/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICECONST_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICECONST_H

#include <cstddef>

/**
 * If the meaning of "org.bosch.cm.navigation.NavigationService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

/**
 * If the meaning of "EstimatedTimeType" isn't clear, then there should be a description here.
 */
enum EstimatedTimeType {

    /**
     * Indicate ETA information about destination
     */
    EstimatedTimeType__DESTINATION,
    /**
     * Indicate ETA information about waypoint
     */
    EstimatedTimeType__WAYPOINT

};

bool EstimatedTimeType_Parse (const char *str, size_t length, EstimatedTimeType &value);

const char* EstimatedTimeType_Name (EstimatedTimeType value);

bool EstimatedTimeType_IsValid (EstimatedTimeType value);

/**
 * Enum describing compatibility between software Navigation application and Navigation data (NDS)
 */
enum NavDataCompatibility {

    /**
     * NavData is compatible
     */
    NavDataCompatibility__NAVDATA_COMPATIBLE = 0u,
    /**
     * NavData is incompatible
     */
    NavDataCompatibility__NAVDATA_INCOMPATIBLE = 1u,
    /**
     * unknown compatibility
     */
    NavDataCompatibility__NAVDATA_COMPATIBILITY_UNKNOWN = 2u

};

bool NavDataCompatibility_Parse (const char *str, size_t length, NavDataCompatibility &value);

const char* NavDataCompatibility_Name (NavDataCompatibility value);

bool NavDataCompatibility_IsValid (NavDataCompatibility value);

/**
 * Enum for navigation status information
 */
enum NavStatus {

    /**
     * The status of the navigation is unknown
     */
    NavStatus__NAVSTATUS_UNKNOWN = 0u,
    /**
     * The navigation is busy and not available
     */
    NavStatus__NAVSTATUS_BUSY,
    /**
     * The navigation data is updating
     */
    NavStatus__NAVSTATUS_NAVDATA_UPDATING,
    /**
     * Map recovery mode
     */
    NavStatus__NAVSTATUS_MAP_RECOVERY_MODE,
    /**
     * The navigation is not in active guidance, calculating a route, not busy and can process messages
     */
    NavStatus__NAVSTATUS_IDLE,
    /**
     * Guidance is active. Messages can still be processed
     */
    NavStatus__NAVSTATUS_GUIDANCE_ACTIVE,
    /**
     * The navigation is calculating a route. Messages can still be processed
     */
    NavStatus__NAVSTATUS_CALCULATING_ROUTE,
    /**
     * Offboard guidance is active
     */
    NavStatus__NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD

};

bool NavStatus_Parse (const char *str, size_t length, NavStatus &value);

const char* NavStatus_Name (NavStatus value);

bool NavStatus_IsValid (NavStatus value);

/**
 * If the meaning of "RoadClass" isn't clear, then there should be a description here.
 */
enum RoadClass {

    /**
     * If the meaning of "ROAD_CLASS_NONE" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_NONE,
    /**
     * If the meaning of "ROAD_CLASS_MOTORWAY" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_MOTORWAY,
    /**
     * If the meaning of "ROAD_CLASS_FREEWAY" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_FREEWAY,
    /**
     * If the meaning of "ROAD_CLASS_HIGHWAY" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_HIGHWAY,
    /**
     * If the meaning of "ROAD_CLASS_ARTERIAL" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_ARTERIAL,
    /**
     * If the meaning of "ROAD_CLASS_COLLECTOR" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_COLLECTOR,
    /**
     * If the meaning of "ROAD_CLASS_LOCAL" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_LOCAL,
    /**
     * If the meaning of "ROAD_CLASS_ADDRESSABLESTREET" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_ADDRESSABLESTREET,
    /**
     * If the meaning of "ROAD_CLASS_TRAIL" isn't clear, then there should be a description here.
     */
    RoadClass__ROAD_CLASS_TRAIL

};

bool RoadClass_Parse (const char *str, size_t length, RoadClass &value);

const char* RoadClass_Name (RoadClass value);

bool RoadClass_IsValid (RoadClass value);

/**
 * If the meaning of "DistanceUnit" isn't clear, then there should be a description here.
 */
enum DistanceUnit {

    /**
     * If the meaning of "METERS" isn't clear, then there should be a description here.
     */
    DistanceUnit__METERS = 0u,
    /**
     * If the meaning of "KILOMETERS" isn't clear, then there should be a description here.
     */
    DistanceUnit__KILOMETERS,
    /**
     * If the meaning of "FEET" isn't clear, then there should be a description here.
     */
    DistanceUnit__FEET,
    /**
     * If the meaning of "YARD" isn't clear, then there should be a description here.
     */
    DistanceUnit__YARD,
    /**
     * If the meaning of "MILES" isn't clear, then there should be a description here.
     */
    DistanceUnit__MILES,
    /**
     * If the meaning of "INVALID" isn't clear, then there should be a description here.
     */
    DistanceUnit__INVALID = 99u

};

bool DistanceUnit_Parse (const char *str, size_t length, DistanceUnit &value);

const char* DistanceUnit_Name (DistanceUnit value);

bool DistanceUnit_IsValid (DistanceUnit value);

/**
 * Enum for turn by turn symbols
 */
enum ManeuverSymbol {

    /**
     * If the meaning of "MANEUVER_SYMBOL_NO_SYMBOL" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_NO_SYMBOL,
    /**
     * If the meaning of "MANEUVER_SYMBOL_NO_INFO" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_NO_INFO,
    /**
     * If the meaning of "MANEUVER_SYMBOL_FOLLOW" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_FOLLOW,
    /**
     * If the meaning of "MANEUVER_SYMBOL_RECALC" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_RECALC,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_REACHED" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_REACHED_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_REACHED_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED,
    /**
     * If the meaning of "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_EXIT_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_EXIT_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_EXIT_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_EXIT_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_STRAIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_STRAIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_HALFRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_HALFRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_SHARPRIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_SHARPRIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_SHARPLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_SHARPLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_TURN_HALFLEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_TURN_HALFLEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_UTURN_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_UTURN_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_UTURN_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_UTURN_RIGHT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_KEEP_LEFT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_KEEP_LEFT,
    /**
     * If the meaning of "MANEUVER_SYMBOL_KEEP_RIGHT" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_KEEP_RIGHT,
    /**
     * Destination straight ahead and further enum values indicate clockwise
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_001,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_009" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_009,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_025" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_025,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_041" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_041,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_057" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_057,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_073" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_073,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_089" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_089,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_105" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_105,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_121" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_121,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_137" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_137,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_153" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_153,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_169" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_169,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_185" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_185,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_201" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_201,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_217" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_217,
    /**
     * If the meaning of "MANEUVER_SYMBOL_DEST_DIRECTION_233" isn't clear, then there should be a description here.
     */
    ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_233,
    /**
     * size of enum type, no actual value
     */
    ManeuverSymbol__SIZE

};

bool ManeuverSymbol_Parse (const char *str, size_t length, ManeuverSymbol &value);

const char* ManeuverSymbol_Name (ManeuverSymbol value);

bool ManeuverSymbol_IsValid (ManeuverSymbol value);

/**
 * Enum for map POI icon categories on map
 */
enum MapPOIIconCategory {

    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_RESTAURANT" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_RESTAURANT = 0u,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_GAS_STATION" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_GAS_STATION,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_HOTEL" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_HOTEL,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_ATM" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_ATM,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_REST_AREA" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_REST_AREA,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_HOSPITAL" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_HOSPITAL,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_PARKING_LOT" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_PARKING_LOT,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_PARKING" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_PARKING,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_FINANCIAL_INSTITUTION" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_FINANCIAL_INSTITUTION,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_POST_OFFICE" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_POST_OFFICE,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_DEPARTMENT_STORE" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_DEPARTMENT_STORE,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_CONVENIENCE_STORE" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_CONVENIENCE_STORE,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_FAST_FOOD" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_FAST_FOOD,
    /**
     * If the meaning of "MAP_POI_ICON_CATEGORY_BANKING_FACILITIES" isn't clear, then there should be a description here.
     */
    MapPOIIconCategory__MAP_POI_ICON_CATEGORY_BANKING_FACILITIES

};

bool MapPOIIconCategory_Parse (const char *str, size_t length, MapPOIIconCategory &value);

const char* MapPOIIconCategory_Name (MapPOIIconCategory value);

bool MapPOIIconCategory_IsValid (MapPOIIconCategory value);

/**
 * Enum for the reasons to which the navigation route is recalculated
 */
enum RouteRecalculationReason {

    /**
     * default invalid reason
     */
    RouteRecalculationReason__UNKNOWN = 0u,
    /**
     * reason if alternative route calculation is not enabled
     */
    RouteRecalculationReason__NO_ROUTE_AVAILABLE,
    /**
     * reason if alternative route is not calculated
     */
    RouteRecalculationReason__NO_CALCULATION,
    /**
     * reason if route is calculated for the first time
     */
    RouteRecalculationReason__FIRST_CALCULATION,
    /**
     * reason if reCalculation is self triggered to optimize the route
     */
    RouteRecalculationReason__OPTIMIZE_ROUTE,
    /**
     * reason if reCalculation is self triggered by traffic messages
     */
    RouteRecalculationReason__REGARDING_TRAFFIC_MESSAGE,
    /**
     * reason if reCalculation due to detour by user or route erased
     */
    RouteRecalculationReason__DISREGARD_ROUTE,
    /**
     * reason if reCalculation is triggered by user considering traffic messages
     */
    RouteRecalculationReason__REGARDING_USER_TRAFFIC_MESSAGE,
    /**
     * reason if reCalculation is triggered if the route options are changed (avoid streets, alternative route)
     */
    RouteRecalculationReason__ROUTE_OPTION_CHANGED,
    /**
     * reason if reCalculation is triggered due to change in route criterion like fast/eco/short route
     */
    RouteRecalculationReason__ROUTE_CRITERION_CHANGED,
    /**
     * reason if both REASON__ROUTE_OPTION_CHANGED, REASON__ROUTE_OPTION_CRITERION_CHANGED are changed
     */
    RouteRecalculationReason__ROUTE_OPTION_CRITERION_CHANGED,
    /**
     * reason if reCalculation is self triggered due to change in entry point
     */
    RouteRecalculationReason__ENTRY_POINT_EVALUATION

};

bool RouteRecalculationReason_Parse (const char *str, size_t length, RouteRecalculationReason &value);

const char* RouteRecalculationReason_Name (RouteRecalculationReason value);

bool RouteRecalculationReason_IsValid (RouteRecalculationReason value);

/**
 * Enum for RouteCriterion
 */
enum RouteCriterion {

    /**
     * If the meaning of "ROUTE_CRITERION_ECONOMIC" isn't clear, then there should be a description here.
     */
    RouteCriterion__ROUTE_CRITERION_ECONOMIC,
    /**
     * If the meaning of "ROUTE_CRITERION_FAST" isn't clear, then there should be a description here.
     */
    RouteCriterion__ROUTE_CRITERION_FAST,
    /**
     * If the meaning of "ROUTE_CRITERION_SHORT" isn't clear, then there should be a description here.
     */
    RouteCriterion__ROUTE_CRITERION_SHORT

};

bool RouteCriterion_Parse (const char *str, size_t length, RouteCriterion &value);

const char* RouteCriterion_Name (RouteCriterion value);

bool RouteCriterion_IsValid (RouteCriterion value);

/**
 * Enum for FreeTextLocationTypes
 */
enum FTSLocationType {

    /**
     * If the meaning of "FREETEXT_SEARCH_TYPE_COMBINED" isn't clear, then there should be a description here.
     */
    FTSLocationType__FREETEXT_SEARCH_TYPE_COMBINED,
    /**
     * If the meaning of "FREETEXT_SEARCH_TYPE_ADDRESS" isn't clear, then there should be a description here.
     */
    FTSLocationType__FREETEXT_SEARCH_TYPE_ADDRESS,
    /**
     * If the meaning of "FREETEXT_SEARCH_TYPE_POI" isn't clear, then there should be a description here.
     */
    FTSLocationType__FREETEXT_SEARCH_TYPE_POI

};

bool FTSLocationType_Parse (const char *str, size_t length, FTSLocationType &value);

const char* FTSLocationType_Name (FTSLocationType value);

bool FTSLocationType_IsValid (FTSLocationType value);

/**
 * Enum for FreeTextSearchScopes
 */
enum FreeTextSearchScope {

    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA,
    /**
     * If the meaning of "FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET" isn't clear, then there should be a description here.
     */
    FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET

};

bool FreeTextSearchScope_Parse (const char *str, size_t length, FreeTextSearchScope &value);

const char* FreeTextSearchScope_Name (FreeTextSearchScope value);

bool FreeTextSearchScope_IsValid (FreeTextSearchScope value);

/**
 * enum to tag typical address entries like e.g. country, state, place, street, Housenumber
 */
enum SDSAddressElementType {

    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_COUNTRY" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_PLACE" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACE,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_ROAD" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROAD,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT,
    /**
     * If the meaning of "SDS_ADDRESS_ELEMENT_TYPE_STATE" isn't clear, then there should be a description here.
     */
    SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_STATE

};

bool SDSAddressElementType_Parse (const char *str, size_t length, SDSAddressElementType &value);

const char* SDSAddressElementType_Name (SDSAddressElementType value);

bool SDSAddressElementType_IsValid (SDSAddressElementType value);

/**
 * If the meaning of "MapRepresentation" isn't clear, then there should be a description here.
 */
enum MapRepresentation {

    /**
     * If the meaning of "MAP_REPRESENTATION_2D_NORTH_UP" isn't clear, then there should be a description here.
     */
    MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP = 0u,
    /**
     * If the meaning of "MAP_REPRESENTATION_3D_CAR_HEADING" isn't clear, then there should be a description here.
     */
    MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING,
    /**
     * If the meaning of "MAP_REPRESENTATION_2D_CAR_HEADING" isn't clear, then there should be a description here.
     */
    MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING,
    /**
     * If the meaning of "MAP_REPRESENTATION_NOT_SET" isn't clear, then there should be a description here.
     */
    MapRepresentation__MAP_REPRESENTATION_NOT_SET

};

bool MapRepresentation_Parse (const char *str, size_t length, MapRepresentation &value);

const char* MapRepresentation_Name (MapRepresentation value);

bool MapRepresentation_IsValid (MapRepresentation value);

/**
 * If the meaning of "MapMultiViewMode" isn't clear, then there should be a description here.
 */
enum MapMultiViewMode {

    /**
     * If the meaning of "MAP_MULTI_VIEW_MODE_UNCHANGED" isn't clear, then there should be a description here.
     */
    MapMultiViewMode__MAP_MULTI_VIEW_MODE_UNCHANGED = 0u,
    /**
     * If the meaning of "MAP_MULTI_VIEW_MODE_OFF" isn't clear, then there should be a description here.
     */
    MapMultiViewMode__MAP_MULTI_VIEW_MODE_OFF,
    /**
     * If the meaning of "MAP_MULTI_VIEW_MODE_ON" isn't clear, then there should be a description here.
     */
    MapMultiViewMode__MAP_MULTI_VIEW_MODE_ON

};

bool MapMultiViewMode_Parse (const char *str, size_t length, MapMultiViewMode &value);

const char* MapMultiViewMode_Name (MapMultiViewMode value);

bool MapMultiViewMode_IsValid (MapMultiViewMode value);

/**
 * If the meaning of "MapViewMode" isn't clear, then there should be a description here.
 */
enum MapViewMode {

    /**
     * Change the map view settings to 2D/3Dmap mode and contextSwitch
     */
    MapViewMode__MAP_VIEW_MODE_FULL_MAP = 0u,
    /**
     * Change the map view settings to 2D/3DSplitmap mode and contextSwitch
     */
    MapViewMode__MAP_VIEW_MODE_SPLIT_MAP

};

bool MapViewMode_Parse (const char *str, size_t length, MapViewMode &value);

const char* MapViewMode_Name (MapViewMode value);

bool MapViewMode_IsValid (MapViewMode value);

/**
 * If the meaning of "MapCameraMode" isn't clear, then there should be a description here.
 */
enum MapCameraMode {

    /**
     * If the meaning of "MAP_MODE_CARSOR" isn't clear, then there should be a description here.
     */
    MapCameraMode__MAP_MODE_CARSOR

};

bool MapCameraMode_Parse (const char *str, size_t length, MapCameraMode &value);

const char* MapCameraMode_Name (MapCameraMode value);

bool MapCameraMode_IsValid (MapCameraMode value);

/**
 * If the meaning of "DeformedImageRoadType" isn't clear, then there should be a description here.
 */
enum DeformedImageRoadType {

    /**
     * If the meaning of "NONE" isn't clear, then there should be a description here.
     */
    DeformedImageRoadType__NONE = 0u,
    /**
     * If the meaning of "FORK" isn't clear, then there should be a description here.
     */
    DeformedImageRoadType__FORK,
    /**
     * If the meaning of "EXIT_LEFT" isn't clear, then there should be a description here.
     */
    DeformedImageRoadType__EXIT_LEFT,
    /**
     * If the meaning of "EXIT_RIGHT" isn't clear, then there should be a description here.
     */
    DeformedImageRoadType__EXIT_RIGHT

};

bool DeformedImageRoadType_Parse (const char *str, size_t length, DeformedImageRoadType &value);

const char* DeformedImageRoadType_Name (DeformedImageRoadType value);

bool DeformedImageRoadType_IsValid (DeformedImageRoadType value);

/**
 * If the meaning of "DeformedImageArrowType" isn't clear, then there should be a description here.
 */
enum DeformedImageArrowType {

    /**
     * If the meaning of "NONE" isn't clear, then there should be a description here.
     */
    DeformedImageArrowType__NONE = 0u,
    /**
     * If the meaning of "STRAIGHT" isn't clear, then there should be a description here.
     */
    DeformedImageArrowType__STRAIGHT,
    /**
     * If the meaning of "LEFT" isn't clear, then there should be a description here.
     */
    DeformedImageArrowType__LEFT,
    /**
     * If the meaning of "RIGHT" isn't clear, then there should be a description here.
     */
    DeformedImageArrowType__RIGHT

};

bool DeformedImageArrowType_Parse (const char *str, size_t length, DeformedImageArrowType &value);

const char* DeformedImageArrowType_Name (DeformedImageArrowType value);

bool DeformedImageArrowType_IsValid (DeformedImageArrowType value);

/**
 * If the meaning of "TimeType" isn't clear, then there should be a description here.
 */
enum TimeType {

    /**
     * If the meaning of "REMAININGTIME" isn't clear, then there should be a description here.
     */
    TimeType__REMAININGTIME = 0u,
    /**
     * If the meaning of "ETA" isn't clear, then there should be a description here.
     */
    TimeType__ETA

};

bool TimeType_Parse (const char *str, size_t length, TimeType &value);

const char* TimeType_Name (TimeType value);

bool TimeType_IsValid (TimeType value);

/**
 * If the meaning of "TimeFormat" isn't clear, then there should be a description here.
 */
enum TimeFormat {

    /**
     * If the meaning of "UNSET" isn't clear, then there should be a description here.
     */
    TimeFormat__UNSET = 0u,
    /**
     * If the meaning of "TWELVEHOURS" isn't clear, then there should be a description here.
     */
    TimeFormat__TWELVEHOURS,
    /**
     * If the meaning of "TWENTYFOURHOURS" isn't clear, then there should be a description here.
     */
    TimeFormat__TWENTYFOURHOURS

};

bool TimeFormat_Parse (const char *str, size_t length, TimeFormat &value);

const char* TimeFormat_Name (TimeFormat value);

bool TimeFormat_IsValid (TimeFormat value);

/**
 * If the meaning of "AdminRoadClass" isn't clear, then there should be a description here.
 */
enum AdminRoadClass {

    /**
     * If the meaning of "UNKNOWN" isn't clear, then there should be a description here.
     */
    AdminRoadClass__UNKNOWN = 0u,
    /**
     * If the meaning of "MOST_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__MOST_IMPORTANT,
    /**
     * If the meaning of "SECOND_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__SECOND_IMPORTANT,
    /**
     * If the meaning of "THIRD_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__THIRD_IMPORTANT,
    /**
     * If the meaning of "FOURTH_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__FOURTH_IMPORTANT,
    /**
     * If the meaning of "FIFTH_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__FIFTH_IMPORTANT,
    /**
     * If the meaning of "SIXTH_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__SIXTH_IMPORTANT,
    /**
     * If the meaning of "LEAST_IMPORTANT" isn't clear, then there should be a description here.
     */
    AdminRoadClass__LEAST_IMPORTANT

};

bool AdminRoadClass_Parse (const char *str, size_t length, AdminRoadClass &value);

const char* AdminRoadClass_Name (AdminRoadClass value);

bool AdminRoadClass_IsValid (AdminRoadClass value);

/**
 * If the meaning of "ManeuverRecommendationType" isn't clear, then there should be a description here.
 */
enum ManeuverRecommendationType {

    /**
     * If the meaning of "PREVIEW" isn't clear, then there should be a description here.
     */
    ManeuverRecommendationType__PREVIEW = 0u,
    /**
     * If the meaning of "PRELIMINARY" isn't clear, then there should be a description here.
     */
    ManeuverRecommendationType__PRELIMINARY,
    /**
     * If the meaning of "REGULAR" isn't clear, then there should be a description here.
     */
    ManeuverRecommendationType__REGULAR,
    /**
     * If the meaning of "REPEATED" isn't clear, then there should be a description here.
     */
    ManeuverRecommendationType__REPEATED

};

bool ManeuverRecommendationType_Parse (const char *str, size_t length, ManeuverRecommendationType &value);

const char* ManeuverRecommendationType_Name (ManeuverRecommendationType value);

bool ManeuverRecommendationType_IsValid (ManeuverRecommendationType value);

/**
 * If the meaning of "SpeedUnit" isn't clear, then there should be a description here.
 */
enum SpeedUnit {

    /**
     * If the meaning of "KM_PER_HOUR" isn't clear, then there should be a description here.
     */
    SpeedUnit__KM_PER_HOUR = 0u,
    /**
     * If the meaning of "MI_PER_HOUR" isn't clear, then there should be a description here.
     */
    SpeedUnit__MI_PER_HOUR

};

bool SpeedUnit_Parse (const char *str, size_t length, SpeedUnit &value);

const char* SpeedUnit_Name (SpeedUnit value);

bool SpeedUnit_IsValid (SpeedUnit value);

/**
 * If the meaning of "LaneStatus" isn't clear, then there should be a description here.
 */
enum LaneStatus {

    /**
     * If the meaning of "UNKNOWN" isn't clear, then there should be a description here.
     */
    LaneStatus__UNKNOWN = 0u,
    /**
     * If the meaning of "FORBIDDEN" isn't clear, then there should be a description here.
     */
    LaneStatus__FORBIDDEN,
    /**
     * If the meaning of "NOT_RECOMMENDED" isn't clear, then there should be a description here.
     */
    LaneStatus__NOT_RECOMMENDED,
    /**
     * If the meaning of "RECOMMENDED" isn't clear, then there should be a description here.
     */
    LaneStatus__RECOMMENDED

};

bool LaneStatus_Parse (const char *str, size_t length, LaneStatus &value);

const char* LaneStatus_Name (LaneStatus value);

bool LaneStatus_IsValid (LaneStatus value);

/**
 * If the meaning of "ManeuverViewType" isn't clear, then there should be a description here.
 */
enum ManeuverViewType {

    /**
     * If the meaning of "NONE" isn't clear, then there should be a description here.
     */
    ManeuverViewType__NONE,
    /**
     * If the meaning of "DEFORMED_IMAGE" isn't clear, then there should be a description here.
     */
    ManeuverViewType__DEFORMED_IMAGE,
    /**
     * If the meaning of "INTERSECTION_MAP" isn't clear, then there should be a description here.
     */
    ManeuverViewType__INTERSECTION_MAP

};

bool ManeuverViewType_Parse (const char *str, size_t length, ManeuverViewType &value);

const char* ManeuverViewType_Name (ManeuverViewType value);

bool ManeuverViewType_IsValid (ManeuverViewType value);

/**
 * If the meaning of "IntersectionMapCarsorState" isn't clear, then there should be a description here.
 */
enum IntersectionMapCarsorState {

    /**
     * If the meaning of "OFF" isn't clear, then there should be a description here.
     */
    IntersectionMapCarsorState__OFF,
    /**
     * If the meaning of "ON" isn't clear, then there should be a description here.
     */
    IntersectionMapCarsorState__ON,
    /**
     * If the meaning of "STANDBY" isn't clear, then there should be a description here.
     */
    IntersectionMapCarsorState__STANDBY

};

bool IntersectionMapCarsorState_Parse (const char *str, size_t length, IntersectionMapCarsorState &value);

const char* IntersectionMapCarsorState_Name (IntersectionMapCarsorState value);

bool IntersectionMapCarsorState_IsValid (IntersectionMapCarsorState value);

/**
 * If the meaning of "ZoomLevel" isn't clear, then there should be a description here.
 */
enum ZoomLevel {

    /**
     * If the meaning of "ZOOM_50M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_50M = 0u,
    /**
     * If the meaning of "ZOOM_100M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_100M,
    /**
     * If the meaning of "ZOOM_200M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_200M,
    /**
     * If the meaning of "ZOOM_500M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_500M,
    /**
     * If the meaning of "ZOOM_1000M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_1000M,
    /**
     * If the meaning of "ZOOM_2000M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_2000M,
    /**
     * If the meaning of "ZOOM_5000M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_5000M,
    /**
     * If the meaning of "ZOOM_10000M" isn't clear, then there should be a description here.
     */
    ZoomLevel__ZOOM_10000M

};

bool ZoomLevel_Parse (const char *str, size_t length, ZoomLevel &value);

const char* ZoomLevel_Name (ZoomLevel value);

bool ZoomLevel_IsValid (ZoomLevel value);

/**
 * If the meaning of "ImageType" isn't clear, then there should be a description here.
 */
enum ImageType {

    /**
     * If the meaning of "PNG" isn't clear, then there should be a description here.
     */
    ImageType__PNG = 1u

};

bool ImageType_Parse (const char *str, size_t length, ImageType &value);

const char* ImageType_Name (ImageType value);

bool ImageType_IsValid (ImageType value);

/**
 * If the meaning of "SDSVoiceTagOptions" isn't clear, then there should be a description here.
 */
enum SDSVoiceTagOptions {

    /**
     * If the meaning of "NONE" isn't clear, then there should be a description here.
     */
    SDSVoiceTagOptions__NONE = 0u,
    /**
     * NAV -> SDS Communication
     *       DestinationMemoryEntryID and DestinationMemoryEntryName will be provided with below option
     */
    SDSVoiceTagOptions__CREATE_NEW_VOICETAG,
    /**
     * DestinationMemoryEntryID, DestinationMemoryEntryName and SDSVoiceTagID will be provided with below option
     */
    SDSVoiceTagOptions__PLAY_VOICETAG,
    /**
     * DestinationMemoryEntryID, DestinationMemoryEntryName and SDSVoiceTagID will be provided with below option
     */
    SDSVoiceTagOptions__DELETE_VOICETAG,
    /**
     * no IDs will be provided
     */
    SDSVoiceTagOptions__DELETE_ALL_VOICETAGS,
    /**
     * SDS -> NAV communication
     *       DestinationMemoryEntryID and SDSVoiceTagID will be provided
     */
    SDSVoiceTagOptions__NEW_VOICETAG_CREATED,
    /**
     * only DestinationMemoryEntryID will be provided
     */
    SDSVoiceTagOptions__NO_VOICETAG_CREATED,
    /**
     * DestinationMemoryEntryID will be provided if one VoiceTag is deleted
     */
    SDSVoiceTagOptions__VOICETAG_DELETED

};

bool SDSVoiceTagOptions_Parse (const char *str, size_t length, SDSVoiceTagOptions &value);

const char* SDSVoiceTagOptions_Name (SDSVoiceTagOptions value);

bool SDSVoiceTagOptions_IsValid (SDSVoiceTagOptions value);

/**
 * If the meaning of "TripReplayStatus" isn't clear, then there should be a description here.
 */
enum TripReplayStatus {

    /**
     * If the meaning of "UNKNOWN" isn't clear, then there should be a description here.
     */
    TripReplayStatus__UNKNOWN = 0u,
    /**
     * If the meaning of "RESERVED" isn't clear, then there should be a description here.
     */
    TripReplayStatus__RESERVED,
    /**
     * If the meaning of "NOT_ACTIVE" isn't clear, then there should be a description here.
     */
    TripReplayStatus__NOT_ACTIVE,
    /**
     * If the meaning of "ACTIVE" isn't clear, then there should be a description here.
     */
    TripReplayStatus__ACTIVE,
    /**
     * If the meaning of "FILE_NOT_FOUND_ERROR" isn't clear, then there should be a description here.
     */
    TripReplayStatus__FILE_NOT_FOUND_ERROR,
    /**
     * If the meaning of "INTERNAL_ERROR" isn't clear, then there should be a description here.
     */
    TripReplayStatus__INTERNAL_ERROR

};

bool TripReplayStatus_Parse (const char *str, size_t length, TripReplayStatus &value);

const char* TripReplayStatus_Name (TripReplayStatus value);

bool TripReplayStatus_IsValid (TripReplayStatus value);

/**
 * If the meaning of "DestinationMemoryCategoryType" isn't clear, then there should be a description here.
 */
enum DestinationMemoryCategoryType {

    /**
     * If the meaning of "ADDRESS_BOOK" isn't clear, then there should be a description here.
     */
    DestinationMemoryCategoryType__ADDRESS_BOOK,
    /**
     * If the meaning of "LAST_DESTINATIONS" isn't clear, then there should be a description here.
     */
    DestinationMemoryCategoryType__LAST_DESTINATIONS

};

bool DestinationMemoryCategoryType_Parse (const char *str, size_t length, DestinationMemoryCategoryType &value);

const char* DestinationMemoryCategoryType_Name (DestinationMemoryCategoryType value);

bool DestinationMemoryCategoryType_IsValid (DestinationMemoryCategoryType value);

/**
 * If the meaning of "DirectionDescription" isn't clear, then there should be a description here.
 */
enum DirectionDescription {

    /**
     * If the meaning of "NORTH" isn't clear, then there should be a description here.
     */
    DirectionDescription__NORTH = 0u,
    /**
     * If the meaning of "NORTH_NORTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__NORTH_NORTH_EAST,
    /**
     * If the meaning of "NORTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__NORTH_EAST,
    /**
     * If the meaning of "EAST_NORTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__EAST_NORTH_EAST,
    /**
     * If the meaning of "EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__EAST,
    /**
     * If the meaning of "EAST_SOUTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__EAST_SOUTH_EAST,
    /**
     * If the meaning of "SOUTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__SOUTH_EAST,
    /**
     * If the meaning of "SOUTH_SOUTH_EAST" isn't clear, then there should be a description here.
     */
    DirectionDescription__SOUTH_SOUTH_EAST,
    /**
     * If the meaning of "SOUTH" isn't clear, then there should be a description here.
     */
    DirectionDescription__SOUTH,
    /**
     * If the meaning of "SOUTH_SOUTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__SOUTH_SOUTH_WEST,
    /**
     * If the meaning of "SOUTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__SOUTH_WEST,
    /**
     * If the meaning of "WEST_SOUTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__WEST_SOUTH_WEST,
    /**
     * If the meaning of "WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__WEST,
    /**
     * If the meaning of "WEST_NORTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__WEST_NORTH_WEST,
    /**
     * If the meaning of "NORTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__NORTH_WEST,
    /**
     * If the meaning of "NORTH_NORTH_WEST" isn't clear, then there should be a description here.
     */
    DirectionDescription__NORTH_NORTH_WEST,
    /**
     * If the meaning of "INVALID" isn't clear, then there should be a description here.
     */
    DirectionDescription__INVALID

};

bool DirectionDescription_Parse (const char *str, size_t length, DirectionDescription &value);

const char* DirectionDescription_Name (DirectionDescription value);

bool DirectionDescription_IsValid (DirectionDescription value);

/**
 * If the meaning of "TrafficReceptionState" isn't clear, then there should be a description here.
 */
enum TrafficReceptionState {

    /**
     * Traffic reception state unknown
     */
    TrafficReceptionState__UNKNOWN = 0u,
    /**
     * Traffic reception state ok
     */
    TrafficReceptionState__OK,
    /**
     * Traffic reception state not subscribed
     */
    TrafficReceptionState__NOT_SUBSCRIBED,
    /**
     * Traffic reception state not available
     */
    TrafficReceptionState__NOT_AVAILABLE,
    /**
     * Traffic reception state no antenna connected
     */
    TrafficReceptionState__NO_ANTENNA,
    /**
     * Traffic reception state no signal
     */
    TrafficReceptionState__NO_SIGNAL,
    /**
     * Traffic reception state signal not available
     */
    TrafficReceptionState__TEMPORARILY_NOT_AVAILABLE,
    /**
     * Traffic reception state inactive state
     */
    TrafficReceptionState__INACTIVE,
    /**
     * Traffic reception state no internet condition
     */
    TrafficReceptionState__NO_INTERNET_CONNECTION,
    /**
     * Traffic reception state authentification failed
     */
    TrafficReceptionState__AUTHENTICATION_INVALID,
    /**
     * Traffic reception state connection lost
     */
    TrafficReceptionState__CONNECTION_LOST

};

bool TrafficReceptionState_Parse (const char *str, size_t length, TrafficReceptionState &value);

const char* TrafficReceptionState_Name (TrafficReceptionState value);

bool TrafficReceptionState_IsValid (TrafficReceptionState value);

/**
 * If the meaning of "SampleVoicePhrase" isn't clear, then there should be a description here.
 */
enum SampleVoicePhrase {

    /**
     * Sample voice phrase based on guidance volume
     */
    SampleVoicePhrase__SAMPLE_PHRASE__GUIDANCE_WILL_BE_AT_THIS_VOLUME = 0u,
    /**
     * Sample voice phrase louder
     */
    SampleVoicePhrase__SAMPLE_PHRASE__LOUDER,
    /**
     * Sample voice phrase quieter
     */
    SampleVoicePhrase__SAMPLE_PHRASE__QUIETER,
    /**
     * Sample voice phrase voice output
     */
    SampleVoicePhrase__SAMPLE_PHRASE__VOICE_OUTPUT

};

bool SampleVoicePhrase_Parse (const char *str, size_t length, SampleVoicePhrase &value);

const char* SampleVoicePhrase_Name (SampleVoicePhrase value);

bool SampleVoicePhrase_IsValid (SampleVoicePhrase value);

/**
 * If the meaning of "ETCStatus" isn't clear, then there should be a description here.
 */
enum ETCStatus {

    /**
     * ETC inactive (e.g. device is working but card has not been inserted)
     */
    ETCStatus__INACTIVE = 0u,
    /**
     * ETC active (e.g. device is working and valid card has been inserted)
     */
    ETCStatus__ACTIVE,
    /**
     * ETC error (either card or hardware failure)
     */
    ETCStatus__ERROR

};

bool ETCStatus_Parse (const char *str, size_t length, ETCStatus &value);

const char* ETCStatus_Name (ETCStatus value);

bool ETCStatus_IsValid (ETCStatus value);

/**
 * If the meaning of "TrafficEnforcementAlertState" isn't clear, then there should be a description here.
 */
enum TrafficEnforcementAlertState {

    /**
     * Vehicle not in range of traffic enforcement cameras
     */
    TrafficEnforcementAlertState__NO_ALERT,
    /**
     * Vehicle approaching a traffic enforcement spot or zone
     */
    TrafficEnforcementAlertState__PRE_ALERT,
    /**
     * Vehicle inside a camera zone
     */
    TrafficEnforcementAlertState__ALERT

};

bool TrafficEnforcementAlertState_Parse (const char *str, size_t length, TrafficEnforcementAlertState &value);

const char* TrafficEnforcementAlertState_Name (TrafficEnforcementAlertState value);

bool TrafficEnforcementAlertState_IsValid (TrafficEnforcementAlertState value);

/**
 * If the meaning of "TrafficEnforcementCameraType" isn't clear, then there should be a description here.
 */
enum TrafficEnforcementCameraType {

    /**
     * If the meaning of "FIXED_SPEED" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__FIXED_SPEED,
    /**
     * If the meaning of "MOBILE_SPEED" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__MOBILE_SPEED,
    /**
     * If the meaning of "REDLIGHT" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__REDLIGHT,
    /**
     * If the meaning of "TOLL_ROAD" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__TOLL_ROAD,
    /**
     * If the meaning of "PECCANCY" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__PECCANCY,
    /**
     * If the meaning of "SPECIAL_LANE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__SPECIAL_LANE,
    /**
     * If the meaning of "FIXED_SPEED_AND_REDLIGHT" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__FIXED_SPEED_AND_REDLIGHT,
    /**
     * If the meaning of "BUSLANE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__BUSLANE,
    /**
     * If the meaning of "FAKE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__FAKE,
    /**
     * If the meaning of "PARKING_VIOLATION" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__PARKING_VIOLATION,
    /**
     * If the meaning of "OTHER" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__OTHER,
    /**
     * If the meaning of "AVERAGE_SPEED_ZONE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__AVERAGE_SPEED_ZONE,
    /**
     * If the meaning of "SPEED_ENFORCEMENT_ZONE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__SPEED_ENFORCEMENT_ZONE,
    /**
     * For French high vigilance areas (HVA)
     */
    TrafficEnforcementCameraType__DANGER_ZONE,
    /**
     * If the meaning of "MOBILE_SPEED_HOTSPOT_ZONE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__MOBILE_SPEED_HOTSPOT_ZONE,
    /**
     * If the meaning of "ACCIDENT_BLACKSPOT_ZONE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__ACCIDENT_BLACKSPOT_ZONE,
    /**
     * If the meaning of "RISK_ZONE" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__RISK_ZONE,
    /**
     * If the meaning of "RESTRICTED_ACCESS" isn't clear, then there should be a description here.
     */
    TrafficEnforcementCameraType__RESTRICTED_ACCESS

};

bool TrafficEnforcementCameraType_Parse (const char *str, size_t length, TrafficEnforcementCameraType &value);

const char* TrafficEnforcementCameraType_Name (TrafficEnforcementCameraType value);

bool TrafficEnforcementCameraType_IsValid (TrafficEnforcementCameraType value);

/**
 * If the meaning of "TrafficEnforcementDistanceType" isn't clear, then there should be a description here.
 */
enum TrafficEnforcementDistanceType {

    /**
     * If the meaning of "TO_ZONE_BEGIN" isn't clear, then there should be a description here.
     */
    TrafficEnforcementDistanceType__TO_ZONE_BEGIN,
    /**
     * If the meaning of "TO_ZONE_END" isn't clear, then there should be a description here.
     */
    TrafficEnforcementDistanceType__TO_ZONE_END

};

bool TrafficEnforcementDistanceType_Parse (const char *str, size_t length, TrafficEnforcementDistanceType &value);

const char* TrafficEnforcementDistanceType_Name (TrafficEnforcementDistanceType value);

bool TrafficEnforcementDistanceType_IsValid (TrafficEnforcementDistanceType value);

/**
 * If the meaning of "TrafficMessageSource" isn't clear, then there should be a description here.
 */
enum TrafficMessageSource {

    /**
     * If the meaning of "UNKOWN" isn't clear, then there should be a description here.
     */
    TrafficMessageSource__UNKOWN = 0u,
    /**
     * If the meaning of "CONNECT_TRAFFIC" isn't clear, then there should be a description here.
     */
    TrafficMessageSource__CONNECT_TRAFFIC,
    /**
     * If the meaning of "TMC_TUNER" isn't clear, then there should be a description here.
     */
    TrafficMessageSource__TMC_TUNER

};

bool TrafficMessageSource_Parse (const char *str, size_t length, TrafficMessageSource &value);

const char* TrafficMessageSource_Name (TrafficMessageSource value);

bool TrafficMessageSource_IsValid (TrafficMessageSource value);

/**
 * If the meaning of "OSPSettingType" isn't clear, then there should be a description here.
 */
enum OSPSettingType {

    /**
     * If the meaning of "TRAFFIC_SIGN" isn't clear, then there should be a description here.
     */
    OSPSettingType__TRAFFIC_SIGN = 0u,
    /**
     * If the meaning of "OVER_SPEED_SOUND_ALERT" isn't clear, then there should be a description here.
     */
    OSPSettingType__OVER_SPEED_SOUND_ALERT,
    /**
     * If the meaning of "RISK_AREA_DISPLAY" isn't clear, then there should be a description here.
     */
    OSPSettingType__RISK_AREA_DISPLAY,
    /**
     * If the meaning of "RISK_AREA_SOUND_ALERT" isn't clear, then there should be a description here.
     */
    OSPSettingType__RISK_AREA_SOUND_ALERT

};

bool OSPSettingType_Parse (const char *str, size_t length, OSPSettingType &value);

const char* OSPSettingType_Name (OSPSettingType value);

bool OSPSettingType_IsValid (OSPSettingType value);

/**
 * If the meaning of "JamAheadActivityStatus" isn't clear, then there should be a description here.
 */
enum JamAheadActivityStatus {

    /**
     * If the meaning of "INACTIVE" isn't clear, then there should be a description here.
     */
    JamAheadActivityStatus__INACTIVE,
    /**
     * If the meaning of "ACTIVE" isn't clear, then there should be a description here.
     */
    JamAheadActivityStatus__ACTIVE,
    /**
     * If the meaning of "NO_DETOUR_POSSIBLE" isn't clear, then there should be a description here.
     */
    JamAheadActivityStatus__NO_DETOUR_POSSIBLE

};

bool JamAheadActivityStatus_Parse (const char *str, size_t length, JamAheadActivityStatus &value);

const char* JamAheadActivityStatus_Name (JamAheadActivityStatus value);

bool JamAheadActivityStatus_IsValid (JamAheadActivityStatus value);

/**
 * If the meaning of "FixedPOICategory" isn't clear, then there should be a description here.
 */
enum FixedPOICategory {

    /**
     * If the meaning of "UNDEFINED" isn't clear, then there should be a description here.
     */
    FixedPOICategory__UNDEFINED = 0u,
    /**
     * If the meaning of "ATM" isn't clear, then there should be a description here.
     */
    FixedPOICategory__ATM,
    /**
     * If the meaning of "EV_CHARGING_STATION" isn't clear, then there should be a description here.
     */
    FixedPOICategory__EV_CHARGING_STATION,
    /**
     * If the meaning of "HOSPITAL" isn't clear, then there should be a description here.
     */
    FixedPOICategory__HOSPITAL,
    /**
     * If the meaning of "HOTEL_MOTEL" isn't clear, then there should be a description here.
     */
    FixedPOICategory__HOTEL_MOTEL,
    /**
     * If the meaning of "MOTORWAY_ENTRY" isn't clear, then there should be a description here.
     */
    FixedPOICategory__MOTORWAY_ENTRY,
    /**
     * If the meaning of "MOTORWAY_EXIT" isn't clear, then there should be a description here.
     */
    FixedPOICategory__MOTORWAY_EXIT,
    /**
     * If the meaning of "PARKING" isn't clear, then there should be a description here.
     */
    FixedPOICategory__PARKING,
    /**
     * If the meaning of "PETROL_STATION" isn't clear, then there should be a description here.
     */
    FixedPOICategory__PETROL_STATION,
    /**
     * If the meaning of "RESTAURANT" isn't clear, then there should be a description here.
     */
    FixedPOICategory__RESTAURANT,
    /**
     * If the meaning of "VEHICLE_REPAIR" isn't clear, then there should be a description here.
     */
    FixedPOICategory__VEHICLE_REPAIR

};

bool FixedPOICategory_Parse (const char *str, size_t length, FixedPOICategory &value);

const char* FixedPOICategory_Name (FixedPOICategory value);

bool FixedPOICategory_IsValid (FixedPOICategory value);

/**
 * If the meaning of "LocationType" isn't clear, then there should be a description here.
 */
enum LocationType {

    /**
     * In case of active guidance driving range around CVP will be along route.
     */
    LocationType__CURRENT_VEHICLE_POSITION,
    /**
     * If the meaning of "WAYPOINT" isn't clear, then there should be a description here.
     */
    LocationType__WAYPOINT,
    /**
     * If the meaning of "DESTINATION" isn't clear, then there should be a description here.
     */
    LocationType__DESTINATION

};

bool LocationType_Parse (const char *str, size_t length, LocationType &value);

const char* LocationType_Name (LocationType value);

bool LocationType_IsValid (LocationType value);

/**
 * Enum provide Consumption Unit type
 */
enum ConsumptionUnit {

    /**
     * If the meaning of "MICROLITER" isn't clear, then there should be a description here.
     */
    ConsumptionUnit__MICROLITER = 0u,
    /**
     * If the meaning of "WATTSECOND" isn't clear, then there should be a description here.
     */
    ConsumptionUnit__WATTSECOND,
    /**
     * If the meaning of "WATTMINUTE" isn't clear, then there should be a description here.
     */
    ConsumptionUnit__WATTMINUTE

};

bool ConsumptionUnit_Parse (const char *str, size_t length, ConsumptionUnit &value);

const char* ConsumptionUnit_Name (ConsumptionUnit value);

bool ConsumptionUnit_IsValid (ConsumptionUnit value);

/**
 * Enum provide screen transition details
 */
enum ScreenTransition {

    /**
     * If the meaning of "ROUTE_INFO_SCREEN" isn't clear, then there should be a description here.
     */
    ScreenTransition__ROUTE_INFO_SCREEN = 1u,
    /**
     * If the meaning of "MAIN_MAP_SCREEN" isn't clear, then there should be a description here.
     */
    ScreenTransition__MAIN_MAP_SCREEN

};

bool ScreenTransition_Parse (const char *str, size_t length, ScreenTransition &value);

const char* ScreenTransition_Name (ScreenTransition value);

bool ScreenTransition_IsValid (ScreenTransition value);

/**
 * Enum for destination reached status information
 */
enum DestinationReachedStatus {

    /**
     * Invalid and by default value set to UNKNOWN.
     */
    DestinationReachedStatus__UNKNOWN = 0u,
    /**
     * The destination reached status of the waypoint
     */
    DestinationReachedStatus__WAYPOINT = 1u,
    /**
     * The destination reached status of the final destination
     */
    DestinationReachedStatus__FINAL_DESTINATION = 2u,
    /**
     * The destination skipped status of the waypoint
     */
    DestinationReachedStatus__WAYPOINT_SKIPPED = 3u

};

bool DestinationReachedStatus_Parse (const char *str, size_t length, DestinationReachedStatus &value);

const char* DestinationReachedStatus_Name (DestinationReachedStatus value);

bool DestinationReachedStatus_IsValid (DestinationReachedStatus value);

/**
 * Enum for waypoint operation status information
 */
enum WaypointOperationStatus {

    /**
     * The waypoint inserted status
     */
    WaypointOperationStatus__INSERTED = 0u,
    /**
     * The waypoint deleted status
     */
    WaypointOperationStatus__DELETED,
    /**
     * The waypoint moved status
     */
    WaypointOperationStatus__MOVED,
    /**
     * The waypoint replaced status
     */
    WaypointOperationStatus__REPLACED

};

bool WaypointOperationStatus_Parse (const char *str, size_t length, WaypointOperationStatus &value);

const char* WaypointOperationStatus_Name (WaypointOperationStatus value);

bool WaypointOperationStatus_IsValid (WaypointOperationStatus value);

/**
 * Enum containing map light mode status such as day and night
 */
enum LightModeStatus {

    /**
     * If the meaning of "DAY" isn't clear, then there should be a description here.
     */
    LightModeStatus__DAY = 0u,
    /**
     * If the meaning of "NIGHT" isn't clear, then there should be a description here.
     */
    LightModeStatus__NIGHT = 1u

};

bool LightModeStatus_Parse (const char *str, size_t length, LightModeStatus &value);

const char* LightModeStatus_Name (LightModeStatus value);

bool LightModeStatus_IsValid (LightModeStatus value);

/**
 * Enum containing type of destination memory address
 */
enum DestinationMemoryAddressType {

    /**
     * If the meaning of "DESTINATION_MEMORY_COUNTRY" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY,
    /**
     * If the meaning of "DESTINATION_MEMORY_STATE" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_STATE,
    /**
     * If the meaning of "DESTINATION_MEMORY_CITY" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_CITY,
    /**
     * If the meaning of "DESTINATION_MEMORY_STREET" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_STREET,
    /**
     * If the meaning of "DESTINATION_MEMORY_HOUSENO" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_HOUSENO,
    /**
     * If the meaning of "DESTINATION_MEMORY_JUNCTION" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_JUNCTION,
    /**
     * If the meaning of "DESTINATION_MEMORY_POI" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_POI,
    /**
     * If the meaning of "DESTINATION_MEMORY_POI_CATEGORY" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_POI_CATEGORY,
    /**
     * If the meaning of "DESTINATION_MEMORY_POI_BRAND" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_POI_BRAND,
    /**
     * If the meaning of "DESTINATION_MEMORY_COUNTRY_CODE" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY_CODE,
    /**
     * If the meaning of "DESTINATION_MEMORY_ADDRESS_DETAIL" isn't clear, then there should be a description here.
     */
    DestinationMemoryAddressType__DESTINATION_MEMORY_ADDRESS_DETAIL

};

bool DestinationMemoryAddressType_Parse (const char *str, size_t length, DestinationMemoryAddressType &value);

const char* DestinationMemoryAddressType_Name (DestinationMemoryAddressType value);

bool DestinationMemoryAddressType_IsValid (DestinationMemoryAddressType value);

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICECONST_H
