/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICESTUB_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationSDSService.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationSDSService {

class NavigationSDSServiceStubDelegate;

class NavigationSDSServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NavigationSDSServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NavigationSDSServiceStub (const std::string& portName);

    /**
     * Create an instance of the NavigationSDSServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NavigationSDSServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NavigationSDSServiceStub();

    // property 'mapUpdateRequested'

    /**
     * The method onMapUpdateRequestedGet() is called by ASF when a client
     * invokes the read method for the property 'mapUpdateRequested'. The
     * onMapUpdateRequestedGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'mapUpdateRequested'</b>:
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     */
    virtual void onMapUpdateRequestedGet(const ::boost::shared_ptr< MapUpdateRequestedGet >& payload);

    /**
     * Sends back the update to a previous onMapUpdateRequestedGet().
     *
     * <b>Documentation of 'mapUpdateRequested'</b>:
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     *
     * @param act Identifies a previous invocation of
     * onMapUpdateRequestedGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapUpdateRequestedGetUpdate(bool mapUpdateRequested, act_t act = 0);

    /**
     * Set the value of the property 'mapUpdateRequested' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'mapUpdateRequested'</b>:
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     */
    void setMapUpdateRequested(bool mapUpdateRequested);

    /**
     * Returns the current value of the property 'mapUpdateRequested'.
     *
     * <b>Documentation of 'mapUpdateRequested'</b>:
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     */
    bool getMapUpdateRequested() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapUpdateRequestedUpdate().
     *
     * <b>Documentation of 'mapUpdateRequested'</b>:
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     */
    void sendMapUpdateRequestedUpdate();

    // property 'handOverSessionStatus'

    /**
     * The method onHandOverSessionStatusGet() is called by ASF when a client
     * invokes the read method for the property 'handOverSessionStatus'. The
     * onHandOverSessionStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     */
    virtual void onHandOverSessionStatusGet(const ::boost::shared_ptr< HandOverSessionStatusGet >& payload);

    /**
     * Sends back the update to a previous onHandOverSessionStatusGet().
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     *
     * @param act Identifies a previous invocation of
     * onHandOverSessionStatusGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHandOverSessionStatusGetUpdate(const HandOverSessionStatus& handOverSessionStatus, act_t act = 0);

    /**
     * Set the value of the property 'handOverSessionStatus' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     */
    void setHandOverSessionStatus(const HandOverSessionStatus& handOverSessionStatus);

    /**
     * Returns the current value of the property 'handOverSessionStatus'.
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     */
    const HandOverSessionStatus& getHandOverSessionStatus() const;

    /**
     * Returns the current value of the property 'handOverSessionStatus' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendHandOverSessionStatusUpdate() method.
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     */
    HandOverSessionStatus& getHandOverSessionStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHandOverSessionStatusUpdate().
     *
     * <b>Documentation of 'handOverSessionStatus'</b>:
     *
     * Attribute provides current HMI screen and lockout mode status
     */
    void sendHandOverSessionStatusUpdate();

    // property 'positionStatusInfo'

    /**
     * The method onPositionStatusInfoGet() is called by ASF when a client
     * invokes the read method for the property 'positionStatusInfo'. The
     * onPositionStatusInfoGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     */
    virtual void onPositionStatusInfoGet(const ::boost::shared_ptr< PositionStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous onPositionStatusInfoGet().
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     *
     * @param act Identifies a previous invocation of
     * onPositionStatusInfoGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPositionStatusInfoGetUpdate(const PositionStatusInfo& positionStatusInfo, act_t act = 0);

    /**
     * Set the value of the property 'positionStatusInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     */
    void setPositionStatusInfo(const PositionStatusInfo& positionStatusInfo);

    /**
     * Returns the current value of the property 'positionStatusInfo'.
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     */
    const PositionStatusInfo& getPositionStatusInfo() const;

    /**
     * Returns the current value of the property 'positionStatusInfo' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendPositionStatusInfoUpdate() method.
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     */
    PositionStatusInfo& getPositionStatusInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPositionStatusInfoUpdate().
     *
     * <b>Documentation of 'positionStatusInfo'</b>:
     *
     * Attribute provides current vehicle position status information
     */
    void sendPositionStatusInfoUpdate();

    // property 'positionInfo'

    /**
     * The method onPositionInfoGet() is called by ASF when a client invokes
     * the read method for the property 'positionInfo'. The
     * onPositionInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     */
    virtual void onPositionInfoGet(const ::boost::shared_ptr< PositionInfoGet >& payload);

    /**
     * Sends back the update to a previous onPositionInfoGet().
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     *
     * @param act Identifies a previous invocation of onPositionInfoGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPositionInfoGetUpdate(const PositionInfo& positionInfo, act_t act = 0);

    /**
     * Set the value of the property 'positionInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     */
    void setPositionInfo(const PositionInfo& positionInfo);

    /**
     * Returns the current value of the property 'positionInfo'.
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     */
    const PositionInfo& getPositionInfo() const;

    /**
     * Returns the current value of the property 'positionInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPositionInfoUpdate() method.
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     */
    PositionInfo& getPositionInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPositionInfoUpdate().
     *
     * <b>Documentation of 'positionInfo'</b>:
     *
     * Attribute provides current vehicle position information
     */
    void sendPositionInfoUpdate();

    // property 'sdsAddressWithOptions'

    /**
     * The method onSdsAddressWithOptionsGet() is called by ASF when a client
     * invokes the read method for the property 'sdsAddressWithOptions'. The
     * onSdsAddressWithOptionsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    virtual void onSdsAddressWithOptionsGet(const ::boost::shared_ptr< SdsAddressWithOptionsGet >& payload);

    /**
     * Sends back the update to a previous onSdsAddressWithOptionsGet().
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     *
     * @param act Identifies a previous invocation of
     * onSdsAddressWithOptionsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsAddressWithOptionsGetUpdate(const SDSAddressWithOptions& sdsAddressWithOptions, act_t act = 0);

    /**
     * Set the value of the property 'sdsAddressWithOptions' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    void setSdsAddressWithOptions(const SDSAddressWithOptions& sdsAddressWithOptions);

    /**
     * Returns the current value of the property 'sdsAddressWithOptions'.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    const SDSAddressWithOptions& getSdsAddressWithOptions() const;

    /**
     * Returns the current value of the property 'sdsAddressWithOptions' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSdsAddressWithOptionsUpdate() method.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    SDSAddressWithOptions& getSdsAddressWithOptionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsAddressWithOptionsUpdate().
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    void sendSdsAddressWithOptionsUpdate();

    // property 'sdsVoiceTagWithOptions'

    /**
     * The method onSdsVoiceTagWithOptionsGet() is called by ASF when a client
     * invokes the read method for the property 'sdsVoiceTagWithOptions'. The
     * onSdsVoiceTagWithOptionsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    virtual void onSdsVoiceTagWithOptionsGet(const ::boost::shared_ptr< SdsVoiceTagWithOptionsGet >& payload);

    /**
     * Sends back the update to a previous onSdsVoiceTagWithOptionsGet().
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @param act Identifies a previous invocation of
     * onSdsVoiceTagWithOptionsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsVoiceTagWithOptionsGetUpdate(const SDSVoiceTagId& sdsVoiceTagWithOptions, act_t act = 0);

    /**
     * Set the value of the property 'sdsVoiceTagWithOptions' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    void setSdsVoiceTagWithOptions(const SDSVoiceTagId& sdsVoiceTagWithOptions);

    /**
     * Returns the current value of the property 'sdsVoiceTagWithOptions'.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    const SDSVoiceTagId& getSdsVoiceTagWithOptions() const;

    /**
     * Returns the current value of the property 'sdsVoiceTagWithOptions' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSdsVoiceTagWithOptionsUpdate() method.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    SDSVoiceTagId& getSdsVoiceTagWithOptionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsVoiceTagWithOptionsUpdate().
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    void sendSdsVoiceTagWithOptionsUpdate();

    // property 'navDatasetInfo'

    /**
     * The method onNavDatasetInfoGet() is called by ASF when a client invokes
     * the read method for the property 'navDatasetInfo'. The
     * onNavDatasetInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     */
    virtual void onNavDatasetInfoGet(const ::boost::shared_ptr< NavDatasetInfoGet >& payload);

    /**
     * Sends back the update to a previous onNavDatasetInfoGet().
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     *
     * @param act Identifies a previous invocation of onNavDatasetInfoGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNavDatasetInfoGetUpdate(const NavDataSetInfo& navDatasetInfo, act_t act = 0);

    /**
     * Set the value of the property 'navDatasetInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     */
    void setNavDatasetInfo(const NavDataSetInfo& navDatasetInfo);

    /**
     * Returns the current value of the property 'navDatasetInfo'.
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     */
    const NavDataSetInfo& getNavDatasetInfo() const;

    /**
     * Returns the current value of the property 'navDatasetInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNavDatasetInfoUpdate() method.
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     */
    NavDataSetInfo& getNavDatasetInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNavDatasetInfoUpdate().
     *
     * <b>Documentation of 'navDatasetInfo'</b>:
     *
     * Attribute provides current navDatasetInfo
     */
    void sendNavDatasetInfoUpdate();

    // property 'dynamicMapPoiCategoryWithLanguage'

    /**
     * The method onDynamicMapPoiCategoryWithLanguageGet() is called by ASF
     * when a client invokes the read method for the property
     * 'dynamicMapPoiCategoryWithLanguage'. The
     * onDynamicMapPoiCategoryWithLanguageGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    virtual void onDynamicMapPoiCategoryWithLanguageGet(const ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageGet >& payload);

    /**
     * Sends back the update to a previous
     * onDynamicMapPoiCategoryWithLanguageGet().
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     *
     * @param act Identifies a previous invocation of
     * onDynamicMapPoiCategoryWithLanguageGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendDynamicMapPoiCategoryWithLanguageGetUpdate(const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage, act_t act = 0);

    /**
     * The method onDynamicMapPoiCategoryWithLanguageSet() is called by ASF
     * when a client invokes the write method for the property
     * 'dynamicMapPoiCategoryWithLanguage'. The
     * onDynamicMapPoiCategoryWithLanguageSet() method set property value to
     * the given parameter dynamicMapPoiCategoryWithLanguage by default. If
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    virtual void onDynamicMapPoiCategoryWithLanguageSet(const ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageSet >& payload);

    /**
     * Sends back the update to a previous
     * onDynamicMapPoiCategoryWithLanguageSet().
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     *
     * @param act Identifies a previous invocation of
     * onDynamicMapPoiCategoryWithLanguageSet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendDynamicMapPoiCategoryWithLanguageSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'dynamicMapPoiCategoryWithLanguage' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    void setDynamicMapPoiCategoryWithLanguage(const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage);

    /**
     * Returns the current value of the property 'dynamicMapPoiCategoryWithLanguage'.
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    const DynamicMapPoiCategoriesWithLanguage& getDynamicMapPoiCategoryWithLanguage() const;

    /**
     * Returns the current value of the property
     * 'dynamicMapPoiCategoryWithLanguage' as a mutable reference. If you
     * change the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendDynamicMapPoiCategoryWithLanguageUpdate() method.
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    DynamicMapPoiCategoriesWithLanguage& getDynamicMapPoiCategoryWithLanguageMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDynamicMapPoiCategoryWithLanguageUpdate().
     *
     * <b>Documentation of 'dynamicMapPoiCategoryWithLanguage'</b>:
     *
     * Attribute provides current DynamicMapPoiCategories
     */
    void sendDynamicMapPoiCategoryWithLanguageUpdate();

    // method 'getGlobalDataForSds'

    /**
     * The method onGetGlobalDataForSds() is called by ASF when a client
     * invokes the method 'getGlobalDataForSds'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetGlobalDataForSds() or sendGetGlobalDataForSdsError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'getGlobalDataForSds'</b>:
     *
     * Method to get the SDS specific nds data
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetGlobalDataForSdsRequest (const ::boost::shared_ptr< GetGlobalDataForSdsRequest >& request) = 0;

    /**
     * The method sendGetGlobalDataForSdsResponse() sends a response of a
     * previous method invocation of 'getGlobalDataForSds' back to the client.
     *
     * <b>Documentation of 'getGlobalDataForSds'</b>:
     *
     * Method to get the SDS specific nds data
     *
     * @param deviceName If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param datasetId If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param sdsProductsList If the meaning of "sdsProductsList" isn't clear, then there should be a description here.
     *
     * @param updateRegionSpecifierRelationsList If the meaning of "updateRegionSpecifierRelationsList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetGlobalDataForSds(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetGlobalDataForSdsResponse (const ::std::string& deviceName, uint32 datasetId, const ::std::string& persistentDatasetId, const ::std::vector< SdsProducts >& sdsProductsList, const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList, act_t act = 0);

    /**
     * The method sendGetGlobalDataForSdsError() sends an error response of a
     * previous method invocation of 'getGlobalDataForSds' back to the client.
     *
     * <b>Documentation of 'getGlobalDataForSds'</b>:
     *
     * Method to get the SDS specific nds data
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetGlobalDataForSds().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetGlobalDataForSdsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getIdListOfCountryAndSubCountry'

    /**
     * The method onGetIdListOfCountryAndSubCountry() is called by ASF when a
     * client invokes the method 'getIdListOfCountryAndSubCountry'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendGetIdListOfCountryAndSubCountry() or
     * sendGetIdListOfCountryAndSubCountryError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'getIdListOfCountryAndSubCountry'</b>:
     *
     * Method to get the list of object ids for all countries and subcountries
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetIdListOfCountryAndSubCountryRequest (const ::boost::shared_ptr< GetIdListOfCountryAndSubCountryRequest >& request) = 0;

    /**
     * The method sendGetIdListOfCountryAndSubCountryResponse() sends a
     * response of a previous method invocation of
     * 'getIdListOfCountryAndSubCountry' back to the client.
     *
     * <b>Documentation of 'getIdListOfCountryAndSubCountry'</b>:
     *
     * Method to get the list of object ids for all countries and subcountries
     *
     * @param countryIdList If the meaning of "countryIdList" isn't clear, then there should be a description here.
     *
     * @param subCountryIdList If the meaning of "subCountryIdList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetIdListOfCountryAndSubCountry(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetIdListOfCountryAndSubCountryResponse (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList, const ::std::vector< SubCountryIds >& subCountryIdList, act_t act = 0);

    /**
     * The method sendGetIdListOfCountryAndSubCountryError() sends an error
     * response of a previous method invocation of
     * 'getIdListOfCountryAndSubCountry' back to the client.
     *
     * <b>Documentation of 'getIdListOfCountryAndSubCountry'</b>:
     *
     * Method to get the list of object ids for all countries and subcountries
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetIdListOfCountryAndSubCountry(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetIdListOfCountryAndSubCountryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getNamesForNDSIds'

    /**
     * The method onGetNamesForNDSIds() is called by ASF when a client invokes
     * the method 'getNamesForNDSIds'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetNamesForNDSIds() or sendGetNamesForNDSIdsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getNamesForNDSIds'</b>:
     *
     * Method to get the named strings for given list of object ids
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetNamesForNDSIdsRequest (const ::boost::shared_ptr< GetNamesForNDSIdsRequest >& request) = 0;

    /**
     * The method sendGetNamesForNDSIdsResponse() sends a response of a
     * previous method invocation of 'getNamesForNDSIds' back to the client.
     *
     * <b>Documentation of 'getNamesForNDSIds'</b>:
     *
     * Method to get the named strings for given list of object ids
     *
     * @param namedObjectIdStringsList If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetNamesForNDSIds(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetNamesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList, act_t act = 0);

    /**
     * The method sendGetNamesForNDSIdsError() sends an error response of a
     * previous method invocation of 'getNamesForNDSIds' back to the client.
     *
     * <b>Documentation of 'getNamesForNDSIds'</b>:
     *
     * Method to get the named strings for given list of object ids
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetNamesForNDSIds().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetNamesForNDSIdsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getPhonemesForNDSIds'

    /**
     * The method onGetPhonemesForNDSIds() is called by ASF when a client
     * invokes the method 'getPhonemesForNDSIds'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetPhonemesForNDSIds() or sendGetPhonemesForNDSIdsError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'getPhonemesForNDSIds'</b>:
     *
     * Method to get the phonemes for given list of object ids
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPhonemesForNDSIdsRequest (const ::boost::shared_ptr< GetPhonemesForNDSIdsRequest >& request) = 0;

    /**
     * The method sendGetPhonemesForNDSIdsResponse() sends a response of a
     * previous method invocation of 'getPhonemesForNDSIds' back to the
     * client.
     *
     * <b>Documentation of 'getPhonemesForNDSIds'</b>:
     *
     * Method to get the phonemes for given list of object ids
     *
     * @param namedObjectIdStringsList If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetPhonemesForNDSIds(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetPhonemesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList, act_t act = 0);

    /**
     * The method sendGetPhonemesForNDSIdsError() sends an error response of a
     * previous method invocation of 'getPhonemesForNDSIds' back to the
     * client.
     *
     * <b>Documentation of 'getPhonemesForNDSIds'</b>:
     *
     * Method to get the phonemes for given list of object ids
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetPhonemesForNDSIds(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetPhonemesForNDSIdsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getCityHasStreets'

    /**
     * The method onGetCityHasStreets() is called by ASF when a client invokes
     * the method 'getCityHasStreets'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetCityHasStreets() or sendGetCityHasStreetsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getCityHasStreets'</b>:
     *
     * Method to get the availability of streets for the given list of city NDS ids
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetCityHasStreetsRequest (const ::boost::shared_ptr< GetCityHasStreetsRequest >& request) = 0;

    /**
     * The method sendGetCityHasStreetsResponse() sends a response of a
     * previous method invocation of 'getCityHasStreets' back to the client.
     *
     * <b>Documentation of 'getCityHasStreets'</b>:
     *
     * Method to get the availability of streets for the given list of city NDS ids
     *
     * @param cityNamedObjectIdHasStreetsList If the meaning of "cityNamedObjectIdHasStreetsList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetCityHasStreets(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetCityHasStreetsResponse (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList, act_t act = 0);

    /**
     * The method sendGetCityHasStreetsError() sends an error response of a
     * previous method invocation of 'getCityHasStreets' back to the client.
     *
     * <b>Documentation of 'getCityHasStreets'</b>:
     *
     * Method to get the availability of streets for the given list of city NDS ids
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetCityHasStreets().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetCityHasStreetsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ndsDatasetReleased'

    /**
     * The method onNdsDatasetReleased() is called by ASF when a client
     * invokes the method 'ndsDatasetReleased'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendNdsDatasetReleased() or sendNdsDatasetReleasedError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ndsDatasetReleased'</b>:
     *
     * Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onNdsDatasetReleasedRequest (const ::boost::shared_ptr< NdsDatasetReleasedRequest >& request) = 0;

    /**
     * The method sendNdsDatasetReleasedResponse() sends a response of a
     * previous method invocation of 'ndsDatasetReleased' back to the client.
     *
     * <b>Documentation of 'ndsDatasetReleased'</b>:
     *
     * Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI
     *
     * @param act The parameter act identifies a previous invocation of
     * onNdsDatasetReleased(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNdsDatasetReleasedResponse (act_t act = 0);

    /**
     * The method sendNdsDatasetReleasedError() sends an error response of a
     * previous method invocation of 'ndsDatasetReleased' back to the client.
     *
     * <b>Documentation of 'ndsDatasetReleased'</b>:
     *
     * Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onNdsDatasetReleased().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNdsDatasetReleasedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getHapticHandOverData'

    /**
     * The method onGetHapticHandOverData() is called by ASF when a client
     * invokes the method 'getHapticHandOverData'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetHapticHandOverData() or sendGetHapticHandOverDataError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'getHapticHandOverData'</b>:
     *
     * Request will get handover screen and data along with location type and address options.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetHapticHandOverDataRequest (const ::boost::shared_ptr< GetHapticHandOverDataRequest >& request) = 0;

    /**
     * The method sendGetHapticHandOverDataResponse() sends a response of a
     * previous method invocation of 'getHapticHandOverData' back to the
     * client.
     *
     * <b>Documentation of 'getHapticHandOverData'</b>:
     *
     * Request will get handover screen and data along with location type and address options.
     *
     * @param sdsHandOverScreenId If the meaning of "sdsHandOverScreenId" isn't clear, then there should be a description here.
     *
     * @param dataList If the meaning of "dataList" isn't clear, then there should be a description here.
     *
     * @param selectedDataListItems If the meaning of "selectedDataListItems" isn't clear, then there should be a description here.
     *
     * @param locationType If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @param sdsHandOverOptionsList If the meaning of "sdsHandOverOptionsList" isn't clear, then there should be a description here.
     *
     * @param searchResults If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetHapticHandOverData(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetHapticHandOverDataResponse (SDSHandOverScreenId sdsHandOverScreenId, const ::std::vector< HapticData >& dataList, const ::std::vector< SelectedDataItem >& selectedDataListItems, LocationType locationType, const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList, const ::std::vector< AddressListElement >& searchResults, act_t act = 0);

    /**
     * The method sendGetHapticHandOverDataError() sends an error response of
     * a previous method invocation of 'getHapticHandOverData' back to the
     * client.
     *
     * <b>Documentation of 'getHapticHandOverData'</b>:
     *
     * Request will get handover screen and data along with location type and address options.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetHapticHandOverData(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetHapticHandOverDataError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'selectHapticHandOverList'

    /**
     * The method onSelectHapticHandOverList() is called by ASF when a client
     * invokes the method 'selectHapticHandOverList'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSelectHapticHandOverList() or
     * sendSelectHapticHandOverListError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'selectHapticHandOverList'</b>:
     *
     * Request will send the selected index from the HMI list.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSelectHapticHandOverListRequest (const ::boost::shared_ptr< SelectHapticHandOverListRequest >& request) = 0;

    /**
     * The method sendSelectHapticHandOverListResponse() sends a response of a
     * previous method invocation of 'selectHapticHandOverList' back to the
     * client.
     *
     * <b>Documentation of 'selectHapticHandOverList'</b>:
     *
     * Request will send the selected index from the HMI list.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSelectHapticHandOverList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectHapticHandOverListResponse (act_t act = 0);

    /**
     * The method sendSelectHapticHandOverListError() sends an error response
     * of a previous method invocation of 'selectHapticHandOverList' back to
     * the client.
     *
     * <b>Documentation of 'selectHapticHandOverList'</b>:
     *
     * Request will send the selected index from the HMI list.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSelectHapticHandOverList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectHapticHandOverListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getDynamicPoiIconCategoriesInMap'

    /**
     * The method onGetDynamicPoiIconCategoriesInMap() is called by ASF when a
     * client invokes the method 'getDynamicPoiIconCategoriesInMap'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendGetDynamicPoiIconCategoriesInMap() or
     * sendGetDynamicPoiIconCategoriesInMapError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'getDynamicPoiIconCategoriesInMap'</b>:
     *
     * Returns the currently available POI icon categories in map
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetDynamicPoiIconCategoriesInMapRequest (const ::boost::shared_ptr< GetDynamicPoiIconCategoriesInMapRequest >& request) = 0;

    /**
     * The method sendGetDynamicPoiIconCategoriesInMapResponse() sends a
     * response of a previous method invocation of
     * 'getDynamicPoiIconCategoriesInMap' back to the client.
     *
     * <b>Documentation of 'getDynamicPoiIconCategoriesInMap'</b>:
     *
     * Returns the currently available POI icon categories in map
     *
     * @param dynamicMapPoiCategory If the meaning of "dynamicMapPoiCategory" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetDynamicPoiIconCategoriesInMap(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetDynamicPoiIconCategoriesInMapResponse (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory, act_t act = 0);

    /**
     * The method sendGetDynamicPoiIconCategoriesInMapError() sends an error
     * response of a previous method invocation of
     * 'getDynamicPoiIconCategoriesInMap' back to the client.
     *
     * <b>Documentation of 'getDynamicPoiIconCategoriesInMap'</b>:
     *
     * Returns the currently available POI icon categories in map
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetDynamicPoiIconCategoriesInMap(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetDynamicPoiIconCategoriesInMapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getMaxWaypointCount'

    /**
     * The method onGetMaxWaypointCount() is called by ASF when a client
     * invokes the method 'getMaxWaypointCount'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetMaxWaypointCount() or sendGetMaxWaypointCountError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'getMaxWaypointCount'</b>:
     *
     * Returns max number of waypoint base on project variant
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetMaxWaypointCountRequest (const ::boost::shared_ptr< GetMaxWaypointCountRequest >& request) = 0;

    /**
     * The method sendGetMaxWaypointCountResponse() sends a response of a
     * previous method invocation of 'getMaxWaypointCount' back to the client.
     *
     * <b>Documentation of 'getMaxWaypointCount'</b>:
     *
     * Returns max number of waypoint base on project variant
     *
     * @param maxWayPointCount If the meaning of "maxWayPointCount" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetMaxWaypointCount(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetMaxWaypointCountResponse (uint32 maxWayPointCount, act_t act = 0);

    /**
     * The method sendGetMaxWaypointCountError() sends an error response of a
     * previous method invocation of 'getMaxWaypointCount' back to the client.
     *
     * <b>Documentation of 'getMaxWaypointCount'</b>:
     *
     * Returns max number of waypoint base on project variant
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetMaxWaypointCount().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetMaxWaypointCountError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setDynamicPoiIconCategoriesInMap'

    /**
     * The method onSetDynamicPoiIconCategoriesInMap() is called by ASF when a
     * client invokes the method 'setDynamicPoiIconCategoriesInMap'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendSetDynamicPoiIconCategoriesInMap() or
     * sendSetDynamicPoiIconCategoriesInMapError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'setDynamicPoiIconCategoriesInMap'</b>:
     *
     * Request to show POI icons on map.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetDynamicPoiIconCategoriesInMapRequest (const ::boost::shared_ptr< SetDynamicPoiIconCategoriesInMapRequest >& request) = 0;

    /**
     * The method sendSetDynamicPoiIconCategoriesInMapResponse() sends a
     * response of a previous method invocation of
     * 'setDynamicPoiIconCategoriesInMap' back to the client.
     *
     * <b>Documentation of 'setDynamicPoiIconCategoriesInMap'</b>:
     *
     * Request to show POI icons on map.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetDynamicPoiIconCategoriesInMap(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendSetDynamicPoiIconCategoriesInMapResponse (act_t act = 0);

    /**
     * The method sendSetDynamicPoiIconCategoriesInMapError() sends an error
     * response of a previous method invocation of
     * 'setDynamicPoiIconCategoriesInMap' back to the client.
     *
     * <b>Documentation of 'setDynamicPoiIconCategoriesInMap'</b>:
     *
     * Request to show POI icons on map.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetDynamicPoiIconCategoriesInMap(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendSetDynamicPoiIconCategoriesInMapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsCheckAddress'

    /**
     * The method onSdsCheckAddress() is called by ASF when a client invokes
     * the method 'sdsCheckAddress'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSdsCheckAddress() or sendSdsCheckAddressError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsCheckAddressRequest (const ::boost::shared_ptr< SdsCheckAddressRequest >& request) = 0;

    /**
     * The method sendSdsCheckAddressResponse() sends a response of a previous
     * method invocation of 'sdsCheckAddress' back to the client.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsCheckAddress(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSdsCheckAddressResponse (act_t act = 0);

    /**
     * The method sendSdsCheckAddressError() sends an error response of a
     * previous method invocation of 'sdsCheckAddress' back to the client.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSdsCheckAddress(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSdsCheckAddressError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsGetRefinementList'

    /**
     * The method onSdsGetRefinementList() is called by ASF when a client
     * invokes the method 'sdsGetRefinementList'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSdsGetRefinementList() or sendSdsGetRefinementListError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsGetRefinementListRequest (const ::boost::shared_ptr< SdsGetRefinementListRequest >& request) = 0;

    /**
     * The method sendSdsGetRefinementListResponse() sends a response of a
     * previous method invocation of 'sdsGetRefinementList' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param refinements If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsGetRefinementList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements, act_t act = 0);

    /**
     * The method sendSdsGetRefinementListError() sends an error response of a
     * previous method invocation of 'sdsGetRefinementList' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsGetRefinementList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetRefinementListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsUpdateVoiceTag'

    /**
     * The method onSdsUpdateVoiceTag() is called by ASF when a client invokes
     * the method 'sdsUpdateVoiceTag'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSdsUpdateVoiceTag() or sendSdsUpdateVoiceTagError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsUpdateVoiceTagRequest (const ::boost::shared_ptr< SdsUpdateVoiceTagRequest >& request) = 0;

    /**
     * The method sendSdsUpdateVoiceTagResponse() sends a response of a
     * previous method invocation of 'sdsUpdateVoiceTag' back to the client.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsUpdateVoiceTag(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsUpdateVoiceTagResponse (act_t act = 0);

    /**
     * The method sendSdsUpdateVoiceTagError() sends an error response of a
     * previous method invocation of 'sdsUpdateVoiceTag' back to the client.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSdsUpdateVoiceTag().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSdsUpdateVoiceTagError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsGetHouseNumberPattern'

    /**
     * The method onSdsGetHouseNumberPattern() is called by ASF when a client
     * invokes the method 'sdsGetHouseNumberPattern'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSdsGetHouseNumberPattern() or
     * sendSdsGetHouseNumberPatternError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsGetHouseNumberPatternRequest (const ::boost::shared_ptr< SdsGetHouseNumberPatternRequest >& request) = 0;

    /**
     * The method sendSdsGetHouseNumberPatternResponse() sends a response of a
     * previous method invocation of 'sdsGetHouseNumberPattern' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param minHouseNumber If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param patterns If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsGetHouseNumberPattern(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber, const ::std::string& maxHouseNumber, const ::std::vector< ::std::string >& patterns, act_t act = 0);

    /**
     * The method sendSdsGetHouseNumberPatternError() sends an error response
     * of a previous method invocation of 'sdsGetHouseNumberPattern' back to
     * the client.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsGetHouseNumberPattern(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetHouseNumberPatternError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'selectSdsRefinement'

    /**
     * The method onSelectSdsRefinement() is called by ASF when a client
     * invokes the method 'selectSdsRefinement'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSelectSdsRefinement() or sendSelectSdsRefinementError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSelectSdsRefinementRequest (const ::boost::shared_ptr< SelectSdsRefinementRequest >& request) = 0;

    /**
     * The method sendSelectSdsRefinementResponse() sends a response of a
     * previous method invocation of 'selectSdsRefinement' back to the client.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param act The parameter act identifies a previous invocation of
     * onSelectSdsRefinement(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectSdsRefinementResponse (act_t act = 0);

    /**
     * The method sendSelectSdsRefinementError() sends an error response of a
     * previous method invocation of 'selectSdsRefinement' back to the client.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSelectSdsRefinement().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSelectSdsRefinementError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithSdsInput'

    /**
     * The method onSetLocationWithSdsInput() is called by ASF when a client
     * invokes the method 'setLocationWithSdsInput'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetLocationWithSdsInput() or
     * sendSetLocationWithSdsInputError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithSdsInputRequest (const ::boost::shared_ptr< SetLocationWithSdsInputRequest >& request) = 0;

    /**
     * The method sendSetLocationWithSdsInputResponse() sends a response of a
     * previous method invocation of 'setLocationWithSdsInput' back to the
     * client.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithSdsInput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithSdsInputResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithSdsInputError() sends an error response
     * of a previous method invocation of 'setLocationWithSdsInput' back to
     * the client.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithSdsInput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithSdsInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestAddressFormatForAvailableCountries'

    /**
     * The method onRequestAddressFormatForAvailableCountries() is called by
     * ASF when a client invokes the method
     * 'requestAddressFormatForAvailableCountries'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRequestAddressFormatForAvailableCountries() or
     * sendRequestAddressFormatForAvailableCountriesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'requestAddressFormatForAvailableCountries'</b>:
     *
     * Request for Address format for all the available countries in Navigation Data
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestAddressFormatForAvailableCountriesRequest (const ::boost::shared_ptr< RequestAddressFormatForAvailableCountriesRequest >& request) = 0;

    /**
     * The method sendRequestAddressFormatForAvailableCountriesResponse()
     * sends a response of a previous method invocation of
     * 'requestAddressFormatForAvailableCountries' back to the client.
     *
     * <b>Documentation of 'requestAddressFormatForAvailableCountries'</b>:
     *
     * Request for Address format for all the available countries in Navigation Data
     *
     * @param addressFormatInfos If the meaning of "addressFormatInfos" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestAddressFormatForAvailableCountries(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendRequestAddressFormatForAvailableCountriesResponse (const ::std::vector< AddressFormatInfo >& addressFormatInfos, act_t act = 0);

    /**
     * The method sendRequestAddressFormatForAvailableCountriesError() sends
     * an error response of a previous method invocation of
     * 'requestAddressFormatForAvailableCountries' back to the client.
     *
     * <b>Documentation of 'requestAddressFormatForAvailableCountries'</b>:
     *
     * Request for Address format for all the available countries in Navigation Data
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestAddressFormatForAvailableCountries(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendRequestAddressFormatForAvailableCountriesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsShowReachableAreaMap'

    /**
     * The method onSdsShowReachableAreaMap() is called by ASF when a client
     * invokes the method 'sdsShowReachableAreaMap'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSdsShowReachableAreaMap() or
     * sendSdsShowReachableAreaMapError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'sdsShowReachableAreaMap'</b>:
     *
     * Request navigation to show driving range on map and contextSwitch
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsShowReachableAreaMapRequest (const ::boost::shared_ptr< SdsShowReachableAreaMapRequest >& request) = 0;

    /**
     * The method sendSdsShowReachableAreaMapResponse() sends a response of a
     * previous method invocation of 'sdsShowReachableAreaMap' back to the
     * client.
     *
     * <b>Documentation of 'sdsShowReachableAreaMap'</b>:
     *
     * Request navigation to show driving range on map and contextSwitch
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsShowReachableAreaMap(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsShowReachableAreaMapResponse (act_t act = 0);

    /**
     * The method sendSdsShowReachableAreaMapError() sends an error response
     * of a previous method invocation of 'sdsShowReachableAreaMap' back to
     * the client.
     *
     * <b>Documentation of 'sdsShowReachableAreaMap'</b>:
     *
     * Request navigation to show driving range on map and contextSwitch
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsShowReachableAreaMap(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsShowReachableAreaMapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsDatasetUserRegistration'

    /**
     * The method onSdsDatasetUserRegistration() is called by ASF when a
     * client invokes the method 'sdsDatasetUserRegistration'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendSdsDatasetUserRegistration() or
     * sendSdsDatasetUserRegistrationError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'sdsDatasetUserRegistration'</b>:
     *
     * Request navigation to register for dataset user
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsDatasetUserRegistrationRequest (const ::boost::shared_ptr< SdsDatasetUserRegistrationRequest >& request) = 0;

    /**
     * The method sendSdsDatasetUserRegistrationResponse() sends a response of
     * a previous method invocation of 'sdsDatasetUserRegistration' back to
     * the client.
     *
     * <b>Documentation of 'sdsDatasetUserRegistration'</b>:
     *
     * Request navigation to register for dataset user
     *
     * @param registrationStatus If the meaning of "registrationStatus" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsDatasetUserRegistration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsDatasetUserRegistrationResponse (RegistrationAndDeRegistrationStatus registrationStatus, act_t act = 0);

    /**
     * The method sendSdsDatasetUserRegistrationError() sends an error
     * response of a previous method invocation of
     * 'sdsDatasetUserRegistration' back to the client.
     *
     * <b>Documentation of 'sdsDatasetUserRegistration'</b>:
     *
     * Request navigation to register for dataset user
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsDatasetUserRegistration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsDatasetUserRegistrationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsDatasetUserDeregistration'

    /**
     * The method onSdsDatasetUserDeregistration() is called by ASF when a
     * client invokes the method 'sdsDatasetUserDeregistration'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendSdsDatasetUserDeregistration() or
     * sendSdsDatasetUserDeregistrationError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'sdsDatasetUserDeregistration'</b>:
     *
     * Request navigation to deregister for dataset user
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsDatasetUserDeregistrationRequest (const ::boost::shared_ptr< SdsDatasetUserDeregistrationRequest >& request) = 0;

    /**
     * The method sendSdsDatasetUserDeregistrationResponse() sends a response
     * of a previous method invocation of 'sdsDatasetUserDeregistration' back
     * to the client.
     *
     * <b>Documentation of 'sdsDatasetUserDeregistration'</b>:
     *
     * Request navigation to deregister for dataset user
     *
     * @param deregistrationStatus If the meaning of "deregistrationStatus" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsDatasetUserDeregistration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsDatasetUserDeregistrationResponse (RegistrationAndDeRegistrationStatus deregistrationStatus, act_t act = 0);

    /**
     * The method sendSdsDatasetUserDeregistrationError() sends an error
     * response of a previous method invocation of
     * 'sdsDatasetUserDeregistration' back to the client.
     *
     * <b>Documentation of 'sdsDatasetUserDeregistration'</b>:
     *
     * Request navigation to deregister for dataset user
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsDatasetUserDeregistration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsDatasetUserDeregistrationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'datasetAccessModeChangedIndication'

    /**
     * The method onDatasetAccessModeChangedIndication() is called by ASF when
     * a client invokes the method 'datasetAccessModeChangedIndication'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendDatasetAccessModeChangedIndication() or
     * sendDatasetAccessModeChangedIndicationError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'datasetAccessModeChangedIndication'</b>:
     *
     * Request to change dataset access mode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDatasetAccessModeChangedIndicationRequest (const ::boost::shared_ptr< DatasetAccessModeChangedIndicationRequest >& request) = 0;

    /**
     * The method sendDatasetAccessModeChangedIndicationResponse() sends a
     * response of a previous method invocation of
     * 'datasetAccessModeChangedIndication' back to the client.
     *
     * <b>Documentation of 'datasetAccessModeChangedIndication'</b>:
     *
     * Request to change dataset access mode
     *
     * @param act The parameter act identifies a previous invocation of
     * onDatasetAccessModeChangedIndication(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendDatasetAccessModeChangedIndicationResponse (act_t act = 0);

    /**
     * The method sendDatasetAccessModeChangedIndicationError() sends an error
     * response of a previous method invocation of
     * 'datasetAccessModeChangedIndication' back to the client.
     *
     * <b>Documentation of 'datasetAccessModeChangedIndication'</b>:
     *
     * Request to change dataset access mode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDatasetAccessModeChangedIndication(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendDatasetAccessModeChangedIndicationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    MapUpdateRequestedUpdate _mapUpdateRequestedProperty;

    HandOverSessionStatusUpdate _handOverSessionStatusProperty;

    PositionStatusInfoUpdate _positionStatusInfoProperty;

    PositionInfoUpdate _positionInfoProperty;

    SdsAddressWithOptionsUpdate _sdsAddressWithOptionsProperty;

    SdsVoiceTagWithOptionsUpdate _sdsVoiceTagWithOptionsProperty;

    NavDatasetInfoUpdate _navDatasetInfoProperty;

    DynamicMapPoiCategoryWithLanguageUpdate _dynamicMapPoiCategoryWithLanguageProperty;

    friend class NavigationSDSServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NavigationSDSService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICESTUB_H
