/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationSDSService.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceJson.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationSDSService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationSDSService", NavigationSDSServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 15, "sdsCheckAddress", 11 },
    { 17, "getCityHasStreets", 4 },
    { 17, "getNamesForNDSIds", 2 },
    { 17, "sdsUpdateVoiceTag", 13 },
    { 18, "ndsDatasetReleased", 5 },
    { 19, "getGlobalDataForSds", 0 },
    { 19, "getMaxWaypointCount", 9 },
    { 19, "selectSdsRefinement", 15 },
    { 20, "getPhonemesForNDSIds", 3 },
    { 20, "sdsGetRefinementList", 12 },
    { 21, "getHapticHandOverData", 6 },
    { 23, "sdsShowReachableAreaMap", 18 },
    { 23, "setLocationWithSdsInput", 16 },
    { 24, "sdsGetHouseNumberPattern", 14 },
    { 24, "selectHapticHandOverList", 7 },
    { 26, "sdsDatasetUserRegistration", 19 },
    { 28, "sdsDatasetUserDeregistration", 20 },
    { 31, "getIdListOfCountryAndSubCountry", 1 },
    { 32, "getDynamicPoiIconCategoriesInMap", 8 },
    { 32, "setDynamicPoiIconCategoriesInMap", 10 },
    { 34, "datasetAccessModeChangedIndication", 21 },
    { 41, "requestAddressFormatForAvailableCountries", 17 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 12, "positionInfo", 3 },
    { 14, "navDatasetInfo", 6 },
    { 18, "mapUpdateRequested", 0 },
    { 18, "positionStatusInfo", 2 },
    { 21, "handOverSessionStatus", 1 },
    { 21, "sdsAddressWithOptions", 4 },
    { 22, "sdsVoiceTagWithOptions", 5 },
    { 33, "dynamicMapPoiCategoryWithLanguage", 7 },
};

class NavigationSDSServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NavigationSDSServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NavigationSDSServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NavigationSDSServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.navigation.NavigationSDSService"),
          _logger(logger) {}

    virtual ~NavigationSDSServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NavigationSDSServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 22, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'getGlobalDataForSds'

            LOG_DEBUG_STUB("process method '%s'", "getGlobalDataForSds");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetGlobalDataForSdsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetGlobalDataForSds", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetGlobalDataForSdsRequest > payload = ::boost::static_pointer_cast<GetGlobalDataForSdsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetGlobalDataForSdsRequest(payload);
            return;
        }
        case 1: {

            // method 'getIdListOfCountryAndSubCountry'

            LOG_DEBUG_STUB("process method '%s'", "getIdListOfCountryAndSubCountry");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetIdListOfCountryAndSubCountryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetIdListOfCountryAndSubCountry", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetIdListOfCountryAndSubCountryRequest > payload = ::boost::static_pointer_cast<GetIdListOfCountryAndSubCountryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetIdListOfCountryAndSubCountryRequest(payload);
            return;
        }
        case 2: {

            // method 'getNamesForNDSIds'

            LOG_DEBUG_STUB("process method '%s'", "getNamesForNDSIds");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNamesForNDSIdsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetNamesForNDSIds", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetNamesForNDSIdsRequest > payload = ::boost::static_pointer_cast<GetNamesForNDSIdsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetNamesForNDSIdsRequest(payload);
            return;
        }
        case 3: {

            // method 'getPhonemesForNDSIds'

            LOG_DEBUG_STUB("process method '%s'", "getPhonemesForNDSIds");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPhonemesForNDSIdsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPhonemesForNDSIds", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPhonemesForNDSIdsRequest > payload = ::boost::static_pointer_cast<GetPhonemesForNDSIdsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetPhonemesForNDSIdsRequest(payload);
            return;
        }
        case 4: {

            // method 'getCityHasStreets'

            LOG_DEBUG_STUB("process method '%s'", "getCityHasStreets");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCityHasStreetsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetCityHasStreets", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetCityHasStreetsRequest > payload = ::boost::static_pointer_cast<GetCityHasStreetsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetCityHasStreetsRequest(payload);
            return;
        }
        case 5: {

            // method 'ndsDatasetReleased'

            LOG_DEBUG_STUB("process method '%s'", "ndsDatasetReleased");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NdsDatasetReleasedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "NdsDatasetReleased", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< NdsDatasetReleasedRequest > payload = ::boost::static_pointer_cast<NdsDatasetReleasedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onNdsDatasetReleasedRequest(payload);
            return;
        }
        case 6: {

            // method 'getHapticHandOverData'

            LOG_DEBUG_STUB("process method '%s'", "getHapticHandOverData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetHapticHandOverDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetHapticHandOverData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetHapticHandOverDataRequest > payload = ::boost::static_pointer_cast<GetHapticHandOverDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetHapticHandOverDataRequest(payload);
            return;
        }
        case 7: {

            // method 'selectHapticHandOverList'

            LOG_DEBUG_STUB("process method '%s'", "selectHapticHandOverList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectHapticHandOverListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SelectHapticHandOverList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectHapticHandOverListRequest > payload = ::boost::static_pointer_cast<SelectHapticHandOverListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSelectHapticHandOverListRequest(payload);
            return;
        }
        case 8: {

            // method 'getDynamicPoiIconCategoriesInMap'

            LOG_DEBUG_STUB("process method '%s'", "getDynamicPoiIconCategoriesInMap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDynamicPoiIconCategoriesInMapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetDynamicPoiIconCategoriesInMap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetDynamicPoiIconCategoriesInMapRequest > payload = ::boost::static_pointer_cast<GetDynamicPoiIconCategoriesInMapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetDynamicPoiIconCategoriesInMapRequest(payload);
            return;
        }
        case 9: {

            // method 'getMaxWaypointCount'

            LOG_DEBUG_STUB("process method '%s'", "getMaxWaypointCount");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetMaxWaypointCountRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetMaxWaypointCount", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetMaxWaypointCountRequest > payload = ::boost::static_pointer_cast<GetMaxWaypointCountRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onGetMaxWaypointCountRequest(payload);
            return;
        }
        case 10: {

            // method 'setDynamicPoiIconCategoriesInMap'

            LOG_DEBUG_STUB("process method '%s'", "setDynamicPoiIconCategoriesInMap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDynamicPoiIconCategoriesInMapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetDynamicPoiIconCategoriesInMap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetDynamicPoiIconCategoriesInMapRequest > payload = ::boost::static_pointer_cast<SetDynamicPoiIconCategoriesInMapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSetDynamicPoiIconCategoriesInMapRequest(payload);
            return;
        }
        case 11: {

            // method 'sdsCheckAddress'

            LOG_DEBUG_STUB("process method '%s'", "sdsCheckAddress");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsCheckAddress", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsCheckAddressRequest > payload = ::boost::static_pointer_cast<SdsCheckAddressRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsCheckAddressRequest(payload);
            return;
        }
        case 12: {

            // method 'sdsGetRefinementList'

            LOG_DEBUG_STUB("process method '%s'", "sdsGetRefinementList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsGetRefinementList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsGetRefinementListRequest > payload = ::boost::static_pointer_cast<SdsGetRefinementListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsGetRefinementListRequest(payload);
            return;
        }
        case 13: {

            // method 'sdsUpdateVoiceTag'

            LOG_DEBUG_STUB("process method '%s'", "sdsUpdateVoiceTag");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsUpdateVoiceTag", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsUpdateVoiceTagRequest > payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsUpdateVoiceTagRequest(payload);
            return;
        }
        case 14: {

            // method 'sdsGetHouseNumberPattern'

            LOG_DEBUG_STUB("process method '%s'", "sdsGetHouseNumberPattern");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsGetHouseNumberPattern", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsGetHouseNumberPatternRequest > payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsGetHouseNumberPatternRequest(payload);
            return;
        }
        case 15: {

            // method 'selectSdsRefinement'

            LOG_DEBUG_STUB("process method '%s'", "selectSdsRefinement");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SelectSdsRefinement", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectSdsRefinementRequest > payload = ::boost::static_pointer_cast<SelectSdsRefinementRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSelectSdsRefinementRequest(payload);
            return;
        }
        case 16: {

            // method 'setLocationWithSdsInput'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithSdsInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithSdsInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithSdsInputRequest > payload = ::boost::static_pointer_cast<SetLocationWithSdsInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSetLocationWithSdsInputRequest(payload);
            return;
        }
        case 17: {

            // method 'requestAddressFormatForAvailableCountries'

            LOG_DEBUG_STUB("process method '%s'", "requestAddressFormatForAvailableCountries");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestAddressFormatForAvailableCountriesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestAddressFormatForAvailableCountries", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestAddressFormatForAvailableCountriesRequest > payload = ::boost::static_pointer_cast<RequestAddressFormatForAvailableCountriesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onRequestAddressFormatForAvailableCountriesRequest(payload);
            return;
        }
        case 18: {

            // method 'sdsShowReachableAreaMap'

            LOG_DEBUG_STUB("process method '%s'", "sdsShowReachableAreaMap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsShowReachableAreaMapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsShowReachableAreaMap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsShowReachableAreaMapRequest > payload = ::boost::static_pointer_cast<SdsShowReachableAreaMapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsShowReachableAreaMapRequest(payload);
            return;
        }
        case 19: {

            // method 'sdsDatasetUserRegistration'

            LOG_DEBUG_STUB("process method '%s'", "sdsDatasetUserRegistration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserRegistrationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsDatasetUserRegistration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsDatasetUserRegistrationRequest > payload = ::boost::static_pointer_cast<SdsDatasetUserRegistrationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsDatasetUserRegistrationRequest(payload);
            return;
        }
        case 20: {

            // method 'sdsDatasetUserDeregistration'

            LOG_DEBUG_STUB("process method '%s'", "sdsDatasetUserDeregistration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserDeregistrationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsDatasetUserDeregistration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsDatasetUserDeregistrationRequest > payload = ::boost::static_pointer_cast<SdsDatasetUserDeregistrationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsDatasetUserDeregistrationRequest(payload);
            return;
        }
        case 21: {

            // method 'datasetAccessModeChangedIndication'

            LOG_DEBUG_STUB("process method '%s'", "datasetAccessModeChangedIndication");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DatasetAccessModeChangedIndicationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DatasetAccessModeChangedIndication", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DatasetAccessModeChangedIndicationRequest > payload = ::boost::static_pointer_cast<DatasetAccessModeChangedIndicationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationSDSServiceStub*>(getStub())->onDatasetAccessModeChangedIndicationRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NavigationSDSServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.navigation.NavigationSDSService\">\n"
            "    <property access=\"read\" name=\"mapUpdateRequested\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"handOverSessionStatus\" type=\"(bb)\"/>\n"
            "    <property access=\"read\" name=\"positionStatusInfo\" type=\"((dd)ssuddbu)\"/>\n"
            "    <property access=\"read\" name=\"positionInfo\" type=\"(ssssss(suq)(suq)(suq)(suq)(suq)(suq)(suq)bu)\"/>\n"
            "    <property access=\"read\" name=\"sdsAddressWithOptions\" type=\"(a(us(b))(bbbbbb)au)\"/>\n"
            "    <property access=\"read\" name=\"sdsVoiceTagWithOptions\" type=\"(tsuu)\"/>\n"
            "    <property access=\"read\" name=\"navDatasetInfo\" type=\"(us(uuu))\"/>\n"
            "    <property access=\"readwrite\" name=\"dynamicMapPoiCategoryWithLanguage\" type=\"(a(sub((nin)ub))(sss))\"/>\n"
            "    <method name=\"getGlobalDataForSds\">\n"
            "      <doc>\n"
            "        <line>getGlobalDataForSds = Method to get the SDS specific nds data</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"deviceName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>deviceName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"datasetId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>datasetId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"persistentDatasetId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>persistentDatasetId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sdsProductsList\" type=\"a(yua(qa(qusu(bb(ua(qs))(ua(qs)))yu)a(qss))a(qsss(sss)qq))\">\n"
            "        <doc>\n"
            "          <line>sdsProductsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"updateRegionSpecifierRelationsList\" type=\"a(qyuq)\">\n"
            "        <doc>\n"
            "          <line>updateRegionSpecifierRelationsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getIdListOfCountryAndSubCountry\">\n"
            "      <doc>\n"
            "        <line>getIdListOfCountryAndSubCountry = Method to get the list of object ids for all countries and subcountries</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"countryIdList\" type=\"a((nin)utu)\">\n"
            "        <doc>\n"
            "          <line>countryIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"subCountryIdList\" type=\"a(((nin)ub)a((nin)utu))\">\n"
            "        <doc>\n"
            "          <line>subCountryIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getNamesForNDSIds\">\n"
            "      <doc>\n"
            "        <line>getNamesForNDSIds = Method to get the named strings for given list of object ids</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"globalNamedObjectIdList\" type=\"a((nin)ub)\">\n"
            "        <doc>\n"
            "          <line>globalNamedObjectIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"languageEntryList\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>languageEntryList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ndsFeatureType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsFeatureType (of type NDSFeatureType) = Description missing</line>\n"
            "          <line>enum[NAMEDOBJECT (null), POI_NAME (null), POI_CATEGORY (null), POI_ATTRIBUTE (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"stopOnFirstMatch\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>stopOnFirstMatch = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"namedObjectIdStringsList\" type=\"a(((nin)ub)(sss)asu)\">\n"
            "        <doc>\n"
            "          <line>namedObjectIdStringsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getPhonemesForNDSIds\">\n"
            "      <doc>\n"
            "        <line>getPhonemesForNDSIds = Method to get the phonemes for given list of object ids</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"globalNamedObjectIdList\" type=\"a((nin)ub)\">\n"
            "        <doc>\n"
            "          <line>globalNamedObjectIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"languageEntryList\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>languageEntryList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ndsFeatureType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsFeatureType (of type NDSFeatureType) = Description missing</line>\n"
            "          <line>enum[NAMEDOBJECT (null), POI_NAME (null), POI_CATEGORY (null), POI_ATTRIBUTE (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"stopOnFirstMatch\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>stopOnFirstMatch = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"namedObjectIdStringsList\" type=\"a(((nin)ub)(sss)asu)\">\n"
            "        <doc>\n"
            "          <line>namedObjectIdStringsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getCityHasStreets\">\n"
            "      <doc>\n"
            "        <line>getCityHasStreets = Method to get the availability of streets for the given list of city NDS ids</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"globalNamedObjectIdList\" type=\"a((nin)ub)\">\n"
            "        <doc>\n"
            "          <line>globalNamedObjectIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"cityNamedObjectIdHasStreetsList\" type=\"a(((nin)ub)b)\">\n"
            "        <doc>\n"
            "          <line>cityNamedObjectIdHasStreetsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ndsDatasetReleased\">\n"
            "      <doc>\n"
            "        <line>ndsDatasetReleased = Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"getHapticHandOverData\">\n"
            "      <doc>\n"
            "        <line>getHapticHandOverData = Request will get handover screen and data along with location type and address options.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"sdsHandOverScreenId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sdsHandOverScreenId (of type SDSHandOverScreenId) = Description missing</line>\n"
            "          <line>enum[NAVI_FREE_TEXT_SEARCH_ADDRESS (null), NAVI_FREE_TEXT_SEARCH_POI (null), NAVI_ENTER_COUNTRY (null), NAVI_ENTER_STATE (null), NAVI_HNOFIRST_HNO (null), NAVI_HNOFIRST_STREET (null), NAVI_HNOFIRST_STREET_CITY (null), NAVI_CITYFIRST_CITY (null), NAVI_CITYFIRST_CITY_STREET (null), NAVI_CITYFIRST_HNO (null), NAVI_CITYFIRST_HNO_STREET (null), NAVI_CITYFIRST_STREET_HNO (null), NAVI_AMBIG_ADDRESS (null), NAVI_SETDEST_ADDRESS (null), NAVI_CITYCENTER_CITY (null), NAVI_CITYCENTER_STATE (null), NAVI_AMBIG_CITYCENTER (null), NAVI_SETDEST_CITYCENTER (null), NAVI_INTERSECTION_STREET1 (null), NAVI_INTERSECTION_STREET2 (null), NAVI_INTERSECTION_CITY (null), NAVI_INTERSECTION_STATE (null), NAVI_INTERSECTION_COUNTRY (null), NAVI_INTERSECTION_LIST (null), NAVI_SETDEST_INTERSECTION (null), NAVI_POI (null), NAVI_POI_CATEGORY (null), NAVI_POI_LIST (null), NAVI_POI_INCITY (null), NAVI_POI_ENTER_STATE (null), NAVI_POI_ENTER_COUNTRY (null), NAVI_SETDEST_POI (null), NAVI_STREET_ADDRESS_WITHOUT_STATE_INTERSECTION (null), NAVI_SETDEST_GENERIC (null), NAVI_FORM_WITHOUT_STATE (null), NAVI_INACTIVE_SCREEN (255)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"dataList\" type=\"a(s((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>dataList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"selectedDataListItems\" type=\"a(us((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>selectedDataListItems = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"locationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationType (of type LocationType) = Description missing</line>\n"
            "          <line>enum[DEFAULT (null), NEAR_CURRENT_LOCATION (null), ALONG_ROUTE (null), NEARBY_DESTINATION (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sdsHandOverOptionsList\" type=\"a(bbbbb)\">\n"
            "        <doc>\n"
            "          <line>sdsHandOverOptionsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"searchResults\" type=\"a(stssu)\">\n"
            "        <doc>\n"
            "          <line>searchResults = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"selectHapticHandOverList\">\n"
            "      <doc>\n"
            "        <line>selectHapticHandOverList = Request will send the selected index from the HMI list.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"index\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>index = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getDynamicPoiIconCategoriesInMap\">\n"
            "      <doc>\n"
            "        <line>getDynamicPoiIconCategoriesInMap = Returns the currently available POI icon categories in map</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"dynamicMapPoiCategory\" type=\"a(sub((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>dynamicMapPoiCategory = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getMaxWaypointCount\">\n"
            "      <doc>\n"
            "        <line>getMaxWaypointCount = Returns max number of waypoint base on project variant</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"maxWayPointCount\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>maxWayPointCount = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setDynamicPoiIconCategoriesInMap\">\n"
            "      <doc>\n"
            "        <line>setDynamicPoiIconCategoriesInMap = Request to show POI icons on map.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"dynamicMapPoiCategory\" type=\"a(sub((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>dynamicMapPoiCategory = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsCheckAddress\">\n"
            "      <doc>\n"
            "        <line>sdsCheckAddress = Request will validate the given address,</line>\n"
            "        <line>as result it update the attribute sdsAddressWithOptions</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"requestedAddress\" type=\"a(us(b))\">\n"
            "        <doc>\n"
            "          <line>requestedAddress = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsGetRefinementList\">\n"
            "      <doc>\n"
            "        <line>sdsGetRefinementList = Request will get refinement list for the validated address</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"refinements\" type=\"a(susu)\">\n"
            "        <doc>\n"
            "          <line>refinements = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsUpdateVoiceTag\">\n"
            "      <doc>\n"
            "        <line>sdsUpdateVoiceTag = Method used to store/delete the VoiceTagId in the destination memory database</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"voiceTagID\" type=\"(tsuu)\">\n"
            "        <doc>\n"
            "          <line>voiceTagID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsGetHouseNumberPattern\">\n"
            "      <doc>\n"
            "        <line>sdsGetHouseNumberPattern = Request will get house number patterns and the minimum and maximum values of the current SDSAddress</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"minHouseNumber\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>minHouseNumber = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"maxHouseNumber\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>maxHouseNumber = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"patterns\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>patterns = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"selectSdsRefinement\">\n"
            "      <doc>\n"
            "        <line>selectSdsRefinement = Request will select the refinement with the id from refinement list and add internal to SDSAddress.</line>\n"
            "        <line>As result it update the attribute sdsAddressWithOptions</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithSdsInput\">\n"
            "      <doc>\n"
            "        <line>setLocationWithSdsInput = Request will set the SDS Address as destination or waypoint</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestAddressFormatForAvailableCountries\">\n"
            "      <doc>\n"
            "        <line>requestAddressFormatForAvailableCountries = Request for Address format for all the available countries in Navigation Data</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"addressFormatInfos\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>addressFormatInfos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsShowReachableAreaMap\">\n"
            "      <doc>\n"
            "        <line>sdsShowReachableAreaMap = Request navigation to show driving range on map and contextSwitch</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"locationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationType (of type LocationType) = Description missing</line>\n"
            "          <line>enum[DEFAULT (null), NEAR_CURRENT_LOCATION (null), ALONG_ROUTE (null), NEARBY_DESTINATION (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsDatasetUserRegistration\">\n"
            "      <doc>\n"
            "        <line>sdsDatasetUserRegistration = Request navigation to register for dataset user</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ndsDataSetUser\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsDataSetUser (of type NdsDatasetUser) = Description missing</line>\n"
            "          <line>enum[NDS_DATASET_USER__SDS (0), NDS_DATASET_USER__UNKNOWN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"datasetId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>datasetId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"registrationStatus\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>registrationStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsDatasetUserDeregistration\">\n"
            "      <doc>\n"
            "        <line>sdsDatasetUserDeregistration = Request navigation to deregister for dataset user</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ndsDataSetUser\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsDataSetUser (of type NdsDatasetUser) = Description missing</line>\n"
            "          <line>enum[NDS_DATASET_USER__SDS (0), NDS_DATASET_USER__UNKNOWN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"datasetId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>datasetId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"deregistrationStatus\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>deregistrationStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"datasetAccessModeChangedIndication\">\n"
            "      <doc>\n"
            "        <line>datasetAccessModeChangedIndication = Request to change dataset access mode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ndsDataSetUser\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsDataSetUser (of type NdsDatasetUser) = Description missing</line>\n"
            "          <line>enum[NDS_DATASET_USER__SDS (0), NDS_DATASET_USER__UNKNOWN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"datasetId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>datasetId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"ndsDataAccessType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ndsDataAccessType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void NavigationSDSServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NavigationSDSServiceStub*>(getStub()))->onGetAll (properties);
}

void NavigationSDSServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "mapUpdateRequested");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "handOverSessionStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "positionStatusInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "positionInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "sdsAddressWithOptions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "sdsVoiceTagWithOptions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "navDatasetInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "dynamicMapPoiCategoryWithLanguage");
            ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageSet > payload(new DynamicMapPoiCategoryWithLanguageSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<NavigationSDSServiceStub*>(getStub())->onDynamicMapPoiCategoryWithLanguageSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NavigationSDSServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "mapUpdateRequested");
            ::boost::shared_ptr< MapUpdateRequestedGet > payload(new MapUpdateRequestedGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onMapUpdateRequestedGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "handOverSessionStatus");
            ::boost::shared_ptr< HandOverSessionStatusGet > payload(new HandOverSessionStatusGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onHandOverSessionStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "positionStatusInfo");
            ::boost::shared_ptr< PositionStatusInfoGet > payload(new PositionStatusInfoGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onPositionStatusInfoGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "positionInfo");
            ::boost::shared_ptr< PositionInfoGet > payload(new PositionInfoGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onPositionInfoGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "sdsAddressWithOptions");
            ::boost::shared_ptr< SdsAddressWithOptionsGet > payload(new SdsAddressWithOptionsGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsAddressWithOptionsGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "sdsVoiceTagWithOptions");
            ::boost::shared_ptr< SdsVoiceTagWithOptionsGet > payload(new SdsVoiceTagWithOptionsGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onSdsVoiceTagWithOptionsGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "navDatasetInfo");
            ::boost::shared_ptr< NavDatasetInfoGet > payload(new NavDatasetInfoGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onNavDatasetInfoGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "dynamicMapPoiCategoryWithLanguage");
            ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageGet > payload(new DynamicMapPoiCategoryWithLanguageGet());
            payload->setAct(act);
            static_cast<NavigationSDSServiceStub*>(getStub())->onDynamicMapPoiCategoryWithLanguageGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NavigationSDSServiceStub::NavigationSDSServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationSDSServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationSDSServiceStub::NavigationSDSServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationSDSServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationSDSServiceStub::~NavigationSDSServiceStub() {
    delete _stubDelegate;
}

void NavigationSDSServiceStub::sendMapUpdateRequestedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapUpdateRequestedUpdate payload(_mapUpdateRequestedProperty);

        LOG_INFO ("-> send%s", "MapUpdateRequestedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("mapUpdateRequested", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapUpdateRequestedUpdate");
    }
}

void NavigationSDSServiceStub::onMapUpdateRequestedGet(const ::boost::shared_ptr< MapUpdateRequestedGet >& mapUpdateRequested) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapUpdateRequestedGet", mapUpdateRequested->getAct());
    sendMapUpdateRequestedGetUpdate(_mapUpdateRequestedProperty.getMapUpdateRequested(), mapUpdateRequested->getAct());
}

void NavigationSDSServiceStub::sendMapUpdateRequestedGetUpdate(bool mapUpdateRequested, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapUpdateRequestedGet payload(mapUpdateRequested);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapUpdateRequestedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setMapUpdateRequested(bool mapUpdateRequested) {
    if(mapUpdateRequested!=_mapUpdateRequestedProperty.getMapUpdateRequested()) {
        _mapUpdateRequestedProperty.setMapUpdateRequested(mapUpdateRequested);
        sendMapUpdateRequestedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationSDSServiceStub::getMapUpdateRequested() const {
    return _mapUpdateRequestedProperty.getMapUpdateRequested();
}

void NavigationSDSServiceStub::sendHandOverSessionStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HandOverSessionStatusUpdate payload(_handOverSessionStatusProperty);

        LOG_INFO ("-> send%s", "HandOverSessionStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("handOverSessionStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HandOverSessionStatusUpdate");
    }
}

void NavigationSDSServiceStub::onHandOverSessionStatusGet(const ::boost::shared_ptr< HandOverSessionStatusGet >& handOverSessionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HandOverSessionStatusGet", handOverSessionStatus->getAct());
    sendHandOverSessionStatusGetUpdate(_handOverSessionStatusProperty.getHandOverSessionStatus(), handOverSessionStatus->getAct());
}

void NavigationSDSServiceStub::sendHandOverSessionStatusGetUpdate(const HandOverSessionStatus& handOverSessionStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HandOverSessionStatusGet payload(handOverSessionStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HandOverSessionStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setHandOverSessionStatus(const HandOverSessionStatus& handOverSessionStatus) {
    if(handOverSessionStatus!=_handOverSessionStatusProperty.getHandOverSessionStatus()) {
        _handOverSessionStatusProperty.setHandOverSessionStatus(handOverSessionStatus);
        sendHandOverSessionStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const HandOverSessionStatus& NavigationSDSServiceStub::getHandOverSessionStatus() const {
    return _handOverSessionStatusProperty.getHandOverSessionStatus();
}

HandOverSessionStatus& NavigationSDSServiceStub::getHandOverSessionStatusMutable() {
    return _handOverSessionStatusProperty.getHandOverSessionStatusMutable();
}

void NavigationSDSServiceStub::sendPositionStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PositionStatusInfoUpdate payload(_positionStatusInfoProperty);

        LOG_INFO ("-> send%s", "PositionStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("positionStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PositionStatusInfoUpdate");
    }
}

void NavigationSDSServiceStub::onPositionStatusInfoGet(const ::boost::shared_ptr< PositionStatusInfoGet >& positionStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PositionStatusInfoGet", positionStatusInfo->getAct());
    sendPositionStatusInfoGetUpdate(_positionStatusInfoProperty.getPositionStatusInfo(), positionStatusInfo->getAct());
}

void NavigationSDSServiceStub::sendPositionStatusInfoGetUpdate(const PositionStatusInfo& positionStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PositionStatusInfoGet payload(positionStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PositionStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setPositionStatusInfo(const PositionStatusInfo& positionStatusInfo) {
    if(positionStatusInfo!=_positionStatusInfoProperty.getPositionStatusInfo()) {
        _positionStatusInfoProperty.setPositionStatusInfo(positionStatusInfo);
        sendPositionStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const PositionStatusInfo& NavigationSDSServiceStub::getPositionStatusInfo() const {
    return _positionStatusInfoProperty.getPositionStatusInfo();
}

PositionStatusInfo& NavigationSDSServiceStub::getPositionStatusInfoMutable() {
    return _positionStatusInfoProperty.getPositionStatusInfoMutable();
}

void NavigationSDSServiceStub::sendPositionInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PositionInfoUpdate payload(_positionInfoProperty);

        LOG_INFO ("-> send%s", "PositionInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("positionInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PositionInfoUpdate");
    }
}

void NavigationSDSServiceStub::onPositionInfoGet(const ::boost::shared_ptr< PositionInfoGet >& positionInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PositionInfoGet", positionInfo->getAct());
    sendPositionInfoGetUpdate(_positionInfoProperty.getPositionInfo(), positionInfo->getAct());
}

void NavigationSDSServiceStub::sendPositionInfoGetUpdate(const PositionInfo& positionInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PositionInfoGet payload(positionInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PositionInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setPositionInfo(const PositionInfo& positionInfo) {
    if(positionInfo!=_positionInfoProperty.getPositionInfo()) {
        _positionInfoProperty.setPositionInfo(positionInfo);
        sendPositionInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const PositionInfo& NavigationSDSServiceStub::getPositionInfo() const {
    return _positionInfoProperty.getPositionInfo();
}

PositionInfo& NavigationSDSServiceStub::getPositionInfoMutable() {
    return _positionInfoProperty.getPositionInfoMutable();
}

void NavigationSDSServiceStub::sendSdsAddressWithOptionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsAddressWithOptionsUpdate payload(_sdsAddressWithOptionsProperty);

        LOG_INFO ("-> send%s", "SdsAddressWithOptionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsAddressWithOptions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsAddressWithOptionsUpdate");
    }
}

void NavigationSDSServiceStub::onSdsAddressWithOptionsGet(const ::boost::shared_ptr< SdsAddressWithOptionsGet >& sdsAddressWithOptions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsAddressWithOptionsGet", sdsAddressWithOptions->getAct());
    sendSdsAddressWithOptionsGetUpdate(_sdsAddressWithOptionsProperty.getSdsAddressWithOptions(), sdsAddressWithOptions->getAct());
}

void NavigationSDSServiceStub::sendSdsAddressWithOptionsGetUpdate(const SDSAddressWithOptions& sdsAddressWithOptions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsAddressWithOptionsGet payload(sdsAddressWithOptions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsAddressWithOptionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setSdsAddressWithOptions(const SDSAddressWithOptions& sdsAddressWithOptions) {
    if(sdsAddressWithOptions!=_sdsAddressWithOptionsProperty.getSdsAddressWithOptions()) {
        _sdsAddressWithOptionsProperty.setSdsAddressWithOptions(sdsAddressWithOptions);
        sendSdsAddressWithOptionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SDSAddressWithOptions& NavigationSDSServiceStub::getSdsAddressWithOptions() const {
    return _sdsAddressWithOptionsProperty.getSdsAddressWithOptions();
}

SDSAddressWithOptions& NavigationSDSServiceStub::getSdsAddressWithOptionsMutable() {
    return _sdsAddressWithOptionsProperty.getSdsAddressWithOptionsMutable();
}

void NavigationSDSServiceStub::sendSdsVoiceTagWithOptionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsVoiceTagWithOptionsUpdate payload(_sdsVoiceTagWithOptionsProperty);

        LOG_INFO ("-> send%s", "SdsVoiceTagWithOptionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsVoiceTagWithOptions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsVoiceTagWithOptionsUpdate");
    }
}

void NavigationSDSServiceStub::onSdsVoiceTagWithOptionsGet(const ::boost::shared_ptr< SdsVoiceTagWithOptionsGet >& sdsVoiceTagWithOptions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsVoiceTagWithOptionsGet", sdsVoiceTagWithOptions->getAct());
    sendSdsVoiceTagWithOptionsGetUpdate(_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions(), sdsVoiceTagWithOptions->getAct());
}

void NavigationSDSServiceStub::sendSdsVoiceTagWithOptionsGetUpdate(const SDSVoiceTagId& sdsVoiceTagWithOptions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsVoiceTagWithOptionsGet payload(sdsVoiceTagWithOptions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsVoiceTagWithOptionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setSdsVoiceTagWithOptions(const SDSVoiceTagId& sdsVoiceTagWithOptions) {
    if(sdsVoiceTagWithOptions!=_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions()) {
        _sdsVoiceTagWithOptionsProperty.setSdsVoiceTagWithOptions(sdsVoiceTagWithOptions);
        sendSdsVoiceTagWithOptionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SDSVoiceTagId& NavigationSDSServiceStub::getSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions();
}

SDSVoiceTagId& NavigationSDSServiceStub::getSdsVoiceTagWithOptionsMutable() {
    return _sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptionsMutable();
}

void NavigationSDSServiceStub::sendNavDatasetInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NavDatasetInfoUpdate payload(_navDatasetInfoProperty);

        LOG_INFO ("-> send%s", "NavDatasetInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("navDatasetInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NavDatasetInfoUpdate");
    }
}

void NavigationSDSServiceStub::onNavDatasetInfoGet(const ::boost::shared_ptr< NavDatasetInfoGet >& navDatasetInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NavDatasetInfoGet", navDatasetInfo->getAct());
    sendNavDatasetInfoGetUpdate(_navDatasetInfoProperty.getNavDatasetInfo(), navDatasetInfo->getAct());
}

void NavigationSDSServiceStub::sendNavDatasetInfoGetUpdate(const NavDataSetInfo& navDatasetInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NavDatasetInfoGet payload(navDatasetInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NavDatasetInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::setNavDatasetInfo(const NavDataSetInfo& navDatasetInfo) {
    if(navDatasetInfo!=_navDatasetInfoProperty.getNavDatasetInfo()) {
        _navDatasetInfoProperty.setNavDatasetInfo(navDatasetInfo);
        sendNavDatasetInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const NavDataSetInfo& NavigationSDSServiceStub::getNavDatasetInfo() const {
    return _navDatasetInfoProperty.getNavDatasetInfo();
}

NavDataSetInfo& NavigationSDSServiceStub::getNavDatasetInfoMutable() {
    return _navDatasetInfoProperty.getNavDatasetInfoMutable();
}

void NavigationSDSServiceStub::sendDynamicMapPoiCategoryWithLanguageUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DynamicMapPoiCategoryWithLanguageUpdate payload(_dynamicMapPoiCategoryWithLanguageProperty);

        LOG_INFO ("-> send%s", "DynamicMapPoiCategoryWithLanguageUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("dynamicMapPoiCategoryWithLanguage", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationSDSService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DynamicMapPoiCategoryWithLanguageUpdate");
    }
}

void NavigationSDSServiceStub::onDynamicMapPoiCategoryWithLanguageGet(const ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageGet >& dynamicMapPoiCategoryWithLanguage) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguageGet", dynamicMapPoiCategoryWithLanguage->getAct());
    sendDynamicMapPoiCategoryWithLanguageGetUpdate(_dynamicMapPoiCategoryWithLanguageProperty.getDynamicMapPoiCategoryWithLanguage(), dynamicMapPoiCategoryWithLanguage->getAct());
}

void NavigationSDSServiceStub::sendDynamicMapPoiCategoryWithLanguageGetUpdate(const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DynamicMapPoiCategoryWithLanguageGet payload(dynamicMapPoiCategoryWithLanguage);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguageGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationSDSServiceStub::onDynamicMapPoiCategoryWithLanguageSet(const ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageSet >& dynamicMapPoiCategoryWithLanguage) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguageSet", dynamicMapPoiCategoryWithLanguage->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*dynamicMapPoiCategoryWithLanguage, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDynamicMapPoiCategoryWithLanguage (dynamicMapPoiCategoryWithLanguage->getDynamicMapPoiCategoryWithLanguage());
    sendDynamicMapPoiCategoryWithLanguageSetUpdate(dynamicMapPoiCategoryWithLanguage->getAct());
}

void NavigationSDSServiceStub::sendDynamicMapPoiCategoryWithLanguageSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguageSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void NavigationSDSServiceStub::setDynamicMapPoiCategoryWithLanguage(const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage) {
    if(dynamicMapPoiCategoryWithLanguage!=_dynamicMapPoiCategoryWithLanguageProperty.getDynamicMapPoiCategoryWithLanguage()) {
        _dynamicMapPoiCategoryWithLanguageProperty.setDynamicMapPoiCategoryWithLanguage(dynamicMapPoiCategoryWithLanguage);
        sendDynamicMapPoiCategoryWithLanguageUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const DynamicMapPoiCategoriesWithLanguage& NavigationSDSServiceStub::getDynamicMapPoiCategoryWithLanguage() const {
    return _dynamicMapPoiCategoryWithLanguageProperty.getDynamicMapPoiCategoryWithLanguage();
}

DynamicMapPoiCategoriesWithLanguage& NavigationSDSServiceStub::getDynamicMapPoiCategoryWithLanguageMutable() {
    return _dynamicMapPoiCategoryWithLanguageProperty.getDynamicMapPoiCategoryWithLanguageMutable();
}

void  NavigationSDSServiceStub::sendGetGlobalDataForSdsResponse (const ::std::string& deviceName, uint32 datasetId, const ::std::string& persistentDatasetId, const ::std::vector< SdsProducts >& sdsProductsList, const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList, act_t act) {
    GetGlobalDataForSdsResponse* payload = new GetGlobalDataForSdsResponse(deviceName, datasetId, persistentDatasetId, sdsProductsList, updateRegionSpecifierRelationsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getGlobalDataForSds", GetGlobalDataForSdsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetGlobalDataForSds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetGlobalDataForSdsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetGlobalDataForSdsError* payload = new GetGlobalDataForSdsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getGlobalDataForSds", GetGlobalDataForSdsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetGlobalDataForSds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetIdListOfCountryAndSubCountryResponse (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList, const ::std::vector< SubCountryIds >& subCountryIdList, act_t act) {
    GetIdListOfCountryAndSubCountryResponse* payload = new GetIdListOfCountryAndSubCountryResponse(countryIdList, subCountryIdList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getIdListOfCountryAndSubCountry", GetIdListOfCountryAndSubCountryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetIdListOfCountryAndSubCountry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetIdListOfCountryAndSubCountryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetIdListOfCountryAndSubCountryError* payload = new GetIdListOfCountryAndSubCountryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getIdListOfCountryAndSubCountry", GetIdListOfCountryAndSubCountryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetIdListOfCountryAndSubCountry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetNamesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList, act_t act) {
    GetNamesForNDSIdsResponse* payload = new GetNamesForNDSIdsResponse(namedObjectIdStringsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getNamesForNDSIds", GetNamesForNDSIdsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetNamesForNDSIds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetNamesForNDSIdsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetNamesForNDSIdsError* payload = new GetNamesForNDSIdsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getNamesForNDSIds", GetNamesForNDSIdsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetNamesForNDSIds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetPhonemesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList, act_t act) {
    GetPhonemesForNDSIdsResponse* payload = new GetPhonemesForNDSIdsResponse(namedObjectIdStringsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getPhonemesForNDSIds", GetPhonemesForNDSIdsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetPhonemesForNDSIds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetPhonemesForNDSIdsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPhonemesForNDSIdsError* payload = new GetPhonemesForNDSIdsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getPhonemesForNDSIds", GetPhonemesForNDSIdsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetPhonemesForNDSIds", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetCityHasStreetsResponse (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList, act_t act) {
    GetCityHasStreetsResponse* payload = new GetCityHasStreetsResponse(cityNamedObjectIdHasStreetsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getCityHasStreets", GetCityHasStreetsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetCityHasStreets", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetCityHasStreetsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetCityHasStreetsError* payload = new GetCityHasStreetsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getCityHasStreets", GetCityHasStreetsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetCityHasStreets", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendNdsDatasetReleasedResponse (act_t act) {
    NdsDatasetReleasedResponse* payload = new NdsDatasetReleasedResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ndsDatasetReleased", NdsDatasetReleasedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "NdsDatasetReleased", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendNdsDatasetReleasedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    NdsDatasetReleasedError* payload = new NdsDatasetReleasedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ndsDatasetReleased", NdsDatasetReleasedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "NdsDatasetReleased", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetHapticHandOverDataResponse (SDSHandOverScreenId sdsHandOverScreenId, const ::std::vector< HapticData >& dataList, const ::std::vector< SelectedDataItem >& selectedDataListItems, LocationType locationType, const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList, const ::std::vector< AddressListElement >& searchResults, act_t act) {
    GetHapticHandOverDataResponse* payload = new GetHapticHandOverDataResponse(sdsHandOverScreenId, dataList, selectedDataListItems, locationType, sdsHandOverOptionsList, searchResults);
    DBUS_MESSAGE_REPLY(dbusMessage, "getHapticHandOverData", GetHapticHandOverDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetHapticHandOverData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetHapticHandOverDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetHapticHandOverDataError* payload = new GetHapticHandOverDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getHapticHandOverData", GetHapticHandOverDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetHapticHandOverData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSelectHapticHandOverListResponse (act_t act) {
    SelectHapticHandOverListResponse* payload = new SelectHapticHandOverListResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "selectHapticHandOverList", SelectHapticHandOverListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SelectHapticHandOverList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSelectHapticHandOverListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectHapticHandOverListError* payload = new SelectHapticHandOverListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "selectHapticHandOverList", SelectHapticHandOverListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SelectHapticHandOverList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetDynamicPoiIconCategoriesInMapResponse (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory, act_t act) {
    GetDynamicPoiIconCategoriesInMapResponse* payload = new GetDynamicPoiIconCategoriesInMapResponse(dynamicMapPoiCategory);
    DBUS_MESSAGE_REPLY(dbusMessage, "getDynamicPoiIconCategoriesInMap", GetDynamicPoiIconCategoriesInMapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetDynamicPoiIconCategoriesInMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetDynamicPoiIconCategoriesInMapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetDynamicPoiIconCategoriesInMapError* payload = new GetDynamicPoiIconCategoriesInMapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getDynamicPoiIconCategoriesInMap", GetDynamicPoiIconCategoriesInMapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetDynamicPoiIconCategoriesInMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetMaxWaypointCountResponse (uint32 maxWayPointCount, act_t act) {
    GetMaxWaypointCountResponse* payload = new GetMaxWaypointCountResponse(maxWayPointCount);
    DBUS_MESSAGE_REPLY(dbusMessage, "getMaxWaypointCount", GetMaxWaypointCountResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetMaxWaypointCount", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendGetMaxWaypointCountError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetMaxWaypointCountError* payload = new GetMaxWaypointCountError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getMaxWaypointCount", GetMaxWaypointCountError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetMaxWaypointCount", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSetDynamicPoiIconCategoriesInMapResponse (act_t act) {
    SetDynamicPoiIconCategoriesInMapResponse* payload = new SetDynamicPoiIconCategoriesInMapResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setDynamicPoiIconCategoriesInMap", SetDynamicPoiIconCategoriesInMapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetDynamicPoiIconCategoriesInMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSetDynamicPoiIconCategoriesInMapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetDynamicPoiIconCategoriesInMapError* payload = new SetDynamicPoiIconCategoriesInMapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setDynamicPoiIconCategoriesInMap", SetDynamicPoiIconCategoriesInMapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetDynamicPoiIconCategoriesInMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsCheckAddressResponse (act_t act) {
    SdsCheckAddressResponse* payload = new SdsCheckAddressResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsCheckAddress", SdsCheckAddressResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsCheckAddress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsCheckAddressError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsCheckAddressError* payload = new SdsCheckAddressError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsCheckAddress", SdsCheckAddressError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsCheckAddress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements, act_t act) {
    SdsGetRefinementListResponse* payload = new SdsGetRefinementListResponse(refinements);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsGetRefinementList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsGetRefinementListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsGetRefinementListError* payload = new SdsGetRefinementListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsGetRefinementList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsUpdateVoiceTagResponse (act_t act) {
    SdsUpdateVoiceTagResponse* payload = new SdsUpdateVoiceTagResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsUpdateVoiceTag", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsUpdateVoiceTagError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsUpdateVoiceTagError* payload = new SdsUpdateVoiceTagError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsUpdateVoiceTag", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber, const ::std::string& maxHouseNumber, const ::std::vector< ::std::string >& patterns, act_t act) {
    SdsGetHouseNumberPatternResponse* payload = new SdsGetHouseNumberPatternResponse(minHouseNumber, maxHouseNumber, patterns);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsGetHouseNumberPattern", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsGetHouseNumberPatternError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsGetHouseNumberPatternError* payload = new SdsGetHouseNumberPatternError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsGetHouseNumberPattern", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSelectSdsRefinementResponse (act_t act) {
    SelectSdsRefinementResponse* payload = new SelectSdsRefinementResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "selectSdsRefinement", SelectSdsRefinementResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SelectSdsRefinement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSelectSdsRefinementError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectSdsRefinementError* payload = new SelectSdsRefinementError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "selectSdsRefinement", SelectSdsRefinementError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SelectSdsRefinement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSetLocationWithSdsInputResponse (act_t act) {
    SetLocationWithSdsInputResponse* payload = new SetLocationWithSdsInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithSdsInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSetLocationWithSdsInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithSdsInputError* payload = new SetLocationWithSdsInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithSdsInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendRequestAddressFormatForAvailableCountriesResponse (const ::std::vector< AddressFormatInfo >& addressFormatInfos, act_t act) {
    RequestAddressFormatForAvailableCountriesResponse* payload = new RequestAddressFormatForAvailableCountriesResponse(addressFormatInfos);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestAddressFormatForAvailableCountries", RequestAddressFormatForAvailableCountriesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestAddressFormatForAvailableCountries", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendRequestAddressFormatForAvailableCountriesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestAddressFormatForAvailableCountriesError* payload = new RequestAddressFormatForAvailableCountriesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestAddressFormatForAvailableCountries", RequestAddressFormatForAvailableCountriesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestAddressFormatForAvailableCountries", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsShowReachableAreaMapResponse (act_t act) {
    SdsShowReachableAreaMapResponse* payload = new SdsShowReachableAreaMapResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsShowReachableAreaMap", SdsShowReachableAreaMapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsShowReachableAreaMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsShowReachableAreaMapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsShowReachableAreaMapError* payload = new SdsShowReachableAreaMapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsShowReachableAreaMap", SdsShowReachableAreaMapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsShowReachableAreaMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsDatasetUserRegistrationResponse (RegistrationAndDeRegistrationStatus registrationStatus, act_t act) {
    SdsDatasetUserRegistrationResponse* payload = new SdsDatasetUserRegistrationResponse(registrationStatus);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsDatasetUserRegistration", SdsDatasetUserRegistrationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsDatasetUserRegistration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsDatasetUserRegistrationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsDatasetUserRegistrationError* payload = new SdsDatasetUserRegistrationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsDatasetUserRegistration", SdsDatasetUserRegistrationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsDatasetUserRegistration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsDatasetUserDeregistrationResponse (RegistrationAndDeRegistrationStatus deregistrationStatus, act_t act) {
    SdsDatasetUserDeregistrationResponse* payload = new SdsDatasetUserDeregistrationResponse(deregistrationStatus);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsDatasetUserDeregistration", SdsDatasetUserDeregistrationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsDatasetUserDeregistration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendSdsDatasetUserDeregistrationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsDatasetUserDeregistrationError* payload = new SdsDatasetUserDeregistrationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsDatasetUserDeregistration", SdsDatasetUserDeregistrationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsDatasetUserDeregistration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendDatasetAccessModeChangedIndicationResponse (act_t act) {
    DatasetAccessModeChangedIndicationResponse* payload = new DatasetAccessModeChangedIndicationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "datasetAccessModeChangedIndication", DatasetAccessModeChangedIndicationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DatasetAccessModeChangedIndication", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationSDSServiceStub::sendDatasetAccessModeChangedIndicationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DatasetAccessModeChangedIndicationError* payload = new DatasetAccessModeChangedIndicationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "datasetAccessModeChangedIndication", DatasetAccessModeChangedIndicationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DatasetAccessModeChangedIndication", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NavigationSDSServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'mapUpdateRequested'
    {
        ::asf::dbus::DBusVariant variant;
        MapUpdateRequestedGet payload(_mapUpdateRequestedProperty.getMapUpdateRequested());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("mapUpdateRequested", variant));
    }

    //property 'handOverSessionStatus'
    {
        ::asf::dbus::DBusVariant variant;
        HandOverSessionStatusGet payload(_handOverSessionStatusProperty.getHandOverSessionStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("handOverSessionStatus", variant));
    }

    //property 'positionStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        PositionStatusInfoGet payload(_positionStatusInfoProperty.getPositionStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("positionStatusInfo", variant));
    }

    //property 'positionInfo'
    {
        ::asf::dbus::DBusVariant variant;
        PositionInfoGet payload(_positionInfoProperty.getPositionInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("positionInfo", variant));
    }

    //property 'sdsAddressWithOptions'
    {
        ::asf::dbus::DBusVariant variant;
        SdsAddressWithOptionsGet payload(_sdsAddressWithOptionsProperty.getSdsAddressWithOptions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsAddressWithOptions", variant));
    }

    //property 'sdsVoiceTagWithOptions'
    {
        ::asf::dbus::DBusVariant variant;
        SdsVoiceTagWithOptionsGet payload(_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsVoiceTagWithOptions", variant));
    }

    //property 'navDatasetInfo'
    {
        ::asf::dbus::DBusVariant variant;
        NavDatasetInfoGet payload(_navDatasetInfoProperty.getNavDatasetInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("navDatasetInfo", variant));
    }

    //property 'dynamicMapPoiCategoryWithLanguage'
    {
        ::asf::dbus::DBusVariant variant;
        DynamicMapPoiCategoryWithLanguageGet payload(_dynamicMapPoiCategoryWithLanguageProperty.getDynamicMapPoiCategoryWithLanguage());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("dynamicMapPoiCategoryWithLanguage", variant));
    }
}

} // namespace NavigationSDSService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
