/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationSDSService.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceJson.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationSDSService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationSDSService", NavigationSDSServiceProxy);

class NavigationSDSServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NavigationSDSServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NavigationSDSServiceProxy >& proxyShared = ::boost::static_pointer_cast< NavigationSDSServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_mapUpdateRequested:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapUpdateRequestedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapUpdateRequested", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapUpdateRequestedError> payload = ::boost::static_pointer_cast<MapUpdateRequestedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MapUpdateRequestedCallbackIF*) _callback)->onMapUpdateRequestedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapUpdateRequestedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapUpdateRequested", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapUpdateRequestedUpdate> payload = ::boost::static_pointer_cast<MapUpdateRequestedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MapUpdateRequestedCallbackIF*) _callback)->onMapUpdateRequestedUpdate(proxyShared, payload);
                        proxyShared->_mapUpdateRequested = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_handOverSessionStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HandOverSessionStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HandOverSessionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HandOverSessionStatusError> payload = ::boost::static_pointer_cast<HandOverSessionStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HandOverSessionStatusCallbackIF*) _callback)->onHandOverSessionStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HandOverSessionStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HandOverSessionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HandOverSessionStatusUpdate> payload = ::boost::static_pointer_cast<HandOverSessionStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HandOverSessionStatusCallbackIF*) _callback)->onHandOverSessionStatusUpdate(proxyShared, payload);
                        proxyShared->_handOverSessionStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_positionStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionStatusInfoError> payload = ::boost::static_pointer_cast<PositionStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PositionStatusInfoCallbackIF*) _callback)->onPositionStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionStatusInfoUpdate> payload = ::boost::static_pointer_cast<PositionStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PositionStatusInfoCallbackIF*) _callback)->onPositionStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_positionStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_positionInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionInfoError> payload = ::boost::static_pointer_cast<PositionInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PositionInfoCallbackIF*) _callback)->onPositionInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionInfoUpdate> payload = ::boost::static_pointer_cast<PositionInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PositionInfoCallbackIF*) _callback)->onPositionInfoUpdate(proxyShared, payload);
                        proxyShared->_positionInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsAddressWithOptions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsAddressWithOptionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsAddressWithOptionsError> payload = ::boost::static_pointer_cast<SdsAddressWithOptionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsAddressWithOptionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsAddressWithOptionsUpdate> payload = ::boost::static_pointer_cast<SdsAddressWithOptionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsUpdate(proxyShared, payload);
                        proxyShared->_sdsAddressWithOptions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsVoiceTagWithOptions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsVoiceTagWithOptionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsVoiceTagWithOptionsError> payload = ::boost::static_pointer_cast<SdsVoiceTagWithOptionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsVoiceTagWithOptionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsVoiceTagWithOptionsUpdate> payload = ::boost::static_pointer_cast<SdsVoiceTagWithOptionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsUpdate(proxyShared, payload);
                        proxyShared->_sdsVoiceTagWithOptions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_navDatasetInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDatasetInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDatasetInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDatasetInfoError> payload = ::boost::static_pointer_cast<NavDatasetInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NavDatasetInfoCallbackIF*) _callback)->onNavDatasetInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDatasetInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDatasetInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDatasetInfoUpdate> payload = ::boost::static_pointer_cast<NavDatasetInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NavDatasetInfoCallbackIF*) _callback)->onNavDatasetInfoUpdate(proxyShared, payload);
                        proxyShared->_navDatasetInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_dynamicMapPoiCategoryWithLanguage:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DynamicMapPoiCategoryWithLanguageError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DynamicMapPoiCategoryWithLanguage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DynamicMapPoiCategoryWithLanguageError> payload = ::boost::static_pointer_cast<DynamicMapPoiCategoryWithLanguageError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DynamicMapPoiCategoryWithLanguageCallbackIF*) _callback)->onDynamicMapPoiCategoryWithLanguageError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DynamicMapPoiCategoryWithLanguageUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DynamicMapPoiCategoryWithLanguage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DynamicMapPoiCategoryWithLanguageUpdate> payload = ::boost::static_pointer_cast<DynamicMapPoiCategoryWithLanguageUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DynamicMapPoiCategoryWithLanguageCallbackIF*) _callback)->onDynamicMapPoiCategoryWithLanguageUpdate(proxyShared, payload);
                        proxyShared->_dynamicMapPoiCategoryWithLanguage = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_getGlobalDataForSds:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetGlobalDataForSdsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetGlobalDataForSds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetGlobalDataForSdsError> payload = ::boost::static_pointer_cast<GetGlobalDataForSdsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetGlobalDataForSdsCallbackIF*) _callback)->onGetGlobalDataForSdsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetGlobalDataForSdsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetGlobalDataForSds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetGlobalDataForSdsResponse> payload = ::boost::static_pointer_cast<GetGlobalDataForSdsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetGlobalDataForSdsCallbackIF*) _callback)->onGetGlobalDataForSdsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getIdListOfCountryAndSubCountry:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetIdListOfCountryAndSubCountryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetIdListOfCountryAndSubCountry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetIdListOfCountryAndSubCountryError> payload = ::boost::static_pointer_cast<GetIdListOfCountryAndSubCountryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetIdListOfCountryAndSubCountryCallbackIF*) _callback)->onGetIdListOfCountryAndSubCountryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetIdListOfCountryAndSubCountryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetIdListOfCountryAndSubCountry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetIdListOfCountryAndSubCountryResponse> payload = ::boost::static_pointer_cast<GetIdListOfCountryAndSubCountryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetIdListOfCountryAndSubCountryCallbackIF*) _callback)->onGetIdListOfCountryAndSubCountryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getNamesForNDSIds:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetNamesForNDSIdsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNamesForNDSIds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNamesForNDSIdsError> payload = ::boost::static_pointer_cast<GetNamesForNDSIdsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNamesForNDSIdsCallbackIF*) _callback)->onGetNamesForNDSIdsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNamesForNDSIdsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNamesForNDSIds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNamesForNDSIdsResponse> payload = ::boost::static_pointer_cast<GetNamesForNDSIdsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNamesForNDSIdsCallbackIF*) _callback)->onGetNamesForNDSIdsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getPhonemesForNDSIds:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPhonemesForNDSIdsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPhonemesForNDSIds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPhonemesForNDSIdsError> payload = ::boost::static_pointer_cast<GetPhonemesForNDSIdsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPhonemesForNDSIdsCallbackIF*) _callback)->onGetPhonemesForNDSIdsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPhonemesForNDSIdsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPhonemesForNDSIds", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPhonemesForNDSIdsResponse> payload = ::boost::static_pointer_cast<GetPhonemesForNDSIdsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPhonemesForNDSIdsCallbackIF*) _callback)->onGetPhonemesForNDSIdsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getCityHasStreets:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetCityHasStreetsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCityHasStreets", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCityHasStreetsError> payload = ::boost::static_pointer_cast<GetCityHasStreetsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCityHasStreetsCallbackIF*) _callback)->onGetCityHasStreetsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCityHasStreetsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCityHasStreets", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCityHasStreetsResponse> payload = ::boost::static_pointer_cast<GetCityHasStreetsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCityHasStreetsCallbackIF*) _callback)->onGetCityHasStreetsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ndsDatasetReleased:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), NdsDatasetReleasedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NdsDatasetReleased", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NdsDatasetReleasedError> payload = ::boost::static_pointer_cast<NdsDatasetReleasedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((NdsDatasetReleasedCallbackIF*) _callback)->onNdsDatasetReleasedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NdsDatasetReleasedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "NdsDatasetReleased", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NdsDatasetReleasedResponse> payload = ::boost::static_pointer_cast<NdsDatasetReleasedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((NdsDatasetReleasedCallbackIF*) _callback)->onNdsDatasetReleasedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getHapticHandOverData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetHapticHandOverDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetHapticHandOverData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetHapticHandOverDataError> payload = ::boost::static_pointer_cast<GetHapticHandOverDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetHapticHandOverDataCallbackIF*) _callback)->onGetHapticHandOverDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetHapticHandOverDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetHapticHandOverData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetHapticHandOverDataResponse> payload = ::boost::static_pointer_cast<GetHapticHandOverDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetHapticHandOverDataCallbackIF*) _callback)->onGetHapticHandOverDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_selectHapticHandOverList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectHapticHandOverListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectHapticHandOverList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectHapticHandOverListError> payload = ::boost::static_pointer_cast<SelectHapticHandOverListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectHapticHandOverListCallbackIF*) _callback)->onSelectHapticHandOverListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectHapticHandOverListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectHapticHandOverList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectHapticHandOverListResponse> payload = ::boost::static_pointer_cast<SelectHapticHandOverListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectHapticHandOverListCallbackIF*) _callback)->onSelectHapticHandOverListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getDynamicPoiIconCategoriesInMap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetDynamicPoiIconCategoriesInMapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDynamicPoiIconCategoriesInMapError> payload = ::boost::static_pointer_cast<GetDynamicPoiIconCategoriesInMapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onGetDynamicPoiIconCategoriesInMapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDynamicPoiIconCategoriesInMapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDynamicPoiIconCategoriesInMapResponse> payload = ::boost::static_pointer_cast<GetDynamicPoiIconCategoriesInMapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onGetDynamicPoiIconCategoriesInMapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getMaxWaypointCount:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetMaxWaypointCountError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetMaxWaypointCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetMaxWaypointCountError> payload = ::boost::static_pointer_cast<GetMaxWaypointCountError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetMaxWaypointCountCallbackIF*) _callback)->onGetMaxWaypointCountError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetMaxWaypointCountResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetMaxWaypointCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetMaxWaypointCountResponse> payload = ::boost::static_pointer_cast<GetMaxWaypointCountResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetMaxWaypointCountCallbackIF*) _callback)->onGetMaxWaypointCountResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setDynamicPoiIconCategoriesInMap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetDynamicPoiIconCategoriesInMapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDynamicPoiIconCategoriesInMapError> payload = ::boost::static_pointer_cast<SetDynamicPoiIconCategoriesInMapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onSetDynamicPoiIconCategoriesInMapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDynamicPoiIconCategoriesInMapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDynamicPoiIconCategoriesInMapResponse> payload = ::boost::static_pointer_cast<SetDynamicPoiIconCategoriesInMapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onSetDynamicPoiIconCategoriesInMapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsCheckAddress:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsCheckAddressError> payload = ::boost::static_pointer_cast<SdsCheckAddressError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsCheckAddressResponse> payload = ::boost::static_pointer_cast<SdsCheckAddressResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsGetRefinementList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetRefinementListError> payload = ::boost::static_pointer_cast<SdsGetRefinementListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetRefinementListResponse> payload = ::boost::static_pointer_cast<SdsGetRefinementListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsUpdateVoiceTag:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsUpdateVoiceTagError> payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsUpdateVoiceTagResponse> payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsGetHouseNumberPattern:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetHouseNumberPatternError> payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetHouseNumberPatternResponse> payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_selectSdsRefinement:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectSdsRefinementError> payload = ::boost::static_pointer_cast<SelectSdsRefinementError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectSdsRefinementResponse> payload = ::boost::static_pointer_cast<SelectSdsRefinementResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithSdsInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithSdsInputError> payload = ::boost::static_pointer_cast<SetLocationWithSdsInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithSdsInputResponse> payload = ::boost::static_pointer_cast<SetLocationWithSdsInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestAddressFormatForAvailableCountries:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestAddressFormatForAvailableCountriesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestAddressFormatForAvailableCountries", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestAddressFormatForAvailableCountriesError> payload = ::boost::static_pointer_cast<RequestAddressFormatForAvailableCountriesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestAddressFormatForAvailableCountriesCallbackIF*) _callback)->onRequestAddressFormatForAvailableCountriesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestAddressFormatForAvailableCountriesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestAddressFormatForAvailableCountries", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestAddressFormatForAvailableCountriesResponse> payload = ::boost::static_pointer_cast<RequestAddressFormatForAvailableCountriesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestAddressFormatForAvailableCountriesCallbackIF*) _callback)->onRequestAddressFormatForAvailableCountriesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsShowReachableAreaMap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsShowReachableAreaMapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsShowReachableAreaMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsShowReachableAreaMapError> payload = ::boost::static_pointer_cast<SdsShowReachableAreaMapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsShowReachableAreaMapCallbackIF*) _callback)->onSdsShowReachableAreaMapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsShowReachableAreaMapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsShowReachableAreaMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsShowReachableAreaMapResponse> payload = ::boost::static_pointer_cast<SdsShowReachableAreaMapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsShowReachableAreaMapCallbackIF*) _callback)->onSdsShowReachableAreaMapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsDatasetUserRegistration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserRegistrationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsDatasetUserRegistration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsDatasetUserRegistrationError> payload = ::boost::static_pointer_cast<SdsDatasetUserRegistrationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsDatasetUserRegistrationCallbackIF*) _callback)->onSdsDatasetUserRegistrationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserRegistrationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsDatasetUserRegistration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsDatasetUserRegistrationResponse> payload = ::boost::static_pointer_cast<SdsDatasetUserRegistrationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsDatasetUserRegistrationCallbackIF*) _callback)->onSdsDatasetUserRegistrationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsDatasetUserDeregistration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserDeregistrationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsDatasetUserDeregistration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsDatasetUserDeregistrationError> payload = ::boost::static_pointer_cast<SdsDatasetUserDeregistrationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsDatasetUserDeregistrationCallbackIF*) _callback)->onSdsDatasetUserDeregistrationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsDatasetUserDeregistrationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsDatasetUserDeregistration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsDatasetUserDeregistrationResponse> payload = ::boost::static_pointer_cast<SdsDatasetUserDeregistrationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsDatasetUserDeregistrationCallbackIF*) _callback)->onSdsDatasetUserDeregistrationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_datasetAccessModeChangedIndication:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DatasetAccessModeChangedIndicationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DatasetAccessModeChangedIndication", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DatasetAccessModeChangedIndicationError> payload = ::boost::static_pointer_cast<DatasetAccessModeChangedIndicationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DatasetAccessModeChangedIndicationCallbackIF*) _callback)->onDatasetAccessModeChangedIndicationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DatasetAccessModeChangedIndicationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DatasetAccessModeChangedIndication", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DatasetAccessModeChangedIndicationResponse> payload = ::boost::static_pointer_cast<DatasetAccessModeChangedIndicationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DatasetAccessModeChangedIndicationCallbackIF*) _callback)->onDatasetAccessModeChangedIndicationResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_mapUpdateRequested: {
                ::boost::shared_ptr< MapUpdateRequestedError > payload = ::boost::shared_ptr< MapUpdateRequestedError >
                (new MapUpdateRequestedError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapUpdateRequested", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapUpdateRequestedCallbackIF*) _callback)->onMapUpdateRequestedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_handOverSessionStatus: {
                ::boost::shared_ptr< HandOverSessionStatusError > payload = ::boost::shared_ptr< HandOverSessionStatusError >
                (new HandOverSessionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HandOverSessionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HandOverSessionStatusCallbackIF*) _callback)->onHandOverSessionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_positionStatusInfo: {
                ::boost::shared_ptr< PositionStatusInfoError > payload = ::boost::shared_ptr< PositionStatusInfoError >
                (new PositionStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PositionStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PositionStatusInfoCallbackIF*) _callback)->onPositionStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_positionInfo: {
                ::boost::shared_ptr< PositionInfoError > payload = ::boost::shared_ptr< PositionInfoError >
                (new PositionInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PositionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PositionInfoCallbackIF*) _callback)->onPositionInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsAddressWithOptions: {
                ::boost::shared_ptr< SdsAddressWithOptionsError > payload = ::boost::shared_ptr< SdsAddressWithOptionsError >
                (new SdsAddressWithOptionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsVoiceTagWithOptions: {
                ::boost::shared_ptr< SdsVoiceTagWithOptionsError > payload = ::boost::shared_ptr< SdsVoiceTagWithOptionsError >
                (new SdsVoiceTagWithOptionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_navDatasetInfo: {
                ::boost::shared_ptr< NavDatasetInfoError > payload = ::boost::shared_ptr< NavDatasetInfoError >
                (new NavDatasetInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NavDatasetInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NavDatasetInfoCallbackIF*) _callback)->onNavDatasetInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_dynamicMapPoiCategoryWithLanguage: {
                ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageError > payload = ::boost::shared_ptr< DynamicMapPoiCategoryWithLanguageError >
                (new DynamicMapPoiCategoryWithLanguageError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DynamicMapPoiCategoryWithLanguage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DynamicMapPoiCategoryWithLanguageCallbackIF*) _callback)->onDynamicMapPoiCategoryWithLanguageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getGlobalDataForSds: {
                ::boost::shared_ptr< GetGlobalDataForSdsError > payload = ::boost::shared_ptr< GetGlobalDataForSdsError >
                (new GetGlobalDataForSdsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetGlobalDataForSds", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetGlobalDataForSdsCallbackIF*) _callback)->onGetGlobalDataForSdsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getIdListOfCountryAndSubCountry: {
                ::boost::shared_ptr< GetIdListOfCountryAndSubCountryError > payload = ::boost::shared_ptr< GetIdListOfCountryAndSubCountryError >
                (new GetIdListOfCountryAndSubCountryError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetIdListOfCountryAndSubCountry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetIdListOfCountryAndSubCountryCallbackIF*) _callback)->onGetIdListOfCountryAndSubCountryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getNamesForNDSIds: {
                ::boost::shared_ptr< GetNamesForNDSIdsError > payload = ::boost::shared_ptr< GetNamesForNDSIdsError >
                (new GetNamesForNDSIdsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetNamesForNDSIds", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetNamesForNDSIdsCallbackIF*) _callback)->onGetNamesForNDSIdsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getPhonemesForNDSIds: {
                ::boost::shared_ptr< GetPhonemesForNDSIdsError > payload = ::boost::shared_ptr< GetPhonemesForNDSIdsError >
                (new GetPhonemesForNDSIdsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetPhonemesForNDSIds", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPhonemesForNDSIdsCallbackIF*) _callback)->onGetPhonemesForNDSIdsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getCityHasStreets: {
                ::boost::shared_ptr< GetCityHasStreetsError > payload = ::boost::shared_ptr< GetCityHasStreetsError >
                (new GetCityHasStreetsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetCityHasStreets", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCityHasStreetsCallbackIF*) _callback)->onGetCityHasStreetsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ndsDatasetReleased: {
                ::boost::shared_ptr< NdsDatasetReleasedError > payload = ::boost::shared_ptr< NdsDatasetReleasedError >
                (new NdsDatasetReleasedError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NdsDatasetReleased", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NdsDatasetReleasedCallbackIF*) _callback)->onNdsDatasetReleasedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getHapticHandOverData: {
                ::boost::shared_ptr< GetHapticHandOverDataError > payload = ::boost::shared_ptr< GetHapticHandOverDataError >
                (new GetHapticHandOverDataError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetHapticHandOverData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetHapticHandOverDataCallbackIF*) _callback)->onGetHapticHandOverDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_selectHapticHandOverList: {
                ::boost::shared_ptr< SelectHapticHandOverListError > payload = ::boost::shared_ptr< SelectHapticHandOverListError >
                (new SelectHapticHandOverListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SelectHapticHandOverList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectHapticHandOverListCallbackIF*) _callback)->onSelectHapticHandOverListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getDynamicPoiIconCategoriesInMap: {
                ::boost::shared_ptr< GetDynamicPoiIconCategoriesInMapError > payload = ::boost::shared_ptr< GetDynamicPoiIconCategoriesInMapError >
                (new GetDynamicPoiIconCategoriesInMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onGetDynamicPoiIconCategoriesInMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getMaxWaypointCount: {
                ::boost::shared_ptr< GetMaxWaypointCountError > payload = ::boost::shared_ptr< GetMaxWaypointCountError >
                (new GetMaxWaypointCountError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetMaxWaypointCount", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetMaxWaypointCountCallbackIF*) _callback)->onGetMaxWaypointCountError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setDynamicPoiIconCategoriesInMap: {
                ::boost::shared_ptr< SetDynamicPoiIconCategoriesInMapError > payload = ::boost::shared_ptr< SetDynamicPoiIconCategoriesInMapError >
                (new SetDynamicPoiIconCategoriesInMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetDynamicPoiIconCategoriesInMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetDynamicPoiIconCategoriesInMapCallbackIF*) _callback)->onSetDynamicPoiIconCategoriesInMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsCheckAddress: {
                ::boost::shared_ptr< SdsCheckAddressError > payload = ::boost::shared_ptr< SdsCheckAddressError >
                (new SdsCheckAddressError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsGetRefinementList: {
                ::boost::shared_ptr< SdsGetRefinementListError > payload = ::boost::shared_ptr< SdsGetRefinementListError >
                (new SdsGetRefinementListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsUpdateVoiceTag: {
                ::boost::shared_ptr< SdsUpdateVoiceTagError > payload = ::boost::shared_ptr< SdsUpdateVoiceTagError >
                (new SdsUpdateVoiceTagError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsGetHouseNumberPattern: {
                ::boost::shared_ptr< SdsGetHouseNumberPatternError > payload = ::boost::shared_ptr< SdsGetHouseNumberPatternError >
                (new SdsGetHouseNumberPatternError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternError (proxyShared,payload);
                return true;
            }
            break;
            case ID_selectSdsRefinement: {
                ::boost::shared_ptr< SelectSdsRefinementError > payload = ::boost::shared_ptr< SelectSdsRefinementError >
                (new SelectSdsRefinementError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithSdsInput: {
                ::boost::shared_ptr< SetLocationWithSdsInputError > payload = ::boost::shared_ptr< SetLocationWithSdsInputError >
                (new SetLocationWithSdsInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestAddressFormatForAvailableCountries: {
                ::boost::shared_ptr< RequestAddressFormatForAvailableCountriesError > payload = ::boost::shared_ptr< RequestAddressFormatForAvailableCountriesError >
                (new RequestAddressFormatForAvailableCountriesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestAddressFormatForAvailableCountries", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestAddressFormatForAvailableCountriesCallbackIF*) _callback)->onRequestAddressFormatForAvailableCountriesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsShowReachableAreaMap: {
                ::boost::shared_ptr< SdsShowReachableAreaMapError > payload = ::boost::shared_ptr< SdsShowReachableAreaMapError >
                (new SdsShowReachableAreaMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsShowReachableAreaMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsShowReachableAreaMapCallbackIF*) _callback)->onSdsShowReachableAreaMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsDatasetUserRegistration: {
                ::boost::shared_ptr< SdsDatasetUserRegistrationError > payload = ::boost::shared_ptr< SdsDatasetUserRegistrationError >
                (new SdsDatasetUserRegistrationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsDatasetUserRegistration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsDatasetUserRegistrationCallbackIF*) _callback)->onSdsDatasetUserRegistrationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsDatasetUserDeregistration: {
                ::boost::shared_ptr< SdsDatasetUserDeregistrationError > payload = ::boost::shared_ptr< SdsDatasetUserDeregistrationError >
                (new SdsDatasetUserDeregistrationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsDatasetUserDeregistration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsDatasetUserDeregistrationCallbackIF*) _callback)->onSdsDatasetUserDeregistrationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_datasetAccessModeChangedIndication: {
                ::boost::shared_ptr< DatasetAccessModeChangedIndicationError > payload = ::boost::shared_ptr< DatasetAccessModeChangedIndicationError >
                (new DatasetAccessModeChangedIndicationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationSDSService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DatasetAccessModeChangedIndication", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationSDSServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationSDSServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DatasetAccessModeChangedIndicationCallbackIF*) _callback)->onDatasetAccessModeChangedIndicationError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NavigationSDSServiceProxyCallback::_logger (NavigationSDSServiceProxy::_logger);

NavigationSDSServiceProxy::NavigationSDSServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.navigation.NavigationSDSService", serviceAvailable, _logger) {
}

NavigationSDSServiceProxy::~NavigationSDSServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NavigationSDSServiceProxy > NavigationSDSServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NavigationSDSServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NavigationSDSServiceProxy > proxyNew(new NavigationSDSServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t NavigationSDSServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NavigationSDSServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationSDSServiceProxy::clearAllProperties ()
{
    _mapUpdateRequested = ::asf::core::nullable< MapUpdateRequestedUpdate >();
    _handOverSessionStatus = ::asf::core::nullable< HandOverSessionStatusUpdate >();
    _positionStatusInfo = ::asf::core::nullable< PositionStatusInfoUpdate >();
    _positionInfo = ::asf::core::nullable< PositionInfoUpdate >();
    _sdsAddressWithOptions = ::asf::core::nullable< SdsAddressWithOptionsUpdate >();
    _sdsVoiceTagWithOptions = ::asf::core::nullable< SdsVoiceTagWithOptionsUpdate >();
    _navDatasetInfo = ::asf::core::nullable< NavDatasetInfoUpdate >();
    _dynamicMapPoiCategoryWithLanguage = ::asf::core::nullable< DynamicMapPoiCategoryWithLanguageUpdate >();
}

void NavigationSDSServiceProxy::sendDeregisterAll () const
{
    sendMapUpdateRequestedDeregisterAll();
    sendHandOverSessionStatusDeregisterAll();
    sendPositionStatusInfoDeregisterAll();
    sendPositionInfoDeregisterAll();
    sendSdsAddressWithOptionsDeregisterAll();
    sendSdsVoiceTagWithOptionsDeregisterAll();
    sendNavDatasetInfoDeregisterAll();
    sendDynamicMapPoiCategoryWithLanguageDeregisterAll();
}

act_t NavigationSDSServiceProxy::sendMapUpdateRequestedRegister(MapUpdateRequestedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_mapUpdateRequested, "mapUpdateRequested", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapUpdateRequested", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendMapUpdateRequestedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("mapUpdateRequested", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapUpdateRequested", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendMapUpdateRequestedGet(MapUpdateRequestedCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_mapUpdateRequested, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MapUpdateRequested", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("mapUpdateRequested", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationSDSServiceProxy::getMapUpdateRequested() const {
    return _mapUpdateRequested.get().getMapUpdateRequested();
}

bool NavigationSDSServiceProxy::hasMapUpdateRequested() const {
    return _mapUpdateRequested.hasValue();
}

void NavigationSDSServiceProxy::sendMapUpdateRequestedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapUpdateRequested");
    _dbusProxyDelegate->deregisterSignalCallback("mapUpdateRequested", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendHandOverSessionStatusRegister(HandOverSessionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_handOverSessionStatus, "handOverSessionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HandOverSessionStatus", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendHandOverSessionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("handOverSessionStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HandOverSessionStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendHandOverSessionStatusGet(HandOverSessionStatusCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_handOverSessionStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "HandOverSessionStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("handOverSessionStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const HandOverSessionStatus& NavigationSDSServiceProxy::getHandOverSessionStatus() const {
    return _handOverSessionStatus.get().getHandOverSessionStatus();
}

bool NavigationSDSServiceProxy::hasHandOverSessionStatus() const {
    return _handOverSessionStatus.hasValue();
}

void NavigationSDSServiceProxy::sendHandOverSessionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HandOverSessionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("handOverSessionStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendPositionStatusInfoRegister(PositionStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_positionStatusInfo, "positionStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PositionStatusInfo", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendPositionStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("positionStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PositionStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendPositionStatusInfoGet(PositionStatusInfoCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_positionStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PositionStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("positionStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const PositionStatusInfo& NavigationSDSServiceProxy::getPositionStatusInfo() const {
    return _positionStatusInfo.get().getPositionStatusInfo();
}

bool NavigationSDSServiceProxy::hasPositionStatusInfo() const {
    return _positionStatusInfo.hasValue();
}

void NavigationSDSServiceProxy::sendPositionStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PositionStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("positionStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendPositionInfoRegister(PositionInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_positionInfo, "positionInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PositionInfo", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendPositionInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("positionInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PositionInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendPositionInfoGet(PositionInfoCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_positionInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PositionInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("positionInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const PositionInfo& NavigationSDSServiceProxy::getPositionInfo() const {
    return _positionInfo.get().getPositionInfo();
}

bool NavigationSDSServiceProxy::hasPositionInfo() const {
    return _positionInfo.hasValue();
}

void NavigationSDSServiceProxy::sendPositionInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PositionInfo");
    _dbusProxyDelegate->deregisterSignalCallback("positionInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendSdsAddressWithOptionsRegister(SdsAddressWithOptionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsAddressWithOptions, "sdsAddressWithOptions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsAddressWithOptions", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendSdsAddressWithOptionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsAddressWithOptions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsAddressWithOptions", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendSdsAddressWithOptionsGet(SdsAddressWithOptionsCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_sdsAddressWithOptions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsAddressWithOptions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsAddressWithOptions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SDSAddressWithOptions& NavigationSDSServiceProxy::getSdsAddressWithOptions() const {
    return _sdsAddressWithOptions.get().getSdsAddressWithOptions();
}

bool NavigationSDSServiceProxy::hasSdsAddressWithOptions() const {
    return _sdsAddressWithOptions.hasValue();
}

void NavigationSDSServiceProxy::sendSdsAddressWithOptionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsAddressWithOptions");
    _dbusProxyDelegate->deregisterSignalCallback("sdsAddressWithOptions", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendSdsVoiceTagWithOptionsRegister(SdsVoiceTagWithOptionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsVoiceTagWithOptions, "sdsVoiceTagWithOptions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsVoiceTagWithOptions", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendSdsVoiceTagWithOptionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsVoiceTagWithOptions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsVoiceTagWithOptions", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendSdsVoiceTagWithOptionsGet(SdsVoiceTagWithOptionsCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_sdsVoiceTagWithOptions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsVoiceTagWithOptions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsVoiceTagWithOptions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SDSVoiceTagId& NavigationSDSServiceProxy::getSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptions.get().getSdsVoiceTagWithOptions();
}

bool NavigationSDSServiceProxy::hasSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptions.hasValue();
}

void NavigationSDSServiceProxy::sendSdsVoiceTagWithOptionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsVoiceTagWithOptions");
    _dbusProxyDelegate->deregisterSignalCallback("sdsVoiceTagWithOptions", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendNavDatasetInfoRegister(NavDatasetInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_navDatasetInfo, "navDatasetInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NavDatasetInfo", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendNavDatasetInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("navDatasetInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NavDatasetInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendNavDatasetInfoGet(NavDatasetInfoCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_navDatasetInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NavDatasetInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("navDatasetInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const NavDataSetInfo& NavigationSDSServiceProxy::getNavDatasetInfo() const {
    return _navDatasetInfo.get().getNavDatasetInfo();
}

bool NavigationSDSServiceProxy::hasNavDatasetInfo() const {
    return _navDatasetInfo.hasValue();
}

void NavigationSDSServiceProxy::sendNavDatasetInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NavDatasetInfo");
    _dbusProxyDelegate->deregisterSignalCallback("navDatasetInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageRegister(DynamicMapPoiCategoryWithLanguageCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_dynamicMapPoiCategoryWithLanguage, "dynamicMapPoiCategoryWithLanguage", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguage", &cb, act);
    return act;
}

bool NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("dynamicMapPoiCategoryWithLanguage", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DynamicMapPoiCategoryWithLanguage", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageGet(DynamicMapPoiCategoryWithLanguageCallbackIF& cb) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_dynamicMapPoiCategoryWithLanguage, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguage", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("dynamicMapPoiCategoryWithLanguage", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageSet(const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage) {
    DynamicMapPoiCategoryWithLanguageSet parameter(dynamicMapPoiCategoryWithLanguage);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DynamicMapPoiCategoryWithLanguage");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "dynamicMapPoiCategoryWithLanguage", propertyContent);
}

act_t NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageSet(DynamicMapPoiCategoryWithLanguageCallbackIF& cb, const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage) {
    NavigationSDSServiceProxyCallback* callback = new NavigationSDSServiceProxyCallback(ID_dynamicMapPoiCategoryWithLanguage, &cb);
    DynamicMapPoiCategoryWithLanguageSet parameter(dynamicMapPoiCategoryWithLanguage);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DynamicMapPoiCategoryWithLanguage", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "dynamicMapPoiCategoryWithLanguage", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const DynamicMapPoiCategoriesWithLanguage& NavigationSDSServiceProxy::getDynamicMapPoiCategoryWithLanguage() const {
    return _dynamicMapPoiCategoryWithLanguage.get().getDynamicMapPoiCategoryWithLanguage();
}

bool NavigationSDSServiceProxy::hasDynamicMapPoiCategoryWithLanguage() const {
    return _dynamicMapPoiCategoryWithLanguage.hasValue();
}

void NavigationSDSServiceProxy::sendDynamicMapPoiCategoryWithLanguageDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DynamicMapPoiCategoryWithLanguage");
    _dbusProxyDelegate->deregisterSignalCallback("dynamicMapPoiCategoryWithLanguage", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationSDSServiceProxy::sendGetGlobalDataForSdsRequest(GetGlobalDataForSdsCallbackIF& cb) const {
    GetGlobalDataForSdsRequest* payload = new GetGlobalDataForSdsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getGlobalDataForSds", GetGlobalDataForSdsRequest, payload, true)
    act_t act = addMethodCallback(ID_getGlobalDataForSds, dbusMessage.getUniqueSerial(), "getGlobalDataForSds", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetGlobalDataForSds", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetIdListOfCountryAndSubCountryRequest(GetIdListOfCountryAndSubCountryCallbackIF& cb) const {
    GetIdListOfCountryAndSubCountryRequest* payload = new GetIdListOfCountryAndSubCountryRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getIdListOfCountryAndSubCountry", GetIdListOfCountryAndSubCountryRequest, payload, true)
    act_t act = addMethodCallback(ID_getIdListOfCountryAndSubCountry, dbusMessage.getUniqueSerial(), "getIdListOfCountryAndSubCountry", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetIdListOfCountryAndSubCountry", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetNamesForNDSIdsRequest(GetNamesForNDSIdsCallbackIF& cb, const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList, const ::std::vector< LanguageEntry >& languageEntryList, NDSFeatureType ndsFeatureType, bool stopOnFirstMatch) const {
    GetNamesForNDSIdsRequest* payload = new GetNamesForNDSIdsRequest();
    CHECK_ALLOCATION(payload);
    payload->setGlobalNamedObjectIdList(globalNamedObjectIdList);
    payload->setLanguageEntryList(languageEntryList);
    payload->setNdsFeatureType(ndsFeatureType);
    payload->setStopOnFirstMatch(stopOnFirstMatch);
    DBUS_MESSAGE_CALL(dbusMessage, "getNamesForNDSIds", GetNamesForNDSIdsRequest, payload, true)
    act_t act = addMethodCallback(ID_getNamesForNDSIds, dbusMessage.getUniqueSerial(), "getNamesForNDSIds", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetNamesForNDSIds", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetPhonemesForNDSIdsRequest(GetPhonemesForNDSIdsCallbackIF& cb, const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList, const ::std::vector< LanguageEntry >& languageEntryList, NDSFeatureType ndsFeatureType, bool stopOnFirstMatch) const {
    GetPhonemesForNDSIdsRequest* payload = new GetPhonemesForNDSIdsRequest();
    CHECK_ALLOCATION(payload);
    payload->setGlobalNamedObjectIdList(globalNamedObjectIdList);
    payload->setLanguageEntryList(languageEntryList);
    payload->setNdsFeatureType(ndsFeatureType);
    payload->setStopOnFirstMatch(stopOnFirstMatch);
    DBUS_MESSAGE_CALL(dbusMessage, "getPhonemesForNDSIds", GetPhonemesForNDSIdsRequest, payload, true)
    act_t act = addMethodCallback(ID_getPhonemesForNDSIds, dbusMessage.getUniqueSerial(), "getPhonemesForNDSIds", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetPhonemesForNDSIds", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetCityHasStreetsRequest(GetCityHasStreetsCallbackIF& cb, const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList) const {
    GetCityHasStreetsRequest* payload = new GetCityHasStreetsRequest();
    CHECK_ALLOCATION(payload);
    payload->setGlobalNamedObjectIdList(globalNamedObjectIdList);
    DBUS_MESSAGE_CALL(dbusMessage, "getCityHasStreets", GetCityHasStreetsRequest, payload, true)
    act_t act = addMethodCallback(ID_getCityHasStreets, dbusMessage.getUniqueSerial(), "getCityHasStreets", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetCityHasStreets", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendNdsDatasetReleasedRequest(NdsDatasetReleasedCallbackIF& cb) const {
    NdsDatasetReleasedRequest* payload = new NdsDatasetReleasedRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ndsDatasetReleased", NdsDatasetReleasedRequest, payload, true)
    act_t act = addMethodCallback(ID_ndsDatasetReleased, dbusMessage.getUniqueSerial(), "ndsDatasetReleased", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "NdsDatasetReleased", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetHapticHandOverDataRequest(GetHapticHandOverDataCallbackIF& cb) const {
    GetHapticHandOverDataRequest* payload = new GetHapticHandOverDataRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getHapticHandOverData", GetHapticHandOverDataRequest, payload, true)
    act_t act = addMethodCallback(ID_getHapticHandOverData, dbusMessage.getUniqueSerial(), "getHapticHandOverData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetHapticHandOverData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSelectHapticHandOverListRequest(SelectHapticHandOverListCallbackIF& cb, uint32 index) const {
    SelectHapticHandOverListRequest* payload = new SelectHapticHandOverListRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    DBUS_MESSAGE_CALL(dbusMessage, "selectHapticHandOverList", SelectHapticHandOverListRequest, payload, true)
    act_t act = addMethodCallback(ID_selectHapticHandOverList, dbusMessage.getUniqueSerial(), "selectHapticHandOverList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SelectHapticHandOverList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetDynamicPoiIconCategoriesInMapRequest(GetDynamicPoiIconCategoriesInMapCallbackIF& cb) const {
    GetDynamicPoiIconCategoriesInMapRequest* payload = new GetDynamicPoiIconCategoriesInMapRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getDynamicPoiIconCategoriesInMap", GetDynamicPoiIconCategoriesInMapRequest, payload, true)
    act_t act = addMethodCallback(ID_getDynamicPoiIconCategoriesInMap, dbusMessage.getUniqueSerial(), "getDynamicPoiIconCategoriesInMap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetDynamicPoiIconCategoriesInMap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendGetMaxWaypointCountRequest(GetMaxWaypointCountCallbackIF& cb) const {
    GetMaxWaypointCountRequest* payload = new GetMaxWaypointCountRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getMaxWaypointCount", GetMaxWaypointCountRequest, payload, true)
    act_t act = addMethodCallback(ID_getMaxWaypointCount, dbusMessage.getUniqueSerial(), "getMaxWaypointCount", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetMaxWaypointCount", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSetDynamicPoiIconCategoriesInMapRequest(SetDynamicPoiIconCategoriesInMapCallbackIF& cb, const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory) const {
    SetDynamicPoiIconCategoriesInMapRequest* payload = new SetDynamicPoiIconCategoriesInMapRequest();
    CHECK_ALLOCATION(payload);
    payload->setDynamicMapPoiCategory(dynamicMapPoiCategory);
    DBUS_MESSAGE_CALL(dbusMessage, "setDynamicPoiIconCategoriesInMap", SetDynamicPoiIconCategoriesInMapRequest, payload, true)
    act_t act = addMethodCallback(ID_setDynamicPoiIconCategoriesInMap, dbusMessage.getUniqueSerial(), "setDynamicPoiIconCategoriesInMap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetDynamicPoiIconCategoriesInMap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsCheckAddressRequest(SdsCheckAddressCallbackIF& cb, const ::std::vector< SDSAddressElement >& requestedAddress) const {
    SdsCheckAddressRequest* payload = new SdsCheckAddressRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequestedAddress(requestedAddress);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsCheckAddress", SdsCheckAddressRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsCheckAddress, dbusMessage.getUniqueSerial(), "sdsCheckAddress", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsCheckAddress", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsGetRefinementListRequest(SdsGetRefinementListCallbackIF& cb) const {
    SdsGetRefinementListRequest* payload = new SdsGetRefinementListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsGetRefinementList, dbusMessage.getUniqueSerial(), "sdsGetRefinementList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsGetRefinementList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsUpdateVoiceTagRequest(SdsUpdateVoiceTagCallbackIF& cb, const SDSVoiceTagId& voiceTagID) const {
    SdsUpdateVoiceTagRequest* payload = new SdsUpdateVoiceTagRequest();
    CHECK_ALLOCATION(payload);
    payload->setVoiceTagID(voiceTagID);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsUpdateVoiceTag, dbusMessage.getUniqueSerial(), "sdsUpdateVoiceTag", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsUpdateVoiceTag", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsGetHouseNumberPatternRequest(SdsGetHouseNumberPatternCallbackIF& cb) const {
    SdsGetHouseNumberPatternRequest* payload = new SdsGetHouseNumberPatternRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsGetHouseNumberPattern, dbusMessage.getUniqueSerial(), "sdsGetHouseNumberPattern", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsGetHouseNumberPattern", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSelectSdsRefinementRequest(SelectSdsRefinementCallbackIF& cb, uint32 id) const {
    SelectSdsRefinementRequest* payload = new SelectSdsRefinementRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "selectSdsRefinement", SelectSdsRefinementRequest, payload, true)
    act_t act = addMethodCallback(ID_selectSdsRefinement, dbusMessage.getUniqueSerial(), "selectSdsRefinement", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SelectSdsRefinement", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSetLocationWithSdsInputRequest(SetLocationWithSdsInputCallbackIF& cb) const {
    SetLocationWithSdsInputRequest* payload = new SetLocationWithSdsInputRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithSdsInput, dbusMessage.getUniqueSerial(), "setLocationWithSdsInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithSdsInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendRequestAddressFormatForAvailableCountriesRequest(RequestAddressFormatForAvailableCountriesCallbackIF& cb) const {
    RequestAddressFormatForAvailableCountriesRequest* payload = new RequestAddressFormatForAvailableCountriesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "requestAddressFormatForAvailableCountries", RequestAddressFormatForAvailableCountriesRequest, payload, true)
    act_t act = addMethodCallback(ID_requestAddressFormatForAvailableCountries, dbusMessage.getUniqueSerial(), "requestAddressFormatForAvailableCountries", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestAddressFormatForAvailableCountries", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsShowReachableAreaMapRequest(SdsShowReachableAreaMapCallbackIF& cb, LocationType locationType) const {
    SdsShowReachableAreaMapRequest* payload = new SdsShowReachableAreaMapRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocationType(locationType);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsShowReachableAreaMap", SdsShowReachableAreaMapRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsShowReachableAreaMap, dbusMessage.getUniqueSerial(), "sdsShowReachableAreaMap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsShowReachableAreaMap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsDatasetUserRegistrationRequest(SdsDatasetUserRegistrationCallbackIF& cb, NdsDatasetUser ndsDataSetUser, uint32 datasetId) const {
    SdsDatasetUserRegistrationRequest* payload = new SdsDatasetUserRegistrationRequest();
    CHECK_ALLOCATION(payload);
    payload->setNdsDataSetUser(ndsDataSetUser);
    payload->setDatasetId(datasetId);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsDatasetUserRegistration", SdsDatasetUserRegistrationRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsDatasetUserRegistration, dbusMessage.getUniqueSerial(), "sdsDatasetUserRegistration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsDatasetUserRegistration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendSdsDatasetUserDeregistrationRequest(SdsDatasetUserDeregistrationCallbackIF& cb, NdsDatasetUser ndsDataSetUser, uint32 datasetId) const {
    SdsDatasetUserDeregistrationRequest* payload = new SdsDatasetUserDeregistrationRequest();
    CHECK_ALLOCATION(payload);
    payload->setNdsDataSetUser(ndsDataSetUser);
    payload->setDatasetId(datasetId);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsDatasetUserDeregistration", SdsDatasetUserDeregistrationRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsDatasetUserDeregistration, dbusMessage.getUniqueSerial(), "sdsDatasetUserDeregistration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsDatasetUserDeregistration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationSDSServiceProxy::sendDatasetAccessModeChangedIndicationRequest(DatasetAccessModeChangedIndicationCallbackIF& cb, NdsDatasetUser ndsDataSetUser, uint32 datasetId, NdsDataAccessType ndsDataAccessType) const {
    DatasetAccessModeChangedIndicationRequest* payload = new DatasetAccessModeChangedIndicationRequest();
    CHECK_ALLOCATION(payload);
    payload->setNdsDataSetUser(ndsDataSetUser);
    payload->setDatasetId(datasetId);
    payload->setNdsDataAccessType(ndsDataAccessType);
    DBUS_MESSAGE_CALL(dbusMessage, "datasetAccessModeChangedIndication", DatasetAccessModeChangedIndicationRequest, payload, true)
    act_t act = addMethodCallback(ID_datasetAccessModeChangedIndication, dbusMessage.getUniqueSerial(), "datasetAccessModeChangedIndication", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DatasetAccessModeChangedIndication", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NavigationSDSService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
