/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/bosch/cm/navigation/NavigationSDSService.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of SDSVoiceTagId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint64 o1 = in.getDestinationMemoryEntryId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT64, &o1));
        const char* o2 = in.getDestinationMemoryEntryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o2));
        uint32 o3 = in.getSdsVoiceTagId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o3));
        const ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions  o4 = in.getOptions();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o4));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagId& out) {
    {
        DBusMessageIter o5;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o5);
                {
                    uint64 destinationMemoryEntryIdValue;
                    uint64 &destinationMemoryEntryIdTmpValue = destinationMemoryEntryIdValue;
                    dbus_message_iter_get_basic(&o5, &destinationMemoryEntryIdTmpValue);
                    out.setDestinationMemoryEntryId(destinationMemoryEntryIdValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    ::std::string destinationMemoryEntryNameValue;
                    ::std::string &destinationMemoryEntryNameTmpValue = destinationMemoryEntryNameValue;
                    {
                        char* o6 = 0;
                        dbus_message_iter_get_basic(&o5, &o6);
                        destinationMemoryEntryNameTmpValue.assign (o6);
                    }
                    out.setDestinationMemoryEntryName(destinationMemoryEntryNameValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    uint32 sdsVoiceTagIdValue;
                    uint32 &sdsVoiceTagIdTmpValue = sdsVoiceTagIdValue;
                    dbus_message_iter_get_basic(&o5, &sdsVoiceTagIdTmpValue);
                    out.setSdsVoiceTagId(sdsVoiceTagIdValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions optionsValue = ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions__NONE;
                    dbus_message_iter_get_basic(&o5, &optionsValue);
                    out.setOptions(optionsValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressWithOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressWithOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o7Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o7Struct));
        DBusMessageIter o8ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o7Struct, DBUS_TYPE_ARRAY, "(us(b))", &o8ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >* o9 = &in.getAddress();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >::const_iterator o10 = o9->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >::const_iterator o11 = o9->begin(); o11 != o10; ++o11) {
            serializeDBus((*o11), &o8ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o7Struct, &o8ArrayIter));
        serializeDBus(in.getAddressOptions(), &o7Struct);
        DBusMessageIter o12ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o7Struct, DBUS_TYPE_ARRAY, "u", &o12ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType >* o13 = &in.getAddressElementType();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType >::const_iterator o14 = o13->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType >::const_iterator o15 = o13->begin(); o15 != o14; ++o15) {
            const ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType  o16 = (*o15);
            DBUS_ASSERT(dbus_message_iter_append_basic(&o12ArrayIter, DBUS_TYPE_UINT32, &o16));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o7Struct, &o12ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o7Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressWithOptions& out) {
    {
        DBusMessageIter o17;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o17);
                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement > addressValue;

                    if (dbus_message_iter_get_arg_type(&o17) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o18ArrayIter;
                        dbus_message_iter_recurse (&o17, &o18ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o18ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement o19;
                                if (!deserializeDBus(&o18ArrayIter, o19)) {
                                    return false;
                                }
                                addressValue.push_back(o19);
                            } while (dbus_message_iter_next(&o18ArrayIter));
                        }
                    }
                    out.setAddress(addressValue);
                }

                if (dbus_message_iter_has_next(&o17)) {
                    dbus_message_iter_next(&o17);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressOptions addressOptionsValue;
                    if (!deserializeDBus(&o17, addressOptionsValue)) {
                        return false;
                    }
                    out.setAddressOptions(addressOptionsValue);
                }

                if (dbus_message_iter_has_next(&o17)) {
                    dbus_message_iter_next(&o17);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType > addressElementTypeValue;

                    if (dbus_message_iter_get_arg_type(&o17) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o20ArrayIter;
                        dbus_message_iter_recurse (&o17, &o20ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o20ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType o21 = ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
                                dbus_message_iter_get_basic(&o20ArrayIter, &o21);
                                addressElementTypeValue.push_back(o21);
                            } while (dbus_message_iter_next(&o20ArrayIter));
                        }
                    }
                    out.setAddressElementType(addressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o17)) {
                    dbus_message_iter_next(&o17);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o22Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o22Struct));
        dbus_bool_t o23 = in.getNavigable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o23));
        dbus_bool_t o24 = in.getAmbigious() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o24));
        dbus_bool_t o25 = in.getRemovedInvalidEntry() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o25));
        dbus_bool_t o26 = in.getMoreEntriesPossible() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o26));
        dbus_bool_t o27 = in.getHouseNumberAvailable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o27));
        dbus_bool_t o28 = in.getHouseNumberValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_BOOLEAN, &o28));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o22Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressOptions& out) {
    {
        DBusMessageIter o29;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o29);
                {
                    bool navigableValue;
                    bool &navigableTmpValue = navigableValue;
                    {
                        dbus_bool_t o30;
                        dbus_message_iter_get_basic(&o29, &o30);
                        navigableTmpValue = o30 ? true : false;
                    }
                    out.setNavigable(navigableValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    bool ambigiousValue;
                    bool &ambigiousTmpValue = ambigiousValue;
                    {
                        dbus_bool_t o31;
                        dbus_message_iter_get_basic(&o29, &o31);
                        ambigiousTmpValue = o31 ? true : false;
                    }
                    out.setAmbigious(ambigiousValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    bool removedInvalidEntryValue;
                    bool &removedInvalidEntryTmpValue = removedInvalidEntryValue;
                    {
                        dbus_bool_t o32;
                        dbus_message_iter_get_basic(&o29, &o32);
                        removedInvalidEntryTmpValue = o32 ? true : false;
                    }
                    out.setRemovedInvalidEntry(removedInvalidEntryValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    bool moreEntriesPossibleValue;
                    bool &moreEntriesPossibleTmpValue = moreEntriesPossibleValue;
                    {
                        dbus_bool_t o33;
                        dbus_message_iter_get_basic(&o29, &o33);
                        moreEntriesPossibleTmpValue = o33 ? true : false;
                    }
                    out.setMoreEntriesPossible(moreEntriesPossibleValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    bool houseNumberAvailableValue;
                    bool &houseNumberAvailableTmpValue = houseNumberAvailableValue;
                    {
                        dbus_bool_t o34;
                        dbus_message_iter_get_basic(&o29, &o34);
                        houseNumberAvailableTmpValue = o34 ? true : false;
                    }
                    out.setHouseNumberAvailable(houseNumberAvailableValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

                {
                    bool houseNumberValidValue;
                    bool &houseNumberValidTmpValue = houseNumberValidValue;
                    {
                        dbus_bool_t o35;
                        dbus_message_iter_get_basic(&o29, &o35);
                        houseNumberValidTmpValue = o35 ? true : false;
                    }
                    out.setHouseNumberValid(houseNumberValidValue);
                }

                if (dbus_message_iter_has_next(&o29)) {
                    dbus_message_iter_next(&o29);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o36Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o36Struct));
        const ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType  o37 = in.getAddressElementType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_UINT32, &o37));
        const char* o38 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_STRING, &o38));
        serializeDBus(in.getElementOptions(), &o36Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o36Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement& out) {
    {
        DBusMessageIter o39;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o39);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType addressElementTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
                    dbus_message_iter_get_basic(&o39, &addressElementTypeValue);
                    out.setAddressElementType(addressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o40 = 0;
                        dbus_message_iter_get_basic(&o39, &o40);
                        dataTmpValue.assign (o40);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSElementOptions elementOptionsValue;
                    if (!deserializeDBus(&o39, elementOptionsValue)) {
                        return false;
                    }
                    out.setElementOptions(elementOptionsValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSElementOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSElementOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o41Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o41Struct));
        dbus_bool_t o42 = in.getIsAmbigious() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o41Struct, DBUS_TYPE_BOOLEAN, &o42));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o41Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSElementOptions& out) {
    {
        DBusMessageIter o43;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o43);
                {
                    bool isAmbigiousValue;
                    bool &isAmbigiousTmpValue = isAmbigiousValue;
                    {
                        dbus_bool_t o44;
                        dbus_message_iter_get_basic(&o43, &o44);
                        isAmbigiousTmpValue = o44 ? true : false;
                    }
                    out.setIsAmbigious(isAmbigiousValue);
                }

                if (dbus_message_iter_has_next(&o43)) {
                    dbus_message_iter_next(&o43);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of RefinementListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o45Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o45Struct));
        const char* o46 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_STRING, &o46));
        uint32 o47 = in.getId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_UINT32, &o47));
        const char* o48 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_STRING, &o48));
        const ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription  o49 = in.getDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_UINT32, &o49));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o45Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement& out) {
    {
        DBusMessageIter o50;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o50);
                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o51 = 0;
                        dbus_message_iter_get_basic(&o50, &o51);
                        dataTmpValue.assign (o51);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o50)) {
                    dbus_message_iter_next(&o50);
                } else {
                    return true;
                }

                {
                    uint32 idValue;
                    uint32 &idTmpValue = idValue;
                    dbus_message_iter_get_basic(&o50, &idTmpValue);
                    out.setId(idValue);
                }

                if (dbus_message_iter_has_next(&o50)) {
                    dbus_message_iter_next(&o50);
                } else {
                    return true;
                }

                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o52 = 0;
                        dbus_message_iter_get_basic(&o50, &o52);
                        distanceTmpValue.assign (o52);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o50)) {
                    dbus_message_iter_next(&o50);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription directionValue = ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH;
                    dbus_message_iter_get_basic(&o50, &directionValue);
                    out.setDirection(directionValue);
                }

                if (dbus_message_iter_has_next(&o50)) {
                    dbus_message_iter_next(&o50);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of AddressListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o53Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o53Struct));
        const char* o54 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_STRING, &o54));
        uint64 o55 = in.getId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_UINT64, &o55));
        const char* o56 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_STRING, &o56));
        const char* o57 = in.getAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_STRING, &o57));
        const ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription  o58 = in.getDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_UINT32, &o58));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o53Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement& out) {
    {
        DBusMessageIter o59;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o59);
                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o60 = 0;
                        dbus_message_iter_get_basic(&o59, &o60);
                        dataTmpValue.assign (o60);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o59)) {
                    dbus_message_iter_next(&o59);
                } else {
                    return true;
                }

                {
                    uint64 idValue;
                    uint64 &idTmpValue = idValue;
                    dbus_message_iter_get_basic(&o59, &idTmpValue);
                    out.setId(idValue);
                }

                if (dbus_message_iter_has_next(&o59)) {
                    dbus_message_iter_next(&o59);
                } else {
                    return true;
                }

                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o61 = 0;
                        dbus_message_iter_get_basic(&o59, &o61);
                        distanceTmpValue.assign (o61);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o59)) {
                    dbus_message_iter_next(&o59);
                } else {
                    return true;
                }

                {
                    ::std::string addressValue;
                    ::std::string &addressTmpValue = addressValue;
                    {
                        char* o62 = 0;
                        dbus_message_iter_get_basic(&o59, &o62);
                        addressTmpValue.assign (o62);
                    }
                    out.setAddress(addressValue);
                }

                if (dbus_message_iter_has_next(&o59)) {
                    dbus_message_iter_next(&o59);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription directionValue = ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH;
                    dbus_message_iter_get_basic(&o59, &directionValue);
                    out.setDirection(directionValue);
                }

                if (dbus_message_iter_has_next(&o59)) {
                    dbus_message_iter_next(&o59);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SdsProducts

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts& in, DBusMessageIter* out) {
    {
        DBusMessageIter o63Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o63Struct));
        uint8 o64 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o63Struct, DBUS_TYPE_BYTE, &o64));
        uint32 o65 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o63Struct, DBUS_TYPE_UINT32, &o65));
        DBusMessageIter o66ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o63Struct, DBUS_TYPE_ARRAY, "(qa(qusu(bb(ua(qs))(ua(qs)))yu)a(qss))", &o66ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions >* o67 = &in.getSdsUpdateRegionsList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions >::const_iterator o68 = o67->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions >::const_iterator o69 = o67->begin(); o69 != o68; ++o69) {
            serializeDBus((*o69), &o66ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o63Struct, &o66ArrayIter));
        DBusMessageIter o70ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o63Struct, DBUS_TYPE_ARRAY, "(qsss(sss)qq)", &o70ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages >* o71 = &in.getSdsLanguagesList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages >::const_iterator o72 = o71->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages >::const_iterator o73 = o71->begin(); o73 != o72; ++o73) {
            serializeDBus((*o73), &o70ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o63Struct, &o70ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o63Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts& out) {
    {
        DBusMessageIter o74;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o74);
                {
                    uint8 supplierIdValue;
                    uint8 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o74, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o74)) {
                    dbus_message_iter_next(&o74);
                } else {
                    return true;
                }

                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o74, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o74)) {
                    dbus_message_iter_next(&o74);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions > sdsUpdateRegionsListValue;

                    if (dbus_message_iter_get_arg_type(&o74) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o75ArrayIter;
                        dbus_message_iter_recurse (&o74, &o75ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o75ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions o76;
                                if (!deserializeDBus(&o75ArrayIter, o76)) {
                                    return false;
                                }
                                sdsUpdateRegionsListValue.push_back(o76);
                            } while (dbus_message_iter_next(&o75ArrayIter));
                        }
                    }
                    out.setSdsUpdateRegionsList(sdsUpdateRegionsListValue);
                }

                if (dbus_message_iter_has_next(&o74)) {
                    dbus_message_iter_next(&o74);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages > sdsLanguagesListValue;

                    if (dbus_message_iter_get_arg_type(&o74) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o77ArrayIter;
                        dbus_message_iter_recurse (&o74, &o77ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o77ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages o78;
                                if (!deserializeDBus(&o77ArrayIter, o78)) {
                                    return false;
                                }
                                sdsLanguagesListValue.push_back(o78);
                            } while (dbus_message_iter_next(&o77ArrayIter));
                        }
                    }
                    out.setSdsLanguagesList(sdsLanguagesListValue);
                }

                if (dbus_message_iter_has_next(&o74)) {
                    dbus_message_iter_next(&o74);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SdsUpdateRegions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o79Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o79Struct));
        uint16 o80 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o79Struct, DBUS_TYPE_UINT16, &o80));
        DBusMessageIter o81ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o79Struct, DBUS_TYPE_ARRAY, "(qusu(bb(ua(qs))(ua(qs)))yu)", &o81ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks >* o82 = &in.getSdsBuildingBlocksList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks >::const_iterator o83 = o82->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks >::const_iterator o84 = o82->begin(); o84 != o83; ++o84) {
            serializeDBus((*o84), &o81ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o79Struct, &o81ArrayIter));
        DBusMessageIter o85ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o79Struct, DBUS_TYPE_ARRAY, "(qss)", &o85ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata >* o86 = &in.getSdsRegionMetadataList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata >::const_iterator o87 = o86->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata >::const_iterator o88 = o86->begin(); o88 != o87; ++o88) {
            serializeDBus((*o88), &o85ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o79Struct, &o85ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o79Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions& out) {
    {
        DBusMessageIter o89;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o89);
                {
                    uint16 updateRegionIdValue;
                    uint16 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o89, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o89)) {
                    dbus_message_iter_next(&o89);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks > sdsBuildingBlocksListValue;

                    if (dbus_message_iter_get_arg_type(&o89) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o90ArrayIter;
                        dbus_message_iter_recurse (&o89, &o90ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o90ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks o91;
                                if (!deserializeDBus(&o90ArrayIter, o91)) {
                                    return false;
                                }
                                sdsBuildingBlocksListValue.push_back(o91);
                            } while (dbus_message_iter_next(&o90ArrayIter));
                        }
                    }
                    out.setSdsBuildingBlocksList(sdsBuildingBlocksListValue);
                }

                if (dbus_message_iter_has_next(&o89)) {
                    dbus_message_iter_next(&o89);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata > sdsRegionMetadataListValue;

                    if (dbus_message_iter_get_arg_type(&o89) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o92ArrayIter;
                        dbus_message_iter_recurse (&o89, &o92ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o92ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata o93;
                                if (!deserializeDBus(&o92ArrayIter, o93)) {
                                    return false;
                                }
                                sdsRegionMetadataListValue.push_back(o93);
                            } while (dbus_message_iter_next(&o92ArrayIter));
                        }
                    }
                    out.setSdsRegionMetadataList(sdsRegionMetadataListValue);
                }

                if (dbus_message_iter_has_next(&o89)) {
                    dbus_message_iter_next(&o89);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SdsBuildingBlocks

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks& in, DBusMessageIter* out) {
    {
        DBusMessageIter o94Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o94Struct));
        uint16 o95 = in.getBuildingBlockId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_UINT16, &o95));
        const ::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType  o96 = in.getNdsBuildingBlockType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_UINT32, &o96));
        const char* o97 = in.getUri().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_STRING, &o97));
        uint32 o98 = in.getEncryptionKeyId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_UINT32, &o98));
        serializeDBus(in.getSpeechMetadata(), &o94Struct);
        uint8 o99 = in.getTypeNdsDbSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_BYTE, &o99));
        uint32 o100 = in.getTypeExtId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_UINT32, &o100));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o94Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks& out) {
    {
        DBusMessageIter o101;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o101);
                {
                    uint16 buildingBlockIdValue;
                    uint16 &buildingBlockIdTmpValue = buildingBlockIdValue;
                    dbus_message_iter_get_basic(&o101, &buildingBlockIdTmpValue);
                    out.setBuildingBlockId(buildingBlockIdValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType ndsBuildingBlockTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType__SPEECH;
                    dbus_message_iter_get_basic(&o101, &ndsBuildingBlockTypeValue);
                    out.setNdsBuildingBlockType(ndsBuildingBlockTypeValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::std::string uriValue;
                    ::std::string &uriTmpValue = uriValue;
                    {
                        char* o102 = 0;
                        dbus_message_iter_get_basic(&o101, &o102);
                        uriTmpValue.assign (o102);
                    }
                    out.setUri(uriValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    uint32 encryptionKeyIdValue;
                    uint32 &encryptionKeyIdTmpValue = encryptionKeyIdValue;
                    dbus_message_iter_get_basic(&o101, &encryptionKeyIdTmpValue);
                    out.setEncryptionKeyId(encryptionKeyIdValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SpeechMetadata speechMetadataValue;
                    if (!deserializeDBus(&o101, speechMetadataValue)) {
                        return false;
                    }
                    out.setSpeechMetadata(speechMetadataValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    uint8 typeNdsDbSupplierIdValue;
                    uint8 &typeNdsDbSupplierIdTmpValue = typeNdsDbSupplierIdValue;
                    dbus_message_iter_get_basic(&o101, &typeNdsDbSupplierIdTmpValue);
                    out.setTypeNdsDbSupplierId(typeNdsDbSupplierIdValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    uint32 typeExtIdValue;
                    uint32 &typeExtIdTmpValue = typeExtIdValue;
                    dbus_message_iter_get_basic(&o101, &typeExtIdTmpValue);
                    out.setTypeExtId(typeExtIdValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SdsRegionMetadata

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata& in, DBusMessageIter* out) {
    {
        DBusMessageIter o103Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o103Struct));
        uint16 o104 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_UINT16, &o104));
        const char* o105 = in.getIsoCountryCodeText().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_STRING, &o105));
        const char* o106 = in.getIsoSubCountryCodeText().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_STRING, &o106));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o103Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata& out) {
    {
        DBusMessageIter o107;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o107);
                {
                    uint16 updateRegionIdValue;
                    uint16 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o107, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

                {
                    ::std::string isoCountryCodeTextValue;
                    ::std::string &isoCountryCodeTextTmpValue = isoCountryCodeTextValue;
                    {
                        char* o108 = 0;
                        dbus_message_iter_get_basic(&o107, &o108);
                        isoCountryCodeTextTmpValue.assign (o108);
                    }
                    out.setIsoCountryCodeText(isoCountryCodeTextValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

                {
                    ::std::string isoSubCountryCodeTextValue;
                    ::std::string &isoSubCountryCodeTextTmpValue = isoSubCountryCodeTextValue;
                    {
                        char* o109 = 0;
                        dbus_message_iter_get_basic(&o107, &o109);
                        isoSubCountryCodeTextTmpValue.assign (o109);
                    }
                    out.setIsoSubCountryCodeText(isoSubCountryCodeTextValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SpeechMetadata

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SpeechMetadata& in, DBusMessageIter* out) {
    {
        DBusMessageIter o110Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o110Struct));
        dbus_bool_t o111 = in.getHasPhonetic() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o110Struct, DBUS_TYPE_BOOLEAN, &o111));
        dbus_bool_t o112 = in.getHasPrerecorded() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o110Struct, DBUS_TYPE_BOOLEAN, &o112));
        serializeDBus(in.getPhoneticTraMetadata(), &o110Struct);
        serializeDBus(in.getPrerecordedVMetadata(), &o110Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o110Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SpeechMetadata& out) {
    {
        DBusMessageIter o113;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o113);
                {
                    bool hasPhoneticValue;
                    bool &hasPhoneticTmpValue = hasPhoneticValue;
                    {
                        dbus_bool_t o114;
                        dbus_message_iter_get_basic(&o113, &o114);
                        hasPhoneticTmpValue = o114 ? true : false;
                    }
                    out.setHasPhonetic(hasPhoneticValue);
                }

                if (dbus_message_iter_has_next(&o113)) {
                    dbus_message_iter_next(&o113);
                } else {
                    return true;
                }

                {
                    bool hasPrerecordedValue;
                    bool &hasPrerecordedTmpValue = hasPrerecordedValue;
                    {
                        dbus_bool_t o115;
                        dbus_message_iter_get_basic(&o113, &o115);
                        hasPrerecordedTmpValue = o115 ? true : false;
                    }
                    out.setHasPrerecorded(hasPrerecordedValue);
                }

                if (dbus_message_iter_has_next(&o113)) {
                    dbus_message_iter_next(&o113);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTraMetadata phoneticTraMetadataValue;
                    if (!deserializeDBus(&o113, phoneticTraMetadataValue)) {
                        return false;
                    }
                    out.setPhoneticTraMetadata(phoneticTraMetadataValue);
                }

                if (dbus_message_iter_has_next(&o113)) {
                    dbus_message_iter_next(&o113);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVMetadata prerecordedVMetadataValue;
                    if (!deserializeDBus(&o113, prerecordedVMetadataValue)) {
                        return false;
                    }
                    out.setPrerecordedVMetadata(prerecordedVMetadataValue);
                }

                if (dbus_message_iter_has_next(&o113)) {
                    dbus_message_iter_next(&o113);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PhoneticTraMetadata

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTraMetadata& in, DBusMessageIter* out) {
    {
        DBusMessageIter o116Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o116Struct));
        const ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat  o117 = in.getPhoneticTranscriptionFormat();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o116Struct, DBUS_TYPE_UINT32, &o117));
        DBusMessageIter o118ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o116Struct, DBUS_TYPE_ARRAY, "(qs)", &o118ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >* o119 = &in.getLanguageVersionList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >::const_iterator o120 = o119->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >::const_iterator o121 = o119->begin(); o121 != o120; ++o121) {
            serializeDBus((*o121), &o118ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o116Struct, &o118ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o116Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTraMetadata& out) {
    {
        DBusMessageIter o122;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o122);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat phoneticTranscriptionFormatValue = ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA;
                    dbus_message_iter_get_basic(&o122, &phoneticTranscriptionFormatValue);
                    out.setPhoneticTranscriptionFormat(phoneticTranscriptionFormatValue);
                }

                if (dbus_message_iter_has_next(&o122)) {
                    dbus_message_iter_next(&o122);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion > languageVersionListValue;

                    if (dbus_message_iter_get_arg_type(&o122) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o123ArrayIter;
                        dbus_message_iter_recurse (&o122, &o123ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o123ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion o124;
                                if (!deserializeDBus(&o123ArrayIter, o124)) {
                                    return false;
                                }
                                languageVersionListValue.push_back(o124);
                            } while (dbus_message_iter_next(&o123ArrayIter));
                        }
                    }
                    out.setLanguageVersionList(languageVersionListValue);
                }

                if (dbus_message_iter_has_next(&o122)) {
                    dbus_message_iter_next(&o122);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of LanguageVersion

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion& in, DBusMessageIter* out) {
    {
        DBusMessageIter o125Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o125Struct));
        uint16 o126 = in.getLanguageCode();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o125Struct, DBUS_TYPE_UINT16, &o126));
        const char* o127 = in.getSpecificationVersion().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o125Struct, DBUS_TYPE_STRING, &o127));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o125Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion& out) {
    {
        DBusMessageIter o128;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o128);
                {
                    uint16 languageCodeValue;
                    uint16 &languageCodeTmpValue = languageCodeValue;
                    dbus_message_iter_get_basic(&o128, &languageCodeTmpValue);
                    out.setLanguageCode(languageCodeValue);
                }

                if (dbus_message_iter_has_next(&o128)) {
                    dbus_message_iter_next(&o128);
                } else {
                    return true;
                }

                {
                    ::std::string specificationVersionValue;
                    ::std::string &specificationVersionTmpValue = specificationVersionValue;
                    {
                        char* o129 = 0;
                        dbus_message_iter_get_basic(&o128, &o129);
                        specificationVersionTmpValue.assign (o129);
                    }
                    out.setSpecificationVersion(specificationVersionValue);
                }

                if (dbus_message_iter_has_next(&o128)) {
                    dbus_message_iter_next(&o128);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PrerecordedVMetadata

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVMetadata& in, DBusMessageIter* out) {
    {
        DBusMessageIter o130Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o130Struct));
        const ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat  o131 = in.getPrerecordedVoiceFormat();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o130Struct, DBUS_TYPE_UINT32, &o131));
        DBusMessageIter o132ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o130Struct, DBUS_TYPE_ARRAY, "(qs)", &o132ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >* o133 = &in.getLanguageVersionList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >::const_iterator o134 = o133->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion >::const_iterator o135 = o133->begin(); o135 != o134; ++o135) {
            serializeDBus((*o135), &o132ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o130Struct, &o132ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o130Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVMetadata& out) {
    {
        DBusMessageIter o136;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o136);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat prerecordedVoiceFormatValue = ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat__ADPCM;
                    dbus_message_iter_get_basic(&o136, &prerecordedVoiceFormatValue);
                    out.setPrerecordedVoiceFormat(prerecordedVoiceFormatValue);
                }

                if (dbus_message_iter_has_next(&o136)) {
                    dbus_message_iter_next(&o136);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion > languageVersionListValue;

                    if (dbus_message_iter_get_arg_type(&o136) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o137ArrayIter;
                        dbus_message_iter_recurse (&o136, &o137ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o137ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::LanguageVersion o138;
                                if (!deserializeDBus(&o137ArrayIter, o138)) {
                                    return false;
                                }
                                languageVersionListValue.push_back(o138);
                            } while (dbus_message_iter_next(&o137ArrayIter));
                        }
                    }
                    out.setLanguageVersionList(languageVersionListValue);
                }

                if (dbus_message_iter_has_next(&o136)) {
                    dbus_message_iter_next(&o136);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SdsLanguages

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages& in, DBusMessageIter* out) {
    {
        DBusMessageIter o139Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o139Struct));
        uint16 o140 = in.getLanguageCode();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_UINT16, &o140));
        const char* o141 = in.getIsoCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_STRING, &o141));
        const char* o142 = in.getIsoLanguageCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_STRING, &o142));
        const char* o143 = in.getIsoScriptCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_STRING, &o143));
        serializeDBus(in.getLanguageEntry(), &o139Struct);
        uint16 o144 = in.getIsTransliterationOf();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_UINT16, &o144));
        uint16 o145 = in.getIsDiacriticTransliterationOf();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o139Struct, DBUS_TYPE_UINT16, &o145));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o139Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsLanguages& out) {
    {
        DBusMessageIter o146;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o146);
                {
                    uint16 languageCodeValue;
                    uint16 &languageCodeTmpValue = languageCodeValue;
                    dbus_message_iter_get_basic(&o146, &languageCodeTmpValue);
                    out.setLanguageCode(languageCodeValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    ::std::string isoCountryCodeValue;
                    ::std::string &isoCountryCodeTmpValue = isoCountryCodeValue;
                    {
                        char* o147 = 0;
                        dbus_message_iter_get_basic(&o146, &o147);
                        isoCountryCodeTmpValue.assign (o147);
                    }
                    out.setIsoCountryCode(isoCountryCodeValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    ::std::string isoLanguageCodeValue;
                    ::std::string &isoLanguageCodeTmpValue = isoLanguageCodeValue;
                    {
                        char* o148 = 0;
                        dbus_message_iter_get_basic(&o146, &o148);
                        isoLanguageCodeTmpValue.assign (o148);
                    }
                    out.setIsoLanguageCode(isoLanguageCodeValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    ::std::string isoScriptCodeValue;
                    ::std::string &isoScriptCodeTmpValue = isoScriptCodeValue;
                    {
                        char* o149 = 0;
                        dbus_message_iter_get_basic(&o146, &o149);
                        isoScriptCodeTmpValue.assign (o149);
                    }
                    out.setIsoScriptCode(isoScriptCodeValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry languageEntryValue;
                    if (!deserializeDBus(&o146, languageEntryValue)) {
                        return false;
                    }
                    out.setLanguageEntry(languageEntryValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    uint16 isTransliterationOfValue;
                    uint16 &isTransliterationOfTmpValue = isTransliterationOfValue;
                    dbus_message_iter_get_basic(&o146, &isTransliterationOfTmpValue);
                    out.setIsTransliterationOf(isTransliterationOfValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

                {
                    uint16 isDiacriticTransliterationOfValue;
                    uint16 &isDiacriticTransliterationOfTmpValue = isDiacriticTransliterationOfValue;
                    dbus_message_iter_get_basic(&o146, &isDiacriticTransliterationOfTmpValue);
                    out.setIsDiacriticTransliterationOf(isDiacriticTransliterationOfValue);
                }

                if (dbus_message_iter_has_next(&o146)) {
                    dbus_message_iter_next(&o146);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of LanguageEntry

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry& in, DBusMessageIter* out) {
    {
        DBusMessageIter o150Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o150Struct));
        const char* o151 = in.getISOLanguageCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o150Struct, DBUS_TYPE_STRING, &o151));
        const char* o152 = in.getISOCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o150Struct, DBUS_TYPE_STRING, &o152));
        const char* o153 = in.getTranscriptCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o150Struct, DBUS_TYPE_STRING, &o153));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o150Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry& out) {
    {
        DBusMessageIter o154;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o154);
                {
                    ::std::string iSOLanguageCodeValue;
                    ::std::string &iSOLanguageCodeTmpValue = iSOLanguageCodeValue;
                    {
                        char* o155 = 0;
                        dbus_message_iter_get_basic(&o154, &o155);
                        iSOLanguageCodeTmpValue.assign (o155);
                    }
                    out.setISOLanguageCode(iSOLanguageCodeValue);
                }

                if (dbus_message_iter_has_next(&o154)) {
                    dbus_message_iter_next(&o154);
                } else {
                    return true;
                }

                {
                    ::std::string iSOCountryCodeValue;
                    ::std::string &iSOCountryCodeTmpValue = iSOCountryCodeValue;
                    {
                        char* o156 = 0;
                        dbus_message_iter_get_basic(&o154, &o156);
                        iSOCountryCodeTmpValue.assign (o156);
                    }
                    out.setISOCountryCode(iSOCountryCodeValue);
                }

                if (dbus_message_iter_has_next(&o154)) {
                    dbus_message_iter_next(&o154);
                } else {
                    return true;
                }

                {
                    ::std::string transcriptCodeValue;
                    ::std::string &transcriptCodeTmpValue = transcriptCodeValue;
                    {
                        char* o157 = 0;
                        dbus_message_iter_get_basic(&o154, &o157);
                        transcriptCodeTmpValue.assign (o157);
                    }
                    out.setTranscriptCode(transcriptCodeValue);
                }

                if (dbus_message_iter_has_next(&o154)) {
                    dbus_message_iter_next(&o154);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GlobalNamedObjectId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o158Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o158Struct));
        serializeDBus(in.getGlobalUpdateRegionId(), &o158Struct);
        uint32 o159 = in.getNamedObjectId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o158Struct, DBUS_TYPE_UINT32, &o159));
        dbus_bool_t o160 = in.getIsValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o158Struct, DBUS_TYPE_BOOLEAN, &o160));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o158Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId& out) {
    {
        DBusMessageIter o161;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o161);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalUpdateRegionId globalUpdateRegionIdValue;
                    if (!deserializeDBus(&o161, globalUpdateRegionIdValue)) {
                        return false;
                    }
                    out.setGlobalUpdateRegionId(globalUpdateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o161)) {
                    dbus_message_iter_next(&o161);
                } else {
                    return true;
                }

                {
                    uint32 namedObjectIdValue;
                    uint32 &namedObjectIdTmpValue = namedObjectIdValue;
                    dbus_message_iter_get_basic(&o161, &namedObjectIdTmpValue);
                    out.setNamedObjectId(namedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o161)) {
                    dbus_message_iter_next(&o161);
                } else {
                    return true;
                }

                {
                    bool isValidValue;
                    bool &isValidTmpValue = isValidValue;
                    {
                        dbus_bool_t o162;
                        dbus_message_iter_get_basic(&o161, &o162);
                        isValidTmpValue = o162 ? true : false;
                    }
                    out.setIsValid(isValidValue);
                }

                if (dbus_message_iter_has_next(&o161)) {
                    dbus_message_iter_next(&o161);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GlobalNamedObjectAndRegionId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o163Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o163Struct));
        serializeDBus(in.getGlobalUpdateRegionId(), &o163Struct);
        uint32 o164 = in.getNamedObjectId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o163Struct, DBUS_TYPE_UINT32, &o164));
        uint64 o165 = in.getPoiRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o163Struct, DBUS_TYPE_UINT64, &o165));
        uint32 o166 = in.getGlobalXrefID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o163Struct, DBUS_TYPE_UINT32, &o166));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o163Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId& out) {
    {
        DBusMessageIter o167;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o167);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalUpdateRegionId globalUpdateRegionIdValue;
                    if (!deserializeDBus(&o167, globalUpdateRegionIdValue)) {
                        return false;
                    }
                    out.setGlobalUpdateRegionId(globalUpdateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o167)) {
                    dbus_message_iter_next(&o167);
                } else {
                    return true;
                }

                {
                    uint32 namedObjectIdValue;
                    uint32 &namedObjectIdTmpValue = namedObjectIdValue;
                    dbus_message_iter_get_basic(&o167, &namedObjectIdTmpValue);
                    out.setNamedObjectId(namedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o167)) {
                    dbus_message_iter_next(&o167);
                } else {
                    return true;
                }

                {
                    uint64 poiRegionIdValue;
                    uint64 &poiRegionIdTmpValue = poiRegionIdValue;
                    dbus_message_iter_get_basic(&o167, &poiRegionIdTmpValue);
                    out.setPoiRegionId(poiRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o167)) {
                    dbus_message_iter_next(&o167);
                } else {
                    return true;
                }

                {
                    uint32 globalXrefIDValue;
                    uint32 &globalXrefIDTmpValue = globalXrefIDValue;
                    dbus_message_iter_get_basic(&o167, &globalXrefIDTmpValue);
                    out.setGlobalXrefID(globalXrefIDValue);
                }

                if (dbus_message_iter_has_next(&o167)) {
                    dbus_message_iter_next(&o167);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GlobalUpdateRegionId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GlobalUpdateRegionId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o168Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o168Struct));
        int16 o169 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o168Struct, DBUS_TYPE_INT16, &o169));
        int32 o170 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o168Struct, DBUS_TYPE_INT32, &o170));
        int16 o171 = in.getSupplierId();
        int16 o172 = o171;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o168Struct, DBUS_TYPE_INT16, &o172));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o168Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GlobalUpdateRegionId& out) {
    {
        DBusMessageIter o173;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o173);
                {
                    int16 updateRegionIdValue;
                    int16 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o173, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o173)) {
                    dbus_message_iter_next(&o173);
                } else {
                    return true;
                }

                {
                    int32 productIdValue;
                    int32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o173, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o173)) {
                    dbus_message_iter_next(&o173);
                } else {
                    return true;
                }

                {
                    int16 supplierIdValue;
                    int16 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o173, &supplierIdTmpValue);
                    out.setSupplierId(static_cast<int8>(supplierIdValue));
                }

                if (dbus_message_iter_has_next(&o173)) {
                    dbus_message_iter_next(&o173);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SubCountryIds

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds& in, DBusMessageIter* out) {
    {
        DBusMessageIter o174Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o174Struct));
        serializeDBus(in.getCountryId(), &o174Struct);
        DBusMessageIter o175ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o174Struct, DBUS_TYPE_ARRAY, "((nin)utu)", &o175ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >* o176 = &in.getSubCountryIdList();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >::const_iterator o177 = o176->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >::const_iterator o178 = o176->begin(); o178 != o177; ++o178) {
            serializeDBus((*o178), &o175ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o174Struct, &o175ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o174Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds& out) {
    {
        DBusMessageIter o179;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o179);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId countryIdValue;
                    if (!deserializeDBus(&o179, countryIdValue)) {
                        return false;
                    }
                    out.setCountryId(countryIdValue);
                }

                if (dbus_message_iter_has_next(&o179)) {
                    dbus_message_iter_next(&o179);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > subCountryIdListValue;

                    if (dbus_message_iter_get_arg_type(&o179) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o180ArrayIter;
                        dbus_message_iter_recurse (&o179, &o180ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o180ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId o181;
                                if (!deserializeDBus(&o180ArrayIter, o181)) {
                                    return false;
                                }
                                subCountryIdListValue.push_back(o181);
                            } while (dbus_message_iter_next(&o180ArrayIter));
                        }
                    }
                    out.setSubCountryIdList(subCountryIdListValue);
                }

                if (dbus_message_iter_has_next(&o179)) {
                    dbus_message_iter_next(&o179);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NamedObjectIdStrings

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings& in, DBusMessageIter* out) {
    {
        DBusMessageIter o182Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o182Struct));
        serializeDBus(in.getGlobalNamedObjectId(), &o182Struct);
        serializeDBus(in.getLanguageEntry(), &o182Struct);
        DBusMessageIter o183ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o182Struct, DBUS_TYPE_ARRAY, "s", &o183ArrayIter));
        const ::std::vector< ::std::string >* o184 = &in.getSdsNamedStringsList();
        ::std::vector< ::std::string >::const_iterator o185 = o184->end();
        for (::std::vector< ::std::string >::const_iterator o186 = o184->begin(); o186 != o185; ++o186) {
            const char* o187 = (*o186).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o183ArrayIter, DBUS_TYPE_STRING, &o187));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o182Struct, &o183ArrayIter));
        const ::org::bosch::cm::navigation::NavigationSDSService::AddressElementType  o188 = in.getAddressElementType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o182Struct, DBUS_TYPE_UINT32, &o188));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o182Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings& out) {
    {
        DBusMessageIter o189;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o189);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId globalNamedObjectIdValue;
                    if (!deserializeDBus(&o189, globalNamedObjectIdValue)) {
                        return false;
                    }
                    out.setGlobalNamedObjectId(globalNamedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o189)) {
                    dbus_message_iter_next(&o189);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry languageEntryValue;
                    if (!deserializeDBus(&o189, languageEntryValue)) {
                        return false;
                    }
                    out.setLanguageEntry(languageEntryValue);
                }

                if (dbus_message_iter_has_next(&o189)) {
                    dbus_message_iter_next(&o189);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > sdsNamedStringsListValue;

                    if (dbus_message_iter_get_arg_type(&o189) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o190ArrayIter;
                        dbus_message_iter_recurse (&o189, &o190ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o190ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o191;
                                {
                                    char* o192 = 0;
                                    dbus_message_iter_get_basic(&o190ArrayIter, &o192);
                                    o191.assign (o192);
                                }
                                sdsNamedStringsListValue.push_back(o191);
                            } while (dbus_message_iter_next(&o190ArrayIter));
                        }
                    }
                    out.setSdsNamedStringsList(sdsNamedStringsListValue);
                }

                if (dbus_message_iter_has_next(&o189)) {
                    dbus_message_iter_next(&o189);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::AddressElementType addressElementTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::AddressElementType__COUNTRY;
                    dbus_message_iter_get_basic(&o189, &addressElementTypeValue);
                    out.setAddressElementType(addressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o189)) {
                    dbus_message_iter_next(&o189);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CityNamedObjectIdHasStreets

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets& in, DBusMessageIter* out) {
    {
        DBusMessageIter o193Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o193Struct));
        serializeDBus(in.getGlobalNamedObjectId(), &o193Struct);
        dbus_bool_t o194 = in.getHasStreets() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o193Struct, DBUS_TYPE_BOOLEAN, &o194));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o193Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets& out) {
    {
        DBusMessageIter o195;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o195);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId globalNamedObjectIdValue;
                    if (!deserializeDBus(&o195, globalNamedObjectIdValue)) {
                        return false;
                    }
                    out.setGlobalNamedObjectId(globalNamedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o195)) {
                    dbus_message_iter_next(&o195);
                } else {
                    return true;
                }

                {
                    bool hasStreetsValue;
                    bool &hasStreetsTmpValue = hasStreetsValue;
                    {
                        dbus_bool_t o196;
                        dbus_message_iter_get_basic(&o195, &o196);
                        hasStreetsTmpValue = o196 ? true : false;
                    }
                    out.setHasStreets(hasStreetsValue);
                }

                if (dbus_message_iter_has_next(&o195)) {
                    dbus_message_iter_next(&o195);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateRegionSpecifierRelations

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations& in, DBusMessageIter* out) {
    {
        DBusMessageIter o197Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o197Struct));
        uint16 o198 = in.getUpdateRegionSpecifier();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_UINT16, &o198));
        uint8 o199 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_BYTE, &o199));
        uint32 o200 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_UINT32, &o200));
        uint16 o201 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_UINT16, &o201));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o197Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations& out) {
    {
        DBusMessageIter o202;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o202);
                {
                    uint16 updateRegionSpecifierValue;
                    uint16 &updateRegionSpecifierTmpValue = updateRegionSpecifierValue;
                    dbus_message_iter_get_basic(&o202, &updateRegionSpecifierTmpValue);
                    out.setUpdateRegionSpecifier(updateRegionSpecifierValue);
                }

                if (dbus_message_iter_has_next(&o202)) {
                    dbus_message_iter_next(&o202);
                } else {
                    return true;
                }

                {
                    uint8 supplierIdValue;
                    uint8 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o202, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o202)) {
                    dbus_message_iter_next(&o202);
                } else {
                    return true;
                }

                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o202, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o202)) {
                    dbus_message_iter_next(&o202);
                } else {
                    return true;
                }

                {
                    uint16 updateRegionIdValue;
                    uint16 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o202, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o202)) {
                    dbus_message_iter_next(&o202);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of HandOverSessionStatus

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatus& in, DBusMessageIter* out) {
    {
        DBusMessageIter o203Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o203Struct));
        dbus_bool_t o204 = in.getIsHandOverScreenActive() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o203Struct, DBUS_TYPE_BOOLEAN, &o204));
        dbus_bool_t o205 = in.getIsLockOutModeActive() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o203Struct, DBUS_TYPE_BOOLEAN, &o205));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o203Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatus& out) {
    {
        DBusMessageIter o206;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o206);
                {
                    bool isHandOverScreenActiveValue;
                    bool &isHandOverScreenActiveTmpValue = isHandOverScreenActiveValue;
                    {
                        dbus_bool_t o207;
                        dbus_message_iter_get_basic(&o206, &o207);
                        isHandOverScreenActiveTmpValue = o207 ? true : false;
                    }
                    out.setIsHandOverScreenActive(isHandOverScreenActiveValue);
                }

                if (dbus_message_iter_has_next(&o206)) {
                    dbus_message_iter_next(&o206);
                } else {
                    return true;
                }

                {
                    bool isLockOutModeActiveValue;
                    bool &isLockOutModeActiveTmpValue = isLockOutModeActiveValue;
                    {
                        dbus_bool_t o208;
                        dbus_message_iter_get_basic(&o206, &o208);
                        isLockOutModeActiveTmpValue = o208 ? true : false;
                    }
                    out.setIsLockOutModeActive(isLockOutModeActiveValue);
                }

                if (dbus_message_iter_has_next(&o206)) {
                    dbus_message_iter_next(&o206);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SelectedDataItem

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem& in, DBusMessageIter* out) {
    {
        DBusMessageIter o209Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o209Struct));
        const ::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType  o210 = in.getHmiSelectedAddressElementType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o209Struct, DBUS_TYPE_UINT32, &o210));
        const char* o211 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o209Struct, DBUS_TYPE_STRING, &o211));
        serializeDBus(in.getSdsGlobalNameObjectId(), &o209Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o209Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem& out) {
    {
        DBusMessageIter o212;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o212);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType hmiSelectedAddressElementTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType__COUNTRY;
                    dbus_message_iter_get_basic(&o212, &hmiSelectedAddressElementTypeValue);
                    out.setHmiSelectedAddressElementType(hmiSelectedAddressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o212)) {
                    dbus_message_iter_next(&o212);
                } else {
                    return true;
                }

                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o213 = 0;
                        dbus_message_iter_get_basic(&o212, &o213);
                        dataTmpValue.assign (o213);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o212)) {
                    dbus_message_iter_next(&o212);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId sdsGlobalNameObjectIdValue;
                    if (!deserializeDBus(&o212, sdsGlobalNameObjectIdValue)) {
                        return false;
                    }
                    out.setSdsGlobalNameObjectId(sdsGlobalNameObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o212)) {
                    dbus_message_iter_next(&o212);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSHandOverOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o214Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o214Struct));
        dbus_bool_t o215 = in.getIsAmbigious() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o214Struct, DBUS_TYPE_BOOLEAN, &o215));
        dbus_bool_t o216 = in.getCityHasStreet() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o214Struct, DBUS_TYPE_BOOLEAN, &o216));
        dbus_bool_t o217 = in.getHouseNumberInRange() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o214Struct, DBUS_TYPE_BOOLEAN, &o217));
        dbus_bool_t o218 = in.getStreetHasHouseNumber() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o214Struct, DBUS_TYPE_BOOLEAN, &o218));
        dbus_bool_t o219 = in.getJunctionAvailable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o214Struct, DBUS_TYPE_BOOLEAN, &o219));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o214Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions& out) {
    {
        DBusMessageIter o220;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o220);
                {
                    bool isAmbigiousValue;
                    bool &isAmbigiousTmpValue = isAmbigiousValue;
                    {
                        dbus_bool_t o221;
                        dbus_message_iter_get_basic(&o220, &o221);
                        isAmbigiousTmpValue = o221 ? true : false;
                    }
                    out.setIsAmbigious(isAmbigiousValue);
                }

                if (dbus_message_iter_has_next(&o220)) {
                    dbus_message_iter_next(&o220);
                } else {
                    return true;
                }

                {
                    bool cityHasStreetValue;
                    bool &cityHasStreetTmpValue = cityHasStreetValue;
                    {
                        dbus_bool_t o222;
                        dbus_message_iter_get_basic(&o220, &o222);
                        cityHasStreetTmpValue = o222 ? true : false;
                    }
                    out.setCityHasStreet(cityHasStreetValue);
                }

                if (dbus_message_iter_has_next(&o220)) {
                    dbus_message_iter_next(&o220);
                } else {
                    return true;
                }

                {
                    bool houseNumberInRangeValue;
                    bool &houseNumberInRangeTmpValue = houseNumberInRangeValue;
                    {
                        dbus_bool_t o223;
                        dbus_message_iter_get_basic(&o220, &o223);
                        houseNumberInRangeTmpValue = o223 ? true : false;
                    }
                    out.setHouseNumberInRange(houseNumberInRangeValue);
                }

                if (dbus_message_iter_has_next(&o220)) {
                    dbus_message_iter_next(&o220);
                } else {
                    return true;
                }

                {
                    bool streetHasHouseNumberValue;
                    bool &streetHasHouseNumberTmpValue = streetHasHouseNumberValue;
                    {
                        dbus_bool_t o224;
                        dbus_message_iter_get_basic(&o220, &o224);
                        streetHasHouseNumberTmpValue = o224 ? true : false;
                    }
                    out.setStreetHasHouseNumber(streetHasHouseNumberValue);
                }

                if (dbus_message_iter_has_next(&o220)) {
                    dbus_message_iter_next(&o220);
                } else {
                    return true;
                }

                {
                    bool junctionAvailableValue;
                    bool &junctionAvailableTmpValue = junctionAvailableValue;
                    {
                        dbus_bool_t o225;
                        dbus_message_iter_get_basic(&o220, &o225);
                        junctionAvailableTmpValue = o225 ? true : false;
                    }
                    out.setJunctionAvailable(junctionAvailableValue);
                }

                if (dbus_message_iter_has_next(&o220)) {
                    dbus_message_iter_next(&o220);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PositionInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o226Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o226Struct));
        const char* o227 = in.getCountry().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o227));
        const char* o228 = in.getProvince().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o228));
        const char* o229 = in.getCity().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o229));
        const char* o230 = in.getCityDistrict().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o230));
        const char* o231 = in.getStreet().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o231));
        const char* o232 = in.getStreetNumber().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_STRING, &o232));
        serializeDBus(in.getCurrentCountry(), &o226Struct);
        serializeDBus(in.getCurrentState(), &o226Struct);
        serializeDBus(in.getCurrentCity(), &o226Struct);
        serializeDBus(in.getCurrentCityDistrict(), &o226Struct);
        serializeDBus(in.getCurrentStreet(), &o226Struct);
        serializeDBus(in.getCurrentIntersection(), &o226Struct);
        serializeDBus(in.getCurrentZipCode(), &o226Struct);
        dbus_bool_t o233 = in.getIsUniqueIdValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_BOOLEAN, &o233));
        uint32 o234 = in.getUniqueId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o226Struct, DBUS_TYPE_UINT32, &o234));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o226Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PositionInfo& out) {
    {
        DBusMessageIter o235;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o235);
                {
                    ::std::string countryValue;
                    ::std::string &countryTmpValue = countryValue;
                    {
                        char* o236 = 0;
                        dbus_message_iter_get_basic(&o235, &o236);
                        countryTmpValue.assign (o236);
                    }
                    out.setCountry(countryValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::std::string provinceValue;
                    ::std::string &provinceTmpValue = provinceValue;
                    {
                        char* o237 = 0;
                        dbus_message_iter_get_basic(&o235, &o237);
                        provinceTmpValue.assign (o237);
                    }
                    out.setProvince(provinceValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::std::string cityValue;
                    ::std::string &cityTmpValue = cityValue;
                    {
                        char* o238 = 0;
                        dbus_message_iter_get_basic(&o235, &o238);
                        cityTmpValue.assign (o238);
                    }
                    out.setCity(cityValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::std::string cityDistrictValue;
                    ::std::string &cityDistrictTmpValue = cityDistrictValue;
                    {
                        char* o239 = 0;
                        dbus_message_iter_get_basic(&o235, &o239);
                        cityDistrictTmpValue.assign (o239);
                    }
                    out.setCityDistrict(cityDistrictValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::std::string streetValue;
                    ::std::string &streetTmpValue = streetValue;
                    {
                        char* o240 = 0;
                        dbus_message_iter_get_basic(&o235, &o240);
                        streetTmpValue.assign (o240);
                    }
                    out.setStreet(streetValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::std::string streetNumberValue;
                    ::std::string &streetNumberTmpValue = streetNumberValue;
                    {
                        char* o241 = 0;
                        dbus_message_iter_get_basic(&o235, &o241);
                        streetNumberTmpValue.assign (o241);
                    }
                    out.setStreetNumber(streetNumberValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentCountryValue;
                    if (!deserializeDBus(&o235, currentCountryValue)) {
                        return false;
                    }
                    out.setCurrentCountry(currentCountryValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentStateValue;
                    if (!deserializeDBus(&o235, currentStateValue)) {
                        return false;
                    }
                    out.setCurrentState(currentStateValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentCityValue;
                    if (!deserializeDBus(&o235, currentCityValue)) {
                        return false;
                    }
                    out.setCurrentCity(currentCityValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentCityDistrictValue;
                    if (!deserializeDBus(&o235, currentCityDistrictValue)) {
                        return false;
                    }
                    out.setCurrentCityDistrict(currentCityDistrictValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentStreetValue;
                    if (!deserializeDBus(&o235, currentStreetValue)) {
                        return false;
                    }
                    out.setCurrentStreet(currentStreetValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentIntersectionValue;
                    if (!deserializeDBus(&o235, currentIntersectionValue)) {
                        return false;
                    }
                    out.setCurrentIntersection(currentIntersectionValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData currentZipCodeValue;
                    if (!deserializeDBus(&o235, currentZipCodeValue)) {
                        return false;
                    }
                    out.setCurrentZipCode(currentZipCodeValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    bool isUniqueIdValidValue;
                    bool &isUniqueIdValidTmpValue = isUniqueIdValidValue;
                    {
                        dbus_bool_t o242;
                        dbus_message_iter_get_basic(&o235, &o242);
                        isUniqueIdValidTmpValue = o242 ? true : false;
                    }
                    out.setIsUniqueIdValid(isUniqueIdValidValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

                {
                    uint32 uniqueIdValue;
                    uint32 &uniqueIdTmpValue = uniqueIdValue;
                    dbus_message_iter_get_basic(&o235, &uniqueIdTmpValue);
                    out.setUniqueId(uniqueIdValue);
                }

                if (dbus_message_iter_has_next(&o235)) {
                    dbus_message_iter_next(&o235);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PositionStatusInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o243Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o243Struct));
        serializeDBus(in.getPositionWGS84(), &o243Struct);
        const char* o244 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_STRING, &o244));
        const char* o245 = in.getStateCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_STRING, &o245));
        const ::org::bosch::cm::navigation::NavigationSDSService::RoadClass  o246 = in.getRoadClass();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_UINT32, &o246));
        double o247 = in.getVehicleSpeed();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_DOUBLE, &o247));
        double o248 = in.getVehicleHeading();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_DOUBLE, &o248));
        dbus_bool_t o249 = in.getIsUniqueIdValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_BOOLEAN, &o249));
        uint32 o250 = in.getUniqueId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o243Struct, DBUS_TYPE_UINT32, &o250));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o243Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfo& out) {
    {
        DBusMessageIter o251;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o251);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::PositionWGS84 positionWGS84Value;
                    if (!deserializeDBus(&o251, positionWGS84Value)) {
                        return false;
                    }
                    out.setPositionWGS84(positionWGS84Value);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o252 = 0;
                        dbus_message_iter_get_basic(&o251, &o252);
                        countryCodeTmpValue.assign (o252);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    ::std::string stateCodeValue;
                    ::std::string &stateCodeTmpValue = stateCodeValue;
                    {
                        char* o253 = 0;
                        dbus_message_iter_get_basic(&o251, &o253);
                        stateCodeTmpValue.assign (o253);
                    }
                    out.setStateCode(stateCodeValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::RoadClass roadClassValue = ::org::bosch::cm::navigation::NavigationSDSService::RoadClass__ROAD_CLASS_NONE;
                    dbus_message_iter_get_basic(&o251, &roadClassValue);
                    out.setRoadClass(roadClassValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    float vehicleSpeedValue;
                    float &vehicleSpeedTmpValue = vehicleSpeedValue;
                    {
                        double o254;
                        dbus_message_iter_get_basic(&o251, &o254);
                        vehicleSpeedTmpValue = static_cast<float>(o254);
                    }
                    out.setVehicleSpeed(vehicleSpeedValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    float vehicleHeadingValue;
                    float &vehicleHeadingTmpValue = vehicleHeadingValue;
                    {
                        double o255;
                        dbus_message_iter_get_basic(&o251, &o255);
                        vehicleHeadingTmpValue = static_cast<float>(o255);
                    }
                    out.setVehicleHeading(vehicleHeadingValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    bool isUniqueIdValidValue;
                    bool &isUniqueIdValidTmpValue = isUniqueIdValidValue;
                    {
                        dbus_bool_t o256;
                        dbus_message_iter_get_basic(&o251, &o256);
                        isUniqueIdValidTmpValue = o256 ? true : false;
                    }
                    out.setIsUniqueIdValid(isUniqueIdValidValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    uint32 uniqueIdValue;
                    uint32 &uniqueIdTmpValue = uniqueIdValue;
                    dbus_message_iter_get_basic(&o251, &uniqueIdTmpValue);
                    out.setUniqueId(uniqueIdValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NDSNamedObjectData

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o257Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o257Struct));
        const char* o258 = in.getObjectName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o257Struct, DBUS_TYPE_STRING, &o258));
        uint32 o259 = in.getNdsNamedObjectId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o257Struct, DBUS_TYPE_UINT32, &o259));
        uint16 o260 = in.getNdsUpdateRegionSpecifier();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o257Struct, DBUS_TYPE_UINT16, &o260));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o257Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::NDSNamedObjectData& out) {
    {
        DBusMessageIter o261;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o261);
                {
                    ::std::string objectNameValue;
                    ::std::string &objectNameTmpValue = objectNameValue;
                    {
                        char* o262 = 0;
                        dbus_message_iter_get_basic(&o261, &o262);
                        objectNameTmpValue.assign (o262);
                    }
                    out.setObjectName(objectNameValue);
                }

                if (dbus_message_iter_has_next(&o261)) {
                    dbus_message_iter_next(&o261);
                } else {
                    return true;
                }

                {
                    uint32 ndsNamedObjectIdValue;
                    uint32 &ndsNamedObjectIdTmpValue = ndsNamedObjectIdValue;
                    dbus_message_iter_get_basic(&o261, &ndsNamedObjectIdTmpValue);
                    out.setNdsNamedObjectId(ndsNamedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o261)) {
                    dbus_message_iter_next(&o261);
                } else {
                    return true;
                }

                {
                    uint16 NdsUpdateRegionSpecifierValue;
                    uint16 &NdsUpdateRegionSpecifierTmpValue = NdsUpdateRegionSpecifierValue;
                    dbus_message_iter_get_basic(&o261, &NdsUpdateRegionSpecifierTmpValue);
                    out.setNdsUpdateRegionSpecifier(NdsUpdateRegionSpecifierValue);
                }

                if (dbus_message_iter_has_next(&o261)) {
                    dbus_message_iter_next(&o261);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PositionWGS84

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionWGS84& in, DBusMessageIter* out) {
    {
        DBusMessageIter o263Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o263Struct));
        double o264 = in.getLongitude();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o263Struct, DBUS_TYPE_DOUBLE, &o264));
        double o265 = in.getLatitude();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o263Struct, DBUS_TYPE_DOUBLE, &o265));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o263Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PositionWGS84& out) {
    {
        DBusMessageIter o266;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o266);
                {
                    double longitudeValue;
                    double &longitudeTmpValue = longitudeValue;
                    dbus_message_iter_get_basic(&o266, &longitudeTmpValue);
                    out.setLongitude(longitudeValue);
                }

                if (dbus_message_iter_has_next(&o266)) {
                    dbus_message_iter_next(&o266);
                } else {
                    return true;
                }

                {
                    double latitudeValue;
                    double &latitudeTmpValue = latitudeValue;
                    dbus_message_iter_get_basic(&o266, &latitudeTmpValue);
                    out.setLatitude(latitudeValue);
                }

                if (dbus_message_iter_has_next(&o266)) {
                    dbus_message_iter_next(&o266);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DynamicMapPoiCategory

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory& in, DBusMessageIter* out) {
    {
        DBusMessageIter o267Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o267Struct));
        const char* o268 = in.getPoiCategoryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o267Struct, DBUS_TYPE_STRING, &o268));
        uint32 o269 = in.getPoiCategoryId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o267Struct, DBUS_TYPE_UINT32, &o269));
        dbus_bool_t o270 = in.getPoiCategoryVisibilityOnMap() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o267Struct, DBUS_TYPE_BOOLEAN, &o270));
        serializeDBus(in.getSdsNameObjectId(), &o267Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o267Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory& out) {
    {
        DBusMessageIter o271;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o271);
                {
                    ::std::string poiCategoryNameValue;
                    ::std::string &poiCategoryNameTmpValue = poiCategoryNameValue;
                    {
                        char* o272 = 0;
                        dbus_message_iter_get_basic(&o271, &o272);
                        poiCategoryNameTmpValue.assign (o272);
                    }
                    out.setPoiCategoryName(poiCategoryNameValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    uint32 poiCategoryIdValue;
                    uint32 &poiCategoryIdTmpValue = poiCategoryIdValue;
                    dbus_message_iter_get_basic(&o271, &poiCategoryIdTmpValue);
                    out.setPoiCategoryId(poiCategoryIdValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    bool poiCategoryVisibilityOnMapValue;
                    bool &poiCategoryVisibilityOnMapTmpValue = poiCategoryVisibilityOnMapValue;
                    {
                        dbus_bool_t o273;
                        dbus_message_iter_get_basic(&o271, &o273);
                        poiCategoryVisibilityOnMapTmpValue = o273 ? true : false;
                    }
                    out.setPoiCategoryVisibilityOnMap(poiCategoryVisibilityOnMapValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId sdsNameObjectIdValue;
                    if (!deserializeDBus(&o271, sdsNameObjectIdValue)) {
                        return false;
                    }
                    out.setSdsNameObjectId(sdsNameObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DynamicMapPoiCategoriesWithLanguage

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoriesWithLanguage& in, DBusMessageIter* out) {
    {
        DBusMessageIter o274Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o274Struct));
        DBusMessageIter o275ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o274Struct, DBUS_TYPE_ARRAY, "(sub((nin)ub))", &o275ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >* o276 = &in.getDynamicMapPoiCategories();
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o277 = o276->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o278 = o276->begin(); o278 != o277; ++o278) {
            serializeDBus((*o278), &o275ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o274Struct, &o275ArrayIter));
        serializeDBus(in.getPoiCategoriesLanguageEntry(), &o274Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o274Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoriesWithLanguage& out) {
    {
        DBusMessageIter o279;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o279);
                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory > dynamicMapPoiCategoriesValue;

                    if (dbus_message_iter_get_arg_type(&o279) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o280ArrayIter;
                        dbus_message_iter_recurse (&o279, &o280ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o280ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory o281;
                                if (!deserializeDBus(&o280ArrayIter, o281)) {
                                    return false;
                                }
                                dynamicMapPoiCategoriesValue.push_back(o281);
                            } while (dbus_message_iter_next(&o280ArrayIter));
                        }
                    }
                    out.setDynamicMapPoiCategories(dynamicMapPoiCategoriesValue);
                }

                if (dbus_message_iter_has_next(&o279)) {
                    dbus_message_iter_next(&o279);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry poiCategoriesLanguageEntryValue;
                    if (!deserializeDBus(&o279, poiCategoriesLanguageEntryValue)) {
                        return false;
                    }
                    out.setPoiCategoriesLanguageEntry(poiCategoriesLanguageEntryValue);
                }

                if (dbus_message_iter_has_next(&o279)) {
                    dbus_message_iter_next(&o279);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of AddressFormatInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o282Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o282Struct));
        const char* o283 = in.getIsoCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o282Struct, DBUS_TYPE_STRING, &o283));
        const char* o284 = in.getAddressFormat().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o282Struct, DBUS_TYPE_STRING, &o284));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o282Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo& out) {
    {
        DBusMessageIter o285;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o285);
                {
                    ::std::string isoCountryCodeValue;
                    ::std::string &isoCountryCodeTmpValue = isoCountryCodeValue;
                    {
                        char* o286 = 0;
                        dbus_message_iter_get_basic(&o285, &o286);
                        isoCountryCodeTmpValue.assign (o286);
                    }
                    out.setIsoCountryCode(isoCountryCodeValue);
                }

                if (dbus_message_iter_has_next(&o285)) {
                    dbus_message_iter_next(&o285);
                } else {
                    return true;
                }

                {
                    ::std::string addressFormatValue;
                    ::std::string &addressFormatTmpValue = addressFormatValue;
                    {
                        char* o287 = 0;
                        dbus_message_iter_get_basic(&o285, &o287);
                        addressFormatTmpValue.assign (o287);
                    }
                    out.setAddressFormat(addressFormatValue);
                }

                if (dbus_message_iter_has_next(&o285)) {
                    dbus_message_iter_next(&o285);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SharedDataAccessAttributes

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccessAttributes& in, DBusMessageIter* out) {
    {
        DBusMessageIter o288Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o288Struct));
        const ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess  o289 = in.getSharedDataAccess();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o288Struct, DBUS_TYPE_UINT32, &o289));
        const ::org::bosch::cm::navigation::NavigationSDSService::JournalingMode  o290 = in.getJournalingMode();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o288Struct, DBUS_TYPE_UINT32, &o290));
        const ::org::bosch::cm::navigation::NavigationSDSService::LockType  o291 = in.getLockType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o288Struct, DBUS_TYPE_UINT32, &o291));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o288Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccessAttributes& out) {
    {
        DBusMessageIter o292;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o292);
                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess sharedDataAccessValue = ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess__SHARED_DATA_ACCESS__NOT_REQUIRED;
                    dbus_message_iter_get_basic(&o292, &sharedDataAccessValue);
                    out.setSharedDataAccess(sharedDataAccessValue);
                }

                if (dbus_message_iter_has_next(&o292)) {
                    dbus_message_iter_next(&o292);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::JournalingMode journalingModeValue = ::org::bosch::cm::navigation::NavigationSDSService::JournalingMode__JOURNALING_MODE__NONE;
                    dbus_message_iter_get_basic(&o292, &journalingModeValue);
                    out.setJournalingMode(journalingModeValue);
                }

                if (dbus_message_iter_has_next(&o292)) {
                    dbus_message_iter_next(&o292);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::LockType lockTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::LockType__LOCK_TYPE__NONE;
                    dbus_message_iter_get_basic(&o292, &lockTypeValue);
                    out.setLockType(lockTypeValue);
                }

                if (dbus_message_iter_has_next(&o292)) {
                    dbus_message_iter_next(&o292);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NavDataSetInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::NavDataSetInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o293Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o293Struct));
        uint32 o294 = in.getDatasetId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o293Struct, DBUS_TYPE_UINT32, &o294));
        const char* o295 = in.getPersistentDatasetId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o293Struct, DBUS_TYPE_STRING, &o295));
        serializeDBus(in.getSharedDataAccessAttributes(), &o293Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o293Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::NavDataSetInfo& out) {
    {
        DBusMessageIter o296;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o296);
                {
                    uint32 datasetIdValue;
                    uint32 &datasetIdTmpValue = datasetIdValue;
                    dbus_message_iter_get_basic(&o296, &datasetIdTmpValue);
                    out.setDatasetId(datasetIdValue);
                }

                if (dbus_message_iter_has_next(&o296)) {
                    dbus_message_iter_next(&o296);
                } else {
                    return true;
                }

                {
                    ::std::string persistentDatasetIdValue;
                    ::std::string &persistentDatasetIdTmpValue = persistentDatasetIdValue;
                    {
                        char* o297 = 0;
                        dbus_message_iter_get_basic(&o296, &o297);
                        persistentDatasetIdTmpValue.assign (o297);
                    }
                    out.setPersistentDatasetId(persistentDatasetIdValue);
                }

                if (dbus_message_iter_has_next(&o296)) {
                    dbus_message_iter_next(&o296);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccessAttributes sharedDataAccessAttributesValue;
                    if (!deserializeDBus(&o296, sharedDataAccessAttributesValue)) {
                        return false;
                    }
                    out.setSharedDataAccessAttributes(sharedDataAccessAttributesValue);
                }

                if (dbus_message_iter_has_next(&o296)) {
                    dbus_message_iter_next(&o296);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of HapticData

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::HapticData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o298Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o298Struct));
        const char* o299 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o298Struct, DBUS_TYPE_STRING, &o299));
        serializeDBus(in.getSdsNameObjectId(), &o298Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o298Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::HapticData& out) {
    {
        DBusMessageIter o300;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o300);
                {
                    ::std::string DataValue;
                    ::std::string &DataTmpValue = DataValue;
                    {
                        char* o301 = 0;
                        dbus_message_iter_get_basic(&o300, &o301);
                        DataTmpValue.assign (o301);
                    }
                    out.setData(DataValue);
                }

                if (dbus_message_iter_has_next(&o300)) {
                    dbus_message_iter_next(&o300);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId sdsNameObjectIdValue;
                    if (!deserializeDBus(&o300, sdsNameObjectIdValue)) {
                        return false;
                    }
                    out.setSdsNameObjectId(sdsNameObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o300)) {
                    dbus_message_iter_next(&o300);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GetGlobalDataForSdsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsResponse& in, DBusMessageIter* out) {
    const char* o302 = in.getDeviceName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o302));
    uint32 o303 = in.getDatasetId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o303));
    const char* o304 = in.getPersistentDatasetId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o304));
    DBusMessageIter o305ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(yua(qa(qusu(bb(ua(qs))(ua(qs)))yu)a(qss))a(qsss(sss)qq))", &o305ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts >* o306 = &in.getSdsProductsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts >::const_iterator o307 = o306->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts >::const_iterator o308 = o306->begin(); o308 != o307; ++o308) {
        serializeDBus((*o308), &o305ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o305ArrayIter));
    DBusMessageIter o309ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qyuq)", &o309ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations >* o310 = &in.getUpdateRegionSpecifierRelationsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations >::const_iterator o311 = o310->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations >::const_iterator o312 = o310->begin(); o312 != o311; ++o312) {
        serializeDBus((*o312), &o309ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o309ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsResponse& out) {
    {
        ::std::string deviceNameValue;
        ::std::string &deviceNameTmpValue = deviceNameValue;
        {
            char* o313 = 0;
            dbus_message_iter_get_basic(in, &o313);
            deviceNameTmpValue.assign (o313);
        }
        out.setDeviceName(deviceNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 datasetIdValue;
        uint32 &datasetIdTmpValue = datasetIdValue;
        dbus_message_iter_get_basic(in, &datasetIdTmpValue);
        out.setDatasetId(datasetIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string persistentDatasetIdValue;
        ::std::string &persistentDatasetIdTmpValue = persistentDatasetIdValue;
        {
            char* o314 = 0;
            dbus_message_iter_get_basic(in, &o314);
            persistentDatasetIdTmpValue.assign (o314);
        }
        out.setPersistentDatasetId(persistentDatasetIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts > sdsProductsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o315ArrayIter;
            dbus_message_iter_recurse (in, &o315ArrayIter);

            if(dbus_message_iter_get_arg_type(&o315ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::SdsProducts o316;
                    if (!deserializeDBus(&o315ArrayIter, o316)) {
                        return false;
                    }
                    sdsProductsListValue.push_back(o316);
                } while (dbus_message_iter_next(&o315ArrayIter));
            }
        }
        out.setSdsProductsList(sdsProductsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations > updateRegionSpecifierRelationsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o317ArrayIter;
            dbus_message_iter_recurse (in, &o317ArrayIter);

            if(dbus_message_iter_get_arg_type(&o317ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations o318;
                    if (!deserializeDBus(&o317ArrayIter, o318)) {
                        return false;
                    }
                    updateRegionSpecifierRelationsListValue.push_back(o318);
                } while (dbus_message_iter_next(&o317ArrayIter));
            }
        }
        out.setUpdateRegionSpecifierRelationsList(updateRegionSpecifierRelationsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetIdListOfCountryAndSubCountryResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryResponse& in, DBusMessageIter* out) {
    DBusMessageIter o319ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((nin)utu)", &o319ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >* o320 = &in.getCountryIdList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >::const_iterator o321 = o320->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId >::const_iterator o322 = o320->begin(); o322 != o321; ++o322) {
        serializeDBus((*o322), &o319ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o319ArrayIter));
    DBusMessageIter o323ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(((nin)ub)a((nin)utu))", &o323ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds >* o324 = &in.getSubCountryIdList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds >::const_iterator o325 = o324->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds >::const_iterator o326 = o324->begin(); o326 != o325; ++o326) {
        serializeDBus((*o326), &o323ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o323ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > countryIdListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o327ArrayIter;
            dbus_message_iter_recurse (in, &o327ArrayIter);

            if(dbus_message_iter_get_arg_type(&o327ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId o328;
                    if (!deserializeDBus(&o327ArrayIter, o328)) {
                        return false;
                    }
                    countryIdListValue.push_back(o328);
                } while (dbus_message_iter_next(&o327ArrayIter));
            }
        }
        out.setCountryIdList(countryIdListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds > subCountryIdListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o329ArrayIter;
            dbus_message_iter_recurse (in, &o329ArrayIter);

            if(dbus_message_iter_get_arg_type(&o329ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::SubCountryIds o330;
                    if (!deserializeDBus(&o329ArrayIter, o330)) {
                        return false;
                    }
                    subCountryIdListValue.push_back(o330);
                } while (dbus_message_iter_next(&o329ArrayIter));
            }
        }
        out.setSubCountryIdList(subCountryIdListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetNamesForNDSIdsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsRequest& in, DBusMessageIter* out) {
    DBusMessageIter o331ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((nin)ub)", &o331ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >* o332 = &in.getGlobalNamedObjectIdList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o333 = o332->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o334 = o332->begin(); o334 != o333; ++o334) {
        serializeDBus((*o334), &o331ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o331ArrayIter));
    DBusMessageIter o335ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o335ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >* o336 = &in.getLanguageEntryList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >::const_iterator o337 = o336->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >::const_iterator o338 = o336->begin(); o338 != o337; ++o338) {
        serializeDBus((*o338), &o335ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o335ArrayIter));
    const ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType  o339 = in.getNdsFeatureType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o339));
    dbus_bool_t o340 = in.getStopOnFirstMatch() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o340));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId > globalNamedObjectIdListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o341ArrayIter;
            dbus_message_iter_recurse (in, &o341ArrayIter);

            if(dbus_message_iter_get_arg_type(&o341ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId o342;
                    if (!deserializeDBus(&o341ArrayIter, o342)) {
                        return false;
                    }
                    globalNamedObjectIdListValue.push_back(o342);
                } while (dbus_message_iter_next(&o341ArrayIter));
            }
        }
        out.setGlobalNamedObjectIdList(globalNamedObjectIdListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry > languageEntryListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o343ArrayIter;
            dbus_message_iter_recurse (in, &o343ArrayIter);

            if(dbus_message_iter_get_arg_type(&o343ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry o344;
                    if (!deserializeDBus(&o343ArrayIter, o344)) {
                        return false;
                    }
                    languageEntryListValue.push_back(o344);
                } while (dbus_message_iter_next(&o343ArrayIter));
            }
        }
        out.setLanguageEntryList(languageEntryListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType ndsFeatureTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT;
        dbus_message_iter_get_basic(in, &ndsFeatureTypeValue);
        out.setNdsFeatureType(ndsFeatureTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool stopOnFirstMatchValue;
        bool &stopOnFirstMatchTmpValue = stopOnFirstMatchValue;
        {
            dbus_bool_t o345;
            dbus_message_iter_get_basic(in, &o345);
            stopOnFirstMatchTmpValue = o345 ? true : false;
        }
        out.setStopOnFirstMatch(stopOnFirstMatchValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetNamesForNDSIdsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o346ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(((nin)ub)(sss)asu)", &o346ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >* o347 = &in.getNamedObjectIdStringsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >::const_iterator o348 = o347->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >::const_iterator o349 = o347->begin(); o349 != o348; ++o349) {
        serializeDBus((*o349), &o346ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o346ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > namedObjectIdStringsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o350ArrayIter;
            dbus_message_iter_recurse (in, &o350ArrayIter);

            if(dbus_message_iter_get_arg_type(&o350ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings o351;
                    if (!deserializeDBus(&o350ArrayIter, o351)) {
                        return false;
                    }
                    namedObjectIdStringsListValue.push_back(o351);
                } while (dbus_message_iter_next(&o350ArrayIter));
            }
        }
        out.setNamedObjectIdStringsList(namedObjectIdStringsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetPhonemesForNDSIdsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsRequest& in, DBusMessageIter* out) {
    DBusMessageIter o352ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((nin)ub)", &o352ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >* o353 = &in.getGlobalNamedObjectIdList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o354 = o353->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o355 = o353->begin(); o355 != o354; ++o355) {
        serializeDBus((*o355), &o352ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o352ArrayIter));
    DBusMessageIter o356ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sss)", &o356ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >* o357 = &in.getLanguageEntryList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >::const_iterator o358 = o357->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >::const_iterator o359 = o357->begin(); o359 != o358; ++o359) {
        serializeDBus((*o359), &o356ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o356ArrayIter));
    const ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType  o360 = in.getNdsFeatureType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o360));
    dbus_bool_t o361 = in.getStopOnFirstMatch() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o361));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId > globalNamedObjectIdListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o362ArrayIter;
            dbus_message_iter_recurse (in, &o362ArrayIter);

            if(dbus_message_iter_get_arg_type(&o362ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId o363;
                    if (!deserializeDBus(&o362ArrayIter, o363)) {
                        return false;
                    }
                    globalNamedObjectIdListValue.push_back(o363);
                } while (dbus_message_iter_next(&o362ArrayIter));
            }
        }
        out.setGlobalNamedObjectIdList(globalNamedObjectIdListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry > languageEntryListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o364ArrayIter;
            dbus_message_iter_recurse (in, &o364ArrayIter);

            if(dbus_message_iter_get_arg_type(&o364ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::LanguageEntry o365;
                    if (!deserializeDBus(&o364ArrayIter, o365)) {
                        return false;
                    }
                    languageEntryListValue.push_back(o365);
                } while (dbus_message_iter_next(&o364ArrayIter));
            }
        }
        out.setLanguageEntryList(languageEntryListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType ndsFeatureTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT;
        dbus_message_iter_get_basic(in, &ndsFeatureTypeValue);
        out.setNdsFeatureType(ndsFeatureTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool stopOnFirstMatchValue;
        bool &stopOnFirstMatchTmpValue = stopOnFirstMatchValue;
        {
            dbus_bool_t o366;
            dbus_message_iter_get_basic(in, &o366);
            stopOnFirstMatchTmpValue = o366 ? true : false;
        }
        out.setStopOnFirstMatch(stopOnFirstMatchValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetPhonemesForNDSIdsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o367ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(((nin)ub)(sss)asu)", &o367ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >* o368 = &in.getNamedObjectIdStringsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >::const_iterator o369 = o368->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >::const_iterator o370 = o368->begin(); o370 != o369; ++o370) {
        serializeDBus((*o370), &o367ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o367ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > namedObjectIdStringsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o371ArrayIter;
            dbus_message_iter_recurse (in, &o371ArrayIter);

            if(dbus_message_iter_get_arg_type(&o371ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings o372;
                    if (!deserializeDBus(&o371ArrayIter, o372)) {
                        return false;
                    }
                    namedObjectIdStringsListValue.push_back(o372);
                } while (dbus_message_iter_next(&o371ArrayIter));
            }
        }
        out.setNamedObjectIdStringsList(namedObjectIdStringsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetCityHasStreetsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsRequest& in, DBusMessageIter* out) {
    DBusMessageIter o373ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((nin)ub)", &o373ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >* o374 = &in.getGlobalNamedObjectIdList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o375 = o374->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId >::const_iterator o376 = o374->begin(); o376 != o375; ++o376) {
        serializeDBus((*o376), &o373ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o373ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId > globalNamedObjectIdListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o377ArrayIter;
            dbus_message_iter_recurse (in, &o377ArrayIter);

            if(dbus_message_iter_get_arg_type(&o377ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId o378;
                    if (!deserializeDBus(&o377ArrayIter, o378)) {
                        return false;
                    }
                    globalNamedObjectIdListValue.push_back(o378);
                } while (dbus_message_iter_next(&o377ArrayIter));
            }
        }
        out.setGlobalNamedObjectIdList(globalNamedObjectIdListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetCityHasStreetsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o379ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(((nin)ub)b)", &o379ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets >* o380 = &in.getCityNamedObjectIdHasStreetsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets >::const_iterator o381 = o380->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets >::const_iterator o382 = o380->begin(); o382 != o381; ++o382) {
        serializeDBus((*o382), &o379ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o379ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets > cityNamedObjectIdHasStreetsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o383ArrayIter;
            dbus_message_iter_recurse (in, &o383ArrayIter);

            if(dbus_message_iter_get_arg_type(&o383ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets o384;
                    if (!deserializeDBus(&o383ArrayIter, o384)) {
                        return false;
                    }
                    cityNamedObjectIdHasStreetsListValue.push_back(o384);
                } while (dbus_message_iter_next(&o383ArrayIter));
            }
        }
        out.setCityNamedObjectIdHasStreetsList(cityNamedObjectIdHasStreetsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetHapticHandOverDataResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId  o385 = in.getSdsHandOverScreenId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o385));
    DBusMessageIter o386ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(s((nin)ub))", &o386ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::HapticData >* o387 = &in.getDataList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::HapticData >::const_iterator o388 = o387->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::HapticData >::const_iterator o389 = o387->begin(); o389 != o388; ++o389) {
        serializeDBus((*o389), &o386ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o386ArrayIter));
    DBusMessageIter o390ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(us((nin)ub))", &o390ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem >* o391 = &in.getSelectedDataListItems();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem >::const_iterator o392 = o391->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem >::const_iterator o393 = o391->begin(); o393 != o392; ++o393) {
        serializeDBus((*o393), &o390ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o390ArrayIter));
    const ::org::bosch::cm::navigation::NavigationSDSService::LocationType  o394 = in.getLocationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o394));
    DBusMessageIter o395ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(bbbbb)", &o395ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions >* o396 = &in.getSdsHandOverOptionsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions >::const_iterator o397 = o396->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions >::const_iterator o398 = o396->begin(); o398 != o397; ++o398) {
        serializeDBus((*o398), &o395ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o395ArrayIter));
    DBusMessageIter o399ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(stssu)", &o399ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement >* o400 = &in.getSearchResults();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement >::const_iterator o401 = o400->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement >::const_iterator o402 = o400->begin(); o402 != o401; ++o402) {
        serializeDBus((*o402), &o399ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o399ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId sdsHandOverScreenIdValue = ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_ADDRESS;
        dbus_message_iter_get_basic(in, &sdsHandOverScreenIdValue);
        out.setSdsHandOverScreenId(sdsHandOverScreenIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::HapticData > dataListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o403ArrayIter;
            dbus_message_iter_recurse (in, &o403ArrayIter);

            if(dbus_message_iter_get_arg_type(&o403ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::HapticData o404;
                    if (!deserializeDBus(&o403ArrayIter, o404)) {
                        return false;
                    }
                    dataListValue.push_back(o404);
                } while (dbus_message_iter_next(&o403ArrayIter));
            }
        }
        out.setDataList(dataListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem > selectedDataListItemsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o405ArrayIter;
            dbus_message_iter_recurse (in, &o405ArrayIter);

            if(dbus_message_iter_get_arg_type(&o405ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem o406;
                    if (!deserializeDBus(&o405ArrayIter, o406)) {
                        return false;
                    }
                    selectedDataListItemsValue.push_back(o406);
                } while (dbus_message_iter_next(&o405ArrayIter));
            }
        }
        out.setSelectedDataListItems(selectedDataListItemsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationSDSService::LocationType locationTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT;
        dbus_message_iter_get_basic(in, &locationTypeValue);
        out.setLocationType(locationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions > sdsHandOverOptionsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o407ArrayIter;
            dbus_message_iter_recurse (in, &o407ArrayIter);

            if(dbus_message_iter_get_arg_type(&o407ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions o408;
                    if (!deserializeDBus(&o407ArrayIter, o408)) {
                        return false;
                    }
                    sdsHandOverOptionsListValue.push_back(o408);
                } while (dbus_message_iter_next(&o407ArrayIter));
            }
        }
        out.setSdsHandOverOptionsList(sdsHandOverOptionsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement > searchResultsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o409ArrayIter;
            dbus_message_iter_recurse (in, &o409ArrayIter);

            if(dbus_message_iter_get_arg_type(&o409ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::AddressListElement o410;
                    if (!deserializeDBus(&o409ArrayIter, o410)) {
                        return false;
                    }
                    searchResultsValue.push_back(o410);
                } while (dbus_message_iter_next(&o409ArrayIter));
            }
        }
        out.setSearchResults(searchResultsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SelectHapticHandOverListRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListRequest& in, DBusMessageIter* out) {
    uint32 o411 = in.getIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o411));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListRequest& out) {
    {
        uint32 indexValue;
        uint32 &indexTmpValue = indexValue;
        dbus_message_iter_get_basic(in, &indexTmpValue);
        out.setIndex(indexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDynamicPoiIconCategoriesInMapResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapResponse& in, DBusMessageIter* out) {
    DBusMessageIter o412ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sub((nin)ub))", &o412ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >* o413 = &in.getDynamicMapPoiCategory();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o414 = o413->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o415 = o413->begin(); o415 != o414; ++o415) {
        serializeDBus((*o415), &o412ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o412ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory > dynamicMapPoiCategoryValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o416ArrayIter;
            dbus_message_iter_recurse (in, &o416ArrayIter);

            if(dbus_message_iter_get_arg_type(&o416ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory o417;
                    if (!deserializeDBus(&o416ArrayIter, o417)) {
                        return false;
                    }
                    dynamicMapPoiCategoryValue.push_back(o417);
                } while (dbus_message_iter_next(&o416ArrayIter));
            }
        }
        out.setDynamicMapPoiCategory(dynamicMapPoiCategoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetMaxWaypointCountResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountResponse& in, DBusMessageIter* out) {
    uint32 o418 = in.getMaxWayPointCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o418));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountResponse& out) {
    {
        uint32 maxWayPointCountValue;
        uint32 &maxWayPointCountTmpValue = maxWayPointCountValue;
        dbus_message_iter_get_basic(in, &maxWayPointCountTmpValue);
        out.setMaxWayPointCount(maxWayPointCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetDynamicPoiIconCategoriesInMapRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapRequest& in, DBusMessageIter* out) {
    DBusMessageIter o419ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sub((nin)ub))", &o419ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >* o420 = &in.getDynamicMapPoiCategory();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o421 = o420->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory >::const_iterator o422 = o420->begin(); o422 != o421; ++o422) {
        serializeDBus((*o422), &o419ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o419ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory > dynamicMapPoiCategoryValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o423ArrayIter;
            dbus_message_iter_recurse (in, &o423ArrayIter);

            if(dbus_message_iter_get_arg_type(&o423ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory o424;
                    if (!deserializeDBus(&o423ArrayIter, o424)) {
                        return false;
                    }
                    dynamicMapPoiCategoryValue.push_back(o424);
                } while (dbus_message_iter_next(&o423ArrayIter));
            }
        }
        out.setDynamicMapPoiCategory(dynamicMapPoiCategoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsCheckAddressRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsCheckAddressRequest& in, DBusMessageIter* out) {
    DBusMessageIter o425ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(us(b))", &o425ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >* o426 = &in.getRequestedAddress();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >::const_iterator o427 = o426->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement >::const_iterator o428 = o426->begin(); o428 != o427; ++o428) {
        serializeDBus((*o428), &o425ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o425ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsCheckAddressRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement > requestedAddressValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o429ArrayIter;
            dbus_message_iter_recurse (in, &o429ArrayIter);

            if(dbus_message_iter_get_arg_type(&o429ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElement o430;
                    if (!deserializeDBus(&o429ArrayIter, o430)) {
                        return false;
                    }
                    requestedAddressValue.push_back(o430);
                } while (dbus_message_iter_next(&o429ArrayIter));
            }
        }
        out.setRequestedAddress(requestedAddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsGetRefinementListResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsGetRefinementListResponse& in, DBusMessageIter* out) {
    DBusMessageIter o431ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(susu)", &o431ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement >* o432 = &in.getRefinements();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement >::const_iterator o433 = o432->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement >::const_iterator o434 = o432->begin(); o434 != o433; ++o434) {
        serializeDBus((*o434), &o431ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o431ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsGetRefinementListResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement > refinementsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o435ArrayIter;
            dbus_message_iter_recurse (in, &o435ArrayIter);

            if(dbus_message_iter_get_arg_type(&o435ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::RefinementListElement o436;
                    if (!deserializeDBus(&o435ArrayIter, o436)) {
                        return false;
                    }
                    refinementsValue.push_back(o436);
                } while (dbus_message_iter_next(&o435ArrayIter));
            }
        }
        out.setRefinements(refinementsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsUpdateVoiceTagRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateVoiceTagRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getVoiceTagID(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsUpdateVoiceTagRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagId voiceTagIDValue;
        if (!deserializeDBus(in, voiceTagIDValue)) {
            return false;
        }
        out.setVoiceTagID(voiceTagIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsGetHouseNumberPatternResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsGetHouseNumberPatternResponse& in, DBusMessageIter* out) {
    const char* o437 = in.getMinHouseNumber().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o437));
    const char* o438 = in.getMaxHouseNumber().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o438));
    DBusMessageIter o439ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o439ArrayIter));
    const ::std::vector< ::std::string >* o440 = &in.getPatterns();
    ::std::vector< ::std::string >::const_iterator o441 = o440->end();
    for (::std::vector< ::std::string >::const_iterator o442 = o440->begin(); o442 != o441; ++o442) {
        const char* o443 = (*o442).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o439ArrayIter, DBUS_TYPE_STRING, &o443));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o439ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsGetHouseNumberPatternResponse& out) {
    {
        ::std::string minHouseNumberValue;
        ::std::string &minHouseNumberTmpValue = minHouseNumberValue;
        {
            char* o444 = 0;
            dbus_message_iter_get_basic(in, &o444);
            minHouseNumberTmpValue.assign (o444);
        }
        out.setMinHouseNumber(minHouseNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string maxHouseNumberValue;
        ::std::string &maxHouseNumberTmpValue = maxHouseNumberValue;
        {
            char* o445 = 0;
            dbus_message_iter_get_basic(in, &o445);
            maxHouseNumberTmpValue.assign (o445);
        }
        out.setMaxHouseNumber(maxHouseNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > patternsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o446ArrayIter;
            dbus_message_iter_recurse (in, &o446ArrayIter);

            if(dbus_message_iter_get_arg_type(&o446ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o447;
                    {
                        char* o448 = 0;
                        dbus_message_iter_get_basic(&o446ArrayIter, &o448);
                        o447.assign (o448);
                    }
                    patternsValue.push_back(o447);
                } while (dbus_message_iter_next(&o446ArrayIter));
            }
        }
        out.setPatterns(patternsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SelectSdsRefinementRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SelectSdsRefinementRequest& in, DBusMessageIter* out) {
    uint32 o449 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o449));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SelectSdsRefinementRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestAddressFormatForAvailableCountriesResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o450ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o450ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo >* o451 = &in.getAddressFormatInfos();
    ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo >::const_iterator o452 = o451->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo >::const_iterator o453 = o451->begin(); o453 != o452; ++o453) {
        serializeDBus((*o453), &o450ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o450ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo > addressFormatInfosValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o454ArrayIter;
            dbus_message_iter_recurse (in, &o454ArrayIter);

            if(dbus_message_iter_get_arg_type(&o454ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationSDSService::AddressFormatInfo o455;
                    if (!deserializeDBus(&o454ArrayIter, o455)) {
                        return false;
                    }
                    addressFormatInfosValue.push_back(o455);
                } while (dbus_message_iter_next(&o454ArrayIter));
            }
        }
        out.setAddressFormatInfos(addressFormatInfosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsShowReachableAreaMapRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::LocationType  o456 = in.getLocationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o456));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::LocationType locationTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT;
        dbus_message_iter_get_basic(in, &locationTypeValue);
        out.setLocationType(locationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsDatasetUserRegistrationRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser  o457 = in.getNdsDataSetUser();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o457));
    uint32 o458 = in.getDatasetId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o458));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser ndsDataSetUserValue = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
        dbus_message_iter_get_basic(in, &ndsDataSetUserValue);
        out.setNdsDataSetUser(ndsDataSetUserValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 datasetIdValue;
        uint32 &datasetIdTmpValue = datasetIdValue;
        dbus_message_iter_get_basic(in, &datasetIdTmpValue);
        out.setDatasetId(datasetIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsDatasetUserRegistrationResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus  o459 = in.getRegistrationStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o459));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus registrationStatusValue = ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK;
        dbus_message_iter_get_basic(in, &registrationStatusValue);
        out.setRegistrationStatus(registrationStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsDatasetUserDeregistrationRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser  o460 = in.getNdsDataSetUser();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o460));
    uint32 o461 = in.getDatasetId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o461));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser ndsDataSetUserValue = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
        dbus_message_iter_get_basic(in, &ndsDataSetUserValue);
        out.setNdsDataSetUser(ndsDataSetUserValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 datasetIdValue;
        uint32 &datasetIdTmpValue = datasetIdValue;
        dbus_message_iter_get_basic(in, &datasetIdTmpValue);
        out.setDatasetId(datasetIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsDatasetUserDeregistrationResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus  o462 = in.getDeregistrationStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o462));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus deregistrationStatusValue = ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK;
        dbus_message_iter_get_basic(in, &deregistrationStatusValue);
        out.setDeregistrationStatus(deregistrationStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DatasetAccessModeChangedIndicationRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser  o463 = in.getNdsDataSetUser();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o463));
    uint32 o464 = in.getDatasetId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o464));
    const ::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType  o465 = in.getNdsDataAccessType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o465));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser ndsDataSetUserValue = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
        dbus_message_iter_get_basic(in, &ndsDataSetUserValue);
        out.setNdsDataSetUser(ndsDataSetUserValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 datasetIdValue;
        uint32 &datasetIdTmpValue = datasetIdValue;
        dbus_message_iter_get_basic(in, &datasetIdTmpValue);
        out.setDatasetId(datasetIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType ndsDataAccessTypeValue = ::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED;
        dbus_message_iter_get_basic(in, &ndsDataAccessTypeValue);
        out.setNdsDataAccessType(ndsDataAccessTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MapUpdateRequestedUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::MapUpdateRequestedUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o466 = in.getMapUpdateRequested() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o466));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::MapUpdateRequestedUpdate& out) {
    {
        bool mapUpdateRequestedValue;
        bool &mapUpdateRequestedTmpValue = mapUpdateRequestedValue;
        {
            dbus_bool_t o467;
            dbus_message_iter_get_basic(in, &o467);
            mapUpdateRequestedTmpValue = o467 ? true : false;
        }
        out.setMapUpdateRequested(mapUpdateRequestedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MapUpdateRequestedRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::MapUpdateRequestedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::MapUpdateRequestedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HandOverSessionStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getHandOverSessionStatus(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatus handOverSessionStatusValue;
        if (!deserializeDBus(in, handOverSessionStatusValue)) {
            return false;
        }
        out.setHandOverSessionStatus(handOverSessionStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HandOverSessionStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PositionStatusInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getPositionStatusInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfo positionStatusInfoValue;
        if (!deserializeDBus(in, positionStatusInfoValue)) {
            return false;
        }
        out.setPositionStatusInfo(positionStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PositionStatusInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PositionInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getPositionInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::PositionInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::PositionInfo positionInfoValue;
        if (!deserializeDBus(in, positionInfoValue)) {
            return false;
        }
        out.setPositionInfo(positionInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PositionInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::PositionInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::PositionInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SdsAddressWithOptionsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsAddressWithOptionsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSdsAddressWithOptions(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsAddressWithOptionsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressWithOptions sdsAddressWithOptionsValue;
        if (!deserializeDBus(in, sdsAddressWithOptionsValue)) {
            return false;
        }
        out.setSdsAddressWithOptions(sdsAddressWithOptionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsAddressWithOptionsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsAddressWithOptionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::SdsAddressWithOptionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SdsVoiceTagWithOptionsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsVoiceTagWithOptionsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSdsVoiceTagWithOptions(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::SdsVoiceTagWithOptionsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagId sdsVoiceTagWithOptionsValue;
        if (!deserializeDBus(in, sdsVoiceTagWithOptionsValue)) {
            return false;
        }
        out.setSdsVoiceTagWithOptions(sdsVoiceTagWithOptionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsVoiceTagWithOptionsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::SdsVoiceTagWithOptionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::SdsVoiceTagWithOptionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NavDatasetInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getNavDatasetInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::NavDataSetInfo navDatasetInfoValue;
        if (!deserializeDBus(in, navDatasetInfoValue)) {
            return false;
        }
        out.setNavDatasetInfo(navDatasetInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavDatasetInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DynamicMapPoiCategoryWithLanguageUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getDynamicMapPoiCategoryWithLanguage(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoriesWithLanguage dynamicMapPoiCategoryWithLanguageValue;
        if (!deserializeDBus(in, dynamicMapPoiCategoryWithLanguageValue)) {
            return false;
        }
        out.setDynamicMapPoiCategoryWithLanguage(dynamicMapPoiCategoryWithLanguageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DynamicMapPoiCategoryWithLanguageRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageRegister& /*out*/) {
    return true;
}

