#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICE_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "org.bosch.cm.navigation.NavigationSDSService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationSDSService {

// method IDs
static const uint16 ID_getGlobalDataForSds = 0;
static const uint16 ID_getIdListOfCountryAndSubCountry = 1;
static const uint16 ID_getNamesForNDSIds = 2;
static const uint16 ID_getPhonemesForNDSIds = 3;
static const uint16 ID_getCityHasStreets = 4;
static const uint16 ID_ndsDatasetReleased = 5;
static const uint16 ID_getHapticHandOverData = 6;
static const uint16 ID_selectHapticHandOverList = 7;
static const uint16 ID_getDynamicPoiIconCategoriesInMap = 8;
static const uint16 ID_getMaxWaypointCount = 9;
static const uint16 ID_setDynamicPoiIconCategoriesInMap = 10;
static const uint16 ID_sdsCheckAddress = 11;
static const uint16 ID_sdsGetRefinementList = 12;
static const uint16 ID_sdsUpdateVoiceTag = 13;
static const uint16 ID_sdsGetHouseNumberPattern = 14;
static const uint16 ID_selectSdsRefinement = 15;
static const uint16 ID_setLocationWithSdsInput = 16;
static const uint16 ID_requestAddressFormatForAvailableCountries = 17;
static const uint16 ID_sdsShowReachableAreaMap = 18;
static const uint16 ID_sdsDatasetUserRegistration = 19;
static const uint16 ID_sdsDatasetUserDeregistration = 20;
static const uint16 ID_datasetAccessModeChangedIndication = 21;

// signal IDs

// property IDs
static const uint16 ID_mapUpdateRequested = 22;
static const uint16 ID_handOverSessionStatus = 23;
static const uint16 ID_positionStatusInfo = 24;
static const uint16 ID_positionInfo = 25;
static const uint16 ID_sdsAddressWithOptions = 26;
static const uint16 ID_sdsVoiceTagWithOptions = 27;
static const uint16 ID_navDatasetInfo = 28;
static const uint16 ID_dynamicMapPoiCategoryWithLanguage = 29;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SDSVoiceTagId;

class SDSElementOptions;

class SDSAddressElement;

class SDSAddressOptions;

class SDSAddressWithOptions;

class RefinementListElement;

class AddressListElement;

class LanguageVersion;

class PhoneticTraMetadata;

class PrerecordedVMetadata;

class SpeechMetadata;

class SdsBuildingBlocks;

class SdsRegionMetadata;

class SdsUpdateRegions;

class LanguageEntry;

class SdsLanguages;

class SdsProducts;

class GlobalUpdateRegionId;

class GlobalNamedObjectId;

class GlobalNamedObjectAndRegionId;

class SubCountryIds;

class NamedObjectIdStrings;

class CityNamedObjectIdHasStreets;

class UpdateRegionSpecifierRelations;

class HandOverSessionStatus;

class SelectedDataItem;

class SDSHandOverOptions;

class NDSNamedObjectData;

class PositionInfo;

class PositionWGS84;

class PositionStatusInfo;

class DynamicMapPoiCategory;

class DynamicMapPoiCategoriesWithLanguage;

class AddressFormatInfo;

class SharedDataAccessAttributes;

class NavDataSetInfo;

class HapticData;

class GetGlobalDataForSdsResponse;

class GetIdListOfCountryAndSubCountryResponse;

class GetNamesForNDSIdsRequest;

class GetNamesForNDSIdsResponse;

class GetPhonemesForNDSIdsRequest;

class GetPhonemesForNDSIdsResponse;

class GetCityHasStreetsRequest;

class GetCityHasStreetsResponse;

class GetHapticHandOverDataResponse;

class SelectHapticHandOverListRequest;

class GetDynamicPoiIconCategoriesInMapResponse;

class GetMaxWaypointCountResponse;

class SetDynamicPoiIconCategoriesInMapRequest;

class SdsCheckAddressRequest;

class SdsGetRefinementListResponse;

class SdsUpdateVoiceTagRequest;

class SdsGetHouseNumberPatternResponse;

class SelectSdsRefinementRequest;

class RequestAddressFormatForAvailableCountriesResponse;

class SdsShowReachableAreaMapRequest;

class SdsDatasetUserRegistrationRequest;

class SdsDatasetUserRegistrationResponse;

class SdsDatasetUserDeregistrationRequest;

class SdsDatasetUserDeregistrationResponse;

class DatasetAccessModeChangedIndicationRequest;

class MapUpdateRequestedUpdate;

class MapUpdateRequestedRegister;

class HandOverSessionStatusUpdate;

class HandOverSessionStatusRegister;

class PositionStatusInfoUpdate;

class PositionStatusInfoRegister;

class PositionInfoUpdate;

class PositionInfoRegister;

class SdsAddressWithOptionsUpdate;

class SdsAddressWithOptionsRegister;

class SdsVoiceTagWithOptionsUpdate;

class SdsVoiceTagWithOptionsRegister;

class NavDatasetInfoUpdate;

class NavDatasetInfoRegister;

class DynamicMapPoiCategoryWithLanguageUpdate;

class DynamicMapPoiCategoryWithLanguageRegister;

// type definitions
/**
 * Method to get the SDS specific nds data
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetGlobalDataForSdsRequest;

/**
 * If the meaning of "GetGlobalDataForSdsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetGlobalDataForSdsError;

/**
 * Method to get the list of object ids for all countries and subcountries
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetIdListOfCountryAndSubCountryRequest;

/**
 * If the meaning of "GetIdListOfCountryAndSubCountryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetIdListOfCountryAndSubCountryError;

/**
 * If the meaning of "GetNamesForNDSIdsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNamesForNDSIdsError;

/**
 * If the meaning of "GetPhonemesForNDSIdsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPhonemesForNDSIdsError;

/**
 * If the meaning of "GetCityHasStreetsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetCityHasStreetsError;

/**
 * Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NdsDatasetReleasedRequest;

/**
 * Method to be triggered when sds has released the nds dataset.This will be triggered when attribute mapUpdateRequested is sent as TRUE by the HMI
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NdsDatasetReleasedResponse;

/**
 * If the meaning of "NdsDatasetReleasedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NdsDatasetReleasedError;

/**
 * Request will get handover screen and data along with location type and address options.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetHapticHandOverDataRequest;

/**
 * If the meaning of "GetHapticHandOverDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetHapticHandOverDataError;

/**
 * Request will send the selected index from the HMI list.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectHapticHandOverListResponse;

/**
 * If the meaning of "SelectHapticHandOverListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectHapticHandOverListError;

/**
 * Returns the currently available POI icon categories in map
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetDynamicPoiIconCategoriesInMapRequest;

/**
 * If the meaning of "GetDynamicPoiIconCategoriesInMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetDynamicPoiIconCategoriesInMapError;

/**
 * Returns max number of waypoint base on project variant
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetMaxWaypointCountRequest;

/**
 * If the meaning of "GetMaxWaypointCountError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetMaxWaypointCountError;

/**
 * Request to show POI icons on map.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetDynamicPoiIconCategoriesInMapResponse;

/**
 * If the meaning of "SetDynamicPoiIconCategoriesInMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetDynamicPoiIconCategoriesInMapError;

/**
 * Request will validate the given address,
 *        as result it update the attribute sdsAddressWithOptions
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsCheckAddressResponse;

/**
 * If the meaning of "SdsCheckAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsCheckAddressError;

/**
 * Request will get refinement list for the validated address
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsGetRefinementListRequest;

/**
 * If the meaning of "SdsGetRefinementListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsGetRefinementListError;

/**
 * Method used to store/delete the VoiceTagId in the destination memory database
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsUpdateVoiceTagResponse;

/**
 * If the meaning of "SdsUpdateVoiceTagError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsUpdateVoiceTagError;

/**
 * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsGetHouseNumberPatternRequest;

/**
 * If the meaning of "SdsGetHouseNumberPatternError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsGetHouseNumberPatternError;

/**
 * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
 *        As result it update the attribute sdsAddressWithOptions
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectSdsRefinementResponse;

/**
 * If the meaning of "SelectSdsRefinementError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectSdsRefinementError;

/**
 * Request will set the SDS Address as destination or waypoint
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithSdsInputRequest;

/**
 * Request will set the SDS Address as destination or waypoint
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithSdsInputResponse;

/**
 * If the meaning of "SetLocationWithSdsInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithSdsInputError;

/**
 * Request for Address format for all the available countries in Navigation Data
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestAddressFormatForAvailableCountriesRequest;

/**
 * If the meaning of "RequestAddressFormatForAvailableCountriesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestAddressFormatForAvailableCountriesError;

/**
 * Request navigation to show driving range on map and contextSwitch
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsShowReachableAreaMapResponse;

/**
 * If the meaning of "SdsShowReachableAreaMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsShowReachableAreaMapError;

/**
 * If the meaning of "SdsDatasetUserRegistrationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsDatasetUserRegistrationError;

/**
 * If the meaning of "SdsDatasetUserDeregistrationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsDatasetUserDeregistrationError;

/**
 * Request to change dataset access mode
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DatasetAccessModeChangedIndicationResponse;

/**
 * If the meaning of "DatasetAccessModeChangedIndicationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DatasetAccessModeChangedIndicationError;

/**
 * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
 */
typedef MapUpdateRequestedUpdate MapUpdateRequestedSet;

/**
 * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
 */
typedef MapUpdateRequestedUpdate MapUpdateRequestedGet;

/**
 * If the meaning of "MapUpdateRequestedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapUpdateRequestedError;

/**
 * Attribute provides current HMI screen and lockout mode status
 */
typedef HandOverSessionStatusUpdate HandOverSessionStatusSet;

/**
 * Attribute provides current HMI screen and lockout mode status
 */
typedef HandOverSessionStatusUpdate HandOverSessionStatusGet;

/**
 * If the meaning of "HandOverSessionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HandOverSessionStatusError;

/**
 * Attribute provides current vehicle position status information
 */
typedef PositionStatusInfoUpdate PositionStatusInfoSet;

/**
 * Attribute provides current vehicle position status information
 */
typedef PositionStatusInfoUpdate PositionStatusInfoGet;

/**
 * If the meaning of "PositionStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PositionStatusInfoError;

/**
 * Attribute provides current vehicle position information
 */
typedef PositionInfoUpdate PositionInfoSet;

/**
 * Attribute provides current vehicle position information
 */
typedef PositionInfoUpdate PositionInfoGet;

/**
 * If the meaning of "PositionInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PositionInfoError;

/**
 * Attribute provides the current SDS address entry
 */
typedef SdsAddressWithOptionsUpdate SdsAddressWithOptionsSet;

/**
 * Attribute provides the current SDS address entry
 */
typedef SdsAddressWithOptionsUpdate SdsAddressWithOptionsGet;

/**
 * If the meaning of "SdsAddressWithOptionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsAddressWithOptionsError;

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
typedef SdsVoiceTagWithOptionsUpdate SdsVoiceTagWithOptionsSet;

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
typedef SdsVoiceTagWithOptionsUpdate SdsVoiceTagWithOptionsGet;

/**
 * If the meaning of "SdsVoiceTagWithOptionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsVoiceTagWithOptionsError;

/**
 * Attribute provides current navDatasetInfo
 */
typedef NavDatasetInfoUpdate NavDatasetInfoSet;

/**
 * Attribute provides current navDatasetInfo
 */
typedef NavDatasetInfoUpdate NavDatasetInfoGet;

/**
 * If the meaning of "NavDatasetInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NavDatasetInfoError;

/**
 * Attribute provides current DynamicMapPoiCategories
 */
typedef DynamicMapPoiCategoryWithLanguageUpdate DynamicMapPoiCategoryWithLanguageSet;

/**
 * Attribute provides current DynamicMapPoiCategories
 */
typedef DynamicMapPoiCategoryWithLanguageUpdate DynamicMapPoiCategoryWithLanguageGet;

/**
 * If the meaning of "DynamicMapPoiCategoryWithLanguageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DynamicMapPoiCategoryWithLanguageError;


/**
 * If the meaning of "SDSVoiceTagId" isn't clear, then there should be a description here.
 */
class SDSVoiceTagId {
public:

    /**
     * Default constructor
     */
    inline  SDSVoiceTagId ();

    /**
     * Copy constructor
     */
    inline  SDSVoiceTagId (const SDSVoiceTagId &rhs);

    /**
     * All fields constructor
     */
    inline  SDSVoiceTagId (uint64 destinationMemoryEntryId_, const ::std::string& destinationMemoryEntryName_, uint32 sdsVoiceTagId_, SDSVoiceTagOptions options_);

    /**
     * Destructor
     */
    inline  ~SDSVoiceTagId();

    /**
     * Assignment operator
     */
    inline SDSVoiceTagId& operator = (const SDSVoiceTagId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSVoiceTagId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSVoiceTagId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSVoiceTagId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSVoiceTagId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destinationMemoryEntryId"

    static const int kDestinationMemoryEntryId = 0;

    /**
     * Clears the field "destinationMemoryEntryId".
     *
     * The field will be set to its default value. The hasDestinationMemoryEntryId()
     * method will return false.
     */
    inline void clearDestinationMemoryEntryId();

    /**
     * Checks whether the field "destinationMemoryEntryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryEntryId()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryEntryId () const;

    /**
     * Returns the value of the member "destinationMemoryEntryId".
     *
     * If the meaning of "destinationMemoryEntryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryEntryId"
     */
    inline uint64 getDestinationMemoryEntryId () const;

    /**
     * Sets the value of the member "destinationMemoryEntryId".
     *
     * If the meaning of "destinationMemoryEntryId" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryId The value which will be set
     */
    inline void setDestinationMemoryEntryId (uint64 destinationMemoryEntryId_);

    // API of field "destinationMemoryEntryName"

    static const int kDestinationMemoryEntryName = 1;

    /**
     * Clears the field "destinationMemoryEntryName".
     *
     * The field will be set to its default value. The hasDestinationMemoryEntryName()
     * method will return false.
     */
    inline void clearDestinationMemoryEntryName();

    /**
     * Checks whether the field "destinationMemoryEntryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryEntryName()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryEntryName () const;

    /**
     * Returns the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryEntryName"
     */
    inline const ::std::string& getDestinationMemoryEntryName () const;

    /**
     * Retrieves the value of the field "destinationMemoryEntryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationMemoryEntryName".
     */
    inline ::std::string& getDestinationMemoryEntryNameMutable ();

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const ::std::string& destinationMemoryEntryName_);

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const char* destinationMemoryEntryName_);

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const char* value, size_t size);

    // API of field "sdsVoiceTagId"

    static const int kSdsVoiceTagId = 2;

    /**
     * Clears the field "sdsVoiceTagId".
     *
     * The field will be set to its default value. The hasSdsVoiceTagId()
     * method will return false.
     */
    inline void clearSdsVoiceTagId();

    /**
     * Checks whether the field "sdsVoiceTagId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsVoiceTagId()). Otherwise it will return false.
     */
    inline bool hasSdsVoiceTagId () const;

    /**
     * Returns the value of the member "sdsVoiceTagId".
     *
     * If the meaning of "sdsVoiceTagId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsVoiceTagId"
     */
    inline uint32 getSdsVoiceTagId () const;

    /**
     * Sets the value of the member "sdsVoiceTagId".
     *
     * If the meaning of "sdsVoiceTagId" isn't clear, then there should be a description here.
     *
     * @param sdsVoiceTagId The value which will be set
     */
    inline void setSdsVoiceTagId (uint32 sdsVoiceTagId_);

    // API of field "options"

    static const int kOptions = 3;

    /**
     * Clears the field "options".
     *
     * The field will be set to its default value. The hasOptions()
     * method will return false.
     */
    inline void clearOptions();

    /**
     * Checks whether the field "options" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOptions()). Otherwise it will return false.
     */
    inline bool hasOptions () const;

    /**
     * Returns the value of the member "options".
     *
     * If the meaning of "options" isn't clear, then there should be a description here.
     *
     * @return The value of the field "options"
     */
    inline SDSVoiceTagOptions getOptions () const;

    /**
     * Sets the value of the member "options".
     *
     * If the meaning of "options" isn't clear, then there should be a description here.
     *
     * @param options The value which will be set
     */
    inline void setOptions (SDSVoiceTagOptions options_);

    static const SDSVoiceTagId &getDefaultInstance();

private:

    inline void set_has_destinationMemoryEntryId ();

    inline void clear_has_destinationMemoryEntryId ();

    inline void set_has_destinationMemoryEntryName ();

    inline void clear_has_destinationMemoryEntryName ();

    inline void set_has_sdsVoiceTagId ();

    inline void clear_has_sdsVoiceTagId ();

    inline void set_has_options ();

    inline void clear_has_options ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint64 _destinationMemoryEntryId;

    ::std::string _destinationMemoryEntryName;

    uint32 _sdsVoiceTagId;

    SDSVoiceTagOptions _options;

};

/**
 * this struct can transport additional flags per element of the address
 */
class SDSElementOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSElementOptions ();

    /**
     * Copy constructor
     */
    inline  SDSElementOptions (const SDSElementOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSElementOptions (bool isAmbigious_);

    /**
     * Destructor
     */
    inline  ~SDSElementOptions();

    /**
     * Assignment operator
     */
    inline SDSElementOptions& operator = (const SDSElementOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSElementOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSElementOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSElementOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSElementOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isAmbigious"

    static const int kIsAmbigious = 0;

    /**
     * Clears the field "isAmbigious".
     *
     * The field will be set to its default value. The hasIsAmbigious()
     * method will return false.
     */
    inline void clearIsAmbigious();

    /**
     * Checks whether the field "isAmbigious" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAmbigious()). Otherwise it will return false.
     */
    inline bool hasIsAmbigious () const;

    /**
     * Returns the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isAmbigious"
     */
    inline bool getIsAmbigious () const;

    /**
     * Sets the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @param isAmbigious The value which will be set
     */
    inline void setIsAmbigious (bool isAmbigious_);

    static const SDSElementOptions &getDefaultInstance();

private:

    inline void set_has_isAmbigious ();

    inline void clear_has_isAmbigious ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isAmbigious;

};

/**
 * struct of an element of the address entries with type and options
 */
class SDSAddressElement {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressElement ();

    /**
     * Copy constructor
     */
    inline  SDSAddressElement (const SDSAddressElement &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressElement (SDSAddressElementType addressElementType_, const ::std::string& data_, const SDSElementOptions& elementOptions_);

    /**
     * Destructor
     */
    inline  ~SDSAddressElement();

    /**
     * Assignment operator
     */
    inline SDSAddressElement& operator = (const SDSAddressElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "addressElementType"

    static const int kAddressElementType = 0;

    /**
     * Clears the field "addressElementType".
     *
     * The field will be set to its default value. The hasAddressElementType()
     * method will return false.
     */
    inline void clearAddressElementType();

    /**
     * Checks whether the field "addressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressElementType()). Otherwise it will return false.
     */
    inline bool hasAddressElementType () const;

    /**
     * Returns the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressElementType"
     */
    inline SDSAddressElementType getAddressElementType () const;

    /**
     * Sets the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @param addressElementType The value which will be set
     */
    inline void setAddressElementType (SDSAddressElementType addressElementType_);

    // API of field "data"

    static const int kData = 1;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "elementOptions"

    static const int kElementOptions = 2;

    /**
     * Clears the field "elementOptions".
     *
     * The field will be set to its default value. The hasElementOptions()
     * method will return false.
     */
    inline void clearElementOptions();

    /**
     * Checks whether the field "elementOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElementOptions()). Otherwise it will return false.
     */
    inline bool hasElementOptions () const;

    /**
     * Returns the value of the member "elementOptions".
     *
     * If the meaning of "elementOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elementOptions"
     */
    inline const SDSElementOptions& getElementOptions () const;

    /**
     * Retrieves the value of the field "elementOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elementOptions".
     */
    inline SDSElementOptions& getElementOptionsMutable ();

    /**
     * Sets the value of the member "elementOptions".
     *
     * If the meaning of "elementOptions" isn't clear, then there should be a description here.
     *
     * @param elementOptions The value which will be set
     */
    inline void setElementOptions (const SDSElementOptions& elementOptions_);

    static const SDSAddressElement &getDefaultInstance();

private:

    inline void set_has_addressElementType ();

    inline void clear_has_addressElementType ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_elementOptions ();

    inline void clear_has_elementOptions ();

    uint32 _has_bits_[ (3 + 31) / 32];

    SDSAddressElementType _addressElementType;

    ::std::string _data;

    SDSElementOptions _elementOptions;

};

/**
 * this struct includes addtional flags for the complete address
 */
class SDSAddressOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressOptions ();

    /**
     * Copy constructor
     */
    inline  SDSAddressOptions (const SDSAddressOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressOptions (bool navigable_, bool ambigious_, bool removedInvalidEntry_, bool moreEntriesPossible_, bool houseNumberAvailable_, bool houseNumberValid_);

    /**
     * Destructor
     */
    inline  ~SDSAddressOptions();

    /**
     * Assignment operator
     */
    inline SDSAddressOptions& operator = (const SDSAddressOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navigable"

    static const int kNavigable = 0;

    /**
     * Clears the field "navigable".
     *
     * The field will be set to its default value. The hasNavigable()
     * method will return false.
     */
    inline void clearNavigable();

    /**
     * Checks whether the field "navigable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigable()). Otherwise it will return false.
     */
    inline bool hasNavigable () const;

    /**
     * Returns the value of the member "navigable".
     *
     * If the meaning of "navigable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "navigable"
     */
    inline bool getNavigable () const;

    /**
     * Sets the value of the member "navigable".
     *
     * If the meaning of "navigable" isn't clear, then there should be a description here.
     *
     * @param navigable The value which will be set
     */
    inline void setNavigable (bool navigable_);

    // API of field "ambigious"

    static const int kAmbigious = 1;

    /**
     * Clears the field "ambigious".
     *
     * The field will be set to its default value. The hasAmbigious()
     * method will return false.
     */
    inline void clearAmbigious();

    /**
     * Checks whether the field "ambigious" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmbigious()). Otherwise it will return false.
     */
    inline bool hasAmbigious () const;

    /**
     * Returns the value of the member "ambigious".
     *
     * If the meaning of "ambigious" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ambigious"
     */
    inline bool getAmbigious () const;

    /**
     * Sets the value of the member "ambigious".
     *
     * If the meaning of "ambigious" isn't clear, then there should be a description here.
     *
     * @param ambigious The value which will be set
     */
    inline void setAmbigious (bool ambigious_);

    // API of field "removedInvalidEntry"

    static const int kRemovedInvalidEntry = 2;

    /**
     * Clears the field "removedInvalidEntry".
     *
     * The field will be set to its default value. The hasRemovedInvalidEntry()
     * method will return false.
     */
    inline void clearRemovedInvalidEntry();

    /**
     * Checks whether the field "removedInvalidEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemovedInvalidEntry()). Otherwise it will return false.
     */
    inline bool hasRemovedInvalidEntry () const;

    /**
     * Returns the value of the member "removedInvalidEntry".
     *
     * If the meaning of "removedInvalidEntry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removedInvalidEntry"
     */
    inline bool getRemovedInvalidEntry () const;

    /**
     * Sets the value of the member "removedInvalidEntry".
     *
     * If the meaning of "removedInvalidEntry" isn't clear, then there should be a description here.
     *
     * @param removedInvalidEntry The value which will be set
     */
    inline void setRemovedInvalidEntry (bool removedInvalidEntry_);

    // API of field "moreEntriesPossible"

    static const int kMoreEntriesPossible = 3;

    /**
     * Clears the field "moreEntriesPossible".
     *
     * The field will be set to its default value. The hasMoreEntriesPossible()
     * method will return false.
     */
    inline void clearMoreEntriesPossible();

    /**
     * Checks whether the field "moreEntriesPossible" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMoreEntriesPossible()). Otherwise it will return false.
     */
    inline bool hasMoreEntriesPossible () const;

    /**
     * Returns the value of the member "moreEntriesPossible".
     *
     * If the meaning of "moreEntriesPossible" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moreEntriesPossible"
     */
    inline bool getMoreEntriesPossible () const;

    /**
     * Sets the value of the member "moreEntriesPossible".
     *
     * If the meaning of "moreEntriesPossible" isn't clear, then there should be a description here.
     *
     * @param moreEntriesPossible The value which will be set
     */
    inline void setMoreEntriesPossible (bool moreEntriesPossible_);

    // API of field "houseNumberAvailable"

    static const int kHouseNumberAvailable = 4;

    /**
     * Clears the field "houseNumberAvailable".
     *
     * The field will be set to its default value. The hasHouseNumberAvailable()
     * method will return false.
     */
    inline void clearHouseNumberAvailable();

    /**
     * Checks whether the field "houseNumberAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseNumberAvailable()). Otherwise it will return false.
     */
    inline bool hasHouseNumberAvailable () const;

    /**
     * Returns the value of the member "houseNumberAvailable".
     *
     * If the meaning of "houseNumberAvailable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseNumberAvailable"
     */
    inline bool getHouseNumberAvailable () const;

    /**
     * Sets the value of the member "houseNumberAvailable".
     *
     * If the meaning of "houseNumberAvailable" isn't clear, then there should be a description here.
     *
     * @param houseNumberAvailable The value which will be set
     */
    inline void setHouseNumberAvailable (bool houseNumberAvailable_);

    // API of field "houseNumberValid"

    static const int kHouseNumberValid = 5;

    /**
     * Clears the field "houseNumberValid".
     *
     * The field will be set to its default value. The hasHouseNumberValid()
     * method will return false.
     */
    inline void clearHouseNumberValid();

    /**
     * Checks whether the field "houseNumberValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseNumberValid()). Otherwise it will return false.
     */
    inline bool hasHouseNumberValid () const;

    /**
     * Returns the value of the member "houseNumberValid".
     *
     * If the meaning of "houseNumberValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseNumberValid"
     */
    inline bool getHouseNumberValid () const;

    /**
     * Sets the value of the member "houseNumberValid".
     *
     * If the meaning of "houseNumberValid" isn't clear, then there should be a description here.
     *
     * @param houseNumberValid The value which will be set
     */
    inline void setHouseNumberValid (bool houseNumberValid_);

    static const SDSAddressOptions &getDefaultInstance();

private:

    inline void set_has_navigable ();

    inline void clear_has_navigable ();

    inline void set_has_ambigious ();

    inline void clear_has_ambigious ();

    inline void set_has_removedInvalidEntry ();

    inline void clear_has_removedInvalidEntry ();

    inline void set_has_moreEntriesPossible ();

    inline void clear_has_moreEntriesPossible ();

    inline void set_has_houseNumberAvailable ();

    inline void clear_has_houseNumberAvailable ();

    inline void set_has_houseNumberValid ();

    inline void clear_has_houseNumberValid ();

    uint32 _has_bits_[ (6 + 31) / 32];

    bool _navigable;

    bool _ambigious;

    bool _removedInvalidEntry;

    bool _moreEntriesPossible;

    bool _houseNumberAvailable;

    bool _houseNumberValid;

};

/**
 * struct for an address with options and possible extension types
 */
class SDSAddressWithOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressWithOptions ();

    /**
     * Copy constructor
     */
    inline  SDSAddressWithOptions (const SDSAddressWithOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressWithOptions (const ::std::vector< SDSAddressElement >& address_, const SDSAddressOptions& addressOptions_, const ::std::vector< SDSAddressElementType >& addressElementType_);

    /**
     * Destructor
     */
    inline  ~SDSAddressWithOptions();

    /**
     * Assignment operator
     */
    inline SDSAddressWithOptions& operator = (const SDSAddressWithOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressWithOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressWithOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressWithOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressWithOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::vector< SDSAddressElement >& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::vector< SDSAddressElement >& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::vector< SDSAddressElement >& address_);

    // API of field "addressOptions"

    static const int kAddressOptions = 1;

    /**
     * Clears the field "addressOptions".
     *
     * The field will be set to its default value. The hasAddressOptions()
     * method will return false.
     */
    inline void clearAddressOptions();

    /**
     * Checks whether the field "addressOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressOptions()). Otherwise it will return false.
     */
    inline bool hasAddressOptions () const;

    /**
     * Returns the value of the member "addressOptions".
     *
     * If the meaning of "addressOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressOptions"
     */
    inline const SDSAddressOptions& getAddressOptions () const;

    /**
     * Retrieves the value of the field "addressOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressOptions".
     */
    inline SDSAddressOptions& getAddressOptionsMutable ();

    /**
     * Sets the value of the member "addressOptions".
     *
     * If the meaning of "addressOptions" isn't clear, then there should be a description here.
     *
     * @param addressOptions The value which will be set
     */
    inline void setAddressOptions (const SDSAddressOptions& addressOptions_);

    // API of field "addressElementType"

    static const int kAddressElementType = 2;

    /**
     * Clears the field "addressElementType".
     *
     * The field will be set to its default value. The hasAddressElementType()
     * method will return false.
     */
    inline void clearAddressElementType();

    /**
     * Checks whether the field "addressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressElementType()). Otherwise it will return false.
     */
    inline bool hasAddressElementType () const;

    /**
     * Returns the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressElementType"
     */
    inline const ::std::vector< SDSAddressElementType >& getAddressElementType () const;

    /**
     * Retrieves the value of the field "addressElementType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressElementType".
     */
    inline ::std::vector< SDSAddressElementType >& getAddressElementTypeMutable ();

    /**
     * Sets the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @param addressElementType The value which will be set
     */
    inline void setAddressElementType (const ::std::vector< SDSAddressElementType >& addressElementType_);

    static const SDSAddressWithOptions &getDefaultInstance();

private:

    static const ::std::vector< SDSAddressElement >& getSDSAddressElementList_DefaultInstance ();

    static const ::std::vector< SDSAddressElementType >& getSDSAddressElementTypeList_DefaultInstance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_addressOptions ();

    inline void clear_has_addressOptions ();

    inline void set_has_addressElementType ();

    inline void clear_has_addressElementType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< SDSAddressElement > _address;

    SDSAddressOptions _addressOptions;

    ::std::vector< SDSAddressElementType > _addressElementType;

};

/**
 * If the meaning of "RefinementListElement" isn't clear, then there should be a description here.
 */
class RefinementListElement {
public:

    /**
     * Default constructor
     */
    inline  RefinementListElement ();

    /**
     * Copy constructor
     */
    inline  RefinementListElement (const RefinementListElement &rhs);

    /**
     * All fields constructor
     */
    inline  RefinementListElement (const ::std::string& data_, uint32 id_, const ::std::string& distance_, DirectionDescription direction_);

    /**
     * Destructor
     */
    inline  ~RefinementListElement();

    /**
     * Assignment operator
     */
    inline RefinementListElement& operator = (const RefinementListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefinementListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefinementListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefinementListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefinementListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * Element Name
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "id"

    static const int kId = 1;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    // API of field "distance"

    static const int kDistance = 2;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "direction"

    static const int kDirection = 3;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @return The value of the field "direction"
     */
    inline DirectionDescription getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @param direction The value which will be set
     */
    inline void setDirection (DirectionDescription direction_);

    static const RefinementListElement &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _data;

    uint32 _id;

    ::std::string _distance;

    DirectionDescription _direction;

};

/**
 * If the meaning of "AddressListElement" isn't clear, then there should be a description here.
 */
class AddressListElement {
public:

    /**
     * Default constructor
     */
    inline  AddressListElement ();

    /**
     * Copy constructor
     */
    inline  AddressListElement (const AddressListElement &rhs);

    /**
     * All fields constructor
     */
    inline  AddressListElement (const ::std::string& data_, uint64 id_, const ::std::string& distance_, const ::std::string& address_, DirectionDescription direction_);

    /**
     * Destructor
     */
    inline  ~AddressListElement();

    /**
     * Assignment operator
     */
    inline AddressListElement& operator = (const AddressListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "id"

    static const int kId = 1;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * id is the identifier for the Search item, Should be used when item is selected for Starting Route Guidance
     *
     * @return The value of the field "id"
     */
    inline uint64 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * id is the identifier for the Search item, Should be used when item is selected for Starting Route Guidance
     *
     * @param id The value which will be set
     */
    inline void setId (uint64 id_);

    // API of field "distance"

    static const int kDistance = 2;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "address"

    static const int kAddress = 3;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * Poi address description
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "direction"

    static const int kDirection = 4;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @return The value of the field "direction"
     */
    inline DirectionDescription getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @param direction The value which will be set
     */
    inline void setDirection (DirectionDescription direction_);

    static const AddressListElement &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _data;

    uint64 _id;

    ::std::string _distance;

    ::std::string _address;

    DirectionDescription _direction;

};

/**
 * struct contains language code and  specificationVersion
 */
class LanguageVersion {
public:

    /**
     * Default constructor
     */
    inline  LanguageVersion ();

    /**
     * Copy constructor
     */
    inline  LanguageVersion (const LanguageVersion &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageVersion (uint16 languageCode_, const ::std::string& specificationVersion_);

    /**
     * Destructor
     */
    inline  ~LanguageVersion();

    /**
     * Assignment operator
     */
    inline LanguageVersion& operator = (const LanguageVersion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageVersion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageVersion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageVersion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageVersion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "languageCode"

    static const int kLanguageCode = 0;

    /**
     * Clears the field "languageCode".
     *
     * The field will be set to its default value. The hasLanguageCode()
     * method will return false.
     */
    inline void clearLanguageCode();

    /**
     * Checks whether the field "languageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageCode()). Otherwise it will return false.
     */
    inline bool hasLanguageCode () const;

    /**
     * Returns the value of the member "languageCode".
     *
     * If the meaning of "languageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageCode"
     */
    inline uint16 getLanguageCode () const;

    /**
     * Sets the value of the member "languageCode".
     *
     * If the meaning of "languageCode" isn't clear, then there should be a description here.
     *
     * @param languageCode The value which will be set
     */
    inline void setLanguageCode (uint16 languageCode_);

    // API of field "specificationVersion"

    static const int kSpecificationVersion = 1;

    /**
     * Clears the field "specificationVersion".
     *
     * The field will be set to its default value. The hasSpecificationVersion()
     * method will return false.
     */
    inline void clearSpecificationVersion();

    /**
     * Checks whether the field "specificationVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpecificationVersion()). Otherwise it will return false.
     */
    inline bool hasSpecificationVersion () const;

    /**
     * Returns the value of the member "specificationVersion".
     *
     * If the meaning of "specificationVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "specificationVersion"
     */
    inline const ::std::string& getSpecificationVersion () const;

    /**
     * Retrieves the value of the field "specificationVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "specificationVersion".
     */
    inline ::std::string& getSpecificationVersionMutable ();

    /**
     * Sets the value of the member "specificationVersion".
     *
     * If the meaning of "specificationVersion" isn't clear, then there should be a description here.
     *
     * @param specificationVersion The value which will be set
     */
    inline void setSpecificationVersion (const ::std::string& specificationVersion_);

    /**
     * Sets the value of the member "specificationVersion".
     *
     * If the meaning of "specificationVersion" isn't clear, then there should be a description here.
     *
     * @param specificationVersion The value which will be set
     */
    inline void setSpecificationVersion (const char* specificationVersion_);

    /**
     * Sets the value of the member "specificationVersion".
     *
     * If the meaning of "specificationVersion" isn't clear, then there should be a description here.
     *
     * @param specificationVersion The value which will be set
     */
    inline void setSpecificationVersion (const char* value, size_t size);

    static const LanguageVersion &getDefaultInstance();

private:

    inline void set_has_languageCode ();

    inline void clear_has_languageCode ();

    inline void set_has_specificationVersion ();

    inline void clear_has_specificationVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _languageCode;

    ::std::string _specificationVersion;

};

/**
 * struct contains phonetic transcription format and language version used by speech meta data
 */
class PhoneticTraMetadata {
public:

    /**
     * Default constructor
     */
    inline  PhoneticTraMetadata ();

    /**
     * Copy constructor
     */
    inline  PhoneticTraMetadata (const PhoneticTraMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneticTraMetadata (PhoneticTranscriptionFormat phoneticTranscriptionFormat_, const ::std::vector< LanguageVersion >& languageVersionList_);

    /**
     * Destructor
     */
    inline  ~PhoneticTraMetadata();

    /**
     * Assignment operator
     */
    inline PhoneticTraMetadata& operator = (const PhoneticTraMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneticTraMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneticTraMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneticTraMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneticTraMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneticTranscriptionFormat"

    static const int kPhoneticTranscriptionFormat = 0;

    /**
     * Clears the field "phoneticTranscriptionFormat".
     *
     * The field will be set to its default value. The hasPhoneticTranscriptionFormat()
     * method will return false.
     */
    inline void clearPhoneticTranscriptionFormat();

    /**
     * Checks whether the field "phoneticTranscriptionFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticTranscriptionFormat()). Otherwise it will return false.
     */
    inline bool hasPhoneticTranscriptionFormat () const;

    /**
     * Returns the value of the member "phoneticTranscriptionFormat".
     *
     * If the meaning of "phoneticTranscriptionFormat" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneticTranscriptionFormat"
     */
    inline PhoneticTranscriptionFormat getPhoneticTranscriptionFormat () const;

    /**
     * Sets the value of the member "phoneticTranscriptionFormat".
     *
     * If the meaning of "phoneticTranscriptionFormat" isn't clear, then there should be a description here.
     *
     * @param phoneticTranscriptionFormat The value which will be set
     */
    inline void setPhoneticTranscriptionFormat (PhoneticTranscriptionFormat phoneticTranscriptionFormat_);

    // API of field "languageVersionList"

    static const int kLanguageVersionList = 1;

    /**
     * Clears the field "languageVersionList".
     *
     * The field will be set to its default value. The hasLanguageVersionList()
     * method will return false.
     */
    inline void clearLanguageVersionList();

    /**
     * Checks whether the field "languageVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageVersionList()). Otherwise it will return false.
     */
    inline bool hasLanguageVersionList () const;

    /**
     * Returns the value of the member "languageVersionList".
     *
     * If the meaning of "languageVersionList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageVersionList"
     */
    inline const ::std::vector< LanguageVersion >& getLanguageVersionList () const;

    /**
     * Retrieves the value of the field "languageVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageVersionList".
     */
    inline ::std::vector< LanguageVersion >& getLanguageVersionListMutable ();

    /**
     * Sets the value of the member "languageVersionList".
     *
     * If the meaning of "languageVersionList" isn't clear, then there should be a description here.
     *
     * @param languageVersionList The value which will be set
     */
    inline void setLanguageVersionList (const ::std::vector< LanguageVersion >& languageVersionList_);

    static const PhoneticTraMetadata &getDefaultInstance();

private:

    static const ::std::vector< LanguageVersion >& getLanguageVersionList_DefaultInstance ();

    inline void set_has_phoneticTranscriptionFormat ();

    inline void clear_has_phoneticTranscriptionFormat ();

    inline void set_has_languageVersionList ();

    inline void clear_has_languageVersionList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PhoneticTranscriptionFormat _phoneticTranscriptionFormat;

    ::std::vector< LanguageVersion > _languageVersionList;

};

/**
 * struct contains perecorded voice meta data and language version used by speech meta data
 */
class PrerecordedVMetadata {
public:

    /**
     * Default constructor
     */
    inline  PrerecordedVMetadata ();

    /**
     * Copy constructor
     */
    inline  PrerecordedVMetadata (const PrerecordedVMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  PrerecordedVMetadata (PrerecordedVoiceFormat prerecordedVoiceFormat_, const ::std::vector< LanguageVersion >& languageVersionList_);

    /**
     * Destructor
     */
    inline  ~PrerecordedVMetadata();

    /**
     * Assignment operator
     */
    inline PrerecordedVMetadata& operator = (const PrerecordedVMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrerecordedVMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrerecordedVMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrerecordedVMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrerecordedVMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "prerecordedVoiceFormat"

    static const int kPrerecordedVoiceFormat = 0;

    /**
     * Clears the field "prerecordedVoiceFormat".
     *
     * The field will be set to its default value. The hasPrerecordedVoiceFormat()
     * method will return false.
     */
    inline void clearPrerecordedVoiceFormat();

    /**
     * Checks whether the field "prerecordedVoiceFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrerecordedVoiceFormat()). Otherwise it will return false.
     */
    inline bool hasPrerecordedVoiceFormat () const;

    /**
     * Returns the value of the member "prerecordedVoiceFormat".
     *
     * If the meaning of "prerecordedVoiceFormat" isn't clear, then there should be a description here.
     *
     * @return The value of the field "prerecordedVoiceFormat"
     */
    inline PrerecordedVoiceFormat getPrerecordedVoiceFormat () const;

    /**
     * Sets the value of the member "prerecordedVoiceFormat".
     *
     * If the meaning of "prerecordedVoiceFormat" isn't clear, then there should be a description here.
     *
     * @param prerecordedVoiceFormat The value which will be set
     */
    inline void setPrerecordedVoiceFormat (PrerecordedVoiceFormat prerecordedVoiceFormat_);

    // API of field "languageVersionList"

    static const int kLanguageVersionList = 1;

    /**
     * Clears the field "languageVersionList".
     *
     * The field will be set to its default value. The hasLanguageVersionList()
     * method will return false.
     */
    inline void clearLanguageVersionList();

    /**
     * Checks whether the field "languageVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageVersionList()). Otherwise it will return false.
     */
    inline bool hasLanguageVersionList () const;

    /**
     * Returns the value of the member "languageVersionList".
     *
     * If the meaning of "languageVersionList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageVersionList"
     */
    inline const ::std::vector< LanguageVersion >& getLanguageVersionList () const;

    /**
     * Retrieves the value of the field "languageVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageVersionList".
     */
    inline ::std::vector< LanguageVersion >& getLanguageVersionListMutable ();

    /**
     * Sets the value of the member "languageVersionList".
     *
     * If the meaning of "languageVersionList" isn't clear, then there should be a description here.
     *
     * @param languageVersionList The value which will be set
     */
    inline void setLanguageVersionList (const ::std::vector< LanguageVersion >& languageVersionList_);

    static const PrerecordedVMetadata &getDefaultInstance();

private:

    static const ::std::vector< LanguageVersion >& getLanguageVersionList_DefaultInstance ();

    inline void set_has_prerecordedVoiceFormat ();

    inline void clear_has_prerecordedVoiceFormat ();

    inline void set_has_languageVersionList ();

    inline void clear_has_languageVersionList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PrerecordedVoiceFormat _prerecordedVoiceFormat;

    ::std::vector< LanguageVersion > _languageVersionList;

};

/**
 * struct contains information about speech data
 */
class SpeechMetadata {
public:

    /**
     * Default constructor
     */
    inline  SpeechMetadata ();

    /**
     * Copy constructor
     */
    inline  SpeechMetadata (const SpeechMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechMetadata (bool hasPhonetic_, bool hasPrerecorded_, const PhoneticTraMetadata& phoneticTraMetadata_, const PrerecordedVMetadata& prerecordedVMetadata_);

    /**
     * Destructor
     */
    inline  ~SpeechMetadata();

    /**
     * Assignment operator
     */
    inline SpeechMetadata& operator = (const SpeechMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "hasPhonetic"

    static const int kHasPhonetic = 0;

    /**
     * Clears the field "hasPhonetic".
     *
     * The field will be set to its default value. The hasHasPhonetic()
     * method will return false.
     */
    inline void clearHasPhonetic();

    /**
     * Checks whether the field "hasPhonetic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHasPhonetic()). Otherwise it will return false.
     */
    inline bool hasHasPhonetic () const;

    /**
     * Returns the value of the member "hasPhonetic".
     *
     * If the meaning of "hasPhonetic" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hasPhonetic"
     */
    inline bool getHasPhonetic () const;

    /**
     * Sets the value of the member "hasPhonetic".
     *
     * If the meaning of "hasPhonetic" isn't clear, then there should be a description here.
     *
     * @param hasPhonetic The value which will be set
     */
    inline void setHasPhonetic (bool hasPhonetic_);

    // API of field "hasPrerecorded"

    static const int kHasPrerecorded = 1;

    /**
     * Clears the field "hasPrerecorded".
     *
     * The field will be set to its default value. The hasHasPrerecorded()
     * method will return false.
     */
    inline void clearHasPrerecorded();

    /**
     * Checks whether the field "hasPrerecorded" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHasPrerecorded()). Otherwise it will return false.
     */
    inline bool hasHasPrerecorded () const;

    /**
     * Returns the value of the member "hasPrerecorded".
     *
     * If the meaning of "hasPrerecorded" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hasPrerecorded"
     */
    inline bool getHasPrerecorded () const;

    /**
     * Sets the value of the member "hasPrerecorded".
     *
     * If the meaning of "hasPrerecorded" isn't clear, then there should be a description here.
     *
     * @param hasPrerecorded The value which will be set
     */
    inline void setHasPrerecorded (bool hasPrerecorded_);

    // API of field "phoneticTraMetadata"

    static const int kPhoneticTraMetadata = 2;

    /**
     * Clears the field "phoneticTraMetadata".
     *
     * The field will be set to its default value. The hasPhoneticTraMetadata()
     * method will return false.
     */
    inline void clearPhoneticTraMetadata();

    /**
     * Checks whether the field "phoneticTraMetadata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticTraMetadata()). Otherwise it will return false.
     */
    inline bool hasPhoneticTraMetadata () const;

    /**
     * Returns the value of the member "phoneticTraMetadata".
     *
     * If the meaning of "phoneticTraMetadata" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneticTraMetadata"
     */
    inline const PhoneticTraMetadata& getPhoneticTraMetadata () const;

    /**
     * Retrieves the value of the field "phoneticTraMetadata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneticTraMetadata".
     */
    inline PhoneticTraMetadata& getPhoneticTraMetadataMutable ();

    /**
     * Sets the value of the member "phoneticTraMetadata".
     *
     * If the meaning of "phoneticTraMetadata" isn't clear, then there should be a description here.
     *
     * @param phoneticTraMetadata The value which will be set
     */
    inline void setPhoneticTraMetadata (const PhoneticTraMetadata& phoneticTraMetadata_);

    // API of field "prerecordedVMetadata"

    static const int kPrerecordedVMetadata = 3;

    /**
     * Clears the field "prerecordedVMetadata".
     *
     * The field will be set to its default value. The hasPrerecordedVMetadata()
     * method will return false.
     */
    inline void clearPrerecordedVMetadata();

    /**
     * Checks whether the field "prerecordedVMetadata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrerecordedVMetadata()). Otherwise it will return false.
     */
    inline bool hasPrerecordedVMetadata () const;

    /**
     * Returns the value of the member "prerecordedVMetadata".
     *
     * If the meaning of "prerecordedVMetadata" isn't clear, then there should be a description here.
     *
     * @return The value of the field "prerecordedVMetadata"
     */
    inline const PrerecordedVMetadata& getPrerecordedVMetadata () const;

    /**
     * Retrieves the value of the field "prerecordedVMetadata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "prerecordedVMetadata".
     */
    inline PrerecordedVMetadata& getPrerecordedVMetadataMutable ();

    /**
     * Sets the value of the member "prerecordedVMetadata".
     *
     * If the meaning of "prerecordedVMetadata" isn't clear, then there should be a description here.
     *
     * @param prerecordedVMetadata The value which will be set
     */
    inline void setPrerecordedVMetadata (const PrerecordedVMetadata& prerecordedVMetadata_);

    static const SpeechMetadata &getDefaultInstance();

private:

    inline void set_has_hasPhonetic ();

    inline void clear_has_hasPhonetic ();

    inline void set_has_hasPrerecorded ();

    inline void clear_has_hasPrerecorded ();

    inline void set_has_phoneticTraMetadata ();

    inline void clear_has_phoneticTraMetadata ();

    inline void set_has_prerecordedVMetadata ();

    inline void clear_has_prerecordedVMetadata ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _hasPhonetic;

    bool _hasPrerecorded;

    PhoneticTraMetadata _phoneticTraMetadata;

    PrerecordedVMetadata _prerecordedVMetadata;

};

/**
 * struct contains information about sds building block
 */
class SdsBuildingBlocks {
public:

    /**
     * Default constructor
     */
    inline  SdsBuildingBlocks ();

    /**
     * Copy constructor
     */
    inline  SdsBuildingBlocks (const SdsBuildingBlocks &rhs);

    /**
     * All fields constructor
     */
    inline  SdsBuildingBlocks (uint16 buildingBlockId_, NDSBuildingBlockType ndsBuildingBlockType_, const ::std::string& uri_, uint32 encryptionKeyId_, const SpeechMetadata& speechMetadata_, uint8 typeNdsDbSupplierId_, uint32 typeExtId_);

    /**
     * Destructor
     */
    inline  ~SdsBuildingBlocks();

    /**
     * Assignment operator
     */
    inline SdsBuildingBlocks& operator = (const SdsBuildingBlocks& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsBuildingBlocks& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsBuildingBlocks& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsBuildingBlocks& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsBuildingBlocks& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "buildingBlockId"

    static const int kBuildingBlockId = 0;

    /**
     * Clears the field "buildingBlockId".
     *
     * The field will be set to its default value. The hasBuildingBlockId()
     * method will return false.
     */
    inline void clearBuildingBlockId();

    /**
     * Checks whether the field "buildingBlockId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuildingBlockId()). Otherwise it will return false.
     */
    inline bool hasBuildingBlockId () const;

    /**
     * Returns the value of the member "buildingBlockId".
     *
     * If the meaning of "buildingBlockId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "buildingBlockId"
     */
    inline uint16 getBuildingBlockId () const;

    /**
     * Sets the value of the member "buildingBlockId".
     *
     * If the meaning of "buildingBlockId" isn't clear, then there should be a description here.
     *
     * @param buildingBlockId The value which will be set
     */
    inline void setBuildingBlockId (uint16 buildingBlockId_);

    // API of field "ndsBuildingBlockType"

    static const int kNdsBuildingBlockType = 1;

    /**
     * Clears the field "ndsBuildingBlockType".
     *
     * The field will be set to its default value. The hasNdsBuildingBlockType()
     * method will return false.
     */
    inline void clearNdsBuildingBlockType();

    /**
     * Checks whether the field "ndsBuildingBlockType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsBuildingBlockType()). Otherwise it will return false.
     */
    inline bool hasNdsBuildingBlockType () const;

    /**
     * Returns the value of the member "ndsBuildingBlockType".
     *
     * If the meaning of "ndsBuildingBlockType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsBuildingBlockType"
     */
    inline NDSBuildingBlockType getNdsBuildingBlockType () const;

    /**
     * Sets the value of the member "ndsBuildingBlockType".
     *
     * If the meaning of "ndsBuildingBlockType" isn't clear, then there should be a description here.
     *
     * @param ndsBuildingBlockType The value which will be set
     */
    inline void setNdsBuildingBlockType (NDSBuildingBlockType ndsBuildingBlockType_);

    // API of field "uri"

    static const int kUri = 2;

    /**
     * Clears the field "uri".
     *
     * The field will be set to its default value. The hasUri()
     * method will return false.
     */
    inline void clearUri();

    /**
     * Checks whether the field "uri" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUri()). Otherwise it will return false.
     */
    inline bool hasUri () const;

    /**
     * Returns the value of the member "uri".
     *
     * If the meaning of "uri" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uri"
     */
    inline const ::std::string& getUri () const;

    /**
     * Retrieves the value of the field "uri" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "uri".
     */
    inline ::std::string& getUriMutable ();

    /**
     * Sets the value of the member "uri".
     *
     * If the meaning of "uri" isn't clear, then there should be a description here.
     *
     * @param uri The value which will be set
     */
    inline void setUri (const ::std::string& uri_);

    /**
     * Sets the value of the member "uri".
     *
     * If the meaning of "uri" isn't clear, then there should be a description here.
     *
     * @param uri The value which will be set
     */
    inline void setUri (const char* uri_);

    /**
     * Sets the value of the member "uri".
     *
     * If the meaning of "uri" isn't clear, then there should be a description here.
     *
     * @param uri The value which will be set
     */
    inline void setUri (const char* value, size_t size);

    // API of field "encryptionKeyId"

    static const int kEncryptionKeyId = 3;

    /**
     * Clears the field "encryptionKeyId".
     *
     * The field will be set to its default value. The hasEncryptionKeyId()
     * method will return false.
     */
    inline void clearEncryptionKeyId();

    /**
     * Checks whether the field "encryptionKeyId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncryptionKeyId()). Otherwise it will return false.
     */
    inline bool hasEncryptionKeyId () const;

    /**
     * Returns the value of the member "encryptionKeyId".
     *
     * If the meaning of "encryptionKeyId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encryptionKeyId"
     */
    inline uint32 getEncryptionKeyId () const;

    /**
     * Sets the value of the member "encryptionKeyId".
     *
     * If the meaning of "encryptionKeyId" isn't clear, then there should be a description here.
     *
     * @param encryptionKeyId The value which will be set
     */
    inline void setEncryptionKeyId (uint32 encryptionKeyId_);

    // API of field "speechMetadata"

    static const int kSpeechMetadata = 4;

    /**
     * Clears the field "speechMetadata".
     *
     * The field will be set to its default value. The hasSpeechMetadata()
     * method will return false.
     */
    inline void clearSpeechMetadata();

    /**
     * Checks whether the field "speechMetadata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeechMetadata()). Otherwise it will return false.
     */
    inline bool hasSpeechMetadata () const;

    /**
     * Returns the value of the member "speechMetadata".
     *
     * If the meaning of "speechMetadata" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speechMetadata"
     */
    inline const SpeechMetadata& getSpeechMetadata () const;

    /**
     * Retrieves the value of the field "speechMetadata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "speechMetadata".
     */
    inline SpeechMetadata& getSpeechMetadataMutable ();

    /**
     * Sets the value of the member "speechMetadata".
     *
     * If the meaning of "speechMetadata" isn't clear, then there should be a description here.
     *
     * @param speechMetadata The value which will be set
     */
    inline void setSpeechMetadata (const SpeechMetadata& speechMetadata_);

    // API of field "typeNdsDbSupplierId"

    static const int kTypeNdsDbSupplierId = 5;

    /**
     * Clears the field "typeNdsDbSupplierId".
     *
     * The field will be set to its default value. The hasTypeNdsDbSupplierId()
     * method will return false.
     */
    inline void clearTypeNdsDbSupplierId();

    /**
     * Checks whether the field "typeNdsDbSupplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTypeNdsDbSupplierId()). Otherwise it will return false.
     */
    inline bool hasTypeNdsDbSupplierId () const;

    /**
     * Returns the value of the member "typeNdsDbSupplierId".
     *
     * If the meaning of "typeNdsDbSupplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "typeNdsDbSupplierId"
     */
    inline uint8 getTypeNdsDbSupplierId () const;

    /**
     * Sets the value of the member "typeNdsDbSupplierId".
     *
     * If the meaning of "typeNdsDbSupplierId" isn't clear, then there should be a description here.
     *
     * @param typeNdsDbSupplierId The value which will be set
     */
    inline void setTypeNdsDbSupplierId (uint8 typeNdsDbSupplierId_);

    // API of field "typeExtId"

    static const int kTypeExtId = 6;

    /**
     * Clears the field "typeExtId".
     *
     * The field will be set to its default value. The hasTypeExtId()
     * method will return false.
     */
    inline void clearTypeExtId();

    /**
     * Checks whether the field "typeExtId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTypeExtId()). Otherwise it will return false.
     */
    inline bool hasTypeExtId () const;

    /**
     * Returns the value of the member "typeExtId".
     *
     * If the meaning of "typeExtId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "typeExtId"
     */
    inline uint32 getTypeExtId () const;

    /**
     * Sets the value of the member "typeExtId".
     *
     * If the meaning of "typeExtId" isn't clear, then there should be a description here.
     *
     * @param typeExtId The value which will be set
     */
    inline void setTypeExtId (uint32 typeExtId_);

    static const SdsBuildingBlocks &getDefaultInstance();

private:

    inline void set_has_buildingBlockId ();

    inline void clear_has_buildingBlockId ();

    inline void set_has_ndsBuildingBlockType ();

    inline void clear_has_ndsBuildingBlockType ();

    inline void set_has_uri ();

    inline void clear_has_uri ();

    inline void set_has_encryptionKeyId ();

    inline void clear_has_encryptionKeyId ();

    inline void set_has_speechMetadata ();

    inline void clear_has_speechMetadata ();

    inline void set_has_typeNdsDbSupplierId ();

    inline void clear_has_typeNdsDbSupplierId ();

    inline void set_has_typeExtId ();

    inline void clear_has_typeExtId ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _buildingBlockId;

    NDSBuildingBlockType _ndsBuildingBlockType;

    ::std::string _uri;

    uint32 _encryptionKeyId;

    SpeechMetadata _speechMetadata;

    uint8 _typeNdsDbSupplierId;

    uint32 _typeExtId;

};

/**
 * struct contains information about update region
 */
class SdsRegionMetadata {
public:

    /**
     * Default constructor
     */
    inline  SdsRegionMetadata ();

    /**
     * Copy constructor
     */
    inline  SdsRegionMetadata (const SdsRegionMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  SdsRegionMetadata (uint16 updateRegionId_, const ::std::string& isoCountryCodeText_, const ::std::string& isoSubCountryCodeText_);

    /**
     * Destructor
     */
    inline  ~SdsRegionMetadata();

    /**
     * Assignment operator
     */
    inline SdsRegionMetadata& operator = (const SdsRegionMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsRegionMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsRegionMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsRegionMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsRegionMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 0;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline uint16 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (uint16 updateRegionId_);

    // API of field "isoCountryCodeText"

    static const int kIsoCountryCodeText = 1;

    /**
     * Clears the field "isoCountryCodeText".
     *
     * The field will be set to its default value. The hasIsoCountryCodeText()
     * method will return false.
     */
    inline void clearIsoCountryCodeText();

    /**
     * Checks whether the field "isoCountryCodeText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoCountryCodeText()). Otherwise it will return false.
     */
    inline bool hasIsoCountryCodeText () const;

    /**
     * Returns the value of the member "isoCountryCodeText".
     *
     * If the meaning of "isoCountryCodeText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoCountryCodeText"
     */
    inline const ::std::string& getIsoCountryCodeText () const;

    /**
     * Retrieves the value of the field "isoCountryCodeText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoCountryCodeText".
     */
    inline ::std::string& getIsoCountryCodeTextMutable ();

    /**
     * Sets the value of the member "isoCountryCodeText".
     *
     * If the meaning of "isoCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoCountryCodeText The value which will be set
     */
    inline void setIsoCountryCodeText (const ::std::string& isoCountryCodeText_);

    /**
     * Sets the value of the member "isoCountryCodeText".
     *
     * If the meaning of "isoCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoCountryCodeText The value which will be set
     */
    inline void setIsoCountryCodeText (const char* isoCountryCodeText_);

    /**
     * Sets the value of the member "isoCountryCodeText".
     *
     * If the meaning of "isoCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoCountryCodeText The value which will be set
     */
    inline void setIsoCountryCodeText (const char* value, size_t size);

    // API of field "isoSubCountryCodeText"

    static const int kIsoSubCountryCodeText = 2;

    /**
     * Clears the field "isoSubCountryCodeText".
     *
     * The field will be set to its default value. The hasIsoSubCountryCodeText()
     * method will return false.
     */
    inline void clearIsoSubCountryCodeText();

    /**
     * Checks whether the field "isoSubCountryCodeText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoSubCountryCodeText()). Otherwise it will return false.
     */
    inline bool hasIsoSubCountryCodeText () const;

    /**
     * Returns the value of the member "isoSubCountryCodeText".
     *
     * If the meaning of "isoSubCountryCodeText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoSubCountryCodeText"
     */
    inline const ::std::string& getIsoSubCountryCodeText () const;

    /**
     * Retrieves the value of the field "isoSubCountryCodeText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoSubCountryCodeText".
     */
    inline ::std::string& getIsoSubCountryCodeTextMutable ();

    /**
     * Sets the value of the member "isoSubCountryCodeText".
     *
     * If the meaning of "isoSubCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoSubCountryCodeText The value which will be set
     */
    inline void setIsoSubCountryCodeText (const ::std::string& isoSubCountryCodeText_);

    /**
     * Sets the value of the member "isoSubCountryCodeText".
     *
     * If the meaning of "isoSubCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoSubCountryCodeText The value which will be set
     */
    inline void setIsoSubCountryCodeText (const char* isoSubCountryCodeText_);

    /**
     * Sets the value of the member "isoSubCountryCodeText".
     *
     * If the meaning of "isoSubCountryCodeText" isn't clear, then there should be a description here.
     *
     * @param isoSubCountryCodeText The value which will be set
     */
    inline void setIsoSubCountryCodeText (const char* value, size_t size);

    static const SdsRegionMetadata &getDefaultInstance();

private:

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    inline void set_has_isoCountryCodeText ();

    inline void clear_has_isoCountryCodeText ();

    inline void set_has_isoSubCountryCodeText ();

    inline void clear_has_isoSubCountryCodeText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _updateRegionId;

    ::std::string _isoCountryCodeText;

    ::std::string _isoSubCountryCodeText;

};

/**
 * struct contains information about regions below update region
 */
class SdsUpdateRegions {
public:

    /**
     * Default constructor
     */
    inline  SdsUpdateRegions ();

    /**
     * Copy constructor
     */
    inline  SdsUpdateRegions (const SdsUpdateRegions &rhs);

    /**
     * All fields constructor
     */
    inline  SdsUpdateRegions (uint16 updateRegionId_, const ::std::vector< SdsBuildingBlocks >& sdsBuildingBlocksList_, const ::std::vector< SdsRegionMetadata >& sdsRegionMetadataList_);

    /**
     * Destructor
     */
    inline  ~SdsUpdateRegions();

    /**
     * Assignment operator
     */
    inline SdsUpdateRegions& operator = (const SdsUpdateRegions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsUpdateRegions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsUpdateRegions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsUpdateRegions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsUpdateRegions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 0;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline uint16 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (uint16 updateRegionId_);

    // API of field "sdsBuildingBlocksList"

    static const int kSdsBuildingBlocksList = 1;

    /**
     * Clears the field "sdsBuildingBlocksList".
     *
     * The field will be set to its default value. The hasSdsBuildingBlocksList()
     * method will return false.
     */
    inline void clearSdsBuildingBlocksList();

    /**
     * Checks whether the field "sdsBuildingBlocksList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsBuildingBlocksList()). Otherwise it will return false.
     */
    inline bool hasSdsBuildingBlocksList () const;

    /**
     * Returns the value of the member "sdsBuildingBlocksList".
     *
     * If the meaning of "sdsBuildingBlocksList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsBuildingBlocksList"
     */
    inline const ::std::vector< SdsBuildingBlocks >& getSdsBuildingBlocksList () const;

    /**
     * Retrieves the value of the field "sdsBuildingBlocksList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsBuildingBlocksList".
     */
    inline ::std::vector< SdsBuildingBlocks >& getSdsBuildingBlocksListMutable ();

    /**
     * Sets the value of the member "sdsBuildingBlocksList".
     *
     * If the meaning of "sdsBuildingBlocksList" isn't clear, then there should be a description here.
     *
     * @param sdsBuildingBlocksList The value which will be set
     */
    inline void setSdsBuildingBlocksList (const ::std::vector< SdsBuildingBlocks >& sdsBuildingBlocksList_);

    // API of field "sdsRegionMetadataList"

    static const int kSdsRegionMetadataList = 2;

    /**
     * Clears the field "sdsRegionMetadataList".
     *
     * The field will be set to its default value. The hasSdsRegionMetadataList()
     * method will return false.
     */
    inline void clearSdsRegionMetadataList();

    /**
     * Checks whether the field "sdsRegionMetadataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsRegionMetadataList()). Otherwise it will return false.
     */
    inline bool hasSdsRegionMetadataList () const;

    /**
     * Returns the value of the member "sdsRegionMetadataList".
     *
     * If the meaning of "sdsRegionMetadataList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsRegionMetadataList"
     */
    inline const ::std::vector< SdsRegionMetadata >& getSdsRegionMetadataList () const;

    /**
     * Retrieves the value of the field "sdsRegionMetadataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsRegionMetadataList".
     */
    inline ::std::vector< SdsRegionMetadata >& getSdsRegionMetadataListMutable ();

    /**
     * Sets the value of the member "sdsRegionMetadataList".
     *
     * If the meaning of "sdsRegionMetadataList" isn't clear, then there should be a description here.
     *
     * @param sdsRegionMetadataList The value which will be set
     */
    inline void setSdsRegionMetadataList (const ::std::vector< SdsRegionMetadata >& sdsRegionMetadataList_);

    static const SdsUpdateRegions &getDefaultInstance();

private:

    static const ::std::vector< SdsBuildingBlocks >& getSdsBuildingBlocksList_DefaultInstance ();

    static const ::std::vector< SdsRegionMetadata >& getSdsRegionMetadataList_DefaultInstance ();

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    inline void set_has_sdsBuildingBlocksList ();

    inline void clear_has_sdsBuildingBlocksList ();

    inline void set_has_sdsRegionMetadataList ();

    inline void clear_has_sdsRegionMetadataList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _updateRegionId;

    ::std::vector< SdsBuildingBlocks > _sdsBuildingBlocksList;

    ::std::vector< SdsRegionMetadata > _sdsRegionMetadataList;

};

/**
 * struct contains sds langauge filter to be applied
 */
class LanguageEntry {
public:

    /**
     * Default constructor
     */
    inline  LanguageEntry ();

    /**
     * Copy constructor
     */
    inline  LanguageEntry (const LanguageEntry &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageEntry (const ::std::string& iSOLanguageCode_, const ::std::string& iSOCountryCode_, const ::std::string& transcriptCode_);

    /**
     * Destructor
     */
    inline  ~LanguageEntry();

    /**
     * Assignment operator
     */
    inline LanguageEntry& operator = (const LanguageEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "iSOLanguageCode"

    static const int kISOLanguageCode = 0;

    /**
     * Clears the field "iSOLanguageCode".
     *
     * The field will be set to its default value. The hasISOLanguageCode()
     * method will return false.
     */
    inline void clearISOLanguageCode();

    /**
     * Checks whether the field "iSOLanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISOLanguageCode()). Otherwise it will return false.
     */
    inline bool hasISOLanguageCode () const;

    /**
     * Returns the value of the member "iSOLanguageCode".
     *
     * If the meaning of "iSOLanguageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iSOLanguageCode"
     */
    inline const ::std::string& getISOLanguageCode () const;

    /**
     * Retrieves the value of the field "iSOLanguageCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "iSOLanguageCode".
     */
    inline ::std::string& getISOLanguageCodeMutable ();

    /**
     * Sets the value of the member "iSOLanguageCode".
     *
     * If the meaning of "iSOLanguageCode" isn't clear, then there should be a description here.
     *
     * @param iSOLanguageCode The value which will be set
     */
    inline void setISOLanguageCode (const ::std::string& iSOLanguageCode_);

    /**
     * Sets the value of the member "iSOLanguageCode".
     *
     * If the meaning of "iSOLanguageCode" isn't clear, then there should be a description here.
     *
     * @param iSOLanguageCode The value which will be set
     */
    inline void setISOLanguageCode (const char* iSOLanguageCode_);

    /**
     * Sets the value of the member "iSOLanguageCode".
     *
     * If the meaning of "iSOLanguageCode" isn't clear, then there should be a description here.
     *
     * @param iSOLanguageCode The value which will be set
     */
    inline void setISOLanguageCode (const char* value, size_t size);

    // API of field "iSOCountryCode"

    static const int kISOCountryCode = 1;

    /**
     * Clears the field "iSOCountryCode".
     *
     * The field will be set to its default value. The hasISOCountryCode()
     * method will return false.
     */
    inline void clearISOCountryCode();

    /**
     * Checks whether the field "iSOCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISOCountryCode()). Otherwise it will return false.
     */
    inline bool hasISOCountryCode () const;

    /**
     * Returns the value of the member "iSOCountryCode".
     *
     * If the meaning of "iSOCountryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iSOCountryCode"
     */
    inline const ::std::string& getISOCountryCode () const;

    /**
     * Retrieves the value of the field "iSOCountryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "iSOCountryCode".
     */
    inline ::std::string& getISOCountryCodeMutable ();

    /**
     * Sets the value of the member "iSOCountryCode".
     *
     * If the meaning of "iSOCountryCode" isn't clear, then there should be a description here.
     *
     * @param iSOCountryCode The value which will be set
     */
    inline void setISOCountryCode (const ::std::string& iSOCountryCode_);

    /**
     * Sets the value of the member "iSOCountryCode".
     *
     * If the meaning of "iSOCountryCode" isn't clear, then there should be a description here.
     *
     * @param iSOCountryCode The value which will be set
     */
    inline void setISOCountryCode (const char* iSOCountryCode_);

    /**
     * Sets the value of the member "iSOCountryCode".
     *
     * If the meaning of "iSOCountryCode" isn't clear, then there should be a description here.
     *
     * @param iSOCountryCode The value which will be set
     */
    inline void setISOCountryCode (const char* value, size_t size);

    // API of field "transcriptCode"

    static const int kTranscriptCode = 2;

    /**
     * Clears the field "transcriptCode".
     *
     * The field will be set to its default value. The hasTranscriptCode()
     * method will return false.
     */
    inline void clearTranscriptCode();

    /**
     * Checks whether the field "transcriptCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTranscriptCode()). Otherwise it will return false.
     */
    inline bool hasTranscriptCode () const;

    /**
     * Returns the value of the member "transcriptCode".
     *
     * If the meaning of "transcriptCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transcriptCode"
     */
    inline const ::std::string& getTranscriptCode () const;

    /**
     * Retrieves the value of the field "transcriptCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transcriptCode".
     */
    inline ::std::string& getTranscriptCodeMutable ();

    /**
     * Sets the value of the member "transcriptCode".
     *
     * If the meaning of "transcriptCode" isn't clear, then there should be a description here.
     *
     * @param transcriptCode The value which will be set
     */
    inline void setTranscriptCode (const ::std::string& transcriptCode_);

    /**
     * Sets the value of the member "transcriptCode".
     *
     * If the meaning of "transcriptCode" isn't clear, then there should be a description here.
     *
     * @param transcriptCode The value which will be set
     */
    inline void setTranscriptCode (const char* transcriptCode_);

    /**
     * Sets the value of the member "transcriptCode".
     *
     * If the meaning of "transcriptCode" isn't clear, then there should be a description here.
     *
     * @param transcriptCode The value which will be set
     */
    inline void setTranscriptCode (const char* value, size_t size);

    static const LanguageEntry &getDefaultInstance();

private:

    inline void set_has_iSOLanguageCode ();

    inline void clear_has_iSOLanguageCode ();

    inline void set_has_iSOCountryCode ();

    inline void clear_has_iSOCountryCode ();

    inline void set_has_transcriptCode ();

    inline void clear_has_transcriptCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _iSOLanguageCode;

    ::std::string _iSOCountryCode;

    ::std::string _transcriptCode;

};

/**
 * struct contains sds langauge code , country code and other additional data
 */
class SdsLanguages {
public:

    /**
     * Default constructor
     */
    inline  SdsLanguages ();

    /**
     * Copy constructor
     */
    inline  SdsLanguages (const SdsLanguages &rhs);

    /**
     * All fields constructor
     */
    inline  SdsLanguages (uint16 languageCode_, const ::std::string& isoCountryCode_, const ::std::string& isoLanguageCode_, const ::std::string& isoScriptCode_, const LanguageEntry& languageEntry_, uint16 isTransliterationOf_, uint16 isDiacriticTransliterationOf_);

    /**
     * Destructor
     */
    inline  ~SdsLanguages();

    /**
     * Assignment operator
     */
    inline SdsLanguages& operator = (const SdsLanguages& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsLanguages& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsLanguages& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsLanguages& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsLanguages& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "languageCode"

    static const int kLanguageCode = 0;

    /**
     * Clears the field "languageCode".
     *
     * The field will be set to its default value. The hasLanguageCode()
     * method will return false.
     */
    inline void clearLanguageCode();

    /**
     * Checks whether the field "languageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageCode()). Otherwise it will return false.
     */
    inline bool hasLanguageCode () const;

    /**
     * Returns the value of the member "languageCode".
     *
     * If the meaning of "languageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageCode"
     */
    inline uint16 getLanguageCode () const;

    /**
     * Sets the value of the member "languageCode".
     *
     * If the meaning of "languageCode" isn't clear, then there should be a description here.
     *
     * @param languageCode The value which will be set
     */
    inline void setLanguageCode (uint16 languageCode_);

    // API of field "isoCountryCode"

    static const int kIsoCountryCode = 1;

    /**
     * Clears the field "isoCountryCode".
     *
     * The field will be set to its default value. The hasIsoCountryCode()
     * method will return false.
     */
    inline void clearIsoCountryCode();

    /**
     * Checks whether the field "isoCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoCountryCode()). Otherwise it will return false.
     */
    inline bool hasIsoCountryCode () const;

    /**
     * Returns the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoCountryCode"
     */
    inline const ::std::string& getIsoCountryCode () const;

    /**
     * Retrieves the value of the field "isoCountryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoCountryCode".
     */
    inline ::std::string& getIsoCountryCodeMutable ();

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const ::std::string& isoCountryCode_);

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const char* isoCountryCode_);

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const char* value, size_t size);

    // API of field "isoLanguageCode"

    static const int kIsoLanguageCode = 2;

    /**
     * Clears the field "isoLanguageCode".
     *
     * The field will be set to its default value. The hasIsoLanguageCode()
     * method will return false.
     */
    inline void clearIsoLanguageCode();

    /**
     * Checks whether the field "isoLanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoLanguageCode()). Otherwise it will return false.
     */
    inline bool hasIsoLanguageCode () const;

    /**
     * Returns the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoLanguageCode"
     */
    inline const ::std::string& getIsoLanguageCode () const;

    /**
     * Retrieves the value of the field "isoLanguageCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoLanguageCode".
     */
    inline ::std::string& getIsoLanguageCodeMutable ();

    /**
     * Sets the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @param isoLanguageCode The value which will be set
     */
    inline void setIsoLanguageCode (const ::std::string& isoLanguageCode_);

    /**
     * Sets the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @param isoLanguageCode The value which will be set
     */
    inline void setIsoLanguageCode (const char* isoLanguageCode_);

    /**
     * Sets the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @param isoLanguageCode The value which will be set
     */
    inline void setIsoLanguageCode (const char* value, size_t size);

    // API of field "isoScriptCode"

    static const int kIsoScriptCode = 3;

    /**
     * Clears the field "isoScriptCode".
     *
     * The field will be set to its default value. The hasIsoScriptCode()
     * method will return false.
     */
    inline void clearIsoScriptCode();

    /**
     * Checks whether the field "isoScriptCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoScriptCode()). Otherwise it will return false.
     */
    inline bool hasIsoScriptCode () const;

    /**
     * Returns the value of the member "isoScriptCode".
     *
     * If the meaning of "isoScriptCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoScriptCode"
     */
    inline const ::std::string& getIsoScriptCode () const;

    /**
     * Retrieves the value of the field "isoScriptCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoScriptCode".
     */
    inline ::std::string& getIsoScriptCodeMutable ();

    /**
     * Sets the value of the member "isoScriptCode".
     *
     * If the meaning of "isoScriptCode" isn't clear, then there should be a description here.
     *
     * @param isoScriptCode The value which will be set
     */
    inline void setIsoScriptCode (const ::std::string& isoScriptCode_);

    /**
     * Sets the value of the member "isoScriptCode".
     *
     * If the meaning of "isoScriptCode" isn't clear, then there should be a description here.
     *
     * @param isoScriptCode The value which will be set
     */
    inline void setIsoScriptCode (const char* isoScriptCode_);

    /**
     * Sets the value of the member "isoScriptCode".
     *
     * If the meaning of "isoScriptCode" isn't clear, then there should be a description here.
     *
     * @param isoScriptCode The value which will be set
     */
    inline void setIsoScriptCode (const char* value, size_t size);

    // API of field "languageEntry"

    static const int kLanguageEntry = 4;

    /**
     * Clears the field "languageEntry".
     *
     * The field will be set to its default value. The hasLanguageEntry()
     * method will return false.
     */
    inline void clearLanguageEntry();

    /**
     * Checks whether the field "languageEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageEntry()). Otherwise it will return false.
     */
    inline bool hasLanguageEntry () const;

    /**
     * Returns the value of the member "languageEntry".
     *
     * If the meaning of "languageEntry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageEntry"
     */
    inline const LanguageEntry& getLanguageEntry () const;

    /**
     * Retrieves the value of the field "languageEntry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageEntry".
     */
    inline LanguageEntry& getLanguageEntryMutable ();

    /**
     * Sets the value of the member "languageEntry".
     *
     * If the meaning of "languageEntry" isn't clear, then there should be a description here.
     *
     * @param languageEntry The value which will be set
     */
    inline void setLanguageEntry (const LanguageEntry& languageEntry_);

    // API of field "isTransliterationOf"

    static const int kIsTransliterationOf = 5;

    /**
     * Clears the field "isTransliterationOf".
     *
     * The field will be set to its default value. The hasIsTransliterationOf()
     * method will return false.
     */
    inline void clearIsTransliterationOf();

    /**
     * Checks whether the field "isTransliterationOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsTransliterationOf()). Otherwise it will return false.
     */
    inline bool hasIsTransliterationOf () const;

    /**
     * Returns the value of the member "isTransliterationOf".
     *
     * If the meaning of "isTransliterationOf" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isTransliterationOf"
     */
    inline uint16 getIsTransliterationOf () const;

    /**
     * Sets the value of the member "isTransliterationOf".
     *
     * If the meaning of "isTransliterationOf" isn't clear, then there should be a description here.
     *
     * @param isTransliterationOf The value which will be set
     */
    inline void setIsTransliterationOf (uint16 isTransliterationOf_);

    // API of field "isDiacriticTransliterationOf"

    static const int kIsDiacriticTransliterationOf = 6;

    /**
     * Clears the field "isDiacriticTransliterationOf".
     *
     * The field will be set to its default value. The hasIsDiacriticTransliterationOf()
     * method will return false.
     */
    inline void clearIsDiacriticTransliterationOf();

    /**
     * Checks whether the field "isDiacriticTransliterationOf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDiacriticTransliterationOf()). Otherwise it will return false.
     */
    inline bool hasIsDiacriticTransliterationOf () const;

    /**
     * Returns the value of the member "isDiacriticTransliterationOf".
     *
     * If the meaning of "isDiacriticTransliterationOf" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isDiacriticTransliterationOf"
     */
    inline uint16 getIsDiacriticTransliterationOf () const;

    /**
     * Sets the value of the member "isDiacriticTransliterationOf".
     *
     * If the meaning of "isDiacriticTransliterationOf" isn't clear, then there should be a description here.
     *
     * @param isDiacriticTransliterationOf The value which will be set
     */
    inline void setIsDiacriticTransliterationOf (uint16 isDiacriticTransliterationOf_);

    static const SdsLanguages &getDefaultInstance();

private:

    inline void set_has_languageCode ();

    inline void clear_has_languageCode ();

    inline void set_has_isoCountryCode ();

    inline void clear_has_isoCountryCode ();

    inline void set_has_isoLanguageCode ();

    inline void clear_has_isoLanguageCode ();

    inline void set_has_isoScriptCode ();

    inline void clear_has_isoScriptCode ();

    inline void set_has_languageEntry ();

    inline void clear_has_languageEntry ();

    inline void set_has_isTransliterationOf ();

    inline void clear_has_isTransliterationOf ();

    inline void set_has_isDiacriticTransliterationOf ();

    inline void clear_has_isDiacriticTransliterationOf ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _languageCode;

    ::std::string _isoCountryCode;

    ::std::string _isoLanguageCode;

    ::std::string _isoScriptCode;

    LanguageEntry _languageEntry;

    uint16 _isTransliterationOf;

    uint16 _isDiacriticTransliterationOf;

};

/**
 * struct contains sds global data set elements
 */
class SdsProducts {
public:

    /**
     * Default constructor
     */
    inline  SdsProducts ();

    /**
     * Copy constructor
     */
    inline  SdsProducts (const SdsProducts &rhs);

    /**
     * All fields constructor
     */
    inline  SdsProducts (uint8 supplierId_, uint32 productId_, const ::std::vector< SdsUpdateRegions >& sdsUpdateRegionsList_, const ::std::vector< SdsLanguages >& sdsLanguagesList_);

    /**
     * Destructor
     */
    inline  ~SdsProducts();

    /**
     * Assignment operator
     */
    inline SdsProducts& operator = (const SdsProducts& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsProducts& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsProducts& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsProducts& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsProducts& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "supplierId"

    static const int kSupplierId = 0;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint8 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint8 supplierId_);

    // API of field "productId"

    static const int kProductId = 1;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "sdsUpdateRegionsList"

    static const int kSdsUpdateRegionsList = 2;

    /**
     * Clears the field "sdsUpdateRegionsList".
     *
     * The field will be set to its default value. The hasSdsUpdateRegionsList()
     * method will return false.
     */
    inline void clearSdsUpdateRegionsList();

    /**
     * Checks whether the field "sdsUpdateRegionsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsUpdateRegionsList()). Otherwise it will return false.
     */
    inline bool hasSdsUpdateRegionsList () const;

    /**
     * Returns the value of the member "sdsUpdateRegionsList".
     *
     * If the meaning of "sdsUpdateRegionsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsUpdateRegionsList"
     */
    inline const ::std::vector< SdsUpdateRegions >& getSdsUpdateRegionsList () const;

    /**
     * Retrieves the value of the field "sdsUpdateRegionsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsUpdateRegionsList".
     */
    inline ::std::vector< SdsUpdateRegions >& getSdsUpdateRegionsListMutable ();

    /**
     * Sets the value of the member "sdsUpdateRegionsList".
     *
     * If the meaning of "sdsUpdateRegionsList" isn't clear, then there should be a description here.
     *
     * @param sdsUpdateRegionsList The value which will be set
     */
    inline void setSdsUpdateRegionsList (const ::std::vector< SdsUpdateRegions >& sdsUpdateRegionsList_);

    // API of field "sdsLanguagesList"

    static const int kSdsLanguagesList = 3;

    /**
     * Clears the field "sdsLanguagesList".
     *
     * The field will be set to its default value. The hasSdsLanguagesList()
     * method will return false.
     */
    inline void clearSdsLanguagesList();

    /**
     * Checks whether the field "sdsLanguagesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsLanguagesList()). Otherwise it will return false.
     */
    inline bool hasSdsLanguagesList () const;

    /**
     * Returns the value of the member "sdsLanguagesList".
     *
     * If the meaning of "sdsLanguagesList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsLanguagesList"
     */
    inline const ::std::vector< SdsLanguages >& getSdsLanguagesList () const;

    /**
     * Retrieves the value of the field "sdsLanguagesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsLanguagesList".
     */
    inline ::std::vector< SdsLanguages >& getSdsLanguagesListMutable ();

    /**
     * Sets the value of the member "sdsLanguagesList".
     *
     * If the meaning of "sdsLanguagesList" isn't clear, then there should be a description here.
     *
     * @param sdsLanguagesList The value which will be set
     */
    inline void setSdsLanguagesList (const ::std::vector< SdsLanguages >& sdsLanguagesList_);

    static const SdsProducts &getDefaultInstance();

private:

    static const ::std::vector< SdsUpdateRegions >& getSdsUpdateRegionsList_DefaultInstance ();

    static const ::std::vector< SdsLanguages >& getSdsLanguagesList_DefaultInstance ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_sdsUpdateRegionsList ();

    inline void clear_has_sdsUpdateRegionsList ();

    inline void set_has_sdsLanguagesList ();

    inline void clear_has_sdsLanguagesList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _supplierId;

    uint32 _productId;

    ::std::vector< SdsUpdateRegions > _sdsUpdateRegionsList;

    ::std::vector< SdsLanguages > _sdsLanguagesList;

};

/**
 * struct contains Global/common ids of selected elements
 */
class GlobalUpdateRegionId {
public:

    /**
     * Default constructor
     */
    inline  GlobalUpdateRegionId ();

    /**
     * Copy constructor
     */
    inline  GlobalUpdateRegionId (const GlobalUpdateRegionId &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalUpdateRegionId (int16 updateRegionId_, int32 productId_, int8 supplierId_);

    /**
     * Destructor
     */
    inline  ~GlobalUpdateRegionId();

    /**
     * Assignment operator
     */
    inline GlobalUpdateRegionId& operator = (const GlobalUpdateRegionId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalUpdateRegionId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalUpdateRegionId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalUpdateRegionId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalUpdateRegionId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 0;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline int16 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (int16 updateRegionId_);

    // API of field "productId"

    static const int kProductId = 1;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline int32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (int32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 2;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline int8 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (int8 supplierId_);

    static const GlobalUpdateRegionId &getDefaultInstance();

private:

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int16 _updateRegionId;

    int32 _productId;

    int8 _supplierId;

};

/**
 * struct contains named object id combined with global update region id to get a unique id
 */
class GlobalNamedObjectId {
public:

    /**
     * Default constructor
     */
    inline  GlobalNamedObjectId ();

    /**
     * Copy constructor
     */
    inline  GlobalNamedObjectId (const GlobalNamedObjectId &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalNamedObjectId (const GlobalUpdateRegionId& globalUpdateRegionId_, uint32 namedObjectId_, bool isValid_);

    /**
     * Destructor
     */
    inline  ~GlobalNamedObjectId();

    /**
     * Assignment operator
     */
    inline GlobalNamedObjectId& operator = (const GlobalNamedObjectId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalNamedObjectId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalNamedObjectId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalNamedObjectId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalNamedObjectId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalUpdateRegionId"

    static const int kGlobalUpdateRegionId = 0;

    /**
     * Clears the field "globalUpdateRegionId".
     *
     * The field will be set to its default value. The hasGlobalUpdateRegionId()
     * method will return false.
     */
    inline void clearGlobalUpdateRegionId();

    /**
     * Checks whether the field "globalUpdateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasGlobalUpdateRegionId () const;

    /**
     * Returns the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalUpdateRegionId"
     */
    inline const GlobalUpdateRegionId& getGlobalUpdateRegionId () const;

    /**
     * Retrieves the value of the field "globalUpdateRegionId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalUpdateRegionId".
     */
    inline GlobalUpdateRegionId& getGlobalUpdateRegionIdMutable ();

    /**
     * Sets the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @param globalUpdateRegionId The value which will be set
     */
    inline void setGlobalUpdateRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_);

    // API of field "namedObjectId"

    static const int kNamedObjectId = 1;

    /**
     * Clears the field "namedObjectId".
     *
     * The field will be set to its default value. The hasNamedObjectId()
     * method will return false.
     */
    inline void clearNamedObjectId();

    /**
     * Checks whether the field "namedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasNamedObjectId () const;

    /**
     * Returns the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "namedObjectId"
     */
    inline uint32 getNamedObjectId () const;

    /**
     * Sets the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @param namedObjectId The value which will be set
     */
    inline void setNamedObjectId (uint32 namedObjectId_);

    // API of field "isValid"

    static const int kIsValid = 2;

    /**
     * Clears the field "isValid".
     *
     * The field will be set to its default value. The hasIsValid()
     * method will return false.
     */
    inline void clearIsValid();

    /**
     * Checks whether the field "isValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsValid()). Otherwise it will return false.
     */
    inline bool hasIsValid () const;

    /**
     * Returns the value of the member "isValid".
     *
     * If the meaning of "isValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isValid"
     */
    inline bool getIsValid () const;

    /**
     * Sets the value of the member "isValid".
     *
     * If the meaning of "isValid" isn't clear, then there should be a description here.
     *
     * @param isValid The value which will be set
     */
    inline void setIsValid (bool isValid_);

    static const GlobalNamedObjectId &getDefaultInstance();

private:

    inline void set_has_globalUpdateRegionId ();

    inline void clear_has_globalUpdateRegionId ();

    inline void set_has_namedObjectId ();

    inline void clear_has_namedObjectId ();

    inline void set_has_isValid ();

    inline void clear_has_isValid ();

    uint32 _has_bits_[ (3 + 31) / 32];

    GlobalUpdateRegionId _globalUpdateRegionId;

    uint32 _namedObjectId;

    bool _isValid;

};

/**
 * If the meaning of "GlobalNamedObjectAndRegionId" isn't clear, then there should be a description here.
 */
class GlobalNamedObjectAndRegionId {
public:

    /**
     * Default constructor
     */
    inline  GlobalNamedObjectAndRegionId ();

    /**
     * Copy constructor
     */
    inline  GlobalNamedObjectAndRegionId (const GlobalNamedObjectAndRegionId &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalNamedObjectAndRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_, uint32 namedObjectId_, uint64 poiRegionId_, uint32 globalXrefID_);

    /**
     * Destructor
     */
    inline  ~GlobalNamedObjectAndRegionId();

    /**
     * Assignment operator
     */
    inline GlobalNamedObjectAndRegionId& operator = (const GlobalNamedObjectAndRegionId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalNamedObjectAndRegionId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalNamedObjectAndRegionId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalNamedObjectAndRegionId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalNamedObjectAndRegionId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalUpdateRegionId"

    static const int kGlobalUpdateRegionId = 0;

    /**
     * Clears the field "globalUpdateRegionId".
     *
     * The field will be set to its default value. The hasGlobalUpdateRegionId()
     * method will return false.
     */
    inline void clearGlobalUpdateRegionId();

    /**
     * Checks whether the field "globalUpdateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasGlobalUpdateRegionId () const;

    /**
     * Returns the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalUpdateRegionId"
     */
    inline const GlobalUpdateRegionId& getGlobalUpdateRegionId () const;

    /**
     * Retrieves the value of the field "globalUpdateRegionId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalUpdateRegionId".
     */
    inline GlobalUpdateRegionId& getGlobalUpdateRegionIdMutable ();

    /**
     * Sets the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @param globalUpdateRegionId The value which will be set
     */
    inline void setGlobalUpdateRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_);

    // API of field "namedObjectId"

    static const int kNamedObjectId = 1;

    /**
     * Clears the field "namedObjectId".
     *
     * The field will be set to its default value. The hasNamedObjectId()
     * method will return false.
     */
    inline void clearNamedObjectId();

    /**
     * Checks whether the field "namedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasNamedObjectId () const;

    /**
     * Returns the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "namedObjectId"
     */
    inline uint32 getNamedObjectId () const;

    /**
     * Sets the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @param namedObjectId The value which will be set
     */
    inline void setNamedObjectId (uint32 namedObjectId_);

    // API of field "poiRegionId"

    static const int kPoiRegionId = 2;

    /**
     * Clears the field "poiRegionId".
     *
     * The field will be set to its default value. The hasPoiRegionId()
     * method will return false.
     */
    inline void clearPoiRegionId();

    /**
     * Checks whether the field "poiRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiRegionId()). Otherwise it will return false.
     */
    inline bool hasPoiRegionId () const;

    /**
     * Returns the value of the member "poiRegionId".
     *
     * If the meaning of "poiRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiRegionId"
     */
    inline uint64 getPoiRegionId () const;

    /**
     * Sets the value of the member "poiRegionId".
     *
     * If the meaning of "poiRegionId" isn't clear, then there should be a description here.
     *
     * @param poiRegionId The value which will be set
     */
    inline void setPoiRegionId (uint64 poiRegionId_);

    // API of field "globalXrefID"

    static const int kGlobalXrefID = 3;

    /**
     * Clears the field "globalXrefID".
     *
     * The field will be set to its default value. The hasGlobalXrefID()
     * method will return false.
     */
    inline void clearGlobalXrefID();

    /**
     * Checks whether the field "globalXrefID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalXrefID()). Otherwise it will return false.
     */
    inline bool hasGlobalXrefID () const;

    /**
     * Returns the value of the member "globalXrefID".
     *
     * If the meaning of "globalXrefID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalXrefID"
     */
    inline uint32 getGlobalXrefID () const;

    /**
     * Sets the value of the member "globalXrefID".
     *
     * If the meaning of "globalXrefID" isn't clear, then there should be a description here.
     *
     * @param globalXrefID The value which will be set
     */
    inline void setGlobalXrefID (uint32 globalXrefID_);

    static const GlobalNamedObjectAndRegionId &getDefaultInstance();

private:

    inline void set_has_globalUpdateRegionId ();

    inline void clear_has_globalUpdateRegionId ();

    inline void set_has_namedObjectId ();

    inline void clear_has_namedObjectId ();

    inline void set_has_poiRegionId ();

    inline void clear_has_poiRegionId ();

    inline void set_has_globalXrefID ();

    inline void clear_has_globalXrefID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    GlobalUpdateRegionId _globalUpdateRegionId;

    uint32 _namedObjectId;

    uint64 _poiRegionId;

    uint32 _globalXrefID;

};

/**
 * struct contains Global ids of country and subcountries
 */
class SubCountryIds {
public:

    /**
     * Default constructor
     */
    inline  SubCountryIds ();

    /**
     * Copy constructor
     */
    inline  SubCountryIds (const SubCountryIds &rhs);

    /**
     * All fields constructor
     */
    inline  SubCountryIds (const GlobalNamedObjectId& countryId_, const ::std::vector< GlobalNamedObjectAndRegionId >& subCountryIdList_);

    /**
     * Destructor
     */
    inline  ~SubCountryIds();

    /**
     * Assignment operator
     */
    inline SubCountryIds& operator = (const SubCountryIds& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubCountryIds& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubCountryIds& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubCountryIds& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubCountryIds& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "countryId"

    static const int kCountryId = 0;

    /**
     * Clears the field "countryId".
     *
     * The field will be set to its default value. The hasCountryId()
     * method will return false.
     */
    inline void clearCountryId();

    /**
     * Checks whether the field "countryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryId()). Otherwise it will return false.
     */
    inline bool hasCountryId () const;

    /**
     * Returns the value of the member "countryId".
     *
     * If the meaning of "countryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryId"
     */
    inline const GlobalNamedObjectId& getCountryId () const;

    /**
     * Retrieves the value of the field "countryId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryId".
     */
    inline GlobalNamedObjectId& getCountryIdMutable ();

    /**
     * Sets the value of the member "countryId".
     *
     * If the meaning of "countryId" isn't clear, then there should be a description here.
     *
     * @param countryId The value which will be set
     */
    inline void setCountryId (const GlobalNamedObjectId& countryId_);

    // API of field "subCountryIdList"

    static const int kSubCountryIdList = 1;

    /**
     * Clears the field "subCountryIdList".
     *
     * The field will be set to its default value. The hasSubCountryIdList()
     * method will return false.
     */
    inline void clearSubCountryIdList();

    /**
     * Checks whether the field "subCountryIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubCountryIdList()). Otherwise it will return false.
     */
    inline bool hasSubCountryIdList () const;

    /**
     * Returns the value of the member "subCountryIdList".
     *
     * If the meaning of "subCountryIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subCountryIdList"
     */
    inline const ::std::vector< GlobalNamedObjectAndRegionId >& getSubCountryIdList () const;

    /**
     * Retrieves the value of the field "subCountryIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subCountryIdList".
     */
    inline ::std::vector< GlobalNamedObjectAndRegionId >& getSubCountryIdListMutable ();

    /**
     * Sets the value of the member "subCountryIdList".
     *
     * If the meaning of "subCountryIdList" isn't clear, then there should be a description here.
     *
     * @param subCountryIdList The value which will be set
     */
    inline void setSubCountryIdList (const ::std::vector< GlobalNamedObjectAndRegionId >& subCountryIdList_);

    static const SubCountryIds &getDefaultInstance();

private:

    static const ::std::vector< GlobalNamedObjectAndRegionId >& getGlobalNamedObjectAndRegionIdList_DefaultInstance ();

    inline void set_has_countryId ();

    inline void clear_has_countryId ();

    inline void set_has_subCountryIdList ();

    inline void clear_has_subCountryIdList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    GlobalNamedObjectId _countryId;

    ::std::vector< GlobalNamedObjectAndRegionId > _subCountryIdList;

};

/**
 * struct contains Global/common ids of selected elements
 */
class NamedObjectIdStrings {
public:

    /**
     * Default constructor
     */
    inline  NamedObjectIdStrings ();

    /**
     * Copy constructor
     */
    inline  NamedObjectIdStrings (const NamedObjectIdStrings &rhs);

    /**
     * All fields constructor
     */
    inline  NamedObjectIdStrings (const GlobalNamedObjectId& globalNamedObjectId_, const LanguageEntry& languageEntry_, const ::std::vector< ::std::string >& sdsNamedStringsList_, AddressElementType addressElementType_);

    /**
     * Destructor
     */
    inline  ~NamedObjectIdStrings();

    /**
     * Assignment operator
     */
    inline NamedObjectIdStrings& operator = (const NamedObjectIdStrings& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NamedObjectIdStrings& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NamedObjectIdStrings& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NamedObjectIdStrings& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NamedObjectIdStrings& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalNamedObjectId"

    static const int kGlobalNamedObjectId = 0;

    /**
     * Clears the field "globalNamedObjectId".
     *
     * The field will be set to its default value. The hasGlobalNamedObjectId()
     * method will return false.
     */
    inline void clearGlobalNamedObjectId();

    /**
     * Checks whether the field "globalNamedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasGlobalNamedObjectId () const;

    /**
     * Returns the value of the member "globalNamedObjectId".
     *
     * If the meaning of "globalNamedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalNamedObjectId"
     */
    inline const GlobalNamedObjectId& getGlobalNamedObjectId () const;

    /**
     * Retrieves the value of the field "globalNamedObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalNamedObjectId".
     */
    inline GlobalNamedObjectId& getGlobalNamedObjectIdMutable ();

    /**
     * Sets the value of the member "globalNamedObjectId".
     *
     * If the meaning of "globalNamedObjectId" isn't clear, then there should be a description here.
     *
     * @param globalNamedObjectId The value which will be set
     */
    inline void setGlobalNamedObjectId (const GlobalNamedObjectId& globalNamedObjectId_);

    // API of field "languageEntry"

    static const int kLanguageEntry = 1;

    /**
     * Clears the field "languageEntry".
     *
     * The field will be set to its default value. The hasLanguageEntry()
     * method will return false.
     */
    inline void clearLanguageEntry();

    /**
     * Checks whether the field "languageEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageEntry()). Otherwise it will return false.
     */
    inline bool hasLanguageEntry () const;

    /**
     * Returns the value of the member "languageEntry".
     *
     * If the meaning of "languageEntry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageEntry"
     */
    inline const LanguageEntry& getLanguageEntry () const;

    /**
     * Retrieves the value of the field "languageEntry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageEntry".
     */
    inline LanguageEntry& getLanguageEntryMutable ();

    /**
     * Sets the value of the member "languageEntry".
     *
     * If the meaning of "languageEntry" isn't clear, then there should be a description here.
     *
     * @param languageEntry The value which will be set
     */
    inline void setLanguageEntry (const LanguageEntry& languageEntry_);

    // API of field "sdsNamedStringsList"

    static const int kSdsNamedStringsList = 2;

    /**
     * Clears the field "sdsNamedStringsList".
     *
     * The field will be set to its default value. The hasSdsNamedStringsList()
     * method will return false.
     */
    inline void clearSdsNamedStringsList();

    /**
     * Checks whether the field "sdsNamedStringsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsNamedStringsList()). Otherwise it will return false.
     */
    inline bool hasSdsNamedStringsList () const;

    /**
     * Returns the value of the member "sdsNamedStringsList".
     *
     * If the meaning of "sdsNamedStringsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsNamedStringsList"
     */
    inline const ::std::vector< ::std::string >& getSdsNamedStringsList () const;

    /**
     * Retrieves the value of the field "sdsNamedStringsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsNamedStringsList".
     */
    inline ::std::vector< ::std::string >& getSdsNamedStringsListMutable ();

    /**
     * Sets the value of the member "sdsNamedStringsList".
     *
     * If the meaning of "sdsNamedStringsList" isn't clear, then there should be a description here.
     *
     * @param sdsNamedStringsList The value which will be set
     */
    inline void setSdsNamedStringsList (const ::std::vector< ::std::string >& sdsNamedStringsList_);

    // API of field "addressElementType"

    static const int kAddressElementType = 3;

    /**
     * Clears the field "addressElementType".
     *
     * The field will be set to its default value. The hasAddressElementType()
     * method will return false.
     */
    inline void clearAddressElementType();

    /**
     * Checks whether the field "addressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressElementType()). Otherwise it will return false.
     */
    inline bool hasAddressElementType () const;

    /**
     * Returns the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressElementType"
     */
    inline AddressElementType getAddressElementType () const;

    /**
     * Sets the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @param addressElementType The value which will be set
     */
    inline void setAddressElementType (AddressElementType addressElementType_);

    static const NamedObjectIdStrings &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_globalNamedObjectId ();

    inline void clear_has_globalNamedObjectId ();

    inline void set_has_languageEntry ();

    inline void clear_has_languageEntry ();

    inline void set_has_sdsNamedStringsList ();

    inline void clear_has_sdsNamedStringsList ();

    inline void set_has_addressElementType ();

    inline void clear_has_addressElementType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    GlobalNamedObjectId _globalNamedObjectId;

    LanguageEntry _languageEntry;

    ::std::vector< ::std::string > _sdsNamedStringsList;

    AddressElementType _addressElementType;

};

/**
 * struct contains named object ids describing the availability of streets
 */
class CityNamedObjectIdHasStreets {
public:

    /**
     * Default constructor
     */
    inline  CityNamedObjectIdHasStreets ();

    /**
     * Copy constructor
     */
    inline  CityNamedObjectIdHasStreets (const CityNamedObjectIdHasStreets &rhs);

    /**
     * All fields constructor
     */
    inline  CityNamedObjectIdHasStreets (const GlobalNamedObjectId& globalNamedObjectId_, bool hasStreets_);

    /**
     * Destructor
     */
    inline  ~CityNamedObjectIdHasStreets();

    /**
     * Assignment operator
     */
    inline CityNamedObjectIdHasStreets& operator = (const CityNamedObjectIdHasStreets& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CityNamedObjectIdHasStreets& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CityNamedObjectIdHasStreets& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CityNamedObjectIdHasStreets& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CityNamedObjectIdHasStreets& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalNamedObjectId"

    static const int kGlobalNamedObjectId = 0;

    /**
     * Clears the field "globalNamedObjectId".
     *
     * The field will be set to its default value. The hasGlobalNamedObjectId()
     * method will return false.
     */
    inline void clearGlobalNamedObjectId();

    /**
     * Checks whether the field "globalNamedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasGlobalNamedObjectId () const;

    /**
     * Returns the value of the member "globalNamedObjectId".
     *
     * If the meaning of "globalNamedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalNamedObjectId"
     */
    inline const GlobalNamedObjectId& getGlobalNamedObjectId () const;

    /**
     * Retrieves the value of the field "globalNamedObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalNamedObjectId".
     */
    inline GlobalNamedObjectId& getGlobalNamedObjectIdMutable ();

    /**
     * Sets the value of the member "globalNamedObjectId".
     *
     * If the meaning of "globalNamedObjectId" isn't clear, then there should be a description here.
     *
     * @param globalNamedObjectId The value which will be set
     */
    inline void setGlobalNamedObjectId (const GlobalNamedObjectId& globalNamedObjectId_);

    // API of field "hasStreets"

    static const int kHasStreets = 1;

    /**
     * Clears the field "hasStreets".
     *
     * The field will be set to its default value. The hasHasStreets()
     * method will return false.
     */
    inline void clearHasStreets();

    /**
     * Checks whether the field "hasStreets" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHasStreets()). Otherwise it will return false.
     */
    inline bool hasHasStreets () const;

    /**
     * Returns the value of the member "hasStreets".
     *
     * If the meaning of "hasStreets" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hasStreets"
     */
    inline bool getHasStreets () const;

    /**
     * Sets the value of the member "hasStreets".
     *
     * If the meaning of "hasStreets" isn't clear, then there should be a description here.
     *
     * @param hasStreets The value which will be set
     */
    inline void setHasStreets (bool hasStreets_);

    static const CityNamedObjectIdHasStreets &getDefaultInstance();

private:

    inline void set_has_globalNamedObjectId ();

    inline void clear_has_globalNamedObjectId ();

    inline void set_has_hasStreets ();

    inline void clear_has_hasStreets ();

    uint32 _has_bits_[ (2 + 31) / 32];

    GlobalNamedObjectId _globalNamedObjectId;

    bool _hasStreets;

};

/**
 * struct contains update region data
 */
class UpdateRegionSpecifierRelations {
public:

    /**
     * Default constructor
     */
    inline  UpdateRegionSpecifierRelations ();

    /**
     * Copy constructor
     */
    inline  UpdateRegionSpecifierRelations (const UpdateRegionSpecifierRelations &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateRegionSpecifierRelations (uint16 updateRegionSpecifier_, uint8 supplierId_, uint32 productId_, uint16 updateRegionId_);

    /**
     * Destructor
     */
    inline  ~UpdateRegionSpecifierRelations();

    /**
     * Assignment operator
     */
    inline UpdateRegionSpecifierRelations& operator = (const UpdateRegionSpecifierRelations& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateRegionSpecifierRelations& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateRegionSpecifierRelations& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateRegionSpecifierRelations& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateRegionSpecifierRelations& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionSpecifier"

    static const int kUpdateRegionSpecifier = 0;

    /**
     * Clears the field "updateRegionSpecifier".
     *
     * The field will be set to its default value. The hasUpdateRegionSpecifier()
     * method will return false.
     */
    inline void clearUpdateRegionSpecifier();

    /**
     * Checks whether the field "updateRegionSpecifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionSpecifier()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionSpecifier () const;

    /**
     * Returns the value of the member "updateRegionSpecifier".
     *
     * If the meaning of "updateRegionSpecifier" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionSpecifier"
     */
    inline uint16 getUpdateRegionSpecifier () const;

    /**
     * Sets the value of the member "updateRegionSpecifier".
     *
     * If the meaning of "updateRegionSpecifier" isn't clear, then there should be a description here.
     *
     * @param updateRegionSpecifier The value which will be set
     */
    inline void setUpdateRegionSpecifier (uint16 updateRegionSpecifier_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint8 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint8 supplierId_);

    // API of field "productId"

    static const int kProductId = 2;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 3;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline uint16 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (uint16 updateRegionId_);

    static const UpdateRegionSpecifierRelations &getDefaultInstance();

private:

    inline void set_has_updateRegionSpecifier ();

    inline void clear_has_updateRegionSpecifier ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _updateRegionSpecifier;

    uint8 _supplierId;

    uint32 _productId;

    uint16 _updateRegionId;

};

/**
 * struct contains whether handover screen is active and/or lock out mode is active.
 */
class HandOverSessionStatus {
public:

    /**
     * Default constructor
     */
    inline  HandOverSessionStatus ();

    /**
     * Copy constructor
     */
    inline  HandOverSessionStatus (const HandOverSessionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HandOverSessionStatus (bool isHandOverScreenActive_, bool isLockOutModeActive_);

    /**
     * Destructor
     */
    inline  ~HandOverSessionStatus();

    /**
     * Assignment operator
     */
    inline HandOverSessionStatus& operator = (const HandOverSessionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandOverSessionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandOverSessionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandOverSessionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandOverSessionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isHandOverScreenActive"

    static const int kIsHandOverScreenActive = 0;

    /**
     * Clears the field "isHandOverScreenActive".
     *
     * The field will be set to its default value. The hasIsHandOverScreenActive()
     * method will return false.
     */
    inline void clearIsHandOverScreenActive();

    /**
     * Checks whether the field "isHandOverScreenActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsHandOverScreenActive()). Otherwise it will return false.
     */
    inline bool hasIsHandOverScreenActive () const;

    /**
     * Returns the value of the member "isHandOverScreenActive".
     *
     * If the meaning of "isHandOverScreenActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isHandOverScreenActive"
     */
    inline bool getIsHandOverScreenActive () const;

    /**
     * Sets the value of the member "isHandOverScreenActive".
     *
     * If the meaning of "isHandOverScreenActive" isn't clear, then there should be a description here.
     *
     * @param isHandOverScreenActive The value which will be set
     */
    inline void setIsHandOverScreenActive (bool isHandOverScreenActive_);

    // API of field "isLockOutModeActive"

    static const int kIsLockOutModeActive = 1;

    /**
     * Clears the field "isLockOutModeActive".
     *
     * The field will be set to its default value. The hasIsLockOutModeActive()
     * method will return false.
     */
    inline void clearIsLockOutModeActive();

    /**
     * Checks whether the field "isLockOutModeActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLockOutModeActive()). Otherwise it will return false.
     */
    inline bool hasIsLockOutModeActive () const;

    /**
     * Returns the value of the member "isLockOutModeActive".
     *
     * If the meaning of "isLockOutModeActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isLockOutModeActive"
     */
    inline bool getIsLockOutModeActive () const;

    /**
     * Sets the value of the member "isLockOutModeActive".
     *
     * If the meaning of "isLockOutModeActive" isn't clear, then there should be a description here.
     *
     * @param isLockOutModeActive The value which will be set
     */
    inline void setIsLockOutModeActive (bool isLockOutModeActive_);

    static const HandOverSessionStatus &getDefaultInstance();

private:

    inline void set_has_isHandOverScreenActive ();

    inline void clear_has_isHandOverScreenActive ();

    inline void set_has_isLockOutModeActive ();

    inline void clear_has_isLockOutModeActive ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _isHandOverScreenActive;

    bool _isLockOutModeActive;

};

/**
 * struct contains address element type and the relevant data.
 */
class SelectedDataItem {
public:

    /**
     * Default constructor
     */
    inline  SelectedDataItem ();

    /**
     * Copy constructor
     */
    inline  SelectedDataItem (const SelectedDataItem &rhs);

    /**
     * All fields constructor
     */
    inline  SelectedDataItem (HMISelectedAddressElementType hmiSelectedAddressElementType_, const ::std::string& data_, const GlobalNamedObjectId& sdsGlobalNameObjectId_);

    /**
     * Destructor
     */
    inline  ~SelectedDataItem();

    /**
     * Assignment operator
     */
    inline SelectedDataItem& operator = (const SelectedDataItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectedDataItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectedDataItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectedDataItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectedDataItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "hmiSelectedAddressElementType"

    static const int kHmiSelectedAddressElementType = 0;

    /**
     * Clears the field "hmiSelectedAddressElementType".
     *
     * The field will be set to its default value. The hasHmiSelectedAddressElementType()
     * method will return false.
     */
    inline void clearHmiSelectedAddressElementType();

    /**
     * Checks whether the field "hmiSelectedAddressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiSelectedAddressElementType()). Otherwise it will return false.
     */
    inline bool hasHmiSelectedAddressElementType () const;

    /**
     * Returns the value of the member "hmiSelectedAddressElementType".
     *
     * If the meaning of "hmiSelectedAddressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hmiSelectedAddressElementType"
     */
    inline HMISelectedAddressElementType getHmiSelectedAddressElementType () const;

    /**
     * Sets the value of the member "hmiSelectedAddressElementType".
     *
     * If the meaning of "hmiSelectedAddressElementType" isn't clear, then there should be a description here.
     *
     * @param hmiSelectedAddressElementType The value which will be set
     */
    inline void setHmiSelectedAddressElementType (HMISelectedAddressElementType hmiSelectedAddressElementType_);

    // API of field "data"

    static const int kData = 1;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "sdsGlobalNameObjectId"

    static const int kSdsGlobalNameObjectId = 2;

    /**
     * Clears the field "sdsGlobalNameObjectId".
     *
     * The field will be set to its default value. The hasSdsGlobalNameObjectId()
     * method will return false.
     */
    inline void clearSdsGlobalNameObjectId();

    /**
     * Checks whether the field "sdsGlobalNameObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsGlobalNameObjectId()). Otherwise it will return false.
     */
    inline bool hasSdsGlobalNameObjectId () const;

    /**
     * Returns the value of the member "sdsGlobalNameObjectId".
     *
     * If the meaning of "sdsGlobalNameObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsGlobalNameObjectId"
     */
    inline const GlobalNamedObjectId& getSdsGlobalNameObjectId () const;

    /**
     * Retrieves the value of the field "sdsGlobalNameObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsGlobalNameObjectId".
     */
    inline GlobalNamedObjectId& getSdsGlobalNameObjectIdMutable ();

    /**
     * Sets the value of the member "sdsGlobalNameObjectId".
     *
     * If the meaning of "sdsGlobalNameObjectId" isn't clear, then there should be a description here.
     *
     * @param sdsGlobalNameObjectId The value which will be set
     */
    inline void setSdsGlobalNameObjectId (const GlobalNamedObjectId& sdsGlobalNameObjectId_);

    static const SelectedDataItem &getDefaultInstance();

private:

    inline void set_has_hmiSelectedAddressElementType ();

    inline void clear_has_hmiSelectedAddressElementType ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_sdsGlobalNameObjectId ();

    inline void clear_has_sdsGlobalNameObjectId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    HMISelectedAddressElementType _hmiSelectedAddressElementType;

    ::std::string _data;

    GlobalNamedObjectId _sdsGlobalNameObjectId;

};

/**
 * struct contains address options that are possible for given HMI input.
 */
class SDSHandOverOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSHandOverOptions ();

    /**
     * Copy constructor
     */
    inline  SDSHandOverOptions (const SDSHandOverOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSHandOverOptions (bool isAmbigious_, bool cityHasStreet_, bool houseNumberInRange_, bool streetHasHouseNumber_, bool junctionAvailable_);

    /**
     * Destructor
     */
    inline  ~SDSHandOverOptions();

    /**
     * Assignment operator
     */
    inline SDSHandOverOptions& operator = (const SDSHandOverOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSHandOverOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSHandOverOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSHandOverOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSHandOverOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isAmbigious"

    static const int kIsAmbigious = 0;

    /**
     * Clears the field "isAmbigious".
     *
     * The field will be set to its default value. The hasIsAmbigious()
     * method will return false.
     */
    inline void clearIsAmbigious();

    /**
     * Checks whether the field "isAmbigious" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAmbigious()). Otherwise it will return false.
     */
    inline bool hasIsAmbigious () const;

    /**
     * Returns the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isAmbigious"
     */
    inline bool getIsAmbigious () const;

    /**
     * Sets the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @param isAmbigious The value which will be set
     */
    inline void setIsAmbigious (bool isAmbigious_);

    // API of field "cityHasStreet"

    static const int kCityHasStreet = 1;

    /**
     * Clears the field "cityHasStreet".
     *
     * The field will be set to its default value. The hasCityHasStreet()
     * method will return false.
     */
    inline void clearCityHasStreet();

    /**
     * Checks whether the field "cityHasStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityHasStreet()). Otherwise it will return false.
     */
    inline bool hasCityHasStreet () const;

    /**
     * Returns the value of the member "cityHasStreet".
     *
     * If the meaning of "cityHasStreet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityHasStreet"
     */
    inline bool getCityHasStreet () const;

    /**
     * Sets the value of the member "cityHasStreet".
     *
     * If the meaning of "cityHasStreet" isn't clear, then there should be a description here.
     *
     * @param cityHasStreet The value which will be set
     */
    inline void setCityHasStreet (bool cityHasStreet_);

    // API of field "houseNumberInRange"

    static const int kHouseNumberInRange = 2;

    /**
     * Clears the field "houseNumberInRange".
     *
     * The field will be set to its default value. The hasHouseNumberInRange()
     * method will return false.
     */
    inline void clearHouseNumberInRange();

    /**
     * Checks whether the field "houseNumberInRange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseNumberInRange()). Otherwise it will return false.
     */
    inline bool hasHouseNumberInRange () const;

    /**
     * Returns the value of the member "houseNumberInRange".
     *
     * If the meaning of "houseNumberInRange" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseNumberInRange"
     */
    inline bool getHouseNumberInRange () const;

    /**
     * Sets the value of the member "houseNumberInRange".
     *
     * If the meaning of "houseNumberInRange" isn't clear, then there should be a description here.
     *
     * @param houseNumberInRange The value which will be set
     */
    inline void setHouseNumberInRange (bool houseNumberInRange_);

    // API of field "streetHasHouseNumber"

    static const int kStreetHasHouseNumber = 3;

    /**
     * Clears the field "streetHasHouseNumber".
     *
     * The field will be set to its default value. The hasStreetHasHouseNumber()
     * method will return false.
     */
    inline void clearStreetHasHouseNumber();

    /**
     * Checks whether the field "streetHasHouseNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetHasHouseNumber()). Otherwise it will return false.
     */
    inline bool hasStreetHasHouseNumber () const;

    /**
     * Returns the value of the member "streetHasHouseNumber".
     *
     * If the meaning of "streetHasHouseNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "streetHasHouseNumber"
     */
    inline bool getStreetHasHouseNumber () const;

    /**
     * Sets the value of the member "streetHasHouseNumber".
     *
     * If the meaning of "streetHasHouseNumber" isn't clear, then there should be a description here.
     *
     * @param streetHasHouseNumber The value which will be set
     */
    inline void setStreetHasHouseNumber (bool streetHasHouseNumber_);

    // API of field "junctionAvailable"

    static const int kJunctionAvailable = 4;

    /**
     * Clears the field "junctionAvailable".
     *
     * The field will be set to its default value. The hasJunctionAvailable()
     * method will return false.
     */
    inline void clearJunctionAvailable();

    /**
     * Checks whether the field "junctionAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJunctionAvailable()). Otherwise it will return false.
     */
    inline bool hasJunctionAvailable () const;

    /**
     * Returns the value of the member "junctionAvailable".
     *
     * If the meaning of "junctionAvailable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "junctionAvailable"
     */
    inline bool getJunctionAvailable () const;

    /**
     * Sets the value of the member "junctionAvailable".
     *
     * If the meaning of "junctionAvailable" isn't clear, then there should be a description here.
     *
     * @param junctionAvailable The value which will be set
     */
    inline void setJunctionAvailable (bool junctionAvailable_);

    static const SDSHandOverOptions &getDefaultInstance();

private:

    inline void set_has_isAmbigious ();

    inline void clear_has_isAmbigious ();

    inline void set_has_cityHasStreet ();

    inline void clear_has_cityHasStreet ();

    inline void set_has_houseNumberInRange ();

    inline void clear_has_houseNumberInRange ();

    inline void set_has_streetHasHouseNumber ();

    inline void clear_has_streetHasHouseNumber ();

    inline void set_has_junctionAvailable ();

    inline void clear_has_junctionAvailable ();

    uint32 _has_bits_[ (5 + 31) / 32];

    bool _isAmbigious;

    bool _cityHasStreet;

    bool _houseNumberInRange;

    bool _streetHasHouseNumber;

    bool _junctionAvailable;

};

/**
 * struct contains NDS ids current position
 */
class NDSNamedObjectData {
public:

    /**
     * Default constructor
     */
    inline  NDSNamedObjectData ();

    /**
     * Copy constructor
     */
    inline  NDSNamedObjectData (const NDSNamedObjectData &rhs);

    /**
     * All fields constructor
     */
    inline  NDSNamedObjectData (const ::std::string& objectName_, uint32 ndsNamedObjectId_, uint16 NdsUpdateRegionSpecifier_);

    /**
     * Destructor
     */
    inline  ~NDSNamedObjectData();

    /**
     * Assignment operator
     */
    inline NDSNamedObjectData& operator = (const NDSNamedObjectData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NDSNamedObjectData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NDSNamedObjectData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NDSNamedObjectData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NDSNamedObjectData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "objectName"

    static const int kObjectName = 0;

    /**
     * Clears the field "objectName".
     *
     * The field will be set to its default value. The hasObjectName()
     * method will return false.
     */
    inline void clearObjectName();

    /**
     * Checks whether the field "objectName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjectName()). Otherwise it will return false.
     */
    inline bool hasObjectName () const;

    /**
     * Returns the value of the member "objectName".
     *
     * If the meaning of "objectName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "objectName"
     */
    inline const ::std::string& getObjectName () const;

    /**
     * Retrieves the value of the field "objectName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "objectName".
     */
    inline ::std::string& getObjectNameMutable ();

    /**
     * Sets the value of the member "objectName".
     *
     * If the meaning of "objectName" isn't clear, then there should be a description here.
     *
     * @param objectName The value which will be set
     */
    inline void setObjectName (const ::std::string& objectName_);

    /**
     * Sets the value of the member "objectName".
     *
     * If the meaning of "objectName" isn't clear, then there should be a description here.
     *
     * @param objectName The value which will be set
     */
    inline void setObjectName (const char* objectName_);

    /**
     * Sets the value of the member "objectName".
     *
     * If the meaning of "objectName" isn't clear, then there should be a description here.
     *
     * @param objectName The value which will be set
     */
    inline void setObjectName (const char* value, size_t size);

    // API of field "ndsNamedObjectId"

    static const int kNdsNamedObjectId = 1;

    /**
     * Clears the field "ndsNamedObjectId".
     *
     * The field will be set to its default value. The hasNdsNamedObjectId()
     * method will return false.
     */
    inline void clearNdsNamedObjectId();

    /**
     * Checks whether the field "ndsNamedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasNdsNamedObjectId () const;

    /**
     * Returns the value of the member "ndsNamedObjectId".
     *
     * If the meaning of "ndsNamedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsNamedObjectId"
     */
    inline uint32 getNdsNamedObjectId () const;

    /**
     * Sets the value of the member "ndsNamedObjectId".
     *
     * If the meaning of "ndsNamedObjectId" isn't clear, then there should be a description here.
     *
     * @param ndsNamedObjectId The value which will be set
     */
    inline void setNdsNamedObjectId (uint32 ndsNamedObjectId_);

    // API of field "NdsUpdateRegionSpecifier"

    static const int kNdsUpdateRegionSpecifier = 2;

    /**
     * Clears the field "NdsUpdateRegionSpecifier".
     *
     * The field will be set to its default value. The hasNdsUpdateRegionSpecifier()
     * method will return false.
     */
    inline void clearNdsUpdateRegionSpecifier();

    /**
     * Checks whether the field "NdsUpdateRegionSpecifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsUpdateRegionSpecifier()). Otherwise it will return false.
     */
    inline bool hasNdsUpdateRegionSpecifier () const;

    /**
     * Returns the value of the member "NdsUpdateRegionSpecifier".
     *
     * If the meaning of "NdsUpdateRegionSpecifier" isn't clear, then there should be a description here.
     *
     * @return The value of the field "NdsUpdateRegionSpecifier"
     */
    inline uint16 getNdsUpdateRegionSpecifier () const;

    /**
     * Sets the value of the member "NdsUpdateRegionSpecifier".
     *
     * If the meaning of "NdsUpdateRegionSpecifier" isn't clear, then there should be a description here.
     *
     * @param NdsUpdateRegionSpecifier The value which will be set
     */
    inline void setNdsUpdateRegionSpecifier (uint16 NdsUpdateRegionSpecifier_);

    static const NDSNamedObjectData &getDefaultInstance();

private:

    inline void set_has_objectName ();

    inline void clear_has_objectName ();

    inline void set_has_ndsNamedObjectId ();

    inline void clear_has_ndsNamedObjectId ();

    inline void set_has_NdsUpdateRegionSpecifier ();

    inline void clear_has_NdsUpdateRegionSpecifier ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _objectName;

    uint32 _ndsNamedObjectId;

    uint16 _NdsUpdateRegionSpecifier;

};

/**
 * struct contains Position information
 */
class PositionInfo {
public:

    /**
     * Default constructor
     */
    inline  PositionInfo ();

    /**
     * Copy constructor
     */
    inline  PositionInfo (const PositionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  PositionInfo (const ::std::string& country_, const ::std::string& province_, const ::std::string& city_, const ::std::string& cityDistrict_, const ::std::string& street_, const ::std::string& streetNumber_, const NDSNamedObjectData& currentCountry_, const NDSNamedObjectData& currentState_, const NDSNamedObjectData& currentCity_, const NDSNamedObjectData& currentCityDistrict_, const NDSNamedObjectData& currentStreet_, const NDSNamedObjectData& currentIntersection_, const NDSNamedObjectData& currentZipCode_, bool isUniqueIdValid_, uint32 uniqueId_);

    /**
     * Destructor
     */
    inline  ~PositionInfo();

    /**
     * Assignment operator
     */
    inline PositionInfo& operator = (const PositionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "country"

    static const int kCountry = 0;

    /**
     * Clears the field "country".
     *
     * The field will be set to its default value. The hasCountry()
     * method will return false.
     */
    inline void clearCountry();

    /**
     * Checks whether the field "country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountry()). Otherwise it will return false.
     */
    inline bool hasCountry () const;

    /**
     * Returns the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "country"
     */
    inline const ::std::string& getCountry () const;

    /**
     * Retrieves the value of the field "country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "country".
     */
    inline ::std::string& getCountryMutable ();

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const ::std::string& country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* value, size_t size);

    // API of field "province"

    static const int kProvince = 1;

    /**
     * Clears the field "province".
     *
     * The field will be set to its default value. The hasProvince()
     * method will return false.
     */
    inline void clearProvince();

    /**
     * Checks whether the field "province" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProvince()). Otherwise it will return false.
     */
    inline bool hasProvince () const;

    /**
     * Returns the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @return The value of the field "province"
     */
    inline const ::std::string& getProvince () const;

    /**
     * Retrieves the value of the field "province" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "province".
     */
    inline ::std::string& getProvinceMutable ();

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const ::std::string& province_);

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const char* province_);

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const char* value, size_t size);

    // API of field "city"

    static const int kCity = 2;

    /**
     * Clears the field "city".
     *
     * The field will be set to its default value. The hasCity()
     * method will return false.
     */
    inline void clearCity();

    /**
     * Checks whether the field "city" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity()). Otherwise it will return false.
     */
    inline bool hasCity () const;

    /**
     * Returns the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @return The value of the field "city"
     */
    inline const ::std::string& getCity () const;

    /**
     * Retrieves the value of the field "city" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "city".
     */
    inline ::std::string& getCityMutable ();

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const ::std::string& city_);

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const char* city_);

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const char* value, size_t size);

    // API of field "cityDistrict"

    static const int kCityDistrict = 3;

    /**
     * Clears the field "cityDistrict".
     *
     * The field will be set to its default value. The hasCityDistrict()
     * method will return false.
     */
    inline void clearCityDistrict();

    /**
     * Checks whether the field "cityDistrict" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityDistrict()). Otherwise it will return false.
     */
    inline bool hasCityDistrict () const;

    /**
     * Returns the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityDistrict"
     */
    inline const ::std::string& getCityDistrict () const;

    /**
     * Retrieves the value of the field "cityDistrict" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityDistrict".
     */
    inline ::std::string& getCityDistrictMutable ();

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const ::std::string& cityDistrict_);

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const char* cityDistrict_);

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const char* value, size_t size);

    // API of field "street"

    static const int kStreet = 4;

    /**
     * Clears the field "street".
     *
     * The field will be set to its default value. The hasStreet()
     * method will return false.
     */
    inline void clearStreet();

    /**
     * Checks whether the field "street" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreet()). Otherwise it will return false.
     */
    inline bool hasStreet () const;

    /**
     * Returns the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @return The value of the field "street"
     */
    inline const ::std::string& getStreet () const;

    /**
     * Retrieves the value of the field "street" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "street".
     */
    inline ::std::string& getStreetMutable ();

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const ::std::string& street_);

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const char* street_);

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const char* value, size_t size);

    // API of field "streetNumber"

    static const int kStreetNumber = 5;

    /**
     * Clears the field "streetNumber".
     *
     * The field will be set to its default value. The hasStreetNumber()
     * method will return false.
     */
    inline void clearStreetNumber();

    /**
     * Checks whether the field "streetNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetNumber()). Otherwise it will return false.
     */
    inline bool hasStreetNumber () const;

    /**
     * Returns the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "streetNumber"
     */
    inline const ::std::string& getStreetNumber () const;

    /**
     * Retrieves the value of the field "streetNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "streetNumber".
     */
    inline ::std::string& getStreetNumberMutable ();

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const ::std::string& streetNumber_);

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const char* streetNumber_);

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const char* value, size_t size);

    // API of field "currentCountry"

    static const int kCurrentCountry = 6;

    /**
     * Clears the field "currentCountry".
     *
     * The field will be set to its default value. The hasCurrentCountry()
     * method will return false.
     */
    inline void clearCurrentCountry();

    /**
     * Checks whether the field "currentCountry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentCountry()). Otherwise it will return false.
     */
    inline bool hasCurrentCountry () const;

    /**
     * Returns the value of the member "currentCountry".
     *
     * If the meaning of "currentCountry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentCountry"
     */
    inline const NDSNamedObjectData& getCurrentCountry () const;

    /**
     * Retrieves the value of the field "currentCountry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentCountry".
     */
    inline NDSNamedObjectData& getCurrentCountryMutable ();

    /**
     * Sets the value of the member "currentCountry".
     *
     * If the meaning of "currentCountry" isn't clear, then there should be a description here.
     *
     * @param currentCountry The value which will be set
     */
    inline void setCurrentCountry (const NDSNamedObjectData& currentCountry_);

    // API of field "currentState"

    static const int kCurrentState = 7;

    /**
     * Clears the field "currentState".
     *
     * The field will be set to its default value. The hasCurrentState()
     * method will return false.
     */
    inline void clearCurrentState();

    /**
     * Checks whether the field "currentState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentState()). Otherwise it will return false.
     */
    inline bool hasCurrentState () const;

    /**
     * Returns the value of the member "currentState".
     *
     * If the meaning of "currentState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentState"
     */
    inline const NDSNamedObjectData& getCurrentState () const;

    /**
     * Retrieves the value of the field "currentState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentState".
     */
    inline NDSNamedObjectData& getCurrentStateMutable ();

    /**
     * Sets the value of the member "currentState".
     *
     * If the meaning of "currentState" isn't clear, then there should be a description here.
     *
     * @param currentState The value which will be set
     */
    inline void setCurrentState (const NDSNamedObjectData& currentState_);

    // API of field "currentCity"

    static const int kCurrentCity = 8;

    /**
     * Clears the field "currentCity".
     *
     * The field will be set to its default value. The hasCurrentCity()
     * method will return false.
     */
    inline void clearCurrentCity();

    /**
     * Checks whether the field "currentCity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentCity()). Otherwise it will return false.
     */
    inline bool hasCurrentCity () const;

    /**
     * Returns the value of the member "currentCity".
     *
     * If the meaning of "currentCity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentCity"
     */
    inline const NDSNamedObjectData& getCurrentCity () const;

    /**
     * Retrieves the value of the field "currentCity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentCity".
     */
    inline NDSNamedObjectData& getCurrentCityMutable ();

    /**
     * Sets the value of the member "currentCity".
     *
     * If the meaning of "currentCity" isn't clear, then there should be a description here.
     *
     * @param currentCity The value which will be set
     */
    inline void setCurrentCity (const NDSNamedObjectData& currentCity_);

    // API of field "currentCityDistrict"

    static const int kCurrentCityDistrict = 9;

    /**
     * Clears the field "currentCityDistrict".
     *
     * The field will be set to its default value. The hasCurrentCityDistrict()
     * method will return false.
     */
    inline void clearCurrentCityDistrict();

    /**
     * Checks whether the field "currentCityDistrict" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentCityDistrict()). Otherwise it will return false.
     */
    inline bool hasCurrentCityDistrict () const;

    /**
     * Returns the value of the member "currentCityDistrict".
     *
     * If the meaning of "currentCityDistrict" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentCityDistrict"
     */
    inline const NDSNamedObjectData& getCurrentCityDistrict () const;

    /**
     * Retrieves the value of the field "currentCityDistrict" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentCityDistrict".
     */
    inline NDSNamedObjectData& getCurrentCityDistrictMutable ();

    /**
     * Sets the value of the member "currentCityDistrict".
     *
     * If the meaning of "currentCityDistrict" isn't clear, then there should be a description here.
     *
     * @param currentCityDistrict The value which will be set
     */
    inline void setCurrentCityDistrict (const NDSNamedObjectData& currentCityDistrict_);

    // API of field "currentStreet"

    static const int kCurrentStreet = 10;

    /**
     * Clears the field "currentStreet".
     *
     * The field will be set to its default value. The hasCurrentStreet()
     * method will return false.
     */
    inline void clearCurrentStreet();

    /**
     * Checks whether the field "currentStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentStreet()). Otherwise it will return false.
     */
    inline bool hasCurrentStreet () const;

    /**
     * Returns the value of the member "currentStreet".
     *
     * If the meaning of "currentStreet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentStreet"
     */
    inline const NDSNamedObjectData& getCurrentStreet () const;

    /**
     * Retrieves the value of the field "currentStreet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentStreet".
     */
    inline NDSNamedObjectData& getCurrentStreetMutable ();

    /**
     * Sets the value of the member "currentStreet".
     *
     * If the meaning of "currentStreet" isn't clear, then there should be a description here.
     *
     * @param currentStreet The value which will be set
     */
    inline void setCurrentStreet (const NDSNamedObjectData& currentStreet_);

    // API of field "currentIntersection"

    static const int kCurrentIntersection = 11;

    /**
     * Clears the field "currentIntersection".
     *
     * The field will be set to its default value. The hasCurrentIntersection()
     * method will return false.
     */
    inline void clearCurrentIntersection();

    /**
     * Checks whether the field "currentIntersection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentIntersection()). Otherwise it will return false.
     */
    inline bool hasCurrentIntersection () const;

    /**
     * Returns the value of the member "currentIntersection".
     *
     * If the meaning of "currentIntersection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentIntersection"
     */
    inline const NDSNamedObjectData& getCurrentIntersection () const;

    /**
     * Retrieves the value of the field "currentIntersection" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentIntersection".
     */
    inline NDSNamedObjectData& getCurrentIntersectionMutable ();

    /**
     * Sets the value of the member "currentIntersection".
     *
     * If the meaning of "currentIntersection" isn't clear, then there should be a description here.
     *
     * @param currentIntersection The value which will be set
     */
    inline void setCurrentIntersection (const NDSNamedObjectData& currentIntersection_);

    // API of field "currentZipCode"

    static const int kCurrentZipCode = 12;

    /**
     * Clears the field "currentZipCode".
     *
     * The field will be set to its default value. The hasCurrentZipCode()
     * method will return false.
     */
    inline void clearCurrentZipCode();

    /**
     * Checks whether the field "currentZipCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentZipCode()). Otherwise it will return false.
     */
    inline bool hasCurrentZipCode () const;

    /**
     * Returns the value of the member "currentZipCode".
     *
     * If the meaning of "currentZipCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentZipCode"
     */
    inline const NDSNamedObjectData& getCurrentZipCode () const;

    /**
     * Retrieves the value of the field "currentZipCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentZipCode".
     */
    inline NDSNamedObjectData& getCurrentZipCodeMutable ();

    /**
     * Sets the value of the member "currentZipCode".
     *
     * If the meaning of "currentZipCode" isn't clear, then there should be a description here.
     *
     * @param currentZipCode The value which will be set
     */
    inline void setCurrentZipCode (const NDSNamedObjectData& currentZipCode_);

    // API of field "isUniqueIdValid"

    static const int kIsUniqueIdValid = 13;

    /**
     * Clears the field "isUniqueIdValid".
     *
     * The field will be set to its default value. The hasIsUniqueIdValid()
     * method will return false.
     */
    inline void clearIsUniqueIdValid();

    /**
     * Checks whether the field "isUniqueIdValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsUniqueIdValid()). Otherwise it will return false.
     */
    inline bool hasIsUniqueIdValid () const;

    /**
     * Returns the value of the member "isUniqueIdValid".
     *
     * If the meaning of "isUniqueIdValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isUniqueIdValid"
     */
    inline bool getIsUniqueIdValid () const;

    /**
     * Sets the value of the member "isUniqueIdValid".
     *
     * If the meaning of "isUniqueIdValid" isn't clear, then there should be a description here.
     *
     * @param isUniqueIdValid The value which will be set
     */
    inline void setIsUniqueIdValid (bool isUniqueIdValid_);

    // API of field "uniqueId"

    static const int kUniqueId = 14;

    /**
     * Clears the field "uniqueId".
     *
     * The field will be set to its default value. The hasUniqueId()
     * method will return false.
     */
    inline void clearUniqueId();

    /**
     * Checks whether the field "uniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUniqueId()). Otherwise it will return false.
     */
    inline bool hasUniqueId () const;

    /**
     * Returns the value of the member "uniqueId".
     *
     * If the meaning of "uniqueId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uniqueId"
     */
    inline uint32 getUniqueId () const;

    /**
     * Sets the value of the member "uniqueId".
     *
     * If the meaning of "uniqueId" isn't clear, then there should be a description here.
     *
     * @param uniqueId The value which will be set
     */
    inline void setUniqueId (uint32 uniqueId_);

    static const PositionInfo &getDefaultInstance();

private:

    inline void set_has_country ();

    inline void clear_has_country ();

    inline void set_has_province ();

    inline void clear_has_province ();

    inline void set_has_city ();

    inline void clear_has_city ();

    inline void set_has_cityDistrict ();

    inline void clear_has_cityDistrict ();

    inline void set_has_street ();

    inline void clear_has_street ();

    inline void set_has_streetNumber ();

    inline void clear_has_streetNumber ();

    inline void set_has_currentCountry ();

    inline void clear_has_currentCountry ();

    inline void set_has_currentState ();

    inline void clear_has_currentState ();

    inline void set_has_currentCity ();

    inline void clear_has_currentCity ();

    inline void set_has_currentCityDistrict ();

    inline void clear_has_currentCityDistrict ();

    inline void set_has_currentStreet ();

    inline void clear_has_currentStreet ();

    inline void set_has_currentIntersection ();

    inline void clear_has_currentIntersection ();

    inline void set_has_currentZipCode ();

    inline void clear_has_currentZipCode ();

    inline void set_has_isUniqueIdValid ();

    inline void clear_has_isUniqueIdValid ();

    inline void set_has_uniqueId ();

    inline void clear_has_uniqueId ();

    uint32 _has_bits_[ (15 + 31) / 32];

    ::std::string _country;

    ::std::string _province;

    ::std::string _city;

    ::std::string _cityDistrict;

    ::std::string _street;

    ::std::string _streetNumber;

    NDSNamedObjectData _currentCountry;

    NDSNamedObjectData _currentState;

    NDSNamedObjectData _currentCity;

    NDSNamedObjectData _currentCityDistrict;

    NDSNamedObjectData _currentStreet;

    NDSNamedObjectData _currentIntersection;

    NDSNamedObjectData _currentZipCode;

    bool _isUniqueIdValid;

    uint32 _uniqueId;

};

/**
 * If the meaning of "PositionWGS84" isn't clear, then there should be a description here.
 */
class PositionWGS84 {
public:

    /**
     * Default constructor
     */
    inline  PositionWGS84 ();

    /**
     * Copy constructor
     */
    inline  PositionWGS84 (const PositionWGS84 &rhs);

    /**
     * All fields constructor
     */
    inline  PositionWGS84 (double longitude_, double latitude_);

    /**
     * Destructor
     */
    inline  ~PositionWGS84();

    /**
     * Assignment operator
     */
    inline PositionWGS84& operator = (const PositionWGS84& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionWGS84& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionWGS84& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionWGS84& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionWGS84& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "longitude"

    static const int kLongitude = 0;

    /**
     * Clears the field "longitude".
     *
     * The field will be set to its default value. The hasLongitude()
     * method will return false.
     */
    inline void clearLongitude();

    /**
     * Checks whether the field "longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitude()). Otherwise it will return false.
     */
    inline bool hasLongitude () const;

    /**
     * Returns the value of the member "longitude".
     *
     * If the meaning of "longitude" isn't clear, then there should be a description here.
     *
     * @return The value of the field "longitude"
     */
    inline double getLongitude () const;

    /**
     * Sets the value of the member "longitude".
     *
     * If the meaning of "longitude" isn't clear, then there should be a description here.
     *
     * @param longitude The value which will be set
     */
    inline void setLongitude (double longitude_);

    // API of field "latitude"

    static const int kLatitude = 1;

    /**
     * Clears the field "latitude".
     *
     * The field will be set to its default value. The hasLatitude()
     * method will return false.
     */
    inline void clearLatitude();

    /**
     * Checks whether the field "latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitude()). Otherwise it will return false.
     */
    inline bool hasLatitude () const;

    /**
     * Returns the value of the member "latitude".
     *
     * If the meaning of "latitude" isn't clear, then there should be a description here.
     *
     * @return The value of the field "latitude"
     */
    inline double getLatitude () const;

    /**
     * Sets the value of the member "latitude".
     *
     * If the meaning of "latitude" isn't clear, then there should be a description here.
     *
     * @param latitude The value which will be set
     */
    inline void setLatitude (double latitude_);

    static const PositionWGS84 &getDefaultInstance();

private:

    inline void set_has_longitude ();

    inline void clear_has_longitude ();

    inline void set_has_latitude ();

    inline void clear_has_latitude ();

    uint32 _has_bits_[ (2 + 31) / 32];

    double _longitude;

    double _latitude;

};

/**
 * struct contains Position status information
 */
class PositionStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  PositionStatusInfo ();

    /**
     * Copy constructor
     */
    inline  PositionStatusInfo (const PositionStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  PositionStatusInfo (const PositionWGS84& positionWGS84_, const ::std::string& countryCode_, const ::std::string& stateCode_, RoadClass roadClass_, float vehicleSpeed_, float vehicleHeading_, bool isUniqueIdValid_, uint32 uniqueId_);

    /**
     * Destructor
     */
    inline  ~PositionStatusInfo();

    /**
     * Assignment operator
     */
    inline PositionStatusInfo& operator = (const PositionStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "positionWGS84"

    static const int kPositionWGS84 = 0;

    /**
     * Clears the field "positionWGS84".
     *
     * The field will be set to its default value. The hasPositionWGS84()
     * method will return false.
     */
    inline void clearPositionWGS84();

    /**
     * Checks whether the field "positionWGS84" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionWGS84()). Otherwise it will return false.
     */
    inline bool hasPositionWGS84 () const;

    /**
     * Returns the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @return The value of the field "positionWGS84"
     */
    inline const PositionWGS84& getPositionWGS84 () const;

    /**
     * Retrieves the value of the field "positionWGS84" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionWGS84".
     */
    inline PositionWGS84& getPositionWGS84Mutable ();

    /**
     * Sets the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @param positionWGS84 The value which will be set
     */
    inline void setPositionWGS84 (const PositionWGS84& positionWGS84_);

    // API of field "countryCode"

    static const int kCountryCode = 1;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "stateCode"

    static const int kStateCode = 2;

    /**
     * Clears the field "stateCode".
     *
     * The field will be set to its default value. The hasStateCode()
     * method will return false.
     */
    inline void clearStateCode();

    /**
     * Checks whether the field "stateCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateCode()). Otherwise it will return false.
     */
    inline bool hasStateCode () const;

    /**
     * Returns the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stateCode"
     */
    inline const ::std::string& getStateCode () const;

    /**
     * Retrieves the value of the field "stateCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateCode".
     */
    inline ::std::string& getStateCodeMutable ();

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const ::std::string& stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* value, size_t size);

    // API of field "roadClass"

    static const int kRoadClass = 3;

    /**
     * Clears the field "roadClass".
     *
     * The field will be set to its default value. The hasRoadClass()
     * method will return false.
     */
    inline void clearRoadClass();

    /**
     * Checks whether the field "roadClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadClass()). Otherwise it will return false.
     */
    inline bool hasRoadClass () const;

    /**
     * Returns the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @return The value of the field "roadClass"
     */
    inline RoadClass getRoadClass () const;

    /**
     * Sets the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @param roadClass The value which will be set
     */
    inline void setRoadClass (RoadClass roadClass_);

    // API of field "vehicleSpeed"

    static const int kVehicleSpeed = 4;

    /**
     * Clears the field "vehicleSpeed".
     *
     * The field will be set to its default value. The hasVehicleSpeed()
     * method will return false.
     */
    inline void clearVehicleSpeed();

    /**
     * Checks whether the field "vehicleSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleSpeed()). Otherwise it will return false.
     */
    inline bool hasVehicleSpeed () const;

    /**
     * Returns the value of the member "vehicleSpeed".
     *
     * If the meaning of "vehicleSpeed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vehicleSpeed"
     */
    inline float getVehicleSpeed () const;

    /**
     * Sets the value of the member "vehicleSpeed".
     *
     * If the meaning of "vehicleSpeed" isn't clear, then there should be a description here.
     *
     * @param vehicleSpeed The value which will be set
     */
    inline void setVehicleSpeed (float vehicleSpeed_);

    // API of field "vehicleHeading"

    static const int kVehicleHeading = 5;

    /**
     * Clears the field "vehicleHeading".
     *
     * The field will be set to its default value. The hasVehicleHeading()
     * method will return false.
     */
    inline void clearVehicleHeading();

    /**
     * Checks whether the field "vehicleHeading" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHeading()). Otherwise it will return false.
     */
    inline bool hasVehicleHeading () const;

    /**
     * Returns the value of the member "vehicleHeading".
     *
     * If the meaning of "vehicleHeading" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vehicleHeading"
     */
    inline float getVehicleHeading () const;

    /**
     * Sets the value of the member "vehicleHeading".
     *
     * If the meaning of "vehicleHeading" isn't clear, then there should be a description here.
     *
     * @param vehicleHeading The value which will be set
     */
    inline void setVehicleHeading (float vehicleHeading_);

    // API of field "isUniqueIdValid"

    static const int kIsUniqueIdValid = 6;

    /**
     * Clears the field "isUniqueIdValid".
     *
     * The field will be set to its default value. The hasIsUniqueIdValid()
     * method will return false.
     */
    inline void clearIsUniqueIdValid();

    /**
     * Checks whether the field "isUniqueIdValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsUniqueIdValid()). Otherwise it will return false.
     */
    inline bool hasIsUniqueIdValid () const;

    /**
     * Returns the value of the member "isUniqueIdValid".
     *
     * If the meaning of "isUniqueIdValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isUniqueIdValid"
     */
    inline bool getIsUniqueIdValid () const;

    /**
     * Sets the value of the member "isUniqueIdValid".
     *
     * If the meaning of "isUniqueIdValid" isn't clear, then there should be a description here.
     *
     * @param isUniqueIdValid The value which will be set
     */
    inline void setIsUniqueIdValid (bool isUniqueIdValid_);

    // API of field "uniqueId"

    static const int kUniqueId = 7;

    /**
     * Clears the field "uniqueId".
     *
     * The field will be set to its default value. The hasUniqueId()
     * method will return false.
     */
    inline void clearUniqueId();

    /**
     * Checks whether the field "uniqueId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUniqueId()). Otherwise it will return false.
     */
    inline bool hasUniqueId () const;

    /**
     * Returns the value of the member "uniqueId".
     *
     * If the meaning of "uniqueId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uniqueId"
     */
    inline uint32 getUniqueId () const;

    /**
     * Sets the value of the member "uniqueId".
     *
     * If the meaning of "uniqueId" isn't clear, then there should be a description here.
     *
     * @param uniqueId The value which will be set
     */
    inline void setUniqueId (uint32 uniqueId_);

    static const PositionStatusInfo &getDefaultInstance();

private:

    inline void set_has_positionWGS84 ();

    inline void clear_has_positionWGS84 ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_stateCode ();

    inline void clear_has_stateCode ();

    inline void set_has_roadClass ();

    inline void clear_has_roadClass ();

    inline void set_has_vehicleSpeed ();

    inline void clear_has_vehicleSpeed ();

    inline void set_has_vehicleHeading ();

    inline void clear_has_vehicleHeading ();

    inline void set_has_isUniqueIdValid ();

    inline void clear_has_isUniqueIdValid ();

    inline void set_has_uniqueId ();

    inline void clear_has_uniqueId ();

    uint32 _has_bits_[ (8 + 31) / 32];

    PositionWGS84 _positionWGS84;

    ::std::string _countryCode;

    ::std::string _stateCode;

    RoadClass _roadClass;

    float _vehicleSpeed;

    float _vehicleHeading;

    bool _isUniqueIdValid;

    uint32 _uniqueId;

};

/**
 * If the meaning of "DynamicMapPoiCategory" isn't clear, then there should be a description here.
 */
class DynamicMapPoiCategory {
public:

    /**
     * Default constructor
     */
    inline  DynamicMapPoiCategory ();

    /**
     * Copy constructor
     */
    inline  DynamicMapPoiCategory (const DynamicMapPoiCategory &rhs);

    /**
     * All fields constructor
     */
    inline  DynamicMapPoiCategory (const ::std::string& poiCategoryName_, uint32 poiCategoryId_, bool poiCategoryVisibilityOnMap_, const GlobalNamedObjectId& sdsNameObjectId_);

    /**
     * Destructor
     */
    inline  ~DynamicMapPoiCategory();

    /**
     * Assignment operator
     */
    inline DynamicMapPoiCategory& operator = (const DynamicMapPoiCategory& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicMapPoiCategory& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicMapPoiCategory& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicMapPoiCategory& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicMapPoiCategory& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "poiCategoryName"

    static const int kPoiCategoryName = 0;

    /**
     * Clears the field "poiCategoryName".
     *
     * The field will be set to its default value. The hasPoiCategoryName()
     * method will return false.
     */
    inline void clearPoiCategoryName();

    /**
     * Checks whether the field "poiCategoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryName()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryName () const;

    /**
     * Returns the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryName"
     */
    inline const ::std::string& getPoiCategoryName () const;

    /**
     * Retrieves the value of the field "poiCategoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiCategoryName".
     */
    inline ::std::string& getPoiCategoryNameMutable ();

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const ::std::string& poiCategoryName_);

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const char* poiCategoryName_);

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const char* value, size_t size);

    // API of field "poiCategoryId"

    static const int kPoiCategoryId = 1;

    /**
     * Clears the field "poiCategoryId".
     *
     * The field will be set to its default value. The hasPoiCategoryId()
     * method will return false.
     */
    inline void clearPoiCategoryId();

    /**
     * Checks whether the field "poiCategoryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryId()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryId () const;

    /**
     * Returns the value of the member "poiCategoryId".
     *
     * If the meaning of "poiCategoryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryId"
     */
    inline uint32 getPoiCategoryId () const;

    /**
     * Sets the value of the member "poiCategoryId".
     *
     * If the meaning of "poiCategoryId" isn't clear, then there should be a description here.
     *
     * @param poiCategoryId The value which will be set
     */
    inline void setPoiCategoryId (uint32 poiCategoryId_);

    // API of field "poiCategoryVisibilityOnMap"

    static const int kPoiCategoryVisibilityOnMap = 2;

    /**
     * Clears the field "poiCategoryVisibilityOnMap".
     *
     * The field will be set to its default value. The hasPoiCategoryVisibilityOnMap()
     * method will return false.
     */
    inline void clearPoiCategoryVisibilityOnMap();

    /**
     * Checks whether the field "poiCategoryVisibilityOnMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryVisibilityOnMap()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryVisibilityOnMap () const;

    /**
     * Returns the value of the member "poiCategoryVisibilityOnMap".
     *
     * If the meaning of "poiCategoryVisibilityOnMap" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryVisibilityOnMap"
     */
    inline bool getPoiCategoryVisibilityOnMap () const;

    /**
     * Sets the value of the member "poiCategoryVisibilityOnMap".
     *
     * If the meaning of "poiCategoryVisibilityOnMap" isn't clear, then there should be a description here.
     *
     * @param poiCategoryVisibilityOnMap The value which will be set
     */
    inline void setPoiCategoryVisibilityOnMap (bool poiCategoryVisibilityOnMap_);

    // API of field "sdsNameObjectId"

    static const int kSdsNameObjectId = 3;

    /**
     * Clears the field "sdsNameObjectId".
     *
     * The field will be set to its default value. The hasSdsNameObjectId()
     * method will return false.
     */
    inline void clearSdsNameObjectId();

    /**
     * Checks whether the field "sdsNameObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsNameObjectId()). Otherwise it will return false.
     */
    inline bool hasSdsNameObjectId () const;

    /**
     * Returns the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsNameObjectId"
     */
    inline const GlobalNamedObjectId& getSdsNameObjectId () const;

    /**
     * Retrieves the value of the field "sdsNameObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsNameObjectId".
     */
    inline GlobalNamedObjectId& getSdsNameObjectIdMutable ();

    /**
     * Sets the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @param sdsNameObjectId The value which will be set
     */
    inline void setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_);

    static const DynamicMapPoiCategory &getDefaultInstance();

private:

    inline void set_has_poiCategoryName ();

    inline void clear_has_poiCategoryName ();

    inline void set_has_poiCategoryId ();

    inline void clear_has_poiCategoryId ();

    inline void set_has_poiCategoryVisibilityOnMap ();

    inline void clear_has_poiCategoryVisibilityOnMap ();

    inline void set_has_sdsNameObjectId ();

    inline void clear_has_sdsNameObjectId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _poiCategoryName;

    uint32 _poiCategoryId;

    bool _poiCategoryVisibilityOnMap;

    GlobalNamedObjectId _sdsNameObjectId;

};

/**
 * If the meaning of "DynamicMapPoiCategoriesWithLanguage" isn't clear, then there should be a description here.
 */
class DynamicMapPoiCategoriesWithLanguage {
public:

    /**
     * Default constructor
     */
    inline  DynamicMapPoiCategoriesWithLanguage ();

    /**
     * Copy constructor
     */
    inline  DynamicMapPoiCategoriesWithLanguage (const DynamicMapPoiCategoriesWithLanguage &rhs);

    /**
     * All fields constructor
     */
    inline  DynamicMapPoiCategoriesWithLanguage (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategories_, const LanguageEntry& poiCategoriesLanguageEntry_);

    /**
     * Destructor
     */
    inline  ~DynamicMapPoiCategoriesWithLanguage();

    /**
     * Assignment operator
     */
    inline DynamicMapPoiCategoriesWithLanguage& operator = (const DynamicMapPoiCategoriesWithLanguage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicMapPoiCategoriesWithLanguage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicMapPoiCategoriesWithLanguage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicMapPoiCategoriesWithLanguage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicMapPoiCategoriesWithLanguage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dynamicMapPoiCategories"

    static const int kDynamicMapPoiCategories = 0;

    /**
     * Clears the field "dynamicMapPoiCategories".
     *
     * The field will be set to its default value. The hasDynamicMapPoiCategories()
     * method will return false.
     */
    inline void clearDynamicMapPoiCategories();

    /**
     * Checks whether the field "dynamicMapPoiCategories" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynamicMapPoiCategories()). Otherwise it will return false.
     */
    inline bool hasDynamicMapPoiCategories () const;

    /**
     * Returns the value of the member "dynamicMapPoiCategories".
     *
     * If the meaning of "dynamicMapPoiCategories" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dynamicMapPoiCategories"
     */
    inline const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategories () const;

    /**
     * Retrieves the value of the field "dynamicMapPoiCategories" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dynamicMapPoiCategories".
     */
    inline ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoriesMutable ();

    /**
     * Sets the value of the member "dynamicMapPoiCategories".
     *
     * If the meaning of "dynamicMapPoiCategories" isn't clear, then there should be a description here.
     *
     * @param dynamicMapPoiCategories The value which will be set
     */
    inline void setDynamicMapPoiCategories (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategories_);

    // API of field "poiCategoriesLanguageEntry"

    static const int kPoiCategoriesLanguageEntry = 1;

    /**
     * Clears the field "poiCategoriesLanguageEntry".
     *
     * The field will be set to its default value. The hasPoiCategoriesLanguageEntry()
     * method will return false.
     */
    inline void clearPoiCategoriesLanguageEntry();

    /**
     * Checks whether the field "poiCategoriesLanguageEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoriesLanguageEntry()). Otherwise it will return false.
     */
    inline bool hasPoiCategoriesLanguageEntry () const;

    /**
     * Returns the value of the member "poiCategoriesLanguageEntry".
     *
     * If the meaning of "poiCategoriesLanguageEntry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoriesLanguageEntry"
     */
    inline const LanguageEntry& getPoiCategoriesLanguageEntry () const;

    /**
     * Retrieves the value of the field "poiCategoriesLanguageEntry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiCategoriesLanguageEntry".
     */
    inline LanguageEntry& getPoiCategoriesLanguageEntryMutable ();

    /**
     * Sets the value of the member "poiCategoriesLanguageEntry".
     *
     * If the meaning of "poiCategoriesLanguageEntry" isn't clear, then there should be a description here.
     *
     * @param poiCategoriesLanguageEntry The value which will be set
     */
    inline void setPoiCategoriesLanguageEntry (const LanguageEntry& poiCategoriesLanguageEntry_);

    static const DynamicMapPoiCategoriesWithLanguage &getDefaultInstance();

private:

    static const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoryList_DefaultInstance ();

    inline void set_has_dynamicMapPoiCategories ();

    inline void clear_has_dynamicMapPoiCategories ();

    inline void set_has_poiCategoriesLanguageEntry ();

    inline void clear_has_poiCategoriesLanguageEntry ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< DynamicMapPoiCategory > _dynamicMapPoiCategories;

    LanguageEntry _poiCategoriesLanguageEntry;

};

/**
 * If the meaning of "AddressFormatInfo" isn't clear, then there should be a description here.
 */
class AddressFormatInfo {
public:

    /**
     * Default constructor
     */
    inline  AddressFormatInfo ();

    /**
     * Copy constructor
     */
    inline  AddressFormatInfo (const AddressFormatInfo &rhs);

    /**
     * All fields constructor
     */
    inline  AddressFormatInfo (const ::std::string& isoCountryCode_, const ::std::string& addressFormat_);

    /**
     * Destructor
     */
    inline  ~AddressFormatInfo();

    /**
     * Assignment operator
     */
    inline AddressFormatInfo& operator = (const AddressFormatInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressFormatInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressFormatInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressFormatInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressFormatInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isoCountryCode"

    static const int kIsoCountryCode = 0;

    /**
     * Clears the field "isoCountryCode".
     *
     * The field will be set to its default value. The hasIsoCountryCode()
     * method will return false.
     */
    inline void clearIsoCountryCode();

    /**
     * Checks whether the field "isoCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoCountryCode()). Otherwise it will return false.
     */
    inline bool hasIsoCountryCode () const;

    /**
     * Returns the value of the member "isoCountryCode".
     *
     * country code returned as ISO 3166-1-alpha-3
     *
     * @return The value of the field "isoCountryCode"
     */
    inline const ::std::string& getIsoCountryCode () const;

    /**
     * Retrieves the value of the field "isoCountryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "isoCountryCode".
     */
    inline ::std::string& getIsoCountryCodeMutable ();

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * country code returned as ISO 3166-1-alpha-3
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const ::std::string& isoCountryCode_);

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * country code returned as ISO 3166-1-alpha-3
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const char* isoCountryCode_);

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * country code returned as ISO 3166-1-alpha-3
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (const char* value, size_t size);

    // API of field "addressFormat"

    static const int kAddressFormat = 1;

    /**
     * Clears the field "addressFormat".
     *
     * The field will be set to its default value. The hasAddressFormat()
     * method will return false.
     */
    inline void clearAddressFormat();

    /**
     * Checks whether the field "addressFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressFormat()). Otherwise it will return false.
     */
    inline bool hasAddressFormat () const;

    /**
     * Returns the value of the member "addressFormat".
     *
     * address format returned in xml tags.
     *           eg:<ROAD/><HNR/><ZIP/><PLACE/><COUNTRY/>
     *           supported Tags:<COUNTRY/><SUBCOUNTRY/><PLACE/><CITYDISTRICT/><ZIP/><HNR/><CROSSROAD/>
     *
     * @return The value of the field "addressFormat"
     */
    inline const ::std::string& getAddressFormat () const;

    /**
     * Retrieves the value of the field "addressFormat" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressFormat".
     */
    inline ::std::string& getAddressFormatMutable ();

    /**
     * Sets the value of the member "addressFormat".
     *
     * address format returned in xml tags.
     *           eg:<ROAD/><HNR/><ZIP/><PLACE/><COUNTRY/>
     *           supported Tags:<COUNTRY/><SUBCOUNTRY/><PLACE/><CITYDISTRICT/><ZIP/><HNR/><CROSSROAD/>
     *
     * @param addressFormat The value which will be set
     */
    inline void setAddressFormat (const ::std::string& addressFormat_);

    /**
     * Sets the value of the member "addressFormat".
     *
     * address format returned in xml tags.
     *           eg:<ROAD/><HNR/><ZIP/><PLACE/><COUNTRY/>
     *           supported Tags:<COUNTRY/><SUBCOUNTRY/><PLACE/><CITYDISTRICT/><ZIP/><HNR/><CROSSROAD/>
     *
     * @param addressFormat The value which will be set
     */
    inline void setAddressFormat (const char* addressFormat_);

    /**
     * Sets the value of the member "addressFormat".
     *
     * address format returned in xml tags.
     *           eg:<ROAD/><HNR/><ZIP/><PLACE/><COUNTRY/>
     *           supported Tags:<COUNTRY/><SUBCOUNTRY/><PLACE/><CITYDISTRICT/><ZIP/><HNR/><CROSSROAD/>
     *
     * @param addressFormat The value which will be set
     */
    inline void setAddressFormat (const char* value, size_t size);

    static const AddressFormatInfo &getDefaultInstance();

private:

    inline void set_has_isoCountryCode ();

    inline void clear_has_isoCountryCode ();

    inline void set_has_addressFormat ();

    inline void clear_has_addressFormat ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _isoCountryCode;

    ::std::string _addressFormat;

};

/**
 * struct contains SharedDataAccessAttributes information
 */
class SharedDataAccessAttributes {
public:

    /**
     * Default constructor
     */
    inline  SharedDataAccessAttributes ();

    /**
     * Copy constructor
     */
    inline  SharedDataAccessAttributes (const SharedDataAccessAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  SharedDataAccessAttributes (SharedDataAccess sharedDataAccess_, JournalingMode journalingMode_, LockType lockType_);

    /**
     * Destructor
     */
    inline  ~SharedDataAccessAttributes();

    /**
     * Assignment operator
     */
    inline SharedDataAccessAttributes& operator = (const SharedDataAccessAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SharedDataAccessAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SharedDataAccessAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SharedDataAccessAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SharedDataAccessAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sharedDataAccess"

    static const int kSharedDataAccess = 0;

    /**
     * Clears the field "sharedDataAccess".
     *
     * The field will be set to its default value. The hasSharedDataAccess()
     * method will return false.
     */
    inline void clearSharedDataAccess();

    /**
     * Checks whether the field "sharedDataAccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedDataAccess()). Otherwise it will return false.
     */
    inline bool hasSharedDataAccess () const;

    /**
     * Returns the value of the member "sharedDataAccess".
     *
     * If the meaning of "sharedDataAccess" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sharedDataAccess"
     */
    inline SharedDataAccess getSharedDataAccess () const;

    /**
     * Sets the value of the member "sharedDataAccess".
     *
     * If the meaning of "sharedDataAccess" isn't clear, then there should be a description here.
     *
     * @param sharedDataAccess The value which will be set
     */
    inline void setSharedDataAccess (SharedDataAccess sharedDataAccess_);

    // API of field "journalingMode"

    static const int kJournalingMode = 1;

    /**
     * Clears the field "journalingMode".
     *
     * The field will be set to its default value. The hasJournalingMode()
     * method will return false.
     */
    inline void clearJournalingMode();

    /**
     * Checks whether the field "journalingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJournalingMode()). Otherwise it will return false.
     */
    inline bool hasJournalingMode () const;

    /**
     * Returns the value of the member "journalingMode".
     *
     * If the meaning of "journalingMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "journalingMode"
     */
    inline JournalingMode getJournalingMode () const;

    /**
     * Sets the value of the member "journalingMode".
     *
     * If the meaning of "journalingMode" isn't clear, then there should be a description here.
     *
     * @param journalingMode The value which will be set
     */
    inline void setJournalingMode (JournalingMode journalingMode_);

    // API of field "lockType"

    static const int kLockType = 2;

    /**
     * Clears the field "lockType".
     *
     * The field will be set to its default value. The hasLockType()
     * method will return false.
     */
    inline void clearLockType();

    /**
     * Checks whether the field "lockType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLockType()). Otherwise it will return false.
     */
    inline bool hasLockType () const;

    /**
     * Returns the value of the member "lockType".
     *
     * If the meaning of "lockType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "lockType"
     */
    inline LockType getLockType () const;

    /**
     * Sets the value of the member "lockType".
     *
     * If the meaning of "lockType" isn't clear, then there should be a description here.
     *
     * @param lockType The value which will be set
     */
    inline void setLockType (LockType lockType_);

    static const SharedDataAccessAttributes &getDefaultInstance();

private:

    inline void set_has_sharedDataAccess ();

    inline void clear_has_sharedDataAccess ();

    inline void set_has_journalingMode ();

    inline void clear_has_journalingMode ();

    inline void set_has_lockType ();

    inline void clear_has_lockType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    SharedDataAccess _sharedDataAccess;

    JournalingMode _journalingMode;

    LockType _lockType;

};

/**
 * struct contains NavDataSetInfo information
 */
class NavDataSetInfo {
public:

    /**
     * Default constructor
     */
    inline  NavDataSetInfo ();

    /**
     * Copy constructor
     */
    inline  NavDataSetInfo (const NavDataSetInfo &rhs);

    /**
     * All fields constructor
     */
    inline  NavDataSetInfo (uint32 datasetId_, const ::std::string& persistentDatasetId_, const SharedDataAccessAttributes& sharedDataAccessAttributes_);

    /**
     * Destructor
     */
    inline  ~NavDataSetInfo();

    /**
     * Assignment operator
     */
    inline NavDataSetInfo& operator = (const NavDataSetInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataSetInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataSetInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataSetInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataSetInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "datasetId"

    static const int kDatasetId = 0;

    /**
     * Clears the field "datasetId".
     *
     * The field will be set to its default value. The hasDatasetId()
     * method will return false.
     */
    inline void clearDatasetId();

    /**
     * Checks whether the field "datasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetId()). Otherwise it will return false.
     */
    inline bool hasDatasetId () const;

    /**
     * Returns the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "datasetId"
     */
    inline uint32 getDatasetId () const;

    /**
     * Sets the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param datasetId The value which will be set
     */
    inline void setDatasetId (uint32 datasetId_);

    // API of field "persistentDatasetId"

    static const int kPersistentDatasetId = 1;

    /**
     * Clears the field "persistentDatasetId".
     *
     * The field will be set to its default value. The hasPersistentDatasetId()
     * method will return false.
     */
    inline void clearPersistentDatasetId();

    /**
     * Checks whether the field "persistentDatasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPersistentDatasetId()). Otherwise it will return false.
     */
    inline bool hasPersistentDatasetId () const;

    /**
     * Returns the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "persistentDatasetId"
     */
    inline const ::std::string& getPersistentDatasetId () const;

    /**
     * Retrieves the value of the field "persistentDatasetId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "persistentDatasetId".
     */
    inline ::std::string& getPersistentDatasetIdMutable ();

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const ::std::string& persistentDatasetId_);

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const char* persistentDatasetId_);

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const char* value, size_t size);

    // API of field "sharedDataAccessAttributes"

    static const int kSharedDataAccessAttributes = 2;

    /**
     * Clears the field "sharedDataAccessAttributes".
     *
     * The field will be set to its default value. The hasSharedDataAccessAttributes()
     * method will return false.
     */
    inline void clearSharedDataAccessAttributes();

    /**
     * Checks whether the field "sharedDataAccessAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedDataAccessAttributes()). Otherwise it will return false.
     */
    inline bool hasSharedDataAccessAttributes () const;

    /**
     * Returns the value of the member "sharedDataAccessAttributes".
     *
     * If the meaning of "sharedDataAccessAttributes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sharedDataAccessAttributes"
     */
    inline const SharedDataAccessAttributes& getSharedDataAccessAttributes () const;

    /**
     * Retrieves the value of the field "sharedDataAccessAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sharedDataAccessAttributes".
     */
    inline SharedDataAccessAttributes& getSharedDataAccessAttributesMutable ();

    /**
     * Sets the value of the member "sharedDataAccessAttributes".
     *
     * If the meaning of "sharedDataAccessAttributes" isn't clear, then there should be a description here.
     *
     * @param sharedDataAccessAttributes The value which will be set
     */
    inline void setSharedDataAccessAttributes (const SharedDataAccessAttributes& sharedDataAccessAttributes_);

    static const NavDataSetInfo &getDefaultInstance();

private:

    inline void set_has_datasetId ();

    inline void clear_has_datasetId ();

    inline void set_has_persistentDatasetId ();

    inline void clear_has_persistentDatasetId ();

    inline void set_has_sharedDataAccessAttributes ();

    inline void clear_has_sharedDataAccessAttributes ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _datasetId;

    ::std::string _persistentDatasetId;

    SharedDataAccessAttributes _sharedDataAccessAttributes;

};

/**
 * If the meaning of "HapticData" isn't clear, then there should be a description here.
 */
class HapticData {
public:

    /**
     * Default constructor
     */
    inline  HapticData ();

    /**
     * Copy constructor
     */
    inline  HapticData (const HapticData &rhs);

    /**
     * All fields constructor
     */
    inline  HapticData (const ::std::string& Data_, const GlobalNamedObjectId& sdsNameObjectId_);

    /**
     * Destructor
     */
    inline  ~HapticData();

    /**
     * Assignment operator
     */
    inline HapticData& operator = (const HapticData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HapticData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HapticData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HapticData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HapticData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Data"

    static const int kData = 0;

    /**
     * Clears the field "Data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "Data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @param Data The value which will be set
     */
    inline void setData (const ::std::string& Data_);

    /**
     * Sets the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @param Data The value which will be set
     */
    inline void setData (const char* Data_);

    /**
     * Sets the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @param Data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "sdsNameObjectId"

    static const int kSdsNameObjectId = 1;

    /**
     * Clears the field "sdsNameObjectId".
     *
     * The field will be set to its default value. The hasSdsNameObjectId()
     * method will return false.
     */
    inline void clearSdsNameObjectId();

    /**
     * Checks whether the field "sdsNameObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsNameObjectId()). Otherwise it will return false.
     */
    inline bool hasSdsNameObjectId () const;

    /**
     * Returns the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsNameObjectId"
     */
    inline const GlobalNamedObjectId& getSdsNameObjectId () const;

    /**
     * Retrieves the value of the field "sdsNameObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsNameObjectId".
     */
    inline GlobalNamedObjectId& getSdsNameObjectIdMutable ();

    /**
     * Sets the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @param sdsNameObjectId The value which will be set
     */
    inline void setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_);

    static const HapticData &getDefaultInstance();

private:

    inline void set_has_Data ();

    inline void clear_has_Data ();

    inline void set_has_sdsNameObjectId ();

    inline void clear_has_sdsNameObjectId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Data;

    GlobalNamedObjectId _sdsNameObjectId;

};

/**
 * Method to get the SDS specific nds data
 */
class GetGlobalDataForSdsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetGlobalDataForSdsResponse ();

    /**
     * Copy constructor
     */
    inline  GetGlobalDataForSdsResponse (const GetGlobalDataForSdsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetGlobalDataForSdsResponse (const ::std::string& deviceName_, uint32 datasetId_, const ::std::string& persistentDatasetId_, const ::std::vector< SdsProducts >& sdsProductsList_, const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList_);

    /**
     * Destructor
     */
    inline virtual  ~GetGlobalDataForSdsResponse();

    /**
     * Assignment operator
     */
    inline GetGlobalDataForSdsResponse& operator = (const GetGlobalDataForSdsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetGlobalDataForSdsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetGlobalDataForSdsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetGlobalDataForSdsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetGlobalDataForSdsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceName"

    static const int kDeviceName = 0;

    /**
     * Clears the field "deviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "deviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "deviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    // API of field "datasetId"

    static const int kDatasetId = 1;

    /**
     * Clears the field "datasetId".
     *
     * The field will be set to its default value. The hasDatasetId()
     * method will return false.
     */
    inline void clearDatasetId();

    /**
     * Checks whether the field "datasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetId()). Otherwise it will return false.
     */
    inline bool hasDatasetId () const;

    /**
     * Returns the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "datasetId"
     */
    inline uint32 getDatasetId () const;

    /**
     * Sets the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param datasetId The value which will be set
     */
    inline void setDatasetId (uint32 datasetId_);

    // API of field "persistentDatasetId"

    static const int kPersistentDatasetId = 2;

    /**
     * Clears the field "persistentDatasetId".
     *
     * The field will be set to its default value. The hasPersistentDatasetId()
     * method will return false.
     */
    inline void clearPersistentDatasetId();

    /**
     * Checks whether the field "persistentDatasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPersistentDatasetId()). Otherwise it will return false.
     */
    inline bool hasPersistentDatasetId () const;

    /**
     * Returns the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "persistentDatasetId"
     */
    inline const ::std::string& getPersistentDatasetId () const;

    /**
     * Retrieves the value of the field "persistentDatasetId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "persistentDatasetId".
     */
    inline ::std::string& getPersistentDatasetIdMutable ();

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const ::std::string& persistentDatasetId_);

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const char* persistentDatasetId_);

    /**
     * Sets the value of the member "persistentDatasetId".
     *
     * If the meaning of "persistentDatasetId" isn't clear, then there should be a description here.
     *
     * @param persistentDatasetId The value which will be set
     */
    inline void setPersistentDatasetId (const char* value, size_t size);

    // API of field "sdsProductsList"

    static const int kSdsProductsList = 3;

    /**
     * Clears the field "sdsProductsList".
     *
     * The field will be set to its default value. The hasSdsProductsList()
     * method will return false.
     */
    inline void clearSdsProductsList();

    /**
     * Checks whether the field "sdsProductsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsProductsList()). Otherwise it will return false.
     */
    inline bool hasSdsProductsList () const;

    /**
     * Returns the value of the member "sdsProductsList".
     *
     * If the meaning of "sdsProductsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsProductsList"
     */
    inline const ::std::vector< SdsProducts >& getSdsProductsList () const;

    /**
     * Retrieves the value of the field "sdsProductsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsProductsList".
     */
    inline ::std::vector< SdsProducts >& getSdsProductsListMutable ();

    /**
     * Sets the value of the member "sdsProductsList".
     *
     * If the meaning of "sdsProductsList" isn't clear, then there should be a description here.
     *
     * @param sdsProductsList The value which will be set
     */
    inline void setSdsProductsList (const ::std::vector< SdsProducts >& sdsProductsList_);

    // API of field "updateRegionSpecifierRelationsList"

    static const int kUpdateRegionSpecifierRelationsList = 4;

    /**
     * Clears the field "updateRegionSpecifierRelationsList".
     *
     * The field will be set to its default value. The hasUpdateRegionSpecifierRelationsList()
     * method will return false.
     */
    inline void clearUpdateRegionSpecifierRelationsList();

    /**
     * Checks whether the field "updateRegionSpecifierRelationsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionSpecifierRelationsList()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionSpecifierRelationsList () const;

    /**
     * Returns the value of the member "updateRegionSpecifierRelationsList".
     *
     * If the meaning of "updateRegionSpecifierRelationsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionSpecifierRelationsList"
     */
    inline const ::std::vector< UpdateRegionSpecifierRelations >& getUpdateRegionSpecifierRelationsList () const;

    /**
     * Retrieves the value of the field "updateRegionSpecifierRelationsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegionSpecifierRelationsList".
     */
    inline ::std::vector< UpdateRegionSpecifierRelations >& getUpdateRegionSpecifierRelationsListMutable ();

    /**
     * Sets the value of the member "updateRegionSpecifierRelationsList".
     *
     * If the meaning of "updateRegionSpecifierRelationsList" isn't clear, then there should be a description here.
     *
     * @param updateRegionSpecifierRelationsList The value which will be set
     */
    inline void setUpdateRegionSpecifierRelationsList (const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList_);

    static const GetGlobalDataForSdsResponse &getDefaultInstance();

private:

    static const ::std::vector< SdsProducts >& getSdsProductsList_DefaultInstance ();

    static const ::std::vector< UpdateRegionSpecifierRelations >& getUpdateRegionSpecifierRelationsList_DefaultInstance ();

    inline void set_has_deviceName ();

    inline void clear_has_deviceName ();

    inline void set_has_datasetId ();

    inline void clear_has_datasetId ();

    inline void set_has_persistentDatasetId ();

    inline void clear_has_persistentDatasetId ();

    inline void set_has_sdsProductsList ();

    inline void clear_has_sdsProductsList ();

    inline void set_has_updateRegionSpecifierRelationsList ();

    inline void clear_has_updateRegionSpecifierRelationsList ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _deviceName;

    uint32 _datasetId;

    ::std::string _persistentDatasetId;

    ::std::vector< SdsProducts > _sdsProductsList;

    ::std::vector< UpdateRegionSpecifierRelations > _updateRegionSpecifierRelationsList;

};

/**
 * Method to get the list of object ids for all countries and subcountries
 */
class GetIdListOfCountryAndSubCountryResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetIdListOfCountryAndSubCountryResponse ();

    /**
     * Copy constructor
     */
    inline  GetIdListOfCountryAndSubCountryResponse (const GetIdListOfCountryAndSubCountryResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetIdListOfCountryAndSubCountryResponse (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList_, const ::std::vector< SubCountryIds >& subCountryIdList_);

    /**
     * Destructor
     */
    inline virtual  ~GetIdListOfCountryAndSubCountryResponse();

    /**
     * Assignment operator
     */
    inline GetIdListOfCountryAndSubCountryResponse& operator = (const GetIdListOfCountryAndSubCountryResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetIdListOfCountryAndSubCountryResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetIdListOfCountryAndSubCountryResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetIdListOfCountryAndSubCountryResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetIdListOfCountryAndSubCountryResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "countryIdList"

    static const int kCountryIdList = 0;

    /**
     * Clears the field "countryIdList".
     *
     * The field will be set to its default value. The hasCountryIdList()
     * method will return false.
     */
    inline void clearCountryIdList();

    /**
     * Checks whether the field "countryIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryIdList()). Otherwise it will return false.
     */
    inline bool hasCountryIdList () const;

    /**
     * Returns the value of the member "countryIdList".
     *
     * If the meaning of "countryIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryIdList"
     */
    inline const ::std::vector< GlobalNamedObjectAndRegionId >& getCountryIdList () const;

    /**
     * Retrieves the value of the field "countryIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryIdList".
     */
    inline ::std::vector< GlobalNamedObjectAndRegionId >& getCountryIdListMutable ();

    /**
     * Sets the value of the member "countryIdList".
     *
     * If the meaning of "countryIdList" isn't clear, then there should be a description here.
     *
     * @param countryIdList The value which will be set
     */
    inline void setCountryIdList (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList_);

    // API of field "subCountryIdList"

    static const int kSubCountryIdList = 1;

    /**
     * Clears the field "subCountryIdList".
     *
     * The field will be set to its default value. The hasSubCountryIdList()
     * method will return false.
     */
    inline void clearSubCountryIdList();

    /**
     * Checks whether the field "subCountryIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubCountryIdList()). Otherwise it will return false.
     */
    inline bool hasSubCountryIdList () const;

    /**
     * Returns the value of the member "subCountryIdList".
     *
     * If the meaning of "subCountryIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subCountryIdList"
     */
    inline const ::std::vector< SubCountryIds >& getSubCountryIdList () const;

    /**
     * Retrieves the value of the field "subCountryIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subCountryIdList".
     */
    inline ::std::vector< SubCountryIds >& getSubCountryIdListMutable ();

    /**
     * Sets the value of the member "subCountryIdList".
     *
     * If the meaning of "subCountryIdList" isn't clear, then there should be a description here.
     *
     * @param subCountryIdList The value which will be set
     */
    inline void setSubCountryIdList (const ::std::vector< SubCountryIds >& subCountryIdList_);

    static const GetIdListOfCountryAndSubCountryResponse &getDefaultInstance();

private:

    static const ::std::vector< GlobalNamedObjectAndRegionId >& getGlobalNamedObjectAndRegionIdList_DefaultInstance ();

    static const ::std::vector< SubCountryIds >& getSubCountryIdsList_DefaultInstance ();

    inline void set_has_countryIdList ();

    inline void clear_has_countryIdList ();

    inline void set_has_subCountryIdList ();

    inline void clear_has_subCountryIdList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< GlobalNamedObjectAndRegionId > _countryIdList;

    ::std::vector< SubCountryIds > _subCountryIdList;

};

/**
 * Method to get the named strings for given list of object ids
 */
class GetNamesForNDSIdsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNamesForNDSIdsRequest ();

    /**
     * Copy constructor
     */
    inline  GetNamesForNDSIdsRequest (const GetNamesForNDSIdsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetNamesForNDSIdsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_, const ::std::vector< LanguageEntry >& languageEntryList_, NDSFeatureType ndsFeatureType_, bool stopOnFirstMatch_);

    /**
     * Destructor
     */
    inline virtual  ~GetNamesForNDSIdsRequest();

    /**
     * Assignment operator
     */
    inline GetNamesForNDSIdsRequest& operator = (const GetNamesForNDSIdsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNamesForNDSIdsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNamesForNDSIdsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNamesForNDSIdsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNamesForNDSIdsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalNamedObjectIdList"

    static const int kGlobalNamedObjectIdList = 0;

    /**
     * Clears the field "globalNamedObjectIdList".
     *
     * The field will be set to its default value. The hasGlobalNamedObjectIdList()
     * method will return false.
     */
    inline void clearGlobalNamedObjectIdList();

    /**
     * Checks whether the field "globalNamedObjectIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalNamedObjectIdList()). Otherwise it will return false.
     */
    inline bool hasGlobalNamedObjectIdList () const;

    /**
     * Returns the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalNamedObjectIdList"
     */
    inline const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList () const;

    /**
     * Retrieves the value of the field "globalNamedObjectIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalNamedObjectIdList".
     */
    inline ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdListMutable ();

    /**
     * Sets the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @param globalNamedObjectIdList The value which will be set
     */
    inline void setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_);

    // API of field "languageEntryList"

    static const int kLanguageEntryList = 1;

    /**
     * Clears the field "languageEntryList".
     *
     * The field will be set to its default value. The hasLanguageEntryList()
     * method will return false.
     */
    inline void clearLanguageEntryList();

    /**
     * Checks whether the field "languageEntryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageEntryList()). Otherwise it will return false.
     */
    inline bool hasLanguageEntryList () const;

    /**
     * Returns the value of the member "languageEntryList".
     *
     * If the meaning of "languageEntryList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageEntryList"
     */
    inline const ::std::vector< LanguageEntry >& getLanguageEntryList () const;

    /**
     * Retrieves the value of the field "languageEntryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageEntryList".
     */
    inline ::std::vector< LanguageEntry >& getLanguageEntryListMutable ();

    /**
     * Sets the value of the member "languageEntryList".
     *
     * If the meaning of "languageEntryList" isn't clear, then there should be a description here.
     *
     * @param languageEntryList The value which will be set
     */
    inline void setLanguageEntryList (const ::std::vector< LanguageEntry >& languageEntryList_);

    // API of field "ndsFeatureType"

    static const int kNdsFeatureType = 2;

    /**
     * Clears the field "ndsFeatureType".
     *
     * The field will be set to its default value. The hasNdsFeatureType()
     * method will return false.
     */
    inline void clearNdsFeatureType();

    /**
     * Checks whether the field "ndsFeatureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsFeatureType()). Otherwise it will return false.
     */
    inline bool hasNdsFeatureType () const;

    /**
     * Returns the value of the member "ndsFeatureType".
     *
     * If the meaning of "ndsFeatureType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsFeatureType"
     */
    inline NDSFeatureType getNdsFeatureType () const;

    /**
     * Sets the value of the member "ndsFeatureType".
     *
     * If the meaning of "ndsFeatureType" isn't clear, then there should be a description here.
     *
     * @param ndsFeatureType The value which will be set
     */
    inline void setNdsFeatureType (NDSFeatureType ndsFeatureType_);

    // API of field "stopOnFirstMatch"

    static const int kStopOnFirstMatch = 3;

    /**
     * Clears the field "stopOnFirstMatch".
     *
     * The field will be set to its default value. The hasStopOnFirstMatch()
     * method will return false.
     */
    inline void clearStopOnFirstMatch();

    /**
     * Checks whether the field "stopOnFirstMatch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStopOnFirstMatch()). Otherwise it will return false.
     */
    inline bool hasStopOnFirstMatch () const;

    /**
     * Returns the value of the member "stopOnFirstMatch".
     *
     * If the meaning of "stopOnFirstMatch" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stopOnFirstMatch"
     */
    inline bool getStopOnFirstMatch () const;

    /**
     * Sets the value of the member "stopOnFirstMatch".
     *
     * If the meaning of "stopOnFirstMatch" isn't clear, then there should be a description here.
     *
     * @param stopOnFirstMatch The value which will be set
     */
    inline void setStopOnFirstMatch (bool stopOnFirstMatch_);

    static const GetNamesForNDSIdsRequest &getDefaultInstance();

private:

    static const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList_DefaultInstance ();

    static const ::std::vector< LanguageEntry >& getLanguageEntryList_DefaultInstance ();

    inline void set_has_globalNamedObjectIdList ();

    inline void clear_has_globalNamedObjectIdList ();

    inline void set_has_languageEntryList ();

    inline void clear_has_languageEntryList ();

    inline void set_has_ndsFeatureType ();

    inline void clear_has_ndsFeatureType ();

    inline void set_has_stopOnFirstMatch ();

    inline void clear_has_stopOnFirstMatch ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::vector< GlobalNamedObjectId > _globalNamedObjectIdList;

    ::std::vector< LanguageEntry > _languageEntryList;

    NDSFeatureType _ndsFeatureType;

    bool _stopOnFirstMatch;

};

/**
 * Method to get the named strings for given list of object ids
 */
class GetNamesForNDSIdsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNamesForNDSIdsResponse ();

    /**
     * Copy constructor
     */
    inline  GetNamesForNDSIdsResponse (const GetNamesForNDSIdsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNamesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_);

    /**
     * Destructor
     */
    inline virtual  ~GetNamesForNDSIdsResponse();

    /**
     * Assignment operator
     */
    inline GetNamesForNDSIdsResponse& operator = (const GetNamesForNDSIdsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNamesForNDSIdsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNamesForNDSIdsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNamesForNDSIdsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNamesForNDSIdsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "namedObjectIdStringsList"

    static const int kNamedObjectIdStringsList = 0;

    /**
     * Clears the field "namedObjectIdStringsList".
     *
     * The field will be set to its default value. The hasNamedObjectIdStringsList()
     * method will return false.
     */
    inline void clearNamedObjectIdStringsList();

    /**
     * Checks whether the field "namedObjectIdStringsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNamedObjectIdStringsList()). Otherwise it will return false.
     */
    inline bool hasNamedObjectIdStringsList () const;

    /**
     * Returns the value of the member "namedObjectIdStringsList".
     *
     * If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "namedObjectIdStringsList"
     */
    inline const ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsList () const;

    /**
     * Retrieves the value of the field "namedObjectIdStringsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "namedObjectIdStringsList".
     */
    inline ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsListMutable ();

    /**
     * Sets the value of the member "namedObjectIdStringsList".
     *
     * If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @param namedObjectIdStringsList The value which will be set
     */
    inline void setNamedObjectIdStringsList (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_);

    static const GetNamesForNDSIdsResponse &getDefaultInstance();

private:

    static const ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsList_DefaultInstance ();

    inline void set_has_namedObjectIdStringsList ();

    inline void clear_has_namedObjectIdStringsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< NamedObjectIdStrings > _namedObjectIdStringsList;

};

/**
 * Method to get the phonemes for given list of object ids
 */
class GetPhonemesForNDSIdsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPhonemesForNDSIdsRequest ();

    /**
     * Copy constructor
     */
    inline  GetPhonemesForNDSIdsRequest (const GetPhonemesForNDSIdsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetPhonemesForNDSIdsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_, const ::std::vector< LanguageEntry >& languageEntryList_, NDSFeatureType ndsFeatureType_, bool stopOnFirstMatch_);

    /**
     * Destructor
     */
    inline virtual  ~GetPhonemesForNDSIdsRequest();

    /**
     * Assignment operator
     */
    inline GetPhonemesForNDSIdsRequest& operator = (const GetPhonemesForNDSIdsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhonemesForNDSIdsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhonemesForNDSIdsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhonemesForNDSIdsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhonemesForNDSIdsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalNamedObjectIdList"

    static const int kGlobalNamedObjectIdList = 0;

    /**
     * Clears the field "globalNamedObjectIdList".
     *
     * The field will be set to its default value. The hasGlobalNamedObjectIdList()
     * method will return false.
     */
    inline void clearGlobalNamedObjectIdList();

    /**
     * Checks whether the field "globalNamedObjectIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalNamedObjectIdList()). Otherwise it will return false.
     */
    inline bool hasGlobalNamedObjectIdList () const;

    /**
     * Returns the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalNamedObjectIdList"
     */
    inline const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList () const;

    /**
     * Retrieves the value of the field "globalNamedObjectIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalNamedObjectIdList".
     */
    inline ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdListMutable ();

    /**
     * Sets the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @param globalNamedObjectIdList The value which will be set
     */
    inline void setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_);

    // API of field "languageEntryList"

    static const int kLanguageEntryList = 1;

    /**
     * Clears the field "languageEntryList".
     *
     * The field will be set to its default value. The hasLanguageEntryList()
     * method will return false.
     */
    inline void clearLanguageEntryList();

    /**
     * Checks whether the field "languageEntryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageEntryList()). Otherwise it will return false.
     */
    inline bool hasLanguageEntryList () const;

    /**
     * Returns the value of the member "languageEntryList".
     *
     * If the meaning of "languageEntryList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageEntryList"
     */
    inline const ::std::vector< LanguageEntry >& getLanguageEntryList () const;

    /**
     * Retrieves the value of the field "languageEntryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "languageEntryList".
     */
    inline ::std::vector< LanguageEntry >& getLanguageEntryListMutable ();

    /**
     * Sets the value of the member "languageEntryList".
     *
     * If the meaning of "languageEntryList" isn't clear, then there should be a description here.
     *
     * @param languageEntryList The value which will be set
     */
    inline void setLanguageEntryList (const ::std::vector< LanguageEntry >& languageEntryList_);

    // API of field "ndsFeatureType"

    static const int kNdsFeatureType = 2;

    /**
     * Clears the field "ndsFeatureType".
     *
     * The field will be set to its default value. The hasNdsFeatureType()
     * method will return false.
     */
    inline void clearNdsFeatureType();

    /**
     * Checks whether the field "ndsFeatureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsFeatureType()). Otherwise it will return false.
     */
    inline bool hasNdsFeatureType () const;

    /**
     * Returns the value of the member "ndsFeatureType".
     *
     * If the meaning of "ndsFeatureType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsFeatureType"
     */
    inline NDSFeatureType getNdsFeatureType () const;

    /**
     * Sets the value of the member "ndsFeatureType".
     *
     * If the meaning of "ndsFeatureType" isn't clear, then there should be a description here.
     *
     * @param ndsFeatureType The value which will be set
     */
    inline void setNdsFeatureType (NDSFeatureType ndsFeatureType_);

    // API of field "stopOnFirstMatch"

    static const int kStopOnFirstMatch = 3;

    /**
     * Clears the field "stopOnFirstMatch".
     *
     * The field will be set to its default value. The hasStopOnFirstMatch()
     * method will return false.
     */
    inline void clearStopOnFirstMatch();

    /**
     * Checks whether the field "stopOnFirstMatch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStopOnFirstMatch()). Otherwise it will return false.
     */
    inline bool hasStopOnFirstMatch () const;

    /**
     * Returns the value of the member "stopOnFirstMatch".
     *
     * If the meaning of "stopOnFirstMatch" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stopOnFirstMatch"
     */
    inline bool getStopOnFirstMatch () const;

    /**
     * Sets the value of the member "stopOnFirstMatch".
     *
     * If the meaning of "stopOnFirstMatch" isn't clear, then there should be a description here.
     *
     * @param stopOnFirstMatch The value which will be set
     */
    inline void setStopOnFirstMatch (bool stopOnFirstMatch_);

    static const GetPhonemesForNDSIdsRequest &getDefaultInstance();

private:

    static const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList_DefaultInstance ();

    static const ::std::vector< LanguageEntry >& getLanguageEntryList_DefaultInstance ();

    inline void set_has_globalNamedObjectIdList ();

    inline void clear_has_globalNamedObjectIdList ();

    inline void set_has_languageEntryList ();

    inline void clear_has_languageEntryList ();

    inline void set_has_ndsFeatureType ();

    inline void clear_has_ndsFeatureType ();

    inline void set_has_stopOnFirstMatch ();

    inline void clear_has_stopOnFirstMatch ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::vector< GlobalNamedObjectId > _globalNamedObjectIdList;

    ::std::vector< LanguageEntry > _languageEntryList;

    NDSFeatureType _ndsFeatureType;

    bool _stopOnFirstMatch;

};

/**
 * Method to get the phonemes for given list of object ids
 */
class GetPhonemesForNDSIdsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPhonemesForNDSIdsResponse ();

    /**
     * Copy constructor
     */
    inline  GetPhonemesForNDSIdsResponse (const GetPhonemesForNDSIdsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPhonemesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_);

    /**
     * Destructor
     */
    inline virtual  ~GetPhonemesForNDSIdsResponse();

    /**
     * Assignment operator
     */
    inline GetPhonemesForNDSIdsResponse& operator = (const GetPhonemesForNDSIdsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhonemesForNDSIdsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhonemesForNDSIdsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhonemesForNDSIdsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhonemesForNDSIdsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "namedObjectIdStringsList"

    static const int kNamedObjectIdStringsList = 0;

    /**
     * Clears the field "namedObjectIdStringsList".
     *
     * The field will be set to its default value. The hasNamedObjectIdStringsList()
     * method will return false.
     */
    inline void clearNamedObjectIdStringsList();

    /**
     * Checks whether the field "namedObjectIdStringsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNamedObjectIdStringsList()). Otherwise it will return false.
     */
    inline bool hasNamedObjectIdStringsList () const;

    /**
     * Returns the value of the member "namedObjectIdStringsList".
     *
     * If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "namedObjectIdStringsList"
     */
    inline const ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsList () const;

    /**
     * Retrieves the value of the field "namedObjectIdStringsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "namedObjectIdStringsList".
     */
    inline ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsListMutable ();

    /**
     * Sets the value of the member "namedObjectIdStringsList".
     *
     * If the meaning of "namedObjectIdStringsList" isn't clear, then there should be a description here.
     *
     * @param namedObjectIdStringsList The value which will be set
     */
    inline void setNamedObjectIdStringsList (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_);

    static const GetPhonemesForNDSIdsResponse &getDefaultInstance();

private:

    static const ::std::vector< NamedObjectIdStrings >& getNamedObjectIdStringsList_DefaultInstance ();

    inline void set_has_namedObjectIdStringsList ();

    inline void clear_has_namedObjectIdStringsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< NamedObjectIdStrings > _namedObjectIdStringsList;

};

/**
 * Method to get the availability of streets for the given list of city NDS ids
 */
class GetCityHasStreetsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCityHasStreetsRequest ();

    /**
     * Copy constructor
     */
    inline  GetCityHasStreetsRequest (const GetCityHasStreetsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetCityHasStreetsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_);

    /**
     * Destructor
     */
    inline virtual  ~GetCityHasStreetsRequest();

    /**
     * Assignment operator
     */
    inline GetCityHasStreetsRequest& operator = (const GetCityHasStreetsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCityHasStreetsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCityHasStreetsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCityHasStreetsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCityHasStreetsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalNamedObjectIdList"

    static const int kGlobalNamedObjectIdList = 0;

    /**
     * Clears the field "globalNamedObjectIdList".
     *
     * The field will be set to its default value. The hasGlobalNamedObjectIdList()
     * method will return false.
     */
    inline void clearGlobalNamedObjectIdList();

    /**
     * Checks whether the field "globalNamedObjectIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalNamedObjectIdList()). Otherwise it will return false.
     */
    inline bool hasGlobalNamedObjectIdList () const;

    /**
     * Returns the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalNamedObjectIdList"
     */
    inline const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList () const;

    /**
     * Retrieves the value of the field "globalNamedObjectIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalNamedObjectIdList".
     */
    inline ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdListMutable ();

    /**
     * Sets the value of the member "globalNamedObjectIdList".
     *
     * If the meaning of "globalNamedObjectIdList" isn't clear, then there should be a description here.
     *
     * @param globalNamedObjectIdList The value which will be set
     */
    inline void setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_);

    static const GetCityHasStreetsRequest &getDefaultInstance();

private:

    static const ::std::vector< GlobalNamedObjectId >& getGlobalNamedObjectIdList_DefaultInstance ();

    inline void set_has_globalNamedObjectIdList ();

    inline void clear_has_globalNamedObjectIdList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GlobalNamedObjectId > _globalNamedObjectIdList;

};

/**
 * Method to get the availability of streets for the given list of city NDS ids
 */
class GetCityHasStreetsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCityHasStreetsResponse ();

    /**
     * Copy constructor
     */
    inline  GetCityHasStreetsResponse (const GetCityHasStreetsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetCityHasStreetsResponse (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList_);

    /**
     * Destructor
     */
    inline virtual  ~GetCityHasStreetsResponse();

    /**
     * Assignment operator
     */
    inline GetCityHasStreetsResponse& operator = (const GetCityHasStreetsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCityHasStreetsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCityHasStreetsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCityHasStreetsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCityHasStreetsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cityNamedObjectIdHasStreetsList"

    static const int kCityNamedObjectIdHasStreetsList = 0;

    /**
     * Clears the field "cityNamedObjectIdHasStreetsList".
     *
     * The field will be set to its default value. The hasCityNamedObjectIdHasStreetsList()
     * method will return false.
     */
    inline void clearCityNamedObjectIdHasStreetsList();

    /**
     * Checks whether the field "cityNamedObjectIdHasStreetsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityNamedObjectIdHasStreetsList()). Otherwise it will return false.
     */
    inline bool hasCityNamedObjectIdHasStreetsList () const;

    /**
     * Returns the value of the member "cityNamedObjectIdHasStreetsList".
     *
     * If the meaning of "cityNamedObjectIdHasStreetsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityNamedObjectIdHasStreetsList"
     */
    inline const ::std::vector< CityNamedObjectIdHasStreets >& getCityNamedObjectIdHasStreetsList () const;

    /**
     * Retrieves the value of the field "cityNamedObjectIdHasStreetsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityNamedObjectIdHasStreetsList".
     */
    inline ::std::vector< CityNamedObjectIdHasStreets >& getCityNamedObjectIdHasStreetsListMutable ();

    /**
     * Sets the value of the member "cityNamedObjectIdHasStreetsList".
     *
     * If the meaning of "cityNamedObjectIdHasStreetsList" isn't clear, then there should be a description here.
     *
     * @param cityNamedObjectIdHasStreetsList The value which will be set
     */
    inline void setCityNamedObjectIdHasStreetsList (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList_);

    static const GetCityHasStreetsResponse &getDefaultInstance();

private:

    static const ::std::vector< CityNamedObjectIdHasStreets >& getCityNamedObjectIdHasStreetsList_DefaultInstance ();

    inline void set_has_cityNamedObjectIdHasStreetsList ();

    inline void clear_has_cityNamedObjectIdHasStreetsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CityNamedObjectIdHasStreets > _cityNamedObjectIdHasStreetsList;

};

/**
 * Request will get handover screen and data along with location type and address options.
 */
class GetHapticHandOverDataResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetHapticHandOverDataResponse ();

    /**
     * Copy constructor
     */
    inline  GetHapticHandOverDataResponse (const GetHapticHandOverDataResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetHapticHandOverDataResponse (SDSHandOverScreenId sdsHandOverScreenId_, const ::std::vector< HapticData >& dataList_, const ::std::vector< SelectedDataItem >& selectedDataListItems_, LocationType locationType_, const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList_, const ::std::vector< AddressListElement >& searchResults_);

    /**
     * Destructor
     */
    inline virtual  ~GetHapticHandOverDataResponse();

    /**
     * Assignment operator
     */
    inline GetHapticHandOverDataResponse& operator = (const GetHapticHandOverDataResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetHapticHandOverDataResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetHapticHandOverDataResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetHapticHandOverDataResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetHapticHandOverDataResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsHandOverScreenId"

    static const int kSdsHandOverScreenId = 0;

    /**
     * Clears the field "sdsHandOverScreenId".
     *
     * The field will be set to its default value. The hasSdsHandOverScreenId()
     * method will return false.
     */
    inline void clearSdsHandOverScreenId();

    /**
     * Checks whether the field "sdsHandOverScreenId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsHandOverScreenId()). Otherwise it will return false.
     */
    inline bool hasSdsHandOverScreenId () const;

    /**
     * Returns the value of the member "sdsHandOverScreenId".
     *
     * If the meaning of "sdsHandOverScreenId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsHandOverScreenId"
     */
    inline SDSHandOverScreenId getSdsHandOverScreenId () const;

    /**
     * Sets the value of the member "sdsHandOverScreenId".
     *
     * If the meaning of "sdsHandOverScreenId" isn't clear, then there should be a description here.
     *
     * @param sdsHandOverScreenId The value which will be set
     */
    inline void setSdsHandOverScreenId (SDSHandOverScreenId sdsHandOverScreenId_);

    // API of field "dataList"

    static const int kDataList = 1;

    /**
     * Clears the field "dataList".
     *
     * The field will be set to its default value. The hasDataList()
     * method will return false.
     */
    inline void clearDataList();

    /**
     * Checks whether the field "dataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataList()). Otherwise it will return false.
     */
    inline bool hasDataList () const;

    /**
     * Returns the value of the member "dataList".
     *
     * If the meaning of "dataList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dataList"
     */
    inline const ::std::vector< HapticData >& getDataList () const;

    /**
     * Retrieves the value of the field "dataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dataList".
     */
    inline ::std::vector< HapticData >& getDataListMutable ();

    /**
     * Sets the value of the member "dataList".
     *
     * If the meaning of "dataList" isn't clear, then there should be a description here.
     *
     * @param dataList The value which will be set
     */
    inline void setDataList (const ::std::vector< HapticData >& dataList_);

    // API of field "selectedDataListItems"

    static const int kSelectedDataListItems = 2;

    /**
     * Clears the field "selectedDataListItems".
     *
     * The field will be set to its default value. The hasSelectedDataListItems()
     * method will return false.
     */
    inline void clearSelectedDataListItems();

    /**
     * Checks whether the field "selectedDataListItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectedDataListItems()). Otherwise it will return false.
     */
    inline bool hasSelectedDataListItems () const;

    /**
     * Returns the value of the member "selectedDataListItems".
     *
     * If the meaning of "selectedDataListItems" isn't clear, then there should be a description here.
     *
     * @return The value of the field "selectedDataListItems"
     */
    inline const ::std::vector< SelectedDataItem >& getSelectedDataListItems () const;

    /**
     * Retrieves the value of the field "selectedDataListItems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "selectedDataListItems".
     */
    inline ::std::vector< SelectedDataItem >& getSelectedDataListItemsMutable ();

    /**
     * Sets the value of the member "selectedDataListItems".
     *
     * If the meaning of "selectedDataListItems" isn't clear, then there should be a description here.
     *
     * @param selectedDataListItems The value which will be set
     */
    inline void setSelectedDataListItems (const ::std::vector< SelectedDataItem >& selectedDataListItems_);

    // API of field "locationType"

    static const int kLocationType = 3;

    /**
     * Clears the field "locationType".
     *
     * The field will be set to its default value. The hasLocationType()
     * method will return false.
     */
    inline void clearLocationType();

    /**
     * Checks whether the field "locationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationType()). Otherwise it will return false.
     */
    inline bool hasLocationType () const;

    /**
     * Returns the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationType"
     */
    inline LocationType getLocationType () const;

    /**
     * Sets the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @param locationType The value which will be set
     */
    inline void setLocationType (LocationType locationType_);

    // API of field "sdsHandOverOptionsList"

    static const int kSdsHandOverOptionsList = 4;

    /**
     * Clears the field "sdsHandOverOptionsList".
     *
     * The field will be set to its default value. The hasSdsHandOverOptionsList()
     * method will return false.
     */
    inline void clearSdsHandOverOptionsList();

    /**
     * Checks whether the field "sdsHandOverOptionsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsHandOverOptionsList()). Otherwise it will return false.
     */
    inline bool hasSdsHandOverOptionsList () const;

    /**
     * Returns the value of the member "sdsHandOverOptionsList".
     *
     * If the meaning of "sdsHandOverOptionsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsHandOverOptionsList"
     */
    inline const ::std::vector< SDSHandOverOptions >& getSdsHandOverOptionsList () const;

    /**
     * Retrieves the value of the field "sdsHandOverOptionsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsHandOverOptionsList".
     */
    inline ::std::vector< SDSHandOverOptions >& getSdsHandOverOptionsListMutable ();

    /**
     * Sets the value of the member "sdsHandOverOptionsList".
     *
     * If the meaning of "sdsHandOverOptionsList" isn't clear, then there should be a description here.
     *
     * @param sdsHandOverOptionsList The value which will be set
     */
    inline void setSdsHandOverOptionsList (const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList_);

    // API of field "searchResults"

    static const int kSearchResults = 5;

    /**
     * Clears the field "searchResults".
     *
     * The field will be set to its default value. The hasSearchResults()
     * method will return false.
     */
    inline void clearSearchResults();

    /**
     * Checks whether the field "searchResults" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchResults()). Otherwise it will return false.
     */
    inline bool hasSearchResults () const;

    /**
     * Returns the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchResults"
     */
    inline const ::std::vector< AddressListElement >& getSearchResults () const;

    /**
     * Retrieves the value of the field "searchResults" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchResults".
     */
    inline ::std::vector< AddressListElement >& getSearchResultsMutable ();

    /**
     * Sets the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param searchResults The value which will be set
     */
    inline void setSearchResults (const ::std::vector< AddressListElement >& searchResults_);

    static const GetHapticHandOverDataResponse &getDefaultInstance();

private:

    static const ::std::vector< HapticData >& getHapticDataList_DefaultInstance ();

    static const ::std::vector< SelectedDataItem >& getSelectedDataItemList_DefaultInstance ();

    static const ::std::vector< SDSHandOverOptions >& getSDSHandOverOptionsList_DefaultInstance ();

    static const ::std::vector< AddressListElement >& getAddressListElementList_DefaultInstance ();

    inline void set_has_sdsHandOverScreenId ();

    inline void clear_has_sdsHandOverScreenId ();

    inline void set_has_dataList ();

    inline void clear_has_dataList ();

    inline void set_has_selectedDataListItems ();

    inline void clear_has_selectedDataListItems ();

    inline void set_has_locationType ();

    inline void clear_has_locationType ();

    inline void set_has_sdsHandOverOptionsList ();

    inline void clear_has_sdsHandOverOptionsList ();

    inline void set_has_searchResults ();

    inline void clear_has_searchResults ();

    uint32 _has_bits_[ (6 + 31) / 32];

    SDSHandOverScreenId _sdsHandOverScreenId;

    ::std::vector< HapticData > _dataList;

    ::std::vector< SelectedDataItem > _selectedDataListItems;

    LocationType _locationType;

    ::std::vector< SDSHandOverOptions > _sdsHandOverOptionsList;

    ::std::vector< AddressListElement > _searchResults;

};

/**
 * Request will send the selected index from the HMI list.
 */
class SelectHapticHandOverListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectHapticHandOverListRequest ();

    /**
     * Copy constructor
     */
    inline  SelectHapticHandOverListRequest (const SelectHapticHandOverListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectHapticHandOverListRequest (uint32 index_);

    /**
     * Destructor
     */
    inline virtual  ~SelectHapticHandOverListRequest();

    /**
     * Assignment operator
     */
    inline SelectHapticHandOverListRequest& operator = (const SelectHapticHandOverListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectHapticHandOverListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectHapticHandOverListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectHapticHandOverListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectHapticHandOverListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    static const SelectHapticHandOverListRequest &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _index;

};

/**
 * Returns the currently available POI icon categories in map
 */
class GetDynamicPoiIconCategoriesInMapResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDynamicPoiIconCategoriesInMapResponse ();

    /**
     * Copy constructor
     */
    inline  GetDynamicPoiIconCategoriesInMapResponse (const GetDynamicPoiIconCategoriesInMapResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetDynamicPoiIconCategoriesInMapResponse (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_);

    /**
     * Destructor
     */
    inline virtual  ~GetDynamicPoiIconCategoriesInMapResponse();

    /**
     * Assignment operator
     */
    inline GetDynamicPoiIconCategoriesInMapResponse& operator = (const GetDynamicPoiIconCategoriesInMapResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dynamicMapPoiCategory"

    static const int kDynamicMapPoiCategory = 0;

    /**
     * Clears the field "dynamicMapPoiCategory".
     *
     * The field will be set to its default value. The hasDynamicMapPoiCategory()
     * method will return false.
     */
    inline void clearDynamicMapPoiCategory();

    /**
     * Checks whether the field "dynamicMapPoiCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynamicMapPoiCategory()). Otherwise it will return false.
     */
    inline bool hasDynamicMapPoiCategory () const;

    /**
     * Returns the value of the member "dynamicMapPoiCategory".
     *
     * If the meaning of "dynamicMapPoiCategory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dynamicMapPoiCategory"
     */
    inline const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategory () const;

    /**
     * Retrieves the value of the field "dynamicMapPoiCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dynamicMapPoiCategory".
     */
    inline ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoryMutable ();

    /**
     * Sets the value of the member "dynamicMapPoiCategory".
     *
     * If the meaning of "dynamicMapPoiCategory" isn't clear, then there should be a description here.
     *
     * @param dynamicMapPoiCategory The value which will be set
     */
    inline void setDynamicMapPoiCategory (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_);

    static const GetDynamicPoiIconCategoriesInMapResponse &getDefaultInstance();

private:

    static const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoryList_DefaultInstance ();

    inline void set_has_dynamicMapPoiCategory ();

    inline void clear_has_dynamicMapPoiCategory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DynamicMapPoiCategory > _dynamicMapPoiCategory;

};

/**
 * Returns max number of waypoint base on project variant
 */
class GetMaxWaypointCountResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMaxWaypointCountResponse ();

    /**
     * Copy constructor
     */
    inline  GetMaxWaypointCountResponse (const GetMaxWaypointCountResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetMaxWaypointCountResponse (uint32 maxWayPointCount_);

    /**
     * Destructor
     */
    inline virtual  ~GetMaxWaypointCountResponse();

    /**
     * Assignment operator
     */
    inline GetMaxWaypointCountResponse& operator = (const GetMaxWaypointCountResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMaxWaypointCountResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMaxWaypointCountResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMaxWaypointCountResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMaxWaypointCountResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maxWayPointCount"

    static const int kMaxWayPointCount = 0;

    /**
     * Clears the field "maxWayPointCount".
     *
     * The field will be set to its default value. The hasMaxWayPointCount()
     * method will return false.
     */
    inline void clearMaxWayPointCount();

    /**
     * Checks whether the field "maxWayPointCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxWayPointCount()). Otherwise it will return false.
     */
    inline bool hasMaxWayPointCount () const;

    /**
     * Returns the value of the member "maxWayPointCount".
     *
     * If the meaning of "maxWayPointCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maxWayPointCount"
     */
    inline uint32 getMaxWayPointCount () const;

    /**
     * Sets the value of the member "maxWayPointCount".
     *
     * If the meaning of "maxWayPointCount" isn't clear, then there should be a description here.
     *
     * @param maxWayPointCount The value which will be set
     */
    inline void setMaxWayPointCount (uint32 maxWayPointCount_);

    static const GetMaxWaypointCountResponse &getDefaultInstance();

private:

    inline void set_has_maxWayPointCount ();

    inline void clear_has_maxWayPointCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _maxWayPointCount;

};

/**
 * Request to show POI icons on map.
 */
class SetDynamicPoiIconCategoriesInMapRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDynamicPoiIconCategoriesInMapRequest ();

    /**
     * Copy constructor
     */
    inline  SetDynamicPoiIconCategoriesInMapRequest (const SetDynamicPoiIconCategoriesInMapRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetDynamicPoiIconCategoriesInMapRequest (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_);

    /**
     * Destructor
     */
    inline virtual  ~SetDynamicPoiIconCategoriesInMapRequest();

    /**
     * Assignment operator
     */
    inline SetDynamicPoiIconCategoriesInMapRequest& operator = (const SetDynamicPoiIconCategoriesInMapRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dynamicMapPoiCategory"

    static const int kDynamicMapPoiCategory = 0;

    /**
     * Clears the field "dynamicMapPoiCategory".
     *
     * The field will be set to its default value. The hasDynamicMapPoiCategory()
     * method will return false.
     */
    inline void clearDynamicMapPoiCategory();

    /**
     * Checks whether the field "dynamicMapPoiCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynamicMapPoiCategory()). Otherwise it will return false.
     */
    inline bool hasDynamicMapPoiCategory () const;

    /**
     * Returns the value of the member "dynamicMapPoiCategory".
     *
     * If the meaning of "dynamicMapPoiCategory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dynamicMapPoiCategory"
     */
    inline const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategory () const;

    /**
     * Retrieves the value of the field "dynamicMapPoiCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dynamicMapPoiCategory".
     */
    inline ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoryMutable ();

    /**
     * Sets the value of the member "dynamicMapPoiCategory".
     *
     * If the meaning of "dynamicMapPoiCategory" isn't clear, then there should be a description here.
     *
     * @param dynamicMapPoiCategory The value which will be set
     */
    inline void setDynamicMapPoiCategory (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_);

    static const SetDynamicPoiIconCategoriesInMapRequest &getDefaultInstance();

private:

    static const ::std::vector< DynamicMapPoiCategory >& getDynamicMapPoiCategoryList_DefaultInstance ();

    inline void set_has_dynamicMapPoiCategory ();

    inline void clear_has_dynamicMapPoiCategory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DynamicMapPoiCategory > _dynamicMapPoiCategory;

};

/**
 * Request will validate the given address,
 *        as result it update the attribute sdsAddressWithOptions
 */
class SdsCheckAddressRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsCheckAddressRequest ();

    /**
     * Copy constructor
     */
    inline  SdsCheckAddressRequest (const SdsCheckAddressRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsCheckAddressRequest (const ::std::vector< SDSAddressElement >& requestedAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SdsCheckAddressRequest();

    /**
     * Assignment operator
     */
    inline SdsCheckAddressRequest& operator = (const SdsCheckAddressRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsCheckAddressRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsCheckAddressRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsCheckAddressRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsCheckAddressRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "requestedAddress"

    static const int kRequestedAddress = 0;

    /**
     * Clears the field "requestedAddress".
     *
     * The field will be set to its default value. The hasRequestedAddress()
     * method will return false.
     */
    inline void clearRequestedAddress();

    /**
     * Checks whether the field "requestedAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestedAddress()). Otherwise it will return false.
     */
    inline bool hasRequestedAddress () const;

    /**
     * Returns the value of the member "requestedAddress".
     *
     * If the meaning of "requestedAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "requestedAddress"
     */
    inline const ::std::vector< SDSAddressElement >& getRequestedAddress () const;

    /**
     * Retrieves the value of the field "requestedAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestedAddress".
     */
    inline ::std::vector< SDSAddressElement >& getRequestedAddressMutable ();

    /**
     * Sets the value of the member "requestedAddress".
     *
     * If the meaning of "requestedAddress" isn't clear, then there should be a description here.
     *
     * @param requestedAddress The value which will be set
     */
    inline void setRequestedAddress (const ::std::vector< SDSAddressElement >& requestedAddress_);

    static const SdsCheckAddressRequest &getDefaultInstance();

private:

    static const ::std::vector< SDSAddressElement >& getSDSAddressElementList_DefaultInstance ();

    inline void set_has_requestedAddress ();

    inline void clear_has_requestedAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SDSAddressElement > _requestedAddress;

};

/**
 * Request will get refinement list for the validated address
 */
class SdsGetRefinementListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsGetRefinementListResponse ();

    /**
     * Copy constructor
     */
    inline  SdsGetRefinementListResponse (const SdsGetRefinementListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements_);

    /**
     * Destructor
     */
    inline virtual  ~SdsGetRefinementListResponse();

    /**
     * Assignment operator
     */
    inline SdsGetRefinementListResponse& operator = (const SdsGetRefinementListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "refinements"

    static const int kRefinements = 0;

    /**
     * Clears the field "refinements".
     *
     * The field will be set to its default value. The hasRefinements()
     * method will return false.
     */
    inline void clearRefinements();

    /**
     * Checks whether the field "refinements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefinements()). Otherwise it will return false.
     */
    inline bool hasRefinements () const;

    /**
     * Returns the value of the member "refinements".
     *
     * If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @return The value of the field "refinements"
     */
    inline const ::std::vector< RefinementListElement >& getRefinements () const;

    /**
     * Retrieves the value of the field "refinements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "refinements".
     */
    inline ::std::vector< RefinementListElement >& getRefinementsMutable ();

    /**
     * Sets the value of the member "refinements".
     *
     * If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @param refinements The value which will be set
     */
    inline void setRefinements (const ::std::vector< RefinementListElement >& refinements_);

    static const SdsGetRefinementListResponse &getDefaultInstance();

private:

    static const ::std::vector< RefinementListElement >& getRefinementListElementList_DefaultInstance ();

    inline void set_has_refinements ();

    inline void clear_has_refinements ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< RefinementListElement > _refinements;

};

/**
 * Method used to store/delete the VoiceTagId in the destination memory database
 */
class SdsUpdateVoiceTagRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsUpdateVoiceTagRequest ();

    /**
     * Copy constructor
     */
    inline  SdsUpdateVoiceTagRequest (const SdsUpdateVoiceTagRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsUpdateVoiceTagRequest (const SDSVoiceTagId& voiceTagID_);

    /**
     * Destructor
     */
    inline virtual  ~SdsUpdateVoiceTagRequest();

    /**
     * Assignment operator
     */
    inline SdsUpdateVoiceTagRequest& operator = (const SdsUpdateVoiceTagRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "voiceTagID"

    static const int kVoiceTagID = 0;

    /**
     * Clears the field "voiceTagID".
     *
     * The field will be set to its default value. The hasVoiceTagID()
     * method will return false.
     */
    inline void clearVoiceTagID();

    /**
     * Checks whether the field "voiceTagID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceTagID()). Otherwise it will return false.
     */
    inline bool hasVoiceTagID () const;

    /**
     * Returns the value of the member "voiceTagID".
     *
     * If the meaning of "voiceTagID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "voiceTagID"
     */
    inline const SDSVoiceTagId& getVoiceTagID () const;

    /**
     * Retrieves the value of the field "voiceTagID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "voiceTagID".
     */
    inline SDSVoiceTagId& getVoiceTagIDMutable ();

    /**
     * Sets the value of the member "voiceTagID".
     *
     * If the meaning of "voiceTagID" isn't clear, then there should be a description here.
     *
     * @param voiceTagID The value which will be set
     */
    inline void setVoiceTagID (const SDSVoiceTagId& voiceTagID_);

    static const SdsUpdateVoiceTagRequest &getDefaultInstance();

private:

    inline void set_has_voiceTagID ();

    inline void clear_has_voiceTagID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSVoiceTagId _voiceTagID;

};

/**
 * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
 */
class SdsGetHouseNumberPatternResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsGetHouseNumberPatternResponse ();

    /**
     * Copy constructor
     */
    inline  SdsGetHouseNumberPatternResponse (const SdsGetHouseNumberPatternResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber_, const ::std::string& maxHouseNumber_, const ::std::vector< ::std::string >& patterns_);

    /**
     * Destructor
     */
    inline virtual  ~SdsGetHouseNumberPatternResponse();

    /**
     * Assignment operator
     */
    inline SdsGetHouseNumberPatternResponse& operator = (const SdsGetHouseNumberPatternResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "minHouseNumber"

    static const int kMinHouseNumber = 0;

    /**
     * Clears the field "minHouseNumber".
     *
     * The field will be set to its default value. The hasMinHouseNumber()
     * method will return false.
     */
    inline void clearMinHouseNumber();

    /**
     * Checks whether the field "minHouseNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinHouseNumber()). Otherwise it will return false.
     */
    inline bool hasMinHouseNumber () const;

    /**
     * Returns the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "minHouseNumber"
     */
    inline const ::std::string& getMinHouseNumber () const;

    /**
     * Retrieves the value of the field "minHouseNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "minHouseNumber".
     */
    inline ::std::string& getMinHouseNumberMutable ();

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const ::std::string& minHouseNumber_);

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const char* minHouseNumber_);

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const char* value, size_t size);

    // API of field "maxHouseNumber"

    static const int kMaxHouseNumber = 1;

    /**
     * Clears the field "maxHouseNumber".
     *
     * The field will be set to its default value. The hasMaxHouseNumber()
     * method will return false.
     */
    inline void clearMaxHouseNumber();

    /**
     * Checks whether the field "maxHouseNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxHouseNumber()). Otherwise it will return false.
     */
    inline bool hasMaxHouseNumber () const;

    /**
     * Returns the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maxHouseNumber"
     */
    inline const ::std::string& getMaxHouseNumber () const;

    /**
     * Retrieves the value of the field "maxHouseNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "maxHouseNumber".
     */
    inline ::std::string& getMaxHouseNumberMutable ();

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const ::std::string& maxHouseNumber_);

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const char* maxHouseNumber_);

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const char* value, size_t size);

    // API of field "patterns"

    static const int kPatterns = 2;

    /**
     * Clears the field "patterns".
     *
     * The field will be set to its default value. The hasPatterns()
     * method will return false.
     */
    inline void clearPatterns();

    /**
     * Checks whether the field "patterns" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPatterns()). Otherwise it will return false.
     */
    inline bool hasPatterns () const;

    /**
     * Returns the value of the member "patterns".
     *
     * If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @return The value of the field "patterns"
     */
    inline const ::std::vector< ::std::string >& getPatterns () const;

    /**
     * Retrieves the value of the field "patterns" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "patterns".
     */
    inline ::std::vector< ::std::string >& getPatternsMutable ();

    /**
     * Sets the value of the member "patterns".
     *
     * If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @param patterns The value which will be set
     */
    inline void setPatterns (const ::std::vector< ::std::string >& patterns_);

    static const SdsGetHouseNumberPatternResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_minHouseNumber ();

    inline void clear_has_minHouseNumber ();

    inline void set_has_maxHouseNumber ();

    inline void clear_has_maxHouseNumber ();

    inline void set_has_patterns ();

    inline void clear_has_patterns ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _minHouseNumber;

    ::std::string _maxHouseNumber;

    ::std::vector< ::std::string > _patterns;

};

/**
 * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
 *        As result it update the attribute sdsAddressWithOptions
 */
class SelectSdsRefinementRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectSdsRefinementRequest ();

    /**
     * Copy constructor
     */
    inline  SelectSdsRefinementRequest (const SelectSdsRefinementRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectSdsRefinementRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~SelectSdsRefinementRequest();

    /**
     * Assignment operator
     */
    inline SelectSdsRefinementRequest& operator = (const SelectSdsRefinementRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const SelectSdsRefinementRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * Request for Address format for all the available countries in Navigation Data
 */
class RequestAddressFormatForAvailableCountriesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAddressFormatForAvailableCountriesResponse ();

    /**
     * Copy constructor
     */
    inline  RequestAddressFormatForAvailableCountriesResponse (const RequestAddressFormatForAvailableCountriesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAddressFormatForAvailableCountriesResponse (const ::std::vector< AddressFormatInfo >& addressFormatInfos_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAddressFormatForAvailableCountriesResponse();

    /**
     * Assignment operator
     */
    inline RequestAddressFormatForAvailableCountriesResponse& operator = (const RequestAddressFormatForAvailableCountriesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAddressFormatForAvailableCountriesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAddressFormatForAvailableCountriesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAddressFormatForAvailableCountriesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAddressFormatForAvailableCountriesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "addressFormatInfos"

    static const int kAddressFormatInfos = 0;

    /**
     * Clears the field "addressFormatInfos".
     *
     * The field will be set to its default value. The hasAddressFormatInfos()
     * method will return false.
     */
    inline void clearAddressFormatInfos();

    /**
     * Checks whether the field "addressFormatInfos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressFormatInfos()). Otherwise it will return false.
     */
    inline bool hasAddressFormatInfos () const;

    /**
     * Returns the value of the member "addressFormatInfos".
     *
     * If the meaning of "addressFormatInfos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressFormatInfos"
     */
    inline const ::std::vector< AddressFormatInfo >& getAddressFormatInfos () const;

    /**
     * Retrieves the value of the field "addressFormatInfos" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressFormatInfos".
     */
    inline ::std::vector< AddressFormatInfo >& getAddressFormatInfosMutable ();

    /**
     * Sets the value of the member "addressFormatInfos".
     *
     * If the meaning of "addressFormatInfos" isn't clear, then there should be a description here.
     *
     * @param addressFormatInfos The value which will be set
     */
    inline void setAddressFormatInfos (const ::std::vector< AddressFormatInfo >& addressFormatInfos_);

    static const RequestAddressFormatForAvailableCountriesResponse &getDefaultInstance();

private:

    static const ::std::vector< AddressFormatInfo >& getAddressFormatInfoList_DefaultInstance ();

    inline void set_has_addressFormatInfos ();

    inline void clear_has_addressFormatInfos ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< AddressFormatInfo > _addressFormatInfos;

};

/**
 * Request navigation to show driving range on map and contextSwitch
 */
class SdsShowReachableAreaMapRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsShowReachableAreaMapRequest ();

    /**
     * Copy constructor
     */
    inline  SdsShowReachableAreaMapRequest (const SdsShowReachableAreaMapRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsShowReachableAreaMapRequest (LocationType locationType_);

    /**
     * Destructor
     */
    inline virtual  ~SdsShowReachableAreaMapRequest();

    /**
     * Assignment operator
     */
    inline SdsShowReachableAreaMapRequest& operator = (const SdsShowReachableAreaMapRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsShowReachableAreaMapRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsShowReachableAreaMapRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsShowReachableAreaMapRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsShowReachableAreaMapRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationType"

    static const int kLocationType = 0;

    /**
     * Clears the field "locationType".
     *
     * The field will be set to its default value. The hasLocationType()
     * method will return false.
     */
    inline void clearLocationType();

    /**
     * Checks whether the field "locationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationType()). Otherwise it will return false.
     */
    inline bool hasLocationType () const;

    /**
     * Returns the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationType"
     */
    inline LocationType getLocationType () const;

    /**
     * Sets the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @param locationType The value which will be set
     */
    inline void setLocationType (LocationType locationType_);

    static const SdsShowReachableAreaMapRequest &getDefaultInstance();

private:

    inline void set_has_locationType ();

    inline void clear_has_locationType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    LocationType _locationType;

};

/**
 * Request navigation to register for dataset user
 */
class SdsDatasetUserRegistrationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsDatasetUserRegistrationRequest ();

    /**
     * Copy constructor
     */
    inline  SdsDatasetUserRegistrationRequest (const SdsDatasetUserRegistrationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsDatasetUserRegistrationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_);

    /**
     * Destructor
     */
    inline virtual  ~SdsDatasetUserRegistrationRequest();

    /**
     * Assignment operator
     */
    inline SdsDatasetUserRegistrationRequest& operator = (const SdsDatasetUserRegistrationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsDatasetUserRegistrationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsDatasetUserRegistrationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsDatasetUserRegistrationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsDatasetUserRegistrationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ndsDataSetUser"

    static const int kNdsDataSetUser = 0;

    /**
     * Clears the field "ndsDataSetUser".
     *
     * The field will be set to its default value. The hasNdsDataSetUser()
     * method will return false.
     */
    inline void clearNdsDataSetUser();

    /**
     * Checks whether the field "ndsDataSetUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsDataSetUser()). Otherwise it will return false.
     */
    inline bool hasNdsDataSetUser () const;

    /**
     * Returns the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsDataSetUser"
     */
    inline NdsDatasetUser getNdsDataSetUser () const;

    /**
     * Sets the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @param ndsDataSetUser The value which will be set
     */
    inline void setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_);

    // API of field "datasetId"

    static const int kDatasetId = 1;

    /**
     * Clears the field "datasetId".
     *
     * The field will be set to its default value. The hasDatasetId()
     * method will return false.
     */
    inline void clearDatasetId();

    /**
     * Checks whether the field "datasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetId()). Otherwise it will return false.
     */
    inline bool hasDatasetId () const;

    /**
     * Returns the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "datasetId"
     */
    inline uint32 getDatasetId () const;

    /**
     * Sets the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param datasetId The value which will be set
     */
    inline void setDatasetId (uint32 datasetId_);

    static const SdsDatasetUserRegistrationRequest &getDefaultInstance();

private:

    inline void set_has_ndsDataSetUser ();

    inline void clear_has_ndsDataSetUser ();

    inline void set_has_datasetId ();

    inline void clear_has_datasetId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    NdsDatasetUser _ndsDataSetUser;

    uint32 _datasetId;

};

/**
 * Request navigation to register for dataset user
 */
class SdsDatasetUserRegistrationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsDatasetUserRegistrationResponse ();

    /**
     * Copy constructor
     */
    inline  SdsDatasetUserRegistrationResponse (const SdsDatasetUserRegistrationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsDatasetUserRegistrationResponse (RegistrationAndDeRegistrationStatus registrationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SdsDatasetUserRegistrationResponse();

    /**
     * Assignment operator
     */
    inline SdsDatasetUserRegistrationResponse& operator = (const SdsDatasetUserRegistrationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsDatasetUserRegistrationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsDatasetUserRegistrationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsDatasetUserRegistrationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsDatasetUserRegistrationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "registrationStatus"

    static const int kRegistrationStatus = 0;

    /**
     * Clears the field "registrationStatus".
     *
     * The field will be set to its default value. The hasRegistrationStatus()
     * method will return false.
     */
    inline void clearRegistrationStatus();

    /**
     * Checks whether the field "registrationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegistrationStatus()). Otherwise it will return false.
     */
    inline bool hasRegistrationStatus () const;

    /**
     * Returns the value of the member "registrationStatus".
     *
     * If the meaning of "registrationStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "registrationStatus"
     */
    inline RegistrationAndDeRegistrationStatus getRegistrationStatus () const;

    /**
     * Sets the value of the member "registrationStatus".
     *
     * If the meaning of "registrationStatus" isn't clear, then there should be a description here.
     *
     * @param registrationStatus The value which will be set
     */
    inline void setRegistrationStatus (RegistrationAndDeRegistrationStatus registrationStatus_);

    static const SdsDatasetUserRegistrationResponse &getDefaultInstance();

private:

    inline void set_has_registrationStatus ();

    inline void clear_has_registrationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RegistrationAndDeRegistrationStatus _registrationStatus;

};

/**
 * Request navigation to deregister for dataset user
 */
class SdsDatasetUserDeregistrationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsDatasetUserDeregistrationRequest ();

    /**
     * Copy constructor
     */
    inline  SdsDatasetUserDeregistrationRequest (const SdsDatasetUserDeregistrationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsDatasetUserDeregistrationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_);

    /**
     * Destructor
     */
    inline virtual  ~SdsDatasetUserDeregistrationRequest();

    /**
     * Assignment operator
     */
    inline SdsDatasetUserDeregistrationRequest& operator = (const SdsDatasetUserDeregistrationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsDatasetUserDeregistrationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsDatasetUserDeregistrationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsDatasetUserDeregistrationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsDatasetUserDeregistrationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ndsDataSetUser"

    static const int kNdsDataSetUser = 0;

    /**
     * Clears the field "ndsDataSetUser".
     *
     * The field will be set to its default value. The hasNdsDataSetUser()
     * method will return false.
     */
    inline void clearNdsDataSetUser();

    /**
     * Checks whether the field "ndsDataSetUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsDataSetUser()). Otherwise it will return false.
     */
    inline bool hasNdsDataSetUser () const;

    /**
     * Returns the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsDataSetUser"
     */
    inline NdsDatasetUser getNdsDataSetUser () const;

    /**
     * Sets the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @param ndsDataSetUser The value which will be set
     */
    inline void setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_);

    // API of field "datasetId"

    static const int kDatasetId = 1;

    /**
     * Clears the field "datasetId".
     *
     * The field will be set to its default value. The hasDatasetId()
     * method will return false.
     */
    inline void clearDatasetId();

    /**
     * Checks whether the field "datasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetId()). Otherwise it will return false.
     */
    inline bool hasDatasetId () const;

    /**
     * Returns the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "datasetId"
     */
    inline uint32 getDatasetId () const;

    /**
     * Sets the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param datasetId The value which will be set
     */
    inline void setDatasetId (uint32 datasetId_);

    static const SdsDatasetUserDeregistrationRequest &getDefaultInstance();

private:

    inline void set_has_ndsDataSetUser ();

    inline void clear_has_ndsDataSetUser ();

    inline void set_has_datasetId ();

    inline void clear_has_datasetId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    NdsDatasetUser _ndsDataSetUser;

    uint32 _datasetId;

};

/**
 * Request navigation to deregister for dataset user
 */
class SdsDatasetUserDeregistrationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsDatasetUserDeregistrationResponse ();

    /**
     * Copy constructor
     */
    inline  SdsDatasetUserDeregistrationResponse (const SdsDatasetUserDeregistrationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsDatasetUserDeregistrationResponse (RegistrationAndDeRegistrationStatus deregistrationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SdsDatasetUserDeregistrationResponse();

    /**
     * Assignment operator
     */
    inline SdsDatasetUserDeregistrationResponse& operator = (const SdsDatasetUserDeregistrationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsDatasetUserDeregistrationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsDatasetUserDeregistrationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsDatasetUserDeregistrationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsDatasetUserDeregistrationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deregistrationStatus"

    static const int kDeregistrationStatus = 0;

    /**
     * Clears the field "deregistrationStatus".
     *
     * The field will be set to its default value. The hasDeregistrationStatus()
     * method will return false.
     */
    inline void clearDeregistrationStatus();

    /**
     * Checks whether the field "deregistrationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeregistrationStatus()). Otherwise it will return false.
     */
    inline bool hasDeregistrationStatus () const;

    /**
     * Returns the value of the member "deregistrationStatus".
     *
     * If the meaning of "deregistrationStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deregistrationStatus"
     */
    inline RegistrationAndDeRegistrationStatus getDeregistrationStatus () const;

    /**
     * Sets the value of the member "deregistrationStatus".
     *
     * If the meaning of "deregistrationStatus" isn't clear, then there should be a description here.
     *
     * @param deregistrationStatus The value which will be set
     */
    inline void setDeregistrationStatus (RegistrationAndDeRegistrationStatus deregistrationStatus_);

    static const SdsDatasetUserDeregistrationResponse &getDefaultInstance();

private:

    inline void set_has_deregistrationStatus ();

    inline void clear_has_deregistrationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RegistrationAndDeRegistrationStatus _deregistrationStatus;

};

/**
 * Request to change dataset access mode
 */
class DatasetAccessModeChangedIndicationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DatasetAccessModeChangedIndicationRequest ();

    /**
     * Copy constructor
     */
    inline  DatasetAccessModeChangedIndicationRequest (const DatasetAccessModeChangedIndicationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DatasetAccessModeChangedIndicationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_, NdsDataAccessType ndsDataAccessType_);

    /**
     * Destructor
     */
    inline virtual  ~DatasetAccessModeChangedIndicationRequest();

    /**
     * Assignment operator
     */
    inline DatasetAccessModeChangedIndicationRequest& operator = (const DatasetAccessModeChangedIndicationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatasetAccessModeChangedIndicationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatasetAccessModeChangedIndicationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatasetAccessModeChangedIndicationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatasetAccessModeChangedIndicationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ndsDataSetUser"

    static const int kNdsDataSetUser = 0;

    /**
     * Clears the field "ndsDataSetUser".
     *
     * The field will be set to its default value. The hasNdsDataSetUser()
     * method will return false.
     */
    inline void clearNdsDataSetUser();

    /**
     * Checks whether the field "ndsDataSetUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsDataSetUser()). Otherwise it will return false.
     */
    inline bool hasNdsDataSetUser () const;

    /**
     * Returns the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsDataSetUser"
     */
    inline NdsDatasetUser getNdsDataSetUser () const;

    /**
     * Sets the value of the member "ndsDataSetUser".
     *
     * If the meaning of "ndsDataSetUser" isn't clear, then there should be a description here.
     *
     * @param ndsDataSetUser The value which will be set
     */
    inline void setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_);

    // API of field "datasetId"

    static const int kDatasetId = 1;

    /**
     * Clears the field "datasetId".
     *
     * The field will be set to its default value. The hasDatasetId()
     * method will return false.
     */
    inline void clearDatasetId();

    /**
     * Checks whether the field "datasetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetId()). Otherwise it will return false.
     */
    inline bool hasDatasetId () const;

    /**
     * Returns the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "datasetId"
     */
    inline uint32 getDatasetId () const;

    /**
     * Sets the value of the member "datasetId".
     *
     * If the meaning of "datasetId" isn't clear, then there should be a description here.
     *
     * @param datasetId The value which will be set
     */
    inline void setDatasetId (uint32 datasetId_);

    // API of field "ndsDataAccessType"

    static const int kNdsDataAccessType = 2;

    /**
     * Clears the field "ndsDataAccessType".
     *
     * The field will be set to its default value. The hasNdsDataAccessType()
     * method will return false.
     */
    inline void clearNdsDataAccessType();

    /**
     * Checks whether the field "ndsDataAccessType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNdsDataAccessType()). Otherwise it will return false.
     */
    inline bool hasNdsDataAccessType () const;

    /**
     * Returns the value of the member "ndsDataAccessType".
     *
     * If the meaning of "ndsDataAccessType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ndsDataAccessType"
     */
    inline NdsDataAccessType getNdsDataAccessType () const;

    /**
     * Sets the value of the member "ndsDataAccessType".
     *
     * If the meaning of "ndsDataAccessType" isn't clear, then there should be a description here.
     *
     * @param ndsDataAccessType The value which will be set
     */
    inline void setNdsDataAccessType (NdsDataAccessType ndsDataAccessType_);

    static const DatasetAccessModeChangedIndicationRequest &getDefaultInstance();

private:

    inline void set_has_ndsDataSetUser ();

    inline void clear_has_ndsDataSetUser ();

    inline void set_has_datasetId ();

    inline void clear_has_datasetId ();

    inline void set_has_ndsDataAccessType ();

    inline void clear_has_ndsDataAccessType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    NdsDatasetUser _ndsDataSetUser;

    uint32 _datasetId;

    NdsDataAccessType _ndsDataAccessType;

};

/**
 * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
 */
class MapUpdateRequestedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapUpdateRequestedUpdate ();

    /**
     * Copy constructor
     */
    inline  MapUpdateRequestedUpdate (const MapUpdateRequestedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MapUpdateRequestedUpdate (bool mapUpdateRequested_);

    /**
     * Destructor
     */
    inline virtual  ~MapUpdateRequestedUpdate();

    /**
     * Assignment operator
     */
    inline MapUpdateRequestedUpdate& operator = (const MapUpdateRequestedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapUpdateRequestedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapUpdateRequestedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapUpdateRequestedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapUpdateRequestedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mapUpdateRequested"

    static const int kMapUpdateRequested = 0;

    /**
     * Clears the field "mapUpdateRequested".
     *
     * The field will be set to its default value. The hasMapUpdateRequested()
     * method will return false.
     */
    inline void clearMapUpdateRequested();

    /**
     * Checks whether the field "mapUpdateRequested" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapUpdateRequested()). Otherwise it will return false.
     */
    inline bool hasMapUpdateRequested () const;

    /**
     * Returns the value of the member "mapUpdateRequested".
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     *
     * @return The value of the field "mapUpdateRequested"
     */
    inline bool getMapUpdateRequested () const;

    /**
     * Sets the value of the member "mapUpdateRequested".
     *
     * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
     *
     * @param mapUpdateRequested The value which will be set
     */
    inline void setMapUpdateRequested (bool mapUpdateRequested_);

    static const MapUpdateRequestedUpdate &getDefaultInstance();

private:

    inline void set_has_mapUpdateRequested ();

    inline void clear_has_mapUpdateRequested ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _mapUpdateRequested;

};

/**
 * Attribute provides status on map update request and method ndsDatasetReleased will be triggered to start the map update
 */
class MapUpdateRequestedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapUpdateRequestedRegister ();

    /**
     * Copy constructor
     */
    inline  MapUpdateRequestedRegister (const MapUpdateRequestedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MapUpdateRequestedRegister();

    /**
     * Assignment operator
     */
    inline MapUpdateRequestedRegister& operator = (const MapUpdateRequestedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapUpdateRequestedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapUpdateRequestedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapUpdateRequestedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapUpdateRequestedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MapUpdateRequestedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current HMI screen and lockout mode status
 */
class HandOverSessionStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandOverSessionStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  HandOverSessionStatusUpdate (const HandOverSessionStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HandOverSessionStatusUpdate (const HandOverSessionStatus& handOverSessionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~HandOverSessionStatusUpdate();

    /**
     * Assignment operator
     */
    inline HandOverSessionStatusUpdate& operator = (const HandOverSessionStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandOverSessionStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandOverSessionStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandOverSessionStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandOverSessionStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "handOverSessionStatus"

    static const int kHandOverSessionStatus = 0;

    /**
     * Clears the field "handOverSessionStatus".
     *
     * The field will be set to its default value. The hasHandOverSessionStatus()
     * method will return false.
     */
    inline void clearHandOverSessionStatus();

    /**
     * Checks whether the field "handOverSessionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHandOverSessionStatus()). Otherwise it will return false.
     */
    inline bool hasHandOverSessionStatus () const;

    /**
     * Returns the value of the member "handOverSessionStatus".
     *
     * Attribute provides current HMI screen and lockout mode status
     *
     * @return The value of the field "handOverSessionStatus"
     */
    inline const HandOverSessionStatus& getHandOverSessionStatus () const;

    /**
     * Retrieves the value of the field "handOverSessionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "handOverSessionStatus".
     */
    inline HandOverSessionStatus& getHandOverSessionStatusMutable ();

    /**
     * Sets the value of the member "handOverSessionStatus".
     *
     * Attribute provides current HMI screen and lockout mode status
     *
     * @param handOverSessionStatus The value which will be set
     */
    inline void setHandOverSessionStatus (const HandOverSessionStatus& handOverSessionStatus_);

    static const HandOverSessionStatusUpdate &getDefaultInstance();

private:

    inline void set_has_handOverSessionStatus ();

    inline void clear_has_handOverSessionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    HandOverSessionStatus _handOverSessionStatus;

};

/**
 * Attribute provides current HMI screen and lockout mode status
 */
class HandOverSessionStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandOverSessionStatusRegister ();

    /**
     * Copy constructor
     */
    inline  HandOverSessionStatusRegister (const HandOverSessionStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HandOverSessionStatusRegister();

    /**
     * Assignment operator
     */
    inline HandOverSessionStatusRegister& operator = (const HandOverSessionStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandOverSessionStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandOverSessionStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandOverSessionStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandOverSessionStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HandOverSessionStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current vehicle position status information
 */
class PositionStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  PositionStatusInfoUpdate (const PositionStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PositionStatusInfoUpdate (const PositionStatusInfo& positionStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~PositionStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline PositionStatusInfoUpdate& operator = (const PositionStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "positionStatusInfo"

    static const int kPositionStatusInfo = 0;

    /**
     * Clears the field "positionStatusInfo".
     *
     * The field will be set to its default value. The hasPositionStatusInfo()
     * method will return false.
     */
    inline void clearPositionStatusInfo();

    /**
     * Checks whether the field "positionStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionStatusInfo()). Otherwise it will return false.
     */
    inline bool hasPositionStatusInfo () const;

    /**
     * Returns the value of the member "positionStatusInfo".
     *
     * Attribute provides current vehicle position status information
     *
     * @return The value of the field "positionStatusInfo"
     */
    inline const PositionStatusInfo& getPositionStatusInfo () const;

    /**
     * Retrieves the value of the field "positionStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionStatusInfo".
     */
    inline PositionStatusInfo& getPositionStatusInfoMutable ();

    /**
     * Sets the value of the member "positionStatusInfo".
     *
     * Attribute provides current vehicle position status information
     *
     * @param positionStatusInfo The value which will be set
     */
    inline void setPositionStatusInfo (const PositionStatusInfo& positionStatusInfo_);

    static const PositionStatusInfoUpdate &getDefaultInstance();

private:

    inline void set_has_positionStatusInfo ();

    inline void clear_has_positionStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionStatusInfo _positionStatusInfo;

};

/**
 * Attribute provides current vehicle position status information
 */
class PositionStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  PositionStatusInfoRegister (const PositionStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PositionStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline PositionStatusInfoRegister& operator = (const PositionStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PositionStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current vehicle position information
 */
class PositionInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  PositionInfoUpdate (const PositionInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PositionInfoUpdate (const PositionInfo& positionInfo_);

    /**
     * Destructor
     */
    inline virtual  ~PositionInfoUpdate();

    /**
     * Assignment operator
     */
    inline PositionInfoUpdate& operator = (const PositionInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "positionInfo"

    static const int kPositionInfo = 0;

    /**
     * Clears the field "positionInfo".
     *
     * The field will be set to its default value. The hasPositionInfo()
     * method will return false.
     */
    inline void clearPositionInfo();

    /**
     * Checks whether the field "positionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionInfo()). Otherwise it will return false.
     */
    inline bool hasPositionInfo () const;

    /**
     * Returns the value of the member "positionInfo".
     *
     * Attribute provides current vehicle position information
     *
     * @return The value of the field "positionInfo"
     */
    inline const PositionInfo& getPositionInfo () const;

    /**
     * Retrieves the value of the field "positionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionInfo".
     */
    inline PositionInfo& getPositionInfoMutable ();

    /**
     * Sets the value of the member "positionInfo".
     *
     * Attribute provides current vehicle position information
     *
     * @param positionInfo The value which will be set
     */
    inline void setPositionInfo (const PositionInfo& positionInfo_);

    static const PositionInfoUpdate &getDefaultInstance();

private:

    inline void set_has_positionInfo ();

    inline void clear_has_positionInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionInfo _positionInfo;

};

/**
 * Attribute provides current vehicle position information
 */
class PositionInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionInfoRegister ();

    /**
     * Copy constructor
     */
    inline  PositionInfoRegister (const PositionInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PositionInfoRegister();

    /**
     * Assignment operator
     */
    inline PositionInfoRegister& operator = (const PositionInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PositionInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the current SDS address entry
 */
class SdsAddressWithOptionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsAddressWithOptionsUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsAddressWithOptionsUpdate (const SdsAddressWithOptionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsAddressWithOptionsUpdate (const SDSAddressWithOptions& sdsAddressWithOptions_);

    /**
     * Destructor
     */
    inline virtual  ~SdsAddressWithOptionsUpdate();

    /**
     * Assignment operator
     */
    inline SdsAddressWithOptionsUpdate& operator = (const SdsAddressWithOptionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsAddressWithOptions"

    static const int kSdsAddressWithOptions = 0;

    /**
     * Clears the field "sdsAddressWithOptions".
     *
     * The field will be set to its default value. The hasSdsAddressWithOptions()
     * method will return false.
     */
    inline void clearSdsAddressWithOptions();

    /**
     * Checks whether the field "sdsAddressWithOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsAddressWithOptions()). Otherwise it will return false.
     */
    inline bool hasSdsAddressWithOptions () const;

    /**
     * Returns the value of the member "sdsAddressWithOptions".
     *
     * Attribute provides the current SDS address entry
     *
     * @return The value of the field "sdsAddressWithOptions"
     */
    inline const SDSAddressWithOptions& getSdsAddressWithOptions () const;

    /**
     * Retrieves the value of the field "sdsAddressWithOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsAddressWithOptions".
     */
    inline SDSAddressWithOptions& getSdsAddressWithOptionsMutable ();

    /**
     * Sets the value of the member "sdsAddressWithOptions".
     *
     * Attribute provides the current SDS address entry
     *
     * @param sdsAddressWithOptions The value which will be set
     */
    inline void setSdsAddressWithOptions (const SDSAddressWithOptions& sdsAddressWithOptions_);

    static const SdsAddressWithOptionsUpdate &getDefaultInstance();

private:

    inline void set_has_sdsAddressWithOptions ();

    inline void clear_has_sdsAddressWithOptions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSAddressWithOptions _sdsAddressWithOptions;

};

/**
 * Attribute provides the current SDS address entry
 */
class SdsAddressWithOptionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsAddressWithOptionsRegister ();

    /**
     * Copy constructor
     */
    inline  SdsAddressWithOptionsRegister (const SdsAddressWithOptionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsAddressWithOptionsRegister();

    /**
     * Assignment operator
     */
    inline SdsAddressWithOptionsRegister& operator = (const SdsAddressWithOptionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsAddressWithOptionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsAddressWithOptionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsAddressWithOptionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsAddressWithOptionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsAddressWithOptionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
class SdsVoiceTagWithOptionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate (const SdsVoiceTagWithOptionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate (const SDSVoiceTagId& sdsVoiceTagWithOptions_);

    /**
     * Destructor
     */
    inline virtual  ~SdsVoiceTagWithOptionsUpdate();

    /**
     * Assignment operator
     */
    inline SdsVoiceTagWithOptionsUpdate& operator = (const SdsVoiceTagWithOptionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsVoiceTagWithOptions"

    static const int kSdsVoiceTagWithOptions = 0;

    /**
     * Clears the field "sdsVoiceTagWithOptions".
     *
     * The field will be set to its default value. The hasSdsVoiceTagWithOptions()
     * method will return false.
     */
    inline void clearSdsVoiceTagWithOptions();

    /**
     * Checks whether the field "sdsVoiceTagWithOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsVoiceTagWithOptions()). Otherwise it will return false.
     */
    inline bool hasSdsVoiceTagWithOptions () const;

    /**
     * Returns the value of the member "sdsVoiceTagWithOptions".
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @return The value of the field "sdsVoiceTagWithOptions"
     */
    inline const SDSVoiceTagId& getSdsVoiceTagWithOptions () const;

    /**
     * Retrieves the value of the field "sdsVoiceTagWithOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsVoiceTagWithOptions".
     */
    inline SDSVoiceTagId& getSdsVoiceTagWithOptionsMutable ();

    /**
     * Sets the value of the member "sdsVoiceTagWithOptions".
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @param sdsVoiceTagWithOptions The value which will be set
     */
    inline void setSdsVoiceTagWithOptions (const SDSVoiceTagId& sdsVoiceTagWithOptions_);

    static const SdsVoiceTagWithOptionsUpdate &getDefaultInstance();

private:

    inline void set_has_sdsVoiceTagWithOptions ();

    inline void clear_has_sdsVoiceTagWithOptions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSVoiceTagId _sdsVoiceTagWithOptions;

};

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
class SdsVoiceTagWithOptionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsVoiceTagWithOptionsRegister ();

    /**
     * Copy constructor
     */
    inline  SdsVoiceTagWithOptionsRegister (const SdsVoiceTagWithOptionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsVoiceTagWithOptionsRegister();

    /**
     * Assignment operator
     */
    inline SdsVoiceTagWithOptionsRegister& operator = (const SdsVoiceTagWithOptionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsVoiceTagWithOptionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsVoiceTagWithOptionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsVoiceTagWithOptionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsVoiceTagWithOptionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsVoiceTagWithOptionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current navDatasetInfo
 */
class NavDatasetInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDatasetInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  NavDatasetInfoUpdate (const NavDatasetInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NavDatasetInfoUpdate (const NavDataSetInfo& navDatasetInfo_);

    /**
     * Destructor
     */
    inline virtual  ~NavDatasetInfoUpdate();

    /**
     * Assignment operator
     */
    inline NavDatasetInfoUpdate& operator = (const NavDatasetInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDatasetInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDatasetInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDatasetInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDatasetInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navDatasetInfo"

    static const int kNavDatasetInfo = 0;

    /**
     * Clears the field "navDatasetInfo".
     *
     * The field will be set to its default value. The hasNavDatasetInfo()
     * method will return false.
     */
    inline void clearNavDatasetInfo();

    /**
     * Checks whether the field "navDatasetInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavDatasetInfo()). Otherwise it will return false.
     */
    inline bool hasNavDatasetInfo () const;

    /**
     * Returns the value of the member "navDatasetInfo".
     *
     * Attribute provides current navDatasetInfo
     *
     * @return The value of the field "navDatasetInfo"
     */
    inline const NavDataSetInfo& getNavDatasetInfo () const;

    /**
     * Retrieves the value of the field "navDatasetInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "navDatasetInfo".
     */
    inline NavDataSetInfo& getNavDatasetInfoMutable ();

    /**
     * Sets the value of the member "navDatasetInfo".
     *
     * Attribute provides current navDatasetInfo
     *
     * @param navDatasetInfo The value which will be set
     */
    inline void setNavDatasetInfo (const NavDataSetInfo& navDatasetInfo_);

    static const NavDatasetInfoUpdate &getDefaultInstance();

private:

    inline void set_has_navDatasetInfo ();

    inline void clear_has_navDatasetInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavDataSetInfo _navDatasetInfo;

};

/**
 * Attribute provides current navDatasetInfo
 */
class NavDatasetInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDatasetInfoRegister ();

    /**
     * Copy constructor
     */
    inline  NavDatasetInfoRegister (const NavDatasetInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NavDatasetInfoRegister();

    /**
     * Assignment operator
     */
    inline NavDatasetInfoRegister& operator = (const NavDatasetInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDatasetInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDatasetInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDatasetInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDatasetInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NavDatasetInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current DynamicMapPoiCategories
 */
class DynamicMapPoiCategoryWithLanguageUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DynamicMapPoiCategoryWithLanguageUpdate ();

    /**
     * Copy constructor
     */
    inline  DynamicMapPoiCategoryWithLanguageUpdate (const DynamicMapPoiCategoryWithLanguageUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DynamicMapPoiCategoryWithLanguageUpdate (const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage_);

    /**
     * Destructor
     */
    inline virtual  ~DynamicMapPoiCategoryWithLanguageUpdate();

    /**
     * Assignment operator
     */
    inline DynamicMapPoiCategoryWithLanguageUpdate& operator = (const DynamicMapPoiCategoryWithLanguageUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dynamicMapPoiCategoryWithLanguage"

    static const int kDynamicMapPoiCategoryWithLanguage = 0;

    /**
     * Clears the field "dynamicMapPoiCategoryWithLanguage".
     *
     * The field will be set to its default value. The hasDynamicMapPoiCategoryWithLanguage()
     * method will return false.
     */
    inline void clearDynamicMapPoiCategoryWithLanguage();

    /**
     * Checks whether the field "dynamicMapPoiCategoryWithLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynamicMapPoiCategoryWithLanguage()). Otherwise it will return false.
     */
    inline bool hasDynamicMapPoiCategoryWithLanguage () const;

    /**
     * Returns the value of the member "dynamicMapPoiCategoryWithLanguage".
     *
     * Attribute provides current DynamicMapPoiCategories
     *
     * @return The value of the field "dynamicMapPoiCategoryWithLanguage"
     */
    inline const DynamicMapPoiCategoriesWithLanguage& getDynamicMapPoiCategoryWithLanguage () const;

    /**
     * Retrieves the value of the field "dynamicMapPoiCategoryWithLanguage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dynamicMapPoiCategoryWithLanguage".
     */
    inline DynamicMapPoiCategoriesWithLanguage& getDynamicMapPoiCategoryWithLanguageMutable ();

    /**
     * Sets the value of the member "dynamicMapPoiCategoryWithLanguage".
     *
     * Attribute provides current DynamicMapPoiCategories
     *
     * @param dynamicMapPoiCategoryWithLanguage The value which will be set
     */
    inline void setDynamicMapPoiCategoryWithLanguage (const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage_);

    static const DynamicMapPoiCategoryWithLanguageUpdate &getDefaultInstance();

private:

    inline void set_has_dynamicMapPoiCategoryWithLanguage ();

    inline void clear_has_dynamicMapPoiCategoryWithLanguage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DynamicMapPoiCategoriesWithLanguage _dynamicMapPoiCategoryWithLanguage;

};

/**
 * Attribute provides current DynamicMapPoiCategories
 */
class DynamicMapPoiCategoryWithLanguageRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DynamicMapPoiCategoryWithLanguageRegister ();

    /**
     * Copy constructor
     */
    inline  DynamicMapPoiCategoryWithLanguageRegister (const DynamicMapPoiCategoryWithLanguageRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DynamicMapPoiCategoryWithLanguageRegister();

    /**
     * Assignment operator
     */
    inline DynamicMapPoiCategoryWithLanguageRegister& operator = (const DynamicMapPoiCategoryWithLanguageRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicMapPoiCategoryWithLanguageRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicMapPoiCategoryWithLanguageRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicMapPoiCategoryWithLanguageRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicMapPoiCategoryWithLanguageRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DynamicMapPoiCategoryWithLanguageRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  SDSVoiceTagId::SDSVoiceTagId ()  :
    _destinationMemoryEntryId (0u),
    _destinationMemoryEntryName (),
    _sdsVoiceTagId (0u),
    _options (::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSVoiceTagId::SDSVoiceTagId (const SDSVoiceTagId &rhs)  :
    _destinationMemoryEntryId (0u),
    _destinationMemoryEntryName (),
    _sdsVoiceTagId (0u),
    _options (::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSVoiceTagId::SDSVoiceTagId (uint64 destinationMemoryEntryId_, const ::std::string& destinationMemoryEntryName_, uint32 sdsVoiceTagId_, SDSVoiceTagOptions options_)  :
    _destinationMemoryEntryId (destinationMemoryEntryId_),
    _destinationMemoryEntryName (destinationMemoryEntryName_),
    _sdsVoiceTagId (sdsVoiceTagId_),
    _options (options_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destinationMemoryEntryName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(SDSVoiceTagOptions_IsValid(options_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", options_, "SDSVoiceTagOptions", "options", "SDSVoiceTagId");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSVoiceTagId::~SDSVoiceTagId() {
}

inline SDSVoiceTagId& SDSVoiceTagId::operator = (const SDSVoiceTagId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDestinationMemoryEntryId()) {
            setDestinationMemoryEntryId(rhs.getDestinationMemoryEntryId());
        } else {
            clearDestinationMemoryEntryId();
        }
        if (rhs.hasDestinationMemoryEntryName()) {
            setDestinationMemoryEntryName(rhs.getDestinationMemoryEntryName());
        } else {
            clearDestinationMemoryEntryName();
        }
        if (rhs.hasSdsVoiceTagId()) {
            setSdsVoiceTagId(rhs.getSdsVoiceTagId());
        } else {
            clearSdsVoiceTagId();
        }
        if (rhs.hasOptions()) {
            setOptions(rhs.getOptions());
        } else {
            clearOptions();
        }
    }
    return *this;
}

inline bool SDSVoiceTagId::operator == (const SDSVoiceTagId& rhs) const {
    return (((!hasDestinationMemoryEntryId() && !rhs.hasDestinationMemoryEntryId()) || getDestinationMemoryEntryId() == rhs.getDestinationMemoryEntryId()) &&
        ((!hasDestinationMemoryEntryName() && !rhs.hasDestinationMemoryEntryName()) || getDestinationMemoryEntryName() == rhs.getDestinationMemoryEntryName()) &&
        ((!hasSdsVoiceTagId() && !rhs.hasSdsVoiceTagId()) || getSdsVoiceTagId() == rhs.getSdsVoiceTagId()) &&
        ((!hasOptions() && !rhs.hasOptions()) || getOptions() == rhs.getOptions()));
}

inline bool SDSVoiceTagId::operator != (const SDSVoiceTagId& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSVoiceTagId::operator < (const SDSVoiceTagId& rhs) const {
    if (hasDestinationMemoryEntryId() || rhs.hasDestinationMemoryEntryId()) {
        if (getDestinationMemoryEntryId() < rhs.getDestinationMemoryEntryId()) return true;
        if (getDestinationMemoryEntryId() > rhs.getDestinationMemoryEntryId()) return false;
    }
    if (hasDestinationMemoryEntryName() || rhs.hasDestinationMemoryEntryName()) {
        if (getDestinationMemoryEntryName() < rhs.getDestinationMemoryEntryName()) return true;
        if (getDestinationMemoryEntryName() > rhs.getDestinationMemoryEntryName()) return false;
    }
    if (hasSdsVoiceTagId() || rhs.hasSdsVoiceTagId()) {
        if (getSdsVoiceTagId() < rhs.getSdsVoiceTagId()) return true;
        if (getSdsVoiceTagId() > rhs.getSdsVoiceTagId()) return false;
    }
    if (hasOptions() || rhs.hasOptions()) {
        if ((uint32)getOptions() < (uint32)rhs.getOptions()) return true;
        if ((uint32)getOptions() > (uint32)rhs.getOptions()) return false;
    }
    return false;
}

inline bool SDSVoiceTagId::operator > (const SDSVoiceTagId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSVoiceTagId::clear() {
    clearDestinationMemoryEntryId();
    clearDestinationMemoryEntryName();
    clearSdsVoiceTagId();
    clearOptions();
}

inline void SDSVoiceTagId::clearDestinationMemoryEntryId() {
    if (hasDestinationMemoryEntryId()) {
         clear_has_destinationMemoryEntryId();
        _destinationMemoryEntryId = 0u;
     }
}

inline bool SDSVoiceTagId::hasDestinationMemoryEntryId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 SDSVoiceTagId::getDestinationMemoryEntryId () const {
    return _destinationMemoryEntryId;
}

inline void SDSVoiceTagId::setDestinationMemoryEntryId (uint64 destinationMemoryEntryId_) {
    set_has_destinationMemoryEntryId();
    this->_destinationMemoryEntryId = destinationMemoryEntryId_;
}

inline void SDSVoiceTagId::clearDestinationMemoryEntryName() {
    if (hasDestinationMemoryEntryName()) {
         clear_has_destinationMemoryEntryName();
        _destinationMemoryEntryName.clear();
     }
}

inline bool SDSVoiceTagId::hasDestinationMemoryEntryName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SDSVoiceTagId::getDestinationMemoryEntryName () const {
    return _destinationMemoryEntryName;
}

inline ::std::string& SDSVoiceTagId::getDestinationMemoryEntryNameMutable () {
    set_has_destinationMemoryEntryName();
    return _destinationMemoryEntryName;
}

inline void SDSVoiceTagId::setDestinationMemoryEntryName (const ::std::string& destinationMemoryEntryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destinationMemoryEntryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destinationMemoryEntryName();
    this->_destinationMemoryEntryName = destinationMemoryEntryName_;
}

inline void SDSVoiceTagId::setDestinationMemoryEntryName (const char* destinationMemoryEntryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destinationMemoryEntryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destinationMemoryEntryName();
    this->_destinationMemoryEntryName.assign(destinationMemoryEntryName_);
}

inline void SDSVoiceTagId::setDestinationMemoryEntryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destinationMemoryEntryName();
    this->_destinationMemoryEntryName.assign(value, size);
}

inline void SDSVoiceTagId::clearSdsVoiceTagId() {
    if (hasSdsVoiceTagId()) {
         clear_has_sdsVoiceTagId();
        _sdsVoiceTagId = 0u;
     }
}

inline bool SDSVoiceTagId::hasSdsVoiceTagId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SDSVoiceTagId::getSdsVoiceTagId () const {
    return _sdsVoiceTagId;
}

inline void SDSVoiceTagId::setSdsVoiceTagId (uint32 sdsVoiceTagId_) {
    set_has_sdsVoiceTagId();
    this->_sdsVoiceTagId = sdsVoiceTagId_;
}

inline void SDSVoiceTagId::clearOptions() {
    if (hasOptions()) {
         clear_has_options();
        _options = ::org::bosch::cm::navigation::NavigationSDSService::SDSVoiceTagOptions__NONE;
     }
}

inline bool SDSVoiceTagId::hasOptions () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline SDSVoiceTagOptions SDSVoiceTagId::getOptions () const {
    return _options;
}

inline void SDSVoiceTagId::setOptions (SDSVoiceTagOptions options_) {
    #ifndef NDEBUG
    if (!(SDSVoiceTagOptions_IsValid(options_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", options_, "SDSVoiceTagOptions", "options", "SDSVoiceTagId");
    }
    #endif
    set_has_options();
    this->_options = options_;
}

inline void SDSVoiceTagId::set_has_destinationMemoryEntryId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSVoiceTagId::clear_has_destinationMemoryEntryId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SDSVoiceTagId::set_has_destinationMemoryEntryName () {
    _has_bits_[0] |= 1u << 1;
}

inline void SDSVoiceTagId::clear_has_destinationMemoryEntryName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SDSVoiceTagId::set_has_sdsVoiceTagId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SDSVoiceTagId::clear_has_sdsVoiceTagId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SDSVoiceTagId::set_has_options () {
    _has_bits_[0] |= 1u << 3;
}

inline void SDSVoiceTagId::clear_has_options () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SDSElementOptions::SDSElementOptions ()  :
    _isAmbigious (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSElementOptions::SDSElementOptions (const SDSElementOptions &rhs)  :
    _isAmbigious (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSElementOptions::SDSElementOptions (bool isAmbigious_)  :
    _isAmbigious (isAmbigious_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSElementOptions::~SDSElementOptions() {
}

inline SDSElementOptions& SDSElementOptions::operator = (const SDSElementOptions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIsAmbigious()) {
            setIsAmbigious(rhs.getIsAmbigious());
        } else {
            clearIsAmbigious();
        }
    }
    return *this;
}

inline bool SDSElementOptions::operator == (const SDSElementOptions& rhs) const {
    return (((!hasIsAmbigious() && !rhs.hasIsAmbigious()) || getIsAmbigious() == rhs.getIsAmbigious()));
}

inline bool SDSElementOptions::operator != (const SDSElementOptions& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSElementOptions::operator < (const SDSElementOptions& rhs) const {
    if (hasIsAmbigious() || rhs.hasIsAmbigious()) {
        if (getIsAmbigious() < rhs.getIsAmbigious()) return true;
        if (getIsAmbigious() > rhs.getIsAmbigious()) return false;
    }
    return false;
}

inline bool SDSElementOptions::operator > (const SDSElementOptions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSElementOptions::clear() {
    clearIsAmbigious();
}

inline void SDSElementOptions::clearIsAmbigious() {
    if (hasIsAmbigious()) {
         clear_has_isAmbigious();
        _isAmbigious = false;
     }
}

inline bool SDSElementOptions::hasIsAmbigious () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SDSElementOptions::getIsAmbigious () const {
    return _isAmbigious;
}

inline void SDSElementOptions::setIsAmbigious (bool isAmbigious_) {
    set_has_isAmbigious();
    this->_isAmbigious = isAmbigious_;
}

inline void SDSElementOptions::set_has_isAmbigious () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSElementOptions::clear_has_isAmbigious () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SDSAddressElement::SDSAddressElement ()  :
    _addressElementType (::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY),
    _data (),
    _elementOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSAddressElement::SDSAddressElement (const SDSAddressElement &rhs)  :
    _addressElementType (::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY),
    _data (),
    _elementOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSAddressElement::SDSAddressElement (SDSAddressElementType addressElementType_, const ::std::string& data_, const SDSElementOptions& elementOptions_)  :
    _addressElementType (addressElementType_),
    _data (data_),
    _elementOptions (elementOptions_)
{
    #ifndef NDEBUG
    if (!(SDSAddressElementType_IsValid(addressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", addressElementType_, "SDSAddressElementType", "addressElementType", "SDSAddressElement");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSAddressElement::~SDSAddressElement() {
}

inline SDSAddressElement& SDSAddressElement::operator = (const SDSAddressElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAddressElementType()) {
            setAddressElementType(rhs.getAddressElementType());
        } else {
            clearAddressElementType();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasElementOptions()) {
            setElementOptions(rhs.getElementOptions());
        } else {
            clearElementOptions();
        }
    }
    return *this;
}

inline bool SDSAddressElement::operator == (const SDSAddressElement& rhs) const {
    return (((!hasAddressElementType() && !rhs.hasAddressElementType()) || getAddressElementType() == rhs.getAddressElementType()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasElementOptions() && !rhs.hasElementOptions()) || getElementOptions() == rhs.getElementOptions()));
}

inline bool SDSAddressElement::operator != (const SDSAddressElement& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSAddressElement::operator < (const SDSAddressElement& rhs) const {
    if (hasAddressElementType() || rhs.hasAddressElementType()) {
        if ((uint32)getAddressElementType() < (uint32)rhs.getAddressElementType()) return true;
        if ((uint32)getAddressElementType() > (uint32)rhs.getAddressElementType()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasElementOptions() || rhs.hasElementOptions()) {
        if (getElementOptions() < rhs.getElementOptions()) return true;
        if (getElementOptions() > rhs.getElementOptions()) return false;
    }
    return false;
}

inline bool SDSAddressElement::operator > (const SDSAddressElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSAddressElement::clear() {
    clearAddressElementType();
    clearData();
    clearElementOptions();
}

inline void SDSAddressElement::clearAddressElementType() {
    if (hasAddressElementType()) {
         clear_has_addressElementType();
        _addressElementType = ::org::bosch::cm::navigation::NavigationSDSService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
     }
}

inline bool SDSAddressElement::hasAddressElementType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SDSAddressElementType SDSAddressElement::getAddressElementType () const {
    return _addressElementType;
}

inline void SDSAddressElement::setAddressElementType (SDSAddressElementType addressElementType_) {
    #ifndef NDEBUG
    if (!(SDSAddressElementType_IsValid(addressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", addressElementType_, "SDSAddressElementType", "addressElementType", "SDSAddressElement");
    }
    #endif
    set_has_addressElementType();
    this->_addressElementType = addressElementType_;
}

inline void SDSAddressElement::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SDSAddressElement::hasData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SDSAddressElement::getData () const {
    return _data;
}

inline ::std::string& SDSAddressElement::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SDSAddressElement::setData (const ::std::string& data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data = data_;
}

inline void SDSAddressElement::setData (const char* data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(data_);
}

inline void SDSAddressElement::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(value, size);
}

inline void SDSAddressElement::clearElementOptions() {
    if (hasElementOptions()) {
         clear_has_elementOptions();
        _elementOptions.clear();
     }
}

inline bool SDSAddressElement::hasElementOptions () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const SDSElementOptions& SDSAddressElement::getElementOptions () const {
    return _elementOptions;
}

inline SDSElementOptions& SDSAddressElement::getElementOptionsMutable () {
    set_has_elementOptions();
    return _elementOptions;
}

inline void SDSAddressElement::setElementOptions (const SDSElementOptions& elementOptions_) {
    set_has_elementOptions();
    this->_elementOptions = elementOptions_;
}

inline void SDSAddressElement::set_has_addressElementType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSAddressElement::clear_has_addressElementType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SDSAddressElement::set_has_data () {
    _has_bits_[0] |= 1u << 1;
}

inline void SDSAddressElement::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SDSAddressElement::set_has_elementOptions () {
    _has_bits_[0] |= 1u << 2;
}

inline void SDSAddressElement::clear_has_elementOptions () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SDSAddressOptions::SDSAddressOptions ()  :
    _navigable (false),
    _ambigious (false),
    _removedInvalidEntry (false),
    _moreEntriesPossible (false),
    _houseNumberAvailable (false),
    _houseNumberValid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSAddressOptions::SDSAddressOptions (const SDSAddressOptions &rhs)  :
    _navigable (false),
    _ambigious (false),
    _removedInvalidEntry (false),
    _moreEntriesPossible (false),
    _houseNumberAvailable (false),
    _houseNumberValid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSAddressOptions::SDSAddressOptions (bool navigable_, bool ambigious_, bool removedInvalidEntry_, bool moreEntriesPossible_, bool houseNumberAvailable_, bool houseNumberValid_)  :
    _navigable (navigable_),
    _ambigious (ambigious_),
    _removedInvalidEntry (removedInvalidEntry_),
    _moreEntriesPossible (moreEntriesPossible_),
    _houseNumberAvailable (houseNumberAvailable_),
    _houseNumberValid (houseNumberValid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSAddressOptions::~SDSAddressOptions() {
}

inline SDSAddressOptions& SDSAddressOptions::operator = (const SDSAddressOptions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNavigable()) {
            setNavigable(rhs.getNavigable());
        } else {
            clearNavigable();
        }
        if (rhs.hasAmbigious()) {
            setAmbigious(rhs.getAmbigious());
        } else {
            clearAmbigious();
        }
        if (rhs.hasRemovedInvalidEntry()) {
            setRemovedInvalidEntry(rhs.getRemovedInvalidEntry());
        } else {
            clearRemovedInvalidEntry();
        }
        if (rhs.hasMoreEntriesPossible()) {
            setMoreEntriesPossible(rhs.getMoreEntriesPossible());
        } else {
            clearMoreEntriesPossible();
        }
        if (rhs.hasHouseNumberAvailable()) {
            setHouseNumberAvailable(rhs.getHouseNumberAvailable());
        } else {
            clearHouseNumberAvailable();
        }
        if (rhs.hasHouseNumberValid()) {
            setHouseNumberValid(rhs.getHouseNumberValid());
        } else {
            clearHouseNumberValid();
        }
    }
    return *this;
}

inline bool SDSAddressOptions::operator == (const SDSAddressOptions& rhs) const {
    return (((!hasNavigable() && !rhs.hasNavigable()) || getNavigable() == rhs.getNavigable()) &&
        ((!hasAmbigious() && !rhs.hasAmbigious()) || getAmbigious() == rhs.getAmbigious()) &&
        ((!hasRemovedInvalidEntry() && !rhs.hasRemovedInvalidEntry()) || getRemovedInvalidEntry() == rhs.getRemovedInvalidEntry()) &&
        ((!hasMoreEntriesPossible() && !rhs.hasMoreEntriesPossible()) || getMoreEntriesPossible() == rhs.getMoreEntriesPossible()) &&
        ((!hasHouseNumberAvailable() && !rhs.hasHouseNumberAvailable()) || getHouseNumberAvailable() == rhs.getHouseNumberAvailable()) &&
        ((!hasHouseNumberValid() && !rhs.hasHouseNumberValid()) || getHouseNumberValid() == rhs.getHouseNumberValid()));
}

inline bool SDSAddressOptions::operator != (const SDSAddressOptions& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSAddressOptions::operator < (const SDSAddressOptions& rhs) const {
    if (hasNavigable() || rhs.hasNavigable()) {
        if (getNavigable() < rhs.getNavigable()) return true;
        if (getNavigable() > rhs.getNavigable()) return false;
    }
    if (hasAmbigious() || rhs.hasAmbigious()) {
        if (getAmbigious() < rhs.getAmbigious()) return true;
        if (getAmbigious() > rhs.getAmbigious()) return false;
    }
    if (hasRemovedInvalidEntry() || rhs.hasRemovedInvalidEntry()) {
        if (getRemovedInvalidEntry() < rhs.getRemovedInvalidEntry()) return true;
        if (getRemovedInvalidEntry() > rhs.getRemovedInvalidEntry()) return false;
    }
    if (hasMoreEntriesPossible() || rhs.hasMoreEntriesPossible()) {
        if (getMoreEntriesPossible() < rhs.getMoreEntriesPossible()) return true;
        if (getMoreEntriesPossible() > rhs.getMoreEntriesPossible()) return false;
    }
    if (hasHouseNumberAvailable() || rhs.hasHouseNumberAvailable()) {
        if (getHouseNumberAvailable() < rhs.getHouseNumberAvailable()) return true;
        if (getHouseNumberAvailable() > rhs.getHouseNumberAvailable()) return false;
    }
    if (hasHouseNumberValid() || rhs.hasHouseNumberValid()) {
        if (getHouseNumberValid() < rhs.getHouseNumberValid()) return true;
        if (getHouseNumberValid() > rhs.getHouseNumberValid()) return false;
    }
    return false;
}

inline bool SDSAddressOptions::operator > (const SDSAddressOptions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSAddressOptions::clear() {
    clearNavigable();
    clearAmbigious();
    clearRemovedInvalidEntry();
    clearMoreEntriesPossible();
    clearHouseNumberAvailable();
    clearHouseNumberValid();
}

inline void SDSAddressOptions::clearNavigable() {
    if (hasNavigable()) {
         clear_has_navigable();
        _navigable = false;
     }
}

inline bool SDSAddressOptions::hasNavigable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SDSAddressOptions::getNavigable () const {
    return _navigable;
}

inline void SDSAddressOptions::setNavigable (bool navigable_) {
    set_has_navigable();
    this->_navigable = navigable_;
}

inline void SDSAddressOptions::clearAmbigious() {
    if (hasAmbigious()) {
         clear_has_ambigious();
        _ambigious = false;
     }
}

inline bool SDSAddressOptions::hasAmbigious () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SDSAddressOptions::getAmbigious () const {
    return _ambigious;
}

inline void SDSAddressOptions::setAmbigious (bool ambigious_) {
    set_has_ambigious();
    this->_ambigious = ambigious_;
}

inline void SDSAddressOptions::clearRemovedInvalidEntry() {
    if (hasRemovedInvalidEntry()) {
         clear_has_removedInvalidEntry();
        _removedInvalidEntry = false;
     }
}

inline bool SDSAddressOptions::hasRemovedInvalidEntry () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SDSAddressOptions::getRemovedInvalidEntry () const {
    return _removedInvalidEntry;
}

inline void SDSAddressOptions::setRemovedInvalidEntry (bool removedInvalidEntry_) {
    set_has_removedInvalidEntry();
    this->_removedInvalidEntry = removedInvalidEntry_;
}

inline void SDSAddressOptions::clearMoreEntriesPossible() {
    if (hasMoreEntriesPossible()) {
         clear_has_moreEntriesPossible();
        _moreEntriesPossible = false;
     }
}

inline bool SDSAddressOptions::hasMoreEntriesPossible () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool SDSAddressOptions::getMoreEntriesPossible () const {
    return _moreEntriesPossible;
}

inline void SDSAddressOptions::setMoreEntriesPossible (bool moreEntriesPossible_) {
    set_has_moreEntriesPossible();
    this->_moreEntriesPossible = moreEntriesPossible_;
}

inline void SDSAddressOptions::clearHouseNumberAvailable() {
    if (hasHouseNumberAvailable()) {
         clear_has_houseNumberAvailable();
        _houseNumberAvailable = false;
     }
}

inline bool SDSAddressOptions::hasHouseNumberAvailable () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool SDSAddressOptions::getHouseNumberAvailable () const {
    return _houseNumberAvailable;
}

inline void SDSAddressOptions::setHouseNumberAvailable (bool houseNumberAvailable_) {
    set_has_houseNumberAvailable();
    this->_houseNumberAvailable = houseNumberAvailable_;
}

inline void SDSAddressOptions::clearHouseNumberValid() {
    if (hasHouseNumberValid()) {
         clear_has_houseNumberValid();
        _houseNumberValid = false;
     }
}

inline bool SDSAddressOptions::hasHouseNumberValid () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool SDSAddressOptions::getHouseNumberValid () const {
    return _houseNumberValid;
}

inline void SDSAddressOptions::setHouseNumberValid (bool houseNumberValid_) {
    set_has_houseNumberValid();
    this->_houseNumberValid = houseNumberValid_;
}

inline void SDSAddressOptions::set_has_navigable () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSAddressOptions::clear_has_navigable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SDSAddressOptions::set_has_ambigious () {
    _has_bits_[0] |= 1u << 1;
}

inline void SDSAddressOptions::clear_has_ambigious () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SDSAddressOptions::set_has_removedInvalidEntry () {
    _has_bits_[0] |= 1u << 2;
}

inline void SDSAddressOptions::clear_has_removedInvalidEntry () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SDSAddressOptions::set_has_moreEntriesPossible () {
    _has_bits_[0] |= 1u << 3;
}

inline void SDSAddressOptions::clear_has_moreEntriesPossible () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SDSAddressOptions::set_has_houseNumberAvailable () {
    _has_bits_[0] |= 1u << 4;
}

inline void SDSAddressOptions::clear_has_houseNumberAvailable () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SDSAddressOptions::set_has_houseNumberValid () {
    _has_bits_[0] |= 1u << 5;
}

inline void SDSAddressOptions::clear_has_houseNumberValid () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  SDSAddressWithOptions::SDSAddressWithOptions ()  :
    _address (),
    _addressOptions (),
    _addressElementType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSAddressWithOptions::SDSAddressWithOptions (const SDSAddressWithOptions &rhs)  :
    _address (),
    _addressOptions (),
    _addressElementType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSAddressWithOptions::SDSAddressWithOptions (const ::std::vector< SDSAddressElement >& address_, const SDSAddressOptions& addressOptions_, const ::std::vector< SDSAddressElementType >& addressElementType_)  :
    _address (address_),
    _addressOptions (addressOptions_),
    _addressElementType (addressElementType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSAddressWithOptions::~SDSAddressWithOptions() {
}

inline SDSAddressWithOptions& SDSAddressWithOptions::operator = (const SDSAddressWithOptions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasAddressOptions()) {
            setAddressOptions(rhs.getAddressOptions());
        } else {
            clearAddressOptions();
        }
        if (rhs.hasAddressElementType()) {
            setAddressElementType(rhs.getAddressElementType());
        } else {
            clearAddressElementType();
        }
    }
    return *this;
}

inline bool SDSAddressWithOptions::operator == (const SDSAddressWithOptions& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasAddressOptions() && !rhs.hasAddressOptions()) || getAddressOptions() == rhs.getAddressOptions()) &&
        ((!hasAddressElementType() && !rhs.hasAddressElementType()) || getAddressElementType() == rhs.getAddressElementType()));
}

inline bool SDSAddressWithOptions::operator != (const SDSAddressWithOptions& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSAddressWithOptions::operator < (const SDSAddressWithOptions& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasAddressOptions() || rhs.hasAddressOptions()) {
        if (getAddressOptions() < rhs.getAddressOptions()) return true;
        if (getAddressOptions() > rhs.getAddressOptions()) return false;
    }
    if (hasAddressElementType() || rhs.hasAddressElementType()) {
        if (getAddressElementType() < rhs.getAddressElementType()) return true;
        if (getAddressElementType() > rhs.getAddressElementType()) return false;
    }
    return false;
}

inline bool SDSAddressWithOptions::operator > (const SDSAddressWithOptions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSAddressWithOptions::clear() {
    clearAddress();
    clearAddressOptions();
    clearAddressElementType();
}

inline void SDSAddressWithOptions::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool SDSAddressWithOptions::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SDSAddressElement >& SDSAddressWithOptions::getAddress () const {
    return _address;
}

inline ::std::vector< SDSAddressElement >& SDSAddressWithOptions::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void SDSAddressWithOptions::setAddress (const ::std::vector< SDSAddressElement >& address_) {
    set_has_address();
    this->_address = address_;
}

inline void SDSAddressWithOptions::clearAddressOptions() {
    if (hasAddressOptions()) {
         clear_has_addressOptions();
        _addressOptions.clear();
     }
}

inline bool SDSAddressWithOptions::hasAddressOptions () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const SDSAddressOptions& SDSAddressWithOptions::getAddressOptions () const {
    return _addressOptions;
}

inline SDSAddressOptions& SDSAddressWithOptions::getAddressOptionsMutable () {
    set_has_addressOptions();
    return _addressOptions;
}

inline void SDSAddressWithOptions::setAddressOptions (const SDSAddressOptions& addressOptions_) {
    set_has_addressOptions();
    this->_addressOptions = addressOptions_;
}

inline void SDSAddressWithOptions::clearAddressElementType() {
    if (hasAddressElementType()) {
         clear_has_addressElementType();
        _addressElementType.clear();
     }
}

inline bool SDSAddressWithOptions::hasAddressElementType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< SDSAddressElementType >& SDSAddressWithOptions::getAddressElementType () const {
    return _addressElementType;
}

inline ::std::vector< SDSAddressElementType >& SDSAddressWithOptions::getAddressElementTypeMutable () {
    set_has_addressElementType();
    return _addressElementType;
}

inline void SDSAddressWithOptions::setAddressElementType (const ::std::vector< SDSAddressElementType >& addressElementType_) {
    set_has_addressElementType();
    this->_addressElementType = addressElementType_;
}

inline void SDSAddressWithOptions::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSAddressWithOptions::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SDSAddressWithOptions::set_has_addressOptions () {
    _has_bits_[0] |= 1u << 1;
}

inline void SDSAddressWithOptions::clear_has_addressOptions () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SDSAddressWithOptions::set_has_addressElementType () {
    _has_bits_[0] |= 1u << 2;
}

inline void SDSAddressWithOptions::clear_has_addressElementType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RefinementListElement::RefinementListElement ()  :
    _data (),
    _id (0u),
    _distance (),
    _direction (::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RefinementListElement::RefinementListElement (const RefinementListElement &rhs)  :
    _data (),
    _id (0u),
    _distance (),
    _direction (::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RefinementListElement::RefinementListElement (const ::std::string& data_, uint32 id_, const ::std::string& distance_, DirectionDescription direction_)  :
    _data (data_),
    _id (id_),
    _distance (distance_),
    _direction (direction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(DirectionDescription_IsValid(direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", direction_, "DirectionDescription", "direction", "RefinementListElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RefinementListElement::~RefinementListElement() {
}

inline RefinementListElement& RefinementListElement::operator = (const RefinementListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
    }
    return *this;
}

inline bool RefinementListElement::operator == (const RefinementListElement& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasId() && !rhs.hasId()) || getId() == rhs.getId()) &&
        ((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()));
}

inline bool RefinementListElement::operator != (const RefinementListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool RefinementListElement::operator < (const RefinementListElement& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasId() || rhs.hasId()) {
        if (getId() < rhs.getId()) return true;
        if (getId() > rhs.getId()) return false;
    }
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if ((uint32)getDirection() < (uint32)rhs.getDirection()) return true;
        if ((uint32)getDirection() > (uint32)rhs.getDirection()) return false;
    }
    return false;
}

inline bool RefinementListElement::operator > (const RefinementListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RefinementListElement::clear() {
    clearData();
    clearId();
    clearDistance();
    clearDirection();
}

inline void RefinementListElement::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool RefinementListElement::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RefinementListElement::getData () const {
    return _data;
}

inline ::std::string& RefinementListElement::getDataMutable () {
    set_has_data();
    return _data;
}

inline void RefinementListElement::setData (const ::std::string& data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data = data_;
}

inline void RefinementListElement::setData (const char* data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(data_);
}

inline void RefinementListElement::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(value, size);
}

inline void RefinementListElement::clearId() {
    if (hasId()) {
         clear_has_id();
        _id = 0u;
     }
}

inline bool RefinementListElement::hasId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RefinementListElement::getId () const {
    return _id;
}

inline void RefinementListElement::setId (uint32 id_) {
    set_has_id();
    this->_id = id_;
}

inline void RefinementListElement::clearDistance() {
    if (hasDistance()) {
         clear_has_distance();
        _distance.clear();
     }
}

inline bool RefinementListElement::hasDistance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& RefinementListElement::getDistance () const {
    return _distance;
}

inline ::std::string& RefinementListElement::getDistanceMutable () {
    set_has_distance();
    return _distance;
}

inline void RefinementListElement::setDistance (const ::std::string& distance_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance = distance_;
}

inline void RefinementListElement::setDistance (const char* distance_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance.assign(distance_);
}

inline void RefinementListElement::setDistance (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance.assign(value, size);
}

inline void RefinementListElement::clearDirection() {
    if (hasDirection()) {
         clear_has_direction();
        _direction = ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH;
     }
}

inline bool RefinementListElement::hasDirection () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline DirectionDescription RefinementListElement::getDirection () const {
    return _direction;
}

inline void RefinementListElement::setDirection (DirectionDescription direction_) {
    #ifndef NDEBUG
    if (!(DirectionDescription_IsValid(direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", direction_, "DirectionDescription", "direction", "RefinementListElement");
    }
    #endif
    set_has_direction();
    this->_direction = direction_;
}

inline void RefinementListElement::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void RefinementListElement::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RefinementListElement::set_has_id () {
    _has_bits_[0] |= 1u << 1;
}

inline void RefinementListElement::clear_has_id () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RefinementListElement::set_has_distance () {
    _has_bits_[0] |= 1u << 2;
}

inline void RefinementListElement::clear_has_distance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RefinementListElement::set_has_direction () {
    _has_bits_[0] |= 1u << 3;
}

inline void RefinementListElement::clear_has_direction () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  AddressListElement::AddressListElement ()  :
    _data (),
    _id (0u),
    _distance (),
    _address (),
    _direction (::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressListElement::AddressListElement (const AddressListElement &rhs)  :
    _data (),
    _id (0u),
    _distance (),
    _address (),
    _direction (::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressListElement::AddressListElement (const ::std::string& data_, uint64 id_, const ::std::string& distance_, const ::std::string& address_, DirectionDescription direction_)  :
    _data (data_),
    _id (id_),
    _distance (distance_),
    _address (address_),
    _direction (direction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(DirectionDescription_IsValid(direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", direction_, "DirectionDescription", "direction", "AddressListElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressListElement::~AddressListElement() {
}

inline AddressListElement& AddressListElement::operator = (const AddressListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
    }
    return *this;
}

inline bool AddressListElement::operator == (const AddressListElement& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasId() && !rhs.hasId()) || getId() == rhs.getId()) &&
        ((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()));
}

inline bool AddressListElement::operator != (const AddressListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressListElement::operator < (const AddressListElement& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasId() || rhs.hasId()) {
        if (getId() < rhs.getId()) return true;
        if (getId() > rhs.getId()) return false;
    }
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if ((uint32)getDirection() < (uint32)rhs.getDirection()) return true;
        if ((uint32)getDirection() > (uint32)rhs.getDirection()) return false;
    }
    return false;
}

inline bool AddressListElement::operator > (const AddressListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressListElement::clear() {
    clearData();
    clearId();
    clearDistance();
    clearAddress();
    clearDirection();
}

inline void AddressListElement::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool AddressListElement::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressListElement::getData () const {
    return _data;
}

inline ::std::string& AddressListElement::getDataMutable () {
    set_has_data();
    return _data;
}

inline void AddressListElement::setData (const ::std::string& data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data = data_;
}

inline void AddressListElement::setData (const char* data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(data_);
}

inline void AddressListElement::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(value, size);
}

inline void AddressListElement::clearId() {
    if (hasId()) {
         clear_has_id();
        _id = 0u;
     }
}

inline bool AddressListElement::hasId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 AddressListElement::getId () const {
    return _id;
}

inline void AddressListElement::setId (uint64 id_) {
    set_has_id();
    this->_id = id_;
}

inline void AddressListElement::clearDistance() {
    if (hasDistance()) {
         clear_has_distance();
        _distance.clear();
     }
}

inline bool AddressListElement::hasDistance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& AddressListElement::getDistance () const {
    return _distance;
}

inline ::std::string& AddressListElement::getDistanceMutable () {
    set_has_distance();
    return _distance;
}

inline void AddressListElement::setDistance (const ::std::string& distance_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance = distance_;
}

inline void AddressListElement::setDistance (const char* distance_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (distance_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance.assign(distance_);
}

inline void AddressListElement::setDistance (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_distance();
    this->_distance.assign(value, size);
}

inline void AddressListElement::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool AddressListElement::hasAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& AddressListElement::getAddress () const {
    return _address;
}

inline ::std::string& AddressListElement::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void AddressListElement::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void AddressListElement::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void AddressListElement::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void AddressListElement::clearDirection() {
    if (hasDirection()) {
         clear_has_direction();
        _direction = ::org::bosch::cm::navigation::NavigationSDSService::DirectionDescription__NORTH;
     }
}

inline bool AddressListElement::hasDirection () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline DirectionDescription AddressListElement::getDirection () const {
    return _direction;
}

inline void AddressListElement::setDirection (DirectionDescription direction_) {
    #ifndef NDEBUG
    if (!(DirectionDescription_IsValid(direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", direction_, "DirectionDescription", "direction", "AddressListElement");
    }
    #endif
    set_has_direction();
    this->_direction = direction_;
}

inline void AddressListElement::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressListElement::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AddressListElement::set_has_id () {
    _has_bits_[0] |= 1u << 1;
}

inline void AddressListElement::clear_has_id () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AddressListElement::set_has_distance () {
    _has_bits_[0] |= 1u << 2;
}

inline void AddressListElement::clear_has_distance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AddressListElement::set_has_address () {
    _has_bits_[0] |= 1u << 3;
}

inline void AddressListElement::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AddressListElement::set_has_direction () {
    _has_bits_[0] |= 1u << 4;
}

inline void AddressListElement::clear_has_direction () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  LanguageVersion::LanguageVersion ()  :
    _languageCode (0u),
    _specificationVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LanguageVersion::LanguageVersion (const LanguageVersion &rhs)  :
    _languageCode (0u),
    _specificationVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LanguageVersion::LanguageVersion (uint16 languageCode_, const ::std::string& specificationVersion_)  :
    _languageCode (languageCode_),
    _specificationVersion (specificationVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (specificationVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LanguageVersion::~LanguageVersion() {
}

inline LanguageVersion& LanguageVersion::operator = (const LanguageVersion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageCode()) {
            setLanguageCode(rhs.getLanguageCode());
        } else {
            clearLanguageCode();
        }
        if (rhs.hasSpecificationVersion()) {
            setSpecificationVersion(rhs.getSpecificationVersion());
        } else {
            clearSpecificationVersion();
        }
    }
    return *this;
}

inline bool LanguageVersion::operator == (const LanguageVersion& rhs) const {
    return (((!hasLanguageCode() && !rhs.hasLanguageCode()) || getLanguageCode() == rhs.getLanguageCode()) &&
        ((!hasSpecificationVersion() && !rhs.hasSpecificationVersion()) || getSpecificationVersion() == rhs.getSpecificationVersion()));
}

inline bool LanguageVersion::operator != (const LanguageVersion& rhs) const {
    return ! (*this == rhs);
}

inline bool LanguageVersion::operator < (const LanguageVersion& rhs) const {
    if (hasLanguageCode() || rhs.hasLanguageCode()) {
        if (getLanguageCode() < rhs.getLanguageCode()) return true;
        if (getLanguageCode() > rhs.getLanguageCode()) return false;
    }
    if (hasSpecificationVersion() || rhs.hasSpecificationVersion()) {
        if (getSpecificationVersion() < rhs.getSpecificationVersion()) return true;
        if (getSpecificationVersion() > rhs.getSpecificationVersion()) return false;
    }
    return false;
}

inline bool LanguageVersion::operator > (const LanguageVersion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LanguageVersion::clear() {
    clearLanguageCode();
    clearSpecificationVersion();
}

inline void LanguageVersion::clearLanguageCode() {
    if (hasLanguageCode()) {
         clear_has_languageCode();
        _languageCode = 0u;
     }
}

inline bool LanguageVersion::hasLanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 LanguageVersion::getLanguageCode () const {
    return _languageCode;
}

inline void LanguageVersion::setLanguageCode (uint16 languageCode_) {
    set_has_languageCode();
    this->_languageCode = languageCode_;
}

inline void LanguageVersion::clearSpecificationVersion() {
    if (hasSpecificationVersion()) {
         clear_has_specificationVersion();
        _specificationVersion.clear();
     }
}

inline bool LanguageVersion::hasSpecificationVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LanguageVersion::getSpecificationVersion () const {
    return _specificationVersion;
}

inline ::std::string& LanguageVersion::getSpecificationVersionMutable () {
    set_has_specificationVersion();
    return _specificationVersion;
}

inline void LanguageVersion::setSpecificationVersion (const ::std::string& specificationVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (specificationVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_specificationVersion();
    this->_specificationVersion = specificationVersion_;
}

inline void LanguageVersion::setSpecificationVersion (const char* specificationVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (specificationVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_specificationVersion();
    this->_specificationVersion.assign(specificationVersion_);
}

inline void LanguageVersion::setSpecificationVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_specificationVersion();
    this->_specificationVersion.assign(value, size);
}

inline void LanguageVersion::set_has_languageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void LanguageVersion::clear_has_languageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LanguageVersion::set_has_specificationVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void LanguageVersion::clear_has_specificationVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PhoneticTraMetadata::PhoneticTraMetadata ()  :
    _phoneticTranscriptionFormat (::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA),
    _languageVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneticTraMetadata::PhoneticTraMetadata (const PhoneticTraMetadata &rhs)  :
    _phoneticTranscriptionFormat (::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA),
    _languageVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneticTraMetadata::PhoneticTraMetadata (PhoneticTranscriptionFormat phoneticTranscriptionFormat_, const ::std::vector< LanguageVersion >& languageVersionList_)  :
    _phoneticTranscriptionFormat (phoneticTranscriptionFormat_),
    _languageVersionList (languageVersionList_)
{
    #ifndef NDEBUG
    if (!(PhoneticTranscriptionFormat_IsValid(phoneticTranscriptionFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneticTranscriptionFormat_, "PhoneticTranscriptionFormat", "phoneticTranscriptionFormat", "PhoneticTraMetadata");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhoneticTraMetadata::~PhoneticTraMetadata() {
}

inline PhoneticTraMetadata& PhoneticTraMetadata::operator = (const PhoneticTraMetadata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPhoneticTranscriptionFormat()) {
            setPhoneticTranscriptionFormat(rhs.getPhoneticTranscriptionFormat());
        } else {
            clearPhoneticTranscriptionFormat();
        }
        if (rhs.hasLanguageVersionList()) {
            setLanguageVersionList(rhs.getLanguageVersionList());
        } else {
            clearLanguageVersionList();
        }
    }
    return *this;
}

inline bool PhoneticTraMetadata::operator == (const PhoneticTraMetadata& rhs) const {
    return (((!hasPhoneticTranscriptionFormat() && !rhs.hasPhoneticTranscriptionFormat()) || getPhoneticTranscriptionFormat() == rhs.getPhoneticTranscriptionFormat()) &&
        ((!hasLanguageVersionList() && !rhs.hasLanguageVersionList()) || getLanguageVersionList() == rhs.getLanguageVersionList()));
}

inline bool PhoneticTraMetadata::operator != (const PhoneticTraMetadata& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneticTraMetadata::operator < (const PhoneticTraMetadata& rhs) const {
    if (hasPhoneticTranscriptionFormat() || rhs.hasPhoneticTranscriptionFormat()) {
        if ((uint32)getPhoneticTranscriptionFormat() < (uint32)rhs.getPhoneticTranscriptionFormat()) return true;
        if ((uint32)getPhoneticTranscriptionFormat() > (uint32)rhs.getPhoneticTranscriptionFormat()) return false;
    }
    if (hasLanguageVersionList() || rhs.hasLanguageVersionList()) {
        if (getLanguageVersionList() < rhs.getLanguageVersionList()) return true;
        if (getLanguageVersionList() > rhs.getLanguageVersionList()) return false;
    }
    return false;
}

inline bool PhoneticTraMetadata::operator > (const PhoneticTraMetadata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneticTraMetadata::clear() {
    clearPhoneticTranscriptionFormat();
    clearLanguageVersionList();
}

inline void PhoneticTraMetadata::clearPhoneticTranscriptionFormat() {
    if (hasPhoneticTranscriptionFormat()) {
         clear_has_phoneticTranscriptionFormat();
        _phoneticTranscriptionFormat = ::org::bosch::cm::navigation::NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA;
     }
}

inline bool PhoneticTraMetadata::hasPhoneticTranscriptionFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline PhoneticTranscriptionFormat PhoneticTraMetadata::getPhoneticTranscriptionFormat () const {
    return _phoneticTranscriptionFormat;
}

inline void PhoneticTraMetadata::setPhoneticTranscriptionFormat (PhoneticTranscriptionFormat phoneticTranscriptionFormat_) {
    #ifndef NDEBUG
    if (!(PhoneticTranscriptionFormat_IsValid(phoneticTranscriptionFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneticTranscriptionFormat_, "PhoneticTranscriptionFormat", "phoneticTranscriptionFormat", "PhoneticTraMetadata");
    }
    #endif
    set_has_phoneticTranscriptionFormat();
    this->_phoneticTranscriptionFormat = phoneticTranscriptionFormat_;
}

inline void PhoneticTraMetadata::clearLanguageVersionList() {
    if (hasLanguageVersionList()) {
         clear_has_languageVersionList();
        _languageVersionList.clear();
     }
}

inline bool PhoneticTraMetadata::hasLanguageVersionList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< LanguageVersion >& PhoneticTraMetadata::getLanguageVersionList () const {
    return _languageVersionList;
}

inline ::std::vector< LanguageVersion >& PhoneticTraMetadata::getLanguageVersionListMutable () {
    set_has_languageVersionList();
    return _languageVersionList;
}

inline void PhoneticTraMetadata::setLanguageVersionList (const ::std::vector< LanguageVersion >& languageVersionList_) {
    set_has_languageVersionList();
    this->_languageVersionList = languageVersionList_;
}

inline void PhoneticTraMetadata::set_has_phoneticTranscriptionFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhoneticTraMetadata::clear_has_phoneticTranscriptionFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PhoneticTraMetadata::set_has_languageVersionList () {
    _has_bits_[0] |= 1u << 1;
}

inline void PhoneticTraMetadata::clear_has_languageVersionList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PrerecordedVMetadata::PrerecordedVMetadata ()  :
    _prerecordedVoiceFormat (::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat__ADPCM),
    _languageVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrerecordedVMetadata::PrerecordedVMetadata (const PrerecordedVMetadata &rhs)  :
    _prerecordedVoiceFormat (::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat__ADPCM),
    _languageVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrerecordedVMetadata::PrerecordedVMetadata (PrerecordedVoiceFormat prerecordedVoiceFormat_, const ::std::vector< LanguageVersion >& languageVersionList_)  :
    _prerecordedVoiceFormat (prerecordedVoiceFormat_),
    _languageVersionList (languageVersionList_)
{
    #ifndef NDEBUG
    if (!(PrerecordedVoiceFormat_IsValid(prerecordedVoiceFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", prerecordedVoiceFormat_, "PrerecordedVoiceFormat", "prerecordedVoiceFormat", "PrerecordedVMetadata");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrerecordedVMetadata::~PrerecordedVMetadata() {
}

inline PrerecordedVMetadata& PrerecordedVMetadata::operator = (const PrerecordedVMetadata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPrerecordedVoiceFormat()) {
            setPrerecordedVoiceFormat(rhs.getPrerecordedVoiceFormat());
        } else {
            clearPrerecordedVoiceFormat();
        }
        if (rhs.hasLanguageVersionList()) {
            setLanguageVersionList(rhs.getLanguageVersionList());
        } else {
            clearLanguageVersionList();
        }
    }
    return *this;
}

inline bool PrerecordedVMetadata::operator == (const PrerecordedVMetadata& rhs) const {
    return (((!hasPrerecordedVoiceFormat() && !rhs.hasPrerecordedVoiceFormat()) || getPrerecordedVoiceFormat() == rhs.getPrerecordedVoiceFormat()) &&
        ((!hasLanguageVersionList() && !rhs.hasLanguageVersionList()) || getLanguageVersionList() == rhs.getLanguageVersionList()));
}

inline bool PrerecordedVMetadata::operator != (const PrerecordedVMetadata& rhs) const {
    return ! (*this == rhs);
}

inline bool PrerecordedVMetadata::operator < (const PrerecordedVMetadata& rhs) const {
    if (hasPrerecordedVoiceFormat() || rhs.hasPrerecordedVoiceFormat()) {
        if ((uint32)getPrerecordedVoiceFormat() < (uint32)rhs.getPrerecordedVoiceFormat()) return true;
        if ((uint32)getPrerecordedVoiceFormat() > (uint32)rhs.getPrerecordedVoiceFormat()) return false;
    }
    if (hasLanguageVersionList() || rhs.hasLanguageVersionList()) {
        if (getLanguageVersionList() < rhs.getLanguageVersionList()) return true;
        if (getLanguageVersionList() > rhs.getLanguageVersionList()) return false;
    }
    return false;
}

inline bool PrerecordedVMetadata::operator > (const PrerecordedVMetadata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrerecordedVMetadata::clear() {
    clearPrerecordedVoiceFormat();
    clearLanguageVersionList();
}

inline void PrerecordedVMetadata::clearPrerecordedVoiceFormat() {
    if (hasPrerecordedVoiceFormat()) {
         clear_has_prerecordedVoiceFormat();
        _prerecordedVoiceFormat = ::org::bosch::cm::navigation::NavigationSDSService::PrerecordedVoiceFormat__ADPCM;
     }
}

inline bool PrerecordedVMetadata::hasPrerecordedVoiceFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline PrerecordedVoiceFormat PrerecordedVMetadata::getPrerecordedVoiceFormat () const {
    return _prerecordedVoiceFormat;
}

inline void PrerecordedVMetadata::setPrerecordedVoiceFormat (PrerecordedVoiceFormat prerecordedVoiceFormat_) {
    #ifndef NDEBUG
    if (!(PrerecordedVoiceFormat_IsValid(prerecordedVoiceFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", prerecordedVoiceFormat_, "PrerecordedVoiceFormat", "prerecordedVoiceFormat", "PrerecordedVMetadata");
    }
    #endif
    set_has_prerecordedVoiceFormat();
    this->_prerecordedVoiceFormat = prerecordedVoiceFormat_;
}

inline void PrerecordedVMetadata::clearLanguageVersionList() {
    if (hasLanguageVersionList()) {
         clear_has_languageVersionList();
        _languageVersionList.clear();
     }
}

inline bool PrerecordedVMetadata::hasLanguageVersionList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< LanguageVersion >& PrerecordedVMetadata::getLanguageVersionList () const {
    return _languageVersionList;
}

inline ::std::vector< LanguageVersion >& PrerecordedVMetadata::getLanguageVersionListMutable () {
    set_has_languageVersionList();
    return _languageVersionList;
}

inline void PrerecordedVMetadata::setLanguageVersionList (const ::std::vector< LanguageVersion >& languageVersionList_) {
    set_has_languageVersionList();
    this->_languageVersionList = languageVersionList_;
}

inline void PrerecordedVMetadata::set_has_prerecordedVoiceFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrerecordedVMetadata::clear_has_prerecordedVoiceFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PrerecordedVMetadata::set_has_languageVersionList () {
    _has_bits_[0] |= 1u << 1;
}

inline void PrerecordedVMetadata::clear_has_languageVersionList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SpeechMetadata::SpeechMetadata ()  :
    _hasPhonetic (false),
    _hasPrerecorded (false),
    _phoneticTraMetadata (),
    _prerecordedVMetadata ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechMetadata::SpeechMetadata (const SpeechMetadata &rhs)  :
    _hasPhonetic (false),
    _hasPrerecorded (false),
    _phoneticTraMetadata (),
    _prerecordedVMetadata ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechMetadata::SpeechMetadata (bool hasPhonetic_, bool hasPrerecorded_, const PhoneticTraMetadata& phoneticTraMetadata_, const PrerecordedVMetadata& prerecordedVMetadata_)  :
    _hasPhonetic (hasPhonetic_),
    _hasPrerecorded (hasPrerecorded_),
    _phoneticTraMetadata (phoneticTraMetadata_),
    _prerecordedVMetadata (prerecordedVMetadata_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechMetadata::~SpeechMetadata() {
}

inline SpeechMetadata& SpeechMetadata::operator = (const SpeechMetadata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHasPhonetic()) {
            setHasPhonetic(rhs.getHasPhonetic());
        } else {
            clearHasPhonetic();
        }
        if (rhs.hasHasPrerecorded()) {
            setHasPrerecorded(rhs.getHasPrerecorded());
        } else {
            clearHasPrerecorded();
        }
        if (rhs.hasPhoneticTraMetadata()) {
            setPhoneticTraMetadata(rhs.getPhoneticTraMetadata());
        } else {
            clearPhoneticTraMetadata();
        }
        if (rhs.hasPrerecordedVMetadata()) {
            setPrerecordedVMetadata(rhs.getPrerecordedVMetadata());
        } else {
            clearPrerecordedVMetadata();
        }
    }
    return *this;
}

inline bool SpeechMetadata::operator == (const SpeechMetadata& rhs) const {
    return (((!hasHasPhonetic() && !rhs.hasHasPhonetic()) || getHasPhonetic() == rhs.getHasPhonetic()) &&
        ((!hasHasPrerecorded() && !rhs.hasHasPrerecorded()) || getHasPrerecorded() == rhs.getHasPrerecorded()) &&
        ((!hasPhoneticTraMetadata() && !rhs.hasPhoneticTraMetadata()) || getPhoneticTraMetadata() == rhs.getPhoneticTraMetadata()) &&
        ((!hasPrerecordedVMetadata() && !rhs.hasPrerecordedVMetadata()) || getPrerecordedVMetadata() == rhs.getPrerecordedVMetadata()));
}

inline bool SpeechMetadata::operator != (const SpeechMetadata& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechMetadata::operator < (const SpeechMetadata& rhs) const {
    if (hasHasPhonetic() || rhs.hasHasPhonetic()) {
        if (getHasPhonetic() < rhs.getHasPhonetic()) return true;
        if (getHasPhonetic() > rhs.getHasPhonetic()) return false;
    }
    if (hasHasPrerecorded() || rhs.hasHasPrerecorded()) {
        if (getHasPrerecorded() < rhs.getHasPrerecorded()) return true;
        if (getHasPrerecorded() > rhs.getHasPrerecorded()) return false;
    }
    if (hasPhoneticTraMetadata() || rhs.hasPhoneticTraMetadata()) {
        if (getPhoneticTraMetadata() < rhs.getPhoneticTraMetadata()) return true;
        if (getPhoneticTraMetadata() > rhs.getPhoneticTraMetadata()) return false;
    }
    if (hasPrerecordedVMetadata() || rhs.hasPrerecordedVMetadata()) {
        if (getPrerecordedVMetadata() < rhs.getPrerecordedVMetadata()) return true;
        if (getPrerecordedVMetadata() > rhs.getPrerecordedVMetadata()) return false;
    }
    return false;
}

inline bool SpeechMetadata::operator > (const SpeechMetadata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechMetadata::clear() {
    clearHasPhonetic();
    clearHasPrerecorded();
    clearPhoneticTraMetadata();
    clearPrerecordedVMetadata();
}

inline void SpeechMetadata::clearHasPhonetic() {
    if (hasHasPhonetic()) {
         clear_has_hasPhonetic();
        _hasPhonetic = false;
     }
}

inline bool SpeechMetadata::hasHasPhonetic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SpeechMetadata::getHasPhonetic () const {
    return _hasPhonetic;
}

inline void SpeechMetadata::setHasPhonetic (bool hasPhonetic_) {
    set_has_hasPhonetic();
    this->_hasPhonetic = hasPhonetic_;
}

inline void SpeechMetadata::clearHasPrerecorded() {
    if (hasHasPrerecorded()) {
         clear_has_hasPrerecorded();
        _hasPrerecorded = false;
     }
}

inline bool SpeechMetadata::hasHasPrerecorded () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SpeechMetadata::getHasPrerecorded () const {
    return _hasPrerecorded;
}

inline void SpeechMetadata::setHasPrerecorded (bool hasPrerecorded_) {
    set_has_hasPrerecorded();
    this->_hasPrerecorded = hasPrerecorded_;
}

inline void SpeechMetadata::clearPhoneticTraMetadata() {
    if (hasPhoneticTraMetadata()) {
         clear_has_phoneticTraMetadata();
        _phoneticTraMetadata.clear();
     }
}

inline bool SpeechMetadata::hasPhoneticTraMetadata () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const PhoneticTraMetadata& SpeechMetadata::getPhoneticTraMetadata () const {
    return _phoneticTraMetadata;
}

inline PhoneticTraMetadata& SpeechMetadata::getPhoneticTraMetadataMutable () {
    set_has_phoneticTraMetadata();
    return _phoneticTraMetadata;
}

inline void SpeechMetadata::setPhoneticTraMetadata (const PhoneticTraMetadata& phoneticTraMetadata_) {
    set_has_phoneticTraMetadata();
    this->_phoneticTraMetadata = phoneticTraMetadata_;
}

inline void SpeechMetadata::clearPrerecordedVMetadata() {
    if (hasPrerecordedVMetadata()) {
         clear_has_prerecordedVMetadata();
        _prerecordedVMetadata.clear();
     }
}

inline bool SpeechMetadata::hasPrerecordedVMetadata () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const PrerecordedVMetadata& SpeechMetadata::getPrerecordedVMetadata () const {
    return _prerecordedVMetadata;
}

inline PrerecordedVMetadata& SpeechMetadata::getPrerecordedVMetadataMutable () {
    set_has_prerecordedVMetadata();
    return _prerecordedVMetadata;
}

inline void SpeechMetadata::setPrerecordedVMetadata (const PrerecordedVMetadata& prerecordedVMetadata_) {
    set_has_prerecordedVMetadata();
    this->_prerecordedVMetadata = prerecordedVMetadata_;
}

inline void SpeechMetadata::set_has_hasPhonetic () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechMetadata::clear_has_hasPhonetic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SpeechMetadata::set_has_hasPrerecorded () {
    _has_bits_[0] |= 1u << 1;
}

inline void SpeechMetadata::clear_has_hasPrerecorded () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SpeechMetadata::set_has_phoneticTraMetadata () {
    _has_bits_[0] |= 1u << 2;
}

inline void SpeechMetadata::clear_has_phoneticTraMetadata () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SpeechMetadata::set_has_prerecordedVMetadata () {
    _has_bits_[0] |= 1u << 3;
}

inline void SpeechMetadata::clear_has_prerecordedVMetadata () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SdsBuildingBlocks::SdsBuildingBlocks ()  :
    _buildingBlockId (0u),
    _ndsBuildingBlockType (::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType__SPEECH),
    _uri (),
    _encryptionKeyId (0u),
    _speechMetadata (),
    _typeNdsDbSupplierId (0u),
    _typeExtId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsBuildingBlocks::SdsBuildingBlocks (const SdsBuildingBlocks &rhs)  :
    _buildingBlockId (0u),
    _ndsBuildingBlockType (::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType__SPEECH),
    _uri (),
    _encryptionKeyId (0u),
    _speechMetadata (),
    _typeNdsDbSupplierId (0u),
    _typeExtId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsBuildingBlocks::SdsBuildingBlocks (uint16 buildingBlockId_, NDSBuildingBlockType ndsBuildingBlockType_, const ::std::string& uri_, uint32 encryptionKeyId_, const SpeechMetadata& speechMetadata_, uint8 typeNdsDbSupplierId_, uint32 typeExtId_)  :
    _buildingBlockId (buildingBlockId_),
    _ndsBuildingBlockType (ndsBuildingBlockType_),
    _uri (uri_),
    _encryptionKeyId (encryptionKeyId_),
    _speechMetadata (speechMetadata_),
    _typeNdsDbSupplierId (typeNdsDbSupplierId_),
    _typeExtId (typeExtId_)
{
    #ifndef NDEBUG
    if (!(NDSBuildingBlockType_IsValid(ndsBuildingBlockType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsBuildingBlockType_, "NDSBuildingBlockType", "ndsBuildingBlockType", "SdsBuildingBlocks");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uri_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsBuildingBlocks::~SdsBuildingBlocks() {
}

inline SdsBuildingBlocks& SdsBuildingBlocks::operator = (const SdsBuildingBlocks& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBuildingBlockId()) {
            setBuildingBlockId(rhs.getBuildingBlockId());
        } else {
            clearBuildingBlockId();
        }
        if (rhs.hasNdsBuildingBlockType()) {
            setNdsBuildingBlockType(rhs.getNdsBuildingBlockType());
        } else {
            clearNdsBuildingBlockType();
        }
        if (rhs.hasUri()) {
            setUri(rhs.getUri());
        } else {
            clearUri();
        }
        if (rhs.hasEncryptionKeyId()) {
            setEncryptionKeyId(rhs.getEncryptionKeyId());
        } else {
            clearEncryptionKeyId();
        }
        if (rhs.hasSpeechMetadata()) {
            setSpeechMetadata(rhs.getSpeechMetadata());
        } else {
            clearSpeechMetadata();
        }
        if (rhs.hasTypeNdsDbSupplierId()) {
            setTypeNdsDbSupplierId(rhs.getTypeNdsDbSupplierId());
        } else {
            clearTypeNdsDbSupplierId();
        }
        if (rhs.hasTypeExtId()) {
            setTypeExtId(rhs.getTypeExtId());
        } else {
            clearTypeExtId();
        }
    }
    return *this;
}

inline bool SdsBuildingBlocks::operator == (const SdsBuildingBlocks& rhs) const {
    return (((!hasBuildingBlockId() && !rhs.hasBuildingBlockId()) || getBuildingBlockId() == rhs.getBuildingBlockId()) &&
        ((!hasNdsBuildingBlockType() && !rhs.hasNdsBuildingBlockType()) || getNdsBuildingBlockType() == rhs.getNdsBuildingBlockType()) &&
        ((!hasUri() && !rhs.hasUri()) || getUri() == rhs.getUri()) &&
        ((!hasEncryptionKeyId() && !rhs.hasEncryptionKeyId()) || getEncryptionKeyId() == rhs.getEncryptionKeyId()) &&
        ((!hasSpeechMetadata() && !rhs.hasSpeechMetadata()) || getSpeechMetadata() == rhs.getSpeechMetadata()) &&
        ((!hasTypeNdsDbSupplierId() && !rhs.hasTypeNdsDbSupplierId()) || getTypeNdsDbSupplierId() == rhs.getTypeNdsDbSupplierId()) &&
        ((!hasTypeExtId() && !rhs.hasTypeExtId()) || getTypeExtId() == rhs.getTypeExtId()));
}

inline bool SdsBuildingBlocks::operator != (const SdsBuildingBlocks& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsBuildingBlocks::operator < (const SdsBuildingBlocks& rhs) const {
    if (hasBuildingBlockId() || rhs.hasBuildingBlockId()) {
        if (getBuildingBlockId() < rhs.getBuildingBlockId()) return true;
        if (getBuildingBlockId() > rhs.getBuildingBlockId()) return false;
    }
    if (hasNdsBuildingBlockType() || rhs.hasNdsBuildingBlockType()) {
        if ((uint32)getNdsBuildingBlockType() < (uint32)rhs.getNdsBuildingBlockType()) return true;
        if ((uint32)getNdsBuildingBlockType() > (uint32)rhs.getNdsBuildingBlockType()) return false;
    }
    if (hasUri() || rhs.hasUri()) {
        if (getUri() < rhs.getUri()) return true;
        if (getUri() > rhs.getUri()) return false;
    }
    if (hasEncryptionKeyId() || rhs.hasEncryptionKeyId()) {
        if (getEncryptionKeyId() < rhs.getEncryptionKeyId()) return true;
        if (getEncryptionKeyId() > rhs.getEncryptionKeyId()) return false;
    }
    if (hasSpeechMetadata() || rhs.hasSpeechMetadata()) {
        if (getSpeechMetadata() < rhs.getSpeechMetadata()) return true;
        if (getSpeechMetadata() > rhs.getSpeechMetadata()) return false;
    }
    if (hasTypeNdsDbSupplierId() || rhs.hasTypeNdsDbSupplierId()) {
        if (getTypeNdsDbSupplierId() < rhs.getTypeNdsDbSupplierId()) return true;
        if (getTypeNdsDbSupplierId() > rhs.getTypeNdsDbSupplierId()) return false;
    }
    if (hasTypeExtId() || rhs.hasTypeExtId()) {
        if (getTypeExtId() < rhs.getTypeExtId()) return true;
        if (getTypeExtId() > rhs.getTypeExtId()) return false;
    }
    return false;
}

inline bool SdsBuildingBlocks::operator > (const SdsBuildingBlocks& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsBuildingBlocks::clear() {
    clearBuildingBlockId();
    clearNdsBuildingBlockType();
    clearUri();
    clearEncryptionKeyId();
    clearSpeechMetadata();
    clearTypeNdsDbSupplierId();
    clearTypeExtId();
}

inline void SdsBuildingBlocks::clearBuildingBlockId() {
    if (hasBuildingBlockId()) {
         clear_has_buildingBlockId();
        _buildingBlockId = 0u;
     }
}

inline bool SdsBuildingBlocks::hasBuildingBlockId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SdsBuildingBlocks::getBuildingBlockId () const {
    return _buildingBlockId;
}

inline void SdsBuildingBlocks::setBuildingBlockId (uint16 buildingBlockId_) {
    set_has_buildingBlockId();
    this->_buildingBlockId = buildingBlockId_;
}

inline void SdsBuildingBlocks::clearNdsBuildingBlockType() {
    if (hasNdsBuildingBlockType()) {
         clear_has_ndsBuildingBlockType();
        _ndsBuildingBlockType = ::org::bosch::cm::navigation::NavigationSDSService::NDSBuildingBlockType__SPEECH;
     }
}

inline bool SdsBuildingBlocks::hasNdsBuildingBlockType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline NDSBuildingBlockType SdsBuildingBlocks::getNdsBuildingBlockType () const {
    return _ndsBuildingBlockType;
}

inline void SdsBuildingBlocks::setNdsBuildingBlockType (NDSBuildingBlockType ndsBuildingBlockType_) {
    #ifndef NDEBUG
    if (!(NDSBuildingBlockType_IsValid(ndsBuildingBlockType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsBuildingBlockType_, "NDSBuildingBlockType", "ndsBuildingBlockType", "SdsBuildingBlocks");
    }
    #endif
    set_has_ndsBuildingBlockType();
    this->_ndsBuildingBlockType = ndsBuildingBlockType_;
}

inline void SdsBuildingBlocks::clearUri() {
    if (hasUri()) {
         clear_has_uri();
        _uri.clear();
     }
}

inline bool SdsBuildingBlocks::hasUri () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SdsBuildingBlocks::getUri () const {
    return _uri;
}

inline ::std::string& SdsBuildingBlocks::getUriMutable () {
    set_has_uri();
    return _uri;
}

inline void SdsBuildingBlocks::setUri (const ::std::string& uri_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uri_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uri();
    this->_uri = uri_;
}

inline void SdsBuildingBlocks::setUri (const char* uri_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uri_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uri();
    this->_uri.assign(uri_);
}

inline void SdsBuildingBlocks::setUri (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uri();
    this->_uri.assign(value, size);
}

inline void SdsBuildingBlocks::clearEncryptionKeyId() {
    if (hasEncryptionKeyId()) {
         clear_has_encryptionKeyId();
        _encryptionKeyId = 0u;
     }
}

inline bool SdsBuildingBlocks::hasEncryptionKeyId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 SdsBuildingBlocks::getEncryptionKeyId () const {
    return _encryptionKeyId;
}

inline void SdsBuildingBlocks::setEncryptionKeyId (uint32 encryptionKeyId_) {
    set_has_encryptionKeyId();
    this->_encryptionKeyId = encryptionKeyId_;
}

inline void SdsBuildingBlocks::clearSpeechMetadata() {
    if (hasSpeechMetadata()) {
         clear_has_speechMetadata();
        _speechMetadata.clear();
     }
}

inline bool SdsBuildingBlocks::hasSpeechMetadata () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const SpeechMetadata& SdsBuildingBlocks::getSpeechMetadata () const {
    return _speechMetadata;
}

inline SpeechMetadata& SdsBuildingBlocks::getSpeechMetadataMutable () {
    set_has_speechMetadata();
    return _speechMetadata;
}

inline void SdsBuildingBlocks::setSpeechMetadata (const SpeechMetadata& speechMetadata_) {
    set_has_speechMetadata();
    this->_speechMetadata = speechMetadata_;
}

inline void SdsBuildingBlocks::clearTypeNdsDbSupplierId() {
    if (hasTypeNdsDbSupplierId()) {
         clear_has_typeNdsDbSupplierId();
        _typeNdsDbSupplierId = 0u;
     }
}

inline bool SdsBuildingBlocks::hasTypeNdsDbSupplierId () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 SdsBuildingBlocks::getTypeNdsDbSupplierId () const {
    return _typeNdsDbSupplierId;
}

inline void SdsBuildingBlocks::setTypeNdsDbSupplierId (uint8 typeNdsDbSupplierId_) {
    set_has_typeNdsDbSupplierId();
    this->_typeNdsDbSupplierId = typeNdsDbSupplierId_;
}

inline void SdsBuildingBlocks::clearTypeExtId() {
    if (hasTypeExtId()) {
         clear_has_typeExtId();
        _typeExtId = 0u;
     }
}

inline bool SdsBuildingBlocks::hasTypeExtId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 SdsBuildingBlocks::getTypeExtId () const {
    return _typeExtId;
}

inline void SdsBuildingBlocks::setTypeExtId (uint32 typeExtId_) {
    set_has_typeExtId();
    this->_typeExtId = typeExtId_;
}

inline void SdsBuildingBlocks::set_has_buildingBlockId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsBuildingBlocks::clear_has_buildingBlockId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsBuildingBlocks::set_has_ndsBuildingBlockType () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsBuildingBlocks::clear_has_ndsBuildingBlockType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsBuildingBlocks::set_has_uri () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsBuildingBlocks::clear_has_uri () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SdsBuildingBlocks::set_has_encryptionKeyId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SdsBuildingBlocks::clear_has_encryptionKeyId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SdsBuildingBlocks::set_has_speechMetadata () {
    _has_bits_[0] |= 1u << 4;
}

inline void SdsBuildingBlocks::clear_has_speechMetadata () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SdsBuildingBlocks::set_has_typeNdsDbSupplierId () {
    _has_bits_[0] |= 1u << 5;
}

inline void SdsBuildingBlocks::clear_has_typeNdsDbSupplierId () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void SdsBuildingBlocks::set_has_typeExtId () {
    _has_bits_[0] |= 1u << 6;
}

inline void SdsBuildingBlocks::clear_has_typeExtId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  SdsRegionMetadata::SdsRegionMetadata ()  :
    _updateRegionId (0u),
    _isoCountryCodeText (),
    _isoSubCountryCodeText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsRegionMetadata::SdsRegionMetadata (const SdsRegionMetadata &rhs)  :
    _updateRegionId (0u),
    _isoCountryCodeText (),
    _isoSubCountryCodeText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsRegionMetadata::SdsRegionMetadata (uint16 updateRegionId_, const ::std::string& isoCountryCodeText_, const ::std::string& isoSubCountryCodeText_)  :
    _updateRegionId (updateRegionId_),
    _isoCountryCodeText (isoCountryCodeText_),
    _isoSubCountryCodeText (isoSubCountryCodeText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoSubCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsRegionMetadata::~SdsRegionMetadata() {
}

inline SdsRegionMetadata& SdsRegionMetadata::operator = (const SdsRegionMetadata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateRegionId()) {
            setUpdateRegionId(rhs.getUpdateRegionId());
        } else {
            clearUpdateRegionId();
        }
        if (rhs.hasIsoCountryCodeText()) {
            setIsoCountryCodeText(rhs.getIsoCountryCodeText());
        } else {
            clearIsoCountryCodeText();
        }
        if (rhs.hasIsoSubCountryCodeText()) {
            setIsoSubCountryCodeText(rhs.getIsoSubCountryCodeText());
        } else {
            clearIsoSubCountryCodeText();
        }
    }
    return *this;
}

inline bool SdsRegionMetadata::operator == (const SdsRegionMetadata& rhs) const {
    return (((!hasUpdateRegionId() && !rhs.hasUpdateRegionId()) || getUpdateRegionId() == rhs.getUpdateRegionId()) &&
        ((!hasIsoCountryCodeText() && !rhs.hasIsoCountryCodeText()) || getIsoCountryCodeText() == rhs.getIsoCountryCodeText()) &&
        ((!hasIsoSubCountryCodeText() && !rhs.hasIsoSubCountryCodeText()) || getIsoSubCountryCodeText() == rhs.getIsoSubCountryCodeText()));
}

inline bool SdsRegionMetadata::operator != (const SdsRegionMetadata& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsRegionMetadata::operator < (const SdsRegionMetadata& rhs) const {
    if (hasUpdateRegionId() || rhs.hasUpdateRegionId()) {
        if (getUpdateRegionId() < rhs.getUpdateRegionId()) return true;
        if (getUpdateRegionId() > rhs.getUpdateRegionId()) return false;
    }
    if (hasIsoCountryCodeText() || rhs.hasIsoCountryCodeText()) {
        if (getIsoCountryCodeText() < rhs.getIsoCountryCodeText()) return true;
        if (getIsoCountryCodeText() > rhs.getIsoCountryCodeText()) return false;
    }
    if (hasIsoSubCountryCodeText() || rhs.hasIsoSubCountryCodeText()) {
        if (getIsoSubCountryCodeText() < rhs.getIsoSubCountryCodeText()) return true;
        if (getIsoSubCountryCodeText() > rhs.getIsoSubCountryCodeText()) return false;
    }
    return false;
}

inline bool SdsRegionMetadata::operator > (const SdsRegionMetadata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsRegionMetadata::clear() {
    clearUpdateRegionId();
    clearIsoCountryCodeText();
    clearIsoSubCountryCodeText();
}

inline void SdsRegionMetadata::clearUpdateRegionId() {
    if (hasUpdateRegionId()) {
         clear_has_updateRegionId();
        _updateRegionId = 0u;
     }
}

inline bool SdsRegionMetadata::hasUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SdsRegionMetadata::getUpdateRegionId () const {
    return _updateRegionId;
}

inline void SdsRegionMetadata::setUpdateRegionId (uint16 updateRegionId_) {
    set_has_updateRegionId();
    this->_updateRegionId = updateRegionId_;
}

inline void SdsRegionMetadata::clearIsoCountryCodeText() {
    if (hasIsoCountryCodeText()) {
         clear_has_isoCountryCodeText();
        _isoCountryCodeText.clear();
     }
}

inline bool SdsRegionMetadata::hasIsoCountryCodeText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SdsRegionMetadata::getIsoCountryCodeText () const {
    return _isoCountryCodeText;
}

inline ::std::string& SdsRegionMetadata::getIsoCountryCodeTextMutable () {
    set_has_isoCountryCodeText();
    return _isoCountryCodeText;
}

inline void SdsRegionMetadata::setIsoCountryCodeText (const ::std::string& isoCountryCodeText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCodeText();
    this->_isoCountryCodeText = isoCountryCodeText_;
}

inline void SdsRegionMetadata::setIsoCountryCodeText (const char* isoCountryCodeText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCodeText();
    this->_isoCountryCodeText.assign(isoCountryCodeText_);
}

inline void SdsRegionMetadata::setIsoCountryCodeText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCodeText();
    this->_isoCountryCodeText.assign(value, size);
}

inline void SdsRegionMetadata::clearIsoSubCountryCodeText() {
    if (hasIsoSubCountryCodeText()) {
         clear_has_isoSubCountryCodeText();
        _isoSubCountryCodeText.clear();
     }
}

inline bool SdsRegionMetadata::hasIsoSubCountryCodeText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SdsRegionMetadata::getIsoSubCountryCodeText () const {
    return _isoSubCountryCodeText;
}

inline ::std::string& SdsRegionMetadata::getIsoSubCountryCodeTextMutable () {
    set_has_isoSubCountryCodeText();
    return _isoSubCountryCodeText;
}

inline void SdsRegionMetadata::setIsoSubCountryCodeText (const ::std::string& isoSubCountryCodeText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoSubCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoSubCountryCodeText();
    this->_isoSubCountryCodeText = isoSubCountryCodeText_;
}

inline void SdsRegionMetadata::setIsoSubCountryCodeText (const char* isoSubCountryCodeText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoSubCountryCodeText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoSubCountryCodeText();
    this->_isoSubCountryCodeText.assign(isoSubCountryCodeText_);
}

inline void SdsRegionMetadata::setIsoSubCountryCodeText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoSubCountryCodeText();
    this->_isoSubCountryCodeText.assign(value, size);
}

inline void SdsRegionMetadata::set_has_updateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsRegionMetadata::clear_has_updateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsRegionMetadata::set_has_isoCountryCodeText () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsRegionMetadata::clear_has_isoCountryCodeText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsRegionMetadata::set_has_isoSubCountryCodeText () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsRegionMetadata::clear_has_isoSubCountryCodeText () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SdsUpdateRegions::SdsUpdateRegions ()  :
    _updateRegionId (0u),
    _sdsBuildingBlocksList (),
    _sdsRegionMetadataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsUpdateRegions::SdsUpdateRegions (const SdsUpdateRegions &rhs)  :
    _updateRegionId (0u),
    _sdsBuildingBlocksList (),
    _sdsRegionMetadataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsUpdateRegions::SdsUpdateRegions (uint16 updateRegionId_, const ::std::vector< SdsBuildingBlocks >& sdsBuildingBlocksList_, const ::std::vector< SdsRegionMetadata >& sdsRegionMetadataList_)  :
    _updateRegionId (updateRegionId_),
    _sdsBuildingBlocksList (sdsBuildingBlocksList_),
    _sdsRegionMetadataList (sdsRegionMetadataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsUpdateRegions::~SdsUpdateRegions() {
}

inline SdsUpdateRegions& SdsUpdateRegions::operator = (const SdsUpdateRegions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateRegionId()) {
            setUpdateRegionId(rhs.getUpdateRegionId());
        } else {
            clearUpdateRegionId();
        }
        if (rhs.hasSdsBuildingBlocksList()) {
            setSdsBuildingBlocksList(rhs.getSdsBuildingBlocksList());
        } else {
            clearSdsBuildingBlocksList();
        }
        if (rhs.hasSdsRegionMetadataList()) {
            setSdsRegionMetadataList(rhs.getSdsRegionMetadataList());
        } else {
            clearSdsRegionMetadataList();
        }
    }
    return *this;
}

inline bool SdsUpdateRegions::operator == (const SdsUpdateRegions& rhs) const {
    return (((!hasUpdateRegionId() && !rhs.hasUpdateRegionId()) || getUpdateRegionId() == rhs.getUpdateRegionId()) &&
        ((!hasSdsBuildingBlocksList() && !rhs.hasSdsBuildingBlocksList()) || getSdsBuildingBlocksList() == rhs.getSdsBuildingBlocksList()) &&
        ((!hasSdsRegionMetadataList() && !rhs.hasSdsRegionMetadataList()) || getSdsRegionMetadataList() == rhs.getSdsRegionMetadataList()));
}

inline bool SdsUpdateRegions::operator != (const SdsUpdateRegions& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsUpdateRegions::operator < (const SdsUpdateRegions& rhs) const {
    if (hasUpdateRegionId() || rhs.hasUpdateRegionId()) {
        if (getUpdateRegionId() < rhs.getUpdateRegionId()) return true;
        if (getUpdateRegionId() > rhs.getUpdateRegionId()) return false;
    }
    if (hasSdsBuildingBlocksList() || rhs.hasSdsBuildingBlocksList()) {
        if (getSdsBuildingBlocksList() < rhs.getSdsBuildingBlocksList()) return true;
        if (getSdsBuildingBlocksList() > rhs.getSdsBuildingBlocksList()) return false;
    }
    if (hasSdsRegionMetadataList() || rhs.hasSdsRegionMetadataList()) {
        if (getSdsRegionMetadataList() < rhs.getSdsRegionMetadataList()) return true;
        if (getSdsRegionMetadataList() > rhs.getSdsRegionMetadataList()) return false;
    }
    return false;
}

inline bool SdsUpdateRegions::operator > (const SdsUpdateRegions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsUpdateRegions::clear() {
    clearUpdateRegionId();
    clearSdsBuildingBlocksList();
    clearSdsRegionMetadataList();
}

inline void SdsUpdateRegions::clearUpdateRegionId() {
    if (hasUpdateRegionId()) {
         clear_has_updateRegionId();
        _updateRegionId = 0u;
     }
}

inline bool SdsUpdateRegions::hasUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SdsUpdateRegions::getUpdateRegionId () const {
    return _updateRegionId;
}

inline void SdsUpdateRegions::setUpdateRegionId (uint16 updateRegionId_) {
    set_has_updateRegionId();
    this->_updateRegionId = updateRegionId_;
}

inline void SdsUpdateRegions::clearSdsBuildingBlocksList() {
    if (hasSdsBuildingBlocksList()) {
         clear_has_sdsBuildingBlocksList();
        _sdsBuildingBlocksList.clear();
     }
}

inline bool SdsUpdateRegions::hasSdsBuildingBlocksList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SdsBuildingBlocks >& SdsUpdateRegions::getSdsBuildingBlocksList () const {
    return _sdsBuildingBlocksList;
}

inline ::std::vector< SdsBuildingBlocks >& SdsUpdateRegions::getSdsBuildingBlocksListMutable () {
    set_has_sdsBuildingBlocksList();
    return _sdsBuildingBlocksList;
}

inline void SdsUpdateRegions::setSdsBuildingBlocksList (const ::std::vector< SdsBuildingBlocks >& sdsBuildingBlocksList_) {
    set_has_sdsBuildingBlocksList();
    this->_sdsBuildingBlocksList = sdsBuildingBlocksList_;
}

inline void SdsUpdateRegions::clearSdsRegionMetadataList() {
    if (hasSdsRegionMetadataList()) {
         clear_has_sdsRegionMetadataList();
        _sdsRegionMetadataList.clear();
     }
}

inline bool SdsUpdateRegions::hasSdsRegionMetadataList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< SdsRegionMetadata >& SdsUpdateRegions::getSdsRegionMetadataList () const {
    return _sdsRegionMetadataList;
}

inline ::std::vector< SdsRegionMetadata >& SdsUpdateRegions::getSdsRegionMetadataListMutable () {
    set_has_sdsRegionMetadataList();
    return _sdsRegionMetadataList;
}

inline void SdsUpdateRegions::setSdsRegionMetadataList (const ::std::vector< SdsRegionMetadata >& sdsRegionMetadataList_) {
    set_has_sdsRegionMetadataList();
    this->_sdsRegionMetadataList = sdsRegionMetadataList_;
}

inline void SdsUpdateRegions::set_has_updateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsUpdateRegions::clear_has_updateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsUpdateRegions::set_has_sdsBuildingBlocksList () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsUpdateRegions::clear_has_sdsBuildingBlocksList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsUpdateRegions::set_has_sdsRegionMetadataList () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsUpdateRegions::clear_has_sdsRegionMetadataList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  LanguageEntry::LanguageEntry ()  :
    _iSOLanguageCode (),
    _iSOCountryCode (),
    _transcriptCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LanguageEntry::LanguageEntry (const LanguageEntry &rhs)  :
    _iSOLanguageCode (),
    _iSOCountryCode (),
    _transcriptCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LanguageEntry::LanguageEntry (const ::std::string& iSOLanguageCode_, const ::std::string& iSOCountryCode_, const ::std::string& transcriptCode_)  :
    _iSOLanguageCode (iSOLanguageCode_),
    _iSOCountryCode (iSOCountryCode_),
    _transcriptCode (transcriptCode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transcriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LanguageEntry::~LanguageEntry() {
}

inline LanguageEntry& LanguageEntry::operator = (const LanguageEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasISOLanguageCode()) {
            setISOLanguageCode(rhs.getISOLanguageCode());
        } else {
            clearISOLanguageCode();
        }
        if (rhs.hasISOCountryCode()) {
            setISOCountryCode(rhs.getISOCountryCode());
        } else {
            clearISOCountryCode();
        }
        if (rhs.hasTranscriptCode()) {
            setTranscriptCode(rhs.getTranscriptCode());
        } else {
            clearTranscriptCode();
        }
    }
    return *this;
}

inline bool LanguageEntry::operator == (const LanguageEntry& rhs) const {
    return (((!hasISOLanguageCode() && !rhs.hasISOLanguageCode()) || getISOLanguageCode() == rhs.getISOLanguageCode()) &&
        ((!hasISOCountryCode() && !rhs.hasISOCountryCode()) || getISOCountryCode() == rhs.getISOCountryCode()) &&
        ((!hasTranscriptCode() && !rhs.hasTranscriptCode()) || getTranscriptCode() == rhs.getTranscriptCode()));
}

inline bool LanguageEntry::operator != (const LanguageEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool LanguageEntry::operator < (const LanguageEntry& rhs) const {
    if (hasISOLanguageCode() || rhs.hasISOLanguageCode()) {
        if (getISOLanguageCode() < rhs.getISOLanguageCode()) return true;
        if (getISOLanguageCode() > rhs.getISOLanguageCode()) return false;
    }
    if (hasISOCountryCode() || rhs.hasISOCountryCode()) {
        if (getISOCountryCode() < rhs.getISOCountryCode()) return true;
        if (getISOCountryCode() > rhs.getISOCountryCode()) return false;
    }
    if (hasTranscriptCode() || rhs.hasTranscriptCode()) {
        if (getTranscriptCode() < rhs.getTranscriptCode()) return true;
        if (getTranscriptCode() > rhs.getTranscriptCode()) return false;
    }
    return false;
}

inline bool LanguageEntry::operator > (const LanguageEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LanguageEntry::clear() {
    clearISOLanguageCode();
    clearISOCountryCode();
    clearTranscriptCode();
}

inline void LanguageEntry::clearISOLanguageCode() {
    if (hasISOLanguageCode()) {
         clear_has_iSOLanguageCode();
        _iSOLanguageCode.clear();
     }
}

inline bool LanguageEntry::hasISOLanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LanguageEntry::getISOLanguageCode () const {
    return _iSOLanguageCode;
}

inline ::std::string& LanguageEntry::getISOLanguageCodeMutable () {
    set_has_iSOLanguageCode();
    return _iSOLanguageCode;
}

inline void LanguageEntry::setISOLanguageCode (const ::std::string& iSOLanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOLanguageCode();
    this->_iSOLanguageCode = iSOLanguageCode_;
}

inline void LanguageEntry::setISOLanguageCode (const char* iSOLanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOLanguageCode();
    this->_iSOLanguageCode.assign(iSOLanguageCode_);
}

inline void LanguageEntry::setISOLanguageCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOLanguageCode();
    this->_iSOLanguageCode.assign(value, size);
}

inline void LanguageEntry::clearISOCountryCode() {
    if (hasISOCountryCode()) {
         clear_has_iSOCountryCode();
        _iSOCountryCode.clear();
     }
}

inline bool LanguageEntry::hasISOCountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LanguageEntry::getISOCountryCode () const {
    return _iSOCountryCode;
}

inline ::std::string& LanguageEntry::getISOCountryCodeMutable () {
    set_has_iSOCountryCode();
    return _iSOCountryCode;
}

inline void LanguageEntry::setISOCountryCode (const ::std::string& iSOCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOCountryCode();
    this->_iSOCountryCode = iSOCountryCode_;
}

inline void LanguageEntry::setISOCountryCode (const char* iSOCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iSOCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOCountryCode();
    this->_iSOCountryCode.assign(iSOCountryCode_);
}

inline void LanguageEntry::setISOCountryCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iSOCountryCode();
    this->_iSOCountryCode.assign(value, size);
}

inline void LanguageEntry::clearTranscriptCode() {
    if (hasTranscriptCode()) {
         clear_has_transcriptCode();
        _transcriptCode.clear();
     }
}

inline bool LanguageEntry::hasTranscriptCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& LanguageEntry::getTranscriptCode () const {
    return _transcriptCode;
}

inline ::std::string& LanguageEntry::getTranscriptCodeMutable () {
    set_has_transcriptCode();
    return _transcriptCode;
}

inline void LanguageEntry::setTranscriptCode (const ::std::string& transcriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transcriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transcriptCode();
    this->_transcriptCode = transcriptCode_;
}

inline void LanguageEntry::setTranscriptCode (const char* transcriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transcriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transcriptCode();
    this->_transcriptCode.assign(transcriptCode_);
}

inline void LanguageEntry::setTranscriptCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transcriptCode();
    this->_transcriptCode.assign(value, size);
}

inline void LanguageEntry::set_has_iSOLanguageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void LanguageEntry::clear_has_iSOLanguageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LanguageEntry::set_has_iSOCountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void LanguageEntry::clear_has_iSOCountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LanguageEntry::set_has_transcriptCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void LanguageEntry::clear_has_transcriptCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SdsLanguages::SdsLanguages ()  :
    _languageCode (0u),
    _isoCountryCode (),
    _isoLanguageCode (),
    _isoScriptCode (),
    _languageEntry (),
    _isTransliterationOf (0u),
    _isDiacriticTransliterationOf (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsLanguages::SdsLanguages (const SdsLanguages &rhs)  :
    _languageCode (0u),
    _isoCountryCode (),
    _isoLanguageCode (),
    _isoScriptCode (),
    _languageEntry (),
    _isTransliterationOf (0u),
    _isDiacriticTransliterationOf (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsLanguages::SdsLanguages (uint16 languageCode_, const ::std::string& isoCountryCode_, const ::std::string& isoLanguageCode_, const ::std::string& isoScriptCode_, const LanguageEntry& languageEntry_, uint16 isTransliterationOf_, uint16 isDiacriticTransliterationOf_)  :
    _languageCode (languageCode_),
    _isoCountryCode (isoCountryCode_),
    _isoLanguageCode (isoLanguageCode_),
    _isoScriptCode (isoScriptCode_),
    _languageEntry (languageEntry_),
    _isTransliterationOf (isTransliterationOf_),
    _isDiacriticTransliterationOf (isDiacriticTransliterationOf_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsLanguages::~SdsLanguages() {
}

inline SdsLanguages& SdsLanguages::operator = (const SdsLanguages& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageCode()) {
            setLanguageCode(rhs.getLanguageCode());
        } else {
            clearLanguageCode();
        }
        if (rhs.hasIsoCountryCode()) {
            setIsoCountryCode(rhs.getIsoCountryCode());
        } else {
            clearIsoCountryCode();
        }
        if (rhs.hasIsoLanguageCode()) {
            setIsoLanguageCode(rhs.getIsoLanguageCode());
        } else {
            clearIsoLanguageCode();
        }
        if (rhs.hasIsoScriptCode()) {
            setIsoScriptCode(rhs.getIsoScriptCode());
        } else {
            clearIsoScriptCode();
        }
        if (rhs.hasLanguageEntry()) {
            setLanguageEntry(rhs.getLanguageEntry());
        } else {
            clearLanguageEntry();
        }
        if (rhs.hasIsTransliterationOf()) {
            setIsTransliterationOf(rhs.getIsTransliterationOf());
        } else {
            clearIsTransliterationOf();
        }
        if (rhs.hasIsDiacriticTransliterationOf()) {
            setIsDiacriticTransliterationOf(rhs.getIsDiacriticTransliterationOf());
        } else {
            clearIsDiacriticTransliterationOf();
        }
    }
    return *this;
}

inline bool SdsLanguages::operator == (const SdsLanguages& rhs) const {
    return (((!hasLanguageCode() && !rhs.hasLanguageCode()) || getLanguageCode() == rhs.getLanguageCode()) &&
        ((!hasIsoCountryCode() && !rhs.hasIsoCountryCode()) || getIsoCountryCode() == rhs.getIsoCountryCode()) &&
        ((!hasIsoLanguageCode() && !rhs.hasIsoLanguageCode()) || getIsoLanguageCode() == rhs.getIsoLanguageCode()) &&
        ((!hasIsoScriptCode() && !rhs.hasIsoScriptCode()) || getIsoScriptCode() == rhs.getIsoScriptCode()) &&
        ((!hasLanguageEntry() && !rhs.hasLanguageEntry()) || getLanguageEntry() == rhs.getLanguageEntry()) &&
        ((!hasIsTransliterationOf() && !rhs.hasIsTransliterationOf()) || getIsTransliterationOf() == rhs.getIsTransliterationOf()) &&
        ((!hasIsDiacriticTransliterationOf() && !rhs.hasIsDiacriticTransliterationOf()) || getIsDiacriticTransliterationOf() == rhs.getIsDiacriticTransliterationOf()));
}

inline bool SdsLanguages::operator != (const SdsLanguages& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsLanguages::operator < (const SdsLanguages& rhs) const {
    if (hasLanguageCode() || rhs.hasLanguageCode()) {
        if (getLanguageCode() < rhs.getLanguageCode()) return true;
        if (getLanguageCode() > rhs.getLanguageCode()) return false;
    }
    if (hasIsoCountryCode() || rhs.hasIsoCountryCode()) {
        if (getIsoCountryCode() < rhs.getIsoCountryCode()) return true;
        if (getIsoCountryCode() > rhs.getIsoCountryCode()) return false;
    }
    if (hasIsoLanguageCode() || rhs.hasIsoLanguageCode()) {
        if (getIsoLanguageCode() < rhs.getIsoLanguageCode()) return true;
        if (getIsoLanguageCode() > rhs.getIsoLanguageCode()) return false;
    }
    if (hasIsoScriptCode() || rhs.hasIsoScriptCode()) {
        if (getIsoScriptCode() < rhs.getIsoScriptCode()) return true;
        if (getIsoScriptCode() > rhs.getIsoScriptCode()) return false;
    }
    if (hasLanguageEntry() || rhs.hasLanguageEntry()) {
        if (getLanguageEntry() < rhs.getLanguageEntry()) return true;
        if (getLanguageEntry() > rhs.getLanguageEntry()) return false;
    }
    if (hasIsTransliterationOf() || rhs.hasIsTransliterationOf()) {
        if (getIsTransliterationOf() < rhs.getIsTransliterationOf()) return true;
        if (getIsTransliterationOf() > rhs.getIsTransliterationOf()) return false;
    }
    if (hasIsDiacriticTransliterationOf() || rhs.hasIsDiacriticTransliterationOf()) {
        if (getIsDiacriticTransliterationOf() < rhs.getIsDiacriticTransliterationOf()) return true;
        if (getIsDiacriticTransliterationOf() > rhs.getIsDiacriticTransliterationOf()) return false;
    }
    return false;
}

inline bool SdsLanguages::operator > (const SdsLanguages& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsLanguages::clear() {
    clearLanguageCode();
    clearIsoCountryCode();
    clearIsoLanguageCode();
    clearIsoScriptCode();
    clearLanguageEntry();
    clearIsTransliterationOf();
    clearIsDiacriticTransliterationOf();
}

inline void SdsLanguages::clearLanguageCode() {
    if (hasLanguageCode()) {
         clear_has_languageCode();
        _languageCode = 0u;
     }
}

inline bool SdsLanguages::hasLanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SdsLanguages::getLanguageCode () const {
    return _languageCode;
}

inline void SdsLanguages::setLanguageCode (uint16 languageCode_) {
    set_has_languageCode();
    this->_languageCode = languageCode_;
}

inline void SdsLanguages::clearIsoCountryCode() {
    if (hasIsoCountryCode()) {
         clear_has_isoCountryCode();
        _isoCountryCode.clear();
     }
}

inline bool SdsLanguages::hasIsoCountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SdsLanguages::getIsoCountryCode () const {
    return _isoCountryCode;
}

inline ::std::string& SdsLanguages::getIsoCountryCodeMutable () {
    set_has_isoCountryCode();
    return _isoCountryCode;
}

inline void SdsLanguages::setIsoCountryCode (const ::std::string& isoCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode = isoCountryCode_;
}

inline void SdsLanguages::setIsoCountryCode (const char* isoCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode.assign(isoCountryCode_);
}

inline void SdsLanguages::setIsoCountryCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode.assign(value, size);
}

inline void SdsLanguages::clearIsoLanguageCode() {
    if (hasIsoLanguageCode()) {
         clear_has_isoLanguageCode();
        _isoLanguageCode.clear();
     }
}

inline bool SdsLanguages::hasIsoLanguageCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SdsLanguages::getIsoLanguageCode () const {
    return _isoLanguageCode;
}

inline ::std::string& SdsLanguages::getIsoLanguageCodeMutable () {
    set_has_isoLanguageCode();
    return _isoLanguageCode;
}

inline void SdsLanguages::setIsoLanguageCode (const ::std::string& isoLanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLanguageCode();
    this->_isoLanguageCode = isoLanguageCode_;
}

inline void SdsLanguages::setIsoLanguageCode (const char* isoLanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoLanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLanguageCode();
    this->_isoLanguageCode.assign(isoLanguageCode_);
}

inline void SdsLanguages::setIsoLanguageCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoLanguageCode();
    this->_isoLanguageCode.assign(value, size);
}

inline void SdsLanguages::clearIsoScriptCode() {
    if (hasIsoScriptCode()) {
         clear_has_isoScriptCode();
        _isoScriptCode.clear();
     }
}

inline bool SdsLanguages::hasIsoScriptCode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SdsLanguages::getIsoScriptCode () const {
    return _isoScriptCode;
}

inline ::std::string& SdsLanguages::getIsoScriptCodeMutable () {
    set_has_isoScriptCode();
    return _isoScriptCode;
}

inline void SdsLanguages::setIsoScriptCode (const ::std::string& isoScriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoScriptCode();
    this->_isoScriptCode = isoScriptCode_;
}

inline void SdsLanguages::setIsoScriptCode (const char* isoScriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoScriptCode();
    this->_isoScriptCode.assign(isoScriptCode_);
}

inline void SdsLanguages::setIsoScriptCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoScriptCode();
    this->_isoScriptCode.assign(value, size);
}

inline void SdsLanguages::clearLanguageEntry() {
    if (hasLanguageEntry()) {
         clear_has_languageEntry();
        _languageEntry.clear();
     }
}

inline bool SdsLanguages::hasLanguageEntry () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const LanguageEntry& SdsLanguages::getLanguageEntry () const {
    return _languageEntry;
}

inline LanguageEntry& SdsLanguages::getLanguageEntryMutable () {
    set_has_languageEntry();
    return _languageEntry;
}

inline void SdsLanguages::setLanguageEntry (const LanguageEntry& languageEntry_) {
    set_has_languageEntry();
    this->_languageEntry = languageEntry_;
}

inline void SdsLanguages::clearIsTransliterationOf() {
    if (hasIsTransliterationOf()) {
         clear_has_isTransliterationOf();
        _isTransliterationOf = 0u;
     }
}

inline bool SdsLanguages::hasIsTransliterationOf () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 SdsLanguages::getIsTransliterationOf () const {
    return _isTransliterationOf;
}

inline void SdsLanguages::setIsTransliterationOf (uint16 isTransliterationOf_) {
    set_has_isTransliterationOf();
    this->_isTransliterationOf = isTransliterationOf_;
}

inline void SdsLanguages::clearIsDiacriticTransliterationOf() {
    if (hasIsDiacriticTransliterationOf()) {
         clear_has_isDiacriticTransliterationOf();
        _isDiacriticTransliterationOf = 0u;
     }
}

inline bool SdsLanguages::hasIsDiacriticTransliterationOf () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 SdsLanguages::getIsDiacriticTransliterationOf () const {
    return _isDiacriticTransliterationOf;
}

inline void SdsLanguages::setIsDiacriticTransliterationOf (uint16 isDiacriticTransliterationOf_) {
    set_has_isDiacriticTransliterationOf();
    this->_isDiacriticTransliterationOf = isDiacriticTransliterationOf_;
}

inline void SdsLanguages::set_has_languageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsLanguages::clear_has_languageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsLanguages::set_has_isoCountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsLanguages::clear_has_isoCountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsLanguages::set_has_isoLanguageCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsLanguages::clear_has_isoLanguageCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SdsLanguages::set_has_isoScriptCode () {
    _has_bits_[0] |= 1u << 3;
}

inline void SdsLanguages::clear_has_isoScriptCode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SdsLanguages::set_has_languageEntry () {
    _has_bits_[0] |= 1u << 4;
}

inline void SdsLanguages::clear_has_languageEntry () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SdsLanguages::set_has_isTransliterationOf () {
    _has_bits_[0] |= 1u << 5;
}

inline void SdsLanguages::clear_has_isTransliterationOf () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void SdsLanguages::set_has_isDiacriticTransliterationOf () {
    _has_bits_[0] |= 1u << 6;
}

inline void SdsLanguages::clear_has_isDiacriticTransliterationOf () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  SdsProducts::SdsProducts ()  :
    _supplierId (0u),
    _productId (0u),
    _sdsUpdateRegionsList (),
    _sdsLanguagesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsProducts::SdsProducts (const SdsProducts &rhs)  :
    _supplierId (0u),
    _productId (0u),
    _sdsUpdateRegionsList (),
    _sdsLanguagesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsProducts::SdsProducts (uint8 supplierId_, uint32 productId_, const ::std::vector< SdsUpdateRegions >& sdsUpdateRegionsList_, const ::std::vector< SdsLanguages >& sdsLanguagesList_)  :
    _supplierId (supplierId_),
    _productId (productId_),
    _sdsUpdateRegionsList (sdsUpdateRegionsList_),
    _sdsLanguagesList (sdsLanguagesList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsProducts::~SdsProducts() {
}

inline SdsProducts& SdsProducts::operator = (const SdsProducts& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSdsUpdateRegionsList()) {
            setSdsUpdateRegionsList(rhs.getSdsUpdateRegionsList());
        } else {
            clearSdsUpdateRegionsList();
        }
        if (rhs.hasSdsLanguagesList()) {
            setSdsLanguagesList(rhs.getSdsLanguagesList());
        } else {
            clearSdsLanguagesList();
        }
    }
    return *this;
}

inline bool SdsProducts::operator == (const SdsProducts& rhs) const {
    return (((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSdsUpdateRegionsList() && !rhs.hasSdsUpdateRegionsList()) || getSdsUpdateRegionsList() == rhs.getSdsUpdateRegionsList()) &&
        ((!hasSdsLanguagesList() && !rhs.hasSdsLanguagesList()) || getSdsLanguagesList() == rhs.getSdsLanguagesList()));
}

inline bool SdsProducts::operator != (const SdsProducts& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsProducts::operator < (const SdsProducts& rhs) const {
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSdsUpdateRegionsList() || rhs.hasSdsUpdateRegionsList()) {
        if (getSdsUpdateRegionsList() < rhs.getSdsUpdateRegionsList()) return true;
        if (getSdsUpdateRegionsList() > rhs.getSdsUpdateRegionsList()) return false;
    }
    if (hasSdsLanguagesList() || rhs.hasSdsLanguagesList()) {
        if (getSdsLanguagesList() < rhs.getSdsLanguagesList()) return true;
        if (getSdsLanguagesList() > rhs.getSdsLanguagesList()) return false;
    }
    return false;
}

inline bool SdsProducts::operator > (const SdsProducts& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsProducts::clear() {
    clearSupplierId();
    clearProductId();
    clearSdsUpdateRegionsList();
    clearSdsLanguagesList();
}

inline void SdsProducts::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool SdsProducts::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SdsProducts::getSupplierId () const {
    return _supplierId;
}

inline void SdsProducts::setSupplierId (uint8 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void SdsProducts::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool SdsProducts::hasProductId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SdsProducts::getProductId () const {
    return _productId;
}

inline void SdsProducts::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void SdsProducts::clearSdsUpdateRegionsList() {
    if (hasSdsUpdateRegionsList()) {
         clear_has_sdsUpdateRegionsList();
        _sdsUpdateRegionsList.clear();
     }
}

inline bool SdsProducts::hasSdsUpdateRegionsList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< SdsUpdateRegions >& SdsProducts::getSdsUpdateRegionsList () const {
    return _sdsUpdateRegionsList;
}

inline ::std::vector< SdsUpdateRegions >& SdsProducts::getSdsUpdateRegionsListMutable () {
    set_has_sdsUpdateRegionsList();
    return _sdsUpdateRegionsList;
}

inline void SdsProducts::setSdsUpdateRegionsList (const ::std::vector< SdsUpdateRegions >& sdsUpdateRegionsList_) {
    set_has_sdsUpdateRegionsList();
    this->_sdsUpdateRegionsList = sdsUpdateRegionsList_;
}

inline void SdsProducts::clearSdsLanguagesList() {
    if (hasSdsLanguagesList()) {
         clear_has_sdsLanguagesList();
        _sdsLanguagesList.clear();
     }
}

inline bool SdsProducts::hasSdsLanguagesList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< SdsLanguages >& SdsProducts::getSdsLanguagesList () const {
    return _sdsLanguagesList;
}

inline ::std::vector< SdsLanguages >& SdsProducts::getSdsLanguagesListMutable () {
    set_has_sdsLanguagesList();
    return _sdsLanguagesList;
}

inline void SdsProducts::setSdsLanguagesList (const ::std::vector< SdsLanguages >& sdsLanguagesList_) {
    set_has_sdsLanguagesList();
    this->_sdsLanguagesList = sdsLanguagesList_;
}

inline void SdsProducts::set_has_supplierId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsProducts::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsProducts::set_has_productId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsProducts::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsProducts::set_has_sdsUpdateRegionsList () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsProducts::clear_has_sdsUpdateRegionsList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SdsProducts::set_has_sdsLanguagesList () {
    _has_bits_[0] |= 1u << 3;
}

inline void SdsProducts::clear_has_sdsLanguagesList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GlobalUpdateRegionId::GlobalUpdateRegionId ()  :
    _updateRegionId (0),
    _productId (0),
    _supplierId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GlobalUpdateRegionId::GlobalUpdateRegionId (const GlobalUpdateRegionId &rhs)  :
    _updateRegionId (0),
    _productId (0),
    _supplierId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GlobalUpdateRegionId::GlobalUpdateRegionId (int16 updateRegionId_, int32 productId_, int8 supplierId_)  :
    _updateRegionId (updateRegionId_),
    _productId (productId_),
    _supplierId (supplierId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GlobalUpdateRegionId::~GlobalUpdateRegionId() {
}

inline GlobalUpdateRegionId& GlobalUpdateRegionId::operator = (const GlobalUpdateRegionId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateRegionId()) {
            setUpdateRegionId(rhs.getUpdateRegionId());
        } else {
            clearUpdateRegionId();
        }
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
    }
    return *this;
}

inline bool GlobalUpdateRegionId::operator == (const GlobalUpdateRegionId& rhs) const {
    return (((!hasUpdateRegionId() && !rhs.hasUpdateRegionId()) || getUpdateRegionId() == rhs.getUpdateRegionId()) &&
        ((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()));
}

inline bool GlobalUpdateRegionId::operator != (const GlobalUpdateRegionId& rhs) const {
    return ! (*this == rhs);
}

inline bool GlobalUpdateRegionId::operator < (const GlobalUpdateRegionId& rhs) const {
    if (hasUpdateRegionId() || rhs.hasUpdateRegionId()) {
        if (getUpdateRegionId() < rhs.getUpdateRegionId()) return true;
        if (getUpdateRegionId() > rhs.getUpdateRegionId()) return false;
    }
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    return false;
}

inline bool GlobalUpdateRegionId::operator > (const GlobalUpdateRegionId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GlobalUpdateRegionId::clear() {
    clearUpdateRegionId();
    clearProductId();
    clearSupplierId();
}

inline void GlobalUpdateRegionId::clearUpdateRegionId() {
    if (hasUpdateRegionId()) {
         clear_has_updateRegionId();
        _updateRegionId = 0;
     }
}

inline bool GlobalUpdateRegionId::hasUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GlobalUpdateRegionId::getUpdateRegionId () const {
    return _updateRegionId;
}

inline void GlobalUpdateRegionId::setUpdateRegionId (int16 updateRegionId_) {
    set_has_updateRegionId();
    this->_updateRegionId = updateRegionId_;
}

inline void GlobalUpdateRegionId::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0;
     }
}

inline bool GlobalUpdateRegionId::hasProductId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 GlobalUpdateRegionId::getProductId () const {
    return _productId;
}

inline void GlobalUpdateRegionId::setProductId (int32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void GlobalUpdateRegionId::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0;
     }
}

inline bool GlobalUpdateRegionId::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 GlobalUpdateRegionId::getSupplierId () const {
    return _supplierId;
}

inline void GlobalUpdateRegionId::setSupplierId (int8 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void GlobalUpdateRegionId::set_has_updateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GlobalUpdateRegionId::clear_has_updateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GlobalUpdateRegionId::set_has_productId () {
    _has_bits_[0] |= 1u << 1;
}

inline void GlobalUpdateRegionId::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GlobalUpdateRegionId::set_has_supplierId () {
    _has_bits_[0] |= 1u << 2;
}

inline void GlobalUpdateRegionId::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GlobalNamedObjectId::GlobalNamedObjectId ()  :
    _globalUpdateRegionId (),
    _namedObjectId (0u),
    _isValid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GlobalNamedObjectId::GlobalNamedObjectId (const GlobalNamedObjectId &rhs)  :
    _globalUpdateRegionId (),
    _namedObjectId (0u),
    _isValid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GlobalNamedObjectId::GlobalNamedObjectId (const GlobalUpdateRegionId& globalUpdateRegionId_, uint32 namedObjectId_, bool isValid_)  :
    _globalUpdateRegionId (globalUpdateRegionId_),
    _namedObjectId (namedObjectId_),
    _isValid (isValid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GlobalNamedObjectId::~GlobalNamedObjectId() {
}

inline GlobalNamedObjectId& GlobalNamedObjectId::operator = (const GlobalNamedObjectId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGlobalUpdateRegionId()) {
            setGlobalUpdateRegionId(rhs.getGlobalUpdateRegionId());
        } else {
            clearGlobalUpdateRegionId();
        }
        if (rhs.hasNamedObjectId()) {
            setNamedObjectId(rhs.getNamedObjectId());
        } else {
            clearNamedObjectId();
        }
        if (rhs.hasIsValid()) {
            setIsValid(rhs.getIsValid());
        } else {
            clearIsValid();
        }
    }
    return *this;
}

inline bool GlobalNamedObjectId::operator == (const GlobalNamedObjectId& rhs) const {
    return (((!hasGlobalUpdateRegionId() && !rhs.hasGlobalUpdateRegionId()) || getGlobalUpdateRegionId() == rhs.getGlobalUpdateRegionId()) &&
        ((!hasNamedObjectId() && !rhs.hasNamedObjectId()) || getNamedObjectId() == rhs.getNamedObjectId()) &&
        ((!hasIsValid() && !rhs.hasIsValid()) || getIsValid() == rhs.getIsValid()));
}

inline bool GlobalNamedObjectId::operator != (const GlobalNamedObjectId& rhs) const {
    return ! (*this == rhs);
}

inline bool GlobalNamedObjectId::operator < (const GlobalNamedObjectId& rhs) const {
    if (hasGlobalUpdateRegionId() || rhs.hasGlobalUpdateRegionId()) {
        if (getGlobalUpdateRegionId() < rhs.getGlobalUpdateRegionId()) return true;
        if (getGlobalUpdateRegionId() > rhs.getGlobalUpdateRegionId()) return false;
    }
    if (hasNamedObjectId() || rhs.hasNamedObjectId()) {
        if (getNamedObjectId() < rhs.getNamedObjectId()) return true;
        if (getNamedObjectId() > rhs.getNamedObjectId()) return false;
    }
    if (hasIsValid() || rhs.hasIsValid()) {
        if (getIsValid() < rhs.getIsValid()) return true;
        if (getIsValid() > rhs.getIsValid()) return false;
    }
    return false;
}

inline bool GlobalNamedObjectId::operator > (const GlobalNamedObjectId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GlobalNamedObjectId::clear() {
    clearGlobalUpdateRegionId();
    clearNamedObjectId();
    clearIsValid();
}

inline void GlobalNamedObjectId::clearGlobalUpdateRegionId() {
    if (hasGlobalUpdateRegionId()) {
         clear_has_globalUpdateRegionId();
        _globalUpdateRegionId.clear();
     }
}

inline bool GlobalNamedObjectId::hasGlobalUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GlobalUpdateRegionId& GlobalNamedObjectId::getGlobalUpdateRegionId () const {
    return _globalUpdateRegionId;
}

inline GlobalUpdateRegionId& GlobalNamedObjectId::getGlobalUpdateRegionIdMutable () {
    set_has_globalUpdateRegionId();
    return _globalUpdateRegionId;
}

inline void GlobalNamedObjectId::setGlobalUpdateRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_) {
    set_has_globalUpdateRegionId();
    this->_globalUpdateRegionId = globalUpdateRegionId_;
}

inline void GlobalNamedObjectId::clearNamedObjectId() {
    if (hasNamedObjectId()) {
         clear_has_namedObjectId();
        _namedObjectId = 0u;
     }
}

inline bool GlobalNamedObjectId::hasNamedObjectId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GlobalNamedObjectId::getNamedObjectId () const {
    return _namedObjectId;
}

inline void GlobalNamedObjectId::setNamedObjectId (uint32 namedObjectId_) {
    set_has_namedObjectId();
    this->_namedObjectId = namedObjectId_;
}

inline void GlobalNamedObjectId::clearIsValid() {
    if (hasIsValid()) {
         clear_has_isValid();
        _isValid = false;
     }
}

inline bool GlobalNamedObjectId::hasIsValid () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool GlobalNamedObjectId::getIsValid () const {
    return _isValid;
}

inline void GlobalNamedObjectId::setIsValid (bool isValid_) {
    set_has_isValid();
    this->_isValid = isValid_;
}

inline void GlobalNamedObjectId::set_has_globalUpdateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GlobalNamedObjectId::clear_has_globalUpdateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GlobalNamedObjectId::set_has_namedObjectId () {
    _has_bits_[0] |= 1u << 1;
}

inline void GlobalNamedObjectId::clear_has_namedObjectId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GlobalNamedObjectId::set_has_isValid () {
    _has_bits_[0] |= 1u << 2;
}

inline void GlobalNamedObjectId::clear_has_isValid () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GlobalNamedObjectAndRegionId::GlobalNamedObjectAndRegionId ()  :
    _globalUpdateRegionId (),
    _namedObjectId (0u),
    _poiRegionId (0u),
    _globalXrefID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GlobalNamedObjectAndRegionId::GlobalNamedObjectAndRegionId (const GlobalNamedObjectAndRegionId &rhs)  :
    _globalUpdateRegionId (),
    _namedObjectId (0u),
    _poiRegionId (0u),
    _globalXrefID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GlobalNamedObjectAndRegionId::GlobalNamedObjectAndRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_, uint32 namedObjectId_, uint64 poiRegionId_, uint32 globalXrefID_)  :
    _globalUpdateRegionId (globalUpdateRegionId_),
    _namedObjectId (namedObjectId_),
    _poiRegionId (poiRegionId_),
    _globalXrefID (globalXrefID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GlobalNamedObjectAndRegionId::~GlobalNamedObjectAndRegionId() {
}

inline GlobalNamedObjectAndRegionId& GlobalNamedObjectAndRegionId::operator = (const GlobalNamedObjectAndRegionId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGlobalUpdateRegionId()) {
            setGlobalUpdateRegionId(rhs.getGlobalUpdateRegionId());
        } else {
            clearGlobalUpdateRegionId();
        }
        if (rhs.hasNamedObjectId()) {
            setNamedObjectId(rhs.getNamedObjectId());
        } else {
            clearNamedObjectId();
        }
        if (rhs.hasPoiRegionId()) {
            setPoiRegionId(rhs.getPoiRegionId());
        } else {
            clearPoiRegionId();
        }
        if (rhs.hasGlobalXrefID()) {
            setGlobalXrefID(rhs.getGlobalXrefID());
        } else {
            clearGlobalXrefID();
        }
    }
    return *this;
}

inline bool GlobalNamedObjectAndRegionId::operator == (const GlobalNamedObjectAndRegionId& rhs) const {
    return (((!hasGlobalUpdateRegionId() && !rhs.hasGlobalUpdateRegionId()) || getGlobalUpdateRegionId() == rhs.getGlobalUpdateRegionId()) &&
        ((!hasNamedObjectId() && !rhs.hasNamedObjectId()) || getNamedObjectId() == rhs.getNamedObjectId()) &&
        ((!hasPoiRegionId() && !rhs.hasPoiRegionId()) || getPoiRegionId() == rhs.getPoiRegionId()) &&
        ((!hasGlobalXrefID() && !rhs.hasGlobalXrefID()) || getGlobalXrefID() == rhs.getGlobalXrefID()));
}

inline bool GlobalNamedObjectAndRegionId::operator != (const GlobalNamedObjectAndRegionId& rhs) const {
    return ! (*this == rhs);
}

inline bool GlobalNamedObjectAndRegionId::operator < (const GlobalNamedObjectAndRegionId& rhs) const {
    if (hasGlobalUpdateRegionId() || rhs.hasGlobalUpdateRegionId()) {
        if (getGlobalUpdateRegionId() < rhs.getGlobalUpdateRegionId()) return true;
        if (getGlobalUpdateRegionId() > rhs.getGlobalUpdateRegionId()) return false;
    }
    if (hasNamedObjectId() || rhs.hasNamedObjectId()) {
        if (getNamedObjectId() < rhs.getNamedObjectId()) return true;
        if (getNamedObjectId() > rhs.getNamedObjectId()) return false;
    }
    if (hasPoiRegionId() || rhs.hasPoiRegionId()) {
        if (getPoiRegionId() < rhs.getPoiRegionId()) return true;
        if (getPoiRegionId() > rhs.getPoiRegionId()) return false;
    }
    if (hasGlobalXrefID() || rhs.hasGlobalXrefID()) {
        if (getGlobalXrefID() < rhs.getGlobalXrefID()) return true;
        if (getGlobalXrefID() > rhs.getGlobalXrefID()) return false;
    }
    return false;
}

inline bool GlobalNamedObjectAndRegionId::operator > (const GlobalNamedObjectAndRegionId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GlobalNamedObjectAndRegionId::clear() {
    clearGlobalUpdateRegionId();
    clearNamedObjectId();
    clearPoiRegionId();
    clearGlobalXrefID();
}

inline void GlobalNamedObjectAndRegionId::clearGlobalUpdateRegionId() {
    if (hasGlobalUpdateRegionId()) {
         clear_has_globalUpdateRegionId();
        _globalUpdateRegionId.clear();
     }
}

inline bool GlobalNamedObjectAndRegionId::hasGlobalUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GlobalUpdateRegionId& GlobalNamedObjectAndRegionId::getGlobalUpdateRegionId () const {
    return _globalUpdateRegionId;
}

inline GlobalUpdateRegionId& GlobalNamedObjectAndRegionId::getGlobalUpdateRegionIdMutable () {
    set_has_globalUpdateRegionId();
    return _globalUpdateRegionId;
}

inline void GlobalNamedObjectAndRegionId::setGlobalUpdateRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_) {
    set_has_globalUpdateRegionId();
    this->_globalUpdateRegionId = globalUpdateRegionId_;
}

inline void GlobalNamedObjectAndRegionId::clearNamedObjectId() {
    if (hasNamedObjectId()) {
         clear_has_namedObjectId();
        _namedObjectId = 0u;
     }
}

inline bool GlobalNamedObjectAndRegionId::hasNamedObjectId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GlobalNamedObjectAndRegionId::getNamedObjectId () const {
    return _namedObjectId;
}

inline void GlobalNamedObjectAndRegionId::setNamedObjectId (uint32 namedObjectId_) {
    set_has_namedObjectId();
    this->_namedObjectId = namedObjectId_;
}

inline void GlobalNamedObjectAndRegionId::clearPoiRegionId() {
    if (hasPoiRegionId()) {
         clear_has_poiRegionId();
        _poiRegionId = 0u;
     }
}

inline bool GlobalNamedObjectAndRegionId::hasPoiRegionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint64 GlobalNamedObjectAndRegionId::getPoiRegionId () const {
    return _poiRegionId;
}

inline void GlobalNamedObjectAndRegionId::setPoiRegionId (uint64 poiRegionId_) {
    set_has_poiRegionId();
    this->_poiRegionId = poiRegionId_;
}

inline void GlobalNamedObjectAndRegionId::clearGlobalXrefID() {
    if (hasGlobalXrefID()) {
         clear_has_globalXrefID();
        _globalXrefID = 0u;
     }
}

inline bool GlobalNamedObjectAndRegionId::hasGlobalXrefID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 GlobalNamedObjectAndRegionId::getGlobalXrefID () const {
    return _globalXrefID;
}

inline void GlobalNamedObjectAndRegionId::setGlobalXrefID (uint32 globalXrefID_) {
    set_has_globalXrefID();
    this->_globalXrefID = globalXrefID_;
}

inline void GlobalNamedObjectAndRegionId::set_has_globalUpdateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GlobalNamedObjectAndRegionId::clear_has_globalUpdateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GlobalNamedObjectAndRegionId::set_has_namedObjectId () {
    _has_bits_[0] |= 1u << 1;
}

inline void GlobalNamedObjectAndRegionId::clear_has_namedObjectId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GlobalNamedObjectAndRegionId::set_has_poiRegionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void GlobalNamedObjectAndRegionId::clear_has_poiRegionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GlobalNamedObjectAndRegionId::set_has_globalXrefID () {
    _has_bits_[0] |= 1u << 3;
}

inline void GlobalNamedObjectAndRegionId::clear_has_globalXrefID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SubCountryIds::SubCountryIds ()  :
    _countryId (),
    _subCountryIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubCountryIds::SubCountryIds (const SubCountryIds &rhs)  :
    _countryId (),
    _subCountryIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubCountryIds::SubCountryIds (const GlobalNamedObjectId& countryId_, const ::std::vector< GlobalNamedObjectAndRegionId >& subCountryIdList_)  :
    _countryId (countryId_),
    _subCountryIdList (subCountryIdList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubCountryIds::~SubCountryIds() {
}

inline SubCountryIds& SubCountryIds::operator = (const SubCountryIds& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCountryId()) {
            setCountryId(rhs.getCountryId());
        } else {
            clearCountryId();
        }
        if (rhs.hasSubCountryIdList()) {
            setSubCountryIdList(rhs.getSubCountryIdList());
        } else {
            clearSubCountryIdList();
        }
    }
    return *this;
}

inline bool SubCountryIds::operator == (const SubCountryIds& rhs) const {
    return (((!hasCountryId() && !rhs.hasCountryId()) || getCountryId() == rhs.getCountryId()) &&
        ((!hasSubCountryIdList() && !rhs.hasSubCountryIdList()) || getSubCountryIdList() == rhs.getSubCountryIdList()));
}

inline bool SubCountryIds::operator != (const SubCountryIds& rhs) const {
    return ! (*this == rhs);
}

inline bool SubCountryIds::operator < (const SubCountryIds& rhs) const {
    if (hasCountryId() || rhs.hasCountryId()) {
        if (getCountryId() < rhs.getCountryId()) return true;
        if (getCountryId() > rhs.getCountryId()) return false;
    }
    if (hasSubCountryIdList() || rhs.hasSubCountryIdList()) {
        if (getSubCountryIdList() < rhs.getSubCountryIdList()) return true;
        if (getSubCountryIdList() > rhs.getSubCountryIdList()) return false;
    }
    return false;
}

inline bool SubCountryIds::operator > (const SubCountryIds& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubCountryIds::clear() {
    clearCountryId();
    clearSubCountryIdList();
}

inline void SubCountryIds::clearCountryId() {
    if (hasCountryId()) {
         clear_has_countryId();
        _countryId.clear();
     }
}

inline bool SubCountryIds::hasCountryId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GlobalNamedObjectId& SubCountryIds::getCountryId () const {
    return _countryId;
}

inline GlobalNamedObjectId& SubCountryIds::getCountryIdMutable () {
    set_has_countryId();
    return _countryId;
}

inline void SubCountryIds::setCountryId (const GlobalNamedObjectId& countryId_) {
    set_has_countryId();
    this->_countryId = countryId_;
}

inline void SubCountryIds::clearSubCountryIdList() {
    if (hasSubCountryIdList()) {
         clear_has_subCountryIdList();
        _subCountryIdList.clear();
     }
}

inline bool SubCountryIds::hasSubCountryIdList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GlobalNamedObjectAndRegionId >& SubCountryIds::getSubCountryIdList () const {
    return _subCountryIdList;
}

inline ::std::vector< GlobalNamedObjectAndRegionId >& SubCountryIds::getSubCountryIdListMutable () {
    set_has_subCountryIdList();
    return _subCountryIdList;
}

inline void SubCountryIds::setSubCountryIdList (const ::std::vector< GlobalNamedObjectAndRegionId >& subCountryIdList_) {
    set_has_subCountryIdList();
    this->_subCountryIdList = subCountryIdList_;
}

inline void SubCountryIds::set_has_countryId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubCountryIds::clear_has_countryId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SubCountryIds::set_has_subCountryIdList () {
    _has_bits_[0] |= 1u << 1;
}

inline void SubCountryIds::clear_has_subCountryIdList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  NamedObjectIdStrings::NamedObjectIdStrings ()  :
    _globalNamedObjectId (),
    _languageEntry (),
    _sdsNamedStringsList (),
    _addressElementType (::org::bosch::cm::navigation::NavigationSDSService::AddressElementType__COUNTRY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NamedObjectIdStrings::NamedObjectIdStrings (const NamedObjectIdStrings &rhs)  :
    _globalNamedObjectId (),
    _languageEntry (),
    _sdsNamedStringsList (),
    _addressElementType (::org::bosch::cm::navigation::NavigationSDSService::AddressElementType__COUNTRY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NamedObjectIdStrings::NamedObjectIdStrings (const GlobalNamedObjectId& globalNamedObjectId_, const LanguageEntry& languageEntry_, const ::std::vector< ::std::string >& sdsNamedStringsList_, AddressElementType addressElementType_)  :
    _globalNamedObjectId (globalNamedObjectId_),
    _languageEntry (languageEntry_),
    _sdsNamedStringsList (sdsNamedStringsList_),
    _addressElementType (addressElementType_)
{
    #ifndef NDEBUG
    if (!(AddressElementType_IsValid(addressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", addressElementType_, "AddressElementType", "addressElementType", "NamedObjectIdStrings");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NamedObjectIdStrings::~NamedObjectIdStrings() {
}

inline NamedObjectIdStrings& NamedObjectIdStrings::operator = (const NamedObjectIdStrings& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGlobalNamedObjectId()) {
            setGlobalNamedObjectId(rhs.getGlobalNamedObjectId());
        } else {
            clearGlobalNamedObjectId();
        }
        if (rhs.hasLanguageEntry()) {
            setLanguageEntry(rhs.getLanguageEntry());
        } else {
            clearLanguageEntry();
        }
        if (rhs.hasSdsNamedStringsList()) {
            setSdsNamedStringsList(rhs.getSdsNamedStringsList());
        } else {
            clearSdsNamedStringsList();
        }
        if (rhs.hasAddressElementType()) {
            setAddressElementType(rhs.getAddressElementType());
        } else {
            clearAddressElementType();
        }
    }
    return *this;
}

inline bool NamedObjectIdStrings::operator == (const NamedObjectIdStrings& rhs) const {
    return (((!hasGlobalNamedObjectId() && !rhs.hasGlobalNamedObjectId()) || getGlobalNamedObjectId() == rhs.getGlobalNamedObjectId()) &&
        ((!hasLanguageEntry() && !rhs.hasLanguageEntry()) || getLanguageEntry() == rhs.getLanguageEntry()) &&
        ((!hasSdsNamedStringsList() && !rhs.hasSdsNamedStringsList()) || getSdsNamedStringsList() == rhs.getSdsNamedStringsList()) &&
        ((!hasAddressElementType() && !rhs.hasAddressElementType()) || getAddressElementType() == rhs.getAddressElementType()));
}

inline bool NamedObjectIdStrings::operator != (const NamedObjectIdStrings& rhs) const {
    return ! (*this == rhs);
}

inline bool NamedObjectIdStrings::operator < (const NamedObjectIdStrings& rhs) const {
    if (hasGlobalNamedObjectId() || rhs.hasGlobalNamedObjectId()) {
        if (getGlobalNamedObjectId() < rhs.getGlobalNamedObjectId()) return true;
        if (getGlobalNamedObjectId() > rhs.getGlobalNamedObjectId()) return false;
    }
    if (hasLanguageEntry() || rhs.hasLanguageEntry()) {
        if (getLanguageEntry() < rhs.getLanguageEntry()) return true;
        if (getLanguageEntry() > rhs.getLanguageEntry()) return false;
    }
    if (hasSdsNamedStringsList() || rhs.hasSdsNamedStringsList()) {
        if (getSdsNamedStringsList() < rhs.getSdsNamedStringsList()) return true;
        if (getSdsNamedStringsList() > rhs.getSdsNamedStringsList()) return false;
    }
    if (hasAddressElementType() || rhs.hasAddressElementType()) {
        if ((uint32)getAddressElementType() < (uint32)rhs.getAddressElementType()) return true;
        if ((uint32)getAddressElementType() > (uint32)rhs.getAddressElementType()) return false;
    }
    return false;
}

inline bool NamedObjectIdStrings::operator > (const NamedObjectIdStrings& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NamedObjectIdStrings::clear() {
    clearGlobalNamedObjectId();
    clearLanguageEntry();
    clearSdsNamedStringsList();
    clearAddressElementType();
}

inline void NamedObjectIdStrings::clearGlobalNamedObjectId() {
    if (hasGlobalNamedObjectId()) {
         clear_has_globalNamedObjectId();
        _globalNamedObjectId.clear();
     }
}

inline bool NamedObjectIdStrings::hasGlobalNamedObjectId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GlobalNamedObjectId& NamedObjectIdStrings::getGlobalNamedObjectId () const {
    return _globalNamedObjectId;
}

inline GlobalNamedObjectId& NamedObjectIdStrings::getGlobalNamedObjectIdMutable () {
    set_has_globalNamedObjectId();
    return _globalNamedObjectId;
}

inline void NamedObjectIdStrings::setGlobalNamedObjectId (const GlobalNamedObjectId& globalNamedObjectId_) {
    set_has_globalNamedObjectId();
    this->_globalNamedObjectId = globalNamedObjectId_;
}

inline void NamedObjectIdStrings::clearLanguageEntry() {
    if (hasLanguageEntry()) {
         clear_has_languageEntry();
        _languageEntry.clear();
     }
}

inline bool NamedObjectIdStrings::hasLanguageEntry () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const LanguageEntry& NamedObjectIdStrings::getLanguageEntry () const {
    return _languageEntry;
}

inline LanguageEntry& NamedObjectIdStrings::getLanguageEntryMutable () {
    set_has_languageEntry();
    return _languageEntry;
}

inline void NamedObjectIdStrings::setLanguageEntry (const LanguageEntry& languageEntry_) {
    set_has_languageEntry();
    this->_languageEntry = languageEntry_;
}

inline void NamedObjectIdStrings::clearSdsNamedStringsList() {
    if (hasSdsNamedStringsList()) {
         clear_has_sdsNamedStringsList();
        _sdsNamedStringsList.clear();
     }
}

inline bool NamedObjectIdStrings::hasSdsNamedStringsList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& NamedObjectIdStrings::getSdsNamedStringsList () const {
    return _sdsNamedStringsList;
}

inline ::std::vector< ::std::string >& NamedObjectIdStrings::getSdsNamedStringsListMutable () {
    set_has_sdsNamedStringsList();
    return _sdsNamedStringsList;
}

inline void NamedObjectIdStrings::setSdsNamedStringsList (const ::std::vector< ::std::string >& sdsNamedStringsList_) {
    set_has_sdsNamedStringsList();
    this->_sdsNamedStringsList = sdsNamedStringsList_;
}

inline void NamedObjectIdStrings::clearAddressElementType() {
    if (hasAddressElementType()) {
         clear_has_addressElementType();
        _addressElementType = ::org::bosch::cm::navigation::NavigationSDSService::AddressElementType__COUNTRY;
     }
}

inline bool NamedObjectIdStrings::hasAddressElementType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline AddressElementType NamedObjectIdStrings::getAddressElementType () const {
    return _addressElementType;
}

inline void NamedObjectIdStrings::setAddressElementType (AddressElementType addressElementType_) {
    #ifndef NDEBUG
    if (!(AddressElementType_IsValid(addressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", addressElementType_, "AddressElementType", "addressElementType", "NamedObjectIdStrings");
    }
    #endif
    set_has_addressElementType();
    this->_addressElementType = addressElementType_;
}

inline void NamedObjectIdStrings::set_has_globalNamedObjectId () {
    _has_bits_[0] |= 1u << 0;
}

inline void NamedObjectIdStrings::clear_has_globalNamedObjectId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NamedObjectIdStrings::set_has_languageEntry () {
    _has_bits_[0] |= 1u << 1;
}

inline void NamedObjectIdStrings::clear_has_languageEntry () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NamedObjectIdStrings::set_has_sdsNamedStringsList () {
    _has_bits_[0] |= 1u << 2;
}

inline void NamedObjectIdStrings::clear_has_sdsNamedStringsList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void NamedObjectIdStrings::set_has_addressElementType () {
    _has_bits_[0] |= 1u << 3;
}

inline void NamedObjectIdStrings::clear_has_addressElementType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CityNamedObjectIdHasStreets::CityNamedObjectIdHasStreets ()  :
    _globalNamedObjectId (),
    _hasStreets (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CityNamedObjectIdHasStreets::CityNamedObjectIdHasStreets (const CityNamedObjectIdHasStreets &rhs)  :
    _globalNamedObjectId (),
    _hasStreets (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CityNamedObjectIdHasStreets::CityNamedObjectIdHasStreets (const GlobalNamedObjectId& globalNamedObjectId_, bool hasStreets_)  :
    _globalNamedObjectId (globalNamedObjectId_),
    _hasStreets (hasStreets_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CityNamedObjectIdHasStreets::~CityNamedObjectIdHasStreets() {
}

inline CityNamedObjectIdHasStreets& CityNamedObjectIdHasStreets::operator = (const CityNamedObjectIdHasStreets& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGlobalNamedObjectId()) {
            setGlobalNamedObjectId(rhs.getGlobalNamedObjectId());
        } else {
            clearGlobalNamedObjectId();
        }
        if (rhs.hasHasStreets()) {
            setHasStreets(rhs.getHasStreets());
        } else {
            clearHasStreets();
        }
    }
    return *this;
}

inline bool CityNamedObjectIdHasStreets::operator == (const CityNamedObjectIdHasStreets& rhs) const {
    return (((!hasGlobalNamedObjectId() && !rhs.hasGlobalNamedObjectId()) || getGlobalNamedObjectId() == rhs.getGlobalNamedObjectId()) &&
        ((!hasHasStreets() && !rhs.hasHasStreets()) || getHasStreets() == rhs.getHasStreets()));
}

inline bool CityNamedObjectIdHasStreets::operator != (const CityNamedObjectIdHasStreets& rhs) const {
    return ! (*this == rhs);
}

inline bool CityNamedObjectIdHasStreets::operator < (const CityNamedObjectIdHasStreets& rhs) const {
    if (hasGlobalNamedObjectId() || rhs.hasGlobalNamedObjectId()) {
        if (getGlobalNamedObjectId() < rhs.getGlobalNamedObjectId()) return true;
        if (getGlobalNamedObjectId() > rhs.getGlobalNamedObjectId()) return false;
    }
    if (hasHasStreets() || rhs.hasHasStreets()) {
        if (getHasStreets() < rhs.getHasStreets()) return true;
        if (getHasStreets() > rhs.getHasStreets()) return false;
    }
    return false;
}

inline bool CityNamedObjectIdHasStreets::operator > (const CityNamedObjectIdHasStreets& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CityNamedObjectIdHasStreets::clear() {
    clearGlobalNamedObjectId();
    clearHasStreets();
}

inline void CityNamedObjectIdHasStreets::clearGlobalNamedObjectId() {
    if (hasGlobalNamedObjectId()) {
         clear_has_globalNamedObjectId();
        _globalNamedObjectId.clear();
     }
}

inline bool CityNamedObjectIdHasStreets::hasGlobalNamedObjectId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GlobalNamedObjectId& CityNamedObjectIdHasStreets::getGlobalNamedObjectId () const {
    return _globalNamedObjectId;
}

inline GlobalNamedObjectId& CityNamedObjectIdHasStreets::getGlobalNamedObjectIdMutable () {
    set_has_globalNamedObjectId();
    return _globalNamedObjectId;
}

inline void CityNamedObjectIdHasStreets::setGlobalNamedObjectId (const GlobalNamedObjectId& globalNamedObjectId_) {
    set_has_globalNamedObjectId();
    this->_globalNamedObjectId = globalNamedObjectId_;
}

inline void CityNamedObjectIdHasStreets::clearHasStreets() {
    if (hasHasStreets()) {
         clear_has_hasStreets();
        _hasStreets = false;
     }
}

inline bool CityNamedObjectIdHasStreets::hasHasStreets () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool CityNamedObjectIdHasStreets::getHasStreets () const {
    return _hasStreets;
}

inline void CityNamedObjectIdHasStreets::setHasStreets (bool hasStreets_) {
    set_has_hasStreets();
    this->_hasStreets = hasStreets_;
}

inline void CityNamedObjectIdHasStreets::set_has_globalNamedObjectId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CityNamedObjectIdHasStreets::clear_has_globalNamedObjectId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CityNamedObjectIdHasStreets::set_has_hasStreets () {
    _has_bits_[0] |= 1u << 1;
}

inline void CityNamedObjectIdHasStreets::clear_has_hasStreets () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateRegionSpecifierRelations::UpdateRegionSpecifierRelations ()  :
    _updateRegionSpecifier (0u),
    _supplierId (0u),
    _productId (0u),
    _updateRegionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateRegionSpecifierRelations::UpdateRegionSpecifierRelations (const UpdateRegionSpecifierRelations &rhs)  :
    _updateRegionSpecifier (0u),
    _supplierId (0u),
    _productId (0u),
    _updateRegionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateRegionSpecifierRelations::UpdateRegionSpecifierRelations (uint16 updateRegionSpecifier_, uint8 supplierId_, uint32 productId_, uint16 updateRegionId_)  :
    _updateRegionSpecifier (updateRegionSpecifier_),
    _supplierId (supplierId_),
    _productId (productId_),
    _updateRegionId (updateRegionId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateRegionSpecifierRelations::~UpdateRegionSpecifierRelations() {
}

inline UpdateRegionSpecifierRelations& UpdateRegionSpecifierRelations::operator = (const UpdateRegionSpecifierRelations& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateRegionSpecifier()) {
            setUpdateRegionSpecifier(rhs.getUpdateRegionSpecifier());
        } else {
            clearUpdateRegionSpecifier();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasUpdateRegionId()) {
            setUpdateRegionId(rhs.getUpdateRegionId());
        } else {
            clearUpdateRegionId();
        }
    }
    return *this;
}

inline bool UpdateRegionSpecifierRelations::operator == (const UpdateRegionSpecifierRelations& rhs) const {
    return (((!hasUpdateRegionSpecifier() && !rhs.hasUpdateRegionSpecifier()) || getUpdateRegionSpecifier() == rhs.getUpdateRegionSpecifier()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasUpdateRegionId() && !rhs.hasUpdateRegionId()) || getUpdateRegionId() == rhs.getUpdateRegionId()));
}

inline bool UpdateRegionSpecifierRelations::operator != (const UpdateRegionSpecifierRelations& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateRegionSpecifierRelations::operator < (const UpdateRegionSpecifierRelations& rhs) const {
    if (hasUpdateRegionSpecifier() || rhs.hasUpdateRegionSpecifier()) {
        if (getUpdateRegionSpecifier() < rhs.getUpdateRegionSpecifier()) return true;
        if (getUpdateRegionSpecifier() > rhs.getUpdateRegionSpecifier()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasUpdateRegionId() || rhs.hasUpdateRegionId()) {
        if (getUpdateRegionId() < rhs.getUpdateRegionId()) return true;
        if (getUpdateRegionId() > rhs.getUpdateRegionId()) return false;
    }
    return false;
}

inline bool UpdateRegionSpecifierRelations::operator > (const UpdateRegionSpecifierRelations& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateRegionSpecifierRelations::clear() {
    clearUpdateRegionSpecifier();
    clearSupplierId();
    clearProductId();
    clearUpdateRegionId();
}

inline void UpdateRegionSpecifierRelations::clearUpdateRegionSpecifier() {
    if (hasUpdateRegionSpecifier()) {
         clear_has_updateRegionSpecifier();
        _updateRegionSpecifier = 0u;
     }
}

inline bool UpdateRegionSpecifierRelations::hasUpdateRegionSpecifier () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 UpdateRegionSpecifierRelations::getUpdateRegionSpecifier () const {
    return _updateRegionSpecifier;
}

inline void UpdateRegionSpecifierRelations::setUpdateRegionSpecifier (uint16 updateRegionSpecifier_) {
    set_has_updateRegionSpecifier();
    this->_updateRegionSpecifier = updateRegionSpecifier_;
}

inline void UpdateRegionSpecifierRelations::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool UpdateRegionSpecifierRelations::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 UpdateRegionSpecifierRelations::getSupplierId () const {
    return _supplierId;
}

inline void UpdateRegionSpecifierRelations::setSupplierId (uint8 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void UpdateRegionSpecifierRelations::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool UpdateRegionSpecifierRelations::hasProductId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 UpdateRegionSpecifierRelations::getProductId () const {
    return _productId;
}

inline void UpdateRegionSpecifierRelations::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void UpdateRegionSpecifierRelations::clearUpdateRegionId() {
    if (hasUpdateRegionId()) {
         clear_has_updateRegionId();
        _updateRegionId = 0u;
     }
}

inline bool UpdateRegionSpecifierRelations::hasUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 UpdateRegionSpecifierRelations::getUpdateRegionId () const {
    return _updateRegionId;
}

inline void UpdateRegionSpecifierRelations::setUpdateRegionId (uint16 updateRegionId_) {
    set_has_updateRegionId();
    this->_updateRegionId = updateRegionId_;
}

inline void UpdateRegionSpecifierRelations::set_has_updateRegionSpecifier () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateRegionSpecifierRelations::clear_has_updateRegionSpecifier () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateRegionSpecifierRelations::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateRegionSpecifierRelations::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateRegionSpecifierRelations::set_has_productId () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateRegionSpecifierRelations::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void UpdateRegionSpecifierRelations::set_has_updateRegionId () {
    _has_bits_[0] |= 1u << 3;
}

inline void UpdateRegionSpecifierRelations::clear_has_updateRegionId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  HandOverSessionStatus::HandOverSessionStatus ()  :
    _isHandOverScreenActive (false),
    _isLockOutModeActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HandOverSessionStatus::HandOverSessionStatus (const HandOverSessionStatus &rhs)  :
    _isHandOverScreenActive (false),
    _isLockOutModeActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HandOverSessionStatus::HandOverSessionStatus (bool isHandOverScreenActive_, bool isLockOutModeActive_)  :
    _isHandOverScreenActive (isHandOverScreenActive_),
    _isLockOutModeActive (isLockOutModeActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HandOverSessionStatus::~HandOverSessionStatus() {
}

inline HandOverSessionStatus& HandOverSessionStatus::operator = (const HandOverSessionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIsHandOverScreenActive()) {
            setIsHandOverScreenActive(rhs.getIsHandOverScreenActive());
        } else {
            clearIsHandOverScreenActive();
        }
        if (rhs.hasIsLockOutModeActive()) {
            setIsLockOutModeActive(rhs.getIsLockOutModeActive());
        } else {
            clearIsLockOutModeActive();
        }
    }
    return *this;
}

inline bool HandOverSessionStatus::operator == (const HandOverSessionStatus& rhs) const {
    return (((!hasIsHandOverScreenActive() && !rhs.hasIsHandOverScreenActive()) || getIsHandOverScreenActive() == rhs.getIsHandOverScreenActive()) &&
        ((!hasIsLockOutModeActive() && !rhs.hasIsLockOutModeActive()) || getIsLockOutModeActive() == rhs.getIsLockOutModeActive()));
}

inline bool HandOverSessionStatus::operator != (const HandOverSessionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HandOverSessionStatus::operator < (const HandOverSessionStatus& rhs) const {
    if (hasIsHandOverScreenActive() || rhs.hasIsHandOverScreenActive()) {
        if (getIsHandOverScreenActive() < rhs.getIsHandOverScreenActive()) return true;
        if (getIsHandOverScreenActive() > rhs.getIsHandOverScreenActive()) return false;
    }
    if (hasIsLockOutModeActive() || rhs.hasIsLockOutModeActive()) {
        if (getIsLockOutModeActive() < rhs.getIsLockOutModeActive()) return true;
        if (getIsLockOutModeActive() > rhs.getIsLockOutModeActive()) return false;
    }
    return false;
}

inline bool HandOverSessionStatus::operator > (const HandOverSessionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HandOverSessionStatus::clear() {
    clearIsHandOverScreenActive();
    clearIsLockOutModeActive();
}

inline void HandOverSessionStatus::clearIsHandOverScreenActive() {
    if (hasIsHandOverScreenActive()) {
         clear_has_isHandOverScreenActive();
        _isHandOverScreenActive = false;
     }
}

inline bool HandOverSessionStatus::hasIsHandOverScreenActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool HandOverSessionStatus::getIsHandOverScreenActive () const {
    return _isHandOverScreenActive;
}

inline void HandOverSessionStatus::setIsHandOverScreenActive (bool isHandOverScreenActive_) {
    set_has_isHandOverScreenActive();
    this->_isHandOverScreenActive = isHandOverScreenActive_;
}

inline void HandOverSessionStatus::clearIsLockOutModeActive() {
    if (hasIsLockOutModeActive()) {
         clear_has_isLockOutModeActive();
        _isLockOutModeActive = false;
     }
}

inline bool HandOverSessionStatus::hasIsLockOutModeActive () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool HandOverSessionStatus::getIsLockOutModeActive () const {
    return _isLockOutModeActive;
}

inline void HandOverSessionStatus::setIsLockOutModeActive (bool isLockOutModeActive_) {
    set_has_isLockOutModeActive();
    this->_isLockOutModeActive = isLockOutModeActive_;
}

inline void HandOverSessionStatus::set_has_isHandOverScreenActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void HandOverSessionStatus::clear_has_isHandOverScreenActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HandOverSessionStatus::set_has_isLockOutModeActive () {
    _has_bits_[0] |= 1u << 1;
}

inline void HandOverSessionStatus::clear_has_isLockOutModeActive () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SelectedDataItem::SelectedDataItem ()  :
    _hmiSelectedAddressElementType (::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType__COUNTRY),
    _data (),
    _sdsGlobalNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SelectedDataItem::SelectedDataItem (const SelectedDataItem &rhs)  :
    _hmiSelectedAddressElementType (::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType__COUNTRY),
    _data (),
    _sdsGlobalNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SelectedDataItem::SelectedDataItem (HMISelectedAddressElementType hmiSelectedAddressElementType_, const ::std::string& data_, const GlobalNamedObjectId& sdsGlobalNameObjectId_)  :
    _hmiSelectedAddressElementType (hmiSelectedAddressElementType_),
    _data (data_),
    _sdsGlobalNameObjectId (sdsGlobalNameObjectId_)
{
    #ifndef NDEBUG
    if (!(HMISelectedAddressElementType_IsValid(hmiSelectedAddressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", hmiSelectedAddressElementType_, "HMISelectedAddressElementType", "hmiSelectedAddressElementType", "SelectedDataItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SelectedDataItem::~SelectedDataItem() {
}

inline SelectedDataItem& SelectedDataItem::operator = (const SelectedDataItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHmiSelectedAddressElementType()) {
            setHmiSelectedAddressElementType(rhs.getHmiSelectedAddressElementType());
        } else {
            clearHmiSelectedAddressElementType();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasSdsGlobalNameObjectId()) {
            setSdsGlobalNameObjectId(rhs.getSdsGlobalNameObjectId());
        } else {
            clearSdsGlobalNameObjectId();
        }
    }
    return *this;
}

inline bool SelectedDataItem::operator == (const SelectedDataItem& rhs) const {
    return (((!hasHmiSelectedAddressElementType() && !rhs.hasHmiSelectedAddressElementType()) || getHmiSelectedAddressElementType() == rhs.getHmiSelectedAddressElementType()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasSdsGlobalNameObjectId() && !rhs.hasSdsGlobalNameObjectId()) || getSdsGlobalNameObjectId() == rhs.getSdsGlobalNameObjectId()));
}

inline bool SelectedDataItem::operator != (const SelectedDataItem& rhs) const {
    return ! (*this == rhs);
}

inline bool SelectedDataItem::operator < (const SelectedDataItem& rhs) const {
    if (hasHmiSelectedAddressElementType() || rhs.hasHmiSelectedAddressElementType()) {
        if ((uint32)getHmiSelectedAddressElementType() < (uint32)rhs.getHmiSelectedAddressElementType()) return true;
        if ((uint32)getHmiSelectedAddressElementType() > (uint32)rhs.getHmiSelectedAddressElementType()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasSdsGlobalNameObjectId() || rhs.hasSdsGlobalNameObjectId()) {
        if (getSdsGlobalNameObjectId() < rhs.getSdsGlobalNameObjectId()) return true;
        if (getSdsGlobalNameObjectId() > rhs.getSdsGlobalNameObjectId()) return false;
    }
    return false;
}

inline bool SelectedDataItem::operator > (const SelectedDataItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SelectedDataItem::clear() {
    clearHmiSelectedAddressElementType();
    clearData();
    clearSdsGlobalNameObjectId();
}

inline void SelectedDataItem::clearHmiSelectedAddressElementType() {
    if (hasHmiSelectedAddressElementType()) {
         clear_has_hmiSelectedAddressElementType();
        _hmiSelectedAddressElementType = ::org::bosch::cm::navigation::NavigationSDSService::HMISelectedAddressElementType__COUNTRY;
     }
}

inline bool SelectedDataItem::hasHmiSelectedAddressElementType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline HMISelectedAddressElementType SelectedDataItem::getHmiSelectedAddressElementType () const {
    return _hmiSelectedAddressElementType;
}

inline void SelectedDataItem::setHmiSelectedAddressElementType (HMISelectedAddressElementType hmiSelectedAddressElementType_) {
    #ifndef NDEBUG
    if (!(HMISelectedAddressElementType_IsValid(hmiSelectedAddressElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", hmiSelectedAddressElementType_, "HMISelectedAddressElementType", "hmiSelectedAddressElementType", "SelectedDataItem");
    }
    #endif
    set_has_hmiSelectedAddressElementType();
    this->_hmiSelectedAddressElementType = hmiSelectedAddressElementType_;
}

inline void SelectedDataItem::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SelectedDataItem::hasData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SelectedDataItem::getData () const {
    return _data;
}

inline ::std::string& SelectedDataItem::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SelectedDataItem::setData (const ::std::string& data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data = data_;
}

inline void SelectedDataItem::setData (const char* data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(data_);
}

inline void SelectedDataItem::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(value, size);
}

inline void SelectedDataItem::clearSdsGlobalNameObjectId() {
    if (hasSdsGlobalNameObjectId()) {
         clear_has_sdsGlobalNameObjectId();
        _sdsGlobalNameObjectId.clear();
     }
}

inline bool SelectedDataItem::hasSdsGlobalNameObjectId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const GlobalNamedObjectId& SelectedDataItem::getSdsGlobalNameObjectId () const {
    return _sdsGlobalNameObjectId;
}

inline GlobalNamedObjectId& SelectedDataItem::getSdsGlobalNameObjectIdMutable () {
    set_has_sdsGlobalNameObjectId();
    return _sdsGlobalNameObjectId;
}

inline void SelectedDataItem::setSdsGlobalNameObjectId (const GlobalNamedObjectId& sdsGlobalNameObjectId_) {
    set_has_sdsGlobalNameObjectId();
    this->_sdsGlobalNameObjectId = sdsGlobalNameObjectId_;
}

inline void SelectedDataItem::set_has_hmiSelectedAddressElementType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SelectedDataItem::clear_has_hmiSelectedAddressElementType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SelectedDataItem::set_has_data () {
    _has_bits_[0] |= 1u << 1;
}

inline void SelectedDataItem::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SelectedDataItem::set_has_sdsGlobalNameObjectId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SelectedDataItem::clear_has_sdsGlobalNameObjectId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SDSHandOverOptions::SDSHandOverOptions ()  :
    _isAmbigious (false),
    _cityHasStreet (false),
    _houseNumberInRange (false),
    _streetHasHouseNumber (false),
    _junctionAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDSHandOverOptions::SDSHandOverOptions (const SDSHandOverOptions &rhs)  :
    _isAmbigious (false),
    _cityHasStreet (false),
    _houseNumberInRange (false),
    _streetHasHouseNumber (false),
    _junctionAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDSHandOverOptions::SDSHandOverOptions (bool isAmbigious_, bool cityHasStreet_, bool houseNumberInRange_, bool streetHasHouseNumber_, bool junctionAvailable_)  :
    _isAmbigious (isAmbigious_),
    _cityHasStreet (cityHasStreet_),
    _houseNumberInRange (houseNumberInRange_),
    _streetHasHouseNumber (streetHasHouseNumber_),
    _junctionAvailable (junctionAvailable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDSHandOverOptions::~SDSHandOverOptions() {
}

inline SDSHandOverOptions& SDSHandOverOptions::operator = (const SDSHandOverOptions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIsAmbigious()) {
            setIsAmbigious(rhs.getIsAmbigious());
        } else {
            clearIsAmbigious();
        }
        if (rhs.hasCityHasStreet()) {
            setCityHasStreet(rhs.getCityHasStreet());
        } else {
            clearCityHasStreet();
        }
        if (rhs.hasHouseNumberInRange()) {
            setHouseNumberInRange(rhs.getHouseNumberInRange());
        } else {
            clearHouseNumberInRange();
        }
        if (rhs.hasStreetHasHouseNumber()) {
            setStreetHasHouseNumber(rhs.getStreetHasHouseNumber());
        } else {
            clearStreetHasHouseNumber();
        }
        if (rhs.hasJunctionAvailable()) {
            setJunctionAvailable(rhs.getJunctionAvailable());
        } else {
            clearJunctionAvailable();
        }
    }
    return *this;
}

inline bool SDSHandOverOptions::operator == (const SDSHandOverOptions& rhs) const {
    return (((!hasIsAmbigious() && !rhs.hasIsAmbigious()) || getIsAmbigious() == rhs.getIsAmbigious()) &&
        ((!hasCityHasStreet() && !rhs.hasCityHasStreet()) || getCityHasStreet() == rhs.getCityHasStreet()) &&
        ((!hasHouseNumberInRange() && !rhs.hasHouseNumberInRange()) || getHouseNumberInRange() == rhs.getHouseNumberInRange()) &&
        ((!hasStreetHasHouseNumber() && !rhs.hasStreetHasHouseNumber()) || getStreetHasHouseNumber() == rhs.getStreetHasHouseNumber()) &&
        ((!hasJunctionAvailable() && !rhs.hasJunctionAvailable()) || getJunctionAvailable() == rhs.getJunctionAvailable()));
}

inline bool SDSHandOverOptions::operator != (const SDSHandOverOptions& rhs) const {
    return ! (*this == rhs);
}

inline bool SDSHandOverOptions::operator < (const SDSHandOverOptions& rhs) const {
    if (hasIsAmbigious() || rhs.hasIsAmbigious()) {
        if (getIsAmbigious() < rhs.getIsAmbigious()) return true;
        if (getIsAmbigious() > rhs.getIsAmbigious()) return false;
    }
    if (hasCityHasStreet() || rhs.hasCityHasStreet()) {
        if (getCityHasStreet() < rhs.getCityHasStreet()) return true;
        if (getCityHasStreet() > rhs.getCityHasStreet()) return false;
    }
    if (hasHouseNumberInRange() || rhs.hasHouseNumberInRange()) {
        if (getHouseNumberInRange() < rhs.getHouseNumberInRange()) return true;
        if (getHouseNumberInRange() > rhs.getHouseNumberInRange()) return false;
    }
    if (hasStreetHasHouseNumber() || rhs.hasStreetHasHouseNumber()) {
        if (getStreetHasHouseNumber() < rhs.getStreetHasHouseNumber()) return true;
        if (getStreetHasHouseNumber() > rhs.getStreetHasHouseNumber()) return false;
    }
    if (hasJunctionAvailable() || rhs.hasJunctionAvailable()) {
        if (getJunctionAvailable() < rhs.getJunctionAvailable()) return true;
        if (getJunctionAvailable() > rhs.getJunctionAvailable()) return false;
    }
    return false;
}

inline bool SDSHandOverOptions::operator > (const SDSHandOverOptions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDSHandOverOptions::clear() {
    clearIsAmbigious();
    clearCityHasStreet();
    clearHouseNumberInRange();
    clearStreetHasHouseNumber();
    clearJunctionAvailable();
}

inline void SDSHandOverOptions::clearIsAmbigious() {
    if (hasIsAmbigious()) {
         clear_has_isAmbigious();
        _isAmbigious = false;
     }
}

inline bool SDSHandOverOptions::hasIsAmbigious () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SDSHandOverOptions::getIsAmbigious () const {
    return _isAmbigious;
}

inline void SDSHandOverOptions::setIsAmbigious (bool isAmbigious_) {
    set_has_isAmbigious();
    this->_isAmbigious = isAmbigious_;
}

inline void SDSHandOverOptions::clearCityHasStreet() {
    if (hasCityHasStreet()) {
         clear_has_cityHasStreet();
        _cityHasStreet = false;
     }
}

inline bool SDSHandOverOptions::hasCityHasStreet () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SDSHandOverOptions::getCityHasStreet () const {
    return _cityHasStreet;
}

inline void SDSHandOverOptions::setCityHasStreet (bool cityHasStreet_) {
    set_has_cityHasStreet();
    this->_cityHasStreet = cityHasStreet_;
}

inline void SDSHandOverOptions::clearHouseNumberInRange() {
    if (hasHouseNumberInRange()) {
         clear_has_houseNumberInRange();
        _houseNumberInRange = false;
     }
}

inline bool SDSHandOverOptions::hasHouseNumberInRange () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SDSHandOverOptions::getHouseNumberInRange () const {
    return _houseNumberInRange;
}

inline void SDSHandOverOptions::setHouseNumberInRange (bool houseNumberInRange_) {
    set_has_houseNumberInRange();
    this->_houseNumberInRange = houseNumberInRange_;
}

inline void SDSHandOverOptions::clearStreetHasHouseNumber() {
    if (hasStreetHasHouseNumber()) {
         clear_has_streetHasHouseNumber();
        _streetHasHouseNumber = false;
     }
}

inline bool SDSHandOverOptions::hasStreetHasHouseNumber () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool SDSHandOverOptions::getStreetHasHouseNumber () const {
    return _streetHasHouseNumber;
}

inline void SDSHandOverOptions::setStreetHasHouseNumber (bool streetHasHouseNumber_) {
    set_has_streetHasHouseNumber();
    this->_streetHasHouseNumber = streetHasHouseNumber_;
}

inline void SDSHandOverOptions::clearJunctionAvailable() {
    if (hasJunctionAvailable()) {
         clear_has_junctionAvailable();
        _junctionAvailable = false;
     }
}

inline bool SDSHandOverOptions::hasJunctionAvailable () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool SDSHandOverOptions::getJunctionAvailable () const {
    return _junctionAvailable;
}

inline void SDSHandOverOptions::setJunctionAvailable (bool junctionAvailable_) {
    set_has_junctionAvailable();
    this->_junctionAvailable = junctionAvailable_;
}

inline void SDSHandOverOptions::set_has_isAmbigious () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDSHandOverOptions::clear_has_isAmbigious () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SDSHandOverOptions::set_has_cityHasStreet () {
    _has_bits_[0] |= 1u << 1;
}

inline void SDSHandOverOptions::clear_has_cityHasStreet () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SDSHandOverOptions::set_has_houseNumberInRange () {
    _has_bits_[0] |= 1u << 2;
}

inline void SDSHandOverOptions::clear_has_houseNumberInRange () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SDSHandOverOptions::set_has_streetHasHouseNumber () {
    _has_bits_[0] |= 1u << 3;
}

inline void SDSHandOverOptions::clear_has_streetHasHouseNumber () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SDSHandOverOptions::set_has_junctionAvailable () {
    _has_bits_[0] |= 1u << 4;
}

inline void SDSHandOverOptions::clear_has_junctionAvailable () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  NDSNamedObjectData::NDSNamedObjectData ()  :
    _objectName (),
    _ndsNamedObjectId (0u),
    _NdsUpdateRegionSpecifier (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NDSNamedObjectData::NDSNamedObjectData (const NDSNamedObjectData &rhs)  :
    _objectName (),
    _ndsNamedObjectId (0u),
    _NdsUpdateRegionSpecifier (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NDSNamedObjectData::NDSNamedObjectData (const ::std::string& objectName_, uint32 ndsNamedObjectId_, uint16 NdsUpdateRegionSpecifier_)  :
    _objectName (objectName_),
    _ndsNamedObjectId (ndsNamedObjectId_),
    _NdsUpdateRegionSpecifier (NdsUpdateRegionSpecifier_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NDSNamedObjectData::~NDSNamedObjectData() {
}

inline NDSNamedObjectData& NDSNamedObjectData::operator = (const NDSNamedObjectData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasObjectName()) {
            setObjectName(rhs.getObjectName());
        } else {
            clearObjectName();
        }
        if (rhs.hasNdsNamedObjectId()) {
            setNdsNamedObjectId(rhs.getNdsNamedObjectId());
        } else {
            clearNdsNamedObjectId();
        }
        if (rhs.hasNdsUpdateRegionSpecifier()) {
            setNdsUpdateRegionSpecifier(rhs.getNdsUpdateRegionSpecifier());
        } else {
            clearNdsUpdateRegionSpecifier();
        }
    }
    return *this;
}

inline bool NDSNamedObjectData::operator == (const NDSNamedObjectData& rhs) const {
    return (((!hasObjectName() && !rhs.hasObjectName()) || getObjectName() == rhs.getObjectName()) &&
        ((!hasNdsNamedObjectId() && !rhs.hasNdsNamedObjectId()) || getNdsNamedObjectId() == rhs.getNdsNamedObjectId()) &&
        ((!hasNdsUpdateRegionSpecifier() && !rhs.hasNdsUpdateRegionSpecifier()) || getNdsUpdateRegionSpecifier() == rhs.getNdsUpdateRegionSpecifier()));
}

inline bool NDSNamedObjectData::operator != (const NDSNamedObjectData& rhs) const {
    return ! (*this == rhs);
}

inline bool NDSNamedObjectData::operator < (const NDSNamedObjectData& rhs) const {
    if (hasObjectName() || rhs.hasObjectName()) {
        if (getObjectName() < rhs.getObjectName()) return true;
        if (getObjectName() > rhs.getObjectName()) return false;
    }
    if (hasNdsNamedObjectId() || rhs.hasNdsNamedObjectId()) {
        if (getNdsNamedObjectId() < rhs.getNdsNamedObjectId()) return true;
        if (getNdsNamedObjectId() > rhs.getNdsNamedObjectId()) return false;
    }
    if (hasNdsUpdateRegionSpecifier() || rhs.hasNdsUpdateRegionSpecifier()) {
        if (getNdsUpdateRegionSpecifier() < rhs.getNdsUpdateRegionSpecifier()) return true;
        if (getNdsUpdateRegionSpecifier() > rhs.getNdsUpdateRegionSpecifier()) return false;
    }
    return false;
}

inline bool NDSNamedObjectData::operator > (const NDSNamedObjectData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NDSNamedObjectData::clear() {
    clearObjectName();
    clearNdsNamedObjectId();
    clearNdsUpdateRegionSpecifier();
}

inline void NDSNamedObjectData::clearObjectName() {
    if (hasObjectName()) {
         clear_has_objectName();
        _objectName.clear();
     }
}

inline bool NDSNamedObjectData::hasObjectName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NDSNamedObjectData::getObjectName () const {
    return _objectName;
}

inline ::std::string& NDSNamedObjectData::getObjectNameMutable () {
    set_has_objectName();
    return _objectName;
}

inline void NDSNamedObjectData::setObjectName (const ::std::string& objectName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectName();
    this->_objectName = objectName_;
}

inline void NDSNamedObjectData::setObjectName (const char* objectName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectName();
    this->_objectName.assign(objectName_);
}

inline void NDSNamedObjectData::setObjectName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectName();
    this->_objectName.assign(value, size);
}

inline void NDSNamedObjectData::clearNdsNamedObjectId() {
    if (hasNdsNamedObjectId()) {
         clear_has_ndsNamedObjectId();
        _ndsNamedObjectId = 0u;
     }
}

inline bool NDSNamedObjectData::hasNdsNamedObjectId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 NDSNamedObjectData::getNdsNamedObjectId () const {
    return _ndsNamedObjectId;
}

inline void NDSNamedObjectData::setNdsNamedObjectId (uint32 ndsNamedObjectId_) {
    set_has_ndsNamedObjectId();
    this->_ndsNamedObjectId = ndsNamedObjectId_;
}

inline void NDSNamedObjectData::clearNdsUpdateRegionSpecifier() {
    if (hasNdsUpdateRegionSpecifier()) {
         clear_has_NdsUpdateRegionSpecifier();
        _NdsUpdateRegionSpecifier = 0u;
     }
}

inline bool NDSNamedObjectData::hasNdsUpdateRegionSpecifier () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 NDSNamedObjectData::getNdsUpdateRegionSpecifier () const {
    return _NdsUpdateRegionSpecifier;
}

inline void NDSNamedObjectData::setNdsUpdateRegionSpecifier (uint16 NdsUpdateRegionSpecifier_) {
    set_has_NdsUpdateRegionSpecifier();
    this->_NdsUpdateRegionSpecifier = NdsUpdateRegionSpecifier_;
}

inline void NDSNamedObjectData::set_has_objectName () {
    _has_bits_[0] |= 1u << 0;
}

inline void NDSNamedObjectData::clear_has_objectName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NDSNamedObjectData::set_has_ndsNamedObjectId () {
    _has_bits_[0] |= 1u << 1;
}

inline void NDSNamedObjectData::clear_has_ndsNamedObjectId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NDSNamedObjectData::set_has_NdsUpdateRegionSpecifier () {
    _has_bits_[0] |= 1u << 2;
}

inline void NDSNamedObjectData::clear_has_NdsUpdateRegionSpecifier () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PositionInfo::PositionInfo ()  :
    _country (),
    _province (),
    _city (),
    _cityDistrict (),
    _street (),
    _streetNumber (),
    _currentCountry (),
    _currentState (),
    _currentCity (),
    _currentCityDistrict (),
    _currentStreet (),
    _currentIntersection (),
    _currentZipCode (),
    _isUniqueIdValid (false),
    _uniqueId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionInfo::PositionInfo (const PositionInfo &rhs)  :
    _country (),
    _province (),
    _city (),
    _cityDistrict (),
    _street (),
    _streetNumber (),
    _currentCountry (),
    _currentState (),
    _currentCity (),
    _currentCityDistrict (),
    _currentStreet (),
    _currentIntersection (),
    _currentZipCode (),
    _isUniqueIdValid (false),
    _uniqueId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionInfo::PositionInfo (const ::std::string& country_, const ::std::string& province_, const ::std::string& city_, const ::std::string& cityDistrict_, const ::std::string& street_, const ::std::string& streetNumber_, const NDSNamedObjectData& currentCountry_, const NDSNamedObjectData& currentState_, const NDSNamedObjectData& currentCity_, const NDSNamedObjectData& currentCityDistrict_, const NDSNamedObjectData& currentStreet_, const NDSNamedObjectData& currentIntersection_, const NDSNamedObjectData& currentZipCode_, bool isUniqueIdValid_, uint32 uniqueId_)  :
    _country (country_),
    _province (province_),
    _city (city_),
    _cityDistrict (cityDistrict_),
    _street (street_),
    _streetNumber (streetNumber_),
    _currentCountry (currentCountry_),
    _currentState (currentState_),
    _currentCity (currentCity_),
    _currentCityDistrict (currentCityDistrict_),
    _currentStreet (currentStreet_),
    _currentIntersection (currentIntersection_),
    _currentZipCode (currentZipCode_),
    _isUniqueIdValid (isUniqueIdValid_),
    _uniqueId (uniqueId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (province_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (city_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (cityDistrict_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (street_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (streetNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PositionInfo::~PositionInfo() {
}

inline PositionInfo& PositionInfo::operator = (const PositionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCountry()) {
            setCountry(rhs.getCountry());
        } else {
            clearCountry();
        }
        if (rhs.hasProvince()) {
            setProvince(rhs.getProvince());
        } else {
            clearProvince();
        }
        if (rhs.hasCity()) {
            setCity(rhs.getCity());
        } else {
            clearCity();
        }
        if (rhs.hasCityDistrict()) {
            setCityDistrict(rhs.getCityDistrict());
        } else {
            clearCityDistrict();
        }
        if (rhs.hasStreet()) {
            setStreet(rhs.getStreet());
        } else {
            clearStreet();
        }
        if (rhs.hasStreetNumber()) {
            setStreetNumber(rhs.getStreetNumber());
        } else {
            clearStreetNumber();
        }
        if (rhs.hasCurrentCountry()) {
            setCurrentCountry(rhs.getCurrentCountry());
        } else {
            clearCurrentCountry();
        }
        if (rhs.hasCurrentState()) {
            setCurrentState(rhs.getCurrentState());
        } else {
            clearCurrentState();
        }
        if (rhs.hasCurrentCity()) {
            setCurrentCity(rhs.getCurrentCity());
        } else {
            clearCurrentCity();
        }
        if (rhs.hasCurrentCityDistrict()) {
            setCurrentCityDistrict(rhs.getCurrentCityDistrict());
        } else {
            clearCurrentCityDistrict();
        }
        if (rhs.hasCurrentStreet()) {
            setCurrentStreet(rhs.getCurrentStreet());
        } else {
            clearCurrentStreet();
        }
        if (rhs.hasCurrentIntersection()) {
            setCurrentIntersection(rhs.getCurrentIntersection());
        } else {
            clearCurrentIntersection();
        }
        if (rhs.hasCurrentZipCode()) {
            setCurrentZipCode(rhs.getCurrentZipCode());
        } else {
            clearCurrentZipCode();
        }
        if (rhs.hasIsUniqueIdValid()) {
            setIsUniqueIdValid(rhs.getIsUniqueIdValid());
        } else {
            clearIsUniqueIdValid();
        }
        if (rhs.hasUniqueId()) {
            setUniqueId(rhs.getUniqueId());
        } else {
            clearUniqueId();
        }
    }
    return *this;
}

inline bool PositionInfo::operator == (const PositionInfo& rhs) const {
    return (((!hasCountry() && !rhs.hasCountry()) || getCountry() == rhs.getCountry()) &&
        ((!hasProvince() && !rhs.hasProvince()) || getProvince() == rhs.getProvince()) &&
        ((!hasCity() && !rhs.hasCity()) || getCity() == rhs.getCity()) &&
        ((!hasCityDistrict() && !rhs.hasCityDistrict()) || getCityDistrict() == rhs.getCityDistrict()) &&
        ((!hasStreet() && !rhs.hasStreet()) || getStreet() == rhs.getStreet()) &&
        ((!hasStreetNumber() && !rhs.hasStreetNumber()) || getStreetNumber() == rhs.getStreetNumber()) &&
        ((!hasCurrentCountry() && !rhs.hasCurrentCountry()) || getCurrentCountry() == rhs.getCurrentCountry()) &&
        ((!hasCurrentState() && !rhs.hasCurrentState()) || getCurrentState() == rhs.getCurrentState()) &&
        ((!hasCurrentCity() && !rhs.hasCurrentCity()) || getCurrentCity() == rhs.getCurrentCity()) &&
        ((!hasCurrentCityDistrict() && !rhs.hasCurrentCityDistrict()) || getCurrentCityDistrict() == rhs.getCurrentCityDistrict()) &&
        ((!hasCurrentStreet() && !rhs.hasCurrentStreet()) || getCurrentStreet() == rhs.getCurrentStreet()) &&
        ((!hasCurrentIntersection() && !rhs.hasCurrentIntersection()) || getCurrentIntersection() == rhs.getCurrentIntersection()) &&
        ((!hasCurrentZipCode() && !rhs.hasCurrentZipCode()) || getCurrentZipCode() == rhs.getCurrentZipCode()) &&
        ((!hasIsUniqueIdValid() && !rhs.hasIsUniqueIdValid()) || getIsUniqueIdValid() == rhs.getIsUniqueIdValid()) &&
        ((!hasUniqueId() && !rhs.hasUniqueId()) || getUniqueId() == rhs.getUniqueId()));
}

inline bool PositionInfo::operator != (const PositionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionInfo::operator < (const PositionInfo& rhs) const {
    if (hasCountry() || rhs.hasCountry()) {
        if (getCountry() < rhs.getCountry()) return true;
        if (getCountry() > rhs.getCountry()) return false;
    }
    if (hasProvince() || rhs.hasProvince()) {
        if (getProvince() < rhs.getProvince()) return true;
        if (getProvince() > rhs.getProvince()) return false;
    }
    if (hasCity() || rhs.hasCity()) {
        if (getCity() < rhs.getCity()) return true;
        if (getCity() > rhs.getCity()) return false;
    }
    if (hasCityDistrict() || rhs.hasCityDistrict()) {
        if (getCityDistrict() < rhs.getCityDistrict()) return true;
        if (getCityDistrict() > rhs.getCityDistrict()) return false;
    }
    if (hasStreet() || rhs.hasStreet()) {
        if (getStreet() < rhs.getStreet()) return true;
        if (getStreet() > rhs.getStreet()) return false;
    }
    if (hasStreetNumber() || rhs.hasStreetNumber()) {
        if (getStreetNumber() < rhs.getStreetNumber()) return true;
        if (getStreetNumber() > rhs.getStreetNumber()) return false;
    }
    if (hasCurrentCountry() || rhs.hasCurrentCountry()) {
        if (getCurrentCountry() < rhs.getCurrentCountry()) return true;
        if (getCurrentCountry() > rhs.getCurrentCountry()) return false;
    }
    if (hasCurrentState() || rhs.hasCurrentState()) {
        if (getCurrentState() < rhs.getCurrentState()) return true;
        if (getCurrentState() > rhs.getCurrentState()) return false;
    }
    if (hasCurrentCity() || rhs.hasCurrentCity()) {
        if (getCurrentCity() < rhs.getCurrentCity()) return true;
        if (getCurrentCity() > rhs.getCurrentCity()) return false;
    }
    if (hasCurrentCityDistrict() || rhs.hasCurrentCityDistrict()) {
        if (getCurrentCityDistrict() < rhs.getCurrentCityDistrict()) return true;
        if (getCurrentCityDistrict() > rhs.getCurrentCityDistrict()) return false;
    }
    if (hasCurrentStreet() || rhs.hasCurrentStreet()) {
        if (getCurrentStreet() < rhs.getCurrentStreet()) return true;
        if (getCurrentStreet() > rhs.getCurrentStreet()) return false;
    }
    if (hasCurrentIntersection() || rhs.hasCurrentIntersection()) {
        if (getCurrentIntersection() < rhs.getCurrentIntersection()) return true;
        if (getCurrentIntersection() > rhs.getCurrentIntersection()) return false;
    }
    if (hasCurrentZipCode() || rhs.hasCurrentZipCode()) {
        if (getCurrentZipCode() < rhs.getCurrentZipCode()) return true;
        if (getCurrentZipCode() > rhs.getCurrentZipCode()) return false;
    }
    if (hasIsUniqueIdValid() || rhs.hasIsUniqueIdValid()) {
        if (getIsUniqueIdValid() < rhs.getIsUniqueIdValid()) return true;
        if (getIsUniqueIdValid() > rhs.getIsUniqueIdValid()) return false;
    }
    if (hasUniqueId() || rhs.hasUniqueId()) {
        if (getUniqueId() < rhs.getUniqueId()) return true;
        if (getUniqueId() > rhs.getUniqueId()) return false;
    }
    return false;
}

inline bool PositionInfo::operator > (const PositionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionInfo::clear() {
    clearCountry();
    clearProvince();
    clearCity();
    clearCityDistrict();
    clearStreet();
    clearStreetNumber();
    clearCurrentCountry();
    clearCurrentState();
    clearCurrentCity();
    clearCurrentCityDistrict();
    clearCurrentStreet();
    clearCurrentIntersection();
    clearCurrentZipCode();
    clearIsUniqueIdValid();
    clearUniqueId();
}

inline void PositionInfo::clearCountry() {
    if (hasCountry()) {
         clear_has_country();
        _country.clear();
     }
}

inline bool PositionInfo::hasCountry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PositionInfo::getCountry () const {
    return _country;
}

inline ::std::string& PositionInfo::getCountryMutable () {
    set_has_country();
    return _country;
}

inline void PositionInfo::setCountry (const ::std::string& country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    this->_country = country_;
}

inline void PositionInfo::setCountry (const char* country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    this->_country.assign(country_);
}

inline void PositionInfo::setCountry (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    this->_country.assign(value, size);
}

inline void PositionInfo::clearProvince() {
    if (hasProvince()) {
         clear_has_province();
        _province.clear();
     }
}

inline bool PositionInfo::hasProvince () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PositionInfo::getProvince () const {
    return _province;
}

inline ::std::string& PositionInfo::getProvinceMutable () {
    set_has_province();
    return _province;
}

inline void PositionInfo::setProvince (const ::std::string& province_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (province_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_province();
    this->_province = province_;
}

inline void PositionInfo::setProvince (const char* province_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (province_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_province();
    this->_province.assign(province_);
}

inline void PositionInfo::setProvince (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_province();
    this->_province.assign(value, size);
}

inline void PositionInfo::clearCity() {
    if (hasCity()) {
         clear_has_city();
        _city.clear();
     }
}

inline bool PositionInfo::hasCity () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& PositionInfo::getCity () const {
    return _city;
}

inline ::std::string& PositionInfo::getCityMutable () {
    set_has_city();
    return _city;
}

inline void PositionInfo::setCity (const ::std::string& city_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (city_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_city();
    this->_city = city_;
}

inline void PositionInfo::setCity (const char* city_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (city_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_city();
    this->_city.assign(city_);
}

inline void PositionInfo::setCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_city();
    this->_city.assign(value, size);
}

inline void PositionInfo::clearCityDistrict() {
    if (hasCityDistrict()) {
         clear_has_cityDistrict();
        _cityDistrict.clear();
     }
}

inline bool PositionInfo::hasCityDistrict () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& PositionInfo::getCityDistrict () const {
    return _cityDistrict;
}

inline ::std::string& PositionInfo::getCityDistrictMutable () {
    set_has_cityDistrict();
    return _cityDistrict;
}

inline void PositionInfo::setCityDistrict (const ::std::string& cityDistrict_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (cityDistrict_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_cityDistrict();
    this->_cityDistrict = cityDistrict_;
}

inline void PositionInfo::setCityDistrict (const char* cityDistrict_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (cityDistrict_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_cityDistrict();
    this->_cityDistrict.assign(cityDistrict_);
}

inline void PositionInfo::setCityDistrict (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_cityDistrict();
    this->_cityDistrict.assign(value, size);
}

inline void PositionInfo::clearStreet() {
    if (hasStreet()) {
         clear_has_street();
        _street.clear();
     }
}

inline bool PositionInfo::hasStreet () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& PositionInfo::getStreet () const {
    return _street;
}

inline ::std::string& PositionInfo::getStreetMutable () {
    set_has_street();
    return _street;
}

inline void PositionInfo::setStreet (const ::std::string& street_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (street_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_street();
    this->_street = street_;
}

inline void PositionInfo::setStreet (const char* street_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (street_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_street();
    this->_street.assign(street_);
}

inline void PositionInfo::setStreet (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_street();
    this->_street.assign(value, size);
}

inline void PositionInfo::clearStreetNumber() {
    if (hasStreetNumber()) {
         clear_has_streetNumber();
        _streetNumber.clear();
     }
}

inline bool PositionInfo::hasStreetNumber () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& PositionInfo::getStreetNumber () const {
    return _streetNumber;
}

inline ::std::string& PositionInfo::getStreetNumberMutable () {
    set_has_streetNumber();
    return _streetNumber;
}

inline void PositionInfo::setStreetNumber (const ::std::string& streetNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (streetNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_streetNumber();
    this->_streetNumber = streetNumber_;
}

inline void PositionInfo::setStreetNumber (const char* streetNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (streetNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_streetNumber();
    this->_streetNumber.assign(streetNumber_);
}

inline void PositionInfo::setStreetNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_streetNumber();
    this->_streetNumber.assign(value, size);
}

inline void PositionInfo::clearCurrentCountry() {
    if (hasCurrentCountry()) {
         clear_has_currentCountry();
        _currentCountry.clear();
     }
}

inline bool PositionInfo::hasCurrentCountry () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentCountry () const {
    return _currentCountry;
}

inline NDSNamedObjectData& PositionInfo::getCurrentCountryMutable () {
    set_has_currentCountry();
    return _currentCountry;
}

inline void PositionInfo::setCurrentCountry (const NDSNamedObjectData& currentCountry_) {
    set_has_currentCountry();
    this->_currentCountry = currentCountry_;
}

inline void PositionInfo::clearCurrentState() {
    if (hasCurrentState()) {
         clear_has_currentState();
        _currentState.clear();
     }
}

inline bool PositionInfo::hasCurrentState () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentState () const {
    return _currentState;
}

inline NDSNamedObjectData& PositionInfo::getCurrentStateMutable () {
    set_has_currentState();
    return _currentState;
}

inline void PositionInfo::setCurrentState (const NDSNamedObjectData& currentState_) {
    set_has_currentState();
    this->_currentState = currentState_;
}

inline void PositionInfo::clearCurrentCity() {
    if (hasCurrentCity()) {
         clear_has_currentCity();
        _currentCity.clear();
     }
}

inline bool PositionInfo::hasCurrentCity () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentCity () const {
    return _currentCity;
}

inline NDSNamedObjectData& PositionInfo::getCurrentCityMutable () {
    set_has_currentCity();
    return _currentCity;
}

inline void PositionInfo::setCurrentCity (const NDSNamedObjectData& currentCity_) {
    set_has_currentCity();
    this->_currentCity = currentCity_;
}

inline void PositionInfo::clearCurrentCityDistrict() {
    if (hasCurrentCityDistrict()) {
         clear_has_currentCityDistrict();
        _currentCityDistrict.clear();
     }
}

inline bool PositionInfo::hasCurrentCityDistrict () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentCityDistrict () const {
    return _currentCityDistrict;
}

inline NDSNamedObjectData& PositionInfo::getCurrentCityDistrictMutable () {
    set_has_currentCityDistrict();
    return _currentCityDistrict;
}

inline void PositionInfo::setCurrentCityDistrict (const NDSNamedObjectData& currentCityDistrict_) {
    set_has_currentCityDistrict();
    this->_currentCityDistrict = currentCityDistrict_;
}

inline void PositionInfo::clearCurrentStreet() {
    if (hasCurrentStreet()) {
         clear_has_currentStreet();
        _currentStreet.clear();
     }
}

inline bool PositionInfo::hasCurrentStreet () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentStreet () const {
    return _currentStreet;
}

inline NDSNamedObjectData& PositionInfo::getCurrentStreetMutable () {
    set_has_currentStreet();
    return _currentStreet;
}

inline void PositionInfo::setCurrentStreet (const NDSNamedObjectData& currentStreet_) {
    set_has_currentStreet();
    this->_currentStreet = currentStreet_;
}

inline void PositionInfo::clearCurrentIntersection() {
    if (hasCurrentIntersection()) {
         clear_has_currentIntersection();
        _currentIntersection.clear();
     }
}

inline bool PositionInfo::hasCurrentIntersection () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentIntersection () const {
    return _currentIntersection;
}

inline NDSNamedObjectData& PositionInfo::getCurrentIntersectionMutable () {
    set_has_currentIntersection();
    return _currentIntersection;
}

inline void PositionInfo::setCurrentIntersection (const NDSNamedObjectData& currentIntersection_) {
    set_has_currentIntersection();
    this->_currentIntersection = currentIntersection_;
}

inline void PositionInfo::clearCurrentZipCode() {
    if (hasCurrentZipCode()) {
         clear_has_currentZipCode();
        _currentZipCode.clear();
     }
}

inline bool PositionInfo::hasCurrentZipCode () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const NDSNamedObjectData& PositionInfo::getCurrentZipCode () const {
    return _currentZipCode;
}

inline NDSNamedObjectData& PositionInfo::getCurrentZipCodeMutable () {
    set_has_currentZipCode();
    return _currentZipCode;
}

inline void PositionInfo::setCurrentZipCode (const NDSNamedObjectData& currentZipCode_) {
    set_has_currentZipCode();
    this->_currentZipCode = currentZipCode_;
}

inline void PositionInfo::clearIsUniqueIdValid() {
    if (hasIsUniqueIdValid()) {
         clear_has_isUniqueIdValid();
        _isUniqueIdValid = false;
     }
}

inline bool PositionInfo::hasIsUniqueIdValid () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool PositionInfo::getIsUniqueIdValid () const {
    return _isUniqueIdValid;
}

inline void PositionInfo::setIsUniqueIdValid (bool isUniqueIdValid_) {
    set_has_isUniqueIdValid();
    this->_isUniqueIdValid = isUniqueIdValid_;
}

inline void PositionInfo::clearUniqueId() {
    if (hasUniqueId()) {
         clear_has_uniqueId();
        _uniqueId = 0u;
     }
}

inline bool PositionInfo::hasUniqueId () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint32 PositionInfo::getUniqueId () const {
    return _uniqueId;
}

inline void PositionInfo::setUniqueId (uint32 uniqueId_) {
    set_has_uniqueId();
    this->_uniqueId = uniqueId_;
}

inline void PositionInfo::set_has_country () {
    _has_bits_[0] |= 1u << 0;
}

inline void PositionInfo::clear_has_country () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PositionInfo::set_has_province () {
    _has_bits_[0] |= 1u << 1;
}

inline void PositionInfo::clear_has_province () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PositionInfo::set_has_city () {
    _has_bits_[0] |= 1u << 2;
}

inline void PositionInfo::clear_has_city () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PositionInfo::set_has_cityDistrict () {
    _has_bits_[0] |= 1u << 3;
}

inline void PositionInfo::clear_has_cityDistrict () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void PositionInfo::set_has_street () {
    _has_bits_[0] |= 1u << 4;
}

inline void PositionInfo::clear_has_street () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void PositionInfo::set_has_streetNumber () {
    _has_bits_[0] |= 1u << 5;
}

inline void PositionInfo::clear_has_streetNumber () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void PositionInfo::set_has_currentCountry () {
    _has_bits_[0] |= 1u << 6;
}

inline void PositionInfo::clear_has_currentCountry () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void PositionInfo::set_has_currentState () {
    _has_bits_[0] |= 1u << 7;
}

inline void PositionInfo::clear_has_currentState () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void PositionInfo::set_has_currentCity () {
    _has_bits_[0] |= 1u << 8;
}

inline void PositionInfo::clear_has_currentCity () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void PositionInfo::set_has_currentCityDistrict () {
    _has_bits_[0] |= 1u << 9;
}

inline void PositionInfo::clear_has_currentCityDistrict () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void PositionInfo::set_has_currentStreet () {
    _has_bits_[0] |= 1u << 10;
}

inline void PositionInfo::clear_has_currentStreet () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void PositionInfo::set_has_currentIntersection () {
    _has_bits_[0] |= 1u << 11;
}

inline void PositionInfo::clear_has_currentIntersection () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void PositionInfo::set_has_currentZipCode () {
    _has_bits_[0] |= 1u << 12;
}

inline void PositionInfo::clear_has_currentZipCode () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void PositionInfo::set_has_isUniqueIdValid () {
    _has_bits_[0] |= 1u << 13;
}

inline void PositionInfo::clear_has_isUniqueIdValid () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void PositionInfo::set_has_uniqueId () {
    _has_bits_[0] |= 1u << 14;
}

inline void PositionInfo::clear_has_uniqueId () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline  PositionWGS84::PositionWGS84 ()  :
    _longitude (0.0),
    _latitude (0.0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionWGS84::PositionWGS84 (const PositionWGS84 &rhs)  :
    _longitude (0.0),
    _latitude (0.0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionWGS84::PositionWGS84 (double longitude_, double latitude_)  :
    _longitude (longitude_),
    _latitude (latitude_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PositionWGS84::~PositionWGS84() {
}

inline PositionWGS84& PositionWGS84::operator = (const PositionWGS84& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLongitude()) {
            setLongitude(rhs.getLongitude());
        } else {
            clearLongitude();
        }
        if (rhs.hasLatitude()) {
            setLatitude(rhs.getLatitude());
        } else {
            clearLatitude();
        }
    }
    return *this;
}

inline bool PositionWGS84::operator == (const PositionWGS84& rhs) const {
    return (((!hasLongitude() && !rhs.hasLongitude()) || getLongitude() == rhs.getLongitude()) &&
        ((!hasLatitude() && !rhs.hasLatitude()) || getLatitude() == rhs.getLatitude()));
}

inline bool PositionWGS84::operator != (const PositionWGS84& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionWGS84::operator < (const PositionWGS84& rhs) const {
    if (hasLongitude() || rhs.hasLongitude()) {
        if (getLongitude() < rhs.getLongitude()) return true;
        if (getLongitude() > rhs.getLongitude()) return false;
    }
    if (hasLatitude() || rhs.hasLatitude()) {
        if (getLatitude() < rhs.getLatitude()) return true;
        if (getLatitude() > rhs.getLatitude()) return false;
    }
    return false;
}

inline bool PositionWGS84::operator > (const PositionWGS84& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionWGS84::clear() {
    clearLongitude();
    clearLatitude();
}

inline void PositionWGS84::clearLongitude() {
    if (hasLongitude()) {
         clear_has_longitude();
        _longitude = 0.0;
     }
}

inline bool PositionWGS84::hasLongitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline double PositionWGS84::getLongitude () const {
    return _longitude;
}

inline void PositionWGS84::setLongitude (double longitude_) {
    set_has_longitude();
    this->_longitude = longitude_;
}

inline void PositionWGS84::clearLatitude() {
    if (hasLatitude()) {
         clear_has_latitude();
        _latitude = 0.0;
     }
}

inline bool PositionWGS84::hasLatitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline double PositionWGS84::getLatitude () const {
    return _latitude;
}

inline void PositionWGS84::setLatitude (double latitude_) {
    set_has_latitude();
    this->_latitude = latitude_;
}

inline void PositionWGS84::set_has_longitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void PositionWGS84::clear_has_longitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PositionWGS84::set_has_latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void PositionWGS84::clear_has_latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PositionStatusInfo::PositionStatusInfo ()  :
    _positionWGS84 (),
    _countryCode (),
    _stateCode (),
    _roadClass (::org::bosch::cm::navigation::NavigationSDSService::RoadClass__ROAD_CLASS_NONE),
    _vehicleSpeed (0.0f),
    _vehicleHeading (0.0f),
    _isUniqueIdValid (false),
    _uniqueId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionStatusInfo::PositionStatusInfo (const PositionStatusInfo &rhs)  :
    _positionWGS84 (),
    _countryCode (),
    _stateCode (),
    _roadClass (::org::bosch::cm::navigation::NavigationSDSService::RoadClass__ROAD_CLASS_NONE),
    _vehicleSpeed (0.0f),
    _vehicleHeading (0.0f),
    _isUniqueIdValid (false),
    _uniqueId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionStatusInfo::PositionStatusInfo (const PositionWGS84& positionWGS84_, const ::std::string& countryCode_, const ::std::string& stateCode_, RoadClass roadClass_, float vehicleSpeed_, float vehicleHeading_, bool isUniqueIdValid_, uint32 uniqueId_)  :
    _positionWGS84 (positionWGS84_),
    _countryCode (countryCode_),
    _stateCode (stateCode_),
    _roadClass (roadClass_),
    _vehicleSpeed (vehicleSpeed_),
    _vehicleHeading (vehicleHeading_),
    _isUniqueIdValid (isUniqueIdValid_),
    _uniqueId (uniqueId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (countryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stateCode_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(RoadClass_IsValid(roadClass_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", roadClass_, "RoadClass", "roadClass", "PositionStatusInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PositionStatusInfo::~PositionStatusInfo() {
}

inline PositionStatusInfo& PositionStatusInfo::operator = (const PositionStatusInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPositionWGS84()) {
            setPositionWGS84(rhs.getPositionWGS84());
        } else {
            clearPositionWGS84();
        }
        if (rhs.hasCountryCode()) {
            setCountryCode(rhs.getCountryCode());
        } else {
            clearCountryCode();
        }
        if (rhs.hasStateCode()) {
            setStateCode(rhs.getStateCode());
        } else {
            clearStateCode();
        }
        if (rhs.hasRoadClass()) {
            setRoadClass(rhs.getRoadClass());
        } else {
            clearRoadClass();
        }
        if (rhs.hasVehicleSpeed()) {
            setVehicleSpeed(rhs.getVehicleSpeed());
        } else {
            clearVehicleSpeed();
        }
        if (rhs.hasVehicleHeading()) {
            setVehicleHeading(rhs.getVehicleHeading());
        } else {
            clearVehicleHeading();
        }
        if (rhs.hasIsUniqueIdValid()) {
            setIsUniqueIdValid(rhs.getIsUniqueIdValid());
        } else {
            clearIsUniqueIdValid();
        }
        if (rhs.hasUniqueId()) {
            setUniqueId(rhs.getUniqueId());
        } else {
            clearUniqueId();
        }
    }
    return *this;
}

inline bool PositionStatusInfo::operator == (const PositionStatusInfo& rhs) const {
    return (((!hasPositionWGS84() && !rhs.hasPositionWGS84()) || getPositionWGS84() == rhs.getPositionWGS84()) &&
        ((!hasCountryCode() && !rhs.hasCountryCode()) || getCountryCode() == rhs.getCountryCode()) &&
        ((!hasStateCode() && !rhs.hasStateCode()) || getStateCode() == rhs.getStateCode()) &&
        ((!hasRoadClass() && !rhs.hasRoadClass()) || getRoadClass() == rhs.getRoadClass()) &&
        ((!hasVehicleSpeed() && !rhs.hasVehicleSpeed()) || getVehicleSpeed() == rhs.getVehicleSpeed()) &&
        ((!hasVehicleHeading() && !rhs.hasVehicleHeading()) || getVehicleHeading() == rhs.getVehicleHeading()) &&
        ((!hasIsUniqueIdValid() && !rhs.hasIsUniqueIdValid()) || getIsUniqueIdValid() == rhs.getIsUniqueIdValid()) &&
        ((!hasUniqueId() && !rhs.hasUniqueId()) || getUniqueId() == rhs.getUniqueId()));
}

inline bool PositionStatusInfo::operator != (const PositionStatusInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionStatusInfo::operator < (const PositionStatusInfo& rhs) const {
    if (hasPositionWGS84() || rhs.hasPositionWGS84()) {
        if (getPositionWGS84() < rhs.getPositionWGS84()) return true;
        if (getPositionWGS84() > rhs.getPositionWGS84()) return false;
    }
    if (hasCountryCode() || rhs.hasCountryCode()) {
        if (getCountryCode() < rhs.getCountryCode()) return true;
        if (getCountryCode() > rhs.getCountryCode()) return false;
    }
    if (hasStateCode() || rhs.hasStateCode()) {
        if (getStateCode() < rhs.getStateCode()) return true;
        if (getStateCode() > rhs.getStateCode()) return false;
    }
    if (hasRoadClass() || rhs.hasRoadClass()) {
        if ((uint32)getRoadClass() < (uint32)rhs.getRoadClass()) return true;
        if ((uint32)getRoadClass() > (uint32)rhs.getRoadClass()) return false;
    }
    if (hasVehicleSpeed() || rhs.hasVehicleSpeed()) {
        if (getVehicleSpeed() < rhs.getVehicleSpeed()) return true;
        if (getVehicleSpeed() > rhs.getVehicleSpeed()) return false;
    }
    if (hasVehicleHeading() || rhs.hasVehicleHeading()) {
        if (getVehicleHeading() < rhs.getVehicleHeading()) return true;
        if (getVehicleHeading() > rhs.getVehicleHeading()) return false;
    }
    if (hasIsUniqueIdValid() || rhs.hasIsUniqueIdValid()) {
        if (getIsUniqueIdValid() < rhs.getIsUniqueIdValid()) return true;
        if (getIsUniqueIdValid() > rhs.getIsUniqueIdValid()) return false;
    }
    if (hasUniqueId() || rhs.hasUniqueId()) {
        if (getUniqueId() < rhs.getUniqueId()) return true;
        if (getUniqueId() > rhs.getUniqueId()) return false;
    }
    return false;
}

inline bool PositionStatusInfo::operator > (const PositionStatusInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionStatusInfo::clear() {
    clearPositionWGS84();
    clearCountryCode();
    clearStateCode();
    clearRoadClass();
    clearVehicleSpeed();
    clearVehicleHeading();
    clearIsUniqueIdValid();
    clearUniqueId();
}

inline void PositionStatusInfo::clearPositionWGS84() {
    if (hasPositionWGS84()) {
         clear_has_positionWGS84();
        _positionWGS84.clear();
     }
}

inline bool PositionStatusInfo::hasPositionWGS84 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const PositionWGS84& PositionStatusInfo::getPositionWGS84 () const {
    return _positionWGS84;
}

inline PositionWGS84& PositionStatusInfo::getPositionWGS84Mutable () {
    set_has_positionWGS84();
    return _positionWGS84;
}

inline void PositionStatusInfo::setPositionWGS84 (const PositionWGS84& positionWGS84_) {
    set_has_positionWGS84();
    this->_positionWGS84 = positionWGS84_;
}

inline void PositionStatusInfo::clearCountryCode() {
    if (hasCountryCode()) {
         clear_has_countryCode();
        _countryCode.clear();
     }
}

inline bool PositionStatusInfo::hasCountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PositionStatusInfo::getCountryCode () const {
    return _countryCode;
}

inline ::std::string& PositionStatusInfo::getCountryCodeMutable () {
    set_has_countryCode();
    return _countryCode;
}

inline void PositionStatusInfo::setCountryCode (const ::std::string& countryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (countryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_countryCode();
    this->_countryCode = countryCode_;
}

inline void PositionStatusInfo::setCountryCode (const char* countryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (countryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_countryCode();
    this->_countryCode.assign(countryCode_);
}

inline void PositionStatusInfo::setCountryCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_countryCode();
    this->_countryCode.assign(value, size);
}

inline void PositionStatusInfo::clearStateCode() {
    if (hasStateCode()) {
         clear_has_stateCode();
        _stateCode.clear();
     }
}

inline bool PositionStatusInfo::hasStateCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& PositionStatusInfo::getStateCode () const {
    return _stateCode;
}

inline ::std::string& PositionStatusInfo::getStateCodeMutable () {
    set_has_stateCode();
    return _stateCode;
}

inline void PositionStatusInfo::setStateCode (const ::std::string& stateCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stateCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stateCode();
    this->_stateCode = stateCode_;
}

inline void PositionStatusInfo::setStateCode (const char* stateCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (stateCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stateCode();
    this->_stateCode.assign(stateCode_);
}

inline void PositionStatusInfo::setStateCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_stateCode();
    this->_stateCode.assign(value, size);
}

inline void PositionStatusInfo::clearRoadClass() {
    if (hasRoadClass()) {
         clear_has_roadClass();
        _roadClass = ::org::bosch::cm::navigation::NavigationSDSService::RoadClass__ROAD_CLASS_NONE;
     }
}

inline bool PositionStatusInfo::hasRoadClass () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline RoadClass PositionStatusInfo::getRoadClass () const {
    return _roadClass;
}

inline void PositionStatusInfo::setRoadClass (RoadClass roadClass_) {
    #ifndef NDEBUG
    if (!(RoadClass_IsValid(roadClass_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", roadClass_, "RoadClass", "roadClass", "PositionStatusInfo");
    }
    #endif
    set_has_roadClass();
    this->_roadClass = roadClass_;
}

inline void PositionStatusInfo::clearVehicleSpeed() {
    if (hasVehicleSpeed()) {
         clear_has_vehicleSpeed();
        _vehicleSpeed = 0.0f;
     }
}

inline bool PositionStatusInfo::hasVehicleSpeed () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float PositionStatusInfo::getVehicleSpeed () const {
    return _vehicleSpeed;
}

inline void PositionStatusInfo::setVehicleSpeed (float vehicleSpeed_) {
    set_has_vehicleSpeed();
    this->_vehicleSpeed = vehicleSpeed_;
}

inline void PositionStatusInfo::clearVehicleHeading() {
    if (hasVehicleHeading()) {
         clear_has_vehicleHeading();
        _vehicleHeading = 0.0f;
     }
}

inline bool PositionStatusInfo::hasVehicleHeading () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float PositionStatusInfo::getVehicleHeading () const {
    return _vehicleHeading;
}

inline void PositionStatusInfo::setVehicleHeading (float vehicleHeading_) {
    set_has_vehicleHeading();
    this->_vehicleHeading = vehicleHeading_;
}

inline void PositionStatusInfo::clearIsUniqueIdValid() {
    if (hasIsUniqueIdValid()) {
         clear_has_isUniqueIdValid();
        _isUniqueIdValid = false;
     }
}

inline bool PositionStatusInfo::hasIsUniqueIdValid () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool PositionStatusInfo::getIsUniqueIdValid () const {
    return _isUniqueIdValid;
}

inline void PositionStatusInfo::setIsUniqueIdValid (bool isUniqueIdValid_) {
    set_has_isUniqueIdValid();
    this->_isUniqueIdValid = isUniqueIdValid_;
}

inline void PositionStatusInfo::clearUniqueId() {
    if (hasUniqueId()) {
         clear_has_uniqueId();
        _uniqueId = 0u;
     }
}

inline bool PositionStatusInfo::hasUniqueId () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 PositionStatusInfo::getUniqueId () const {
    return _uniqueId;
}

inline void PositionStatusInfo::setUniqueId (uint32 uniqueId_) {
    set_has_uniqueId();
    this->_uniqueId = uniqueId_;
}

inline void PositionStatusInfo::set_has_positionWGS84 () {
    _has_bits_[0] |= 1u << 0;
}

inline void PositionStatusInfo::clear_has_positionWGS84 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PositionStatusInfo::set_has_countryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void PositionStatusInfo::clear_has_countryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PositionStatusInfo::set_has_stateCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void PositionStatusInfo::clear_has_stateCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PositionStatusInfo::set_has_roadClass () {
    _has_bits_[0] |= 1u << 3;
}

inline void PositionStatusInfo::clear_has_roadClass () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void PositionStatusInfo::set_has_vehicleSpeed () {
    _has_bits_[0] |= 1u << 4;
}

inline void PositionStatusInfo::clear_has_vehicleSpeed () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void PositionStatusInfo::set_has_vehicleHeading () {
    _has_bits_[0] |= 1u << 5;
}

inline void PositionStatusInfo::clear_has_vehicleHeading () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void PositionStatusInfo::set_has_isUniqueIdValid () {
    _has_bits_[0] |= 1u << 6;
}

inline void PositionStatusInfo::clear_has_isUniqueIdValid () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void PositionStatusInfo::set_has_uniqueId () {
    _has_bits_[0] |= 1u << 7;
}

inline void PositionStatusInfo::clear_has_uniqueId () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  DynamicMapPoiCategory::DynamicMapPoiCategory ()  :
    _poiCategoryName (),
    _poiCategoryId (0u),
    _poiCategoryVisibilityOnMap (false),
    _sdsNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategory::DynamicMapPoiCategory (const DynamicMapPoiCategory &rhs)  :
    _poiCategoryName (),
    _poiCategoryId (0u),
    _poiCategoryVisibilityOnMap (false),
    _sdsNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicMapPoiCategory::DynamicMapPoiCategory (const ::std::string& poiCategoryName_, uint32 poiCategoryId_, bool poiCategoryVisibilityOnMap_, const GlobalNamedObjectId& sdsNameObjectId_)  :
    _poiCategoryName (poiCategoryName_),
    _poiCategoryId (poiCategoryId_),
    _poiCategoryVisibilityOnMap (poiCategoryVisibilityOnMap_),
    _sdsNameObjectId (sdsNameObjectId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (poiCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategory::~DynamicMapPoiCategory() {
}

inline DynamicMapPoiCategory& DynamicMapPoiCategory::operator = (const DynamicMapPoiCategory& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPoiCategoryName()) {
            setPoiCategoryName(rhs.getPoiCategoryName());
        } else {
            clearPoiCategoryName();
        }
        if (rhs.hasPoiCategoryId()) {
            setPoiCategoryId(rhs.getPoiCategoryId());
        } else {
            clearPoiCategoryId();
        }
        if (rhs.hasPoiCategoryVisibilityOnMap()) {
            setPoiCategoryVisibilityOnMap(rhs.getPoiCategoryVisibilityOnMap());
        } else {
            clearPoiCategoryVisibilityOnMap();
        }
        if (rhs.hasSdsNameObjectId()) {
            setSdsNameObjectId(rhs.getSdsNameObjectId());
        } else {
            clearSdsNameObjectId();
        }
    }
    return *this;
}

inline bool DynamicMapPoiCategory::operator == (const DynamicMapPoiCategory& rhs) const {
    return (((!hasPoiCategoryName() && !rhs.hasPoiCategoryName()) || getPoiCategoryName() == rhs.getPoiCategoryName()) &&
        ((!hasPoiCategoryId() && !rhs.hasPoiCategoryId()) || getPoiCategoryId() == rhs.getPoiCategoryId()) &&
        ((!hasPoiCategoryVisibilityOnMap() && !rhs.hasPoiCategoryVisibilityOnMap()) || getPoiCategoryVisibilityOnMap() == rhs.getPoiCategoryVisibilityOnMap()) &&
        ((!hasSdsNameObjectId() && !rhs.hasSdsNameObjectId()) || getSdsNameObjectId() == rhs.getSdsNameObjectId()));
}

inline bool DynamicMapPoiCategory::operator != (const DynamicMapPoiCategory& rhs) const {
    return ! (*this == rhs);
}

inline bool DynamicMapPoiCategory::operator < (const DynamicMapPoiCategory& rhs) const {
    if (hasPoiCategoryName() || rhs.hasPoiCategoryName()) {
        if (getPoiCategoryName() < rhs.getPoiCategoryName()) return true;
        if (getPoiCategoryName() > rhs.getPoiCategoryName()) return false;
    }
    if (hasPoiCategoryId() || rhs.hasPoiCategoryId()) {
        if (getPoiCategoryId() < rhs.getPoiCategoryId()) return true;
        if (getPoiCategoryId() > rhs.getPoiCategoryId()) return false;
    }
    if (hasPoiCategoryVisibilityOnMap() || rhs.hasPoiCategoryVisibilityOnMap()) {
        if (getPoiCategoryVisibilityOnMap() < rhs.getPoiCategoryVisibilityOnMap()) return true;
        if (getPoiCategoryVisibilityOnMap() > rhs.getPoiCategoryVisibilityOnMap()) return false;
    }
    if (hasSdsNameObjectId() || rhs.hasSdsNameObjectId()) {
        if (getSdsNameObjectId() < rhs.getSdsNameObjectId()) return true;
        if (getSdsNameObjectId() > rhs.getSdsNameObjectId()) return false;
    }
    return false;
}

inline bool DynamicMapPoiCategory::operator > (const DynamicMapPoiCategory& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DynamicMapPoiCategory::clear() {
    clearPoiCategoryName();
    clearPoiCategoryId();
    clearPoiCategoryVisibilityOnMap();
    clearSdsNameObjectId();
}

inline void DynamicMapPoiCategory::clearPoiCategoryName() {
    if (hasPoiCategoryName()) {
         clear_has_poiCategoryName();
        _poiCategoryName.clear();
     }
}

inline bool DynamicMapPoiCategory::hasPoiCategoryName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DynamicMapPoiCategory::getPoiCategoryName () const {
    return _poiCategoryName;
}

inline ::std::string& DynamicMapPoiCategory::getPoiCategoryNameMutable () {
    set_has_poiCategoryName();
    return _poiCategoryName;
}

inline void DynamicMapPoiCategory::setPoiCategoryName (const ::std::string& poiCategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (poiCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_poiCategoryName();
    this->_poiCategoryName = poiCategoryName_;
}

inline void DynamicMapPoiCategory::setPoiCategoryName (const char* poiCategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (poiCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_poiCategoryName();
    this->_poiCategoryName.assign(poiCategoryName_);
}

inline void DynamicMapPoiCategory::setPoiCategoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_poiCategoryName();
    this->_poiCategoryName.assign(value, size);
}

inline void DynamicMapPoiCategory::clearPoiCategoryId() {
    if (hasPoiCategoryId()) {
         clear_has_poiCategoryId();
        _poiCategoryId = 0u;
     }
}

inline bool DynamicMapPoiCategory::hasPoiCategoryId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DynamicMapPoiCategory::getPoiCategoryId () const {
    return _poiCategoryId;
}

inline void DynamicMapPoiCategory::setPoiCategoryId (uint32 poiCategoryId_) {
    set_has_poiCategoryId();
    this->_poiCategoryId = poiCategoryId_;
}

inline void DynamicMapPoiCategory::clearPoiCategoryVisibilityOnMap() {
    if (hasPoiCategoryVisibilityOnMap()) {
         clear_has_poiCategoryVisibilityOnMap();
        _poiCategoryVisibilityOnMap = false;
     }
}

inline bool DynamicMapPoiCategory::hasPoiCategoryVisibilityOnMap () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool DynamicMapPoiCategory::getPoiCategoryVisibilityOnMap () const {
    return _poiCategoryVisibilityOnMap;
}

inline void DynamicMapPoiCategory::setPoiCategoryVisibilityOnMap (bool poiCategoryVisibilityOnMap_) {
    set_has_poiCategoryVisibilityOnMap();
    this->_poiCategoryVisibilityOnMap = poiCategoryVisibilityOnMap_;
}

inline void DynamicMapPoiCategory::clearSdsNameObjectId() {
    if (hasSdsNameObjectId()) {
         clear_has_sdsNameObjectId();
        _sdsNameObjectId.clear();
     }
}

inline bool DynamicMapPoiCategory::hasSdsNameObjectId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const GlobalNamedObjectId& DynamicMapPoiCategory::getSdsNameObjectId () const {
    return _sdsNameObjectId;
}

inline GlobalNamedObjectId& DynamicMapPoiCategory::getSdsNameObjectIdMutable () {
    set_has_sdsNameObjectId();
    return _sdsNameObjectId;
}

inline void DynamicMapPoiCategory::setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_) {
    set_has_sdsNameObjectId();
    this->_sdsNameObjectId = sdsNameObjectId_;
}

inline void DynamicMapPoiCategory::set_has_poiCategoryName () {
    _has_bits_[0] |= 1u << 0;
}

inline void DynamicMapPoiCategory::clear_has_poiCategoryName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DynamicMapPoiCategory::set_has_poiCategoryId () {
    _has_bits_[0] |= 1u << 1;
}

inline void DynamicMapPoiCategory::clear_has_poiCategoryId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DynamicMapPoiCategory::set_has_poiCategoryVisibilityOnMap () {
    _has_bits_[0] |= 1u << 2;
}

inline void DynamicMapPoiCategory::clear_has_poiCategoryVisibilityOnMap () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DynamicMapPoiCategory::set_has_sdsNameObjectId () {
    _has_bits_[0] |= 1u << 3;
}

inline void DynamicMapPoiCategory::clear_has_sdsNameObjectId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DynamicMapPoiCategoriesWithLanguage::DynamicMapPoiCategoriesWithLanguage ()  :
    _dynamicMapPoiCategories (),
    _poiCategoriesLanguageEntry ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategoriesWithLanguage::DynamicMapPoiCategoriesWithLanguage (const DynamicMapPoiCategoriesWithLanguage &rhs)  :
    _dynamicMapPoiCategories (),
    _poiCategoriesLanguageEntry ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicMapPoiCategoriesWithLanguage::DynamicMapPoiCategoriesWithLanguage (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategories_, const LanguageEntry& poiCategoriesLanguageEntry_)  :
    _dynamicMapPoiCategories (dynamicMapPoiCategories_),
    _poiCategoriesLanguageEntry (poiCategoriesLanguageEntry_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategoriesWithLanguage::~DynamicMapPoiCategoriesWithLanguage() {
}

inline DynamicMapPoiCategoriesWithLanguage& DynamicMapPoiCategoriesWithLanguage::operator = (const DynamicMapPoiCategoriesWithLanguage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDynamicMapPoiCategories()) {
            setDynamicMapPoiCategories(rhs.getDynamicMapPoiCategories());
        } else {
            clearDynamicMapPoiCategories();
        }
        if (rhs.hasPoiCategoriesLanguageEntry()) {
            setPoiCategoriesLanguageEntry(rhs.getPoiCategoriesLanguageEntry());
        } else {
            clearPoiCategoriesLanguageEntry();
        }
    }
    return *this;
}

inline bool DynamicMapPoiCategoriesWithLanguage::operator == (const DynamicMapPoiCategoriesWithLanguage& rhs) const {
    return (((!hasDynamicMapPoiCategories() && !rhs.hasDynamicMapPoiCategories()) || getDynamicMapPoiCategories() == rhs.getDynamicMapPoiCategories()) &&
        ((!hasPoiCategoriesLanguageEntry() && !rhs.hasPoiCategoriesLanguageEntry()) || getPoiCategoriesLanguageEntry() == rhs.getPoiCategoriesLanguageEntry()));
}

inline bool DynamicMapPoiCategoriesWithLanguage::operator != (const DynamicMapPoiCategoriesWithLanguage& rhs) const {
    return ! (*this == rhs);
}

inline bool DynamicMapPoiCategoriesWithLanguage::operator < (const DynamicMapPoiCategoriesWithLanguage& rhs) const {
    if (hasDynamicMapPoiCategories() || rhs.hasDynamicMapPoiCategories()) {
        if (getDynamicMapPoiCategories() < rhs.getDynamicMapPoiCategories()) return true;
        if (getDynamicMapPoiCategories() > rhs.getDynamicMapPoiCategories()) return false;
    }
    if (hasPoiCategoriesLanguageEntry() || rhs.hasPoiCategoriesLanguageEntry()) {
        if (getPoiCategoriesLanguageEntry() < rhs.getPoiCategoriesLanguageEntry()) return true;
        if (getPoiCategoriesLanguageEntry() > rhs.getPoiCategoriesLanguageEntry()) return false;
    }
    return false;
}

inline bool DynamicMapPoiCategoriesWithLanguage::operator > (const DynamicMapPoiCategoriesWithLanguage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DynamicMapPoiCategoriesWithLanguage::clear() {
    clearDynamicMapPoiCategories();
    clearPoiCategoriesLanguageEntry();
}

inline void DynamicMapPoiCategoriesWithLanguage::clearDynamicMapPoiCategories() {
    if (hasDynamicMapPoiCategories()) {
         clear_has_dynamicMapPoiCategories();
        _dynamicMapPoiCategories.clear();
     }
}

inline bool DynamicMapPoiCategoriesWithLanguage::hasDynamicMapPoiCategories () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< DynamicMapPoiCategory >& DynamicMapPoiCategoriesWithLanguage::getDynamicMapPoiCategories () const {
    return _dynamicMapPoiCategories;
}

inline ::std::vector< DynamicMapPoiCategory >& DynamicMapPoiCategoriesWithLanguage::getDynamicMapPoiCategoriesMutable () {
    set_has_dynamicMapPoiCategories();
    return _dynamicMapPoiCategories;
}

inline void DynamicMapPoiCategoriesWithLanguage::setDynamicMapPoiCategories (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategories_) {
    set_has_dynamicMapPoiCategories();
    this->_dynamicMapPoiCategories = dynamicMapPoiCategories_;
}

inline void DynamicMapPoiCategoriesWithLanguage::clearPoiCategoriesLanguageEntry() {
    if (hasPoiCategoriesLanguageEntry()) {
         clear_has_poiCategoriesLanguageEntry();
        _poiCategoriesLanguageEntry.clear();
     }
}

inline bool DynamicMapPoiCategoriesWithLanguage::hasPoiCategoriesLanguageEntry () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const LanguageEntry& DynamicMapPoiCategoriesWithLanguage::getPoiCategoriesLanguageEntry () const {
    return _poiCategoriesLanguageEntry;
}

inline LanguageEntry& DynamicMapPoiCategoriesWithLanguage::getPoiCategoriesLanguageEntryMutable () {
    set_has_poiCategoriesLanguageEntry();
    return _poiCategoriesLanguageEntry;
}

inline void DynamicMapPoiCategoriesWithLanguage::setPoiCategoriesLanguageEntry (const LanguageEntry& poiCategoriesLanguageEntry_) {
    set_has_poiCategoriesLanguageEntry();
    this->_poiCategoriesLanguageEntry = poiCategoriesLanguageEntry_;
}

inline void DynamicMapPoiCategoriesWithLanguage::set_has_dynamicMapPoiCategories () {
    _has_bits_[0] |= 1u << 0;
}

inline void DynamicMapPoiCategoriesWithLanguage::clear_has_dynamicMapPoiCategories () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DynamicMapPoiCategoriesWithLanguage::set_has_poiCategoriesLanguageEntry () {
    _has_bits_[0] |= 1u << 1;
}

inline void DynamicMapPoiCategoriesWithLanguage::clear_has_poiCategoriesLanguageEntry () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AddressFormatInfo::AddressFormatInfo ()  :
    _isoCountryCode (),
    _addressFormat ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressFormatInfo::AddressFormatInfo (const AddressFormatInfo &rhs)  :
    _isoCountryCode (),
    _addressFormat ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressFormatInfo::AddressFormatInfo (const ::std::string& isoCountryCode_, const ::std::string& addressFormat_)  :
    _isoCountryCode (isoCountryCode_),
    _addressFormat (addressFormat_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (addressFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressFormatInfo::~AddressFormatInfo() {
}

inline AddressFormatInfo& AddressFormatInfo::operator = (const AddressFormatInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIsoCountryCode()) {
            setIsoCountryCode(rhs.getIsoCountryCode());
        } else {
            clearIsoCountryCode();
        }
        if (rhs.hasAddressFormat()) {
            setAddressFormat(rhs.getAddressFormat());
        } else {
            clearAddressFormat();
        }
    }
    return *this;
}

inline bool AddressFormatInfo::operator == (const AddressFormatInfo& rhs) const {
    return (((!hasIsoCountryCode() && !rhs.hasIsoCountryCode()) || getIsoCountryCode() == rhs.getIsoCountryCode()) &&
        ((!hasAddressFormat() && !rhs.hasAddressFormat()) || getAddressFormat() == rhs.getAddressFormat()));
}

inline bool AddressFormatInfo::operator != (const AddressFormatInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressFormatInfo::operator < (const AddressFormatInfo& rhs) const {
    if (hasIsoCountryCode() || rhs.hasIsoCountryCode()) {
        if (getIsoCountryCode() < rhs.getIsoCountryCode()) return true;
        if (getIsoCountryCode() > rhs.getIsoCountryCode()) return false;
    }
    if (hasAddressFormat() || rhs.hasAddressFormat()) {
        if (getAddressFormat() < rhs.getAddressFormat()) return true;
        if (getAddressFormat() > rhs.getAddressFormat()) return false;
    }
    return false;
}

inline bool AddressFormatInfo::operator > (const AddressFormatInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressFormatInfo::clear() {
    clearIsoCountryCode();
    clearAddressFormat();
}

inline void AddressFormatInfo::clearIsoCountryCode() {
    if (hasIsoCountryCode()) {
         clear_has_isoCountryCode();
        _isoCountryCode.clear();
     }
}

inline bool AddressFormatInfo::hasIsoCountryCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressFormatInfo::getIsoCountryCode () const {
    return _isoCountryCode;
}

inline ::std::string& AddressFormatInfo::getIsoCountryCodeMutable () {
    set_has_isoCountryCode();
    return _isoCountryCode;
}

inline void AddressFormatInfo::setIsoCountryCode (const ::std::string& isoCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode = isoCountryCode_;
}

inline void AddressFormatInfo::setIsoCountryCode (const char* isoCountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (isoCountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode.assign(isoCountryCode_);
}

inline void AddressFormatInfo::setIsoCountryCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_isoCountryCode();
    this->_isoCountryCode.assign(value, size);
}

inline void AddressFormatInfo::clearAddressFormat() {
    if (hasAddressFormat()) {
         clear_has_addressFormat();
        _addressFormat.clear();
     }
}

inline bool AddressFormatInfo::hasAddressFormat () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AddressFormatInfo::getAddressFormat () const {
    return _addressFormat;
}

inline ::std::string& AddressFormatInfo::getAddressFormatMutable () {
    set_has_addressFormat();
    return _addressFormat;
}

inline void AddressFormatInfo::setAddressFormat (const ::std::string& addressFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (addressFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_addressFormat();
    this->_addressFormat = addressFormat_;
}

inline void AddressFormatInfo::setAddressFormat (const char* addressFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (addressFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_addressFormat();
    this->_addressFormat.assign(addressFormat_);
}

inline void AddressFormatInfo::setAddressFormat (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_addressFormat();
    this->_addressFormat.assign(value, size);
}

inline void AddressFormatInfo::set_has_isoCountryCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressFormatInfo::clear_has_isoCountryCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AddressFormatInfo::set_has_addressFormat () {
    _has_bits_[0] |= 1u << 1;
}

inline void AddressFormatInfo::clear_has_addressFormat () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SharedDataAccessAttributes::SharedDataAccessAttributes ()  :
    _sharedDataAccess (::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess__SHARED_DATA_ACCESS__NOT_REQUIRED),
    _journalingMode (::org::bosch::cm::navigation::NavigationSDSService::JournalingMode__JOURNALING_MODE__NONE),
    _lockType (::org::bosch::cm::navigation::NavigationSDSService::LockType__LOCK_TYPE__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SharedDataAccessAttributes::SharedDataAccessAttributes (const SharedDataAccessAttributes &rhs)  :
    _sharedDataAccess (::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess__SHARED_DATA_ACCESS__NOT_REQUIRED),
    _journalingMode (::org::bosch::cm::navigation::NavigationSDSService::JournalingMode__JOURNALING_MODE__NONE),
    _lockType (::org::bosch::cm::navigation::NavigationSDSService::LockType__LOCK_TYPE__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SharedDataAccessAttributes::SharedDataAccessAttributes (SharedDataAccess sharedDataAccess_, JournalingMode journalingMode_, LockType lockType_)  :
    _sharedDataAccess (sharedDataAccess_),
    _journalingMode (journalingMode_),
    _lockType (lockType_)
{
    #ifndef NDEBUG
    if (!(SharedDataAccess_IsValid(sharedDataAccess_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sharedDataAccess_, "SharedDataAccess", "sharedDataAccess", "SharedDataAccessAttributes");
    }
    #endif
    #ifndef NDEBUG
    if (!(JournalingMode_IsValid(journalingMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", journalingMode_, "JournalingMode", "journalingMode", "SharedDataAccessAttributes");
    }
    #endif
    #ifndef NDEBUG
    if (!(LockType_IsValid(lockType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", lockType_, "LockType", "lockType", "SharedDataAccessAttributes");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SharedDataAccessAttributes::~SharedDataAccessAttributes() {
}

inline SharedDataAccessAttributes& SharedDataAccessAttributes::operator = (const SharedDataAccessAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSharedDataAccess()) {
            setSharedDataAccess(rhs.getSharedDataAccess());
        } else {
            clearSharedDataAccess();
        }
        if (rhs.hasJournalingMode()) {
            setJournalingMode(rhs.getJournalingMode());
        } else {
            clearJournalingMode();
        }
        if (rhs.hasLockType()) {
            setLockType(rhs.getLockType());
        } else {
            clearLockType();
        }
    }
    return *this;
}

inline bool SharedDataAccessAttributes::operator == (const SharedDataAccessAttributes& rhs) const {
    return (((!hasSharedDataAccess() && !rhs.hasSharedDataAccess()) || getSharedDataAccess() == rhs.getSharedDataAccess()) &&
        ((!hasJournalingMode() && !rhs.hasJournalingMode()) || getJournalingMode() == rhs.getJournalingMode()) &&
        ((!hasLockType() && !rhs.hasLockType()) || getLockType() == rhs.getLockType()));
}

inline bool SharedDataAccessAttributes::operator != (const SharedDataAccessAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool SharedDataAccessAttributes::operator < (const SharedDataAccessAttributes& rhs) const {
    if (hasSharedDataAccess() || rhs.hasSharedDataAccess()) {
        if ((uint32)getSharedDataAccess() < (uint32)rhs.getSharedDataAccess()) return true;
        if ((uint32)getSharedDataAccess() > (uint32)rhs.getSharedDataAccess()) return false;
    }
    if (hasJournalingMode() || rhs.hasJournalingMode()) {
        if ((uint32)getJournalingMode() < (uint32)rhs.getJournalingMode()) return true;
        if ((uint32)getJournalingMode() > (uint32)rhs.getJournalingMode()) return false;
    }
    if (hasLockType() || rhs.hasLockType()) {
        if ((uint32)getLockType() < (uint32)rhs.getLockType()) return true;
        if ((uint32)getLockType() > (uint32)rhs.getLockType()) return false;
    }
    return false;
}

inline bool SharedDataAccessAttributes::operator > (const SharedDataAccessAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SharedDataAccessAttributes::clear() {
    clearSharedDataAccess();
    clearJournalingMode();
    clearLockType();
}

inline void SharedDataAccessAttributes::clearSharedDataAccess() {
    if (hasSharedDataAccess()) {
         clear_has_sharedDataAccess();
        _sharedDataAccess = ::org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess__SHARED_DATA_ACCESS__NOT_REQUIRED;
     }
}

inline bool SharedDataAccessAttributes::hasSharedDataAccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SharedDataAccess SharedDataAccessAttributes::getSharedDataAccess () const {
    return _sharedDataAccess;
}

inline void SharedDataAccessAttributes::setSharedDataAccess (SharedDataAccess sharedDataAccess_) {
    #ifndef NDEBUG
    if (!(SharedDataAccess_IsValid(sharedDataAccess_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sharedDataAccess_, "SharedDataAccess", "sharedDataAccess", "SharedDataAccessAttributes");
    }
    #endif
    set_has_sharedDataAccess();
    this->_sharedDataAccess = sharedDataAccess_;
}

inline void SharedDataAccessAttributes::clearJournalingMode() {
    if (hasJournalingMode()) {
         clear_has_journalingMode();
        _journalingMode = ::org::bosch::cm::navigation::NavigationSDSService::JournalingMode__JOURNALING_MODE__NONE;
     }
}

inline bool SharedDataAccessAttributes::hasJournalingMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline JournalingMode SharedDataAccessAttributes::getJournalingMode () const {
    return _journalingMode;
}

inline void SharedDataAccessAttributes::setJournalingMode (JournalingMode journalingMode_) {
    #ifndef NDEBUG
    if (!(JournalingMode_IsValid(journalingMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", journalingMode_, "JournalingMode", "journalingMode", "SharedDataAccessAttributes");
    }
    #endif
    set_has_journalingMode();
    this->_journalingMode = journalingMode_;
}

inline void SharedDataAccessAttributes::clearLockType() {
    if (hasLockType()) {
         clear_has_lockType();
        _lockType = ::org::bosch::cm::navigation::NavigationSDSService::LockType__LOCK_TYPE__NONE;
     }
}

inline bool SharedDataAccessAttributes::hasLockType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline LockType SharedDataAccessAttributes::getLockType () const {
    return _lockType;
}

inline void SharedDataAccessAttributes::setLockType (LockType lockType_) {
    #ifndef NDEBUG
    if (!(LockType_IsValid(lockType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", lockType_, "LockType", "lockType", "SharedDataAccessAttributes");
    }
    #endif
    set_has_lockType();
    this->_lockType = lockType_;
}

inline void SharedDataAccessAttributes::set_has_sharedDataAccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void SharedDataAccessAttributes::clear_has_sharedDataAccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SharedDataAccessAttributes::set_has_journalingMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SharedDataAccessAttributes::clear_has_journalingMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SharedDataAccessAttributes::set_has_lockType () {
    _has_bits_[0] |= 1u << 2;
}

inline void SharedDataAccessAttributes::clear_has_lockType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  NavDataSetInfo::NavDataSetInfo ()  :
    _datasetId (0u),
    _persistentDatasetId (),
    _sharedDataAccessAttributes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataSetInfo::NavDataSetInfo (const NavDataSetInfo &rhs)  :
    _datasetId (0u),
    _persistentDatasetId (),
    _sharedDataAccessAttributes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataSetInfo::NavDataSetInfo (uint32 datasetId_, const ::std::string& persistentDatasetId_, const SharedDataAccessAttributes& sharedDataAccessAttributes_)  :
    _datasetId (datasetId_),
    _persistentDatasetId (persistentDatasetId_),
    _sharedDataAccessAttributes (sharedDataAccessAttributes_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavDataSetInfo::~NavDataSetInfo() {
}

inline NavDataSetInfo& NavDataSetInfo::operator = (const NavDataSetInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDatasetId()) {
            setDatasetId(rhs.getDatasetId());
        } else {
            clearDatasetId();
        }
        if (rhs.hasPersistentDatasetId()) {
            setPersistentDatasetId(rhs.getPersistentDatasetId());
        } else {
            clearPersistentDatasetId();
        }
        if (rhs.hasSharedDataAccessAttributes()) {
            setSharedDataAccessAttributes(rhs.getSharedDataAccessAttributes());
        } else {
            clearSharedDataAccessAttributes();
        }
    }
    return *this;
}

inline bool NavDataSetInfo::operator == (const NavDataSetInfo& rhs) const {
    return (((!hasDatasetId() && !rhs.hasDatasetId()) || getDatasetId() == rhs.getDatasetId()) &&
        ((!hasPersistentDatasetId() && !rhs.hasPersistentDatasetId()) || getPersistentDatasetId() == rhs.getPersistentDatasetId()) &&
        ((!hasSharedDataAccessAttributes() && !rhs.hasSharedDataAccessAttributes()) || getSharedDataAccessAttributes() == rhs.getSharedDataAccessAttributes()));
}

inline bool NavDataSetInfo::operator != (const NavDataSetInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataSetInfo::operator < (const NavDataSetInfo& rhs) const {
    if (hasDatasetId() || rhs.hasDatasetId()) {
        if (getDatasetId() < rhs.getDatasetId()) return true;
        if (getDatasetId() > rhs.getDatasetId()) return false;
    }
    if (hasPersistentDatasetId() || rhs.hasPersistentDatasetId()) {
        if (getPersistentDatasetId() < rhs.getPersistentDatasetId()) return true;
        if (getPersistentDatasetId() > rhs.getPersistentDatasetId()) return false;
    }
    if (hasSharedDataAccessAttributes() || rhs.hasSharedDataAccessAttributes()) {
        if (getSharedDataAccessAttributes() < rhs.getSharedDataAccessAttributes()) return true;
        if (getSharedDataAccessAttributes() > rhs.getSharedDataAccessAttributes()) return false;
    }
    return false;
}

inline bool NavDataSetInfo::operator > (const NavDataSetInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataSetInfo::clear() {
    clearDatasetId();
    clearPersistentDatasetId();
    clearSharedDataAccessAttributes();
}

inline void NavDataSetInfo::clearDatasetId() {
    if (hasDatasetId()) {
         clear_has_datasetId();
        _datasetId = 0u;
     }
}

inline bool NavDataSetInfo::hasDatasetId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 NavDataSetInfo::getDatasetId () const {
    return _datasetId;
}

inline void NavDataSetInfo::setDatasetId (uint32 datasetId_) {
    set_has_datasetId();
    this->_datasetId = datasetId_;
}

inline void NavDataSetInfo::clearPersistentDatasetId() {
    if (hasPersistentDatasetId()) {
         clear_has_persistentDatasetId();
        _persistentDatasetId.clear();
     }
}

inline bool NavDataSetInfo::hasPersistentDatasetId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NavDataSetInfo::getPersistentDatasetId () const {
    return _persistentDatasetId;
}

inline ::std::string& NavDataSetInfo::getPersistentDatasetIdMutable () {
    set_has_persistentDatasetId();
    return _persistentDatasetId;
}

inline void NavDataSetInfo::setPersistentDatasetId (const ::std::string& persistentDatasetId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId = persistentDatasetId_;
}

inline void NavDataSetInfo::setPersistentDatasetId (const char* persistentDatasetId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId.assign(persistentDatasetId_);
}

inline void NavDataSetInfo::setPersistentDatasetId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId.assign(value, size);
}

inline void NavDataSetInfo::clearSharedDataAccessAttributes() {
    if (hasSharedDataAccessAttributes()) {
         clear_has_sharedDataAccessAttributes();
        _sharedDataAccessAttributes.clear();
     }
}

inline bool NavDataSetInfo::hasSharedDataAccessAttributes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const SharedDataAccessAttributes& NavDataSetInfo::getSharedDataAccessAttributes () const {
    return _sharedDataAccessAttributes;
}

inline SharedDataAccessAttributes& NavDataSetInfo::getSharedDataAccessAttributesMutable () {
    set_has_sharedDataAccessAttributes();
    return _sharedDataAccessAttributes;
}

inline void NavDataSetInfo::setSharedDataAccessAttributes (const SharedDataAccessAttributes& sharedDataAccessAttributes_) {
    set_has_sharedDataAccessAttributes();
    this->_sharedDataAccessAttributes = sharedDataAccessAttributes_;
}

inline void NavDataSetInfo::set_has_datasetId () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavDataSetInfo::clear_has_datasetId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NavDataSetInfo::set_has_persistentDatasetId () {
    _has_bits_[0] |= 1u << 1;
}

inline void NavDataSetInfo::clear_has_persistentDatasetId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NavDataSetInfo::set_has_sharedDataAccessAttributes () {
    _has_bits_[0] |= 1u << 2;
}

inline void NavDataSetInfo::clear_has_sharedDataAccessAttributes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  HapticData::HapticData ()  :
    _Data (),
    _sdsNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HapticData::HapticData (const HapticData &rhs)  :
    _Data (),
    _sdsNameObjectId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HapticData::HapticData (const ::std::string& Data_, const GlobalNamedObjectId& sdsNameObjectId_)  :
    _Data (Data_),
    _sdsNameObjectId (sdsNameObjectId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Data_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HapticData::~HapticData() {
}

inline HapticData& HapticData::operator = (const HapticData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasSdsNameObjectId()) {
            setSdsNameObjectId(rhs.getSdsNameObjectId());
        } else {
            clearSdsNameObjectId();
        }
    }
    return *this;
}

inline bool HapticData::operator == (const HapticData& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasSdsNameObjectId() && !rhs.hasSdsNameObjectId()) || getSdsNameObjectId() == rhs.getSdsNameObjectId()));
}

inline bool HapticData::operator != (const HapticData& rhs) const {
    return ! (*this == rhs);
}

inline bool HapticData::operator < (const HapticData& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasSdsNameObjectId() || rhs.hasSdsNameObjectId()) {
        if (getSdsNameObjectId() < rhs.getSdsNameObjectId()) return true;
        if (getSdsNameObjectId() > rhs.getSdsNameObjectId()) return false;
    }
    return false;
}

inline bool HapticData::operator > (const HapticData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HapticData::clear() {
    clearData();
    clearSdsNameObjectId();
}

inline void HapticData::clearData() {
    if (hasData()) {
         clear_has_Data();
        _Data.clear();
     }
}

inline bool HapticData::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& HapticData::getData () const {
    return _Data;
}

inline ::std::string& HapticData::getDataMutable () {
    set_has_Data();
    return _Data;
}

inline void HapticData::setData (const ::std::string& Data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Data();
    this->_Data = Data_;
}

inline void HapticData::setData (const char* Data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Data();
    this->_Data.assign(Data_);
}

inline void HapticData::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Data();
    this->_Data.assign(value, size);
}

inline void HapticData::clearSdsNameObjectId() {
    if (hasSdsNameObjectId()) {
         clear_has_sdsNameObjectId();
        _sdsNameObjectId.clear();
     }
}

inline bool HapticData::hasSdsNameObjectId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const GlobalNamedObjectId& HapticData::getSdsNameObjectId () const {
    return _sdsNameObjectId;
}

inline GlobalNamedObjectId& HapticData::getSdsNameObjectIdMutable () {
    set_has_sdsNameObjectId();
    return _sdsNameObjectId;
}

inline void HapticData::setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_) {
    set_has_sdsNameObjectId();
    this->_sdsNameObjectId = sdsNameObjectId_;
}

inline void HapticData::set_has_Data () {
    _has_bits_[0] |= 1u << 0;
}

inline void HapticData::clear_has_Data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HapticData::set_has_sdsNameObjectId () {
    _has_bits_[0] |= 1u << 1;
}

inline void HapticData::clear_has_sdsNameObjectId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetGlobalDataForSdsResponse::GetGlobalDataForSdsResponse ()  :
    _deviceName (),
    _datasetId (0u),
    _persistentDatasetId (),
    _sdsProductsList (),
    _updateRegionSpecifierRelationsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetGlobalDataForSdsResponse::GetGlobalDataForSdsResponse (const GetGlobalDataForSdsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _deviceName (),
    _datasetId (0u),
    _persistentDatasetId (),
    _sdsProductsList (),
    _updateRegionSpecifierRelationsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetGlobalDataForSdsResponse::GetGlobalDataForSdsResponse (const ::std::string& deviceName_, uint32 datasetId_, const ::std::string& persistentDatasetId_, const ::std::vector< SdsProducts >& sdsProductsList_, const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList_)  :
    _deviceName (deviceName_),
    _datasetId (datasetId_),
    _persistentDatasetId (persistentDatasetId_),
    _sdsProductsList (sdsProductsList_),
    _updateRegionSpecifierRelationsList (updateRegionSpecifierRelationsList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetGlobalDataForSdsResponse::~GetGlobalDataForSdsResponse() {
}

inline GetGlobalDataForSdsResponse& GetGlobalDataForSdsResponse::operator = (const GetGlobalDataForSdsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
        if (rhs.hasDatasetId()) {
            setDatasetId(rhs.getDatasetId());
        } else {
            clearDatasetId();
        }
        if (rhs.hasPersistentDatasetId()) {
            setPersistentDatasetId(rhs.getPersistentDatasetId());
        } else {
            clearPersistentDatasetId();
        }
        if (rhs.hasSdsProductsList()) {
            setSdsProductsList(rhs.getSdsProductsList());
        } else {
            clearSdsProductsList();
        }
        if (rhs.hasUpdateRegionSpecifierRelationsList()) {
            setUpdateRegionSpecifierRelationsList(rhs.getUpdateRegionSpecifierRelationsList());
        } else {
            clearUpdateRegionSpecifierRelationsList();
        }
    }
    return *this;
}

inline bool GetGlobalDataForSdsResponse::operator == (const GetGlobalDataForSdsResponse& rhs) const {
    return (((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()) &&
        ((!hasDatasetId() && !rhs.hasDatasetId()) || getDatasetId() == rhs.getDatasetId()) &&
        ((!hasPersistentDatasetId() && !rhs.hasPersistentDatasetId()) || getPersistentDatasetId() == rhs.getPersistentDatasetId()) &&
        ((!hasSdsProductsList() && !rhs.hasSdsProductsList()) || getSdsProductsList() == rhs.getSdsProductsList()) &&
        ((!hasUpdateRegionSpecifierRelationsList() && !rhs.hasUpdateRegionSpecifierRelationsList()) || getUpdateRegionSpecifierRelationsList() == rhs.getUpdateRegionSpecifierRelationsList()));
}

inline bool GetGlobalDataForSdsResponse::operator != (const GetGlobalDataForSdsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetGlobalDataForSdsResponse::operator < (const GetGlobalDataForSdsResponse& rhs) const {
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    if (hasDatasetId() || rhs.hasDatasetId()) {
        if (getDatasetId() < rhs.getDatasetId()) return true;
        if (getDatasetId() > rhs.getDatasetId()) return false;
    }
    if (hasPersistentDatasetId() || rhs.hasPersistentDatasetId()) {
        if (getPersistentDatasetId() < rhs.getPersistentDatasetId()) return true;
        if (getPersistentDatasetId() > rhs.getPersistentDatasetId()) return false;
    }
    if (hasSdsProductsList() || rhs.hasSdsProductsList()) {
        if (getSdsProductsList() < rhs.getSdsProductsList()) return true;
        if (getSdsProductsList() > rhs.getSdsProductsList()) return false;
    }
    if (hasUpdateRegionSpecifierRelationsList() || rhs.hasUpdateRegionSpecifierRelationsList()) {
        if (getUpdateRegionSpecifierRelationsList() < rhs.getUpdateRegionSpecifierRelationsList()) return true;
        if (getUpdateRegionSpecifierRelationsList() > rhs.getUpdateRegionSpecifierRelationsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetGlobalDataForSdsResponse::clone() {
    return new GetGlobalDataForSdsResponse(*this);
}

inline bool GetGlobalDataForSdsResponse::operator > (const GetGlobalDataForSdsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetGlobalDataForSdsResponse::clear() {
    clearDeviceName();
    clearDatasetId();
    clearPersistentDatasetId();
    clearSdsProductsList();
    clearUpdateRegionSpecifierRelationsList();
}

inline void GetGlobalDataForSdsResponse::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_deviceName();
        _deviceName.clear();
     }
}

inline bool GetGlobalDataForSdsResponse::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetGlobalDataForSdsResponse::getDeviceName () const {
    return _deviceName;
}

inline ::std::string& GetGlobalDataForSdsResponse::getDeviceNameMutable () {
    set_has_deviceName();
    return _deviceName;
}

inline void GetGlobalDataForSdsResponse::setDeviceName (const ::std::string& deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName = deviceName_;
}

inline void GetGlobalDataForSdsResponse::setDeviceName (const char* deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(deviceName_);
}

inline void GetGlobalDataForSdsResponse::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(value, size);
}

inline void GetGlobalDataForSdsResponse::clearDatasetId() {
    if (hasDatasetId()) {
         clear_has_datasetId();
        _datasetId = 0u;
     }
}

inline bool GetGlobalDataForSdsResponse::hasDatasetId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetGlobalDataForSdsResponse::getDatasetId () const {
    return _datasetId;
}

inline void GetGlobalDataForSdsResponse::setDatasetId (uint32 datasetId_) {
    set_has_datasetId();
    this->_datasetId = datasetId_;
}

inline void GetGlobalDataForSdsResponse::clearPersistentDatasetId() {
    if (hasPersistentDatasetId()) {
         clear_has_persistentDatasetId();
        _persistentDatasetId.clear();
     }
}

inline bool GetGlobalDataForSdsResponse::hasPersistentDatasetId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& GetGlobalDataForSdsResponse::getPersistentDatasetId () const {
    return _persistentDatasetId;
}

inline ::std::string& GetGlobalDataForSdsResponse::getPersistentDatasetIdMutable () {
    set_has_persistentDatasetId();
    return _persistentDatasetId;
}

inline void GetGlobalDataForSdsResponse::setPersistentDatasetId (const ::std::string& persistentDatasetId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId = persistentDatasetId_;
}

inline void GetGlobalDataForSdsResponse::setPersistentDatasetId (const char* persistentDatasetId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (persistentDatasetId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId.assign(persistentDatasetId_);
}

inline void GetGlobalDataForSdsResponse::setPersistentDatasetId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_persistentDatasetId();
    this->_persistentDatasetId.assign(value, size);
}

inline void GetGlobalDataForSdsResponse::clearSdsProductsList() {
    if (hasSdsProductsList()) {
         clear_has_sdsProductsList();
        _sdsProductsList.clear();
     }
}

inline bool GetGlobalDataForSdsResponse::hasSdsProductsList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< SdsProducts >& GetGlobalDataForSdsResponse::getSdsProductsList () const {
    return _sdsProductsList;
}

inline ::std::vector< SdsProducts >& GetGlobalDataForSdsResponse::getSdsProductsListMutable () {
    set_has_sdsProductsList();
    return _sdsProductsList;
}

inline void GetGlobalDataForSdsResponse::setSdsProductsList (const ::std::vector< SdsProducts >& sdsProductsList_) {
    set_has_sdsProductsList();
    this->_sdsProductsList = sdsProductsList_;
}

inline void GetGlobalDataForSdsResponse::clearUpdateRegionSpecifierRelationsList() {
    if (hasUpdateRegionSpecifierRelationsList()) {
         clear_has_updateRegionSpecifierRelationsList();
        _updateRegionSpecifierRelationsList.clear();
     }
}

inline bool GetGlobalDataForSdsResponse::hasUpdateRegionSpecifierRelationsList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< UpdateRegionSpecifierRelations >& GetGlobalDataForSdsResponse::getUpdateRegionSpecifierRelationsList () const {
    return _updateRegionSpecifierRelationsList;
}

inline ::std::vector< UpdateRegionSpecifierRelations >& GetGlobalDataForSdsResponse::getUpdateRegionSpecifierRelationsListMutable () {
    set_has_updateRegionSpecifierRelationsList();
    return _updateRegionSpecifierRelationsList;
}

inline void GetGlobalDataForSdsResponse::setUpdateRegionSpecifierRelationsList (const ::std::vector< UpdateRegionSpecifierRelations >& updateRegionSpecifierRelationsList_) {
    set_has_updateRegionSpecifierRelationsList();
    this->_updateRegionSpecifierRelationsList = updateRegionSpecifierRelationsList_;
}

inline void GetGlobalDataForSdsResponse::set_has_deviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetGlobalDataForSdsResponse::clear_has_deviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetGlobalDataForSdsResponse::set_has_datasetId () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetGlobalDataForSdsResponse::clear_has_datasetId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetGlobalDataForSdsResponse::set_has_persistentDatasetId () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetGlobalDataForSdsResponse::clear_has_persistentDatasetId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetGlobalDataForSdsResponse::set_has_sdsProductsList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetGlobalDataForSdsResponse::clear_has_sdsProductsList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetGlobalDataForSdsResponse::set_has_updateRegionSpecifierRelationsList () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetGlobalDataForSdsResponse::clear_has_updateRegionSpecifierRelationsList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetIdListOfCountryAndSubCountryResponse::GetIdListOfCountryAndSubCountryResponse ()  :
    _countryIdList (),
    _subCountryIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetIdListOfCountryAndSubCountryResponse::GetIdListOfCountryAndSubCountryResponse (const GetIdListOfCountryAndSubCountryResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _countryIdList (),
    _subCountryIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetIdListOfCountryAndSubCountryResponse::GetIdListOfCountryAndSubCountryResponse (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList_, const ::std::vector< SubCountryIds >& subCountryIdList_)  :
    _countryIdList (countryIdList_),
    _subCountryIdList (subCountryIdList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetIdListOfCountryAndSubCountryResponse::~GetIdListOfCountryAndSubCountryResponse() {
}

inline GetIdListOfCountryAndSubCountryResponse& GetIdListOfCountryAndSubCountryResponse::operator = (const GetIdListOfCountryAndSubCountryResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCountryIdList()) {
            setCountryIdList(rhs.getCountryIdList());
        } else {
            clearCountryIdList();
        }
        if (rhs.hasSubCountryIdList()) {
            setSubCountryIdList(rhs.getSubCountryIdList());
        } else {
            clearSubCountryIdList();
        }
    }
    return *this;
}

inline bool GetIdListOfCountryAndSubCountryResponse::operator == (const GetIdListOfCountryAndSubCountryResponse& rhs) const {
    return (((!hasCountryIdList() && !rhs.hasCountryIdList()) || getCountryIdList() == rhs.getCountryIdList()) &&
        ((!hasSubCountryIdList() && !rhs.hasSubCountryIdList()) || getSubCountryIdList() == rhs.getSubCountryIdList()));
}

inline bool GetIdListOfCountryAndSubCountryResponse::operator != (const GetIdListOfCountryAndSubCountryResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetIdListOfCountryAndSubCountryResponse::operator < (const GetIdListOfCountryAndSubCountryResponse& rhs) const {
    if (hasCountryIdList() || rhs.hasCountryIdList()) {
        if (getCountryIdList() < rhs.getCountryIdList()) return true;
        if (getCountryIdList() > rhs.getCountryIdList()) return false;
    }
    if (hasSubCountryIdList() || rhs.hasSubCountryIdList()) {
        if (getSubCountryIdList() < rhs.getSubCountryIdList()) return true;
        if (getSubCountryIdList() > rhs.getSubCountryIdList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetIdListOfCountryAndSubCountryResponse::clone() {
    return new GetIdListOfCountryAndSubCountryResponse(*this);
}

inline bool GetIdListOfCountryAndSubCountryResponse::operator > (const GetIdListOfCountryAndSubCountryResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetIdListOfCountryAndSubCountryResponse::clear() {
    clearCountryIdList();
    clearSubCountryIdList();
}

inline void GetIdListOfCountryAndSubCountryResponse::clearCountryIdList() {
    if (hasCountryIdList()) {
         clear_has_countryIdList();
        _countryIdList.clear();
     }
}

inline bool GetIdListOfCountryAndSubCountryResponse::hasCountryIdList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GlobalNamedObjectAndRegionId >& GetIdListOfCountryAndSubCountryResponse::getCountryIdList () const {
    return _countryIdList;
}

inline ::std::vector< GlobalNamedObjectAndRegionId >& GetIdListOfCountryAndSubCountryResponse::getCountryIdListMutable () {
    set_has_countryIdList();
    return _countryIdList;
}

inline void GetIdListOfCountryAndSubCountryResponse::setCountryIdList (const ::std::vector< GlobalNamedObjectAndRegionId >& countryIdList_) {
    set_has_countryIdList();
    this->_countryIdList = countryIdList_;
}

inline void GetIdListOfCountryAndSubCountryResponse::clearSubCountryIdList() {
    if (hasSubCountryIdList()) {
         clear_has_subCountryIdList();
        _subCountryIdList.clear();
     }
}

inline bool GetIdListOfCountryAndSubCountryResponse::hasSubCountryIdList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SubCountryIds >& GetIdListOfCountryAndSubCountryResponse::getSubCountryIdList () const {
    return _subCountryIdList;
}

inline ::std::vector< SubCountryIds >& GetIdListOfCountryAndSubCountryResponse::getSubCountryIdListMutable () {
    set_has_subCountryIdList();
    return _subCountryIdList;
}

inline void GetIdListOfCountryAndSubCountryResponse::setSubCountryIdList (const ::std::vector< SubCountryIds >& subCountryIdList_) {
    set_has_subCountryIdList();
    this->_subCountryIdList = subCountryIdList_;
}

inline void GetIdListOfCountryAndSubCountryResponse::set_has_countryIdList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetIdListOfCountryAndSubCountryResponse::clear_has_countryIdList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetIdListOfCountryAndSubCountryResponse::set_has_subCountryIdList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetIdListOfCountryAndSubCountryResponse::clear_has_subCountryIdList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetNamesForNDSIdsRequest::GetNamesForNDSIdsRequest ()  :
    _globalNamedObjectIdList (),
    _languageEntryList (),
    _ndsFeatureType (::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT),
    _stopOnFirstMatch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNamesForNDSIdsRequest::GetNamesForNDSIdsRequest (const GetNamesForNDSIdsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _globalNamedObjectIdList (),
    _languageEntryList (),
    _ndsFeatureType (::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT),
    _stopOnFirstMatch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNamesForNDSIdsRequest::GetNamesForNDSIdsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_, const ::std::vector< LanguageEntry >& languageEntryList_, NDSFeatureType ndsFeatureType_, bool stopOnFirstMatch_)  :
    _globalNamedObjectIdList (globalNamedObjectIdList_),
    _languageEntryList (languageEntryList_),
    _ndsFeatureType (ndsFeatureType_),
    _stopOnFirstMatch (stopOnFirstMatch_)
{
    #ifndef NDEBUG
    if (!(NDSFeatureType_IsValid(ndsFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsFeatureType_, "NDSFeatureType", "ndsFeatureType", "GetNamesForNDSIdsRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNamesForNDSIdsRequest::~GetNamesForNDSIdsRequest() {
}

inline GetNamesForNDSIdsRequest& GetNamesForNDSIdsRequest::operator = (const GetNamesForNDSIdsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGlobalNamedObjectIdList()) {
            setGlobalNamedObjectIdList(rhs.getGlobalNamedObjectIdList());
        } else {
            clearGlobalNamedObjectIdList();
        }
        if (rhs.hasLanguageEntryList()) {
            setLanguageEntryList(rhs.getLanguageEntryList());
        } else {
            clearLanguageEntryList();
        }
        if (rhs.hasNdsFeatureType()) {
            setNdsFeatureType(rhs.getNdsFeatureType());
        } else {
            clearNdsFeatureType();
        }
        if (rhs.hasStopOnFirstMatch()) {
            setStopOnFirstMatch(rhs.getStopOnFirstMatch());
        } else {
            clearStopOnFirstMatch();
        }
    }
    return *this;
}

inline bool GetNamesForNDSIdsRequest::operator == (const GetNamesForNDSIdsRequest& rhs) const {
    return (((!hasGlobalNamedObjectIdList() && !rhs.hasGlobalNamedObjectIdList()) || getGlobalNamedObjectIdList() == rhs.getGlobalNamedObjectIdList()) &&
        ((!hasLanguageEntryList() && !rhs.hasLanguageEntryList()) || getLanguageEntryList() == rhs.getLanguageEntryList()) &&
        ((!hasNdsFeatureType() && !rhs.hasNdsFeatureType()) || getNdsFeatureType() == rhs.getNdsFeatureType()) &&
        ((!hasStopOnFirstMatch() && !rhs.hasStopOnFirstMatch()) || getStopOnFirstMatch() == rhs.getStopOnFirstMatch()));
}

inline bool GetNamesForNDSIdsRequest::operator != (const GetNamesForNDSIdsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNamesForNDSIdsRequest::operator < (const GetNamesForNDSIdsRequest& rhs) const {
    if (hasGlobalNamedObjectIdList() || rhs.hasGlobalNamedObjectIdList()) {
        if (getGlobalNamedObjectIdList() < rhs.getGlobalNamedObjectIdList()) return true;
        if (getGlobalNamedObjectIdList() > rhs.getGlobalNamedObjectIdList()) return false;
    }
    if (hasLanguageEntryList() || rhs.hasLanguageEntryList()) {
        if (getLanguageEntryList() < rhs.getLanguageEntryList()) return true;
        if (getLanguageEntryList() > rhs.getLanguageEntryList()) return false;
    }
    if (hasNdsFeatureType() || rhs.hasNdsFeatureType()) {
        if ((uint32)getNdsFeatureType() < (uint32)rhs.getNdsFeatureType()) return true;
        if ((uint32)getNdsFeatureType() > (uint32)rhs.getNdsFeatureType()) return false;
    }
    if (hasStopOnFirstMatch() || rhs.hasStopOnFirstMatch()) {
        if (getStopOnFirstMatch() < rhs.getStopOnFirstMatch()) return true;
        if (getStopOnFirstMatch() > rhs.getStopOnFirstMatch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNamesForNDSIdsRequest::clone() {
    return new GetNamesForNDSIdsRequest(*this);
}

inline bool GetNamesForNDSIdsRequest::operator > (const GetNamesForNDSIdsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNamesForNDSIdsRequest::clear() {
    clearGlobalNamedObjectIdList();
    clearLanguageEntryList();
    clearNdsFeatureType();
    clearStopOnFirstMatch();
}

inline void GetNamesForNDSIdsRequest::clearGlobalNamedObjectIdList() {
    if (hasGlobalNamedObjectIdList()) {
         clear_has_globalNamedObjectIdList();
        _globalNamedObjectIdList.clear();
     }
}

inline bool GetNamesForNDSIdsRequest::hasGlobalNamedObjectIdList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GlobalNamedObjectId >& GetNamesForNDSIdsRequest::getGlobalNamedObjectIdList () const {
    return _globalNamedObjectIdList;
}

inline ::std::vector< GlobalNamedObjectId >& GetNamesForNDSIdsRequest::getGlobalNamedObjectIdListMutable () {
    set_has_globalNamedObjectIdList();
    return _globalNamedObjectIdList;
}

inline void GetNamesForNDSIdsRequest::setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_) {
    set_has_globalNamedObjectIdList();
    this->_globalNamedObjectIdList = globalNamedObjectIdList_;
}

inline void GetNamesForNDSIdsRequest::clearLanguageEntryList() {
    if (hasLanguageEntryList()) {
         clear_has_languageEntryList();
        _languageEntryList.clear();
     }
}

inline bool GetNamesForNDSIdsRequest::hasLanguageEntryList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< LanguageEntry >& GetNamesForNDSIdsRequest::getLanguageEntryList () const {
    return _languageEntryList;
}

inline ::std::vector< LanguageEntry >& GetNamesForNDSIdsRequest::getLanguageEntryListMutable () {
    set_has_languageEntryList();
    return _languageEntryList;
}

inline void GetNamesForNDSIdsRequest::setLanguageEntryList (const ::std::vector< LanguageEntry >& languageEntryList_) {
    set_has_languageEntryList();
    this->_languageEntryList = languageEntryList_;
}

inline void GetNamesForNDSIdsRequest::clearNdsFeatureType() {
    if (hasNdsFeatureType()) {
         clear_has_ndsFeatureType();
        _ndsFeatureType = ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT;
     }
}

inline bool GetNamesForNDSIdsRequest::hasNdsFeatureType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline NDSFeatureType GetNamesForNDSIdsRequest::getNdsFeatureType () const {
    return _ndsFeatureType;
}

inline void GetNamesForNDSIdsRequest::setNdsFeatureType (NDSFeatureType ndsFeatureType_) {
    #ifndef NDEBUG
    if (!(NDSFeatureType_IsValid(ndsFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsFeatureType_, "NDSFeatureType", "ndsFeatureType", "GetNamesForNDSIdsRequest");
    }
    #endif
    set_has_ndsFeatureType();
    this->_ndsFeatureType = ndsFeatureType_;
}

inline void GetNamesForNDSIdsRequest::clearStopOnFirstMatch() {
    if (hasStopOnFirstMatch()) {
         clear_has_stopOnFirstMatch();
        _stopOnFirstMatch = false;
     }
}

inline bool GetNamesForNDSIdsRequest::hasStopOnFirstMatch () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool GetNamesForNDSIdsRequest::getStopOnFirstMatch () const {
    return _stopOnFirstMatch;
}

inline void GetNamesForNDSIdsRequest::setStopOnFirstMatch (bool stopOnFirstMatch_) {
    set_has_stopOnFirstMatch();
    this->_stopOnFirstMatch = stopOnFirstMatch_;
}

inline void GetNamesForNDSIdsRequest::set_has_globalNamedObjectIdList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNamesForNDSIdsRequest::clear_has_globalNamedObjectIdList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetNamesForNDSIdsRequest::set_has_languageEntryList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetNamesForNDSIdsRequest::clear_has_languageEntryList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetNamesForNDSIdsRequest::set_has_ndsFeatureType () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetNamesForNDSIdsRequest::clear_has_ndsFeatureType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetNamesForNDSIdsRequest::set_has_stopOnFirstMatch () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetNamesForNDSIdsRequest::clear_has_stopOnFirstMatch () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetNamesForNDSIdsResponse::GetNamesForNDSIdsResponse ()  :
    _namedObjectIdStringsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNamesForNDSIdsResponse::GetNamesForNDSIdsResponse (const GetNamesForNDSIdsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _namedObjectIdStringsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNamesForNDSIdsResponse::GetNamesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_)  :
    _namedObjectIdStringsList (namedObjectIdStringsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNamesForNDSIdsResponse::~GetNamesForNDSIdsResponse() {
}

inline GetNamesForNDSIdsResponse& GetNamesForNDSIdsResponse::operator = (const GetNamesForNDSIdsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNamedObjectIdStringsList()) {
            setNamedObjectIdStringsList(rhs.getNamedObjectIdStringsList());
        } else {
            clearNamedObjectIdStringsList();
        }
    }
    return *this;
}

inline bool GetNamesForNDSIdsResponse::operator == (const GetNamesForNDSIdsResponse& rhs) const {
    return (((!hasNamedObjectIdStringsList() && !rhs.hasNamedObjectIdStringsList()) || getNamedObjectIdStringsList() == rhs.getNamedObjectIdStringsList()));
}

inline bool GetNamesForNDSIdsResponse::operator != (const GetNamesForNDSIdsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNamesForNDSIdsResponse::operator < (const GetNamesForNDSIdsResponse& rhs) const {
    if (hasNamedObjectIdStringsList() || rhs.hasNamedObjectIdStringsList()) {
        if (getNamedObjectIdStringsList() < rhs.getNamedObjectIdStringsList()) return true;
        if (getNamedObjectIdStringsList() > rhs.getNamedObjectIdStringsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNamesForNDSIdsResponse::clone() {
    return new GetNamesForNDSIdsResponse(*this);
}

inline bool GetNamesForNDSIdsResponse::operator > (const GetNamesForNDSIdsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNamesForNDSIdsResponse::clear() {
    clearNamedObjectIdStringsList();
}

inline void GetNamesForNDSIdsResponse::clearNamedObjectIdStringsList() {
    if (hasNamedObjectIdStringsList()) {
         clear_has_namedObjectIdStringsList();
        _namedObjectIdStringsList.clear();
     }
}

inline bool GetNamesForNDSIdsResponse::hasNamedObjectIdStringsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< NamedObjectIdStrings >& GetNamesForNDSIdsResponse::getNamedObjectIdStringsList () const {
    return _namedObjectIdStringsList;
}

inline ::std::vector< NamedObjectIdStrings >& GetNamesForNDSIdsResponse::getNamedObjectIdStringsListMutable () {
    set_has_namedObjectIdStringsList();
    return _namedObjectIdStringsList;
}

inline void GetNamesForNDSIdsResponse::setNamedObjectIdStringsList (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_) {
    set_has_namedObjectIdStringsList();
    this->_namedObjectIdStringsList = namedObjectIdStringsList_;
}

inline void GetNamesForNDSIdsResponse::set_has_namedObjectIdStringsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNamesForNDSIdsResponse::clear_has_namedObjectIdStringsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPhonemesForNDSIdsRequest::GetPhonemesForNDSIdsRequest ()  :
    _globalNamedObjectIdList (),
    _languageEntryList (),
    _ndsFeatureType (::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT),
    _stopOnFirstMatch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPhonemesForNDSIdsRequest::GetPhonemesForNDSIdsRequest (const GetPhonemesForNDSIdsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _globalNamedObjectIdList (),
    _languageEntryList (),
    _ndsFeatureType (::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT),
    _stopOnFirstMatch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPhonemesForNDSIdsRequest::GetPhonemesForNDSIdsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_, const ::std::vector< LanguageEntry >& languageEntryList_, NDSFeatureType ndsFeatureType_, bool stopOnFirstMatch_)  :
    _globalNamedObjectIdList (globalNamedObjectIdList_),
    _languageEntryList (languageEntryList_),
    _ndsFeatureType (ndsFeatureType_),
    _stopOnFirstMatch (stopOnFirstMatch_)
{
    #ifndef NDEBUG
    if (!(NDSFeatureType_IsValid(ndsFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsFeatureType_, "NDSFeatureType", "ndsFeatureType", "GetPhonemesForNDSIdsRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPhonemesForNDSIdsRequest::~GetPhonemesForNDSIdsRequest() {
}

inline GetPhonemesForNDSIdsRequest& GetPhonemesForNDSIdsRequest::operator = (const GetPhonemesForNDSIdsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGlobalNamedObjectIdList()) {
            setGlobalNamedObjectIdList(rhs.getGlobalNamedObjectIdList());
        } else {
            clearGlobalNamedObjectIdList();
        }
        if (rhs.hasLanguageEntryList()) {
            setLanguageEntryList(rhs.getLanguageEntryList());
        } else {
            clearLanguageEntryList();
        }
        if (rhs.hasNdsFeatureType()) {
            setNdsFeatureType(rhs.getNdsFeatureType());
        } else {
            clearNdsFeatureType();
        }
        if (rhs.hasStopOnFirstMatch()) {
            setStopOnFirstMatch(rhs.getStopOnFirstMatch());
        } else {
            clearStopOnFirstMatch();
        }
    }
    return *this;
}

inline bool GetPhonemesForNDSIdsRequest::operator == (const GetPhonemesForNDSIdsRequest& rhs) const {
    return (((!hasGlobalNamedObjectIdList() && !rhs.hasGlobalNamedObjectIdList()) || getGlobalNamedObjectIdList() == rhs.getGlobalNamedObjectIdList()) &&
        ((!hasLanguageEntryList() && !rhs.hasLanguageEntryList()) || getLanguageEntryList() == rhs.getLanguageEntryList()) &&
        ((!hasNdsFeatureType() && !rhs.hasNdsFeatureType()) || getNdsFeatureType() == rhs.getNdsFeatureType()) &&
        ((!hasStopOnFirstMatch() && !rhs.hasStopOnFirstMatch()) || getStopOnFirstMatch() == rhs.getStopOnFirstMatch()));
}

inline bool GetPhonemesForNDSIdsRequest::operator != (const GetPhonemesForNDSIdsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhonemesForNDSIdsRequest::operator < (const GetPhonemesForNDSIdsRequest& rhs) const {
    if (hasGlobalNamedObjectIdList() || rhs.hasGlobalNamedObjectIdList()) {
        if (getGlobalNamedObjectIdList() < rhs.getGlobalNamedObjectIdList()) return true;
        if (getGlobalNamedObjectIdList() > rhs.getGlobalNamedObjectIdList()) return false;
    }
    if (hasLanguageEntryList() || rhs.hasLanguageEntryList()) {
        if (getLanguageEntryList() < rhs.getLanguageEntryList()) return true;
        if (getLanguageEntryList() > rhs.getLanguageEntryList()) return false;
    }
    if (hasNdsFeatureType() || rhs.hasNdsFeatureType()) {
        if ((uint32)getNdsFeatureType() < (uint32)rhs.getNdsFeatureType()) return true;
        if ((uint32)getNdsFeatureType() > (uint32)rhs.getNdsFeatureType()) return false;
    }
    if (hasStopOnFirstMatch() || rhs.hasStopOnFirstMatch()) {
        if (getStopOnFirstMatch() < rhs.getStopOnFirstMatch()) return true;
        if (getStopOnFirstMatch() > rhs.getStopOnFirstMatch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPhonemesForNDSIdsRequest::clone() {
    return new GetPhonemesForNDSIdsRequest(*this);
}

inline bool GetPhonemesForNDSIdsRequest::operator > (const GetPhonemesForNDSIdsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPhonemesForNDSIdsRequest::clear() {
    clearGlobalNamedObjectIdList();
    clearLanguageEntryList();
    clearNdsFeatureType();
    clearStopOnFirstMatch();
}

inline void GetPhonemesForNDSIdsRequest::clearGlobalNamedObjectIdList() {
    if (hasGlobalNamedObjectIdList()) {
         clear_has_globalNamedObjectIdList();
        _globalNamedObjectIdList.clear();
     }
}

inline bool GetPhonemesForNDSIdsRequest::hasGlobalNamedObjectIdList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GlobalNamedObjectId >& GetPhonemesForNDSIdsRequest::getGlobalNamedObjectIdList () const {
    return _globalNamedObjectIdList;
}

inline ::std::vector< GlobalNamedObjectId >& GetPhonemesForNDSIdsRequest::getGlobalNamedObjectIdListMutable () {
    set_has_globalNamedObjectIdList();
    return _globalNamedObjectIdList;
}

inline void GetPhonemesForNDSIdsRequest::setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_) {
    set_has_globalNamedObjectIdList();
    this->_globalNamedObjectIdList = globalNamedObjectIdList_;
}

inline void GetPhonemesForNDSIdsRequest::clearLanguageEntryList() {
    if (hasLanguageEntryList()) {
         clear_has_languageEntryList();
        _languageEntryList.clear();
     }
}

inline bool GetPhonemesForNDSIdsRequest::hasLanguageEntryList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< LanguageEntry >& GetPhonemesForNDSIdsRequest::getLanguageEntryList () const {
    return _languageEntryList;
}

inline ::std::vector< LanguageEntry >& GetPhonemesForNDSIdsRequest::getLanguageEntryListMutable () {
    set_has_languageEntryList();
    return _languageEntryList;
}

inline void GetPhonemesForNDSIdsRequest::setLanguageEntryList (const ::std::vector< LanguageEntry >& languageEntryList_) {
    set_has_languageEntryList();
    this->_languageEntryList = languageEntryList_;
}

inline void GetPhonemesForNDSIdsRequest::clearNdsFeatureType() {
    if (hasNdsFeatureType()) {
         clear_has_ndsFeatureType();
        _ndsFeatureType = ::org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType__NAMEDOBJECT;
     }
}

inline bool GetPhonemesForNDSIdsRequest::hasNdsFeatureType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline NDSFeatureType GetPhonemesForNDSIdsRequest::getNdsFeatureType () const {
    return _ndsFeatureType;
}

inline void GetPhonemesForNDSIdsRequest::setNdsFeatureType (NDSFeatureType ndsFeatureType_) {
    #ifndef NDEBUG
    if (!(NDSFeatureType_IsValid(ndsFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsFeatureType_, "NDSFeatureType", "ndsFeatureType", "GetPhonemesForNDSIdsRequest");
    }
    #endif
    set_has_ndsFeatureType();
    this->_ndsFeatureType = ndsFeatureType_;
}

inline void GetPhonemesForNDSIdsRequest::clearStopOnFirstMatch() {
    if (hasStopOnFirstMatch()) {
         clear_has_stopOnFirstMatch();
        _stopOnFirstMatch = false;
     }
}

inline bool GetPhonemesForNDSIdsRequest::hasStopOnFirstMatch () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool GetPhonemesForNDSIdsRequest::getStopOnFirstMatch () const {
    return _stopOnFirstMatch;
}

inline void GetPhonemesForNDSIdsRequest::setStopOnFirstMatch (bool stopOnFirstMatch_) {
    set_has_stopOnFirstMatch();
    this->_stopOnFirstMatch = stopOnFirstMatch_;
}

inline void GetPhonemesForNDSIdsRequest::set_has_globalNamedObjectIdList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPhonemesForNDSIdsRequest::clear_has_globalNamedObjectIdList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPhonemesForNDSIdsRequest::set_has_languageEntryList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPhonemesForNDSIdsRequest::clear_has_languageEntryList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetPhonemesForNDSIdsRequest::set_has_ndsFeatureType () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetPhonemesForNDSIdsRequest::clear_has_ndsFeatureType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetPhonemesForNDSIdsRequest::set_has_stopOnFirstMatch () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetPhonemesForNDSIdsRequest::clear_has_stopOnFirstMatch () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetPhonemesForNDSIdsResponse::GetPhonemesForNDSIdsResponse ()  :
    _namedObjectIdStringsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPhonemesForNDSIdsResponse::GetPhonemesForNDSIdsResponse (const GetPhonemesForNDSIdsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _namedObjectIdStringsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPhonemesForNDSIdsResponse::GetPhonemesForNDSIdsResponse (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_)  :
    _namedObjectIdStringsList (namedObjectIdStringsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPhonemesForNDSIdsResponse::~GetPhonemesForNDSIdsResponse() {
}

inline GetPhonemesForNDSIdsResponse& GetPhonemesForNDSIdsResponse::operator = (const GetPhonemesForNDSIdsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNamedObjectIdStringsList()) {
            setNamedObjectIdStringsList(rhs.getNamedObjectIdStringsList());
        } else {
            clearNamedObjectIdStringsList();
        }
    }
    return *this;
}

inline bool GetPhonemesForNDSIdsResponse::operator == (const GetPhonemesForNDSIdsResponse& rhs) const {
    return (((!hasNamedObjectIdStringsList() && !rhs.hasNamedObjectIdStringsList()) || getNamedObjectIdStringsList() == rhs.getNamedObjectIdStringsList()));
}

inline bool GetPhonemesForNDSIdsResponse::operator != (const GetPhonemesForNDSIdsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhonemesForNDSIdsResponse::operator < (const GetPhonemesForNDSIdsResponse& rhs) const {
    if (hasNamedObjectIdStringsList() || rhs.hasNamedObjectIdStringsList()) {
        if (getNamedObjectIdStringsList() < rhs.getNamedObjectIdStringsList()) return true;
        if (getNamedObjectIdStringsList() > rhs.getNamedObjectIdStringsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPhonemesForNDSIdsResponse::clone() {
    return new GetPhonemesForNDSIdsResponse(*this);
}

inline bool GetPhonemesForNDSIdsResponse::operator > (const GetPhonemesForNDSIdsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPhonemesForNDSIdsResponse::clear() {
    clearNamedObjectIdStringsList();
}

inline void GetPhonemesForNDSIdsResponse::clearNamedObjectIdStringsList() {
    if (hasNamedObjectIdStringsList()) {
         clear_has_namedObjectIdStringsList();
        _namedObjectIdStringsList.clear();
     }
}

inline bool GetPhonemesForNDSIdsResponse::hasNamedObjectIdStringsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< NamedObjectIdStrings >& GetPhonemesForNDSIdsResponse::getNamedObjectIdStringsList () const {
    return _namedObjectIdStringsList;
}

inline ::std::vector< NamedObjectIdStrings >& GetPhonemesForNDSIdsResponse::getNamedObjectIdStringsListMutable () {
    set_has_namedObjectIdStringsList();
    return _namedObjectIdStringsList;
}

inline void GetPhonemesForNDSIdsResponse::setNamedObjectIdStringsList (const ::std::vector< NamedObjectIdStrings >& namedObjectIdStringsList_) {
    set_has_namedObjectIdStringsList();
    this->_namedObjectIdStringsList = namedObjectIdStringsList_;
}

inline void GetPhonemesForNDSIdsResponse::set_has_namedObjectIdStringsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPhonemesForNDSIdsResponse::clear_has_namedObjectIdStringsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCityHasStreetsRequest::GetCityHasStreetsRequest ()  :
    _globalNamedObjectIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCityHasStreetsRequest::GetCityHasStreetsRequest (const GetCityHasStreetsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _globalNamedObjectIdList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCityHasStreetsRequest::GetCityHasStreetsRequest (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_)  :
    _globalNamedObjectIdList (globalNamedObjectIdList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCityHasStreetsRequest::~GetCityHasStreetsRequest() {
}

inline GetCityHasStreetsRequest& GetCityHasStreetsRequest::operator = (const GetCityHasStreetsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGlobalNamedObjectIdList()) {
            setGlobalNamedObjectIdList(rhs.getGlobalNamedObjectIdList());
        } else {
            clearGlobalNamedObjectIdList();
        }
    }
    return *this;
}

inline bool GetCityHasStreetsRequest::operator == (const GetCityHasStreetsRequest& rhs) const {
    return (((!hasGlobalNamedObjectIdList() && !rhs.hasGlobalNamedObjectIdList()) || getGlobalNamedObjectIdList() == rhs.getGlobalNamedObjectIdList()));
}

inline bool GetCityHasStreetsRequest::operator != (const GetCityHasStreetsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCityHasStreetsRequest::operator < (const GetCityHasStreetsRequest& rhs) const {
    if (hasGlobalNamedObjectIdList() || rhs.hasGlobalNamedObjectIdList()) {
        if (getGlobalNamedObjectIdList() < rhs.getGlobalNamedObjectIdList()) return true;
        if (getGlobalNamedObjectIdList() > rhs.getGlobalNamedObjectIdList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCityHasStreetsRequest::clone() {
    return new GetCityHasStreetsRequest(*this);
}

inline bool GetCityHasStreetsRequest::operator > (const GetCityHasStreetsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCityHasStreetsRequest::clear() {
    clearGlobalNamedObjectIdList();
}

inline void GetCityHasStreetsRequest::clearGlobalNamedObjectIdList() {
    if (hasGlobalNamedObjectIdList()) {
         clear_has_globalNamedObjectIdList();
        _globalNamedObjectIdList.clear();
     }
}

inline bool GetCityHasStreetsRequest::hasGlobalNamedObjectIdList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GlobalNamedObjectId >& GetCityHasStreetsRequest::getGlobalNamedObjectIdList () const {
    return _globalNamedObjectIdList;
}

inline ::std::vector< GlobalNamedObjectId >& GetCityHasStreetsRequest::getGlobalNamedObjectIdListMutable () {
    set_has_globalNamedObjectIdList();
    return _globalNamedObjectIdList;
}

inline void GetCityHasStreetsRequest::setGlobalNamedObjectIdList (const ::std::vector< GlobalNamedObjectId >& globalNamedObjectIdList_) {
    set_has_globalNamedObjectIdList();
    this->_globalNamedObjectIdList = globalNamedObjectIdList_;
}

inline void GetCityHasStreetsRequest::set_has_globalNamedObjectIdList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCityHasStreetsRequest::clear_has_globalNamedObjectIdList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCityHasStreetsResponse::GetCityHasStreetsResponse ()  :
    _cityNamedObjectIdHasStreetsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCityHasStreetsResponse::GetCityHasStreetsResponse (const GetCityHasStreetsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _cityNamedObjectIdHasStreetsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCityHasStreetsResponse::GetCityHasStreetsResponse (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList_)  :
    _cityNamedObjectIdHasStreetsList (cityNamedObjectIdHasStreetsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCityHasStreetsResponse::~GetCityHasStreetsResponse() {
}

inline GetCityHasStreetsResponse& GetCityHasStreetsResponse::operator = (const GetCityHasStreetsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCityNamedObjectIdHasStreetsList()) {
            setCityNamedObjectIdHasStreetsList(rhs.getCityNamedObjectIdHasStreetsList());
        } else {
            clearCityNamedObjectIdHasStreetsList();
        }
    }
    return *this;
}

inline bool GetCityHasStreetsResponse::operator == (const GetCityHasStreetsResponse& rhs) const {
    return (((!hasCityNamedObjectIdHasStreetsList() && !rhs.hasCityNamedObjectIdHasStreetsList()) || getCityNamedObjectIdHasStreetsList() == rhs.getCityNamedObjectIdHasStreetsList()));
}

inline bool GetCityHasStreetsResponse::operator != (const GetCityHasStreetsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCityHasStreetsResponse::operator < (const GetCityHasStreetsResponse& rhs) const {
    if (hasCityNamedObjectIdHasStreetsList() || rhs.hasCityNamedObjectIdHasStreetsList()) {
        if (getCityNamedObjectIdHasStreetsList() < rhs.getCityNamedObjectIdHasStreetsList()) return true;
        if (getCityNamedObjectIdHasStreetsList() > rhs.getCityNamedObjectIdHasStreetsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCityHasStreetsResponse::clone() {
    return new GetCityHasStreetsResponse(*this);
}

inline bool GetCityHasStreetsResponse::operator > (const GetCityHasStreetsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCityHasStreetsResponse::clear() {
    clearCityNamedObjectIdHasStreetsList();
}

inline void GetCityHasStreetsResponse::clearCityNamedObjectIdHasStreetsList() {
    if (hasCityNamedObjectIdHasStreetsList()) {
         clear_has_cityNamedObjectIdHasStreetsList();
        _cityNamedObjectIdHasStreetsList.clear();
     }
}

inline bool GetCityHasStreetsResponse::hasCityNamedObjectIdHasStreetsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CityNamedObjectIdHasStreets >& GetCityHasStreetsResponse::getCityNamedObjectIdHasStreetsList () const {
    return _cityNamedObjectIdHasStreetsList;
}

inline ::std::vector< CityNamedObjectIdHasStreets >& GetCityHasStreetsResponse::getCityNamedObjectIdHasStreetsListMutable () {
    set_has_cityNamedObjectIdHasStreetsList();
    return _cityNamedObjectIdHasStreetsList;
}

inline void GetCityHasStreetsResponse::setCityNamedObjectIdHasStreetsList (const ::std::vector< CityNamedObjectIdHasStreets >& cityNamedObjectIdHasStreetsList_) {
    set_has_cityNamedObjectIdHasStreetsList();
    this->_cityNamedObjectIdHasStreetsList = cityNamedObjectIdHasStreetsList_;
}

inline void GetCityHasStreetsResponse::set_has_cityNamedObjectIdHasStreetsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCityHasStreetsResponse::clear_has_cityNamedObjectIdHasStreetsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetHapticHandOverDataResponse::GetHapticHandOverDataResponse ()  :
    _sdsHandOverScreenId (::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_ADDRESS),
    _dataList (),
    _selectedDataListItems (),
    _locationType (::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT),
    _sdsHandOverOptionsList (),
    _searchResults ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetHapticHandOverDataResponse::GetHapticHandOverDataResponse (const GetHapticHandOverDataResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sdsHandOverScreenId (::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_ADDRESS),
    _dataList (),
    _selectedDataListItems (),
    _locationType (::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT),
    _sdsHandOverOptionsList (),
    _searchResults ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetHapticHandOverDataResponse::GetHapticHandOverDataResponse (SDSHandOverScreenId sdsHandOverScreenId_, const ::std::vector< HapticData >& dataList_, const ::std::vector< SelectedDataItem >& selectedDataListItems_, LocationType locationType_, const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList_, const ::std::vector< AddressListElement >& searchResults_)  :
    _sdsHandOverScreenId (sdsHandOverScreenId_),
    _dataList (dataList_),
    _selectedDataListItems (selectedDataListItems_),
    _locationType (locationType_),
    _sdsHandOverOptionsList (sdsHandOverOptionsList_),
    _searchResults (searchResults_)
{
    #ifndef NDEBUG
    if (!(SDSHandOverScreenId_IsValid(sdsHandOverScreenId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsHandOverScreenId_, "SDSHandOverScreenId", "sdsHandOverScreenId", "GetHapticHandOverDataResponse");
    }
    #endif
    #ifndef NDEBUG
    if (!(LocationType_IsValid(locationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", locationType_, "LocationType", "locationType", "GetHapticHandOverDataResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetHapticHandOverDataResponse::~GetHapticHandOverDataResponse() {
}

inline GetHapticHandOverDataResponse& GetHapticHandOverDataResponse::operator = (const GetHapticHandOverDataResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSdsHandOverScreenId()) {
            setSdsHandOverScreenId(rhs.getSdsHandOverScreenId());
        } else {
            clearSdsHandOverScreenId();
        }
        if (rhs.hasDataList()) {
            setDataList(rhs.getDataList());
        } else {
            clearDataList();
        }
        if (rhs.hasSelectedDataListItems()) {
            setSelectedDataListItems(rhs.getSelectedDataListItems());
        } else {
            clearSelectedDataListItems();
        }
        if (rhs.hasLocationType()) {
            setLocationType(rhs.getLocationType());
        } else {
            clearLocationType();
        }
        if (rhs.hasSdsHandOverOptionsList()) {
            setSdsHandOverOptionsList(rhs.getSdsHandOverOptionsList());
        } else {
            clearSdsHandOverOptionsList();
        }
        if (rhs.hasSearchResults()) {
            setSearchResults(rhs.getSearchResults());
        } else {
            clearSearchResults();
        }
    }
    return *this;
}

inline bool GetHapticHandOverDataResponse::operator == (const GetHapticHandOverDataResponse& rhs) const {
    return (((!hasSdsHandOverScreenId() && !rhs.hasSdsHandOverScreenId()) || getSdsHandOverScreenId() == rhs.getSdsHandOverScreenId()) &&
        ((!hasDataList() && !rhs.hasDataList()) || getDataList() == rhs.getDataList()) &&
        ((!hasSelectedDataListItems() && !rhs.hasSelectedDataListItems()) || getSelectedDataListItems() == rhs.getSelectedDataListItems()) &&
        ((!hasLocationType() && !rhs.hasLocationType()) || getLocationType() == rhs.getLocationType()) &&
        ((!hasSdsHandOverOptionsList() && !rhs.hasSdsHandOverOptionsList()) || getSdsHandOverOptionsList() == rhs.getSdsHandOverOptionsList()) &&
        ((!hasSearchResults() && !rhs.hasSearchResults()) || getSearchResults() == rhs.getSearchResults()));
}

inline bool GetHapticHandOverDataResponse::operator != (const GetHapticHandOverDataResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetHapticHandOverDataResponse::operator < (const GetHapticHandOverDataResponse& rhs) const {
    if (hasSdsHandOverScreenId() || rhs.hasSdsHandOverScreenId()) {
        if ((uint32)getSdsHandOverScreenId() < (uint32)rhs.getSdsHandOverScreenId()) return true;
        if ((uint32)getSdsHandOverScreenId() > (uint32)rhs.getSdsHandOverScreenId()) return false;
    }
    if (hasDataList() || rhs.hasDataList()) {
        if (getDataList() < rhs.getDataList()) return true;
        if (getDataList() > rhs.getDataList()) return false;
    }
    if (hasSelectedDataListItems() || rhs.hasSelectedDataListItems()) {
        if (getSelectedDataListItems() < rhs.getSelectedDataListItems()) return true;
        if (getSelectedDataListItems() > rhs.getSelectedDataListItems()) return false;
    }
    if (hasLocationType() || rhs.hasLocationType()) {
        if ((uint32)getLocationType() < (uint32)rhs.getLocationType()) return true;
        if ((uint32)getLocationType() > (uint32)rhs.getLocationType()) return false;
    }
    if (hasSdsHandOverOptionsList() || rhs.hasSdsHandOverOptionsList()) {
        if (getSdsHandOverOptionsList() < rhs.getSdsHandOverOptionsList()) return true;
        if (getSdsHandOverOptionsList() > rhs.getSdsHandOverOptionsList()) return false;
    }
    if (hasSearchResults() || rhs.hasSearchResults()) {
        if (getSearchResults() < rhs.getSearchResults()) return true;
        if (getSearchResults() > rhs.getSearchResults()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetHapticHandOverDataResponse::clone() {
    return new GetHapticHandOverDataResponse(*this);
}

inline bool GetHapticHandOverDataResponse::operator > (const GetHapticHandOverDataResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetHapticHandOverDataResponse::clear() {
    clearSdsHandOverScreenId();
    clearDataList();
    clearSelectedDataListItems();
    clearLocationType();
    clearSdsHandOverOptionsList();
    clearSearchResults();
}

inline void GetHapticHandOverDataResponse::clearSdsHandOverScreenId() {
    if (hasSdsHandOverScreenId()) {
         clear_has_sdsHandOverScreenId();
        _sdsHandOverScreenId = ::org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_ADDRESS;
     }
}

inline bool GetHapticHandOverDataResponse::hasSdsHandOverScreenId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SDSHandOverScreenId GetHapticHandOverDataResponse::getSdsHandOverScreenId () const {
    return _sdsHandOverScreenId;
}

inline void GetHapticHandOverDataResponse::setSdsHandOverScreenId (SDSHandOverScreenId sdsHandOverScreenId_) {
    #ifndef NDEBUG
    if (!(SDSHandOverScreenId_IsValid(sdsHandOverScreenId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsHandOverScreenId_, "SDSHandOverScreenId", "sdsHandOverScreenId", "GetHapticHandOverDataResponse");
    }
    #endif
    set_has_sdsHandOverScreenId();
    this->_sdsHandOverScreenId = sdsHandOverScreenId_;
}

inline void GetHapticHandOverDataResponse::clearDataList() {
    if (hasDataList()) {
         clear_has_dataList();
        _dataList.clear();
     }
}

inline bool GetHapticHandOverDataResponse::hasDataList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< HapticData >& GetHapticHandOverDataResponse::getDataList () const {
    return _dataList;
}

inline ::std::vector< HapticData >& GetHapticHandOverDataResponse::getDataListMutable () {
    set_has_dataList();
    return _dataList;
}

inline void GetHapticHandOverDataResponse::setDataList (const ::std::vector< HapticData >& dataList_) {
    set_has_dataList();
    this->_dataList = dataList_;
}

inline void GetHapticHandOverDataResponse::clearSelectedDataListItems() {
    if (hasSelectedDataListItems()) {
         clear_has_selectedDataListItems();
        _selectedDataListItems.clear();
     }
}

inline bool GetHapticHandOverDataResponse::hasSelectedDataListItems () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< SelectedDataItem >& GetHapticHandOverDataResponse::getSelectedDataListItems () const {
    return _selectedDataListItems;
}

inline ::std::vector< SelectedDataItem >& GetHapticHandOverDataResponse::getSelectedDataListItemsMutable () {
    set_has_selectedDataListItems();
    return _selectedDataListItems;
}

inline void GetHapticHandOverDataResponse::setSelectedDataListItems (const ::std::vector< SelectedDataItem >& selectedDataListItems_) {
    set_has_selectedDataListItems();
    this->_selectedDataListItems = selectedDataListItems_;
}

inline void GetHapticHandOverDataResponse::clearLocationType() {
    if (hasLocationType()) {
         clear_has_locationType();
        _locationType = ::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT;
     }
}

inline bool GetHapticHandOverDataResponse::hasLocationType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline LocationType GetHapticHandOverDataResponse::getLocationType () const {
    return _locationType;
}

inline void GetHapticHandOverDataResponse::setLocationType (LocationType locationType_) {
    #ifndef NDEBUG
    if (!(LocationType_IsValid(locationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", locationType_, "LocationType", "locationType", "GetHapticHandOverDataResponse");
    }
    #endif
    set_has_locationType();
    this->_locationType = locationType_;
}

inline void GetHapticHandOverDataResponse::clearSdsHandOverOptionsList() {
    if (hasSdsHandOverOptionsList()) {
         clear_has_sdsHandOverOptionsList();
        _sdsHandOverOptionsList.clear();
     }
}

inline bool GetHapticHandOverDataResponse::hasSdsHandOverOptionsList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< SDSHandOverOptions >& GetHapticHandOverDataResponse::getSdsHandOverOptionsList () const {
    return _sdsHandOverOptionsList;
}

inline ::std::vector< SDSHandOverOptions >& GetHapticHandOverDataResponse::getSdsHandOverOptionsListMutable () {
    set_has_sdsHandOverOptionsList();
    return _sdsHandOverOptionsList;
}

inline void GetHapticHandOverDataResponse::setSdsHandOverOptionsList (const ::std::vector< SDSHandOverOptions >& sdsHandOverOptionsList_) {
    set_has_sdsHandOverOptionsList();
    this->_sdsHandOverOptionsList = sdsHandOverOptionsList_;
}

inline void GetHapticHandOverDataResponse::clearSearchResults() {
    if (hasSearchResults()) {
         clear_has_searchResults();
        _searchResults.clear();
     }
}

inline bool GetHapticHandOverDataResponse::hasSearchResults () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< AddressListElement >& GetHapticHandOverDataResponse::getSearchResults () const {
    return _searchResults;
}

inline ::std::vector< AddressListElement >& GetHapticHandOverDataResponse::getSearchResultsMutable () {
    set_has_searchResults();
    return _searchResults;
}

inline void GetHapticHandOverDataResponse::setSearchResults (const ::std::vector< AddressListElement >& searchResults_) {
    set_has_searchResults();
    this->_searchResults = searchResults_;
}

inline void GetHapticHandOverDataResponse::set_has_sdsHandOverScreenId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetHapticHandOverDataResponse::clear_has_sdsHandOverScreenId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetHapticHandOverDataResponse::set_has_dataList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetHapticHandOverDataResponse::clear_has_dataList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetHapticHandOverDataResponse::set_has_selectedDataListItems () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetHapticHandOverDataResponse::clear_has_selectedDataListItems () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetHapticHandOverDataResponse::set_has_locationType () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetHapticHandOverDataResponse::clear_has_locationType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetHapticHandOverDataResponse::set_has_sdsHandOverOptionsList () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetHapticHandOverDataResponse::clear_has_sdsHandOverOptionsList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void GetHapticHandOverDataResponse::set_has_searchResults () {
    _has_bits_[0] |= 1u << 5;
}

inline void GetHapticHandOverDataResponse::clear_has_searchResults () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  SelectHapticHandOverListRequest::SelectHapticHandOverListRequest ()  :
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SelectHapticHandOverListRequest::SelectHapticHandOverListRequest (const SelectHapticHandOverListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SelectHapticHandOverListRequest::SelectHapticHandOverListRequest (uint32 index_)  :
    _index (index_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SelectHapticHandOverListRequest::~SelectHapticHandOverListRequest() {
}

inline SelectHapticHandOverListRequest& SelectHapticHandOverListRequest::operator = (const SelectHapticHandOverListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
    }
    return *this;
}

inline bool SelectHapticHandOverListRequest::operator == (const SelectHapticHandOverListRequest& rhs) const {
    return (((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()));
}

inline bool SelectHapticHandOverListRequest::operator != (const SelectHapticHandOverListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SelectHapticHandOverListRequest::operator < (const SelectHapticHandOverListRequest& rhs) const {
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SelectHapticHandOverListRequest::clone() {
    return new SelectHapticHandOverListRequest(*this);
}

inline bool SelectHapticHandOverListRequest::operator > (const SelectHapticHandOverListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SelectHapticHandOverListRequest::clear() {
    clearIndex();
}

inline void SelectHapticHandOverListRequest::clearIndex() {
    if (hasIndex()) {
         clear_has_index();
        _index = 0u;
     }
}

inline bool SelectHapticHandOverListRequest::hasIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SelectHapticHandOverListRequest::getIndex () const {
    return _index;
}

inline void SelectHapticHandOverListRequest::setIndex (uint32 index_) {
    set_has_index();
    this->_index = index_;
}

inline void SelectHapticHandOverListRequest::set_has_index () {
    _has_bits_[0] |= 1u << 0;
}

inline void SelectHapticHandOverListRequest::clear_has_index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDynamicPoiIconCategoriesInMapResponse::GetDynamicPoiIconCategoriesInMapResponse ()  :
    _dynamicMapPoiCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDynamicPoiIconCategoriesInMapResponse::GetDynamicPoiIconCategoriesInMapResponse (const GetDynamicPoiIconCategoriesInMapResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _dynamicMapPoiCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDynamicPoiIconCategoriesInMapResponse::GetDynamicPoiIconCategoriesInMapResponse (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_)  :
    _dynamicMapPoiCategory (dynamicMapPoiCategory_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDynamicPoiIconCategoriesInMapResponse::~GetDynamicPoiIconCategoriesInMapResponse() {
}

inline GetDynamicPoiIconCategoriesInMapResponse& GetDynamicPoiIconCategoriesInMapResponse::operator = (const GetDynamicPoiIconCategoriesInMapResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDynamicMapPoiCategory()) {
            setDynamicMapPoiCategory(rhs.getDynamicMapPoiCategory());
        } else {
            clearDynamicMapPoiCategory();
        }
    }
    return *this;
}

inline bool GetDynamicPoiIconCategoriesInMapResponse::operator == (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const {
    return (((!hasDynamicMapPoiCategory() && !rhs.hasDynamicMapPoiCategory()) || getDynamicMapPoiCategory() == rhs.getDynamicMapPoiCategory()));
}

inline bool GetDynamicPoiIconCategoriesInMapResponse::operator != (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDynamicPoiIconCategoriesInMapResponse::operator < (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const {
    if (hasDynamicMapPoiCategory() || rhs.hasDynamicMapPoiCategory()) {
        if (getDynamicMapPoiCategory() < rhs.getDynamicMapPoiCategory()) return true;
        if (getDynamicMapPoiCategory() > rhs.getDynamicMapPoiCategory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDynamicPoiIconCategoriesInMapResponse::clone() {
    return new GetDynamicPoiIconCategoriesInMapResponse(*this);
}

inline bool GetDynamicPoiIconCategoriesInMapResponse::operator > (const GetDynamicPoiIconCategoriesInMapResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDynamicPoiIconCategoriesInMapResponse::clear() {
    clearDynamicMapPoiCategory();
}

inline void GetDynamicPoiIconCategoriesInMapResponse::clearDynamicMapPoiCategory() {
    if (hasDynamicMapPoiCategory()) {
         clear_has_dynamicMapPoiCategory();
        _dynamicMapPoiCategory.clear();
     }
}

inline bool GetDynamicPoiIconCategoriesInMapResponse::hasDynamicMapPoiCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< DynamicMapPoiCategory >& GetDynamicPoiIconCategoriesInMapResponse::getDynamicMapPoiCategory () const {
    return _dynamicMapPoiCategory;
}

inline ::std::vector< DynamicMapPoiCategory >& GetDynamicPoiIconCategoriesInMapResponse::getDynamicMapPoiCategoryMutable () {
    set_has_dynamicMapPoiCategory();
    return _dynamicMapPoiCategory;
}

inline void GetDynamicPoiIconCategoriesInMapResponse::setDynamicMapPoiCategory (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_) {
    set_has_dynamicMapPoiCategory();
    this->_dynamicMapPoiCategory = dynamicMapPoiCategory_;
}

inline void GetDynamicPoiIconCategoriesInMapResponse::set_has_dynamicMapPoiCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDynamicPoiIconCategoriesInMapResponse::clear_has_dynamicMapPoiCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetMaxWaypointCountResponse::GetMaxWaypointCountResponse ()  :
    _maxWayPointCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetMaxWaypointCountResponse::GetMaxWaypointCountResponse (const GetMaxWaypointCountResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _maxWayPointCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetMaxWaypointCountResponse::GetMaxWaypointCountResponse (uint32 maxWayPointCount_)  :
    _maxWayPointCount (maxWayPointCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetMaxWaypointCountResponse::~GetMaxWaypointCountResponse() {
}

inline GetMaxWaypointCountResponse& GetMaxWaypointCountResponse::operator = (const GetMaxWaypointCountResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMaxWayPointCount()) {
            setMaxWayPointCount(rhs.getMaxWayPointCount());
        } else {
            clearMaxWayPointCount();
        }
    }
    return *this;
}

inline bool GetMaxWaypointCountResponse::operator == (const GetMaxWaypointCountResponse& rhs) const {
    return (((!hasMaxWayPointCount() && !rhs.hasMaxWayPointCount()) || getMaxWayPointCount() == rhs.getMaxWayPointCount()));
}

inline bool GetMaxWaypointCountResponse::operator != (const GetMaxWaypointCountResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetMaxWaypointCountResponse::operator < (const GetMaxWaypointCountResponse& rhs) const {
    if (hasMaxWayPointCount() || rhs.hasMaxWayPointCount()) {
        if (getMaxWayPointCount() < rhs.getMaxWayPointCount()) return true;
        if (getMaxWayPointCount() > rhs.getMaxWayPointCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetMaxWaypointCountResponse::clone() {
    return new GetMaxWaypointCountResponse(*this);
}

inline bool GetMaxWaypointCountResponse::operator > (const GetMaxWaypointCountResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetMaxWaypointCountResponse::clear() {
    clearMaxWayPointCount();
}

inline void GetMaxWaypointCountResponse::clearMaxWayPointCount() {
    if (hasMaxWayPointCount()) {
         clear_has_maxWayPointCount();
        _maxWayPointCount = 0u;
     }
}

inline bool GetMaxWaypointCountResponse::hasMaxWayPointCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetMaxWaypointCountResponse::getMaxWayPointCount () const {
    return _maxWayPointCount;
}

inline void GetMaxWaypointCountResponse::setMaxWayPointCount (uint32 maxWayPointCount_) {
    set_has_maxWayPointCount();
    this->_maxWayPointCount = maxWayPointCount_;
}

inline void GetMaxWaypointCountResponse::set_has_maxWayPointCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetMaxWaypointCountResponse::clear_has_maxWayPointCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDynamicPoiIconCategoriesInMapRequest::SetDynamicPoiIconCategoriesInMapRequest ()  :
    _dynamicMapPoiCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDynamicPoiIconCategoriesInMapRequest::SetDynamicPoiIconCategoriesInMapRequest (const SetDynamicPoiIconCategoriesInMapRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _dynamicMapPoiCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDynamicPoiIconCategoriesInMapRequest::SetDynamicPoiIconCategoriesInMapRequest (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_)  :
    _dynamicMapPoiCategory (dynamicMapPoiCategory_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDynamicPoiIconCategoriesInMapRequest::~SetDynamicPoiIconCategoriesInMapRequest() {
}

inline SetDynamicPoiIconCategoriesInMapRequest& SetDynamicPoiIconCategoriesInMapRequest::operator = (const SetDynamicPoiIconCategoriesInMapRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDynamicMapPoiCategory()) {
            setDynamicMapPoiCategory(rhs.getDynamicMapPoiCategory());
        } else {
            clearDynamicMapPoiCategory();
        }
    }
    return *this;
}

inline bool SetDynamicPoiIconCategoriesInMapRequest::operator == (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const {
    return (((!hasDynamicMapPoiCategory() && !rhs.hasDynamicMapPoiCategory()) || getDynamicMapPoiCategory() == rhs.getDynamicMapPoiCategory()));
}

inline bool SetDynamicPoiIconCategoriesInMapRequest::operator != (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDynamicPoiIconCategoriesInMapRequest::operator < (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const {
    if (hasDynamicMapPoiCategory() || rhs.hasDynamicMapPoiCategory()) {
        if (getDynamicMapPoiCategory() < rhs.getDynamicMapPoiCategory()) return true;
        if (getDynamicMapPoiCategory() > rhs.getDynamicMapPoiCategory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDynamicPoiIconCategoriesInMapRequest::clone() {
    return new SetDynamicPoiIconCategoriesInMapRequest(*this);
}

inline bool SetDynamicPoiIconCategoriesInMapRequest::operator > (const SetDynamicPoiIconCategoriesInMapRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDynamicPoiIconCategoriesInMapRequest::clear() {
    clearDynamicMapPoiCategory();
}

inline void SetDynamicPoiIconCategoriesInMapRequest::clearDynamicMapPoiCategory() {
    if (hasDynamicMapPoiCategory()) {
         clear_has_dynamicMapPoiCategory();
        _dynamicMapPoiCategory.clear();
     }
}

inline bool SetDynamicPoiIconCategoriesInMapRequest::hasDynamicMapPoiCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< DynamicMapPoiCategory >& SetDynamicPoiIconCategoriesInMapRequest::getDynamicMapPoiCategory () const {
    return _dynamicMapPoiCategory;
}

inline ::std::vector< DynamicMapPoiCategory >& SetDynamicPoiIconCategoriesInMapRequest::getDynamicMapPoiCategoryMutable () {
    set_has_dynamicMapPoiCategory();
    return _dynamicMapPoiCategory;
}

inline void SetDynamicPoiIconCategoriesInMapRequest::setDynamicMapPoiCategory (const ::std::vector< DynamicMapPoiCategory >& dynamicMapPoiCategory_) {
    set_has_dynamicMapPoiCategory();
    this->_dynamicMapPoiCategory = dynamicMapPoiCategory_;
}

inline void SetDynamicPoiIconCategoriesInMapRequest::set_has_dynamicMapPoiCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDynamicPoiIconCategoriesInMapRequest::clear_has_dynamicMapPoiCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsCheckAddressRequest::SdsCheckAddressRequest ()  :
    _requestedAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsCheckAddressRequest::SdsCheckAddressRequest (const SdsCheckAddressRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _requestedAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsCheckAddressRequest::SdsCheckAddressRequest (const ::std::vector< SDSAddressElement >& requestedAddress_)  :
    _requestedAddress (requestedAddress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsCheckAddressRequest::~SdsCheckAddressRequest() {
}

inline SdsCheckAddressRequest& SdsCheckAddressRequest::operator = (const SdsCheckAddressRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestedAddress()) {
            setRequestedAddress(rhs.getRequestedAddress());
        } else {
            clearRequestedAddress();
        }
    }
    return *this;
}

inline bool SdsCheckAddressRequest::operator == (const SdsCheckAddressRequest& rhs) const {
    return (((!hasRequestedAddress() && !rhs.hasRequestedAddress()) || getRequestedAddress() == rhs.getRequestedAddress()));
}

inline bool SdsCheckAddressRequest::operator != (const SdsCheckAddressRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsCheckAddressRequest::operator < (const SdsCheckAddressRequest& rhs) const {
    if (hasRequestedAddress() || rhs.hasRequestedAddress()) {
        if (getRequestedAddress() < rhs.getRequestedAddress()) return true;
        if (getRequestedAddress() > rhs.getRequestedAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsCheckAddressRequest::clone() {
    return new SdsCheckAddressRequest(*this);
}

inline bool SdsCheckAddressRequest::operator > (const SdsCheckAddressRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsCheckAddressRequest::clear() {
    clearRequestedAddress();
}

inline void SdsCheckAddressRequest::clearRequestedAddress() {
    if (hasRequestedAddress()) {
         clear_has_requestedAddress();
        _requestedAddress.clear();
     }
}

inline bool SdsCheckAddressRequest::hasRequestedAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SDSAddressElement >& SdsCheckAddressRequest::getRequestedAddress () const {
    return _requestedAddress;
}

inline ::std::vector< SDSAddressElement >& SdsCheckAddressRequest::getRequestedAddressMutable () {
    set_has_requestedAddress();
    return _requestedAddress;
}

inline void SdsCheckAddressRequest::setRequestedAddress (const ::std::vector< SDSAddressElement >& requestedAddress_) {
    set_has_requestedAddress();
    this->_requestedAddress = requestedAddress_;
}

inline void SdsCheckAddressRequest::set_has_requestedAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsCheckAddressRequest::clear_has_requestedAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsGetRefinementListResponse::SdsGetRefinementListResponse ()  :
    _refinements ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsGetRefinementListResponse::SdsGetRefinementListResponse (const SdsGetRefinementListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _refinements ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsGetRefinementListResponse::SdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements_)  :
    _refinements (refinements_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsGetRefinementListResponse::~SdsGetRefinementListResponse() {
}

inline SdsGetRefinementListResponse& SdsGetRefinementListResponse::operator = (const SdsGetRefinementListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRefinements()) {
            setRefinements(rhs.getRefinements());
        } else {
            clearRefinements();
        }
    }
    return *this;
}

inline bool SdsGetRefinementListResponse::operator == (const SdsGetRefinementListResponse& rhs) const {
    return (((!hasRefinements() && !rhs.hasRefinements()) || getRefinements() == rhs.getRefinements()));
}

inline bool SdsGetRefinementListResponse::operator != (const SdsGetRefinementListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsGetRefinementListResponse::operator < (const SdsGetRefinementListResponse& rhs) const {
    if (hasRefinements() || rhs.hasRefinements()) {
        if (getRefinements() < rhs.getRefinements()) return true;
        if (getRefinements() > rhs.getRefinements()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsGetRefinementListResponse::clone() {
    return new SdsGetRefinementListResponse(*this);
}

inline bool SdsGetRefinementListResponse::operator > (const SdsGetRefinementListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsGetRefinementListResponse::clear() {
    clearRefinements();
}

inline void SdsGetRefinementListResponse::clearRefinements() {
    if (hasRefinements()) {
         clear_has_refinements();
        _refinements.clear();
     }
}

inline bool SdsGetRefinementListResponse::hasRefinements () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< RefinementListElement >& SdsGetRefinementListResponse::getRefinements () const {
    return _refinements;
}

inline ::std::vector< RefinementListElement >& SdsGetRefinementListResponse::getRefinementsMutable () {
    set_has_refinements();
    return _refinements;
}

inline void SdsGetRefinementListResponse::setRefinements (const ::std::vector< RefinementListElement >& refinements_) {
    set_has_refinements();
    this->_refinements = refinements_;
}

inline void SdsGetRefinementListResponse::set_has_refinements () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsGetRefinementListResponse::clear_has_refinements () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsUpdateVoiceTagRequest::SdsUpdateVoiceTagRequest ()  :
    _voiceTagID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsUpdateVoiceTagRequest::SdsUpdateVoiceTagRequest (const SdsUpdateVoiceTagRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _voiceTagID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsUpdateVoiceTagRequest::SdsUpdateVoiceTagRequest (const SDSVoiceTagId& voiceTagID_)  :
    _voiceTagID (voiceTagID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsUpdateVoiceTagRequest::~SdsUpdateVoiceTagRequest() {
}

inline SdsUpdateVoiceTagRequest& SdsUpdateVoiceTagRequest::operator = (const SdsUpdateVoiceTagRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceTagID()) {
            setVoiceTagID(rhs.getVoiceTagID());
        } else {
            clearVoiceTagID();
        }
    }
    return *this;
}

inline bool SdsUpdateVoiceTagRequest::operator == (const SdsUpdateVoiceTagRequest& rhs) const {
    return (((!hasVoiceTagID() && !rhs.hasVoiceTagID()) || getVoiceTagID() == rhs.getVoiceTagID()));
}

inline bool SdsUpdateVoiceTagRequest::operator != (const SdsUpdateVoiceTagRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsUpdateVoiceTagRequest::operator < (const SdsUpdateVoiceTagRequest& rhs) const {
    if (hasVoiceTagID() || rhs.hasVoiceTagID()) {
        if (getVoiceTagID() < rhs.getVoiceTagID()) return true;
        if (getVoiceTagID() > rhs.getVoiceTagID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsUpdateVoiceTagRequest::clone() {
    return new SdsUpdateVoiceTagRequest(*this);
}

inline bool SdsUpdateVoiceTagRequest::operator > (const SdsUpdateVoiceTagRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsUpdateVoiceTagRequest::clear() {
    clearVoiceTagID();
}

inline void SdsUpdateVoiceTagRequest::clearVoiceTagID() {
    if (hasVoiceTagID()) {
         clear_has_voiceTagID();
        _voiceTagID.clear();
     }
}

inline bool SdsUpdateVoiceTagRequest::hasVoiceTagID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SDSVoiceTagId& SdsUpdateVoiceTagRequest::getVoiceTagID () const {
    return _voiceTagID;
}

inline SDSVoiceTagId& SdsUpdateVoiceTagRequest::getVoiceTagIDMutable () {
    set_has_voiceTagID();
    return _voiceTagID;
}

inline void SdsUpdateVoiceTagRequest::setVoiceTagID (const SDSVoiceTagId& voiceTagID_) {
    set_has_voiceTagID();
    this->_voiceTagID = voiceTagID_;
}

inline void SdsUpdateVoiceTagRequest::set_has_voiceTagID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsUpdateVoiceTagRequest::clear_has_voiceTagID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsGetHouseNumberPatternResponse::SdsGetHouseNumberPatternResponse ()  :
    _minHouseNumber (),
    _maxHouseNumber (),
    _patterns ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsGetHouseNumberPatternResponse::SdsGetHouseNumberPatternResponse (const SdsGetHouseNumberPatternResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _minHouseNumber (),
    _maxHouseNumber (),
    _patterns ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsGetHouseNumberPatternResponse::SdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber_, const ::std::string& maxHouseNumber_, const ::std::vector< ::std::string >& patterns_)  :
    _minHouseNumber (minHouseNumber_),
    _maxHouseNumber (maxHouseNumber_),
    _patterns (patterns_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (minHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (maxHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsGetHouseNumberPatternResponse::~SdsGetHouseNumberPatternResponse() {
}

inline SdsGetHouseNumberPatternResponse& SdsGetHouseNumberPatternResponse::operator = (const SdsGetHouseNumberPatternResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMinHouseNumber()) {
            setMinHouseNumber(rhs.getMinHouseNumber());
        } else {
            clearMinHouseNumber();
        }
        if (rhs.hasMaxHouseNumber()) {
            setMaxHouseNumber(rhs.getMaxHouseNumber());
        } else {
            clearMaxHouseNumber();
        }
        if (rhs.hasPatterns()) {
            setPatterns(rhs.getPatterns());
        } else {
            clearPatterns();
        }
    }
    return *this;
}

inline bool SdsGetHouseNumberPatternResponse::operator == (const SdsGetHouseNumberPatternResponse& rhs) const {
    return (((!hasMinHouseNumber() && !rhs.hasMinHouseNumber()) || getMinHouseNumber() == rhs.getMinHouseNumber()) &&
        ((!hasMaxHouseNumber() && !rhs.hasMaxHouseNumber()) || getMaxHouseNumber() == rhs.getMaxHouseNumber()) &&
        ((!hasPatterns() && !rhs.hasPatterns()) || getPatterns() == rhs.getPatterns()));
}

inline bool SdsGetHouseNumberPatternResponse::operator != (const SdsGetHouseNumberPatternResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsGetHouseNumberPatternResponse::operator < (const SdsGetHouseNumberPatternResponse& rhs) const {
    if (hasMinHouseNumber() || rhs.hasMinHouseNumber()) {
        if (getMinHouseNumber() < rhs.getMinHouseNumber()) return true;
        if (getMinHouseNumber() > rhs.getMinHouseNumber()) return false;
    }
    if (hasMaxHouseNumber() || rhs.hasMaxHouseNumber()) {
        if (getMaxHouseNumber() < rhs.getMaxHouseNumber()) return true;
        if (getMaxHouseNumber() > rhs.getMaxHouseNumber()) return false;
    }
    if (hasPatterns() || rhs.hasPatterns()) {
        if (getPatterns() < rhs.getPatterns()) return true;
        if (getPatterns() > rhs.getPatterns()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsGetHouseNumberPatternResponse::clone() {
    return new SdsGetHouseNumberPatternResponse(*this);
}

inline bool SdsGetHouseNumberPatternResponse::operator > (const SdsGetHouseNumberPatternResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsGetHouseNumberPatternResponse::clear() {
    clearMinHouseNumber();
    clearMaxHouseNumber();
    clearPatterns();
}

inline void SdsGetHouseNumberPatternResponse::clearMinHouseNumber() {
    if (hasMinHouseNumber()) {
         clear_has_minHouseNumber();
        _minHouseNumber.clear();
     }
}

inline bool SdsGetHouseNumberPatternResponse::hasMinHouseNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SdsGetHouseNumberPatternResponse::getMinHouseNumber () const {
    return _minHouseNumber;
}

inline ::std::string& SdsGetHouseNumberPatternResponse::getMinHouseNumberMutable () {
    set_has_minHouseNumber();
    return _minHouseNumber;
}

inline void SdsGetHouseNumberPatternResponse::setMinHouseNumber (const ::std::string& minHouseNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (minHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_minHouseNumber();
    this->_minHouseNumber = minHouseNumber_;
}

inline void SdsGetHouseNumberPatternResponse::setMinHouseNumber (const char* minHouseNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (minHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_minHouseNumber();
    this->_minHouseNumber.assign(minHouseNumber_);
}

inline void SdsGetHouseNumberPatternResponse::setMinHouseNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_minHouseNumber();
    this->_minHouseNumber.assign(value, size);
}

inline void SdsGetHouseNumberPatternResponse::clearMaxHouseNumber() {
    if (hasMaxHouseNumber()) {
         clear_has_maxHouseNumber();
        _maxHouseNumber.clear();
     }
}

inline bool SdsGetHouseNumberPatternResponse::hasMaxHouseNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SdsGetHouseNumberPatternResponse::getMaxHouseNumber () const {
    return _maxHouseNumber;
}

inline ::std::string& SdsGetHouseNumberPatternResponse::getMaxHouseNumberMutable () {
    set_has_maxHouseNumber();
    return _maxHouseNumber;
}

inline void SdsGetHouseNumberPatternResponse::setMaxHouseNumber (const ::std::string& maxHouseNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (maxHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_maxHouseNumber();
    this->_maxHouseNumber = maxHouseNumber_;
}

inline void SdsGetHouseNumberPatternResponse::setMaxHouseNumber (const char* maxHouseNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (maxHouseNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_maxHouseNumber();
    this->_maxHouseNumber.assign(maxHouseNumber_);
}

inline void SdsGetHouseNumberPatternResponse::setMaxHouseNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_maxHouseNumber();
    this->_maxHouseNumber.assign(value, size);
}

inline void SdsGetHouseNumberPatternResponse::clearPatterns() {
    if (hasPatterns()) {
         clear_has_patterns();
        _patterns.clear();
     }
}

inline bool SdsGetHouseNumberPatternResponse::hasPatterns () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& SdsGetHouseNumberPatternResponse::getPatterns () const {
    return _patterns;
}

inline ::std::vector< ::std::string >& SdsGetHouseNumberPatternResponse::getPatternsMutable () {
    set_has_patterns();
    return _patterns;
}

inline void SdsGetHouseNumberPatternResponse::setPatterns (const ::std::vector< ::std::string >& patterns_) {
    set_has_patterns();
    this->_patterns = patterns_;
}

inline void SdsGetHouseNumberPatternResponse::set_has_minHouseNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsGetHouseNumberPatternResponse::clear_has_minHouseNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsGetHouseNumberPatternResponse::set_has_maxHouseNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsGetHouseNumberPatternResponse::clear_has_maxHouseNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SdsGetHouseNumberPatternResponse::set_has_patterns () {
    _has_bits_[0] |= 1u << 2;
}

inline void SdsGetHouseNumberPatternResponse::clear_has_patterns () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SelectSdsRefinementRequest::SelectSdsRefinementRequest ()  :
    _id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SelectSdsRefinementRequest::SelectSdsRefinementRequest (const SelectSdsRefinementRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SelectSdsRefinementRequest::SelectSdsRefinementRequest (uint32 id_)  :
    _id (id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SelectSdsRefinementRequest::~SelectSdsRefinementRequest() {
}

inline SelectSdsRefinementRequest& SelectSdsRefinementRequest::operator = (const SelectSdsRefinementRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
    }
    return *this;
}

inline bool SelectSdsRefinementRequest::operator == (const SelectSdsRefinementRequest& rhs) const {
    return (((!hasId() && !rhs.hasId()) || getId() == rhs.getId()));
}

inline bool SelectSdsRefinementRequest::operator != (const SelectSdsRefinementRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SelectSdsRefinementRequest::operator < (const SelectSdsRefinementRequest& rhs) const {
    if (hasId() || rhs.hasId()) {
        if (getId() < rhs.getId()) return true;
        if (getId() > rhs.getId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SelectSdsRefinementRequest::clone() {
    return new SelectSdsRefinementRequest(*this);
}

inline bool SelectSdsRefinementRequest::operator > (const SelectSdsRefinementRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SelectSdsRefinementRequest::clear() {
    clearId();
}

inline void SelectSdsRefinementRequest::clearId() {
    if (hasId()) {
         clear_has_id();
        _id = 0u;
     }
}

inline bool SelectSdsRefinementRequest::hasId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SelectSdsRefinementRequest::getId () const {
    return _id;
}

inline void SelectSdsRefinementRequest::setId (uint32 id_) {
    set_has_id();
    this->_id = id_;
}

inline void SelectSdsRefinementRequest::set_has_id () {
    _has_bits_[0] |= 1u << 0;
}

inline void SelectSdsRefinementRequest::clear_has_id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestAddressFormatForAvailableCountriesResponse::RequestAddressFormatForAvailableCountriesResponse ()  :
    _addressFormatInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestAddressFormatForAvailableCountriesResponse::RequestAddressFormatForAvailableCountriesResponse (const RequestAddressFormatForAvailableCountriesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _addressFormatInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestAddressFormatForAvailableCountriesResponse::RequestAddressFormatForAvailableCountriesResponse (const ::std::vector< AddressFormatInfo >& addressFormatInfos_)  :
    _addressFormatInfos (addressFormatInfos_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestAddressFormatForAvailableCountriesResponse::~RequestAddressFormatForAvailableCountriesResponse() {
}

inline RequestAddressFormatForAvailableCountriesResponse& RequestAddressFormatForAvailableCountriesResponse::operator = (const RequestAddressFormatForAvailableCountriesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddressFormatInfos()) {
            setAddressFormatInfos(rhs.getAddressFormatInfos());
        } else {
            clearAddressFormatInfos();
        }
    }
    return *this;
}

inline bool RequestAddressFormatForAvailableCountriesResponse::operator == (const RequestAddressFormatForAvailableCountriesResponse& rhs) const {
    return (((!hasAddressFormatInfos() && !rhs.hasAddressFormatInfos()) || getAddressFormatInfos() == rhs.getAddressFormatInfos()));
}

inline bool RequestAddressFormatForAvailableCountriesResponse::operator != (const RequestAddressFormatForAvailableCountriesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestAddressFormatForAvailableCountriesResponse::operator < (const RequestAddressFormatForAvailableCountriesResponse& rhs) const {
    if (hasAddressFormatInfos() || rhs.hasAddressFormatInfos()) {
        if (getAddressFormatInfos() < rhs.getAddressFormatInfos()) return true;
        if (getAddressFormatInfos() > rhs.getAddressFormatInfos()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestAddressFormatForAvailableCountriesResponse::clone() {
    return new RequestAddressFormatForAvailableCountriesResponse(*this);
}

inline bool RequestAddressFormatForAvailableCountriesResponse::operator > (const RequestAddressFormatForAvailableCountriesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestAddressFormatForAvailableCountriesResponse::clear() {
    clearAddressFormatInfos();
}

inline void RequestAddressFormatForAvailableCountriesResponse::clearAddressFormatInfos() {
    if (hasAddressFormatInfos()) {
         clear_has_addressFormatInfos();
        _addressFormatInfos.clear();
     }
}

inline bool RequestAddressFormatForAvailableCountriesResponse::hasAddressFormatInfos () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< AddressFormatInfo >& RequestAddressFormatForAvailableCountriesResponse::getAddressFormatInfos () const {
    return _addressFormatInfos;
}

inline ::std::vector< AddressFormatInfo >& RequestAddressFormatForAvailableCountriesResponse::getAddressFormatInfosMutable () {
    set_has_addressFormatInfos();
    return _addressFormatInfos;
}

inline void RequestAddressFormatForAvailableCountriesResponse::setAddressFormatInfos (const ::std::vector< AddressFormatInfo >& addressFormatInfos_) {
    set_has_addressFormatInfos();
    this->_addressFormatInfos = addressFormatInfos_;
}

inline void RequestAddressFormatForAvailableCountriesResponse::set_has_addressFormatInfos () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestAddressFormatForAvailableCountriesResponse::clear_has_addressFormatInfos () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsShowReachableAreaMapRequest::SdsShowReachableAreaMapRequest ()  :
    _locationType (::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsShowReachableAreaMapRequest::SdsShowReachableAreaMapRequest (const SdsShowReachableAreaMapRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _locationType (::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsShowReachableAreaMapRequest::SdsShowReachableAreaMapRequest (LocationType locationType_)  :
    _locationType (locationType_)
{
    #ifndef NDEBUG
    if (!(LocationType_IsValid(locationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", locationType_, "LocationType", "locationType", "SdsShowReachableAreaMapRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsShowReachableAreaMapRequest::~SdsShowReachableAreaMapRequest() {
}

inline SdsShowReachableAreaMapRequest& SdsShowReachableAreaMapRequest::operator = (const SdsShowReachableAreaMapRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLocationType()) {
            setLocationType(rhs.getLocationType());
        } else {
            clearLocationType();
        }
    }
    return *this;
}

inline bool SdsShowReachableAreaMapRequest::operator == (const SdsShowReachableAreaMapRequest& rhs) const {
    return (((!hasLocationType() && !rhs.hasLocationType()) || getLocationType() == rhs.getLocationType()));
}

inline bool SdsShowReachableAreaMapRequest::operator != (const SdsShowReachableAreaMapRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsShowReachableAreaMapRequest::operator < (const SdsShowReachableAreaMapRequest& rhs) const {
    if (hasLocationType() || rhs.hasLocationType()) {
        if ((uint32)getLocationType() < (uint32)rhs.getLocationType()) return true;
        if ((uint32)getLocationType() > (uint32)rhs.getLocationType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsShowReachableAreaMapRequest::clone() {
    return new SdsShowReachableAreaMapRequest(*this);
}

inline bool SdsShowReachableAreaMapRequest::operator > (const SdsShowReachableAreaMapRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsShowReachableAreaMapRequest::clear() {
    clearLocationType();
}

inline void SdsShowReachableAreaMapRequest::clearLocationType() {
    if (hasLocationType()) {
         clear_has_locationType();
        _locationType = ::org::bosch::cm::navigation::NavigationSDSService::LocationType__DEFAULT;
     }
}

inline bool SdsShowReachableAreaMapRequest::hasLocationType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline LocationType SdsShowReachableAreaMapRequest::getLocationType () const {
    return _locationType;
}

inline void SdsShowReachableAreaMapRequest::setLocationType (LocationType locationType_) {
    #ifndef NDEBUG
    if (!(LocationType_IsValid(locationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", locationType_, "LocationType", "locationType", "SdsShowReachableAreaMapRequest");
    }
    #endif
    set_has_locationType();
    this->_locationType = locationType_;
}

inline void SdsShowReachableAreaMapRequest::set_has_locationType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsShowReachableAreaMapRequest::clear_has_locationType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsDatasetUserRegistrationRequest::SdsDatasetUserRegistrationRequest ()  :
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsDatasetUserRegistrationRequest::SdsDatasetUserRegistrationRequest (const SdsDatasetUserRegistrationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsDatasetUserRegistrationRequest::SdsDatasetUserRegistrationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_)  :
    _ndsDataSetUser (ndsDataSetUser_),
    _datasetId (datasetId_)
{
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "SdsDatasetUserRegistrationRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsDatasetUserRegistrationRequest::~SdsDatasetUserRegistrationRequest() {
}

inline SdsDatasetUserRegistrationRequest& SdsDatasetUserRegistrationRequest::operator = (const SdsDatasetUserRegistrationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNdsDataSetUser()) {
            setNdsDataSetUser(rhs.getNdsDataSetUser());
        } else {
            clearNdsDataSetUser();
        }
        if (rhs.hasDatasetId()) {
            setDatasetId(rhs.getDatasetId());
        } else {
            clearDatasetId();
        }
    }
    return *this;
}

inline bool SdsDatasetUserRegistrationRequest::operator == (const SdsDatasetUserRegistrationRequest& rhs) const {
    return (((!hasNdsDataSetUser() && !rhs.hasNdsDataSetUser()) || getNdsDataSetUser() == rhs.getNdsDataSetUser()) &&
        ((!hasDatasetId() && !rhs.hasDatasetId()) || getDatasetId() == rhs.getDatasetId()));
}

inline bool SdsDatasetUserRegistrationRequest::operator != (const SdsDatasetUserRegistrationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsDatasetUserRegistrationRequest::operator < (const SdsDatasetUserRegistrationRequest& rhs) const {
    if (hasNdsDataSetUser() || rhs.hasNdsDataSetUser()) {
        if ((uint32)getNdsDataSetUser() < (uint32)rhs.getNdsDataSetUser()) return true;
        if ((uint32)getNdsDataSetUser() > (uint32)rhs.getNdsDataSetUser()) return false;
    }
    if (hasDatasetId() || rhs.hasDatasetId()) {
        if (getDatasetId() < rhs.getDatasetId()) return true;
        if (getDatasetId() > rhs.getDatasetId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsDatasetUserRegistrationRequest::clone() {
    return new SdsDatasetUserRegistrationRequest(*this);
}

inline bool SdsDatasetUserRegistrationRequest::operator > (const SdsDatasetUserRegistrationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsDatasetUserRegistrationRequest::clear() {
    clearNdsDataSetUser();
    clearDatasetId();
}

inline void SdsDatasetUserRegistrationRequest::clearNdsDataSetUser() {
    if (hasNdsDataSetUser()) {
         clear_has_ndsDataSetUser();
        _ndsDataSetUser = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
     }
}

inline bool SdsDatasetUserRegistrationRequest::hasNdsDataSetUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NdsDatasetUser SdsDatasetUserRegistrationRequest::getNdsDataSetUser () const {
    return _ndsDataSetUser;
}

inline void SdsDatasetUserRegistrationRequest::setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_) {
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "SdsDatasetUserRegistrationRequest");
    }
    #endif
    set_has_ndsDataSetUser();
    this->_ndsDataSetUser = ndsDataSetUser_;
}

inline void SdsDatasetUserRegistrationRequest::clearDatasetId() {
    if (hasDatasetId()) {
         clear_has_datasetId();
        _datasetId = 0u;
     }
}

inline bool SdsDatasetUserRegistrationRequest::hasDatasetId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SdsDatasetUserRegistrationRequest::getDatasetId () const {
    return _datasetId;
}

inline void SdsDatasetUserRegistrationRequest::setDatasetId (uint32 datasetId_) {
    set_has_datasetId();
    this->_datasetId = datasetId_;
}

inline void SdsDatasetUserRegistrationRequest::set_has_ndsDataSetUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsDatasetUserRegistrationRequest::clear_has_ndsDataSetUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsDatasetUserRegistrationRequest::set_has_datasetId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsDatasetUserRegistrationRequest::clear_has_datasetId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SdsDatasetUserRegistrationResponse::SdsDatasetUserRegistrationResponse ()  :
    _registrationStatus (::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsDatasetUserRegistrationResponse::SdsDatasetUserRegistrationResponse (const SdsDatasetUserRegistrationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _registrationStatus (::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsDatasetUserRegistrationResponse::SdsDatasetUserRegistrationResponse (RegistrationAndDeRegistrationStatus registrationStatus_)  :
    _registrationStatus (registrationStatus_)
{
    #ifndef NDEBUG
    if (!(RegistrationAndDeRegistrationStatus_IsValid(registrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", registrationStatus_, "RegistrationAndDeRegistrationStatus", "registrationStatus", "SdsDatasetUserRegistrationResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsDatasetUserRegistrationResponse::~SdsDatasetUserRegistrationResponse() {
}

inline SdsDatasetUserRegistrationResponse& SdsDatasetUserRegistrationResponse::operator = (const SdsDatasetUserRegistrationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegistrationStatus()) {
            setRegistrationStatus(rhs.getRegistrationStatus());
        } else {
            clearRegistrationStatus();
        }
    }
    return *this;
}

inline bool SdsDatasetUserRegistrationResponse::operator == (const SdsDatasetUserRegistrationResponse& rhs) const {
    return (((!hasRegistrationStatus() && !rhs.hasRegistrationStatus()) || getRegistrationStatus() == rhs.getRegistrationStatus()));
}

inline bool SdsDatasetUserRegistrationResponse::operator != (const SdsDatasetUserRegistrationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsDatasetUserRegistrationResponse::operator < (const SdsDatasetUserRegistrationResponse& rhs) const {
    if (hasRegistrationStatus() || rhs.hasRegistrationStatus()) {
        if ((uint32)getRegistrationStatus() < (uint32)rhs.getRegistrationStatus()) return true;
        if ((uint32)getRegistrationStatus() > (uint32)rhs.getRegistrationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsDatasetUserRegistrationResponse::clone() {
    return new SdsDatasetUserRegistrationResponse(*this);
}

inline bool SdsDatasetUserRegistrationResponse::operator > (const SdsDatasetUserRegistrationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsDatasetUserRegistrationResponse::clear() {
    clearRegistrationStatus();
}

inline void SdsDatasetUserRegistrationResponse::clearRegistrationStatus() {
    if (hasRegistrationStatus()) {
         clear_has_registrationStatus();
        _registrationStatus = ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK;
     }
}

inline bool SdsDatasetUserRegistrationResponse::hasRegistrationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline RegistrationAndDeRegistrationStatus SdsDatasetUserRegistrationResponse::getRegistrationStatus () const {
    return _registrationStatus;
}

inline void SdsDatasetUserRegistrationResponse::setRegistrationStatus (RegistrationAndDeRegistrationStatus registrationStatus_) {
    #ifndef NDEBUG
    if (!(RegistrationAndDeRegistrationStatus_IsValid(registrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", registrationStatus_, "RegistrationAndDeRegistrationStatus", "registrationStatus", "SdsDatasetUserRegistrationResponse");
    }
    #endif
    set_has_registrationStatus();
    this->_registrationStatus = registrationStatus_;
}

inline void SdsDatasetUserRegistrationResponse::set_has_registrationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsDatasetUserRegistrationResponse::clear_has_registrationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsDatasetUserDeregistrationRequest::SdsDatasetUserDeregistrationRequest ()  :
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsDatasetUserDeregistrationRequest::SdsDatasetUserDeregistrationRequest (const SdsDatasetUserDeregistrationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsDatasetUserDeregistrationRequest::SdsDatasetUserDeregistrationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_)  :
    _ndsDataSetUser (ndsDataSetUser_),
    _datasetId (datasetId_)
{
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "SdsDatasetUserDeregistrationRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsDatasetUserDeregistrationRequest::~SdsDatasetUserDeregistrationRequest() {
}

inline SdsDatasetUserDeregistrationRequest& SdsDatasetUserDeregistrationRequest::operator = (const SdsDatasetUserDeregistrationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNdsDataSetUser()) {
            setNdsDataSetUser(rhs.getNdsDataSetUser());
        } else {
            clearNdsDataSetUser();
        }
        if (rhs.hasDatasetId()) {
            setDatasetId(rhs.getDatasetId());
        } else {
            clearDatasetId();
        }
    }
    return *this;
}

inline bool SdsDatasetUserDeregistrationRequest::operator == (const SdsDatasetUserDeregistrationRequest& rhs) const {
    return (((!hasNdsDataSetUser() && !rhs.hasNdsDataSetUser()) || getNdsDataSetUser() == rhs.getNdsDataSetUser()) &&
        ((!hasDatasetId() && !rhs.hasDatasetId()) || getDatasetId() == rhs.getDatasetId()));
}

inline bool SdsDatasetUserDeregistrationRequest::operator != (const SdsDatasetUserDeregistrationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsDatasetUserDeregistrationRequest::operator < (const SdsDatasetUserDeregistrationRequest& rhs) const {
    if (hasNdsDataSetUser() || rhs.hasNdsDataSetUser()) {
        if ((uint32)getNdsDataSetUser() < (uint32)rhs.getNdsDataSetUser()) return true;
        if ((uint32)getNdsDataSetUser() > (uint32)rhs.getNdsDataSetUser()) return false;
    }
    if (hasDatasetId() || rhs.hasDatasetId()) {
        if (getDatasetId() < rhs.getDatasetId()) return true;
        if (getDatasetId() > rhs.getDatasetId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsDatasetUserDeregistrationRequest::clone() {
    return new SdsDatasetUserDeregistrationRequest(*this);
}

inline bool SdsDatasetUserDeregistrationRequest::operator > (const SdsDatasetUserDeregistrationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsDatasetUserDeregistrationRequest::clear() {
    clearNdsDataSetUser();
    clearDatasetId();
}

inline void SdsDatasetUserDeregistrationRequest::clearNdsDataSetUser() {
    if (hasNdsDataSetUser()) {
         clear_has_ndsDataSetUser();
        _ndsDataSetUser = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
     }
}

inline bool SdsDatasetUserDeregistrationRequest::hasNdsDataSetUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NdsDatasetUser SdsDatasetUserDeregistrationRequest::getNdsDataSetUser () const {
    return _ndsDataSetUser;
}

inline void SdsDatasetUserDeregistrationRequest::setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_) {
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "SdsDatasetUserDeregistrationRequest");
    }
    #endif
    set_has_ndsDataSetUser();
    this->_ndsDataSetUser = ndsDataSetUser_;
}

inline void SdsDatasetUserDeregistrationRequest::clearDatasetId() {
    if (hasDatasetId()) {
         clear_has_datasetId();
        _datasetId = 0u;
     }
}

inline bool SdsDatasetUserDeregistrationRequest::hasDatasetId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SdsDatasetUserDeregistrationRequest::getDatasetId () const {
    return _datasetId;
}

inline void SdsDatasetUserDeregistrationRequest::setDatasetId (uint32 datasetId_) {
    set_has_datasetId();
    this->_datasetId = datasetId_;
}

inline void SdsDatasetUserDeregistrationRequest::set_has_ndsDataSetUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsDatasetUserDeregistrationRequest::clear_has_ndsDataSetUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SdsDatasetUserDeregistrationRequest::set_has_datasetId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SdsDatasetUserDeregistrationRequest::clear_has_datasetId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SdsDatasetUserDeregistrationResponse::SdsDatasetUserDeregistrationResponse ()  :
    _deregistrationStatus (::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsDatasetUserDeregistrationResponse::SdsDatasetUserDeregistrationResponse (const SdsDatasetUserDeregistrationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _deregistrationStatus (::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsDatasetUserDeregistrationResponse::SdsDatasetUserDeregistrationResponse (RegistrationAndDeRegistrationStatus deregistrationStatus_)  :
    _deregistrationStatus (deregistrationStatus_)
{
    #ifndef NDEBUG
    if (!(RegistrationAndDeRegistrationStatus_IsValid(deregistrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", deregistrationStatus_, "RegistrationAndDeRegistrationStatus", "deregistrationStatus", "SdsDatasetUserDeregistrationResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsDatasetUserDeregistrationResponse::~SdsDatasetUserDeregistrationResponse() {
}

inline SdsDatasetUserDeregistrationResponse& SdsDatasetUserDeregistrationResponse::operator = (const SdsDatasetUserDeregistrationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeregistrationStatus()) {
            setDeregistrationStatus(rhs.getDeregistrationStatus());
        } else {
            clearDeregistrationStatus();
        }
    }
    return *this;
}

inline bool SdsDatasetUserDeregistrationResponse::operator == (const SdsDatasetUserDeregistrationResponse& rhs) const {
    return (((!hasDeregistrationStatus() && !rhs.hasDeregistrationStatus()) || getDeregistrationStatus() == rhs.getDeregistrationStatus()));
}

inline bool SdsDatasetUserDeregistrationResponse::operator != (const SdsDatasetUserDeregistrationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsDatasetUserDeregistrationResponse::operator < (const SdsDatasetUserDeregistrationResponse& rhs) const {
    if (hasDeregistrationStatus() || rhs.hasDeregistrationStatus()) {
        if ((uint32)getDeregistrationStatus() < (uint32)rhs.getDeregistrationStatus()) return true;
        if ((uint32)getDeregistrationStatus() > (uint32)rhs.getDeregistrationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsDatasetUserDeregistrationResponse::clone() {
    return new SdsDatasetUserDeregistrationResponse(*this);
}

inline bool SdsDatasetUserDeregistrationResponse::operator > (const SdsDatasetUserDeregistrationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsDatasetUserDeregistrationResponse::clear() {
    clearDeregistrationStatus();
}

inline void SdsDatasetUserDeregistrationResponse::clearDeregistrationStatus() {
    if (hasDeregistrationStatus()) {
         clear_has_deregistrationStatus();
        _deregistrationStatus = ::org::bosch::cm::navigation::NavigationSDSService::RegistrationAndDeRegistrationStatus__STATUS_OK;
     }
}

inline bool SdsDatasetUserDeregistrationResponse::hasDeregistrationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline RegistrationAndDeRegistrationStatus SdsDatasetUserDeregistrationResponse::getDeregistrationStatus () const {
    return _deregistrationStatus;
}

inline void SdsDatasetUserDeregistrationResponse::setDeregistrationStatus (RegistrationAndDeRegistrationStatus deregistrationStatus_) {
    #ifndef NDEBUG
    if (!(RegistrationAndDeRegistrationStatus_IsValid(deregistrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", deregistrationStatus_, "RegistrationAndDeRegistrationStatus", "deregistrationStatus", "SdsDatasetUserDeregistrationResponse");
    }
    #endif
    set_has_deregistrationStatus();
    this->_deregistrationStatus = deregistrationStatus_;
}

inline void SdsDatasetUserDeregistrationResponse::set_has_deregistrationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsDatasetUserDeregistrationResponse::clear_has_deregistrationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DatasetAccessModeChangedIndicationRequest::DatasetAccessModeChangedIndicationRequest ()  :
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u),
    _ndsDataAccessType (::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DatasetAccessModeChangedIndicationRequest::DatasetAccessModeChangedIndicationRequest (const DatasetAccessModeChangedIndicationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ndsDataSetUser (::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS),
    _datasetId (0u),
    _ndsDataAccessType (::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DatasetAccessModeChangedIndicationRequest::DatasetAccessModeChangedIndicationRequest (NdsDatasetUser ndsDataSetUser_, uint32 datasetId_, NdsDataAccessType ndsDataAccessType_)  :
    _ndsDataSetUser (ndsDataSetUser_),
    _datasetId (datasetId_),
    _ndsDataAccessType (ndsDataAccessType_)
{
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "DatasetAccessModeChangedIndicationRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(NdsDataAccessType_IsValid(ndsDataAccessType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataAccessType_, "NdsDataAccessType", "ndsDataAccessType", "DatasetAccessModeChangedIndicationRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DatasetAccessModeChangedIndicationRequest::~DatasetAccessModeChangedIndicationRequest() {
}

inline DatasetAccessModeChangedIndicationRequest& DatasetAccessModeChangedIndicationRequest::operator = (const DatasetAccessModeChangedIndicationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNdsDataSetUser()) {
            setNdsDataSetUser(rhs.getNdsDataSetUser());
        } else {
            clearNdsDataSetUser();
        }
        if (rhs.hasDatasetId()) {
            setDatasetId(rhs.getDatasetId());
        } else {
            clearDatasetId();
        }
        if (rhs.hasNdsDataAccessType()) {
            setNdsDataAccessType(rhs.getNdsDataAccessType());
        } else {
            clearNdsDataAccessType();
        }
    }
    return *this;
}

inline bool DatasetAccessModeChangedIndicationRequest::operator == (const DatasetAccessModeChangedIndicationRequest& rhs) const {
    return (((!hasNdsDataSetUser() && !rhs.hasNdsDataSetUser()) || getNdsDataSetUser() == rhs.getNdsDataSetUser()) &&
        ((!hasDatasetId() && !rhs.hasDatasetId()) || getDatasetId() == rhs.getDatasetId()) &&
        ((!hasNdsDataAccessType() && !rhs.hasNdsDataAccessType()) || getNdsDataAccessType() == rhs.getNdsDataAccessType()));
}

inline bool DatasetAccessModeChangedIndicationRequest::operator != (const DatasetAccessModeChangedIndicationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DatasetAccessModeChangedIndicationRequest::operator < (const DatasetAccessModeChangedIndicationRequest& rhs) const {
    if (hasNdsDataSetUser() || rhs.hasNdsDataSetUser()) {
        if ((uint32)getNdsDataSetUser() < (uint32)rhs.getNdsDataSetUser()) return true;
        if ((uint32)getNdsDataSetUser() > (uint32)rhs.getNdsDataSetUser()) return false;
    }
    if (hasDatasetId() || rhs.hasDatasetId()) {
        if (getDatasetId() < rhs.getDatasetId()) return true;
        if (getDatasetId() > rhs.getDatasetId()) return false;
    }
    if (hasNdsDataAccessType() || rhs.hasNdsDataAccessType()) {
        if ((uint32)getNdsDataAccessType() < (uint32)rhs.getNdsDataAccessType()) return true;
        if ((uint32)getNdsDataAccessType() > (uint32)rhs.getNdsDataAccessType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DatasetAccessModeChangedIndicationRequest::clone() {
    return new DatasetAccessModeChangedIndicationRequest(*this);
}

inline bool DatasetAccessModeChangedIndicationRequest::operator > (const DatasetAccessModeChangedIndicationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DatasetAccessModeChangedIndicationRequest::clear() {
    clearNdsDataSetUser();
    clearDatasetId();
    clearNdsDataAccessType();
}

inline void DatasetAccessModeChangedIndicationRequest::clearNdsDataSetUser() {
    if (hasNdsDataSetUser()) {
         clear_has_ndsDataSetUser();
        _ndsDataSetUser = ::org::bosch::cm::navigation::NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS;
     }
}

inline bool DatasetAccessModeChangedIndicationRequest::hasNdsDataSetUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NdsDatasetUser DatasetAccessModeChangedIndicationRequest::getNdsDataSetUser () const {
    return _ndsDataSetUser;
}

inline void DatasetAccessModeChangedIndicationRequest::setNdsDataSetUser (NdsDatasetUser ndsDataSetUser_) {
    #ifndef NDEBUG
    if (!(NdsDatasetUser_IsValid(ndsDataSetUser_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataSetUser_, "NdsDatasetUser", "ndsDataSetUser", "DatasetAccessModeChangedIndicationRequest");
    }
    #endif
    set_has_ndsDataSetUser();
    this->_ndsDataSetUser = ndsDataSetUser_;
}

inline void DatasetAccessModeChangedIndicationRequest::clearDatasetId() {
    if (hasDatasetId()) {
         clear_has_datasetId();
        _datasetId = 0u;
     }
}

inline bool DatasetAccessModeChangedIndicationRequest::hasDatasetId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DatasetAccessModeChangedIndicationRequest::getDatasetId () const {
    return _datasetId;
}

inline void DatasetAccessModeChangedIndicationRequest::setDatasetId (uint32 datasetId_) {
    set_has_datasetId();
    this->_datasetId = datasetId_;
}

inline void DatasetAccessModeChangedIndicationRequest::clearNdsDataAccessType() {
    if (hasNdsDataAccessType()) {
         clear_has_ndsDataAccessType();
        _ndsDataAccessType = ::org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED;
     }
}

inline bool DatasetAccessModeChangedIndicationRequest::hasNdsDataAccessType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline NdsDataAccessType DatasetAccessModeChangedIndicationRequest::getNdsDataAccessType () const {
    return _ndsDataAccessType;
}

inline void DatasetAccessModeChangedIndicationRequest::setNdsDataAccessType (NdsDataAccessType ndsDataAccessType_) {
    #ifndef NDEBUG
    if (!(NdsDataAccessType_IsValid(ndsDataAccessType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ndsDataAccessType_, "NdsDataAccessType", "ndsDataAccessType", "DatasetAccessModeChangedIndicationRequest");
    }
    #endif
    set_has_ndsDataAccessType();
    this->_ndsDataAccessType = ndsDataAccessType_;
}

inline void DatasetAccessModeChangedIndicationRequest::set_has_ndsDataSetUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void DatasetAccessModeChangedIndicationRequest::clear_has_ndsDataSetUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DatasetAccessModeChangedIndicationRequest::set_has_datasetId () {
    _has_bits_[0] |= 1u << 1;
}

inline void DatasetAccessModeChangedIndicationRequest::clear_has_datasetId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DatasetAccessModeChangedIndicationRequest::set_has_ndsDataAccessType () {
    _has_bits_[0] |= 1u << 2;
}

inline void DatasetAccessModeChangedIndicationRequest::clear_has_ndsDataAccessType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  MapUpdateRequestedUpdate::MapUpdateRequestedUpdate ()  :
    _mapUpdateRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapUpdateRequestedUpdate::MapUpdateRequestedUpdate (const MapUpdateRequestedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _mapUpdateRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapUpdateRequestedUpdate::MapUpdateRequestedUpdate (bool mapUpdateRequested_)  :
    _mapUpdateRequested (mapUpdateRequested_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapUpdateRequestedUpdate::~MapUpdateRequestedUpdate() {
}

inline MapUpdateRequestedUpdate& MapUpdateRequestedUpdate::operator = (const MapUpdateRequestedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMapUpdateRequested()) {
            setMapUpdateRequested(rhs.getMapUpdateRequested());
        } else {
            clearMapUpdateRequested();
        }
    }
    return *this;
}

inline bool MapUpdateRequestedUpdate::operator == (const MapUpdateRequestedUpdate& rhs) const {
    return (((!hasMapUpdateRequested() && !rhs.hasMapUpdateRequested()) || getMapUpdateRequested() == rhs.getMapUpdateRequested()));
}

inline bool MapUpdateRequestedUpdate::operator != (const MapUpdateRequestedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MapUpdateRequestedUpdate::operator < (const MapUpdateRequestedUpdate& rhs) const {
    if (hasMapUpdateRequested() || rhs.hasMapUpdateRequested()) {
        if (getMapUpdateRequested() < rhs.getMapUpdateRequested()) return true;
        if (getMapUpdateRequested() > rhs.getMapUpdateRequested()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapUpdateRequestedUpdate::clone() {
    return new MapUpdateRequestedUpdate(*this);
}

inline bool MapUpdateRequestedUpdate::operator > (const MapUpdateRequestedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapUpdateRequestedUpdate::clear() {
    clearMapUpdateRequested();
}

inline void MapUpdateRequestedUpdate::clearMapUpdateRequested() {
    if (hasMapUpdateRequested()) {
         clear_has_mapUpdateRequested();
        _mapUpdateRequested = false;
     }
}

inline bool MapUpdateRequestedUpdate::hasMapUpdateRequested () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool MapUpdateRequestedUpdate::getMapUpdateRequested () const {
    return _mapUpdateRequested;
}

inline void MapUpdateRequestedUpdate::setMapUpdateRequested (bool mapUpdateRequested_) {
    set_has_mapUpdateRequested();
    this->_mapUpdateRequested = mapUpdateRequested_;
}

inline void MapUpdateRequestedUpdate::set_has_mapUpdateRequested () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapUpdateRequestedUpdate::clear_has_mapUpdateRequested () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MapUpdateRequestedRegister::MapUpdateRequestedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapUpdateRequestedRegister::MapUpdateRequestedRegister (const MapUpdateRequestedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapUpdateRequestedRegister::~MapUpdateRequestedRegister() {
}

inline MapUpdateRequestedRegister& MapUpdateRequestedRegister::operator = (const MapUpdateRequestedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MapUpdateRequestedRegister::operator == (const MapUpdateRequestedRegister& ) const {
    return true;
}

inline bool MapUpdateRequestedRegister::operator != (const MapUpdateRequestedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MapUpdateRequestedRegister::operator < (const MapUpdateRequestedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MapUpdateRequestedRegister::clone() {
    return new MapUpdateRequestedRegister(*this);
}

inline bool MapUpdateRequestedRegister::operator > (const MapUpdateRequestedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapUpdateRequestedRegister::clear() {
}

inline  HandOverSessionStatusUpdate::HandOverSessionStatusUpdate ()  :
    _handOverSessionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HandOverSessionStatusUpdate::HandOverSessionStatusUpdate (const HandOverSessionStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _handOverSessionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HandOverSessionStatusUpdate::HandOverSessionStatusUpdate (const HandOverSessionStatus& handOverSessionStatus_)  :
    _handOverSessionStatus (handOverSessionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HandOverSessionStatusUpdate::~HandOverSessionStatusUpdate() {
}

inline HandOverSessionStatusUpdate& HandOverSessionStatusUpdate::operator = (const HandOverSessionStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHandOverSessionStatus()) {
            setHandOverSessionStatus(rhs.getHandOverSessionStatus());
        } else {
            clearHandOverSessionStatus();
        }
    }
    return *this;
}

inline bool HandOverSessionStatusUpdate::operator == (const HandOverSessionStatusUpdate& rhs) const {
    return (((!hasHandOverSessionStatus() && !rhs.hasHandOverSessionStatus()) || getHandOverSessionStatus() == rhs.getHandOverSessionStatus()));
}

inline bool HandOverSessionStatusUpdate::operator != (const HandOverSessionStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool HandOverSessionStatusUpdate::operator < (const HandOverSessionStatusUpdate& rhs) const {
    if (hasHandOverSessionStatus() || rhs.hasHandOverSessionStatus()) {
        if (getHandOverSessionStatus() < rhs.getHandOverSessionStatus()) return true;
        if (getHandOverSessionStatus() > rhs.getHandOverSessionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HandOverSessionStatusUpdate::clone() {
    return new HandOverSessionStatusUpdate(*this);
}

inline bool HandOverSessionStatusUpdate::operator > (const HandOverSessionStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HandOverSessionStatusUpdate::clear() {
    clearHandOverSessionStatus();
}

inline void HandOverSessionStatusUpdate::clearHandOverSessionStatus() {
    if (hasHandOverSessionStatus()) {
         clear_has_handOverSessionStatus();
        _handOverSessionStatus.clear();
     }
}

inline bool HandOverSessionStatusUpdate::hasHandOverSessionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const HandOverSessionStatus& HandOverSessionStatusUpdate::getHandOverSessionStatus () const {
    return _handOverSessionStatus;
}

inline HandOverSessionStatus& HandOverSessionStatusUpdate::getHandOverSessionStatusMutable () {
    set_has_handOverSessionStatus();
    return _handOverSessionStatus;
}

inline void HandOverSessionStatusUpdate::setHandOverSessionStatus (const HandOverSessionStatus& handOverSessionStatus_) {
    set_has_handOverSessionStatus();
    this->_handOverSessionStatus = handOverSessionStatus_;
}

inline void HandOverSessionStatusUpdate::set_has_handOverSessionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void HandOverSessionStatusUpdate::clear_has_handOverSessionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HandOverSessionStatusRegister::HandOverSessionStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HandOverSessionStatusRegister::HandOverSessionStatusRegister (const HandOverSessionStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HandOverSessionStatusRegister::~HandOverSessionStatusRegister() {
}

inline HandOverSessionStatusRegister& HandOverSessionStatusRegister::operator = (const HandOverSessionStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool HandOverSessionStatusRegister::operator == (const HandOverSessionStatusRegister& ) const {
    return true;
}

inline bool HandOverSessionStatusRegister::operator != (const HandOverSessionStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool HandOverSessionStatusRegister::operator < (const HandOverSessionStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* HandOverSessionStatusRegister::clone() {
    return new HandOverSessionStatusRegister(*this);
}

inline bool HandOverSessionStatusRegister::operator > (const HandOverSessionStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HandOverSessionStatusRegister::clear() {
}

inline  PositionStatusInfoUpdate::PositionStatusInfoUpdate ()  :
    _positionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionStatusInfoUpdate::PositionStatusInfoUpdate (const PositionStatusInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _positionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionStatusInfoUpdate::PositionStatusInfoUpdate (const PositionStatusInfo& positionStatusInfo_)  :
    _positionStatusInfo (positionStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PositionStatusInfoUpdate::~PositionStatusInfoUpdate() {
}

inline PositionStatusInfoUpdate& PositionStatusInfoUpdate::operator = (const PositionStatusInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPositionStatusInfo()) {
            setPositionStatusInfo(rhs.getPositionStatusInfo());
        } else {
            clearPositionStatusInfo();
        }
    }
    return *this;
}

inline bool PositionStatusInfoUpdate::operator == (const PositionStatusInfoUpdate& rhs) const {
    return (((!hasPositionStatusInfo() && !rhs.hasPositionStatusInfo()) || getPositionStatusInfo() == rhs.getPositionStatusInfo()));
}

inline bool PositionStatusInfoUpdate::operator != (const PositionStatusInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionStatusInfoUpdate::operator < (const PositionStatusInfoUpdate& rhs) const {
    if (hasPositionStatusInfo() || rhs.hasPositionStatusInfo()) {
        if (getPositionStatusInfo() < rhs.getPositionStatusInfo()) return true;
        if (getPositionStatusInfo() > rhs.getPositionStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PositionStatusInfoUpdate::clone() {
    return new PositionStatusInfoUpdate(*this);
}

inline bool PositionStatusInfoUpdate::operator > (const PositionStatusInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionStatusInfoUpdate::clear() {
    clearPositionStatusInfo();
}

inline void PositionStatusInfoUpdate::clearPositionStatusInfo() {
    if (hasPositionStatusInfo()) {
         clear_has_positionStatusInfo();
        _positionStatusInfo.clear();
     }
}

inline bool PositionStatusInfoUpdate::hasPositionStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const PositionStatusInfo& PositionStatusInfoUpdate::getPositionStatusInfo () const {
    return _positionStatusInfo;
}

inline PositionStatusInfo& PositionStatusInfoUpdate::getPositionStatusInfoMutable () {
    set_has_positionStatusInfo();
    return _positionStatusInfo;
}

inline void PositionStatusInfoUpdate::setPositionStatusInfo (const PositionStatusInfo& positionStatusInfo_) {
    set_has_positionStatusInfo();
    this->_positionStatusInfo = positionStatusInfo_;
}

inline void PositionStatusInfoUpdate::set_has_positionStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void PositionStatusInfoUpdate::clear_has_positionStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PositionStatusInfoRegister::PositionStatusInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionStatusInfoRegister::PositionStatusInfoRegister (const PositionStatusInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionStatusInfoRegister::~PositionStatusInfoRegister() {
}

inline PositionStatusInfoRegister& PositionStatusInfoRegister::operator = (const PositionStatusInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PositionStatusInfoRegister::operator == (const PositionStatusInfoRegister& ) const {
    return true;
}

inline bool PositionStatusInfoRegister::operator != (const PositionStatusInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionStatusInfoRegister::operator < (const PositionStatusInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PositionStatusInfoRegister::clone() {
    return new PositionStatusInfoRegister(*this);
}

inline bool PositionStatusInfoRegister::operator > (const PositionStatusInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionStatusInfoRegister::clear() {
}

inline  PositionInfoUpdate::PositionInfoUpdate ()  :
    _positionInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionInfoUpdate::PositionInfoUpdate (const PositionInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _positionInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionInfoUpdate::PositionInfoUpdate (const PositionInfo& positionInfo_)  :
    _positionInfo (positionInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PositionInfoUpdate::~PositionInfoUpdate() {
}

inline PositionInfoUpdate& PositionInfoUpdate::operator = (const PositionInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPositionInfo()) {
            setPositionInfo(rhs.getPositionInfo());
        } else {
            clearPositionInfo();
        }
    }
    return *this;
}

inline bool PositionInfoUpdate::operator == (const PositionInfoUpdate& rhs) const {
    return (((!hasPositionInfo() && !rhs.hasPositionInfo()) || getPositionInfo() == rhs.getPositionInfo()));
}

inline bool PositionInfoUpdate::operator != (const PositionInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionInfoUpdate::operator < (const PositionInfoUpdate& rhs) const {
    if (hasPositionInfo() || rhs.hasPositionInfo()) {
        if (getPositionInfo() < rhs.getPositionInfo()) return true;
        if (getPositionInfo() > rhs.getPositionInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PositionInfoUpdate::clone() {
    return new PositionInfoUpdate(*this);
}

inline bool PositionInfoUpdate::operator > (const PositionInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionInfoUpdate::clear() {
    clearPositionInfo();
}

inline void PositionInfoUpdate::clearPositionInfo() {
    if (hasPositionInfo()) {
         clear_has_positionInfo();
        _positionInfo.clear();
     }
}

inline bool PositionInfoUpdate::hasPositionInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const PositionInfo& PositionInfoUpdate::getPositionInfo () const {
    return _positionInfo;
}

inline PositionInfo& PositionInfoUpdate::getPositionInfoMutable () {
    set_has_positionInfo();
    return _positionInfo;
}

inline void PositionInfoUpdate::setPositionInfo (const PositionInfo& positionInfo_) {
    set_has_positionInfo();
    this->_positionInfo = positionInfo_;
}

inline void PositionInfoUpdate::set_has_positionInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void PositionInfoUpdate::clear_has_positionInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PositionInfoRegister::PositionInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PositionInfoRegister::PositionInfoRegister (const PositionInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PositionInfoRegister::~PositionInfoRegister() {
}

inline PositionInfoRegister& PositionInfoRegister::operator = (const PositionInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PositionInfoRegister::operator == (const PositionInfoRegister& ) const {
    return true;
}

inline bool PositionInfoRegister::operator != (const PositionInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PositionInfoRegister::operator < (const PositionInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PositionInfoRegister::clone() {
    return new PositionInfoRegister(*this);
}

inline bool PositionInfoRegister::operator > (const PositionInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PositionInfoRegister::clear() {
}

inline  SdsAddressWithOptionsUpdate::SdsAddressWithOptionsUpdate ()  :
    _sdsAddressWithOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsAddressWithOptionsUpdate::SdsAddressWithOptionsUpdate (const SdsAddressWithOptionsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _sdsAddressWithOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsAddressWithOptionsUpdate::SdsAddressWithOptionsUpdate (const SDSAddressWithOptions& sdsAddressWithOptions_)  :
    _sdsAddressWithOptions (sdsAddressWithOptions_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsAddressWithOptionsUpdate::~SdsAddressWithOptionsUpdate() {
}

inline SdsAddressWithOptionsUpdate& SdsAddressWithOptionsUpdate::operator = (const SdsAddressWithOptionsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSdsAddressWithOptions()) {
            setSdsAddressWithOptions(rhs.getSdsAddressWithOptions());
        } else {
            clearSdsAddressWithOptions();
        }
    }
    return *this;
}

inline bool SdsAddressWithOptionsUpdate::operator == (const SdsAddressWithOptionsUpdate& rhs) const {
    return (((!hasSdsAddressWithOptions() && !rhs.hasSdsAddressWithOptions()) || getSdsAddressWithOptions() == rhs.getSdsAddressWithOptions()));
}

inline bool SdsAddressWithOptionsUpdate::operator != (const SdsAddressWithOptionsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsAddressWithOptionsUpdate::operator < (const SdsAddressWithOptionsUpdate& rhs) const {
    if (hasSdsAddressWithOptions() || rhs.hasSdsAddressWithOptions()) {
        if (getSdsAddressWithOptions() < rhs.getSdsAddressWithOptions()) return true;
        if (getSdsAddressWithOptions() > rhs.getSdsAddressWithOptions()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsAddressWithOptionsUpdate::clone() {
    return new SdsAddressWithOptionsUpdate(*this);
}

inline bool SdsAddressWithOptionsUpdate::operator > (const SdsAddressWithOptionsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsAddressWithOptionsUpdate::clear() {
    clearSdsAddressWithOptions();
}

inline void SdsAddressWithOptionsUpdate::clearSdsAddressWithOptions() {
    if (hasSdsAddressWithOptions()) {
         clear_has_sdsAddressWithOptions();
        _sdsAddressWithOptions.clear();
     }
}

inline bool SdsAddressWithOptionsUpdate::hasSdsAddressWithOptions () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SDSAddressWithOptions& SdsAddressWithOptionsUpdate::getSdsAddressWithOptions () const {
    return _sdsAddressWithOptions;
}

inline SDSAddressWithOptions& SdsAddressWithOptionsUpdate::getSdsAddressWithOptionsMutable () {
    set_has_sdsAddressWithOptions();
    return _sdsAddressWithOptions;
}

inline void SdsAddressWithOptionsUpdate::setSdsAddressWithOptions (const SDSAddressWithOptions& sdsAddressWithOptions_) {
    set_has_sdsAddressWithOptions();
    this->_sdsAddressWithOptions = sdsAddressWithOptions_;
}

inline void SdsAddressWithOptionsUpdate::set_has_sdsAddressWithOptions () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsAddressWithOptionsUpdate::clear_has_sdsAddressWithOptions () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsAddressWithOptionsRegister::SdsAddressWithOptionsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsAddressWithOptionsRegister::SdsAddressWithOptionsRegister (const SdsAddressWithOptionsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsAddressWithOptionsRegister::~SdsAddressWithOptionsRegister() {
}

inline SdsAddressWithOptionsRegister& SdsAddressWithOptionsRegister::operator = (const SdsAddressWithOptionsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SdsAddressWithOptionsRegister::operator == (const SdsAddressWithOptionsRegister& ) const {
    return true;
}

inline bool SdsAddressWithOptionsRegister::operator != (const SdsAddressWithOptionsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsAddressWithOptionsRegister::operator < (const SdsAddressWithOptionsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SdsAddressWithOptionsRegister::clone() {
    return new SdsAddressWithOptionsRegister(*this);
}

inline bool SdsAddressWithOptionsRegister::operator > (const SdsAddressWithOptionsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsAddressWithOptionsRegister::clear() {
}

inline  SdsVoiceTagWithOptionsUpdate::SdsVoiceTagWithOptionsUpdate ()  :
    _sdsVoiceTagWithOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsVoiceTagWithOptionsUpdate::SdsVoiceTagWithOptionsUpdate (const SdsVoiceTagWithOptionsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _sdsVoiceTagWithOptions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsVoiceTagWithOptionsUpdate::SdsVoiceTagWithOptionsUpdate (const SDSVoiceTagId& sdsVoiceTagWithOptions_)  :
    _sdsVoiceTagWithOptions (sdsVoiceTagWithOptions_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsVoiceTagWithOptionsUpdate::~SdsVoiceTagWithOptionsUpdate() {
}

inline SdsVoiceTagWithOptionsUpdate& SdsVoiceTagWithOptionsUpdate::operator = (const SdsVoiceTagWithOptionsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSdsVoiceTagWithOptions()) {
            setSdsVoiceTagWithOptions(rhs.getSdsVoiceTagWithOptions());
        } else {
            clearSdsVoiceTagWithOptions();
        }
    }
    return *this;
}

inline bool SdsVoiceTagWithOptionsUpdate::operator == (const SdsVoiceTagWithOptionsUpdate& rhs) const {
    return (((!hasSdsVoiceTagWithOptions() && !rhs.hasSdsVoiceTagWithOptions()) || getSdsVoiceTagWithOptions() == rhs.getSdsVoiceTagWithOptions()));
}

inline bool SdsVoiceTagWithOptionsUpdate::operator != (const SdsVoiceTagWithOptionsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsVoiceTagWithOptionsUpdate::operator < (const SdsVoiceTagWithOptionsUpdate& rhs) const {
    if (hasSdsVoiceTagWithOptions() || rhs.hasSdsVoiceTagWithOptions()) {
        if (getSdsVoiceTagWithOptions() < rhs.getSdsVoiceTagWithOptions()) return true;
        if (getSdsVoiceTagWithOptions() > rhs.getSdsVoiceTagWithOptions()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsVoiceTagWithOptionsUpdate::clone() {
    return new SdsVoiceTagWithOptionsUpdate(*this);
}

inline bool SdsVoiceTagWithOptionsUpdate::operator > (const SdsVoiceTagWithOptionsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsVoiceTagWithOptionsUpdate::clear() {
    clearSdsVoiceTagWithOptions();
}

inline void SdsVoiceTagWithOptionsUpdate::clearSdsVoiceTagWithOptions() {
    if (hasSdsVoiceTagWithOptions()) {
         clear_has_sdsVoiceTagWithOptions();
        _sdsVoiceTagWithOptions.clear();
     }
}

inline bool SdsVoiceTagWithOptionsUpdate::hasSdsVoiceTagWithOptions () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SDSVoiceTagId& SdsVoiceTagWithOptionsUpdate::getSdsVoiceTagWithOptions () const {
    return _sdsVoiceTagWithOptions;
}

inline SDSVoiceTagId& SdsVoiceTagWithOptionsUpdate::getSdsVoiceTagWithOptionsMutable () {
    set_has_sdsVoiceTagWithOptions();
    return _sdsVoiceTagWithOptions;
}

inline void SdsVoiceTagWithOptionsUpdate::setSdsVoiceTagWithOptions (const SDSVoiceTagId& sdsVoiceTagWithOptions_) {
    set_has_sdsVoiceTagWithOptions();
    this->_sdsVoiceTagWithOptions = sdsVoiceTagWithOptions_;
}

inline void SdsVoiceTagWithOptionsUpdate::set_has_sdsVoiceTagWithOptions () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsVoiceTagWithOptionsUpdate::clear_has_sdsVoiceTagWithOptions () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsVoiceTagWithOptionsRegister::SdsVoiceTagWithOptionsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsVoiceTagWithOptionsRegister::SdsVoiceTagWithOptionsRegister (const SdsVoiceTagWithOptionsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsVoiceTagWithOptionsRegister::~SdsVoiceTagWithOptionsRegister() {
}

inline SdsVoiceTagWithOptionsRegister& SdsVoiceTagWithOptionsRegister::operator = (const SdsVoiceTagWithOptionsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SdsVoiceTagWithOptionsRegister::operator == (const SdsVoiceTagWithOptionsRegister& ) const {
    return true;
}

inline bool SdsVoiceTagWithOptionsRegister::operator != (const SdsVoiceTagWithOptionsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsVoiceTagWithOptionsRegister::operator < (const SdsVoiceTagWithOptionsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SdsVoiceTagWithOptionsRegister::clone() {
    return new SdsVoiceTagWithOptionsRegister(*this);
}

inline bool SdsVoiceTagWithOptionsRegister::operator > (const SdsVoiceTagWithOptionsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsVoiceTagWithOptionsRegister::clear() {
}

inline  NavDatasetInfoUpdate::NavDatasetInfoUpdate ()  :
    _navDatasetInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDatasetInfoUpdate::NavDatasetInfoUpdate (const NavDatasetInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _navDatasetInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDatasetInfoUpdate::NavDatasetInfoUpdate (const NavDataSetInfo& navDatasetInfo_)  :
    _navDatasetInfo (navDatasetInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavDatasetInfoUpdate::~NavDatasetInfoUpdate() {
}

inline NavDatasetInfoUpdate& NavDatasetInfoUpdate::operator = (const NavDatasetInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNavDatasetInfo()) {
            setNavDatasetInfo(rhs.getNavDatasetInfo());
        } else {
            clearNavDatasetInfo();
        }
    }
    return *this;
}

inline bool NavDatasetInfoUpdate::operator == (const NavDatasetInfoUpdate& rhs) const {
    return (((!hasNavDatasetInfo() && !rhs.hasNavDatasetInfo()) || getNavDatasetInfo() == rhs.getNavDatasetInfo()));
}

inline bool NavDatasetInfoUpdate::operator != (const NavDatasetInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDatasetInfoUpdate::operator < (const NavDatasetInfoUpdate& rhs) const {
    if (hasNavDatasetInfo() || rhs.hasNavDatasetInfo()) {
        if (getNavDatasetInfo() < rhs.getNavDatasetInfo()) return true;
        if (getNavDatasetInfo() > rhs.getNavDatasetInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NavDatasetInfoUpdate::clone() {
    return new NavDatasetInfoUpdate(*this);
}

inline bool NavDatasetInfoUpdate::operator > (const NavDatasetInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDatasetInfoUpdate::clear() {
    clearNavDatasetInfo();
}

inline void NavDatasetInfoUpdate::clearNavDatasetInfo() {
    if (hasNavDatasetInfo()) {
         clear_has_navDatasetInfo();
        _navDatasetInfo.clear();
     }
}

inline bool NavDatasetInfoUpdate::hasNavDatasetInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const NavDataSetInfo& NavDatasetInfoUpdate::getNavDatasetInfo () const {
    return _navDatasetInfo;
}

inline NavDataSetInfo& NavDatasetInfoUpdate::getNavDatasetInfoMutable () {
    set_has_navDatasetInfo();
    return _navDatasetInfo;
}

inline void NavDatasetInfoUpdate::setNavDatasetInfo (const NavDataSetInfo& navDatasetInfo_) {
    set_has_navDatasetInfo();
    this->_navDatasetInfo = navDatasetInfo_;
}

inline void NavDatasetInfoUpdate::set_has_navDatasetInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavDatasetInfoUpdate::clear_has_navDatasetInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NavDatasetInfoRegister::NavDatasetInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDatasetInfoRegister::NavDatasetInfoRegister (const NavDatasetInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDatasetInfoRegister::~NavDatasetInfoRegister() {
}

inline NavDatasetInfoRegister& NavDatasetInfoRegister::operator = (const NavDatasetInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NavDatasetInfoRegister::operator == (const NavDatasetInfoRegister& ) const {
    return true;
}

inline bool NavDatasetInfoRegister::operator != (const NavDatasetInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDatasetInfoRegister::operator < (const NavDatasetInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NavDatasetInfoRegister::clone() {
    return new NavDatasetInfoRegister(*this);
}

inline bool NavDatasetInfoRegister::operator > (const NavDatasetInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDatasetInfoRegister::clear() {
}

inline  DynamicMapPoiCategoryWithLanguageUpdate::DynamicMapPoiCategoryWithLanguageUpdate ()  :
    _dynamicMapPoiCategoryWithLanguage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategoryWithLanguageUpdate::DynamicMapPoiCategoryWithLanguageUpdate (const DynamicMapPoiCategoryWithLanguageUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _dynamicMapPoiCategoryWithLanguage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicMapPoiCategoryWithLanguageUpdate::DynamicMapPoiCategoryWithLanguageUpdate (const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage_)  :
    _dynamicMapPoiCategoryWithLanguage (dynamicMapPoiCategoryWithLanguage_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategoryWithLanguageUpdate::~DynamicMapPoiCategoryWithLanguageUpdate() {
}

inline DynamicMapPoiCategoryWithLanguageUpdate& DynamicMapPoiCategoryWithLanguageUpdate::operator = (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDynamicMapPoiCategoryWithLanguage()) {
            setDynamicMapPoiCategoryWithLanguage(rhs.getDynamicMapPoiCategoryWithLanguage());
        } else {
            clearDynamicMapPoiCategoryWithLanguage();
        }
    }
    return *this;
}

inline bool DynamicMapPoiCategoryWithLanguageUpdate::operator == (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const {
    return (((!hasDynamicMapPoiCategoryWithLanguage() && !rhs.hasDynamicMapPoiCategoryWithLanguage()) || getDynamicMapPoiCategoryWithLanguage() == rhs.getDynamicMapPoiCategoryWithLanguage()));
}

inline bool DynamicMapPoiCategoryWithLanguageUpdate::operator != (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DynamicMapPoiCategoryWithLanguageUpdate::operator < (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const {
    if (hasDynamicMapPoiCategoryWithLanguage() || rhs.hasDynamicMapPoiCategoryWithLanguage()) {
        if (getDynamicMapPoiCategoryWithLanguage() < rhs.getDynamicMapPoiCategoryWithLanguage()) return true;
        if (getDynamicMapPoiCategoryWithLanguage() > rhs.getDynamicMapPoiCategoryWithLanguage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DynamicMapPoiCategoryWithLanguageUpdate::clone() {
    return new DynamicMapPoiCategoryWithLanguageUpdate(*this);
}

inline bool DynamicMapPoiCategoryWithLanguageUpdate::operator > (const DynamicMapPoiCategoryWithLanguageUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DynamicMapPoiCategoryWithLanguageUpdate::clear() {
    clearDynamicMapPoiCategoryWithLanguage();
}

inline void DynamicMapPoiCategoryWithLanguageUpdate::clearDynamicMapPoiCategoryWithLanguage() {
    if (hasDynamicMapPoiCategoryWithLanguage()) {
         clear_has_dynamicMapPoiCategoryWithLanguage();
        _dynamicMapPoiCategoryWithLanguage.clear();
     }
}

inline bool DynamicMapPoiCategoryWithLanguageUpdate::hasDynamicMapPoiCategoryWithLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const DynamicMapPoiCategoriesWithLanguage& DynamicMapPoiCategoryWithLanguageUpdate::getDynamicMapPoiCategoryWithLanguage () const {
    return _dynamicMapPoiCategoryWithLanguage;
}

inline DynamicMapPoiCategoriesWithLanguage& DynamicMapPoiCategoryWithLanguageUpdate::getDynamicMapPoiCategoryWithLanguageMutable () {
    set_has_dynamicMapPoiCategoryWithLanguage();
    return _dynamicMapPoiCategoryWithLanguage;
}

inline void DynamicMapPoiCategoryWithLanguageUpdate::setDynamicMapPoiCategoryWithLanguage (const DynamicMapPoiCategoriesWithLanguage& dynamicMapPoiCategoryWithLanguage_) {
    set_has_dynamicMapPoiCategoryWithLanguage();
    this->_dynamicMapPoiCategoryWithLanguage = dynamicMapPoiCategoryWithLanguage_;
}

inline void DynamicMapPoiCategoryWithLanguageUpdate::set_has_dynamicMapPoiCategoryWithLanguage () {
    _has_bits_[0] |= 1u << 0;
}

inline void DynamicMapPoiCategoryWithLanguageUpdate::clear_has_dynamicMapPoiCategoryWithLanguage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DynamicMapPoiCategoryWithLanguageRegister::DynamicMapPoiCategoryWithLanguageRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicMapPoiCategoryWithLanguageRegister::DynamicMapPoiCategoryWithLanguageRegister (const DynamicMapPoiCategoryWithLanguageRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicMapPoiCategoryWithLanguageRegister::~DynamicMapPoiCategoryWithLanguageRegister() {
}

inline DynamicMapPoiCategoryWithLanguageRegister& DynamicMapPoiCategoryWithLanguageRegister::operator = (const DynamicMapPoiCategoryWithLanguageRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DynamicMapPoiCategoryWithLanguageRegister::operator == (const DynamicMapPoiCategoryWithLanguageRegister& ) const {
    return true;
}

inline bool DynamicMapPoiCategoryWithLanguageRegister::operator != (const DynamicMapPoiCategoryWithLanguageRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DynamicMapPoiCategoryWithLanguageRegister::operator < (const DynamicMapPoiCategoryWithLanguageRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DynamicMapPoiCategoryWithLanguageRegister::clone() {
    return new DynamicMapPoiCategoryWithLanguageRegister(*this);
}

inline bool DynamicMapPoiCategoryWithLanguageRegister::operator > (const DynamicMapPoiCategoryWithLanguageRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DynamicMapPoiCategoryWithLanguageRegister::clear() {
}

} // namespace NavigationSDSService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSDSSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
