/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceJson.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationDataUpdateService", NavigationDataUpdateServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 15, "startFullUpdate", 5 },
    { 18, "StartMapDataExport", 6 },
    { 19, "getAvailableUpdates", 1 },
    { 21, "deleteUpdateComponent", 2 },
    { 24, "setFavoriteUpdateRegions", 3 },
    { 26, "clearFavoriteUpdateRegions", 4 },
    { 27, "DiagPerformFullUpdateViaUSB", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "deviceInfos", 7 },
    { 13, "navDataStatus", 2 },
    { 14, "navDataContext", 3 },
    { 15, "catalogueStatus", 5 },
    { 18, "installationStatus", 1 },
    { 21, "favoriteUpdateRegions", 0 },
    { 21, "mapupdateExportStatus", 6 },
    { 30, "navigationDataUpdateStatusInfo", 4 },
};

class NavigationDataUpdateServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NavigationDataUpdateServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NavigationDataUpdateServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NavigationDataUpdateServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.navigation.NavigationDataUpdateService"),
          _logger(logger) {}

    virtual ~NavigationDataUpdateServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NavigationDataUpdateServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 7, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'DiagPerformFullUpdateViaUSB'

            LOG_DEBUG_STUB("process method '%s'", "DiagPerformFullUpdateViaUSB");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiagPerformFullUpdateViaUSBRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DiagPerformFullUpdateViaUSB", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DiagPerformFullUpdateViaUSBRequest > payload = ::boost::static_pointer_cast<DiagPerformFullUpdateViaUSBRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onDiagPerformFullUpdateViaUSBRequest(payload);
            return;
        }
        case 1: {

            // method 'getAvailableUpdates'

            LOG_DEBUG_STUB("process method '%s'", "getAvailableUpdates");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailableUpdatesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAvailableUpdates", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAvailableUpdatesRequest > payload = ::boost::static_pointer_cast<GetAvailableUpdatesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onGetAvailableUpdatesRequest(payload);
            return;
        }
        case 2: {

            // method 'deleteUpdateComponent'

            LOG_DEBUG_STUB("process method '%s'", "deleteUpdateComponent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteUpdateComponentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeleteUpdateComponent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeleteUpdateComponentRequest > payload = ::boost::static_pointer_cast<DeleteUpdateComponentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onDeleteUpdateComponentRequest(payload);
            return;
        }
        case 3: {

            // method 'setFavoriteUpdateRegions'

            LOG_DEBUG_STUB("process method '%s'", "setFavoriteUpdateRegions");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFavoriteUpdateRegionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetFavoriteUpdateRegions", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetFavoriteUpdateRegionsRequest > payload = ::boost::static_pointer_cast<SetFavoriteUpdateRegionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onSetFavoriteUpdateRegionsRequest(payload);
            return;
        }
        case 4: {

            // method 'clearFavoriteUpdateRegions'

            LOG_DEBUG_STUB("process method '%s'", "clearFavoriteUpdateRegions");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearFavoriteUpdateRegionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearFavoriteUpdateRegions", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearFavoriteUpdateRegionsRequest > payload = ::boost::static_pointer_cast<ClearFavoriteUpdateRegionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onClearFavoriteUpdateRegionsRequest(payload);
            return;
        }
        case 5: {

            // method 'startFullUpdate'

            LOG_DEBUG_STUB("process method '%s'", "startFullUpdate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartFullUpdateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartFullUpdate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartFullUpdateRequest > payload = ::boost::static_pointer_cast<StartFullUpdateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onStartFullUpdateRequest(payload);
            return;
        }
        case 6: {

            // method 'StartMapDataExport'

            LOG_DEBUG_STUB("process method '%s'", "StartMapDataExport");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartMapDataExportRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartMapDataExport", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartMapDataExportRequest > payload = ::boost::static_pointer_cast<StartMapDataExportRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onStartMapDataExportRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NavigationDataUpdateServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.navigation.NavigationDataUpdateService\">\n"
            "    <property access=\"read\" name=\"favoriteUpdateRegions\" type=\"(u(uuuau))\"/>\n"
            "    <property access=\"read\" name=\"installationStatus\" type=\"(uuuuqbss)\"/>\n"
            "    <property access=\"read\" name=\"navDataStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"navDataContext\" type=\"(ssa(suuuuubtsua(usau)a(sustbbttbb))(tt))\"/>\n"
            "    <property access=\"read\" name=\"navigationDataUpdateStatusInfo\" type=\"(uyuss)\"/>\n"
            "    <property access=\"read\" name=\"catalogueStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"mapupdateExportStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"deviceInfos\" type=\"a(uuu)\"/>\n"
            "    <method name=\"DiagPerformFullUpdateViaUSB\">\n"
            "      <doc>\n"
            "        <line>DiagPerformFullUpdateViaUSB = Diagnosis request full update via USB in Diagnostic mode</line>\n"
            "        <line>Response: Update result (SUCCESSFUL, FAILED, DECLINED)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ack\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ack (of type NavigationDataUpdateServiceAck) = Description missing</line>\n"
            "          <line>enum[ACCEPTED (null), DECLINED__CANNOT_PROCESS (null), DECLINED__REQUEST_ACTIVE (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getAvailableUpdates\">\n"
            "      <doc>\n"
            "        <line>getAvailableUpdates = Request to get a list of all available updates.</line>\n"
            "        <line>For each update component one entry is contained if an update is available only.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"availableUpdates\" type=\"(ua(uuua(uua(uttt))))\">\n"
            "        <doc>\n"
            "          <line>availableUpdates (of type AvailableUpdates) = Description missing</line>\n"
            "          <line>AvailableUpdates struct[result, products] = Describes the result og method GetAvailableUpdates.\n"
            "      If no updates are available result will be set to SUCCESS, but the ProductVersionInfo array is empty.</line>\n"
            "          <line>0: AvailableUpdates.result ('?') = Description missing</line>\n"
            "          <line>1: AvailableUpdates.products ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"deleteUpdateComponent\">\n"
            "      <doc>\n"
            "        <line>deleteUpdateComponent = Request to remove an updateable component from the data.</line>\n"
            "        <line>The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"productId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>productId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"supplierId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>supplierId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"regionId\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result (of type DeleteUpdateComponentResult) = Description missing</line>\n"
            "          <line>enum[DELETED (0), SUCCESS (1), FAILED_DEINSTALL_MISSING (2), FAILED_INSTALLER_BUSY (3), FAILED_REGION_NOT_INSTALLED (4), FAILED (5), UNKNOWN (6)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setFavoriteUpdateRegions\">\n"
            "      <doc>\n"
            "        <line>setFavoriteUpdateRegions = Request to change the current favorite update regions (aka home regions).</line>\n"
            "        <line>Usually the user can select a certain country as its favorite region on the HMI.</line>\n"
            "        <line>Selected country can consists of one or more update regions. All update regions relates to the same product.</line>\n"
            "        <line>In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"productId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>productId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"supplierId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>supplierId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"baselineMapId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>baselineMapId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"updateRegionIds\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>updateRegionIds = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result (of type SetFavoriteUpdateRegionsResult) = Description missing</line>\n"
            "          <line>enum[OK (0), FAILED_UPDATE_REGION_NOT_AVAILABLE (1), FAILED (2)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"clearFavoriteUpdateRegions\">\n"
            "      <doc>\n"
            "        <line>clearFavoriteUpdateRegions = Request to remove current favorite region setting.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result (of type ClearFavoriteUpdateRegionsResult) = Description missing</line>\n"
            "          <line>enum[OK (0), FAILED_NOT_ALLOWED (1), FAILED (2)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"startFullUpdate\">\n"
            "      <doc>\n"
            "        <line>startFullUpdate = Request to install a full navigation data update if USB full update data is available.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result (of type StartFullUpdateResult) = Description missing</line>\n"
            "          <line>enum[ACCEPTED (0), DECLINED__NO_FULL_UPDATE_AVAILABLE (1), DECLINED__SUBSCRIPTION_EXPIRED (2), DECLINED__BUSY (3), DECLINED (4)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartMapDataExport\">\n"
            "      <doc>\n"
            "        <line>StartMapDataExport = Start MapData Export For A Device ID</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"deviceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>deviceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"deviceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>deviceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void NavigationDataUpdateServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NavigationDataUpdateServiceStub*>(getStub()))->onGetAll (properties);
}

void NavigationDataUpdateServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "favoriteUpdateRegions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "installationStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "navDataStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "navDataContext");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "navigationDataUpdateStatusInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "catalogueStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "mapupdateExportStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "deviceInfos");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NavigationDataUpdateServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "favoriteUpdateRegions");
            ::boost::shared_ptr< FavoriteUpdateRegionsGet > payload(new FavoriteUpdateRegionsGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onFavoriteUpdateRegionsGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "installationStatus");
            ::boost::shared_ptr< InstallationStatusGet > payload(new InstallationStatusGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onInstallationStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "navDataStatus");
            ::boost::shared_ptr< NavDataStatusGet > payload(new NavDataStatusGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onNavDataStatusGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "navDataContext");
            ::boost::shared_ptr< NavDataContextGet > payload(new NavDataContextGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onNavDataContextGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "navigationDataUpdateStatusInfo");
            ::boost::shared_ptr< NavigationDataUpdateStatusInfoGet > payload(new NavigationDataUpdateStatusInfoGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onNavigationDataUpdateStatusInfoGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "catalogueStatus");
            ::boost::shared_ptr< CatalogueStatusGet > payload(new CatalogueStatusGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onCatalogueStatusGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "mapupdateExportStatus");
            ::boost::shared_ptr< MapupdateExportStatusGet > payload(new MapupdateExportStatusGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onMapupdateExportStatusGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "deviceInfos");
            ::boost::shared_ptr< DeviceInfosGet > payload(new DeviceInfosGet());
            payload->setAct(act);
            static_cast<NavigationDataUpdateServiceStub*>(getStub())->onDeviceInfosGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NavigationDataUpdateServiceStub::NavigationDataUpdateServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationDataUpdateServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationDataUpdateServiceStub::NavigationDataUpdateServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationDataUpdateServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationDataUpdateServiceStub::~NavigationDataUpdateServiceStub() {
    delete _stubDelegate;
}

void NavigationDataUpdateServiceStub::sendFavoriteUpdateRegionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FavoriteUpdateRegionsUpdate payload(_favoriteUpdateRegionsProperty);

        LOG_INFO ("-> send%s", "FavoriteUpdateRegionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("favoriteUpdateRegions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FavoriteUpdateRegionsUpdate");
    }
}

void NavigationDataUpdateServiceStub::onFavoriteUpdateRegionsGet(const ::boost::shared_ptr< FavoriteUpdateRegionsGet >& favoriteUpdateRegions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FavoriteUpdateRegionsGet", favoriteUpdateRegions->getAct());
    sendFavoriteUpdateRegionsGetUpdate(_favoriteUpdateRegionsProperty.getFavoriteUpdateRegions(), favoriteUpdateRegions->getAct());
}

void NavigationDataUpdateServiceStub::sendFavoriteUpdateRegionsGetUpdate(const FavoriteUpdateRegions& favoriteUpdateRegions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FavoriteUpdateRegionsGet payload(favoriteUpdateRegions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FavoriteUpdateRegionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setFavoriteUpdateRegions(const FavoriteUpdateRegions& favoriteUpdateRegions) {
    if(favoriteUpdateRegions!=_favoriteUpdateRegionsProperty.getFavoriteUpdateRegions()) {
        _favoriteUpdateRegionsProperty.setFavoriteUpdateRegions(favoriteUpdateRegions);
        sendFavoriteUpdateRegionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const FavoriteUpdateRegions& NavigationDataUpdateServiceStub::getFavoriteUpdateRegions() const {
    return _favoriteUpdateRegionsProperty.getFavoriteUpdateRegions();
}

FavoriteUpdateRegions& NavigationDataUpdateServiceStub::getFavoriteUpdateRegionsMutable() {
    return _favoriteUpdateRegionsProperty.getFavoriteUpdateRegionsMutable();
}

void NavigationDataUpdateServiceStub::sendInstallationStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InstallationStatusUpdate payload(_installationStatusProperty);

        LOG_INFO ("-> send%s", "InstallationStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("installationStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InstallationStatusUpdate");
    }
}

void NavigationDataUpdateServiceStub::onInstallationStatusGet(const ::boost::shared_ptr< InstallationStatusGet >& installationStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InstallationStatusGet", installationStatus->getAct());
    sendInstallationStatusGetUpdate(_installationStatusProperty.getInstallationStatus(), installationStatus->getAct());
}

void NavigationDataUpdateServiceStub::sendInstallationStatusGetUpdate(const InstallationStatus& installationStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InstallationStatusGet payload(installationStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InstallationStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setInstallationStatus(const InstallationStatus& installationStatus) {
    if(installationStatus!=_installationStatusProperty.getInstallationStatus()) {
        _installationStatusProperty.setInstallationStatus(installationStatus);
        sendInstallationStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const InstallationStatus& NavigationDataUpdateServiceStub::getInstallationStatus() const {
    return _installationStatusProperty.getInstallationStatus();
}

InstallationStatus& NavigationDataUpdateServiceStub::getInstallationStatusMutable() {
    return _installationStatusProperty.getInstallationStatusMutable();
}

void NavigationDataUpdateServiceStub::sendNavDataStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NavDataStatusUpdate payload(_navDataStatusProperty);

        LOG_INFO ("-> send%s", "NavDataStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("navDataStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NavDataStatusUpdate");
    }
}

void NavigationDataUpdateServiceStub::onNavDataStatusGet(const ::boost::shared_ptr< NavDataStatusGet >& navDataStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NavDataStatusGet", navDataStatus->getAct());
    sendNavDataStatusGetUpdate(_navDataStatusProperty.getNavDataStatus(), navDataStatus->getAct());
}

void NavigationDataUpdateServiceStub::sendNavDataStatusGetUpdate(NavigationDataStatus navDataStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NavDataStatusGet payload(navDataStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NavDataStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setNavDataStatus(NavigationDataStatus navDataStatus) {
    if(navDataStatus!=_navDataStatusProperty.getNavDataStatus()) {
        _navDataStatusProperty.setNavDataStatus(navDataStatus);
        sendNavDataStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

NavigationDataStatus NavigationDataUpdateServiceStub::getNavDataStatus() const {
    return _navDataStatusProperty.getNavDataStatus();
}

void NavigationDataUpdateServiceStub::sendNavDataContextUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NavDataContextUpdate payload(_navDataContextProperty);

        LOG_INFO ("-> send%s", "NavDataContextUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("navDataContext", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NavDataContextUpdate");
    }
}

void NavigationDataUpdateServiceStub::onNavDataContextGet(const ::boost::shared_ptr< NavDataContextGet >& navDataContext) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NavDataContextGet", navDataContext->getAct());
    sendNavDataContextGetUpdate(_navDataContextProperty.getNavDataContext(), navDataContext->getAct());
}

void NavigationDataUpdateServiceStub::sendNavDataContextGetUpdate(const NavDataContext& navDataContext, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NavDataContextGet payload(navDataContext);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NavDataContextGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setNavDataContext(const NavDataContext& navDataContext) {
    if(navDataContext!=_navDataContextProperty.getNavDataContext()) {
        _navDataContextProperty.setNavDataContext(navDataContext);
        sendNavDataContextUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const NavDataContext& NavigationDataUpdateServiceStub::getNavDataContext() const {
    return _navDataContextProperty.getNavDataContext();
}

NavDataContext& NavigationDataUpdateServiceStub::getNavDataContextMutable() {
    return _navDataContextProperty.getNavDataContextMutable();
}

void NavigationDataUpdateServiceStub::sendNavigationDataUpdateStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NavigationDataUpdateStatusInfoUpdate payload(_navigationDataUpdateStatusInfoProperty);

        LOG_INFO ("-> send%s", "NavigationDataUpdateStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("navigationDataUpdateStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NavigationDataUpdateStatusInfoUpdate");
    }
}

void NavigationDataUpdateServiceStub::onNavigationDataUpdateStatusInfoGet(const ::boost::shared_ptr< NavigationDataUpdateStatusInfoGet >& navigationDataUpdateStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NavigationDataUpdateStatusInfoGet", navigationDataUpdateStatusInfo->getAct());
    sendNavigationDataUpdateStatusInfoGetUpdate(_navigationDataUpdateStatusInfoProperty.getNavigationDataUpdateStatusInfo(), navigationDataUpdateStatusInfo->getAct());
}

void NavigationDataUpdateServiceStub::sendNavigationDataUpdateStatusInfoGetUpdate(const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NavigationDataUpdateStatusInfoGet payload(navigationDataUpdateStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NavigationDataUpdateStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setNavigationDataUpdateStatusInfo(const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo) {
    if(navigationDataUpdateStatusInfo!=_navigationDataUpdateStatusInfoProperty.getNavigationDataUpdateStatusInfo()) {
        _navigationDataUpdateStatusInfoProperty.setNavigationDataUpdateStatusInfo(navigationDataUpdateStatusInfo);
        sendNavigationDataUpdateStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const NavigationDataUpdateStatusInfo& NavigationDataUpdateServiceStub::getNavigationDataUpdateStatusInfo() const {
    return _navigationDataUpdateStatusInfoProperty.getNavigationDataUpdateStatusInfo();
}

NavigationDataUpdateStatusInfo& NavigationDataUpdateServiceStub::getNavigationDataUpdateStatusInfoMutable() {
    return _navigationDataUpdateStatusInfoProperty.getNavigationDataUpdateStatusInfoMutable();
}

void NavigationDataUpdateServiceStub::sendCatalogueStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CatalogueStatusUpdate payload(_catalogueStatusProperty);

        LOG_INFO ("-> send%s", "CatalogueStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("catalogueStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CatalogueStatusUpdate");
    }
}

void NavigationDataUpdateServiceStub::onCatalogueStatusGet(const ::boost::shared_ptr< CatalogueStatusGet >& catalogueStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CatalogueStatusGet", catalogueStatus->getAct());
    sendCatalogueStatusGetUpdate(_catalogueStatusProperty.getCatalogueStatus(), catalogueStatus->getAct());
}

void NavigationDataUpdateServiceStub::sendCatalogueStatusGetUpdate(CatalogueStatus catalogueStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CatalogueStatusGet payload(catalogueStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CatalogueStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setCatalogueStatus(CatalogueStatus catalogueStatus) {
    if(catalogueStatus!=_catalogueStatusProperty.getCatalogueStatus()) {
        _catalogueStatusProperty.setCatalogueStatus(catalogueStatus);
        sendCatalogueStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

CatalogueStatus NavigationDataUpdateServiceStub::getCatalogueStatus() const {
    return _catalogueStatusProperty.getCatalogueStatus();
}

void NavigationDataUpdateServiceStub::sendMapupdateExportStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapupdateExportStatusUpdate payload(_mapupdateExportStatusProperty);

        LOG_INFO ("-> send%s", "MapupdateExportStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("mapupdateExportStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapupdateExportStatusUpdate");
    }
}

void NavigationDataUpdateServiceStub::onMapupdateExportStatusGet(const ::boost::shared_ptr< MapupdateExportStatusGet >& mapupdateExportStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapupdateExportStatusGet", mapupdateExportStatus->getAct());
    sendMapupdateExportStatusGetUpdate(_mapupdateExportStatusProperty.getMapupdateExportStatus(), mapupdateExportStatus->getAct());
}

void NavigationDataUpdateServiceStub::sendMapupdateExportStatusGetUpdate(MapupdateExportStatus mapupdateExportStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapupdateExportStatusGet payload(mapupdateExportStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapupdateExportStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setMapupdateExportStatus(MapupdateExportStatus mapupdateExportStatus) {
    if(mapupdateExportStatus!=_mapupdateExportStatusProperty.getMapupdateExportStatus()) {
        _mapupdateExportStatusProperty.setMapupdateExportStatus(mapupdateExportStatus);
        sendMapupdateExportStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

MapupdateExportStatus NavigationDataUpdateServiceStub::getMapupdateExportStatus() const {
    return _mapupdateExportStatusProperty.getMapupdateExportStatus();
}

void NavigationDataUpdateServiceStub::sendDeviceInfosUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceInfosUpdate payload(_deviceInfosProperty);

        LOG_INFO ("-> send%s", "DeviceInfosUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("deviceInfos", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationDataUpdateService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceInfosUpdate");
    }
}

void NavigationDataUpdateServiceStub::onDeviceInfosGet(const ::boost::shared_ptr< DeviceInfosGet >& deviceInfos) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceInfosGet", deviceInfos->getAct());
    sendDeviceInfosGetUpdate(_deviceInfosProperty.getDeviceInfos(), deviceInfos->getAct());
}

void NavigationDataUpdateServiceStub::sendDeviceInfosGetUpdate(const ::std::vector< DeviceInfo >& deviceInfos, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceInfosGet payload(deviceInfos);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceInfosGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationDataUpdateServiceStub::setDeviceInfos(const ::std::vector< DeviceInfo >& deviceInfos) {
    if(deviceInfos!=_deviceInfosProperty.getDeviceInfos()) {
        _deviceInfosProperty.setDeviceInfos(deviceInfos);
        sendDeviceInfosUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< DeviceInfo >& NavigationDataUpdateServiceStub::getDeviceInfos() const {
    return _deviceInfosProperty.getDeviceInfos();
}

::std::vector< DeviceInfo >& NavigationDataUpdateServiceStub::getDeviceInfosMutable() {
    return _deviceInfosProperty.getDeviceInfosMutable();
}

void  NavigationDataUpdateServiceStub::sendDiagPerformFullUpdateViaUSBResponse (NavigationDataUpdateServiceAck ack, act_t act) {
    DiagPerformFullUpdateViaUSBResponse* payload = new DiagPerformFullUpdateViaUSBResponse(ack);
    DBUS_MESSAGE_REPLY(dbusMessage, "DiagPerformFullUpdateViaUSB", DiagPerformFullUpdateViaUSBResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DiagPerformFullUpdateViaUSB", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendDiagPerformFullUpdateViaUSBError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DiagPerformFullUpdateViaUSBError* payload = new DiagPerformFullUpdateViaUSBError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DiagPerformFullUpdateViaUSB", DiagPerformFullUpdateViaUSBError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DiagPerformFullUpdateViaUSB", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendGetAvailableUpdatesResponse (const AvailableUpdates& availableUpdates, act_t act) {
    GetAvailableUpdatesResponse* payload = new GetAvailableUpdatesResponse(availableUpdates);
    DBUS_MESSAGE_REPLY(dbusMessage, "getAvailableUpdates", GetAvailableUpdatesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAvailableUpdates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendGetAvailableUpdatesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAvailableUpdatesError* payload = new GetAvailableUpdatesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getAvailableUpdates", GetAvailableUpdatesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAvailableUpdates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendDeleteUpdateComponentResponse (DeleteUpdateComponentResult result, act_t act) {
    DeleteUpdateComponentResponse* payload = new DeleteUpdateComponentResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "deleteUpdateComponent", DeleteUpdateComponentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeleteUpdateComponent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendDeleteUpdateComponentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeleteUpdateComponentError* payload = new DeleteUpdateComponentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "deleteUpdateComponent", DeleteUpdateComponentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeleteUpdateComponent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendSetFavoriteUpdateRegionsResponse (SetFavoriteUpdateRegionsResult result, act_t act) {
    SetFavoriteUpdateRegionsResponse* payload = new SetFavoriteUpdateRegionsResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "setFavoriteUpdateRegions", SetFavoriteUpdateRegionsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetFavoriteUpdateRegions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendSetFavoriteUpdateRegionsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetFavoriteUpdateRegionsError* payload = new SetFavoriteUpdateRegionsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setFavoriteUpdateRegions", SetFavoriteUpdateRegionsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetFavoriteUpdateRegions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendClearFavoriteUpdateRegionsResponse (ClearFavoriteUpdateRegionsResult result, act_t act) {
    ClearFavoriteUpdateRegionsResponse* payload = new ClearFavoriteUpdateRegionsResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "clearFavoriteUpdateRegions", ClearFavoriteUpdateRegionsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClearFavoriteUpdateRegions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendClearFavoriteUpdateRegionsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClearFavoriteUpdateRegionsError* payload = new ClearFavoriteUpdateRegionsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "clearFavoriteUpdateRegions", ClearFavoriteUpdateRegionsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClearFavoriteUpdateRegions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendStartFullUpdateResponse (StartFullUpdateResult result, act_t act) {
    StartFullUpdateResponse* payload = new StartFullUpdateResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "startFullUpdate", StartFullUpdateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartFullUpdate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendStartFullUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartFullUpdateError* payload = new StartFullUpdateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startFullUpdate", StartFullUpdateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartFullUpdate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendStartMapDataExportResponse (MapExportStartStatus result, act_t act) {
    StartMapDataExportResponse* payload = new StartMapDataExportResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartMapDataExport", StartMapDataExportResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartMapDataExport", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationDataUpdateServiceStub::sendStartMapDataExportError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartMapDataExportError* payload = new StartMapDataExportError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartMapDataExport", StartMapDataExportError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartMapDataExport", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NavigationDataUpdateServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'favoriteUpdateRegions'
    {
        ::asf::dbus::DBusVariant variant;
        FavoriteUpdateRegionsGet payload(_favoriteUpdateRegionsProperty.getFavoriteUpdateRegions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("favoriteUpdateRegions", variant));
    }

    //property 'installationStatus'
    {
        ::asf::dbus::DBusVariant variant;
        InstallationStatusGet payload(_installationStatusProperty.getInstallationStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("installationStatus", variant));
    }

    //property 'navDataStatus'
    {
        ::asf::dbus::DBusVariant variant;
        NavDataStatusGet payload(_navDataStatusProperty.getNavDataStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("navDataStatus", variant));
    }

    //property 'navDataContext'
    {
        ::asf::dbus::DBusVariant variant;
        NavDataContextGet payload(_navDataContextProperty.getNavDataContext());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("navDataContext", variant));
    }

    //property 'navigationDataUpdateStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        NavigationDataUpdateStatusInfoGet payload(_navigationDataUpdateStatusInfoProperty.getNavigationDataUpdateStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("navigationDataUpdateStatusInfo", variant));
    }

    //property 'catalogueStatus'
    {
        ::asf::dbus::DBusVariant variant;
        CatalogueStatusGet payload(_catalogueStatusProperty.getCatalogueStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("catalogueStatus", variant));
    }

    //property 'mapupdateExportStatus'
    {
        ::asf::dbus::DBusVariant variant;
        MapupdateExportStatusGet payload(_mapupdateExportStatusProperty.getMapupdateExportStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("mapupdateExportStatus", variant));
    }

    //property 'deviceInfos'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceInfosGet payload(_deviceInfosProperty.getDeviceInfos());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("deviceInfos", variant));
    }
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
