/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICEPROXY_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

class NavigationDataUpdateServiceProxy;

class CatalogueStatusCallbackIF {
public:
    virtual ~CatalogueStatusCallbackIF() {}

    virtual void onCatalogueStatusError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< CatalogueStatusError >& error) = 0;

    virtual void onCatalogueStatusUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< CatalogueStatusUpdate >& update) = 0;
};

class ClearFavoriteUpdateRegionsCallbackIF {
public:
    virtual ~ClearFavoriteUpdateRegionsCallbackIF() {}

    virtual void onClearFavoriteUpdateRegionsError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< ClearFavoriteUpdateRegionsError >& error) = 0;

    virtual void onClearFavoriteUpdateRegionsResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< ClearFavoriteUpdateRegionsResponse >& response) = 0;
};

class DeleteUpdateComponentCallbackIF {
public:
    virtual ~DeleteUpdateComponentCallbackIF() {}

    virtual void onDeleteUpdateComponentError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DeleteUpdateComponentError >& error) = 0;

    virtual void onDeleteUpdateComponentResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DeleteUpdateComponentResponse >& response) = 0;
};

class DeviceInfosCallbackIF {
public:
    virtual ~DeviceInfosCallbackIF() {}

    virtual void onDeviceInfosError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DeviceInfosError >& error) = 0;

    virtual void onDeviceInfosUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DeviceInfosUpdate >& update) = 0;
};

class DiagPerformFullUpdateViaUSBCallbackIF {
public:
    virtual ~DiagPerformFullUpdateViaUSBCallbackIF() {}

    virtual void onDiagPerformFullUpdateViaUSBError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBError >& error) = 0;

    virtual void onDiagPerformFullUpdateViaUSBResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBResponse >& response) = 0;
};

class FavoriteUpdateRegionsCallbackIF {
public:
    virtual ~FavoriteUpdateRegionsCallbackIF() {}

    virtual void onFavoriteUpdateRegionsError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< FavoriteUpdateRegionsError >& error) = 0;

    virtual void onFavoriteUpdateRegionsUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< FavoriteUpdateRegionsUpdate >& update) = 0;
};

class GetAvailableUpdatesCallbackIF {
public:
    virtual ~GetAvailableUpdatesCallbackIF() {}

    virtual void onGetAvailableUpdatesError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailableUpdatesError >& error) = 0;

    virtual void onGetAvailableUpdatesResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailableUpdatesResponse >& response) = 0;
};

class InstallationStatusCallbackIF {
public:
    virtual ~InstallationStatusCallbackIF() {}

    virtual void onInstallationStatusError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< InstallationStatusError >& error) = 0;

    virtual void onInstallationStatusUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< InstallationStatusUpdate >& update) = 0;
};

class MapupdateExportStatusCallbackIF {
public:
    virtual ~MapupdateExportStatusCallbackIF() {}

    virtual void onMapupdateExportStatusError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< MapupdateExportStatusError >& error) = 0;

    virtual void onMapupdateExportStatusUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< MapupdateExportStatusUpdate >& update) = 0;
};

class NavDataContextCallbackIF {
public:
    virtual ~NavDataContextCallbackIF() {}

    virtual void onNavDataContextError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavDataContextError >& error) = 0;

    virtual void onNavDataContextUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavDataContextUpdate >& update) = 0;
};

class NavDataStatusCallbackIF {
public:
    virtual ~NavDataStatusCallbackIF() {}

    virtual void onNavDataStatusError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavDataStatusError >& error) = 0;

    virtual void onNavDataStatusUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavDataStatusUpdate >& update) = 0;
};

class NavigationDataUpdateStatusInfoCallbackIF {
public:
    virtual ~NavigationDataUpdateStatusInfoCallbackIF() {}

    virtual void onNavigationDataUpdateStatusInfoError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoError >& error) = 0;

    virtual void onNavigationDataUpdateStatusInfoUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoUpdate >& update) = 0;
};

class SetFavoriteUpdateRegionsCallbackIF {
public:
    virtual ~SetFavoriteUpdateRegionsCallbackIF() {}

    virtual void onSetFavoriteUpdateRegionsError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< SetFavoriteUpdateRegionsError >& error) = 0;

    virtual void onSetFavoriteUpdateRegionsResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< SetFavoriteUpdateRegionsResponse >& response) = 0;
};

class StartFullUpdateCallbackIF {
public:
    virtual ~StartFullUpdateCallbackIF() {}

    virtual void onStartFullUpdateError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< StartFullUpdateError >& error) = 0;

    virtual void onStartFullUpdateResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< StartFullUpdateResponse >& response) = 0;
};

class StartMapDataExportCallbackIF {
public:
    virtual ~StartMapDataExportCallbackIF() {}

    virtual void onStartMapDataExportError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< StartMapDataExportError >& error) = 0;

    virtual void onStartMapDataExportResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< StartMapDataExportResponse >& response) = 0;
};


/**
 * NavigationDataUpdateServiceProxy is the client side representation of
 * the D-Bus service interface
 * 'org.bosch.cm.navigation.NavigationDataUpdateService' (specified in
 * file NavigationDataUpdateService_.xml).
 *
 * If the meaning of "org.bosch.cm.navigation.NavigationDataUpdateService" isn't clear, then there should be a description here.
 */
class NavigationDataUpdateServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of NavigationDataUpdateServiceProxy.
     */
    static ::boost::shared_ptr< NavigationDataUpdateServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of NavigationDataUpdateServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< NavigationDataUpdateServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of NavigationDataUpdateServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< NavigationDataUpdateServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< NavigationDataUpdateServiceProxy > proxyNew(new NavigationDataUpdateServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~NavigationDataUpdateServiceProxy ();



    // Property 'favoriteUpdateRegions'

    /**
     * Notify on the property 'favoriteUpdateRegions'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFavoriteUpdateRegionsRegister(FavoriteUpdateRegionsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'favoriteUpdateRegions'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @param act The act which was previously returned by the
     * sendFavoriteUpdateRegionsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFavoriteUpdateRegionsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'favoriteUpdateRegions'.
     */
    void sendFavoriteUpdateRegionsDeregisterAll() const;

    /**
     * Request the value of the property 'favoriteUpdateRegions' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFavoriteUpdateRegionsGet(FavoriteUpdateRegionsCallbackIF& cb);


    /**
     * Returns the current value of the property 'favoriteUpdateRegions' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFavoriteUpdateRegions() returns true.
     *
     * @return the previously received value of the property 'favoriteUpdateRegions'.
     */
    const FavoriteUpdateRegions& getFavoriteUpdateRegions() const;

    /**
     * Determines whether a status message for the property
     * 'favoriteUpdateRegions' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFavoriteUpdateRegions() const;

    // Property 'installationStatus'

    /**
     * Notify on the property 'installationStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstallationStatusRegister(InstallationStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'installationStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     *
     * @param act The act which was previously returned by the
     * sendInstallationStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInstallationStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'installationStatus'.
     */
    void sendInstallationStatusDeregisterAll() const;

    /**
     * Request the value of the property 'installationStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstallationStatusGet(InstallationStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'installationStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasInstallationStatus() returns true.
     *
     * @return the previously received value of the property 'installationStatus'.
     */
    const InstallationStatus& getInstallationStatus() const;

    /**
     * Determines whether a status message for the property
     * 'installationStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInstallationStatus() const;

    // Property 'navDataStatus'

    /**
     * Notify on the property 'navDataStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavDataStatusRegister(NavDataStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'navDataStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @param act The act which was previously returned by the
     * sendNavDataStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNavDataStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'navDataStatus'.
     */
    void sendNavDataStatusDeregisterAll() const;

    /**
     * Request the value of the property 'navDataStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavDataStatusGet(NavDataStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'navDataStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNavDataStatus() returns true.
     *
     * @return the previously received value of the property 'navDataStatus'.
     */
    NavigationDataStatus getNavDataStatus() const;

    /**
     * Determines whether a status message for the property 'navDataStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavDataStatus() const;

    // Property 'navDataContext'

    /**
     * Notify on the property 'navDataContext'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavDataContextRegister(NavDataContextCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'navDataContext'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @param act The act which was previously returned by the
     * sendNavDataContextRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNavDataContextDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'navDataContext'.
     */
    void sendNavDataContextDeregisterAll() const;

    /**
     * Request the value of the property 'navDataContext' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavDataContextGet(NavDataContextCallbackIF& cb);


    /**
     * Returns the current value of the property 'navDataContext' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNavDataContext() returns true.
     *
     * @return the previously received value of the property 'navDataContext'.
     */
    const NavDataContext& getNavDataContext() const;

    /**
     * Determines whether a status message for the property 'navDataContext'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavDataContext() const;

    // Property 'navigationDataUpdateStatusInfo'

    /**
     * Notify on the property 'navigationDataUpdateStatusInfo'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationDataUpdateStatusInfoRegister(NavigationDataUpdateStatusInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'navigationDataUpdateStatusInfo'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @param act The act which was previously returned by the
     * sendNavigationDataUpdateStatusInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNavigationDataUpdateStatusInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'navigationDataUpdateStatusInfo'.
     */
    void sendNavigationDataUpdateStatusInfoDeregisterAll() const;

    /**
     * Request the value of the property 'navigationDataUpdateStatusInfo' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationDataUpdateStatusInfoGet(NavigationDataUpdateStatusInfoCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'navigationDataUpdateStatusInfo' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasNavigationDataUpdateStatusInfo() returns true.
     *
     * @return the previously received value of the property 'navigationDataUpdateStatusInfo'.
     */
    const NavigationDataUpdateStatusInfo& getNavigationDataUpdateStatusInfo() const;

    /**
     * Determines whether a status message for the property
     * 'navigationDataUpdateStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavigationDataUpdateStatusInfo() const;

    // Property 'catalogueStatus'

    /**
     * Notify on the property 'catalogueStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCatalogueStatusRegister(CatalogueStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'catalogueStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     *
     * @param act The act which was previously returned by the
     * sendCatalogueStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCatalogueStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'catalogueStatus'.
     */
    void sendCatalogueStatusDeregisterAll() const;

    /**
     * Request the value of the property 'catalogueStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCatalogueStatusGet(CatalogueStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'catalogueStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCatalogueStatus() returns true.
     *
     * @return the previously received value of the property 'catalogueStatus'.
     */
    CatalogueStatus getCatalogueStatus() const;

    /**
     * Determines whether a status message for the property 'catalogueStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCatalogueStatus() const;

    // Property 'mapupdateExportStatus'

    /**
     * Notify on the property 'mapupdateExportStatus'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapupdateExportStatusRegister(MapupdateExportStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'mapupdateExportStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     *
     * @param act The act which was previously returned by the
     * sendMapupdateExportStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMapupdateExportStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'mapupdateExportStatus'.
     */
    void sendMapupdateExportStatusDeregisterAll() const;

    /**
     * Request the value of the property 'mapupdateExportStatus' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapupdateExportStatusGet(MapupdateExportStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'mapupdateExportStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMapupdateExportStatus() returns true.
     *
     * @return the previously received value of the property 'mapupdateExportStatus'.
     */
    MapupdateExportStatus getMapupdateExportStatus() const;

    /**
     * Determines whether a status message for the property
     * 'mapupdateExportStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMapupdateExportStatus() const;

    // Property 'deviceInfos'

    /**
     * Notify on the property 'deviceInfos'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceInfosRegister(DeviceInfosCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'deviceInfos'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     *
     * @param act The act which was previously returned by the
     * sendDeviceInfosRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceInfosDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'deviceInfos'.
     */
    void sendDeviceInfosDeregisterAll() const;

    /**
     * Request the value of the property 'deviceInfos' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceInfosGet(DeviceInfosCallbackIF& cb);


    /**
     * Returns the current value of the property 'deviceInfos' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDeviceInfos() returns true.
     *
     * @return the previously received value of the property 'deviceInfos'.
     */
    const ::std::vector< DeviceInfo >& getDeviceInfos() const;

    /**
     * Determines whether a status message for the property 'deviceInfos' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceInfos() const;


    // Method 'DiagPerformFullUpdateViaUSB'

    /**
     * Call the method 'DiagPerformFullUpdateViaUSB'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'DiagPerformFullUpdateViaUSB'</b>:
     *
     * Diagnosis request full update via USB in Diagnostic mode
     *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagPerformFullUpdateViaUSBRequest(DiagPerformFullUpdateViaUSBCallbackIF& cb) const;

    // Method 'getAvailableUpdates'

    /**
     * Call the method 'getAvailableUpdates'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'getAvailableUpdates'</b>:
     *
     * Request to get a list of all available updates.
     *        For each update component one entry is contained if an update is available only.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAvailableUpdatesRequest(GetAvailableUpdatesCallbackIF& cb) const;

    // Method 'deleteUpdateComponent'

    /**
     * Call the method 'deleteUpdateComponent'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'deleteUpdateComponent'</b>:
     *
     * Request to remove an updateable component from the data.
     *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param productId If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param supplierId If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param regionId If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteUpdateComponentRequest(DeleteUpdateComponentCallbackIF& cb, uint32 productId, uint32 supplierId, const ::std::vector< uint32 >& regionId) const;

    // Method 'setFavoriteUpdateRegions'

    /**
     * Call the method 'setFavoriteUpdateRegions'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'setFavoriteUpdateRegions'</b>:
     *
     * Request to change the current favorite update regions (aka home regions).
     *        Usually the user can select a certain country as its favorite region on the HMI.
     *        Selected country can consists of one or more update regions. All update regions relates to the same product.
     *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param productId If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param supplierId If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param baselineMapId If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @param updateRegionIds If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFavoriteUpdateRegionsRequest(SetFavoriteUpdateRegionsCallbackIF& cb, uint32 productId, uint32 supplierId, uint32 baselineMapId, const ::std::vector< uint32 >& updateRegionIds) const;

    // Method 'clearFavoriteUpdateRegions'

    /**
     * Call the method 'clearFavoriteUpdateRegions'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'clearFavoriteUpdateRegions'</b>:
     *
     * Request to remove current favorite region setting.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearFavoriteUpdateRegionsRequest(ClearFavoriteUpdateRegionsCallbackIF& cb) const;

    // Method 'startFullUpdate'

    /**
     * Call the method 'startFullUpdate'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'startFullUpdate'</b>:
     *
     * Request to install a full navigation data update if USB full update data is available.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartFullUpdateRequest(StartFullUpdateCallbackIF& cb) const;

    // Method 'StartMapDataExport'

    /**
     * Call the method 'StartMapDataExport'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'StartMapDataExport'</b>:
     *
     * Start MapData Export For A Device ID
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param deviceId If the meaning of "deviceId" isn't clear, then there should be a description here.
     *
     * @param deviceType If the meaning of "deviceType" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartMapDataExportRequest(StartMapDataExportCallbackIF& cb, uint32 deviceId, Devicetype deviceType) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    NavigationDataUpdateServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'favoriteUpdateRegions'

    ::asf::core::nullable< FavoriteUpdateRegionsUpdate > _favoriteUpdateRegions;

    // Property 'installationStatus'

    ::asf::core::nullable< InstallationStatusUpdate > _installationStatus;

    // Property 'navDataStatus'

    ::asf::core::nullable< NavDataStatusUpdate > _navDataStatus;

    // Property 'navDataContext'

    ::asf::core::nullable< NavDataContextUpdate > _navDataContext;

    // Property 'navigationDataUpdateStatusInfo'

    ::asf::core::nullable< NavigationDataUpdateStatusInfoUpdate > _navigationDataUpdateStatusInfo;

    // Property 'catalogueStatus'

    ::asf::core::nullable< CatalogueStatusUpdate > _catalogueStatus;

    // Property 'mapupdateExportStatus'

    ::asf::core::nullable< MapupdateExportStatusUpdate > _mapupdateExportStatus;

    // Property 'deviceInfos'

    ::asf::core::nullable< DeviceInfosUpdate > _deviceInfos;

    DECLARE_CLASS_LOGGER();

    friend class NavigationDataUpdateServiceProxyCallback;
};

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICEPROXY_H
