/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceJson.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "FavoriteUpdateRegionData"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasBaselineMapId()) {
        yajl_gen_string(g, (const unsigned char*)  "baselineMapId" , 13);
        yajl_gen_integer(g, (long long)value.getBaselineMapId());
    }
    if (!isSparse || value.hasUpdateRegionIds()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegionIds" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o1 = value.getUpdateRegionIds();
        {
            ::std::vector< uint32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FavoriteUpdateRegions"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFavoriteUpdateRegionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "favoriteUpdateRegionStatus" , 26);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus_Name(value.getFavoriteUpdateRegionStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFavoriteUpdateRegionStatus());
    }
    if (!isSparse || value.hasFavoriteUpdateRegions()) {
        yajl_gen_string(g, (const unsigned char*)  "favoriteUpdateRegions" , 21);
        serializeJson(value.getFavoriteUpdateRegions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationDataUpdateStatusInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasProgressValue()) {
        yajl_gen_string(g, (const unsigned char*)  "progressValue" , 13);
        yajl_gen_integer(g, (long long)value.getProgressValue());
    }
    if (!isSparse || value.hasRemainingTimeInSecond()) {
        yajl_gen_string(g, (const unsigned char*)  "remainingTimeInSecond" , 21);
        yajl_gen_integer(g, (long long)value.getRemainingTimeInSecond());
    }
    if (!isSparse || value.hasProductName()) {
        yajl_gen_string(g, (const unsigned char*)  "productName" , 11);
        const char *s = value.getProductName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRegionName()) {
        yajl_gen_string(g, (const unsigned char*)  "regionName" , 10);
        const char *s = value.getRegionName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InstallationStatus"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "regionId" , 8);
        yajl_gen_integer(g, (long long)value.getRegionId());
    }
    if (!isSparse || value.hasUpdateStep()) {
        yajl_gen_string(g, (const unsigned char*)  "updateStep" , 10);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep_Name(value.getUpdateStep());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUpdateStep());
    }
    if (!isSparse || value.hasPercentage()) {
        yajl_gen_string(g, (const unsigned char*)  "percentage" , 10);
        yajl_gen_integer(g, (long long)value.getPercentage());
    }
    if (!isSparse || value.hasIsProductUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "isProductUpdate" , 15);
        yajl_gen_bool(g, (bool)value.getIsProductUpdate());
    }
    if (!isSparse || value.hasProductName()) {
        yajl_gen_string(g, (const unsigned char*)  "productName" , 11);
        const char *s = value.getProductName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRegionName()) {
        yajl_gen_string(g, (const unsigned char*)  "regionName" , 10);
        const char *s = value.getRegionName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StorageSpace"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpaceTotalInBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "spaceTotalInBytes" , 17);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSpaceTotalInBytes(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasSpaceLeftInBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "spaceLeftInBytes" , 16);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getSpaceLeftInBytes(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateDescription"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateVersionId()) {
        yajl_gen_string(g, (const unsigned char*)  "updateVersionId" , 15);
        yajl_gen_integer(g, (long long)value.getUpdateVersionId());
    }
    if (!isSparse || value.hasUpdateVersionDate()) {
        yajl_gen_string(g, (const unsigned char*)  "updateVersionDate" , 17);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getUpdateVersionDate(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasDownloadSizeInBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "downloadSizeInBytes" , 19);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getDownloadSizeInBytes(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasEstimatedInstallTimeInSeconds()) {
        yajl_gen_string(g, (const unsigned char*)  "estimatedInstallTimeInSeconds" , 29);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getEstimatedInstallTimeInSeconds(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateRegionVersionInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegionId" , 14);
        yajl_gen_integer(g, (long long)value.getUpdateRegionId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasUpdateDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "updateDescription" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription >& o3 = value.getUpdateDescription();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProductVersionInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasBaselineMapId()) {
        yajl_gen_string(g, (const unsigned char*)  "baselineMapId" , 13);
        yajl_gen_integer(g, (long long)value.getBaselineMapId());
    }
    if (!isSparse || value.hasUpdateRegions()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegions" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo >& o5 = value.getUpdateRegions();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableUpdates"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    if (!isSparse || value.hasProducts()) {
        yajl_gen_string(g, (const unsigned char*)  "products" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo >& o7 = value.getProducts();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateRegion"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasComponentId()) {
        yajl_gen_string(g, (const unsigned char*)  "componentId" , 11);
        const char *s = value.getComponentId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "regionId" , 8);
        yajl_gen_integer(g, (long long)value.getRegionId());
    }
    if (!isSparse || value.hasRegionName()) {
        yajl_gen_string(g, (const unsigned char*)  "regionName" , 10);
        const char *s = value.getRegionName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCurrentSizeInBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "currentSizeInBytes" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCurrentSizeInBytes(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasIsRemovable()) {
        yajl_gen_string(g, (const unsigned char*)  "isRemovable" , 11);
        yajl_gen_bool(g, (bool)value.getIsRemovable());
    }
    if (!isSparse || value.hasIsInstalled()) {
        yajl_gen_string(g, (const unsigned char*)  "isInstalled" , 11);
        yajl_gen_bool(g, (bool)value.getIsInstalled());
    }
    if (!isSparse || value.hasCurrentVersionId()) {
        yajl_gen_string(g, (const unsigned char*)  "currentVersionId" , 16);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCurrentVersionId(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasCurrentVersionDate()) {
        yajl_gen_string(g, (const unsigned char*)  "currentVersionDate" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getCurrentVersionDate(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasIsSubscriptionActive()) {
        yajl_gen_string(g, (const unsigned char*)  "isSubscriptionActive" , 20);
        yajl_gen_bool(g, (bool)value.getIsSubscriptionActive());
    }
    if (!isSparse || value.hasIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "isFavorite" , 10);
        yajl_gen_bool(g, (bool)value.getIsFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegionSet"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRegionSetId()) {
        yajl_gen_string(g, (const unsigned char*)  "regionSetId" , 11);
        yajl_gen_integer(g, (long long)value.getRegionSetId());
    }
    if (!isSparse || value.hasRegionSetName()) {
        yajl_gen_string(g, (const unsigned char*)  "regionSetName" , 13);
        const char *s = value.getRegionSetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUpdateRegionIds()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegionIds" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o9 = value.getUpdateRegionIds();
        {
            ::std::vector< uint32 >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                yajl_gen_integer(g, (long long)(*o8));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Product"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::Product& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasComponentId()) {
        yajl_gen_string(g, (const unsigned char*)  "componentId" , 11);
        const char *s = value.getComponentId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasBaselineMapId()) {
        yajl_gen_string(g, (const unsigned char*)  "baselineMapId" , 13);
        yajl_gen_integer(g, (long long)value.getBaselineMapId());
    }
    if (!isSparse || value.hasProductGroupId()) {
        yajl_gen_string(g, (const unsigned char*)  "productGroupId" , 14);
        yajl_gen_integer(g, (long long)value.getProductGroupId());
    }
    if (!isSparse || value.hasProductVersionId()) {
        yajl_gen_string(g, (const unsigned char*)  "productVersionId" , 16);
        yajl_gen_integer(g, (long long)value.getProductVersionId());
    }
    if (!isSparse || value.hasProductVersionIsDirty()) {
        yajl_gen_string(g, (const unsigned char*)  "productVersionIsDirty" , 21);
        yajl_gen_bool(g, (bool)value.getProductVersionIsDirty());
    }
    if (!isSparse || value.hasProductVersionDate()) {
        yajl_gen_string(g, (const unsigned char*)  "productVersionDate" , 18);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getProductVersionDate(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasProductName()) {
        yajl_gen_string(g, (const unsigned char*)  "productName" , 11);
        const char *s = value.getProductName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProductTypeMask()) {
        yajl_gen_string(g, (const unsigned char*)  "productTypeMask" , 15);
        yajl_gen_integer(g, (long long)value.getProductTypeMask());
    }
    if (!isSparse || value.hasRegionSet()) {
        yajl_gen_string(g, (const unsigned char*)  "regionSet" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet >& o11 = value.getRegionSet();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasUpdateRegions()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegions" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion >& o13 = value.getUpdateRegions();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::Product& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavDataContext"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavigationSWVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "navigationSWVersion" , 19);
        const char *s = value.getNavigationSWVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPackageId()) {
        yajl_gen_string(g, (const unsigned char*)  "packageId" , 9);
        const char *s = value.getPackageId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProducts()) {
        yajl_gen_string(g, (const unsigned char*)  "products" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product >& o15 = value.getProducts();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasStorageSpace()) {
        yajl_gen_string(g, (const unsigned char*)  "storageSpace" , 12);
        serializeJson(value.getStorageSpace(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceId()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceId" , 8);
        yajl_gen_integer(g, (long long)value.getDeviceId());
    }
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceType" , 10);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    if (!isSparse || value.hasDeviceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceStatus" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus_Name(value.getDeviceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagPerformFullUpdateViaUSBResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAck()) {
        yajl_gen_string(g, (const unsigned char*)  "ack" , 3);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck_Name(value.getAck());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAck());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAvailableUpdatesResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAvailableUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "availableUpdates" , 16);
        serializeJson(value.getAvailableUpdates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteUpdateComponentRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "regionId" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o17 = value.getRegionId();
        {
            ::std::vector< uint32 >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                yajl_gen_integer(g, (long long)(*o16));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteUpdateComponentResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFavoriteUpdateRegionsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    if (!isSparse || value.hasBaselineMapId()) {
        yajl_gen_string(g, (const unsigned char*)  "baselineMapId" , 13);
        yajl_gen_integer(g, (long long)value.getBaselineMapId());
    }
    if (!isSparse || value.hasUpdateRegionIds()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegionIds" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o19 = value.getUpdateRegionIds();
        {
            ::std::vector< uint32 >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                yajl_gen_integer(g, (long long)(*o18));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFavoriteUpdateRegionsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearFavoriteUpdateRegionsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartFullUpdateResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartMapDataExportRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceId()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceId" , 8);
        yajl_gen_integer(g, (long long)value.getDeviceId());
    }
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceType" , 10);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartMapDataExportResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FavoriteUpdateRegionsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFavoriteUpdateRegions()) {
        yajl_gen_string(g, (const unsigned char*)  "favoriteUpdateRegions" , 21);
        serializeJson(value.getFavoriteUpdateRegions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FavoriteUpdateRegionsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InstallationStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInstallationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "installationStatus" , 18);
        serializeJson(value.getInstallationStatus(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InstallationStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavDataStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavDataStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "navDataStatus" , 13);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus_Name(value.getNavDataStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getNavDataStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavDataStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavDataContextUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavDataContext()) {
        yajl_gen_string(g, (const unsigned char*)  "navDataContext" , 14);
        serializeJson(value.getNavDataContext(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavDataContextRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationDataUpdateStatusInfoUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavigationDataUpdateStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "navigationDataUpdateStatusInfo" , 30);
        serializeJson(value.getNavigationDataUpdateStatusInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationDataUpdateStatusInfoRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CatalogueStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCatalogueStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "catalogueStatus" , 15);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus_Name(value.getCatalogueStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCatalogueStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CatalogueStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapupdateExportStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMapupdateExportStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "mapupdateExportStatus" , 21);
        const char* s = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus_Name(value.getMapupdateExportStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMapupdateExportStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapupdateExportStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceInfosUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceInfos()) {
        yajl_gen_string(g, (const unsigned char*)  "deviceInfos" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo >& o21 = value.getDeviceInfos();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceInfosRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::Product& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

