#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICE_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "org.bosch.cm.navigation.NavigationDataUpdateService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

// method IDs
static const uint16 ID_DiagPerformFullUpdateViaUSB = 0;
static const uint16 ID_getAvailableUpdates = 1;
static const uint16 ID_deleteUpdateComponent = 2;
static const uint16 ID_setFavoriteUpdateRegions = 3;
static const uint16 ID_clearFavoriteUpdateRegions = 4;
static const uint16 ID_startFullUpdate = 5;
static const uint16 ID_StartMapDataExport = 6;

// signal IDs

// property IDs
static const uint16 ID_favoriteUpdateRegions = 7;
static const uint16 ID_installationStatus = 8;
static const uint16 ID_navDataStatus = 9;
static const uint16 ID_navDataContext = 10;
static const uint16 ID_navigationDataUpdateStatusInfo = 11;
static const uint16 ID_catalogueStatus = 12;
static const uint16 ID_mapupdateExportStatus = 13;
static const uint16 ID_deviceInfos = 14;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class FavoriteUpdateRegionData;

class FavoriteUpdateRegions;

class NavigationDataUpdateStatusInfo;

class InstallationStatus;

class StorageSpace;

class UpdateDescription;

class UpdateRegionVersionInfo;

class ProductVersionInfo;

class AvailableUpdates;

class UpdateRegion;

class RegionSet;

class Product;

class NavDataContext;

class DeviceInfo;

class DiagPerformFullUpdateViaUSBResponse;

class GetAvailableUpdatesResponse;

class DeleteUpdateComponentRequest;

class DeleteUpdateComponentResponse;

class SetFavoriteUpdateRegionsRequest;

class SetFavoriteUpdateRegionsResponse;

class ClearFavoriteUpdateRegionsResponse;

class StartFullUpdateResponse;

class StartMapDataExportRequest;

class StartMapDataExportResponse;

class FavoriteUpdateRegionsUpdate;

class FavoriteUpdateRegionsRegister;

class InstallationStatusUpdate;

class InstallationStatusRegister;

class NavDataStatusUpdate;

class NavDataStatusRegister;

class NavDataContextUpdate;

class NavDataContextRegister;

class NavigationDataUpdateStatusInfoUpdate;

class NavigationDataUpdateStatusInfoRegister;

class CatalogueStatusUpdate;

class CatalogueStatusRegister;

class MapupdateExportStatusUpdate;

class MapupdateExportStatusRegister;

class DeviceInfosUpdate;

class DeviceInfosRegister;

// type definitions
/**
 * Diagnosis request full update via USB in Diagnostic mode
 *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DiagPerformFullUpdateViaUSBRequest;

/**
 * If the meaning of "DiagPerformFullUpdateViaUSBError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiagPerformFullUpdateViaUSBError;

/**
 * Request to get a list of all available updates.
 *        For each update component one entry is contained if an update is available only.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAvailableUpdatesRequest;

/**
 * If the meaning of "GetAvailableUpdatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAvailableUpdatesError;

/**
 * If the meaning of "DeleteUpdateComponentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeleteUpdateComponentError;

/**
 * If the meaning of "SetFavoriteUpdateRegionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetFavoriteUpdateRegionsError;

/**
 * Request to remove current favorite region setting.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ClearFavoriteUpdateRegionsRequest;

/**
 * If the meaning of "ClearFavoriteUpdateRegionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClearFavoriteUpdateRegionsError;

/**
 * Request to install a full navigation data update if USB full update data is available.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartFullUpdateRequest;

/**
 * If the meaning of "StartFullUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartFullUpdateError;

/**
 * If the meaning of "StartMapDataExportError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartMapDataExportError;

/**
 * Attribute provides current favorite update regions and its storage status.
 *        Storage status informs about the reason for changing the favorite update regions.
 */
typedef FavoriteUpdateRegionsUpdate FavoriteUpdateRegionsSet;

/**
 * Attribute provides current favorite update regions and its storage status.
 *        Storage status informs about the reason for changing the favorite update regions.
 */
typedef FavoriteUpdateRegionsUpdate FavoriteUpdateRegionsGet;

/**
 * If the meaning of "FavoriteUpdateRegionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FavoriteUpdateRegionsError;

/**
 * Attribute provides the installation status of a certain update region
 */
typedef InstallationStatusUpdate InstallationStatusSet;

/**
 * Attribute provides the installation status of a certain update region
 */
typedef InstallationStatusUpdate InstallationStatusGet;

/**
 * If the meaning of "InstallationStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InstallationStatusError;

/**
 * Attribute provides the navigation data status like UNKNOWN, OK,...
 */
typedef NavDataStatusUpdate NavDataStatusSet;

/**
 * Attribute provides the navigation data status like UNKNOWN, OK,...
 */
typedef NavDataStatusUpdate NavDataStatusGet;

/**
 * If the meaning of "NavDataStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NavDataStatusError;

/**
 * Attribute to get current NavData context (aka map context).
 *        It offers all products with their id's, space on ffs and their update regions.
 *        Also each update region with its own id's, space on ffs are part of the context.
 *        Furthermore the current version id for each product and region is shown.
 */
typedef NavDataContextUpdate NavDataContextSet;

/**
 * Attribute to get current NavData context (aka map context).
 *        It offers all products with their id's, space on ffs and their update regions.
 *        Also each update region with its own id's, space on ffs are part of the context.
 *        Furthermore the current version id for each product and region is shown.
 */
typedef NavDataContextUpdate NavDataContextGet;

/**
 * If the meaning of "NavDataContextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NavDataContextError;

/**
 * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
 */
typedef NavigationDataUpdateStatusInfoUpdate NavigationDataUpdateStatusInfoSet;

/**
 * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
 */
typedef NavigationDataUpdateStatusInfoUpdate NavigationDataUpdateStatusInfoGet;

/**
 * If the meaning of "NavigationDataUpdateStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NavigationDataUpdateStatusInfoError;

/**
 * Attribute to get current catalogue status
 */
typedef CatalogueStatusUpdate CatalogueStatusSet;

/**
 * Attribute to get current catalogue status
 */
typedef CatalogueStatusUpdate CatalogueStatusGet;

/**
 * If the meaning of "CatalogueStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CatalogueStatusError;

/**
 * Attribute to get mapdataExport Status
 */
typedef MapupdateExportStatusUpdate MapupdateExportStatusSet;

/**
 * Attribute to get mapdataExport Status
 */
typedef MapupdateExportStatusUpdate MapupdateExportStatusGet;

/**
 * If the meaning of "MapupdateExportStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapupdateExportStatusError;

/**
 * Attribute to get DeviceInfos Details
 */
typedef DeviceInfosUpdate DeviceInfosSet;

/**
 * Attribute to get DeviceInfos Details
 */
typedef DeviceInfosUpdate DeviceInfosGet;

/**
 * If the meaning of "DeviceInfosError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceInfosError;


/**
 * Add id's that are required to indentify an update region.
 *        As there are multiple updateRegions possible as favorites it contains a list of updateRegions.
 *        All favorites are part of the same product, so product identifier are available only once.
 */
class FavoriteUpdateRegionData {
public:

    /**
     * Default constructor
     */
    inline  FavoriteUpdateRegionData ();

    /**
     * Copy constructor
     */
    inline  FavoriteUpdateRegionData (const FavoriteUpdateRegionData &rhs);

    /**
     * All fields constructor
     */
    inline  FavoriteUpdateRegionData (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< uint32 >& updateRegionIds_);

    /**
     * Destructor
     */
    inline  ~FavoriteUpdateRegionData();

    /**
     * Assignment operator
     */
    inline FavoriteUpdateRegionData& operator = (const FavoriteUpdateRegionData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FavoriteUpdateRegionData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FavoriteUpdateRegionData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FavoriteUpdateRegionData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FavoriteUpdateRegionData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "productId"

    static const int kProductId = 0;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "baselineMapId"

    static const int kBaselineMapId = 2;

    /**
     * Clears the field "baselineMapId".
     *
     * The field will be set to its default value. The hasBaselineMapId()
     * method will return false.
     */
    inline void clearBaselineMapId();

    /**
     * Checks whether the field "baselineMapId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBaselineMapId()). Otherwise it will return false.
     */
    inline bool hasBaselineMapId () const;

    /**
     * Returns the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "baselineMapId"
     */
    inline uint32 getBaselineMapId () const;

    /**
     * Sets the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @param baselineMapId The value which will be set
     */
    inline void setBaselineMapId (uint32 baselineMapId_);

    // API of field "updateRegionIds"

    static const int kUpdateRegionIds = 3;

    /**
     * Clears the field "updateRegionIds".
     *
     * The field will be set to its default value. The hasUpdateRegionIds()
     * method will return false.
     */
    inline void clearUpdateRegionIds();

    /**
     * Checks whether the field "updateRegionIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionIds()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionIds () const;

    /**
     * Returns the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionIds"
     */
    inline const ::std::vector< uint32 >& getUpdateRegionIds () const;

    /**
     * Retrieves the value of the field "updateRegionIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegionIds".
     */
    inline ::std::vector< uint32 >& getUpdateRegionIdsMutable ();

    /**
     * Sets the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @param updateRegionIds The value which will be set
     */
    inline void setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_);

    static const FavoriteUpdateRegionData &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_baselineMapId ();

    inline void clear_has_baselineMapId ();

    inline void set_has_updateRegionIds ();

    inline void clear_has_updateRegionIds ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _productId;

    uint32 _supplierId;

    uint32 _baselineMapId;

    ::std::vector< uint32 > _updateRegionIds;

};

/**
 * Contains data related to favorite update regions and the reason for status update.
 *       favoriteUpdateRegionStatus : Gives information about the reason for changes causing this update
 *       favoriteUpdateRegions : Contains current favorite updateRegions or in case of SUGGESTED_SETTINGS the
 *       favoriteUpdateRegions that fits better to the current locale of the vehicle. The stored favorite update regions
 *       will be left unchanged and can be read from the NavDataContext as usual.
 *       In case no favorites are set the updateRegionIds array of favoriteUpdateRegions is empty and all other ids are 0.
 */
class FavoriteUpdateRegions {
public:

    /**
     * Default constructor
     */
    inline  FavoriteUpdateRegions ();

    /**
     * Copy constructor
     */
    inline  FavoriteUpdateRegions (const FavoriteUpdateRegions &rhs);

    /**
     * All fields constructor
     */
    inline  FavoriteUpdateRegions (FavoriteUpdateRegionStatus favoriteUpdateRegionStatus_, const FavoriteUpdateRegionData& favoriteUpdateRegions_);

    /**
     * Destructor
     */
    inline  ~FavoriteUpdateRegions();

    /**
     * Assignment operator
     */
    inline FavoriteUpdateRegions& operator = (const FavoriteUpdateRegions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FavoriteUpdateRegions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FavoriteUpdateRegions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FavoriteUpdateRegions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FavoriteUpdateRegions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "favoriteUpdateRegionStatus"

    static const int kFavoriteUpdateRegionStatus = 0;

    /**
     * Clears the field "favoriteUpdateRegionStatus".
     *
     * The field will be set to its default value. The hasFavoriteUpdateRegionStatus()
     * method will return false.
     */
    inline void clearFavoriteUpdateRegionStatus();

    /**
     * Checks whether the field "favoriteUpdateRegionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteUpdateRegionStatus()). Otherwise it will return false.
     */
    inline bool hasFavoriteUpdateRegionStatus () const;

    /**
     * Returns the value of the member "favoriteUpdateRegionStatus".
     *
     * If the meaning of "favoriteUpdateRegionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "favoriteUpdateRegionStatus"
     */
    inline FavoriteUpdateRegionStatus getFavoriteUpdateRegionStatus () const;

    /**
     * Sets the value of the member "favoriteUpdateRegionStatus".
     *
     * If the meaning of "favoriteUpdateRegionStatus" isn't clear, then there should be a description here.
     *
     * @param favoriteUpdateRegionStatus The value which will be set
     */
    inline void setFavoriteUpdateRegionStatus (FavoriteUpdateRegionStatus favoriteUpdateRegionStatus_);

    // API of field "favoriteUpdateRegions"

    static const int kFavoriteUpdateRegions = 1;

    /**
     * Clears the field "favoriteUpdateRegions".
     *
     * The field will be set to its default value. The hasFavoriteUpdateRegions()
     * method will return false.
     */
    inline void clearFavoriteUpdateRegions();

    /**
     * Checks whether the field "favoriteUpdateRegions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteUpdateRegions()). Otherwise it will return false.
     */
    inline bool hasFavoriteUpdateRegions () const;

    /**
     * Returns the value of the member "favoriteUpdateRegions".
     *
     * If the meaning of "favoriteUpdateRegions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "favoriteUpdateRegions"
     */
    inline const FavoriteUpdateRegionData& getFavoriteUpdateRegions () const;

    /**
     * Retrieves the value of the field "favoriteUpdateRegions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "favoriteUpdateRegions".
     */
    inline FavoriteUpdateRegionData& getFavoriteUpdateRegionsMutable ();

    /**
     * Sets the value of the member "favoriteUpdateRegions".
     *
     * If the meaning of "favoriteUpdateRegions" isn't clear, then there should be a description here.
     *
     * @param favoriteUpdateRegions The value which will be set
     */
    inline void setFavoriteUpdateRegions (const FavoriteUpdateRegionData& favoriteUpdateRegions_);

    static const FavoriteUpdateRegions &getDefaultInstance();

private:

    inline void set_has_favoriteUpdateRegionStatus ();

    inline void clear_has_favoriteUpdateRegionStatus ();

    inline void set_has_favoriteUpdateRegions ();

    inline void clear_has_favoriteUpdateRegions ();

    uint32 _has_bits_[ (2 + 31) / 32];

    FavoriteUpdateRegionStatus _favoriteUpdateRegionStatus;

    FavoriteUpdateRegionData _favoriteUpdateRegions;

};

/**
 * Describes current status of of FullUpdateViaUSB requested by Diagnosis.
 */
class NavigationDataUpdateStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  NavigationDataUpdateStatusInfo ();

    /**
     * Copy constructor
     */
    inline  NavigationDataUpdateStatusInfo (const NavigationDataUpdateStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  NavigationDataUpdateStatusInfo (NavigationDataUpdateStatus status_, uint8 progressValue_, uint32 remainingTimeInSecond_, const ::std::string& productName_, const ::std::string& regionName_);

    /**
     * Destructor
     */
    inline  ~NavigationDataUpdateStatusInfo();

    /**
     * Assignment operator
     */
    inline NavigationDataUpdateStatusInfo& operator = (const NavigationDataUpdateStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationDataUpdateStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationDataUpdateStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationDataUpdateStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationDataUpdateStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline NavigationDataUpdateStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (NavigationDataUpdateStatus status_);

    // API of field "progressValue"

    static const int kProgressValue = 1;

    /**
     * Clears the field "progressValue".
     *
     * The field will be set to its default value. The hasProgressValue()
     * method will return false.
     */
    inline void clearProgressValue();

    /**
     * Checks whether the field "progressValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgressValue()). Otherwise it will return false.
     */
    inline bool hasProgressValue () const;

    /**
     * Returns the value of the member "progressValue".
     *
     * If the meaning of "progressValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "progressValue"
     */
    inline uint8 getProgressValue () const;

    /**
     * Sets the value of the member "progressValue".
     *
     * If the meaning of "progressValue" isn't clear, then there should be a description here.
     *
     * @param progressValue The value which will be set
     */
    inline void setProgressValue (uint8 progressValue_);

    // API of field "remainingTimeInSecond"

    static const int kRemainingTimeInSecond = 2;

    /**
     * Clears the field "remainingTimeInSecond".
     *
     * The field will be set to its default value. The hasRemainingTimeInSecond()
     * method will return false.
     */
    inline void clearRemainingTimeInSecond();

    /**
     * Checks whether the field "remainingTimeInSecond" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemainingTimeInSecond()). Otherwise it will return false.
     */
    inline bool hasRemainingTimeInSecond () const;

    /**
     * Returns the value of the member "remainingTimeInSecond".
     *
     * If the meaning of "remainingTimeInSecond" isn't clear, then there should be a description here.
     *
     * @return The value of the field "remainingTimeInSecond"
     */
    inline uint32 getRemainingTimeInSecond () const;

    /**
     * Sets the value of the member "remainingTimeInSecond".
     *
     * If the meaning of "remainingTimeInSecond" isn't clear, then there should be a description here.
     *
     * @param remainingTimeInSecond The value which will be set
     */
    inline void setRemainingTimeInSecond (uint32 remainingTimeInSecond_);

    // API of field "productName"

    static const int kProductName = 3;

    /**
     * Clears the field "productName".
     *
     * The field will be set to its default value. The hasProductName()
     * method will return false.
     */
    inline void clearProductName();

    /**
     * Checks whether the field "productName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductName()). Otherwise it will return false.
     */
    inline bool hasProductName () const;

    /**
     * Returns the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productName"
     */
    inline const ::std::string& getProductName () const;

    /**
     * Retrieves the value of the field "productName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "productName".
     */
    inline ::std::string& getProductNameMutable ();

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const ::std::string& productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* value, size_t size);

    // API of field "regionName"

    static const int kRegionName = 4;

    /**
     * Clears the field "regionName".
     *
     * The field will be set to its default value. The hasRegionName()
     * method will return false.
     */
    inline void clearRegionName();

    /**
     * Checks whether the field "regionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionName()). Otherwise it will return false.
     */
    inline bool hasRegionName () const;

    /**
     * Returns the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionName"
     */
    inline const ::std::string& getRegionName () const;

    /**
     * Retrieves the value of the field "regionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionName".
     */
    inline ::std::string& getRegionNameMutable ();

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const ::std::string& regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* value, size_t size);

    static const NavigationDataUpdateStatusInfo &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_progressValue ();

    inline void clear_has_progressValue ();

    inline void set_has_remainingTimeInSecond ();

    inline void clear_has_remainingTimeInSecond ();

    inline void set_has_productName ();

    inline void clear_has_productName ();

    inline void set_has_regionName ();

    inline void clear_has_regionName ();

    uint32 _has_bits_[ (5 + 31) / 32];

    NavigationDataUpdateStatus _status;

    uint8 _progressValue;

    uint32 _remainingTimeInSecond;

    ::std::string _productName;

    ::std::string _regionName;

};

/**
 * Describes current installation status of a certain update component.
 *        The combination of productId, supplierId and regionId refers to the identifiers used in NavDataContext. It uniquely identifies the updatable component.
 *        updateStep describes current state of the installation process
 *        percentage current installation progress in percent (valid in case of updateStep UPDATE_INSTALLATION_IN_PROGRESS) Range [0..100]
 *        isProductUpdate set to true in case a whole product is currently updated (regionName can be empty or describes current region in progress)
 *        productName the name of the product currenttly updated
 *        regionName the name of the region currenttly updated
 */
class InstallationStatus {
public:

    /**
     * Default constructor
     */
    inline  InstallationStatus ();

    /**
     * Copy constructor
     */
    inline  InstallationStatus (const InstallationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  InstallationStatus (uint32 productId_, uint32 supplierId_, uint32 regionId_, UpdateStep updateStep_, uint16 percentage_, bool isProductUpdate_, const ::std::string& productName_, const ::std::string& regionName_);

    /**
     * Destructor
     */
    inline  ~InstallationStatus();

    /**
     * Assignment operator
     */
    inline InstallationStatus& operator = (const InstallationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstallationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstallationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstallationStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstallationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "productId"

    static const int kProductId = 0;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "regionId"

    static const int kRegionId = 2;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "updateStep"

    static const int kUpdateStep = 3;

    /**
     * Clears the field "updateStep".
     *
     * The field will be set to its default value. The hasUpdateStep()
     * method will return false.
     */
    inline void clearUpdateStep();

    /**
     * Checks whether the field "updateStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateStep()). Otherwise it will return false.
     */
    inline bool hasUpdateStep () const;

    /**
     * Returns the value of the member "updateStep".
     *
     * If the meaning of "updateStep" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateStep"
     */
    inline UpdateStep getUpdateStep () const;

    /**
     * Sets the value of the member "updateStep".
     *
     * If the meaning of "updateStep" isn't clear, then there should be a description here.
     *
     * @param updateStep The value which will be set
     */
    inline void setUpdateStep (UpdateStep updateStep_);

    // API of field "percentage"

    static const int kPercentage = 4;

    /**
     * Clears the field "percentage".
     *
     * The field will be set to its default value. The hasPercentage()
     * method will return false.
     */
    inline void clearPercentage();

    /**
     * Checks whether the field "percentage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPercentage()). Otherwise it will return false.
     */
    inline bool hasPercentage () const;

    /**
     * Returns the value of the member "percentage".
     *
     * If the meaning of "percentage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "percentage"
     */
    inline uint16 getPercentage () const;

    /**
     * Sets the value of the member "percentage".
     *
     * If the meaning of "percentage" isn't clear, then there should be a description here.
     *
     * @param percentage The value which will be set
     */
    inline void setPercentage (uint16 percentage_);

    // API of field "isProductUpdate"

    static const int kIsProductUpdate = 5;

    /**
     * Clears the field "isProductUpdate".
     *
     * The field will be set to its default value. The hasIsProductUpdate()
     * method will return false.
     */
    inline void clearIsProductUpdate();

    /**
     * Checks whether the field "isProductUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsProductUpdate()). Otherwise it will return false.
     */
    inline bool hasIsProductUpdate () const;

    /**
     * Returns the value of the member "isProductUpdate".
     *
     * If the meaning of "isProductUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isProductUpdate"
     */
    inline bool getIsProductUpdate () const;

    /**
     * Sets the value of the member "isProductUpdate".
     *
     * If the meaning of "isProductUpdate" isn't clear, then there should be a description here.
     *
     * @param isProductUpdate The value which will be set
     */
    inline void setIsProductUpdate (bool isProductUpdate_);

    // API of field "productName"

    static const int kProductName = 6;

    /**
     * Clears the field "productName".
     *
     * The field will be set to its default value. The hasProductName()
     * method will return false.
     */
    inline void clearProductName();

    /**
     * Checks whether the field "productName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductName()). Otherwise it will return false.
     */
    inline bool hasProductName () const;

    /**
     * Returns the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productName"
     */
    inline const ::std::string& getProductName () const;

    /**
     * Retrieves the value of the field "productName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "productName".
     */
    inline ::std::string& getProductNameMutable ();

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const ::std::string& productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* value, size_t size);

    // API of field "regionName"

    static const int kRegionName = 7;

    /**
     * Clears the field "regionName".
     *
     * The field will be set to its default value. The hasRegionName()
     * method will return false.
     */
    inline void clearRegionName();

    /**
     * Checks whether the field "regionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionName()). Otherwise it will return false.
     */
    inline bool hasRegionName () const;

    /**
     * Returns the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionName"
     */
    inline const ::std::string& getRegionName () const;

    /**
     * Retrieves the value of the field "regionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionName".
     */
    inline ::std::string& getRegionNameMutable ();

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const ::std::string& regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* value, size_t size);

    static const InstallationStatus &getDefaultInstance();

private:

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_updateStep ();

    inline void clear_has_updateStep ();

    inline void set_has_percentage ();

    inline void clear_has_percentage ();

    inline void set_has_isProductUpdate ();

    inline void clear_has_isProductUpdate ();

    inline void set_has_productName ();

    inline void clear_has_productName ();

    inline void set_has_regionName ();

    inline void clear_has_regionName ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint32 _productId;

    uint32 _supplierId;

    uint32 _regionId;

    UpdateStep _updateStep;

    uint16 _percentage;

    bool _isProductUpdate;

    ::std::string _productName;

    ::std::string _regionName;

};

/**
 * If the meaning of "StorageSpace" isn't clear, then there should be a description here.
 */
class StorageSpace {
public:

    /**
     * Default constructor
     */
    inline  StorageSpace ();

    /**
     * Copy constructor
     */
    inline  StorageSpace (const StorageSpace &rhs);

    /**
     * All fields constructor
     */
    inline  StorageSpace (uint64 spaceTotalInBytes_, uint64 spaceLeftInBytes_);

    /**
     * Destructor
     */
    inline  ~StorageSpace();

    /**
     * Assignment operator
     */
    inline StorageSpace& operator = (const StorageSpace& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorageSpace& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorageSpace& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorageSpace& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorageSpace& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "spaceTotalInBytes"

    static const int kSpaceTotalInBytes = 0;

    /**
     * Clears the field "spaceTotalInBytes".
     *
     * The field will be set to its default value. The hasSpaceTotalInBytes()
     * method will return false.
     */
    inline void clearSpaceTotalInBytes();

    /**
     * Checks whether the field "spaceTotalInBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpaceTotalInBytes()). Otherwise it will return false.
     */
    inline bool hasSpaceTotalInBytes () const;

    /**
     * Returns the value of the member "spaceTotalInBytes".
     *
     * If the meaning of "spaceTotalInBytes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "spaceTotalInBytes"
     */
    inline uint64 getSpaceTotalInBytes () const;

    /**
     * Sets the value of the member "spaceTotalInBytes".
     *
     * If the meaning of "spaceTotalInBytes" isn't clear, then there should be a description here.
     *
     * @param spaceTotalInBytes The value which will be set
     */
    inline void setSpaceTotalInBytes (uint64 spaceTotalInBytes_);

    // API of field "spaceLeftInBytes"

    static const int kSpaceLeftInBytes = 1;

    /**
     * Clears the field "spaceLeftInBytes".
     *
     * The field will be set to its default value. The hasSpaceLeftInBytes()
     * method will return false.
     */
    inline void clearSpaceLeftInBytes();

    /**
     * Checks whether the field "spaceLeftInBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpaceLeftInBytes()). Otherwise it will return false.
     */
    inline bool hasSpaceLeftInBytes () const;

    /**
     * Returns the value of the member "spaceLeftInBytes".
     *
     * If the meaning of "spaceLeftInBytes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "spaceLeftInBytes"
     */
    inline uint64 getSpaceLeftInBytes () const;

    /**
     * Sets the value of the member "spaceLeftInBytes".
     *
     * If the meaning of "spaceLeftInBytes" isn't clear, then there should be a description here.
     *
     * @param spaceLeftInBytes The value which will be set
     */
    inline void setSpaceLeftInBytes (uint64 spaceLeftInBytes_);

    static const StorageSpace &getDefaultInstance();

private:

    inline void set_has_spaceTotalInBytes ();

    inline void clear_has_spaceTotalInBytes ();

    inline void set_has_spaceLeftInBytes ();

    inline void clear_has_spaceLeftInBytes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint64 _spaceTotalInBytes;

    uint64 _spaceLeftInBytes;

};

/**
 * Describes an update for an updatable component for textual representation.
 *        updateVersionId of the update
 *        updateVersionDate in unix timestamp (January 1st, 1970 at UTC)
 *        downloadSizeInBytes  (as indicated in the catalogue)
 *        estimatedInstallTimeInSeconds  (as calculated based on the data in the catalogue)
 */
class UpdateDescription {
public:

    /**
     * Default constructor
     */
    inline  UpdateDescription ();

    /**
     * Copy constructor
     */
    inline  UpdateDescription (const UpdateDescription &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateDescription (uint32 updateVersionId_, uint64 updateVersionDate_, uint64 downloadSizeInBytes_, uint64 estimatedInstallTimeInSeconds_);

    /**
     * Destructor
     */
    inline  ~UpdateDescription();

    /**
     * Assignment operator
     */
    inline UpdateDescription& operator = (const UpdateDescription& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateDescription& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateDescription& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateDescription& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateDescription& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateVersionId"

    static const int kUpdateVersionId = 0;

    /**
     * Clears the field "updateVersionId".
     *
     * The field will be set to its default value. The hasUpdateVersionId()
     * method will return false.
     */
    inline void clearUpdateVersionId();

    /**
     * Checks whether the field "updateVersionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateVersionId()). Otherwise it will return false.
     */
    inline bool hasUpdateVersionId () const;

    /**
     * Returns the value of the member "updateVersionId".
     *
     * If the meaning of "updateVersionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateVersionId"
     */
    inline uint32 getUpdateVersionId () const;

    /**
     * Sets the value of the member "updateVersionId".
     *
     * If the meaning of "updateVersionId" isn't clear, then there should be a description here.
     *
     * @param updateVersionId The value which will be set
     */
    inline void setUpdateVersionId (uint32 updateVersionId_);

    // API of field "updateVersionDate"

    static const int kUpdateVersionDate = 1;

    /**
     * Clears the field "updateVersionDate".
     *
     * The field will be set to its default value. The hasUpdateVersionDate()
     * method will return false.
     */
    inline void clearUpdateVersionDate();

    /**
     * Checks whether the field "updateVersionDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateVersionDate()). Otherwise it will return false.
     */
    inline bool hasUpdateVersionDate () const;

    /**
     * Returns the value of the member "updateVersionDate".
     *
     * If the meaning of "updateVersionDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateVersionDate"
     */
    inline uint64 getUpdateVersionDate () const;

    /**
     * Sets the value of the member "updateVersionDate".
     *
     * If the meaning of "updateVersionDate" isn't clear, then there should be a description here.
     *
     * @param updateVersionDate The value which will be set
     */
    inline void setUpdateVersionDate (uint64 updateVersionDate_);

    // API of field "downloadSizeInBytes"

    static const int kDownloadSizeInBytes = 2;

    /**
     * Clears the field "downloadSizeInBytes".
     *
     * The field will be set to its default value. The hasDownloadSizeInBytes()
     * method will return false.
     */
    inline void clearDownloadSizeInBytes();

    /**
     * Checks whether the field "downloadSizeInBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadSizeInBytes()). Otherwise it will return false.
     */
    inline bool hasDownloadSizeInBytes () const;

    /**
     * Returns the value of the member "downloadSizeInBytes".
     *
     * If the meaning of "downloadSizeInBytes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "downloadSizeInBytes"
     */
    inline uint64 getDownloadSizeInBytes () const;

    /**
     * Sets the value of the member "downloadSizeInBytes".
     *
     * If the meaning of "downloadSizeInBytes" isn't clear, then there should be a description here.
     *
     * @param downloadSizeInBytes The value which will be set
     */
    inline void setDownloadSizeInBytes (uint64 downloadSizeInBytes_);

    // API of field "estimatedInstallTimeInSeconds"

    static const int kEstimatedInstallTimeInSeconds = 3;

    /**
     * Clears the field "estimatedInstallTimeInSeconds".
     *
     * The field will be set to its default value. The hasEstimatedInstallTimeInSeconds()
     * method will return false.
     */
    inline void clearEstimatedInstallTimeInSeconds();

    /**
     * Checks whether the field "estimatedInstallTimeInSeconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedInstallTimeInSeconds()). Otherwise it will return false.
     */
    inline bool hasEstimatedInstallTimeInSeconds () const;

    /**
     * Returns the value of the member "estimatedInstallTimeInSeconds".
     *
     * If the meaning of "estimatedInstallTimeInSeconds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "estimatedInstallTimeInSeconds"
     */
    inline uint64 getEstimatedInstallTimeInSeconds () const;

    /**
     * Sets the value of the member "estimatedInstallTimeInSeconds".
     *
     * If the meaning of "estimatedInstallTimeInSeconds" isn't clear, then there should be a description here.
     *
     * @param estimatedInstallTimeInSeconds The value which will be set
     */
    inline void setEstimatedInstallTimeInSeconds (uint64 estimatedInstallTimeInSeconds_);

    static const UpdateDescription &getDefaultInstance();

private:

    inline void set_has_updateVersionId ();

    inline void clear_has_updateVersionId ();

    inline void set_has_updateVersionDate ();

    inline void clear_has_updateVersionDate ();

    inline void set_has_downloadSizeInBytes ();

    inline void clear_has_downloadSizeInBytes ();

    inline void set_has_estimatedInstallTimeInSeconds ();

    inline void clear_has_estimatedInstallTimeInSeconds ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _updateVersionId;

    uint64 _updateVersionDate;

    uint64 _downloadSizeInBytes;

    uint64 _estimatedInstallTimeInSeconds;

};

/**
 * Describes an updatable component of type region.
 *        A region component can have none, one or multiple updates.
 *        Therefore it deals with an array of UpdateDescription elements. In case a region is upToDate the array will be empty.
 *        isSubscriptionActive indicates if the update region is still allowed by the user to be updated.
 */
class UpdateRegionVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  UpdateRegionVersionInfo ();

    /**
     * Copy constructor
     */
    inline  UpdateRegionVersionInfo (const UpdateRegionVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateRegionVersionInfo (uint32 updateRegionId_, UpdateState status_, const ::std::vector< UpdateDescription >& updateDescription_);

    /**
     * Destructor
     */
    inline  ~UpdateRegionVersionInfo();

    /**
     * Assignment operator
     */
    inline UpdateRegionVersionInfo& operator = (const UpdateRegionVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateRegionVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateRegionVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateRegionVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateRegionVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 0;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline uint32 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (uint32 updateRegionId_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline UpdateState getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (UpdateState status_);

    // API of field "updateDescription"

    static const int kUpdateDescription = 2;

    /**
     * Clears the field "updateDescription".
     *
     * The field will be set to its default value. The hasUpdateDescription()
     * method will return false.
     */
    inline void clearUpdateDescription();

    /**
     * Checks whether the field "updateDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateDescription()). Otherwise it will return false.
     */
    inline bool hasUpdateDescription () const;

    /**
     * Returns the value of the member "updateDescription".
     *
     * If the meaning of "updateDescription" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateDescription"
     */
    inline const ::std::vector< UpdateDescription >& getUpdateDescription () const;

    /**
     * Retrieves the value of the field "updateDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateDescription".
     */
    inline ::std::vector< UpdateDescription >& getUpdateDescriptionMutable ();

    /**
     * Sets the value of the member "updateDescription".
     *
     * If the meaning of "updateDescription" isn't clear, then there should be a description here.
     *
     * @param updateDescription The value which will be set
     */
    inline void setUpdateDescription (const ::std::vector< UpdateDescription >& updateDescription_);

    static const UpdateRegionVersionInfo &getDefaultInstance();

private:

    static const ::std::vector< UpdateDescription >& getUpdateDescriptionList_DefaultInstance ();

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_updateDescription ();

    inline void clear_has_updateDescription ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _updateRegionId;

    UpdateState _status;

    ::std::vector< UpdateDescription > _updateDescription;

};

/**
 * Describes an updatable component of type product.
 *        A specific product is identified by its productId and the supplierId.
 *        Each product is splitted into multiple update regions. An update region itself is updateable.
 */
class ProductVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  ProductVersionInfo ();

    /**
     * Copy constructor
     */
    inline  ProductVersionInfo (const ProductVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  ProductVersionInfo (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< UpdateRegionVersionInfo >& updateRegions_);

    /**
     * Destructor
     */
    inline  ~ProductVersionInfo();

    /**
     * Assignment operator
     */
    inline ProductVersionInfo& operator = (const ProductVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "productId"

    static const int kProductId = 0;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "baselineMapId"

    static const int kBaselineMapId = 2;

    /**
     * Clears the field "baselineMapId".
     *
     * The field will be set to its default value. The hasBaselineMapId()
     * method will return false.
     */
    inline void clearBaselineMapId();

    /**
     * Checks whether the field "baselineMapId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBaselineMapId()). Otherwise it will return false.
     */
    inline bool hasBaselineMapId () const;

    /**
     * Returns the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "baselineMapId"
     */
    inline uint32 getBaselineMapId () const;

    /**
     * Sets the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @param baselineMapId The value which will be set
     */
    inline void setBaselineMapId (uint32 baselineMapId_);

    // API of field "updateRegions"

    static const int kUpdateRegions = 3;

    /**
     * Clears the field "updateRegions".
     *
     * The field will be set to its default value. The hasUpdateRegions()
     * method will return false.
     */
    inline void clearUpdateRegions();

    /**
     * Checks whether the field "updateRegions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegions()). Otherwise it will return false.
     */
    inline bool hasUpdateRegions () const;

    /**
     * Returns the value of the member "updateRegions".
     *
     * If the meaning of "updateRegions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegions"
     */
    inline const ::std::vector< UpdateRegionVersionInfo >& getUpdateRegions () const;

    /**
     * Retrieves the value of the field "updateRegions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegions".
     */
    inline ::std::vector< UpdateRegionVersionInfo >& getUpdateRegionsMutable ();

    /**
     * Sets the value of the member "updateRegions".
     *
     * If the meaning of "updateRegions" isn't clear, then there should be a description here.
     *
     * @param updateRegions The value which will be set
     */
    inline void setUpdateRegions (const ::std::vector< UpdateRegionVersionInfo >& updateRegions_);

    static const ProductVersionInfo &getDefaultInstance();

private:

    static const ::std::vector< UpdateRegionVersionInfo >& getUpdateRegionVersionInfoList_DefaultInstance ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_baselineMapId ();

    inline void clear_has_baselineMapId ();

    inline void set_has_updateRegions ();

    inline void clear_has_updateRegions ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _productId;

    uint32 _supplierId;

    uint32 _baselineMapId;

    ::std::vector< UpdateRegionVersionInfo > _updateRegions;

};

/**
 * Describes the result og method GetAvailableUpdates.
 *       If no updates are available result will be set to SUCCESS, but the ProductVersionInfo array is empty.
 */
class AvailableUpdates {
public:

    /**
     * Default constructor
     */
    inline  AvailableUpdates ();

    /**
     * Copy constructor
     */
    inline  AvailableUpdates (const AvailableUpdates &rhs);

    /**
     * All fields constructor
     */
    inline  AvailableUpdates (GetAvailableUpdatesResult result_, const ::std::vector< ProductVersionInfo >& products_);

    /**
     * Destructor
     */
    inline  ~AvailableUpdates();

    /**
     * Assignment operator
     */
    inline AvailableUpdates& operator = (const AvailableUpdates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableUpdates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableUpdates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableUpdates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableUpdates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline GetAvailableUpdatesResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (GetAvailableUpdatesResult result_);

    // API of field "products"

    static const int kProducts = 1;

    /**
     * Clears the field "products".
     *
     * The field will be set to its default value. The hasProducts()
     * method will return false.
     */
    inline void clearProducts();

    /**
     * Checks whether the field "products" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProducts()). Otherwise it will return false.
     */
    inline bool hasProducts () const;

    /**
     * Returns the value of the member "products".
     *
     * If the meaning of "products" isn't clear, then there should be a description here.
     *
     * @return The value of the field "products"
     */
    inline const ::std::vector< ProductVersionInfo >& getProducts () const;

    /**
     * Retrieves the value of the field "products" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "products".
     */
    inline ::std::vector< ProductVersionInfo >& getProductsMutable ();

    /**
     * Sets the value of the member "products".
     *
     * If the meaning of "products" isn't clear, then there should be a description here.
     *
     * @param products The value which will be set
     */
    inline void setProducts (const ::std::vector< ProductVersionInfo >& products_);

    static const AvailableUpdates &getDefaultInstance();

private:

    static const ::std::vector< ProductVersionInfo >& getProductVersionInfoList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_products ();

    inline void clear_has_products ();

    uint32 _has_bits_[ (2 + 31) / 32];

    GetAvailableUpdatesResult _result;

    ::std::vector< ProductVersionInfo > _products;

};

/**
 * Describes one UpdateRegion
 *       currentVersionDate in unix timestamp (January 1st, 1970 at UTC)
 */
class UpdateRegion {
public:

    /**
     * Default constructor
     */
    inline  UpdateRegion ();

    /**
     * Copy constructor
     */
    inline  UpdateRegion (const UpdateRegion &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateRegion (const ::std::string& componentId_, uint32 regionId_, const ::std::string& regionName_, uint64 currentSizeInBytes_, bool isRemovable_, bool isInstalled_, uint64 currentVersionId_, uint64 currentVersionDate_, bool isSubscriptionActive_, bool isFavorite_);

    /**
     * Destructor
     */
    inline  ~UpdateRegion();

    /**
     * Assignment operator
     */
    inline UpdateRegion& operator = (const UpdateRegion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateRegion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateRegion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateRegion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateRegion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "componentId"

    static const int kComponentId = 0;

    /**
     * Clears the field "componentId".
     *
     * The field will be set to its default value. The hasComponentId()
     * method will return false.
     */
    inline void clearComponentId();

    /**
     * Checks whether the field "componentId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentId()). Otherwise it will return false.
     */
    inline bool hasComponentId () const;

    /**
     * Returns the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "componentId"
     */
    inline const ::std::string& getComponentId () const;

    /**
     * Retrieves the value of the field "componentId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "componentId".
     */
    inline ::std::string& getComponentIdMutable ();

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const ::std::string& componentId_);

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const char* componentId_);

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const char* value, size_t size);

    // API of field "regionId"

    static const int kRegionId = 1;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "regionName"

    static const int kRegionName = 2;

    /**
     * Clears the field "regionName".
     *
     * The field will be set to its default value. The hasRegionName()
     * method will return false.
     */
    inline void clearRegionName();

    /**
     * Checks whether the field "regionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionName()). Otherwise it will return false.
     */
    inline bool hasRegionName () const;

    /**
     * Returns the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionName"
     */
    inline const ::std::string& getRegionName () const;

    /**
     * Retrieves the value of the field "regionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionName".
     */
    inline ::std::string& getRegionNameMutable ();

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const ::std::string& regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* regionName_);

    /**
     * Sets the value of the member "regionName".
     *
     * If the meaning of "regionName" isn't clear, then there should be a description here.
     *
     * @param regionName The value which will be set
     */
    inline void setRegionName (const char* value, size_t size);

    // API of field "currentSizeInBytes"

    static const int kCurrentSizeInBytes = 3;

    /**
     * Clears the field "currentSizeInBytes".
     *
     * The field will be set to its default value. The hasCurrentSizeInBytes()
     * method will return false.
     */
    inline void clearCurrentSizeInBytes();

    /**
     * Checks whether the field "currentSizeInBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentSizeInBytes()). Otherwise it will return false.
     */
    inline bool hasCurrentSizeInBytes () const;

    /**
     * Returns the value of the member "currentSizeInBytes".
     *
     * If the meaning of "currentSizeInBytes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentSizeInBytes"
     */
    inline uint64 getCurrentSizeInBytes () const;

    /**
     * Sets the value of the member "currentSizeInBytes".
     *
     * If the meaning of "currentSizeInBytes" isn't clear, then there should be a description here.
     *
     * @param currentSizeInBytes The value which will be set
     */
    inline void setCurrentSizeInBytes (uint64 currentSizeInBytes_);

    // API of field "isRemovable"

    static const int kIsRemovable = 4;

    /**
     * Clears the field "isRemovable".
     *
     * The field will be set to its default value. The hasIsRemovable()
     * method will return false.
     */
    inline void clearIsRemovable();

    /**
     * Checks whether the field "isRemovable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsRemovable()). Otherwise it will return false.
     */
    inline bool hasIsRemovable () const;

    /**
     * Returns the value of the member "isRemovable".
     *
     * If the meaning of "isRemovable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isRemovable"
     */
    inline bool getIsRemovable () const;

    /**
     * Sets the value of the member "isRemovable".
     *
     * If the meaning of "isRemovable" isn't clear, then there should be a description here.
     *
     * @param isRemovable The value which will be set
     */
    inline void setIsRemovable (bool isRemovable_);

    // API of field "isInstalled"

    static const int kIsInstalled = 5;

    /**
     * Clears the field "isInstalled".
     *
     * The field will be set to its default value. The hasIsInstalled()
     * method will return false.
     */
    inline void clearIsInstalled();

    /**
     * Checks whether the field "isInstalled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsInstalled()). Otherwise it will return false.
     */
    inline bool hasIsInstalled () const;

    /**
     * Returns the value of the member "isInstalled".
     *
     * If the meaning of "isInstalled" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isInstalled"
     */
    inline bool getIsInstalled () const;

    /**
     * Sets the value of the member "isInstalled".
     *
     * If the meaning of "isInstalled" isn't clear, then there should be a description here.
     *
     * @param isInstalled The value which will be set
     */
    inline void setIsInstalled (bool isInstalled_);

    // API of field "currentVersionId"

    static const int kCurrentVersionId = 6;

    /**
     * Clears the field "currentVersionId".
     *
     * The field will be set to its default value. The hasCurrentVersionId()
     * method will return false.
     */
    inline void clearCurrentVersionId();

    /**
     * Checks whether the field "currentVersionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentVersionId()). Otherwise it will return false.
     */
    inline bool hasCurrentVersionId () const;

    /**
     * Returns the value of the member "currentVersionId".
     *
     * If the meaning of "currentVersionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentVersionId"
     */
    inline uint64 getCurrentVersionId () const;

    /**
     * Sets the value of the member "currentVersionId".
     *
     * If the meaning of "currentVersionId" isn't clear, then there should be a description here.
     *
     * @param currentVersionId The value which will be set
     */
    inline void setCurrentVersionId (uint64 currentVersionId_);

    // API of field "currentVersionDate"

    static const int kCurrentVersionDate = 7;

    /**
     * Clears the field "currentVersionDate".
     *
     * The field will be set to its default value. The hasCurrentVersionDate()
     * method will return false.
     */
    inline void clearCurrentVersionDate();

    /**
     * Checks whether the field "currentVersionDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentVersionDate()). Otherwise it will return false.
     */
    inline bool hasCurrentVersionDate () const;

    /**
     * Returns the value of the member "currentVersionDate".
     *
     * If the meaning of "currentVersionDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentVersionDate"
     */
    inline uint64 getCurrentVersionDate () const;

    /**
     * Sets the value of the member "currentVersionDate".
     *
     * If the meaning of "currentVersionDate" isn't clear, then there should be a description here.
     *
     * @param currentVersionDate The value which will be set
     */
    inline void setCurrentVersionDate (uint64 currentVersionDate_);

    // API of field "isSubscriptionActive"

    static const int kIsSubscriptionActive = 8;

    /**
     * Clears the field "isSubscriptionActive".
     *
     * The field will be set to its default value. The hasIsSubscriptionActive()
     * method will return false.
     */
    inline void clearIsSubscriptionActive();

    /**
     * Checks whether the field "isSubscriptionActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSubscriptionActive()). Otherwise it will return false.
     */
    inline bool hasIsSubscriptionActive () const;

    /**
     * Returns the value of the member "isSubscriptionActive".
     *
     * If the meaning of "isSubscriptionActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isSubscriptionActive"
     */
    inline bool getIsSubscriptionActive () const;

    /**
     * Sets the value of the member "isSubscriptionActive".
     *
     * If the meaning of "isSubscriptionActive" isn't clear, then there should be a description here.
     *
     * @param isSubscriptionActive The value which will be set
     */
    inline void setIsSubscriptionActive (bool isSubscriptionActive_);

    // API of field "isFavorite"

    static const int kIsFavorite = 9;

    /**
     * Clears the field "isFavorite".
     *
     * The field will be set to its default value. The hasIsFavorite()
     * method will return false.
     */
    inline void clearIsFavorite();

    /**
     * Checks whether the field "isFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsFavorite()). Otherwise it will return false.
     */
    inline bool hasIsFavorite () const;

    /**
     * Returns the value of the member "isFavorite".
     *
     * If the meaning of "isFavorite" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isFavorite"
     */
    inline bool getIsFavorite () const;

    /**
     * Sets the value of the member "isFavorite".
     *
     * If the meaning of "isFavorite" isn't clear, then there should be a description here.
     *
     * @param isFavorite The value which will be set
     */
    inline void setIsFavorite (bool isFavorite_);

    static const UpdateRegion &getDefaultInstance();

private:

    inline void set_has_componentId ();

    inline void clear_has_componentId ();

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_regionName ();

    inline void clear_has_regionName ();

    inline void set_has_currentSizeInBytes ();

    inline void clear_has_currentSizeInBytes ();

    inline void set_has_isRemovable ();

    inline void clear_has_isRemovable ();

    inline void set_has_isInstalled ();

    inline void clear_has_isInstalled ();

    inline void set_has_currentVersionId ();

    inline void clear_has_currentVersionId ();

    inline void set_has_currentVersionDate ();

    inline void clear_has_currentVersionDate ();

    inline void set_has_isSubscriptionActive ();

    inline void clear_has_isSubscriptionActive ();

    inline void set_has_isFavorite ();

    inline void clear_has_isFavorite ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::std::string _componentId;

    uint32 _regionId;

    ::std::string _regionName;

    uint64 _currentSizeInBytes;

    bool _isRemovable;

    bool _isInstalled;

    uint64 _currentVersionId;

    uint64 _currentVersionDate;

    bool _isSubscriptionActive;

    bool _isFavorite;

};

/**
 * If the meaning of "RegionSet" isn't clear, then there should be a description here.
 */
class RegionSet {
public:

    /**
     * Default constructor
     */
    inline  RegionSet ();

    /**
     * Copy constructor
     */
    inline  RegionSet (const RegionSet &rhs);

    /**
     * All fields constructor
     */
    inline  RegionSet (uint32 regionSetId_, const ::std::string& regionSetName_, const ::std::vector< uint32 >& updateRegionIds_);

    /**
     * Destructor
     */
    inline  ~RegionSet();

    /**
     * Assignment operator
     */
    inline RegionSet& operator = (const RegionSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegionSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegionSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegionSet& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegionSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionSetId"

    static const int kRegionSetId = 0;

    /**
     * Clears the field "regionSetId".
     *
     * The field will be set to its default value. The hasRegionSetId()
     * method will return false.
     */
    inline void clearRegionSetId();

    /**
     * Checks whether the field "regionSetId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionSetId()). Otherwise it will return false.
     */
    inline bool hasRegionSetId () const;

    /**
     * Returns the value of the member "regionSetId".
     *
     * If the meaning of "regionSetId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionSetId"
     */
    inline uint32 getRegionSetId () const;

    /**
     * Sets the value of the member "regionSetId".
     *
     * If the meaning of "regionSetId" isn't clear, then there should be a description here.
     *
     * @param regionSetId The value which will be set
     */
    inline void setRegionSetId (uint32 regionSetId_);

    // API of field "regionSetName"

    static const int kRegionSetName = 1;

    /**
     * Clears the field "regionSetName".
     *
     * The field will be set to its default value. The hasRegionSetName()
     * method will return false.
     */
    inline void clearRegionSetName();

    /**
     * Checks whether the field "regionSetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionSetName()). Otherwise it will return false.
     */
    inline bool hasRegionSetName () const;

    /**
     * Returns the value of the member "regionSetName".
     *
     * If the meaning of "regionSetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionSetName"
     */
    inline const ::std::string& getRegionSetName () const;

    /**
     * Retrieves the value of the field "regionSetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionSetName".
     */
    inline ::std::string& getRegionSetNameMutable ();

    /**
     * Sets the value of the member "regionSetName".
     *
     * If the meaning of "regionSetName" isn't clear, then there should be a description here.
     *
     * @param regionSetName The value which will be set
     */
    inline void setRegionSetName (const ::std::string& regionSetName_);

    /**
     * Sets the value of the member "regionSetName".
     *
     * If the meaning of "regionSetName" isn't clear, then there should be a description here.
     *
     * @param regionSetName The value which will be set
     */
    inline void setRegionSetName (const char* regionSetName_);

    /**
     * Sets the value of the member "regionSetName".
     *
     * If the meaning of "regionSetName" isn't clear, then there should be a description here.
     *
     * @param regionSetName The value which will be set
     */
    inline void setRegionSetName (const char* value, size_t size);

    // API of field "updateRegionIds"

    static const int kUpdateRegionIds = 2;

    /**
     * Clears the field "updateRegionIds".
     *
     * The field will be set to its default value. The hasUpdateRegionIds()
     * method will return false.
     */
    inline void clearUpdateRegionIds();

    /**
     * Checks whether the field "updateRegionIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionIds()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionIds () const;

    /**
     * Returns the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionIds"
     */
    inline const ::std::vector< uint32 >& getUpdateRegionIds () const;

    /**
     * Retrieves the value of the field "updateRegionIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegionIds".
     */
    inline ::std::vector< uint32 >& getUpdateRegionIdsMutable ();

    /**
     * Sets the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @param updateRegionIds The value which will be set
     */
    inline void setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_);

    static const RegionSet &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_regionSetId ();

    inline void clear_has_regionSetId ();

    inline void set_has_regionSetName ();

    inline void clear_has_regionSetName ();

    inline void set_has_updateRegionIds ();

    inline void clear_has_updateRegionIds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _regionSetId;

    ::std::string _regionSetName;

    ::std::vector< uint32 > _updateRegionIds;

};

/**
 * Describes one product of the NavDataContext
 *        componentId is for future purpose and is set to empty string by default.
 *        A product is uniquely identified by several parameters: productId, supplierId, baselineMapId, productGroupId
 *        A product is versioned and productVersionId productVersionIsDirty tells details about the version in use.
 *        The productName can be used for display options. It contains the name in current system HMI language.
 *        A product is assigned to one or more product type. The productTypeMask is a bitfield containing all the types
 *        a given product is assigned to. The enumeration ProductType describes the bit position if each possible type.
 *        A product may be clustered into regionSets (used to model a country - depending on the project needs)
 *        A product consists of one or more update region.
 */
class Product {
public:

    /**
     * Default constructor
     */
    inline  Product ();

    /**
     * Copy constructor
     */
    inline  Product (const Product &rhs);

    /**
     * All fields constructor
     */
    inline  Product (const ::std::string& componentId_, uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, uint32 productGroupId_, uint32 productVersionId_, bool productVersionIsDirty_, uint64 productVersionDate_, const ::std::string& productName_, uint32 productTypeMask_, const ::std::vector< RegionSet >& regionSet_, const ::std::vector< UpdateRegion >& updateRegions_);

    /**
     * Destructor
     */
    inline  ~Product();

    /**
     * Assignment operator
     */
    inline Product& operator = (const Product& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Product& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Product& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Product& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Product& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "componentId"

    static const int kComponentId = 0;

    /**
     * Clears the field "componentId".
     *
     * The field will be set to its default value. The hasComponentId()
     * method will return false.
     */
    inline void clearComponentId();

    /**
     * Checks whether the field "componentId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentId()). Otherwise it will return false.
     */
    inline bool hasComponentId () const;

    /**
     * Returns the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "componentId"
     */
    inline const ::std::string& getComponentId () const;

    /**
     * Retrieves the value of the field "componentId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "componentId".
     */
    inline ::std::string& getComponentIdMutable ();

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const ::std::string& componentId_);

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const char* componentId_);

    /**
     * Sets the value of the member "componentId".
     *
     * If the meaning of "componentId" isn't clear, then there should be a description here.
     *
     * @param componentId The value which will be set
     */
    inline void setComponentId (const char* value, size_t size);

    // API of field "productId"

    static const int kProductId = 1;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 2;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "baselineMapId"

    static const int kBaselineMapId = 3;

    /**
     * Clears the field "baselineMapId".
     *
     * The field will be set to its default value. The hasBaselineMapId()
     * method will return false.
     */
    inline void clearBaselineMapId();

    /**
     * Checks whether the field "baselineMapId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBaselineMapId()). Otherwise it will return false.
     */
    inline bool hasBaselineMapId () const;

    /**
     * Returns the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "baselineMapId"
     */
    inline uint32 getBaselineMapId () const;

    /**
     * Sets the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @param baselineMapId The value which will be set
     */
    inline void setBaselineMapId (uint32 baselineMapId_);

    // API of field "productGroupId"

    static const int kProductGroupId = 4;

    /**
     * Clears the field "productGroupId".
     *
     * The field will be set to its default value. The hasProductGroupId()
     * method will return false.
     */
    inline void clearProductGroupId();

    /**
     * Checks whether the field "productGroupId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductGroupId()). Otherwise it will return false.
     */
    inline bool hasProductGroupId () const;

    /**
     * Returns the value of the member "productGroupId".
     *
     * If the meaning of "productGroupId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productGroupId"
     */
    inline uint32 getProductGroupId () const;

    /**
     * Sets the value of the member "productGroupId".
     *
     * If the meaning of "productGroupId" isn't clear, then there should be a description here.
     *
     * @param productGroupId The value which will be set
     */
    inline void setProductGroupId (uint32 productGroupId_);

    // API of field "productVersionId"

    static const int kProductVersionId = 5;

    /**
     * Clears the field "productVersionId".
     *
     * The field will be set to its default value. The hasProductVersionId()
     * method will return false.
     */
    inline void clearProductVersionId();

    /**
     * Checks whether the field "productVersionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductVersionId()). Otherwise it will return false.
     */
    inline bool hasProductVersionId () const;

    /**
     * Returns the value of the member "productVersionId".
     *
     * If the meaning of "productVersionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productVersionId"
     */
    inline uint32 getProductVersionId () const;

    /**
     * Sets the value of the member "productVersionId".
     *
     * If the meaning of "productVersionId" isn't clear, then there should be a description here.
     *
     * @param productVersionId The value which will be set
     */
    inline void setProductVersionId (uint32 productVersionId_);

    // API of field "productVersionIsDirty"

    static const int kProductVersionIsDirty = 6;

    /**
     * Clears the field "productVersionIsDirty".
     *
     * The field will be set to its default value. The hasProductVersionIsDirty()
     * method will return false.
     */
    inline void clearProductVersionIsDirty();

    /**
     * Checks whether the field "productVersionIsDirty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductVersionIsDirty()). Otherwise it will return false.
     */
    inline bool hasProductVersionIsDirty () const;

    /**
     * Returns the value of the member "productVersionIsDirty".
     *
     * If the meaning of "productVersionIsDirty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productVersionIsDirty"
     */
    inline bool getProductVersionIsDirty () const;

    /**
     * Sets the value of the member "productVersionIsDirty".
     *
     * If the meaning of "productVersionIsDirty" isn't clear, then there should be a description here.
     *
     * @param productVersionIsDirty The value which will be set
     */
    inline void setProductVersionIsDirty (bool productVersionIsDirty_);

    // API of field "productVersionDate"

    static const int kProductVersionDate = 7;

    /**
     * Clears the field "productVersionDate".
     *
     * The field will be set to its default value. The hasProductVersionDate()
     * method will return false.
     */
    inline void clearProductVersionDate();

    /**
     * Checks whether the field "productVersionDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductVersionDate()). Otherwise it will return false.
     */
    inline bool hasProductVersionDate () const;

    /**
     * Returns the value of the member "productVersionDate".
     *
     * If the meaning of "productVersionDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productVersionDate"
     */
    inline uint64 getProductVersionDate () const;

    /**
     * Sets the value of the member "productVersionDate".
     *
     * If the meaning of "productVersionDate" isn't clear, then there should be a description here.
     *
     * @param productVersionDate The value which will be set
     */
    inline void setProductVersionDate (uint64 productVersionDate_);

    // API of field "productName"

    static const int kProductName = 8;

    /**
     * Clears the field "productName".
     *
     * The field will be set to its default value. The hasProductName()
     * method will return false.
     */
    inline void clearProductName();

    /**
     * Checks whether the field "productName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductName()). Otherwise it will return false.
     */
    inline bool hasProductName () const;

    /**
     * Returns the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productName"
     */
    inline const ::std::string& getProductName () const;

    /**
     * Retrieves the value of the field "productName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "productName".
     */
    inline ::std::string& getProductNameMutable ();

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const ::std::string& productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* productName_);

    /**
     * Sets the value of the member "productName".
     *
     * If the meaning of "productName" isn't clear, then there should be a description here.
     *
     * @param productName The value which will be set
     */
    inline void setProductName (const char* value, size_t size);

    // API of field "productTypeMask"

    static const int kProductTypeMask = 9;

    /**
     * Clears the field "productTypeMask".
     *
     * The field will be set to its default value. The hasProductTypeMask()
     * method will return false.
     */
    inline void clearProductTypeMask();

    /**
     * Checks whether the field "productTypeMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductTypeMask()). Otherwise it will return false.
     */
    inline bool hasProductTypeMask () const;

    /**
     * Returns the value of the member "productTypeMask".
     *
     * If the meaning of "productTypeMask" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productTypeMask"
     */
    inline uint32 getProductTypeMask () const;

    /**
     * Sets the value of the member "productTypeMask".
     *
     * If the meaning of "productTypeMask" isn't clear, then there should be a description here.
     *
     * @param productTypeMask The value which will be set
     */
    inline void setProductTypeMask (uint32 productTypeMask_);

    // API of field "regionSet"

    static const int kRegionSet = 10;

    /**
     * Clears the field "regionSet".
     *
     * The field will be set to its default value. The hasRegionSet()
     * method will return false.
     */
    inline void clearRegionSet();

    /**
     * Checks whether the field "regionSet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionSet()). Otherwise it will return false.
     */
    inline bool hasRegionSet () const;

    /**
     * Returns the value of the member "regionSet".
     *
     * If the meaning of "regionSet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionSet"
     */
    inline const ::std::vector< RegionSet >& getRegionSet () const;

    /**
     * Retrieves the value of the field "regionSet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionSet".
     */
    inline ::std::vector< RegionSet >& getRegionSetMutable ();

    /**
     * Sets the value of the member "regionSet".
     *
     * If the meaning of "regionSet" isn't clear, then there should be a description here.
     *
     * @param regionSet The value which will be set
     */
    inline void setRegionSet (const ::std::vector< RegionSet >& regionSet_);

    // API of field "updateRegions"

    static const int kUpdateRegions = 11;

    /**
     * Clears the field "updateRegions".
     *
     * The field will be set to its default value. The hasUpdateRegions()
     * method will return false.
     */
    inline void clearUpdateRegions();

    /**
     * Checks whether the field "updateRegions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegions()). Otherwise it will return false.
     */
    inline bool hasUpdateRegions () const;

    /**
     * Returns the value of the member "updateRegions".
     *
     * If the meaning of "updateRegions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegions"
     */
    inline const ::std::vector< UpdateRegion >& getUpdateRegions () const;

    /**
     * Retrieves the value of the field "updateRegions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegions".
     */
    inline ::std::vector< UpdateRegion >& getUpdateRegionsMutable ();

    /**
     * Sets the value of the member "updateRegions".
     *
     * If the meaning of "updateRegions" isn't clear, then there should be a description here.
     *
     * @param updateRegions The value which will be set
     */
    inline void setUpdateRegions (const ::std::vector< UpdateRegion >& updateRegions_);

    static const Product &getDefaultInstance();

private:

    static const ::std::vector< RegionSet >& getRegionSetList_DefaultInstance ();

    static const ::std::vector< UpdateRegion >& getUpdateRegionList_DefaultInstance ();

    inline void set_has_componentId ();

    inline void clear_has_componentId ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_baselineMapId ();

    inline void clear_has_baselineMapId ();

    inline void set_has_productGroupId ();

    inline void clear_has_productGroupId ();

    inline void set_has_productVersionId ();

    inline void clear_has_productVersionId ();

    inline void set_has_productVersionIsDirty ();

    inline void clear_has_productVersionIsDirty ();

    inline void set_has_productVersionDate ();

    inline void clear_has_productVersionDate ();

    inline void set_has_productName ();

    inline void clear_has_productName ();

    inline void set_has_productTypeMask ();

    inline void clear_has_productTypeMask ();

    inline void set_has_regionSet ();

    inline void clear_has_regionSet ();

    inline void set_has_updateRegions ();

    inline void clear_has_updateRegions ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::std::string _componentId;

    uint32 _productId;

    uint32 _supplierId;

    uint32 _baselineMapId;

    uint32 _productGroupId;

    uint32 _productVersionId;

    bool _productVersionIsDirty;

    uint64 _productVersionDate;

    ::std::string _productName;

    uint32 _productTypeMask;

    ::std::vector< RegionSet > _regionSet;

    ::std::vector< UpdateRegion > _updateRegions;

};

/**
 * Structure contains current navigation data content and related information.
 *       The navigationSWVersion tells about the current revision of the navigation software.
 *       The packageId describes the full navigation data as installed and used eg. for full update pacakges.
 *       The NavigationData itself is splitted into multiple products. The use of a product depends on the type of the product.
 *       storeageStatus gives the space free and used by the navigation data. This can be used to estimated if further cahnges can be installed.
 */
class NavDataContext {
public:

    /**
     * Default constructor
     */
    inline  NavDataContext ();

    /**
     * Copy constructor
     */
    inline  NavDataContext (const NavDataContext &rhs);

    /**
     * All fields constructor
     */
    inline  NavDataContext (const ::std::string& navigationSWVersion_, const ::std::string& packageId_, const ::std::vector< Product >& products_, const StorageSpace& storageSpace_);

    /**
     * Destructor
     */
    inline  ~NavDataContext();

    /**
     * Assignment operator
     */
    inline NavDataContext& operator = (const NavDataContext& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataContext& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataContext& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataContext& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataContext& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navigationSWVersion"

    static const int kNavigationSWVersion = 0;

    /**
     * Clears the field "navigationSWVersion".
     *
     * The field will be set to its default value. The hasNavigationSWVersion()
     * method will return false.
     */
    inline void clearNavigationSWVersion();

    /**
     * Checks whether the field "navigationSWVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigationSWVersion()). Otherwise it will return false.
     */
    inline bool hasNavigationSWVersion () const;

    /**
     * Returns the value of the member "navigationSWVersion".
     *
     * If the meaning of "navigationSWVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "navigationSWVersion"
     */
    inline const ::std::string& getNavigationSWVersion () const;

    /**
     * Retrieves the value of the field "navigationSWVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "navigationSWVersion".
     */
    inline ::std::string& getNavigationSWVersionMutable ();

    /**
     * Sets the value of the member "navigationSWVersion".
     *
     * If the meaning of "navigationSWVersion" isn't clear, then there should be a description here.
     *
     * @param navigationSWVersion The value which will be set
     */
    inline void setNavigationSWVersion (const ::std::string& navigationSWVersion_);

    /**
     * Sets the value of the member "navigationSWVersion".
     *
     * If the meaning of "navigationSWVersion" isn't clear, then there should be a description here.
     *
     * @param navigationSWVersion The value which will be set
     */
    inline void setNavigationSWVersion (const char* navigationSWVersion_);

    /**
     * Sets the value of the member "navigationSWVersion".
     *
     * If the meaning of "navigationSWVersion" isn't clear, then there should be a description here.
     *
     * @param navigationSWVersion The value which will be set
     */
    inline void setNavigationSWVersion (const char* value, size_t size);

    // API of field "packageId"

    static const int kPackageId = 1;

    /**
     * Clears the field "packageId".
     *
     * The field will be set to its default value. The hasPackageId()
     * method will return false.
     */
    inline void clearPackageId();

    /**
     * Checks whether the field "packageId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPackageId()). Otherwise it will return false.
     */
    inline bool hasPackageId () const;

    /**
     * Returns the value of the member "packageId".
     *
     * If the meaning of "packageId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "packageId"
     */
    inline const ::std::string& getPackageId () const;

    /**
     * Retrieves the value of the field "packageId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "packageId".
     */
    inline ::std::string& getPackageIdMutable ();

    /**
     * Sets the value of the member "packageId".
     *
     * If the meaning of "packageId" isn't clear, then there should be a description here.
     *
     * @param packageId The value which will be set
     */
    inline void setPackageId (const ::std::string& packageId_);

    /**
     * Sets the value of the member "packageId".
     *
     * If the meaning of "packageId" isn't clear, then there should be a description here.
     *
     * @param packageId The value which will be set
     */
    inline void setPackageId (const char* packageId_);

    /**
     * Sets the value of the member "packageId".
     *
     * If the meaning of "packageId" isn't clear, then there should be a description here.
     *
     * @param packageId The value which will be set
     */
    inline void setPackageId (const char* value, size_t size);

    // API of field "products"

    static const int kProducts = 2;

    /**
     * Clears the field "products".
     *
     * The field will be set to its default value. The hasProducts()
     * method will return false.
     */
    inline void clearProducts();

    /**
     * Checks whether the field "products" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProducts()). Otherwise it will return false.
     */
    inline bool hasProducts () const;

    /**
     * Returns the value of the member "products".
     *
     * If the meaning of "products" isn't clear, then there should be a description here.
     *
     * @return The value of the field "products"
     */
    inline const ::std::vector< Product >& getProducts () const;

    /**
     * Retrieves the value of the field "products" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "products".
     */
    inline ::std::vector< Product >& getProductsMutable ();

    /**
     * Sets the value of the member "products".
     *
     * If the meaning of "products" isn't clear, then there should be a description here.
     *
     * @param products The value which will be set
     */
    inline void setProducts (const ::std::vector< Product >& products_);

    // API of field "storageSpace"

    static const int kStorageSpace = 3;

    /**
     * Clears the field "storageSpace".
     *
     * The field will be set to its default value. The hasStorageSpace()
     * method will return false.
     */
    inline void clearStorageSpace();

    /**
     * Checks whether the field "storageSpace" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStorageSpace()). Otherwise it will return false.
     */
    inline bool hasStorageSpace () const;

    /**
     * Returns the value of the member "storageSpace".
     *
     * If the meaning of "storageSpace" isn't clear, then there should be a description here.
     *
     * @return The value of the field "storageSpace"
     */
    inline const StorageSpace& getStorageSpace () const;

    /**
     * Retrieves the value of the field "storageSpace" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "storageSpace".
     */
    inline StorageSpace& getStorageSpaceMutable ();

    /**
     * Sets the value of the member "storageSpace".
     *
     * If the meaning of "storageSpace" isn't clear, then there should be a description here.
     *
     * @param storageSpace The value which will be set
     */
    inline void setStorageSpace (const StorageSpace& storageSpace_);

    static const NavDataContext &getDefaultInstance();

private:

    static const ::std::vector< Product >& getProductList_DefaultInstance ();

    inline void set_has_navigationSWVersion ();

    inline void clear_has_navigationSWVersion ();

    inline void set_has_packageId ();

    inline void clear_has_packageId ();

    inline void set_has_products ();

    inline void clear_has_products ();

    inline void set_has_storageSpace ();

    inline void clear_has_storageSpace ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _navigationSWVersion;

    ::std::string _packageId;

    ::std::vector< Product > _products;

    StorageSpace _storageSpace;

};

/**
 * If the meaning of "DeviceInfo" isn't clear, then there should be a description here.
 */
class DeviceInfo {
public:

    /**
     * Default constructor
     */
    inline  DeviceInfo ();

    /**
     * Copy constructor
     */
    inline  DeviceInfo (const DeviceInfo &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceInfo (uint32 DeviceId_, Devicetype DeviceType_, Devicestatus DeviceStatus_);

    /**
     * Destructor
     */
    inline  ~DeviceInfo();

    /**
     * Assignment operator
     */
    inline DeviceInfo& operator = (const DeviceInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceId"

    static const int kDeviceId = 0;

    /**
     * Clears the field "DeviceId".
     *
     * The field will be set to its default value. The hasDeviceId()
     * method will return false.
     */
    inline void clearDeviceId();

    /**
     * Checks whether the field "DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceId()). Otherwise it will return false.
     */
    inline bool hasDeviceId () const;

    /**
     * Returns the value of the member "DeviceId".
     *
     * If the meaning of "DeviceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceId"
     */
    inline uint32 getDeviceId () const;

    /**
     * Sets the value of the member "DeviceId".
     *
     * If the meaning of "DeviceId" isn't clear, then there should be a description here.
     *
     * @param DeviceId The value which will be set
     */
    inline void setDeviceId (uint32 DeviceId_);

    // API of field "DeviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * If the meaning of "DeviceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceType"
     */
    inline Devicetype getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * If the meaning of "DeviceType" isn't clear, then there should be a description here.
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (Devicetype DeviceType_);

    // API of field "DeviceStatus"

    static const int kDeviceStatus = 2;

    /**
     * Clears the field "DeviceStatus".
     *
     * The field will be set to its default value. The hasDeviceStatus()
     * method will return false.
     */
    inline void clearDeviceStatus();

    /**
     * Checks whether the field "DeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceStatus () const;

    /**
     * Returns the value of the member "DeviceStatus".
     *
     * If the meaning of "DeviceStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatus"
     */
    inline Devicestatus getDeviceStatus () const;

    /**
     * Sets the value of the member "DeviceStatus".
     *
     * If the meaning of "DeviceStatus" isn't clear, then there should be a description here.
     *
     * @param DeviceStatus The value which will be set
     */
    inline void setDeviceStatus (Devicestatus DeviceStatus_);

    static const DeviceInfo &getDefaultInstance();

private:

    inline void set_has_DeviceId ();

    inline void clear_has_DeviceId ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    inline void set_has_DeviceStatus ();

    inline void clear_has_DeviceStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceId;

    Devicetype _DeviceType;

    Devicestatus _DeviceStatus;

};

/**
 * Diagnosis request full update via USB in Diagnostic mode
 *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
 */
class DiagPerformFullUpdateViaUSBResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagPerformFullUpdateViaUSBResponse ();

    /**
     * Copy constructor
     */
    inline  DiagPerformFullUpdateViaUSBResponse (const DiagPerformFullUpdateViaUSBResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DiagPerformFullUpdateViaUSBResponse (NavigationDataUpdateServiceAck ack_);

    /**
     * Destructor
     */
    inline virtual  ~DiagPerformFullUpdateViaUSBResponse();

    /**
     * Assignment operator
     */
    inline DiagPerformFullUpdateViaUSBResponse& operator = (const DiagPerformFullUpdateViaUSBResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagPerformFullUpdateViaUSBResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagPerformFullUpdateViaUSBResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagPerformFullUpdateViaUSBResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagPerformFullUpdateViaUSBResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ack"

    static const int kAck = 0;

    /**
     * Clears the field "ack".
     *
     * The field will be set to its default value. The hasAck()
     * method will return false.
     */
    inline void clearAck();

    /**
     * Checks whether the field "ack" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAck()). Otherwise it will return false.
     */
    inline bool hasAck () const;

    /**
     * Returns the value of the member "ack".
     *
     * If the meaning of "ack" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ack"
     */
    inline NavigationDataUpdateServiceAck getAck () const;

    /**
     * Sets the value of the member "ack".
     *
     * If the meaning of "ack" isn't clear, then there should be a description here.
     *
     * @param ack The value which will be set
     */
    inline void setAck (NavigationDataUpdateServiceAck ack_);

    static const DiagPerformFullUpdateViaUSBResponse &getDefaultInstance();

private:

    inline void set_has_ack ();

    inline void clear_has_ack ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavigationDataUpdateServiceAck _ack;

};

/**
 * Request to get a list of all available updates.
 *        For each update component one entry is contained if an update is available only.
 */
class GetAvailableUpdatesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAvailableUpdatesResponse ();

    /**
     * Copy constructor
     */
    inline  GetAvailableUpdatesResponse (const GetAvailableUpdatesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAvailableUpdatesResponse (const AvailableUpdates& availableUpdates_);

    /**
     * Destructor
     */
    inline virtual  ~GetAvailableUpdatesResponse();

    /**
     * Assignment operator
     */
    inline GetAvailableUpdatesResponse& operator = (const GetAvailableUpdatesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAvailableUpdatesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAvailableUpdatesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAvailableUpdatesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAvailableUpdatesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "availableUpdates"

    static const int kAvailableUpdates = 0;

    /**
     * Clears the field "availableUpdates".
     *
     * The field will be set to its default value. The hasAvailableUpdates()
     * method will return false.
     */
    inline void clearAvailableUpdates();

    /**
     * Checks whether the field "availableUpdates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailableUpdates()). Otherwise it will return false.
     */
    inline bool hasAvailableUpdates () const;

    /**
     * Returns the value of the member "availableUpdates".
     *
     * If the meaning of "availableUpdates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availableUpdates"
     */
    inline const AvailableUpdates& getAvailableUpdates () const;

    /**
     * Retrieves the value of the field "availableUpdates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "availableUpdates".
     */
    inline AvailableUpdates& getAvailableUpdatesMutable ();

    /**
     * Sets the value of the member "availableUpdates".
     *
     * If the meaning of "availableUpdates" isn't clear, then there should be a description here.
     *
     * @param availableUpdates The value which will be set
     */
    inline void setAvailableUpdates (const AvailableUpdates& availableUpdates_);

    static const GetAvailableUpdatesResponse &getDefaultInstance();

private:

    inline void set_has_availableUpdates ();

    inline void clear_has_availableUpdates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    AvailableUpdates _availableUpdates;

};

/**
 * Request to remove an updateable component from the data.
 *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
 */
class DeleteUpdateComponentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteUpdateComponentRequest ();

    /**
     * Copy constructor
     */
    inline  DeleteUpdateComponentRequest (const DeleteUpdateComponentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteUpdateComponentRequest (uint32 productId_, uint32 supplierId_, const ::std::vector< uint32 >& regionId_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteUpdateComponentRequest();

    /**
     * Assignment operator
     */
    inline DeleteUpdateComponentRequest& operator = (const DeleteUpdateComponentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteUpdateComponentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteUpdateComponentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteUpdateComponentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteUpdateComponentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "productId"

    static const int kProductId = 0;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "regionId"

    static const int kRegionId = 2;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline const ::std::vector< uint32 >& getRegionId () const;

    /**
     * Retrieves the value of the field "regionId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionId".
     */
    inline ::std::vector< uint32 >& getRegionIdMutable ();

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (const ::std::vector< uint32 >& regionId_);

    static const DeleteUpdateComponentRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _productId;

    uint32 _supplierId;

    ::std::vector< uint32 > _regionId;

};

/**
 * Request to remove an updateable component from the data.
 *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
 */
class DeleteUpdateComponentResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteUpdateComponentResponse ();

    /**
     * Copy constructor
     */
    inline  DeleteUpdateComponentResponse (const DeleteUpdateComponentResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteUpdateComponentResponse (DeleteUpdateComponentResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteUpdateComponentResponse();

    /**
     * Assignment operator
     */
    inline DeleteUpdateComponentResponse& operator = (const DeleteUpdateComponentResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteUpdateComponentResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteUpdateComponentResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteUpdateComponentResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteUpdateComponentResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline DeleteUpdateComponentResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (DeleteUpdateComponentResult result_);

    static const DeleteUpdateComponentResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DeleteUpdateComponentResult _result;

};

/**
 * Request to change the current favorite update regions (aka home regions).
 *        Usually the user can select a certain country as its favorite region on the HMI.
 *        Selected country can consists of one or more update regions. All update regions relates to the same product.
 *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
 */
class SetFavoriteUpdateRegionsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFavoriteUpdateRegionsRequest ();

    /**
     * Copy constructor
     */
    inline  SetFavoriteUpdateRegionsRequest (const SetFavoriteUpdateRegionsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetFavoriteUpdateRegionsRequest (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< uint32 >& updateRegionIds_);

    /**
     * Destructor
     */
    inline virtual  ~SetFavoriteUpdateRegionsRequest();

    /**
     * Assignment operator
     */
    inline SetFavoriteUpdateRegionsRequest& operator = (const SetFavoriteUpdateRegionsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFavoriteUpdateRegionsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFavoriteUpdateRegionsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFavoriteUpdateRegionsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFavoriteUpdateRegionsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "productId"

    static const int kProductId = 0;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline uint32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (uint32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 1;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline uint32 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (uint32 supplierId_);

    // API of field "baselineMapId"

    static const int kBaselineMapId = 2;

    /**
     * Clears the field "baselineMapId".
     *
     * The field will be set to its default value. The hasBaselineMapId()
     * method will return false.
     */
    inline void clearBaselineMapId();

    /**
     * Checks whether the field "baselineMapId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBaselineMapId()). Otherwise it will return false.
     */
    inline bool hasBaselineMapId () const;

    /**
     * Returns the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "baselineMapId"
     */
    inline uint32 getBaselineMapId () const;

    /**
     * Sets the value of the member "baselineMapId".
     *
     * If the meaning of "baselineMapId" isn't clear, then there should be a description here.
     *
     * @param baselineMapId The value which will be set
     */
    inline void setBaselineMapId (uint32 baselineMapId_);

    // API of field "updateRegionIds"

    static const int kUpdateRegionIds = 3;

    /**
     * Clears the field "updateRegionIds".
     *
     * The field will be set to its default value. The hasUpdateRegionIds()
     * method will return false.
     */
    inline void clearUpdateRegionIds();

    /**
     * Checks whether the field "updateRegionIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionIds()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionIds () const;

    /**
     * Returns the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionIds"
     */
    inline const ::std::vector< uint32 >& getUpdateRegionIds () const;

    /**
     * Retrieves the value of the field "updateRegionIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "updateRegionIds".
     */
    inline ::std::vector< uint32 >& getUpdateRegionIdsMutable ();

    /**
     * Sets the value of the member "updateRegionIds".
     *
     * If the meaning of "updateRegionIds" isn't clear, then there should be a description here.
     *
     * @param updateRegionIds The value which will be set
     */
    inline void setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_);

    static const SetFavoriteUpdateRegionsRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    inline void set_has_baselineMapId ();

    inline void clear_has_baselineMapId ();

    inline void set_has_updateRegionIds ();

    inline void clear_has_updateRegionIds ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _productId;

    uint32 _supplierId;

    uint32 _baselineMapId;

    ::std::vector< uint32 > _updateRegionIds;

};

/**
 * Request to change the current favorite update regions (aka home regions).
 *        Usually the user can select a certain country as its favorite region on the HMI.
 *        Selected country can consists of one or more update regions. All update regions relates to the same product.
 *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
 */
class SetFavoriteUpdateRegionsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFavoriteUpdateRegionsResponse ();

    /**
     * Copy constructor
     */
    inline  SetFavoriteUpdateRegionsResponse (const SetFavoriteUpdateRegionsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetFavoriteUpdateRegionsResponse (SetFavoriteUpdateRegionsResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetFavoriteUpdateRegionsResponse();

    /**
     * Assignment operator
     */
    inline SetFavoriteUpdateRegionsResponse& operator = (const SetFavoriteUpdateRegionsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline SetFavoriteUpdateRegionsResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (SetFavoriteUpdateRegionsResult result_);

    static const SetFavoriteUpdateRegionsResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SetFavoriteUpdateRegionsResult _result;

};

/**
 * Request to remove current favorite region setting.
 */
class ClearFavoriteUpdateRegionsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearFavoriteUpdateRegionsResponse ();

    /**
     * Copy constructor
     */
    inline  ClearFavoriteUpdateRegionsResponse (const ClearFavoriteUpdateRegionsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ClearFavoriteUpdateRegionsResponse (ClearFavoriteUpdateRegionsResult result_);

    /**
     * Destructor
     */
    inline virtual  ~ClearFavoriteUpdateRegionsResponse();

    /**
     * Assignment operator
     */
    inline ClearFavoriteUpdateRegionsResponse& operator = (const ClearFavoriteUpdateRegionsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearFavoriteUpdateRegionsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline ClearFavoriteUpdateRegionsResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (ClearFavoriteUpdateRegionsResult result_);

    static const ClearFavoriteUpdateRegionsResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ClearFavoriteUpdateRegionsResult _result;

};

/**
 * Request to install a full navigation data update if USB full update data is available.
 */
class StartFullUpdateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartFullUpdateResponse ();

    /**
     * Copy constructor
     */
    inline  StartFullUpdateResponse (const StartFullUpdateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartFullUpdateResponse (StartFullUpdateResult result_);

    /**
     * Destructor
     */
    inline virtual  ~StartFullUpdateResponse();

    /**
     * Assignment operator
     */
    inline StartFullUpdateResponse& operator = (const StartFullUpdateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartFullUpdateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartFullUpdateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartFullUpdateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartFullUpdateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline StartFullUpdateResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (StartFullUpdateResult result_);

    static const StartFullUpdateResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    StartFullUpdateResult _result;

};

/**
 * Start MapData Export For A Device ID
 */
class StartMapDataExportRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartMapDataExportRequest ();

    /**
     * Copy constructor
     */
    inline  StartMapDataExportRequest (const StartMapDataExportRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartMapDataExportRequest (uint32 deviceId_, Devicetype deviceType_);

    /**
     * Destructor
     */
    inline virtual  ~StartMapDataExportRequest();

    /**
     * Assignment operator
     */
    inline StartMapDataExportRequest& operator = (const StartMapDataExportRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartMapDataExportRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartMapDataExportRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartMapDataExportRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartMapDataExportRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceId"

    static const int kDeviceId = 0;

    /**
     * Clears the field "deviceId".
     *
     * The field will be set to its default value. The hasDeviceId()
     * method will return false.
     */
    inline void clearDeviceId();

    /**
     * Checks whether the field "deviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceId()). Otherwise it will return false.
     */
    inline bool hasDeviceId () const;

    /**
     * Returns the value of the member "deviceId".
     *
     * If the meaning of "deviceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceId"
     */
    inline uint32 getDeviceId () const;

    /**
     * Sets the value of the member "deviceId".
     *
     * If the meaning of "deviceId" isn't clear, then there should be a description here.
     *
     * @param deviceId The value which will be set
     */
    inline void setDeviceId (uint32 deviceId_);

    // API of field "deviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "deviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "deviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "deviceType".
     *
     * If the meaning of "deviceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceType"
     */
    inline Devicetype getDeviceType () const;

    /**
     * Sets the value of the member "deviceType".
     *
     * If the meaning of "deviceType" isn't clear, then there should be a description here.
     *
     * @param deviceType The value which will be set
     */
    inline void setDeviceType (Devicetype deviceType_);

    static const StartMapDataExportRequest &getDefaultInstance();

private:

    inline void set_has_deviceId ();

    inline void clear_has_deviceId ();

    inline void set_has_deviceType ();

    inline void clear_has_deviceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _deviceId;

    Devicetype _deviceType;

};

/**
 * Start MapData Export For A Device ID
 */
class StartMapDataExportResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartMapDataExportResponse ();

    /**
     * Copy constructor
     */
    inline  StartMapDataExportResponse (const StartMapDataExportResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartMapDataExportResponse (MapExportStartStatus result_);

    /**
     * Destructor
     */
    inline virtual  ~StartMapDataExportResponse();

    /**
     * Assignment operator
     */
    inline StartMapDataExportResponse& operator = (const StartMapDataExportResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartMapDataExportResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartMapDataExportResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartMapDataExportResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartMapDataExportResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline MapExportStartStatus getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (MapExportStartStatus result_);

    static const StartMapDataExportResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapExportStartStatus _result;

};

/**
 * Attribute provides current favorite update regions and its storage status.
 *        Storage status informs about the reason for changing the favorite update regions.
 */
class FavoriteUpdateRegionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FavoriteUpdateRegionsUpdate ();

    /**
     * Copy constructor
     */
    inline  FavoriteUpdateRegionsUpdate (const FavoriteUpdateRegionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FavoriteUpdateRegionsUpdate (const FavoriteUpdateRegions& favoriteUpdateRegions_);

    /**
     * Destructor
     */
    inline virtual  ~FavoriteUpdateRegionsUpdate();

    /**
     * Assignment operator
     */
    inline FavoriteUpdateRegionsUpdate& operator = (const FavoriteUpdateRegionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FavoriteUpdateRegionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FavoriteUpdateRegionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FavoriteUpdateRegionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FavoriteUpdateRegionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "favoriteUpdateRegions"

    static const int kFavoriteUpdateRegions = 0;

    /**
     * Clears the field "favoriteUpdateRegions".
     *
     * The field will be set to its default value. The hasFavoriteUpdateRegions()
     * method will return false.
     */
    inline void clearFavoriteUpdateRegions();

    /**
     * Checks whether the field "favoriteUpdateRegions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteUpdateRegions()). Otherwise it will return false.
     */
    inline bool hasFavoriteUpdateRegions () const;

    /**
     * Returns the value of the member "favoriteUpdateRegions".
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @return The value of the field "favoriteUpdateRegions"
     */
    inline const FavoriteUpdateRegions& getFavoriteUpdateRegions () const;

    /**
     * Retrieves the value of the field "favoriteUpdateRegions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "favoriteUpdateRegions".
     */
    inline FavoriteUpdateRegions& getFavoriteUpdateRegionsMutable ();

    /**
     * Sets the value of the member "favoriteUpdateRegions".
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @param favoriteUpdateRegions The value which will be set
     */
    inline void setFavoriteUpdateRegions (const FavoriteUpdateRegions& favoriteUpdateRegions_);

    static const FavoriteUpdateRegionsUpdate &getDefaultInstance();

private:

    inline void set_has_favoriteUpdateRegions ();

    inline void clear_has_favoriteUpdateRegions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    FavoriteUpdateRegions _favoriteUpdateRegions;

};

/**
 * Attribute provides current favorite update regions and its storage status.
 *        Storage status informs about the reason for changing the favorite update regions.
 */
class FavoriteUpdateRegionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FavoriteUpdateRegionsRegister ();

    /**
     * Copy constructor
     */
    inline  FavoriteUpdateRegionsRegister (const FavoriteUpdateRegionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FavoriteUpdateRegionsRegister();

    /**
     * Assignment operator
     */
    inline FavoriteUpdateRegionsRegister& operator = (const FavoriteUpdateRegionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FavoriteUpdateRegionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FavoriteUpdateRegionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FavoriteUpdateRegionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FavoriteUpdateRegionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FavoriteUpdateRegionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the installation status of a certain update region
 */
class InstallationStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstallationStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  InstallationStatusUpdate (const InstallationStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InstallationStatusUpdate (const InstallationStatus& installationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~InstallationStatusUpdate();

    /**
     * Assignment operator
     */
    inline InstallationStatusUpdate& operator = (const InstallationStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstallationStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstallationStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstallationStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstallationStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "installationStatus"

    static const int kInstallationStatus = 0;

    /**
     * Clears the field "installationStatus".
     *
     * The field will be set to its default value. The hasInstallationStatus()
     * method will return false.
     */
    inline void clearInstallationStatus();

    /**
     * Checks whether the field "installationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstallationStatus()). Otherwise it will return false.
     */
    inline bool hasInstallationStatus () const;

    /**
     * Returns the value of the member "installationStatus".
     *
     * Attribute provides the installation status of a certain update region
     *
     * @return The value of the field "installationStatus"
     */
    inline const InstallationStatus& getInstallationStatus () const;

    /**
     * Retrieves the value of the field "installationStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "installationStatus".
     */
    inline InstallationStatus& getInstallationStatusMutable ();

    /**
     * Sets the value of the member "installationStatus".
     *
     * Attribute provides the installation status of a certain update region
     *
     * @param installationStatus The value which will be set
     */
    inline void setInstallationStatus (const InstallationStatus& installationStatus_);

    static const InstallationStatusUpdate &getDefaultInstance();

private:

    inline void set_has_installationStatus ();

    inline void clear_has_installationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    InstallationStatus _installationStatus;

};

/**
 * Attribute provides the installation status of a certain update region
 */
class InstallationStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstallationStatusRegister ();

    /**
     * Copy constructor
     */
    inline  InstallationStatusRegister (const InstallationStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InstallationStatusRegister();

    /**
     * Assignment operator
     */
    inline InstallationStatusRegister& operator = (const InstallationStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstallationStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstallationStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstallationStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstallationStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InstallationStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the navigation data status like UNKNOWN, OK,...
 */
class NavDataStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDataStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  NavDataStatusUpdate (const NavDataStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NavDataStatusUpdate (NavigationDataStatus navDataStatus_);

    /**
     * Destructor
     */
    inline virtual  ~NavDataStatusUpdate();

    /**
     * Assignment operator
     */
    inline NavDataStatusUpdate& operator = (const NavDataStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navDataStatus"

    static const int kNavDataStatus = 0;

    /**
     * Clears the field "navDataStatus".
     *
     * The field will be set to its default value. The hasNavDataStatus()
     * method will return false.
     */
    inline void clearNavDataStatus();

    /**
     * Checks whether the field "navDataStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavDataStatus()). Otherwise it will return false.
     */
    inline bool hasNavDataStatus () const;

    /**
     * Returns the value of the member "navDataStatus".
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @return The value of the field "navDataStatus"
     */
    inline NavigationDataStatus getNavDataStatus () const;

    /**
     * Sets the value of the member "navDataStatus".
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @param navDataStatus The value which will be set
     */
    inline void setNavDataStatus (NavigationDataStatus navDataStatus_);

    static const NavDataStatusUpdate &getDefaultInstance();

private:

    inline void set_has_navDataStatus ();

    inline void clear_has_navDataStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavigationDataStatus _navDataStatus;

};

/**
 * Attribute provides the navigation data status like UNKNOWN, OK,...
 */
class NavDataStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDataStatusRegister ();

    /**
     * Copy constructor
     */
    inline  NavDataStatusRegister (const NavDataStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NavDataStatusRegister();

    /**
     * Assignment operator
     */
    inline NavDataStatusRegister& operator = (const NavDataStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NavDataStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute to get current NavData context (aka map context).
 *        It offers all products with their id's, space on ffs and their update regions.
 *        Also each update region with its own id's, space on ffs are part of the context.
 *        Furthermore the current version id for each product and region is shown.
 */
class NavDataContextUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDataContextUpdate ();

    /**
     * Copy constructor
     */
    inline  NavDataContextUpdate (const NavDataContextUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NavDataContextUpdate (const NavDataContext& navDataContext_);

    /**
     * Destructor
     */
    inline virtual  ~NavDataContextUpdate();

    /**
     * Assignment operator
     */
    inline NavDataContextUpdate& operator = (const NavDataContextUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataContextUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataContextUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataContextUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataContextUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navDataContext"

    static const int kNavDataContext = 0;

    /**
     * Clears the field "navDataContext".
     *
     * The field will be set to its default value. The hasNavDataContext()
     * method will return false.
     */
    inline void clearNavDataContext();

    /**
     * Checks whether the field "navDataContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavDataContext()). Otherwise it will return false.
     */
    inline bool hasNavDataContext () const;

    /**
     * Returns the value of the member "navDataContext".
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @return The value of the field "navDataContext"
     */
    inline const NavDataContext& getNavDataContext () const;

    /**
     * Retrieves the value of the field "navDataContext" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "navDataContext".
     */
    inline NavDataContext& getNavDataContextMutable ();

    /**
     * Sets the value of the member "navDataContext".
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @param navDataContext The value which will be set
     */
    inline void setNavDataContext (const NavDataContext& navDataContext_);

    static const NavDataContextUpdate &getDefaultInstance();

private:

    inline void set_has_navDataContext ();

    inline void clear_has_navDataContext ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavDataContext _navDataContext;

};

/**
 * Attribute to get current NavData context (aka map context).
 *        It offers all products with their id's, space on ffs and their update regions.
 *        Also each update region with its own id's, space on ffs are part of the context.
 *        Furthermore the current version id for each product and region is shown.
 */
class NavDataContextRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavDataContextRegister ();

    /**
     * Copy constructor
     */
    inline  NavDataContextRegister (const NavDataContextRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NavDataContextRegister();

    /**
     * Assignment operator
     */
    inline NavDataContextRegister& operator = (const NavDataContextRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavDataContextRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavDataContextRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavDataContextRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavDataContextRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NavDataContextRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
 */
class NavigationDataUpdateStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavigationDataUpdateStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  NavigationDataUpdateStatusInfoUpdate (const NavigationDataUpdateStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NavigationDataUpdateStatusInfoUpdate (const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~NavigationDataUpdateStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline NavigationDataUpdateStatusInfoUpdate& operator = (const NavigationDataUpdateStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationDataUpdateStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationDataUpdateStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationDataUpdateStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationDataUpdateStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navigationDataUpdateStatusInfo"

    static const int kNavigationDataUpdateStatusInfo = 0;

    /**
     * Clears the field "navigationDataUpdateStatusInfo".
     *
     * The field will be set to its default value. The hasNavigationDataUpdateStatusInfo()
     * method will return false.
     */
    inline void clearNavigationDataUpdateStatusInfo();

    /**
     * Checks whether the field "navigationDataUpdateStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigationDataUpdateStatusInfo()). Otherwise it will return false.
     */
    inline bool hasNavigationDataUpdateStatusInfo () const;

    /**
     * Returns the value of the member "navigationDataUpdateStatusInfo".
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @return The value of the field "navigationDataUpdateStatusInfo"
     */
    inline const NavigationDataUpdateStatusInfo& getNavigationDataUpdateStatusInfo () const;

    /**
     * Retrieves the value of the field "navigationDataUpdateStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "navigationDataUpdateStatusInfo".
     */
    inline NavigationDataUpdateStatusInfo& getNavigationDataUpdateStatusInfoMutable ();

    /**
     * Sets the value of the member "navigationDataUpdateStatusInfo".
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @param navigationDataUpdateStatusInfo The value which will be set
     */
    inline void setNavigationDataUpdateStatusInfo (const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo_);

    static const NavigationDataUpdateStatusInfoUpdate &getDefaultInstance();

private:

    inline void set_has_navigationDataUpdateStatusInfo ();

    inline void clear_has_navigationDataUpdateStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavigationDataUpdateStatusInfo _navigationDataUpdateStatusInfo;

};

/**
 * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
 */
class NavigationDataUpdateStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavigationDataUpdateStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  NavigationDataUpdateStatusInfoRegister (const NavigationDataUpdateStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NavigationDataUpdateStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline NavigationDataUpdateStatusInfoRegister& operator = (const NavigationDataUpdateStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationDataUpdateStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationDataUpdateStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationDataUpdateStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationDataUpdateStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NavigationDataUpdateStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute to get current catalogue status
 */
class CatalogueStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CatalogueStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  CatalogueStatusUpdate (const CatalogueStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CatalogueStatusUpdate (CatalogueStatus catalogueStatus_);

    /**
     * Destructor
     */
    inline virtual  ~CatalogueStatusUpdate();

    /**
     * Assignment operator
     */
    inline CatalogueStatusUpdate& operator = (const CatalogueStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CatalogueStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CatalogueStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CatalogueStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CatalogueStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "catalogueStatus"

    static const int kCatalogueStatus = 0;

    /**
     * Clears the field "catalogueStatus".
     *
     * The field will be set to its default value. The hasCatalogueStatus()
     * method will return false.
     */
    inline void clearCatalogueStatus();

    /**
     * Checks whether the field "catalogueStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCatalogueStatus()). Otherwise it will return false.
     */
    inline bool hasCatalogueStatus () const;

    /**
     * Returns the value of the member "catalogueStatus".
     *
     * Attribute to get current catalogue status
     *
     * @return The value of the field "catalogueStatus"
     */
    inline CatalogueStatus getCatalogueStatus () const;

    /**
     * Sets the value of the member "catalogueStatus".
     *
     * Attribute to get current catalogue status
     *
     * @param catalogueStatus The value which will be set
     */
    inline void setCatalogueStatus (CatalogueStatus catalogueStatus_);

    static const CatalogueStatusUpdate &getDefaultInstance();

private:

    inline void set_has_catalogueStatus ();

    inline void clear_has_catalogueStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    CatalogueStatus _catalogueStatus;

};

/**
 * Attribute to get current catalogue status
 */
class CatalogueStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CatalogueStatusRegister ();

    /**
     * Copy constructor
     */
    inline  CatalogueStatusRegister (const CatalogueStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CatalogueStatusRegister();

    /**
     * Assignment operator
     */
    inline CatalogueStatusRegister& operator = (const CatalogueStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CatalogueStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CatalogueStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CatalogueStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CatalogueStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CatalogueStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute to get mapdataExport Status
 */
class MapupdateExportStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapupdateExportStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  MapupdateExportStatusUpdate (const MapupdateExportStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MapupdateExportStatusUpdate (MapupdateExportStatus mapupdateExportStatus_);

    /**
     * Destructor
     */
    inline virtual  ~MapupdateExportStatusUpdate();

    /**
     * Assignment operator
     */
    inline MapupdateExportStatusUpdate& operator = (const MapupdateExportStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapupdateExportStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapupdateExportStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapupdateExportStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapupdateExportStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mapupdateExportStatus"

    static const int kMapupdateExportStatus = 0;

    /**
     * Clears the field "mapupdateExportStatus".
     *
     * The field will be set to its default value. The hasMapupdateExportStatus()
     * method will return false.
     */
    inline void clearMapupdateExportStatus();

    /**
     * Checks whether the field "mapupdateExportStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapupdateExportStatus()). Otherwise it will return false.
     */
    inline bool hasMapupdateExportStatus () const;

    /**
     * Returns the value of the member "mapupdateExportStatus".
     *
     * Attribute to get mapdataExport Status
     *
     * @return The value of the field "mapupdateExportStatus"
     */
    inline MapupdateExportStatus getMapupdateExportStatus () const;

    /**
     * Sets the value of the member "mapupdateExportStatus".
     *
     * Attribute to get mapdataExport Status
     *
     * @param mapupdateExportStatus The value which will be set
     */
    inline void setMapupdateExportStatus (MapupdateExportStatus mapupdateExportStatus_);

    static const MapupdateExportStatusUpdate &getDefaultInstance();

private:

    inline void set_has_mapupdateExportStatus ();

    inline void clear_has_mapupdateExportStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapupdateExportStatus _mapupdateExportStatus;

};

/**
 * Attribute to get mapdataExport Status
 */
class MapupdateExportStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapupdateExportStatusRegister ();

    /**
     * Copy constructor
     */
    inline  MapupdateExportStatusRegister (const MapupdateExportStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MapupdateExportStatusRegister();

    /**
     * Assignment operator
     */
    inline MapupdateExportStatusRegister& operator = (const MapupdateExportStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapupdateExportStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapupdateExportStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapupdateExportStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapupdateExportStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MapupdateExportStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute to get DeviceInfos Details
 */
class DeviceInfosUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceInfosUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceInfosUpdate (const DeviceInfosUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceInfosUpdate (const ::std::vector< DeviceInfo >& deviceInfos_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceInfosUpdate();

    /**
     * Assignment operator
     */
    inline DeviceInfosUpdate& operator = (const DeviceInfosUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceInfosUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceInfosUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceInfosUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceInfosUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceInfos"

    static const int kDeviceInfos = 0;

    /**
     * Clears the field "deviceInfos".
     *
     * The field will be set to its default value. The hasDeviceInfos()
     * method will return false.
     */
    inline void clearDeviceInfos();

    /**
     * Checks whether the field "deviceInfos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceInfos()). Otherwise it will return false.
     */
    inline bool hasDeviceInfos () const;

    /**
     * Returns the value of the member "deviceInfos".
     *
     * Attribute to get DeviceInfos Details
     *
     * @return The value of the field "deviceInfos"
     */
    inline const ::std::vector< DeviceInfo >& getDeviceInfos () const;

    /**
     * Retrieves the value of the field "deviceInfos" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceInfos".
     */
    inline ::std::vector< DeviceInfo >& getDeviceInfosMutable ();

    /**
     * Sets the value of the member "deviceInfos".
     *
     * Attribute to get DeviceInfos Details
     *
     * @param deviceInfos The value which will be set
     */
    inline void setDeviceInfos (const ::std::vector< DeviceInfo >& deviceInfos_);

    static const DeviceInfosUpdate &getDefaultInstance();

private:

    static const ::std::vector< DeviceInfo >& getDeviceInfoList_DefaultInstance ();

    inline void set_has_deviceInfos ();

    inline void clear_has_deviceInfos ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DeviceInfo > _deviceInfos;

};

/**
 * Attribute to get DeviceInfos Details
 */
class DeviceInfosRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceInfosRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceInfosRegister (const DeviceInfosRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceInfosRegister();

    /**
     * Assignment operator
     */
    inline DeviceInfosRegister& operator = (const DeviceInfosRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceInfosRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceInfosRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceInfosRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceInfosRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceInfosRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  FavoriteUpdateRegionData::FavoriteUpdateRegionData ()  :
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegionData::FavoriteUpdateRegionData (const FavoriteUpdateRegionData &rhs)  :
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FavoriteUpdateRegionData::FavoriteUpdateRegionData (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< uint32 >& updateRegionIds_)  :
    _productId (productId_),
    _supplierId (supplierId_),
    _baselineMapId (baselineMapId_),
    _updateRegionIds (updateRegionIds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegionData::~FavoriteUpdateRegionData() {
}

inline FavoriteUpdateRegionData& FavoriteUpdateRegionData::operator = (const FavoriteUpdateRegionData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasBaselineMapId()) {
            setBaselineMapId(rhs.getBaselineMapId());
        } else {
            clearBaselineMapId();
        }
        if (rhs.hasUpdateRegionIds()) {
            setUpdateRegionIds(rhs.getUpdateRegionIds());
        } else {
            clearUpdateRegionIds();
        }
    }
    return *this;
}

inline bool FavoriteUpdateRegionData::operator == (const FavoriteUpdateRegionData& rhs) const {
    return (((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasBaselineMapId() && !rhs.hasBaselineMapId()) || getBaselineMapId() == rhs.getBaselineMapId()) &&
        ((!hasUpdateRegionIds() && !rhs.hasUpdateRegionIds()) || getUpdateRegionIds() == rhs.getUpdateRegionIds()));
}

inline bool FavoriteUpdateRegionData::operator != (const FavoriteUpdateRegionData& rhs) const {
    return ! (*this == rhs);
}

inline bool FavoriteUpdateRegionData::operator < (const FavoriteUpdateRegionData& rhs) const {
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasBaselineMapId() || rhs.hasBaselineMapId()) {
        if (getBaselineMapId() < rhs.getBaselineMapId()) return true;
        if (getBaselineMapId() > rhs.getBaselineMapId()) return false;
    }
    if (hasUpdateRegionIds() || rhs.hasUpdateRegionIds()) {
        if (getUpdateRegionIds() < rhs.getUpdateRegionIds()) return true;
        if (getUpdateRegionIds() > rhs.getUpdateRegionIds()) return false;
    }
    return false;
}

inline bool FavoriteUpdateRegionData::operator > (const FavoriteUpdateRegionData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FavoriteUpdateRegionData::clear() {
    clearProductId();
    clearSupplierId();
    clearBaselineMapId();
    clearUpdateRegionIds();
}

inline void FavoriteUpdateRegionData::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool FavoriteUpdateRegionData::hasProductId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FavoriteUpdateRegionData::getProductId () const {
    return _productId;
}

inline void FavoriteUpdateRegionData::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void FavoriteUpdateRegionData::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool FavoriteUpdateRegionData::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FavoriteUpdateRegionData::getSupplierId () const {
    return _supplierId;
}

inline void FavoriteUpdateRegionData::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void FavoriteUpdateRegionData::clearBaselineMapId() {
    if (hasBaselineMapId()) {
         clear_has_baselineMapId();
        _baselineMapId = 0u;
     }
}

inline bool FavoriteUpdateRegionData::hasBaselineMapId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 FavoriteUpdateRegionData::getBaselineMapId () const {
    return _baselineMapId;
}

inline void FavoriteUpdateRegionData::setBaselineMapId (uint32 baselineMapId_) {
    set_has_baselineMapId();
    this->_baselineMapId = baselineMapId_;
}

inline void FavoriteUpdateRegionData::clearUpdateRegionIds() {
    if (hasUpdateRegionIds()) {
         clear_has_updateRegionIds();
        _updateRegionIds.clear();
     }
}

inline bool FavoriteUpdateRegionData::hasUpdateRegionIds () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint32 >& FavoriteUpdateRegionData::getUpdateRegionIds () const {
    return _updateRegionIds;
}

inline ::std::vector< uint32 >& FavoriteUpdateRegionData::getUpdateRegionIdsMutable () {
    set_has_updateRegionIds();
    return _updateRegionIds;
}

inline void FavoriteUpdateRegionData::setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_) {
    set_has_updateRegionIds();
    this->_updateRegionIds = updateRegionIds_;
}

inline void FavoriteUpdateRegionData::set_has_productId () {
    _has_bits_[0] |= 1u << 0;
}

inline void FavoriteUpdateRegionData::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FavoriteUpdateRegionData::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void FavoriteUpdateRegionData::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FavoriteUpdateRegionData::set_has_baselineMapId () {
    _has_bits_[0] |= 1u << 2;
}

inline void FavoriteUpdateRegionData::clear_has_baselineMapId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FavoriteUpdateRegionData::set_has_updateRegionIds () {
    _has_bits_[0] |= 1u << 3;
}

inline void FavoriteUpdateRegionData::clear_has_updateRegionIds () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  FavoriteUpdateRegions::FavoriteUpdateRegions ()  :
    _favoriteUpdateRegionStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus__UKNOWN_STATUS),
    _favoriteUpdateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegions::FavoriteUpdateRegions (const FavoriteUpdateRegions &rhs)  :
    _favoriteUpdateRegionStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus__UKNOWN_STATUS),
    _favoriteUpdateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FavoriteUpdateRegions::FavoriteUpdateRegions (FavoriteUpdateRegionStatus favoriteUpdateRegionStatus_, const FavoriteUpdateRegionData& favoriteUpdateRegions_)  :
    _favoriteUpdateRegionStatus (favoriteUpdateRegionStatus_),
    _favoriteUpdateRegions (favoriteUpdateRegions_)
{
    #ifndef NDEBUG
    if (!(FavoriteUpdateRegionStatus_IsValid(favoriteUpdateRegionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", favoriteUpdateRegionStatus_, "FavoriteUpdateRegionStatus", "favoriteUpdateRegionStatus", "FavoriteUpdateRegions");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegions::~FavoriteUpdateRegions() {
}

inline FavoriteUpdateRegions& FavoriteUpdateRegions::operator = (const FavoriteUpdateRegions& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFavoriteUpdateRegionStatus()) {
            setFavoriteUpdateRegionStatus(rhs.getFavoriteUpdateRegionStatus());
        } else {
            clearFavoriteUpdateRegionStatus();
        }
        if (rhs.hasFavoriteUpdateRegions()) {
            setFavoriteUpdateRegions(rhs.getFavoriteUpdateRegions());
        } else {
            clearFavoriteUpdateRegions();
        }
    }
    return *this;
}

inline bool FavoriteUpdateRegions::operator == (const FavoriteUpdateRegions& rhs) const {
    return (((!hasFavoriteUpdateRegionStatus() && !rhs.hasFavoriteUpdateRegionStatus()) || getFavoriteUpdateRegionStatus() == rhs.getFavoriteUpdateRegionStatus()) &&
        ((!hasFavoriteUpdateRegions() && !rhs.hasFavoriteUpdateRegions()) || getFavoriteUpdateRegions() == rhs.getFavoriteUpdateRegions()));
}

inline bool FavoriteUpdateRegions::operator != (const FavoriteUpdateRegions& rhs) const {
    return ! (*this == rhs);
}

inline bool FavoriteUpdateRegions::operator < (const FavoriteUpdateRegions& rhs) const {
    if (hasFavoriteUpdateRegionStatus() || rhs.hasFavoriteUpdateRegionStatus()) {
        if ((uint32)getFavoriteUpdateRegionStatus() < (uint32)rhs.getFavoriteUpdateRegionStatus()) return true;
        if ((uint32)getFavoriteUpdateRegionStatus() > (uint32)rhs.getFavoriteUpdateRegionStatus()) return false;
    }
    if (hasFavoriteUpdateRegions() || rhs.hasFavoriteUpdateRegions()) {
        if (getFavoriteUpdateRegions() < rhs.getFavoriteUpdateRegions()) return true;
        if (getFavoriteUpdateRegions() > rhs.getFavoriteUpdateRegions()) return false;
    }
    return false;
}

inline bool FavoriteUpdateRegions::operator > (const FavoriteUpdateRegions& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FavoriteUpdateRegions::clear() {
    clearFavoriteUpdateRegionStatus();
    clearFavoriteUpdateRegions();
}

inline void FavoriteUpdateRegions::clearFavoriteUpdateRegionStatus() {
    if (hasFavoriteUpdateRegionStatus()) {
         clear_has_favoriteUpdateRegionStatus();
        _favoriteUpdateRegionStatus = ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus__UKNOWN_STATUS;
     }
}

inline bool FavoriteUpdateRegions::hasFavoriteUpdateRegionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline FavoriteUpdateRegionStatus FavoriteUpdateRegions::getFavoriteUpdateRegionStatus () const {
    return _favoriteUpdateRegionStatus;
}

inline void FavoriteUpdateRegions::setFavoriteUpdateRegionStatus (FavoriteUpdateRegionStatus favoriteUpdateRegionStatus_) {
    #ifndef NDEBUG
    if (!(FavoriteUpdateRegionStatus_IsValid(favoriteUpdateRegionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", favoriteUpdateRegionStatus_, "FavoriteUpdateRegionStatus", "favoriteUpdateRegionStatus", "FavoriteUpdateRegions");
    }
    #endif
    set_has_favoriteUpdateRegionStatus();
    this->_favoriteUpdateRegionStatus = favoriteUpdateRegionStatus_;
}

inline void FavoriteUpdateRegions::clearFavoriteUpdateRegions() {
    if (hasFavoriteUpdateRegions()) {
         clear_has_favoriteUpdateRegions();
        _favoriteUpdateRegions.clear();
     }
}

inline bool FavoriteUpdateRegions::hasFavoriteUpdateRegions () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const FavoriteUpdateRegionData& FavoriteUpdateRegions::getFavoriteUpdateRegions () const {
    return _favoriteUpdateRegions;
}

inline FavoriteUpdateRegionData& FavoriteUpdateRegions::getFavoriteUpdateRegionsMutable () {
    set_has_favoriteUpdateRegions();
    return _favoriteUpdateRegions;
}

inline void FavoriteUpdateRegions::setFavoriteUpdateRegions (const FavoriteUpdateRegionData& favoriteUpdateRegions_) {
    set_has_favoriteUpdateRegions();
    this->_favoriteUpdateRegions = favoriteUpdateRegions_;
}

inline void FavoriteUpdateRegions::set_has_favoriteUpdateRegionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FavoriteUpdateRegions::clear_has_favoriteUpdateRegionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FavoriteUpdateRegions::set_has_favoriteUpdateRegions () {
    _has_bits_[0] |= 1u << 1;
}

inline void FavoriteUpdateRegions::clear_has_favoriteUpdateRegions () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  NavigationDataUpdateStatusInfo::NavigationDataUpdateStatusInfo ()  :
    _status (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus__IDLE),
    _progressValue (0u),
    _remainingTimeInSecond (0u),
    _productName (),
    _regionName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavigationDataUpdateStatusInfo::NavigationDataUpdateStatusInfo (const NavigationDataUpdateStatusInfo &rhs)  :
    _status (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus__IDLE),
    _progressValue (0u),
    _remainingTimeInSecond (0u),
    _productName (),
    _regionName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavigationDataUpdateStatusInfo::NavigationDataUpdateStatusInfo (NavigationDataUpdateStatus status_, uint8 progressValue_, uint32 remainingTimeInSecond_, const ::std::string& productName_, const ::std::string& regionName_)  :
    _status (status_),
    _progressValue (progressValue_),
    _remainingTimeInSecond (remainingTimeInSecond_),
    _productName (productName_),
    _regionName (regionName_)
{
    #ifndef NDEBUG
    if (!(NavigationDataUpdateStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "NavigationDataUpdateStatus", "status", "NavigationDataUpdateStatusInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavigationDataUpdateStatusInfo::~NavigationDataUpdateStatusInfo() {
}

inline NavigationDataUpdateStatusInfo& NavigationDataUpdateStatusInfo::operator = (const NavigationDataUpdateStatusInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasProgressValue()) {
            setProgressValue(rhs.getProgressValue());
        } else {
            clearProgressValue();
        }
        if (rhs.hasRemainingTimeInSecond()) {
            setRemainingTimeInSecond(rhs.getRemainingTimeInSecond());
        } else {
            clearRemainingTimeInSecond();
        }
        if (rhs.hasProductName()) {
            setProductName(rhs.getProductName());
        } else {
            clearProductName();
        }
        if (rhs.hasRegionName()) {
            setRegionName(rhs.getRegionName());
        } else {
            clearRegionName();
        }
    }
    return *this;
}

inline bool NavigationDataUpdateStatusInfo::operator == (const NavigationDataUpdateStatusInfo& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasProgressValue() && !rhs.hasProgressValue()) || getProgressValue() == rhs.getProgressValue()) &&
        ((!hasRemainingTimeInSecond() && !rhs.hasRemainingTimeInSecond()) || getRemainingTimeInSecond() == rhs.getRemainingTimeInSecond()) &&
        ((!hasProductName() && !rhs.hasProductName()) || getProductName() == rhs.getProductName()) &&
        ((!hasRegionName() && !rhs.hasRegionName()) || getRegionName() == rhs.getRegionName()));
}

inline bool NavigationDataUpdateStatusInfo::operator != (const NavigationDataUpdateStatusInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool NavigationDataUpdateStatusInfo::operator < (const NavigationDataUpdateStatusInfo& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasProgressValue() || rhs.hasProgressValue()) {
        if (getProgressValue() < rhs.getProgressValue()) return true;
        if (getProgressValue() > rhs.getProgressValue()) return false;
    }
    if (hasRemainingTimeInSecond() || rhs.hasRemainingTimeInSecond()) {
        if (getRemainingTimeInSecond() < rhs.getRemainingTimeInSecond()) return true;
        if (getRemainingTimeInSecond() > rhs.getRemainingTimeInSecond()) return false;
    }
    if (hasProductName() || rhs.hasProductName()) {
        if (getProductName() < rhs.getProductName()) return true;
        if (getProductName() > rhs.getProductName()) return false;
    }
    if (hasRegionName() || rhs.hasRegionName()) {
        if (getRegionName() < rhs.getRegionName()) return true;
        if (getRegionName() > rhs.getRegionName()) return false;
    }
    return false;
}

inline bool NavigationDataUpdateStatusInfo::operator > (const NavigationDataUpdateStatusInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavigationDataUpdateStatusInfo::clear() {
    clearStatus();
    clearProgressValue();
    clearRemainingTimeInSecond();
    clearProductName();
    clearRegionName();
}

inline void NavigationDataUpdateStatusInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus__IDLE;
     }
}

inline bool NavigationDataUpdateStatusInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NavigationDataUpdateStatus NavigationDataUpdateStatusInfo::getStatus () const {
    return _status;
}

inline void NavigationDataUpdateStatusInfo::setStatus (NavigationDataUpdateStatus status_) {
    #ifndef NDEBUG
    if (!(NavigationDataUpdateStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "NavigationDataUpdateStatus", "status", "NavigationDataUpdateStatusInfo");
    }
    #endif
    set_has_status();
    this->_status = status_;
}

inline void NavigationDataUpdateStatusInfo::clearProgressValue() {
    if (hasProgressValue()) {
         clear_has_progressValue();
        _progressValue = 0u;
     }
}

inline bool NavigationDataUpdateStatusInfo::hasProgressValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 NavigationDataUpdateStatusInfo::getProgressValue () const {
    return _progressValue;
}

inline void NavigationDataUpdateStatusInfo::setProgressValue (uint8 progressValue_) {
    set_has_progressValue();
    this->_progressValue = progressValue_;
}

inline void NavigationDataUpdateStatusInfo::clearRemainingTimeInSecond() {
    if (hasRemainingTimeInSecond()) {
         clear_has_remainingTimeInSecond();
        _remainingTimeInSecond = 0u;
     }
}

inline bool NavigationDataUpdateStatusInfo::hasRemainingTimeInSecond () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 NavigationDataUpdateStatusInfo::getRemainingTimeInSecond () const {
    return _remainingTimeInSecond;
}

inline void NavigationDataUpdateStatusInfo::setRemainingTimeInSecond (uint32 remainingTimeInSecond_) {
    set_has_remainingTimeInSecond();
    this->_remainingTimeInSecond = remainingTimeInSecond_;
}

inline void NavigationDataUpdateStatusInfo::clearProductName() {
    if (hasProductName()) {
         clear_has_productName();
        _productName.clear();
     }
}

inline bool NavigationDataUpdateStatusInfo::hasProductName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& NavigationDataUpdateStatusInfo::getProductName () const {
    return _productName;
}

inline ::std::string& NavigationDataUpdateStatusInfo::getProductNameMutable () {
    set_has_productName();
    return _productName;
}

inline void NavigationDataUpdateStatusInfo::setProductName (const ::std::string& productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName = productName_;
}

inline void NavigationDataUpdateStatusInfo::setProductName (const char* productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(productName_);
}

inline void NavigationDataUpdateStatusInfo::setProductName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(value, size);
}

inline void NavigationDataUpdateStatusInfo::clearRegionName() {
    if (hasRegionName()) {
         clear_has_regionName();
        _regionName.clear();
     }
}

inline bool NavigationDataUpdateStatusInfo::hasRegionName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& NavigationDataUpdateStatusInfo::getRegionName () const {
    return _regionName;
}

inline ::std::string& NavigationDataUpdateStatusInfo::getRegionNameMutable () {
    set_has_regionName();
    return _regionName;
}

inline void NavigationDataUpdateStatusInfo::setRegionName (const ::std::string& regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName = regionName_;
}

inline void NavigationDataUpdateStatusInfo::setRegionName (const char* regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(regionName_);
}

inline void NavigationDataUpdateStatusInfo::setRegionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(value, size);
}

inline void NavigationDataUpdateStatusInfo::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavigationDataUpdateStatusInfo::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NavigationDataUpdateStatusInfo::set_has_progressValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void NavigationDataUpdateStatusInfo::clear_has_progressValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NavigationDataUpdateStatusInfo::set_has_remainingTimeInSecond () {
    _has_bits_[0] |= 1u << 2;
}

inline void NavigationDataUpdateStatusInfo::clear_has_remainingTimeInSecond () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void NavigationDataUpdateStatusInfo::set_has_productName () {
    _has_bits_[0] |= 1u << 3;
}

inline void NavigationDataUpdateStatusInfo::clear_has_productName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void NavigationDataUpdateStatusInfo::set_has_regionName () {
    _has_bits_[0] |= 1u << 4;
}

inline void NavigationDataUpdateStatusInfo::clear_has_regionName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  InstallationStatus::InstallationStatus ()  :
    _productId (0u),
    _supplierId (0u),
    _regionId (0u),
    _updateStep (::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep__UPDATE_INACTIVE),
    _percentage (0u),
    _isProductUpdate (false),
    _productName (),
    _regionName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstallationStatus::InstallationStatus (const InstallationStatus &rhs)  :
    _productId (0u),
    _supplierId (0u),
    _regionId (0u),
    _updateStep (::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep__UPDATE_INACTIVE),
    _percentage (0u),
    _isProductUpdate (false),
    _productName (),
    _regionName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstallationStatus::InstallationStatus (uint32 productId_, uint32 supplierId_, uint32 regionId_, UpdateStep updateStep_, uint16 percentage_, bool isProductUpdate_, const ::std::string& productName_, const ::std::string& regionName_)  :
    _productId (productId_),
    _supplierId (supplierId_),
    _regionId (regionId_),
    _updateStep (updateStep_),
    _percentage (percentage_),
    _isProductUpdate (isProductUpdate_),
    _productName (productName_),
    _regionName (regionName_)
{
    #ifndef NDEBUG
    if (!(UpdateStep_IsValid(updateStep_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", updateStep_, "UpdateStep", "updateStep", "InstallationStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InstallationStatus::~InstallationStatus() {
}

inline InstallationStatus& InstallationStatus::operator = (const InstallationStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasUpdateStep()) {
            setUpdateStep(rhs.getUpdateStep());
        } else {
            clearUpdateStep();
        }
        if (rhs.hasPercentage()) {
            setPercentage(rhs.getPercentage());
        } else {
            clearPercentage();
        }
        if (rhs.hasIsProductUpdate()) {
            setIsProductUpdate(rhs.getIsProductUpdate());
        } else {
            clearIsProductUpdate();
        }
        if (rhs.hasProductName()) {
            setProductName(rhs.getProductName());
        } else {
            clearProductName();
        }
        if (rhs.hasRegionName()) {
            setRegionName(rhs.getRegionName());
        } else {
            clearRegionName();
        }
    }
    return *this;
}

inline bool InstallationStatus::operator == (const InstallationStatus& rhs) const {
    return (((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasUpdateStep() && !rhs.hasUpdateStep()) || getUpdateStep() == rhs.getUpdateStep()) &&
        ((!hasPercentage() && !rhs.hasPercentage()) || getPercentage() == rhs.getPercentage()) &&
        ((!hasIsProductUpdate() && !rhs.hasIsProductUpdate()) || getIsProductUpdate() == rhs.getIsProductUpdate()) &&
        ((!hasProductName() && !rhs.hasProductName()) || getProductName() == rhs.getProductName()) &&
        ((!hasRegionName() && !rhs.hasRegionName()) || getRegionName() == rhs.getRegionName()));
}

inline bool InstallationStatus::operator != (const InstallationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool InstallationStatus::operator < (const InstallationStatus& rhs) const {
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasUpdateStep() || rhs.hasUpdateStep()) {
        if ((uint32)getUpdateStep() < (uint32)rhs.getUpdateStep()) return true;
        if ((uint32)getUpdateStep() > (uint32)rhs.getUpdateStep()) return false;
    }
    if (hasPercentage() || rhs.hasPercentage()) {
        if (getPercentage() < rhs.getPercentage()) return true;
        if (getPercentage() > rhs.getPercentage()) return false;
    }
    if (hasIsProductUpdate() || rhs.hasIsProductUpdate()) {
        if (getIsProductUpdate() < rhs.getIsProductUpdate()) return true;
        if (getIsProductUpdate() > rhs.getIsProductUpdate()) return false;
    }
    if (hasProductName() || rhs.hasProductName()) {
        if (getProductName() < rhs.getProductName()) return true;
        if (getProductName() > rhs.getProductName()) return false;
    }
    if (hasRegionName() || rhs.hasRegionName()) {
        if (getRegionName() < rhs.getRegionName()) return true;
        if (getRegionName() > rhs.getRegionName()) return false;
    }
    return false;
}

inline bool InstallationStatus::operator > (const InstallationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstallationStatus::clear() {
    clearProductId();
    clearSupplierId();
    clearRegionId();
    clearUpdateStep();
    clearPercentage();
    clearIsProductUpdate();
    clearProductName();
    clearRegionName();
}

inline void InstallationStatus::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool InstallationStatus::hasProductId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 InstallationStatus::getProductId () const {
    return _productId;
}

inline void InstallationStatus::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void InstallationStatus::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool InstallationStatus::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 InstallationStatus::getSupplierId () const {
    return _supplierId;
}

inline void InstallationStatus::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void InstallationStatus::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool InstallationStatus::hasRegionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 InstallationStatus::getRegionId () const {
    return _regionId;
}

inline void InstallationStatus::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void InstallationStatus::clearUpdateStep() {
    if (hasUpdateStep()) {
         clear_has_updateStep();
        _updateStep = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep__UPDATE_INACTIVE;
     }
}

inline bool InstallationStatus::hasUpdateStep () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline UpdateStep InstallationStatus::getUpdateStep () const {
    return _updateStep;
}

inline void InstallationStatus::setUpdateStep (UpdateStep updateStep_) {
    #ifndef NDEBUG
    if (!(UpdateStep_IsValid(updateStep_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", updateStep_, "UpdateStep", "updateStep", "InstallationStatus");
    }
    #endif
    set_has_updateStep();
    this->_updateStep = updateStep_;
}

inline void InstallationStatus::clearPercentage() {
    if (hasPercentage()) {
         clear_has_percentage();
        _percentage = 0u;
     }
}

inline bool InstallationStatus::hasPercentage () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 InstallationStatus::getPercentage () const {
    return _percentage;
}

inline void InstallationStatus::setPercentage (uint16 percentage_) {
    set_has_percentage();
    this->_percentage = percentage_;
}

inline void InstallationStatus::clearIsProductUpdate() {
    if (hasIsProductUpdate()) {
         clear_has_isProductUpdate();
        _isProductUpdate = false;
     }
}

inline bool InstallationStatus::hasIsProductUpdate () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool InstallationStatus::getIsProductUpdate () const {
    return _isProductUpdate;
}

inline void InstallationStatus::setIsProductUpdate (bool isProductUpdate_) {
    set_has_isProductUpdate();
    this->_isProductUpdate = isProductUpdate_;
}

inline void InstallationStatus::clearProductName() {
    if (hasProductName()) {
         clear_has_productName();
        _productName.clear();
     }
}

inline bool InstallationStatus::hasProductName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& InstallationStatus::getProductName () const {
    return _productName;
}

inline ::std::string& InstallationStatus::getProductNameMutable () {
    set_has_productName();
    return _productName;
}

inline void InstallationStatus::setProductName (const ::std::string& productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName = productName_;
}

inline void InstallationStatus::setProductName (const char* productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(productName_);
}

inline void InstallationStatus::setProductName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(value, size);
}

inline void InstallationStatus::clearRegionName() {
    if (hasRegionName()) {
         clear_has_regionName();
        _regionName.clear();
     }
}

inline bool InstallationStatus::hasRegionName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& InstallationStatus::getRegionName () const {
    return _regionName;
}

inline ::std::string& InstallationStatus::getRegionNameMutable () {
    set_has_regionName();
    return _regionName;
}

inline void InstallationStatus::setRegionName (const ::std::string& regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName = regionName_;
}

inline void InstallationStatus::setRegionName (const char* regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(regionName_);
}

inline void InstallationStatus::setRegionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(value, size);
}

inline void InstallationStatus::set_has_productId () {
    _has_bits_[0] |= 1u << 0;
}

inline void InstallationStatus::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void InstallationStatus::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void InstallationStatus::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void InstallationStatus::set_has_regionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void InstallationStatus::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void InstallationStatus::set_has_updateStep () {
    _has_bits_[0] |= 1u << 3;
}

inline void InstallationStatus::clear_has_updateStep () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void InstallationStatus::set_has_percentage () {
    _has_bits_[0] |= 1u << 4;
}

inline void InstallationStatus::clear_has_percentage () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void InstallationStatus::set_has_isProductUpdate () {
    _has_bits_[0] |= 1u << 5;
}

inline void InstallationStatus::clear_has_isProductUpdate () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void InstallationStatus::set_has_productName () {
    _has_bits_[0] |= 1u << 6;
}

inline void InstallationStatus::clear_has_productName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void InstallationStatus::set_has_regionName () {
    _has_bits_[0] |= 1u << 7;
}

inline void InstallationStatus::clear_has_regionName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  StorageSpace::StorageSpace ()  :
    _spaceTotalInBytes (0u),
    _spaceLeftInBytes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StorageSpace::StorageSpace (const StorageSpace &rhs)  :
    _spaceTotalInBytes (0u),
    _spaceLeftInBytes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StorageSpace::StorageSpace (uint64 spaceTotalInBytes_, uint64 spaceLeftInBytes_)  :
    _spaceTotalInBytes (spaceTotalInBytes_),
    _spaceLeftInBytes (spaceLeftInBytes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StorageSpace::~StorageSpace() {
}

inline StorageSpace& StorageSpace::operator = (const StorageSpace& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSpaceTotalInBytes()) {
            setSpaceTotalInBytes(rhs.getSpaceTotalInBytes());
        } else {
            clearSpaceTotalInBytes();
        }
        if (rhs.hasSpaceLeftInBytes()) {
            setSpaceLeftInBytes(rhs.getSpaceLeftInBytes());
        } else {
            clearSpaceLeftInBytes();
        }
    }
    return *this;
}

inline bool StorageSpace::operator == (const StorageSpace& rhs) const {
    return (((!hasSpaceTotalInBytes() && !rhs.hasSpaceTotalInBytes()) || getSpaceTotalInBytes() == rhs.getSpaceTotalInBytes()) &&
        ((!hasSpaceLeftInBytes() && !rhs.hasSpaceLeftInBytes()) || getSpaceLeftInBytes() == rhs.getSpaceLeftInBytes()));
}

inline bool StorageSpace::operator != (const StorageSpace& rhs) const {
    return ! (*this == rhs);
}

inline bool StorageSpace::operator < (const StorageSpace& rhs) const {
    if (hasSpaceTotalInBytes() || rhs.hasSpaceTotalInBytes()) {
        if (getSpaceTotalInBytes() < rhs.getSpaceTotalInBytes()) return true;
        if (getSpaceTotalInBytes() > rhs.getSpaceTotalInBytes()) return false;
    }
    if (hasSpaceLeftInBytes() || rhs.hasSpaceLeftInBytes()) {
        if (getSpaceLeftInBytes() < rhs.getSpaceLeftInBytes()) return true;
        if (getSpaceLeftInBytes() > rhs.getSpaceLeftInBytes()) return false;
    }
    return false;
}

inline bool StorageSpace::operator > (const StorageSpace& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StorageSpace::clear() {
    clearSpaceTotalInBytes();
    clearSpaceLeftInBytes();
}

inline void StorageSpace::clearSpaceTotalInBytes() {
    if (hasSpaceTotalInBytes()) {
         clear_has_spaceTotalInBytes();
        _spaceTotalInBytes = 0u;
     }
}

inline bool StorageSpace::hasSpaceTotalInBytes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 StorageSpace::getSpaceTotalInBytes () const {
    return _spaceTotalInBytes;
}

inline void StorageSpace::setSpaceTotalInBytes (uint64 spaceTotalInBytes_) {
    set_has_spaceTotalInBytes();
    this->_spaceTotalInBytes = spaceTotalInBytes_;
}

inline void StorageSpace::clearSpaceLeftInBytes() {
    if (hasSpaceLeftInBytes()) {
         clear_has_spaceLeftInBytes();
        _spaceLeftInBytes = 0u;
     }
}

inline bool StorageSpace::hasSpaceLeftInBytes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 StorageSpace::getSpaceLeftInBytes () const {
    return _spaceLeftInBytes;
}

inline void StorageSpace::setSpaceLeftInBytes (uint64 spaceLeftInBytes_) {
    set_has_spaceLeftInBytes();
    this->_spaceLeftInBytes = spaceLeftInBytes_;
}

inline void StorageSpace::set_has_spaceTotalInBytes () {
    _has_bits_[0] |= 1u << 0;
}

inline void StorageSpace::clear_has_spaceTotalInBytes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StorageSpace::set_has_spaceLeftInBytes () {
    _has_bits_[0] |= 1u << 1;
}

inline void StorageSpace::clear_has_spaceLeftInBytes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateDescription::UpdateDescription ()  :
    _updateVersionId (0u),
    _updateVersionDate (0u),
    _downloadSizeInBytes (0u),
    _estimatedInstallTimeInSeconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateDescription::UpdateDescription (const UpdateDescription &rhs)  :
    _updateVersionId (0u),
    _updateVersionDate (0u),
    _downloadSizeInBytes (0u),
    _estimatedInstallTimeInSeconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateDescription::UpdateDescription (uint32 updateVersionId_, uint64 updateVersionDate_, uint64 downloadSizeInBytes_, uint64 estimatedInstallTimeInSeconds_)  :
    _updateVersionId (updateVersionId_),
    _updateVersionDate (updateVersionDate_),
    _downloadSizeInBytes (downloadSizeInBytes_),
    _estimatedInstallTimeInSeconds (estimatedInstallTimeInSeconds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateDescription::~UpdateDescription() {
}

inline UpdateDescription& UpdateDescription::operator = (const UpdateDescription& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateVersionId()) {
            setUpdateVersionId(rhs.getUpdateVersionId());
        } else {
            clearUpdateVersionId();
        }
        if (rhs.hasUpdateVersionDate()) {
            setUpdateVersionDate(rhs.getUpdateVersionDate());
        } else {
            clearUpdateVersionDate();
        }
        if (rhs.hasDownloadSizeInBytes()) {
            setDownloadSizeInBytes(rhs.getDownloadSizeInBytes());
        } else {
            clearDownloadSizeInBytes();
        }
        if (rhs.hasEstimatedInstallTimeInSeconds()) {
            setEstimatedInstallTimeInSeconds(rhs.getEstimatedInstallTimeInSeconds());
        } else {
            clearEstimatedInstallTimeInSeconds();
        }
    }
    return *this;
}

inline bool UpdateDescription::operator == (const UpdateDescription& rhs) const {
    return (((!hasUpdateVersionId() && !rhs.hasUpdateVersionId()) || getUpdateVersionId() == rhs.getUpdateVersionId()) &&
        ((!hasUpdateVersionDate() && !rhs.hasUpdateVersionDate()) || getUpdateVersionDate() == rhs.getUpdateVersionDate()) &&
        ((!hasDownloadSizeInBytes() && !rhs.hasDownloadSizeInBytes()) || getDownloadSizeInBytes() == rhs.getDownloadSizeInBytes()) &&
        ((!hasEstimatedInstallTimeInSeconds() && !rhs.hasEstimatedInstallTimeInSeconds()) || getEstimatedInstallTimeInSeconds() == rhs.getEstimatedInstallTimeInSeconds()));
}

inline bool UpdateDescription::operator != (const UpdateDescription& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateDescription::operator < (const UpdateDescription& rhs) const {
    if (hasUpdateVersionId() || rhs.hasUpdateVersionId()) {
        if (getUpdateVersionId() < rhs.getUpdateVersionId()) return true;
        if (getUpdateVersionId() > rhs.getUpdateVersionId()) return false;
    }
    if (hasUpdateVersionDate() || rhs.hasUpdateVersionDate()) {
        if (getUpdateVersionDate() < rhs.getUpdateVersionDate()) return true;
        if (getUpdateVersionDate() > rhs.getUpdateVersionDate()) return false;
    }
    if (hasDownloadSizeInBytes() || rhs.hasDownloadSizeInBytes()) {
        if (getDownloadSizeInBytes() < rhs.getDownloadSizeInBytes()) return true;
        if (getDownloadSizeInBytes() > rhs.getDownloadSizeInBytes()) return false;
    }
    if (hasEstimatedInstallTimeInSeconds() || rhs.hasEstimatedInstallTimeInSeconds()) {
        if (getEstimatedInstallTimeInSeconds() < rhs.getEstimatedInstallTimeInSeconds()) return true;
        if (getEstimatedInstallTimeInSeconds() > rhs.getEstimatedInstallTimeInSeconds()) return false;
    }
    return false;
}

inline bool UpdateDescription::operator > (const UpdateDescription& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateDescription::clear() {
    clearUpdateVersionId();
    clearUpdateVersionDate();
    clearDownloadSizeInBytes();
    clearEstimatedInstallTimeInSeconds();
}

inline void UpdateDescription::clearUpdateVersionId() {
    if (hasUpdateVersionId()) {
         clear_has_updateVersionId();
        _updateVersionId = 0u;
     }
}

inline bool UpdateDescription::hasUpdateVersionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 UpdateDescription::getUpdateVersionId () const {
    return _updateVersionId;
}

inline void UpdateDescription::setUpdateVersionId (uint32 updateVersionId_) {
    set_has_updateVersionId();
    this->_updateVersionId = updateVersionId_;
}

inline void UpdateDescription::clearUpdateVersionDate() {
    if (hasUpdateVersionDate()) {
         clear_has_updateVersionDate();
        _updateVersionDate = 0u;
     }
}

inline bool UpdateDescription::hasUpdateVersionDate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 UpdateDescription::getUpdateVersionDate () const {
    return _updateVersionDate;
}

inline void UpdateDescription::setUpdateVersionDate (uint64 updateVersionDate_) {
    set_has_updateVersionDate();
    this->_updateVersionDate = updateVersionDate_;
}

inline void UpdateDescription::clearDownloadSizeInBytes() {
    if (hasDownloadSizeInBytes()) {
         clear_has_downloadSizeInBytes();
        _downloadSizeInBytes = 0u;
     }
}

inline bool UpdateDescription::hasDownloadSizeInBytes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint64 UpdateDescription::getDownloadSizeInBytes () const {
    return _downloadSizeInBytes;
}

inline void UpdateDescription::setDownloadSizeInBytes (uint64 downloadSizeInBytes_) {
    set_has_downloadSizeInBytes();
    this->_downloadSizeInBytes = downloadSizeInBytes_;
}

inline void UpdateDescription::clearEstimatedInstallTimeInSeconds() {
    if (hasEstimatedInstallTimeInSeconds()) {
         clear_has_estimatedInstallTimeInSeconds();
        _estimatedInstallTimeInSeconds = 0u;
     }
}

inline bool UpdateDescription::hasEstimatedInstallTimeInSeconds () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint64 UpdateDescription::getEstimatedInstallTimeInSeconds () const {
    return _estimatedInstallTimeInSeconds;
}

inline void UpdateDescription::setEstimatedInstallTimeInSeconds (uint64 estimatedInstallTimeInSeconds_) {
    set_has_estimatedInstallTimeInSeconds();
    this->_estimatedInstallTimeInSeconds = estimatedInstallTimeInSeconds_;
}

inline void UpdateDescription::set_has_updateVersionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateDescription::clear_has_updateVersionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateDescription::set_has_updateVersionDate () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateDescription::clear_has_updateVersionDate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateDescription::set_has_downloadSizeInBytes () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateDescription::clear_has_downloadSizeInBytes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void UpdateDescription::set_has_estimatedInstallTimeInSeconds () {
    _has_bits_[0] |= 1u << 3;
}

inline void UpdateDescription::clear_has_estimatedInstallTimeInSeconds () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  UpdateRegionVersionInfo::UpdateRegionVersionInfo ()  :
    _updateRegionId (0u),
    _status (::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState__UP_TO_DATE),
    _updateDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateRegionVersionInfo::UpdateRegionVersionInfo (const UpdateRegionVersionInfo &rhs)  :
    _updateRegionId (0u),
    _status (::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState__UP_TO_DATE),
    _updateDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateRegionVersionInfo::UpdateRegionVersionInfo (uint32 updateRegionId_, UpdateState status_, const ::std::vector< UpdateDescription >& updateDescription_)  :
    _updateRegionId (updateRegionId_),
    _status (status_),
    _updateDescription (updateDescription_)
{
    #ifndef NDEBUG
    if (!(UpdateState_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "UpdateState", "status", "UpdateRegionVersionInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateRegionVersionInfo::~UpdateRegionVersionInfo() {
}

inline UpdateRegionVersionInfo& UpdateRegionVersionInfo::operator = (const UpdateRegionVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUpdateRegionId()) {
            setUpdateRegionId(rhs.getUpdateRegionId());
        } else {
            clearUpdateRegionId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasUpdateDescription()) {
            setUpdateDescription(rhs.getUpdateDescription());
        } else {
            clearUpdateDescription();
        }
    }
    return *this;
}

inline bool UpdateRegionVersionInfo::operator == (const UpdateRegionVersionInfo& rhs) const {
    return (((!hasUpdateRegionId() && !rhs.hasUpdateRegionId()) || getUpdateRegionId() == rhs.getUpdateRegionId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasUpdateDescription() && !rhs.hasUpdateDescription()) || getUpdateDescription() == rhs.getUpdateDescription()));
}

inline bool UpdateRegionVersionInfo::operator != (const UpdateRegionVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateRegionVersionInfo::operator < (const UpdateRegionVersionInfo& rhs) const {
    if (hasUpdateRegionId() || rhs.hasUpdateRegionId()) {
        if (getUpdateRegionId() < rhs.getUpdateRegionId()) return true;
        if (getUpdateRegionId() > rhs.getUpdateRegionId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasUpdateDescription() || rhs.hasUpdateDescription()) {
        if (getUpdateDescription() < rhs.getUpdateDescription()) return true;
        if (getUpdateDescription() > rhs.getUpdateDescription()) return false;
    }
    return false;
}

inline bool UpdateRegionVersionInfo::operator > (const UpdateRegionVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateRegionVersionInfo::clear() {
    clearUpdateRegionId();
    clearStatus();
    clearUpdateDescription();
}

inline void UpdateRegionVersionInfo::clearUpdateRegionId() {
    if (hasUpdateRegionId()) {
         clear_has_updateRegionId();
        _updateRegionId = 0u;
     }
}

inline bool UpdateRegionVersionInfo::hasUpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 UpdateRegionVersionInfo::getUpdateRegionId () const {
    return _updateRegionId;
}

inline void UpdateRegionVersionInfo::setUpdateRegionId (uint32 updateRegionId_) {
    set_has_updateRegionId();
    this->_updateRegionId = updateRegionId_;
}

inline void UpdateRegionVersionInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState__UP_TO_DATE;
     }
}

inline bool UpdateRegionVersionInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline UpdateState UpdateRegionVersionInfo::getStatus () const {
    return _status;
}

inline void UpdateRegionVersionInfo::setStatus (UpdateState status_) {
    #ifndef NDEBUG
    if (!(UpdateState_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "UpdateState", "status", "UpdateRegionVersionInfo");
    }
    #endif
    set_has_status();
    this->_status = status_;
}

inline void UpdateRegionVersionInfo::clearUpdateDescription() {
    if (hasUpdateDescription()) {
         clear_has_updateDescription();
        _updateDescription.clear();
     }
}

inline bool UpdateRegionVersionInfo::hasUpdateDescription () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< UpdateDescription >& UpdateRegionVersionInfo::getUpdateDescription () const {
    return _updateDescription;
}

inline ::std::vector< UpdateDescription >& UpdateRegionVersionInfo::getUpdateDescriptionMutable () {
    set_has_updateDescription();
    return _updateDescription;
}

inline void UpdateRegionVersionInfo::setUpdateDescription (const ::std::vector< UpdateDescription >& updateDescription_) {
    set_has_updateDescription();
    this->_updateDescription = updateDescription_;
}

inline void UpdateRegionVersionInfo::set_has_updateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateRegionVersionInfo::clear_has_updateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateRegionVersionInfo::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateRegionVersionInfo::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateRegionVersionInfo::set_has_updateDescription () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateRegionVersionInfo::clear_has_updateDescription () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ProductVersionInfo::ProductVersionInfo ()  :
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductVersionInfo::ProductVersionInfo (const ProductVersionInfo &rhs)  :
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductVersionInfo::ProductVersionInfo (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< UpdateRegionVersionInfo >& updateRegions_)  :
    _productId (productId_),
    _supplierId (supplierId_),
    _baselineMapId (baselineMapId_),
    _updateRegions (updateRegions_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProductVersionInfo::~ProductVersionInfo() {
}

inline ProductVersionInfo& ProductVersionInfo::operator = (const ProductVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasBaselineMapId()) {
            setBaselineMapId(rhs.getBaselineMapId());
        } else {
            clearBaselineMapId();
        }
        if (rhs.hasUpdateRegions()) {
            setUpdateRegions(rhs.getUpdateRegions());
        } else {
            clearUpdateRegions();
        }
    }
    return *this;
}

inline bool ProductVersionInfo::operator == (const ProductVersionInfo& rhs) const {
    return (((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasBaselineMapId() && !rhs.hasBaselineMapId()) || getBaselineMapId() == rhs.getBaselineMapId()) &&
        ((!hasUpdateRegions() && !rhs.hasUpdateRegions()) || getUpdateRegions() == rhs.getUpdateRegions()));
}

inline bool ProductVersionInfo::operator != (const ProductVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductVersionInfo::operator < (const ProductVersionInfo& rhs) const {
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasBaselineMapId() || rhs.hasBaselineMapId()) {
        if (getBaselineMapId() < rhs.getBaselineMapId()) return true;
        if (getBaselineMapId() > rhs.getBaselineMapId()) return false;
    }
    if (hasUpdateRegions() || rhs.hasUpdateRegions()) {
        if (getUpdateRegions() < rhs.getUpdateRegions()) return true;
        if (getUpdateRegions() > rhs.getUpdateRegions()) return false;
    }
    return false;
}

inline bool ProductVersionInfo::operator > (const ProductVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductVersionInfo::clear() {
    clearProductId();
    clearSupplierId();
    clearBaselineMapId();
    clearUpdateRegions();
}

inline void ProductVersionInfo::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool ProductVersionInfo::hasProductId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ProductVersionInfo::getProductId () const {
    return _productId;
}

inline void ProductVersionInfo::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void ProductVersionInfo::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool ProductVersionInfo::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ProductVersionInfo::getSupplierId () const {
    return _supplierId;
}

inline void ProductVersionInfo::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void ProductVersionInfo::clearBaselineMapId() {
    if (hasBaselineMapId()) {
         clear_has_baselineMapId();
        _baselineMapId = 0u;
     }
}

inline bool ProductVersionInfo::hasBaselineMapId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ProductVersionInfo::getBaselineMapId () const {
    return _baselineMapId;
}

inline void ProductVersionInfo::setBaselineMapId (uint32 baselineMapId_) {
    set_has_baselineMapId();
    this->_baselineMapId = baselineMapId_;
}

inline void ProductVersionInfo::clearUpdateRegions() {
    if (hasUpdateRegions()) {
         clear_has_updateRegions();
        _updateRegions.clear();
     }
}

inline bool ProductVersionInfo::hasUpdateRegions () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< UpdateRegionVersionInfo >& ProductVersionInfo::getUpdateRegions () const {
    return _updateRegions;
}

inline ::std::vector< UpdateRegionVersionInfo >& ProductVersionInfo::getUpdateRegionsMutable () {
    set_has_updateRegions();
    return _updateRegions;
}

inline void ProductVersionInfo::setUpdateRegions (const ::std::vector< UpdateRegionVersionInfo >& updateRegions_) {
    set_has_updateRegions();
    this->_updateRegions = updateRegions_;
}

inline void ProductVersionInfo::set_has_productId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProductVersionInfo::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProductVersionInfo::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProductVersionInfo::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ProductVersionInfo::set_has_baselineMapId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ProductVersionInfo::clear_has_baselineMapId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ProductVersionInfo::set_has_updateRegions () {
    _has_bits_[0] |= 1u << 3;
}

inline void ProductVersionInfo::clear_has_updateRegions () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  AvailableUpdates::AvailableUpdates ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult__SUCCESS),
    _products ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailableUpdates::AvailableUpdates (const AvailableUpdates &rhs)  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult__SUCCESS),
    _products ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailableUpdates::AvailableUpdates (GetAvailableUpdatesResult result_, const ::std::vector< ProductVersionInfo >& products_)  :
    _result (result_),
    _products (products_)
{
    #ifndef NDEBUG
    if (!(GetAvailableUpdatesResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "GetAvailableUpdatesResult", "result", "AvailableUpdates");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AvailableUpdates::~AvailableUpdates() {
}

inline AvailableUpdates& AvailableUpdates::operator = (const AvailableUpdates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasProducts()) {
            setProducts(rhs.getProducts());
        } else {
            clearProducts();
        }
    }
    return *this;
}

inline bool AvailableUpdates::operator == (const AvailableUpdates& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasProducts() && !rhs.hasProducts()) || getProducts() == rhs.getProducts()));
}

inline bool AvailableUpdates::operator != (const AvailableUpdates& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailableUpdates::operator < (const AvailableUpdates& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    if (hasProducts() || rhs.hasProducts()) {
        if (getProducts() < rhs.getProducts()) return true;
        if (getProducts() > rhs.getProducts()) return false;
    }
    return false;
}

inline bool AvailableUpdates::operator > (const AvailableUpdates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailableUpdates::clear() {
    clearResult();
    clearProducts();
}

inline void AvailableUpdates::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult__SUCCESS;
     }
}

inline bool AvailableUpdates::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline GetAvailableUpdatesResult AvailableUpdates::getResult () const {
    return _result;
}

inline void AvailableUpdates::setResult (GetAvailableUpdatesResult result_) {
    #ifndef NDEBUG
    if (!(GetAvailableUpdatesResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "GetAvailableUpdatesResult", "result", "AvailableUpdates");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void AvailableUpdates::clearProducts() {
    if (hasProducts()) {
         clear_has_products();
        _products.clear();
     }
}

inline bool AvailableUpdates::hasProducts () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ProductVersionInfo >& AvailableUpdates::getProducts () const {
    return _products;
}

inline ::std::vector< ProductVersionInfo >& AvailableUpdates::getProductsMutable () {
    set_has_products();
    return _products;
}

inline void AvailableUpdates::setProducts (const ::std::vector< ProductVersionInfo >& products_) {
    set_has_products();
    this->_products = products_;
}

inline void AvailableUpdates::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void AvailableUpdates::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AvailableUpdates::set_has_products () {
    _has_bits_[0] |= 1u << 1;
}

inline void AvailableUpdates::clear_has_products () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateRegion::UpdateRegion ()  :
    _componentId (),
    _regionId (0u),
    _regionName (),
    _currentSizeInBytes (0u),
    _isRemovable (false),
    _isInstalled (false),
    _currentVersionId (0u),
    _currentVersionDate (0u),
    _isSubscriptionActive (false),
    _isFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateRegion::UpdateRegion (const UpdateRegion &rhs)  :
    _componentId (),
    _regionId (0u),
    _regionName (),
    _currentSizeInBytes (0u),
    _isRemovable (false),
    _isInstalled (false),
    _currentVersionId (0u),
    _currentVersionDate (0u),
    _isSubscriptionActive (false),
    _isFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateRegion::UpdateRegion (const ::std::string& componentId_, uint32 regionId_, const ::std::string& regionName_, uint64 currentSizeInBytes_, bool isRemovable_, bool isInstalled_, uint64 currentVersionId_, uint64 currentVersionDate_, bool isSubscriptionActive_, bool isFavorite_)  :
    _componentId (componentId_),
    _regionId (regionId_),
    _regionName (regionName_),
    _currentSizeInBytes (currentSizeInBytes_),
    _isRemovable (isRemovable_),
    _isInstalled (isInstalled_),
    _currentVersionId (currentVersionId_),
    _currentVersionDate (currentVersionDate_),
    _isSubscriptionActive (isSubscriptionActive_),
    _isFavorite (isFavorite_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateRegion::~UpdateRegion() {
}

inline UpdateRegion& UpdateRegion::operator = (const UpdateRegion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasComponentId()) {
            setComponentId(rhs.getComponentId());
        } else {
            clearComponentId();
        }
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasRegionName()) {
            setRegionName(rhs.getRegionName());
        } else {
            clearRegionName();
        }
        if (rhs.hasCurrentSizeInBytes()) {
            setCurrentSizeInBytes(rhs.getCurrentSizeInBytes());
        } else {
            clearCurrentSizeInBytes();
        }
        if (rhs.hasIsRemovable()) {
            setIsRemovable(rhs.getIsRemovable());
        } else {
            clearIsRemovable();
        }
        if (rhs.hasIsInstalled()) {
            setIsInstalled(rhs.getIsInstalled());
        } else {
            clearIsInstalled();
        }
        if (rhs.hasCurrentVersionId()) {
            setCurrentVersionId(rhs.getCurrentVersionId());
        } else {
            clearCurrentVersionId();
        }
        if (rhs.hasCurrentVersionDate()) {
            setCurrentVersionDate(rhs.getCurrentVersionDate());
        } else {
            clearCurrentVersionDate();
        }
        if (rhs.hasIsSubscriptionActive()) {
            setIsSubscriptionActive(rhs.getIsSubscriptionActive());
        } else {
            clearIsSubscriptionActive();
        }
        if (rhs.hasIsFavorite()) {
            setIsFavorite(rhs.getIsFavorite());
        } else {
            clearIsFavorite();
        }
    }
    return *this;
}

inline bool UpdateRegion::operator == (const UpdateRegion& rhs) const {
    return (((!hasComponentId() && !rhs.hasComponentId()) || getComponentId() == rhs.getComponentId()) &&
        ((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasRegionName() && !rhs.hasRegionName()) || getRegionName() == rhs.getRegionName()) &&
        ((!hasCurrentSizeInBytes() && !rhs.hasCurrentSizeInBytes()) || getCurrentSizeInBytes() == rhs.getCurrentSizeInBytes()) &&
        ((!hasIsRemovable() && !rhs.hasIsRemovable()) || getIsRemovable() == rhs.getIsRemovable()) &&
        ((!hasIsInstalled() && !rhs.hasIsInstalled()) || getIsInstalled() == rhs.getIsInstalled()) &&
        ((!hasCurrentVersionId() && !rhs.hasCurrentVersionId()) || getCurrentVersionId() == rhs.getCurrentVersionId()) &&
        ((!hasCurrentVersionDate() && !rhs.hasCurrentVersionDate()) || getCurrentVersionDate() == rhs.getCurrentVersionDate()) &&
        ((!hasIsSubscriptionActive() && !rhs.hasIsSubscriptionActive()) || getIsSubscriptionActive() == rhs.getIsSubscriptionActive()) &&
        ((!hasIsFavorite() && !rhs.hasIsFavorite()) || getIsFavorite() == rhs.getIsFavorite()));
}

inline bool UpdateRegion::operator != (const UpdateRegion& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateRegion::operator < (const UpdateRegion& rhs) const {
    if (hasComponentId() || rhs.hasComponentId()) {
        if (getComponentId() < rhs.getComponentId()) return true;
        if (getComponentId() > rhs.getComponentId()) return false;
    }
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasRegionName() || rhs.hasRegionName()) {
        if (getRegionName() < rhs.getRegionName()) return true;
        if (getRegionName() > rhs.getRegionName()) return false;
    }
    if (hasCurrentSizeInBytes() || rhs.hasCurrentSizeInBytes()) {
        if (getCurrentSizeInBytes() < rhs.getCurrentSizeInBytes()) return true;
        if (getCurrentSizeInBytes() > rhs.getCurrentSizeInBytes()) return false;
    }
    if (hasIsRemovable() || rhs.hasIsRemovable()) {
        if (getIsRemovable() < rhs.getIsRemovable()) return true;
        if (getIsRemovable() > rhs.getIsRemovable()) return false;
    }
    if (hasIsInstalled() || rhs.hasIsInstalled()) {
        if (getIsInstalled() < rhs.getIsInstalled()) return true;
        if (getIsInstalled() > rhs.getIsInstalled()) return false;
    }
    if (hasCurrentVersionId() || rhs.hasCurrentVersionId()) {
        if (getCurrentVersionId() < rhs.getCurrentVersionId()) return true;
        if (getCurrentVersionId() > rhs.getCurrentVersionId()) return false;
    }
    if (hasCurrentVersionDate() || rhs.hasCurrentVersionDate()) {
        if (getCurrentVersionDate() < rhs.getCurrentVersionDate()) return true;
        if (getCurrentVersionDate() > rhs.getCurrentVersionDate()) return false;
    }
    if (hasIsSubscriptionActive() || rhs.hasIsSubscriptionActive()) {
        if (getIsSubscriptionActive() < rhs.getIsSubscriptionActive()) return true;
        if (getIsSubscriptionActive() > rhs.getIsSubscriptionActive()) return false;
    }
    if (hasIsFavorite() || rhs.hasIsFavorite()) {
        if (getIsFavorite() < rhs.getIsFavorite()) return true;
        if (getIsFavorite() > rhs.getIsFavorite()) return false;
    }
    return false;
}

inline bool UpdateRegion::operator > (const UpdateRegion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateRegion::clear() {
    clearComponentId();
    clearRegionId();
    clearRegionName();
    clearCurrentSizeInBytes();
    clearIsRemovable();
    clearIsInstalled();
    clearCurrentVersionId();
    clearCurrentVersionDate();
    clearIsSubscriptionActive();
    clearIsFavorite();
}

inline void UpdateRegion::clearComponentId() {
    if (hasComponentId()) {
         clear_has_componentId();
        _componentId.clear();
     }
}

inline bool UpdateRegion::hasComponentId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UpdateRegion::getComponentId () const {
    return _componentId;
}

inline ::std::string& UpdateRegion::getComponentIdMutable () {
    set_has_componentId();
    return _componentId;
}

inline void UpdateRegion::setComponentId (const ::std::string& componentId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId = componentId_;
}

inline void UpdateRegion::setComponentId (const char* componentId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId.assign(componentId_);
}

inline void UpdateRegion::setComponentId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId.assign(value, size);
}

inline void UpdateRegion::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool UpdateRegion::hasRegionId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 UpdateRegion::getRegionId () const {
    return _regionId;
}

inline void UpdateRegion::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void UpdateRegion::clearRegionName() {
    if (hasRegionName()) {
         clear_has_regionName();
        _regionName.clear();
     }
}

inline bool UpdateRegion::hasRegionName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& UpdateRegion::getRegionName () const {
    return _regionName;
}

inline ::std::string& UpdateRegion::getRegionNameMutable () {
    set_has_regionName();
    return _regionName;
}

inline void UpdateRegion::setRegionName (const ::std::string& regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName = regionName_;
}

inline void UpdateRegion::setRegionName (const char* regionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(regionName_);
}

inline void UpdateRegion::setRegionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionName();
    this->_regionName.assign(value, size);
}

inline void UpdateRegion::clearCurrentSizeInBytes() {
    if (hasCurrentSizeInBytes()) {
         clear_has_currentSizeInBytes();
        _currentSizeInBytes = 0u;
     }
}

inline bool UpdateRegion::hasCurrentSizeInBytes () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint64 UpdateRegion::getCurrentSizeInBytes () const {
    return _currentSizeInBytes;
}

inline void UpdateRegion::setCurrentSizeInBytes (uint64 currentSizeInBytes_) {
    set_has_currentSizeInBytes();
    this->_currentSizeInBytes = currentSizeInBytes_;
}

inline void UpdateRegion::clearIsRemovable() {
    if (hasIsRemovable()) {
         clear_has_isRemovable();
        _isRemovable = false;
     }
}

inline bool UpdateRegion::hasIsRemovable () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool UpdateRegion::getIsRemovable () const {
    return _isRemovable;
}

inline void UpdateRegion::setIsRemovable (bool isRemovable_) {
    set_has_isRemovable();
    this->_isRemovable = isRemovable_;
}

inline void UpdateRegion::clearIsInstalled() {
    if (hasIsInstalled()) {
         clear_has_isInstalled();
        _isInstalled = false;
     }
}

inline bool UpdateRegion::hasIsInstalled () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool UpdateRegion::getIsInstalled () const {
    return _isInstalled;
}

inline void UpdateRegion::setIsInstalled (bool isInstalled_) {
    set_has_isInstalled();
    this->_isInstalled = isInstalled_;
}

inline void UpdateRegion::clearCurrentVersionId() {
    if (hasCurrentVersionId()) {
         clear_has_currentVersionId();
        _currentVersionId = 0u;
     }
}

inline bool UpdateRegion::hasCurrentVersionId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint64 UpdateRegion::getCurrentVersionId () const {
    return _currentVersionId;
}

inline void UpdateRegion::setCurrentVersionId (uint64 currentVersionId_) {
    set_has_currentVersionId();
    this->_currentVersionId = currentVersionId_;
}

inline void UpdateRegion::clearCurrentVersionDate() {
    if (hasCurrentVersionDate()) {
         clear_has_currentVersionDate();
        _currentVersionDate = 0u;
     }
}

inline bool UpdateRegion::hasCurrentVersionDate () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint64 UpdateRegion::getCurrentVersionDate () const {
    return _currentVersionDate;
}

inline void UpdateRegion::setCurrentVersionDate (uint64 currentVersionDate_) {
    set_has_currentVersionDate();
    this->_currentVersionDate = currentVersionDate_;
}

inline void UpdateRegion::clearIsSubscriptionActive() {
    if (hasIsSubscriptionActive()) {
         clear_has_isSubscriptionActive();
        _isSubscriptionActive = false;
     }
}

inline bool UpdateRegion::hasIsSubscriptionActive () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool UpdateRegion::getIsSubscriptionActive () const {
    return _isSubscriptionActive;
}

inline void UpdateRegion::setIsSubscriptionActive (bool isSubscriptionActive_) {
    set_has_isSubscriptionActive();
    this->_isSubscriptionActive = isSubscriptionActive_;
}

inline void UpdateRegion::clearIsFavorite() {
    if (hasIsFavorite()) {
         clear_has_isFavorite();
        _isFavorite = false;
     }
}

inline bool UpdateRegion::hasIsFavorite () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool UpdateRegion::getIsFavorite () const {
    return _isFavorite;
}

inline void UpdateRegion::setIsFavorite (bool isFavorite_) {
    set_has_isFavorite();
    this->_isFavorite = isFavorite_;
}

inline void UpdateRegion::set_has_componentId () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateRegion::clear_has_componentId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateRegion::set_has_regionId () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateRegion::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateRegion::set_has_regionName () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateRegion::clear_has_regionName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void UpdateRegion::set_has_currentSizeInBytes () {
    _has_bits_[0] |= 1u << 3;
}

inline void UpdateRegion::clear_has_currentSizeInBytes () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void UpdateRegion::set_has_isRemovable () {
    _has_bits_[0] |= 1u << 4;
}

inline void UpdateRegion::clear_has_isRemovable () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void UpdateRegion::set_has_isInstalled () {
    _has_bits_[0] |= 1u << 5;
}

inline void UpdateRegion::clear_has_isInstalled () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void UpdateRegion::set_has_currentVersionId () {
    _has_bits_[0] |= 1u << 6;
}

inline void UpdateRegion::clear_has_currentVersionId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void UpdateRegion::set_has_currentVersionDate () {
    _has_bits_[0] |= 1u << 7;
}

inline void UpdateRegion::clear_has_currentVersionDate () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void UpdateRegion::set_has_isSubscriptionActive () {
    _has_bits_[0] |= 1u << 8;
}

inline void UpdateRegion::clear_has_isSubscriptionActive () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void UpdateRegion::set_has_isFavorite () {
    _has_bits_[0] |= 1u << 9;
}

inline void UpdateRegion::clear_has_isFavorite () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  RegionSet::RegionSet ()  :
    _regionSetId (0u),
    _regionSetName (),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegionSet::RegionSet (const RegionSet &rhs)  :
    _regionSetId (0u),
    _regionSetName (),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegionSet::RegionSet (uint32 regionSetId_, const ::std::string& regionSetName_, const ::std::vector< uint32 >& updateRegionIds_)  :
    _regionSetId (regionSetId_),
    _regionSetName (regionSetName_),
    _updateRegionIds (updateRegionIds_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionSetName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegionSet::~RegionSet() {
}

inline RegionSet& RegionSet::operator = (const RegionSet& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRegionSetId()) {
            setRegionSetId(rhs.getRegionSetId());
        } else {
            clearRegionSetId();
        }
        if (rhs.hasRegionSetName()) {
            setRegionSetName(rhs.getRegionSetName());
        } else {
            clearRegionSetName();
        }
        if (rhs.hasUpdateRegionIds()) {
            setUpdateRegionIds(rhs.getUpdateRegionIds());
        } else {
            clearUpdateRegionIds();
        }
    }
    return *this;
}

inline bool RegionSet::operator == (const RegionSet& rhs) const {
    return (((!hasRegionSetId() && !rhs.hasRegionSetId()) || getRegionSetId() == rhs.getRegionSetId()) &&
        ((!hasRegionSetName() && !rhs.hasRegionSetName()) || getRegionSetName() == rhs.getRegionSetName()) &&
        ((!hasUpdateRegionIds() && !rhs.hasUpdateRegionIds()) || getUpdateRegionIds() == rhs.getUpdateRegionIds()));
}

inline bool RegionSet::operator != (const RegionSet& rhs) const {
    return ! (*this == rhs);
}

inline bool RegionSet::operator < (const RegionSet& rhs) const {
    if (hasRegionSetId() || rhs.hasRegionSetId()) {
        if (getRegionSetId() < rhs.getRegionSetId()) return true;
        if (getRegionSetId() > rhs.getRegionSetId()) return false;
    }
    if (hasRegionSetName() || rhs.hasRegionSetName()) {
        if (getRegionSetName() < rhs.getRegionSetName()) return true;
        if (getRegionSetName() > rhs.getRegionSetName()) return false;
    }
    if (hasUpdateRegionIds() || rhs.hasUpdateRegionIds()) {
        if (getUpdateRegionIds() < rhs.getUpdateRegionIds()) return true;
        if (getUpdateRegionIds() > rhs.getUpdateRegionIds()) return false;
    }
    return false;
}

inline bool RegionSet::operator > (const RegionSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegionSet::clear() {
    clearRegionSetId();
    clearRegionSetName();
    clearUpdateRegionIds();
}

inline void RegionSet::clearRegionSetId() {
    if (hasRegionSetId()) {
         clear_has_regionSetId();
        _regionSetId = 0u;
     }
}

inline bool RegionSet::hasRegionSetId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RegionSet::getRegionSetId () const {
    return _regionSetId;
}

inline void RegionSet::setRegionSetId (uint32 regionSetId_) {
    set_has_regionSetId();
    this->_regionSetId = regionSetId_;
}

inline void RegionSet::clearRegionSetName() {
    if (hasRegionSetName()) {
         clear_has_regionSetName();
        _regionSetName.clear();
     }
}

inline bool RegionSet::hasRegionSetName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegionSet::getRegionSetName () const {
    return _regionSetName;
}

inline ::std::string& RegionSet::getRegionSetNameMutable () {
    set_has_regionSetName();
    return _regionSetName;
}

inline void RegionSet::setRegionSetName (const ::std::string& regionSetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionSetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionSetName();
    this->_regionSetName = regionSetName_;
}

inline void RegionSet::setRegionSetName (const char* regionSetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regionSetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionSetName();
    this->_regionSetName.assign(regionSetName_);
}

inline void RegionSet::setRegionSetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regionSetName();
    this->_regionSetName.assign(value, size);
}

inline void RegionSet::clearUpdateRegionIds() {
    if (hasUpdateRegionIds()) {
         clear_has_updateRegionIds();
        _updateRegionIds.clear();
     }
}

inline bool RegionSet::hasUpdateRegionIds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint32 >& RegionSet::getUpdateRegionIds () const {
    return _updateRegionIds;
}

inline ::std::vector< uint32 >& RegionSet::getUpdateRegionIdsMutable () {
    set_has_updateRegionIds();
    return _updateRegionIds;
}

inline void RegionSet::setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_) {
    set_has_updateRegionIds();
    this->_updateRegionIds = updateRegionIds_;
}

inline void RegionSet::set_has_regionSetId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegionSet::clear_has_regionSetId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegionSet::set_has_regionSetName () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegionSet::clear_has_regionSetName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegionSet::set_has_updateRegionIds () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegionSet::clear_has_updateRegionIds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Product::Product ()  :
    _componentId (),
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _productGroupId (0u),
    _productVersionId (0u),
    _productVersionIsDirty (false),
    _productVersionDate (0u),
    _productName (),
    _productTypeMask (0u),
    _regionSet (),
    _updateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Product::Product (const Product &rhs)  :
    _componentId (),
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _productGroupId (0u),
    _productVersionId (0u),
    _productVersionIsDirty (false),
    _productVersionDate (0u),
    _productName (),
    _productTypeMask (0u),
    _regionSet (),
    _updateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Product::Product (const ::std::string& componentId_, uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, uint32 productGroupId_, uint32 productVersionId_, bool productVersionIsDirty_, uint64 productVersionDate_, const ::std::string& productName_, uint32 productTypeMask_, const ::std::vector< RegionSet >& regionSet_, const ::std::vector< UpdateRegion >& updateRegions_)  :
    _componentId (componentId_),
    _productId (productId_),
    _supplierId (supplierId_),
    _baselineMapId (baselineMapId_),
    _productGroupId (productGroupId_),
    _productVersionId (productVersionId_),
    _productVersionIsDirty (productVersionIsDirty_),
    _productVersionDate (productVersionDate_),
    _productName (productName_),
    _productTypeMask (productTypeMask_),
    _regionSet (regionSet_),
    _updateRegions (updateRegions_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Product::~Product() {
}

inline Product& Product::operator = (const Product& rhs) {
    if( this != &rhs ) {
        if (rhs.hasComponentId()) {
            setComponentId(rhs.getComponentId());
        } else {
            clearComponentId();
        }
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasBaselineMapId()) {
            setBaselineMapId(rhs.getBaselineMapId());
        } else {
            clearBaselineMapId();
        }
        if (rhs.hasProductGroupId()) {
            setProductGroupId(rhs.getProductGroupId());
        } else {
            clearProductGroupId();
        }
        if (rhs.hasProductVersionId()) {
            setProductVersionId(rhs.getProductVersionId());
        } else {
            clearProductVersionId();
        }
        if (rhs.hasProductVersionIsDirty()) {
            setProductVersionIsDirty(rhs.getProductVersionIsDirty());
        } else {
            clearProductVersionIsDirty();
        }
        if (rhs.hasProductVersionDate()) {
            setProductVersionDate(rhs.getProductVersionDate());
        } else {
            clearProductVersionDate();
        }
        if (rhs.hasProductName()) {
            setProductName(rhs.getProductName());
        } else {
            clearProductName();
        }
        if (rhs.hasProductTypeMask()) {
            setProductTypeMask(rhs.getProductTypeMask());
        } else {
            clearProductTypeMask();
        }
        if (rhs.hasRegionSet()) {
            setRegionSet(rhs.getRegionSet());
        } else {
            clearRegionSet();
        }
        if (rhs.hasUpdateRegions()) {
            setUpdateRegions(rhs.getUpdateRegions());
        } else {
            clearUpdateRegions();
        }
    }
    return *this;
}

inline bool Product::operator == (const Product& rhs) const {
    return (((!hasComponentId() && !rhs.hasComponentId()) || getComponentId() == rhs.getComponentId()) &&
        ((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasBaselineMapId() && !rhs.hasBaselineMapId()) || getBaselineMapId() == rhs.getBaselineMapId()) &&
        ((!hasProductGroupId() && !rhs.hasProductGroupId()) || getProductGroupId() == rhs.getProductGroupId()) &&
        ((!hasProductVersionId() && !rhs.hasProductVersionId()) || getProductVersionId() == rhs.getProductVersionId()) &&
        ((!hasProductVersionIsDirty() && !rhs.hasProductVersionIsDirty()) || getProductVersionIsDirty() == rhs.getProductVersionIsDirty()) &&
        ((!hasProductVersionDate() && !rhs.hasProductVersionDate()) || getProductVersionDate() == rhs.getProductVersionDate()) &&
        ((!hasProductName() && !rhs.hasProductName()) || getProductName() == rhs.getProductName()) &&
        ((!hasProductTypeMask() && !rhs.hasProductTypeMask()) || getProductTypeMask() == rhs.getProductTypeMask()) &&
        ((!hasRegionSet() && !rhs.hasRegionSet()) || getRegionSet() == rhs.getRegionSet()) &&
        ((!hasUpdateRegions() && !rhs.hasUpdateRegions()) || getUpdateRegions() == rhs.getUpdateRegions()));
}

inline bool Product::operator != (const Product& rhs) const {
    return ! (*this == rhs);
}

inline bool Product::operator < (const Product& rhs) const {
    if (hasComponentId() || rhs.hasComponentId()) {
        if (getComponentId() < rhs.getComponentId()) return true;
        if (getComponentId() > rhs.getComponentId()) return false;
    }
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasBaselineMapId() || rhs.hasBaselineMapId()) {
        if (getBaselineMapId() < rhs.getBaselineMapId()) return true;
        if (getBaselineMapId() > rhs.getBaselineMapId()) return false;
    }
    if (hasProductGroupId() || rhs.hasProductGroupId()) {
        if (getProductGroupId() < rhs.getProductGroupId()) return true;
        if (getProductGroupId() > rhs.getProductGroupId()) return false;
    }
    if (hasProductVersionId() || rhs.hasProductVersionId()) {
        if (getProductVersionId() < rhs.getProductVersionId()) return true;
        if (getProductVersionId() > rhs.getProductVersionId()) return false;
    }
    if (hasProductVersionIsDirty() || rhs.hasProductVersionIsDirty()) {
        if (getProductVersionIsDirty() < rhs.getProductVersionIsDirty()) return true;
        if (getProductVersionIsDirty() > rhs.getProductVersionIsDirty()) return false;
    }
    if (hasProductVersionDate() || rhs.hasProductVersionDate()) {
        if (getProductVersionDate() < rhs.getProductVersionDate()) return true;
        if (getProductVersionDate() > rhs.getProductVersionDate()) return false;
    }
    if (hasProductName() || rhs.hasProductName()) {
        if (getProductName() < rhs.getProductName()) return true;
        if (getProductName() > rhs.getProductName()) return false;
    }
    if (hasProductTypeMask() || rhs.hasProductTypeMask()) {
        if (getProductTypeMask() < rhs.getProductTypeMask()) return true;
        if (getProductTypeMask() > rhs.getProductTypeMask()) return false;
    }
    if (hasRegionSet() || rhs.hasRegionSet()) {
        if (getRegionSet() < rhs.getRegionSet()) return true;
        if (getRegionSet() > rhs.getRegionSet()) return false;
    }
    if (hasUpdateRegions() || rhs.hasUpdateRegions()) {
        if (getUpdateRegions() < rhs.getUpdateRegions()) return true;
        if (getUpdateRegions() > rhs.getUpdateRegions()) return false;
    }
    return false;
}

inline bool Product::operator > (const Product& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Product::clear() {
    clearComponentId();
    clearProductId();
    clearSupplierId();
    clearBaselineMapId();
    clearProductGroupId();
    clearProductVersionId();
    clearProductVersionIsDirty();
    clearProductVersionDate();
    clearProductName();
    clearProductTypeMask();
    clearRegionSet();
    clearUpdateRegions();
}

inline void Product::clearComponentId() {
    if (hasComponentId()) {
         clear_has_componentId();
        _componentId.clear();
     }
}

inline bool Product::hasComponentId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& Product::getComponentId () const {
    return _componentId;
}

inline ::std::string& Product::getComponentIdMutable () {
    set_has_componentId();
    return _componentId;
}

inline void Product::setComponentId (const ::std::string& componentId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId = componentId_;
}

inline void Product::setComponentId (const char* componentId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (componentId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId.assign(componentId_);
}

inline void Product::setComponentId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_componentId();
    this->_componentId.assign(value, size);
}

inline void Product::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool Product::hasProductId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 Product::getProductId () const {
    return _productId;
}

inline void Product::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void Product::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool Product::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 Product::getSupplierId () const {
    return _supplierId;
}

inline void Product::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void Product::clearBaselineMapId() {
    if (hasBaselineMapId()) {
         clear_has_baselineMapId();
        _baselineMapId = 0u;
     }
}

inline bool Product::hasBaselineMapId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 Product::getBaselineMapId () const {
    return _baselineMapId;
}

inline void Product::setBaselineMapId (uint32 baselineMapId_) {
    set_has_baselineMapId();
    this->_baselineMapId = baselineMapId_;
}

inline void Product::clearProductGroupId() {
    if (hasProductGroupId()) {
         clear_has_productGroupId();
        _productGroupId = 0u;
     }
}

inline bool Product::hasProductGroupId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 Product::getProductGroupId () const {
    return _productGroupId;
}

inline void Product::setProductGroupId (uint32 productGroupId_) {
    set_has_productGroupId();
    this->_productGroupId = productGroupId_;
}

inline void Product::clearProductVersionId() {
    if (hasProductVersionId()) {
         clear_has_productVersionId();
        _productVersionId = 0u;
     }
}

inline bool Product::hasProductVersionId () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 Product::getProductVersionId () const {
    return _productVersionId;
}

inline void Product::setProductVersionId (uint32 productVersionId_) {
    set_has_productVersionId();
    this->_productVersionId = productVersionId_;
}

inline void Product::clearProductVersionIsDirty() {
    if (hasProductVersionIsDirty()) {
         clear_has_productVersionIsDirty();
        _productVersionIsDirty = false;
     }
}

inline bool Product::hasProductVersionIsDirty () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool Product::getProductVersionIsDirty () const {
    return _productVersionIsDirty;
}

inline void Product::setProductVersionIsDirty (bool productVersionIsDirty_) {
    set_has_productVersionIsDirty();
    this->_productVersionIsDirty = productVersionIsDirty_;
}

inline void Product::clearProductVersionDate() {
    if (hasProductVersionDate()) {
         clear_has_productVersionDate();
        _productVersionDate = 0u;
     }
}

inline bool Product::hasProductVersionDate () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint64 Product::getProductVersionDate () const {
    return _productVersionDate;
}

inline void Product::setProductVersionDate (uint64 productVersionDate_) {
    set_has_productVersionDate();
    this->_productVersionDate = productVersionDate_;
}

inline void Product::clearProductName() {
    if (hasProductName()) {
         clear_has_productName();
        _productName.clear();
     }
}

inline bool Product::hasProductName () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& Product::getProductName () const {
    return _productName;
}

inline ::std::string& Product::getProductNameMutable () {
    set_has_productName();
    return _productName;
}

inline void Product::setProductName (const ::std::string& productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName = productName_;
}

inline void Product::setProductName (const char* productName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (productName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(productName_);
}

inline void Product::setProductName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_productName();
    this->_productName.assign(value, size);
}

inline void Product::clearProductTypeMask() {
    if (hasProductTypeMask()) {
         clear_has_productTypeMask();
        _productTypeMask = 0u;
     }
}

inline bool Product::hasProductTypeMask () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 Product::getProductTypeMask () const {
    return _productTypeMask;
}

inline void Product::setProductTypeMask (uint32 productTypeMask_) {
    set_has_productTypeMask();
    this->_productTypeMask = productTypeMask_;
}

inline void Product::clearRegionSet() {
    if (hasRegionSet()) {
         clear_has_regionSet();
        _regionSet.clear();
     }
}

inline bool Product::hasRegionSet () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::vector< RegionSet >& Product::getRegionSet () const {
    return _regionSet;
}

inline ::std::vector< RegionSet >& Product::getRegionSetMutable () {
    set_has_regionSet();
    return _regionSet;
}

inline void Product::setRegionSet (const ::std::vector< RegionSet >& regionSet_) {
    set_has_regionSet();
    this->_regionSet = regionSet_;
}

inline void Product::clearUpdateRegions() {
    if (hasUpdateRegions()) {
         clear_has_updateRegions();
        _updateRegions.clear();
     }
}

inline bool Product::hasUpdateRegions () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::vector< UpdateRegion >& Product::getUpdateRegions () const {
    return _updateRegions;
}

inline ::std::vector< UpdateRegion >& Product::getUpdateRegionsMutable () {
    set_has_updateRegions();
    return _updateRegions;
}

inline void Product::setUpdateRegions (const ::std::vector< UpdateRegion >& updateRegions_) {
    set_has_updateRegions();
    this->_updateRegions = updateRegions_;
}

inline void Product::set_has_componentId () {
    _has_bits_[0] |= 1u << 0;
}

inline void Product::clear_has_componentId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Product::set_has_productId () {
    _has_bits_[0] |= 1u << 1;
}

inline void Product::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Product::set_has_supplierId () {
    _has_bits_[0] |= 1u << 2;
}

inline void Product::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Product::set_has_baselineMapId () {
    _has_bits_[0] |= 1u << 3;
}

inline void Product::clear_has_baselineMapId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Product::set_has_productGroupId () {
    _has_bits_[0] |= 1u << 4;
}

inline void Product::clear_has_productGroupId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void Product::set_has_productVersionId () {
    _has_bits_[0] |= 1u << 5;
}

inline void Product::clear_has_productVersionId () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void Product::set_has_productVersionIsDirty () {
    _has_bits_[0] |= 1u << 6;
}

inline void Product::clear_has_productVersionIsDirty () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void Product::set_has_productVersionDate () {
    _has_bits_[0] |= 1u << 7;
}

inline void Product::clear_has_productVersionDate () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void Product::set_has_productName () {
    _has_bits_[0] |= 1u << 8;
}

inline void Product::clear_has_productName () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void Product::set_has_productTypeMask () {
    _has_bits_[0] |= 1u << 9;
}

inline void Product::clear_has_productTypeMask () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void Product::set_has_regionSet () {
    _has_bits_[0] |= 1u << 10;
}

inline void Product::clear_has_regionSet () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void Product::set_has_updateRegions () {
    _has_bits_[0] |= 1u << 11;
}

inline void Product::clear_has_updateRegions () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  NavDataContext::NavDataContext ()  :
    _navigationSWVersion (),
    _packageId (),
    _products (),
    _storageSpace ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataContext::NavDataContext (const NavDataContext &rhs)  :
    _navigationSWVersion (),
    _packageId (),
    _products (),
    _storageSpace ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataContext::NavDataContext (const ::std::string& navigationSWVersion_, const ::std::string& packageId_, const ::std::vector< Product >& products_, const StorageSpace& storageSpace_)  :
    _navigationSWVersion (navigationSWVersion_),
    _packageId (packageId_),
    _products (products_),
    _storageSpace (storageSpace_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (navigationSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (packageId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavDataContext::~NavDataContext() {
}

inline NavDataContext& NavDataContext::operator = (const NavDataContext& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNavigationSWVersion()) {
            setNavigationSWVersion(rhs.getNavigationSWVersion());
        } else {
            clearNavigationSWVersion();
        }
        if (rhs.hasPackageId()) {
            setPackageId(rhs.getPackageId());
        } else {
            clearPackageId();
        }
        if (rhs.hasProducts()) {
            setProducts(rhs.getProducts());
        } else {
            clearProducts();
        }
        if (rhs.hasStorageSpace()) {
            setStorageSpace(rhs.getStorageSpace());
        } else {
            clearStorageSpace();
        }
    }
    return *this;
}

inline bool NavDataContext::operator == (const NavDataContext& rhs) const {
    return (((!hasNavigationSWVersion() && !rhs.hasNavigationSWVersion()) || getNavigationSWVersion() == rhs.getNavigationSWVersion()) &&
        ((!hasPackageId() && !rhs.hasPackageId()) || getPackageId() == rhs.getPackageId()) &&
        ((!hasProducts() && !rhs.hasProducts()) || getProducts() == rhs.getProducts()) &&
        ((!hasStorageSpace() && !rhs.hasStorageSpace()) || getStorageSpace() == rhs.getStorageSpace()));
}

inline bool NavDataContext::operator != (const NavDataContext& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataContext::operator < (const NavDataContext& rhs) const {
    if (hasNavigationSWVersion() || rhs.hasNavigationSWVersion()) {
        if (getNavigationSWVersion() < rhs.getNavigationSWVersion()) return true;
        if (getNavigationSWVersion() > rhs.getNavigationSWVersion()) return false;
    }
    if (hasPackageId() || rhs.hasPackageId()) {
        if (getPackageId() < rhs.getPackageId()) return true;
        if (getPackageId() > rhs.getPackageId()) return false;
    }
    if (hasProducts() || rhs.hasProducts()) {
        if (getProducts() < rhs.getProducts()) return true;
        if (getProducts() > rhs.getProducts()) return false;
    }
    if (hasStorageSpace() || rhs.hasStorageSpace()) {
        if (getStorageSpace() < rhs.getStorageSpace()) return true;
        if (getStorageSpace() > rhs.getStorageSpace()) return false;
    }
    return false;
}

inline bool NavDataContext::operator > (const NavDataContext& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataContext::clear() {
    clearNavigationSWVersion();
    clearPackageId();
    clearProducts();
    clearStorageSpace();
}

inline void NavDataContext::clearNavigationSWVersion() {
    if (hasNavigationSWVersion()) {
         clear_has_navigationSWVersion();
        _navigationSWVersion.clear();
     }
}

inline bool NavDataContext::hasNavigationSWVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NavDataContext::getNavigationSWVersion () const {
    return _navigationSWVersion;
}

inline ::std::string& NavDataContext::getNavigationSWVersionMutable () {
    set_has_navigationSWVersion();
    return _navigationSWVersion;
}

inline void NavDataContext::setNavigationSWVersion (const ::std::string& navigationSWVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (navigationSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_navigationSWVersion();
    this->_navigationSWVersion = navigationSWVersion_;
}

inline void NavDataContext::setNavigationSWVersion (const char* navigationSWVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (navigationSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_navigationSWVersion();
    this->_navigationSWVersion.assign(navigationSWVersion_);
}

inline void NavDataContext::setNavigationSWVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_navigationSWVersion();
    this->_navigationSWVersion.assign(value, size);
}

inline void NavDataContext::clearPackageId() {
    if (hasPackageId()) {
         clear_has_packageId();
        _packageId.clear();
     }
}

inline bool NavDataContext::hasPackageId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NavDataContext::getPackageId () const {
    return _packageId;
}

inline ::std::string& NavDataContext::getPackageIdMutable () {
    set_has_packageId();
    return _packageId;
}

inline void NavDataContext::setPackageId (const ::std::string& packageId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (packageId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_packageId();
    this->_packageId = packageId_;
}

inline void NavDataContext::setPackageId (const char* packageId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (packageId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_packageId();
    this->_packageId.assign(packageId_);
}

inline void NavDataContext::setPackageId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_packageId();
    this->_packageId.assign(value, size);
}

inline void NavDataContext::clearProducts() {
    if (hasProducts()) {
         clear_has_products();
        _products.clear();
     }
}

inline bool NavDataContext::hasProducts () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< Product >& NavDataContext::getProducts () const {
    return _products;
}

inline ::std::vector< Product >& NavDataContext::getProductsMutable () {
    set_has_products();
    return _products;
}

inline void NavDataContext::setProducts (const ::std::vector< Product >& products_) {
    set_has_products();
    this->_products = products_;
}

inline void NavDataContext::clearStorageSpace() {
    if (hasStorageSpace()) {
         clear_has_storageSpace();
        _storageSpace.clear();
     }
}

inline bool NavDataContext::hasStorageSpace () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const StorageSpace& NavDataContext::getStorageSpace () const {
    return _storageSpace;
}

inline StorageSpace& NavDataContext::getStorageSpaceMutable () {
    set_has_storageSpace();
    return _storageSpace;
}

inline void NavDataContext::setStorageSpace (const StorageSpace& storageSpace_) {
    set_has_storageSpace();
    this->_storageSpace = storageSpace_;
}

inline void NavDataContext::set_has_navigationSWVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavDataContext::clear_has_navigationSWVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NavDataContext::set_has_packageId () {
    _has_bits_[0] |= 1u << 1;
}

inline void NavDataContext::clear_has_packageId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NavDataContext::set_has_products () {
    _has_bits_[0] |= 1u << 2;
}

inline void NavDataContext::clear_has_products () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void NavDataContext::set_has_storageSpace () {
    _has_bits_[0] |= 1u << 3;
}

inline void NavDataContext::clear_has_storageSpace () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DeviceInfo::DeviceInfo ()  :
    _DeviceId (0u),
    _DeviceType (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB),
    _DeviceStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus__DEVICESTATUS__AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceInfo::DeviceInfo (const DeviceInfo &rhs)  :
    _DeviceId (0u),
    _DeviceType (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB),
    _DeviceStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus__DEVICESTATUS__AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceInfo::DeviceInfo (uint32 DeviceId_, Devicetype DeviceType_, Devicestatus DeviceStatus_)  :
    _DeviceId (DeviceId_),
    _DeviceType (DeviceType_),
    _DeviceStatus (DeviceStatus_)
{
    #ifndef NDEBUG
    if (!(Devicetype_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "Devicetype", "DeviceType", "DeviceInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(Devicestatus_IsValid(DeviceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceStatus_, "Devicestatus", "DeviceStatus", "DeviceInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceInfo::~DeviceInfo() {
}

inline DeviceInfo& DeviceInfo::operator = (const DeviceInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceId()) {
            setDeviceId(rhs.getDeviceId());
        } else {
            clearDeviceId();
        }
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
        if (rhs.hasDeviceStatus()) {
            setDeviceStatus(rhs.getDeviceStatus());
        } else {
            clearDeviceStatus();
        }
    }
    return *this;
}

inline bool DeviceInfo::operator == (const DeviceInfo& rhs) const {
    return (((!hasDeviceId() && !rhs.hasDeviceId()) || getDeviceId() == rhs.getDeviceId()) &&
        ((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()) &&
        ((!hasDeviceStatus() && !rhs.hasDeviceStatus()) || getDeviceStatus() == rhs.getDeviceStatus()));
}

inline bool DeviceInfo::operator != (const DeviceInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceInfo::operator < (const DeviceInfo& rhs) const {
    if (hasDeviceId() || rhs.hasDeviceId()) {
        if (getDeviceId() < rhs.getDeviceId()) return true;
        if (getDeviceId() > rhs.getDeviceId()) return false;
    }
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if ((uint32)getDeviceType() < (uint32)rhs.getDeviceType()) return true;
        if ((uint32)getDeviceType() > (uint32)rhs.getDeviceType()) return false;
    }
    if (hasDeviceStatus() || rhs.hasDeviceStatus()) {
        if ((uint32)getDeviceStatus() < (uint32)rhs.getDeviceStatus()) return true;
        if ((uint32)getDeviceStatus() > (uint32)rhs.getDeviceStatus()) return false;
    }
    return false;
}

inline bool DeviceInfo::operator > (const DeviceInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceInfo::clear() {
    clearDeviceId();
    clearDeviceType();
    clearDeviceStatus();
}

inline void DeviceInfo::clearDeviceId() {
    if (hasDeviceId()) {
         clear_has_DeviceId();
        _DeviceId = 0u;
     }
}

inline bool DeviceInfo::hasDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DeviceInfo::getDeviceId () const {
    return _DeviceId;
}

inline void DeviceInfo::setDeviceId (uint32 DeviceId_) {
    set_has_DeviceId();
    this->_DeviceId = DeviceId_;
}

inline void DeviceInfo::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_DeviceType();
        _DeviceType = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB;
     }
}

inline bool DeviceInfo::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline Devicetype DeviceInfo::getDeviceType () const {
    return _DeviceType;
}

inline void DeviceInfo::setDeviceType (Devicetype DeviceType_) {
    #ifndef NDEBUG
    if (!(Devicetype_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "Devicetype", "DeviceType", "DeviceInfo");
    }
    #endif
    set_has_DeviceType();
    this->_DeviceType = DeviceType_;
}

inline void DeviceInfo::clearDeviceStatus() {
    if (hasDeviceStatus()) {
         clear_has_DeviceStatus();
        _DeviceStatus = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus__DEVICESTATUS__AVAILABLE;
     }
}

inline bool DeviceInfo::hasDeviceStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline Devicestatus DeviceInfo::getDeviceStatus () const {
    return _DeviceStatus;
}

inline void DeviceInfo::setDeviceStatus (Devicestatus DeviceStatus_) {
    #ifndef NDEBUG
    if (!(Devicestatus_IsValid(DeviceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceStatus_, "Devicestatus", "DeviceStatus", "DeviceInfo");
    }
    #endif
    set_has_DeviceStatus();
    this->_DeviceStatus = DeviceStatus_;
}

inline void DeviceInfo::set_has_DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceInfo::clear_has_DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeviceInfo::set_has_DeviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeviceInfo::clear_has_DeviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DeviceInfo::set_has_DeviceStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void DeviceInfo::clear_has_DeviceStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiagPerformFullUpdateViaUSBResponse::DiagPerformFullUpdateViaUSBResponse ()  :
    _ack (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagPerformFullUpdateViaUSBResponse::DiagPerformFullUpdateViaUSBResponse (const DiagPerformFullUpdateViaUSBResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ack (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagPerformFullUpdateViaUSBResponse::DiagPerformFullUpdateViaUSBResponse (NavigationDataUpdateServiceAck ack_)  :
    _ack (ack_)
{
    #ifndef NDEBUG
    if (!(NavigationDataUpdateServiceAck_IsValid(ack_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ack_, "NavigationDataUpdateServiceAck", "ack", "DiagPerformFullUpdateViaUSBResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagPerformFullUpdateViaUSBResponse::~DiagPerformFullUpdateViaUSBResponse() {
}

inline DiagPerformFullUpdateViaUSBResponse& DiagPerformFullUpdateViaUSBResponse::operator = (const DiagPerformFullUpdateViaUSBResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAck()) {
            setAck(rhs.getAck());
        } else {
            clearAck();
        }
    }
    return *this;
}

inline bool DiagPerformFullUpdateViaUSBResponse::operator == (const DiagPerformFullUpdateViaUSBResponse& rhs) const {
    return (((!hasAck() && !rhs.hasAck()) || getAck() == rhs.getAck()));
}

inline bool DiagPerformFullUpdateViaUSBResponse::operator != (const DiagPerformFullUpdateViaUSBResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagPerformFullUpdateViaUSBResponse::operator < (const DiagPerformFullUpdateViaUSBResponse& rhs) const {
    if (hasAck() || rhs.hasAck()) {
        if ((uint32)getAck() < (uint32)rhs.getAck()) return true;
        if ((uint32)getAck() > (uint32)rhs.getAck()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagPerformFullUpdateViaUSBResponse::clone() {
    return new DiagPerformFullUpdateViaUSBResponse(*this);
}

inline bool DiagPerformFullUpdateViaUSBResponse::operator > (const DiagPerformFullUpdateViaUSBResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagPerformFullUpdateViaUSBResponse::clear() {
    clearAck();
}

inline void DiagPerformFullUpdateViaUSBResponse::clearAck() {
    if (hasAck()) {
         clear_has_ack();
        _ack = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck__ACCEPTED;
     }
}

inline bool DiagPerformFullUpdateViaUSBResponse::hasAck () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NavigationDataUpdateServiceAck DiagPerformFullUpdateViaUSBResponse::getAck () const {
    return _ack;
}

inline void DiagPerformFullUpdateViaUSBResponse::setAck (NavigationDataUpdateServiceAck ack_) {
    #ifndef NDEBUG
    if (!(NavigationDataUpdateServiceAck_IsValid(ack_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ack_, "NavigationDataUpdateServiceAck", "ack", "DiagPerformFullUpdateViaUSBResponse");
    }
    #endif
    set_has_ack();
    this->_ack = ack_;
}

inline void DiagPerformFullUpdateViaUSBResponse::set_has_ack () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagPerformFullUpdateViaUSBResponse::clear_has_ack () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAvailableUpdatesResponse::GetAvailableUpdatesResponse ()  :
    _availableUpdates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAvailableUpdatesResponse::GetAvailableUpdatesResponse (const GetAvailableUpdatesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _availableUpdates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAvailableUpdatesResponse::GetAvailableUpdatesResponse (const AvailableUpdates& availableUpdates_)  :
    _availableUpdates (availableUpdates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAvailableUpdatesResponse::~GetAvailableUpdatesResponse() {
}

inline GetAvailableUpdatesResponse& GetAvailableUpdatesResponse::operator = (const GetAvailableUpdatesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailableUpdates()) {
            setAvailableUpdates(rhs.getAvailableUpdates());
        } else {
            clearAvailableUpdates();
        }
    }
    return *this;
}

inline bool GetAvailableUpdatesResponse::operator == (const GetAvailableUpdatesResponse& rhs) const {
    return (((!hasAvailableUpdates() && !rhs.hasAvailableUpdates()) || getAvailableUpdates() == rhs.getAvailableUpdates()));
}

inline bool GetAvailableUpdatesResponse::operator != (const GetAvailableUpdatesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAvailableUpdatesResponse::operator < (const GetAvailableUpdatesResponse& rhs) const {
    if (hasAvailableUpdates() || rhs.hasAvailableUpdates()) {
        if (getAvailableUpdates() < rhs.getAvailableUpdates()) return true;
        if (getAvailableUpdates() > rhs.getAvailableUpdates()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAvailableUpdatesResponse::clone() {
    return new GetAvailableUpdatesResponse(*this);
}

inline bool GetAvailableUpdatesResponse::operator > (const GetAvailableUpdatesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAvailableUpdatesResponse::clear() {
    clearAvailableUpdates();
}

inline void GetAvailableUpdatesResponse::clearAvailableUpdates() {
    if (hasAvailableUpdates()) {
         clear_has_availableUpdates();
        _availableUpdates.clear();
     }
}

inline bool GetAvailableUpdatesResponse::hasAvailableUpdates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const AvailableUpdates& GetAvailableUpdatesResponse::getAvailableUpdates () const {
    return _availableUpdates;
}

inline AvailableUpdates& GetAvailableUpdatesResponse::getAvailableUpdatesMutable () {
    set_has_availableUpdates();
    return _availableUpdates;
}

inline void GetAvailableUpdatesResponse::setAvailableUpdates (const AvailableUpdates& availableUpdates_) {
    set_has_availableUpdates();
    this->_availableUpdates = availableUpdates_;
}

inline void GetAvailableUpdatesResponse::set_has_availableUpdates () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAvailableUpdatesResponse::clear_has_availableUpdates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeleteUpdateComponentRequest::DeleteUpdateComponentRequest ()  :
    _productId (0u),
    _supplierId (0u),
    _regionId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeleteUpdateComponentRequest::DeleteUpdateComponentRequest (const DeleteUpdateComponentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _productId (0u),
    _supplierId (0u),
    _regionId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeleteUpdateComponentRequest::DeleteUpdateComponentRequest (uint32 productId_, uint32 supplierId_, const ::std::vector< uint32 >& regionId_)  :
    _productId (productId_),
    _supplierId (supplierId_),
    _regionId (regionId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeleteUpdateComponentRequest::~DeleteUpdateComponentRequest() {
}

inline DeleteUpdateComponentRequest& DeleteUpdateComponentRequest::operator = (const DeleteUpdateComponentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
    }
    return *this;
}

inline bool DeleteUpdateComponentRequest::operator == (const DeleteUpdateComponentRequest& rhs) const {
    return (((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()));
}

inline bool DeleteUpdateComponentRequest::operator != (const DeleteUpdateComponentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeleteUpdateComponentRequest::operator < (const DeleteUpdateComponentRequest& rhs) const {
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeleteUpdateComponentRequest::clone() {
    return new DeleteUpdateComponentRequest(*this);
}

inline bool DeleteUpdateComponentRequest::operator > (const DeleteUpdateComponentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeleteUpdateComponentRequest::clear() {
    clearProductId();
    clearSupplierId();
    clearRegionId();
}

inline void DeleteUpdateComponentRequest::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool DeleteUpdateComponentRequest::hasProductId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DeleteUpdateComponentRequest::getProductId () const {
    return _productId;
}

inline void DeleteUpdateComponentRequest::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void DeleteUpdateComponentRequest::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool DeleteUpdateComponentRequest::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DeleteUpdateComponentRequest::getSupplierId () const {
    return _supplierId;
}

inline void DeleteUpdateComponentRequest::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void DeleteUpdateComponentRequest::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId.clear();
     }
}

inline bool DeleteUpdateComponentRequest::hasRegionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint32 >& DeleteUpdateComponentRequest::getRegionId () const {
    return _regionId;
}

inline ::std::vector< uint32 >& DeleteUpdateComponentRequest::getRegionIdMutable () {
    set_has_regionId();
    return _regionId;
}

inline void DeleteUpdateComponentRequest::setRegionId (const ::std::vector< uint32 >& regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void DeleteUpdateComponentRequest::set_has_productId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeleteUpdateComponentRequest::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeleteUpdateComponentRequest::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeleteUpdateComponentRequest::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DeleteUpdateComponentRequest::set_has_regionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void DeleteUpdateComponentRequest::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DeleteUpdateComponentResponse::DeleteUpdateComponentResponse ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult__DELETED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeleteUpdateComponentResponse::DeleteUpdateComponentResponse (const DeleteUpdateComponentResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult__DELETED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeleteUpdateComponentResponse::DeleteUpdateComponentResponse (DeleteUpdateComponentResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(DeleteUpdateComponentResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "DeleteUpdateComponentResult", "result", "DeleteUpdateComponentResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeleteUpdateComponentResponse::~DeleteUpdateComponentResponse() {
}

inline DeleteUpdateComponentResponse& DeleteUpdateComponentResponse::operator = (const DeleteUpdateComponentResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DeleteUpdateComponentResponse::operator == (const DeleteUpdateComponentResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DeleteUpdateComponentResponse::operator != (const DeleteUpdateComponentResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DeleteUpdateComponentResponse::operator < (const DeleteUpdateComponentResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeleteUpdateComponentResponse::clone() {
    return new DeleteUpdateComponentResponse(*this);
}

inline bool DeleteUpdateComponentResponse::operator > (const DeleteUpdateComponentResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeleteUpdateComponentResponse::clear() {
    clearResult();
}

inline void DeleteUpdateComponentResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult__DELETED;
     }
}

inline bool DeleteUpdateComponentResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline DeleteUpdateComponentResult DeleteUpdateComponentResponse::getResult () const {
    return _result;
}

inline void DeleteUpdateComponentResponse::setResult (DeleteUpdateComponentResult result_) {
    #ifndef NDEBUG
    if (!(DeleteUpdateComponentResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "DeleteUpdateComponentResult", "result", "DeleteUpdateComponentResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DeleteUpdateComponentResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeleteUpdateComponentResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFavoriteUpdateRegionsRequest::SetFavoriteUpdateRegionsRequest ()  :
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFavoriteUpdateRegionsRequest::SetFavoriteUpdateRegionsRequest (const SetFavoriteUpdateRegionsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _productId (0u),
    _supplierId (0u),
    _baselineMapId (0u),
    _updateRegionIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFavoriteUpdateRegionsRequest::SetFavoriteUpdateRegionsRequest (uint32 productId_, uint32 supplierId_, uint32 baselineMapId_, const ::std::vector< uint32 >& updateRegionIds_)  :
    _productId (productId_),
    _supplierId (supplierId_),
    _baselineMapId (baselineMapId_),
    _updateRegionIds (updateRegionIds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFavoriteUpdateRegionsRequest::~SetFavoriteUpdateRegionsRequest() {
}

inline SetFavoriteUpdateRegionsRequest& SetFavoriteUpdateRegionsRequest::operator = (const SetFavoriteUpdateRegionsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProductId()) {
            setProductId(rhs.getProductId());
        } else {
            clearProductId();
        }
        if (rhs.hasSupplierId()) {
            setSupplierId(rhs.getSupplierId());
        } else {
            clearSupplierId();
        }
        if (rhs.hasBaselineMapId()) {
            setBaselineMapId(rhs.getBaselineMapId());
        } else {
            clearBaselineMapId();
        }
        if (rhs.hasUpdateRegionIds()) {
            setUpdateRegionIds(rhs.getUpdateRegionIds());
        } else {
            clearUpdateRegionIds();
        }
    }
    return *this;
}

inline bool SetFavoriteUpdateRegionsRequest::operator == (const SetFavoriteUpdateRegionsRequest& rhs) const {
    return (((!hasProductId() && !rhs.hasProductId()) || getProductId() == rhs.getProductId()) &&
        ((!hasSupplierId() && !rhs.hasSupplierId()) || getSupplierId() == rhs.getSupplierId()) &&
        ((!hasBaselineMapId() && !rhs.hasBaselineMapId()) || getBaselineMapId() == rhs.getBaselineMapId()) &&
        ((!hasUpdateRegionIds() && !rhs.hasUpdateRegionIds()) || getUpdateRegionIds() == rhs.getUpdateRegionIds()));
}

inline bool SetFavoriteUpdateRegionsRequest::operator != (const SetFavoriteUpdateRegionsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFavoriteUpdateRegionsRequest::operator < (const SetFavoriteUpdateRegionsRequest& rhs) const {
    if (hasProductId() || rhs.hasProductId()) {
        if (getProductId() < rhs.getProductId()) return true;
        if (getProductId() > rhs.getProductId()) return false;
    }
    if (hasSupplierId() || rhs.hasSupplierId()) {
        if (getSupplierId() < rhs.getSupplierId()) return true;
        if (getSupplierId() > rhs.getSupplierId()) return false;
    }
    if (hasBaselineMapId() || rhs.hasBaselineMapId()) {
        if (getBaselineMapId() < rhs.getBaselineMapId()) return true;
        if (getBaselineMapId() > rhs.getBaselineMapId()) return false;
    }
    if (hasUpdateRegionIds() || rhs.hasUpdateRegionIds()) {
        if (getUpdateRegionIds() < rhs.getUpdateRegionIds()) return true;
        if (getUpdateRegionIds() > rhs.getUpdateRegionIds()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFavoriteUpdateRegionsRequest::clone() {
    return new SetFavoriteUpdateRegionsRequest(*this);
}

inline bool SetFavoriteUpdateRegionsRequest::operator > (const SetFavoriteUpdateRegionsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFavoriteUpdateRegionsRequest::clear() {
    clearProductId();
    clearSupplierId();
    clearBaselineMapId();
    clearUpdateRegionIds();
}

inline void SetFavoriteUpdateRegionsRequest::clearProductId() {
    if (hasProductId()) {
         clear_has_productId();
        _productId = 0u;
     }
}

inline bool SetFavoriteUpdateRegionsRequest::hasProductId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SetFavoriteUpdateRegionsRequest::getProductId () const {
    return _productId;
}

inline void SetFavoriteUpdateRegionsRequest::setProductId (uint32 productId_) {
    set_has_productId();
    this->_productId = productId_;
}

inline void SetFavoriteUpdateRegionsRequest::clearSupplierId() {
    if (hasSupplierId()) {
         clear_has_supplierId();
        _supplierId = 0u;
     }
}

inline bool SetFavoriteUpdateRegionsRequest::hasSupplierId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SetFavoriteUpdateRegionsRequest::getSupplierId () const {
    return _supplierId;
}

inline void SetFavoriteUpdateRegionsRequest::setSupplierId (uint32 supplierId_) {
    set_has_supplierId();
    this->_supplierId = supplierId_;
}

inline void SetFavoriteUpdateRegionsRequest::clearBaselineMapId() {
    if (hasBaselineMapId()) {
         clear_has_baselineMapId();
        _baselineMapId = 0u;
     }
}

inline bool SetFavoriteUpdateRegionsRequest::hasBaselineMapId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SetFavoriteUpdateRegionsRequest::getBaselineMapId () const {
    return _baselineMapId;
}

inline void SetFavoriteUpdateRegionsRequest::setBaselineMapId (uint32 baselineMapId_) {
    set_has_baselineMapId();
    this->_baselineMapId = baselineMapId_;
}

inline void SetFavoriteUpdateRegionsRequest::clearUpdateRegionIds() {
    if (hasUpdateRegionIds()) {
         clear_has_updateRegionIds();
        _updateRegionIds.clear();
     }
}

inline bool SetFavoriteUpdateRegionsRequest::hasUpdateRegionIds () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint32 >& SetFavoriteUpdateRegionsRequest::getUpdateRegionIds () const {
    return _updateRegionIds;
}

inline ::std::vector< uint32 >& SetFavoriteUpdateRegionsRequest::getUpdateRegionIdsMutable () {
    set_has_updateRegionIds();
    return _updateRegionIds;
}

inline void SetFavoriteUpdateRegionsRequest::setUpdateRegionIds (const ::std::vector< uint32 >& updateRegionIds_) {
    set_has_updateRegionIds();
    this->_updateRegionIds = updateRegionIds_;
}

inline void SetFavoriteUpdateRegionsRequest::set_has_productId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFavoriteUpdateRegionsRequest::clear_has_productId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFavoriteUpdateRegionsRequest::set_has_supplierId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFavoriteUpdateRegionsRequest::clear_has_supplierId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFavoriteUpdateRegionsRequest::set_has_baselineMapId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFavoriteUpdateRegionsRequest::clear_has_baselineMapId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFavoriteUpdateRegionsRequest::set_has_updateRegionIds () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFavoriteUpdateRegionsRequest::clear_has_updateRegionIds () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SetFavoriteUpdateRegionsResponse::SetFavoriteUpdateRegionsResponse ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFavoriteUpdateRegionsResponse::SetFavoriteUpdateRegionsResponse (const SetFavoriteUpdateRegionsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFavoriteUpdateRegionsResponse::SetFavoriteUpdateRegionsResponse (SetFavoriteUpdateRegionsResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(SetFavoriteUpdateRegionsResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "SetFavoriteUpdateRegionsResult", "result", "SetFavoriteUpdateRegionsResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFavoriteUpdateRegionsResponse::~SetFavoriteUpdateRegionsResponse() {
}

inline SetFavoriteUpdateRegionsResponse& SetFavoriteUpdateRegionsResponse::operator = (const SetFavoriteUpdateRegionsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetFavoriteUpdateRegionsResponse::operator == (const SetFavoriteUpdateRegionsResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetFavoriteUpdateRegionsResponse::operator != (const SetFavoriteUpdateRegionsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFavoriteUpdateRegionsResponse::operator < (const SetFavoriteUpdateRegionsResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFavoriteUpdateRegionsResponse::clone() {
    return new SetFavoriteUpdateRegionsResponse(*this);
}

inline bool SetFavoriteUpdateRegionsResponse::operator > (const SetFavoriteUpdateRegionsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFavoriteUpdateRegionsResponse::clear() {
    clearResult();
}

inline void SetFavoriteUpdateRegionsResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult__OK;
     }
}

inline bool SetFavoriteUpdateRegionsResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SetFavoriteUpdateRegionsResult SetFavoriteUpdateRegionsResponse::getResult () const {
    return _result;
}

inline void SetFavoriteUpdateRegionsResponse::setResult (SetFavoriteUpdateRegionsResult result_) {
    #ifndef NDEBUG
    if (!(SetFavoriteUpdateRegionsResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "SetFavoriteUpdateRegionsResult", "result", "SetFavoriteUpdateRegionsResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetFavoriteUpdateRegionsResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFavoriteUpdateRegionsResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClearFavoriteUpdateRegionsResponse::ClearFavoriteUpdateRegionsResponse ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearFavoriteUpdateRegionsResponse::ClearFavoriteUpdateRegionsResponse (const ClearFavoriteUpdateRegionsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearFavoriteUpdateRegionsResponse::ClearFavoriteUpdateRegionsResponse (ClearFavoriteUpdateRegionsResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(ClearFavoriteUpdateRegionsResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "ClearFavoriteUpdateRegionsResult", "result", "ClearFavoriteUpdateRegionsResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearFavoriteUpdateRegionsResponse::~ClearFavoriteUpdateRegionsResponse() {
}

inline ClearFavoriteUpdateRegionsResponse& ClearFavoriteUpdateRegionsResponse::operator = (const ClearFavoriteUpdateRegionsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool ClearFavoriteUpdateRegionsResponse::operator == (const ClearFavoriteUpdateRegionsResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool ClearFavoriteUpdateRegionsResponse::operator != (const ClearFavoriteUpdateRegionsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearFavoriteUpdateRegionsResponse::operator < (const ClearFavoriteUpdateRegionsResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearFavoriteUpdateRegionsResponse::clone() {
    return new ClearFavoriteUpdateRegionsResponse(*this);
}

inline bool ClearFavoriteUpdateRegionsResponse::operator > (const ClearFavoriteUpdateRegionsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearFavoriteUpdateRegionsResponse::clear() {
    clearResult();
}

inline void ClearFavoriteUpdateRegionsResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult__OK;
     }
}

inline bool ClearFavoriteUpdateRegionsResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ClearFavoriteUpdateRegionsResult ClearFavoriteUpdateRegionsResponse::getResult () const {
    return _result;
}

inline void ClearFavoriteUpdateRegionsResponse::setResult (ClearFavoriteUpdateRegionsResult result_) {
    #ifndef NDEBUG
    if (!(ClearFavoriteUpdateRegionsResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "ClearFavoriteUpdateRegionsResult", "result", "ClearFavoriteUpdateRegionsResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void ClearFavoriteUpdateRegionsResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearFavoriteUpdateRegionsResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartFullUpdateResponse::StartFullUpdateResponse ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartFullUpdateResponse::StartFullUpdateResponse (const StartFullUpdateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartFullUpdateResponse::StartFullUpdateResponse (StartFullUpdateResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(StartFullUpdateResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "StartFullUpdateResult", "result", "StartFullUpdateResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartFullUpdateResponse::~StartFullUpdateResponse() {
}

inline StartFullUpdateResponse& StartFullUpdateResponse::operator = (const StartFullUpdateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool StartFullUpdateResponse::operator == (const StartFullUpdateResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool StartFullUpdateResponse::operator != (const StartFullUpdateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartFullUpdateResponse::operator < (const StartFullUpdateResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartFullUpdateResponse::clone() {
    return new StartFullUpdateResponse(*this);
}

inline bool StartFullUpdateResponse::operator > (const StartFullUpdateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartFullUpdateResponse::clear() {
    clearResult();
}

inline void StartFullUpdateResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult__ACCEPTED;
     }
}

inline bool StartFullUpdateResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline StartFullUpdateResult StartFullUpdateResponse::getResult () const {
    return _result;
}

inline void StartFullUpdateResponse::setResult (StartFullUpdateResult result_) {
    #ifndef NDEBUG
    if (!(StartFullUpdateResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "StartFullUpdateResult", "result", "StartFullUpdateResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void StartFullUpdateResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartFullUpdateResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartMapDataExportRequest::StartMapDataExportRequest ()  :
    _deviceId (0u),
    _deviceType (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartMapDataExportRequest::StartMapDataExportRequest (const StartMapDataExportRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _deviceId (0u),
    _deviceType (::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartMapDataExportRequest::StartMapDataExportRequest (uint32 deviceId_, Devicetype deviceType_)  :
    _deviceId (deviceId_),
    _deviceType (deviceType_)
{
    #ifndef NDEBUG
    if (!(Devicetype_IsValid(deviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", deviceType_, "Devicetype", "deviceType", "StartMapDataExportRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartMapDataExportRequest::~StartMapDataExportRequest() {
}

inline StartMapDataExportRequest& StartMapDataExportRequest::operator = (const StartMapDataExportRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceId()) {
            setDeviceId(rhs.getDeviceId());
        } else {
            clearDeviceId();
        }
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
    }
    return *this;
}

inline bool StartMapDataExportRequest::operator == (const StartMapDataExportRequest& rhs) const {
    return (((!hasDeviceId() && !rhs.hasDeviceId()) || getDeviceId() == rhs.getDeviceId()) &&
        ((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()));
}

inline bool StartMapDataExportRequest::operator != (const StartMapDataExportRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartMapDataExportRequest::operator < (const StartMapDataExportRequest& rhs) const {
    if (hasDeviceId() || rhs.hasDeviceId()) {
        if (getDeviceId() < rhs.getDeviceId()) return true;
        if (getDeviceId() > rhs.getDeviceId()) return false;
    }
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if ((uint32)getDeviceType() < (uint32)rhs.getDeviceType()) return true;
        if ((uint32)getDeviceType() > (uint32)rhs.getDeviceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartMapDataExportRequest::clone() {
    return new StartMapDataExportRequest(*this);
}

inline bool StartMapDataExportRequest::operator > (const StartMapDataExportRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartMapDataExportRequest::clear() {
    clearDeviceId();
    clearDeviceType();
}

inline void StartMapDataExportRequest::clearDeviceId() {
    if (hasDeviceId()) {
         clear_has_deviceId();
        _deviceId = 0u;
     }
}

inline bool StartMapDataExportRequest::hasDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 StartMapDataExportRequest::getDeviceId () const {
    return _deviceId;
}

inline void StartMapDataExportRequest::setDeviceId (uint32 deviceId_) {
    set_has_deviceId();
    this->_deviceId = deviceId_;
}

inline void StartMapDataExportRequest::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_deviceType();
        _deviceType = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB;
     }
}

inline bool StartMapDataExportRequest::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline Devicetype StartMapDataExportRequest::getDeviceType () const {
    return _deviceType;
}

inline void StartMapDataExportRequest::setDeviceType (Devicetype deviceType_) {
    #ifndef NDEBUG
    if (!(Devicetype_IsValid(deviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", deviceType_, "Devicetype", "deviceType", "StartMapDataExportRequest");
    }
    #endif
    set_has_deviceType();
    this->_deviceType = deviceType_;
}

inline void StartMapDataExportRequest::set_has_deviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartMapDataExportRequest::clear_has_deviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartMapDataExportRequest::set_has_deviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartMapDataExportRequest::clear_has_deviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartMapDataExportResponse::StartMapDataExportResponse ()  :
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus__EXPORT_TRIGGER_SUCCESSFULLY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartMapDataExportResponse::StartMapDataExportResponse (const StartMapDataExportResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus__EXPORT_TRIGGER_SUCCESSFULLY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartMapDataExportResponse::StartMapDataExportResponse (MapExportStartStatus result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(MapExportStartStatus_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "MapExportStartStatus", "result", "StartMapDataExportResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartMapDataExportResponse::~StartMapDataExportResponse() {
}

inline StartMapDataExportResponse& StartMapDataExportResponse::operator = (const StartMapDataExportResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool StartMapDataExportResponse::operator == (const StartMapDataExportResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool StartMapDataExportResponse::operator != (const StartMapDataExportResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartMapDataExportResponse::operator < (const StartMapDataExportResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartMapDataExportResponse::clone() {
    return new StartMapDataExportResponse(*this);
}

inline bool StartMapDataExportResponse::operator > (const StartMapDataExportResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartMapDataExportResponse::clear() {
    clearResult();
}

inline void StartMapDataExportResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus__EXPORT_TRIGGER_SUCCESSFULLY;
     }
}

inline bool StartMapDataExportResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline MapExportStartStatus StartMapDataExportResponse::getResult () const {
    return _result;
}

inline void StartMapDataExportResponse::setResult (MapExportStartStatus result_) {
    #ifndef NDEBUG
    if (!(MapExportStartStatus_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "MapExportStartStatus", "result", "StartMapDataExportResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void StartMapDataExportResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartMapDataExportResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FavoriteUpdateRegionsUpdate::FavoriteUpdateRegionsUpdate ()  :
    _favoriteUpdateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegionsUpdate::FavoriteUpdateRegionsUpdate (const FavoriteUpdateRegionsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _favoriteUpdateRegions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FavoriteUpdateRegionsUpdate::FavoriteUpdateRegionsUpdate (const FavoriteUpdateRegions& favoriteUpdateRegions_)  :
    _favoriteUpdateRegions (favoriteUpdateRegions_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegionsUpdate::~FavoriteUpdateRegionsUpdate() {
}

inline FavoriteUpdateRegionsUpdate& FavoriteUpdateRegionsUpdate::operator = (const FavoriteUpdateRegionsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFavoriteUpdateRegions()) {
            setFavoriteUpdateRegions(rhs.getFavoriteUpdateRegions());
        } else {
            clearFavoriteUpdateRegions();
        }
    }
    return *this;
}

inline bool FavoriteUpdateRegionsUpdate::operator == (const FavoriteUpdateRegionsUpdate& rhs) const {
    return (((!hasFavoriteUpdateRegions() && !rhs.hasFavoriteUpdateRegions()) || getFavoriteUpdateRegions() == rhs.getFavoriteUpdateRegions()));
}

inline bool FavoriteUpdateRegionsUpdate::operator != (const FavoriteUpdateRegionsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FavoriteUpdateRegionsUpdate::operator < (const FavoriteUpdateRegionsUpdate& rhs) const {
    if (hasFavoriteUpdateRegions() || rhs.hasFavoriteUpdateRegions()) {
        if (getFavoriteUpdateRegions() < rhs.getFavoriteUpdateRegions()) return true;
        if (getFavoriteUpdateRegions() > rhs.getFavoriteUpdateRegions()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FavoriteUpdateRegionsUpdate::clone() {
    return new FavoriteUpdateRegionsUpdate(*this);
}

inline bool FavoriteUpdateRegionsUpdate::operator > (const FavoriteUpdateRegionsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FavoriteUpdateRegionsUpdate::clear() {
    clearFavoriteUpdateRegions();
}

inline void FavoriteUpdateRegionsUpdate::clearFavoriteUpdateRegions() {
    if (hasFavoriteUpdateRegions()) {
         clear_has_favoriteUpdateRegions();
        _favoriteUpdateRegions.clear();
     }
}

inline bool FavoriteUpdateRegionsUpdate::hasFavoriteUpdateRegions () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const FavoriteUpdateRegions& FavoriteUpdateRegionsUpdate::getFavoriteUpdateRegions () const {
    return _favoriteUpdateRegions;
}

inline FavoriteUpdateRegions& FavoriteUpdateRegionsUpdate::getFavoriteUpdateRegionsMutable () {
    set_has_favoriteUpdateRegions();
    return _favoriteUpdateRegions;
}

inline void FavoriteUpdateRegionsUpdate::setFavoriteUpdateRegions (const FavoriteUpdateRegions& favoriteUpdateRegions_) {
    set_has_favoriteUpdateRegions();
    this->_favoriteUpdateRegions = favoriteUpdateRegions_;
}

inline void FavoriteUpdateRegionsUpdate::set_has_favoriteUpdateRegions () {
    _has_bits_[0] |= 1u << 0;
}

inline void FavoriteUpdateRegionsUpdate::clear_has_favoriteUpdateRegions () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FavoriteUpdateRegionsRegister::FavoriteUpdateRegionsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FavoriteUpdateRegionsRegister::FavoriteUpdateRegionsRegister (const FavoriteUpdateRegionsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FavoriteUpdateRegionsRegister::~FavoriteUpdateRegionsRegister() {
}

inline FavoriteUpdateRegionsRegister& FavoriteUpdateRegionsRegister::operator = (const FavoriteUpdateRegionsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FavoriteUpdateRegionsRegister::operator == (const FavoriteUpdateRegionsRegister& ) const {
    return true;
}

inline bool FavoriteUpdateRegionsRegister::operator != (const FavoriteUpdateRegionsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FavoriteUpdateRegionsRegister::operator < (const FavoriteUpdateRegionsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FavoriteUpdateRegionsRegister::clone() {
    return new FavoriteUpdateRegionsRegister(*this);
}

inline bool FavoriteUpdateRegionsRegister::operator > (const FavoriteUpdateRegionsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FavoriteUpdateRegionsRegister::clear() {
}

inline  InstallationStatusUpdate::InstallationStatusUpdate ()  :
    _installationStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstallationStatusUpdate::InstallationStatusUpdate (const InstallationStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _installationStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstallationStatusUpdate::InstallationStatusUpdate (const InstallationStatus& installationStatus_)  :
    _installationStatus (installationStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InstallationStatusUpdate::~InstallationStatusUpdate() {
}

inline InstallationStatusUpdate& InstallationStatusUpdate::operator = (const InstallationStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInstallationStatus()) {
            setInstallationStatus(rhs.getInstallationStatus());
        } else {
            clearInstallationStatus();
        }
    }
    return *this;
}

inline bool InstallationStatusUpdate::operator == (const InstallationStatusUpdate& rhs) const {
    return (((!hasInstallationStatus() && !rhs.hasInstallationStatus()) || getInstallationStatus() == rhs.getInstallationStatus()));
}

inline bool InstallationStatusUpdate::operator != (const InstallationStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InstallationStatusUpdate::operator < (const InstallationStatusUpdate& rhs) const {
    if (hasInstallationStatus() || rhs.hasInstallationStatus()) {
        if (getInstallationStatus() < rhs.getInstallationStatus()) return true;
        if (getInstallationStatus() > rhs.getInstallationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InstallationStatusUpdate::clone() {
    return new InstallationStatusUpdate(*this);
}

inline bool InstallationStatusUpdate::operator > (const InstallationStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstallationStatusUpdate::clear() {
    clearInstallationStatus();
}

inline void InstallationStatusUpdate::clearInstallationStatus() {
    if (hasInstallationStatus()) {
         clear_has_installationStatus();
        _installationStatus.clear();
     }
}

inline bool InstallationStatusUpdate::hasInstallationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const InstallationStatus& InstallationStatusUpdate::getInstallationStatus () const {
    return _installationStatus;
}

inline InstallationStatus& InstallationStatusUpdate::getInstallationStatusMutable () {
    set_has_installationStatus();
    return _installationStatus;
}

inline void InstallationStatusUpdate::setInstallationStatus (const InstallationStatus& installationStatus_) {
    set_has_installationStatus();
    this->_installationStatus = installationStatus_;
}

inline void InstallationStatusUpdate::set_has_installationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void InstallationStatusUpdate::clear_has_installationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InstallationStatusRegister::InstallationStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstallationStatusRegister::InstallationStatusRegister (const InstallationStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstallationStatusRegister::~InstallationStatusRegister() {
}

inline InstallationStatusRegister& InstallationStatusRegister::operator = (const InstallationStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InstallationStatusRegister::operator == (const InstallationStatusRegister& ) const {
    return true;
}

inline bool InstallationStatusRegister::operator != (const InstallationStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InstallationStatusRegister::operator < (const InstallationStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InstallationStatusRegister::clone() {
    return new InstallationStatusRegister(*this);
}

inline bool InstallationStatusRegister::operator > (const InstallationStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstallationStatusRegister::clear() {
}

inline  NavDataStatusUpdate::NavDataStatusUpdate ()  :
    _navDataStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus__NAVDATA_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataStatusUpdate::NavDataStatusUpdate (const NavDataStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _navDataStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus__NAVDATA_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataStatusUpdate::NavDataStatusUpdate (NavigationDataStatus navDataStatus_)  :
    _navDataStatus (navDataStatus_)
{
    #ifndef NDEBUG
    if (!(NavigationDataStatus_IsValid(navDataStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", navDataStatus_, "NavigationDataStatus", "navDataStatus", "NavDataStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavDataStatusUpdate::~NavDataStatusUpdate() {
}

inline NavDataStatusUpdate& NavDataStatusUpdate::operator = (const NavDataStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNavDataStatus()) {
            setNavDataStatus(rhs.getNavDataStatus());
        } else {
            clearNavDataStatus();
        }
    }
    return *this;
}

inline bool NavDataStatusUpdate::operator == (const NavDataStatusUpdate& rhs) const {
    return (((!hasNavDataStatus() && !rhs.hasNavDataStatus()) || getNavDataStatus() == rhs.getNavDataStatus()));
}

inline bool NavDataStatusUpdate::operator != (const NavDataStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataStatusUpdate::operator < (const NavDataStatusUpdate& rhs) const {
    if (hasNavDataStatus() || rhs.hasNavDataStatus()) {
        if ((uint32)getNavDataStatus() < (uint32)rhs.getNavDataStatus()) return true;
        if ((uint32)getNavDataStatus() > (uint32)rhs.getNavDataStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NavDataStatusUpdate::clone() {
    return new NavDataStatusUpdate(*this);
}

inline bool NavDataStatusUpdate::operator > (const NavDataStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataStatusUpdate::clear() {
    clearNavDataStatus();
}

inline void NavDataStatusUpdate::clearNavDataStatus() {
    if (hasNavDataStatus()) {
         clear_has_navDataStatus();
        _navDataStatus = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus__NAVDATA_OK;
     }
}

inline bool NavDataStatusUpdate::hasNavDataStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline NavigationDataStatus NavDataStatusUpdate::getNavDataStatus () const {
    return _navDataStatus;
}

inline void NavDataStatusUpdate::setNavDataStatus (NavigationDataStatus navDataStatus_) {
    #ifndef NDEBUG
    if (!(NavigationDataStatus_IsValid(navDataStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", navDataStatus_, "NavigationDataStatus", "navDataStatus", "NavDataStatusUpdate");
    }
    #endif
    set_has_navDataStatus();
    this->_navDataStatus = navDataStatus_;
}

inline void NavDataStatusUpdate::set_has_navDataStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavDataStatusUpdate::clear_has_navDataStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NavDataStatusRegister::NavDataStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataStatusRegister::NavDataStatusRegister (const NavDataStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataStatusRegister::~NavDataStatusRegister() {
}

inline NavDataStatusRegister& NavDataStatusRegister::operator = (const NavDataStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NavDataStatusRegister::operator == (const NavDataStatusRegister& ) const {
    return true;
}

inline bool NavDataStatusRegister::operator != (const NavDataStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataStatusRegister::operator < (const NavDataStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NavDataStatusRegister::clone() {
    return new NavDataStatusRegister(*this);
}

inline bool NavDataStatusRegister::operator > (const NavDataStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataStatusRegister::clear() {
}

inline  NavDataContextUpdate::NavDataContextUpdate ()  :
    _navDataContext ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataContextUpdate::NavDataContextUpdate (const NavDataContextUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _navDataContext ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataContextUpdate::NavDataContextUpdate (const NavDataContext& navDataContext_)  :
    _navDataContext (navDataContext_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavDataContextUpdate::~NavDataContextUpdate() {
}

inline NavDataContextUpdate& NavDataContextUpdate::operator = (const NavDataContextUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNavDataContext()) {
            setNavDataContext(rhs.getNavDataContext());
        } else {
            clearNavDataContext();
        }
    }
    return *this;
}

inline bool NavDataContextUpdate::operator == (const NavDataContextUpdate& rhs) const {
    return (((!hasNavDataContext() && !rhs.hasNavDataContext()) || getNavDataContext() == rhs.getNavDataContext()));
}

inline bool NavDataContextUpdate::operator != (const NavDataContextUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataContextUpdate::operator < (const NavDataContextUpdate& rhs) const {
    if (hasNavDataContext() || rhs.hasNavDataContext()) {
        if (getNavDataContext() < rhs.getNavDataContext()) return true;
        if (getNavDataContext() > rhs.getNavDataContext()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NavDataContextUpdate::clone() {
    return new NavDataContextUpdate(*this);
}

inline bool NavDataContextUpdate::operator > (const NavDataContextUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataContextUpdate::clear() {
    clearNavDataContext();
}

inline void NavDataContextUpdate::clearNavDataContext() {
    if (hasNavDataContext()) {
         clear_has_navDataContext();
        _navDataContext.clear();
     }
}

inline bool NavDataContextUpdate::hasNavDataContext () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const NavDataContext& NavDataContextUpdate::getNavDataContext () const {
    return _navDataContext;
}

inline NavDataContext& NavDataContextUpdate::getNavDataContextMutable () {
    set_has_navDataContext();
    return _navDataContext;
}

inline void NavDataContextUpdate::setNavDataContext (const NavDataContext& navDataContext_) {
    set_has_navDataContext();
    this->_navDataContext = navDataContext_;
}

inline void NavDataContextUpdate::set_has_navDataContext () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavDataContextUpdate::clear_has_navDataContext () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NavDataContextRegister::NavDataContextRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavDataContextRegister::NavDataContextRegister (const NavDataContextRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavDataContextRegister::~NavDataContextRegister() {
}

inline NavDataContextRegister& NavDataContextRegister::operator = (const NavDataContextRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NavDataContextRegister::operator == (const NavDataContextRegister& ) const {
    return true;
}

inline bool NavDataContextRegister::operator != (const NavDataContextRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NavDataContextRegister::operator < (const NavDataContextRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NavDataContextRegister::clone() {
    return new NavDataContextRegister(*this);
}

inline bool NavDataContextRegister::operator > (const NavDataContextRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavDataContextRegister::clear() {
}

inline  NavigationDataUpdateStatusInfoUpdate::NavigationDataUpdateStatusInfoUpdate ()  :
    _navigationDataUpdateStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavigationDataUpdateStatusInfoUpdate::NavigationDataUpdateStatusInfoUpdate (const NavigationDataUpdateStatusInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _navigationDataUpdateStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavigationDataUpdateStatusInfoUpdate::NavigationDataUpdateStatusInfoUpdate (const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo_)  :
    _navigationDataUpdateStatusInfo (navigationDataUpdateStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NavigationDataUpdateStatusInfoUpdate::~NavigationDataUpdateStatusInfoUpdate() {
}

inline NavigationDataUpdateStatusInfoUpdate& NavigationDataUpdateStatusInfoUpdate::operator = (const NavigationDataUpdateStatusInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNavigationDataUpdateStatusInfo()) {
            setNavigationDataUpdateStatusInfo(rhs.getNavigationDataUpdateStatusInfo());
        } else {
            clearNavigationDataUpdateStatusInfo();
        }
    }
    return *this;
}

inline bool NavigationDataUpdateStatusInfoUpdate::operator == (const NavigationDataUpdateStatusInfoUpdate& rhs) const {
    return (((!hasNavigationDataUpdateStatusInfo() && !rhs.hasNavigationDataUpdateStatusInfo()) || getNavigationDataUpdateStatusInfo() == rhs.getNavigationDataUpdateStatusInfo()));
}

inline bool NavigationDataUpdateStatusInfoUpdate::operator != (const NavigationDataUpdateStatusInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NavigationDataUpdateStatusInfoUpdate::operator < (const NavigationDataUpdateStatusInfoUpdate& rhs) const {
    if (hasNavigationDataUpdateStatusInfo() || rhs.hasNavigationDataUpdateStatusInfo()) {
        if (getNavigationDataUpdateStatusInfo() < rhs.getNavigationDataUpdateStatusInfo()) return true;
        if (getNavigationDataUpdateStatusInfo() > rhs.getNavigationDataUpdateStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NavigationDataUpdateStatusInfoUpdate::clone() {
    return new NavigationDataUpdateStatusInfoUpdate(*this);
}

inline bool NavigationDataUpdateStatusInfoUpdate::operator > (const NavigationDataUpdateStatusInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavigationDataUpdateStatusInfoUpdate::clear() {
    clearNavigationDataUpdateStatusInfo();
}

inline void NavigationDataUpdateStatusInfoUpdate::clearNavigationDataUpdateStatusInfo() {
    if (hasNavigationDataUpdateStatusInfo()) {
         clear_has_navigationDataUpdateStatusInfo();
        _navigationDataUpdateStatusInfo.clear();
     }
}

inline bool NavigationDataUpdateStatusInfoUpdate::hasNavigationDataUpdateStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const NavigationDataUpdateStatusInfo& NavigationDataUpdateStatusInfoUpdate::getNavigationDataUpdateStatusInfo () const {
    return _navigationDataUpdateStatusInfo;
}

inline NavigationDataUpdateStatusInfo& NavigationDataUpdateStatusInfoUpdate::getNavigationDataUpdateStatusInfoMutable () {
    set_has_navigationDataUpdateStatusInfo();
    return _navigationDataUpdateStatusInfo;
}

inline void NavigationDataUpdateStatusInfoUpdate::setNavigationDataUpdateStatusInfo (const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo_) {
    set_has_navigationDataUpdateStatusInfo();
    this->_navigationDataUpdateStatusInfo = navigationDataUpdateStatusInfo_;
}

inline void NavigationDataUpdateStatusInfoUpdate::set_has_navigationDataUpdateStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void NavigationDataUpdateStatusInfoUpdate::clear_has_navigationDataUpdateStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NavigationDataUpdateStatusInfoRegister::NavigationDataUpdateStatusInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NavigationDataUpdateStatusInfoRegister::NavigationDataUpdateStatusInfoRegister (const NavigationDataUpdateStatusInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NavigationDataUpdateStatusInfoRegister::~NavigationDataUpdateStatusInfoRegister() {
}

inline NavigationDataUpdateStatusInfoRegister& NavigationDataUpdateStatusInfoRegister::operator = (const NavigationDataUpdateStatusInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NavigationDataUpdateStatusInfoRegister::operator == (const NavigationDataUpdateStatusInfoRegister& ) const {
    return true;
}

inline bool NavigationDataUpdateStatusInfoRegister::operator != (const NavigationDataUpdateStatusInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NavigationDataUpdateStatusInfoRegister::operator < (const NavigationDataUpdateStatusInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NavigationDataUpdateStatusInfoRegister::clone() {
    return new NavigationDataUpdateStatusInfoRegister(*this);
}

inline bool NavigationDataUpdateStatusInfoRegister::operator > (const NavigationDataUpdateStatusInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NavigationDataUpdateStatusInfoRegister::clear() {
}

inline  CatalogueStatusUpdate::CatalogueStatusUpdate ()  :
    _catalogueStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CatalogueStatusUpdate::CatalogueStatusUpdate (const CatalogueStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _catalogueStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CatalogueStatusUpdate::CatalogueStatusUpdate (CatalogueStatus catalogueStatus_)  :
    _catalogueStatus (catalogueStatus_)
{
    #ifndef NDEBUG
    if (!(CatalogueStatus_IsValid(catalogueStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", catalogueStatus_, "CatalogueStatus", "catalogueStatus", "CatalogueStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CatalogueStatusUpdate::~CatalogueStatusUpdate() {
}

inline CatalogueStatusUpdate& CatalogueStatusUpdate::operator = (const CatalogueStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCatalogueStatus()) {
            setCatalogueStatus(rhs.getCatalogueStatus());
        } else {
            clearCatalogueStatus();
        }
    }
    return *this;
}

inline bool CatalogueStatusUpdate::operator == (const CatalogueStatusUpdate& rhs) const {
    return (((!hasCatalogueStatus() && !rhs.hasCatalogueStatus()) || getCatalogueStatus() == rhs.getCatalogueStatus()));
}

inline bool CatalogueStatusUpdate::operator != (const CatalogueStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CatalogueStatusUpdate::operator < (const CatalogueStatusUpdate& rhs) const {
    if (hasCatalogueStatus() || rhs.hasCatalogueStatus()) {
        if ((uint32)getCatalogueStatus() < (uint32)rhs.getCatalogueStatus()) return true;
        if ((uint32)getCatalogueStatus() > (uint32)rhs.getCatalogueStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CatalogueStatusUpdate::clone() {
    return new CatalogueStatusUpdate(*this);
}

inline bool CatalogueStatusUpdate::operator > (const CatalogueStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CatalogueStatusUpdate::clear() {
    clearCatalogueStatus();
}

inline void CatalogueStatusUpdate::clearCatalogueStatus() {
    if (hasCatalogueStatus()) {
         clear_has_catalogueStatus();
        _catalogueStatus = ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus__UNKNOWN;
     }
}

inline bool CatalogueStatusUpdate::hasCatalogueStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline CatalogueStatus CatalogueStatusUpdate::getCatalogueStatus () const {
    return _catalogueStatus;
}

inline void CatalogueStatusUpdate::setCatalogueStatus (CatalogueStatus catalogueStatus_) {
    #ifndef NDEBUG
    if (!(CatalogueStatus_IsValid(catalogueStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", catalogueStatus_, "CatalogueStatus", "catalogueStatus", "CatalogueStatusUpdate");
    }
    #endif
    set_has_catalogueStatus();
    this->_catalogueStatus = catalogueStatus_;
}

inline void CatalogueStatusUpdate::set_has_catalogueStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void CatalogueStatusUpdate::clear_has_catalogueStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CatalogueStatusRegister::CatalogueStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CatalogueStatusRegister::CatalogueStatusRegister (const CatalogueStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CatalogueStatusRegister::~CatalogueStatusRegister() {
}

inline CatalogueStatusRegister& CatalogueStatusRegister::operator = (const CatalogueStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CatalogueStatusRegister::operator == (const CatalogueStatusRegister& ) const {
    return true;
}

inline bool CatalogueStatusRegister::operator != (const CatalogueStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CatalogueStatusRegister::operator < (const CatalogueStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CatalogueStatusRegister::clone() {
    return new CatalogueStatusRegister(*this);
}

inline bool CatalogueStatusRegister::operator > (const CatalogueStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CatalogueStatusRegister::clear() {
}

inline  MapupdateExportStatusUpdate::MapupdateExportStatusUpdate ()  :
    _mapupdateExportStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus__USB_DEVICE_STATUS__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapupdateExportStatusUpdate::MapupdateExportStatusUpdate (const MapupdateExportStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _mapupdateExportStatus (::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus__USB_DEVICE_STATUS__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapupdateExportStatusUpdate::MapupdateExportStatusUpdate (MapupdateExportStatus mapupdateExportStatus_)  :
    _mapupdateExportStatus (mapupdateExportStatus_)
{
    #ifndef NDEBUG
    if (!(MapupdateExportStatus_IsValid(mapupdateExportStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", mapupdateExportStatus_, "MapupdateExportStatus", "mapupdateExportStatus", "MapupdateExportStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapupdateExportStatusUpdate::~MapupdateExportStatusUpdate() {
}

inline MapupdateExportStatusUpdate& MapupdateExportStatusUpdate::operator = (const MapupdateExportStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMapupdateExportStatus()) {
            setMapupdateExportStatus(rhs.getMapupdateExportStatus());
        } else {
            clearMapupdateExportStatus();
        }
    }
    return *this;
}

inline bool MapupdateExportStatusUpdate::operator == (const MapupdateExportStatusUpdate& rhs) const {
    return (((!hasMapupdateExportStatus() && !rhs.hasMapupdateExportStatus()) || getMapupdateExportStatus() == rhs.getMapupdateExportStatus()));
}

inline bool MapupdateExportStatusUpdate::operator != (const MapupdateExportStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MapupdateExportStatusUpdate::operator < (const MapupdateExportStatusUpdate& rhs) const {
    if (hasMapupdateExportStatus() || rhs.hasMapupdateExportStatus()) {
        if ((uint32)getMapupdateExportStatus() < (uint32)rhs.getMapupdateExportStatus()) return true;
        if ((uint32)getMapupdateExportStatus() > (uint32)rhs.getMapupdateExportStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapupdateExportStatusUpdate::clone() {
    return new MapupdateExportStatusUpdate(*this);
}

inline bool MapupdateExportStatusUpdate::operator > (const MapupdateExportStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapupdateExportStatusUpdate::clear() {
    clearMapupdateExportStatus();
}

inline void MapupdateExportStatusUpdate::clearMapupdateExportStatus() {
    if (hasMapupdateExportStatus()) {
         clear_has_mapupdateExportStatus();
        _mapupdateExportStatus = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus__USB_DEVICE_STATUS__SUCCESS;
     }
}

inline bool MapupdateExportStatusUpdate::hasMapupdateExportStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline MapupdateExportStatus MapupdateExportStatusUpdate::getMapupdateExportStatus () const {
    return _mapupdateExportStatus;
}

inline void MapupdateExportStatusUpdate::setMapupdateExportStatus (MapupdateExportStatus mapupdateExportStatus_) {
    #ifndef NDEBUG
    if (!(MapupdateExportStatus_IsValid(mapupdateExportStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", mapupdateExportStatus_, "MapupdateExportStatus", "mapupdateExportStatus", "MapupdateExportStatusUpdate");
    }
    #endif
    set_has_mapupdateExportStatus();
    this->_mapupdateExportStatus = mapupdateExportStatus_;
}

inline void MapupdateExportStatusUpdate::set_has_mapupdateExportStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapupdateExportStatusUpdate::clear_has_mapupdateExportStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MapupdateExportStatusRegister::MapupdateExportStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapupdateExportStatusRegister::MapupdateExportStatusRegister (const MapupdateExportStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapupdateExportStatusRegister::~MapupdateExportStatusRegister() {
}

inline MapupdateExportStatusRegister& MapupdateExportStatusRegister::operator = (const MapupdateExportStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MapupdateExportStatusRegister::operator == (const MapupdateExportStatusRegister& ) const {
    return true;
}

inline bool MapupdateExportStatusRegister::operator != (const MapupdateExportStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MapupdateExportStatusRegister::operator < (const MapupdateExportStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MapupdateExportStatusRegister::clone() {
    return new MapupdateExportStatusRegister(*this);
}

inline bool MapupdateExportStatusRegister::operator > (const MapupdateExportStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapupdateExportStatusRegister::clear() {
}

inline  DeviceInfosUpdate::DeviceInfosUpdate ()  :
    _deviceInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceInfosUpdate::DeviceInfosUpdate (const DeviceInfosUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _deviceInfos ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceInfosUpdate::DeviceInfosUpdate (const ::std::vector< DeviceInfo >& deviceInfos_)  :
    _deviceInfos (deviceInfos_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceInfosUpdate::~DeviceInfosUpdate() {
}

inline DeviceInfosUpdate& DeviceInfosUpdate::operator = (const DeviceInfosUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceInfos()) {
            setDeviceInfos(rhs.getDeviceInfos());
        } else {
            clearDeviceInfos();
        }
    }
    return *this;
}

inline bool DeviceInfosUpdate::operator == (const DeviceInfosUpdate& rhs) const {
    return (((!hasDeviceInfos() && !rhs.hasDeviceInfos()) || getDeviceInfos() == rhs.getDeviceInfos()));
}

inline bool DeviceInfosUpdate::operator != (const DeviceInfosUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceInfosUpdate::operator < (const DeviceInfosUpdate& rhs) const {
    if (hasDeviceInfos() || rhs.hasDeviceInfos()) {
        if (getDeviceInfos() < rhs.getDeviceInfos()) return true;
        if (getDeviceInfos() > rhs.getDeviceInfos()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceInfosUpdate::clone() {
    return new DeviceInfosUpdate(*this);
}

inline bool DeviceInfosUpdate::operator > (const DeviceInfosUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceInfosUpdate::clear() {
    clearDeviceInfos();
}

inline void DeviceInfosUpdate::clearDeviceInfos() {
    if (hasDeviceInfos()) {
         clear_has_deviceInfos();
        _deviceInfos.clear();
     }
}

inline bool DeviceInfosUpdate::hasDeviceInfos () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< DeviceInfo >& DeviceInfosUpdate::getDeviceInfos () const {
    return _deviceInfos;
}

inline ::std::vector< DeviceInfo >& DeviceInfosUpdate::getDeviceInfosMutable () {
    set_has_deviceInfos();
    return _deviceInfos;
}

inline void DeviceInfosUpdate::setDeviceInfos (const ::std::vector< DeviceInfo >& deviceInfos_) {
    set_has_deviceInfos();
    this->_deviceInfos = deviceInfos_;
}

inline void DeviceInfosUpdate::set_has_deviceInfos () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceInfosUpdate::clear_has_deviceInfos () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceInfosRegister::DeviceInfosRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceInfosRegister::DeviceInfosRegister (const DeviceInfosRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceInfosRegister::~DeviceInfosRegister() {
}

inline DeviceInfosRegister& DeviceInfosRegister::operator = (const DeviceInfosRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeviceInfosRegister::operator == (const DeviceInfosRegister& ) const {
    return true;
}

inline bool DeviceInfosRegister::operator != (const DeviceInfosRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceInfosRegister::operator < (const DeviceInfosRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeviceInfosRegister::clone() {
    return new DeviceInfosRegister(*this);
}

inline bool DeviceInfosRegister::operator > (const DeviceInfosRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceInfosRegister::clear() {
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
