/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/NativeTestApplication.h"
#include "com/bosch/NativeTestComponent.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "NativeTestApplication" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {

DEFINE_LOGGER_AND_LEVEL (_logger, "/com/bosch/NativeTestApplication", Info);

/* static */ const char* NativeTestApplication::nativeTestComponent = "nativeTestComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool NativeTestApplication_enabledASFSignalHandler = false;

void importNativeTestApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach NativeTestApplication, because no Application is instantiated");

    // Expression

    cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'Thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("Thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'NativeTestComponent nativeTestComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::com::bosch::NativeTestComponent > > nativeTestComponentFactory(new ::asf::core::ComponentFactory< ::com::bosch::NativeTestComponent >);
        ::asf::core::ComponentDescriptionSharedPtr nativeTestComponentDescription(new ::asf::core::ComponentDescription(1, "nativeTestComponent", /* immediate = */ true, /* threadBridge = */ false, nativeTestComponentFactory));
        Thread1->addComponentDescription(nativeTestComponentDescription);

            // Port 'NativeService1Port'

            ::asf::core::ProvidedPort& nativeTestComponent_NativeService1Port = nativeTestComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("com.bosch.NativeService1", "NativeService1Port", false, false));
            (void)nativeTestComponent_NativeService1Port; // prevent unused variable warning

            // Port 'NativeService2Port'

            ::asf::core::ProvidedPort& nativeTestComponent_NativeService2Port = nativeTestComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("com.bosch.NativeService2", "NativeService2Port", false, false));
            (void)nativeTestComponent_NativeService2Port; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (nativeTestComponent_NativeService1Port, ::std::string("/org/bosch/cm/ai_security/NativeService1"));

    // Expression

    dbusConnector_->exportByName (nativeTestComponent_NativeService2Port, ::std::string("/org/bosch/cm/ai_security/NativeService2"));


    LOG_INFO_STATIC("Starting application 'NativeTestApplication' version 0.1.0");

    app->start();
}

int executeNativeTestApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("com.bosch", "NativeTestApplication");
    } else {
        ::asf::core::Logger::setupLogging ("com.bosch", "NativeTestApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", NativeTestApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("com.bosch", "NativeTestApplication", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create NativeTestApplication");

    app->enableExceptionHandler(true);

    importNativeTestApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace bosch
} // namespace com

int main(int argc, char* argv[]) {
    ::com::bosch::NativeTestApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::com::bosch::executeNativeTestApplication(argc, argv);
}

