/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/NativeService2.h"
#include "com/bosch/NativeService2DBus.h"
#include "com/bosch/NativeService2Json.h"
#include "com/bosch/NativeService2Stub.h"

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace NativeService2 {

DEFINE_CLASS_LOGGER("/com/bosch/com/bosch/NativeService2", NativeService2Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 15, "Service2Method1", 0 },
};


class NativeService2StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NativeService2StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NativeService2StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NativeService2StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.NativeService2"),
          _logger(logger) {}

    virtual ~NativeService2StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NativeService2StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Service2Method1'

            LOG_DEBUG_STUB("process method '%s'", "Service2Method1");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Service2Method1Request);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Service2Method1", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< Service2Method1Request > payload = ::boost::static_pointer_cast<Service2Method1Request>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NativeService2Stub*>(getStub())->onService2Method1Request(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NativeService2StubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.NativeService2\">\n"
            "    <method name=\"Service2Method1\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void NativeService2StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NativeService2Stub*>(getStub()))->onGetAll (properties);
}

void NativeService2StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NativeService2StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NativeService2Stub::NativeService2Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NativeService2StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NativeService2Stub::NativeService2Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NativeService2StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NativeService2Stub::~NativeService2Stub() {
    delete _stubDelegate;
}

void  NativeService2Stub::sendService2Method1Response (bool bOk, act_t act) {
    Service2Method1Response* payload = new Service2Method1Response(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "Service2Method1", Service2Method1Response, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Service2Method1", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NativeService2Stub::sendService2Method1Error (const std::string &errorName, const std::string &errorMessage, act_t act) {
    Service2Method1Error* payload = new Service2Method1Error(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Service2Method1", Service2Method1Error, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Service2Method1", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NativeService2Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace NativeService2
} // namespace bosch
} // namespace com
