/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/NativeService1.h"
#include "com/bosch/NativeService1DBus.h"
#include "com/bosch/NativeService1Json.h"
#include "com/bosch/NativeService1Proxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace NativeService1 {

DEFINE_CLASS_LOGGER("/com/bosch/com/bosch/NativeService1", NativeService1Proxy);

class NativeService1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NativeService1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NativeService1Proxy >& proxyShared = ::boost::static_pointer_cast< NativeService1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_mountNavishare:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MountNavishareError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MountNavishare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MountNavishareError> payload = ::boost::static_pointer_cast<MountNavishareError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MountNavishareCallbackIF*) _callback)->onMountNavishareError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MountNavishareResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MountNavishare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MountNavishareResponse> payload = ::boost::static_pointer_cast<MountNavishareResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MountNavishareCallbackIF*) _callback)->onMountNavishareResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_umountNavishare:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UmountNavishareError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UmountNavishare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UmountNavishareError> payload = ::boost::static_pointer_cast<UmountNavishareError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UmountNavishareCallbackIF*) _callback)->onUmountNavishareError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UmountNavishareResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UmountNavishare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UmountNavishareResponse> payload = ::boost::static_pointer_cast<UmountNavishareResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UmountNavishareCallbackIF*) _callback)->onUmountNavishareResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_mountNavishare: {
                ::boost::shared_ptr< MountNavishareError > payload = ::boost::shared_ptr< MountNavishareError >
                (new MountNavishareError(DBUS_ERROR_NO_SERVER, "The DBus service NativeService1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MountNavishare", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NativeService1Proxy> proxyShared = ::boost::static_pointer_cast<NativeService1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MountNavishareCallbackIF*) _callback)->onMountNavishareError (proxyShared,payload);
                return true;
            }
            break;
            case ID_umountNavishare: {
                ::boost::shared_ptr< UmountNavishareError > payload = ::boost::shared_ptr< UmountNavishareError >
                (new UmountNavishareError(DBUS_ERROR_NO_SERVER, "The DBus service NativeService1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UmountNavishare", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NativeService1Proxy> proxyShared = ::boost::static_pointer_cast<NativeService1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UmountNavishareCallbackIF*) _callback)->onUmountNavishareError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NativeService1ProxyCallback::_logger (NativeService1Proxy::_logger);

NativeService1Proxy::NativeService1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.NativeService1", serviceAvailable, _logger) {
}

NativeService1Proxy::~NativeService1Proxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NativeService1Proxy > NativeService1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NativeService1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NativeService1Proxy > proxyNew(new NativeService1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t NativeService1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NativeService1ProxyCallback* callback = new NativeService1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NativeService1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NativeService1ProxyCallback* callback = new NativeService1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t NativeService1Proxy::sendMountNavishareRequest(MountNavishareCallbackIF& cb) const {
    MountNavishareRequest* payload = new MountNavishareRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "mountNavishare", MountNavishareRequest, payload, true)
    act_t act = addMethodCallback(ID_mountNavishare, dbusMessage.getUniqueSerial(), "mountNavishare", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MountNavishare", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NativeService1Proxy::sendUmountNavishareRequest(UmountNavishareCallbackIF& cb) const {
    UmountNavishareRequest* payload = new UmountNavishareRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "umountNavishare", UmountNavishareRequest, payload, true)
    act_t act = addMethodCallback(ID_umountNavishare, dbusMessage.getUniqueSerial(), "umountNavishare", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UmountNavishare", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NativeService1
} // namespace bosch
} // namespace com
