/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "NanoMsg_MasterApp/NanoMsgServer/NanoMsgMasterAppService.h"
#include "NanoMsg_MasterApp/NanoMsgServer/NanoMsgMasterApplication.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "NanoMsgMasterApplication" isn't clear, then there should be a description here.
 */

namespace NanoMsg_MasterApp {
namespace NanoMsgServer {

DEFINE_LOGGER_AND_LEVEL (_logger, "/NanoMsg_MasterApp/NanoMsgServer/NanoMsgMasterApplication", Info);

/* static */ const char* NanoMsgMasterApplication::nanocore = "nanocore";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool NanoMsgMasterApplication_enabledASFSignalHandler = false;

void importNanoMsgMasterApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach NanoMsgMasterApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'NanoMsgMasterthread'

    ::asf::core::ComponentContainerSharedPtr NanoMsgMasterthread(new ::asf::core::ComponentContainer("NanoMsgMasterthread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (NanoMsgMasterthread);

        // Component 'NanoMsgMasterAppService nanocore'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::NanoMsg_MasterApp::NanoMsgServer::NanoMsgMasterAppService > > nanocoreFactory(new ::asf::core::ComponentFactory< ::NanoMsg_MasterApp::NanoMsgServer::NanoMsgMasterAppService >);
        ::asf::core::ComponentDescriptionSharedPtr nanocoreDescription(new ::asf::core::ComponentDescription(1, "nanocore", /* immediate = */ true, /* threadBridge = */ false, nanocoreFactory));
        NanoMsgMasterthread->addComponentDescription(nanocoreDescription);

            // Port 'NanoMsgLCMPort'

            ::asf::core::ProvidedPort& nanocore_NanoMsgLCMPort = nanocoreDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.di.NanoMsgLCMInterface", "NanoMsgLCMPort", false, false));
            (void)nanocore_NanoMsgLCMPort; // prevent unused variable warning

            // Port 'NanoMsgIntercomPort'

            ::asf::core::ProvidedPort& nanocore_NanoMsgIntercomPort = nanocoreDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.di.NanoMsgIntercomInterface", "NanoMsgIntercomPort", false, false));
            (void)nanocore_NanoMsgIntercomPort; // prevent unused variable warning

            // Port 'NanoMsgGenericPort'

            ::asf::core::ProvidedPort& nanocore_NanoMsgGenericPort = nanocoreDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.di.NanoMsgGenericInterface", "NanoMsgGenericPort", false, false));
            (void)nanocore_NanoMsgGenericPort; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (nanocore_NanoMsgLCMPort, ::std::string("/bosch/cm/di/NanoMsgLCMInterface"));

    // Expression

    dbusSessionConnector_->exportByName (nanocore_NanoMsgIntercomPort, ::std::string("/bosch/cm/di/NanoMsgIntercomInterface"));

    // Expression

    dbusSessionConnector_->exportByName (nanocore_NanoMsgGenericPort, ::std::string("/bosch/cm/di/NanoMsgGenericInterface"));


    LOG_INFO_STATIC("Starting application 'NanoMsgMasterApplication' version 1.0.0");

    app->start();
}

int executeNanoMsgMasterApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("NanoMsg_MasterApp.NanoMsgServer", "NanoMsgMasterApplication");
    } else {
        ::asf::core::Logger::setupLogging ("NanoMsg_MasterApp.NanoMsgServer", "NanoMsgMasterApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", NanoMsgMasterApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("NanoMsg_MasterApp.NanoMsgServer", "NanoMsgMasterApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create NanoMsgMasterApplication");

    app->enableExceptionHandler(true);

    importNanoMsgMasterApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace NanoMsgServer
} // namespace NanoMsg_MasterApp

int main(int argc, char* argv[]) {
    ::NanoMsg_MasterApp::NanoMsgServer::NanoMsgMasterApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::NanoMsg_MasterApp::NanoMsgServer::executeNanoMsgMasterApplication(argc, argv);
}

