/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGLCMINTERFACESTUB_H
#define BOSCH_CM_DI_NANOMSGLCMINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgLCMInterface.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgLCMInterface {

class NanoMsgLCMInterfaceStubDelegate;

class NanoMsgLCMInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NanoMsgLCMInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NanoMsgLCMInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the NanoMsgLCMInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NanoMsgLCMInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NanoMsgLCMInterfaceStub();

    // signal 'sig_RspSetPowerMode'

    /**
     * Raise the signal 'sig_RspSetPowerMode' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspSetPowerMode'</b>:
     *
     * RspSetPowerMode = response to  ReqSetPowerMode
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspSetPowerModeSignal(uint16 status, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_RspGetPowerMode'

    /**
     * Raise the signal 'sig_RspGetPowerMode' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspGetPowerMode'</b>:
     *
     * RspGetPowerMode = response to  ReqGetPowerMode
     *
     * @param PowerMode If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetPowerModeSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_EventPowerModeChange'

    /**
     * Raise the signal 'sig_EventPowerModeChange' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_EventPowerModeChange'</b>:
     *
     * EventPowerModeChange = response to  EventPowerModeChange
     *
     * @param PowerMode If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventPowerModeChangeSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_RspGetWakeupReason'

    /**
     * Raise the signal 'sig_RspGetWakeupReason' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspGetWakeupReason'</b>:
     *
     * RspGetWakeupReason = response to WakeupReason
     *
     * @param WakeupReason If the meaning of "WakeupReason" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetWakeupReasonSignal(entWakeupReason wakeupReason, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_RspShutdown'

    /**
     * Raise the signal 'sig_RspShutdown' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspShutdown'</b>:
     *
     * RspShutdown = response to Shutdown
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspShutdownSignal(uint16 status, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_RspSetChainMode'

    /**
     * Raise the signal 'sig_RspSetChainMode' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspSetChainMode'</b>:
     *
     * If the meaning of "sig_RspSetChainMode" isn't clear, then there should be a description here.
     *
     * @param tRet If the meaning of "tRet" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspSetChainModeSignal(eniRet tRet, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_RspHealthCare'

    /**
     * Raise the signal 'sig_RspHealthCare' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspHealthCare'</b>:
     *
     * RspHealthCare = 0x0031 response to Request HealthCare
     *
     * @param PowerMode If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspHealthCareSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // signal 'sig_EventDtcOccurance'

    /**
     * Raise the signal 'sig_EventDtcOccurance' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_EventDtcOccurance'</b>:
     *
     * EventDtcOccurance = 0x0032 Any component sends an event EventDtcOccurance if a DTC status has changed, occurred or vanished
     *
     * @param DtcTable If the meaning of "DtcTable" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventDtcOccuranceSignal(const ::std::vector< uint8 >& dtcTable, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP);

    // method 'ReqSetPowerMode'

    /**
     * The method onReqSetPowerMode() is called by ASF when a client invokes
     * the method 'ReqSetPowerMode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqSetPowerMode() or sendReqSetPowerModeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReqSetPowerMode'</b>:
     *
     * ReqSetPowerMode = Method to request for setting Power Mode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetPowerModeRequest (const ::boost::shared_ptr< ReqSetPowerModeRequest >& request) = 0;

    /**
     * The method sendReqSetPowerModeResponse() sends a response of a previous
     * method invocation of 'ReqSetPowerMode' back to the client.
     *
     * <b>Documentation of 'ReqSetPowerMode'</b>:
     *
     * ReqSetPowerMode = Method to request for setting Power Mode
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetPowerMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqSetPowerModeResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetPowerModeError() sends an error response of a
     * previous method invocation of 'ReqSetPowerMode' back to the client.
     *
     * <b>Documentation of 'ReqSetPowerMode'</b>:
     *
     * ReqSetPowerMode = Method to request for setting Power Mode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqSetPowerMode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqSetPowerModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetPowerMode'

    /**
     * The method onReqGetPowerMode() is called by ASF when a client invokes
     * the method 'ReqGetPowerMode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqGetPowerMode() or sendReqGetPowerModeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetPowerMode'</b>:
     *
     * ReqGetPowerMode = Method to request for getting Power Mode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetPowerModeRequest (const ::boost::shared_ptr< ReqGetPowerModeRequest >& request) = 0;

    /**
     * The method sendReqGetPowerModeResponse() sends a response of a previous
     * method invocation of 'ReqGetPowerMode' back to the client.
     *
     * <b>Documentation of 'ReqGetPowerMode'</b>:
     *
     * ReqGetPowerMode = Method to request for getting Power Mode
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetPowerMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqGetPowerModeResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetPowerModeError() sends an error response of a
     * previous method invocation of 'ReqGetPowerMode' back to the client.
     *
     * <b>Documentation of 'ReqGetPowerMode'</b>:
     *
     * ReqGetPowerMode = Method to request for getting Power Mode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetPowerMode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetPowerModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetWakeupReason'

    /**
     * The method onReqGetWakeupReason() is called by ASF when a client
     * invokes the method 'ReqGetWakeupReason'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqGetWakeupReason() or sendReqGetWakeupReasonError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetWakeupReason'</b>:
     *
     * ReqGetWakeupReason = Method to request for getting WakeupReason
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetWakeupReasonRequest (const ::boost::shared_ptr< ReqGetWakeupReasonRequest >& request) = 0;

    /**
     * The method sendReqGetWakeupReasonResponse() sends a response of a
     * previous method invocation of 'ReqGetWakeupReason' back to the client.
     *
     * <b>Documentation of 'ReqGetWakeupReason'</b>:
     *
     * ReqGetWakeupReason = Method to request for getting WakeupReason
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetWakeupReason(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetWakeupReasonResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetWakeupReasonError() sends an error response of a
     * previous method invocation of 'ReqGetWakeupReason' back to the client.
     *
     * <b>Documentation of 'ReqGetWakeupReason'</b>:
     *
     * ReqGetWakeupReason = Method to request for getting WakeupReason
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetWakeupReason().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetWakeupReasonError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqShutdown'

    /**
     * The method onReqShutdown() is called by ASF when a client invokes the
     * method 'ReqShutdown'. A subclass has to implement this method and send
     * back a response to the client either with the sendReqShutdown() or
     * sendReqShutdownError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqShutdown'</b>:
     *
     * ReqShutdown = Method to request for Shutdown
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqShutdownRequest (const ::boost::shared_ptr< ReqShutdownRequest >& request) = 0;

    /**
     * The method sendReqShutdownResponse() sends a response of a previous
     * method invocation of 'ReqShutdown' back to the client.
     *
     * <b>Documentation of 'ReqShutdown'</b>:
     *
     * ReqShutdown = Method to request for Shutdown
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqShutdown(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqShutdownResponse (bool response, act_t act = 0);

    /**
     * The method sendReqShutdownError() sends an error response of a previous
     * method invocation of 'ReqShutdown' back to the client.
     *
     * <b>Documentation of 'ReqShutdown'</b>:
     *
     * ReqShutdown = Method to request for Shutdown
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqShutdown(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReqShutdownError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqSetChainMode'

    /**
     * The method onReqSetChainMode() is called by ASF when a client invokes
     * the method 'ReqSetChainMode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqSetChainMode() or sendReqSetChainModeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReqSetChainMode'</b>:
     *
     * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetChainModeRequest (const ::boost::shared_ptr< ReqSetChainModeRequest >& request) = 0;

    /**
     * The method sendReqSetChainModeResponse() sends a response of a previous
     * method invocation of 'ReqSetChainMode' back to the client.
     *
     * <b>Documentation of 'ReqSetChainMode'</b>:
     *
     * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetChainMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqSetChainModeResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetChainModeError() sends an error response of a
     * previous method invocation of 'ReqSetChainMode' back to the client.
     *
     * <b>Documentation of 'ReqSetChainMode'</b>:
     *
     * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqSetChainMode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqSetChainModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqHealthCare'

    /**
     * The method onReqHealthCare() is called by ASF when a client invokes the
     * method 'ReqHealthCare'. A subclass has to implement this method and
     * send back a response to the client either with the sendReqHealthCare()
     * or sendReqHealthCareError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ReqHealthCare'</b>:
     *
     * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqHealthCareRequest (const ::boost::shared_ptr< ReqHealthCareRequest >& request) = 0;

    /**
     * The method sendReqHealthCareResponse() sends a response of a previous
     * method invocation of 'ReqHealthCare' back to the client.
     *
     * <b>Documentation of 'ReqHealthCare'</b>:
     *
     * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqHealthCare(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqHealthCareResponse (bool response, act_t act = 0);

    /**
     * The method sendReqHealthCareError() sends an error response of a
     * previous method invocation of 'ReqHealthCare' back to the client.
     *
     * <b>Documentation of 'ReqHealthCare'</b>:
     *
     * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqHealthCare(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqHealthCareError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class NanoMsgLCMInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NanoMsgLCMInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGLCMINTERFACESTUB_H
