/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/di/NanoMsgLCMInterface.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of ReqSetPowerModeRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqSetPowerModeRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode  o0 = in.getPowerMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o0));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o1 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o1));
    uint8 o2 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o2));
    uint16 o3 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o3));
    const char* o4 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqSetPowerModeRequest& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode PowerModeValue = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
        dbus_message_iter_get_basic(in, &PowerModeValue);
        out.setPowerMode(PowerModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o5 = 0;
            dbus_message_iter_get_basic(in, &o5);
            DestIPTmpValue.assign (o5);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqSetPowerModeResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqSetPowerModeResponse& in, DBusMessageIter* out) {
    dbus_bool_t o6 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o6));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqSetPowerModeResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o7;
            dbus_message_iter_get_basic(in, &o7);
            responseTmpValue = o7 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqGetPowerModeRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqGetPowerModeRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o8 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o8));
    uint8 o9 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o9));
    uint16 o10 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o10));
    const char* o11 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqGetPowerModeRequest& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            DestIPTmpValue.assign (o12);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqGetPowerModeResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqGetPowerModeResponse& in, DBusMessageIter* out) {
    dbus_bool_t o13 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o13));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqGetPowerModeResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o14;
            dbus_message_iter_get_basic(in, &o14);
            responseTmpValue = o14 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqGetWakeupReasonRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqGetWakeupReasonRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o15 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o15));
    uint8 o16 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o16));
    uint16 o17 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o17));
    const char* o18 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o18));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqGetWakeupReasonRequest& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o19 = 0;
            dbus_message_iter_get_basic(in, &o19);
            DestIPTmpValue.assign (o19);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqGetWakeupReasonResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqGetWakeupReasonResponse& in, DBusMessageIter* out) {
    dbus_bool_t o20 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqGetWakeupReasonResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o21;
            dbus_message_iter_get_basic(in, &o21);
            responseTmpValue = o21 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqShutdownRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqShutdownRequest& in, DBusMessageIter* out) {
    uint16 o22 = in.getTimeout();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o22));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o23 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o23));
    uint8 o24 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o24));
    uint16 o25 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o25));
    const char* o26 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o26));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqShutdownRequest& out) {
    {
        uint16 timeoutValue;
        uint16 &timeoutTmpValue = timeoutValue;
        dbus_message_iter_get_basic(in, &timeoutTmpValue);
        out.setTimeout(timeoutValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o27 = 0;
            dbus_message_iter_get_basic(in, &o27);
            DestIPTmpValue.assign (o27);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqShutdownResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqShutdownResponse& in, DBusMessageIter* out) {
    dbus_bool_t o28 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o28));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqShutdownResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o29;
            dbus_message_iter_get_basic(in, &o29);
            responseTmpValue = o29 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqSetChainModeRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqSetChainModeRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode  o30 = in.getPowerMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o30));
    uint16 o31 = in.getTChain();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o31));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o32 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o32));
    uint8 o33 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o33));
    uint16 o34 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o34));
    const char* o35 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o35));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqSetChainModeRequest& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode PowerModeValue = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
        dbus_message_iter_get_basic(in, &PowerModeValue);
        out.setPowerMode(PowerModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 tChainValue;
        uint16 &tChainTmpValue = tChainValue;
        dbus_message_iter_get_basic(in, &tChainTmpValue);
        out.setTChain(tChainValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o36 = 0;
            dbus_message_iter_get_basic(in, &o36);
            DestIPTmpValue.assign (o36);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqSetChainModeResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqSetChainModeResponse& in, DBusMessageIter* out) {
    dbus_bool_t o37 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o37));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqSetChainModeResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o38;
            dbus_message_iter_get_basic(in, &o38);
            responseTmpValue = o38 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqHealthCareRequest

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqHealthCareRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o39 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o39));
    uint8 o40 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o40));
    uint16 o41 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o41));
    const char* o42 = in.getDestIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o42));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqHealthCareRequest& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string DestIPValue;
        ::std::string &DestIPTmpValue = DestIPValue;
        {
            char* o43 = 0;
            dbus_message_iter_get_basic(in, &o43);
            DestIPTmpValue.assign (o43);
        }
        out.setDestIP(DestIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqHealthCareResponse

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::ReqHealthCareResponse& in, DBusMessageIter* out) {
    dbus_bool_t o44 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o44));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::ReqHealthCareResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o45;
            dbus_message_iter_get_basic(in, &o45);
            responseTmpValue = o45 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspSetPowerModeSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspSetPowerModeSignal& in, DBusMessageIter* out) {
    uint16 o46 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o46));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o47 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o47));
    uint8 o48 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o48));
    uint16 o49 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o49));
    const char* o50 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o50));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspSetPowerModeSignal& out) {
    {
        uint16 statusValue;
        uint16 &statusTmpValue = statusValue;
        dbus_message_iter_get_basic(in, &statusTmpValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o51 = 0;
            dbus_message_iter_get_basic(in, &o51);
            RecevedIPTmpValue.assign (o51);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspGetPowerModeSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspGetPowerModeSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode  o52 = in.getPowerMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o52));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o53 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o53));
    uint8 o54 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o54));
    uint16 o55 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o55));
    const char* o56 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o56));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspGetPowerModeSignal& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode PowerModeValue = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
        dbus_message_iter_get_basic(in, &PowerModeValue);
        out.setPowerMode(PowerModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o57 = 0;
            dbus_message_iter_get_basic(in, &o57);
            RecevedIPTmpValue.assign (o57);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_EventPowerModeChangeSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_EventPowerModeChangeSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode  o58 = in.getPowerMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o58));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o59 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o59));
    uint8 o60 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o60));
    uint16 o61 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o61));
    const char* o62 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o62));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_EventPowerModeChangeSignal& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode PowerModeValue = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
        dbus_message_iter_get_basic(in, &PowerModeValue);
        out.setPowerMode(PowerModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o63 = 0;
            dbus_message_iter_get_basic(in, &o63);
            RecevedIPTmpValue.assign (o63);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspGetWakeupReasonSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspGetWakeupReasonSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason  o64 = in.getWakeupReason();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o64));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o65 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o65));
    uint8 o66 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o66));
    uint16 o67 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o67));
    const char* o68 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o68));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspGetWakeupReasonSignal& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason WakeupReasonValue = ::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason__entWakeupReason_No_reason;
        dbus_message_iter_get_basic(in, &WakeupReasonValue);
        out.setWakeupReason(WakeupReasonValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o69 = 0;
            dbus_message_iter_get_basic(in, &o69);
            RecevedIPTmpValue.assign (o69);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspShutdownSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspShutdownSignal& in, DBusMessageIter* out) {
    uint16 o70 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o70));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o71 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o71));
    uint8 o72 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o72));
    uint16 o73 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o73));
    const char* o74 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o74));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspShutdownSignal& out) {
    {
        uint16 statusValue;
        uint16 &statusTmpValue = statusValue;
        dbus_message_iter_get_basic(in, &statusTmpValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o75 = 0;
            dbus_message_iter_get_basic(in, &o75);
            RecevedIPTmpValue.assign (o75);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspSetChainModeSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspSetChainModeSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::eniRet  o76 = in.getTRet();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o76));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o77 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o77));
    uint8 o78 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o78));
    uint16 o79 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o79));
    const char* o80 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspSetChainModeSignal& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::eniRet tRetValue = ::bosch::cm::di::NanoMsgLCMInterface::eniRet__eniRet_Ok;
        dbus_message_iter_get_basic(in, &tRetValue);
        out.setTRet(tRetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o81 = 0;
            dbus_message_iter_get_basic(in, &o81);
            RecevedIPTmpValue.assign (o81);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_RspHealthCareSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspHealthCareSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode  o82 = in.getPowerMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o82));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o83 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o83));
    uint8 o84 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o84));
    uint16 o85 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o85));
    const char* o86 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_RspHealthCareSignal& out) {
    {
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode PowerModeValue = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
        dbus_message_iter_get_basic(in, &PowerModeValue);
        out.setPowerMode(PowerModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o87 = 0;
            dbus_message_iter_get_basic(in, &o87);
            RecevedIPTmpValue.assign (o87);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_EventDtcOccuranceSignal

void serializeDBus (const ::bosch::cm::di::NanoMsgLCMInterface::Sig_EventDtcOccuranceSignal& in, DBusMessageIter* out) {
    DBusMessageIter o88ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o88ArrayIter));
    const ::std::vector< uint8 >* o89 = &in.getDtcTable();
    ::std::vector< uint8 >::const_iterator o90 = o89->end();
    for (::std::vector< uint8 >::const_iterator o91 = o89->begin(); o91 != o90; ++o91) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88ArrayIter, DBUS_TYPE_BYTE, &(*o91)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o88ArrayIter));
    const ::bosch::cm::di::NanoMsgLCMInterface::enDevID  o92 = in.getDev_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o92));
    uint8 o93 = in.getDev_Nr();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o93));
    uint16 o94 = in.getMsg_ID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o94));
    const char* o95 = in.getRecevedIP().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::NanoMsgLCMInterface::Sig_EventDtcOccuranceSignal& out) {
    {
        ::std::vector< uint8 > DtcTableValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o96ArrayIter;
            dbus_message_iter_recurse (in, &o96ArrayIter);

            if(dbus_message_iter_get_arg_type(&o96ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o97;
                    dbus_message_iter_get_basic(&o96ArrayIter, &o97);
                    DtcTableValue.push_back(o97);
                } while (dbus_message_iter_next(&o96ArrayIter));
            }
        }
        out.setDtcTable(DtcTableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_IDValue = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
        dbus_message_iter_get_basic(in, &Dev_IDValue);
        out.setDev_ID(Dev_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 Dev_NrValue;
        uint8 &Dev_NrTmpValue = Dev_NrValue;
        dbus_message_iter_get_basic(in, &Dev_NrTmpValue);
        out.setDev_Nr(Dev_NrValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 Msg_IDValue;
        uint16 &Msg_IDTmpValue = Msg_IDValue;
        dbus_message_iter_get_basic(in, &Msg_IDTmpValue);
        out.setMsg_ID(Msg_IDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string RecevedIPValue;
        ::std::string &RecevedIPTmpValue = RecevedIPValue;
        {
            char* o98 = 0;
            dbus_message_iter_get_basic(in, &o98);
            RecevedIPTmpValue.assign (o98);
        }
        out.setRecevedIP(RecevedIPValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

