/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGINTERCOMINTERFACESTUB_H
#define BOSCH_CM_DI_NANOMSGINTERCOMINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgIntercomInterface.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceConst.h"
#include <string>

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgIntercomInterface {

class NanoMsgIntercomInterfaceStubDelegate;

class NanoMsgIntercomInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NanoMsgIntercomInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NanoMsgIntercomInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the NanoMsgIntercomInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NanoMsgIntercomInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NanoMsgIntercomInterfaceStub();

    // signal 'sig_RspPhoneStatus'

    /**
     * Raise the signal 'sig_RspPhoneStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspPhoneStatus'</b>:
     *
     * xxxx   CMA -- CMC
     *
     * @param phonestatus1 If the meaning of "phonestatus1" isn't clear, then there should be a description here.
     *
     * @param phonestatus2 If the meaning of "phonestatus2" isn't clear, then there should be a description here.
     *
     * @param phonestatus3 If the meaning of "phonestatus3" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspPhoneStatusSignal(uint8 phonestatus1, uint8 phonestatus2, uint8 phonestatus3, const ::std::string& recevedIP);

    // signal 'sig_EventPhoneStatusChanged'

    /**
     * Raise the signal 'sig_EventPhoneStatusChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_EventPhoneStatusChanged'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param phoneNumber If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phonestatus If the meaning of "phonestatus" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventPhoneStatusChangedSignal(eTPhoneNumber phoneNumber, uint8 phonestatus, const ::std::string& recevedIP);

    // signal 'sig_EventIntercomCall'

    /**
     * Raise the signal 'sig_EventIntercomCall' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_EventIntercomCall'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param phoneNumber If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventIntercomCallSignal(eTPhoneNumber phoneNumber, const ::std::string& recevedIP);

    // signal 'sig_EventCancelIntercomCall'

    /**
     * Raise the signal 'sig_EventCancelIntercomCall' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_EventCancelIntercomCall'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventCancelIntercomCallSignal(bool response, const ::std::string& recevedIP);

    // signal 'sig_EventAcceptIntercomCall'

    /**
     * Raise the signal 'sig_EventAcceptIntercomCall' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_EventAcceptIntercomCall'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param phoneNumber If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventAcceptIntercomCallSignal(eTPhoneNumber phoneNumber, const ::std::string& recevedIP);

    // signal 'sig_RspGetVolume'

    /**
     * Raise the signal 'sig_RspGetVolume' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspGetVolume'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param Volumevalue If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetVolumeSignal(uint8 volumevalue, const ::std::string& recevedIP);

    // signal 'sig_EventSetVolume'

    /**
     * Raise the signal 'sig_EventSetVolume' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_EventSetVolume'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param Volumevalue If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventSetVolumeSignal(uint8 volumevalue, const ::std::string& recevedIP);

    // signal 'sig_RspGetVersion'

    /**
     * Raise the signal 'sig_RspGetVersion' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspGetVersion'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param Swversion If the meaning of "Swversion" isn't clear, then there should be a description here.
     *
     * @param Hwversion If the meaning of "Hwversion" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetVersionSignal(uint32 swversion, uint32 hwversion, const ::std::string& recevedIP);

    // signal 'sig_RspGetIntercomAvailable'

    /**
     * Raise the signal 'sig_RspGetIntercomAvailable' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_RspGetIntercomAvailable'</b>:
     *
     * xxxx   CMA -- CMC
     *
     * @param Availability If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetIntercomAvailableSignal(eTIntercomAvailable availability, const ::std::string& recevedIP);

    // signal 'sig_EventIntercomAvailable'

    /**
     * Raise the signal 'sig_EventIntercomAvailable' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_EventIntercomAvailable'</b>:
     *
     * xxxx  CMA -- CMC
     *
     * @param Availability If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventIntercomAvailableSignal(eTIntercomAvailable availability, const ::std::string& recevedIP);

    // method 'EventHUCall'

    /**
     * The method onEventHUCall() is called by ASF when a client invokes the
     * method 'EventHUCall'. A subclass has to implement this method and send
     * back a response to the client either with the sendEventHUCall() or
     * sendEventHUCallError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'EventHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEventHUCallRequest (const ::boost::shared_ptr< EventHUCallRequest >& request) = 0;

    /**
     * The method sendEventHUCallResponse() sends a response of a previous
     * method invocation of 'EventHUCall' back to the client.
     *
     * <b>Documentation of 'EventHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEventHUCall(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEventHUCallResponse (bool response, act_t act = 0);

    /**
     * The method sendEventHUCallError() sends an error response of a previous
     * method invocation of 'EventHUCall' back to the client.
     *
     * <b>Documentation of 'EventHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEventHUCall(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEventHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EventAcceptHUCall'

    /**
     * The method onEventAcceptHUCall() is called by ASF when a client invokes
     * the method 'EventAcceptHUCall'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEventAcceptHUCall() or sendEventAcceptHUCallError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'EventAcceptHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEventAcceptHUCallRequest (const ::boost::shared_ptr< EventAcceptHUCallRequest >& request) = 0;

    /**
     * The method sendEventAcceptHUCallResponse() sends a response of a
     * previous method invocation of 'EventAcceptHUCall' back to the client.
     *
     * <b>Documentation of 'EventAcceptHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEventAcceptHUCall(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEventAcceptHUCallResponse (bool response, act_t act = 0);

    /**
     * The method sendEventAcceptHUCallError() sends an error response of a
     * previous method invocation of 'EventAcceptHUCall' back to the client.
     *
     * <b>Documentation of 'EventAcceptHUCall'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEventAcceptHUCall().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEventAcceptHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EventCancelHUCall'

    /**
     * The method onEventCancelHUCall() is called by ASF when a client invokes
     * the method 'EventCancelHUCall'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEventCancelHUCall() or sendEventCancelHUCallError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'EventCancelHUCall'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEventCancelHUCallRequest (const ::boost::shared_ptr< EventCancelHUCallRequest >& request) = 0;

    /**
     * The method sendEventCancelHUCallResponse() sends a response of a
     * previous method invocation of 'EventCancelHUCall' back to the client.
     *
     * <b>Documentation of 'EventCancelHUCall'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEventCancelHUCall(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEventCancelHUCallResponse (bool response, act_t act = 0);

    /**
     * The method sendEventCancelHUCallError() sends an error response of a
     * previous method invocation of 'EventCancelHUCall' back to the client.
     *
     * <b>Documentation of 'EventCancelHUCall'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEventCancelHUCall().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEventCancelHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqPhoneStatus'

    /**
     * The method onReqPhoneStatus() is called by ASF when a client invokes
     * the method 'ReqPhoneStatus'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqPhoneStatus() or sendReqPhoneStatusError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ReqPhoneStatus'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqPhoneStatusRequest (const ::boost::shared_ptr< ReqPhoneStatusRequest >& request) = 0;

    /**
     * The method sendReqPhoneStatusResponse() sends a response of a previous
     * method invocation of 'ReqPhoneStatus' back to the client.
     *
     * <b>Documentation of 'ReqPhoneStatus'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqPhoneStatus(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqPhoneStatusResponse (bool response, act_t act = 0);

    /**
     * The method sendReqPhoneStatusError() sends an error response of a
     * previous method invocation of 'ReqPhoneStatus' back to the client.
     *
     * <b>Documentation of 'ReqPhoneStatus'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqPhoneStatus(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqPhoneStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqSetVolumeUp'

    /**
     * The method onReqSetVolumeUp() is called by ASF when a client invokes
     * the method 'ReqSetVolumeUp'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqSetVolumeUp() or sendReqSetVolumeUpError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ReqSetVolumeUp'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetVolumeUpRequest (const ::boost::shared_ptr< ReqSetVolumeUpRequest >& request) = 0;

    /**
     * The method sendReqSetVolumeUpResponse() sends a response of a previous
     * method invocation of 'ReqSetVolumeUp' back to the client.
     *
     * <b>Documentation of 'ReqSetVolumeUp'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetVolumeUp(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqSetVolumeUpResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetVolumeUpError() sends an error response of a
     * previous method invocation of 'ReqSetVolumeUp' back to the client.
     *
     * <b>Documentation of 'ReqSetVolumeUp'</b>:
     *
     * xxxx CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqSetVolumeUp(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqSetVolumeUpError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqSetVolumeDown'

    /**
     * The method onReqSetVolumeDown() is called by ASF when a client invokes
     * the method 'ReqSetVolumeDown'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReqSetVolumeDown() or sendReqSetVolumeDownError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReqSetVolumeDown'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetVolumeDownRequest (const ::boost::shared_ptr< ReqSetVolumeDownRequest >& request) = 0;

    /**
     * The method sendReqSetVolumeDownResponse() sends a response of a
     * previous method invocation of 'ReqSetVolumeDown' back to the client.
     *
     * <b>Documentation of 'ReqSetVolumeDown'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetVolumeDown(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqSetVolumeDownResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetVolumeDownError() sends an error response of a
     * previous method invocation of 'ReqSetVolumeDown' back to the client.
     *
     * <b>Documentation of 'ReqSetVolumeDown'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqSetVolumeDown(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqSetVolumeDownError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetVolume'

    /**
     * The method onReqGetVolume() is called by ASF when a client invokes the
     * method 'ReqGetVolume'. A subclass has to implement this method and send
     * back a response to the client either with the sendReqGetVolume() or
     * sendReqGetVolumeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetVolumeRequest (const ::boost::shared_ptr< ReqGetVolumeRequest >& request) = 0;

    /**
     * The method sendReqGetVolumeResponse() sends a response of a previous
     * method invocation of 'ReqGetVolume' back to the client.
     *
     * <b>Documentation of 'ReqGetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetVolume(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqGetVolumeResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetVolumeError() sends an error response of a
     * previous method invocation of 'ReqGetVolume' back to the client.
     *
     * <b>Documentation of 'ReqGetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetVolume(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReqGetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqSetVolume'

    /**
     * The method onReqSetVolume() is called by ASF when a client invokes the
     * method 'ReqSetVolume'. A subclass has to implement this method and send
     * back a response to the client either with the sendReqSetVolume() or
     * sendReqSetVolumeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqSetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetVolumeRequest (const ::boost::shared_ptr< ReqSetVolumeRequest >& request) = 0;

    /**
     * The method sendReqSetVolumeResponse() sends a response of a previous
     * method invocation of 'ReqSetVolume' back to the client.
     *
     * <b>Documentation of 'ReqSetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetVolume(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqSetVolumeResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetVolumeError() sends an error response of a
     * previous method invocation of 'ReqSetVolume' back to the client.
     *
     * <b>Documentation of 'ReqSetVolume'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqSetVolume(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReqSetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetVersion'

    /**
     * The method onReqGetVersion() is called by ASF when a client invokes the
     * method 'ReqGetVersion'. A subclass has to implement this method and
     * send back a response to the client either with the sendReqGetVersion()
     * or sendReqGetVersionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ReqGetVersion'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetVersionRequest (const ::boost::shared_ptr< ReqGetVersionRequest >& request) = 0;

    /**
     * The method sendReqGetVersionResponse() sends a response of a previous
     * method invocation of 'ReqGetVersion' back to the client.
     *
     * <b>Documentation of 'ReqGetVersion'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetVersion(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqGetVersionResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetVersionError() sends an error response of a
     * previous method invocation of 'ReqGetVersion' back to the client.
     *
     * <b>Documentation of 'ReqGetVersion'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetVersion(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetVersionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetIntercomAvailable'

    /**
     * The method onReqGetIntercomAvailable() is called by ASF when a client
     * invokes the method 'ReqGetIntercomAvailable'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendReqGetIntercomAvailable() or
     * sendReqGetIntercomAvailableError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ReqGetIntercomAvailable'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetIntercomAvailableRequest (const ::boost::shared_ptr< ReqGetIntercomAvailableRequest >& request) = 0;

    /**
     * The method sendReqGetIntercomAvailableResponse() sends a response of a
     * previous method invocation of 'ReqGetIntercomAvailable' back to the
     * client.
     *
     * <b>Documentation of 'ReqGetIntercomAvailable'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetIntercomAvailable(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetIntercomAvailableResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetIntercomAvailableError() sends an error response
     * of a previous method invocation of 'ReqGetIntercomAvailable' back to
     * the client.
     *
     * <b>Documentation of 'ReqGetIntercomAvailable'</b>:
     *
     * xxxx  CMC -- CMA
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqGetIntercomAvailable(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetIntercomAvailableError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class NanoMsgIntercomInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NanoMsgIntercomInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGINTERCOMINTERFACESTUB_H
