/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgIntercomInterface.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceConst.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceJson.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgIntercomInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgIntercomInterface", NanoMsgIntercomInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "EventHUCall", 0 },
    { 12, "ReqGetVolume", 6 },
    { 12, "ReqSetVolume", 7 },
    { 13, "ReqGetVersion", 8 },
    { 14, "ReqPhoneStatus", 3 },
    { 14, "ReqSetVolumeUp", 4 },
    { 16, "ReqSetVolumeDown", 5 },
    { 17, "EventAcceptHUCall", 1 },
    { 17, "EventCancelHUCall", 2 },
    { 23, "ReqGetIntercomAvailable", 9 },
};


class NanoMsgIntercomInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NanoMsgIntercomInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NanoMsgIntercomInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NanoMsgIntercomInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.di.NanoMsgIntercomInterface"),
          _logger(logger) {}

    virtual ~NanoMsgIntercomInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NanoMsgIntercomInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 10, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'EventHUCall'

            LOG_DEBUG_STUB("process method '%s'", "EventHUCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventHUCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EventHUCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EventHUCallRequest > payload = ::boost::static_pointer_cast<EventHUCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onEventHUCallRequest(payload);
            return;
        }
        case 1: {

            // method 'EventAcceptHUCall'

            LOG_DEBUG_STUB("process method '%s'", "EventAcceptHUCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventAcceptHUCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EventAcceptHUCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EventAcceptHUCallRequest > payload = ::boost::static_pointer_cast<EventAcceptHUCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onEventAcceptHUCallRequest(payload);
            return;
        }
        case 2: {

            // method 'EventCancelHUCall'

            LOG_DEBUG_STUB("process method '%s'", "EventCancelHUCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventCancelHUCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EventCancelHUCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EventCancelHUCallRequest > payload = ::boost::static_pointer_cast<EventCancelHUCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onEventCancelHUCallRequest(payload);
            return;
        }
        case 3: {

            // method 'ReqPhoneStatus'

            LOG_DEBUG_STUB("process method '%s'", "ReqPhoneStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqPhoneStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqPhoneStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqPhoneStatusRequest > payload = ::boost::static_pointer_cast<ReqPhoneStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqPhoneStatusRequest(payload);
            return;
        }
        case 4: {

            // method 'ReqSetVolumeUp'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetVolumeUp");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeUpRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetVolumeUp", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetVolumeUpRequest > payload = ::boost::static_pointer_cast<ReqSetVolumeUpRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqSetVolumeUpRequest(payload);
            return;
        }
        case 5: {

            // method 'ReqSetVolumeDown'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetVolumeDown");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeDownRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetVolumeDown", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetVolumeDownRequest > payload = ::boost::static_pointer_cast<ReqSetVolumeDownRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqSetVolumeDownRequest(payload);
            return;
        }
        case 6: {

            // method 'ReqGetVolume'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetVolume");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVolumeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetVolume", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetVolumeRequest > payload = ::boost::static_pointer_cast<ReqGetVolumeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqGetVolumeRequest(payload);
            return;
        }
        case 7: {

            // method 'ReqSetVolume'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetVolume");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetVolume", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetVolumeRequest > payload = ::boost::static_pointer_cast<ReqSetVolumeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqSetVolumeRequest(payload);
            return;
        }
        case 8: {

            // method 'ReqGetVersion'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetVersion");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVersionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetVersion", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetVersionRequest > payload = ::boost::static_pointer_cast<ReqGetVersionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqGetVersionRequest(payload);
            return;
        }
        case 9: {

            // method 'ReqGetIntercomAvailable'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetIntercomAvailable");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetIntercomAvailableRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetIntercomAvailable", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetIntercomAvailableRequest > payload = ::boost::static_pointer_cast<ReqGetIntercomAvailableRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgIntercomInterfaceStub*>(getStub())->onReqGetIntercomAvailableRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NanoMsgIntercomInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.di.NanoMsgIntercomInterface\">\n"
            "    <method name=\"EventHUCall\">\n"
            "      <doc>\n"
            "        <line>EventHUCall = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"phoneNumber\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneNumber (of type eTPhoneNumber) = Description missing</line>\n"
            "          <line>enum[eTPhoneNumber_RestRoom (0x01), eTPhoneNumber_Kitchen (0x02), eTPhoneNumber_UpperDeck (0x03), eTPhoneNumber_Undefined (0xFF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EventAcceptHUCall\">\n"
            "      <doc>\n"
            "        <line>EventAcceptHUCall = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EventCancelHUCall\">\n"
            "      <doc>\n"
            "        <line>EventCancelHUCall = xxxx CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqPhoneStatus\">\n"
            "      <doc>\n"
            "        <line>ReqPhoneStatus = xxxx CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqSetVolumeUp\">\n"
            "      <doc>\n"
            "        <line>ReqSetVolumeUp = xxxx CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqSetVolumeDown\">\n"
            "      <doc>\n"
            "        <line>ReqSetVolumeDown = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetVolume\">\n"
            "      <doc>\n"
            "        <line>ReqGetVolume = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqSetVolume\">\n"
            "      <doc>\n"
            "        <line>ReqSetVolume = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Volumevalue\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Volumevalue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetVersion\">\n"
            "      <doc>\n"
            "        <line>ReqGetVersion = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetIntercomAvailable\">\n"
            "      <doc>\n"
            "        <line>ReqGetIntercomAvailable = xxxx  CMC -- CMA</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sig_RspPhoneStatus\">\n"
            "      <doc>\n"
            "        <line>sig_RspPhoneStatus = xxxx   CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"phonestatus1\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>phonestatus1 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"phonestatus2\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>phonestatus2 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"phonestatus3\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>phonestatus3 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventPhoneStatusChanged\">\n"
            "      <doc>\n"
            "        <line>sig_EventPhoneStatusChanged = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"phoneNumber\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneNumber (of type eTPhoneNumber) = Description missing</line>\n"
            "          <line>enum[eTPhoneNumber_RestRoom (0x01), eTPhoneNumber_Kitchen (0x02), eTPhoneNumber_UpperDeck (0x03), eTPhoneNumber_Undefined (0xFF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"phonestatus\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>phonestatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventIntercomCall\">\n"
            "      <doc>\n"
            "        <line>sig_EventIntercomCall = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"phoneNumber\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneNumber (of type eTPhoneNumber) = Description missing</line>\n"
            "          <line>enum[eTPhoneNumber_RestRoom (0x01), eTPhoneNumber_Kitchen (0x02), eTPhoneNumber_UpperDeck (0x03), eTPhoneNumber_Undefined (0xFF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventCancelIntercomCall\">\n"
            "      <doc>\n"
            "        <line>sig_EventCancelIntercomCall = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventAcceptIntercomCall\">\n"
            "      <doc>\n"
            "        <line>sig_EventAcceptIntercomCall = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"phoneNumber\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneNumber (of type eTPhoneNumber) = Description missing</line>\n"
            "          <line>enum[eTPhoneNumber_RestRoom (0x01), eTPhoneNumber_Kitchen (0x02), eTPhoneNumber_UpperDeck (0x03), eTPhoneNumber_Undefined (0xFF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetVolume\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetVolume = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Volumevalue\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Volumevalue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventSetVolume\">\n"
            "      <doc>\n"
            "        <line>sig_EventSetVolume = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Volumevalue\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Volumevalue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetVersion\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetVersion = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Swversion\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Swversion = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Hwversion\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Hwversion = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetIntercomAvailable\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetIntercomAvailable = xxxx   CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Availability\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Availability = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventIntercomAvailable\">\n"
            "      <doc>\n"
            "        <line>sig_EventIntercomAvailable = xxxx  CMA -- CMC</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Availability\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Availability = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void NanoMsgIntercomInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NanoMsgIntercomInterfaceStub*>(getStub()))->onGetAll (properties);
}

void NanoMsgIntercomInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NanoMsgIntercomInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NanoMsgIntercomInterfaceStub::NanoMsgIntercomInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgIntercomInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgIntercomInterfaceStub::NanoMsgIntercomInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgIntercomInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgIntercomInterfaceStub::~NanoMsgIntercomInterfaceStub() {
    delete _stubDelegate;
}

void NanoMsgIntercomInterfaceStub::sendSig_RspPhoneStatusSignal(uint8 phonestatus1, uint8 phonestatus2, uint8 phonestatus3, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspPhoneStatusSignal* payload = new Sig_RspPhoneStatusSignal(phonestatus1, phonestatus2, phonestatus3, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspPhoneStatus", Sig_RspPhoneStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspPhoneStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspPhoneStatus");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventPhoneStatusChangedSignal(eTPhoneNumber phoneNumber, uint8 phonestatus, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventPhoneStatusChangedSignal* payload = new Sig_EventPhoneStatusChangedSignal(phoneNumber, phonestatus, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventPhoneStatusChanged", Sig_EventPhoneStatusChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventPhoneStatusChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventPhoneStatusChanged");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventIntercomCallSignal(eTPhoneNumber phoneNumber, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventIntercomCallSignal* payload = new Sig_EventIntercomCallSignal(phoneNumber, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventIntercomCall", Sig_EventIntercomCallSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventIntercomCall");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventIntercomCall");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventCancelIntercomCallSignal(bool response, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventCancelIntercomCallSignal* payload = new Sig_EventCancelIntercomCallSignal(response, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventCancelIntercomCall", Sig_EventCancelIntercomCallSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventCancelIntercomCall");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventCancelIntercomCall");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventAcceptIntercomCallSignal(eTPhoneNumber phoneNumber, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventAcceptIntercomCallSignal* payload = new Sig_EventAcceptIntercomCallSignal(phoneNumber, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventAcceptIntercomCall", Sig_EventAcceptIntercomCallSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventAcceptIntercomCall");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventAcceptIntercomCall");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_RspGetVolumeSignal(uint8 volumevalue, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetVolumeSignal* payload = new Sig_RspGetVolumeSignal(volumevalue, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetVolume", Sig_RspGetVolumeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetVolume");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetVolume");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventSetVolumeSignal(uint8 volumevalue, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventSetVolumeSignal* payload = new Sig_EventSetVolumeSignal(volumevalue, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventSetVolume", Sig_EventSetVolumeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventSetVolume");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventSetVolume");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_RspGetVersionSignal(uint32 swversion, uint32 hwversion, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetVersionSignal* payload = new Sig_RspGetVersionSignal(swversion, hwversion, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetVersion", Sig_RspGetVersionSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetVersion");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetVersion");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_RspGetIntercomAvailableSignal(eTIntercomAvailable availability, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetIntercomAvailableSignal* payload = new Sig_RspGetIntercomAvailableSignal(availability, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetIntercomAvailable", Sig_RspGetIntercomAvailableSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetIntercomAvailable");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetIntercomAvailable");
    }
}

void NanoMsgIntercomInterfaceStub::sendSig_EventIntercomAvailableSignal(eTIntercomAvailable availability, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventIntercomAvailableSignal* payload = new Sig_EventIntercomAvailableSignal(availability, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventIntercomAvailable", Sig_EventIntercomAvailableSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventIntercomAvailable");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventIntercomAvailable");
    }
}

void  NanoMsgIntercomInterfaceStub::sendEventHUCallResponse (bool response, act_t act) {
    EventHUCallResponse* payload = new EventHUCallResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "EventHUCall", EventHUCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EventHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendEventHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EventHUCallError* payload = new EventHUCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EventHUCall", EventHUCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EventHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendEventAcceptHUCallResponse (bool response, act_t act) {
    EventAcceptHUCallResponse* payload = new EventAcceptHUCallResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "EventAcceptHUCall", EventAcceptHUCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EventAcceptHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendEventAcceptHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EventAcceptHUCallError* payload = new EventAcceptHUCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EventAcceptHUCall", EventAcceptHUCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EventAcceptHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendEventCancelHUCallResponse (bool response, act_t act) {
    EventCancelHUCallResponse* payload = new EventCancelHUCallResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "EventCancelHUCall", EventCancelHUCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EventCancelHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendEventCancelHUCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EventCancelHUCallError* payload = new EventCancelHUCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EventCancelHUCall", EventCancelHUCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EventCancelHUCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqPhoneStatusResponse (bool response, act_t act) {
    ReqPhoneStatusResponse* payload = new ReqPhoneStatusResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqPhoneStatus", ReqPhoneStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqPhoneStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqPhoneStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqPhoneStatusError* payload = new ReqPhoneStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqPhoneStatus", ReqPhoneStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqPhoneStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeUpResponse (bool response, act_t act) {
    ReqSetVolumeUpResponse* payload = new ReqSetVolumeUpResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetVolumeUp", ReqSetVolumeUpResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetVolumeUp", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeUpError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetVolumeUpError* payload = new ReqSetVolumeUpError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetVolumeUp", ReqSetVolumeUpError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetVolumeUp", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeDownResponse (bool response, act_t act) {
    ReqSetVolumeDownResponse* payload = new ReqSetVolumeDownResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetVolumeDown", ReqSetVolumeDownResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetVolumeDown", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeDownError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetVolumeDownError* payload = new ReqSetVolumeDownError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetVolumeDown", ReqSetVolumeDownError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetVolumeDown", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetVolumeResponse (bool response, act_t act) {
    ReqGetVolumeResponse* payload = new ReqGetVolumeResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetVolume", ReqGetVolumeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetVolumeError* payload = new ReqGetVolumeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetVolume", ReqGetVolumeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeResponse (bool response, act_t act) {
    ReqSetVolumeResponse* payload = new ReqSetVolumeResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetVolume", ReqSetVolumeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqSetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetVolumeError* payload = new ReqSetVolumeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetVolume", ReqSetVolumeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetVersionResponse (bool response, act_t act) {
    ReqGetVersionResponse* payload = new ReqGetVersionResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetVersion", ReqGetVersionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetVersionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetVersionError* payload = new ReqGetVersionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetVersion", ReqGetVersionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetIntercomAvailableResponse (bool response, act_t act) {
    ReqGetIntercomAvailableResponse* payload = new ReqGetIntercomAvailableResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetIntercomAvailable", ReqGetIntercomAvailableResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetIntercomAvailable", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgIntercomInterfaceStub::sendReqGetIntercomAvailableError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetIntercomAvailableError* payload = new ReqGetIntercomAvailableError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetIntercomAvailable", ReqGetIntercomAvailableError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetIntercomAvailable", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NanoMsgIntercomInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace NanoMsgIntercomInterface
} // namespace di
} // namespace cm
} // namespace bosch
