/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGGENERICINTERFACESTUB_H
#define BOSCH_CM_DI_NANOMSGGENERICINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgGenericInterface.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include <string>

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgGenericInterface {

class NanoMsgGenericInterfaceStubDelegate;

class NanoMsgGenericInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NanoMsgGenericInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NanoMsgGenericInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the NanoMsgGenericInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NanoMsgGenericInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NanoMsgGenericInterfaceStub();

    // signal 'sig_RspCMGSvivelPosition'

    /**
     * Raise the signal 'sig_RspCMGSvivelPosition' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_RspCMGSvivelPosition'</b>:
     *
     * RspCMGSvivelPosition =0x0065, Response to ReqCMGSvivelPosition
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param RecevedIP If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspCMGSvivelPositionSignal(uint16 status, const ::std::string& recevedIP);

    // signal 'sig_RspGetDigitalInput'

    /**
     * Raise the signal 'sig_RspGetDigitalInput' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_RspGetDigitalInput'</b>:
     *
     * RspGetDigitalInput = 0x0017 response to  Request Digital IO's
     *
     * @param DigitalInput If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetDigitalInputSignal(uint32 digitalInput, const ::std::string& receivedIP);

    // signal 'sig_EventDigitalInput'

    /**
     * Raise the signal 'sig_EventDigitalInput' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_EventDigitalInput'</b>:
     *
     * EventDigitalInput = 0x0015 Event to  Request Digital IO's
     *
     * @param DigitalInput If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventDigitalInputSignal(uint32 digitalInput, entBool response, const ::std::string& receivedIP);

    // signal 'sig_RspGetDigitalInputCMP'

    /**
     * Raise the signal 'sig_RspGetDigitalInputCMP' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMP'</b>:
     *
     * RspGetDigitalInputCMP = 0x0020 response to  Request Digital IO's
     *
     * @param DigitalInputCMP If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetDigitalInputCMPSignal(uint32 digitalInputCMP, const ::std::string& receivedIP);

    // signal 'sig_EventDigitalInputCMP'

    /**
     * Raise the signal 'sig_EventDigitalInputCMP' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMP'</b>:
     *
     * EventDigitalInputCMP = 0x0018 Event to  Request Digital IO's
     *
     * @param DigitalInputCMP If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventDigitalInputCMPSignal(uint32 digitalInputCMP, const ::std::string& receivedIP);

    // signal 'sig_RspGetDigitalInputCMG'

    /**
     * Raise the signal 'sig_RspGetDigitalInputCMG' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMG'</b>:
     *
     * RspGetDigitalInputCMG = 0x0023 response to  Request Digital IO's
     *
     * @param DigitalInputCMG If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_RspGetDigitalInputCMGSignal(uint32 digitalInputCMG, const ::std::string& receivedIP);

    // signal 'sig_EventDigitalInputCMG'

    /**
     * Raise the signal 'sig_EventDigitalInputCMG' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMG'</b>:
     *
     * EventDigitalInputCMG = 0x0021 Event to  Request Digital IO's
     *
     * @param DigitalInputCMG If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventDigitalInputCMGSignal(uint32 digitalInputCMG, const ::std::string& receivedIP);

    // signal 'RspGetVoltage'

    /**
     * Raise the signal 'RspGetVoltage' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RspGetVoltage'</b>:
     *
     * RspGetVoltage = 0x0014
     *
     * @param VoltageLevel If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param VoltageValue If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendRspGetVoltageSignal(entVoltageLevel voltageLevel, entVoltageSensor voltageSensor, uint16 voltageValue, const ::std::string& receivedIP);

    // signal 'EventVoltage'

    /**
     * Raise the signal 'EventVoltage' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EventVoltage'</b>:
     *
     * EventVoltage = 0x0012
     *
     * @param VoltageLevel If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param VoltageValue If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendEventVoltageSignal(entVoltageLevel voltageLevel, entVoltageSensor voltageSensor, uint16 voltageValue, const ::std::string& receivedIP);

    // signal 'RspGetThermalState'

    /**
     * Raise the signal 'RspGetThermalState' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RspGetThermalState'</b>:
     *
     * RspGetThermalState = 0x0045
     *
     * @param ThermalState If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @param ThermalSensorID If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @param Temperature If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendRspGetThermalStateSignal(entThermalState thermalState, entThermalSensorID thermalSensorID, int16 temperature, const ::std::string& receivedIP);

    // signal 'EventThermalState'

    /**
     * Raise the signal 'EventThermalState' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EventThermalState'</b>:
     *
     * EventThermalState = 0x0043
     *
     * @param ThermalState If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @param ThermalSensorID If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @param Temperature If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendEventThermalStateSignal(entThermalState thermalState, entThermalSensorID thermalSensorID, int16 temperature, const ::std::string& receivedIP);

    // signal 'RspSetAnnouncementOut'

    /**
     * Raise the signal 'RspSetAnnouncementOut' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RspSetAnnouncementOut'</b>:
     *
     * RspSetAnnouncementOut = 0x0021
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendRspSetAnnouncementOutSignal(uint16 status, const ::std::string& receivedIP);

    // signal 'sig_EventCMGSwivelPosition'

    /**
     * Raise the signal 'sig_EventCMGSwivelPosition' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_EventCMGSwivelPosition'</b>:
     *
     * EventCMGSwivelPosition = 0x0063 Any component sends an event EventCMGSwivelPosition if a swivel position has changed
     *
     * @param SwivelPosition If the meaning of "SwivelPosition" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     */
    void sendSig_EventCMGSwivelPositionSignal(entSwivelPosition swivelPosition, const ::std::string& receivedIP);

    // method 'ReqGetDigitalInput'

    /**
     * The method onReqGetDigitalInput() is called by ASF when a client
     * invokes the method 'ReqGetDigitalInput'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqGetDigitalInput() or sendReqGetDigitalInputError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetDigitalInput'</b>:
     *
     * ReqGetDigitalInput = Method to Request Digital IO's
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetDigitalInputRequest (const ::boost::shared_ptr< ReqGetDigitalInputRequest >& request) = 0;

    /**
     * The method sendReqGetDigitalInputResponse() sends a response of a
     * previous method invocation of 'ReqGetDigitalInput' back to the client.
     *
     * <b>Documentation of 'ReqGetDigitalInput'</b>:
     *
     * ReqGetDigitalInput = Method to Request Digital IO's
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetDigitalInput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetDigitalInputResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetDigitalInputError() sends an error response of a
     * previous method invocation of 'ReqGetDigitalInput' back to the client.
     *
     * <b>Documentation of 'ReqGetDigitalInput'</b>:
     *
     * ReqGetDigitalInput = Method to Request Digital IO's
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetDigitalInput().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetDigitalInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetDigitalInputCMP'

    /**
     * The method onReqGetDigitalInputCMP() is called by ASF when a client
     * invokes the method 'ReqGetDigitalInputCMP'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqGetDigitalInputCMP() or sendReqGetDigitalInputCMPError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMP'</b>:
     *
     * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetDigitalInputCMPRequest (const ::boost::shared_ptr< ReqGetDigitalInputCMPRequest >& request) = 0;

    /**
     * The method sendReqGetDigitalInputCMPResponse() sends a response of a
     * previous method invocation of 'ReqGetDigitalInputCMP' back to the
     * client.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMP'</b>:
     *
     * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetDigitalInputCMP(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetDigitalInputCMPResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetDigitalInputCMPError() sends an error response of
     * a previous method invocation of 'ReqGetDigitalInputCMP' back to the
     * client.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMP'</b>:
     *
     * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqGetDigitalInputCMP(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetDigitalInputCMPError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetDigitalInputCMG'

    /**
     * The method onReqGetDigitalInputCMG() is called by ASF when a client
     * invokes the method 'ReqGetDigitalInputCMG'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqGetDigitalInputCMG() or sendReqGetDigitalInputCMGError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMG'</b>:
     *
     * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetDigitalInputCMGRequest (const ::boost::shared_ptr< ReqGetDigitalInputCMGRequest >& request) = 0;

    /**
     * The method sendReqGetDigitalInputCMGResponse() sends a response of a
     * previous method invocation of 'ReqGetDigitalInputCMG' back to the
     * client.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMG'</b>:
     *
     * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetDigitalInputCMG(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetDigitalInputCMGResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetDigitalInputCMGError() sends an error response of
     * a previous method invocation of 'ReqGetDigitalInputCMG' back to the
     * client.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMG'</b>:
     *
     * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqGetDigitalInputCMG(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetDigitalInputCMGError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetVoltage'

    /**
     * The method onReqGetVoltage() is called by ASF when a client invokes the
     * method 'ReqGetVoltage'. A subclass has to implement this method and
     * send back a response to the client either with the sendReqGetVoltage()
     * or sendReqGetVoltageError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ReqGetVoltage'</b>:
     *
     * ReqGetVoltage = 0x0013
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetVoltageRequest (const ::boost::shared_ptr< ReqGetVoltageRequest >& request) = 0;

    /**
     * The method sendReqGetVoltageResponse() sends a response of a previous
     * method invocation of 'ReqGetVoltage' back to the client.
     *
     * <b>Documentation of 'ReqGetVoltage'</b>:
     *
     * ReqGetVoltage = 0x0013
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetVoltage(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqGetVoltageResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetVoltageError() sends an error response of a
     * previous method invocation of 'ReqGetVoltage' back to the client.
     *
     * <b>Documentation of 'ReqGetVoltage'</b>:
     *
     * ReqGetVoltage = 0x0013
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetVoltage(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetVoltageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqSetAnnouncementOut'

    /**
     * The method onReqSetAnnouncementOut() is called by ASF when a client
     * invokes the method 'ReqSetAnnouncementOut'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqSetAnnouncementOut() or sendReqSetAnnouncementOutError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqSetAnnouncementOut'</b>:
     *
     * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqSetAnnouncementOutRequest (const ::boost::shared_ptr< ReqSetAnnouncementOutRequest >& request) = 0;

    /**
     * The method sendReqSetAnnouncementOutResponse() sends a response of a
     * previous method invocation of 'ReqSetAnnouncementOut' back to the
     * client.
     *
     * <b>Documentation of 'ReqSetAnnouncementOut'</b>:
     *
     * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqSetAnnouncementOut(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqSetAnnouncementOutResponse (bool response, act_t act = 0);

    /**
     * The method sendReqSetAnnouncementOutError() sends an error response of
     * a previous method invocation of 'ReqSetAnnouncementOut' back to the
     * client.
     *
     * <b>Documentation of 'ReqSetAnnouncementOut'</b>:
     *
     * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqSetAnnouncementOut(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqSetAnnouncementOutError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqGetThermalState'

    /**
     * The method onReqGetThermalState() is called by ASF when a client
     * invokes the method 'ReqGetThermalState'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqGetThermalState() or sendReqGetThermalStateError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ReqGetThermalState'</b>:
     *
     * ReqGetThermalState = 0x0044
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqGetThermalStateRequest (const ::boost::shared_ptr< ReqGetThermalStateRequest >& request) = 0;

    /**
     * The method sendReqGetThermalStateResponse() sends a response of a
     * previous method invocation of 'ReqGetThermalState' back to the client.
     *
     * <b>Documentation of 'ReqGetThermalState'</b>:
     *
     * ReqGetThermalState = 0x0044
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqGetThermalState(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqGetThermalStateResponse (bool response, act_t act = 0);

    /**
     * The method sendReqGetThermalStateError() sends an error response of a
     * previous method invocation of 'ReqGetThermalState' back to the client.
     *
     * <b>Documentation of 'ReqGetThermalState'</b>:
     *
     * ReqGetThermalState = 0x0044
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqGetThermalState().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqGetThermalStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqCMGSvivelPosition'

    /**
     * The method onReqCMGSvivelPosition() is called by ASF when a client
     * invokes the method 'ReqCMGSvivelPosition'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReqCMGSvivelPosition() or sendReqCMGSvivelPositionError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReqCMGSvivelPosition'</b>:
     *
     * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqCMGSvivelPositionRequest (const ::boost::shared_ptr< ReqCMGSvivelPositionRequest >& request) = 0;

    /**
     * The method sendReqCMGSvivelPositionResponse() sends a response of a
     * previous method invocation of 'ReqCMGSvivelPosition' back to the
     * client.
     *
     * <b>Documentation of 'ReqCMGSvivelPosition'</b>:
     *
     * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqCMGSvivelPosition(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqCMGSvivelPositionResponse (bool response, act_t act = 0);

    /**
     * The method sendReqCMGSvivelPositionError() sends an error response of a
     * previous method invocation of 'ReqCMGSvivelPosition' back to the
     * client.
     *
     * <b>Documentation of 'ReqCMGSvivelPosition'</b>:
     *
     * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqCMGSvivelPosition(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqCMGSvivelPositionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class NanoMsgGenericInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NanoMsgGenericInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGGENERICINTERFACESTUB_H
