/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgGenericInterface.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceJson.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgGenericInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgGenericInterface", NanoMsgGenericInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "ReqGetVoltage", 3 },
    { 18, "ReqGetDigitalInput", 0 },
    { 18, "ReqGetThermalState", 5 },
    { 20, "ReqCMGSvivelPosition", 6 },
    { 21, "ReqGetDigitalInputCMG", 2 },
    { 21, "ReqGetDigitalInputCMP", 1 },
    { 21, "ReqSetAnnouncementOut", 4 },
};


class NanoMsgGenericInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NanoMsgGenericInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NanoMsgGenericInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NanoMsgGenericInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.di.NanoMsgGenericInterface"),
          _logger(logger) {}

    virtual ~NanoMsgGenericInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NanoMsgGenericInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 7, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ReqGetDigitalInput'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetDigitalInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetDigitalInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetDigitalInputRequest > payload = ::boost::static_pointer_cast<ReqGetDigitalInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqGetDigitalInputRequest(payload);
            return;
        }
        case 1: {

            // method 'ReqGetDigitalInputCMP'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetDigitalInputCMP");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMPRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetDigitalInputCMP", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetDigitalInputCMPRequest > payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMPRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqGetDigitalInputCMPRequest(payload);
            return;
        }
        case 2: {

            // method 'ReqGetDigitalInputCMG'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetDigitalInputCMG");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMGRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetDigitalInputCMG", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetDigitalInputCMGRequest > payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMGRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqGetDigitalInputCMGRequest(payload);
            return;
        }
        case 3: {

            // method 'ReqGetVoltage'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetVoltage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVoltageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetVoltage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetVoltageRequest > payload = ::boost::static_pointer_cast<ReqGetVoltageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqGetVoltageRequest(payload);
            return;
        }
        case 4: {

            // method 'ReqSetAnnouncementOut'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetAnnouncementOut");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetAnnouncementOutRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetAnnouncementOut", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetAnnouncementOutRequest > payload = ::boost::static_pointer_cast<ReqSetAnnouncementOutRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqSetAnnouncementOutRequest(payload);
            return;
        }
        case 5: {

            // method 'ReqGetThermalState'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetThermalState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetThermalStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetThermalState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetThermalStateRequest > payload = ::boost::static_pointer_cast<ReqGetThermalStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqGetThermalStateRequest(payload);
            return;
        }
        case 6: {

            // method 'ReqCMGSvivelPosition'

            LOG_DEBUG_STUB("process method '%s'", "ReqCMGSvivelPosition");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCMGSvivelPositionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqCMGSvivelPosition", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqCMGSvivelPositionRequest > payload = ::boost::static_pointer_cast<ReqCMGSvivelPositionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgGenericInterfaceStub*>(getStub())->onReqCMGSvivelPositionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NanoMsgGenericInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.di.NanoMsgGenericInterface\">\n"
            "    <method name=\"ReqGetDigitalInput\">\n"
            "      <doc>\n"
            "        <line>ReqGetDigitalInput = ReqGetDigitalInput = Method to Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetDigitalInputCMP\">\n"
            "      <doc>\n"
            "        <line>ReqGetDigitalInputCMP = ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetDigitalInputCMG\">\n"
            "      <doc>\n"
            "        <line>ReqGetDigitalInputCMG = ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetVoltage\">\n"
            "      <doc>\n"
            "        <line>ReqGetVoltage = ReqGetVoltage = 0x0013</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"VoltageSensor\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>VoltageSensor (of type entVoltageSensor) = Description missing</line>\n"
            "          <line>enum[entVoltageSensor_Undefined (0x0000), entVoltageSensor_BatterySensor (0x0001), entVoltageSensor_12VSupplyVoltage (0x0002)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqSetAnnouncementOut\">\n"
            "      <doc>\n"
            "        <line>ReqSetAnnouncementOut = ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"AnnouncementState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>AnnouncementState (of type entAnnouncementState) = Description missing</line>\n"
            "          <line>enum[entAnnouncementState_On_High (0x00), entAnnouncementState_Off_Low (0x01)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetThermalState\">\n"
            "      <doc>\n"
            "        <line>ReqGetThermalState = ReqGetThermalState = 0x0044</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqCMGSvivelPosition\">\n"
            "      <doc>\n"
            "        <line>ReqCMGSvivelPosition = ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SvivelRequest\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SvivelRequest = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sig_RspCMGSvivelPosition\">\n"
            "      <doc>\n"
            "        <line>sig_RspCMGSvivelPosition = RspCMGSvivelPosition =0x0065, Response to ReqCMGSvivelPosition</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetDigitalInput\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetDigitalInput = RspGetDigitalInput = 0x0017 response to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInput\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInput = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventDigitalInput\">\n"
            "      <doc>\n"
            "        <line>sig_EventDigitalInput = EventDigitalInput = 0x0015 Event to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInput\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInput = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetDigitalInputCMP\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetDigitalInputCMP = RspGetDigitalInputCMP = 0x0020 response to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInputCMP\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInputCMP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventDigitalInputCMP\">\n"
            "      <doc>\n"
            "        <line>sig_EventDigitalInputCMP = EventDigitalInputCMP = 0x0018 Event to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInputCMP\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInputCMP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetDigitalInputCMG\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetDigitalInputCMG = RspGetDigitalInputCMG = 0x0023 response to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInputCMG\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInputCMG = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventDigitalInputCMG\">\n"
            "      <doc>\n"
            "        <line>sig_EventDigitalInputCMG = EventDigitalInputCMG = 0x0021 Event to  Request Digital IO's</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DigitalInputCMG\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DigitalInputCMG = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"RspGetVoltage\">\n"
            "      <doc>\n"
            "        <line>RspGetVoltage = RspGetVoltage = 0x0014</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoltageLevel\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>VoltageLevel = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"VoltageSensor\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>VoltageSensor (of type entVoltageSensor) = Description missing</line>\n"
            "          <line>enum[entVoltageSensor_Undefined (0x0000), entVoltageSensor_BatterySensor (0x0001), entVoltageSensor_12VSupplyVoltage (0x0002)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"VoltageValue\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>VoltageValue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EventVoltage\">\n"
            "      <doc>\n"
            "        <line>EventVoltage = EventVoltage = 0x0012</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoltageLevel\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>VoltageLevel = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"VoltageSensor\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>VoltageSensor (of type entVoltageSensor) = Description missing</line>\n"
            "          <line>enum[entVoltageSensor_Undefined (0x0000), entVoltageSensor_BatterySensor (0x0001), entVoltageSensor_12VSupplyVoltage (0x0002)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"VoltageValue\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>VoltageValue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"RspGetThermalState\">\n"
            "      <doc>\n"
            "        <line>RspGetThermalState = RspGetThermalState = 0x0045</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ThermalState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ThermalState (of type entThermalState) = Description missing</line>\n"
            "          <line>enum[entUndefined (0x0000), entOver (0x0001), entCritical_High (0x0002), entHigh (0x0003), entNormal (0x0004), entLow (0x0005), entCritical_low (0x0006), entUnder (0x0007)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ThermalSensorID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ThermalSensorID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Temperature\" type=\"n\">\n"
            "        <doc>\n"
            "          <line>Temperature = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EventThermalState\">\n"
            "      <doc>\n"
            "        <line>EventThermalState = EventThermalState = 0x0043</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ThermalState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ThermalState (of type entThermalState) = Description missing</line>\n"
            "          <line>enum[entUndefined (0x0000), entOver (0x0001), entCritical_High (0x0002), entHigh (0x0003), entNormal (0x0004), entLow (0x0005), entCritical_low (0x0006), entUnder (0x0007)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ThermalSensorID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ThermalSensorID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Temperature\" type=\"n\">\n"
            "        <doc>\n"
            "          <line>Temperature = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"RspSetAnnouncementOut\">\n"
            "      <doc>\n"
            "        <line>RspSetAnnouncementOut = RspSetAnnouncementOut = 0x0021</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventCMGSwivelPosition\">\n"
            "      <doc>\n"
            "        <line>sig_EventCMGSwivelPosition = EventCMGSwivelPosition = 0x0063 Any component sends an event EventCMGSwivelPosition if a swivel position has changed</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"SwivelPosition\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SwivelPosition = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ReceivedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ReceivedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void NanoMsgGenericInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NanoMsgGenericInterfaceStub*>(getStub()))->onGetAll (properties);
}

void NanoMsgGenericInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NanoMsgGenericInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NanoMsgGenericInterfaceStub::NanoMsgGenericInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgGenericInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgGenericInterfaceStub::NanoMsgGenericInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgGenericInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgGenericInterfaceStub::~NanoMsgGenericInterfaceStub() {
    delete _stubDelegate;
}

void NanoMsgGenericInterfaceStub::sendSig_RspCMGSvivelPositionSignal(uint16 status, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspCMGSvivelPositionSignal* payload = new Sig_RspCMGSvivelPositionSignal(status, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspCMGSvivelPosition", Sig_RspCMGSvivelPositionSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspCMGSvivelPosition");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspCMGSvivelPosition");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_RspGetDigitalInputSignal(uint32 digitalInput, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetDigitalInputSignal* payload = new Sig_RspGetDigitalInputSignal(digitalInput, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetDigitalInput", Sig_RspGetDigitalInputSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetDigitalInput");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetDigitalInput");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_EventDigitalInputSignal(uint32 digitalInput, entBool response, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventDigitalInputSignal* payload = new Sig_EventDigitalInputSignal(digitalInput, response, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventDigitalInput", Sig_EventDigitalInputSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventDigitalInput");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventDigitalInput");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_RspGetDigitalInputCMPSignal(uint32 digitalInputCMP, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetDigitalInputCMPSignal* payload = new Sig_RspGetDigitalInputCMPSignal(digitalInputCMP, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetDigitalInputCMP", Sig_RspGetDigitalInputCMPSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetDigitalInputCMP");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetDigitalInputCMP");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_EventDigitalInputCMPSignal(uint32 digitalInputCMP, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventDigitalInputCMPSignal* payload = new Sig_EventDigitalInputCMPSignal(digitalInputCMP, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventDigitalInputCMP", Sig_EventDigitalInputCMPSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventDigitalInputCMP");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventDigitalInputCMP");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_RspGetDigitalInputCMGSignal(uint32 digitalInputCMG, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetDigitalInputCMGSignal* payload = new Sig_RspGetDigitalInputCMGSignal(digitalInputCMG, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetDigitalInputCMG", Sig_RspGetDigitalInputCMGSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetDigitalInputCMG");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetDigitalInputCMG");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_EventDigitalInputCMGSignal(uint32 digitalInputCMG, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventDigitalInputCMGSignal* payload = new Sig_EventDigitalInputCMGSignal(digitalInputCMG, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventDigitalInputCMG", Sig_EventDigitalInputCMGSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventDigitalInputCMG");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventDigitalInputCMG");
    }
}

void NanoMsgGenericInterfaceStub::sendRspGetVoltageSignal(entVoltageLevel voltageLevel, entVoltageSensor voltageSensor, uint16 voltageValue, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        RspGetVoltageSignal* payload = new RspGetVoltageSignal(voltageLevel, voltageSensor, voltageValue, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RspGetVoltage", RspGetVoltageSignal, payload)
        LOG_INFO ("-> send%sSignal", "RspGetVoltage");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RspGetVoltage");
    }
}

void NanoMsgGenericInterfaceStub::sendEventVoltageSignal(entVoltageLevel voltageLevel, entVoltageSensor voltageSensor, uint16 voltageValue, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        EventVoltageSignal* payload = new EventVoltageSignal(voltageLevel, voltageSensor, voltageValue, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventVoltage", EventVoltageSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventVoltage");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventVoltage");
    }
}

void NanoMsgGenericInterfaceStub::sendRspGetThermalStateSignal(entThermalState thermalState, entThermalSensorID thermalSensorID, int16 temperature, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        RspGetThermalStateSignal* payload = new RspGetThermalStateSignal(thermalState, thermalSensorID, temperature, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RspGetThermalState", RspGetThermalStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "RspGetThermalState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RspGetThermalState");
    }
}

void NanoMsgGenericInterfaceStub::sendEventThermalStateSignal(entThermalState thermalState, entThermalSensorID thermalSensorID, int16 temperature, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        EventThermalStateSignal* payload = new EventThermalStateSignal(thermalState, thermalSensorID, temperature, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventThermalState", EventThermalStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventThermalState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventThermalState");
    }
}

void NanoMsgGenericInterfaceStub::sendRspSetAnnouncementOutSignal(uint16 status, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        RspSetAnnouncementOutSignal* payload = new RspSetAnnouncementOutSignal(status, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RspSetAnnouncementOut", RspSetAnnouncementOutSignal, payload)
        LOG_INFO ("-> send%sSignal", "RspSetAnnouncementOut");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RspSetAnnouncementOut");
    }
}

void NanoMsgGenericInterfaceStub::sendSig_EventCMGSwivelPositionSignal(entSwivelPosition swivelPosition, const ::std::string& receivedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventCMGSwivelPositionSignal* payload = new Sig_EventCMGSwivelPositionSignal(swivelPosition, receivedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventCMGSwivelPosition", Sig_EventCMGSwivelPositionSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventCMGSwivelPosition");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventCMGSwivelPosition");
    }
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputResponse (bool response, act_t act) {
    ReqGetDigitalInputResponse* payload = new ReqGetDigitalInputResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetDigitalInput", ReqGetDigitalInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetDigitalInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetDigitalInputError* payload = new ReqGetDigitalInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetDigitalInput", ReqGetDigitalInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetDigitalInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputCMPResponse (bool response, act_t act) {
    ReqGetDigitalInputCMPResponse* payload = new ReqGetDigitalInputCMPResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetDigitalInputCMP", ReqGetDigitalInputCMPResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetDigitalInputCMP", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputCMPError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetDigitalInputCMPError* payload = new ReqGetDigitalInputCMPError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetDigitalInputCMP", ReqGetDigitalInputCMPError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetDigitalInputCMP", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputCMGResponse (bool response, act_t act) {
    ReqGetDigitalInputCMGResponse* payload = new ReqGetDigitalInputCMGResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetDigitalInputCMG", ReqGetDigitalInputCMGResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetDigitalInputCMG", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetDigitalInputCMGError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetDigitalInputCMGError* payload = new ReqGetDigitalInputCMGError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetDigitalInputCMG", ReqGetDigitalInputCMGError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetDigitalInputCMG", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetVoltageResponse (bool response, act_t act) {
    ReqGetVoltageResponse* payload = new ReqGetVoltageResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetVoltage", ReqGetVoltageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetVoltage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetVoltageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetVoltageError* payload = new ReqGetVoltageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetVoltage", ReqGetVoltageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetVoltage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqSetAnnouncementOutResponse (bool response, act_t act) {
    ReqSetAnnouncementOutResponse* payload = new ReqSetAnnouncementOutResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetAnnouncementOut", ReqSetAnnouncementOutResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetAnnouncementOut", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqSetAnnouncementOutError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetAnnouncementOutError* payload = new ReqSetAnnouncementOutError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetAnnouncementOut", ReqSetAnnouncementOutError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetAnnouncementOut", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetThermalStateResponse (bool response, act_t act) {
    ReqGetThermalStateResponse* payload = new ReqGetThermalStateResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetThermalState", ReqGetThermalStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetThermalState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqGetThermalStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetThermalStateError* payload = new ReqGetThermalStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetThermalState", ReqGetThermalStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetThermalState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqCMGSvivelPositionResponse (bool response, act_t act) {
    ReqCMGSvivelPositionResponse* payload = new ReqCMGSvivelPositionResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqCMGSvivelPosition", ReqCMGSvivelPositionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqCMGSvivelPosition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgGenericInterfaceStub::sendReqCMGSvivelPositionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqCMGSvivelPositionError* payload = new ReqCMGSvivelPositionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqCMGSvivelPosition", ReqCMGSvivelPositionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqCMGSvivelPosition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NanoMsgGenericInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace NanoMsgGenericInterface
} // namespace di
} // namespace cm
} // namespace bosch
