#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGGENERICINTERFACE_H
#define BOSCH_CM_DI_NANOMSGGENERICINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "bosch.cm.di.NanoMsgGenericInterface" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgGenericInterface {

// method IDs
static const uint16 ID_ReqGetDigitalInput = 0;
static const uint16 ID_ReqGetDigitalInputCMP = 1;
static const uint16 ID_ReqGetDigitalInputCMG = 2;
static const uint16 ID_ReqGetVoltage = 3;
static const uint16 ID_ReqSetAnnouncementOut = 4;
static const uint16 ID_ReqGetThermalState = 5;
static const uint16 ID_ReqCMGSvivelPosition = 6;

// signal IDs
static const uint16 ID_sig_RspCMGSvivelPosition = 7;
static const uint16 ID_sig_RspGetDigitalInput = 8;
static const uint16 ID_sig_EventDigitalInput = 9;
static const uint16 ID_sig_RspGetDigitalInputCMP = 10;
static const uint16 ID_sig_EventDigitalInputCMP = 11;
static const uint16 ID_sig_RspGetDigitalInputCMG = 12;
static const uint16 ID_sig_EventDigitalInputCMG = 13;
static const uint16 ID_RspGetVoltage = 14;
static const uint16 ID_EventVoltage = 15;
static const uint16 ID_RspGetThermalState = 16;
static const uint16 ID_EventThermalState = 17;
static const uint16 ID_RspSetAnnouncementOut = 18;
static const uint16 ID_sig_EventCMGSwivelPosition = 19;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ReqGetDigitalInputRequest;

class ReqGetDigitalInputResponse;

class ReqGetDigitalInputCMPRequest;

class ReqGetDigitalInputCMPResponse;

class ReqGetDigitalInputCMGRequest;

class ReqGetDigitalInputCMGResponse;

class ReqGetVoltageRequest;

class ReqGetVoltageResponse;

class ReqSetAnnouncementOutRequest;

class ReqSetAnnouncementOutResponse;

class ReqGetThermalStateRequest;

class ReqGetThermalStateResponse;

class ReqCMGSvivelPositionRequest;

class ReqCMGSvivelPositionResponse;

class Sig_RspCMGSvivelPositionSignal;

class Sig_RspGetDigitalInputSignal;

class Sig_EventDigitalInputSignal;

class Sig_RspGetDigitalInputCMPSignal;

class Sig_EventDigitalInputCMPSignal;

class Sig_RspGetDigitalInputCMGSignal;

class Sig_EventDigitalInputCMGSignal;

class RspGetVoltageSignal;

class EventVoltageSignal;

class RspGetThermalStateSignal;

class EventThermalStateSignal;

class RspSetAnnouncementOutSignal;

class Sig_EventCMGSwivelPositionSignal;

// type definitions
/**
 * If the meaning of "ReqGetDigitalInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetDigitalInputError;

/**
 * If the meaning of "ReqGetDigitalInputCMPError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetDigitalInputCMPError;

/**
 * If the meaning of "ReqGetDigitalInputCMGError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetDigitalInputCMGError;

/**
 * If the meaning of "ReqGetVoltageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetVoltageError;

/**
 * If the meaning of "ReqSetAnnouncementOutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetAnnouncementOutError;

/**
 * If the meaning of "ReqGetThermalStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetThermalStateError;

/**
 * If the meaning of "ReqCMGSvivelPositionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqCMGSvivelPositionError;

/**
 * If the meaning of "Sig_RspCMGSvivelPositionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspCMGSvivelPositionError;

/**
 * If the meaning of "Sig_RspGetDigitalInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetDigitalInputError;

/**
 * If the meaning of "Sig_EventDigitalInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventDigitalInputError;

/**
 * If the meaning of "Sig_RspGetDigitalInputCMPError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetDigitalInputCMPError;

/**
 * If the meaning of "Sig_EventDigitalInputCMPError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventDigitalInputCMPError;

/**
 * If the meaning of "Sig_RspGetDigitalInputCMGError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetDigitalInputCMGError;

/**
 * If the meaning of "Sig_EventDigitalInputCMGError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventDigitalInputCMGError;

/**
 * If the meaning of "RspGetVoltageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RspGetVoltageError;

/**
 * If the meaning of "EventVoltageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventVoltageError;

/**
 * If the meaning of "RspGetThermalStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RspGetThermalStateError;

/**
 * If the meaning of "EventThermalStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventThermalStateError;

/**
 * If the meaning of "RspSetAnnouncementOutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RspSetAnnouncementOutError;

/**
 * If the meaning of "Sig_EventCMGSwivelPositionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventCMGSwivelPositionError;


/**
 * ReqGetDigitalInput = Method to Request Digital IO's
 */
class ReqGetDigitalInputRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputRequest (const ReqGetDigitalInputRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputRequest();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputRequest& operator = (const ReqGetDigitalInputRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetDigitalInputRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetDigitalInput = Method to Request Digital IO's
 */
class ReqGetDigitalInputResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputResponse (const ReqGetDigitalInputResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputResponse();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputResponse& operator = (const ReqGetDigitalInputResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetDigitalInputResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
 */
class ReqGetDigitalInputCMPRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputCMPRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputCMPRequest (const ReqGetDigitalInputCMPRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputCMPRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputCMPRequest();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputCMPRequest& operator = (const ReqGetDigitalInputCMPRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputCMPRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputCMPRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputCMPRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputCMPRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetDigitalInputCMPRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
 */
class ReqGetDigitalInputCMPResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputCMPResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputCMPResponse (const ReqGetDigitalInputCMPResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputCMPResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputCMPResponse();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputCMPResponse& operator = (const ReqGetDigitalInputCMPResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputCMPResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputCMPResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputCMPResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputCMPResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetDigitalInputCMPResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
 */
class ReqGetDigitalInputCMGRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputCMGRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputCMGRequest (const ReqGetDigitalInputCMGRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputCMGRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputCMGRequest();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputCMGRequest& operator = (const ReqGetDigitalInputCMGRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputCMGRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputCMGRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputCMGRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputCMGRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetDigitalInputCMGRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
 */
class ReqGetDigitalInputCMGResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetDigitalInputCMGResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetDigitalInputCMGResponse (const ReqGetDigitalInputCMGResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetDigitalInputCMGResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetDigitalInputCMGResponse();

    /**
     * Assignment operator
     */
    inline ReqGetDigitalInputCMGResponse& operator = (const ReqGetDigitalInputCMGResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetDigitalInputCMGResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetDigitalInputCMGResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetDigitalInputCMGResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetDigitalInputCMGResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetDigitalInputCMGResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetVoltage = 0x0013
 */
class ReqGetVoltageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVoltageRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetVoltageRequest (const ReqGetVoltageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVoltageRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, entVoltageSensor VoltageSensor_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVoltageRequest();

    /**
     * Assignment operator
     */
    inline ReqGetVoltageRequest& operator = (const ReqGetVoltageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVoltageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVoltageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVoltageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVoltageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "VoltageSensor"

    static const int kVoltageSensor = 3;

    /**
     * Clears the field "VoltageSensor".
     *
     * The field will be set to its default value. The hasVoltageSensor()
     * method will return false.
     */
    inline void clearVoltageSensor();

    /**
     * Checks whether the field "VoltageSensor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageSensor()). Otherwise it will return false.
     */
    inline bool hasVoltageSensor () const;

    /**
     * Returns the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageSensor"
     */
    inline entVoltageSensor getVoltageSensor () const;

    /**
     * Sets the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor The value which will be set
     */
    inline void setVoltageSensor (entVoltageSensor VoltageSensor_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetVoltageRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_VoltageSensor ();

    inline void clear_has_VoltageSensor ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    entVoltageSensor _VoltageSensor;

    ::std::string _DestIP;

};

/**
 * ReqGetVoltage = 0x0013
 */
class ReqGetVoltageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVoltageResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetVoltageResponse (const ReqGetVoltageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVoltageResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVoltageResponse();

    /**
     * Assignment operator
     */
    inline ReqGetVoltageResponse& operator = (const ReqGetVoltageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVoltageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVoltageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVoltageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVoltageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetVoltageResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
 */
class ReqSetAnnouncementOutRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetAnnouncementOutRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetAnnouncementOutRequest (const ReqSetAnnouncementOutRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetAnnouncementOutRequest (entAnnouncementState AnnouncementState_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetAnnouncementOutRequest();

    /**
     * Assignment operator
     */
    inline ReqSetAnnouncementOutRequest& operator = (const ReqSetAnnouncementOutRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetAnnouncementOutRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetAnnouncementOutRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetAnnouncementOutRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetAnnouncementOutRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnouncementState"

    static const int kAnnouncementState = 0;

    /**
     * Clears the field "AnnouncementState".
     *
     * The field will be set to its default value. The hasAnnouncementState()
     * method will return false.
     */
    inline void clearAnnouncementState();

    /**
     * Checks whether the field "AnnouncementState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnouncementState()). Otherwise it will return false.
     */
    inline bool hasAnnouncementState () const;

    /**
     * Returns the value of the member "AnnouncementState".
     *
     * If the meaning of "AnnouncementState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AnnouncementState"
     */
    inline entAnnouncementState getAnnouncementState () const;

    /**
     * Sets the value of the member "AnnouncementState".
     *
     * If the meaning of "AnnouncementState" isn't clear, then there should be a description here.
     *
     * @param AnnouncementState The value which will be set
     */
    inline void setAnnouncementState (entAnnouncementState AnnouncementState_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetAnnouncementOutRequest &getDefaultInstance();

private:

    inline void set_has_AnnouncementState ();

    inline void clear_has_AnnouncementState ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entAnnouncementState _AnnouncementState;

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
 */
class ReqSetAnnouncementOutResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetAnnouncementOutResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetAnnouncementOutResponse (const ReqSetAnnouncementOutResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetAnnouncementOutResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetAnnouncementOutResponse();

    /**
     * Assignment operator
     */
    inline ReqSetAnnouncementOutResponse& operator = (const ReqSetAnnouncementOutResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetAnnouncementOutResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetAnnouncementOutResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetAnnouncementOutResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetAnnouncementOutResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetAnnouncementOutResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetThermalState = 0x0044
 */
class ReqGetThermalStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetThermalStateRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetThermalStateRequest (const ReqGetThermalStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetThermalStateRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetThermalStateRequest();

    /**
     * Assignment operator
     */
    inline ReqGetThermalStateRequest& operator = (const ReqGetThermalStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetThermalStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetThermalStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetThermalStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetThermalStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetThermalStateRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetThermalState = 0x0044
 */
class ReqGetThermalStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetThermalStateResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetThermalStateResponse (const ReqGetThermalStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetThermalStateResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetThermalStateResponse();

    /**
     * Assignment operator
     */
    inline ReqGetThermalStateResponse& operator = (const ReqGetThermalStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetThermalStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetThermalStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetThermalStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetThermalStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetThermalStateResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
 */
class ReqCMGSvivelPositionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCMGSvivelPositionRequest ();

    /**
     * Copy constructor
     */
    inline  ReqCMGSvivelPositionRequest (const ReqCMGSvivelPositionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCMGSvivelPositionRequest (entSvivelRequest SvivelRequest_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCMGSvivelPositionRequest();

    /**
     * Assignment operator
     */
    inline ReqCMGSvivelPositionRequest& operator = (const ReqCMGSvivelPositionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCMGSvivelPositionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCMGSvivelPositionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCMGSvivelPositionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCMGSvivelPositionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SvivelRequest"

    static const int kSvivelRequest = 0;

    /**
     * Clears the field "SvivelRequest".
     *
     * The field will be set to its default value. The hasSvivelRequest()
     * method will return false.
     */
    inline void clearSvivelRequest();

    /**
     * Checks whether the field "SvivelRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSvivelRequest()). Otherwise it will return false.
     */
    inline bool hasSvivelRequest () const;

    /**
     * Returns the value of the member "SvivelRequest".
     *
     * If the meaning of "SvivelRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SvivelRequest"
     */
    inline entSvivelRequest getSvivelRequest () const;

    /**
     * Sets the value of the member "SvivelRequest".
     *
     * If the meaning of "SvivelRequest" isn't clear, then there should be a description here.
     *
     * @param SvivelRequest The value which will be set
     */
    inline void setSvivelRequest (entSvivelRequest SvivelRequest_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqCMGSvivelPositionRequest &getDefaultInstance();

private:

    inline void set_has_SvivelRequest ();

    inline void clear_has_SvivelRequest ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entSvivelRequest _SvivelRequest;

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
 */
class ReqCMGSvivelPositionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCMGSvivelPositionResponse ();

    /**
     * Copy constructor
     */
    inline  ReqCMGSvivelPositionResponse (const ReqCMGSvivelPositionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCMGSvivelPositionResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCMGSvivelPositionResponse();

    /**
     * Assignment operator
     */
    inline ReqCMGSvivelPositionResponse& operator = (const ReqCMGSvivelPositionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCMGSvivelPositionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCMGSvivelPositionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCMGSvivelPositionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCMGSvivelPositionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqCMGSvivelPositionResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * RspCMGSvivelPosition =0x0065, Response to ReqCMGSvivelPosition
 */
class Sig_RspCMGSvivelPositionSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspCMGSvivelPositionSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspCMGSvivelPositionSignal (const Sig_RspCMGSvivelPositionSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspCMGSvivelPositionSignal (uint16 status_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspCMGSvivelPositionSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspCMGSvivelPositionSignal& operator = (const Sig_RspCMGSvivelPositionSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspCMGSvivelPositionSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspCMGSvivelPositionSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspCMGSvivelPositionSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspCMGSvivelPositionSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspCMGSvivelPositionSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _status;

    ::std::string _RecevedIP;

};

/**
 * RspGetDigitalInput = 0x0017 response to  Request Digital IO's
 */
class Sig_RspGetDigitalInputSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetDigitalInputSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetDigitalInputSignal (const Sig_RspGetDigitalInputSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetDigitalInputSignal (uint32 DigitalInput_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetDigitalInputSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetDigitalInputSignal& operator = (const Sig_RspGetDigitalInputSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetDigitalInputSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetDigitalInputSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetDigitalInputSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetDigitalInputSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInput"

    static const int kDigitalInput = 0;

    /**
     * Clears the field "DigitalInput".
     *
     * The field will be set to its default value. The hasDigitalInput()
     * method will return false.
     */
    inline void clearDigitalInput();

    /**
     * Checks whether the field "DigitalInput" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInput()). Otherwise it will return false.
     */
    inline bool hasDigitalInput () const;

    /**
     * Returns the value of the member "DigitalInput".
     *
     * If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInput"
     */
    inline uint32 getDigitalInput () const;

    /**
     * Sets the value of the member "DigitalInput".
     *
     * If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @param DigitalInput The value which will be set
     */
    inline void setDigitalInput (uint32 DigitalInput_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_RspGetDigitalInputSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInput ();

    inline void clear_has_DigitalInput ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DigitalInput;

    ::std::string _ReceivedIP;

};

/**
 * EventDigitalInput = 0x0015 Event to  Request Digital IO's
 */
class Sig_EventDigitalInputSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventDigitalInputSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventDigitalInputSignal (const Sig_EventDigitalInputSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventDigitalInputSignal (uint32 DigitalInput_, entBool response_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventDigitalInputSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventDigitalInputSignal& operator = (const Sig_EventDigitalInputSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventDigitalInputSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventDigitalInputSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventDigitalInputSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventDigitalInputSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInput"

    static const int kDigitalInput = 0;

    /**
     * Clears the field "DigitalInput".
     *
     * The field will be set to its default value. The hasDigitalInput()
     * method will return false.
     */
    inline void clearDigitalInput();

    /**
     * Checks whether the field "DigitalInput" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInput()). Otherwise it will return false.
     */
    inline bool hasDigitalInput () const;

    /**
     * Returns the value of the member "DigitalInput".
     *
     * If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInput"
     */
    inline uint32 getDigitalInput () const;

    /**
     * Sets the value of the member "DigitalInput".
     *
     * If the meaning of "DigitalInput" isn't clear, then there should be a description here.
     *
     * @param DigitalInput The value which will be set
     */
    inline void setDigitalInput (uint32 DigitalInput_);

    // API of field "response"

    static const int kResponse = 1;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline entBool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (entBool response_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 2;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_EventDigitalInputSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInput ();

    inline void clear_has_DigitalInput ();

    inline void set_has_response ();

    inline void clear_has_response ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DigitalInput;

    entBool _response;

    ::std::string _ReceivedIP;

};

/**
 * RspGetDigitalInputCMP = 0x0020 response to  Request Digital IO's
 */
class Sig_RspGetDigitalInputCMPSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetDigitalInputCMPSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetDigitalInputCMPSignal (const Sig_RspGetDigitalInputCMPSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetDigitalInputCMPSignal (uint32 DigitalInputCMP_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetDigitalInputCMPSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetDigitalInputCMPSignal& operator = (const Sig_RspGetDigitalInputCMPSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetDigitalInputCMPSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetDigitalInputCMPSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetDigitalInputCMPSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetDigitalInputCMPSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInputCMP"

    static const int kDigitalInputCMP = 0;

    /**
     * Clears the field "DigitalInputCMP".
     *
     * The field will be set to its default value. The hasDigitalInputCMP()
     * method will return false.
     */
    inline void clearDigitalInputCMP();

    /**
     * Checks whether the field "DigitalInputCMP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInputCMP()). Otherwise it will return false.
     */
    inline bool hasDigitalInputCMP () const;

    /**
     * Returns the value of the member "DigitalInputCMP".
     *
     * If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInputCMP"
     */
    inline uint32 getDigitalInputCMP () const;

    /**
     * Sets the value of the member "DigitalInputCMP".
     *
     * If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @param DigitalInputCMP The value which will be set
     */
    inline void setDigitalInputCMP (uint32 DigitalInputCMP_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_RspGetDigitalInputCMPSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInputCMP ();

    inline void clear_has_DigitalInputCMP ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DigitalInputCMP;

    ::std::string _ReceivedIP;

};

/**
 * EventDigitalInputCMP = 0x0018 Event to  Request Digital IO's
 */
class Sig_EventDigitalInputCMPSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventDigitalInputCMPSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventDigitalInputCMPSignal (const Sig_EventDigitalInputCMPSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventDigitalInputCMPSignal (uint32 DigitalInputCMP_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventDigitalInputCMPSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventDigitalInputCMPSignal& operator = (const Sig_EventDigitalInputCMPSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventDigitalInputCMPSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventDigitalInputCMPSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventDigitalInputCMPSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventDigitalInputCMPSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInputCMP"

    static const int kDigitalInputCMP = 0;

    /**
     * Clears the field "DigitalInputCMP".
     *
     * The field will be set to its default value. The hasDigitalInputCMP()
     * method will return false.
     */
    inline void clearDigitalInputCMP();

    /**
     * Checks whether the field "DigitalInputCMP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInputCMP()). Otherwise it will return false.
     */
    inline bool hasDigitalInputCMP () const;

    /**
     * Returns the value of the member "DigitalInputCMP".
     *
     * If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInputCMP"
     */
    inline uint32 getDigitalInputCMP () const;

    /**
     * Sets the value of the member "DigitalInputCMP".
     *
     * If the meaning of "DigitalInputCMP" isn't clear, then there should be a description here.
     *
     * @param DigitalInputCMP The value which will be set
     */
    inline void setDigitalInputCMP (uint32 DigitalInputCMP_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_EventDigitalInputCMPSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInputCMP ();

    inline void clear_has_DigitalInputCMP ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DigitalInputCMP;

    ::std::string _ReceivedIP;

};

/**
 * RspGetDigitalInputCMG = 0x0023 response to  Request Digital IO's
 */
class Sig_RspGetDigitalInputCMGSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetDigitalInputCMGSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetDigitalInputCMGSignal (const Sig_RspGetDigitalInputCMGSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetDigitalInputCMGSignal (uint32 DigitalInputCMG_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetDigitalInputCMGSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetDigitalInputCMGSignal& operator = (const Sig_RspGetDigitalInputCMGSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetDigitalInputCMGSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetDigitalInputCMGSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetDigitalInputCMGSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetDigitalInputCMGSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInputCMG"

    static const int kDigitalInputCMG = 0;

    /**
     * Clears the field "DigitalInputCMG".
     *
     * The field will be set to its default value. The hasDigitalInputCMG()
     * method will return false.
     */
    inline void clearDigitalInputCMG();

    /**
     * Checks whether the field "DigitalInputCMG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInputCMG()). Otherwise it will return false.
     */
    inline bool hasDigitalInputCMG () const;

    /**
     * Returns the value of the member "DigitalInputCMG".
     *
     * If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInputCMG"
     */
    inline uint32 getDigitalInputCMG () const;

    /**
     * Sets the value of the member "DigitalInputCMG".
     *
     * If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @param DigitalInputCMG The value which will be set
     */
    inline void setDigitalInputCMG (uint32 DigitalInputCMG_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_RspGetDigitalInputCMGSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInputCMG ();

    inline void clear_has_DigitalInputCMG ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DigitalInputCMG;

    ::std::string _ReceivedIP;

};

/**
 * EventDigitalInputCMG = 0x0021 Event to  Request Digital IO's
 */
class Sig_EventDigitalInputCMGSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventDigitalInputCMGSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventDigitalInputCMGSignal (const Sig_EventDigitalInputCMGSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventDigitalInputCMGSignal (uint32 DigitalInputCMG_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventDigitalInputCMGSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventDigitalInputCMGSignal& operator = (const Sig_EventDigitalInputCMGSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventDigitalInputCMGSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventDigitalInputCMGSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventDigitalInputCMGSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventDigitalInputCMGSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DigitalInputCMG"

    static const int kDigitalInputCMG = 0;

    /**
     * Clears the field "DigitalInputCMG".
     *
     * The field will be set to its default value. The hasDigitalInputCMG()
     * method will return false.
     */
    inline void clearDigitalInputCMG();

    /**
     * Checks whether the field "DigitalInputCMG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigitalInputCMG()). Otherwise it will return false.
     */
    inline bool hasDigitalInputCMG () const;

    /**
     * Returns the value of the member "DigitalInputCMG".
     *
     * If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DigitalInputCMG"
     */
    inline uint32 getDigitalInputCMG () const;

    /**
     * Sets the value of the member "DigitalInputCMG".
     *
     * If the meaning of "DigitalInputCMG" isn't clear, then there should be a description here.
     *
     * @param DigitalInputCMG The value which will be set
     */
    inline void setDigitalInputCMG (uint32 DigitalInputCMG_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_EventDigitalInputCMGSignal &getDefaultInstance();

private:

    inline void set_has_DigitalInputCMG ();

    inline void clear_has_DigitalInputCMG ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DigitalInputCMG;

    ::std::string _ReceivedIP;

};

/**
 * RspGetVoltage = 0x0014
 */
class RspGetVoltageSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RspGetVoltageSignal ();

    /**
     * Copy constructor
     */
    inline  RspGetVoltageSignal (const RspGetVoltageSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RspGetVoltageSignal (entVoltageLevel VoltageLevel_, entVoltageSensor VoltageSensor_, uint16 VoltageValue_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~RspGetVoltageSignal();

    /**
     * Assignment operator
     */
    inline RspGetVoltageSignal& operator = (const RspGetVoltageSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RspGetVoltageSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RspGetVoltageSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RspGetVoltageSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RspGetVoltageSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageLevel"

    static const int kVoltageLevel = 0;

    /**
     * Clears the field "VoltageLevel".
     *
     * The field will be set to its default value. The hasVoltageLevel()
     * method will return false.
     */
    inline void clearVoltageLevel();

    /**
     * Checks whether the field "VoltageLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageLevel()). Otherwise it will return false.
     */
    inline bool hasVoltageLevel () const;

    /**
     * Returns the value of the member "VoltageLevel".
     *
     * If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageLevel"
     */
    inline entVoltageLevel getVoltageLevel () const;

    /**
     * Sets the value of the member "VoltageLevel".
     *
     * If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @param VoltageLevel The value which will be set
     */
    inline void setVoltageLevel (entVoltageLevel VoltageLevel_);

    // API of field "VoltageSensor"

    static const int kVoltageSensor = 1;

    /**
     * Clears the field "VoltageSensor".
     *
     * The field will be set to its default value. The hasVoltageSensor()
     * method will return false.
     */
    inline void clearVoltageSensor();

    /**
     * Checks whether the field "VoltageSensor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageSensor()). Otherwise it will return false.
     */
    inline bool hasVoltageSensor () const;

    /**
     * Returns the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageSensor"
     */
    inline entVoltageSensor getVoltageSensor () const;

    /**
     * Sets the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor The value which will be set
     */
    inline void setVoltageSensor (entVoltageSensor VoltageSensor_);

    // API of field "VoltageValue"

    static const int kVoltageValue = 2;

    /**
     * Clears the field "VoltageValue".
     *
     * The field will be set to its default value. The hasVoltageValue()
     * method will return false.
     */
    inline void clearVoltageValue();

    /**
     * Checks whether the field "VoltageValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageValue()). Otherwise it will return false.
     */
    inline bool hasVoltageValue () const;

    /**
     * Returns the value of the member "VoltageValue".
     *
     * If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageValue"
     */
    inline uint16 getVoltageValue () const;

    /**
     * Sets the value of the member "VoltageValue".
     *
     * If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @param VoltageValue The value which will be set
     */
    inline void setVoltageValue (uint16 VoltageValue_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 3;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const RspGetVoltageSignal &getDefaultInstance();

private:

    inline void set_has_VoltageLevel ();

    inline void clear_has_VoltageLevel ();

    inline void set_has_VoltageSensor ();

    inline void clear_has_VoltageSensor ();

    inline void set_has_VoltageValue ();

    inline void clear_has_VoltageValue ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    entVoltageLevel _VoltageLevel;

    entVoltageSensor _VoltageSensor;

    uint16 _VoltageValue;

    ::std::string _ReceivedIP;

};

/**
 * EventVoltage = 0x0012
 */
class EventVoltageSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventVoltageSignal ();

    /**
     * Copy constructor
     */
    inline  EventVoltageSignal (const EventVoltageSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventVoltageSignal (entVoltageLevel VoltageLevel_, entVoltageSensor VoltageSensor_, uint16 VoltageValue_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~EventVoltageSignal();

    /**
     * Assignment operator
     */
    inline EventVoltageSignal& operator = (const EventVoltageSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventVoltageSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventVoltageSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventVoltageSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventVoltageSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageLevel"

    static const int kVoltageLevel = 0;

    /**
     * Clears the field "VoltageLevel".
     *
     * The field will be set to its default value. The hasVoltageLevel()
     * method will return false.
     */
    inline void clearVoltageLevel();

    /**
     * Checks whether the field "VoltageLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageLevel()). Otherwise it will return false.
     */
    inline bool hasVoltageLevel () const;

    /**
     * Returns the value of the member "VoltageLevel".
     *
     * If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageLevel"
     */
    inline entVoltageLevel getVoltageLevel () const;

    /**
     * Sets the value of the member "VoltageLevel".
     *
     * If the meaning of "VoltageLevel" isn't clear, then there should be a description here.
     *
     * @param VoltageLevel The value which will be set
     */
    inline void setVoltageLevel (entVoltageLevel VoltageLevel_);

    // API of field "VoltageSensor"

    static const int kVoltageSensor = 1;

    /**
     * Clears the field "VoltageSensor".
     *
     * The field will be set to its default value. The hasVoltageSensor()
     * method will return false.
     */
    inline void clearVoltageSensor();

    /**
     * Checks whether the field "VoltageSensor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageSensor()). Otherwise it will return false.
     */
    inline bool hasVoltageSensor () const;

    /**
     * Returns the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageSensor"
     */
    inline entVoltageSensor getVoltageSensor () const;

    /**
     * Sets the value of the member "VoltageSensor".
     *
     * If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor The value which will be set
     */
    inline void setVoltageSensor (entVoltageSensor VoltageSensor_);

    // API of field "VoltageValue"

    static const int kVoltageValue = 2;

    /**
     * Clears the field "VoltageValue".
     *
     * The field will be set to its default value. The hasVoltageValue()
     * method will return false.
     */
    inline void clearVoltageValue();

    /**
     * Checks whether the field "VoltageValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageValue()). Otherwise it will return false.
     */
    inline bool hasVoltageValue () const;

    /**
     * Returns the value of the member "VoltageValue".
     *
     * If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VoltageValue"
     */
    inline uint16 getVoltageValue () const;

    /**
     * Sets the value of the member "VoltageValue".
     *
     * If the meaning of "VoltageValue" isn't clear, then there should be a description here.
     *
     * @param VoltageValue The value which will be set
     */
    inline void setVoltageValue (uint16 VoltageValue_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 3;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const EventVoltageSignal &getDefaultInstance();

private:

    inline void set_has_VoltageLevel ();

    inline void clear_has_VoltageLevel ();

    inline void set_has_VoltageSensor ();

    inline void clear_has_VoltageSensor ();

    inline void set_has_VoltageValue ();

    inline void clear_has_VoltageValue ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    entVoltageLevel _VoltageLevel;

    entVoltageSensor _VoltageSensor;

    uint16 _VoltageValue;

    ::std::string _ReceivedIP;

};

/**
 * RspGetThermalState = 0x0045
 */
class RspGetThermalStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RspGetThermalStateSignal ();

    /**
     * Copy constructor
     */
    inline  RspGetThermalStateSignal (const RspGetThermalStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RspGetThermalStateSignal (entThermalState ThermalState_, entThermalSensorID ThermalSensorID_, int16 Temperature_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~RspGetThermalStateSignal();

    /**
     * Assignment operator
     */
    inline RspGetThermalStateSignal& operator = (const RspGetThermalStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RspGetThermalStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RspGetThermalStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RspGetThermalStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RspGetThermalStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ThermalState"

    static const int kThermalState = 0;

    /**
     * Clears the field "ThermalState".
     *
     * The field will be set to its default value. The hasThermalState()
     * method will return false.
     */
    inline void clearThermalState();

    /**
     * Checks whether the field "ThermalState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermalState()). Otherwise it will return false.
     */
    inline bool hasThermalState () const;

    /**
     * Returns the value of the member "ThermalState".
     *
     * If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ThermalState"
     */
    inline entThermalState getThermalState () const;

    /**
     * Sets the value of the member "ThermalState".
     *
     * If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @param ThermalState The value which will be set
     */
    inline void setThermalState (entThermalState ThermalState_);

    // API of field "ThermalSensorID"

    static const int kThermalSensorID = 1;

    /**
     * Clears the field "ThermalSensorID".
     *
     * The field will be set to its default value. The hasThermalSensorID()
     * method will return false.
     */
    inline void clearThermalSensorID();

    /**
     * Checks whether the field "ThermalSensorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermalSensorID()). Otherwise it will return false.
     */
    inline bool hasThermalSensorID () const;

    /**
     * Returns the value of the member "ThermalSensorID".
     *
     * If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ThermalSensorID"
     */
    inline entThermalSensorID getThermalSensorID () const;

    /**
     * Sets the value of the member "ThermalSensorID".
     *
     * If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @param ThermalSensorID The value which will be set
     */
    inline void setThermalSensorID (entThermalSensorID ThermalSensorID_);

    // API of field "Temperature"

    static const int kTemperature = 2;

    /**
     * Clears the field "Temperature".
     *
     * The field will be set to its default value. The hasTemperature()
     * method will return false.
     */
    inline void clearTemperature();

    /**
     * Checks whether the field "Temperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperature()). Otherwise it will return false.
     */
    inline bool hasTemperature () const;

    /**
     * Returns the value of the member "Temperature".
     *
     * If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Temperature"
     */
    inline int16 getTemperature () const;

    /**
     * Sets the value of the member "Temperature".
     *
     * If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @param Temperature The value which will be set
     */
    inline void setTemperature (int16 Temperature_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 3;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const RspGetThermalStateSignal &getDefaultInstance();

private:

    inline void set_has_ThermalState ();

    inline void clear_has_ThermalState ();

    inline void set_has_ThermalSensorID ();

    inline void clear_has_ThermalSensorID ();

    inline void set_has_Temperature ();

    inline void clear_has_Temperature ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    entThermalState _ThermalState;

    entThermalSensorID _ThermalSensorID;

    int16 _Temperature;

    ::std::string _ReceivedIP;

};

/**
 * EventThermalState = 0x0043
 */
class EventThermalStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventThermalStateSignal ();

    /**
     * Copy constructor
     */
    inline  EventThermalStateSignal (const EventThermalStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventThermalStateSignal (entThermalState ThermalState_, entThermalSensorID ThermalSensorID_, int16 Temperature_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~EventThermalStateSignal();

    /**
     * Assignment operator
     */
    inline EventThermalStateSignal& operator = (const EventThermalStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventThermalStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventThermalStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventThermalStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventThermalStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ThermalState"

    static const int kThermalState = 0;

    /**
     * Clears the field "ThermalState".
     *
     * The field will be set to its default value. The hasThermalState()
     * method will return false.
     */
    inline void clearThermalState();

    /**
     * Checks whether the field "ThermalState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermalState()). Otherwise it will return false.
     */
    inline bool hasThermalState () const;

    /**
     * Returns the value of the member "ThermalState".
     *
     * If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ThermalState"
     */
    inline entThermalState getThermalState () const;

    /**
     * Sets the value of the member "ThermalState".
     *
     * If the meaning of "ThermalState" isn't clear, then there should be a description here.
     *
     * @param ThermalState The value which will be set
     */
    inline void setThermalState (entThermalState ThermalState_);

    // API of field "ThermalSensorID"

    static const int kThermalSensorID = 1;

    /**
     * Clears the field "ThermalSensorID".
     *
     * The field will be set to its default value. The hasThermalSensorID()
     * method will return false.
     */
    inline void clearThermalSensorID();

    /**
     * Checks whether the field "ThermalSensorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermalSensorID()). Otherwise it will return false.
     */
    inline bool hasThermalSensorID () const;

    /**
     * Returns the value of the member "ThermalSensorID".
     *
     * If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ThermalSensorID"
     */
    inline entThermalSensorID getThermalSensorID () const;

    /**
     * Sets the value of the member "ThermalSensorID".
     *
     * If the meaning of "ThermalSensorID" isn't clear, then there should be a description here.
     *
     * @param ThermalSensorID The value which will be set
     */
    inline void setThermalSensorID (entThermalSensorID ThermalSensorID_);

    // API of field "Temperature"

    static const int kTemperature = 2;

    /**
     * Clears the field "Temperature".
     *
     * The field will be set to its default value. The hasTemperature()
     * method will return false.
     */
    inline void clearTemperature();

    /**
     * Checks whether the field "Temperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperature()). Otherwise it will return false.
     */
    inline bool hasTemperature () const;

    /**
     * Returns the value of the member "Temperature".
     *
     * If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Temperature"
     */
    inline int16 getTemperature () const;

    /**
     * Sets the value of the member "Temperature".
     *
     * If the meaning of "Temperature" isn't clear, then there should be a description here.
     *
     * @param Temperature The value which will be set
     */
    inline void setTemperature (int16 Temperature_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 3;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const EventThermalStateSignal &getDefaultInstance();

private:

    inline void set_has_ThermalState ();

    inline void clear_has_ThermalState ();

    inline void set_has_ThermalSensorID ();

    inline void clear_has_ThermalSensorID ();

    inline void set_has_Temperature ();

    inline void clear_has_Temperature ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    entThermalState _ThermalState;

    entThermalSensorID _ThermalSensorID;

    int16 _Temperature;

    ::std::string _ReceivedIP;

};

/**
 * RspSetAnnouncementOut = 0x0021
 */
class RspSetAnnouncementOutSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RspSetAnnouncementOutSignal ();

    /**
     * Copy constructor
     */
    inline  RspSetAnnouncementOutSignal (const RspSetAnnouncementOutSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RspSetAnnouncementOutSignal (uint16 status_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~RspSetAnnouncementOutSignal();

    /**
     * Assignment operator
     */
    inline RspSetAnnouncementOutSignal& operator = (const RspSetAnnouncementOutSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RspSetAnnouncementOutSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RspSetAnnouncementOutSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RspSetAnnouncementOutSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RspSetAnnouncementOutSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const RspSetAnnouncementOutSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _status;

    ::std::string _ReceivedIP;

};

/**
 * EventCMGSwivelPosition = 0x0063 Any component sends an event EventCMGSwivelPosition if a swivel position has changed
 */
class Sig_EventCMGSwivelPositionSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventCMGSwivelPositionSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventCMGSwivelPositionSignal (const Sig_EventCMGSwivelPositionSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventCMGSwivelPositionSignal (entSwivelPosition SwivelPosition_, const ::std::string& ReceivedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventCMGSwivelPositionSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventCMGSwivelPositionSignal& operator = (const Sig_EventCMGSwivelPositionSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventCMGSwivelPositionSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventCMGSwivelPositionSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventCMGSwivelPositionSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventCMGSwivelPositionSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SwivelPosition"

    static const int kSwivelPosition = 0;

    /**
     * Clears the field "SwivelPosition".
     *
     * The field will be set to its default value. The hasSwivelPosition()
     * method will return false.
     */
    inline void clearSwivelPosition();

    /**
     * Checks whether the field "SwivelPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwivelPosition()). Otherwise it will return false.
     */
    inline bool hasSwivelPosition () const;

    /**
     * Returns the value of the member "SwivelPosition".
     *
     * If the meaning of "SwivelPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SwivelPosition"
     */
    inline entSwivelPosition getSwivelPosition () const;

    /**
     * Sets the value of the member "SwivelPosition".
     *
     * If the meaning of "SwivelPosition" isn't clear, then there should be a description here.
     *
     * @param SwivelPosition The value which will be set
     */
    inline void setSwivelPosition (entSwivelPosition SwivelPosition_);

    // API of field "ReceivedIP"

    static const int kReceivedIP = 1;

    /**
     * Clears the field "ReceivedIP".
     *
     * The field will be set to its default value. The hasReceivedIP()
     * method will return false.
     */
    inline void clearReceivedIP();

    /**
     * Checks whether the field "ReceivedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedIP()). Otherwise it will return false.
     */
    inline bool hasReceivedIP () const;

    /**
     * Returns the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReceivedIP"
     */
    inline const ::std::string& getReceivedIP () const;

    /**
     * Retrieves the value of the field "ReceivedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReceivedIP".
     */
    inline ::std::string& getReceivedIPMutable ();

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const ::std::string& ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* ReceivedIP_);

    /**
     * Sets the value of the member "ReceivedIP".
     *
     * If the meaning of "ReceivedIP" isn't clear, then there should be a description here.
     *
     * @param ReceivedIP The value which will be set
     */
    inline void setReceivedIP (const char* value, size_t size);

    static const Sig_EventCMGSwivelPositionSignal &getDefaultInstance();

private:

    inline void set_has_SwivelPosition ();

    inline void clear_has_SwivelPosition ();

    inline void set_has_ReceivedIP ();

    inline void clear_has_ReceivedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    entSwivelPosition _SwivelPosition;

    ::std::string _ReceivedIP;

};

inline  ReqGetDigitalInputRequest::ReqGetDigitalInputRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputRequest::ReqGetDigitalInputRequest (const ReqGetDigitalInputRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputRequest::ReqGetDigitalInputRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputRequest::~ReqGetDigitalInputRequest() {
}

inline ReqGetDigitalInputRequest& ReqGetDigitalInputRequest::operator = (const ReqGetDigitalInputRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputRequest::operator == (const ReqGetDigitalInputRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetDigitalInputRequest::operator != (const ReqGetDigitalInputRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputRequest::operator < (const ReqGetDigitalInputRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputRequest::clone() {
    return new ReqGetDigitalInputRequest(*this);
}

inline bool ReqGetDigitalInputRequest::operator > (const ReqGetDigitalInputRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetDigitalInputRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetDigitalInputRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetDigitalInputRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetDigitalInputRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetDigitalInputRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetDigitalInputRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetDigitalInputRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetDigitalInputRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetDigitalInputRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetDigitalInputRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetDigitalInputRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetDigitalInputRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetDigitalInputRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetDigitalInputRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetDigitalInputRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetDigitalInputRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetDigitalInputRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetDigitalInputRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetDigitalInputRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetDigitalInputRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetDigitalInputRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetDigitalInputRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetDigitalInputRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetDigitalInputRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetDigitalInputRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetDigitalInputRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetDigitalInputResponse::ReqGetDigitalInputResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputResponse::ReqGetDigitalInputResponse (const ReqGetDigitalInputResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputResponse::ReqGetDigitalInputResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputResponse::~ReqGetDigitalInputResponse() {
}

inline ReqGetDigitalInputResponse& ReqGetDigitalInputResponse::operator = (const ReqGetDigitalInputResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputResponse::operator == (const ReqGetDigitalInputResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetDigitalInputResponse::operator != (const ReqGetDigitalInputResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputResponse::operator < (const ReqGetDigitalInputResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputResponse::clone() {
    return new ReqGetDigitalInputResponse(*this);
}

inline bool ReqGetDigitalInputResponse::operator > (const ReqGetDigitalInputResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputResponse::clear() {
    clearResponse();
}

inline void ReqGetDigitalInputResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetDigitalInputResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetDigitalInputResponse::getResponse () const {
    return _response;
}

inline void ReqGetDigitalInputResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetDigitalInputResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetDigitalInputCMPRequest::ReqGetDigitalInputCMPRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMPRequest::ReqGetDigitalInputCMPRequest (const ReqGetDigitalInputCMPRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputCMPRequest::ReqGetDigitalInputCMPRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMPRequest::~ReqGetDigitalInputCMPRequest() {
}

inline ReqGetDigitalInputCMPRequest& ReqGetDigitalInputCMPRequest::operator = (const ReqGetDigitalInputCMPRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputCMPRequest::operator == (const ReqGetDigitalInputCMPRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetDigitalInputCMPRequest::operator != (const ReqGetDigitalInputCMPRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputCMPRequest::operator < (const ReqGetDigitalInputCMPRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputCMPRequest::clone() {
    return new ReqGetDigitalInputCMPRequest(*this);
}

inline bool ReqGetDigitalInputCMPRequest::operator > (const ReqGetDigitalInputCMPRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputCMPRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetDigitalInputCMPRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetDigitalInputCMPRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetDigitalInputCMPRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetDigitalInputCMPRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetDigitalInputCMPRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetDigitalInputCMPRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetDigitalInputCMPRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetDigitalInputCMPRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetDigitalInputCMPRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetDigitalInputCMPRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetDigitalInputCMPRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetDigitalInputCMPRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetDigitalInputCMPRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetDigitalInputCMPRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetDigitalInputCMPRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetDigitalInputCMPRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetDigitalInputCMPRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetDigitalInputCMPRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetDigitalInputCMPRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetDigitalInputCMPRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputCMPRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetDigitalInputCMPRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetDigitalInputCMPRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetDigitalInputCMPRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetDigitalInputCMPRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetDigitalInputCMPRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetDigitalInputCMPRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetDigitalInputCMPResponse::ReqGetDigitalInputCMPResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMPResponse::ReqGetDigitalInputCMPResponse (const ReqGetDigitalInputCMPResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputCMPResponse::ReqGetDigitalInputCMPResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMPResponse::~ReqGetDigitalInputCMPResponse() {
}

inline ReqGetDigitalInputCMPResponse& ReqGetDigitalInputCMPResponse::operator = (const ReqGetDigitalInputCMPResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputCMPResponse::operator == (const ReqGetDigitalInputCMPResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetDigitalInputCMPResponse::operator != (const ReqGetDigitalInputCMPResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputCMPResponse::operator < (const ReqGetDigitalInputCMPResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputCMPResponse::clone() {
    return new ReqGetDigitalInputCMPResponse(*this);
}

inline bool ReqGetDigitalInputCMPResponse::operator > (const ReqGetDigitalInputCMPResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputCMPResponse::clear() {
    clearResponse();
}

inline void ReqGetDigitalInputCMPResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetDigitalInputCMPResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetDigitalInputCMPResponse::getResponse () const {
    return _response;
}

inline void ReqGetDigitalInputCMPResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetDigitalInputCMPResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputCMPResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetDigitalInputCMGRequest::ReqGetDigitalInputCMGRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMGRequest::ReqGetDigitalInputCMGRequest (const ReqGetDigitalInputCMGRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputCMGRequest::ReqGetDigitalInputCMGRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMGRequest::~ReqGetDigitalInputCMGRequest() {
}

inline ReqGetDigitalInputCMGRequest& ReqGetDigitalInputCMGRequest::operator = (const ReqGetDigitalInputCMGRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputCMGRequest::operator == (const ReqGetDigitalInputCMGRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetDigitalInputCMGRequest::operator != (const ReqGetDigitalInputCMGRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputCMGRequest::operator < (const ReqGetDigitalInputCMGRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputCMGRequest::clone() {
    return new ReqGetDigitalInputCMGRequest(*this);
}

inline bool ReqGetDigitalInputCMGRequest::operator > (const ReqGetDigitalInputCMGRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputCMGRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetDigitalInputCMGRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetDigitalInputCMGRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetDigitalInputCMGRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetDigitalInputCMGRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetDigitalInputCMGRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetDigitalInputCMGRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetDigitalInputCMGRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetDigitalInputCMGRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetDigitalInputCMGRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetDigitalInputCMGRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetDigitalInputCMGRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetDigitalInputCMGRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetDigitalInputCMGRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetDigitalInputCMGRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetDigitalInputCMGRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetDigitalInputCMGRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetDigitalInputCMGRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetDigitalInputCMGRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetDigitalInputCMGRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetDigitalInputCMGRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputCMGRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetDigitalInputCMGRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetDigitalInputCMGRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetDigitalInputCMGRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetDigitalInputCMGRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetDigitalInputCMGRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetDigitalInputCMGRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetDigitalInputCMGResponse::ReqGetDigitalInputCMGResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMGResponse::ReqGetDigitalInputCMGResponse (const ReqGetDigitalInputCMGResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetDigitalInputCMGResponse::ReqGetDigitalInputCMGResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetDigitalInputCMGResponse::~ReqGetDigitalInputCMGResponse() {
}

inline ReqGetDigitalInputCMGResponse& ReqGetDigitalInputCMGResponse::operator = (const ReqGetDigitalInputCMGResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetDigitalInputCMGResponse::operator == (const ReqGetDigitalInputCMGResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetDigitalInputCMGResponse::operator != (const ReqGetDigitalInputCMGResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetDigitalInputCMGResponse::operator < (const ReqGetDigitalInputCMGResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetDigitalInputCMGResponse::clone() {
    return new ReqGetDigitalInputCMGResponse(*this);
}

inline bool ReqGetDigitalInputCMGResponse::operator > (const ReqGetDigitalInputCMGResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetDigitalInputCMGResponse::clear() {
    clearResponse();
}

inline void ReqGetDigitalInputCMGResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetDigitalInputCMGResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetDigitalInputCMGResponse::getResponse () const {
    return _response;
}

inline void ReqGetDigitalInputCMGResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetDigitalInputCMGResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetDigitalInputCMGResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetVoltageRequest::ReqGetVoltageRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVoltageRequest::ReqGetVoltageRequest (const ReqGetVoltageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVoltageRequest::ReqGetVoltageRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, entVoltageSensor VoltageSensor_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _VoltageSensor (VoltageSensor_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "ReqGetVoltageRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVoltageRequest::~ReqGetVoltageRequest() {
}

inline ReqGetVoltageRequest& ReqGetVoltageRequest::operator = (const ReqGetVoltageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasVoltageSensor()) {
            setVoltageSensor(rhs.getVoltageSensor());
        } else {
            clearVoltageSensor();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetVoltageRequest::operator == (const ReqGetVoltageRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasVoltageSensor() && !rhs.hasVoltageSensor()) || getVoltageSensor() == rhs.getVoltageSensor()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetVoltageRequest::operator != (const ReqGetVoltageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVoltageRequest::operator < (const ReqGetVoltageRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasVoltageSensor() || rhs.hasVoltageSensor()) {
        if ((uint32)getVoltageSensor() < (uint32)rhs.getVoltageSensor()) return true;
        if ((uint32)getVoltageSensor() > (uint32)rhs.getVoltageSensor()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVoltageRequest::clone() {
    return new ReqGetVoltageRequest(*this);
}

inline bool ReqGetVoltageRequest::operator > (const ReqGetVoltageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVoltageRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearVoltageSensor();
    clearDestIP();
}

inline void ReqGetVoltageRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetVoltageRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetVoltageRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetVoltageRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetVoltageRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetVoltageRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetVoltageRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetVoltageRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetVoltageRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetVoltageRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetVoltageRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetVoltageRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetVoltageRequest::clearVoltageSensor() {
    if (hasVoltageSensor()) {
         clear_has_VoltageSensor();
        _VoltageSensor = ::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined;
     }
}

inline bool ReqGetVoltageRequest::hasVoltageSensor () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline entVoltageSensor ReqGetVoltageRequest::getVoltageSensor () const {
    return _VoltageSensor;
}

inline void ReqGetVoltageRequest::setVoltageSensor (entVoltageSensor VoltageSensor_) {
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "ReqGetVoltageRequest");
    }
    #endif
    set_has_VoltageSensor();
    this->_VoltageSensor = VoltageSensor_;
}

inline void ReqGetVoltageRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetVoltageRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqGetVoltageRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetVoltageRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetVoltageRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetVoltageRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetVoltageRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetVoltageRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVoltageRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetVoltageRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetVoltageRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetVoltageRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetVoltageRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetVoltageRequest::set_has_VoltageSensor () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetVoltageRequest::clear_has_VoltageSensor () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqGetVoltageRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqGetVoltageRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqGetVoltageResponse::ReqGetVoltageResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVoltageResponse::ReqGetVoltageResponse (const ReqGetVoltageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVoltageResponse::ReqGetVoltageResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVoltageResponse::~ReqGetVoltageResponse() {
}

inline ReqGetVoltageResponse& ReqGetVoltageResponse::operator = (const ReqGetVoltageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetVoltageResponse::operator == (const ReqGetVoltageResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetVoltageResponse::operator != (const ReqGetVoltageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVoltageResponse::operator < (const ReqGetVoltageResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVoltageResponse::clone() {
    return new ReqGetVoltageResponse(*this);
}

inline bool ReqGetVoltageResponse::operator > (const ReqGetVoltageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVoltageResponse::clear() {
    clearResponse();
}

inline void ReqGetVoltageResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetVoltageResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetVoltageResponse::getResponse () const {
    return _response;
}

inline void ReqGetVoltageResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetVoltageResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVoltageResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqSetAnnouncementOutRequest::ReqSetAnnouncementOutRequest ()  :
    _AnnouncementState (::bosch::cm::di::NanoMsgGenericInterface::entAnnouncementState__entAnnouncementState_On_High),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetAnnouncementOutRequest::ReqSetAnnouncementOutRequest (const ReqSetAnnouncementOutRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AnnouncementState (::bosch::cm::di::NanoMsgGenericInterface::entAnnouncementState__entAnnouncementState_On_High),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetAnnouncementOutRequest::ReqSetAnnouncementOutRequest (entAnnouncementState AnnouncementState_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _AnnouncementState (AnnouncementState_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(entAnnouncementState_IsValid(AnnouncementState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnouncementState_, "entAnnouncementState", "AnnouncementState", "ReqSetAnnouncementOutRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetAnnouncementOutRequest::~ReqSetAnnouncementOutRequest() {
}

inline ReqSetAnnouncementOutRequest& ReqSetAnnouncementOutRequest::operator = (const ReqSetAnnouncementOutRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAnnouncementState()) {
            setAnnouncementState(rhs.getAnnouncementState());
        } else {
            clearAnnouncementState();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetAnnouncementOutRequest::operator == (const ReqSetAnnouncementOutRequest& rhs) const {
    return (((!hasAnnouncementState() && !rhs.hasAnnouncementState()) || getAnnouncementState() == rhs.getAnnouncementState()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetAnnouncementOutRequest::operator != (const ReqSetAnnouncementOutRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetAnnouncementOutRequest::operator < (const ReqSetAnnouncementOutRequest& rhs) const {
    if (hasAnnouncementState() || rhs.hasAnnouncementState()) {
        if ((uint32)getAnnouncementState() < (uint32)rhs.getAnnouncementState()) return true;
        if ((uint32)getAnnouncementState() > (uint32)rhs.getAnnouncementState()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetAnnouncementOutRequest::clone() {
    return new ReqSetAnnouncementOutRequest(*this);
}

inline bool ReqSetAnnouncementOutRequest::operator > (const ReqSetAnnouncementOutRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetAnnouncementOutRequest::clear() {
    clearAnnouncementState();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetAnnouncementOutRequest::clearAnnouncementState() {
    if (hasAnnouncementState()) {
         clear_has_AnnouncementState();
        _AnnouncementState = ::bosch::cm::di::NanoMsgGenericInterface::entAnnouncementState__entAnnouncementState_On_High;
     }
}

inline bool ReqSetAnnouncementOutRequest::hasAnnouncementState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entAnnouncementState ReqSetAnnouncementOutRequest::getAnnouncementState () const {
    return _AnnouncementState;
}

inline void ReqSetAnnouncementOutRequest::setAnnouncementState (entAnnouncementState AnnouncementState_) {
    #ifndef NDEBUG
    if (!(entAnnouncementState_IsValid(AnnouncementState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AnnouncementState_, "entAnnouncementState", "AnnouncementState", "ReqSetAnnouncementOutRequest");
    }
    #endif
    set_has_AnnouncementState();
    this->_AnnouncementState = AnnouncementState_;
}

inline void ReqSetAnnouncementOutRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqSetAnnouncementOutRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqSetAnnouncementOutRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetAnnouncementOutRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetAnnouncementOutRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetAnnouncementOutRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqSetAnnouncementOutRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetAnnouncementOutRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetAnnouncementOutRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetAnnouncementOutRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqSetAnnouncementOutRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetAnnouncementOutRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetAnnouncementOutRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetAnnouncementOutRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqSetAnnouncementOutRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetAnnouncementOutRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetAnnouncementOutRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetAnnouncementOutRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetAnnouncementOutRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetAnnouncementOutRequest::set_has_AnnouncementState () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetAnnouncementOutRequest::clear_has_AnnouncementState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetAnnouncementOutRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetAnnouncementOutRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetAnnouncementOutRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetAnnouncementOutRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetAnnouncementOutRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetAnnouncementOutRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqSetAnnouncementOutRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqSetAnnouncementOutRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqSetAnnouncementOutResponse::ReqSetAnnouncementOutResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetAnnouncementOutResponse::ReqSetAnnouncementOutResponse (const ReqSetAnnouncementOutResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetAnnouncementOutResponse::ReqSetAnnouncementOutResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetAnnouncementOutResponse::~ReqSetAnnouncementOutResponse() {
}

inline ReqSetAnnouncementOutResponse& ReqSetAnnouncementOutResponse::operator = (const ReqSetAnnouncementOutResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetAnnouncementOutResponse::operator == (const ReqSetAnnouncementOutResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetAnnouncementOutResponse::operator != (const ReqSetAnnouncementOutResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetAnnouncementOutResponse::operator < (const ReqSetAnnouncementOutResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetAnnouncementOutResponse::clone() {
    return new ReqSetAnnouncementOutResponse(*this);
}

inline bool ReqSetAnnouncementOutResponse::operator > (const ReqSetAnnouncementOutResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetAnnouncementOutResponse::clear() {
    clearResponse();
}

inline void ReqSetAnnouncementOutResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetAnnouncementOutResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetAnnouncementOutResponse::getResponse () const {
    return _response;
}

inline void ReqSetAnnouncementOutResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetAnnouncementOutResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetAnnouncementOutResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetThermalStateRequest::ReqGetThermalStateRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetThermalStateRequest::ReqGetThermalStateRequest (const ReqGetThermalStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetThermalStateRequest::ReqGetThermalStateRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetThermalStateRequest::~ReqGetThermalStateRequest() {
}

inline ReqGetThermalStateRequest& ReqGetThermalStateRequest::operator = (const ReqGetThermalStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetThermalStateRequest::operator == (const ReqGetThermalStateRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetThermalStateRequest::operator != (const ReqGetThermalStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetThermalStateRequest::operator < (const ReqGetThermalStateRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetThermalStateRequest::clone() {
    return new ReqGetThermalStateRequest(*this);
}

inline bool ReqGetThermalStateRequest::operator > (const ReqGetThermalStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetThermalStateRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetThermalStateRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetThermalStateRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetThermalStateRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetThermalStateRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetThermalStateRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetThermalStateRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetThermalStateRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetThermalStateRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetThermalStateRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetThermalStateRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetThermalStateRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetThermalStateRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetThermalStateRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetThermalStateRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetThermalStateRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetThermalStateRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetThermalStateRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetThermalStateRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetThermalStateRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetThermalStateRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetThermalStateRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetThermalStateRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetThermalStateRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetThermalStateRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetThermalStateRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetThermalStateRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetThermalStateRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetThermalStateResponse::ReqGetThermalStateResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetThermalStateResponse::ReqGetThermalStateResponse (const ReqGetThermalStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetThermalStateResponse::ReqGetThermalStateResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetThermalStateResponse::~ReqGetThermalStateResponse() {
}

inline ReqGetThermalStateResponse& ReqGetThermalStateResponse::operator = (const ReqGetThermalStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetThermalStateResponse::operator == (const ReqGetThermalStateResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetThermalStateResponse::operator != (const ReqGetThermalStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetThermalStateResponse::operator < (const ReqGetThermalStateResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetThermalStateResponse::clone() {
    return new ReqGetThermalStateResponse(*this);
}

inline bool ReqGetThermalStateResponse::operator > (const ReqGetThermalStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetThermalStateResponse::clear() {
    clearResponse();
}

inline void ReqGetThermalStateResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetThermalStateResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetThermalStateResponse::getResponse () const {
    return _response;
}

inline void ReqGetThermalStateResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetThermalStateResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetThermalStateResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqCMGSvivelPositionRequest::ReqCMGSvivelPositionRequest ()  :
    _SvivelRequest (::bosch::cm::di::NanoMsgGenericInterface::entSvivelRequest__entSvivelRequest_Stop),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCMGSvivelPositionRequest::ReqCMGSvivelPositionRequest (const ReqCMGSvivelPositionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SvivelRequest (::bosch::cm::di::NanoMsgGenericInterface::entSvivelRequest__entSvivelRequest_Stop),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCMGSvivelPositionRequest::ReqCMGSvivelPositionRequest (entSvivelRequest SvivelRequest_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _SvivelRequest (SvivelRequest_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(entSvivelRequest_IsValid(SvivelRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SvivelRequest_, "entSvivelRequest", "SvivelRequest", "ReqCMGSvivelPositionRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCMGSvivelPositionRequest::~ReqCMGSvivelPositionRequest() {
}

inline ReqCMGSvivelPositionRequest& ReqCMGSvivelPositionRequest::operator = (const ReqCMGSvivelPositionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSvivelRequest()) {
            setSvivelRequest(rhs.getSvivelRequest());
        } else {
            clearSvivelRequest();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqCMGSvivelPositionRequest::operator == (const ReqCMGSvivelPositionRequest& rhs) const {
    return (((!hasSvivelRequest() && !rhs.hasSvivelRequest()) || getSvivelRequest() == rhs.getSvivelRequest()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqCMGSvivelPositionRequest::operator != (const ReqCMGSvivelPositionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCMGSvivelPositionRequest::operator < (const ReqCMGSvivelPositionRequest& rhs) const {
    if (hasSvivelRequest() || rhs.hasSvivelRequest()) {
        if ((uint32)getSvivelRequest() < (uint32)rhs.getSvivelRequest()) return true;
        if ((uint32)getSvivelRequest() > (uint32)rhs.getSvivelRequest()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCMGSvivelPositionRequest::clone() {
    return new ReqCMGSvivelPositionRequest(*this);
}

inline bool ReqCMGSvivelPositionRequest::operator > (const ReqCMGSvivelPositionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCMGSvivelPositionRequest::clear() {
    clearSvivelRequest();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqCMGSvivelPositionRequest::clearSvivelRequest() {
    if (hasSvivelRequest()) {
         clear_has_SvivelRequest();
        _SvivelRequest = ::bosch::cm::di::NanoMsgGenericInterface::entSvivelRequest__entSvivelRequest_Stop;
     }
}

inline bool ReqCMGSvivelPositionRequest::hasSvivelRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSvivelRequest ReqCMGSvivelPositionRequest::getSvivelRequest () const {
    return _SvivelRequest;
}

inline void ReqCMGSvivelPositionRequest::setSvivelRequest (entSvivelRequest SvivelRequest_) {
    #ifndef NDEBUG
    if (!(entSvivelRequest_IsValid(SvivelRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SvivelRequest_, "entSvivelRequest", "SvivelRequest", "ReqCMGSvivelPositionRequest");
    }
    #endif
    set_has_SvivelRequest();
    this->_SvivelRequest = SvivelRequest_;
}

inline void ReqCMGSvivelPositionRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqCMGSvivelPositionRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqCMGSvivelPositionRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqCMGSvivelPositionRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqCMGSvivelPositionRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqCMGSvivelPositionRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqCMGSvivelPositionRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqCMGSvivelPositionRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqCMGSvivelPositionRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqCMGSvivelPositionRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqCMGSvivelPositionRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqCMGSvivelPositionRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqCMGSvivelPositionRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqCMGSvivelPositionRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqCMGSvivelPositionRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqCMGSvivelPositionRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqCMGSvivelPositionRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqCMGSvivelPositionRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqCMGSvivelPositionRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqCMGSvivelPositionRequest::set_has_SvivelRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCMGSvivelPositionRequest::clear_has_SvivelRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqCMGSvivelPositionRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqCMGSvivelPositionRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqCMGSvivelPositionRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqCMGSvivelPositionRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqCMGSvivelPositionRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqCMGSvivelPositionRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqCMGSvivelPositionRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqCMGSvivelPositionRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqCMGSvivelPositionResponse::ReqCMGSvivelPositionResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCMGSvivelPositionResponse::ReqCMGSvivelPositionResponse (const ReqCMGSvivelPositionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCMGSvivelPositionResponse::ReqCMGSvivelPositionResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCMGSvivelPositionResponse::~ReqCMGSvivelPositionResponse() {
}

inline ReqCMGSvivelPositionResponse& ReqCMGSvivelPositionResponse::operator = (const ReqCMGSvivelPositionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqCMGSvivelPositionResponse::operator == (const ReqCMGSvivelPositionResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqCMGSvivelPositionResponse::operator != (const ReqCMGSvivelPositionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCMGSvivelPositionResponse::operator < (const ReqCMGSvivelPositionResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCMGSvivelPositionResponse::clone() {
    return new ReqCMGSvivelPositionResponse(*this);
}

inline bool ReqCMGSvivelPositionResponse::operator > (const ReqCMGSvivelPositionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCMGSvivelPositionResponse::clear() {
    clearResponse();
}

inline void ReqCMGSvivelPositionResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqCMGSvivelPositionResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqCMGSvivelPositionResponse::getResponse () const {
    return _response;
}

inline void ReqCMGSvivelPositionResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqCMGSvivelPositionResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCMGSvivelPositionResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_RspCMGSvivelPositionSignal::Sig_RspCMGSvivelPositionSignal ()  :
    _status (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspCMGSvivelPositionSignal::Sig_RspCMGSvivelPositionSignal (const Sig_RspCMGSvivelPositionSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspCMGSvivelPositionSignal::Sig_RspCMGSvivelPositionSignal (uint16 status_, const ::std::string& RecevedIP_)  :
    _status (status_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspCMGSvivelPositionSignal::~Sig_RspCMGSvivelPositionSignal() {
}

inline Sig_RspCMGSvivelPositionSignal& Sig_RspCMGSvivelPositionSignal::operator = (const Sig_RspCMGSvivelPositionSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspCMGSvivelPositionSignal::operator == (const Sig_RspCMGSvivelPositionSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspCMGSvivelPositionSignal::operator != (const Sig_RspCMGSvivelPositionSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspCMGSvivelPositionSignal::operator < (const Sig_RspCMGSvivelPositionSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspCMGSvivelPositionSignal::clone() {
    return new Sig_RspCMGSvivelPositionSignal(*this);
}

inline bool Sig_RspCMGSvivelPositionSignal::operator > (const Sig_RspCMGSvivelPositionSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspCMGSvivelPositionSignal::clear() {
    clearStatus();
    clearRecevedIP();
}

inline void Sig_RspCMGSvivelPositionSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool Sig_RspCMGSvivelPositionSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Sig_RspCMGSvivelPositionSignal::getStatus () const {
    return _status;
}

inline void Sig_RspCMGSvivelPositionSignal::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_RspCMGSvivelPositionSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspCMGSvivelPositionSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspCMGSvivelPositionSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspCMGSvivelPositionSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspCMGSvivelPositionSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspCMGSvivelPositionSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspCMGSvivelPositionSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspCMGSvivelPositionSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspCMGSvivelPositionSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspCMGSvivelPositionSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspCMGSvivelPositionSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_RspGetDigitalInputSignal::Sig_RspGetDigitalInputSignal ()  :
    _DigitalInput (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputSignal::Sig_RspGetDigitalInputSignal (const Sig_RspGetDigitalInputSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInput (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetDigitalInputSignal::Sig_RspGetDigitalInputSignal (uint32 DigitalInput_, const ::std::string& ReceivedIP_)  :
    _DigitalInput (DigitalInput_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputSignal::~Sig_RspGetDigitalInputSignal() {
}

inline Sig_RspGetDigitalInputSignal& Sig_RspGetDigitalInputSignal::operator = (const Sig_RspGetDigitalInputSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInput()) {
            setDigitalInput(rhs.getDigitalInput());
        } else {
            clearDigitalInput();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetDigitalInputSignal::operator == (const Sig_RspGetDigitalInputSignal& rhs) const {
    return (((!hasDigitalInput() && !rhs.hasDigitalInput()) || getDigitalInput() == rhs.getDigitalInput()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_RspGetDigitalInputSignal::operator != (const Sig_RspGetDigitalInputSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetDigitalInputSignal::operator < (const Sig_RspGetDigitalInputSignal& rhs) const {
    if (hasDigitalInput() || rhs.hasDigitalInput()) {
        if (getDigitalInput() < rhs.getDigitalInput()) return true;
        if (getDigitalInput() > rhs.getDigitalInput()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetDigitalInputSignal::clone() {
    return new Sig_RspGetDigitalInputSignal(*this);
}

inline bool Sig_RspGetDigitalInputSignal::operator > (const Sig_RspGetDigitalInputSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetDigitalInputSignal::clear() {
    clearDigitalInput();
    clearReceivedIP();
}

inline void Sig_RspGetDigitalInputSignal::clearDigitalInput() {
    if (hasDigitalInput()) {
         clear_has_DigitalInput();
        _DigitalInput = 0u;
     }
}

inline bool Sig_RspGetDigitalInputSignal::hasDigitalInput () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_RspGetDigitalInputSignal::getDigitalInput () const {
    return _DigitalInput;
}

inline void Sig_RspGetDigitalInputSignal::setDigitalInput (uint32 DigitalInput_) {
    set_has_DigitalInput();
    this->_DigitalInput = DigitalInput_;
}

inline void Sig_RspGetDigitalInputSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_RspGetDigitalInputSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspGetDigitalInputSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_RspGetDigitalInputSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_RspGetDigitalInputSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_RspGetDigitalInputSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_RspGetDigitalInputSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_RspGetDigitalInputSignal::set_has_DigitalInput () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetDigitalInputSignal::clear_has_DigitalInput () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetDigitalInputSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetDigitalInputSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventDigitalInputSignal::Sig_EventDigitalInputSignal ()  :
    _DigitalInput (0u),
    _response (::bosch::cm::di::NanoMsgGenericInterface::entBool__entBool_OFF),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputSignal::Sig_EventDigitalInputSignal (const Sig_EventDigitalInputSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInput (0u),
    _response (::bosch::cm::di::NanoMsgGenericInterface::entBool__entBool_OFF),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventDigitalInputSignal::Sig_EventDigitalInputSignal (uint32 DigitalInput_, entBool response_, const ::std::string& ReceivedIP_)  :
    _DigitalInput (DigitalInput_),
    _response (response_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entBool_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "entBool", "response", "Sig_EventDigitalInputSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputSignal::~Sig_EventDigitalInputSignal() {
}

inline Sig_EventDigitalInputSignal& Sig_EventDigitalInputSignal::operator = (const Sig_EventDigitalInputSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInput()) {
            setDigitalInput(rhs.getDigitalInput());
        } else {
            clearDigitalInput();
        }
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_EventDigitalInputSignal::operator == (const Sig_EventDigitalInputSignal& rhs) const {
    return (((!hasDigitalInput() && !rhs.hasDigitalInput()) || getDigitalInput() == rhs.getDigitalInput()) &&
        ((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_EventDigitalInputSignal::operator != (const Sig_EventDigitalInputSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventDigitalInputSignal::operator < (const Sig_EventDigitalInputSignal& rhs) const {
    if (hasDigitalInput() || rhs.hasDigitalInput()) {
        if (getDigitalInput() < rhs.getDigitalInput()) return true;
        if (getDigitalInput() > rhs.getDigitalInput()) return false;
    }
    if (hasResponse() || rhs.hasResponse()) {
        if ((uint32)getResponse() < (uint32)rhs.getResponse()) return true;
        if ((uint32)getResponse() > (uint32)rhs.getResponse()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventDigitalInputSignal::clone() {
    return new Sig_EventDigitalInputSignal(*this);
}

inline bool Sig_EventDigitalInputSignal::operator > (const Sig_EventDigitalInputSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventDigitalInputSignal::clear() {
    clearDigitalInput();
    clearResponse();
    clearReceivedIP();
}

inline void Sig_EventDigitalInputSignal::clearDigitalInput() {
    if (hasDigitalInput()) {
         clear_has_DigitalInput();
        _DigitalInput = 0u;
     }
}

inline bool Sig_EventDigitalInputSignal::hasDigitalInput () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_EventDigitalInputSignal::getDigitalInput () const {
    return _DigitalInput;
}

inline void Sig_EventDigitalInputSignal::setDigitalInput (uint32 DigitalInput_) {
    set_has_DigitalInput();
    this->_DigitalInput = DigitalInput_;
}

inline void Sig_EventDigitalInputSignal::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = ::bosch::cm::di::NanoMsgGenericInterface::entBool__entBool_OFF;
     }
}

inline bool Sig_EventDigitalInputSignal::hasResponse () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entBool Sig_EventDigitalInputSignal::getResponse () const {
    return _response;
}

inline void Sig_EventDigitalInputSignal::setResponse (entBool response_) {
    #ifndef NDEBUG
    if (!(entBool_IsValid(response_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", response_, "entBool", "response", "Sig_EventDigitalInputSignal");
    }
    #endif
    set_has_response();
    this->_response = response_;
}

inline void Sig_EventDigitalInputSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_EventDigitalInputSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& Sig_EventDigitalInputSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_EventDigitalInputSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_EventDigitalInputSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_EventDigitalInputSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_EventDigitalInputSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_EventDigitalInputSignal::set_has_DigitalInput () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventDigitalInputSignal::clear_has_DigitalInput () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventDigitalInputSignal::set_has_response () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventDigitalInputSignal::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_EventDigitalInputSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_EventDigitalInputSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_RspGetDigitalInputCMPSignal::Sig_RspGetDigitalInputCMPSignal ()  :
    _DigitalInputCMP (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputCMPSignal::Sig_RspGetDigitalInputCMPSignal (const Sig_RspGetDigitalInputCMPSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInputCMP (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetDigitalInputCMPSignal::Sig_RspGetDigitalInputCMPSignal (uint32 DigitalInputCMP_, const ::std::string& ReceivedIP_)  :
    _DigitalInputCMP (DigitalInputCMP_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputCMPSignal::~Sig_RspGetDigitalInputCMPSignal() {
}

inline Sig_RspGetDigitalInputCMPSignal& Sig_RspGetDigitalInputCMPSignal::operator = (const Sig_RspGetDigitalInputCMPSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInputCMP()) {
            setDigitalInputCMP(rhs.getDigitalInputCMP());
        } else {
            clearDigitalInputCMP();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetDigitalInputCMPSignal::operator == (const Sig_RspGetDigitalInputCMPSignal& rhs) const {
    return (((!hasDigitalInputCMP() && !rhs.hasDigitalInputCMP()) || getDigitalInputCMP() == rhs.getDigitalInputCMP()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_RspGetDigitalInputCMPSignal::operator != (const Sig_RspGetDigitalInputCMPSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetDigitalInputCMPSignal::operator < (const Sig_RspGetDigitalInputCMPSignal& rhs) const {
    if (hasDigitalInputCMP() || rhs.hasDigitalInputCMP()) {
        if (getDigitalInputCMP() < rhs.getDigitalInputCMP()) return true;
        if (getDigitalInputCMP() > rhs.getDigitalInputCMP()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetDigitalInputCMPSignal::clone() {
    return new Sig_RspGetDigitalInputCMPSignal(*this);
}

inline bool Sig_RspGetDigitalInputCMPSignal::operator > (const Sig_RspGetDigitalInputCMPSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetDigitalInputCMPSignal::clear() {
    clearDigitalInputCMP();
    clearReceivedIP();
}

inline void Sig_RspGetDigitalInputCMPSignal::clearDigitalInputCMP() {
    if (hasDigitalInputCMP()) {
         clear_has_DigitalInputCMP();
        _DigitalInputCMP = 0u;
     }
}

inline bool Sig_RspGetDigitalInputCMPSignal::hasDigitalInputCMP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_RspGetDigitalInputCMPSignal::getDigitalInputCMP () const {
    return _DigitalInputCMP;
}

inline void Sig_RspGetDigitalInputCMPSignal::setDigitalInputCMP (uint32 DigitalInputCMP_) {
    set_has_DigitalInputCMP();
    this->_DigitalInputCMP = DigitalInputCMP_;
}

inline void Sig_RspGetDigitalInputCMPSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_RspGetDigitalInputCMPSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspGetDigitalInputCMPSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_RspGetDigitalInputCMPSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_RspGetDigitalInputCMPSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_RspGetDigitalInputCMPSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_RspGetDigitalInputCMPSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_RspGetDigitalInputCMPSignal::set_has_DigitalInputCMP () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetDigitalInputCMPSignal::clear_has_DigitalInputCMP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetDigitalInputCMPSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetDigitalInputCMPSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventDigitalInputCMPSignal::Sig_EventDigitalInputCMPSignal ()  :
    _DigitalInputCMP (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputCMPSignal::Sig_EventDigitalInputCMPSignal (const Sig_EventDigitalInputCMPSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInputCMP (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventDigitalInputCMPSignal::Sig_EventDigitalInputCMPSignal (uint32 DigitalInputCMP_, const ::std::string& ReceivedIP_)  :
    _DigitalInputCMP (DigitalInputCMP_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputCMPSignal::~Sig_EventDigitalInputCMPSignal() {
}

inline Sig_EventDigitalInputCMPSignal& Sig_EventDigitalInputCMPSignal::operator = (const Sig_EventDigitalInputCMPSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInputCMP()) {
            setDigitalInputCMP(rhs.getDigitalInputCMP());
        } else {
            clearDigitalInputCMP();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_EventDigitalInputCMPSignal::operator == (const Sig_EventDigitalInputCMPSignal& rhs) const {
    return (((!hasDigitalInputCMP() && !rhs.hasDigitalInputCMP()) || getDigitalInputCMP() == rhs.getDigitalInputCMP()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_EventDigitalInputCMPSignal::operator != (const Sig_EventDigitalInputCMPSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventDigitalInputCMPSignal::operator < (const Sig_EventDigitalInputCMPSignal& rhs) const {
    if (hasDigitalInputCMP() || rhs.hasDigitalInputCMP()) {
        if (getDigitalInputCMP() < rhs.getDigitalInputCMP()) return true;
        if (getDigitalInputCMP() > rhs.getDigitalInputCMP()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventDigitalInputCMPSignal::clone() {
    return new Sig_EventDigitalInputCMPSignal(*this);
}

inline bool Sig_EventDigitalInputCMPSignal::operator > (const Sig_EventDigitalInputCMPSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventDigitalInputCMPSignal::clear() {
    clearDigitalInputCMP();
    clearReceivedIP();
}

inline void Sig_EventDigitalInputCMPSignal::clearDigitalInputCMP() {
    if (hasDigitalInputCMP()) {
         clear_has_DigitalInputCMP();
        _DigitalInputCMP = 0u;
     }
}

inline bool Sig_EventDigitalInputCMPSignal::hasDigitalInputCMP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_EventDigitalInputCMPSignal::getDigitalInputCMP () const {
    return _DigitalInputCMP;
}

inline void Sig_EventDigitalInputCMPSignal::setDigitalInputCMP (uint32 DigitalInputCMP_) {
    set_has_DigitalInputCMP();
    this->_DigitalInputCMP = DigitalInputCMP_;
}

inline void Sig_EventDigitalInputCMPSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_EventDigitalInputCMPSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventDigitalInputCMPSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_EventDigitalInputCMPSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_EventDigitalInputCMPSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_EventDigitalInputCMPSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_EventDigitalInputCMPSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_EventDigitalInputCMPSignal::set_has_DigitalInputCMP () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventDigitalInputCMPSignal::clear_has_DigitalInputCMP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventDigitalInputCMPSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventDigitalInputCMPSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_RspGetDigitalInputCMGSignal::Sig_RspGetDigitalInputCMGSignal ()  :
    _DigitalInputCMG (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputCMGSignal::Sig_RspGetDigitalInputCMGSignal (const Sig_RspGetDigitalInputCMGSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInputCMG (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetDigitalInputCMGSignal::Sig_RspGetDigitalInputCMGSignal (uint32 DigitalInputCMG_, const ::std::string& ReceivedIP_)  :
    _DigitalInputCMG (DigitalInputCMG_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetDigitalInputCMGSignal::~Sig_RspGetDigitalInputCMGSignal() {
}

inline Sig_RspGetDigitalInputCMGSignal& Sig_RspGetDigitalInputCMGSignal::operator = (const Sig_RspGetDigitalInputCMGSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInputCMG()) {
            setDigitalInputCMG(rhs.getDigitalInputCMG());
        } else {
            clearDigitalInputCMG();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetDigitalInputCMGSignal::operator == (const Sig_RspGetDigitalInputCMGSignal& rhs) const {
    return (((!hasDigitalInputCMG() && !rhs.hasDigitalInputCMG()) || getDigitalInputCMG() == rhs.getDigitalInputCMG()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_RspGetDigitalInputCMGSignal::operator != (const Sig_RspGetDigitalInputCMGSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetDigitalInputCMGSignal::operator < (const Sig_RspGetDigitalInputCMGSignal& rhs) const {
    if (hasDigitalInputCMG() || rhs.hasDigitalInputCMG()) {
        if (getDigitalInputCMG() < rhs.getDigitalInputCMG()) return true;
        if (getDigitalInputCMG() > rhs.getDigitalInputCMG()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetDigitalInputCMGSignal::clone() {
    return new Sig_RspGetDigitalInputCMGSignal(*this);
}

inline bool Sig_RspGetDigitalInputCMGSignal::operator > (const Sig_RspGetDigitalInputCMGSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetDigitalInputCMGSignal::clear() {
    clearDigitalInputCMG();
    clearReceivedIP();
}

inline void Sig_RspGetDigitalInputCMGSignal::clearDigitalInputCMG() {
    if (hasDigitalInputCMG()) {
         clear_has_DigitalInputCMG();
        _DigitalInputCMG = 0u;
     }
}

inline bool Sig_RspGetDigitalInputCMGSignal::hasDigitalInputCMG () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_RspGetDigitalInputCMGSignal::getDigitalInputCMG () const {
    return _DigitalInputCMG;
}

inline void Sig_RspGetDigitalInputCMGSignal::setDigitalInputCMG (uint32 DigitalInputCMG_) {
    set_has_DigitalInputCMG();
    this->_DigitalInputCMG = DigitalInputCMG_;
}

inline void Sig_RspGetDigitalInputCMGSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_RspGetDigitalInputCMGSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspGetDigitalInputCMGSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_RspGetDigitalInputCMGSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_RspGetDigitalInputCMGSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_RspGetDigitalInputCMGSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_RspGetDigitalInputCMGSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_RspGetDigitalInputCMGSignal::set_has_DigitalInputCMG () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetDigitalInputCMGSignal::clear_has_DigitalInputCMG () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetDigitalInputCMGSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetDigitalInputCMGSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventDigitalInputCMGSignal::Sig_EventDigitalInputCMGSignal ()  :
    _DigitalInputCMG (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputCMGSignal::Sig_EventDigitalInputCMGSignal (const Sig_EventDigitalInputCMGSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DigitalInputCMG (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventDigitalInputCMGSignal::Sig_EventDigitalInputCMGSignal (uint32 DigitalInputCMG_, const ::std::string& ReceivedIP_)  :
    _DigitalInputCMG (DigitalInputCMG_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventDigitalInputCMGSignal::~Sig_EventDigitalInputCMGSignal() {
}

inline Sig_EventDigitalInputCMGSignal& Sig_EventDigitalInputCMGSignal::operator = (const Sig_EventDigitalInputCMGSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigitalInputCMG()) {
            setDigitalInputCMG(rhs.getDigitalInputCMG());
        } else {
            clearDigitalInputCMG();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_EventDigitalInputCMGSignal::operator == (const Sig_EventDigitalInputCMGSignal& rhs) const {
    return (((!hasDigitalInputCMG() && !rhs.hasDigitalInputCMG()) || getDigitalInputCMG() == rhs.getDigitalInputCMG()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_EventDigitalInputCMGSignal::operator != (const Sig_EventDigitalInputCMGSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventDigitalInputCMGSignal::operator < (const Sig_EventDigitalInputCMGSignal& rhs) const {
    if (hasDigitalInputCMG() || rhs.hasDigitalInputCMG()) {
        if (getDigitalInputCMG() < rhs.getDigitalInputCMG()) return true;
        if (getDigitalInputCMG() > rhs.getDigitalInputCMG()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventDigitalInputCMGSignal::clone() {
    return new Sig_EventDigitalInputCMGSignal(*this);
}

inline bool Sig_EventDigitalInputCMGSignal::operator > (const Sig_EventDigitalInputCMGSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventDigitalInputCMGSignal::clear() {
    clearDigitalInputCMG();
    clearReceivedIP();
}

inline void Sig_EventDigitalInputCMGSignal::clearDigitalInputCMG() {
    if (hasDigitalInputCMG()) {
         clear_has_DigitalInputCMG();
        _DigitalInputCMG = 0u;
     }
}

inline bool Sig_EventDigitalInputCMGSignal::hasDigitalInputCMG () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_EventDigitalInputCMGSignal::getDigitalInputCMG () const {
    return _DigitalInputCMG;
}

inline void Sig_EventDigitalInputCMGSignal::setDigitalInputCMG (uint32 DigitalInputCMG_) {
    set_has_DigitalInputCMG();
    this->_DigitalInputCMG = DigitalInputCMG_;
}

inline void Sig_EventDigitalInputCMGSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_EventDigitalInputCMGSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventDigitalInputCMGSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_EventDigitalInputCMGSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_EventDigitalInputCMGSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_EventDigitalInputCMGSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_EventDigitalInputCMGSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_EventDigitalInputCMGSignal::set_has_DigitalInputCMG () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventDigitalInputCMGSignal::clear_has_DigitalInputCMG () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventDigitalInputCMGSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventDigitalInputCMGSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RspGetVoltageSignal::RspGetVoltageSignal ()  :
    _VoltageLevel (::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _VoltageValue (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RspGetVoltageSignal::RspGetVoltageSignal (const RspGetVoltageSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _VoltageLevel (::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _VoltageValue (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RspGetVoltageSignal::RspGetVoltageSignal (entVoltageLevel VoltageLevel_, entVoltageSensor VoltageSensor_, uint16 VoltageValue_, const ::std::string& ReceivedIP_)  :
    _VoltageLevel (VoltageLevel_),
    _VoltageSensor (VoltageSensor_),
    _VoltageValue (VoltageValue_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entVoltageLevel_IsValid(VoltageLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageLevel_, "entVoltageLevel", "VoltageLevel", "RspGetVoltageSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "RspGetVoltageSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RspGetVoltageSignal::~RspGetVoltageSignal() {
}

inline RspGetVoltageSignal& RspGetVoltageSignal::operator = (const RspGetVoltageSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoltageLevel()) {
            setVoltageLevel(rhs.getVoltageLevel());
        } else {
            clearVoltageLevel();
        }
        if (rhs.hasVoltageSensor()) {
            setVoltageSensor(rhs.getVoltageSensor());
        } else {
            clearVoltageSensor();
        }
        if (rhs.hasVoltageValue()) {
            setVoltageValue(rhs.getVoltageValue());
        } else {
            clearVoltageValue();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool RspGetVoltageSignal::operator == (const RspGetVoltageSignal& rhs) const {
    return (((!hasVoltageLevel() && !rhs.hasVoltageLevel()) || getVoltageLevel() == rhs.getVoltageLevel()) &&
        ((!hasVoltageSensor() && !rhs.hasVoltageSensor()) || getVoltageSensor() == rhs.getVoltageSensor()) &&
        ((!hasVoltageValue() && !rhs.hasVoltageValue()) || getVoltageValue() == rhs.getVoltageValue()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool RspGetVoltageSignal::operator != (const RspGetVoltageSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RspGetVoltageSignal::operator < (const RspGetVoltageSignal& rhs) const {
    if (hasVoltageLevel() || rhs.hasVoltageLevel()) {
        if ((uint32)getVoltageLevel() < (uint32)rhs.getVoltageLevel()) return true;
        if ((uint32)getVoltageLevel() > (uint32)rhs.getVoltageLevel()) return false;
    }
    if (hasVoltageSensor() || rhs.hasVoltageSensor()) {
        if ((uint32)getVoltageSensor() < (uint32)rhs.getVoltageSensor()) return true;
        if ((uint32)getVoltageSensor() > (uint32)rhs.getVoltageSensor()) return false;
    }
    if (hasVoltageValue() || rhs.hasVoltageValue()) {
        if (getVoltageValue() < rhs.getVoltageValue()) return true;
        if (getVoltageValue() > rhs.getVoltageValue()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RspGetVoltageSignal::clone() {
    return new RspGetVoltageSignal(*this);
}

inline bool RspGetVoltageSignal::operator > (const RspGetVoltageSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RspGetVoltageSignal::clear() {
    clearVoltageLevel();
    clearVoltageSensor();
    clearVoltageValue();
    clearReceivedIP();
}

inline void RspGetVoltageSignal::clearVoltageLevel() {
    if (hasVoltageLevel()) {
         clear_has_VoltageLevel();
        _VoltageLevel = ::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined;
     }
}

inline bool RspGetVoltageSignal::hasVoltageLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entVoltageLevel RspGetVoltageSignal::getVoltageLevel () const {
    return _VoltageLevel;
}

inline void RspGetVoltageSignal::setVoltageLevel (entVoltageLevel VoltageLevel_) {
    #ifndef NDEBUG
    if (!(entVoltageLevel_IsValid(VoltageLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageLevel_, "entVoltageLevel", "VoltageLevel", "RspGetVoltageSignal");
    }
    #endif
    set_has_VoltageLevel();
    this->_VoltageLevel = VoltageLevel_;
}

inline void RspGetVoltageSignal::clearVoltageSensor() {
    if (hasVoltageSensor()) {
         clear_has_VoltageSensor();
        _VoltageSensor = ::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined;
     }
}

inline bool RspGetVoltageSignal::hasVoltageSensor () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entVoltageSensor RspGetVoltageSignal::getVoltageSensor () const {
    return _VoltageSensor;
}

inline void RspGetVoltageSignal::setVoltageSensor (entVoltageSensor VoltageSensor_) {
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "RspGetVoltageSignal");
    }
    #endif
    set_has_VoltageSensor();
    this->_VoltageSensor = VoltageSensor_;
}

inline void RspGetVoltageSignal::clearVoltageValue() {
    if (hasVoltageValue()) {
         clear_has_VoltageValue();
        _VoltageValue = 0u;
     }
}

inline bool RspGetVoltageSignal::hasVoltageValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 RspGetVoltageSignal::getVoltageValue () const {
    return _VoltageValue;
}

inline void RspGetVoltageSignal::setVoltageValue (uint16 VoltageValue_) {
    set_has_VoltageValue();
    this->_VoltageValue = VoltageValue_;
}

inline void RspGetVoltageSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool RspGetVoltageSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& RspGetVoltageSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& RspGetVoltageSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void RspGetVoltageSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void RspGetVoltageSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void RspGetVoltageSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void RspGetVoltageSignal::set_has_VoltageLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void RspGetVoltageSignal::clear_has_VoltageLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RspGetVoltageSignal::set_has_VoltageSensor () {
    _has_bits_[0] |= 1u << 1;
}

inline void RspGetVoltageSignal::clear_has_VoltageSensor () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RspGetVoltageSignal::set_has_VoltageValue () {
    _has_bits_[0] |= 1u << 2;
}

inline void RspGetVoltageSignal::clear_has_VoltageValue () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RspGetVoltageSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void RspGetVoltageSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EventVoltageSignal::EventVoltageSignal ()  :
    _VoltageLevel (::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _VoltageValue (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventVoltageSignal::EventVoltageSignal (const EventVoltageSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _VoltageLevel (::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined),
    _VoltageSensor (::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined),
    _VoltageValue (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventVoltageSignal::EventVoltageSignal (entVoltageLevel VoltageLevel_, entVoltageSensor VoltageSensor_, uint16 VoltageValue_, const ::std::string& ReceivedIP_)  :
    _VoltageLevel (VoltageLevel_),
    _VoltageSensor (VoltageSensor_),
    _VoltageValue (VoltageValue_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entVoltageLevel_IsValid(VoltageLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageLevel_, "entVoltageLevel", "VoltageLevel", "EventVoltageSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "EventVoltageSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventVoltageSignal::~EventVoltageSignal() {
}

inline EventVoltageSignal& EventVoltageSignal::operator = (const EventVoltageSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoltageLevel()) {
            setVoltageLevel(rhs.getVoltageLevel());
        } else {
            clearVoltageLevel();
        }
        if (rhs.hasVoltageSensor()) {
            setVoltageSensor(rhs.getVoltageSensor());
        } else {
            clearVoltageSensor();
        }
        if (rhs.hasVoltageValue()) {
            setVoltageValue(rhs.getVoltageValue());
        } else {
            clearVoltageValue();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool EventVoltageSignal::operator == (const EventVoltageSignal& rhs) const {
    return (((!hasVoltageLevel() && !rhs.hasVoltageLevel()) || getVoltageLevel() == rhs.getVoltageLevel()) &&
        ((!hasVoltageSensor() && !rhs.hasVoltageSensor()) || getVoltageSensor() == rhs.getVoltageSensor()) &&
        ((!hasVoltageValue() && !rhs.hasVoltageValue()) || getVoltageValue() == rhs.getVoltageValue()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool EventVoltageSignal::operator != (const EventVoltageSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventVoltageSignal::operator < (const EventVoltageSignal& rhs) const {
    if (hasVoltageLevel() || rhs.hasVoltageLevel()) {
        if ((uint32)getVoltageLevel() < (uint32)rhs.getVoltageLevel()) return true;
        if ((uint32)getVoltageLevel() > (uint32)rhs.getVoltageLevel()) return false;
    }
    if (hasVoltageSensor() || rhs.hasVoltageSensor()) {
        if ((uint32)getVoltageSensor() < (uint32)rhs.getVoltageSensor()) return true;
        if ((uint32)getVoltageSensor() > (uint32)rhs.getVoltageSensor()) return false;
    }
    if (hasVoltageValue() || rhs.hasVoltageValue()) {
        if (getVoltageValue() < rhs.getVoltageValue()) return true;
        if (getVoltageValue() > rhs.getVoltageValue()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventVoltageSignal::clone() {
    return new EventVoltageSignal(*this);
}

inline bool EventVoltageSignal::operator > (const EventVoltageSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventVoltageSignal::clear() {
    clearVoltageLevel();
    clearVoltageSensor();
    clearVoltageValue();
    clearReceivedIP();
}

inline void EventVoltageSignal::clearVoltageLevel() {
    if (hasVoltageLevel()) {
         clear_has_VoltageLevel();
        _VoltageLevel = ::bosch::cm::di::NanoMsgGenericInterface::entVoltageLevel__entVoltage_Undefined;
     }
}

inline bool EventVoltageSignal::hasVoltageLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entVoltageLevel EventVoltageSignal::getVoltageLevel () const {
    return _VoltageLevel;
}

inline void EventVoltageSignal::setVoltageLevel (entVoltageLevel VoltageLevel_) {
    #ifndef NDEBUG
    if (!(entVoltageLevel_IsValid(VoltageLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageLevel_, "entVoltageLevel", "VoltageLevel", "EventVoltageSignal");
    }
    #endif
    set_has_VoltageLevel();
    this->_VoltageLevel = VoltageLevel_;
}

inline void EventVoltageSignal::clearVoltageSensor() {
    if (hasVoltageSensor()) {
         clear_has_VoltageSensor();
        _VoltageSensor = ::bosch::cm::di::NanoMsgGenericInterface::entVoltageSensor__entVoltageSensor_Undefined;
     }
}

inline bool EventVoltageSignal::hasVoltageSensor () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entVoltageSensor EventVoltageSignal::getVoltageSensor () const {
    return _VoltageSensor;
}

inline void EventVoltageSignal::setVoltageSensor (entVoltageSensor VoltageSensor_) {
    #ifndef NDEBUG
    if (!(entVoltageSensor_IsValid(VoltageSensor_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoltageSensor_, "entVoltageSensor", "VoltageSensor", "EventVoltageSignal");
    }
    #endif
    set_has_VoltageSensor();
    this->_VoltageSensor = VoltageSensor_;
}

inline void EventVoltageSignal::clearVoltageValue() {
    if (hasVoltageValue()) {
         clear_has_VoltageValue();
        _VoltageValue = 0u;
     }
}

inline bool EventVoltageSignal::hasVoltageValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 EventVoltageSignal::getVoltageValue () const {
    return _VoltageValue;
}

inline void EventVoltageSignal::setVoltageValue (uint16 VoltageValue_) {
    set_has_VoltageValue();
    this->_VoltageValue = VoltageValue_;
}

inline void EventVoltageSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool EventVoltageSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& EventVoltageSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& EventVoltageSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void EventVoltageSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void EventVoltageSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void EventVoltageSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void EventVoltageSignal::set_has_VoltageLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventVoltageSignal::clear_has_VoltageLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventVoltageSignal::set_has_VoltageSensor () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventVoltageSignal::clear_has_VoltageSensor () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EventVoltageSignal::set_has_VoltageValue () {
    _has_bits_[0] |= 1u << 2;
}

inline void EventVoltageSignal::clear_has_VoltageValue () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EventVoltageSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void EventVoltageSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RspGetThermalStateSignal::RspGetThermalStateSignal ()  :
    _ThermalState (::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined),
    _ThermalSensorID (::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined),
    _Temperature (0),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RspGetThermalStateSignal::RspGetThermalStateSignal (const RspGetThermalStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ThermalState (::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined),
    _ThermalSensorID (::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined),
    _Temperature (0),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RspGetThermalStateSignal::RspGetThermalStateSignal (entThermalState ThermalState_, entThermalSensorID ThermalSensorID_, int16 Temperature_, const ::std::string& ReceivedIP_)  :
    _ThermalState (ThermalState_),
    _ThermalSensorID (ThermalSensorID_),
    _Temperature (Temperature_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entThermalState_IsValid(ThermalState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalState_, "entThermalState", "ThermalState", "RspGetThermalStateSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entThermalSensorID_IsValid(ThermalSensorID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalSensorID_, "entThermalSensorID", "ThermalSensorID", "RspGetThermalStateSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RspGetThermalStateSignal::~RspGetThermalStateSignal() {
}

inline RspGetThermalStateSignal& RspGetThermalStateSignal::operator = (const RspGetThermalStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasThermalState()) {
            setThermalState(rhs.getThermalState());
        } else {
            clearThermalState();
        }
        if (rhs.hasThermalSensorID()) {
            setThermalSensorID(rhs.getThermalSensorID());
        } else {
            clearThermalSensorID();
        }
        if (rhs.hasTemperature()) {
            setTemperature(rhs.getTemperature());
        } else {
            clearTemperature();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool RspGetThermalStateSignal::operator == (const RspGetThermalStateSignal& rhs) const {
    return (((!hasThermalState() && !rhs.hasThermalState()) || getThermalState() == rhs.getThermalState()) &&
        ((!hasThermalSensorID() && !rhs.hasThermalSensorID()) || getThermalSensorID() == rhs.getThermalSensorID()) &&
        ((!hasTemperature() && !rhs.hasTemperature()) || getTemperature() == rhs.getTemperature()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool RspGetThermalStateSignal::operator != (const RspGetThermalStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RspGetThermalStateSignal::operator < (const RspGetThermalStateSignal& rhs) const {
    if (hasThermalState() || rhs.hasThermalState()) {
        if ((uint32)getThermalState() < (uint32)rhs.getThermalState()) return true;
        if ((uint32)getThermalState() > (uint32)rhs.getThermalState()) return false;
    }
    if (hasThermalSensorID() || rhs.hasThermalSensorID()) {
        if ((uint32)getThermalSensorID() < (uint32)rhs.getThermalSensorID()) return true;
        if ((uint32)getThermalSensorID() > (uint32)rhs.getThermalSensorID()) return false;
    }
    if (hasTemperature() || rhs.hasTemperature()) {
        if (getTemperature() < rhs.getTemperature()) return true;
        if (getTemperature() > rhs.getTemperature()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RspGetThermalStateSignal::clone() {
    return new RspGetThermalStateSignal(*this);
}

inline bool RspGetThermalStateSignal::operator > (const RspGetThermalStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RspGetThermalStateSignal::clear() {
    clearThermalState();
    clearThermalSensorID();
    clearTemperature();
    clearReceivedIP();
}

inline void RspGetThermalStateSignal::clearThermalState() {
    if (hasThermalState()) {
         clear_has_ThermalState();
        _ThermalState = ::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined;
     }
}

inline bool RspGetThermalStateSignal::hasThermalState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entThermalState RspGetThermalStateSignal::getThermalState () const {
    return _ThermalState;
}

inline void RspGetThermalStateSignal::setThermalState (entThermalState ThermalState_) {
    #ifndef NDEBUG
    if (!(entThermalState_IsValid(ThermalState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalState_, "entThermalState", "ThermalState", "RspGetThermalStateSignal");
    }
    #endif
    set_has_ThermalState();
    this->_ThermalState = ThermalState_;
}

inline void RspGetThermalStateSignal::clearThermalSensorID() {
    if (hasThermalSensorID()) {
         clear_has_ThermalSensorID();
        _ThermalSensorID = ::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined;
     }
}

inline bool RspGetThermalStateSignal::hasThermalSensorID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entThermalSensorID RspGetThermalStateSignal::getThermalSensorID () const {
    return _ThermalSensorID;
}

inline void RspGetThermalStateSignal::setThermalSensorID (entThermalSensorID ThermalSensorID_) {
    #ifndef NDEBUG
    if (!(entThermalSensorID_IsValid(ThermalSensorID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalSensorID_, "entThermalSensorID", "ThermalSensorID", "RspGetThermalStateSignal");
    }
    #endif
    set_has_ThermalSensorID();
    this->_ThermalSensorID = ThermalSensorID_;
}

inline void RspGetThermalStateSignal::clearTemperature() {
    if (hasTemperature()) {
         clear_has_Temperature();
        _Temperature = 0;
     }
}

inline bool RspGetThermalStateSignal::hasTemperature () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int16 RspGetThermalStateSignal::getTemperature () const {
    return _Temperature;
}

inline void RspGetThermalStateSignal::setTemperature (int16 Temperature_) {
    set_has_Temperature();
    this->_Temperature = Temperature_;
}

inline void RspGetThermalStateSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool RspGetThermalStateSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& RspGetThermalStateSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& RspGetThermalStateSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void RspGetThermalStateSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void RspGetThermalStateSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void RspGetThermalStateSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void RspGetThermalStateSignal::set_has_ThermalState () {
    _has_bits_[0] |= 1u << 0;
}

inline void RspGetThermalStateSignal::clear_has_ThermalState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RspGetThermalStateSignal::set_has_ThermalSensorID () {
    _has_bits_[0] |= 1u << 1;
}

inline void RspGetThermalStateSignal::clear_has_ThermalSensorID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RspGetThermalStateSignal::set_has_Temperature () {
    _has_bits_[0] |= 1u << 2;
}

inline void RspGetThermalStateSignal::clear_has_Temperature () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RspGetThermalStateSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void RspGetThermalStateSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EventThermalStateSignal::EventThermalStateSignal ()  :
    _ThermalState (::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined),
    _ThermalSensorID (::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined),
    _Temperature (0),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventThermalStateSignal::EventThermalStateSignal (const EventThermalStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ThermalState (::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined),
    _ThermalSensorID (::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined),
    _Temperature (0),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventThermalStateSignal::EventThermalStateSignal (entThermalState ThermalState_, entThermalSensorID ThermalSensorID_, int16 Temperature_, const ::std::string& ReceivedIP_)  :
    _ThermalState (ThermalState_),
    _ThermalSensorID (ThermalSensorID_),
    _Temperature (Temperature_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entThermalState_IsValid(ThermalState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalState_, "entThermalState", "ThermalState", "EventThermalStateSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entThermalSensorID_IsValid(ThermalSensorID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalSensorID_, "entThermalSensorID", "ThermalSensorID", "EventThermalStateSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventThermalStateSignal::~EventThermalStateSignal() {
}

inline EventThermalStateSignal& EventThermalStateSignal::operator = (const EventThermalStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasThermalState()) {
            setThermalState(rhs.getThermalState());
        } else {
            clearThermalState();
        }
        if (rhs.hasThermalSensorID()) {
            setThermalSensorID(rhs.getThermalSensorID());
        } else {
            clearThermalSensorID();
        }
        if (rhs.hasTemperature()) {
            setTemperature(rhs.getTemperature());
        } else {
            clearTemperature();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool EventThermalStateSignal::operator == (const EventThermalStateSignal& rhs) const {
    return (((!hasThermalState() && !rhs.hasThermalState()) || getThermalState() == rhs.getThermalState()) &&
        ((!hasThermalSensorID() && !rhs.hasThermalSensorID()) || getThermalSensorID() == rhs.getThermalSensorID()) &&
        ((!hasTemperature() && !rhs.hasTemperature()) || getTemperature() == rhs.getTemperature()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool EventThermalStateSignal::operator != (const EventThermalStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventThermalStateSignal::operator < (const EventThermalStateSignal& rhs) const {
    if (hasThermalState() || rhs.hasThermalState()) {
        if ((uint32)getThermalState() < (uint32)rhs.getThermalState()) return true;
        if ((uint32)getThermalState() > (uint32)rhs.getThermalState()) return false;
    }
    if (hasThermalSensorID() || rhs.hasThermalSensorID()) {
        if ((uint32)getThermalSensorID() < (uint32)rhs.getThermalSensorID()) return true;
        if ((uint32)getThermalSensorID() > (uint32)rhs.getThermalSensorID()) return false;
    }
    if (hasTemperature() || rhs.hasTemperature()) {
        if (getTemperature() < rhs.getTemperature()) return true;
        if (getTemperature() > rhs.getTemperature()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventThermalStateSignal::clone() {
    return new EventThermalStateSignal(*this);
}

inline bool EventThermalStateSignal::operator > (const EventThermalStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventThermalStateSignal::clear() {
    clearThermalState();
    clearThermalSensorID();
    clearTemperature();
    clearReceivedIP();
}

inline void EventThermalStateSignal::clearThermalState() {
    if (hasThermalState()) {
         clear_has_ThermalState();
        _ThermalState = ::bosch::cm::di::NanoMsgGenericInterface::entThermalState__entUndefined;
     }
}

inline bool EventThermalStateSignal::hasThermalState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entThermalState EventThermalStateSignal::getThermalState () const {
    return _ThermalState;
}

inline void EventThermalStateSignal::setThermalState (entThermalState ThermalState_) {
    #ifndef NDEBUG
    if (!(entThermalState_IsValid(ThermalState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalState_, "entThermalState", "ThermalState", "EventThermalStateSignal");
    }
    #endif
    set_has_ThermalState();
    this->_ThermalState = ThermalState_;
}

inline void EventThermalStateSignal::clearThermalSensorID() {
    if (hasThermalSensorID()) {
         clear_has_ThermalSensorID();
        _ThermalSensorID = ::bosch::cm::di::NanoMsgGenericInterface::entThermalSensorID__entUndefined;
     }
}

inline bool EventThermalStateSignal::hasThermalSensorID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entThermalSensorID EventThermalStateSignal::getThermalSensorID () const {
    return _ThermalSensorID;
}

inline void EventThermalStateSignal::setThermalSensorID (entThermalSensorID ThermalSensorID_) {
    #ifndef NDEBUG
    if (!(entThermalSensorID_IsValid(ThermalSensorID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ThermalSensorID_, "entThermalSensorID", "ThermalSensorID", "EventThermalStateSignal");
    }
    #endif
    set_has_ThermalSensorID();
    this->_ThermalSensorID = ThermalSensorID_;
}

inline void EventThermalStateSignal::clearTemperature() {
    if (hasTemperature()) {
         clear_has_Temperature();
        _Temperature = 0;
     }
}

inline bool EventThermalStateSignal::hasTemperature () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int16 EventThermalStateSignal::getTemperature () const {
    return _Temperature;
}

inline void EventThermalStateSignal::setTemperature (int16 Temperature_) {
    set_has_Temperature();
    this->_Temperature = Temperature_;
}

inline void EventThermalStateSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool EventThermalStateSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& EventThermalStateSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& EventThermalStateSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void EventThermalStateSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void EventThermalStateSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void EventThermalStateSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void EventThermalStateSignal::set_has_ThermalState () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventThermalStateSignal::clear_has_ThermalState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventThermalStateSignal::set_has_ThermalSensorID () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventThermalStateSignal::clear_has_ThermalSensorID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EventThermalStateSignal::set_has_Temperature () {
    _has_bits_[0] |= 1u << 2;
}

inline void EventThermalStateSignal::clear_has_Temperature () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EventThermalStateSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void EventThermalStateSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RspSetAnnouncementOutSignal::RspSetAnnouncementOutSignal ()  :
    _status (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RspSetAnnouncementOutSignal::RspSetAnnouncementOutSignal (const RspSetAnnouncementOutSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RspSetAnnouncementOutSignal::RspSetAnnouncementOutSignal (uint16 status_, const ::std::string& ReceivedIP_)  :
    _status (status_),
    _ReceivedIP (ReceivedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RspSetAnnouncementOutSignal::~RspSetAnnouncementOutSignal() {
}

inline RspSetAnnouncementOutSignal& RspSetAnnouncementOutSignal::operator = (const RspSetAnnouncementOutSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool RspSetAnnouncementOutSignal::operator == (const RspSetAnnouncementOutSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool RspSetAnnouncementOutSignal::operator != (const RspSetAnnouncementOutSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RspSetAnnouncementOutSignal::operator < (const RspSetAnnouncementOutSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RspSetAnnouncementOutSignal::clone() {
    return new RspSetAnnouncementOutSignal(*this);
}

inline bool RspSetAnnouncementOutSignal::operator > (const RspSetAnnouncementOutSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RspSetAnnouncementOutSignal::clear() {
    clearStatus();
    clearReceivedIP();
}

inline void RspSetAnnouncementOutSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool RspSetAnnouncementOutSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 RspSetAnnouncementOutSignal::getStatus () const {
    return _status;
}

inline void RspSetAnnouncementOutSignal::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void RspSetAnnouncementOutSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool RspSetAnnouncementOutSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RspSetAnnouncementOutSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& RspSetAnnouncementOutSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void RspSetAnnouncementOutSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void RspSetAnnouncementOutSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void RspSetAnnouncementOutSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void RspSetAnnouncementOutSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RspSetAnnouncementOutSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RspSetAnnouncementOutSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void RspSetAnnouncementOutSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventCMGSwivelPositionSignal::Sig_EventCMGSwivelPositionSignal ()  :
    _SwivelPosition (::bosch::cm::di::NanoMsgGenericInterface::entSwivelPosition__enSwivelPos_STOPPED),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventCMGSwivelPositionSignal::Sig_EventCMGSwivelPositionSignal (const Sig_EventCMGSwivelPositionSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _SwivelPosition (::bosch::cm::di::NanoMsgGenericInterface::entSwivelPosition__enSwivelPos_STOPPED),
    _ReceivedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventCMGSwivelPositionSignal::Sig_EventCMGSwivelPositionSignal (entSwivelPosition SwivelPosition_, const ::std::string& ReceivedIP_)  :
    _SwivelPosition (SwivelPosition_),
    _ReceivedIP (ReceivedIP_)
{
    #ifndef NDEBUG
    if (!(entSwivelPosition_IsValid(SwivelPosition_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SwivelPosition_, "entSwivelPosition", "SwivelPosition", "Sig_EventCMGSwivelPositionSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventCMGSwivelPositionSignal::~Sig_EventCMGSwivelPositionSignal() {
}

inline Sig_EventCMGSwivelPositionSignal& Sig_EventCMGSwivelPositionSignal::operator = (const Sig_EventCMGSwivelPositionSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSwivelPosition()) {
            setSwivelPosition(rhs.getSwivelPosition());
        } else {
            clearSwivelPosition();
        }
        if (rhs.hasReceivedIP()) {
            setReceivedIP(rhs.getReceivedIP());
        } else {
            clearReceivedIP();
        }
    }
    return *this;
}

inline bool Sig_EventCMGSwivelPositionSignal::operator == (const Sig_EventCMGSwivelPositionSignal& rhs) const {
    return (((!hasSwivelPosition() && !rhs.hasSwivelPosition()) || getSwivelPosition() == rhs.getSwivelPosition()) &&
        ((!hasReceivedIP() && !rhs.hasReceivedIP()) || getReceivedIP() == rhs.getReceivedIP()));
}

inline bool Sig_EventCMGSwivelPositionSignal::operator != (const Sig_EventCMGSwivelPositionSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventCMGSwivelPositionSignal::operator < (const Sig_EventCMGSwivelPositionSignal& rhs) const {
    if (hasSwivelPosition() || rhs.hasSwivelPosition()) {
        if ((uint32)getSwivelPosition() < (uint32)rhs.getSwivelPosition()) return true;
        if ((uint32)getSwivelPosition() > (uint32)rhs.getSwivelPosition()) return false;
    }
    if (hasReceivedIP() || rhs.hasReceivedIP()) {
        if (getReceivedIP() < rhs.getReceivedIP()) return true;
        if (getReceivedIP() > rhs.getReceivedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventCMGSwivelPositionSignal::clone() {
    return new Sig_EventCMGSwivelPositionSignal(*this);
}

inline bool Sig_EventCMGSwivelPositionSignal::operator > (const Sig_EventCMGSwivelPositionSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventCMGSwivelPositionSignal::clear() {
    clearSwivelPosition();
    clearReceivedIP();
}

inline void Sig_EventCMGSwivelPositionSignal::clearSwivelPosition() {
    if (hasSwivelPosition()) {
         clear_has_SwivelPosition();
        _SwivelPosition = ::bosch::cm::di::NanoMsgGenericInterface::entSwivelPosition__enSwivelPos_STOPPED;
     }
}

inline bool Sig_EventCMGSwivelPositionSignal::hasSwivelPosition () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSwivelPosition Sig_EventCMGSwivelPositionSignal::getSwivelPosition () const {
    return _SwivelPosition;
}

inline void Sig_EventCMGSwivelPositionSignal::setSwivelPosition (entSwivelPosition SwivelPosition_) {
    #ifndef NDEBUG
    if (!(entSwivelPosition_IsValid(SwivelPosition_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SwivelPosition_, "entSwivelPosition", "SwivelPosition", "Sig_EventCMGSwivelPositionSignal");
    }
    #endif
    set_has_SwivelPosition();
    this->_SwivelPosition = SwivelPosition_;
}

inline void Sig_EventCMGSwivelPositionSignal::clearReceivedIP() {
    if (hasReceivedIP()) {
         clear_has_ReceivedIP();
        _ReceivedIP.clear();
     }
}

inline bool Sig_EventCMGSwivelPositionSignal::hasReceivedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventCMGSwivelPositionSignal::getReceivedIP () const {
    return _ReceivedIP;
}

inline ::std::string& Sig_EventCMGSwivelPositionSignal::getReceivedIPMutable () {
    set_has_ReceivedIP();
    return _ReceivedIP;
}

inline void Sig_EventCMGSwivelPositionSignal::setReceivedIP (const ::std::string& ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP = ReceivedIP_;
}

inline void Sig_EventCMGSwivelPositionSignal::setReceivedIP (const char* ReceivedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReceivedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(ReceivedIP_);
}

inline void Sig_EventCMGSwivelPositionSignal::setReceivedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReceivedIP();
    this->_ReceivedIP.assign(value, size);
}

inline void Sig_EventCMGSwivelPositionSignal::set_has_SwivelPosition () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventCMGSwivelPositionSignal::clear_has_SwivelPosition () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventCMGSwivelPositionSignal::set_has_ReceivedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventCMGSwivelPositionSignal::clear_has_ReceivedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace NanoMsgGenericInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGGENERICINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
