/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERSTUB_H
#define MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERSTUB_H

#include "MessageTunnelService/BlobMessageReceiver.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "boost/shared_ptr.hpp"

namespace MessageTunnelService {
namespace BlobMessageReceiver {

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 *  ==> MessageTunnelService = CourierTunnelService, QtTunnelService
 *  ==> BlobMessageReceiver  = CourierMessageReceiver, QtMessageReceiver
 *  ==> BlobMessageReceiverProxy = CourierMessageReceiverProxy
 * _messageProxy = _courierProxy, qtProxy
 *  receiveBlobMessage = receiveCourierMessage, receiveQtMessage
 */

class BlobMessageReceiverStubConnector;

/**
 * The BlobMessageReceiverStub is the hook to implement the
 * BlobMessageReceiver. It is necessary to derive from this class and
 * implement the pure virtual functions. That's the way to add the
 * functionality to the service.
 */
class BlobMessageReceiverStub : public ::asf::core::Stub
{
public:
    /**
     * The derived class has to pass the port name to the
     * BlobMessageReceiverStub. The port name is defined in the "Car
     * Multimedia Component" model.
     */
    BlobMessageReceiverStub (const std::string& portName);

    virtual ~BlobMessageReceiverStub();

    // request receiveBlobMessage

    /**
     * This function will be called if the component receives the client
     * request "receiveBlobMessageRequest". The service implementation has to
     * process the request and send the response with
     * sendReceiveBlobMessageResponse().
     *
     * <b>Documentation of 'receiveBlobMessage'</b>:
     *
     * Sends a message from the client to the service provider
     */
    virtual void onReceiveBlobMessageRequest (const ::boost::shared_ptr< ReceiveBlobMessageRequest >& receiveBlobMessage) = 0;


private:
    BlobMessageReceiverStub(const BlobMessageReceiverStub&);

    BlobMessageReceiverStub& operator=(const BlobMessageReceiverStub&);


    BlobMessageReceiverStubConnector* _stubConnector;

    ::asf::cms::CmsStubDelegate* _cmsStubDelegate;

    DECLARE_CLASS_LOGGER();

    friend class BlobMessageReceiverStubConnector;
};

} // namespace BlobMessageReceiver
} // namespace MessageTunnelService

#endif // MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERSTUB_H
