#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVER_H
#define MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVER_H

#include "asf/cms/CmsTypes.h"
#include "asf/core/Blob.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 *  ==> MessageTunnelService = CourierTunnelService, QtTunnelService
 *  ==> BlobMessageReceiver  = CourierMessageReceiver, QtMessageReceiver
 *  ==> BlobMessageReceiverProxy = CourierMessageReceiverProxy
 * _messageProxy = _courierProxy, qtProxy
 *  receiveBlobMessage = receiveCourierMessage, receiveQtMessage
 */

namespace MessageTunnelService {
namespace BlobMessageReceiver {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

static const int RECEIVE_BLOB_MESSAGE__ID = -1000560953;

// forward declarations
class ReceiveBlobMessageRequest;

// type definitions
/**
 * Sends a message from the client to the service provider
 */
typedef ::asf::cms::CmsTypes::BaseError ReceiveBlobMessageError;


/**
 * Sends a message from the client to the service provider
 */
class ReceiveBlobMessageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReceiveBlobMessageRequest ();

    /**
     * Copy constructor
     */
    inline  ReceiveBlobMessageRequest (const ReceiveBlobMessageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReceiveBlobMessageRequest (const ::asf::core::Blob& message_);

    /**
     * Destructor
     */
    inline virtual  ~ReceiveBlobMessageRequest();

    /**
     * Assignment operator
     */
    inline ReceiveBlobMessageRequest& operator = (const ReceiveBlobMessageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReceiveBlobMessageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReceiveBlobMessageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReceiveBlobMessageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReceiveBlobMessageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::asf::core::Blob& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::asf::core::Blob& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::asf::core::Blob& message_);

    /**
     * Release the object stored in the field "message".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "message"
     */
    inline ::asf::core::Blob* releaseMessage();

    /**
     * Replace the field "message".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMessage (::asf::core::Blob* message_);

    static const ReceiveBlobMessageRequest &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::asf::core::Blob* _message;

};

inline  ReceiveBlobMessageRequest::ReceiveBlobMessageRequest ()  :
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReceiveBlobMessageRequest::ReceiveBlobMessageRequest (const ReceiveBlobMessageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReceiveBlobMessageRequest::ReceiveBlobMessageRequest (const ::asf::core::Blob& message_)  :
    _message (new ::asf::core::Blob(message_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReceiveBlobMessageRequest::~ReceiveBlobMessageRequest() {
    delete _message;
}

inline ReceiveBlobMessageRequest& ReceiveBlobMessageRequest::operator = (const ReceiveBlobMessageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool ReceiveBlobMessageRequest::operator == (const ReceiveBlobMessageRequest& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool ReceiveBlobMessageRequest::operator != (const ReceiveBlobMessageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReceiveBlobMessageRequest::operator < (const ReceiveBlobMessageRequest& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReceiveBlobMessageRequest::clone() {
    return new ReceiveBlobMessageRequest(*this);
}

inline bool ReceiveBlobMessageRequest::operator > (const ReceiveBlobMessageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReceiveBlobMessageRequest::clear() {
    clearMessage();
}

inline void ReceiveBlobMessageRequest::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        delete _message;
        _message = NULL;
     }
}

inline bool ReceiveBlobMessageRequest::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::asf::core::Blob& ReceiveBlobMessageRequest::getMessage () const {
    if (_message == NULL) {
        return ::asf::core::theEmptyBlob;
    }
    return *_message;
}

inline ::asf::core::Blob& ReceiveBlobMessageRequest::getMessageMutable () {
    set_has_message();
    if (_message == NULL) {
        _message = new ::asf::core::Blob ();
        CHECK_ALLOCATION( _message );
    }
    return *_message;
}

inline void ReceiveBlobMessageRequest::setMessage (const ::asf::core::Blob& message_) {
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::asf::core::Blob (message_);
        CHECK_ALLOCATION( this->_message );
    } else {
        *this->_message = message_;
    }
}

inline ::asf::core::Blob* ReceiveBlobMessageRequest::releaseMessage() {
    clear_has_message();
    ::asf::core::Blob* temp = _message;
    this->_message = NULL;
    return temp;
}

inline void ReceiveBlobMessageRequest::replaceMessage (::asf::core::Blob* message_) {
    set_has_message();
    if (this->_message != message_) {
        if (this->_message != NULL) {
            delete this->_message;
        }
        this->_message = message_;
    }
}

inline void ReceiveBlobMessageRequest::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReceiveBlobMessageRequest::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace BlobMessageReceiver
} // namespace MessageTunnelService

#endif // MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
