/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesDBus.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesJson.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesStub.h"
#include <map>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace SoundProperties {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/masteraudioservice/bosch/cm/ai/hmi/masteraudioservice/SoundProperties", SoundPropertiesStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "setMuteState", 0 },
    { 13, "setAudioState", 1 },
    { 17, "SetSystemProperty", 3 },
    { 24, "setMainSinkSoundProperty", 2 },
    { 25, "RequestSystemPropertyList", 5 },
    { 32, "RequestMainSinkSoundPropertyList", 4 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 6, "volume", 0 },
    { 9, "muteState", 2 },
    { 9, "volumeMap", 1 },
    { 12, "muteStateMap", 3 },
    { 14, "audioStateInfo", 4 },
    { 17, "audioStateInfoMap", 5 },
    { 17, "soundPropertyList", 7 },
    { 18, "systemPropertyList", 6 },
};

class SoundPropertiesStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SoundPropertiesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SoundPropertiesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SoundPropertiesStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.masteraudioservice.SoundProperties"),
          _logger(logger) {}

    virtual ~SoundPropertiesStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SoundPropertiesStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'setMuteState'

            LOG_DEBUG_STUB("process method '%s'", "setMuteState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMuteStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMuteState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMuteStateRequest > payload = ::boost::static_pointer_cast<SetMuteStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onSetMuteStateRequest(payload);
            return;
        }
        case 1: {

            // method 'setAudioState'

            LOG_DEBUG_STUB("process method '%s'", "setAudioState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAudioStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetAudioState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetAudioStateRequest > payload = ::boost::static_pointer_cast<SetAudioStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onSetAudioStateRequest(payload);
            return;
        }
        case 2: {

            // method 'setMainSinkSoundProperty'

            LOG_DEBUG_STUB("process method '%s'", "setMainSinkSoundProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMainSinkSoundProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMainSinkSoundPropertyRequest > payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onSetMainSinkSoundPropertyRequest(payload);
            return;
        }
        case 3: {

            // method 'SetSystemProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetSystemProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSystemProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSystemPropertyRequest > payload = ::boost::static_pointer_cast<SetSystemPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onSetSystemPropertyRequest(payload);
            return;
        }
        case 4: {

            // method 'RequestMainSinkSoundPropertyList'

            LOG_DEBUG_STUB("process method '%s'", "RequestMainSinkSoundPropertyList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestMainSinkSoundPropertyListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestMainSinkSoundPropertyList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestMainSinkSoundPropertyListRequest > payload = ::boost::static_pointer_cast<RequestMainSinkSoundPropertyListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onRequestMainSinkSoundPropertyListRequest(payload);
            return;
        }
        case 5: {

            // method 'RequestSystemPropertyList'

            LOG_DEBUG_STUB("process method '%s'", "RequestSystemPropertyList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestSystemPropertyListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestSystemPropertyList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestSystemPropertyListRequest > payload = ::boost::static_pointer_cast<RequestSystemPropertyListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SoundPropertiesStub*>(getStub())->onRequestSystemPropertyListRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SoundPropertiesStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.masteraudioservice.SoundProperties\">\n"
            "    <property access=\"read\" name=\"volume\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"volumeMap\" type=\"a{qy}\"/>\n"
            "    <property access=\"read\" name=\"muteState\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"muteStateMap\" type=\"a{qb}\"/>\n"
            "    <property access=\"read\" name=\"audioStateInfo\" type=\"(bb)\"/>\n"
            "    <property access=\"read\" name=\"audioStateInfoMap\" type=\"a{q(bb)}\"/>\n"
            "    <property access=\"read\" name=\"systemPropertyList\" type=\"a(ii)\"/>\n"
            "    <property access=\"read\" name=\"soundPropertyList\" type=\"(a(ii)q)\"/>\n"
            "    <method name=\"setMuteState\">\n"
            "      <doc>\n"
            "        <line>setMuteState = Method to activate or deactivate mute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"muteState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>muteState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setAudioState\">\n"
            "      <doc>\n"
            "        <line>setAudioState = Method to activate or deactivate audio off for main sink</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"audioState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>audioState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setMainSinkSoundProperty\">\n"
            "      <doc>\n"
            "        <line>setMainSinkSoundProperty = Method for Converting static sink ID to dynamic and send the same to Audio</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"PropertyType\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>PropertyType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"value\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetSystemProperty\">\n"
            "      <doc>\n"
            "        <line>SetSystemProperty = Method for setting system property</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"propertyType\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>propertyType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"value\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestMainSinkSoundPropertyList\">\n"
            "      <doc>\n"
            "        <line>RequestMainSinkSoundPropertyList = Method for requesting List of MainSinkSoundProperties</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestSystemPropertyList\">\n"
            "      <doc>\n"
            "        <line>RequestSystemPropertyList = Method for requesting List of System properties</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <signal name=\"MainSinkSoundPropertyChanged\">\n"
            "      <doc>\n"
            "        <line>MainSinkSoundPropertyChanged = Signal to indicate that there is a change in MainSinkSoundProperty</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"PropertyType\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>PropertyType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"value\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SystemPropertyChanged\">\n"
            "      <doc>\n"
            "        <line>SystemPropertyChanged = Signal to indicate that there is a change in SystemProperty</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"PropertyType\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>PropertyType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"value\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void SoundPropertiesStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SoundPropertiesStub*>(getStub()))->onGetAll (properties);
}

void SoundPropertiesStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "volume");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "volumeMap");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "muteState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "muteStateMap");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "audioStateInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "audioStateInfoMap");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "systemPropertyList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "soundPropertyList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SoundPropertiesStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "volume");
            ::boost::shared_ptr< VolumeGet > payload(new VolumeGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onVolumeGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "volumeMap");
            ::boost::shared_ptr< VolumeMapGet > payload(new VolumeMapGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onVolumeMapGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "muteState");
            ::boost::shared_ptr< MuteStateGet > payload(new MuteStateGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onMuteStateGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "muteStateMap");
            ::boost::shared_ptr< MuteStateMapGet > payload(new MuteStateMapGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onMuteStateMapGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "audioStateInfo");
            ::boost::shared_ptr< AudioStateInfoGet > payload(new AudioStateInfoGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onAudioStateInfoGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "audioStateInfoMap");
            ::boost::shared_ptr< AudioStateInfoMapGet > payload(new AudioStateInfoMapGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onAudioStateInfoMapGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "systemPropertyList");
            ::boost::shared_ptr< SystemPropertyListGet > payload(new SystemPropertyListGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onSystemPropertyListGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "soundPropertyList");
            ::boost::shared_ptr< SoundPropertyListGet > payload(new SoundPropertyListGet());
            payload->setAct(act);
            static_cast<SoundPropertiesStub*>(getStub())->onSoundPropertyListGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SoundPropertiesStub::SoundPropertiesStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SoundPropertiesStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SoundPropertiesStub::SoundPropertiesStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SoundPropertiesStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SoundPropertiesStub::~SoundPropertiesStub() {
    delete _stubDelegate;
}

void SoundPropertiesStub::sendMainSinkSoundPropertyChangedSignal(int32 propertyType, int32 value, uint16 sinkId) {
    if (_stubDelegate->isConnected()) {
        MainSinkSoundPropertyChangedSignal* payload = new MainSinkSoundPropertyChangedSignal(propertyType, value, sinkId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MainSinkSoundPropertyChanged", MainSinkSoundPropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "MainSinkSoundPropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MainSinkSoundPropertyChanged");
    }
}

void SoundPropertiesStub::sendSystemPropertyChangedSignal(int32 propertyType, int32 value) {
    if (_stubDelegate->isConnected()) {
        SystemPropertyChangedSignal* payload = new SystemPropertyChangedSignal(propertyType, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SystemPropertyChanged", SystemPropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SystemPropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SystemPropertyChanged");
    }
}

void SoundPropertiesStub::sendVolumeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VolumeUpdate payload(_volumeProperty);

        LOG_INFO ("-> send%s", "VolumeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("volume", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VolumeUpdate");
    }
}

void SoundPropertiesStub::onVolumeGet(const ::boost::shared_ptr< VolumeGet >& volume) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VolumeGet", volume->getAct());
    sendVolumeGetUpdate(_volumeProperty.getVolume(), volume->getAct());
}

void SoundPropertiesStub::sendVolumeGetUpdate(uint8 volume, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VolumeGet payload(volume);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VolumeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setVolume(uint8 volume) {
    if(volume!=_volumeProperty.getVolume()) {
        _volumeProperty.setVolume(volume);
        sendVolumeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 SoundPropertiesStub::getVolume() const {
    return _volumeProperty.getVolume();
}

void SoundPropertiesStub::sendVolumeMapUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VolumeMapUpdate payload(_volumeMapProperty);

        LOG_INFO ("-> send%s", "VolumeMapUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("volumeMap", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VolumeMapUpdate");
    }
}

void SoundPropertiesStub::onVolumeMapGet(const ::boost::shared_ptr< VolumeMapGet >& volumeMap) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VolumeMapGet", volumeMap->getAct());
    sendVolumeMapGetUpdate(_volumeMapProperty.getVolumeMap(), volumeMap->getAct());
}

void SoundPropertiesStub::sendVolumeMapGetUpdate(const ::std::map< uint16, uint8 >& volumeMap, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VolumeMapGet payload(volumeMap);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VolumeMapGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setVolumeMap(const ::std::map< uint16, uint8 >& volumeMap) {
    if(volumeMap!=_volumeMapProperty.getVolumeMap()) {
        _volumeMapProperty.setVolumeMap(volumeMap);
        sendVolumeMapUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< uint16, uint8 >& SoundPropertiesStub::getVolumeMap() const {
    return _volumeMapProperty.getVolumeMap();
}

::std::map< uint16, uint8 >& SoundPropertiesStub::getVolumeMapMutable() {
    return _volumeMapProperty.getVolumeMapMutable();
}

void SoundPropertiesStub::sendMuteStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MuteStateUpdate payload(_muteStateProperty);

        LOG_INFO ("-> send%s", "MuteStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("muteState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MuteStateUpdate");
    }
}

void SoundPropertiesStub::onMuteStateGet(const ::boost::shared_ptr< MuteStateGet >& muteState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MuteStateGet", muteState->getAct());
    sendMuteStateGetUpdate(_muteStateProperty.getMuteState(), muteState->getAct());
}

void SoundPropertiesStub::sendMuteStateGetUpdate(bool muteState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MuteStateGet payload(muteState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MuteStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setMuteState(bool muteState) {
    if(muteState!=_muteStateProperty.getMuteState()) {
        _muteStateProperty.setMuteState(muteState);
        sendMuteStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SoundPropertiesStub::getMuteState() const {
    return _muteStateProperty.getMuteState();
}

void SoundPropertiesStub::sendMuteStateMapUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MuteStateMapUpdate payload(_muteStateMapProperty);

        LOG_INFO ("-> send%s", "MuteStateMapUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("muteStateMap", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MuteStateMapUpdate");
    }
}

void SoundPropertiesStub::onMuteStateMapGet(const ::boost::shared_ptr< MuteStateMapGet >& muteStateMap) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MuteStateMapGet", muteStateMap->getAct());
    sendMuteStateMapGetUpdate(_muteStateMapProperty.getMuteStateMap(), muteStateMap->getAct());
}

void SoundPropertiesStub::sendMuteStateMapGetUpdate(const ::std::map< uint16, bool >& muteStateMap, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MuteStateMapGet payload(muteStateMap);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MuteStateMapGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setMuteStateMap(const ::std::map< uint16, bool >& muteStateMap) {
    if(muteStateMap!=_muteStateMapProperty.getMuteStateMap()) {
        _muteStateMapProperty.setMuteStateMap(muteStateMap);
        sendMuteStateMapUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< uint16, bool >& SoundPropertiesStub::getMuteStateMap() const {
    return _muteStateMapProperty.getMuteStateMap();
}

::std::map< uint16, bool >& SoundPropertiesStub::getMuteStateMapMutable() {
    return _muteStateMapProperty.getMuteStateMapMutable();
}

void SoundPropertiesStub::sendAudioStateInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AudioStateInfoUpdate payload(_audioStateInfoProperty);

        LOG_INFO ("-> send%s", "AudioStateInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("audioStateInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AudioStateInfoUpdate");
    }
}

void SoundPropertiesStub::onAudioStateInfoGet(const ::boost::shared_ptr< AudioStateInfoGet >& audioStateInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AudioStateInfoGet", audioStateInfo->getAct());
    sendAudioStateInfoGetUpdate(_audioStateInfoProperty.getAudioStateInfo(), audioStateInfo->getAct());
}

void SoundPropertiesStub::sendAudioStateInfoGetUpdate(const AudioStateInfo& audioStateInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AudioStateInfoGet payload(audioStateInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AudioStateInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setAudioStateInfo(const AudioStateInfo& audioStateInfo) {
    if(audioStateInfo!=_audioStateInfoProperty.getAudioStateInfo()) {
        _audioStateInfoProperty.setAudioStateInfo(audioStateInfo);
        sendAudioStateInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const AudioStateInfo& SoundPropertiesStub::getAudioStateInfo() const {
    return _audioStateInfoProperty.getAudioStateInfo();
}

AudioStateInfo& SoundPropertiesStub::getAudioStateInfoMutable() {
    return _audioStateInfoProperty.getAudioStateInfoMutable();
}

void SoundPropertiesStub::sendAudioStateInfoMapUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AudioStateInfoMapUpdate payload(_audioStateInfoMapProperty);

        LOG_INFO ("-> send%s", "AudioStateInfoMapUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("audioStateInfoMap", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AudioStateInfoMapUpdate");
    }
}

void SoundPropertiesStub::onAudioStateInfoMapGet(const ::boost::shared_ptr< AudioStateInfoMapGet >& audioStateInfoMap) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AudioStateInfoMapGet", audioStateInfoMap->getAct());
    sendAudioStateInfoMapGetUpdate(_audioStateInfoMapProperty.getAudioStateInfoMap(), audioStateInfoMap->getAct());
}

void SoundPropertiesStub::sendAudioStateInfoMapGetUpdate(const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AudioStateInfoMapGet payload(audioStateInfoMap);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AudioStateInfoMapGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setAudioStateInfoMap(const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap) {
    if(audioStateInfoMap!=_audioStateInfoMapProperty.getAudioStateInfoMap()) {
        _audioStateInfoMapProperty.setAudioStateInfoMap(audioStateInfoMap);
        sendAudioStateInfoMapUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< uint16, AudioStateInfo >& SoundPropertiesStub::getAudioStateInfoMap() const {
    return _audioStateInfoMapProperty.getAudioStateInfoMap();
}

::std::map< uint16, AudioStateInfo >& SoundPropertiesStub::getAudioStateInfoMapMutable() {
    return _audioStateInfoMapProperty.getAudioStateInfoMapMutable();
}

void SoundPropertiesStub::sendSystemPropertyListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemPropertyListUpdate payload(_systemPropertyListProperty);

        LOG_INFO ("-> send%s", "SystemPropertyListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("systemPropertyList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemPropertyListUpdate");
    }
}

void SoundPropertiesStub::onSystemPropertyListGet(const ::boost::shared_ptr< SystemPropertyListGet >& systemPropertyList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemPropertyListGet", systemPropertyList->getAct());
    sendSystemPropertyListGetUpdate(_systemPropertyListProperty.getSystemPropertyList(), systemPropertyList->getAct());
}

void SoundPropertiesStub::sendSystemPropertyListGetUpdate(const ::std::vector< SystemProperty >& systemPropertyList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemPropertyListGet payload(systemPropertyList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemPropertyListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setSystemPropertyList(const ::std::vector< SystemProperty >& systemPropertyList) {
    if(systemPropertyList!=_systemPropertyListProperty.getSystemPropertyList()) {
        _systemPropertyListProperty.setSystemPropertyList(systemPropertyList);
        sendSystemPropertyListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< SystemProperty >& SoundPropertiesStub::getSystemPropertyList() const {
    return _systemPropertyListProperty.getSystemPropertyList();
}

::std::vector< SystemProperty >& SoundPropertiesStub::getSystemPropertyListMutable() {
    return _systemPropertyListProperty.getSystemPropertyListMutable();
}

void SoundPropertiesStub::sendSoundPropertyListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SoundPropertyListUpdate payload(_soundPropertyListProperty);

        LOG_INFO ("-> send%s", "SoundPropertyListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("soundPropertyList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SoundPropertyListUpdate");
    }
}

void SoundPropertiesStub::onSoundPropertyListGet(const ::boost::shared_ptr< SoundPropertyListGet >& soundPropertyList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SoundPropertyListGet", soundPropertyList->getAct());
    sendSoundPropertyListGetUpdate(_soundPropertyListProperty.getSoundPropertyList(), soundPropertyList->getAct());
}

void SoundPropertiesStub::sendSoundPropertyListGetUpdate(const SoundPropertyData& soundPropertyList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SoundPropertyListGet payload(soundPropertyList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SoundPropertyListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SoundPropertiesStub::setSoundPropertyList(const SoundPropertyData& soundPropertyList) {
    if(soundPropertyList!=_soundPropertyListProperty.getSoundPropertyList()) {
        _soundPropertyListProperty.setSoundPropertyList(soundPropertyList);
        sendSoundPropertyListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SoundPropertyData& SoundPropertiesStub::getSoundPropertyList() const {
    return _soundPropertyListProperty.getSoundPropertyList();
}

SoundPropertyData& SoundPropertiesStub::getSoundPropertyListMutable() {
    return _soundPropertyListProperty.getSoundPropertyListMutable();
}

void  SoundPropertiesStub::sendSetMuteStateResponse (act_t act) {
    SetMuteStateResponse* payload = new SetMuteStateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setMuteState", SetMuteStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMuteStateError* payload = new SetMuteStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setMuteState", SetMuteStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetAudioStateResponse (act_t act) {
    SetAudioStateResponse* payload = new SetAudioStateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setAudioState", SetAudioStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetAudioState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetAudioStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetAudioStateError* payload = new SetAudioStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setAudioState", SetAudioStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetAudioState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetMainSinkSoundPropertyResponse (act_t act) {
    SetMainSinkSoundPropertyResponse* payload = new SetMainSinkSoundPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setMainSinkSoundProperty", SetMainSinkSoundPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMainSinkSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetMainSinkSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMainSinkSoundPropertyError* payload = new SetMainSinkSoundPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setMainSinkSoundProperty", SetMainSinkSoundPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMainSinkSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetSystemPropertyResponse (act_t act) {
    SetSystemPropertyResponse* payload = new SetSystemPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetSystemProperty", SetSystemPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSystemProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SoundPropertiesStub::sendSetSystemPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSystemPropertyError* payload = new SetSystemPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetSystemProperty", SetSystemPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSystemProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}



void SoundPropertiesStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'volume'
    {
        ::asf::dbus::DBusVariant variant;
        VolumeGet payload(_volumeProperty.getVolume());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("volume", variant));
    }

    //property 'volumeMap'
    {
        ::asf::dbus::DBusVariant variant;
        VolumeMapGet payload(_volumeMapProperty.getVolumeMap());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("volumeMap", variant));
    }

    //property 'muteState'
    {
        ::asf::dbus::DBusVariant variant;
        MuteStateGet payload(_muteStateProperty.getMuteState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("muteState", variant));
    }

    //property 'muteStateMap'
    {
        ::asf::dbus::DBusVariant variant;
        MuteStateMapGet payload(_muteStateMapProperty.getMuteStateMap());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("muteStateMap", variant));
    }

    //property 'audioStateInfo'
    {
        ::asf::dbus::DBusVariant variant;
        AudioStateInfoGet payload(_audioStateInfoProperty.getAudioStateInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("audioStateInfo", variant));
    }

    //property 'audioStateInfoMap'
    {
        ::asf::dbus::DBusVariant variant;
        AudioStateInfoMapGet payload(_audioStateInfoMapProperty.getAudioStateInfoMap());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("audioStateInfoMap", variant));
    }

    //property 'systemPropertyList'
    {
        ::asf::dbus::DBusVariant variant;
        SystemPropertyListGet payload(_systemPropertyListProperty.getSystemPropertyList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("systemPropertyList", variant));
    }

    //property 'soundPropertyList'
    {
        ::asf::dbus::DBusVariant variant;
        SoundPropertyListGet payload(_soundPropertyListProperty.getSoundPropertyList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("soundPropertyList", variant));
    }
}

} // namespace SoundProperties
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
