/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESPROXY_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <map>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace SoundProperties {

class SoundPropertiesProxy;

class AudioStateInfoCallbackIF {
public:
    virtual ~AudioStateInfoCallbackIF() {}

    virtual void onAudioStateInfoError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AudioStateInfoError >& error) = 0;

    virtual void onAudioStateInfoUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AudioStateInfoUpdate >& update) = 0;
};

class AudioStateInfoMapCallbackIF {
public:
    virtual ~AudioStateInfoMapCallbackIF() {}

    virtual void onAudioStateInfoMapError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AudioStateInfoMapError >& error) = 0;

    virtual void onAudioStateInfoMapUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AudioStateInfoMapUpdate >& update) = 0;
};

class MainSinkSoundPropertyChangedCallbackIF {
public:
    virtual ~MainSinkSoundPropertyChangedCallbackIF() {}

    virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MainSinkSoundPropertyChangedError >& error) = 0;

    virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MainSinkSoundPropertyChangedSignal >& signal) = 0;
};

class MuteStateCallbackIF {
public:
    virtual ~MuteStateCallbackIF() {}

    virtual void onMuteStateError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MuteStateError >& error) = 0;

    virtual void onMuteStateUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MuteStateUpdate >& update) = 0;
};

class MuteStateMapCallbackIF {
public:
    virtual ~MuteStateMapCallbackIF() {}

    virtual void onMuteStateMapError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MuteStateMapError >& error) = 0;

    virtual void onMuteStateMapUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< MuteStateMapUpdate >& update) = 0;
};

class SetAudioStateCallbackIF {
public:
    virtual ~SetAudioStateCallbackIF() {}

    virtual void onSetAudioStateError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetAudioStateError >& error) = 0;

    virtual void onSetAudioStateResponse(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetAudioStateResponse >& response) = 0;
};

class SetMainSinkSoundPropertyCallbackIF {
public:
    virtual ~SetMainSinkSoundPropertyCallbackIF() {}

    virtual void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetMainSinkSoundPropertyError >& error) = 0;

    virtual void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetMainSinkSoundPropertyResponse >& response) = 0;
};

class SetMuteStateCallbackIF {
public:
    virtual ~SetMuteStateCallbackIF() {}

    virtual void onSetMuteStateError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetMuteStateError >& error) = 0;

    virtual void onSetMuteStateResponse(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetMuteStateResponse >& response) = 0;
};

class SetSystemPropertyCallbackIF {
public:
    virtual ~SetSystemPropertyCallbackIF() {}

    virtual void onSetSystemPropertyError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyError >& error) = 0;

    virtual void onSetSystemPropertyResponse(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyResponse >& response) = 0;
};

class SoundPropertyListCallbackIF {
public:
    virtual ~SoundPropertyListCallbackIF() {}

    virtual void onSoundPropertyListError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SoundPropertyListError >& error) = 0;

    virtual void onSoundPropertyListUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SoundPropertyListUpdate >& update) = 0;
};

class SystemPropertyChangedCallbackIF {
public:
    virtual ~SystemPropertyChangedCallbackIF() {}

    virtual void onSystemPropertyChangedError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedError >& error) = 0;

    virtual void onSystemPropertyChangedSignal(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedSignal >& signal) = 0;
};

class SystemPropertyListCallbackIF {
public:
    virtual ~SystemPropertyListCallbackIF() {}

    virtual void onSystemPropertyListError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SystemPropertyListError >& error) = 0;

    virtual void onSystemPropertyListUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< SystemPropertyListUpdate >& update) = 0;
};

class VolumeCallbackIF {
public:
    virtual ~VolumeCallbackIF() {}

    virtual void onVolumeError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< VolumeError >& error) = 0;

    virtual void onVolumeUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< VolumeUpdate >& update) = 0;
};

class VolumeMapCallbackIF {
public:
    virtual ~VolumeMapCallbackIF() {}

    virtual void onVolumeMapError(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< VolumeMapError >& error) = 0;

    virtual void onVolumeMapUpdate(const ::boost::shared_ptr< SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< VolumeMapUpdate >& update) = 0;
};


/**
 * SoundPropertiesProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.ai.hmi.masteraudioservice.SoundProperties'
 * (specified in file SoundProperties_.xml).
 *
 * todo
 */
class SoundPropertiesProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SoundPropertiesProxy.
     */
    static ::boost::shared_ptr< SoundPropertiesProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SoundPropertiesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SoundPropertiesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SoundPropertiesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SoundPropertiesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SoundPropertiesProxy > proxyNew(new SoundPropertiesProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~SoundPropertiesProxy ();


    // Signal 'MainSinkSoundPropertyChanged'

    /**
     * Notify on the signal 'MainSinkSoundPropertyChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in MainSinkSoundProperty
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMainSinkSoundPropertyChangedRegister(MainSinkSoundPropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'MainSinkSoundPropertyChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in MainSinkSoundProperty
     *
     * @param act The act which was previously returned by the
     * sendMainSinkSoundPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMainSinkSoundPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'MainSinkSoundPropertyChanged'.
     */
    void sendMainSinkSoundPropertyChangedDeregisterAll () const;

    // Signal 'SystemPropertyChanged'

    /**
     * Notify on the signal 'SystemPropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in SystemProperty
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemPropertyChangedRegister(SystemPropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SystemPropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in SystemProperty
     *
     * @param act The act which was previously returned by the
     * sendSystemPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSystemPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SystemPropertyChanged'.
     */
    void sendSystemPropertyChangedDeregisterAll () const;


    // Property 'volume'

    /**
     * Notify on the property 'volume'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVolumeRegister(VolumeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'volume'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @param act The act which was previously returned by the
     * sendVolumeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVolumeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'volume'.
     */
    void sendVolumeDeregisterAll() const;

    /**
     * Request the value of the property 'volume' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVolumeGet(VolumeCallbackIF& cb);


    /**
     * Returns the current value of the property 'volume' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVolume()
     * returns true.
     *
     * @return the previously received value of the property 'volume'.
     */
    uint8 getVolume() const;

    /**
     * Determines whether a status message for the property 'volume' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVolume() const;

    // Property 'volumeMap'

    /**
     * Notify on the property 'volumeMap'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVolumeMapRegister(VolumeMapCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'volumeMap'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     *
     * @param act The act which was previously returned by the
     * sendVolumeMapRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVolumeMapDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'volumeMap'.
     */
    void sendVolumeMapDeregisterAll() const;

    /**
     * Request the value of the property 'volumeMap' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVolumeMapGet(VolumeMapCallbackIF& cb);


    /**
     * Returns the current value of the property 'volumeMap' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVolumeMap()
     * returns true.
     *
     * @return the previously received value of the property 'volumeMap'.
     */
    const ::std::map< uint16, uint8 >& getVolumeMap() const;

    /**
     * Determines whether a status message for the property 'volumeMap' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVolumeMap() const;

    // Property 'muteState'

    /**
     * Notify on the property 'muteState'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteStateRegister(MuteStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'muteState'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @param act The act which was previously returned by the
     * sendMuteStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMuteStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'muteState'.
     */
    void sendMuteStateDeregisterAll() const;

    /**
     * Request the value of the property 'muteState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteStateGet(MuteStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'muteState' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasMuteState()
     * returns true.
     *
     * @return the previously received value of the property 'muteState'.
     */
    bool getMuteState() const;

    /**
     * Determines whether a status message for the property 'muteState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMuteState() const;

    // Property 'muteStateMap'

    /**
     * Notify on the property 'muteStateMap'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteStateMapRegister(MuteStateMapCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'muteStateMap'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     *
     * @param act The act which was previously returned by the
     * sendMuteStateMapRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMuteStateMapDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'muteStateMap'.
     */
    void sendMuteStateMapDeregisterAll() const;

    /**
     * Request the value of the property 'muteStateMap' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteStateMapGet(MuteStateMapCallbackIF& cb);


    /**
     * Returns the current value of the property 'muteStateMap' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMuteStateMap() returns true.
     *
     * @return the previously received value of the property 'muteStateMap'.
     */
    const ::std::map< uint16, bool >& getMuteStateMap() const;

    /**
     * Determines whether a status message for the property 'muteStateMap' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMuteStateMap() const;

    // Property 'audioStateInfo'

    /**
     * Notify on the property 'audioStateInfo'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioStateInfoRegister(AudioStateInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'audioStateInfo'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @param act The act which was previously returned by the
     * sendAudioStateInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAudioStateInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'audioStateInfo'.
     */
    void sendAudioStateInfoDeregisterAll() const;

    /**
     * Request the value of the property 'audioStateInfo' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioStateInfoGet(AudioStateInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'audioStateInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAudioStateInfo() returns true.
     *
     * @return the previously received value of the property 'audioStateInfo'.
     */
    const AudioStateInfo& getAudioStateInfo() const;

    /**
     * Determines whether a status message for the property 'audioStateInfo'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAudioStateInfo() const;

    // Property 'audioStateInfoMap'

    /**
     * Notify on the property 'audioStateInfoMap'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioStateInfoMapRegister(AudioStateInfoMapCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'audioStateInfoMap'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     *
     * @param act The act which was previously returned by the
     * sendAudioStateInfoMapRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAudioStateInfoMapDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'audioStateInfoMap'.
     */
    void sendAudioStateInfoMapDeregisterAll() const;

    /**
     * Request the value of the property 'audioStateInfoMap' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioStateInfoMapGet(AudioStateInfoMapCallbackIF& cb);


    /**
     * Returns the current value of the property 'audioStateInfoMap' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAudioStateInfoMap() returns true.
     *
     * @return the previously received value of the property 'audioStateInfoMap'.
     */
    const ::std::map< uint16, AudioStateInfo >& getAudioStateInfoMap() const;

    /**
     * Determines whether a status message for the property
     * 'audioStateInfoMap' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAudioStateInfoMap() const;

    // Property 'systemPropertyList'

    /**
     * Notify on the property 'systemPropertyList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemPropertyListRegister(SystemPropertyListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'systemPropertyList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     *
     * @param act The act which was previously returned by the
     * sendSystemPropertyListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSystemPropertyListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'systemPropertyList'.
     */
    void sendSystemPropertyListDeregisterAll() const;

    /**
     * Request the value of the property 'systemPropertyList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemPropertyListGet(SystemPropertyListCallbackIF& cb);


    /**
     * Returns the current value of the property 'systemPropertyList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSystemPropertyList() returns true.
     *
     * @return the previously received value of the property 'systemPropertyList'.
     */
    const ::std::vector< SystemProperty >& getSystemPropertyList() const;

    /**
     * Determines whether a status message for the property
     * 'systemPropertyList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemPropertyList() const;

    // Property 'soundPropertyList'

    /**
     * Notify on the property 'soundPropertyList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoundPropertyListRegister(SoundPropertyListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'soundPropertyList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     *
     * @param act The act which was previously returned by the
     * sendSoundPropertyListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSoundPropertyListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'soundPropertyList'.
     */
    void sendSoundPropertyListDeregisterAll() const;

    /**
     * Request the value of the property 'soundPropertyList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoundPropertyListGet(SoundPropertyListCallbackIF& cb);


    /**
     * Returns the current value of the property 'soundPropertyList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSoundPropertyList() returns true.
     *
     * @return the previously received value of the property 'soundPropertyList'.
     */
    const SoundPropertyData& getSoundPropertyList() const;

    /**
     * Determines whether a status message for the property
     * 'soundPropertyList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSoundPropertyList() const;


    // Method 'setMuteState'

    /**
     * Call the method 'setMuteState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setMuteState'</b>:
     *
     * Method to activate or deactivate mute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param muteState If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMuteStateRequest(SetMuteStateCallbackIF& cb, bool muteState, uint16 sinkId) const;

    // Method 'setAudioState'

    /**
     * Call the method 'setAudioState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setAudioState'</b>:
     *
     * Method to activate or deactivate audio off for main sink
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param audioState If the meaning of "audioState" isn't clear, then there should be a description here.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAudioStateRequest(SetAudioStateCallbackIF& cb, bool audioState, uint16 sinkId) const;

    // Method 'setMainSinkSoundProperty'

    /**
     * Call the method 'setMainSinkSoundProperty'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'setMainSinkSoundProperty'</b>:
     *
     * Method for Converting static sink ID to dynamic and send the same to Audio
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param PropertyType If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMainSinkSoundPropertyRequest(SetMainSinkSoundPropertyCallbackIF& cb, uint16 propertyType, int32 value, uint16 sinkId) const;

    // Method 'SetSystemProperty'

    /**
     * Call the method 'SetSystemProperty'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Method for setting system property
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param propertyType If the meaning of "propertyType" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetSystemPropertyRequest(SetSystemPropertyCallbackIF& cb, uint16 propertyType, int32 value) const;

    // Method 'RequestMainSinkSoundPropertyList'

    /**
     * Call the method 'RequestMainSinkSoundPropertyList'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RequestMainSinkSoundPropertyList'</b>:
     *
     * Method for requesting List of MainSinkSoundProperties
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestMainSinkSoundPropertyListRequest(uint16 sinkId) const;

    // Method 'RequestSystemPropertyList'

    /**
     * Call the method 'RequestSystemPropertyList'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RequestSystemPropertyList'</b>:
     *
     * Method for requesting List of System properties
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSystemPropertyListRequest() const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SoundPropertiesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'volume'

    ::asf::core::nullable< VolumeUpdate > _volume;

    // Property 'volumeMap'

    ::asf::core::nullable< VolumeMapUpdate > _volumeMap;

    // Property 'muteState'

    ::asf::core::nullable< MuteStateUpdate > _muteState;

    // Property 'muteStateMap'

    ::asf::core::nullable< MuteStateMapUpdate > _muteStateMap;

    // Property 'audioStateInfo'

    ::asf::core::nullable< AudioStateInfoUpdate > _audioStateInfo;

    // Property 'audioStateInfoMap'

    ::asf::core::nullable< AudioStateInfoMapUpdate > _audioStateInfoMap;

    // Property 'systemPropertyList'

    ::asf::core::nullable< SystemPropertyListUpdate > _systemPropertyList;

    // Property 'soundPropertyList'

    ::asf::core::nullable< SoundPropertyListUpdate > _soundPropertyList;

    DECLARE_CLASS_LOGGER();

    friend class SoundPropertiesProxyCallback;
};

} // namespace SoundProperties
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESPROXY_H
