/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesDBus.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesJson.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include <map>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace SoundProperties {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/masteraudioservice/bosch/cm/ai/hmi/masteraudioservice/SoundProperties", SoundPropertiesProxy);

class SoundPropertiesProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SoundPropertiesProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SoundPropertiesProxy >& proxyShared = ::boost::static_pointer_cast< SoundPropertiesProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_MainSinkSoundPropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainSinkSoundPropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainSinkSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MainSinkSoundPropertyChangedSignal> payload = ::boost::static_pointer_cast<MainSinkSoundPropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MainSinkSoundPropertyChangedCallbackIF*) _callback)->onMainSinkSoundPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SystemPropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemPropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemPropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SystemPropertyChangedSignal> payload = ::boost::static_pointer_cast<SystemPropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SystemPropertyChangedCallbackIF*) _callback)->onSystemPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_volume:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Volume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeError> payload = ::boost::static_pointer_cast<VolumeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VolumeCallbackIF*) _callback)->onVolumeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Volume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeUpdate> payload = ::boost::static_pointer_cast<VolumeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VolumeCallbackIF*) _callback)->onVolumeUpdate(proxyShared, payload);
                        proxyShared->_volume = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_volumeMap:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeMapError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VolumeMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeMapError> payload = ::boost::static_pointer_cast<VolumeMapError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VolumeMapCallbackIF*) _callback)->onVolumeMapError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VolumeMapUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VolumeMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VolumeMapUpdate> payload = ::boost::static_pointer_cast<VolumeMapUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VolumeMapCallbackIF*) _callback)->onVolumeMapUpdate(proxyShared, payload);
                        proxyShared->_volumeMap = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_muteState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateError> payload = ::boost::static_pointer_cast<MuteStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MuteStateCallbackIF*) _callback)->onMuteStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateUpdate> payload = ::boost::static_pointer_cast<MuteStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MuteStateCallbackIF*) _callback)->onMuteStateUpdate(proxyShared, payload);
                        proxyShared->_muteState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_muteStateMap:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateMapError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MuteStateMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateMapError> payload = ::boost::static_pointer_cast<MuteStateMapError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MuteStateMapCallbackIF*) _callback)->onMuteStateMapError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateMapUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MuteStateMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateMapUpdate> payload = ::boost::static_pointer_cast<MuteStateMapUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MuteStateMapCallbackIF*) _callback)->onMuteStateMapUpdate(proxyShared, payload);
                        proxyShared->_muteStateMap = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_audioStateInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioStateInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudioStateInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioStateInfoError> payload = ::boost::static_pointer_cast<AudioStateInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AudioStateInfoCallbackIF*) _callback)->onAudioStateInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioStateInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudioStateInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioStateInfoUpdate> payload = ::boost::static_pointer_cast<AudioStateInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AudioStateInfoCallbackIF*) _callback)->onAudioStateInfoUpdate(proxyShared, payload);
                        proxyShared->_audioStateInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_audioStateInfoMap:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioStateInfoMapError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudioStateInfoMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioStateInfoMapError> payload = ::boost::static_pointer_cast<AudioStateInfoMapError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AudioStateInfoMapCallbackIF*) _callback)->onAudioStateInfoMapError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioStateInfoMapUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AudioStateInfoMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioStateInfoMapUpdate> payload = ::boost::static_pointer_cast<AudioStateInfoMapUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AudioStateInfoMapCallbackIF*) _callback)->onAudioStateInfoMapUpdate(proxyShared, payload);
                        proxyShared->_audioStateInfoMap = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_systemPropertyList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemPropertyListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemPropertyList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemPropertyListError> payload = ::boost::static_pointer_cast<SystemPropertyListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemPropertyListCallbackIF*) _callback)->onSystemPropertyListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemPropertyListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemPropertyList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemPropertyListUpdate> payload = ::boost::static_pointer_cast<SystemPropertyListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemPropertyListCallbackIF*) _callback)->onSystemPropertyListUpdate(proxyShared, payload);
                        proxyShared->_systemPropertyList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_soundPropertyList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SoundPropertyListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SoundPropertyList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SoundPropertyListError> payload = ::boost::static_pointer_cast<SoundPropertyListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SoundPropertyListCallbackIF*) _callback)->onSoundPropertyListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SoundPropertyListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SoundPropertyList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SoundPropertyListUpdate> payload = ::boost::static_pointer_cast<SoundPropertyListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SoundPropertyListCallbackIF*) _callback)->onSoundPropertyListUpdate(proxyShared, payload);
                        proxyShared->_soundPropertyList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_setMuteState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMuteStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMuteStateError> payload = ::boost::static_pointer_cast<SetMuteStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMuteStateCallbackIF*) _callback)->onSetMuteStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMuteStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMuteStateResponse> payload = ::boost::static_pointer_cast<SetMuteStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMuteStateCallbackIF*) _callback)->onSetMuteStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setAudioState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetAudioStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAudioState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAudioStateError> payload = ::boost::static_pointer_cast<SetAudioStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAudioStateCallbackIF*) _callback)->onSetAudioStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAudioStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAudioState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAudioStateResponse> payload = ::boost::static_pointer_cast<SetAudioStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAudioStateCallbackIF*) _callback)->onSetAudioStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setMainSinkSoundProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSinkSoundPropertyError> payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMainSinkSoundPropertyResponse> payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetSystemProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSystemPropertyError> payload = ::boost::static_pointer_cast<SetSystemPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSystemPropertyResponse> payload = ::boost::static_pointer_cast<SetSystemPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_MainSinkSoundPropertyChanged: {
                ::boost::shared_ptr< MainSinkSoundPropertyChangedError > payload = ::boost::shared_ptr< MainSinkSoundPropertyChangedError >
                (new MainSinkSoundPropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MainSinkSoundPropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MainSinkSoundPropertyChangedCallbackIF*) _callback)->onMainSinkSoundPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemPropertyChanged: {
                ::boost::shared_ptr< SystemPropertyChangedError > payload = ::boost::shared_ptr< SystemPropertyChangedError >
                (new SystemPropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemPropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemPropertyChangedCallbackIF*) _callback)->onSystemPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_volume: {
                ::boost::shared_ptr< VolumeError > payload = ::boost::shared_ptr< VolumeError >
                (new VolumeError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Volume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VolumeCallbackIF*) _callback)->onVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_volumeMap: {
                ::boost::shared_ptr< VolumeMapError > payload = ::boost::shared_ptr< VolumeMapError >
                (new VolumeMapError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VolumeMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VolumeMapCallbackIF*) _callback)->onVolumeMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_muteState: {
                ::boost::shared_ptr< MuteStateError > payload = ::boost::shared_ptr< MuteStateError >
                (new MuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MuteStateCallbackIF*) _callback)->onMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_muteStateMap: {
                ::boost::shared_ptr< MuteStateMapError > payload = ::boost::shared_ptr< MuteStateMapError >
                (new MuteStateMapError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MuteStateMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MuteStateMapCallbackIF*) _callback)->onMuteStateMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_audioStateInfo: {
                ::boost::shared_ptr< AudioStateInfoError > payload = ::boost::shared_ptr< AudioStateInfoError >
                (new AudioStateInfoError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudioStateInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudioStateInfoCallbackIF*) _callback)->onAudioStateInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_audioStateInfoMap: {
                ::boost::shared_ptr< AudioStateInfoMapError > payload = ::boost::shared_ptr< AudioStateInfoMapError >
                (new AudioStateInfoMapError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudioStateInfoMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudioStateInfoMapCallbackIF*) _callback)->onAudioStateInfoMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_systemPropertyList: {
                ::boost::shared_ptr< SystemPropertyListError > payload = ::boost::shared_ptr< SystemPropertyListError >
                (new SystemPropertyListError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemPropertyList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemPropertyListCallbackIF*) _callback)->onSystemPropertyListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_soundPropertyList: {
                ::boost::shared_ptr< SoundPropertyListError > payload = ::boost::shared_ptr< SoundPropertyListError >
                (new SoundPropertyListError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SoundPropertyList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SoundPropertyListCallbackIF*) _callback)->onSoundPropertyListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setMuteState: {
                ::boost::shared_ptr< SetMuteStateError > payload = ::boost::shared_ptr< SetMuteStateError >
                (new SetMuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMuteStateCallbackIF*) _callback)->onSetMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setAudioState: {
                ::boost::shared_ptr< SetAudioStateError > payload = ::boost::shared_ptr< SetAudioStateError >
                (new SetAudioStateError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetAudioState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetAudioStateCallbackIF*) _callback)->onSetAudioStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setMainSinkSoundProperty: {
                ::boost::shared_ptr< SetMainSinkSoundPropertyError > payload = ::boost::shared_ptr< SetMainSinkSoundPropertyError >
                (new SetMainSinkSoundPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMainSinkSoundProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMainSinkSoundPropertyCallbackIF*) _callback)->onSetMainSinkSoundPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetSystemProperty: {
                ::boost::shared_ptr< SetSystemPropertyError > payload = ::boost::shared_ptr< SetSystemPropertyError >
                (new SetSystemPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service SoundProperties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSystemProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SoundPropertiesProxy> proxyShared = ::boost::static_pointer_cast<SoundPropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSystemPropertyCallbackIF*) _callback)->onSetSystemPropertyError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SoundPropertiesProxyCallback::_logger (SoundPropertiesProxy::_logger);

SoundPropertiesProxy::SoundPropertiesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.masteraudioservice.SoundProperties", serviceAvailable, _logger) {
}

SoundPropertiesProxy::~SoundPropertiesProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SoundPropertiesProxy > SoundPropertiesProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SoundPropertiesProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SoundPropertiesProxy > proxyNew(new SoundPropertiesProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SoundPropertiesProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SoundPropertiesProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SoundPropertiesProxy::clearAllProperties ()
{
    _volume = ::asf::core::nullable< VolumeUpdate >();
    _volumeMap = ::asf::core::nullable< VolumeMapUpdate >();
    _muteState = ::asf::core::nullable< MuteStateUpdate >();
    _muteStateMap = ::asf::core::nullable< MuteStateMapUpdate >();
    _audioStateInfo = ::asf::core::nullable< AudioStateInfoUpdate >();
    _audioStateInfoMap = ::asf::core::nullable< AudioStateInfoMapUpdate >();
    _systemPropertyList = ::asf::core::nullable< SystemPropertyListUpdate >();
    _soundPropertyList = ::asf::core::nullable< SoundPropertyListUpdate >();
}

void SoundPropertiesProxy::sendDeregisterAll () const
{
    sendVolumeDeregisterAll();
    sendVolumeMapDeregisterAll();
    sendMuteStateDeregisterAll();
    sendMuteStateMapDeregisterAll();
    sendAudioStateInfoDeregisterAll();
    sendAudioStateInfoMapDeregisterAll();
    sendSystemPropertyListDeregisterAll();
    sendSoundPropertyListDeregisterAll();
    sendMainSinkSoundPropertyChangedDeregisterAll();
    sendSystemPropertyChangedDeregisterAll();
}

act_t SoundPropertiesProxy::sendMainSinkSoundPropertyChangedRegister(MainSinkSoundPropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MainSinkSoundPropertyChanged");
    act_t act = addSignalCallback(ID_MainSinkSoundPropertyChanged, "MainSinkSoundPropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MainSinkSoundPropertyChanged", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendMainSinkSoundPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MainSinkSoundPropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MainSinkSoundPropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void SoundPropertiesProxy::sendMainSinkSoundPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MainSinkSoundPropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("MainSinkSoundPropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t SoundPropertiesProxy::sendSystemPropertyChangedRegister(SystemPropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SystemPropertyChanged");
    act_t act = addSignalCallback(ID_SystemPropertyChanged, "SystemPropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemPropertyChanged", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendSystemPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemPropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemPropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void SoundPropertiesProxy::sendSystemPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemPropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SystemPropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t SoundPropertiesProxy::sendVolumeRegister(VolumeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_volume, "volume", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Volume", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendVolumeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("volume", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Volume", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendVolumeGet(VolumeCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_volume, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Volume", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("volume", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 SoundPropertiesProxy::getVolume() const {
    return _volume.get().getVolume();
}

bool SoundPropertiesProxy::hasVolume() const {
    return _volume.hasValue();
}

void SoundPropertiesProxy::sendVolumeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Volume");
    _dbusProxyDelegate->deregisterSignalCallback("volume", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendVolumeMapRegister(VolumeMapCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_volumeMap, "volumeMap", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VolumeMap", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendVolumeMapDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("volumeMap", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VolumeMap", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendVolumeMapGet(VolumeMapCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_volumeMap, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VolumeMap", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("volumeMap", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< uint16, uint8 >& SoundPropertiesProxy::getVolumeMap() const {
    return _volumeMap.get().getVolumeMap();
}

bool SoundPropertiesProxy::hasVolumeMap() const {
    return _volumeMap.hasValue();
}

void SoundPropertiesProxy::sendVolumeMapDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VolumeMap");
    _dbusProxyDelegate->deregisterSignalCallback("volumeMap", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendMuteStateRegister(MuteStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_muteState, "muteState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MuteState", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendMuteStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("muteState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MuteState", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendMuteStateGet(MuteStateCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_muteState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MuteState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("muteState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool SoundPropertiesProxy::getMuteState() const {
    return _muteState.get().getMuteState();
}

bool SoundPropertiesProxy::hasMuteState() const {
    return _muteState.hasValue();
}

void SoundPropertiesProxy::sendMuteStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MuteState");
    _dbusProxyDelegate->deregisterSignalCallback("muteState", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendMuteStateMapRegister(MuteStateMapCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_muteStateMap, "muteStateMap", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MuteStateMap", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendMuteStateMapDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("muteStateMap", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MuteStateMap", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendMuteStateMapGet(MuteStateMapCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_muteStateMap, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MuteStateMap", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("muteStateMap", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< uint16, bool >& SoundPropertiesProxy::getMuteStateMap() const {
    return _muteStateMap.get().getMuteStateMap();
}

bool SoundPropertiesProxy::hasMuteStateMap() const {
    return _muteStateMap.hasValue();
}

void SoundPropertiesProxy::sendMuteStateMapDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MuteStateMap");
    _dbusProxyDelegate->deregisterSignalCallback("muteStateMap", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendAudioStateInfoRegister(AudioStateInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_audioStateInfo, "audioStateInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AudioStateInfo", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendAudioStateInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("audioStateInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AudioStateInfo", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendAudioStateInfoGet(AudioStateInfoCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_audioStateInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AudioStateInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("audioStateInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const AudioStateInfo& SoundPropertiesProxy::getAudioStateInfo() const {
    return _audioStateInfo.get().getAudioStateInfo();
}

bool SoundPropertiesProxy::hasAudioStateInfo() const {
    return _audioStateInfo.hasValue();
}

void SoundPropertiesProxy::sendAudioStateInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AudioStateInfo");
    _dbusProxyDelegate->deregisterSignalCallback("audioStateInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendAudioStateInfoMapRegister(AudioStateInfoMapCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_audioStateInfoMap, "audioStateInfoMap", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AudioStateInfoMap", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendAudioStateInfoMapDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("audioStateInfoMap", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AudioStateInfoMap", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendAudioStateInfoMapGet(AudioStateInfoMapCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_audioStateInfoMap, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AudioStateInfoMap", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("audioStateInfoMap", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< uint16, AudioStateInfo >& SoundPropertiesProxy::getAudioStateInfoMap() const {
    return _audioStateInfoMap.get().getAudioStateInfoMap();
}

bool SoundPropertiesProxy::hasAudioStateInfoMap() const {
    return _audioStateInfoMap.hasValue();
}

void SoundPropertiesProxy::sendAudioStateInfoMapDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AudioStateInfoMap");
    _dbusProxyDelegate->deregisterSignalCallback("audioStateInfoMap", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendSystemPropertyListRegister(SystemPropertyListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_systemPropertyList, "systemPropertyList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemPropertyList", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendSystemPropertyListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("systemPropertyList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemPropertyList", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendSystemPropertyListGet(SystemPropertyListCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_systemPropertyList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemPropertyList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("systemPropertyList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< SystemProperty >& SoundPropertiesProxy::getSystemPropertyList() const {
    return _systemPropertyList.get().getSystemPropertyList();
}

bool SoundPropertiesProxy::hasSystemPropertyList() const {
    return _systemPropertyList.hasValue();
}

void SoundPropertiesProxy::sendSystemPropertyListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemPropertyList");
    _dbusProxyDelegate->deregisterSignalCallback("systemPropertyList", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendSoundPropertyListRegister(SoundPropertyListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_soundPropertyList, "soundPropertyList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SoundPropertyList", &cb, act);
    return act;
}

bool SoundPropertiesProxy::sendSoundPropertyListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("soundPropertyList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SoundPropertyList", act, static_cast<int>(rv));
    return rv;
}

act_t SoundPropertiesProxy::sendSoundPropertyListGet(SoundPropertyListCallbackIF& cb) {
    SoundPropertiesProxyCallback* callback = new SoundPropertiesProxyCallback(ID_soundPropertyList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SoundPropertyList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("soundPropertyList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SoundPropertyData& SoundPropertiesProxy::getSoundPropertyList() const {
    return _soundPropertyList.get().getSoundPropertyList();
}

bool SoundPropertiesProxy::hasSoundPropertyList() const {
    return _soundPropertyList.hasValue();
}

void SoundPropertiesProxy::sendSoundPropertyListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SoundPropertyList");
    _dbusProxyDelegate->deregisterSignalCallback("soundPropertyList", 0, _dbusDaemonProxy.get(), true);
}

act_t SoundPropertiesProxy::sendSetMuteStateRequest(SetMuteStateCallbackIF& cb, bool muteState, uint16 sinkId) const {
    SetMuteStateRequest* payload = new SetMuteStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setMuteState(muteState);
    payload->setSinkId(sinkId);
    DBUS_MESSAGE_CALL(dbusMessage, "setMuteState", SetMuteStateRequest, payload, true)
    act_t act = addMethodCallback(ID_setMuteState, dbusMessage.getUniqueSerial(), "setMuteState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMuteState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SoundPropertiesProxy::sendSetAudioStateRequest(SetAudioStateCallbackIF& cb, bool audioState, uint16 sinkId) const {
    SetAudioStateRequest* payload = new SetAudioStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setAudioState(audioState);
    payload->setSinkId(sinkId);
    DBUS_MESSAGE_CALL(dbusMessage, "setAudioState", SetAudioStateRequest, payload, true)
    act_t act = addMethodCallback(ID_setAudioState, dbusMessage.getUniqueSerial(), "setAudioState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetAudioState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SoundPropertiesProxy::sendSetMainSinkSoundPropertyRequest(SetMainSinkSoundPropertyCallbackIF& cb, uint16 propertyType, int32 value, uint16 sinkId) const {
    SetMainSinkSoundPropertyRequest* payload = new SetMainSinkSoundPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setPropertyType(propertyType);
    payload->setValue(value);
    payload->setSinkId(sinkId);
    DBUS_MESSAGE_CALL(dbusMessage, "setMainSinkSoundProperty", SetMainSinkSoundPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_setMainSinkSoundProperty, dbusMessage.getUniqueSerial(), "setMainSinkSoundProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMainSinkSoundProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SoundPropertiesProxy::sendSetSystemPropertyRequest(SetSystemPropertyCallbackIF& cb, uint16 propertyType, int32 value) const {
    SetSystemPropertyRequest* payload = new SetSystemPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setPropertyType(propertyType);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetSystemProperty", SetSystemPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetSystemProperty, dbusMessage.getUniqueSerial(), "SetSystemProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSystemProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SoundPropertiesProxy::sendRequestMainSinkSoundPropertyListRequest(uint16 sinkId) const {
    RequestMainSinkSoundPropertyListRequest* payload = new RequestMainSinkSoundPropertyListRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinkId(sinkId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestMainSinkSoundPropertyList", RequestMainSinkSoundPropertyListRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestMainSinkSoundPropertyList");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t SoundPropertiesProxy::sendRequestSystemPropertyListRequest() const {
    RequestSystemPropertyListRequest* payload = new RequestSystemPropertyListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestSystemPropertyList", RequestSystemPropertyListRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestSystemPropertyList");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace SoundProperties
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
