#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIES_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIES_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <map>
#include <vector>

/**
 * todo
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace SoundProperties {

// method IDs
static const uint16 ID_setMuteState = 0;
static const uint16 ID_setAudioState = 1;
static const uint16 ID_setMainSinkSoundProperty = 2;
static const uint16 ID_SetSystemProperty = 3;
static const uint16 ID_RequestMainSinkSoundPropertyList = 4;
static const uint16 ID_RequestSystemPropertyList = 5;

// signal IDs
static const uint16 ID_MainSinkSoundPropertyChanged = 6;
static const uint16 ID_SystemPropertyChanged = 7;

// property IDs
static const uint16 ID_volume = 8;
static const uint16 ID_volumeMap = 9;
static const uint16 ID_muteState = 10;
static const uint16 ID_muteStateMap = 11;
static const uint16 ID_audioStateInfo = 12;
static const uint16 ID_audioStateInfoMap = 13;
static const uint16 ID_systemPropertyList = 14;
static const uint16 ID_soundPropertyList = 15;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AudioStateInfo;

class SoundProperty;

class SystemProperty;

class SoundPropertyData;

class SetMuteStateRequest;

class SetAudioStateRequest;

class SetMainSinkSoundPropertyRequest;

class SetSystemPropertyRequest;

class RequestMainSinkSoundPropertyListRequest;

class VolumeUpdate;

class VolumeRegister;

class VolumeMapUpdate;

class VolumeMapRegister;

class MuteStateUpdate;

class MuteStateRegister;

class MuteStateMapUpdate;

class MuteStateMapRegister;

class AudioStateInfoUpdate;

class AudioStateInfoRegister;

class AudioStateInfoMapUpdate;

class AudioStateInfoMapRegister;

class SystemPropertyListUpdate;

class SystemPropertyListRegister;

class SoundPropertyListUpdate;

class SoundPropertyListRegister;

class MainSinkSoundPropertyChangedSignal;

class SystemPropertyChangedSignal;

// type definitions
/**
 * Method to activate or deactivate mute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetMuteStateResponse;

/**
 * If the meaning of "SetMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMuteStateError;

/**
 * Method to activate or deactivate audio off for main sink
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetAudioStateResponse;

/**
 * If the meaning of "SetAudioStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetAudioStateError;

/**
 * Method for Converting static sink ID to dynamic and send the same to Audio
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetMainSinkSoundPropertyResponse;

/**
 * If the meaning of "SetMainSinkSoundPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMainSinkSoundPropertyError;

/**
 * Method for setting system property
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetSystemPropertyResponse;

/**
 * If the meaning of "SetSystemPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSystemPropertyError;

/**
 * Method for requesting List of MainSinkSoundProperties
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestMainSinkSoundPropertyListResponse;

/**
 * If the meaning of "RequestMainSinkSoundPropertyListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestMainSinkSoundPropertyListError;

/**
 * Method for requesting List of System properties
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestSystemPropertyListRequest;

/**
 * Method for requesting List of System properties
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestSystemPropertyListResponse;

/**
 * If the meaning of "RequestSystemPropertyListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestSystemPropertyListError;

/**
 * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
 */
typedef VolumeUpdate VolumeSet;

/**
 * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
 */
typedef VolumeUpdate VolumeGet;

/**
 * If the meaning of "VolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VolumeError;

/**
 * holds the current volume value
 */
typedef VolumeMapUpdate VolumeMapSet;

/**
 * holds the current volume value
 */
typedef VolumeMapUpdate VolumeMapGet;

/**
 * If the meaning of "VolumeMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VolumeMapError;

/**
 * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
 */
typedef MuteStateUpdate MuteStateSet;

/**
 * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
 */
typedef MuteStateUpdate MuteStateGet;

/**
 * If the meaning of "MuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MuteStateError;

/**
 * holds the current mute state
 */
typedef MuteStateMapUpdate MuteStateMapSet;

/**
 * holds the current mute state
 */
typedef MuteStateMapUpdate MuteStateMapGet;

/**
 * If the meaning of "MuteStateMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MuteStateMapError;

/**
 * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
 */
typedef AudioStateInfoUpdate AudioStateInfoSet;

/**
 * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
 */
typedef AudioStateInfoUpdate AudioStateInfoGet;

/**
 * If the meaning of "AudioStateInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudioStateInfoError;

/**
 * holds the current mute and audio state
 */
typedef AudioStateInfoMapUpdate AudioStateInfoMapSet;

/**
 * holds the current mute and audio state
 */
typedef AudioStateInfoMapUpdate AudioStateInfoMapGet;

/**
 * If the meaning of "AudioStateInfoMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudioStateInfoMapError;

/**
 * List of System properties to registered clients
 */
typedef SystemPropertyListUpdate SystemPropertyListSet;

/**
 * List of System properties to registered clients
 */
typedef SystemPropertyListUpdate SystemPropertyListGet;

/**
 * If the meaning of "SystemPropertyListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemPropertyListError;

/**
 * List of sound properties to registered clients
 */
typedef SoundPropertyListUpdate SoundPropertyListSet;

/**
 * List of sound properties to registered clients
 */
typedef SoundPropertyListUpdate SoundPropertyListGet;

/**
 * If the meaning of "SoundPropertyListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SoundPropertyListError;

/**
 * If the meaning of "MainSinkSoundPropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MainSinkSoundPropertyChangedError;

/**
 * If the meaning of "SystemPropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemPropertyChangedError;


/**
 * Struct AudioState contains mute and audio state information
 */
class AudioStateInfo {
public:

    /**
     * Default constructor
     */
    inline  AudioStateInfo ();

    /**
     * Copy constructor
     */
    inline  AudioStateInfo (const AudioStateInfo &rhs);

    /**
     * All fields constructor
     */
    inline  AudioStateInfo (bool muteState_, bool audioOnOffState_);

    /**
     * Destructor
     */
    inline  ~AudioStateInfo();

    /**
     * Assignment operator
     */
    inline AudioStateInfo& operator = (const AudioStateInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "muteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "muteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "muteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "muteState"
     */
    inline bool getMuteState () const;

    /**
     * Sets the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @param muteState The value which will be set
     */
    inline void setMuteState (bool muteState_);

    // API of field "audioOnOffState"

    static const int kAudioOnOffState = 1;

    /**
     * Clears the field "audioOnOffState".
     *
     * The field will be set to its default value. The hasAudioOnOffState()
     * method will return false.
     */
    inline void clearAudioOnOffState();

    /**
     * Checks whether the field "audioOnOffState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOnOffState()). Otherwise it will return false.
     */
    inline bool hasAudioOnOffState () const;

    /**
     * Returns the value of the member "audioOnOffState".
     *
     * If the meaning of "audioOnOffState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "audioOnOffState"
     */
    inline bool getAudioOnOffState () const;

    /**
     * Sets the value of the member "audioOnOffState".
     *
     * If the meaning of "audioOnOffState" isn't clear, then there should be a description here.
     *
     * @param audioOnOffState The value which will be set
     */
    inline void setAudioOnOffState (bool audioOnOffState_);

    static const AudioStateInfo &getDefaultInstance();

private:

    inline void set_has_muteState ();

    inline void clear_has_muteState ();

    inline void set_has_audioOnOffState ();

    inline void clear_has_audioOnOffState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _muteState;

    bool _audioOnOffState;

};

/**
 * Struct SoundProperty
 */
class SoundProperty {
public:

    /**
     * Default constructor
     */
    inline  SoundProperty ();

    /**
     * Copy constructor
     */
    inline  SoundProperty (const SoundProperty &rhs);

    /**
     * All fields constructor
     */
    inline  SoundProperty (int32 PropertyType_, int32 value_);

    /**
     * Destructor
     */
    inline  ~SoundProperty();

    /**
     * Assignment operator
     */
    inline SoundProperty& operator = (const SoundProperty& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoundProperty& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoundProperty& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoundProperty& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoundProperty& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "PropertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "PropertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyType"
     */
    inline int32 getPropertyType () const;

    /**
     * Sets the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param PropertyType The value which will be set
     */
    inline void setPropertyType (int32 PropertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    static const SoundProperty &getDefaultInstance();

private:

    inline void set_has_PropertyType ();

    inline void clear_has_PropertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _PropertyType;

    int32 _value;

};

/**
 * Struct SystemProperty
 */
class SystemProperty {
public:

    /**
     * Default constructor
     */
    inline  SystemProperty ();

    /**
     * Copy constructor
     */
    inline  SystemProperty (const SystemProperty &rhs);

    /**
     * All fields constructor
     */
    inline  SystemProperty (int32 PropertyType_, int32 value_);

    /**
     * Destructor
     */
    inline  ~SystemProperty();

    /**
     * Assignment operator
     */
    inline SystemProperty& operator = (const SystemProperty& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemProperty& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemProperty& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemProperty& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemProperty& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "PropertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "PropertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyType"
     */
    inline int32 getPropertyType () const;

    /**
     * Sets the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param PropertyType The value which will be set
     */
    inline void setPropertyType (int32 PropertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    static const SystemProperty &getDefaultInstance();

private:

    inline void set_has_PropertyType ();

    inline void clear_has_PropertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _PropertyType;

    int32 _value;

};

/**
 * Struct SoundPropertyData
 */
class SoundPropertyData {
public:

    /**
     * Default constructor
     */
    inline  SoundPropertyData ();

    /**
     * Copy constructor
     */
    inline  SoundPropertyData (const SoundPropertyData &rhs);

    /**
     * All fields constructor
     */
    inline  SoundPropertyData (const ::std::vector< SoundProperty >& SoundData_, uint16 SinkId_);

    /**
     * Destructor
     */
    inline  ~SoundPropertyData();

    /**
     * Assignment operator
     */
    inline SoundPropertyData& operator = (const SoundPropertyData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoundPropertyData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoundPropertyData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoundPropertyData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoundPropertyData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundData"

    static const int kSoundData = 0;

    /**
     * Clears the field "SoundData".
     *
     * The field will be set to its default value. The hasSoundData()
     * method will return false.
     */
    inline void clearSoundData();

    /**
     * Checks whether the field "SoundData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundData()). Otherwise it will return false.
     */
    inline bool hasSoundData () const;

    /**
     * Returns the value of the member "SoundData".
     *
     * If the meaning of "SoundData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SoundData"
     */
    inline const ::std::vector< SoundProperty >& getSoundData () const;

    /**
     * Retrieves the value of the field "SoundData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SoundData".
     */
    inline ::std::vector< SoundProperty >& getSoundDataMutable ();

    /**
     * Sets the value of the member "SoundData".
     *
     * If the meaning of "SoundData" isn't clear, then there should be a description here.
     *
     * @param SoundData The value which will be set
     */
    inline void setSoundData (const ::std::vector< SoundProperty >& SoundData_);

    // API of field "SinkId"

    static const int kSinkId = 1;

    /**
     * Clears the field "SinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "SinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "SinkId".
     *
     * If the meaning of "SinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "SinkId".
     *
     * If the meaning of "SinkId" isn't clear, then there should be a description here.
     *
     * @param SinkId The value which will be set
     */
    inline void setSinkId (uint16 SinkId_);

    static const SoundPropertyData &getDefaultInstance();

private:

    static const ::std::vector< SoundProperty >& getSoundPropertyList_DefaultInstance ();

    inline void set_has_SoundData ();

    inline void clear_has_SoundData ();

    inline void set_has_SinkId ();

    inline void clear_has_SinkId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< SoundProperty > _SoundData;

    uint16 _SinkId;

};

/**
 * Method to activate or deactivate mute
 */
class SetMuteStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMuteStateRequest ();

    /**
     * Copy constructor
     */
    inline  SetMuteStateRequest (const SetMuteStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMuteStateRequest (bool muteState_, uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~SetMuteStateRequest();

    /**
     * Assignment operator
     */
    inline SetMuteStateRequest& operator = (const SetMuteStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMuteStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMuteStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMuteStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMuteStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "muteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "muteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "muteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "muteState"
     */
    inline bool getMuteState () const;

    /**
     * Sets the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @param muteState The value which will be set
     */
    inline void setMuteState (bool muteState_);

    // API of field "sinkId"

    static const int kSinkId = 1;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const SetMuteStateRequest &getDefaultInstance();

private:

    inline void set_has_muteState ();

    inline void clear_has_muteState ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _muteState;

    uint16 _sinkId;

};

/**
 * Method to activate or deactivate audio off for main sink
 */
class SetAudioStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAudioStateRequest ();

    /**
     * Copy constructor
     */
    inline  SetAudioStateRequest (const SetAudioStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetAudioStateRequest (bool audioState_, uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~SetAudioStateRequest();

    /**
     * Assignment operator
     */
    inline SetAudioStateRequest& operator = (const SetAudioStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAudioStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAudioStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAudioStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAudioStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "audioState"

    static const int kAudioState = 0;

    /**
     * Clears the field "audioState".
     *
     * The field will be set to its default value. The hasAudioState()
     * method will return false.
     */
    inline void clearAudioState();

    /**
     * Checks whether the field "audioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioState()). Otherwise it will return false.
     */
    inline bool hasAudioState () const;

    /**
     * Returns the value of the member "audioState".
     *
     * If the meaning of "audioState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "audioState"
     */
    inline bool getAudioState () const;

    /**
     * Sets the value of the member "audioState".
     *
     * If the meaning of "audioState" isn't clear, then there should be a description here.
     *
     * @param audioState The value which will be set
     */
    inline void setAudioState (bool audioState_);

    // API of field "sinkId"

    static const int kSinkId = 1;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const SetAudioStateRequest &getDefaultInstance();

private:

    inline void set_has_audioState ();

    inline void clear_has_audioState ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _audioState;

    uint16 _sinkId;

};

/**
 * Method for Converting static sink ID to dynamic and send the same to Audio
 */
class SetMainSinkSoundPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMainSinkSoundPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetMainSinkSoundPropertyRequest (const SetMainSinkSoundPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSinkSoundPropertyRequest (uint16 PropertyType_, int32 value_, uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~SetMainSinkSoundPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetMainSinkSoundPropertyRequest& operator = (const SetMainSinkSoundPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "PropertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "PropertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyType"
     */
    inline uint16 getPropertyType () const;

    /**
     * Sets the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param PropertyType The value which will be set
     */
    inline void setPropertyType (uint16 PropertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    // API of field "sinkId"

    static const int kSinkId = 2;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const SetMainSinkSoundPropertyRequest &getDefaultInstance();

private:

    inline void set_has_PropertyType ();

    inline void clear_has_PropertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _PropertyType;

    int32 _value;

    uint16 _sinkId;

};

/**
 * Method for setting system property
 */
class SetSystemPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSystemPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetSystemPropertyRequest (const SetSystemPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemPropertyRequest (uint16 propertyType_, int32 value_);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetSystemPropertyRequest& operator = (const SetSystemPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "propertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "propertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "propertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "propertyType".
     *
     * If the meaning of "propertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "propertyType"
     */
    inline uint16 getPropertyType () const;

    /**
     * Sets the value of the member "propertyType".
     *
     * If the meaning of "propertyType" isn't clear, then there should be a description here.
     *
     * @param propertyType The value which will be set
     */
    inline void setPropertyType (uint16 propertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    static const SetSystemPropertyRequest &getDefaultInstance();

private:

    inline void set_has_propertyType ();

    inline void clear_has_propertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _propertyType;

    int32 _value;

};

/**
 * Method for requesting List of MainSinkSoundProperties
 */
class RequestMainSinkSoundPropertyListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMainSinkSoundPropertyListRequest ();

    /**
     * Copy constructor
     */
    inline  RequestMainSinkSoundPropertyListRequest (const RequestMainSinkSoundPropertyListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMainSinkSoundPropertyListRequest (uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMainSinkSoundPropertyListRequest();

    /**
     * Assignment operator
     */
    inline RequestMainSinkSoundPropertyListRequest& operator = (const RequestMainSinkSoundPropertyListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMainSinkSoundPropertyListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMainSinkSoundPropertyListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMainSinkSoundPropertyListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMainSinkSoundPropertyListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkId"

    static const int kSinkId = 0;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const RequestMainSinkSoundPropertyListRequest &getDefaultInstance();

private:

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _sinkId;

};

/**
 * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
 */
class VolumeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeUpdate ();

    /**
     * Copy constructor
     */
    inline  VolumeUpdate (const VolumeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeUpdate (uint8 volume_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeUpdate();

    /**
     * Assignment operator
     */
    inline VolumeUpdate& operator = (const VolumeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "volume"

    static const int kVolume = 0;

    /**
     * Clears the field "volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "volume".
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @return The value of the field "volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "volume".
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @param volume The value which will be set
     */
    inline void setVolume (uint8 volume_);

    static const VolumeUpdate &getDefaultInstance();

private:

    inline void set_has_volume ();

    inline void clear_has_volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _volume;

};

/**
 * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
 */
class VolumeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeRegister ();

    /**
     * Copy constructor
     */
    inline  VolumeRegister (const VolumeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VolumeRegister();

    /**
     * Assignment operator
     */
    inline VolumeRegister& operator = (const VolumeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VolumeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * holds the current volume value
 */
class VolumeMapUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeMapUpdate ();

    /**
     * Copy constructor
     */
    inline  VolumeMapUpdate (const VolumeMapUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeMapUpdate (const ::std::map< uint16, uint8 >& volumeMap_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeMapUpdate();

    /**
     * Assignment operator
     */
    inline VolumeMapUpdate& operator = (const VolumeMapUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeMapUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeMapUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeMapUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeMapUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "volumeMap"

    static const int kVolumeMap = 0;

    /**
     * Clears the field "volumeMap".
     *
     * The field will be set to its default value. The hasVolumeMap()
     * method will return false.
     */
    inline void clearVolumeMap();

    /**
     * Checks whether the field "volumeMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeMap()). Otherwise it will return false.
     */
    inline bool hasVolumeMap () const;

    /**
     * Returns the value of the member "volumeMap".
     *
     * holds the current volume value
     *
     * @return The value of the field "volumeMap"
     */
    inline const ::std::map< uint16, uint8 >& getVolumeMap () const;

    /**
     * Retrieves the value of the field "volumeMap" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "volumeMap".
     */
    inline ::std::map< uint16, uint8 >& getVolumeMapMutable ();

    /**
     * Sets the value of the member "volumeMap".
     *
     * holds the current volume value
     *
     * @param volumeMap The value which will be set
     */
    inline void setVolumeMap (const ::std::map< uint16, uint8 >& volumeMap_);

    static const VolumeMapUpdate &getDefaultInstance();

private:

    static const ::std::map< uint16, uint8 >& getUint16ToUint8Map_DefaultInstance ();

    inline void set_has_volumeMap ();

    inline void clear_has_volumeMap ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< uint16, uint8 > _volumeMap;

};

/**
 * holds the current volume value
 */
class VolumeMapRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeMapRegister ();

    /**
     * Copy constructor
     */
    inline  VolumeMapRegister (const VolumeMapRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VolumeMapRegister();

    /**
     * Assignment operator
     */
    inline VolumeMapRegister& operator = (const VolumeMapRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeMapRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeMapRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeMapRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeMapRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VolumeMapRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
 */
class MuteStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStateUpdate ();

    /**
     * Copy constructor
     */
    inline  MuteStateUpdate (const MuteStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MuteStateUpdate (bool muteState_);

    /**
     * Destructor
     */
    inline virtual  ~MuteStateUpdate();

    /**
     * Assignment operator
     */
    inline MuteStateUpdate& operator = (const MuteStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "muteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "muteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "muteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "muteState".
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @return The value of the field "muteState"
     */
    inline bool getMuteState () const;

    /**
     * Sets the value of the member "muteState".
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @param muteState The value which will be set
     */
    inline void setMuteState (bool muteState_);

    static const MuteStateUpdate &getDefaultInstance();

private:

    inline void set_has_muteState ();

    inline void clear_has_muteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _muteState;

};

/**
 * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
 */
class MuteStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStateRegister ();

    /**
     * Copy constructor
     */
    inline  MuteStateRegister (const MuteStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MuteStateRegister();

    /**
     * Assignment operator
     */
    inline MuteStateRegister& operator = (const MuteStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MuteStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * holds the current mute state
 */
class MuteStateMapUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStateMapUpdate ();

    /**
     * Copy constructor
     */
    inline  MuteStateMapUpdate (const MuteStateMapUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MuteStateMapUpdate (const ::std::map< uint16, bool >& muteStateMap_);

    /**
     * Destructor
     */
    inline virtual  ~MuteStateMapUpdate();

    /**
     * Assignment operator
     */
    inline MuteStateMapUpdate& operator = (const MuteStateMapUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStateMapUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStateMapUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStateMapUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStateMapUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "muteStateMap"

    static const int kMuteStateMap = 0;

    /**
     * Clears the field "muteStateMap".
     *
     * The field will be set to its default value. The hasMuteStateMap()
     * method will return false.
     */
    inline void clearMuteStateMap();

    /**
     * Checks whether the field "muteStateMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteStateMap()). Otherwise it will return false.
     */
    inline bool hasMuteStateMap () const;

    /**
     * Returns the value of the member "muteStateMap".
     *
     * holds the current mute state
     *
     * @return The value of the field "muteStateMap"
     */
    inline const ::std::map< uint16, bool >& getMuteStateMap () const;

    /**
     * Retrieves the value of the field "muteStateMap" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "muteStateMap".
     */
    inline ::std::map< uint16, bool >& getMuteStateMapMutable ();

    /**
     * Sets the value of the member "muteStateMap".
     *
     * holds the current mute state
     *
     * @param muteStateMap The value which will be set
     */
    inline void setMuteStateMap (const ::std::map< uint16, bool >& muteStateMap_);

    static const MuteStateMapUpdate &getDefaultInstance();

private:

    static const ::std::map< uint16, bool >& getUint16ToBooleanMap_DefaultInstance ();

    inline void set_has_muteStateMap ();

    inline void clear_has_muteStateMap ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< uint16, bool > _muteStateMap;

};

/**
 * holds the current mute state
 */
class MuteStateMapRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStateMapRegister ();

    /**
     * Copy constructor
     */
    inline  MuteStateMapRegister (const MuteStateMapRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MuteStateMapRegister();

    /**
     * Assignment operator
     */
    inline MuteStateMapRegister& operator = (const MuteStateMapRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStateMapRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStateMapRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStateMapRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStateMapRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MuteStateMapRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
 */
class AudioStateInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  AudioStateInfoUpdate (const AudioStateInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AudioStateInfoUpdate (const AudioStateInfo& audioStateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~AudioStateInfoUpdate();

    /**
     * Assignment operator
     */
    inline AudioStateInfoUpdate& operator = (const AudioStateInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "audioStateInfo"

    static const int kAudioStateInfo = 0;

    /**
     * Clears the field "audioStateInfo".
     *
     * The field will be set to its default value. The hasAudioStateInfo()
     * method will return false.
     */
    inline void clearAudioStateInfo();

    /**
     * Checks whether the field "audioStateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioStateInfo()). Otherwise it will return false.
     */
    inline bool hasAudioStateInfo () const;

    /**
     * Returns the value of the member "audioStateInfo".
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @return The value of the field "audioStateInfo"
     */
    inline const AudioStateInfo& getAudioStateInfo () const;

    /**
     * Retrieves the value of the field "audioStateInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "audioStateInfo".
     */
    inline AudioStateInfo& getAudioStateInfoMutable ();

    /**
     * Sets the value of the member "audioStateInfo".
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @param audioStateInfo The value which will be set
     */
    inline void setAudioStateInfo (const AudioStateInfo& audioStateInfo_);

    static const AudioStateInfoUpdate &getDefaultInstance();

private:

    inline void set_has_audioStateInfo ();

    inline void clear_has_audioStateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    AudioStateInfo _audioStateInfo;

};

/**
 * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
 */
class AudioStateInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateInfoRegister ();

    /**
     * Copy constructor
     */
    inline  AudioStateInfoRegister (const AudioStateInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AudioStateInfoRegister();

    /**
     * Assignment operator
     */
    inline AudioStateInfoRegister& operator = (const AudioStateInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AudioStateInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * holds the current mute and audio state
 */
class AudioStateInfoMapUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateInfoMapUpdate ();

    /**
     * Copy constructor
     */
    inline  AudioStateInfoMapUpdate (const AudioStateInfoMapUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AudioStateInfoMapUpdate (const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap_);

    /**
     * Destructor
     */
    inline virtual  ~AudioStateInfoMapUpdate();

    /**
     * Assignment operator
     */
    inline AudioStateInfoMapUpdate& operator = (const AudioStateInfoMapUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateInfoMapUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateInfoMapUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateInfoMapUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateInfoMapUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "audioStateInfoMap"

    static const int kAudioStateInfoMap = 0;

    /**
     * Clears the field "audioStateInfoMap".
     *
     * The field will be set to its default value. The hasAudioStateInfoMap()
     * method will return false.
     */
    inline void clearAudioStateInfoMap();

    /**
     * Checks whether the field "audioStateInfoMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioStateInfoMap()). Otherwise it will return false.
     */
    inline bool hasAudioStateInfoMap () const;

    /**
     * Returns the value of the member "audioStateInfoMap".
     *
     * holds the current mute and audio state
     *
     * @return The value of the field "audioStateInfoMap"
     */
    inline const ::std::map< uint16, AudioStateInfo >& getAudioStateInfoMap () const;

    /**
     * Retrieves the value of the field "audioStateInfoMap" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "audioStateInfoMap".
     */
    inline ::std::map< uint16, AudioStateInfo >& getAudioStateInfoMapMutable ();

    /**
     * Sets the value of the member "audioStateInfoMap".
     *
     * holds the current mute and audio state
     *
     * @param audioStateInfoMap The value which will be set
     */
    inline void setAudioStateInfoMap (const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap_);

    static const AudioStateInfoMapUpdate &getDefaultInstance();

private:

    static const ::std::map< uint16, AudioStateInfo >& getUint16ToAudioStateInfoMap_DefaultInstance ();

    inline void set_has_audioStateInfoMap ();

    inline void clear_has_audioStateInfoMap ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< uint16, AudioStateInfo > _audioStateInfoMap;

};

/**
 * holds the current mute and audio state
 */
class AudioStateInfoMapRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateInfoMapRegister ();

    /**
     * Copy constructor
     */
    inline  AudioStateInfoMapRegister (const AudioStateInfoMapRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AudioStateInfoMapRegister();

    /**
     * Assignment operator
     */
    inline AudioStateInfoMapRegister& operator = (const AudioStateInfoMapRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateInfoMapRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateInfoMapRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateInfoMapRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateInfoMapRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AudioStateInfoMapRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * List of System properties to registered clients
 */
class SystemPropertyListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPropertyListUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemPropertyListUpdate (const SystemPropertyListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPropertyListUpdate (const ::std::vector< SystemProperty >& systemPropertyList_);

    /**
     * Destructor
     */
    inline virtual  ~SystemPropertyListUpdate();

    /**
     * Assignment operator
     */
    inline SystemPropertyListUpdate& operator = (const SystemPropertyListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPropertyListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPropertyListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPropertyListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPropertyListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "systemPropertyList"

    static const int kSystemPropertyList = 0;

    /**
     * Clears the field "systemPropertyList".
     *
     * The field will be set to its default value. The hasSystemPropertyList()
     * method will return false.
     */
    inline void clearSystemPropertyList();

    /**
     * Checks whether the field "systemPropertyList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemPropertyList()). Otherwise it will return false.
     */
    inline bool hasSystemPropertyList () const;

    /**
     * Returns the value of the member "systemPropertyList".
     *
     * List of System properties to registered clients
     *
     * @return The value of the field "systemPropertyList"
     */
    inline const ::std::vector< SystemProperty >& getSystemPropertyList () const;

    /**
     * Retrieves the value of the field "systemPropertyList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "systemPropertyList".
     */
    inline ::std::vector< SystemProperty >& getSystemPropertyListMutable ();

    /**
     * Sets the value of the member "systemPropertyList".
     *
     * List of System properties to registered clients
     *
     * @param systemPropertyList The value which will be set
     */
    inline void setSystemPropertyList (const ::std::vector< SystemProperty >& systemPropertyList_);

    static const SystemPropertyListUpdate &getDefaultInstance();

private:

    static const ::std::vector< SystemProperty >& getSystemPropertyList_DefaultInstance ();

    inline void set_has_systemPropertyList ();

    inline void clear_has_systemPropertyList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SystemProperty > _systemPropertyList;

};

/**
 * List of System properties to registered clients
 */
class SystemPropertyListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPropertyListRegister ();

    /**
     * Copy constructor
     */
    inline  SystemPropertyListRegister (const SystemPropertyListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemPropertyListRegister();

    /**
     * Assignment operator
     */
    inline SystemPropertyListRegister& operator = (const SystemPropertyListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPropertyListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPropertyListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPropertyListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPropertyListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemPropertyListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * List of sound properties to registered clients
 */
class SoundPropertyListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SoundPropertyListUpdate ();

    /**
     * Copy constructor
     */
    inline  SoundPropertyListUpdate (const SoundPropertyListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SoundPropertyListUpdate (const SoundPropertyData& soundPropertyList_);

    /**
     * Destructor
     */
    inline virtual  ~SoundPropertyListUpdate();

    /**
     * Assignment operator
     */
    inline SoundPropertyListUpdate& operator = (const SoundPropertyListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoundPropertyListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoundPropertyListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoundPropertyListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoundPropertyListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "soundPropertyList"

    static const int kSoundPropertyList = 0;

    /**
     * Clears the field "soundPropertyList".
     *
     * The field will be set to its default value. The hasSoundPropertyList()
     * method will return false.
     */
    inline void clearSoundPropertyList();

    /**
     * Checks whether the field "soundPropertyList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundPropertyList()). Otherwise it will return false.
     */
    inline bool hasSoundPropertyList () const;

    /**
     * Returns the value of the member "soundPropertyList".
     *
     * List of sound properties to registered clients
     *
     * @return The value of the field "soundPropertyList"
     */
    inline const SoundPropertyData& getSoundPropertyList () const;

    /**
     * Retrieves the value of the field "soundPropertyList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "soundPropertyList".
     */
    inline SoundPropertyData& getSoundPropertyListMutable ();

    /**
     * Sets the value of the member "soundPropertyList".
     *
     * List of sound properties to registered clients
     *
     * @param soundPropertyList The value which will be set
     */
    inline void setSoundPropertyList (const SoundPropertyData& soundPropertyList_);

    static const SoundPropertyListUpdate &getDefaultInstance();

private:

    inline void set_has_soundPropertyList ();

    inline void clear_has_soundPropertyList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SoundPropertyData _soundPropertyList;

};

/**
 * List of sound properties to registered clients
 */
class SoundPropertyListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SoundPropertyListRegister ();

    /**
     * Copy constructor
     */
    inline  SoundPropertyListRegister (const SoundPropertyListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SoundPropertyListRegister();

    /**
     * Assignment operator
     */
    inline SoundPropertyListRegister& operator = (const SoundPropertyListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoundPropertyListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoundPropertyListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoundPropertyListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoundPropertyListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SoundPropertyListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Signal to indicate that there is a change in MainSinkSoundProperty
 */
class MainSinkSoundPropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MainSinkSoundPropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  MainSinkSoundPropertyChangedSignal (const MainSinkSoundPropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MainSinkSoundPropertyChangedSignal (int32 PropertyType_, int32 value_, uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~MainSinkSoundPropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline MainSinkSoundPropertyChangedSignal& operator = (const MainSinkSoundPropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "PropertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "PropertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyType"
     */
    inline int32 getPropertyType () const;

    /**
     * Sets the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param PropertyType The value which will be set
     */
    inline void setPropertyType (int32 PropertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    // API of field "sinkId"

    static const int kSinkId = 2;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const MainSinkSoundPropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_PropertyType ();

    inline void clear_has_PropertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _PropertyType;

    int32 _value;

    uint16 _sinkId;

};

/**
 * Signal to indicate that there is a change in SystemProperty
 */
class SystemPropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SystemPropertyChangedSignal (const SystemPropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPropertyChangedSignal (int32 PropertyType_, int32 value_);

    /**
     * Destructor
     */
    inline virtual  ~SystemPropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline SystemPropertyChangedSignal& operator = (const SystemPropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PropertyType"

    static const int kPropertyType = 0;

    /**
     * Clears the field "PropertyType".
     *
     * The field will be set to its default value. The hasPropertyType()
     * method will return false.
     */
    inline void clearPropertyType();

    /**
     * Checks whether the field "PropertyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyType()). Otherwise it will return false.
     */
    inline bool hasPropertyType () const;

    /**
     * Returns the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PropertyType"
     */
    inline int32 getPropertyType () const;

    /**
     * Sets the value of the member "PropertyType".
     *
     * If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param PropertyType The value which will be set
     */
    inline void setPropertyType (int32 PropertyType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int32 value_);

    static const SystemPropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_PropertyType ();

    inline void clear_has_PropertyType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _PropertyType;

    int32 _value;

};

inline  AudioStateInfo::AudioStateInfo ()  :
    _muteState (false),
    _audioOnOffState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioStateInfo::AudioStateInfo (const AudioStateInfo &rhs)  :
    _muteState (false),
    _audioOnOffState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioStateInfo::AudioStateInfo (bool muteState_, bool audioOnOffState_)  :
    _muteState (muteState_),
    _audioOnOffState (audioOnOffState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudioStateInfo::~AudioStateInfo() {
}

inline AudioStateInfo& AudioStateInfo::operator = (const AudioStateInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
        if (rhs.hasAudioOnOffState()) {
            setAudioOnOffState(rhs.getAudioOnOffState());
        } else {
            clearAudioOnOffState();
        }
    }
    return *this;
}

inline bool AudioStateInfo::operator == (const AudioStateInfo& rhs) const {
    return (((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()) &&
        ((!hasAudioOnOffState() && !rhs.hasAudioOnOffState()) || getAudioOnOffState() == rhs.getAudioOnOffState()));
}

inline bool AudioStateInfo::operator != (const AudioStateInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioStateInfo::operator < (const AudioStateInfo& rhs) const {
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    if (hasAudioOnOffState() || rhs.hasAudioOnOffState()) {
        if (getAudioOnOffState() < rhs.getAudioOnOffState()) return true;
        if (getAudioOnOffState() > rhs.getAudioOnOffState()) return false;
    }
    return false;
}

inline bool AudioStateInfo::operator > (const AudioStateInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioStateInfo::clear() {
    clearMuteState();
    clearAudioOnOffState();
}

inline void AudioStateInfo::clearMuteState() {
    if (hasMuteState()) {
         clear_has_muteState();
        _muteState = false;
     }
}

inline bool AudioStateInfo::hasMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AudioStateInfo::getMuteState () const {
    return _muteState;
}

inline void AudioStateInfo::setMuteState (bool muteState_) {
    set_has_muteState();
    this->_muteState = muteState_;
}

inline void AudioStateInfo::clearAudioOnOffState() {
    if (hasAudioOnOffState()) {
         clear_has_audioOnOffState();
        _audioOnOffState = false;
     }
}

inline bool AudioStateInfo::hasAudioOnOffState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool AudioStateInfo::getAudioOnOffState () const {
    return _audioOnOffState;
}

inline void AudioStateInfo::setAudioOnOffState (bool audioOnOffState_) {
    set_has_audioOnOffState();
    this->_audioOnOffState = audioOnOffState_;
}

inline void AudioStateInfo::set_has_muteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudioStateInfo::clear_has_muteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudioStateInfo::set_has_audioOnOffState () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudioStateInfo::clear_has_audioOnOffState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SoundProperty::SoundProperty ()  :
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoundProperty::SoundProperty (const SoundProperty &rhs)  :
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoundProperty::SoundProperty (int32 PropertyType_, int32 value_)  :
    _PropertyType (PropertyType_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SoundProperty::~SoundProperty() {
}

inline SoundProperty& SoundProperty::operator = (const SoundProperty& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SoundProperty::operator == (const SoundProperty& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SoundProperty::operator != (const SoundProperty& rhs) const {
    return ! (*this == rhs);
}

inline bool SoundProperty::operator < (const SoundProperty& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool SoundProperty::operator > (const SoundProperty& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoundProperty::clear() {
    clearPropertyType();
    clearValue();
}

inline void SoundProperty::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_PropertyType();
        _PropertyType = 0;
     }
}

inline bool SoundProperty::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SoundProperty::getPropertyType () const {
    return _PropertyType;
}

inline void SoundProperty::setPropertyType (int32 PropertyType_) {
    set_has_PropertyType();
    this->_PropertyType = PropertyType_;
}

inline void SoundProperty::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SoundProperty::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SoundProperty::getValue () const {
    return _value;
}

inline void SoundProperty::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SoundProperty::set_has_PropertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SoundProperty::clear_has_PropertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SoundProperty::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SoundProperty::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SystemProperty::SystemProperty ()  :
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemProperty::SystemProperty (const SystemProperty &rhs)  :
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemProperty::SystemProperty (int32 PropertyType_, int32 value_)  :
    _PropertyType (PropertyType_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemProperty::~SystemProperty() {
}

inline SystemProperty& SystemProperty::operator = (const SystemProperty& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SystemProperty::operator == (const SystemProperty& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SystemProperty::operator != (const SystemProperty& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemProperty::operator < (const SystemProperty& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool SystemProperty::operator > (const SystemProperty& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemProperty::clear() {
    clearPropertyType();
    clearValue();
}

inline void SystemProperty::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_PropertyType();
        _PropertyType = 0;
     }
}

inline bool SystemProperty::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SystemProperty::getPropertyType () const {
    return _PropertyType;
}

inline void SystemProperty::setPropertyType (int32 PropertyType_) {
    set_has_PropertyType();
    this->_PropertyType = PropertyType_;
}

inline void SystemProperty::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SystemProperty::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SystemProperty::getValue () const {
    return _value;
}

inline void SystemProperty::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SystemProperty::set_has_PropertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemProperty::clear_has_PropertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SystemProperty::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SystemProperty::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SoundPropertyData::SoundPropertyData ()  :
    _SoundData (),
    _SinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoundPropertyData::SoundPropertyData (const SoundPropertyData &rhs)  :
    _SoundData (),
    _SinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoundPropertyData::SoundPropertyData (const ::std::vector< SoundProperty >& SoundData_, uint16 SinkId_)  :
    _SoundData (SoundData_),
    _SinkId (SinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SoundPropertyData::~SoundPropertyData() {
}

inline SoundPropertyData& SoundPropertyData::operator = (const SoundPropertyData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSoundData()) {
            setSoundData(rhs.getSoundData());
        } else {
            clearSoundData();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool SoundPropertyData::operator == (const SoundPropertyData& rhs) const {
    return (((!hasSoundData() && !rhs.hasSoundData()) || getSoundData() == rhs.getSoundData()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool SoundPropertyData::operator != (const SoundPropertyData& rhs) const {
    return ! (*this == rhs);
}

inline bool SoundPropertyData::operator < (const SoundPropertyData& rhs) const {
    if (hasSoundData() || rhs.hasSoundData()) {
        if (getSoundData() < rhs.getSoundData()) return true;
        if (getSoundData() > rhs.getSoundData()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline bool SoundPropertyData::operator > (const SoundPropertyData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoundPropertyData::clear() {
    clearSoundData();
    clearSinkId();
}

inline void SoundPropertyData::clearSoundData() {
    if (hasSoundData()) {
         clear_has_SoundData();
        _SoundData.clear();
     }
}

inline bool SoundPropertyData::hasSoundData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SoundProperty >& SoundPropertyData::getSoundData () const {
    return _SoundData;
}

inline ::std::vector< SoundProperty >& SoundPropertyData::getSoundDataMutable () {
    set_has_SoundData();
    return _SoundData;
}

inline void SoundPropertyData::setSoundData (const ::std::vector< SoundProperty >& SoundData_) {
    set_has_SoundData();
    this->_SoundData = SoundData_;
}

inline void SoundPropertyData::clearSinkId() {
    if (hasSinkId()) {
         clear_has_SinkId();
        _SinkId = 0u;
     }
}

inline bool SoundPropertyData::hasSinkId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SoundPropertyData::getSinkId () const {
    return _SinkId;
}

inline void SoundPropertyData::setSinkId (uint16 SinkId_) {
    set_has_SinkId();
    this->_SinkId = SinkId_;
}

inline void SoundPropertyData::set_has_SoundData () {
    _has_bits_[0] |= 1u << 0;
}

inline void SoundPropertyData::clear_has_SoundData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SoundPropertyData::set_has_SinkId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SoundPropertyData::clear_has_SinkId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMuteStateRequest::SetMuteStateRequest ()  :
    _muteState (false),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMuteStateRequest::SetMuteStateRequest (const SetMuteStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _muteState (false),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMuteStateRequest::SetMuteStateRequest (bool muteState_, uint16 sinkId_)  :
    _muteState (muteState_),
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMuteStateRequest::~SetMuteStateRequest() {
}

inline SetMuteStateRequest& SetMuteStateRequest::operator = (const SetMuteStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool SetMuteStateRequest::operator == (const SetMuteStateRequest& rhs) const {
    return (((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool SetMuteStateRequest::operator != (const SetMuteStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMuteStateRequest::operator < (const SetMuteStateRequest& rhs) const {
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMuteStateRequest::clone() {
    return new SetMuteStateRequest(*this);
}

inline bool SetMuteStateRequest::operator > (const SetMuteStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMuteStateRequest::clear() {
    clearMuteState();
    clearSinkId();
}

inline void SetMuteStateRequest::clearMuteState() {
    if (hasMuteState()) {
         clear_has_muteState();
        _muteState = false;
     }
}

inline bool SetMuteStateRequest::hasMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetMuteStateRequest::getMuteState () const {
    return _muteState;
}

inline void SetMuteStateRequest::setMuteState (bool muteState_) {
    set_has_muteState();
    this->_muteState = muteState_;
}

inline void SetMuteStateRequest::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool SetMuteStateRequest::hasSinkId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SetMuteStateRequest::getSinkId () const {
    return _sinkId;
}

inline void SetMuteStateRequest::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void SetMuteStateRequest::set_has_muteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMuteStateRequest::clear_has_muteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMuteStateRequest::set_has_sinkId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMuteStateRequest::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetAudioStateRequest::SetAudioStateRequest ()  :
    _audioState (false),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAudioStateRequest::SetAudioStateRequest (const SetAudioStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _audioState (false),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAudioStateRequest::SetAudioStateRequest (bool audioState_, uint16 sinkId_)  :
    _audioState (audioState_),
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAudioStateRequest::~SetAudioStateRequest() {
}

inline SetAudioStateRequest& SetAudioStateRequest::operator = (const SetAudioStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioState()) {
            setAudioState(rhs.getAudioState());
        } else {
            clearAudioState();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool SetAudioStateRequest::operator == (const SetAudioStateRequest& rhs) const {
    return (((!hasAudioState() && !rhs.hasAudioState()) || getAudioState() == rhs.getAudioState()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool SetAudioStateRequest::operator != (const SetAudioStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAudioStateRequest::operator < (const SetAudioStateRequest& rhs) const {
    if (hasAudioState() || rhs.hasAudioState()) {
        if (getAudioState() < rhs.getAudioState()) return true;
        if (getAudioState() > rhs.getAudioState()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAudioStateRequest::clone() {
    return new SetAudioStateRequest(*this);
}

inline bool SetAudioStateRequest::operator > (const SetAudioStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAudioStateRequest::clear() {
    clearAudioState();
    clearSinkId();
}

inline void SetAudioStateRequest::clearAudioState() {
    if (hasAudioState()) {
         clear_has_audioState();
        _audioState = false;
     }
}

inline bool SetAudioStateRequest::hasAudioState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetAudioStateRequest::getAudioState () const {
    return _audioState;
}

inline void SetAudioStateRequest::setAudioState (bool audioState_) {
    set_has_audioState();
    this->_audioState = audioState_;
}

inline void SetAudioStateRequest::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool SetAudioStateRequest::hasSinkId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SetAudioStateRequest::getSinkId () const {
    return _sinkId;
}

inline void SetAudioStateRequest::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void SetAudioStateRequest::set_has_audioState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAudioStateRequest::clear_has_audioState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetAudioStateRequest::set_has_sinkId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetAudioStateRequest::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest ()  :
    _PropertyType (0u),
    _value (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest (const SetMainSinkSoundPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _PropertyType (0u),
    _value (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest (uint16 PropertyType_, int32 value_, uint16 sinkId_)  :
    _PropertyType (PropertyType_),
    _value (value_),
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequest::~SetMainSinkSoundPropertyRequest() {
}

inline SetMainSinkSoundPropertyRequest& SetMainSinkSoundPropertyRequest::operator = (const SetMainSinkSoundPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool SetMainSinkSoundPropertyRequest::operator == (const SetMainSinkSoundPropertyRequest& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool SetMainSinkSoundPropertyRequest::operator != (const SetMainSinkSoundPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSinkSoundPropertyRequest::operator < (const SetMainSinkSoundPropertyRequest& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMainSinkSoundPropertyRequest::clone() {
    return new SetMainSinkSoundPropertyRequest(*this);
}

inline bool SetMainSinkSoundPropertyRequest::operator > (const SetMainSinkSoundPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSinkSoundPropertyRequest::clear() {
    clearPropertyType();
    clearValue();
    clearSinkId();
}

inline void SetMainSinkSoundPropertyRequest::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_PropertyType();
        _PropertyType = 0u;
     }
}

inline bool SetMainSinkSoundPropertyRequest::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetMainSinkSoundPropertyRequest::getPropertyType () const {
    return _PropertyType;
}

inline void SetMainSinkSoundPropertyRequest::setPropertyType (uint16 PropertyType_) {
    set_has_PropertyType();
    this->_PropertyType = PropertyType_;
}

inline void SetMainSinkSoundPropertyRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SetMainSinkSoundPropertyRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SetMainSinkSoundPropertyRequest::getValue () const {
    return _value;
}

inline void SetMainSinkSoundPropertyRequest::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetMainSinkSoundPropertyRequest::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool SetMainSinkSoundPropertyRequest::hasSinkId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 SetMainSinkSoundPropertyRequest::getSinkId () const {
    return _sinkId;
}

inline void SetMainSinkSoundPropertyRequest::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void SetMainSinkSoundPropertyRequest::set_has_PropertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSinkSoundPropertyRequest::clear_has_PropertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMainSinkSoundPropertyRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMainSinkSoundPropertyRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetMainSinkSoundPropertyRequest::set_has_sinkId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetMainSinkSoundPropertyRequest::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest ()  :
    _propertyType (0u),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest (const SetSystemPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _propertyType (0u),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest (uint16 propertyType_, int32 value_)  :
    _propertyType (propertyType_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequest::~SetSystemPropertyRequest() {
}

inline SetSystemPropertyRequest& SetSystemPropertyRequest::operator = (const SetSystemPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetSystemPropertyRequest::operator == (const SetSystemPropertyRequest& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetSystemPropertyRequest::operator != (const SetSystemPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSystemPropertyRequest::operator < (const SetSystemPropertyRequest& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSystemPropertyRequest::clone() {
    return new SetSystemPropertyRequest(*this);
}

inline bool SetSystemPropertyRequest::operator > (const SetSystemPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSystemPropertyRequest::clear() {
    clearPropertyType();
    clearValue();
}

inline void SetSystemPropertyRequest::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_propertyType();
        _propertyType = 0u;
     }
}

inline bool SetSystemPropertyRequest::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetSystemPropertyRequest::getPropertyType () const {
    return _propertyType;
}

inline void SetSystemPropertyRequest::setPropertyType (uint16 propertyType_) {
    set_has_propertyType();
    this->_propertyType = propertyType_;
}

inline void SetSystemPropertyRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SetSystemPropertyRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SetSystemPropertyRequest::getValue () const {
    return _value;
}

inline void SetSystemPropertyRequest::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetSystemPropertyRequest::set_has_propertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSystemPropertyRequest::clear_has_propertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetSystemPropertyRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetSystemPropertyRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestMainSinkSoundPropertyListRequest::RequestMainSinkSoundPropertyListRequest ()  :
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestMainSinkSoundPropertyListRequest::RequestMainSinkSoundPropertyListRequest (const RequestMainSinkSoundPropertyListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestMainSinkSoundPropertyListRequest::RequestMainSinkSoundPropertyListRequest (uint16 sinkId_)  :
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestMainSinkSoundPropertyListRequest::~RequestMainSinkSoundPropertyListRequest() {
}

inline RequestMainSinkSoundPropertyListRequest& RequestMainSinkSoundPropertyListRequest::operator = (const RequestMainSinkSoundPropertyListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool RequestMainSinkSoundPropertyListRequest::operator == (const RequestMainSinkSoundPropertyListRequest& rhs) const {
    return (((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool RequestMainSinkSoundPropertyListRequest::operator != (const RequestMainSinkSoundPropertyListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestMainSinkSoundPropertyListRequest::operator < (const RequestMainSinkSoundPropertyListRequest& rhs) const {
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestMainSinkSoundPropertyListRequest::clone() {
    return new RequestMainSinkSoundPropertyListRequest(*this);
}

inline bool RequestMainSinkSoundPropertyListRequest::operator > (const RequestMainSinkSoundPropertyListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestMainSinkSoundPropertyListRequest::clear() {
    clearSinkId();
}

inline void RequestMainSinkSoundPropertyListRequest::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool RequestMainSinkSoundPropertyListRequest::hasSinkId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 RequestMainSinkSoundPropertyListRequest::getSinkId () const {
    return _sinkId;
}

inline void RequestMainSinkSoundPropertyListRequest::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void RequestMainSinkSoundPropertyListRequest::set_has_sinkId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestMainSinkSoundPropertyListRequest::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VolumeUpdate::VolumeUpdate ()  :
    _volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeUpdate::VolumeUpdate (const VolumeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeUpdate::VolumeUpdate (uint8 volume_)  :
    _volume (volume_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeUpdate::~VolumeUpdate() {
}

inline VolumeUpdate& VolumeUpdate::operator = (const VolumeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolume()) {
            setVolume(rhs.getVolume());
        } else {
            clearVolume();
        }
    }
    return *this;
}

inline bool VolumeUpdate::operator == (const VolumeUpdate& rhs) const {
    return (((!hasVolume() && !rhs.hasVolume()) || getVolume() == rhs.getVolume()));
}

inline bool VolumeUpdate::operator != (const VolumeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeUpdate::operator < (const VolumeUpdate& rhs) const {
    if (hasVolume() || rhs.hasVolume()) {
        if (getVolume() < rhs.getVolume()) return true;
        if (getVolume() > rhs.getVolume()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeUpdate::clone() {
    return new VolumeUpdate(*this);
}

inline bool VolumeUpdate::operator > (const VolumeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeUpdate::clear() {
    clearVolume();
}

inline void VolumeUpdate::clearVolume() {
    if (hasVolume()) {
         clear_has_volume();
        _volume = 0u;
     }
}

inline bool VolumeUpdate::hasVolume () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 VolumeUpdate::getVolume () const {
    return _volume;
}

inline void VolumeUpdate::setVolume (uint8 volume_) {
    set_has_volume();
    this->_volume = volume_;
}

inline void VolumeUpdate::set_has_volume () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeUpdate::clear_has_volume () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VolumeRegister::VolumeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeRegister::VolumeRegister (const VolumeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeRegister::~VolumeRegister() {
}

inline VolumeRegister& VolumeRegister::operator = (const VolumeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VolumeRegister::operator == (const VolumeRegister& ) const {
    return true;
}

inline bool VolumeRegister::operator != (const VolumeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeRegister::operator < (const VolumeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VolumeRegister::clone() {
    return new VolumeRegister(*this);
}

inline bool VolumeRegister::operator > (const VolumeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeRegister::clear() {
}

inline  VolumeMapUpdate::VolumeMapUpdate ()  :
    _volumeMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeMapUpdate::VolumeMapUpdate (const VolumeMapUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _volumeMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeMapUpdate::VolumeMapUpdate (const ::std::map< uint16, uint8 >& volumeMap_)  :
    _volumeMap (volumeMap_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeMapUpdate::~VolumeMapUpdate() {
}

inline VolumeMapUpdate& VolumeMapUpdate::operator = (const VolumeMapUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumeMap()) {
            setVolumeMap(rhs.getVolumeMap());
        } else {
            clearVolumeMap();
        }
    }
    return *this;
}

inline bool VolumeMapUpdate::operator == (const VolumeMapUpdate& rhs) const {
    return (((!hasVolumeMap() && !rhs.hasVolumeMap()) || getVolumeMap() == rhs.getVolumeMap()));
}

inline bool VolumeMapUpdate::operator != (const VolumeMapUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeMapUpdate::operator < (const VolumeMapUpdate& rhs) const {
    if (hasVolumeMap() || rhs.hasVolumeMap()) {
        if (getVolumeMap() < rhs.getVolumeMap()) return true;
        if (getVolumeMap() > rhs.getVolumeMap()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeMapUpdate::clone() {
    return new VolumeMapUpdate(*this);
}

inline bool VolumeMapUpdate::operator > (const VolumeMapUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeMapUpdate::clear() {
    clearVolumeMap();
}

inline void VolumeMapUpdate::clearVolumeMap() {
    if (hasVolumeMap()) {
         clear_has_volumeMap();
        _volumeMap.clear();
     }
}

inline bool VolumeMapUpdate::hasVolumeMap () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< uint16, uint8 >& VolumeMapUpdate::getVolumeMap () const {
    return _volumeMap;
}

inline ::std::map< uint16, uint8 >& VolumeMapUpdate::getVolumeMapMutable () {
    set_has_volumeMap();
    return _volumeMap;
}

inline void VolumeMapUpdate::setVolumeMap (const ::std::map< uint16, uint8 >& volumeMap_) {
    set_has_volumeMap();
    this->_volumeMap = volumeMap_;
}

inline void VolumeMapUpdate::set_has_volumeMap () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeMapUpdate::clear_has_volumeMap () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VolumeMapRegister::VolumeMapRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeMapRegister::VolumeMapRegister (const VolumeMapRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeMapRegister::~VolumeMapRegister() {
}

inline VolumeMapRegister& VolumeMapRegister::operator = (const VolumeMapRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VolumeMapRegister::operator == (const VolumeMapRegister& ) const {
    return true;
}

inline bool VolumeMapRegister::operator != (const VolumeMapRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeMapRegister::operator < (const VolumeMapRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VolumeMapRegister::clone() {
    return new VolumeMapRegister(*this);
}

inline bool VolumeMapRegister::operator > (const VolumeMapRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeMapRegister::clear() {
}

inline  MuteStateUpdate::MuteStateUpdate ()  :
    _muteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteStateUpdate::MuteStateUpdate (const MuteStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _muteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteStateUpdate::MuteStateUpdate (bool muteState_)  :
    _muteState (muteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MuteStateUpdate::~MuteStateUpdate() {
}

inline MuteStateUpdate& MuteStateUpdate::operator = (const MuteStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
    }
    return *this;
}

inline bool MuteStateUpdate::operator == (const MuteStateUpdate& rhs) const {
    return (((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()));
}

inline bool MuteStateUpdate::operator != (const MuteStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteStateUpdate::operator < (const MuteStateUpdate& rhs) const {
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MuteStateUpdate::clone() {
    return new MuteStateUpdate(*this);
}

inline bool MuteStateUpdate::operator > (const MuteStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteStateUpdate::clear() {
    clearMuteState();
}

inline void MuteStateUpdate::clearMuteState() {
    if (hasMuteState()) {
         clear_has_muteState();
        _muteState = false;
     }
}

inline bool MuteStateUpdate::hasMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool MuteStateUpdate::getMuteState () const {
    return _muteState;
}

inline void MuteStateUpdate::setMuteState (bool muteState_) {
    set_has_muteState();
    this->_muteState = muteState_;
}

inline void MuteStateUpdate::set_has_muteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void MuteStateUpdate::clear_has_muteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MuteStateRegister::MuteStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteStateRegister::MuteStateRegister (const MuteStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteStateRegister::~MuteStateRegister() {
}

inline MuteStateRegister& MuteStateRegister::operator = (const MuteStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MuteStateRegister::operator == (const MuteStateRegister& ) const {
    return true;
}

inline bool MuteStateRegister::operator != (const MuteStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteStateRegister::operator < (const MuteStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MuteStateRegister::clone() {
    return new MuteStateRegister(*this);
}

inline bool MuteStateRegister::operator > (const MuteStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteStateRegister::clear() {
}

inline  MuteStateMapUpdate::MuteStateMapUpdate ()  :
    _muteStateMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteStateMapUpdate::MuteStateMapUpdate (const MuteStateMapUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _muteStateMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteStateMapUpdate::MuteStateMapUpdate (const ::std::map< uint16, bool >& muteStateMap_)  :
    _muteStateMap (muteStateMap_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MuteStateMapUpdate::~MuteStateMapUpdate() {
}

inline MuteStateMapUpdate& MuteStateMapUpdate::operator = (const MuteStateMapUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMuteStateMap()) {
            setMuteStateMap(rhs.getMuteStateMap());
        } else {
            clearMuteStateMap();
        }
    }
    return *this;
}

inline bool MuteStateMapUpdate::operator == (const MuteStateMapUpdate& rhs) const {
    return (((!hasMuteStateMap() && !rhs.hasMuteStateMap()) || getMuteStateMap() == rhs.getMuteStateMap()));
}

inline bool MuteStateMapUpdate::operator != (const MuteStateMapUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteStateMapUpdate::operator < (const MuteStateMapUpdate& rhs) const {
    if (hasMuteStateMap() || rhs.hasMuteStateMap()) {
        if (getMuteStateMap() < rhs.getMuteStateMap()) return true;
        if (getMuteStateMap() > rhs.getMuteStateMap()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MuteStateMapUpdate::clone() {
    return new MuteStateMapUpdate(*this);
}

inline bool MuteStateMapUpdate::operator > (const MuteStateMapUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteStateMapUpdate::clear() {
    clearMuteStateMap();
}

inline void MuteStateMapUpdate::clearMuteStateMap() {
    if (hasMuteStateMap()) {
         clear_has_muteStateMap();
        _muteStateMap.clear();
     }
}

inline bool MuteStateMapUpdate::hasMuteStateMap () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< uint16, bool >& MuteStateMapUpdate::getMuteStateMap () const {
    return _muteStateMap;
}

inline ::std::map< uint16, bool >& MuteStateMapUpdate::getMuteStateMapMutable () {
    set_has_muteStateMap();
    return _muteStateMap;
}

inline void MuteStateMapUpdate::setMuteStateMap (const ::std::map< uint16, bool >& muteStateMap_) {
    set_has_muteStateMap();
    this->_muteStateMap = muteStateMap_;
}

inline void MuteStateMapUpdate::set_has_muteStateMap () {
    _has_bits_[0] |= 1u << 0;
}

inline void MuteStateMapUpdate::clear_has_muteStateMap () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MuteStateMapRegister::MuteStateMapRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteStateMapRegister::MuteStateMapRegister (const MuteStateMapRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteStateMapRegister::~MuteStateMapRegister() {
}

inline MuteStateMapRegister& MuteStateMapRegister::operator = (const MuteStateMapRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MuteStateMapRegister::operator == (const MuteStateMapRegister& ) const {
    return true;
}

inline bool MuteStateMapRegister::operator != (const MuteStateMapRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteStateMapRegister::operator < (const MuteStateMapRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MuteStateMapRegister::clone() {
    return new MuteStateMapRegister(*this);
}

inline bool MuteStateMapRegister::operator > (const MuteStateMapRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteStateMapRegister::clear() {
}

inline  AudioStateInfoUpdate::AudioStateInfoUpdate ()  :
    _audioStateInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioStateInfoUpdate::AudioStateInfoUpdate (const AudioStateInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _audioStateInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioStateInfoUpdate::AudioStateInfoUpdate (const AudioStateInfo& audioStateInfo_)  :
    _audioStateInfo (audioStateInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudioStateInfoUpdate::~AudioStateInfoUpdate() {
}

inline AudioStateInfoUpdate& AudioStateInfoUpdate::operator = (const AudioStateInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioStateInfo()) {
            setAudioStateInfo(rhs.getAudioStateInfo());
        } else {
            clearAudioStateInfo();
        }
    }
    return *this;
}

inline bool AudioStateInfoUpdate::operator == (const AudioStateInfoUpdate& rhs) const {
    return (((!hasAudioStateInfo() && !rhs.hasAudioStateInfo()) || getAudioStateInfo() == rhs.getAudioStateInfo()));
}

inline bool AudioStateInfoUpdate::operator != (const AudioStateInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioStateInfoUpdate::operator < (const AudioStateInfoUpdate& rhs) const {
    if (hasAudioStateInfo() || rhs.hasAudioStateInfo()) {
        if (getAudioStateInfo() < rhs.getAudioStateInfo()) return true;
        if (getAudioStateInfo() > rhs.getAudioStateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudioStateInfoUpdate::clone() {
    return new AudioStateInfoUpdate(*this);
}

inline bool AudioStateInfoUpdate::operator > (const AudioStateInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioStateInfoUpdate::clear() {
    clearAudioStateInfo();
}

inline void AudioStateInfoUpdate::clearAudioStateInfo() {
    if (hasAudioStateInfo()) {
         clear_has_audioStateInfo();
        _audioStateInfo.clear();
     }
}

inline bool AudioStateInfoUpdate::hasAudioStateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const AudioStateInfo& AudioStateInfoUpdate::getAudioStateInfo () const {
    return _audioStateInfo;
}

inline AudioStateInfo& AudioStateInfoUpdate::getAudioStateInfoMutable () {
    set_has_audioStateInfo();
    return _audioStateInfo;
}

inline void AudioStateInfoUpdate::setAudioStateInfo (const AudioStateInfo& audioStateInfo_) {
    set_has_audioStateInfo();
    this->_audioStateInfo = audioStateInfo_;
}

inline void AudioStateInfoUpdate::set_has_audioStateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudioStateInfoUpdate::clear_has_audioStateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudioStateInfoRegister::AudioStateInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioStateInfoRegister::AudioStateInfoRegister (const AudioStateInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioStateInfoRegister::~AudioStateInfoRegister() {
}

inline AudioStateInfoRegister& AudioStateInfoRegister::operator = (const AudioStateInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AudioStateInfoRegister::operator == (const AudioStateInfoRegister& ) const {
    return true;
}

inline bool AudioStateInfoRegister::operator != (const AudioStateInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioStateInfoRegister::operator < (const AudioStateInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AudioStateInfoRegister::clone() {
    return new AudioStateInfoRegister(*this);
}

inline bool AudioStateInfoRegister::operator > (const AudioStateInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioStateInfoRegister::clear() {
}

inline  AudioStateInfoMapUpdate::AudioStateInfoMapUpdate ()  :
    _audioStateInfoMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioStateInfoMapUpdate::AudioStateInfoMapUpdate (const AudioStateInfoMapUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _audioStateInfoMap ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioStateInfoMapUpdate::AudioStateInfoMapUpdate (const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap_)  :
    _audioStateInfoMap (audioStateInfoMap_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudioStateInfoMapUpdate::~AudioStateInfoMapUpdate() {
}

inline AudioStateInfoMapUpdate& AudioStateInfoMapUpdate::operator = (const AudioStateInfoMapUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioStateInfoMap()) {
            setAudioStateInfoMap(rhs.getAudioStateInfoMap());
        } else {
            clearAudioStateInfoMap();
        }
    }
    return *this;
}

inline bool AudioStateInfoMapUpdate::operator == (const AudioStateInfoMapUpdate& rhs) const {
    return (((!hasAudioStateInfoMap() && !rhs.hasAudioStateInfoMap()) || getAudioStateInfoMap() == rhs.getAudioStateInfoMap()));
}

inline bool AudioStateInfoMapUpdate::operator != (const AudioStateInfoMapUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioStateInfoMapUpdate::operator < (const AudioStateInfoMapUpdate& rhs) const {
    if (hasAudioStateInfoMap() || rhs.hasAudioStateInfoMap()) {
        if (getAudioStateInfoMap() < rhs.getAudioStateInfoMap()) return true;
        if (getAudioStateInfoMap() > rhs.getAudioStateInfoMap()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudioStateInfoMapUpdate::clone() {
    return new AudioStateInfoMapUpdate(*this);
}

inline bool AudioStateInfoMapUpdate::operator > (const AudioStateInfoMapUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioStateInfoMapUpdate::clear() {
    clearAudioStateInfoMap();
}

inline void AudioStateInfoMapUpdate::clearAudioStateInfoMap() {
    if (hasAudioStateInfoMap()) {
         clear_has_audioStateInfoMap();
        _audioStateInfoMap.clear();
     }
}

inline bool AudioStateInfoMapUpdate::hasAudioStateInfoMap () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< uint16, AudioStateInfo >& AudioStateInfoMapUpdate::getAudioStateInfoMap () const {
    return _audioStateInfoMap;
}

inline ::std::map< uint16, AudioStateInfo >& AudioStateInfoMapUpdate::getAudioStateInfoMapMutable () {
    set_has_audioStateInfoMap();
    return _audioStateInfoMap;
}

inline void AudioStateInfoMapUpdate::setAudioStateInfoMap (const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap_) {
    set_has_audioStateInfoMap();
    this->_audioStateInfoMap = audioStateInfoMap_;
}

inline void AudioStateInfoMapUpdate::set_has_audioStateInfoMap () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudioStateInfoMapUpdate::clear_has_audioStateInfoMap () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AudioStateInfoMapRegister::AudioStateInfoMapRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioStateInfoMapRegister::AudioStateInfoMapRegister (const AudioStateInfoMapRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioStateInfoMapRegister::~AudioStateInfoMapRegister() {
}

inline AudioStateInfoMapRegister& AudioStateInfoMapRegister::operator = (const AudioStateInfoMapRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AudioStateInfoMapRegister::operator == (const AudioStateInfoMapRegister& ) const {
    return true;
}

inline bool AudioStateInfoMapRegister::operator != (const AudioStateInfoMapRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioStateInfoMapRegister::operator < (const AudioStateInfoMapRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AudioStateInfoMapRegister::clone() {
    return new AudioStateInfoMapRegister(*this);
}

inline bool AudioStateInfoMapRegister::operator > (const AudioStateInfoMapRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioStateInfoMapRegister::clear() {
}

inline  SystemPropertyListUpdate::SystemPropertyListUpdate ()  :
    _systemPropertyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemPropertyListUpdate::SystemPropertyListUpdate (const SystemPropertyListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _systemPropertyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemPropertyListUpdate::SystemPropertyListUpdate (const ::std::vector< SystemProperty >& systemPropertyList_)  :
    _systemPropertyList (systemPropertyList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemPropertyListUpdate::~SystemPropertyListUpdate() {
}

inline SystemPropertyListUpdate& SystemPropertyListUpdate::operator = (const SystemPropertyListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSystemPropertyList()) {
            setSystemPropertyList(rhs.getSystemPropertyList());
        } else {
            clearSystemPropertyList();
        }
    }
    return *this;
}

inline bool SystemPropertyListUpdate::operator == (const SystemPropertyListUpdate& rhs) const {
    return (((!hasSystemPropertyList() && !rhs.hasSystemPropertyList()) || getSystemPropertyList() == rhs.getSystemPropertyList()));
}

inline bool SystemPropertyListUpdate::operator != (const SystemPropertyListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemPropertyListUpdate::operator < (const SystemPropertyListUpdate& rhs) const {
    if (hasSystemPropertyList() || rhs.hasSystemPropertyList()) {
        if (getSystemPropertyList() < rhs.getSystemPropertyList()) return true;
        if (getSystemPropertyList() > rhs.getSystemPropertyList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemPropertyListUpdate::clone() {
    return new SystemPropertyListUpdate(*this);
}

inline bool SystemPropertyListUpdate::operator > (const SystemPropertyListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemPropertyListUpdate::clear() {
    clearSystemPropertyList();
}

inline void SystemPropertyListUpdate::clearSystemPropertyList() {
    if (hasSystemPropertyList()) {
         clear_has_systemPropertyList();
        _systemPropertyList.clear();
     }
}

inline bool SystemPropertyListUpdate::hasSystemPropertyList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SystemProperty >& SystemPropertyListUpdate::getSystemPropertyList () const {
    return _systemPropertyList;
}

inline ::std::vector< SystemProperty >& SystemPropertyListUpdate::getSystemPropertyListMutable () {
    set_has_systemPropertyList();
    return _systemPropertyList;
}

inline void SystemPropertyListUpdate::setSystemPropertyList (const ::std::vector< SystemProperty >& systemPropertyList_) {
    set_has_systemPropertyList();
    this->_systemPropertyList = systemPropertyList_;
}

inline void SystemPropertyListUpdate::set_has_systemPropertyList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemPropertyListUpdate::clear_has_systemPropertyList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SystemPropertyListRegister::SystemPropertyListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemPropertyListRegister::SystemPropertyListRegister (const SystemPropertyListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemPropertyListRegister::~SystemPropertyListRegister() {
}

inline SystemPropertyListRegister& SystemPropertyListRegister::operator = (const SystemPropertyListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SystemPropertyListRegister::operator == (const SystemPropertyListRegister& ) const {
    return true;
}

inline bool SystemPropertyListRegister::operator != (const SystemPropertyListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemPropertyListRegister::operator < (const SystemPropertyListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SystemPropertyListRegister::clone() {
    return new SystemPropertyListRegister(*this);
}

inline bool SystemPropertyListRegister::operator > (const SystemPropertyListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemPropertyListRegister::clear() {
}

inline  SoundPropertyListUpdate::SoundPropertyListUpdate ()  :
    _soundPropertyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoundPropertyListUpdate::SoundPropertyListUpdate (const SoundPropertyListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _soundPropertyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoundPropertyListUpdate::SoundPropertyListUpdate (const SoundPropertyData& soundPropertyList_)  :
    _soundPropertyList (soundPropertyList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SoundPropertyListUpdate::~SoundPropertyListUpdate() {
}

inline SoundPropertyListUpdate& SoundPropertyListUpdate::operator = (const SoundPropertyListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundPropertyList()) {
            setSoundPropertyList(rhs.getSoundPropertyList());
        } else {
            clearSoundPropertyList();
        }
    }
    return *this;
}

inline bool SoundPropertyListUpdate::operator == (const SoundPropertyListUpdate& rhs) const {
    return (((!hasSoundPropertyList() && !rhs.hasSoundPropertyList()) || getSoundPropertyList() == rhs.getSoundPropertyList()));
}

inline bool SoundPropertyListUpdate::operator != (const SoundPropertyListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SoundPropertyListUpdate::operator < (const SoundPropertyListUpdate& rhs) const {
    if (hasSoundPropertyList() || rhs.hasSoundPropertyList()) {
        if (getSoundPropertyList() < rhs.getSoundPropertyList()) return true;
        if (getSoundPropertyList() > rhs.getSoundPropertyList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SoundPropertyListUpdate::clone() {
    return new SoundPropertyListUpdate(*this);
}

inline bool SoundPropertyListUpdate::operator > (const SoundPropertyListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoundPropertyListUpdate::clear() {
    clearSoundPropertyList();
}

inline void SoundPropertyListUpdate::clearSoundPropertyList() {
    if (hasSoundPropertyList()) {
         clear_has_soundPropertyList();
        _soundPropertyList.clear();
     }
}

inline bool SoundPropertyListUpdate::hasSoundPropertyList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SoundPropertyData& SoundPropertyListUpdate::getSoundPropertyList () const {
    return _soundPropertyList;
}

inline SoundPropertyData& SoundPropertyListUpdate::getSoundPropertyListMutable () {
    set_has_soundPropertyList();
    return _soundPropertyList;
}

inline void SoundPropertyListUpdate::setSoundPropertyList (const SoundPropertyData& soundPropertyList_) {
    set_has_soundPropertyList();
    this->_soundPropertyList = soundPropertyList_;
}

inline void SoundPropertyListUpdate::set_has_soundPropertyList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SoundPropertyListUpdate::clear_has_soundPropertyList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SoundPropertyListRegister::SoundPropertyListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoundPropertyListRegister::SoundPropertyListRegister (const SoundPropertyListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoundPropertyListRegister::~SoundPropertyListRegister() {
}

inline SoundPropertyListRegister& SoundPropertyListRegister::operator = (const SoundPropertyListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SoundPropertyListRegister::operator == (const SoundPropertyListRegister& ) const {
    return true;
}

inline bool SoundPropertyListRegister::operator != (const SoundPropertyListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SoundPropertyListRegister::operator < (const SoundPropertyListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SoundPropertyListRegister::clone() {
    return new SoundPropertyListRegister(*this);
}

inline bool SoundPropertyListRegister::operator > (const SoundPropertyListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoundPropertyListRegister::clear() {
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal ()  :
    _PropertyType (0),
    _value (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal (const MainSinkSoundPropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PropertyType (0),
    _value (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal (int32 PropertyType_, int32 value_, uint16 sinkId_)  :
    _PropertyType (PropertyType_),
    _value (value_),
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignal::~MainSinkSoundPropertyChangedSignal() {
}

inline MainSinkSoundPropertyChangedSignal& MainSinkSoundPropertyChangedSignal::operator = (const MainSinkSoundPropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool MainSinkSoundPropertyChangedSignal::operator == (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool MainSinkSoundPropertyChangedSignal::operator != (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MainSinkSoundPropertyChangedSignal::operator < (const MainSinkSoundPropertyChangedSignal& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MainSinkSoundPropertyChangedSignal::clone() {
    return new MainSinkSoundPropertyChangedSignal(*this);
}

inline bool MainSinkSoundPropertyChangedSignal::operator > (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainSinkSoundPropertyChangedSignal::clear() {
    clearPropertyType();
    clearValue();
    clearSinkId();
}

inline void MainSinkSoundPropertyChangedSignal::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_PropertyType();
        _PropertyType = 0;
     }
}

inline bool MainSinkSoundPropertyChangedSignal::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 MainSinkSoundPropertyChangedSignal::getPropertyType () const {
    return _PropertyType;
}

inline void MainSinkSoundPropertyChangedSignal::setPropertyType (int32 PropertyType_) {
    set_has_PropertyType();
    this->_PropertyType = PropertyType_;
}

inline void MainSinkSoundPropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool MainSinkSoundPropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 MainSinkSoundPropertyChangedSignal::getValue () const {
    return _value;
}

inline void MainSinkSoundPropertyChangedSignal::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void MainSinkSoundPropertyChangedSignal::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool MainSinkSoundPropertyChangedSignal::hasSinkId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 MainSinkSoundPropertyChangedSignal::getSinkId () const {
    return _sinkId;
}

inline void MainSinkSoundPropertyChangedSignal::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void MainSinkSoundPropertyChangedSignal::set_has_PropertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainSinkSoundPropertyChangedSignal::clear_has_PropertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainSinkSoundPropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainSinkSoundPropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MainSinkSoundPropertyChangedSignal::set_has_sinkId () {
    _has_bits_[0] |= 1u << 2;
}

inline void MainSinkSoundPropertyChangedSignal::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal ()  :
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal (const SystemPropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PropertyType (0),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal (int32 PropertyType_, int32 value_)  :
    _PropertyType (PropertyType_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignal::~SystemPropertyChangedSignal() {
}

inline SystemPropertyChangedSignal& SystemPropertyChangedSignal::operator = (const SystemPropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPropertyType()) {
            setPropertyType(rhs.getPropertyType());
        } else {
            clearPropertyType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SystemPropertyChangedSignal::operator == (const SystemPropertyChangedSignal& rhs) const {
    return (((!hasPropertyType() && !rhs.hasPropertyType()) || getPropertyType() == rhs.getPropertyType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SystemPropertyChangedSignal::operator != (const SystemPropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemPropertyChangedSignal::operator < (const SystemPropertyChangedSignal& rhs) const {
    if (hasPropertyType() || rhs.hasPropertyType()) {
        if (getPropertyType() < rhs.getPropertyType()) return true;
        if (getPropertyType() > rhs.getPropertyType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemPropertyChangedSignal::clone() {
    return new SystemPropertyChangedSignal(*this);
}

inline bool SystemPropertyChangedSignal::operator > (const SystemPropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemPropertyChangedSignal::clear() {
    clearPropertyType();
    clearValue();
}

inline void SystemPropertyChangedSignal::clearPropertyType() {
    if (hasPropertyType()) {
         clear_has_PropertyType();
        _PropertyType = 0;
     }
}

inline bool SystemPropertyChangedSignal::hasPropertyType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SystemPropertyChangedSignal::getPropertyType () const {
    return _PropertyType;
}

inline void SystemPropertyChangedSignal::setPropertyType (int32 PropertyType_) {
    set_has_PropertyType();
    this->_PropertyType = PropertyType_;
}

inline void SystemPropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SystemPropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SystemPropertyChangedSignal::getValue () const {
    return _value;
}

inline void SystemPropertyChangedSignal::setValue (int32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SystemPropertyChangedSignal::set_has_PropertyType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemPropertyChangedSignal::clear_has_PropertyType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SystemPropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SystemPropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace SoundProperties
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
