/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGESTUB_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace AudioSourceChange {

class AudioSourceChangeStubDelegate;

class AudioSourceChangeStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AudioSourceChangeStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AudioSourceChangeStub (const std::string& portName);

    /**
     * Create an instance of the AudioSourceChangeStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AudioSourceChangeStub (const std::string& portName, const std::string& objectPath);

    virtual ~AudioSourceChangeStub();

    // signal 'sourceActivated'

    /**
     * Raise the signal 'sourceActivated' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sourceActivated'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param sourceId If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     */
    void sendSourceActivatedSignal(int32 sourceId, uint16 sinkId);

    // signal 'sourceListChanged'

    /**
     * Raise the signal 'sourceListChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sourceListChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param groupId If the meaning of "groupId" isn't clear, then there should be a description here.
     */
    void sendSourceListChangedSignal(int32 groupId);

    // signal 'sourceAvailabilityChanged'

    /**
     * Raise the signal 'sourceAvailabilityChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'sourceAvailabilityChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source Availability for a particular source
     *
     * @param sourceAvailability If the meaning of "sourceAvailability" isn't clear, then there should be a description here.
     */
    void sendSourceAvailabilityChangedSignal(const sourceDetails& sourceAvailability);

    // property 'activeSource'

    /**
     * The method onActiveSourceGet() is called by ASF when a client invokes
     * the read method for the property 'activeSource'. The
     * onActiveSourceGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     */
    virtual void onActiveSourceGet(const ::boost::shared_ptr< ActiveSourceGet >& payload);

    /**
     * Sends back the update to a previous onActiveSourceGet().
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     *
     * @param act Identifies a previous invocation of onActiveSourceGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveSourceGetUpdate(const sourceData& activeSource, act_t act = 0);

    /**
     * Set the value of the property 'activeSource' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     */
    void setActiveSource(const sourceData& activeSource);

    /**
     * Returns the current value of the property 'activeSource'.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     */
    const sourceData& getActiveSource() const;

    /**
     * Returns the current value of the property 'activeSource' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendActiveSourceUpdate() method.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     */
    sourceData& getActiveSourceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveSourceUpdate().
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     */
    void sendActiveSourceUpdate();

    // property 'activeSourceList'

    /**
     * The method onActiveSourceListGet() is called by ASF when a client
     * invokes the read method for the property 'activeSourceList'. The
     * onActiveSourceListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     */
    virtual void onActiveSourceListGet(const ::boost::shared_ptr< ActiveSourceListGet >& payload);

    /**
     * Sends back the update to a previous onActiveSourceListGet().
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     *
     * @param act Identifies a previous invocation of onActiveSourceListGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveSourceListGetUpdate(const ::std::vector< sourceData >& activeSourceList, act_t act = 0);

    /**
     * Set the value of the property 'activeSourceList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     */
    void setActiveSourceList(const ::std::vector< sourceData >& activeSourceList);

    /**
     * Returns the current value of the property 'activeSourceList'.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     */
    const ::std::vector< sourceData >& getActiveSourceList() const;

    /**
     * Returns the current value of the property 'activeSourceList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendActiveSourceListUpdate() method.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     */
    ::std::vector< sourceData >& getActiveSourceListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveSourceListUpdate().
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     */
    void sendActiveSourceListUpdate();

    // method 'activateSource'

    /**
     * The method onActivateSource() is called by ASF when a client invokes
     * the method 'activateSource'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendActivateSource() or sendActivateSourceError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'activateSource'</b>:
     *
     * Method for Source change request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActivateSourceRequest (const ::boost::shared_ptr< ActivateSourceRequest >& request) = 0;

    /**
     * The method sendActivateSourceResponse() sends a response of a previous
     * method invocation of 'activateSource' back to the client.
     *
     * <b>Documentation of 'activateSource'</b>:
     *
     * Method for Source change request
     *
     * @param act The parameter act identifies a previous invocation of
     * onActivateSource(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendActivateSourceResponse (act_t act = 0);

    /**
     * The method sendActivateSourceError() sends an error response of a
     * previous method invocation of 'activateSource' back to the client.
     *
     * <b>Documentation of 'activateSource'</b>:
     *
     * Method for Source change request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onActivateSource(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActivateSourceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'deactivateSource'

    /**
     * The method onDeactivateSource() is called by ASF when a client invokes
     * the method 'deactivateSource'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDeactivateSource() or sendDeactivateSourceError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'deactivateSource'</b>:
     *
     * Method for Source change deactivation
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeactivateSourceRequest (const ::boost::shared_ptr< DeactivateSourceRequest >& request) = 0;

    /**
     * The method sendDeactivateSourceResponse() sends a response of a
     * previous method invocation of 'deactivateSource' back to the client.
     *
     * <b>Documentation of 'deactivateSource'</b>:
     *
     * Method for Source change deactivation
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeactivateSource(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDeactivateSourceResponse (act_t act = 0);

    /**
     * The method sendDeactivateSourceError() sends an error response of a
     * previous method invocation of 'deactivateSource' back to the client.
     *
     * <b>Documentation of 'deactivateSource'</b>:
     *
     * Method for Source change deactivation
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDeactivateSource(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeactivateSourceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getSourceList'

    /**
     * The method onGetSourceList() is called by ASF when a client invokes the
     * method 'getSourceList'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetSourceList()
     * or sendGetSourceListError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'getSourceList'</b>:
     *
     * Method to get the list of available sources for activation
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetSourceListRequest (const ::boost::shared_ptr< GetSourceListRequest >& request) = 0;

    /**
     * The method sendGetSourceListResponse() sends a response of a previous
     * method invocation of 'getSourceList' back to the client.
     *
     * <b>Documentation of 'getSourceList'</b>:
     *
     * Method to get the list of available sources for activation
     *
     * @param sources If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetSourceList(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetSourceListResponse (const ::std::vector< sourceDetails >& sources, act_t act = 0);

    /**
     * The method sendGetSourceListError() sends an error response of a
     * previous method invocation of 'getSourceList' back to the client.
     *
     * <b>Documentation of 'getSourceList'</b>:
     *
     * Method to get the list of available sources for activation
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetSourceList(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetSourceListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ActiveSourceUpdate _activeSourceProperty;

    ActiveSourceListUpdate _activeSourceListProperty;

    friend class AudioSourceChangeStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace AudioSourceChange
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGESTUB_H
