/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeDBus.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeJson.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace AudioSourceChange {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/masteraudioservice/bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange", AudioSourceChangeStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "getSourceList", 2 },
    { 14, "activateSource", 0 },
    { 16, "deactivateSource", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 12, "activeSource", 0 },
    { 16, "activeSourceList", 1 },
};

class AudioSourceChangeStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AudioSourceChangeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AudioSourceChangeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AudioSourceChangeStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange"),
          _logger(logger) {}

    virtual ~AudioSourceChangeStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AudioSourceChangeStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'activateSource'

            LOG_DEBUG_STUB("process method '%s'", "activateSource");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateSourceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ActivateSource", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActivateSourceRequest > payload = ::boost::static_pointer_cast<ActivateSourceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioSourceChangeStub*>(getStub())->onActivateSourceRequest(payload);
            return;
        }
        case 1: {

            // method 'deactivateSource'

            LOG_DEBUG_STUB("process method '%s'", "deactivateSource");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateSourceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeactivateSource", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeactivateSourceRequest > payload = ::boost::static_pointer_cast<DeactivateSourceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioSourceChangeStub*>(getStub())->onDeactivateSourceRequest(payload);
            return;
        }
        case 2: {

            // method 'getSourceList'

            LOG_DEBUG_STUB("process method '%s'", "getSourceList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSourceListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetSourceList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetSourceListRequest > payload = ::boost::static_pointer_cast<GetSourceListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioSourceChangeStub*>(getStub())->onGetSourceListRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AudioSourceChangeStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange\">\n"
            "    <property access=\"read\" name=\"activeSource\" type=\"(iiqu)\"/>\n"
            "    <property access=\"read\" name=\"activeSourceList\" type=\"a(iiqu)\"/>\n"
            "    <method name=\"activateSource\">\n"
            "      <doc>\n"
            "        <line>activateSource = Method for Source change request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sourceInfo\" type=\"(iiqu)\">\n"
            "        <doc>\n"
            "          <line>sourceInfo (of type sourceData) = Description missing</line>\n"
            "          <line>sourceData struct[srcId, subSrcId, sinkId, connectionState] = todo</line>\n"
            "          <line>0: sourceData.srcId ('i') = Description missing</line>\n"
            "          <line>1: sourceData.subSrcId ('i') = Description missing</line>\n"
            "          <line>2: sourceData.sinkId ('q') = Description missing</line>\n"
            "          <line>3: sourceData.connectionState ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"forceViewChange\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>forceViewChange = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"deactivateSource\">\n"
            "      <doc>\n"
            "        <line>deactivateSource = Method for Source change deactivation</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sourceInfo\" type=\"(iiqu)\">\n"
            "        <doc>\n"
            "          <line>sourceInfo (of type sourceData) = Description missing</line>\n"
            "          <line>sourceData struct[srcId, subSrcId, sinkId, connectionState] = todo</line>\n"
            "          <line>0: sourceData.srcId ('i') = Description missing</line>\n"
            "          <line>1: sourceData.subSrcId ('i') = Description missing</line>\n"
            "          <line>2: sourceData.sinkId ('q') = Description missing</line>\n"
            "          <line>3: sourceData.connectionState ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getSourceList\">\n"
            "      <doc>\n"
            "        <line>getSourceList = Method to get the list of available sources for activation</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"srcGroupId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>srcGroupId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sources\" type=\"a(iiii)\">\n"
            "        <doc>\n"
            "          <line>sources = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sourceActivated\">\n"
            "      <doc>\n"
            "        <line>sourceActivated = Signal to indicate that there is a change in the Source List under a particular group</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"sourceId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>sourceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sinkId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>sinkId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sourceListChanged\">\n"
            "      <doc>\n"
            "        <line>sourceListChanged = Signal to indicate that there is a change in the Source List under a particular group</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"groupId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>groupId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sourceAvailabilityChanged\">\n"
            "      <doc>\n"
            "        <line>sourceAvailabilityChanged = Signal to indicate that there is a change in the Source Availability for a particular source</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"sourceAvailability\" type=\"(iiii)\">\n"
            "        <doc>\n"
            "          <line>sourceAvailability (of type sourceDetails) = Description missing</line>\n"
            "          <line>sourceDetails struct[srcId, subSrcId, availability, availabilityReason] = todo</line>\n"
            "          <line>0: sourceDetails.srcId ('i') = Description missing</line>\n"
            "          <line>1: sourceDetails.subSrcId ('i') = Description missing</line>\n"
            "          <line>2: sourceDetails.availability ('i') = Description missing</line>\n"
            "          <line>3: sourceDetails.availabilityReason ('i') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void AudioSourceChangeStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AudioSourceChangeStub*>(getStub()))->onGetAll (properties);
}

void AudioSourceChangeStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeSource");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "activeSourceList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AudioSourceChangeStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeSource");
            ::boost::shared_ptr< ActiveSourceGet > payload(new ActiveSourceGet());
            payload->setAct(act);
            static_cast<AudioSourceChangeStub*>(getStub())->onActiveSourceGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "activeSourceList");
            ::boost::shared_ptr< ActiveSourceListGet > payload(new ActiveSourceListGet());
            payload->setAct(act);
            static_cast<AudioSourceChangeStub*>(getStub())->onActiveSourceListGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AudioSourceChangeStub::AudioSourceChangeStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AudioSourceChangeStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AudioSourceChangeStub::AudioSourceChangeStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AudioSourceChangeStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AudioSourceChangeStub::~AudioSourceChangeStub() {
    delete _stubDelegate;
}

void AudioSourceChangeStub::sendSourceActivatedSignal(int32 sourceId, uint16 sinkId) {
    if (_stubDelegate->isConnected()) {
        SourceActivatedSignal* payload = new SourceActivatedSignal(sourceId, sinkId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sourceActivated", SourceActivatedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceActivated");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceActivated");
    }
}

void AudioSourceChangeStub::sendSourceListChangedSignal(int32 groupId) {
    if (_stubDelegate->isConnected()) {
        SourceListChangedSignal* payload = new SourceListChangedSignal(groupId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sourceListChanged", SourceListChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceListChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceListChanged");
    }
}

void AudioSourceChangeStub::sendSourceAvailabilityChangedSignal(const sourceDetails& sourceAvailability) {
    if (_stubDelegate->isConnected()) {
        SourceAvailabilityChangedSignal* payload = new SourceAvailabilityChangedSignal(sourceAvailability);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sourceAvailabilityChanged", SourceAvailabilityChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceAvailabilityChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceAvailabilityChanged");
    }
}

void AudioSourceChangeStub::sendActiveSourceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveSourceUpdate payload(_activeSourceProperty);

        LOG_INFO ("-> send%s", "ActiveSourceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeSource", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveSourceUpdate");
    }
}

void AudioSourceChangeStub::onActiveSourceGet(const ::boost::shared_ptr< ActiveSourceGet >& activeSource) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveSourceGet", activeSource->getAct());
    sendActiveSourceGetUpdate(_activeSourceProperty.getActiveSource(), activeSource->getAct());
}

void AudioSourceChangeStub::sendActiveSourceGetUpdate(const sourceData& activeSource, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveSourceGet payload(activeSource);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveSourceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AudioSourceChangeStub::setActiveSource(const sourceData& activeSource) {
    if(activeSource!=_activeSourceProperty.getActiveSource()) {
        _activeSourceProperty.setActiveSource(activeSource);
        sendActiveSourceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const sourceData& AudioSourceChangeStub::getActiveSource() const {
    return _activeSourceProperty.getActiveSource();
}

sourceData& AudioSourceChangeStub::getActiveSourceMutable() {
    return _activeSourceProperty.getActiveSourceMutable();
}

void AudioSourceChangeStub::sendActiveSourceListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveSourceListUpdate payload(_activeSourceListProperty);

        LOG_INFO ("-> send%s", "ActiveSourceListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeSourceList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveSourceListUpdate");
    }
}

void AudioSourceChangeStub::onActiveSourceListGet(const ::boost::shared_ptr< ActiveSourceListGet >& activeSourceList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveSourceListGet", activeSourceList->getAct());
    sendActiveSourceListGetUpdate(_activeSourceListProperty.getActiveSourceList(), activeSourceList->getAct());
}

void AudioSourceChangeStub::sendActiveSourceListGetUpdate(const ::std::vector< sourceData >& activeSourceList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveSourceListGet payload(activeSourceList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveSourceListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AudioSourceChangeStub::setActiveSourceList(const ::std::vector< sourceData >& activeSourceList) {
    if(activeSourceList!=_activeSourceListProperty.getActiveSourceList()) {
        _activeSourceListProperty.setActiveSourceList(activeSourceList);
        sendActiveSourceListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< sourceData >& AudioSourceChangeStub::getActiveSourceList() const {
    return _activeSourceListProperty.getActiveSourceList();
}

::std::vector< sourceData >& AudioSourceChangeStub::getActiveSourceListMutable() {
    return _activeSourceListProperty.getActiveSourceListMutable();
}

void  AudioSourceChangeStub::sendActivateSourceResponse (act_t act) {
    ActivateSourceResponse* payload = new ActivateSourceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "activateSource", ActivateSourceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ActivateSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioSourceChangeStub::sendActivateSourceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ActivateSourceError* payload = new ActivateSourceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "activateSource", ActivateSourceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ActivateSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioSourceChangeStub::sendDeactivateSourceResponse (act_t act) {
    DeactivateSourceResponse* payload = new DeactivateSourceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "deactivateSource", DeactivateSourceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeactivateSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioSourceChangeStub::sendDeactivateSourceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeactivateSourceError* payload = new DeactivateSourceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "deactivateSource", DeactivateSourceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeactivateSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioSourceChangeStub::sendGetSourceListResponse (const ::std::vector< sourceDetails >& sources, act_t act) {
    GetSourceListResponse* payload = new GetSourceListResponse(sources);
    DBUS_MESSAGE_REPLY(dbusMessage, "getSourceList", GetSourceListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetSourceList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioSourceChangeStub::sendGetSourceListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetSourceListError* payload = new GetSourceListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getSourceList", GetSourceListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetSourceList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AudioSourceChangeStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'activeSource'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveSourceGet payload(_activeSourceProperty.getActiveSource());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeSource", variant));
    }

    //property 'activeSourceList'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveSourceListGet payload(_activeSourceListProperty.getActiveSourceList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeSourceList", variant));
    }
}

} // namespace AudioSourceChange
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
