/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGEPROXY_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace AudioSourceChange {

class AudioSourceChangeProxy;

class ActivateSourceCallbackIF {
public:
    virtual ~ActivateSourceCallbackIF() {}

    virtual void onActivateSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActivateSourceError >& error) = 0;

    virtual void onActivateSourceResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActivateSourceResponse >& response) = 0;
};

class ActiveSourceCallbackIF {
public:
    virtual ~ActiveSourceCallbackIF() {}

    virtual void onActiveSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceError >& error) = 0;

    virtual void onActiveSourceUpdate(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceUpdate >& update) = 0;
};

class ActiveSourceListCallbackIF {
public:
    virtual ~ActiveSourceListCallbackIF() {}

    virtual void onActiveSourceListError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceListError >& error) = 0;

    virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< ActiveSourceListUpdate >& update) = 0;
};

class DeactivateSourceCallbackIF {
public:
    virtual ~DeactivateSourceCallbackIF() {}

    virtual void onDeactivateSourceError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< DeactivateSourceError >& error) = 0;

    virtual void onDeactivateSourceResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< DeactivateSourceResponse >& response) = 0;
};

class GetSourceListCallbackIF {
public:
    virtual ~GetSourceListCallbackIF() {}

    virtual void onGetSourceListError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< GetSourceListError >& error) = 0;

    virtual void onGetSourceListResponse(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< GetSourceListResponse >& response) = 0;
};

class SourceActivatedCallbackIF {
public:
    virtual ~SourceActivatedCallbackIF() {}

    virtual void onSourceActivatedError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceActivatedError >& error) = 0;

    virtual void onSourceActivatedSignal(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceActivatedSignal >& signal) = 0;
};

class SourceAvailabilityChangedCallbackIF {
public:
    virtual ~SourceAvailabilityChangedCallbackIF() {}

    virtual void onSourceAvailabilityChangedError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityChangedError >& error) = 0;

    virtual void onSourceAvailabilityChangedSignal(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityChangedSignal >& signal) = 0;
};

class SourceListChangedCallbackIF {
public:
    virtual ~SourceListChangedCallbackIF() {}

    virtual void onSourceListChangedError(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceListChangedError >& error) = 0;

    virtual void onSourceListChangedSignal(const ::boost::shared_ptr< AudioSourceChangeProxy >& proxy, const ::boost::shared_ptr< SourceListChangedSignal >& signal) = 0;
};


/**
 * AudioSourceChangeProxy is the client side representation of the D-Bus
 * service interface
 * 'bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange' (specified in
 * file AudioSourceChange_.xml).
 *
 * todo
 */
class AudioSourceChangeProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of AudioSourceChangeProxy.
     */
    static ::boost::shared_ptr< AudioSourceChangeProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of AudioSourceChangeProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< AudioSourceChangeProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of AudioSourceChangeProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< AudioSourceChangeProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< AudioSourceChangeProxy > proxyNew(new AudioSourceChangeProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~AudioSourceChangeProxy ();


    // Signal 'sourceActivated'

    /**
     * Notify on the signal 'sourceActivated'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sourceActivated'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceActivatedRegister(SourceActivatedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sourceActivated'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sourceActivated'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param act The act which was previously returned by the
     * sendSourceActivatedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceActivatedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sourceActivated'.
     */
    void sendSourceActivatedDeregisterAll () const;

    // Signal 'sourceListChanged'

    /**
     * Notify on the signal 'sourceListChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sourceListChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceListChangedRegister(SourceListChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sourceListChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sourceListChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source List under a particular group
     *
     * @param act The act which was previously returned by the
     * sendSourceListChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceListChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sourceListChanged'.
     */
    void sendSourceListChangedDeregisterAll () const;

    // Signal 'sourceAvailabilityChanged'

    /**
     * Notify on the signal 'sourceAvailabilityChanged'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sourceAvailabilityChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source Availability for a particular source
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailabilityChangedRegister(SourceAvailabilityChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sourceAvailabilityChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sourceAvailabilityChanged'</b>:
     *
     * Signal to indicate that there is a change in the Source Availability for a particular source
     *
     * @param act The act which was previously returned by the
     * sendSourceAvailabilityChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceAvailabilityChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'sourceAvailabilityChanged'.
     */
    void sendSourceAvailabilityChangedDeregisterAll () const;


    // Property 'activeSource'

    /**
     * Notify on the property 'activeSource'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveSourceRegister(ActiveSourceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'activeSource'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     *
     * @param act The act which was previously returned by the
     * sendActiveSourceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveSourceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'activeSource'.
     */
    void sendActiveSourceDeregisterAll() const;

    /**
     * Request the value of the property 'activeSource' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'activeSource'</b>:
     *
     * Property to state the current active source
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveSourceGet(ActiveSourceCallbackIF& cb);


    /**
     * Returns the current value of the property 'activeSource' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveSource() returns true.
     *
     * @return the previously received value of the property 'activeSource'.
     */
    const sourceData& getActiveSource() const;

    /**
     * Determines whether a status message for the property 'activeSource' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveSource() const;

    // Property 'activeSourceList'

    /**
     * Notify on the property 'activeSourceList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveSourceListRegister(ActiveSourceListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'activeSourceList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     *
     * @param act The act which was previously returned by the
     * sendActiveSourceListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveSourceListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'activeSourceList'.
     */
    void sendActiveSourceListDeregisterAll() const;

    /**
     * Request the value of the property 'activeSourceList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'activeSourceList'</b>:
     *
     * Property to state the current active sources
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveSourceListGet(ActiveSourceListCallbackIF& cb);


    /**
     * Returns the current value of the property 'activeSourceList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveSourceList() returns true.
     *
     * @return the previously received value of the property 'activeSourceList'.
     */
    const ::std::vector< sourceData >& getActiveSourceList() const;

    /**
     * Determines whether a status message for the property 'activeSourceList'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveSourceList() const;


    // Method 'activateSource'

    /**
     * Call the method 'activateSource'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'activateSource'</b>:
     *
     * Method for Source change request
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceInfo If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @param forceViewChange If the meaning of "forceViewChange" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateSourceRequest(ActivateSourceCallbackIF& cb, const sourceData& sourceInfo, bool forceViewChange) const;

    // Method 'deactivateSource'

    /**
     * Call the method 'deactivateSource'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'deactivateSource'</b>:
     *
     * Method for Source change deactivation
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceInfo If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeactivateSourceRequest(DeactivateSourceCallbackIF& cb, const sourceData& sourceInfo) const;

    // Method 'getSourceList'

    /**
     * Call the method 'getSourceList'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getSourceList'</b>:
     *
     * Method to get the list of available sources for activation
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param srcGroupId If the meaning of "srcGroupId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSourceListRequest(GetSourceListCallbackIF& cb, int32 srcGroupId) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    AudioSourceChangeProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'activeSource'

    ::asf::core::nullable< ActiveSourceUpdate > _activeSource;

    // Property 'activeSourceList'

    ::asf::core::nullable< ActiveSourceListUpdate > _activeSourceList;

    DECLARE_CLASS_LOGGER();

    friend class AudioSourceChangeProxyCallback;
};

} // namespace AudioSourceChange
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGEPROXY_H
