/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERPROXY_H
#define COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/LifeCycleManager.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace LifeCycleManager {

class LifeCycleManagerProxy;

class HeartBeatNotificationCallbackIF {
public:
    virtual ~HeartBeatNotificationCallbackIF() {}

    virtual void onHeartBeatNotificationError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< HeartBeatNotificationError >& error) = 0;

    virtual void onHeartBeatNotificationResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< HeartBeatNotificationResponse >& response) = 0;
};

class LifecycleRequestCallbackIF {
public:
    virtual ~LifecycleRequestCallbackIF() {}

    virtual void onLifecycleRequestError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestError >& error) = 0;

    virtual void onLifecycleRequestSignal(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestSignal >& signal) = 0;
};

class LifecycleRequestCompleteCallbackIF {
public:
    virtual ~LifecycleRequestCompleteCallbackIF() {}

    virtual void onLifecycleRequestCompleteError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteError >& error) = 0;

    virtual void onLifecycleRequestCompleteResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteResponse >& response) = 0;
};

class RegisterCallbackIF {
public:
    virtual ~RegisterCallbackIF() {}

    virtual void onRegisterError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RegisterError >& error) = 0;

    virtual void onRegisterResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RegisterResponse >& response) = 0;
};

class RequestForRestartCallbackIF {
public:
    virtual ~RequestForRestartCallbackIF() {}

    virtual void onRequestForRestartError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RequestForRestartError >& error) = 0;

    virtual void onRequestForRestartResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RequestForRestartResponse >& response) = 0;
};


/**
 * LifeCycleManagerProxy is the client side representation of the D-Bus
 * service interface 'com.bosch.AutomotiveProxy.LifeCycleManager'
 * (specified in file com.bosch.AutomotiveProxy.LifeCycleManager.xml).
 *
 * If the meaning of "com.bosch.AutomotiveProxy.LifeCycleManager" isn't clear, then there should be a description here.
 */
class LifeCycleManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LifeCycleManagerProxy.
     */
    static ::boost::shared_ptr< LifeCycleManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LifeCycleManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LifeCycleManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LifeCycleManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LifeCycleManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LifeCycleManagerProxy > proxyNew(new LifeCycleManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~LifeCycleManagerProxy ();


    // Signal 'LifecycleRequest'

    /**
     * Notify on the signal 'LifecycleRequest'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * If the meaning of "LifecycleRequest" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLifecycleRequestRegister(LifecycleRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'LifecycleRequest'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * If the meaning of "LifecycleRequest" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLifecycleRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLifecycleRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'LifecycleRequest'.
     */
    void sendLifecycleRequestDeregisterAll () const;



    // Method 'Register'

    /**
     * Call the method 'Register'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Register'</b>:
     *
     * If the meaning of "Register" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param credentials If the meaning of "credentials" isn't clear, then there should be a description here.
     *
     * @param request_mode If the meaning of "request_mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterRequest(RegisterCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials, uint32 request_mode) const;

    // Method 'HeartBeatNotification'

    /**
     * Call the method 'HeartBeatNotification'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'HeartBeatNotification'</b>:
     *
     * If the meaning of "HeartBeatNotification" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param request_id If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHeartBeatNotificationRequest(HeartBeatNotificationCallbackIF& cb, uint32 request_id) const;

    // Method 'LifecycleRequestComplete'

    /**
     * Call the method 'LifecycleRequestComplete'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * If the meaning of "LifecycleRequestComplete" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param request_id If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLifecycleRequestCompleteRequest(LifecycleRequestCompleteCallbackIF& cb, uint32 request_id) const;

    // Method 'RequestForRestart'

    /**
     * Call the method 'RequestForRestart'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestForRestart'</b>:
     *
     * If the meaning of "RequestForRestart" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param request_id If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestForRestartRequest(RequestForRestartCallbackIF& cb, uint32 request_id) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    LifeCycleManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class LifeCycleManagerProxyCallback;
};

} // namespace LifeCycleManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERPROXY_H
