/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/LifeCycleManager.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerDBus.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerJson.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace LifeCycleManager {

DEFINE_CLASS_LOGGER("//com/bosch/AutomotiveProxy/LifeCycleManager/com/bosch/AutomotiveProxy/LifeCycleManager", LifeCycleManagerProxy);

class LifeCycleManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    LifeCycleManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< LifeCycleManagerProxy >& proxyShared = ::boost::static_pointer_cast< LifeCycleManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_LifecycleRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LifecycleRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LifecycleRequestSignal> payload = ::boost::static_pointer_cast<LifecycleRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LifecycleRequestCallbackIF*) _callback)->onLifecycleRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Register:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Register", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterError> payload = ::boost::static_pointer_cast<RegisterError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterCallbackIF*) _callback)->onRegisterError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Register", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterResponse> payload = ::boost::static_pointer_cast<RegisterResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterCallbackIF*) _callback)->onRegisterResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HeartBeatNotification:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HeartBeatNotificationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HeartBeatNotification", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HeartBeatNotificationError> payload = ::boost::static_pointer_cast<HeartBeatNotificationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HeartBeatNotificationCallbackIF*) _callback)->onHeartBeatNotificationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HeartBeatNotificationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HeartBeatNotification", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HeartBeatNotificationResponse> payload = ::boost::static_pointer_cast<HeartBeatNotificationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HeartBeatNotificationCallbackIF*) _callback)->onHeartBeatNotificationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_LifecycleRequestComplete:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestCompleteError> payload = ::boost::static_pointer_cast<LifecycleRequestCompleteError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestCompleteResponse> payload = ::boost::static_pointer_cast<LifecycleRequestCompleteResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestForRestart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestForRestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestForRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestForRestartError> payload = ::boost::static_pointer_cast<RequestForRestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestForRestartCallbackIF*) _callback)->onRequestForRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestForRestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestForRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestForRestartResponse> payload = ::boost::static_pointer_cast<RequestForRestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestForRestartCallbackIF*) _callback)->onRequestForRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_LifecycleRequest: {
                ::boost::shared_ptr< LifecycleRequestError > payload = ::boost::shared_ptr< LifecycleRequestError >
                (new LifecycleRequestError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LifecycleRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleManagerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LifecycleRequestCallbackIF*) _callback)->onLifecycleRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Register: {
                ::boost::shared_ptr< RegisterError > payload = ::boost::shared_ptr< RegisterError >
                (new RegisterError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Register", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleManagerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterCallbackIF*) _callback)->onRegisterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HeartBeatNotification: {
                ::boost::shared_ptr< HeartBeatNotificationError > payload = ::boost::shared_ptr< HeartBeatNotificationError >
                (new HeartBeatNotificationError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HeartBeatNotification", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleManagerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HeartBeatNotificationCallbackIF*) _callback)->onHeartBeatNotificationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LifecycleRequestComplete: {
                ::boost::shared_ptr< LifecycleRequestCompleteError > payload = ::boost::shared_ptr< LifecycleRequestCompleteError >
                (new LifecycleRequestCompleteError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleManagerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestForRestart: {
                ::boost::shared_ptr< RequestForRestartError > payload = ::boost::shared_ptr< RequestForRestartError >
                (new RequestForRestartError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestForRestart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleManagerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestForRestartCallbackIF*) _callback)->onRequestForRestartError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& LifeCycleManagerProxyCallback::_logger (LifeCycleManagerProxy::_logger);

LifeCycleManagerProxy::LifeCycleManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.AutomotiveProxy.LifeCycleManager", serviceAvailable, _logger) {
}

LifeCycleManagerProxy::~LifeCycleManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< LifeCycleManagerProxy > LifeCycleManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<LifeCycleManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< LifeCycleManagerProxy > proxyNew(new LifeCycleManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t LifeCycleManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    LifeCycleManagerProxyCallback* callback = new LifeCycleManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t LifeCycleManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    LifeCycleManagerProxyCallback* callback = new LifeCycleManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void LifeCycleManagerProxy::sendDeregisterAll () const
{
    sendLifecycleRequestDeregisterAll();
}

act_t LifeCycleManagerProxy::sendLifecycleRequestRegister(LifecycleRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LifecycleRequest");
    act_t act = addSignalCallback(ID_LifecycleRequest, "LifecycleRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LifecycleRequest", &cb, act);
    return act;
}

bool LifeCycleManagerProxy::sendLifecycleRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LifecycleRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LifecycleRequest", act, static_cast<int>(rv));
    return rv;
}

void LifeCycleManagerProxy::sendLifecycleRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LifecycleRequest");
    _dbusProxyDelegate->deregisterSignalCallback("LifecycleRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t LifeCycleManagerProxy::sendRegisterRequest(RegisterCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials, uint32 request_mode) const {
    RegisterRequest* payload = new RegisterRequest();
    CHECK_ALLOCATION(payload);
    payload->setCredentials(credentials);
    payload->setRequest_mode(request_mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Register", RegisterRequest, payload, true)
    act_t act = addMethodCallback(ID_Register, dbusMessage.getUniqueSerial(), "Register", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Register", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifeCycleManagerProxy::sendHeartBeatNotificationRequest(HeartBeatNotificationCallbackIF& cb, uint32 request_id) const {
    HeartBeatNotificationRequest* payload = new HeartBeatNotificationRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest_id(request_id);
    DBUS_MESSAGE_CALL(dbusMessage, "HeartBeatNotification", HeartBeatNotificationRequest, payload, true)
    act_t act = addMethodCallback(ID_HeartBeatNotification, dbusMessage.getUniqueSerial(), "HeartBeatNotification", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HeartBeatNotification", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifeCycleManagerProxy::sendLifecycleRequestCompleteRequest(LifecycleRequestCompleteCallbackIF& cb, uint32 request_id) const {
    LifecycleRequestCompleteRequest* payload = new LifecycleRequestCompleteRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest_id(request_id);
    DBUS_MESSAGE_CALL(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteRequest, payload, true)
    act_t act = addMethodCallback(ID_LifecycleRequestComplete, dbusMessage.getUniqueSerial(), "LifecycleRequestComplete", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LifecycleRequestComplete", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LifeCycleManagerProxy::sendRequestForRestartRequest(RequestForRestartCallbackIF& cb, uint32 request_id) const {
    RequestForRestartRequest* payload = new RequestForRestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest_id(request_id);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestForRestart", RequestForRestartRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestForRestart, dbusMessage.getUniqueSerial(), "RequestForRestart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestForRestart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace LifeCycleManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com
