#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGER_H
#define COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGER_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "LifeCycleManager" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace LifeCycleManager {

// method IDs
static const uint16 ID_Register = 0;
static const uint16 ID_HeartBeatNotification = 1;
static const uint16 ID_LifecycleRequestComplete = 2;
static const uint16 ID_RequestForRestart = 3;

// signal IDs
static const uint16 ID_LifecycleRequest = 4;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RegisterRequest;

class RegisterResponse;

class HeartBeatNotificationRequest;

class LifecycleRequestCompleteRequest;

class RequestForRestartRequest;

class LifecycleRequestSignal;

// type definitions
/**
 * If the meaning of "RegisterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterError;

/**
 * If the meaning of "HeartBeatNotificationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HeartBeatNotificationResponse;

/**
 * If the meaning of "HeartBeatNotificationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HeartBeatNotificationError;

/**
 * If the meaning of "LifecycleRequestCompleteResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage LifecycleRequestCompleteResponse;

/**
 * If the meaning of "LifecycleRequestCompleteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LifecycleRequestCompleteError;

/**
 * If the meaning of "RequestForRestartResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestForRestartResponse;

/**
 * If the meaning of "RequestForRestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestForRestartError;

/**
 * If the meaning of "LifecycleRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LifecycleRequestError;


/**
 * If the meaning of "RegisterRequest" isn't clear, then there should be a description here.
 */
class RegisterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterRequest (const RegisterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials_, uint32 request_mode_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterRequest();

    /**
     * Assignment operator
     */
    inline RegisterRequest& operator = (const RegisterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "credentials"

    static const int kCredentials = 0;

    /**
     * Clears the field "credentials".
     *
     * The field will be set to its default value. The hasCredentials()
     * method will return false.
     */
    inline void clearCredentials();

    /**
     * Checks whether the field "credentials" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCredentials()). Otherwise it will return false.
     */
    inline bool hasCredentials () const;

    /**
     * Returns the value of the member "credentials".
     *
     * If the meaning of "credentials" isn't clear, then there should be a description here.
     *
     * @return The value of the field "credentials"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getCredentials () const;

    /**
     * Retrieves the value of the field "credentials" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "credentials".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getCredentialsMutable ();

    /**
     * Sets the value of the member "credentials".
     *
     * If the meaning of "credentials" isn't clear, then there should be a description here.
     *
     * @param credentials The value which will be set
     */
    inline void setCredentials (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials_);

    // API of field "request_mode"

    static const int kRequest_mode = 1;

    /**
     * Clears the field "request_mode".
     *
     * The field will be set to its default value. The hasRequest_mode()
     * method will return false.
     */
    inline void clearRequest_mode();

    /**
     * Checks whether the field "request_mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_mode()). Otherwise it will return false.
     */
    inline bool hasRequest_mode () const;

    /**
     * Returns the value of the member "request_mode".
     *
     * If the meaning of "request_mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_mode"
     */
    inline uint32 getRequest_mode () const;

    /**
     * Sets the value of the member "request_mode".
     *
     * If the meaning of "request_mode" isn't clear, then there should be a description here.
     *
     * @param request_mode The value which will be set
     */
    inline void setRequest_mode (uint32 request_mode_);

    static const RegisterRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_credentials ();

    inline void clear_has_credentials ();

    inline void set_has_request_mode ();

    inline void clear_has_request_mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _credentials;

    uint32 _request_mode;

};

/**
 * If the meaning of "RegisterResponse" isn't clear, then there should be a description here.
 */
class RegisterResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterResponse (const RegisterResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterResponse (uint32 request_id_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterResponse();

    /**
     * Assignment operator
     */
    inline RegisterResponse& operator = (const RegisterResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request_id"

    static const int kRequest_id = 0;

    /**
     * Clears the field "request_id".
     *
     * The field will be set to its default value. The hasRequest_id()
     * method will return false.
     */
    inline void clearRequest_id();

    /**
     * Checks whether the field "request_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_id()). Otherwise it will return false.
     */
    inline bool hasRequest_id () const;

    /**
     * Returns the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_id"
     */
    inline uint32 getRequest_id () const;

    /**
     * Sets the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param request_id The value which will be set
     */
    inline void setRequest_id (uint32 request_id_);

    static const RegisterResponse &getDefaultInstance();

private:

    inline void set_has_request_id ();

    inline void clear_has_request_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _request_id;

};

/**
 * If the meaning of "HeartBeatNotificationRequest" isn't clear, then there should be a description here.
 */
class HeartBeatNotificationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HeartBeatNotificationRequest ();

    /**
     * Copy constructor
     */
    inline  HeartBeatNotificationRequest (const HeartBeatNotificationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HeartBeatNotificationRequest (uint32 request_id_);

    /**
     * Destructor
     */
    inline virtual  ~HeartBeatNotificationRequest();

    /**
     * Assignment operator
     */
    inline HeartBeatNotificationRequest& operator = (const HeartBeatNotificationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HeartBeatNotificationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HeartBeatNotificationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HeartBeatNotificationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HeartBeatNotificationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request_id"

    static const int kRequest_id = 0;

    /**
     * Clears the field "request_id".
     *
     * The field will be set to its default value. The hasRequest_id()
     * method will return false.
     */
    inline void clearRequest_id();

    /**
     * Checks whether the field "request_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_id()). Otherwise it will return false.
     */
    inline bool hasRequest_id () const;

    /**
     * Returns the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_id"
     */
    inline uint32 getRequest_id () const;

    /**
     * Sets the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param request_id The value which will be set
     */
    inline void setRequest_id (uint32 request_id_);

    static const HeartBeatNotificationRequest &getDefaultInstance();

private:

    inline void set_has_request_id ();

    inline void clear_has_request_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _request_id;

};

/**
 * If the meaning of "LifecycleRequestCompleteRequest" isn't clear, then there should be a description here.
 */
class LifecycleRequestCompleteRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestCompleteRequest ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestCompleteRequest (const LifecycleRequestCompleteRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestCompleteRequest (uint32 request_id_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestCompleteRequest();

    /**
     * Assignment operator
     */
    inline LifecycleRequestCompleteRequest& operator = (const LifecycleRequestCompleteRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestCompleteRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request_id"

    static const int kRequest_id = 0;

    /**
     * Clears the field "request_id".
     *
     * The field will be set to its default value. The hasRequest_id()
     * method will return false.
     */
    inline void clearRequest_id();

    /**
     * Checks whether the field "request_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_id()). Otherwise it will return false.
     */
    inline bool hasRequest_id () const;

    /**
     * Returns the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_id"
     */
    inline uint32 getRequest_id () const;

    /**
     * Sets the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param request_id The value which will be set
     */
    inline void setRequest_id (uint32 request_id_);

    static const LifecycleRequestCompleteRequest &getDefaultInstance();

private:

    inline void set_has_request_id ();

    inline void clear_has_request_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _request_id;

};

/**
 * If the meaning of "RequestForRestartRequest" isn't clear, then there should be a description here.
 */
class RequestForRestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestForRestartRequest ();

    /**
     * Copy constructor
     */
    inline  RequestForRestartRequest (const RequestForRestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestForRestartRequest (uint32 request_id_);

    /**
     * Destructor
     */
    inline virtual  ~RequestForRestartRequest();

    /**
     * Assignment operator
     */
    inline RequestForRestartRequest& operator = (const RequestForRestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestForRestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestForRestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestForRestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestForRestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "request_id"

    static const int kRequest_id = 0;

    /**
     * Clears the field "request_id".
     *
     * The field will be set to its default value. The hasRequest_id()
     * method will return false.
     */
    inline void clearRequest_id();

    /**
     * Checks whether the field "request_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_id()). Otherwise it will return false.
     */
    inline bool hasRequest_id () const;

    /**
     * Returns the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_id"
     */
    inline uint32 getRequest_id () const;

    /**
     * Sets the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param request_id The value which will be set
     */
    inline void setRequest_id (uint32 request_id_);

    static const RequestForRestartRequest &getDefaultInstance();

private:

    inline void set_has_request_id ();

    inline void clear_has_request_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _request_id;

};

/**
 * If the meaning of "LifecycleRequestSignal" isn't clear, then there should be a description here.
 */
class LifecycleRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestSignal ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestSignal (const LifecycleRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestSignal (uint32 mode_, uint32 request_id_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestSignal();

    /**
     * Assignment operator
     */
    inline LifecycleRequestSignal& operator = (const LifecycleRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline uint32 getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (uint32 mode_);

    // API of field "request_id"

    static const int kRequest_id = 1;

    /**
     * Clears the field "request_id".
     *
     * The field will be set to its default value. The hasRequest_id()
     * method will return false.
     */
    inline void clearRequest_id();

    /**
     * Checks whether the field "request_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest_id()). Otherwise it will return false.
     */
    inline bool hasRequest_id () const;

    /**
     * Returns the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "request_id"
     */
    inline uint32 getRequest_id () const;

    /**
     * Sets the value of the member "request_id".
     *
     * If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param request_id The value which will be set
     */
    inline void setRequest_id (uint32 request_id_);

    static const LifecycleRequestSignal &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_request_id ();

    inline void clear_has_request_id ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _mode;

    uint32 _request_id;

};

inline  RegisterRequest::RegisterRequest ()  :
    _credentials (),
    _request_mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterRequest::RegisterRequest (const RegisterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _credentials (),
    _request_mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterRequest::RegisterRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials_, uint32 request_mode_)  :
    _credentials (credentials_),
    _request_mode (request_mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterRequest::~RegisterRequest() {
}

inline RegisterRequest& RegisterRequest::operator = (const RegisterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCredentials()) {
            setCredentials(rhs.getCredentials());
        } else {
            clearCredentials();
        }
        if (rhs.hasRequest_mode()) {
            setRequest_mode(rhs.getRequest_mode());
        } else {
            clearRequest_mode();
        }
    }
    return *this;
}

inline bool RegisterRequest::operator == (const RegisterRequest& rhs) const {
    return (((!hasCredentials() && !rhs.hasCredentials()) || getCredentials() == rhs.getCredentials()) &&
        ((!hasRequest_mode() && !rhs.hasRequest_mode()) || getRequest_mode() == rhs.getRequest_mode()));
}

inline bool RegisterRequest::operator != (const RegisterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterRequest::operator < (const RegisterRequest& rhs) const {
    if (hasCredentials() || rhs.hasCredentials()) {
        if (getCredentials() < rhs.getCredentials()) return true;
        if (getCredentials() > rhs.getCredentials()) return false;
    }
    if (hasRequest_mode() || rhs.hasRequest_mode()) {
        if (getRequest_mode() < rhs.getRequest_mode()) return true;
        if (getRequest_mode() > rhs.getRequest_mode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterRequest::clone() {
    return new RegisterRequest(*this);
}

inline bool RegisterRequest::operator > (const RegisterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterRequest::clear() {
    clearCredentials();
    clearRequest_mode();
}

inline void RegisterRequest::clearCredentials() {
    if (hasCredentials()) {
         clear_has_credentials();
        _credentials.clear();
     }
}

inline bool RegisterRequest::hasCredentials () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RegisterRequest::getCredentials () const {
    return _credentials;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RegisterRequest::getCredentialsMutable () {
    set_has_credentials();
    return _credentials;
}

inline void RegisterRequest::setCredentials (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& credentials_) {
    set_has_credentials();
    this->_credentials = credentials_;
}

inline void RegisterRequest::clearRequest_mode() {
    if (hasRequest_mode()) {
         clear_has_request_mode();
        _request_mode = 0u;
     }
}

inline bool RegisterRequest::hasRequest_mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RegisterRequest::getRequest_mode () const {
    return _request_mode;
}

inline void RegisterRequest::setRequest_mode (uint32 request_mode_) {
    set_has_request_mode();
    this->_request_mode = request_mode_;
}

inline void RegisterRequest::set_has_credentials () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterRequest::clear_has_credentials () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterRequest::set_has_request_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterRequest::clear_has_request_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegisterResponse::RegisterResponse ()  :
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterResponse::RegisterResponse (const RegisterResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterResponse::RegisterResponse (uint32 request_id_)  :
    _request_id (request_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterResponse::~RegisterResponse() {
}

inline RegisterResponse& RegisterResponse::operator = (const RegisterResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequest_id()) {
            setRequest_id(rhs.getRequest_id());
        } else {
            clearRequest_id();
        }
    }
    return *this;
}

inline bool RegisterResponse::operator == (const RegisterResponse& rhs) const {
    return (((!hasRequest_id() && !rhs.hasRequest_id()) || getRequest_id() == rhs.getRequest_id()));
}

inline bool RegisterResponse::operator != (const RegisterResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterResponse::operator < (const RegisterResponse& rhs) const {
    if (hasRequest_id() || rhs.hasRequest_id()) {
        if (getRequest_id() < rhs.getRequest_id()) return true;
        if (getRequest_id() > rhs.getRequest_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterResponse::clone() {
    return new RegisterResponse(*this);
}

inline bool RegisterResponse::operator > (const RegisterResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterResponse::clear() {
    clearRequest_id();
}

inline void RegisterResponse::clearRequest_id() {
    if (hasRequest_id()) {
         clear_has_request_id();
        _request_id = 0u;
     }
}

inline bool RegisterResponse::hasRequest_id () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RegisterResponse::getRequest_id () const {
    return _request_id;
}

inline void RegisterResponse::setRequest_id (uint32 request_id_) {
    set_has_request_id();
    this->_request_id = request_id_;
}

inline void RegisterResponse::set_has_request_id () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterResponse::clear_has_request_id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HeartBeatNotificationRequest::HeartBeatNotificationRequest ()  :
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HeartBeatNotificationRequest::HeartBeatNotificationRequest (const HeartBeatNotificationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HeartBeatNotificationRequest::HeartBeatNotificationRequest (uint32 request_id_)  :
    _request_id (request_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HeartBeatNotificationRequest::~HeartBeatNotificationRequest() {
}

inline HeartBeatNotificationRequest& HeartBeatNotificationRequest::operator = (const HeartBeatNotificationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequest_id()) {
            setRequest_id(rhs.getRequest_id());
        } else {
            clearRequest_id();
        }
    }
    return *this;
}

inline bool HeartBeatNotificationRequest::operator == (const HeartBeatNotificationRequest& rhs) const {
    return (((!hasRequest_id() && !rhs.hasRequest_id()) || getRequest_id() == rhs.getRequest_id()));
}

inline bool HeartBeatNotificationRequest::operator != (const HeartBeatNotificationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool HeartBeatNotificationRequest::operator < (const HeartBeatNotificationRequest& rhs) const {
    if (hasRequest_id() || rhs.hasRequest_id()) {
        if (getRequest_id() < rhs.getRequest_id()) return true;
        if (getRequest_id() > rhs.getRequest_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HeartBeatNotificationRequest::clone() {
    return new HeartBeatNotificationRequest(*this);
}

inline bool HeartBeatNotificationRequest::operator > (const HeartBeatNotificationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HeartBeatNotificationRequest::clear() {
    clearRequest_id();
}

inline void HeartBeatNotificationRequest::clearRequest_id() {
    if (hasRequest_id()) {
         clear_has_request_id();
        _request_id = 0u;
     }
}

inline bool HeartBeatNotificationRequest::hasRequest_id () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 HeartBeatNotificationRequest::getRequest_id () const {
    return _request_id;
}

inline void HeartBeatNotificationRequest::setRequest_id (uint32 request_id_) {
    set_has_request_id();
    this->_request_id = request_id_;
}

inline void HeartBeatNotificationRequest::set_has_request_id () {
    _has_bits_[0] |= 1u << 0;
}

inline void HeartBeatNotificationRequest::clear_has_request_id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest ()  :
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest (const LifecycleRequestCompleteRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestCompleteRequest::LifecycleRequestCompleteRequest (uint32 request_id_)  :
    _request_id (request_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestCompleteRequest::~LifecycleRequestCompleteRequest() {
}

inline LifecycleRequestCompleteRequest& LifecycleRequestCompleteRequest::operator = (const LifecycleRequestCompleteRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequest_id()) {
            setRequest_id(rhs.getRequest_id());
        } else {
            clearRequest_id();
        }
    }
    return *this;
}

inline bool LifecycleRequestCompleteRequest::operator == (const LifecycleRequestCompleteRequest& rhs) const {
    return (((!hasRequest_id() && !rhs.hasRequest_id()) || getRequest_id() == rhs.getRequest_id()));
}

inline bool LifecycleRequestCompleteRequest::operator != (const LifecycleRequestCompleteRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestCompleteRequest::operator < (const LifecycleRequestCompleteRequest& rhs) const {
    if (hasRequest_id() || rhs.hasRequest_id()) {
        if (getRequest_id() < rhs.getRequest_id()) return true;
        if (getRequest_id() > rhs.getRequest_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestCompleteRequest::clone() {
    return new LifecycleRequestCompleteRequest(*this);
}

inline bool LifecycleRequestCompleteRequest::operator > (const LifecycleRequestCompleteRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestCompleteRequest::clear() {
    clearRequest_id();
}

inline void LifecycleRequestCompleteRequest::clearRequest_id() {
    if (hasRequest_id()) {
         clear_has_request_id();
        _request_id = 0u;
     }
}

inline bool LifecycleRequestCompleteRequest::hasRequest_id () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 LifecycleRequestCompleteRequest::getRequest_id () const {
    return _request_id;
}

inline void LifecycleRequestCompleteRequest::setRequest_id (uint32 request_id_) {
    set_has_request_id();
    this->_request_id = request_id_;
}

inline void LifecycleRequestCompleteRequest::set_has_request_id () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestCompleteRequest::clear_has_request_id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestForRestartRequest::RequestForRestartRequest ()  :
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestForRestartRequest::RequestForRestartRequest (const RequestForRestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestForRestartRequest::RequestForRestartRequest (uint32 request_id_)  :
    _request_id (request_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestForRestartRequest::~RequestForRestartRequest() {
}

inline RequestForRestartRequest& RequestForRestartRequest::operator = (const RequestForRestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequest_id()) {
            setRequest_id(rhs.getRequest_id());
        } else {
            clearRequest_id();
        }
    }
    return *this;
}

inline bool RequestForRestartRequest::operator == (const RequestForRestartRequest& rhs) const {
    return (((!hasRequest_id() && !rhs.hasRequest_id()) || getRequest_id() == rhs.getRequest_id()));
}

inline bool RequestForRestartRequest::operator != (const RequestForRestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestForRestartRequest::operator < (const RequestForRestartRequest& rhs) const {
    if (hasRequest_id() || rhs.hasRequest_id()) {
        if (getRequest_id() < rhs.getRequest_id()) return true;
        if (getRequest_id() > rhs.getRequest_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestForRestartRequest::clone() {
    return new RequestForRestartRequest(*this);
}

inline bool RequestForRestartRequest::operator > (const RequestForRestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestForRestartRequest::clear() {
    clearRequest_id();
}

inline void RequestForRestartRequest::clearRequest_id() {
    if (hasRequest_id()) {
         clear_has_request_id();
        _request_id = 0u;
     }
}

inline bool RequestForRestartRequest::hasRequest_id () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestForRestartRequest::getRequest_id () const {
    return _request_id;
}

inline void RequestForRestartRequest::setRequest_id (uint32 request_id_) {
    set_has_request_id();
    this->_request_id = request_id_;
}

inline void RequestForRestartRequest::set_has_request_id () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestForRestartRequest::clear_has_request_id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LifecycleRequestSignal::LifecycleRequestSignal ()  :
    _mode (0u),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestSignal::LifecycleRequestSignal (const LifecycleRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _mode (0u),
    _request_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestSignal::LifecycleRequestSignal (uint32 mode_, uint32 request_id_)  :
    _mode (mode_),
    _request_id (request_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestSignal::~LifecycleRequestSignal() {
}

inline LifecycleRequestSignal& LifecycleRequestSignal::operator = (const LifecycleRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasRequest_id()) {
            setRequest_id(rhs.getRequest_id());
        } else {
            clearRequest_id();
        }
    }
    return *this;
}

inline bool LifecycleRequestSignal::operator == (const LifecycleRequestSignal& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasRequest_id() && !rhs.hasRequest_id()) || getRequest_id() == rhs.getRequest_id()));
}

inline bool LifecycleRequestSignal::operator != (const LifecycleRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestSignal::operator < (const LifecycleRequestSignal& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasRequest_id() || rhs.hasRequest_id()) {
        if (getRequest_id() < rhs.getRequest_id()) return true;
        if (getRequest_id() > rhs.getRequest_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestSignal::clone() {
    return new LifecycleRequestSignal(*this);
}

inline bool LifecycleRequestSignal::operator > (const LifecycleRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestSignal::clear() {
    clearMode();
    clearRequest_id();
}

inline void LifecycleRequestSignal::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode = 0u;
     }
}

inline bool LifecycleRequestSignal::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 LifecycleRequestSignal::getMode () const {
    return _mode;
}

inline void LifecycleRequestSignal::setMode (uint32 mode_) {
    set_has_mode();
    this->_mode = mode_;
}

inline void LifecycleRequestSignal::clearRequest_id() {
    if (hasRequest_id()) {
         clear_has_request_id();
        _request_id = 0u;
     }
}

inline bool LifecycleRequestSignal::hasRequest_id () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 LifecycleRequestSignal::getRequest_id () const {
    return _request_id;
}

inline void LifecycleRequestSignal::setRequest_id (uint32 request_id_) {
    set_has_request_id();
    this->_request_id = request_id_;
}

inline void LifecycleRequestSignal::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestSignal::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LifecycleRequestSignal::set_has_request_id () {
    _has_bits_[0] |= 1u << 1;
}

inline void LifecycleRequestSignal::clear_has_request_id () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace LifeCycleManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
