/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICESTUB_H
#define BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorService.h"
#include <string>

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmimonitorservice {
namespace HmiMonitorService {

class HmiMonitorServiceStubDelegate;

class HmiMonitorServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HmiMonitorServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HmiMonitorServiceStub (const std::string& portName);

    /**
     * Create an instance of the HmiMonitorServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HmiMonitorServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~HmiMonitorServiceStub();

    // property 'activeRenderedViewName'

    /**
     * The method onActiveRenderedViewNameGet() is called by ASF when a client
     * invokes the read method for the property 'activeRenderedViewName'. The
     * onActiveRenderedViewNameGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    virtual void onActiveRenderedViewNameGet(const ::boost::shared_ptr< ActiveRenderedViewNameGet >& payload);

    /**
     * Sends back the update to a previous onActiveRenderedViewNameGet().
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     *
     * @param act Identifies a previous invocation of
     * onActiveRenderedViewNameGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveRenderedViewNameGetUpdate(const ::std::string& activeRenderedViewName, act_t act = 0);

    /**
     * Set the value of the property 'activeRenderedViewName' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    void setActiveRenderedViewName(const ::std::string& activeRenderedViewName);

    /**
     * Returns the current value of the property 'activeRenderedViewName'.
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    const ::std::string& getActiveRenderedViewName() const;

    /**
     * Returns the current value of the property 'activeRenderedViewName' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendActiveRenderedViewNameUpdate() method.
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    ::std::string& getActiveRenderedViewNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveRenderedViewNameUpdate().
     *
     * <b>Documentation of 'activeRenderedViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    void sendActiveRenderedViewNameUpdate();

    // property 'activeRenderedUpperViewName'

    /**
     * The method onActiveRenderedUpperViewNameGet() is called by ASF when a
     * client invokes the read method for the property
     * 'activeRenderedUpperViewName'. The onActiveRenderedUpperViewNameGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    virtual void onActiveRenderedUpperViewNameGet(const ::boost::shared_ptr< ActiveRenderedUpperViewNameGet >& payload);

    /**
     * Sends back the update to a previous onActiveRenderedUpperViewNameGet().
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     *
     * @param act Identifies a previous invocation of
     * onActiveRenderedUpperViewNameGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendActiveRenderedUpperViewNameGetUpdate(const ::std::string& activeRenderedUpperViewName, act_t act = 0);

    /**
     * Set the value of the property 'activeRenderedUpperViewName' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    void setActiveRenderedUpperViewName(const ::std::string& activeRenderedUpperViewName);

    /**
     * Returns the current value of the property 'activeRenderedUpperViewName'.
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    const ::std::string& getActiveRenderedUpperViewName() const;

    /**
     * Returns the current value of the property 'activeRenderedUpperViewName'
     * as a mutable reference. If you change the content of the returned
     * object you have to send updates to registered clients by yourself with
     * the help of the sendActiveRenderedUpperViewNameUpdate() method.
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    ::std::string& getActiveRenderedUpperViewNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveRenderedUpperViewNameUpdate().
     *
     * <b>Documentation of 'activeRenderedUpperViewName'</b>:
     *
     * Property to state the current active rendered view name
     */
    void sendActiveRenderedUpperViewNameUpdate();

    // property 'nextActiveAppUpper'

    /**
     * The method onNextActiveAppUpperGet() is called by ASF when a client
     * invokes the read method for the property 'nextActiveAppUpper'. The
     * onNextActiveAppUpperGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     */
    virtual void onNextActiveAppUpperGet(const ::boost::shared_ptr< NextActiveAppUpperGet >& payload);

    /**
     * Sends back the update to a previous onNextActiveAppUpperGet().
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     *
     * @param act Identifies a previous invocation of
     * onNextActiveAppUpperGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNextActiveAppUpperGetUpdate(const ::std::string& nextActiveAppUpper, act_t act = 0);

    /**
     * Set the value of the property 'nextActiveAppUpper' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     */
    void setNextActiveAppUpper(const ::std::string& nextActiveAppUpper);

    /**
     * Returns the current value of the property 'nextActiveAppUpper'.
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     */
    const ::std::string& getNextActiveAppUpper() const;

    /**
     * Returns the current value of the property 'nextActiveAppUpper' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendNextActiveAppUpperUpdate() method.
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     */
    ::std::string& getNextActiveAppUpperMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNextActiveAppUpperUpdate().
     *
     * <b>Documentation of 'nextActiveAppUpper'</b>:
     *
     * Property to state the next active application in upper display
     */
    void sendNextActiveAppUpperUpdate();

    // property 'nextActiveAppLower'

    /**
     * The method onNextActiveAppLowerGet() is called by ASF when a client
     * invokes the read method for the property 'nextActiveAppLower'. The
     * onNextActiveAppLowerGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     */
    virtual void onNextActiveAppLowerGet(const ::boost::shared_ptr< NextActiveAppLowerGet >& payload);

    /**
     * Sends back the update to a previous onNextActiveAppLowerGet().
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     *
     * @param act Identifies a previous invocation of
     * onNextActiveAppLowerGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNextActiveAppLowerGetUpdate(const ::std::string& nextActiveAppLower, act_t act = 0);

    /**
     * Set the value of the property 'nextActiveAppLower' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     */
    void setNextActiveAppLower(const ::std::string& nextActiveAppLower);

    /**
     * Returns the current value of the property 'nextActiveAppLower'.
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     */
    const ::std::string& getNextActiveAppLower() const;

    /**
     * Returns the current value of the property 'nextActiveAppLower' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendNextActiveAppLowerUpdate() method.
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     */
    ::std::string& getNextActiveAppLowerMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNextActiveAppLowerUpdate().
     *
     * <b>Documentation of 'nextActiveAppLower'</b>:
     *
     * Property to state the next active application in lower display
     */
    void sendNextActiveAppLowerUpdate();

    // method 'getStartUpTimeInterval'

    /**
     * The method onGetStartUpTimeInterval() is called by ASF when a client
     * invokes the method 'getStartUpTimeInterval'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetStartUpTimeInterval() or
     * sendGetStartUpTimeIntervalError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'getStartUpTimeInterval'</b>:
     *
     * Method to give startup time interval till OEM logo performance indicator
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetStartUpTimeIntervalRequest (const ::boost::shared_ptr< GetStartUpTimeIntervalRequest >& request) = 0;

    /**
     * The method sendGetStartUpTimeIntervalResponse() sends a response of a
     * previous method invocation of 'getStartUpTimeInterval' back to the
     * client.
     *
     * <b>Documentation of 'getStartUpTimeInterval'</b>:
     *
     * Method to give startup time interval till OEM logo performance indicator
     *
     * @param startUpTimeInterval If the meaning of "startUpTimeInterval" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetStartUpTimeInterval(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetStartUpTimeIntervalResponse (uint32 startUpTimeInterval, act_t act = 0);

    /**
     * The method sendGetStartUpTimeIntervalError() sends an error response of
     * a previous method invocation of 'getStartUpTimeInterval' back to the
     * client.
     *
     * <b>Documentation of 'getStartUpTimeInterval'</b>:
     *
     * Method to give startup time interval till OEM logo performance indicator
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetStartUpTimeInterval(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetStartUpTimeIntervalError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getActiveForegroundScene'

    /**
     * The method onGetActiveForegroundScene() is called by ASF when a client
     * invokes the method 'getActiveForegroundScene'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetActiveForegroundScene() or
     * sendGetActiveForegroundSceneError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'getActiveForegroundScene'</b>:
     *
     * Method to give active screen/popup on foreground
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetActiveForegroundSceneRequest (const ::boost::shared_ptr< GetActiveForegroundSceneRequest >& request) = 0;

    /**
     * The method sendGetActiveForegroundSceneResponse() sends a response of a
     * previous method invocation of 'getActiveForegroundScene' back to the
     * client.
     *
     * <b>Documentation of 'getActiveForegroundScene'</b>:
     *
     * Method to give active screen/popup on foreground
     *
     * @param activeSceneName If the meaning of "activeSceneName" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetActiveForegroundScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetActiveForegroundSceneResponse (const ::std::string& activeSceneName, act_t act = 0);

    /**
     * The method sendGetActiveForegroundSceneError() sends an error response
     * of a previous method invocation of 'getActiveForegroundScene' back to
     * the client.
     *
     * <b>Documentation of 'getActiveForegroundScene'</b>:
     *
     * Method to give active screen/popup on foreground
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetActiveForegroundScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetActiveForegroundSceneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getActiveForegroundSceneUpper'

    /**
     * The method onGetActiveForegroundSceneUpper() is called by ASF when a
     * client invokes the method 'getActiveForegroundSceneUpper'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendGetActiveForegroundSceneUpper() or
     * sendGetActiveForegroundSceneUpperError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'getActiveForegroundSceneUpper'</b>:
     *
     * Method to give active screen/popup on foreground in Upper Display
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetActiveForegroundSceneUpperRequest (const ::boost::shared_ptr< GetActiveForegroundSceneUpperRequest >& request) = 0;

    /**
     * The method sendGetActiveForegroundSceneUpperResponse() sends a response
     * of a previous method invocation of 'getActiveForegroundSceneUpper' back
     * to the client.
     *
     * <b>Documentation of 'getActiveForegroundSceneUpper'</b>:
     *
     * Method to give active screen/popup on foreground in Upper Display
     *
     * @param activeSceneNameUpper If the meaning of "activeSceneNameUpper" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetActiveForegroundSceneUpper(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetActiveForegroundSceneUpperResponse (const ::std::string& activeSceneNameUpper, act_t act = 0);

    /**
     * The method sendGetActiveForegroundSceneUpperError() sends an error
     * response of a previous method invocation of
     * 'getActiveForegroundSceneUpper' back to the client.
     *
     * <b>Documentation of 'getActiveForegroundSceneUpper'</b>:
     *
     * Method to give active screen/popup on foreground in Upper Display
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetActiveForegroundSceneUpper(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendGetActiveForegroundSceneUpperError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setHMIInfoServiceStatus'

    /**
     * The method onSetHMIInfoServiceStatus() is called by ASF when a client
     * invokes the method 'setHMIInfoServiceStatus'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetHMIInfoServiceStatus() or
     * sendSetHMIInfoServiceStatusError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setHMIInfoServiceStatus'</b>:
     *
     * Method to enable or disable HMIInfo service
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetHMIInfoServiceStatusRequest (const ::boost::shared_ptr< SetHMIInfoServiceStatusRequest >& request) = 0;

    /**
     * The method sendSetHMIInfoServiceStatusResponse() sends a response of a
     * previous method invocation of 'setHMIInfoServiceStatus' back to the
     * client.
     *
     * <b>Documentation of 'setHMIInfoServiceStatus'</b>:
     *
     * Method to enable or disable HMIInfo service
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetHMIInfoServiceStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetHMIInfoServiceStatusResponse (act_t act = 0);

    /**
     * The method sendSetHMIInfoServiceStatusError() sends an error response
     * of a previous method invocation of 'setHMIInfoServiceStatus' back to
     * the client.
     *
     * <b>Documentation of 'setHMIInfoServiceStatus'</b>:
     *
     * Method to enable or disable HMIInfo service
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetHMIInfoServiceStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetHMIInfoServiceStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getNextActiveAppUpper'

    /**
     * The method onGetNextActiveAppUpper() is called by ASF when a client
     * invokes the method 'getNextActiveAppUpper'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetNextActiveAppUpper() or sendGetNextActiveAppUpperError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'getNextActiveAppUpper'</b>:
     *
     * Method to give next active application Id of Upper display
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetNextActiveAppUpperRequest (const ::boost::shared_ptr< GetNextActiveAppUpperRequest >& request) = 0;

    /**
     * The method sendGetNextActiveAppUpperResponse() sends a response of a
     * previous method invocation of 'getNextActiveAppUpper' back to the
     * client.
     *
     * <b>Documentation of 'getNextActiveAppUpper'</b>:
     *
     * Method to give next active application Id of Upper display
     *
     * @param appIdUpper If the meaning of "appIdUpper" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetNextActiveAppUpper(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetNextActiveAppUpperResponse (const ::std::string& appIdUpper, act_t act = 0);

    /**
     * The method sendGetNextActiveAppUpperError() sends an error response of
     * a previous method invocation of 'getNextActiveAppUpper' back to the
     * client.
     *
     * <b>Documentation of 'getNextActiveAppUpper'</b>:
     *
     * Method to give next active application Id of Upper display
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetNextActiveAppUpper(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetNextActiveAppUpperError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getNextActiveAppLower'

    /**
     * The method onGetNextActiveAppLower() is called by ASF when a client
     * invokes the method 'getNextActiveAppLower'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetNextActiveAppLower() or sendGetNextActiveAppLowerError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'getNextActiveAppLower'</b>:
     *
     * Method to give next active application Id of Lower display
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetNextActiveAppLowerRequest (const ::boost::shared_ptr< GetNextActiveAppLowerRequest >& request) = 0;

    /**
     * The method sendGetNextActiveAppLowerResponse() sends a response of a
     * previous method invocation of 'getNextActiveAppLower' back to the
     * client.
     *
     * <b>Documentation of 'getNextActiveAppLower'</b>:
     *
     * Method to give next active application Id of Lower display
     *
     * @param appIdLower If the meaning of "appIdLower" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetNextActiveAppLower(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetNextActiveAppLowerResponse (const ::std::string& appIdLower, act_t act = 0);

    /**
     * The method sendGetNextActiveAppLowerError() sends an error response of
     * a previous method invocation of 'getNextActiveAppLower' back to the
     * client.
     *
     * <b>Documentation of 'getNextActiveAppLower'</b>:
     *
     * Method to give next active application Id of Lower display
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetNextActiveAppLower(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetNextActiveAppLowerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ActiveRenderedViewNameUpdate _activeRenderedViewNameProperty;

    ActiveRenderedUpperViewNameUpdate _activeRenderedUpperViewNameProperty;

    NextActiveAppUpperUpdate _nextActiveAppUpperProperty;

    NextActiveAppLowerUpdate _nextActiveAppLowerProperty;

    friend class HmiMonitorServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HmiMonitorService
} // namespace hmimonitorservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICESTUB_H
