/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorService.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceDBus.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceJson.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmimonitorservice {
namespace HmiMonitorService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/nissan/hmi/hmimonitorservice/bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorService", HmiMonitorServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 21, "getNextActiveAppLower", 5 },
    { 21, "getNextActiveAppUpper", 4 },
    { 22, "getStartUpTimeInterval", 0 },
    { 23, "setHMIInfoServiceStatus", 3 },
    { 24, "getActiveForegroundScene", 1 },
    { 29, "getActiveForegroundSceneUpper", 2 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 18, "nextActiveAppLower", 3 },
    { 18, "nextActiveAppUpper", 2 },
    { 22, "activeRenderedViewName", 0 },
    { 27, "activeRenderedUpperViewName", 1 },
};

class HmiMonitorServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HmiMonitorServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HmiMonitorServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HmiMonitorServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService"),
          _logger(logger) {}

    virtual ~HmiMonitorServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HmiMonitorServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'getStartUpTimeInterval'

            LOG_DEBUG_STUB("process method '%s'", "getStartUpTimeInterval");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetStartUpTimeIntervalRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetStartUpTimeInterval", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetStartUpTimeIntervalRequest > payload = ::boost::static_pointer_cast<GetStartUpTimeIntervalRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onGetStartUpTimeIntervalRequest(payload);
            return;
        }
        case 1: {

            // method 'getActiveForegroundScene'

            LOG_DEBUG_STUB("process method '%s'", "getActiveForegroundScene");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetActiveForegroundScene", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetActiveForegroundSceneRequest > payload = ::boost::static_pointer_cast<GetActiveForegroundSceneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onGetActiveForegroundSceneRequest(payload);
            return;
        }
        case 2: {

            // method 'getActiveForegroundSceneUpper'

            LOG_DEBUG_STUB("process method '%s'", "getActiveForegroundSceneUpper");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneUpperRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetActiveForegroundSceneUpper", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetActiveForegroundSceneUpperRequest > payload = ::boost::static_pointer_cast<GetActiveForegroundSceneUpperRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onGetActiveForegroundSceneUpperRequest(payload);
            return;
        }
        case 3: {

            // method 'setHMIInfoServiceStatus'

            LOG_DEBUG_STUB("process method '%s'", "setHMIInfoServiceStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetHMIInfoServiceStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetHMIInfoServiceStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetHMIInfoServiceStatusRequest > payload = ::boost::static_pointer_cast<SetHMIInfoServiceStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onSetHMIInfoServiceStatusRequest(payload);
            return;
        }
        case 4: {

            // method 'getNextActiveAppUpper'

            LOG_DEBUG_STUB("process method '%s'", "getNextActiveAppUpper");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppUpperRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetNextActiveAppUpper", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetNextActiveAppUpperRequest > payload = ::boost::static_pointer_cast<GetNextActiveAppUpperRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onGetNextActiveAppUpperRequest(payload);
            return;
        }
        case 5: {

            // method 'getNextActiveAppLower'

            LOG_DEBUG_STUB("process method '%s'", "getNextActiveAppLower");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppLowerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetNextActiveAppLower", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetNextActiveAppLowerRequest > payload = ::boost::static_pointer_cast<GetNextActiveAppLowerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiMonitorServiceStub*>(getStub())->onGetNextActiveAppLowerRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HmiMonitorServiceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService\">\n"
            "    <property access=\"read\" name=\"activeRenderedViewName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"activeRenderedUpperViewName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"nextActiveAppUpper\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"nextActiveAppLower\" type=\"s\"/>\n"
            "    <method name=\"getStartUpTimeInterval\">\n"
            "      <doc>\n"
            "        <line>getStartUpTimeInterval = Method to give startup time interval till OEM logo performance indicator</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"startUpTimeInterval\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>startUpTimeInterval = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getActiveForegroundScene\">\n"
            "      <doc>\n"
            "        <line>getActiveForegroundScene = Method to give active screen/popup on foreground</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"activeSceneName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>activeSceneName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getActiveForegroundSceneUpper\">\n"
            "      <doc>\n"
            "        <line>getActiveForegroundSceneUpper = Method to give active screen/popup on foreground in Upper Display</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"activeSceneNameUpper\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>activeSceneNameUpper = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setHMIInfoServiceStatus\">\n"
            "      <doc>\n"
            "        <line>setHMIInfoServiceStatus = Method to enable or disable HMIInfo service</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"hmiInfoStatus\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>hmiInfoStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getNextActiveAppUpper\">\n"
            "      <doc>\n"
            "        <line>getNextActiveAppUpper = Method to give next active application Id of Upper display</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"appIdUpper\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>appIdUpper = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getNextActiveAppLower\">\n"
            "      <doc>\n"
            "        <line>getNextActiveAppLower = Method to give next active application Id of Lower display</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"appIdLower\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>appIdLower = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void HmiMonitorServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HmiMonitorServiceStub*>(getStub()))->onGetAll (properties);
}

void HmiMonitorServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeRenderedViewName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "activeRenderedUpperViewName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "nextActiveAppUpper");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "nextActiveAppLower");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HmiMonitorServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeRenderedViewName");
            ::boost::shared_ptr< ActiveRenderedViewNameGet > payload(new ActiveRenderedViewNameGet());
            payload->setAct(act);
            static_cast<HmiMonitorServiceStub*>(getStub())->onActiveRenderedViewNameGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "activeRenderedUpperViewName");
            ::boost::shared_ptr< ActiveRenderedUpperViewNameGet > payload(new ActiveRenderedUpperViewNameGet());
            payload->setAct(act);
            static_cast<HmiMonitorServiceStub*>(getStub())->onActiveRenderedUpperViewNameGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "nextActiveAppUpper");
            ::boost::shared_ptr< NextActiveAppUpperGet > payload(new NextActiveAppUpperGet());
            payload->setAct(act);
            static_cast<HmiMonitorServiceStub*>(getStub())->onNextActiveAppUpperGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "nextActiveAppLower");
            ::boost::shared_ptr< NextActiveAppLowerGet > payload(new NextActiveAppLowerGet());
            payload->setAct(act);
            static_cast<HmiMonitorServiceStub*>(getStub())->onNextActiveAppLowerGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HmiMonitorServiceStub::HmiMonitorServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiMonitorServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiMonitorServiceStub::HmiMonitorServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiMonitorServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiMonitorServiceStub::~HmiMonitorServiceStub() {
    delete _stubDelegate;
}

void HmiMonitorServiceStub::sendActiveRenderedViewNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveRenderedViewNameUpdate payload(_activeRenderedViewNameProperty);

        LOG_INFO ("-> send%s", "ActiveRenderedViewNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeRenderedViewName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveRenderedViewNameUpdate");
    }
}

void HmiMonitorServiceStub::onActiveRenderedViewNameGet(const ::boost::shared_ptr< ActiveRenderedViewNameGet >& activeRenderedViewName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveRenderedViewNameGet", activeRenderedViewName->getAct());
    sendActiveRenderedViewNameGetUpdate(_activeRenderedViewNameProperty.getActiveRenderedViewName(), activeRenderedViewName->getAct());
}

void HmiMonitorServiceStub::sendActiveRenderedViewNameGetUpdate(const ::std::string& activeRenderedViewName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveRenderedViewNameGet payload(activeRenderedViewName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveRenderedViewNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiMonitorServiceStub::setActiveRenderedViewName(const ::std::string& activeRenderedViewName) {
    if(activeRenderedViewName!=_activeRenderedViewNameProperty.getActiveRenderedViewName()) {
        _activeRenderedViewNameProperty.setActiveRenderedViewName(activeRenderedViewName);
        sendActiveRenderedViewNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& HmiMonitorServiceStub::getActiveRenderedViewName() const {
    return _activeRenderedViewNameProperty.getActiveRenderedViewName();
}

::std::string& HmiMonitorServiceStub::getActiveRenderedViewNameMutable() {
    return _activeRenderedViewNameProperty.getActiveRenderedViewNameMutable();
}

void HmiMonitorServiceStub::sendActiveRenderedUpperViewNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveRenderedUpperViewNameUpdate payload(_activeRenderedUpperViewNameProperty);

        LOG_INFO ("-> send%s", "ActiveRenderedUpperViewNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeRenderedUpperViewName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveRenderedUpperViewNameUpdate");
    }
}

void HmiMonitorServiceStub::onActiveRenderedUpperViewNameGet(const ::boost::shared_ptr< ActiveRenderedUpperViewNameGet >& activeRenderedUpperViewName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveRenderedUpperViewNameGet", activeRenderedUpperViewName->getAct());
    sendActiveRenderedUpperViewNameGetUpdate(_activeRenderedUpperViewNameProperty.getActiveRenderedUpperViewName(), activeRenderedUpperViewName->getAct());
}

void HmiMonitorServiceStub::sendActiveRenderedUpperViewNameGetUpdate(const ::std::string& activeRenderedUpperViewName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveRenderedUpperViewNameGet payload(activeRenderedUpperViewName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveRenderedUpperViewNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiMonitorServiceStub::setActiveRenderedUpperViewName(const ::std::string& activeRenderedUpperViewName) {
    if(activeRenderedUpperViewName!=_activeRenderedUpperViewNameProperty.getActiveRenderedUpperViewName()) {
        _activeRenderedUpperViewNameProperty.setActiveRenderedUpperViewName(activeRenderedUpperViewName);
        sendActiveRenderedUpperViewNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& HmiMonitorServiceStub::getActiveRenderedUpperViewName() const {
    return _activeRenderedUpperViewNameProperty.getActiveRenderedUpperViewName();
}

::std::string& HmiMonitorServiceStub::getActiveRenderedUpperViewNameMutable() {
    return _activeRenderedUpperViewNameProperty.getActiveRenderedUpperViewNameMutable();
}

void HmiMonitorServiceStub::sendNextActiveAppUpperUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NextActiveAppUpperUpdate payload(_nextActiveAppUpperProperty);

        LOG_INFO ("-> send%s", "NextActiveAppUpperUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("nextActiveAppUpper", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NextActiveAppUpperUpdate");
    }
}

void HmiMonitorServiceStub::onNextActiveAppUpperGet(const ::boost::shared_ptr< NextActiveAppUpperGet >& nextActiveAppUpper) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NextActiveAppUpperGet", nextActiveAppUpper->getAct());
    sendNextActiveAppUpperGetUpdate(_nextActiveAppUpperProperty.getNextActiveAppUpper(), nextActiveAppUpper->getAct());
}

void HmiMonitorServiceStub::sendNextActiveAppUpperGetUpdate(const ::std::string& nextActiveAppUpper, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NextActiveAppUpperGet payload(nextActiveAppUpper);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NextActiveAppUpperGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiMonitorServiceStub::setNextActiveAppUpper(const ::std::string& nextActiveAppUpper) {
    if(nextActiveAppUpper!=_nextActiveAppUpperProperty.getNextActiveAppUpper()) {
        _nextActiveAppUpperProperty.setNextActiveAppUpper(nextActiveAppUpper);
        sendNextActiveAppUpperUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& HmiMonitorServiceStub::getNextActiveAppUpper() const {
    return _nextActiveAppUpperProperty.getNextActiveAppUpper();
}

::std::string& HmiMonitorServiceStub::getNextActiveAppUpperMutable() {
    return _nextActiveAppUpperProperty.getNextActiveAppUpperMutable();
}

void HmiMonitorServiceStub::sendNextActiveAppLowerUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NextActiveAppLowerUpdate payload(_nextActiveAppLowerProperty);

        LOG_INFO ("-> send%s", "NextActiveAppLowerUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("nextActiveAppLower", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NextActiveAppLowerUpdate");
    }
}

void HmiMonitorServiceStub::onNextActiveAppLowerGet(const ::boost::shared_ptr< NextActiveAppLowerGet >& nextActiveAppLower) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NextActiveAppLowerGet", nextActiveAppLower->getAct());
    sendNextActiveAppLowerGetUpdate(_nextActiveAppLowerProperty.getNextActiveAppLower(), nextActiveAppLower->getAct());
}

void HmiMonitorServiceStub::sendNextActiveAppLowerGetUpdate(const ::std::string& nextActiveAppLower, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NextActiveAppLowerGet payload(nextActiveAppLower);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NextActiveAppLowerGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiMonitorServiceStub::setNextActiveAppLower(const ::std::string& nextActiveAppLower) {
    if(nextActiveAppLower!=_nextActiveAppLowerProperty.getNextActiveAppLower()) {
        _nextActiveAppLowerProperty.setNextActiveAppLower(nextActiveAppLower);
        sendNextActiveAppLowerUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& HmiMonitorServiceStub::getNextActiveAppLower() const {
    return _nextActiveAppLowerProperty.getNextActiveAppLower();
}

::std::string& HmiMonitorServiceStub::getNextActiveAppLowerMutable() {
    return _nextActiveAppLowerProperty.getNextActiveAppLowerMutable();
}

void  HmiMonitorServiceStub::sendGetStartUpTimeIntervalResponse (uint32 startUpTimeInterval, act_t act) {
    GetStartUpTimeIntervalResponse* payload = new GetStartUpTimeIntervalResponse(startUpTimeInterval);
    DBUS_MESSAGE_REPLY(dbusMessage, "getStartUpTimeInterval", GetStartUpTimeIntervalResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetStartUpTimeInterval", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetStartUpTimeIntervalError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetStartUpTimeIntervalError* payload = new GetStartUpTimeIntervalError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getStartUpTimeInterval", GetStartUpTimeIntervalError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetStartUpTimeInterval", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetActiveForegroundSceneResponse (const ::std::string& activeSceneName, act_t act) {
    GetActiveForegroundSceneResponse* payload = new GetActiveForegroundSceneResponse(activeSceneName);
    DBUS_MESSAGE_REPLY(dbusMessage, "getActiveForegroundScene", GetActiveForegroundSceneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetActiveForegroundScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetActiveForegroundSceneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetActiveForegroundSceneError* payload = new GetActiveForegroundSceneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getActiveForegroundScene", GetActiveForegroundSceneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetActiveForegroundScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetActiveForegroundSceneUpperResponse (const ::std::string& activeSceneNameUpper, act_t act) {
    GetActiveForegroundSceneUpperResponse* payload = new GetActiveForegroundSceneUpperResponse(activeSceneNameUpper);
    DBUS_MESSAGE_REPLY(dbusMessage, "getActiveForegroundSceneUpper", GetActiveForegroundSceneUpperResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetActiveForegroundSceneUpper", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetActiveForegroundSceneUpperError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetActiveForegroundSceneUpperError* payload = new GetActiveForegroundSceneUpperError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getActiveForegroundSceneUpper", GetActiveForegroundSceneUpperError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetActiveForegroundSceneUpper", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendSetHMIInfoServiceStatusResponse (act_t act) {
    SetHMIInfoServiceStatusResponse* payload = new SetHMIInfoServiceStatusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setHMIInfoServiceStatus", SetHMIInfoServiceStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetHMIInfoServiceStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendSetHMIInfoServiceStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetHMIInfoServiceStatusError* payload = new SetHMIInfoServiceStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setHMIInfoServiceStatus", SetHMIInfoServiceStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetHMIInfoServiceStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetNextActiveAppUpperResponse (const ::std::string& appIdUpper, act_t act) {
    GetNextActiveAppUpperResponse* payload = new GetNextActiveAppUpperResponse(appIdUpper);
    DBUS_MESSAGE_REPLY(dbusMessage, "getNextActiveAppUpper", GetNextActiveAppUpperResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetNextActiveAppUpper", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetNextActiveAppUpperError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetNextActiveAppUpperError* payload = new GetNextActiveAppUpperError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getNextActiveAppUpper", GetNextActiveAppUpperError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetNextActiveAppUpper", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetNextActiveAppLowerResponse (const ::std::string& appIdLower, act_t act) {
    GetNextActiveAppLowerResponse* payload = new GetNextActiveAppLowerResponse(appIdLower);
    DBUS_MESSAGE_REPLY(dbusMessage, "getNextActiveAppLower", GetNextActiveAppLowerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetNextActiveAppLower", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiMonitorServiceStub::sendGetNextActiveAppLowerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetNextActiveAppLowerError* payload = new GetNextActiveAppLowerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getNextActiveAppLower", GetNextActiveAppLowerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetNextActiveAppLower", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HmiMonitorServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'activeRenderedViewName'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveRenderedViewNameGet payload(_activeRenderedViewNameProperty.getActiveRenderedViewName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeRenderedViewName", variant));
    }

    //property 'activeRenderedUpperViewName'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveRenderedUpperViewNameGet payload(_activeRenderedUpperViewNameProperty.getActiveRenderedUpperViewName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeRenderedUpperViewName", variant));
    }

    //property 'nextActiveAppUpper'
    {
        ::asf::dbus::DBusVariant variant;
        NextActiveAppUpperGet payload(_nextActiveAppUpperProperty.getNextActiveAppUpper());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("nextActiveAppUpper", variant));
    }

    //property 'nextActiveAppLower'
    {
        ::asf::dbus::DBusVariant variant;
        NextActiveAppLowerGet payload(_nextActiveAppLowerProperty.getNextActiveAppLower());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("nextActiveAppLower", variant));
    }
}

} // namespace HmiMonitorService
} // namespace hmimonitorservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch
