/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICESTUB_H
#define BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {

class HmiInfoServiceStubDelegate;

class HmiInfoServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HmiInfoServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HmiInfoServiceStub (const std::string& portName);

    /**
     * Create an instance of the HmiInfoServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HmiInfoServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~HmiInfoServiceStub();

    // signal 'toggleGadgetAudioSourceRequest'

    /**
     * Raise the signal 'toggleGadgetAudioSourceRequest' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'toggleGadgetAudioSourceRequest'</b>:
     *
     * Signal to update the trigger of gadget audio source toggle
     *
     * @param regionId If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param srcApplicationId If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @param destApplicationId If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     */
    void sendToggleGadgetAudioSourceRequestSignal(uint32 regionId, uint8 srcApplicationId, uint8 destApplicationId);

    // signal 'cabinsSourceDisconnectionTrigger'

    /**
     * Raise the signal 'cabinsSourceDisconnectionTrigger' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'cabinsSourceDisconnectionTrigger'</b>:
     *
     * Signal to trigger cabin source disconnection on subsystem error
     *
     * @param cabinsSourceDisconnectionTriggerInfo If the meaning of "cabinsSourceDisconnectionTriggerInfo" isn't clear, then there should be a description here.
     */
    void sendCabinsSourceDisconnectionTriggerSignal(const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo);

    // signal 'restoreAVSource'

    /**
     * Raise the signal 'restoreAVSource' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'restoreAVSource'</b>:
     *
     * Signal to trigger AV source restoration
     *
     * @param cabinId If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @param sourceId If the meaning of "sourceId" isn't clear, then there should be a description here.
     */
    void sendRestoreAVSourceSignal(uint32 cabinId, int16 sourceId);

    // property 'currentForegroundApplicationId'

    /**
     * The method onCurrentForegroundApplicationIdGet() is called by ASF when
     * a client invokes the read method for the property
     * 'currentForegroundApplicationId'. The
     * onCurrentForegroundApplicationIdGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     */
    virtual void onCurrentForegroundApplicationIdGet(const ::boost::shared_ptr< CurrentForegroundApplicationIdGet >& payload);

    /**
     * Sends back the update to a previous
     * onCurrentForegroundApplicationIdGet().
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     *
     * @param act Identifies a previous invocation of
     * onCurrentForegroundApplicationIdGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendCurrentForegroundApplicationIdGetUpdate(uint8 currentForegroundApplicationId, act_t act = 0);

    /**
     * Set the value of the property 'currentForegroundApplicationId' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     */
    void setCurrentForegroundApplicationId(uint8 currentForegroundApplicationId);

    /**
     * Returns the current value of the property 'currentForegroundApplicationId'.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     */
    uint8 getCurrentForegroundApplicationId() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentForegroundApplicationIdUpdate().
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     */
    void sendCurrentForegroundApplicationIdUpdate();

    // property 'RVCSignalStatus'

    /**
     * The method onRVCSignalStatusGet() is called by ASF when a client
     * invokes the read method for the property 'RVCSignalStatus'. The
     * onRVCSignalStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     */
    virtual void onRVCSignalStatusGet(const ::boost::shared_ptr< RVCSignalStatusGet >& payload);

    /**
     * Sends back the update to a previous onRVCSignalStatusGet().
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @param act Identifies a previous invocation of onRVCSignalStatusGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRVCSignalStatusGetUpdate(bool rVCSignalStatus, act_t act = 0);

    /**
     * Set the value of the property 'RVCSignalStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     */
    void setRVCSignalStatus(bool rVCSignalStatus);

    /**
     * Returns the current value of the property 'RVCSignalStatus'.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     */
    bool getRVCSignalStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRVCSignalStatusUpdate().
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     */
    void sendRVCSignalStatusUpdate();

    // property 'regionsMapOutStatusInfo'

    /**
     * The method onRegionsMapOutStatusInfoGet() is called by ASF when a
     * client invokes the read method for the property
     * 'regionsMapOutStatusInfo'. The onRegionsMapOutStatusInfoGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     */
    virtual void onRegionsMapOutStatusInfoGet(const ::boost::shared_ptr< RegionsMapOutStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous onRegionsMapOutStatusInfoGet().
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     *
     * @param act Identifies a previous invocation of
     * onRegionsMapOutStatusInfoGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegionsMapOutStatusInfoGetUpdate(const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo, act_t act = 0);

    /**
     * Set the value of the property 'regionsMapOutStatusInfo' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     */
    void setRegionsMapOutStatusInfo(const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo);

    /**
     * Returns the current value of the property 'regionsMapOutStatusInfo'.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     */
    const ::std::vector< RegionMapOutStatusInfo >& getRegionsMapOutStatusInfo() const;

    /**
     * Returns the current value of the property 'regionsMapOutStatusInfo' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendRegionsMapOutStatusInfoUpdate() method.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     */
    ::std::vector< RegionMapOutStatusInfo >& getRegionsMapOutStatusInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRegionsMapOutStatusInfoUpdate().
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     */
    void sendRegionsMapOutStatusInfoUpdate();

    // property 'cabinsSourceRestorationInfo'

    /**
     * The method onCabinsSourceRestorationInfoGet() is called by ASF when a
     * client invokes the read method for the property
     * 'cabinsSourceRestorationInfo'. The onCabinsSourceRestorationInfoGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     */
    virtual void onCabinsSourceRestorationInfoGet(const ::boost::shared_ptr< CabinsSourceRestorationInfoGet >& payload);

    /**
     * Sends back the update to a previous onCabinsSourceRestorationInfoGet().
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @param act Identifies a previous invocation of
     * onCabinsSourceRestorationInfoGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendCabinsSourceRestorationInfoGetUpdate(const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo, act_t act = 0);

    /**
     * Set the value of the property 'cabinsSourceRestorationInfo' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     */
    void setCabinsSourceRestorationInfo(const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo);

    /**
     * Returns the current value of the property 'cabinsSourceRestorationInfo'.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     */
    const ::std::vector< CabinSourceRestorationInfo >& getCabinsSourceRestorationInfo() const;

    /**
     * Returns the current value of the property 'cabinsSourceRestorationInfo'
     * as a mutable reference. If you change the content of the returned
     * object you have to send updates to registered clients by yourself with
     * the help of the sendCabinsSourceRestorationInfoUpdate() method.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     */
    ::std::vector< CabinSourceRestorationInfo >& getCabinsSourceRestorationInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCabinsSourceRestorationInfoUpdate().
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     */
    void sendCabinsSourceRestorationInfoUpdate();

    // property 'cabinsSystemsInfo'

    /**
     * The method onCabinsSystemsInfoGet() is called by ASF when a client
     * invokes the read method for the property 'cabinsSystemsInfo'. The
     * onCabinsSystemsInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     */
    virtual void onCabinsSystemsInfoGet(const ::boost::shared_ptr< CabinsSystemsInfoGet >& payload);

    /**
     * Sends back the update to a previous onCabinsSystemsInfoGet().
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     *
     * @param act Identifies a previous invocation of
     * onCabinsSystemsInfoGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCabinsSystemsInfoGetUpdate(const ::std::vector< SystemInfo >& cabinsSystemsInfo, act_t act = 0);

    /**
     * Set the value of the property 'cabinsSystemsInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     */
    void setCabinsSystemsInfo(const ::std::vector< SystemInfo >& cabinsSystemsInfo);

    /**
     * Returns the current value of the property 'cabinsSystemsInfo'.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     */
    const ::std::vector< SystemInfo >& getCabinsSystemsInfo() const;

    /**
     * Returns the current value of the property 'cabinsSystemsInfo' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendCabinsSystemsInfoUpdate() method.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     */
    ::std::vector< SystemInfo >& getCabinsSystemsInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCabinsSystemsInfoUpdate().
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     */
    void sendCabinsSystemsInfoUpdate();

    // property 'LanguageStatusInfo'

    /**
     * The method onLanguageStatusInfoGet() is called by ASF when a client
     * invokes the read method for the property 'LanguageStatusInfo'. The
     * onLanguageStatusInfoGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     */
    virtual void onLanguageStatusInfoGet(const ::boost::shared_ptr< LanguageStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous onLanguageStatusInfoGet().
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     *
     * @param act Identifies a previous invocation of
     * onLanguageStatusInfoGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLanguageStatusInfoGetUpdate(uint32 languageStatusInfo, act_t act = 0);

    /**
     * Set the value of the property 'LanguageStatusInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     */
    void setLanguageStatusInfo(uint32 languageStatusInfo);

    /**
     * Returns the current value of the property 'LanguageStatusInfo'.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     */
    uint32 getLanguageStatusInfo() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLanguageStatusInfoUpdate().
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     */
    void sendLanguageStatusInfoUpdate();

    // property 'spiConnectionStatusInfo'

    /**
     * The method onSpiConnectionStatusInfoGet() is called by ASF when a
     * client invokes the read method for the property
     * 'spiConnectionStatusInfo'. The onSpiConnectionStatusInfoGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    virtual void onSpiConnectionStatusInfoGet(const ::boost::shared_ptr< SpiConnectionStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous onSpiConnectionStatusInfoGet().
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param act Identifies a previous invocation of
     * onSpiConnectionStatusInfoGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpiConnectionStatusInfoGetUpdate(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo, act_t act = 0);

    /**
     * The method onSpiConnectionStatusInfoSet() is called by ASF when a
     * client invokes the write method for the property
     * 'spiConnectionStatusInfo'. The onSpiConnectionStatusInfoSet() method
     * set property value to the given parameter spiConnectionStatusInfo by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    virtual void onSpiConnectionStatusInfoSet(const ::boost::shared_ptr< SpiConnectionStatusInfoSet >& payload);

    /**
     * Sends back the update to a previous onSpiConnectionStatusInfoSet().
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param act Identifies a previous invocation of
     * onSpiConnectionStatusInfoSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpiConnectionStatusInfoSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'spiConnectionStatusInfo' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    void setSpiConnectionStatusInfo(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo);

    /**
     * Returns the current value of the property 'spiConnectionStatusInfo'.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    const SPIConnectionStatusInfoHolder& getSpiConnectionStatusInfo() const;

    /**
     * Returns the current value of the property 'spiConnectionStatusInfo' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendSpiConnectionStatusInfoUpdate() method.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    SPIConnectionStatusInfoHolder& getSpiConnectionStatusInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSpiConnectionStatusInfoUpdate().
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    void sendSpiConnectionStatusInfoUpdate();

    // property 'cabinSourcesConnectionStatus'

    /**
     * The method onCabinSourcesConnectionStatusGet() is called by ASF when a
     * client invokes the read method for the property
     * 'cabinSourcesConnectionStatus'. The onCabinSourcesConnectionStatusGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     */
    virtual void onCabinSourcesConnectionStatusGet(const ::boost::shared_ptr< CabinSourcesConnectionStatusGet >& payload);

    /**
     * Sends back the update to a previous
     * onCabinSourcesConnectionStatusGet().
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     *
     * @param act Identifies a previous invocation of
     * onCabinSourcesConnectionStatusGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendCabinSourcesConnectionStatusGetUpdate(const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus, act_t act = 0);

    /**
     * Set the value of the property 'cabinSourcesConnectionStatus' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     */
    void setCabinSourcesConnectionStatus(const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus);

    /**
     * Returns the current value of the property 'cabinSourcesConnectionStatus'.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     */
    const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatus() const;

    /**
     * Returns the current value of the property
     * 'cabinSourcesConnectionStatus' as a mutable reference. If you change
     * the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendCabinSourcesConnectionStatusUpdate() method.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     */
    ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCabinSourcesConnectionStatusUpdate().
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     */
    void sendCabinSourcesConnectionStatusUpdate();

    // property 'cabinsVideoMixInfo'

    /**
     * The method onCabinsVideoMixInfoGet() is called by ASF when a client
     * invokes the read method for the property 'cabinsVideoMixInfo'. The
     * onCabinsVideoMixInfoGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     */
    virtual void onCabinsVideoMixInfoGet(const ::boost::shared_ptr< CabinsVideoMixInfoGet >& payload);

    /**
     * Sends back the update to a previous onCabinsVideoMixInfoGet().
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     *
     * @param act Identifies a previous invocation of
     * onCabinsVideoMixInfoGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCabinsVideoMixInfoGetUpdate(const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo, act_t act = 0);

    /**
     * Set the value of the property 'cabinsVideoMixInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     */
    void setCabinsVideoMixInfo(const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo);

    /**
     * Returns the current value of the property 'cabinsVideoMixInfo'.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     */
    const ::std::vector< CabinVideoMixInfo >& getCabinsVideoMixInfo() const;

    /**
     * Returns the current value of the property 'cabinsVideoMixInfo' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendCabinsVideoMixInfoUpdate() method.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     */
    ::std::vector< CabinVideoMixInfo >& getCabinsVideoMixInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCabinsVideoMixInfoUpdate().
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     */
    void sendCabinsVideoMixInfoUpdate();

    // method 'getRVCSignalStatus'

    /**
     * The method onGetRVCSignalStatus() is called by ASF when a client
     * invokes the method 'getRVCSignalStatus'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetRVCSignalStatus() or sendGetRVCSignalStatusError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'getRVCSignalStatus'</b>:
     *
     * Method to give RVC Signal status
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetRVCSignalStatusRequest (const ::boost::shared_ptr< GetRVCSignalStatusRequest >& request) = 0;

    /**
     * The method sendGetRVCSignalStatusResponse() sends a response of a
     * previous method invocation of 'getRVCSignalStatus' back to the client.
     *
     * <b>Documentation of 'getRVCSignalStatus'</b>:
     *
     * Method to give RVC Signal status
     *
     * @param RVCSignalStatus If the meaning of "RVCSignalStatus" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetRVCSignalStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetRVCSignalStatusResponse (bool rVCSignalStatus, act_t act = 0);

    /**
     * The method sendGetRVCSignalStatusError() sends an error response of a
     * previous method invocation of 'getRVCSignalStatus' back to the client.
     *
     * <b>Documentation of 'getRVCSignalStatus'</b>:
     *
     * Method to give RVC Signal status
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetRVCSignalStatus().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetRVCSignalStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getCurrentForegroundApplicationId'

    /**
     * The method onGetCurrentForegroundApplicationId() is called by ASF when
     * a client invokes the method 'getCurrentForegroundApplicationId'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendGetCurrentForegroundApplicationId() or
     * sendGetCurrentForegroundApplicationIdError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'getCurrentForegroundApplicationId'</b>:
     *
     * Method to give active screen/popup name
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetCurrentForegroundApplicationIdRequest (const ::boost::shared_ptr< GetCurrentForegroundApplicationIdRequest >& request) = 0;

    /**
     * The method sendGetCurrentForegroundApplicationIdResponse() sends a
     * response of a previous method invocation of
     * 'getCurrentForegroundApplicationId' back to the client.
     *
     * <b>Documentation of 'getCurrentForegroundApplicationId'</b>:
     *
     * Method to give active screen/popup name
     *
     * @param currentForegroundApplicationId If the meaning of "currentForegroundApplicationId" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetCurrentForegroundApplicationId(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendGetCurrentForegroundApplicationIdResponse (const ::std::string& currentForegroundApplicationId, act_t act = 0);

    /**
     * The method sendGetCurrentForegroundApplicationIdError() sends an error
     * response of a previous method invocation of
     * 'getCurrentForegroundApplicationId' back to the client.
     *
     * <b>Documentation of 'getCurrentForegroundApplicationId'</b>:
     *
     * Method to give active screen/popup name
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetCurrentForegroundApplicationId(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendGetCurrentForegroundApplicationIdError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'toggleGadgetAudioSource'

    /**
     * The method onToggleGadgetAudioSource() is called by ASF when a client
     * invokes the method 'toggleGadgetAudioSource'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendToggleGadgetAudioSource() or
     * sendToggleGadgetAudioSourceError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'toggleGadgetAudioSource'</b>:
     *
     * Method to update the trigger of gadget audio source toggle
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onToggleGadgetAudioSourceRequest (const ::boost::shared_ptr< ToggleGadgetAudioSourceRequest >& request) = 0;

    /**
     * The method sendToggleGadgetAudioSourceResponse() sends a response of a
     * previous method invocation of 'toggleGadgetAudioSource' back to the
     * client.
     *
     * <b>Documentation of 'toggleGadgetAudioSource'</b>:
     *
     * Method to update the trigger of gadget audio source toggle
     *
     * @param act The parameter act identifies a previous invocation of
     * onToggleGadgetAudioSource(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendToggleGadgetAudioSourceResponse (act_t act = 0);

    /**
     * The method sendToggleGadgetAudioSourceError() sends an error response
     * of a previous method invocation of 'toggleGadgetAudioSource' back to
     * the client.
     *
     * <b>Documentation of 'toggleGadgetAudioSource'</b>:
     *
     * Method to update the trigger of gadget audio source toggle
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onToggleGadgetAudioSource(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendToggleGadgetAudioSourceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setCabinSourceConnectionStatus'

    /**
     * The method onSetCabinSourceConnectionStatus() is called by ASF when a
     * client invokes the method 'setCabinSourceConnectionStatus'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendSetCabinSourceConnectionStatus() or
     * sendSetCabinSourceConnectionStatusError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'setCabinSourceConnectionStatus'</b>:
     *
     * Method to update the cabin source connection status
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetCabinSourceConnectionStatusRequest (const ::boost::shared_ptr< SetCabinSourceConnectionStatusRequest >& request) = 0;

    /**
     * The method sendSetCabinSourceConnectionStatusResponse() sends a
     * response of a previous method invocation of
     * 'setCabinSourceConnectionStatus' back to the client.
     *
     * <b>Documentation of 'setCabinSourceConnectionStatus'</b>:
     *
     * Method to update the cabin source connection status
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetCabinSourceConnectionStatus(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendSetCabinSourceConnectionStatusResponse (act_t act = 0);

    /**
     * The method sendSetCabinSourceConnectionStatusError() sends an error
     * response of a previous method invocation of
     * 'setCabinSourceConnectionStatus' back to the client.
     *
     * <b>Documentation of 'setCabinSourceConnectionStatus'</b>:
     *
     * Method to update the cabin source connection status
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetCabinSourceConnectionStatus(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendSetCabinSourceConnectionStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'removeCabinSourceConnection'

    /**
     * The method onRemoveCabinSourceConnection() is called by ASF when a
     * client invokes the method 'removeCabinSourceConnection'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendRemoveCabinSourceConnection() or
     * sendRemoveCabinSourceConnectionError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'removeCabinSourceConnection'</b>:
     *
     * Method to remove source from cabin source connection array
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveCabinSourceConnectionRequest (const ::boost::shared_ptr< RemoveCabinSourceConnectionRequest >& request) = 0;

    /**
     * The method sendRemoveCabinSourceConnectionResponse() sends a response
     * of a previous method invocation of 'removeCabinSourceConnection' back
     * to the client.
     *
     * <b>Documentation of 'removeCabinSourceConnection'</b>:
     *
     * Method to remove source from cabin source connection array
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveCabinSourceConnection(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRemoveCabinSourceConnectionResponse (act_t act = 0);

    /**
     * The method sendRemoveCabinSourceConnectionError() sends an error
     * response of a previous method invocation of
     * 'removeCabinSourceConnection' back to the client.
     *
     * <b>Documentation of 'removeCabinSourceConnection'</b>:
     *
     * Method to remove source from cabin source connection array
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRemoveCabinSourceConnection(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRemoveCabinSourceConnectionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setCabinVideoMixIndex'

    /**
     * The method onSetCabinVideoMixIndex() is called by ASF when a client
     * invokes the method 'setCabinVideoMixIndex'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetCabinVideoMixIndex() or sendSetCabinVideoMixIndexError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'setCabinVideoMixIndex'</b>:
     *
     * Method to update the cabin video mix info
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetCabinVideoMixIndexRequest (const ::boost::shared_ptr< SetCabinVideoMixIndexRequest >& request) = 0;

    /**
     * The method sendSetCabinVideoMixIndexResponse() sends a response of a
     * previous method invocation of 'setCabinVideoMixIndex' back to the
     * client.
     *
     * <b>Documentation of 'setCabinVideoMixIndex'</b>:
     *
     * Method to update the cabin video mix info
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetCabinVideoMixIndex(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetCabinVideoMixIndexResponse (act_t act = 0);

    /**
     * The method sendSetCabinVideoMixIndexError() sends an error response of
     * a previous method invocation of 'setCabinVideoMixIndex' back to the
     * client.
     *
     * <b>Documentation of 'setCabinVideoMixIndex'</b>:
     *
     * Method to update the cabin video mix info
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetCabinVideoMixIndex(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetCabinVideoMixIndexError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    CurrentForegroundApplicationIdUpdate _currentForegroundApplicationIdProperty;

    RVCSignalStatusUpdate _RVCSignalStatusProperty;

    RegionsMapOutStatusInfoUpdate _regionsMapOutStatusInfoProperty;

    CabinsSourceRestorationInfoUpdate _cabinsSourceRestorationInfoProperty;

    CabinsSystemsInfoUpdate _cabinsSystemsInfoProperty;

    LanguageStatusInfoUpdate _LanguageStatusInfoProperty;

    SpiConnectionStatusInfoUpdate _spiConnectionStatusInfoProperty;

    CabinSourcesConnectionStatusUpdate _cabinSourcesConnectionStatusProperty;

    CabinsVideoMixInfoUpdate _cabinsVideoMixInfoProperty;

    friend class HmiInfoServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HmiInfoService
} // namespace hmiinfoservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICESTUB_H
