/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceDBus.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceJson.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/hmiinfoservice/bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService", HmiInfoServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 18, "getRVCSignalStatus", 0 },
    { 21, "setCabinVideoMixIndex", 5 },
    { 23, "toggleGadgetAudioSource", 2 },
    { 27, "removeCabinSourceConnection", 4 },
    { 30, "setCabinSourceConnectionStatus", 3 },
    { 33, "getCurrentForegroundApplicationId", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 15, "RVCSignalStatus", 1 },
    { 17, "cabinsSystemsInfo", 4 },
    { 18, "LanguageStatusInfo", 5 },
    { 18, "cabinsVideoMixInfo", 8 },
    { 23, "regionsMapOutStatusInfo", 2 },
    { 23, "spiConnectionStatusInfo", 6 },
    { 27, "cabinsSourceRestorationInfo", 3 },
    { 28, "cabinSourcesConnectionStatus", 7 },
    { 30, "currentForegroundApplicationId", 0 },
};

class HmiInfoServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HmiInfoServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HmiInfoServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HmiInfoServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService"),
          _logger(logger) {}

    virtual ~HmiInfoServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HmiInfoServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'getRVCSignalStatus'

            LOG_DEBUG_STUB("process method '%s'", "getRVCSignalStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRVCSignalStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetRVCSignalStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetRVCSignalStatusRequest > payload = ::boost::static_pointer_cast<GetRVCSignalStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onGetRVCSignalStatusRequest(payload);
            return;
        }
        case 1: {

            // method 'getCurrentForegroundApplicationId'

            LOG_DEBUG_STUB("process method '%s'", "getCurrentForegroundApplicationId");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCurrentForegroundApplicationIdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetCurrentForegroundApplicationId", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetCurrentForegroundApplicationIdRequest > payload = ::boost::static_pointer_cast<GetCurrentForegroundApplicationIdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onGetCurrentForegroundApplicationIdRequest(payload);
            return;
        }
        case 2: {

            // method 'toggleGadgetAudioSource'

            LOG_DEBUG_STUB("process method '%s'", "toggleGadgetAudioSource");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ToggleGadgetAudioSourceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ToggleGadgetAudioSource", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ToggleGadgetAudioSourceRequest > payload = ::boost::static_pointer_cast<ToggleGadgetAudioSourceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onToggleGadgetAudioSourceRequest(payload);
            return;
        }
        case 3: {

            // method 'setCabinSourceConnectionStatus'

            LOG_DEBUG_STUB("process method '%s'", "setCabinSourceConnectionStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinSourceConnectionStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetCabinSourceConnectionStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetCabinSourceConnectionStatusRequest > payload = ::boost::static_pointer_cast<SetCabinSourceConnectionStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onSetCabinSourceConnectionStatusRequest(payload);
            return;
        }
        case 4: {

            // method 'removeCabinSourceConnection'

            LOG_DEBUG_STUB("process method '%s'", "removeCabinSourceConnection");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveCabinSourceConnectionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveCabinSourceConnection", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveCabinSourceConnectionRequest > payload = ::boost::static_pointer_cast<RemoveCabinSourceConnectionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onRemoveCabinSourceConnectionRequest(payload);
            return;
        }
        case 5: {

            // method 'setCabinVideoMixIndex'

            LOG_DEBUG_STUB("process method '%s'", "setCabinVideoMixIndex");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinVideoMixIndexRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetCabinVideoMixIndex", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetCabinVideoMixIndexRequest > payload = ::boost::static_pointer_cast<SetCabinVideoMixIndexRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiInfoServiceStub*>(getStub())->onSetCabinVideoMixIndexRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HmiInfoServiceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService\">\n"
            "    <property access=\"read\" name=\"currentForegroundApplicationId\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"RVCSignalStatus\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"regionsMapOutStatusInfo\" type=\"a(ua(ub))\"/>\n"
            "    <property access=\"read\" name=\"cabinsSourceRestorationInfo\" type=\"a(uya(nnyuy))\"/>\n"
            "    <property access=\"read\" name=\"cabinsSystemsInfo\" type=\"a(autyyyyyyy)\"/>\n"
            "    <property access=\"read\" name=\"LanguageStatusInfo\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"spiConnectionStatusInfo\" type=\"(yys)\"/>\n"
            "    <property access=\"read\" name=\"cabinSourcesConnectionStatus\" type=\"a(nbsu)\"/>\n"
            "    <property access=\"read\" name=\"cabinsVideoMixInfo\" type=\"a(uyy)\"/>\n"
            "    <method name=\"getRVCSignalStatus\">\n"
            "      <doc>\n"
            "        <line>getRVCSignalStatus = Method to give RVC Signal status</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"RVCSignalStatus\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>RVCSignalStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getCurrentForegroundApplicationId\">\n"
            "      <doc>\n"
            "        <line>getCurrentForegroundApplicationId = Method to give active screen/popup name</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"currentForegroundApplicationId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>currentForegroundApplicationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"toggleGadgetAudioSource\">\n"
            "      <doc>\n"
            "        <line>toggleGadgetAudioSource = Method to update the trigger of gadget audio source toggle</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"regionId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"srcApplicationId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>srcApplicationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"destApplicationId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>destApplicationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setCabinSourceConnectionStatus\">\n"
            "      <doc>\n"
            "        <line>setCabinSourceConnectionStatus = Method to update the cabin source connection status</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"cabinSourcesConnectionStatusInfo\" type=\"a(nbsu)\">\n"
            "        <doc>\n"
            "          <line>cabinSourcesConnectionStatusInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"removeCabinSourceConnection\">\n"
            "      <doc>\n"
            "        <line>removeCabinSourceConnection = Method to remove source from cabin source connection array</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sourcesIdInfo\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>sourcesIdInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setCabinVideoMixIndex\">\n"
            "      <doc>\n"
            "        <line>setCabinVideoMixIndex = Method to update the cabin video mix info</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"cabinVideoMixInfo\" type=\"(uyy)\">\n"
            "        <doc>\n"
            "          <line>cabinVideoMixInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"toggleGadgetAudioSourceRequest\">\n"
            "      <doc>\n"
            "        <line>toggleGadgetAudioSourceRequest = Signal to update the trigger of gadget audio source toggle</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"regionId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"srcApplicationId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>srcApplicationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"destApplicationId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>destApplicationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"cabinsSourceDisconnectionTrigger\">\n"
            "      <doc>\n"
            "        <line>cabinsSourceDisconnectionTrigger = Signal to trigger cabin source disconnection on subsystem error</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"cabinsSourceDisconnectionTriggerInfo\" type=\"a(uuua(nnyuy))\">\n"
            "        <doc>\n"
            "          <line>cabinsSourceDisconnectionTriggerInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"restoreAVSource\">\n"
            "      <doc>\n"
            "        <line>restoreAVSource = Signal to trigger AV source restoration</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"cabinId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>cabinId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"sourceId\" type=\"n\">\n"
            "        <doc>\n"
            "          <line>sourceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void HmiInfoServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HmiInfoServiceStub*>(getStub()))->onGetAll (properties);
}

void HmiInfoServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 9, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "currentForegroundApplicationId");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "RVCSignalStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "regionsMapOutStatusInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsSourceRestorationInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsSystemsInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "LanguageStatusInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "spiConnectionStatusInfo");
            ::boost::shared_ptr< SpiConnectionStatusInfoSet > payload(new SpiConnectionStatusInfoSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<HmiInfoServiceStub*>(getStub())->onSpiConnectionStatusInfoSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "cabinSourcesConnectionStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsVideoMixInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HmiInfoServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 9, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "currentForegroundApplicationId");
            ::boost::shared_ptr< CurrentForegroundApplicationIdGet > payload(new CurrentForegroundApplicationIdGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onCurrentForegroundApplicationIdGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "RVCSignalStatus");
            ::boost::shared_ptr< RVCSignalStatusGet > payload(new RVCSignalStatusGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onRVCSignalStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "regionsMapOutStatusInfo");
            ::boost::shared_ptr< RegionsMapOutStatusInfoGet > payload(new RegionsMapOutStatusInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onRegionsMapOutStatusInfoGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsSourceRestorationInfo");
            ::boost::shared_ptr< CabinsSourceRestorationInfoGet > payload(new CabinsSourceRestorationInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onCabinsSourceRestorationInfoGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsSystemsInfo");
            ::boost::shared_ptr< CabinsSystemsInfoGet > payload(new CabinsSystemsInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onCabinsSystemsInfoGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "LanguageStatusInfo");
            ::boost::shared_ptr< LanguageStatusInfoGet > payload(new LanguageStatusInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onLanguageStatusInfoGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "spiConnectionStatusInfo");
            ::boost::shared_ptr< SpiConnectionStatusInfoGet > payload(new SpiConnectionStatusInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onSpiConnectionStatusInfoGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "cabinSourcesConnectionStatus");
            ::boost::shared_ptr< CabinSourcesConnectionStatusGet > payload(new CabinSourcesConnectionStatusGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onCabinSourcesConnectionStatusGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "cabinsVideoMixInfo");
            ::boost::shared_ptr< CabinsVideoMixInfoGet > payload(new CabinsVideoMixInfoGet());
            payload->setAct(act);
            static_cast<HmiInfoServiceStub*>(getStub())->onCabinsVideoMixInfoGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HmiInfoServiceStub::HmiInfoServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiInfoServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiInfoServiceStub::HmiInfoServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiInfoServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiInfoServiceStub::~HmiInfoServiceStub() {
    delete _stubDelegate;
}

void HmiInfoServiceStub::sendToggleGadgetAudioSourceRequestSignal(uint32 regionId, uint8 srcApplicationId, uint8 destApplicationId) {
    if (_stubDelegate->isConnected()) {
        ToggleGadgetAudioSourceRequestSignal* payload = new ToggleGadgetAudioSourceRequestSignal(regionId, srcApplicationId, destApplicationId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "toggleGadgetAudioSourceRequest", ToggleGadgetAudioSourceRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "ToggleGadgetAudioSourceRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ToggleGadgetAudioSourceRequest");
    }
}

void HmiInfoServiceStub::sendCabinsSourceDisconnectionTriggerSignal(const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo) {
    if (_stubDelegate->isConnected()) {
        CabinsSourceDisconnectionTriggerSignal* payload = new CabinsSourceDisconnectionTriggerSignal(cabinsSourceDisconnectionTriggerInfo);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "cabinsSourceDisconnectionTrigger", CabinsSourceDisconnectionTriggerSignal, payload)
        LOG_INFO ("-> send%sSignal", "CabinsSourceDisconnectionTrigger");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "CabinsSourceDisconnectionTrigger");
    }
}

void HmiInfoServiceStub::sendRestoreAVSourceSignal(uint32 cabinId, int16 sourceId) {
    if (_stubDelegate->isConnected()) {
        RestoreAVSourceSignal* payload = new RestoreAVSourceSignal(cabinId, sourceId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "restoreAVSource", RestoreAVSourceSignal, payload)
        LOG_INFO ("-> send%sSignal", "RestoreAVSource");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RestoreAVSource");
    }
}

void HmiInfoServiceStub::sendCurrentForegroundApplicationIdUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentForegroundApplicationIdUpdate payload(_currentForegroundApplicationIdProperty);

        LOG_INFO ("-> send%s", "CurrentForegroundApplicationIdUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("currentForegroundApplicationId", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentForegroundApplicationIdUpdate");
    }
}

void HmiInfoServiceStub::onCurrentForegroundApplicationIdGet(const ::boost::shared_ptr< CurrentForegroundApplicationIdGet >& currentForegroundApplicationId) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentForegroundApplicationIdGet", currentForegroundApplicationId->getAct());
    sendCurrentForegroundApplicationIdGetUpdate(_currentForegroundApplicationIdProperty.getCurrentForegroundApplicationId(), currentForegroundApplicationId->getAct());
}

void HmiInfoServiceStub::sendCurrentForegroundApplicationIdGetUpdate(uint8 currentForegroundApplicationId, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentForegroundApplicationIdGet payload(currentForegroundApplicationId);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentForegroundApplicationIdGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setCurrentForegroundApplicationId(uint8 currentForegroundApplicationId) {
    if(currentForegroundApplicationId!=_currentForegroundApplicationIdProperty.getCurrentForegroundApplicationId()) {
        _currentForegroundApplicationIdProperty.setCurrentForegroundApplicationId(currentForegroundApplicationId);
        sendCurrentForegroundApplicationIdUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 HmiInfoServiceStub::getCurrentForegroundApplicationId() const {
    return _currentForegroundApplicationIdProperty.getCurrentForegroundApplicationId();
}

void HmiInfoServiceStub::sendRVCSignalStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RVCSignalStatusUpdate payload(_RVCSignalStatusProperty);

        LOG_INFO ("-> send%s", "RVCSignalStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RVCSignalStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RVCSignalStatusUpdate");
    }
}

void HmiInfoServiceStub::onRVCSignalStatusGet(const ::boost::shared_ptr< RVCSignalStatusGet >& rVCSignalStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RVCSignalStatusGet", rVCSignalStatus->getAct());
    sendRVCSignalStatusGetUpdate(_RVCSignalStatusProperty.getRVCSignalStatus(), rVCSignalStatus->getAct());
}

void HmiInfoServiceStub::sendRVCSignalStatusGetUpdate(bool rVCSignalStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RVCSignalStatusGet payload(rVCSignalStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RVCSignalStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setRVCSignalStatus(bool rVCSignalStatus) {
    if(rVCSignalStatus!=_RVCSignalStatusProperty.getRVCSignalStatus()) {
        _RVCSignalStatusProperty.setRVCSignalStatus(rVCSignalStatus);
        sendRVCSignalStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool HmiInfoServiceStub::getRVCSignalStatus() const {
    return _RVCSignalStatusProperty.getRVCSignalStatus();
}

void HmiInfoServiceStub::sendRegionsMapOutStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RegionsMapOutStatusInfoUpdate payload(_regionsMapOutStatusInfoProperty);

        LOG_INFO ("-> send%s", "RegionsMapOutStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("regionsMapOutStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RegionsMapOutStatusInfoUpdate");
    }
}

void HmiInfoServiceStub::onRegionsMapOutStatusInfoGet(const ::boost::shared_ptr< RegionsMapOutStatusInfoGet >& regionsMapOutStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RegionsMapOutStatusInfoGet", regionsMapOutStatusInfo->getAct());
    sendRegionsMapOutStatusInfoGetUpdate(_regionsMapOutStatusInfoProperty.getRegionsMapOutStatusInfo(), regionsMapOutStatusInfo->getAct());
}

void HmiInfoServiceStub::sendRegionsMapOutStatusInfoGetUpdate(const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RegionsMapOutStatusInfoGet payload(regionsMapOutStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RegionsMapOutStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setRegionsMapOutStatusInfo(const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo) {
    if(regionsMapOutStatusInfo!=_regionsMapOutStatusInfoProperty.getRegionsMapOutStatusInfo()) {
        _regionsMapOutStatusInfoProperty.setRegionsMapOutStatusInfo(regionsMapOutStatusInfo);
        sendRegionsMapOutStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< RegionMapOutStatusInfo >& HmiInfoServiceStub::getRegionsMapOutStatusInfo() const {
    return _regionsMapOutStatusInfoProperty.getRegionsMapOutStatusInfo();
}

::std::vector< RegionMapOutStatusInfo >& HmiInfoServiceStub::getRegionsMapOutStatusInfoMutable() {
    return _regionsMapOutStatusInfoProperty.getRegionsMapOutStatusInfoMutable();
}

void HmiInfoServiceStub::sendCabinsSourceRestorationInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CabinsSourceRestorationInfoUpdate payload(_cabinsSourceRestorationInfoProperty);

        LOG_INFO ("-> send%s", "CabinsSourceRestorationInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("cabinsSourceRestorationInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CabinsSourceRestorationInfoUpdate");
    }
}

void HmiInfoServiceStub::onCabinsSourceRestorationInfoGet(const ::boost::shared_ptr< CabinsSourceRestorationInfoGet >& cabinsSourceRestorationInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CabinsSourceRestorationInfoGet", cabinsSourceRestorationInfo->getAct());
    sendCabinsSourceRestorationInfoGetUpdate(_cabinsSourceRestorationInfoProperty.getCabinsSourceRestorationInfo(), cabinsSourceRestorationInfo->getAct());
}

void HmiInfoServiceStub::sendCabinsSourceRestorationInfoGetUpdate(const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CabinsSourceRestorationInfoGet payload(cabinsSourceRestorationInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CabinsSourceRestorationInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setCabinsSourceRestorationInfo(const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo) {
    if(cabinsSourceRestorationInfo!=_cabinsSourceRestorationInfoProperty.getCabinsSourceRestorationInfo()) {
        _cabinsSourceRestorationInfoProperty.setCabinsSourceRestorationInfo(cabinsSourceRestorationInfo);
        sendCabinsSourceRestorationInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< CabinSourceRestorationInfo >& HmiInfoServiceStub::getCabinsSourceRestorationInfo() const {
    return _cabinsSourceRestorationInfoProperty.getCabinsSourceRestorationInfo();
}

::std::vector< CabinSourceRestorationInfo >& HmiInfoServiceStub::getCabinsSourceRestorationInfoMutable() {
    return _cabinsSourceRestorationInfoProperty.getCabinsSourceRestorationInfoMutable();
}

void HmiInfoServiceStub::sendCabinsSystemsInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CabinsSystemsInfoUpdate payload(_cabinsSystemsInfoProperty);

        LOG_INFO ("-> send%s", "CabinsSystemsInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("cabinsSystemsInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CabinsSystemsInfoUpdate");
    }
}

void HmiInfoServiceStub::onCabinsSystemsInfoGet(const ::boost::shared_ptr< CabinsSystemsInfoGet >& cabinsSystemsInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CabinsSystemsInfoGet", cabinsSystemsInfo->getAct());
    sendCabinsSystemsInfoGetUpdate(_cabinsSystemsInfoProperty.getCabinsSystemsInfo(), cabinsSystemsInfo->getAct());
}

void HmiInfoServiceStub::sendCabinsSystemsInfoGetUpdate(const ::std::vector< SystemInfo >& cabinsSystemsInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CabinsSystemsInfoGet payload(cabinsSystemsInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CabinsSystemsInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setCabinsSystemsInfo(const ::std::vector< SystemInfo >& cabinsSystemsInfo) {
    if(cabinsSystemsInfo!=_cabinsSystemsInfoProperty.getCabinsSystemsInfo()) {
        _cabinsSystemsInfoProperty.setCabinsSystemsInfo(cabinsSystemsInfo);
        sendCabinsSystemsInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< SystemInfo >& HmiInfoServiceStub::getCabinsSystemsInfo() const {
    return _cabinsSystemsInfoProperty.getCabinsSystemsInfo();
}

::std::vector< SystemInfo >& HmiInfoServiceStub::getCabinsSystemsInfoMutable() {
    return _cabinsSystemsInfoProperty.getCabinsSystemsInfoMutable();
}

void HmiInfoServiceStub::sendLanguageStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LanguageStatusInfoUpdate payload(_LanguageStatusInfoProperty);

        LOG_INFO ("-> send%s", "LanguageStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LanguageStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LanguageStatusInfoUpdate");
    }
}

void HmiInfoServiceStub::onLanguageStatusInfoGet(const ::boost::shared_ptr< LanguageStatusInfoGet >& languageStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LanguageStatusInfoGet", languageStatusInfo->getAct());
    sendLanguageStatusInfoGetUpdate(_LanguageStatusInfoProperty.getLanguageStatusInfo(), languageStatusInfo->getAct());
}

void HmiInfoServiceStub::sendLanguageStatusInfoGetUpdate(uint32 languageStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LanguageStatusInfoGet payload(languageStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LanguageStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setLanguageStatusInfo(uint32 languageStatusInfo) {
    if(languageStatusInfo!=_LanguageStatusInfoProperty.getLanguageStatusInfo()) {
        _LanguageStatusInfoProperty.setLanguageStatusInfo(languageStatusInfo);
        sendLanguageStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 HmiInfoServiceStub::getLanguageStatusInfo() const {
    return _LanguageStatusInfoProperty.getLanguageStatusInfo();
}

void HmiInfoServiceStub::sendSpiConnectionStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpiConnectionStatusInfoUpdate payload(_spiConnectionStatusInfoProperty);

        LOG_INFO ("-> send%s", "SpiConnectionStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("spiConnectionStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpiConnectionStatusInfoUpdate");
    }
}

void HmiInfoServiceStub::onSpiConnectionStatusInfoGet(const ::boost::shared_ptr< SpiConnectionStatusInfoGet >& spiConnectionStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpiConnectionStatusInfoGet", spiConnectionStatusInfo->getAct());
    sendSpiConnectionStatusInfoGetUpdate(_spiConnectionStatusInfoProperty.getSpiConnectionStatusInfo(), spiConnectionStatusInfo->getAct());
}

void HmiInfoServiceStub::sendSpiConnectionStatusInfoGetUpdate(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpiConnectionStatusInfoGet payload(spiConnectionStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpiConnectionStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::onSpiConnectionStatusInfoSet(const ::boost::shared_ptr< SpiConnectionStatusInfoSet >& spiConnectionStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpiConnectionStatusInfoSet", spiConnectionStatusInfo->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*spiConnectionStatusInfo, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSpiConnectionStatusInfo (spiConnectionStatusInfo->getSpiConnectionStatusInfo());
    sendSpiConnectionStatusInfoSetUpdate(spiConnectionStatusInfo->getAct());
}

void HmiInfoServiceStub::sendSpiConnectionStatusInfoSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpiConnectionStatusInfoSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void HmiInfoServiceStub::setSpiConnectionStatusInfo(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo) {
    if(spiConnectionStatusInfo!=_spiConnectionStatusInfoProperty.getSpiConnectionStatusInfo()) {
        _spiConnectionStatusInfoProperty.setSpiConnectionStatusInfo(spiConnectionStatusInfo);
        sendSpiConnectionStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SPIConnectionStatusInfoHolder& HmiInfoServiceStub::getSpiConnectionStatusInfo() const {
    return _spiConnectionStatusInfoProperty.getSpiConnectionStatusInfo();
}

SPIConnectionStatusInfoHolder& HmiInfoServiceStub::getSpiConnectionStatusInfoMutable() {
    return _spiConnectionStatusInfoProperty.getSpiConnectionStatusInfoMutable();
}

void HmiInfoServiceStub::sendCabinSourcesConnectionStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CabinSourcesConnectionStatusUpdate payload(_cabinSourcesConnectionStatusProperty);

        LOG_INFO ("-> send%s", "CabinSourcesConnectionStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("cabinSourcesConnectionStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CabinSourcesConnectionStatusUpdate");
    }
}

void HmiInfoServiceStub::onCabinSourcesConnectionStatusGet(const ::boost::shared_ptr< CabinSourcesConnectionStatusGet >& cabinSourcesConnectionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CabinSourcesConnectionStatusGet", cabinSourcesConnectionStatus->getAct());
    sendCabinSourcesConnectionStatusGetUpdate(_cabinSourcesConnectionStatusProperty.getCabinSourcesConnectionStatus(), cabinSourcesConnectionStatus->getAct());
}

void HmiInfoServiceStub::sendCabinSourcesConnectionStatusGetUpdate(const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CabinSourcesConnectionStatusGet payload(cabinSourcesConnectionStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CabinSourcesConnectionStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setCabinSourcesConnectionStatus(const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus) {
    if(cabinSourcesConnectionStatus!=_cabinSourcesConnectionStatusProperty.getCabinSourcesConnectionStatus()) {
        _cabinSourcesConnectionStatusProperty.setCabinSourcesConnectionStatus(cabinSourcesConnectionStatus);
        sendCabinSourcesConnectionStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< CabinSourceConnectionStatusInfo >& HmiInfoServiceStub::getCabinSourcesConnectionStatus() const {
    return _cabinSourcesConnectionStatusProperty.getCabinSourcesConnectionStatus();
}

::std::vector< CabinSourceConnectionStatusInfo >& HmiInfoServiceStub::getCabinSourcesConnectionStatusMutable() {
    return _cabinSourcesConnectionStatusProperty.getCabinSourcesConnectionStatusMutable();
}

void HmiInfoServiceStub::sendCabinsVideoMixInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CabinsVideoMixInfoUpdate payload(_cabinsVideoMixInfoProperty);

        LOG_INFO ("-> send%s", "CabinsVideoMixInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("cabinsVideoMixInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CabinsVideoMixInfoUpdate");
    }
}

void HmiInfoServiceStub::onCabinsVideoMixInfoGet(const ::boost::shared_ptr< CabinsVideoMixInfoGet >& cabinsVideoMixInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CabinsVideoMixInfoGet", cabinsVideoMixInfo->getAct());
    sendCabinsVideoMixInfoGetUpdate(_cabinsVideoMixInfoProperty.getCabinsVideoMixInfo(), cabinsVideoMixInfo->getAct());
}

void HmiInfoServiceStub::sendCabinsVideoMixInfoGetUpdate(const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CabinsVideoMixInfoGet payload(cabinsVideoMixInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CabinsVideoMixInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiInfoServiceStub::setCabinsVideoMixInfo(const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo) {
    if(cabinsVideoMixInfo!=_cabinsVideoMixInfoProperty.getCabinsVideoMixInfo()) {
        _cabinsVideoMixInfoProperty.setCabinsVideoMixInfo(cabinsVideoMixInfo);
        sendCabinsVideoMixInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< CabinVideoMixInfo >& HmiInfoServiceStub::getCabinsVideoMixInfo() const {
    return _cabinsVideoMixInfoProperty.getCabinsVideoMixInfo();
}

::std::vector< CabinVideoMixInfo >& HmiInfoServiceStub::getCabinsVideoMixInfoMutable() {
    return _cabinsVideoMixInfoProperty.getCabinsVideoMixInfoMutable();
}

void  HmiInfoServiceStub::sendGetRVCSignalStatusResponse (bool rVCSignalStatus, act_t act) {
    GetRVCSignalStatusResponse* payload = new GetRVCSignalStatusResponse(rVCSignalStatus);
    DBUS_MESSAGE_REPLY(dbusMessage, "getRVCSignalStatus", GetRVCSignalStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetRVCSignalStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendGetRVCSignalStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetRVCSignalStatusError* payload = new GetRVCSignalStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getRVCSignalStatus", GetRVCSignalStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetRVCSignalStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendGetCurrentForegroundApplicationIdResponse (const ::std::string& currentForegroundApplicationId, act_t act) {
    GetCurrentForegroundApplicationIdResponse* payload = new GetCurrentForegroundApplicationIdResponse(currentForegroundApplicationId);
    DBUS_MESSAGE_REPLY(dbusMessage, "getCurrentForegroundApplicationId", GetCurrentForegroundApplicationIdResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetCurrentForegroundApplicationId", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendGetCurrentForegroundApplicationIdError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetCurrentForegroundApplicationIdError* payload = new GetCurrentForegroundApplicationIdError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getCurrentForegroundApplicationId", GetCurrentForegroundApplicationIdError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetCurrentForegroundApplicationId", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendToggleGadgetAudioSourceResponse (act_t act) {
    ToggleGadgetAudioSourceResponse* payload = new ToggleGadgetAudioSourceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "toggleGadgetAudioSource", ToggleGadgetAudioSourceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ToggleGadgetAudioSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendToggleGadgetAudioSourceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ToggleGadgetAudioSourceError* payload = new ToggleGadgetAudioSourceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "toggleGadgetAudioSource", ToggleGadgetAudioSourceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ToggleGadgetAudioSource", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendSetCabinSourceConnectionStatusResponse (act_t act) {
    SetCabinSourceConnectionStatusResponse* payload = new SetCabinSourceConnectionStatusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setCabinSourceConnectionStatus", SetCabinSourceConnectionStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetCabinSourceConnectionStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendSetCabinSourceConnectionStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetCabinSourceConnectionStatusError* payload = new SetCabinSourceConnectionStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setCabinSourceConnectionStatus", SetCabinSourceConnectionStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetCabinSourceConnectionStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendRemoveCabinSourceConnectionResponse (act_t act) {
    RemoveCabinSourceConnectionResponse* payload = new RemoveCabinSourceConnectionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "removeCabinSourceConnection", RemoveCabinSourceConnectionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveCabinSourceConnection", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendRemoveCabinSourceConnectionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveCabinSourceConnectionError* payload = new RemoveCabinSourceConnectionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "removeCabinSourceConnection", RemoveCabinSourceConnectionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveCabinSourceConnection", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendSetCabinVideoMixIndexResponse (act_t act) {
    SetCabinVideoMixIndexResponse* payload = new SetCabinVideoMixIndexResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setCabinVideoMixIndex", SetCabinVideoMixIndexResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetCabinVideoMixIndex", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiInfoServiceStub::sendSetCabinVideoMixIndexError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetCabinVideoMixIndexError* payload = new SetCabinVideoMixIndexError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setCabinVideoMixIndex", SetCabinVideoMixIndexError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetCabinVideoMixIndex", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HmiInfoServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'currentForegroundApplicationId'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentForegroundApplicationIdGet payload(_currentForegroundApplicationIdProperty.getCurrentForegroundApplicationId());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("currentForegroundApplicationId", variant));
    }

    //property 'RVCSignalStatus'
    {
        ::asf::dbus::DBusVariant variant;
        RVCSignalStatusGet payload(_RVCSignalStatusProperty.getRVCSignalStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RVCSignalStatus", variant));
    }

    //property 'regionsMapOutStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        RegionsMapOutStatusInfoGet payload(_regionsMapOutStatusInfoProperty.getRegionsMapOutStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("regionsMapOutStatusInfo", variant));
    }

    //property 'cabinsSourceRestorationInfo'
    {
        ::asf::dbus::DBusVariant variant;
        CabinsSourceRestorationInfoGet payload(_cabinsSourceRestorationInfoProperty.getCabinsSourceRestorationInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("cabinsSourceRestorationInfo", variant));
    }

    //property 'cabinsSystemsInfo'
    {
        ::asf::dbus::DBusVariant variant;
        CabinsSystemsInfoGet payload(_cabinsSystemsInfoProperty.getCabinsSystemsInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("cabinsSystemsInfo", variant));
    }

    //property 'LanguageStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        LanguageStatusInfoGet payload(_LanguageStatusInfoProperty.getLanguageStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LanguageStatusInfo", variant));
    }

    //property 'spiConnectionStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        SpiConnectionStatusInfoGet payload(_spiConnectionStatusInfoProperty.getSpiConnectionStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("spiConnectionStatusInfo", variant));
    }

    //property 'cabinSourcesConnectionStatus'
    {
        ::asf::dbus::DBusVariant variant;
        CabinSourcesConnectionStatusGet payload(_cabinSourcesConnectionStatusProperty.getCabinSourcesConnectionStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("cabinSourcesConnectionStatus", variant));
    }

    //property 'cabinsVideoMixInfo'
    {
        ::asf::dbus::DBusVariant variant;
        CabinsVideoMixInfoGet payload(_cabinsVideoMixInfoProperty.getCabinsVideoMixInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("cabinsVideoMixInfo", variant));
    }
}

} // namespace HmiInfoService
} // namespace hmiinfoservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
