/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceDBus.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceJson.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/hmiinfoservice/bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService", HmiInfoServiceProxy);

class HmiInfoServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HmiInfoServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HmiInfoServiceProxy >& proxyShared = ::boost::static_pointer_cast< HmiInfoServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_toggleGadgetAudioSourceRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ToggleGadgetAudioSourceRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ToggleGadgetAudioSourceRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ToggleGadgetAudioSourceRequestSignal> payload = ::boost::static_pointer_cast<ToggleGadgetAudioSourceRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ToggleGadgetAudioSourceRequestCallbackIF*) _callback)->onToggleGadgetAudioSourceRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_cabinsSourceDisconnectionTrigger:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsSourceDisconnectionTriggerSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsSourceDisconnectionTrigger", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<CabinsSourceDisconnectionTriggerSignal> payload = ::boost::static_pointer_cast<CabinsSourceDisconnectionTriggerSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((CabinsSourceDisconnectionTriggerCallbackIF*) _callback)->onCabinsSourceDisconnectionTriggerSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_restoreAVSource:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreAVSourceSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestoreAVSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RestoreAVSourceSignal> payload = ::boost::static_pointer_cast<RestoreAVSourceSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RestoreAVSourceCallbackIF*) _callback)->onRestoreAVSourceSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_currentForegroundApplicationId:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentForegroundApplicationIdError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentForegroundApplicationIdError> payload = ::boost::static_pointer_cast<CurrentForegroundApplicationIdError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentForegroundApplicationIdCallbackIF*) _callback)->onCurrentForegroundApplicationIdError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentForegroundApplicationIdUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentForegroundApplicationIdUpdate> payload = ::boost::static_pointer_cast<CurrentForegroundApplicationIdUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentForegroundApplicationIdCallbackIF*) _callback)->onCurrentForegroundApplicationIdUpdate(proxyShared, payload);
                        proxyShared->_currentForegroundApplicationId = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RVCSignalStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RVCSignalStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RVCSignalStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RVCSignalStatusError> payload = ::boost::static_pointer_cast<RVCSignalStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RVCSignalStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RVCSignalStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RVCSignalStatusUpdate> payload = ::boost::static_pointer_cast<RVCSignalStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusUpdate(proxyShared, payload);
                        proxyShared->_rVCSignalStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_regionsMapOutStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegionsMapOutStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RegionsMapOutStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegionsMapOutStatusInfoError> payload = ::boost::static_pointer_cast<RegionsMapOutStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RegionsMapOutStatusInfoCallbackIF*) _callback)->onRegionsMapOutStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegionsMapOutStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RegionsMapOutStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegionsMapOutStatusInfoUpdate> payload = ::boost::static_pointer_cast<RegionsMapOutStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RegionsMapOutStatusInfoCallbackIF*) _callback)->onRegionsMapOutStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_regionsMapOutStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_cabinsSourceRestorationInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsSourceRestorationInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsSourceRestorationInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsSourceRestorationInfoError> payload = ::boost::static_pointer_cast<CabinsSourceRestorationInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CabinsSourceRestorationInfoCallbackIF*) _callback)->onCabinsSourceRestorationInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsSourceRestorationInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsSourceRestorationInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsSourceRestorationInfoUpdate> payload = ::boost::static_pointer_cast<CabinsSourceRestorationInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CabinsSourceRestorationInfoCallbackIF*) _callback)->onCabinsSourceRestorationInfoUpdate(proxyShared, payload);
                        proxyShared->_cabinsSourceRestorationInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_cabinsSystemsInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsSystemsInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsSystemsInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsSystemsInfoError> payload = ::boost::static_pointer_cast<CabinsSystemsInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CabinsSystemsInfoCallbackIF*) _callback)->onCabinsSystemsInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsSystemsInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsSystemsInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsSystemsInfoUpdate> payload = ::boost::static_pointer_cast<CabinsSystemsInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CabinsSystemsInfoCallbackIF*) _callback)->onCabinsSystemsInfoUpdate(proxyShared, payload);
                        proxyShared->_cabinsSystemsInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LanguageStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LanguageStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LanguageStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LanguageStatusInfoError> payload = ::boost::static_pointer_cast<LanguageStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LanguageStatusInfoCallbackIF*) _callback)->onLanguageStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LanguageStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LanguageStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LanguageStatusInfoUpdate> payload = ::boost::static_pointer_cast<LanguageStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LanguageStatusInfoCallbackIF*) _callback)->onLanguageStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_languageStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_spiConnectionStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpiConnectionStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpiConnectionStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpiConnectionStatusInfoError> payload = ::boost::static_pointer_cast<SpiConnectionStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SpiConnectionStatusInfoCallbackIF*) _callback)->onSpiConnectionStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpiConnectionStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpiConnectionStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpiConnectionStatusInfoUpdate> payload = ::boost::static_pointer_cast<SpiConnectionStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SpiConnectionStatusInfoCallbackIF*) _callback)->onSpiConnectionStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_spiConnectionStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_cabinSourcesConnectionStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinSourcesConnectionStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinSourcesConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinSourcesConnectionStatusError> payload = ::boost::static_pointer_cast<CabinSourcesConnectionStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CabinSourcesConnectionStatusCallbackIF*) _callback)->onCabinSourcesConnectionStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinSourcesConnectionStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinSourcesConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinSourcesConnectionStatusUpdate> payload = ::boost::static_pointer_cast<CabinSourcesConnectionStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CabinSourcesConnectionStatusCallbackIF*) _callback)->onCabinSourcesConnectionStatusUpdate(proxyShared, payload);
                        proxyShared->_cabinSourcesConnectionStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_cabinsVideoMixInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsVideoMixInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsVideoMixInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsVideoMixInfoError> payload = ::boost::static_pointer_cast<CabinsVideoMixInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CabinsVideoMixInfoCallbackIF*) _callback)->onCabinsVideoMixInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CabinsVideoMixInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CabinsVideoMixInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CabinsVideoMixInfoUpdate> payload = ::boost::static_pointer_cast<CabinsVideoMixInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CabinsVideoMixInfoCallbackIF*) _callback)->onCabinsVideoMixInfoUpdate(proxyShared, payload);
                        proxyShared->_cabinsVideoMixInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_getRVCSignalStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetRVCSignalStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetRVCSignalStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetRVCSignalStatusError> payload = ::boost::static_pointer_cast<GetRVCSignalStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetRVCSignalStatusCallbackIF*) _callback)->onGetRVCSignalStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRVCSignalStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetRVCSignalStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetRVCSignalStatusResponse> payload = ::boost::static_pointer_cast<GetRVCSignalStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetRVCSignalStatusCallbackIF*) _callback)->onGetRVCSignalStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getCurrentForegroundApplicationId:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetCurrentForegroundApplicationIdError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCurrentForegroundApplicationIdError> payload = ::boost::static_pointer_cast<GetCurrentForegroundApplicationIdError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCurrentForegroundApplicationIdCallbackIF*) _callback)->onGetCurrentForegroundApplicationIdError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCurrentForegroundApplicationIdResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCurrentForegroundApplicationIdResponse> payload = ::boost::static_pointer_cast<GetCurrentForegroundApplicationIdResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCurrentForegroundApplicationIdCallbackIF*) _callback)->onGetCurrentForegroundApplicationIdResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_toggleGadgetAudioSource:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ToggleGadgetAudioSourceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ToggleGadgetAudioSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ToggleGadgetAudioSourceError> payload = ::boost::static_pointer_cast<ToggleGadgetAudioSourceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ToggleGadgetAudioSourceCallbackIF*) _callback)->onToggleGadgetAudioSourceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ToggleGadgetAudioSourceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ToggleGadgetAudioSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ToggleGadgetAudioSourceResponse> payload = ::boost::static_pointer_cast<ToggleGadgetAudioSourceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ToggleGadgetAudioSourceCallbackIF*) _callback)->onToggleGadgetAudioSourceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setCabinSourceConnectionStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinSourceConnectionStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCabinSourceConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCabinSourceConnectionStatusError> payload = ::boost::static_pointer_cast<SetCabinSourceConnectionStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCabinSourceConnectionStatusCallbackIF*) _callback)->onSetCabinSourceConnectionStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinSourceConnectionStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCabinSourceConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCabinSourceConnectionStatusResponse> payload = ::boost::static_pointer_cast<SetCabinSourceConnectionStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCabinSourceConnectionStatusCallbackIF*) _callback)->onSetCabinSourceConnectionStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_removeCabinSourceConnection:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveCabinSourceConnectionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveCabinSourceConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveCabinSourceConnectionError> payload = ::boost::static_pointer_cast<RemoveCabinSourceConnectionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveCabinSourceConnectionCallbackIF*) _callback)->onRemoveCabinSourceConnectionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveCabinSourceConnectionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveCabinSourceConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveCabinSourceConnectionResponse> payload = ::boost::static_pointer_cast<RemoveCabinSourceConnectionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveCabinSourceConnectionCallbackIF*) _callback)->onRemoveCabinSourceConnectionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setCabinVideoMixIndex:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinVideoMixIndexError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCabinVideoMixIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCabinVideoMixIndexError> payload = ::boost::static_pointer_cast<SetCabinVideoMixIndexError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCabinVideoMixIndexCallbackIF*) _callback)->onSetCabinVideoMixIndexError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCabinVideoMixIndexResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCabinVideoMixIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCabinVideoMixIndexResponse> payload = ::boost::static_pointer_cast<SetCabinVideoMixIndexResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCabinVideoMixIndexCallbackIF*) _callback)->onSetCabinVideoMixIndexResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_toggleGadgetAudioSourceRequest: {
                ::boost::shared_ptr< ToggleGadgetAudioSourceRequestError > payload = ::boost::shared_ptr< ToggleGadgetAudioSourceRequestError >
                (new ToggleGadgetAudioSourceRequestError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ToggleGadgetAudioSourceRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ToggleGadgetAudioSourceRequestCallbackIF*) _callback)->onToggleGadgetAudioSourceRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cabinsSourceDisconnectionTrigger: {
                ::boost::shared_ptr< CabinsSourceDisconnectionTriggerError > payload = ::boost::shared_ptr< CabinsSourceDisconnectionTriggerError >
                (new CabinsSourceDisconnectionTriggerError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CabinsSourceDisconnectionTrigger", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CabinsSourceDisconnectionTriggerCallbackIF*) _callback)->onCabinsSourceDisconnectionTriggerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_restoreAVSource: {
                ::boost::shared_ptr< RestoreAVSourceError > payload = ::boost::shared_ptr< RestoreAVSourceError >
                (new RestoreAVSourceError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestoreAVSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestoreAVSourceCallbackIF*) _callback)->onRestoreAVSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_currentForegroundApplicationId: {
                ::boost::shared_ptr< CurrentForegroundApplicationIdError > payload = ::boost::shared_ptr< CurrentForegroundApplicationIdError >
                (new CurrentForegroundApplicationIdError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentForegroundApplicationIdCallbackIF*) _callback)->onCurrentForegroundApplicationIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RVCSignalStatus: {
                ::boost::shared_ptr< RVCSignalStatusError > payload = ::boost::shared_ptr< RVCSignalStatusError >
                (new RVCSignalStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RVCSignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_regionsMapOutStatusInfo: {
                ::boost::shared_ptr< RegionsMapOutStatusInfoError > payload = ::boost::shared_ptr< RegionsMapOutStatusInfoError >
                (new RegionsMapOutStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegionsMapOutStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegionsMapOutStatusInfoCallbackIF*) _callback)->onRegionsMapOutStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cabinsSourceRestorationInfo: {
                ::boost::shared_ptr< CabinsSourceRestorationInfoError > payload = ::boost::shared_ptr< CabinsSourceRestorationInfoError >
                (new CabinsSourceRestorationInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CabinsSourceRestorationInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CabinsSourceRestorationInfoCallbackIF*) _callback)->onCabinsSourceRestorationInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cabinsSystemsInfo: {
                ::boost::shared_ptr< CabinsSystemsInfoError > payload = ::boost::shared_ptr< CabinsSystemsInfoError >
                (new CabinsSystemsInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CabinsSystemsInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CabinsSystemsInfoCallbackIF*) _callback)->onCabinsSystemsInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LanguageStatusInfo: {
                ::boost::shared_ptr< LanguageStatusInfoError > payload = ::boost::shared_ptr< LanguageStatusInfoError >
                (new LanguageStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LanguageStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LanguageStatusInfoCallbackIF*) _callback)->onLanguageStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_spiConnectionStatusInfo: {
                ::boost::shared_ptr< SpiConnectionStatusInfoError > payload = ::boost::shared_ptr< SpiConnectionStatusInfoError >
                (new SpiConnectionStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpiConnectionStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpiConnectionStatusInfoCallbackIF*) _callback)->onSpiConnectionStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cabinSourcesConnectionStatus: {
                ::boost::shared_ptr< CabinSourcesConnectionStatusError > payload = ::boost::shared_ptr< CabinSourcesConnectionStatusError >
                (new CabinSourcesConnectionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CabinSourcesConnectionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CabinSourcesConnectionStatusCallbackIF*) _callback)->onCabinSourcesConnectionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cabinsVideoMixInfo: {
                ::boost::shared_ptr< CabinsVideoMixInfoError > payload = ::boost::shared_ptr< CabinsVideoMixInfoError >
                (new CabinsVideoMixInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CabinsVideoMixInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CabinsVideoMixInfoCallbackIF*) _callback)->onCabinsVideoMixInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getRVCSignalStatus: {
                ::boost::shared_ptr< GetRVCSignalStatusError > payload = ::boost::shared_ptr< GetRVCSignalStatusError >
                (new GetRVCSignalStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetRVCSignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetRVCSignalStatusCallbackIF*) _callback)->onGetRVCSignalStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getCurrentForegroundApplicationId: {
                ::boost::shared_ptr< GetCurrentForegroundApplicationIdError > payload = ::boost::shared_ptr< GetCurrentForegroundApplicationIdError >
                (new GetCurrentForegroundApplicationIdError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetCurrentForegroundApplicationId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCurrentForegroundApplicationIdCallbackIF*) _callback)->onGetCurrentForegroundApplicationIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_toggleGadgetAudioSource: {
                ::boost::shared_ptr< ToggleGadgetAudioSourceError > payload = ::boost::shared_ptr< ToggleGadgetAudioSourceError >
                (new ToggleGadgetAudioSourceError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ToggleGadgetAudioSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ToggleGadgetAudioSourceCallbackIF*) _callback)->onToggleGadgetAudioSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setCabinSourceConnectionStatus: {
                ::boost::shared_ptr< SetCabinSourceConnectionStatusError > payload = ::boost::shared_ptr< SetCabinSourceConnectionStatusError >
                (new SetCabinSourceConnectionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetCabinSourceConnectionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCabinSourceConnectionStatusCallbackIF*) _callback)->onSetCabinSourceConnectionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_removeCabinSourceConnection: {
                ::boost::shared_ptr< RemoveCabinSourceConnectionError > payload = ::boost::shared_ptr< RemoveCabinSourceConnectionError >
                (new RemoveCabinSourceConnectionError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveCabinSourceConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveCabinSourceConnectionCallbackIF*) _callback)->onRemoveCabinSourceConnectionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setCabinVideoMixIndex: {
                ::boost::shared_ptr< SetCabinVideoMixIndexError > payload = ::boost::shared_ptr< SetCabinVideoMixIndexError >
                (new SetCabinVideoMixIndexError(DBUS_ERROR_NO_SERVER, "The DBus service HmiInfoService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetCabinVideoMixIndex", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiInfoServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiInfoServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCabinVideoMixIndexCallbackIF*) _callback)->onSetCabinVideoMixIndexError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HmiInfoServiceProxyCallback::_logger (HmiInfoServiceProxy::_logger);

HmiInfoServiceProxy::HmiInfoServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", serviceAvailable, _logger) {
}

HmiInfoServiceProxy::~HmiInfoServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HmiInfoServiceProxy > HmiInfoServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HmiInfoServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HmiInfoServiceProxy > proxyNew(new HmiInfoServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HmiInfoServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HmiInfoServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiInfoServiceProxy::clearAllProperties ()
{
    _currentForegroundApplicationId = ::asf::core::nullable< CurrentForegroundApplicationIdUpdate >();
    _rVCSignalStatus = ::asf::core::nullable< RVCSignalStatusUpdate >();
    _regionsMapOutStatusInfo = ::asf::core::nullable< RegionsMapOutStatusInfoUpdate >();
    _cabinsSourceRestorationInfo = ::asf::core::nullable< CabinsSourceRestorationInfoUpdate >();
    _cabinsSystemsInfo = ::asf::core::nullable< CabinsSystemsInfoUpdate >();
    _languageStatusInfo = ::asf::core::nullable< LanguageStatusInfoUpdate >();
    _spiConnectionStatusInfo = ::asf::core::nullable< SpiConnectionStatusInfoUpdate >();
    _cabinSourcesConnectionStatus = ::asf::core::nullable< CabinSourcesConnectionStatusUpdate >();
    _cabinsVideoMixInfo = ::asf::core::nullable< CabinsVideoMixInfoUpdate >();
}

void HmiInfoServiceProxy::sendDeregisterAll () const
{
    sendCurrentForegroundApplicationIdDeregisterAll();
    sendRVCSignalStatusDeregisterAll();
    sendRegionsMapOutStatusInfoDeregisterAll();
    sendCabinsSourceRestorationInfoDeregisterAll();
    sendCabinsSystemsInfoDeregisterAll();
    sendLanguageStatusInfoDeregisterAll();
    sendSpiConnectionStatusInfoDeregisterAll();
    sendCabinSourcesConnectionStatusDeregisterAll();
    sendCabinsVideoMixInfoDeregisterAll();
    sendToggleGadgetAudioSourceRequestDeregisterAll();
    sendCabinsSourceDisconnectionTriggerDeregisterAll();
    sendRestoreAVSourceDeregisterAll();
}

act_t HmiInfoServiceProxy::sendToggleGadgetAudioSourceRequestRegister(ToggleGadgetAudioSourceRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "toggleGadgetAudioSourceRequest");
    act_t act = addSignalCallback(ID_toggleGadgetAudioSourceRequest, "toggleGadgetAudioSourceRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ToggleGadgetAudioSourceRequest", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendToggleGadgetAudioSourceRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("toggleGadgetAudioSourceRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ToggleGadgetAudioSourceRequest", act, static_cast<int>(rv));
    return rv;
}

void HmiInfoServiceProxy::sendToggleGadgetAudioSourceRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ToggleGadgetAudioSourceRequest");
    _dbusProxyDelegate->deregisterSignalCallback("toggleGadgetAudioSourceRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiInfoServiceProxy::sendCabinsSourceDisconnectionTriggerRegister(CabinsSourceDisconnectionTriggerCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "cabinsSourceDisconnectionTrigger");
    act_t act = addSignalCallback(ID_cabinsSourceDisconnectionTrigger, "cabinsSourceDisconnectionTrigger", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CabinsSourceDisconnectionTrigger", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCabinsSourceDisconnectionTriggerDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cabinsSourceDisconnectionTrigger", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CabinsSourceDisconnectionTrigger", act, static_cast<int>(rv));
    return rv;
}

void HmiInfoServiceProxy::sendCabinsSourceDisconnectionTriggerDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CabinsSourceDisconnectionTrigger");
    _dbusProxyDelegate->deregisterSignalCallback("cabinsSourceDisconnectionTrigger", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiInfoServiceProxy::sendRestoreAVSourceRegister(RestoreAVSourceCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "restoreAVSource");
    act_t act = addSignalCallback(ID_restoreAVSource, "restoreAVSource", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RestoreAVSource", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendRestoreAVSourceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("restoreAVSource", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RestoreAVSource", act, static_cast<int>(rv));
    return rv;
}

void HmiInfoServiceProxy::sendRestoreAVSourceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RestoreAVSource");
    _dbusProxyDelegate->deregisterSignalCallback("restoreAVSource", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiInfoServiceProxy::sendCurrentForegroundApplicationIdRegister(CurrentForegroundApplicationIdCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_currentForegroundApplicationId, "currentForegroundApplicationId", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentForegroundApplicationId", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCurrentForegroundApplicationIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("currentForegroundApplicationId", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentForegroundApplicationId", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendCurrentForegroundApplicationIdGet(CurrentForegroundApplicationIdCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_currentForegroundApplicationId, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentForegroundApplicationId", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("currentForegroundApplicationId", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 HmiInfoServiceProxy::getCurrentForegroundApplicationId() const {
    return _currentForegroundApplicationId.get().getCurrentForegroundApplicationId();
}

bool HmiInfoServiceProxy::hasCurrentForegroundApplicationId() const {
    return _currentForegroundApplicationId.hasValue();
}

void HmiInfoServiceProxy::sendCurrentForegroundApplicationIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentForegroundApplicationId");
    _dbusProxyDelegate->deregisterSignalCallback("currentForegroundApplicationId", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendRVCSignalStatusRegister(RVCSignalStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RVCSignalStatus, "RVCSignalStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RVCSignalStatus", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendRVCSignalStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RVCSignalStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RVCSignalStatus", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendRVCSignalStatusGet(RVCSignalStatusCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_RVCSignalStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RVCSignalStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RVCSignalStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool HmiInfoServiceProxy::getRVCSignalStatus() const {
    return _rVCSignalStatus.get().getRVCSignalStatus();
}

bool HmiInfoServiceProxy::hasRVCSignalStatus() const {
    return _rVCSignalStatus.hasValue();
}

void HmiInfoServiceProxy::sendRVCSignalStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RVCSignalStatus");
    _dbusProxyDelegate->deregisterSignalCallback("RVCSignalStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendRegionsMapOutStatusInfoRegister(RegionsMapOutStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_regionsMapOutStatusInfo, "regionsMapOutStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RegionsMapOutStatusInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendRegionsMapOutStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("regionsMapOutStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RegionsMapOutStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendRegionsMapOutStatusInfoGet(RegionsMapOutStatusInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_regionsMapOutStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RegionsMapOutStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("regionsMapOutStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< RegionMapOutStatusInfo >& HmiInfoServiceProxy::getRegionsMapOutStatusInfo() const {
    return _regionsMapOutStatusInfo.get().getRegionsMapOutStatusInfo();
}

bool HmiInfoServiceProxy::hasRegionsMapOutStatusInfo() const {
    return _regionsMapOutStatusInfo.hasValue();
}

void HmiInfoServiceProxy::sendRegionsMapOutStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RegionsMapOutStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("regionsMapOutStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendCabinsSourceRestorationInfoRegister(CabinsSourceRestorationInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_cabinsSourceRestorationInfo, "cabinsSourceRestorationInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CabinsSourceRestorationInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCabinsSourceRestorationInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cabinsSourceRestorationInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CabinsSourceRestorationInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendCabinsSourceRestorationInfoGet(CabinsSourceRestorationInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_cabinsSourceRestorationInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CabinsSourceRestorationInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("cabinsSourceRestorationInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< CabinSourceRestorationInfo >& HmiInfoServiceProxy::getCabinsSourceRestorationInfo() const {
    return _cabinsSourceRestorationInfo.get().getCabinsSourceRestorationInfo();
}

bool HmiInfoServiceProxy::hasCabinsSourceRestorationInfo() const {
    return _cabinsSourceRestorationInfo.hasValue();
}

void HmiInfoServiceProxy::sendCabinsSourceRestorationInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CabinsSourceRestorationInfo");
    _dbusProxyDelegate->deregisterSignalCallback("cabinsSourceRestorationInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendCabinsSystemsInfoRegister(CabinsSystemsInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_cabinsSystemsInfo, "cabinsSystemsInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CabinsSystemsInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCabinsSystemsInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cabinsSystemsInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CabinsSystemsInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendCabinsSystemsInfoGet(CabinsSystemsInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_cabinsSystemsInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CabinsSystemsInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("cabinsSystemsInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< SystemInfo >& HmiInfoServiceProxy::getCabinsSystemsInfo() const {
    return _cabinsSystemsInfo.get().getCabinsSystemsInfo();
}

bool HmiInfoServiceProxy::hasCabinsSystemsInfo() const {
    return _cabinsSystemsInfo.hasValue();
}

void HmiInfoServiceProxy::sendCabinsSystemsInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CabinsSystemsInfo");
    _dbusProxyDelegate->deregisterSignalCallback("cabinsSystemsInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendLanguageStatusInfoRegister(LanguageStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LanguageStatusInfo, "LanguageStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LanguageStatusInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendLanguageStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LanguageStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LanguageStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendLanguageStatusInfoGet(LanguageStatusInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_LanguageStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LanguageStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LanguageStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 HmiInfoServiceProxy::getLanguageStatusInfo() const {
    return _languageStatusInfo.get().getLanguageStatusInfo();
}

bool HmiInfoServiceProxy::hasLanguageStatusInfo() const {
    return _languageStatusInfo.hasValue();
}

void HmiInfoServiceProxy::sendLanguageStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LanguageStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("LanguageStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendSpiConnectionStatusInfoRegister(SpiConnectionStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_spiConnectionStatusInfo, "spiConnectionStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpiConnectionStatusInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendSpiConnectionStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("spiConnectionStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpiConnectionStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendSpiConnectionStatusInfoGet(SpiConnectionStatusInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_spiConnectionStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SpiConnectionStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("spiConnectionStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiInfoServiceProxy::sendSpiConnectionStatusInfoSet(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo) {
    SpiConnectionStatusInfoSet parameter(spiConnectionStatusInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SpiConnectionStatusInfo");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "spiConnectionStatusInfo", propertyContent);
}

act_t HmiInfoServiceProxy::sendSpiConnectionStatusInfoSet(SpiConnectionStatusInfoCallbackIF& cb, const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_spiConnectionStatusInfo, &cb);
    SpiConnectionStatusInfoSet parameter(spiConnectionStatusInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SpiConnectionStatusInfo", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "spiConnectionStatusInfo", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const SPIConnectionStatusInfoHolder& HmiInfoServiceProxy::getSpiConnectionStatusInfo() const {
    return _spiConnectionStatusInfo.get().getSpiConnectionStatusInfo();
}

bool HmiInfoServiceProxy::hasSpiConnectionStatusInfo() const {
    return _spiConnectionStatusInfo.hasValue();
}

void HmiInfoServiceProxy::sendSpiConnectionStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpiConnectionStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("spiConnectionStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendCabinSourcesConnectionStatusRegister(CabinSourcesConnectionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_cabinSourcesConnectionStatus, "cabinSourcesConnectionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CabinSourcesConnectionStatus", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCabinSourcesConnectionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cabinSourcesConnectionStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CabinSourcesConnectionStatus", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendCabinSourcesConnectionStatusGet(CabinSourcesConnectionStatusCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_cabinSourcesConnectionStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CabinSourcesConnectionStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("cabinSourcesConnectionStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< CabinSourceConnectionStatusInfo >& HmiInfoServiceProxy::getCabinSourcesConnectionStatus() const {
    return _cabinSourcesConnectionStatus.get().getCabinSourcesConnectionStatus();
}

bool HmiInfoServiceProxy::hasCabinSourcesConnectionStatus() const {
    return _cabinSourcesConnectionStatus.hasValue();
}

void HmiInfoServiceProxy::sendCabinSourcesConnectionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CabinSourcesConnectionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("cabinSourcesConnectionStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendCabinsVideoMixInfoRegister(CabinsVideoMixInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_cabinsVideoMixInfo, "cabinsVideoMixInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CabinsVideoMixInfo", &cb, act);
    return act;
}

bool HmiInfoServiceProxy::sendCabinsVideoMixInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cabinsVideoMixInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CabinsVideoMixInfo", act, static_cast<int>(rv));
    return rv;
}

act_t HmiInfoServiceProxy::sendCabinsVideoMixInfoGet(CabinsVideoMixInfoCallbackIF& cb) {
    HmiInfoServiceProxyCallback* callback = new HmiInfoServiceProxyCallback(ID_cabinsVideoMixInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CabinsVideoMixInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("cabinsVideoMixInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< CabinVideoMixInfo >& HmiInfoServiceProxy::getCabinsVideoMixInfo() const {
    return _cabinsVideoMixInfo.get().getCabinsVideoMixInfo();
}

bool HmiInfoServiceProxy::hasCabinsVideoMixInfo() const {
    return _cabinsVideoMixInfo.hasValue();
}

void HmiInfoServiceProxy::sendCabinsVideoMixInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CabinsVideoMixInfo");
    _dbusProxyDelegate->deregisterSignalCallback("cabinsVideoMixInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiInfoServiceProxy::sendGetRVCSignalStatusRequest(GetRVCSignalStatusCallbackIF& cb) const {
    GetRVCSignalStatusRequest* payload = new GetRVCSignalStatusRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getRVCSignalStatus", GetRVCSignalStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_getRVCSignalStatus, dbusMessage.getUniqueSerial(), "getRVCSignalStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetRVCSignalStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiInfoServiceProxy::sendGetCurrentForegroundApplicationIdRequest(GetCurrentForegroundApplicationIdCallbackIF& cb) const {
    GetCurrentForegroundApplicationIdRequest* payload = new GetCurrentForegroundApplicationIdRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getCurrentForegroundApplicationId", GetCurrentForegroundApplicationIdRequest, payload, true)
    act_t act = addMethodCallback(ID_getCurrentForegroundApplicationId, dbusMessage.getUniqueSerial(), "getCurrentForegroundApplicationId", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetCurrentForegroundApplicationId", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiInfoServiceProxy::sendToggleGadgetAudioSourceRequest(ToggleGadgetAudioSourceCallbackIF& cb, uint32 regionId, uint8 srcApplicationId, uint8 destApplicationId) const {
    ToggleGadgetAudioSourceRequest* payload = new ToggleGadgetAudioSourceRequest();
    CHECK_ALLOCATION(payload);
    payload->setRegionId(regionId);
    payload->setSrcApplicationId(srcApplicationId);
    payload->setDestApplicationId(destApplicationId);
    DBUS_MESSAGE_CALL(dbusMessage, "toggleGadgetAudioSource", ToggleGadgetAudioSourceRequest, payload, true)
    act_t act = addMethodCallback(ID_toggleGadgetAudioSource, dbusMessage.getUniqueSerial(), "toggleGadgetAudioSource", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ToggleGadgetAudioSource", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiInfoServiceProxy::sendSetCabinSourceConnectionStatusRequest(SetCabinSourceConnectionStatusCallbackIF& cb, const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo) const {
    SetCabinSourceConnectionStatusRequest* payload = new SetCabinSourceConnectionStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setCabinSourcesConnectionStatusInfo(cabinSourcesConnectionStatusInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "setCabinSourceConnectionStatus", SetCabinSourceConnectionStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_setCabinSourceConnectionStatus, dbusMessage.getUniqueSerial(), "setCabinSourceConnectionStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetCabinSourceConnectionStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiInfoServiceProxy::sendRemoveCabinSourceConnectionRequest(RemoveCabinSourceConnectionCallbackIF& cb, const ::std::vector< uint32 >& sourcesIdInfo) const {
    RemoveCabinSourceConnectionRequest* payload = new RemoveCabinSourceConnectionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourcesIdInfo(sourcesIdInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "removeCabinSourceConnection", RemoveCabinSourceConnectionRequest, payload, true)
    act_t act = addMethodCallback(ID_removeCabinSourceConnection, dbusMessage.getUniqueSerial(), "removeCabinSourceConnection", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveCabinSourceConnection", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiInfoServiceProxy::sendSetCabinVideoMixIndexRequest(SetCabinVideoMixIndexCallbackIF& cb, const CabinVideoMixInfo& cabinVideoMixInfo) const {
    SetCabinVideoMixIndexRequest* payload = new SetCabinVideoMixIndexRequest();
    CHECK_ALLOCATION(payload);
    payload->setCabinVideoMixInfo(cabinVideoMixInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "setCabinVideoMixIndex", SetCabinVideoMixIndexRequest, payload, true)
    act_t act = addMethodCallback(ID_setCabinVideoMixIndex, dbusMessage.getUniqueSerial(), "setCabinVideoMixIndex", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetCabinVideoMixIndex", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace HmiInfoService
} // namespace hmiinfoservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
