/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of RegionMapOutStatusInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint32 o1 = in.getRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o1));
        DBusMessageIter o2ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o0Struct, DBUS_TYPE_ARRAY, "(ub)", &o2ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo >* o3 = &in.getMapOutStatusInfo();
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo >::const_iterator o4 = o3->end();
        for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo >::const_iterator o5 = o3->begin(); o5 != o4; ++o5) {
            serializeDBus((*o5), &o2ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o0Struct, &o2ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo& out) {
    {
        DBusMessageIter o6;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o6);
                {
                    uint32 regionIdValue;
                    uint32 &regionIdTmpValue = regionIdValue;
                    dbus_message_iter_get_basic(&o6, &regionIdTmpValue);
                    out.setRegionId(regionIdValue);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo > mapOutStatusInfoValue;

                    if (dbus_message_iter_get_arg_type(&o6) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o7ArrayIter;
                        dbus_message_iter_recurse (&o6, &o7ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o7ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo o8;
                                if (!deserializeDBus(&o7ArrayIter, o8)) {
                                    return false;
                                }
                                mapOutStatusInfoValue.push_back(o8);
                            } while (dbus_message_iter_next(&o7ArrayIter));
                        }
                    }
                    out.setMapOutStatusInfo(mapOutStatusInfoValue);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of MapOutStatusInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o9Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o9Struct));
        uint32 o10 = in.getGlassId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o9Struct, DBUS_TYPE_UINT32, &o10));
        dbus_bool_t o11 = in.getActiveStatus() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o9Struct, DBUS_TYPE_BOOLEAN, &o11));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o9Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::MapOutStatusInfo& out) {
    {
        DBusMessageIter o12;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o12);
                {
                    uint32 glassIdValue;
                    uint32 &glassIdTmpValue = glassIdValue;
                    dbus_message_iter_get_basic(&o12, &glassIdTmpValue);
                    out.setGlassId(glassIdValue);
                }

                if (dbus_message_iter_has_next(&o12)) {
                    dbus_message_iter_next(&o12);
                } else {
                    return true;
                }

                {
                    bool activeStatusValue;
                    bool &activeStatusTmpValue = activeStatusValue;
                    {
                        dbus_bool_t o13;
                        dbus_message_iter_get_basic(&o12, &o13);
                        activeStatusTmpValue = o13 ? true : false;
                    }
                    out.setActiveStatus(activeStatusValue);
                }

                if (dbus_message_iter_has_next(&o12)) {
                    dbus_message_iter_next(&o12);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CabinSourceDisconnectionTriggerInfoHolder

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        uint32 o15 = in.getCabinId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o15));
        uint32 o16 = in.getSpmHMIState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o16));
        uint32 o17 = in.getSubErrorType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o17));
        DBusMessageIter o18ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o14Struct, DBUS_TYPE_ARRAY, "(nnyuy)", &o18ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >* o19 = &in.getSourcesInfo();
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >::const_iterator o20 = o19->end();
        for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >::const_iterator o21 = o19->begin(); o21 != o20; ++o21) {
            serializeDBus((*o21), &o18ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o14Struct, &o18ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder& out) {
    {
        DBusMessageIter o22;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o22);
                {
                    uint32 cabinIdValue;
                    uint32 &cabinIdTmpValue = cabinIdValue;
                    dbus_message_iter_get_basic(&o22, &cabinIdTmpValue);
                    out.setCabinId(cabinIdValue);
                }

                if (dbus_message_iter_has_next(&o22)) {
                    dbus_message_iter_next(&o22);
                } else {
                    return true;
                }

                {
                    uint32 spmHMIStateValue;
                    uint32 &spmHMIStateTmpValue = spmHMIStateValue;
                    dbus_message_iter_get_basic(&o22, &spmHMIStateTmpValue);
                    out.setSpmHMIState(spmHMIStateValue);
                }

                if (dbus_message_iter_has_next(&o22)) {
                    dbus_message_iter_next(&o22);
                } else {
                    return true;
                }

                {
                    uint32 subErrorTypeValue;
                    uint32 &subErrorTypeTmpValue = subErrorTypeValue;
                    dbus_message_iter_get_basic(&o22, &subErrorTypeTmpValue);
                    out.setSubErrorType(subErrorTypeValue);
                }

                if (dbus_message_iter_has_next(&o22)) {
                    dbus_message_iter_next(&o22);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder > sourcesInfoValue;

                    if (dbus_message_iter_get_arg_type(&o22) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o23ArrayIter;
                        dbus_message_iter_recurse (&o22, &o23ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o23ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder o24;
                                if (!deserializeDBus(&o23ArrayIter, o24)) {
                                    return false;
                                }
                                sourcesInfoValue.push_back(o24);
                            } while (dbus_message_iter_next(&o23ArrayIter));
                        }
                    }
                    out.setSourcesInfo(sourcesInfoValue);
                }

                if (dbus_message_iter_has_next(&o22)) {
                    dbus_message_iter_next(&o22);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SourceInfoHolder

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder& in, DBusMessageIter* out) {
    {
        DBusMessageIter o25Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o25Struct));
        int16 o26 = in.getSourceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_INT16, &o26));
        int16 o27 = in.getSinkId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_INT16, &o27));
        uint8 o28 = in.getSourceState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_BYTE, &o28));
        uint32 o29 = in.getSubSourceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_UINT32, &o29));
        uint8 o30 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_BYTE, &o30));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o25Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder& out) {
    {
        DBusMessageIter o31;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o31);
                {
                    int16 sourceIdValue;
                    int16 &sourceIdTmpValue = sourceIdValue;
                    dbus_message_iter_get_basic(&o31, &sourceIdTmpValue);
                    out.setSourceId(sourceIdValue);
                }

                if (dbus_message_iter_has_next(&o31)) {
                    dbus_message_iter_next(&o31);
                } else {
                    return true;
                }

                {
                    int16 sinkIdValue;
                    int16 &sinkIdTmpValue = sinkIdValue;
                    dbus_message_iter_get_basic(&o31, &sinkIdTmpValue);
                    out.setSinkId(sinkIdValue);
                }

                if (dbus_message_iter_has_next(&o31)) {
                    dbus_message_iter_next(&o31);
                } else {
                    return true;
                }

                {
                    uint8 sourceStateValue;
                    uint8 &sourceStateTmpValue = sourceStateValue;
                    dbus_message_iter_get_basic(&o31, &sourceStateTmpValue);
                    out.setSourceState(sourceStateValue);
                }

                if (dbus_message_iter_has_next(&o31)) {
                    dbus_message_iter_next(&o31);
                } else {
                    return true;
                }

                {
                    uint32 subSourceIdValue;
                    uint32 &subSourceIdTmpValue = subSourceIdValue;
                    dbus_message_iter_get_basic(&o31, &subSourceIdTmpValue);
                    out.setSubSourceId(subSourceIdValue);
                }

                if (dbus_message_iter_has_next(&o31)) {
                    dbus_message_iter_next(&o31);
                } else {
                    return true;
                }

                {
                    uint8 statusValue;
                    uint8 &statusTmpValue = statusValue;
                    dbus_message_iter_get_basic(&o31, &statusTmpValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o31)) {
                    dbus_message_iter_next(&o31);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CabinSourceRestorationInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o32Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o32Struct));
        uint32 o33 = in.getCabinId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o32Struct, DBUS_TYPE_UINT32, &o33));
        uint8 o34 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o32Struct, DBUS_TYPE_BYTE, &o34));
        DBusMessageIter o35ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o32Struct, DBUS_TYPE_ARRAY, "(nnyuy)", &o35ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >* o36 = &in.getLastActiveSourcesInfo();
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >::const_iterator o37 = o36->end();
        for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder >::const_iterator o38 = o36->begin(); o38 != o37; ++o38) {
            serializeDBus((*o38), &o35ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o32Struct, &o35ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o32Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo& out) {
    {
        DBusMessageIter o39;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o39);
                {
                    uint32 cabinIdValue;
                    uint32 &cabinIdTmpValue = cabinIdValue;
                    dbus_message_iter_get_basic(&o39, &cabinIdTmpValue);
                    out.setCabinId(cabinIdValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    uint8 statusValue;
                    uint8 &statusTmpValue = statusValue;
                    dbus_message_iter_get_basic(&o39, &statusTmpValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder > lastActiveSourcesInfoValue;

                    if (dbus_message_iter_get_arg_type(&o39) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o40ArrayIter;
                        dbus_message_iter_recurse (&o39, &o40ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o40ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SourceInfoHolder o41;
                                if (!deserializeDBus(&o40ArrayIter, o41)) {
                                    return false;
                                }
                                lastActiveSourcesInfoValue.push_back(o41);
                            } while (dbus_message_iter_next(&o40ArrayIter));
                        }
                    }
                    out.setLastActiveSourcesInfo(lastActiveSourcesInfoValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SystemInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o42Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o42Struct));
        DBusMessageIter o43ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o42Struct, DBUS_TYPE_ARRAY, "u", &o43ArrayIter));
        const ::std::vector< uint32 >* o44 = &in.getCabinsInfo();
        ::std::vector< uint32 >::const_iterator o45 = o44->end();
        for (::std::vector< uint32 >::const_iterator o46 = o44->begin(); o46 != o45; ++o46) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o43ArrayIter, DBUS_TYPE_UINT32, &(*o46)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o42Struct, &o43ArrayIter));
        uint64 o47 = in.getEntityId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_UINT64, &o47));
        uint8 o48 = in.getSystemId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o48));
        uint8 o49 = in.getSystemPosition();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o49));
        uint8 o50 = in.getSystemGroup();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o50));
        uint8 o51 = in.getSystemStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o51));
        uint8 o52 = in.getAvdeccStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o52));
        uint8 o53 = in.getNanoMsgStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o53));
        uint8 o54 = in.getSystemCategory();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_BYTE, &o54));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o42Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo& out) {
    {
        DBusMessageIter o55;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o55);
                {
                    ::std::vector< uint32 > cabinsInfoValue;

                    if (dbus_message_iter_get_arg_type(&o55) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o56ArrayIter;
                        dbus_message_iter_recurse (&o55, &o56ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o56ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint32 o57;
                                dbus_message_iter_get_basic(&o56ArrayIter, &o57);
                                cabinsInfoValue.push_back(o57);
                            } while (dbus_message_iter_next(&o56ArrayIter));
                        }
                    }
                    out.setCabinsInfo(cabinsInfoValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint64 entityIdValue;
                    uint64 &entityIdTmpValue = entityIdValue;
                    dbus_message_iter_get_basic(&o55, &entityIdTmpValue);
                    out.setEntityId(entityIdValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 systemIdValue;
                    uint8 &systemIdTmpValue = systemIdValue;
                    dbus_message_iter_get_basic(&o55, &systemIdTmpValue);
                    out.setSystemId(systemIdValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 systemPositionValue;
                    uint8 &systemPositionTmpValue = systemPositionValue;
                    dbus_message_iter_get_basic(&o55, &systemPositionTmpValue);
                    out.setSystemPosition(systemPositionValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 systemGroupValue;
                    uint8 &systemGroupTmpValue = systemGroupValue;
                    dbus_message_iter_get_basic(&o55, &systemGroupTmpValue);
                    out.setSystemGroup(systemGroupValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 systemStatusValue;
                    uint8 &systemStatusTmpValue = systemStatusValue;
                    dbus_message_iter_get_basic(&o55, &systemStatusTmpValue);
                    out.setSystemStatus(systemStatusValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 avdeccStatusValue;
                    uint8 &avdeccStatusTmpValue = avdeccStatusValue;
                    dbus_message_iter_get_basic(&o55, &avdeccStatusTmpValue);
                    out.setAvdeccStatus(avdeccStatusValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 nanoMsgStatusValue;
                    uint8 &nanoMsgStatusTmpValue = nanoMsgStatusValue;
                    dbus_message_iter_get_basic(&o55, &nanoMsgStatusTmpValue);
                    out.setNanoMsgStatus(nanoMsgStatusValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

                {
                    uint8 systemCategoryValue;
                    uint8 &systemCategoryTmpValue = systemCategoryValue;
                    dbus_message_iter_get_basic(&o55, &systemCategoryTmpValue);
                    out.setSystemCategory(systemCategoryValue);
                }

                if (dbus_message_iter_has_next(&o55)) {
                    dbus_message_iter_next(&o55);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SPIConnectionStatusInfoHolder

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SPIConnectionStatusInfoHolder& in, DBusMessageIter* out) {
    {
        DBusMessageIter o58Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o58Struct));
        uint8 o59 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o58Struct, DBUS_TYPE_BYTE, &o59));
        uint8 o60 = in.getDeviceType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o58Struct, DBUS_TYPE_BYTE, &o60));
        const char* o61 = in.getDeviceName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o58Struct, DBUS_TYPE_STRING, &o61));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o58Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SPIConnectionStatusInfoHolder& out) {
    {
        DBusMessageIter o62;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o62);
                {
                    uint8 statusValue;
                    uint8 &statusTmpValue = statusValue;
                    dbus_message_iter_get_basic(&o62, &statusTmpValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o62)) {
                    dbus_message_iter_next(&o62);
                } else {
                    return true;
                }

                {
                    uint8 deviceTypeValue;
                    uint8 &deviceTypeTmpValue = deviceTypeValue;
                    dbus_message_iter_get_basic(&o62, &deviceTypeTmpValue);
                    out.setDeviceType(deviceTypeValue);
                }

                if (dbus_message_iter_has_next(&o62)) {
                    dbus_message_iter_next(&o62);
                } else {
                    return true;
                }

                {
                    ::std::string deviceNameValue;
                    ::std::string &deviceNameTmpValue = deviceNameValue;
                    {
                        char* o63 = 0;
                        dbus_message_iter_get_basic(&o62, &o63);
                        deviceNameTmpValue.assign (o63);
                    }
                    out.setDeviceName(deviceNameValue);
                }

                if (dbus_message_iter_has_next(&o62)) {
                    dbus_message_iter_next(&o62);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CabinSourceConnectionStatusInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o64Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o64Struct));
        int16 o65 = in.getSourceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_INT16, &o65));
        dbus_bool_t o66 = in.getStatus() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_BOOLEAN, &o66));
        const char* o67 = in.getUserData1().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_STRING, &o67));
        uint32 o68 = in.getUserData2();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_UINT32, &o68));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o64Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo& out) {
    {
        DBusMessageIter o69;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o69);
                {
                    int16 sourceIdValue;
                    int16 &sourceIdTmpValue = sourceIdValue;
                    dbus_message_iter_get_basic(&o69, &sourceIdTmpValue);
                    out.setSourceId(sourceIdValue);
                }

                if (dbus_message_iter_has_next(&o69)) {
                    dbus_message_iter_next(&o69);
                } else {
                    return true;
                }

                {
                    bool statusValue;
                    bool &statusTmpValue = statusValue;
                    {
                        dbus_bool_t o70;
                        dbus_message_iter_get_basic(&o69, &o70);
                        statusTmpValue = o70 ? true : false;
                    }
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o69)) {
                    dbus_message_iter_next(&o69);
                } else {
                    return true;
                }

                {
                    ::std::string userData1Value;
                    ::std::string &userData1TmpValue = userData1Value;
                    {
                        char* o71 = 0;
                        dbus_message_iter_get_basic(&o69, &o71);
                        userData1TmpValue.assign (o71);
                    }
                    out.setUserData1(userData1Value);
                }

                if (dbus_message_iter_has_next(&o69)) {
                    dbus_message_iter_next(&o69);
                } else {
                    return true;
                }

                {
                    uint32 userData2Value;
                    uint32 &userData2TmpValue = userData2Value;
                    dbus_message_iter_get_basic(&o69, &userData2TmpValue);
                    out.setUserData2(userData2Value);
                }

                if (dbus_message_iter_has_next(&o69)) {
                    dbus_message_iter_next(&o69);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CabinVideoMixInfo

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o72Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o72Struct));
        uint32 o73 = in.getCabinId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o72Struct, DBUS_TYPE_UINT32, &o73));
        uint8 o74 = in.getReason();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o72Struct, DBUS_TYPE_BYTE, &o74));
        uint8 o75 = in.getVideoMixIndex();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o72Struct, DBUS_TYPE_BYTE, &o75));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o72Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo& out) {
    {
        DBusMessageIter o76;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o76);
                {
                    uint32 cabinIdValue;
                    uint32 &cabinIdTmpValue = cabinIdValue;
                    dbus_message_iter_get_basic(&o76, &cabinIdTmpValue);
                    out.setCabinId(cabinIdValue);
                }

                if (dbus_message_iter_has_next(&o76)) {
                    dbus_message_iter_next(&o76);
                } else {
                    return true;
                }

                {
                    uint8 reasonValue;
                    uint8 &reasonTmpValue = reasonValue;
                    dbus_message_iter_get_basic(&o76, &reasonTmpValue);
                    out.setReason(reasonValue);
                }

                if (dbus_message_iter_has_next(&o76)) {
                    dbus_message_iter_next(&o76);
                } else {
                    return true;
                }

                {
                    uint8 videoMixIndexValue;
                    uint8 &videoMixIndexTmpValue = videoMixIndexValue;
                    dbus_message_iter_get_basic(&o76, &videoMixIndexTmpValue);
                    out.setVideoMixIndex(videoMixIndexValue);
                }

                if (dbus_message_iter_has_next(&o76)) {
                    dbus_message_iter_next(&o76);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GetRVCSignalStatusResponse

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::GetRVCSignalStatusResponse& in, DBusMessageIter* out) {
    dbus_bool_t o77 = in.getRVCSignalStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o77));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::GetRVCSignalStatusResponse& out) {
    {
        bool RVCSignalStatusValue;
        bool &RVCSignalStatusTmpValue = RVCSignalStatusValue;
        {
            dbus_bool_t o78;
            dbus_message_iter_get_basic(in, &o78);
            RVCSignalStatusTmpValue = o78 ? true : false;
        }
        out.setRVCSignalStatus(RVCSignalStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetCurrentForegroundApplicationIdResponse

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::GetCurrentForegroundApplicationIdResponse& in, DBusMessageIter* out) {
    const char* o79 = in.getCurrentForegroundApplicationId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o79));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::GetCurrentForegroundApplicationIdResponse& out) {
    {
        ::std::string currentForegroundApplicationIdValue;
        ::std::string &currentForegroundApplicationIdTmpValue = currentForegroundApplicationIdValue;
        {
            char* o80 = 0;
            dbus_message_iter_get_basic(in, &o80);
            currentForegroundApplicationIdTmpValue.assign (o80);
        }
        out.setCurrentForegroundApplicationId(currentForegroundApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ToggleGadgetAudioSourceRequest

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::ToggleGadgetAudioSourceRequest& in, DBusMessageIter* out) {
    uint32 o81 = in.getRegionId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o81));
    uint8 o82 = in.getSrcApplicationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o82));
    uint8 o83 = in.getDestApplicationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o83));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::ToggleGadgetAudioSourceRequest& out) {
    {
        uint32 regionIdValue;
        uint32 &regionIdTmpValue = regionIdValue;
        dbus_message_iter_get_basic(in, &regionIdTmpValue);
        out.setRegionId(regionIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 srcApplicationIdValue;
        uint8 &srcApplicationIdTmpValue = srcApplicationIdValue;
        dbus_message_iter_get_basic(in, &srcApplicationIdTmpValue);
        out.setSrcApplicationId(srcApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 destApplicationIdValue;
        uint8 &destApplicationIdTmpValue = destApplicationIdValue;
        dbus_message_iter_get_basic(in, &destApplicationIdTmpValue);
        out.setDestApplicationId(destApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetCabinSourceConnectionStatusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SetCabinSourceConnectionStatusRequest& in, DBusMessageIter* out) {
    DBusMessageIter o84ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nbsu)", &o84ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >* o85 = &in.getCabinSourcesConnectionStatusInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >::const_iterator o86 = o85->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >::const_iterator o87 = o85->begin(); o87 != o86; ++o87) {
        serializeDBus((*o87), &o84ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o84ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SetCabinSourceConnectionStatusRequest& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo > cabinSourcesConnectionStatusInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o88ArrayIter;
            dbus_message_iter_recurse (in, &o88ArrayIter);

            if(dbus_message_iter_get_arg_type(&o88ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo o89;
                    if (!deserializeDBus(&o88ArrayIter, o89)) {
                        return false;
                    }
                    cabinSourcesConnectionStatusInfoValue.push_back(o89);
                } while (dbus_message_iter_next(&o88ArrayIter));
            }
        }
        out.setCabinSourcesConnectionStatusInfo(cabinSourcesConnectionStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemoveCabinSourceConnectionRequest

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RemoveCabinSourceConnectionRequest& in, DBusMessageIter* out) {
    DBusMessageIter o90ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o90ArrayIter));
    const ::std::vector< uint32 >* o91 = &in.getSourcesIdInfo();
    ::std::vector< uint32 >::const_iterator o92 = o91->end();
    for (::std::vector< uint32 >::const_iterator o93 = o91->begin(); o93 != o92; ++o93) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o90ArrayIter, DBUS_TYPE_UINT32, &(*o93)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o90ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RemoveCabinSourceConnectionRequest& out) {
    {
        ::std::vector< uint32 > sourcesIdInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o94ArrayIter;
            dbus_message_iter_recurse (in, &o94ArrayIter);

            if(dbus_message_iter_get_arg_type(&o94ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o95;
                    dbus_message_iter_get_basic(&o94ArrayIter, &o95);
                    sourcesIdInfoValue.push_back(o95);
                } while (dbus_message_iter_next(&o94ArrayIter));
            }
        }
        out.setSourcesIdInfo(sourcesIdInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetCabinVideoMixIndexRequest

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SetCabinVideoMixIndexRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getCabinVideoMixInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SetCabinVideoMixIndexRequest& out) {
    {
        ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo cabinVideoMixInfoValue;
        if (!deserializeDBus(in, cabinVideoMixInfoValue)) {
            return false;
        }
        out.setCabinVideoMixInfo(cabinVideoMixInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentForegroundApplicationIdUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdUpdate& in, DBusMessageIter* out) {
    uint8 o96 = in.getCurrentForegroundApplicationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o96));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdUpdate& out) {
    {
        uint8 currentForegroundApplicationIdValue;
        uint8 &currentForegroundApplicationIdTmpValue = currentForegroundApplicationIdValue;
        dbus_message_iter_get_basic(in, &currentForegroundApplicationIdTmpValue);
        out.setCurrentForegroundApplicationId(currentForegroundApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentForegroundApplicationIdRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RVCSignalStatusUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o97 = in.getRVCSignalStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o97));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusUpdate& out) {
    {
        bool RVCSignalStatusValue;
        bool &RVCSignalStatusTmpValue = RVCSignalStatusValue;
        {
            dbus_bool_t o98;
            dbus_message_iter_get_basic(in, &o98);
            RVCSignalStatusTmpValue = o98 ? true : false;
        }
        out.setRVCSignalStatus(RVCSignalStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RVCSignalStatusRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RegionsMapOutStatusInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionsMapOutStatusInfoUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o99ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ua(ub))", &o99ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo >* o100 = &in.getRegionsMapOutStatusInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo >::const_iterator o101 = o100->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo >::const_iterator o102 = o100->begin(); o102 != o101; ++o102) {
        serializeDBus((*o102), &o99ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o99ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionsMapOutStatusInfoUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo > regionsMapOutStatusInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o103ArrayIter;
            dbus_message_iter_recurse (in, &o103ArrayIter);

            if(dbus_message_iter_get_arg_type(&o103ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionMapOutStatusInfo o104;
                    if (!deserializeDBus(&o103ArrayIter, o104)) {
                        return false;
                    }
                    regionsMapOutStatusInfoValue.push_back(o104);
                } while (dbus_message_iter_next(&o103ArrayIter));
            }
        }
        out.setRegionsMapOutStatusInfo(regionsMapOutStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegionsMapOutStatusInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionsMapOutStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RegionsMapOutStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CabinsSourceRestorationInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceRestorationInfoUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o105ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uya(nnyuy))", &o105ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo >* o106 = &in.getCabinsSourceRestorationInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo >::const_iterator o107 = o106->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo >::const_iterator o108 = o106->begin(); o108 != o107; ++o108) {
        serializeDBus((*o108), &o105ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o105ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceRestorationInfoUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo > cabinsSourceRestorationInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o109ArrayIter;
            dbus_message_iter_recurse (in, &o109ArrayIter);

            if(dbus_message_iter_get_arg_type(&o109ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceRestorationInfo o110;
                    if (!deserializeDBus(&o109ArrayIter, o110)) {
                        return false;
                    }
                    cabinsSourceRestorationInfoValue.push_back(o110);
                } while (dbus_message_iter_next(&o109ArrayIter));
            }
        }
        out.setCabinsSourceRestorationInfo(cabinsSourceRestorationInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CabinsSourceRestorationInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceRestorationInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceRestorationInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CabinsSystemsInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSystemsInfoUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o111ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(autyyyyyyy)", &o111ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo >* o112 = &in.getCabinsSystemsInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo >::const_iterator o113 = o112->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo >::const_iterator o114 = o112->begin(); o114 != o113; ++o114) {
        serializeDBus((*o114), &o111ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o111ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSystemsInfoUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo > cabinsSystemsInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o115ArrayIter;
            dbus_message_iter_recurse (in, &o115ArrayIter);

            if(dbus_message_iter_get_arg_type(&o115ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SystemInfo o116;
                    if (!deserializeDBus(&o115ArrayIter, o116)) {
                        return false;
                    }
                    cabinsSystemsInfoValue.push_back(o116);
                } while (dbus_message_iter_next(&o115ArrayIter));
            }
        }
        out.setCabinsSystemsInfo(cabinsSystemsInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CabinsSystemsInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSystemsInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSystemsInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LanguageStatusInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::LanguageStatusInfoUpdate& in, DBusMessageIter* out) {
    uint32 o117 = in.getLanguageStatusInfo();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o117));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::LanguageStatusInfoUpdate& out) {
    {
        uint32 LanguageStatusInfoValue;
        uint32 &LanguageStatusInfoTmpValue = LanguageStatusInfoValue;
        dbus_message_iter_get_basic(in, &LanguageStatusInfoTmpValue);
        out.setLanguageStatusInfo(LanguageStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LanguageStatusInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::LanguageStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::LanguageStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SpiConnectionStatusInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SpiConnectionStatusInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSpiConnectionStatusInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SpiConnectionStatusInfoUpdate& out) {
    {
        ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SPIConnectionStatusInfoHolder spiConnectionStatusInfoValue;
        if (!deserializeDBus(in, spiConnectionStatusInfoValue)) {
            return false;
        }
        out.setSpiConnectionStatusInfo(spiConnectionStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SpiConnectionStatusInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SpiConnectionStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::SpiConnectionStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CabinSourcesConnectionStatusUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourcesConnectionStatusUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o118ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nbsu)", &o118ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >* o119 = &in.getCabinSourcesConnectionStatus();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >::const_iterator o120 = o119->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo >::const_iterator o121 = o119->begin(); o121 != o120; ++o121) {
        serializeDBus((*o121), &o118ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o118ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourcesConnectionStatusUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo > cabinSourcesConnectionStatusValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o122ArrayIter;
            dbus_message_iter_recurse (in, &o122ArrayIter);

            if(dbus_message_iter_get_arg_type(&o122ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceConnectionStatusInfo o123;
                    if (!deserializeDBus(&o122ArrayIter, o123)) {
                        return false;
                    }
                    cabinSourcesConnectionStatusValue.push_back(o123);
                } while (dbus_message_iter_next(&o122ArrayIter));
            }
        }
        out.setCabinSourcesConnectionStatus(cabinSourcesConnectionStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CabinSourcesConnectionStatusRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourcesConnectionStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourcesConnectionStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CabinsVideoMixInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsVideoMixInfoUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o124ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uyy)", &o124ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo >* o125 = &in.getCabinsVideoMixInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo >::const_iterator o126 = o125->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo >::const_iterator o127 = o125->begin(); o127 != o126; ++o127) {
        serializeDBus((*o127), &o124ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o124ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsVideoMixInfoUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo > cabinsVideoMixInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o128ArrayIter;
            dbus_message_iter_recurse (in, &o128ArrayIter);

            if(dbus_message_iter_get_arg_type(&o128ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinVideoMixInfo o129;
                    if (!deserializeDBus(&o128ArrayIter, o129)) {
                        return false;
                    }
                    cabinsVideoMixInfoValue.push_back(o129);
                } while (dbus_message_iter_next(&o128ArrayIter));
            }
        }
        out.setCabinsVideoMixInfo(cabinsVideoMixInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CabinsVideoMixInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsVideoMixInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsVideoMixInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ToggleGadgetAudioSourceRequestSignal

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::ToggleGadgetAudioSourceRequestSignal& in, DBusMessageIter* out) {
    uint32 o130 = in.getRegionId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o130));
    uint8 o131 = in.getSrcApplicationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o131));
    uint8 o132 = in.getDestApplicationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o132));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::ToggleGadgetAudioSourceRequestSignal& out) {
    {
        uint32 regionIdValue;
        uint32 &regionIdTmpValue = regionIdValue;
        dbus_message_iter_get_basic(in, &regionIdTmpValue);
        out.setRegionId(regionIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 srcApplicationIdValue;
        uint8 &srcApplicationIdTmpValue = srcApplicationIdValue;
        dbus_message_iter_get_basic(in, &srcApplicationIdTmpValue);
        out.setSrcApplicationId(srcApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 destApplicationIdValue;
        uint8 &destApplicationIdTmpValue = destApplicationIdValue;
        dbus_message_iter_get_basic(in, &destApplicationIdTmpValue);
        out.setDestApplicationId(destApplicationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CabinsSourceDisconnectionTriggerSignal

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceDisconnectionTriggerSignal& in, DBusMessageIter* out) {
    DBusMessageIter o133ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uuua(nnyuy))", &o133ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder >* o134 = &in.getCabinsSourceDisconnectionTriggerInfo();
    ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder >::const_iterator o135 = o134->end();
    for (::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder >::const_iterator o136 = o134->begin(); o136 != o135; ++o136) {
        serializeDBus((*o136), &o133ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o133ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinsSourceDisconnectionTriggerSignal& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder > cabinsSourceDisconnectionTriggerInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o137ArrayIter;
            dbus_message_iter_recurse (in, &o137ArrayIter);

            if(dbus_message_iter_get_arg_type(&o137ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CabinSourceDisconnectionTriggerInfoHolder o138;
                    if (!deserializeDBus(&o137ArrayIter, o138)) {
                        return false;
                    }
                    cabinsSourceDisconnectionTriggerInfoValue.push_back(o138);
                } while (dbus_message_iter_next(&o137ArrayIter));
            }
        }
        out.setCabinsSourceDisconnectionTriggerInfo(cabinsSourceDisconnectionTriggerInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestoreAVSourceSignal

void serializeDBus (const ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RestoreAVSourceSignal& in, DBusMessageIter* out) {
    uint32 o139 = in.getCabinId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o139));
    int16 o140 = in.getSourceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o140));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RestoreAVSourceSignal& out) {
    {
        uint32 cabinIdValue;
        uint32 &cabinIdTmpValue = cabinIdValue;
        dbus_message_iter_get_basic(in, &cabinIdTmpValue);
        out.setCabinId(cabinIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 sourceIdValue;
        int16 &sourceIdTmpValue = sourceIdValue;
        dbus_message_iter_get_basic(in, &sourceIdTmpValue);
        out.setSourceId(sourceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

