#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICE_H
#define BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * todo
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {

// method IDs
static const uint16 ID_getRVCSignalStatus = 0;
static const uint16 ID_getCurrentForegroundApplicationId = 1;
static const uint16 ID_toggleGadgetAudioSource = 2;
static const uint16 ID_setCabinSourceConnectionStatus = 3;
static const uint16 ID_removeCabinSourceConnection = 4;
static const uint16 ID_setCabinVideoMixIndex = 5;

// signal IDs
static const uint16 ID_toggleGadgetAudioSourceRequest = 6;
static const uint16 ID_cabinsSourceDisconnectionTrigger = 7;
static const uint16 ID_restoreAVSource = 8;

// property IDs
static const uint16 ID_currentForegroundApplicationId = 9;
static const uint16 ID_RVCSignalStatus = 10;
static const uint16 ID_regionsMapOutStatusInfo = 11;
static const uint16 ID_cabinsSourceRestorationInfo = 12;
static const uint16 ID_cabinsSystemsInfo = 13;
static const uint16 ID_LanguageStatusInfo = 14;
static const uint16 ID_spiConnectionStatusInfo = 15;
static const uint16 ID_cabinSourcesConnectionStatus = 16;
static const uint16 ID_cabinsVideoMixInfo = 17;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class MapOutStatusInfo;

class RegionMapOutStatusInfo;

class SourceInfoHolder;

class CabinSourceDisconnectionTriggerInfoHolder;

class CabinSourceRestorationInfo;

class SystemInfo;

class SPIConnectionStatusInfoHolder;

class CabinSourceConnectionStatusInfo;

class CabinVideoMixInfo;

class GetRVCSignalStatusResponse;

class GetCurrentForegroundApplicationIdResponse;

class ToggleGadgetAudioSourceRequest;

class SetCabinSourceConnectionStatusRequest;

class RemoveCabinSourceConnectionRequest;

class SetCabinVideoMixIndexRequest;

class CurrentForegroundApplicationIdUpdate;

class CurrentForegroundApplicationIdRegister;

class RVCSignalStatusUpdate;

class RVCSignalStatusRegister;

class RegionsMapOutStatusInfoUpdate;

class RegionsMapOutStatusInfoRegister;

class CabinsSourceRestorationInfoUpdate;

class CabinsSourceRestorationInfoRegister;

class CabinsSystemsInfoUpdate;

class CabinsSystemsInfoRegister;

class LanguageStatusInfoUpdate;

class LanguageStatusInfoRegister;

class SpiConnectionStatusInfoUpdate;

class SpiConnectionStatusInfoRegister;

class CabinSourcesConnectionStatusUpdate;

class CabinSourcesConnectionStatusRegister;

class CabinsVideoMixInfoUpdate;

class CabinsVideoMixInfoRegister;

class ToggleGadgetAudioSourceRequestSignal;

class CabinsSourceDisconnectionTriggerSignal;

class RestoreAVSourceSignal;

// type definitions
/**
 * Method to give RVC Signal status
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetRVCSignalStatusRequest;

/**
 * If the meaning of "GetRVCSignalStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetRVCSignalStatusError;

/**
 * Method to give active screen/popup name
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetCurrentForegroundApplicationIdRequest;

/**
 * If the meaning of "GetCurrentForegroundApplicationIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetCurrentForegroundApplicationIdError;

/**
 * Method to update the trigger of gadget audio source toggle
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ToggleGadgetAudioSourceResponse;

/**
 * If the meaning of "ToggleGadgetAudioSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ToggleGadgetAudioSourceError;

/**
 * Method to update the cabin source connection status
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetCabinSourceConnectionStatusResponse;

/**
 * If the meaning of "SetCabinSourceConnectionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetCabinSourceConnectionStatusError;

/**
 * Method to remove source from cabin source connection array
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveCabinSourceConnectionResponse;

/**
 * If the meaning of "RemoveCabinSourceConnectionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveCabinSourceConnectionError;

/**
 * Method to update the cabin video mix info
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetCabinVideoMixIndexResponse;

/**
 * If the meaning of "SetCabinVideoMixIndexError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetCabinVideoMixIndexError;

/**
 * Property to state the currentVisibleScene
 */
typedef CurrentForegroundApplicationIdUpdate CurrentForegroundApplicationIdSet;

/**
 * Property to state the currentVisibleScene
 */
typedef CurrentForegroundApplicationIdUpdate CurrentForegroundApplicationIdGet;

/**
 * If the meaning of "CurrentForegroundApplicationIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentForegroundApplicationIdError;

/**
 * Property to state the RVCSignal status false = RVC not active, true = RVC active
 */
typedef RVCSignalStatusUpdate RVCSignalStatusSet;

/**
 * Property to state the RVCSignal status false = RVC not active, true = RVC active
 */
typedef RVCSignalStatusUpdate RVCSignalStatusGet;

/**
 * If the meaning of "RVCSignalStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RVCSignalStatusError;

/**
 * Property to update map out status information of regions
 */
typedef RegionsMapOutStatusInfoUpdate RegionsMapOutStatusInfoSet;

/**
 * Property to update map out status information of regions
 */
typedef RegionsMapOutStatusInfoUpdate RegionsMapOutStatusInfoGet;

/**
 * If the meaning of "RegionsMapOutStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegionsMapOutStatusInfoError;

/**
 * Property to trigger cabin source restoration on subsystem error clearance
 */
typedef CabinsSourceRestorationInfoUpdate CabinsSourceRestorationInfoSet;

/**
 * Property to trigger cabin source restoration on subsystem error clearance
 */
typedef CabinsSourceRestorationInfoUpdate CabinsSourceRestorationInfoGet;

/**
 * If the meaning of "CabinsSourceRestorationInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CabinsSourceRestorationInfoError;

/**
 * Property to update cabins systems information
 */
typedef CabinsSystemsInfoUpdate CabinsSystemsInfoSet;

/**
 * Property to update cabins systems information
 */
typedef CabinsSystemsInfoUpdate CabinsSystemsInfoGet;

/**
 * If the meaning of "CabinsSystemsInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CabinsSystemsInfoError;

/**
 * Property to update language status information
 */
typedef LanguageStatusInfoUpdate LanguageStatusInfoSet;

/**
 * Property to update language status information
 */
typedef LanguageStatusInfoUpdate LanguageStatusInfoGet;

/**
 * If the meaning of "LanguageStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LanguageStatusInfoError;

/**
 * Property to update SPI connection status information
 */
typedef SpiConnectionStatusInfoUpdate SpiConnectionStatusInfoSet;

/**
 * Property to update SPI connection status information
 */
typedef SpiConnectionStatusInfoUpdate SpiConnectionStatusInfoGet;

/**
 * If the meaning of "SpiConnectionStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpiConnectionStatusInfoError;

/**
 * Property to update the cabin sources connection status
 */
typedef CabinSourcesConnectionStatusUpdate CabinSourcesConnectionStatusSet;

/**
 * Property to update the cabin sources connection status
 */
typedef CabinSourcesConnectionStatusUpdate CabinSourcesConnectionStatusGet;

/**
 * If the meaning of "CabinSourcesConnectionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CabinSourcesConnectionStatusError;

/**
 * Property to update the cabin video mix info
 */
typedef CabinsVideoMixInfoUpdate CabinsVideoMixInfoSet;

/**
 * Property to update the cabin video mix info
 */
typedef CabinsVideoMixInfoUpdate CabinsVideoMixInfoGet;

/**
 * If the meaning of "CabinsVideoMixInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CabinsVideoMixInfoError;

/**
 * If the meaning of "ToggleGadgetAudioSourceRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ToggleGadgetAudioSourceRequestError;

/**
 * If the meaning of "CabinsSourceDisconnectionTriggerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CabinsSourceDisconnectionTriggerError;

/**
 * If the meaning of "RestoreAVSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestoreAVSourceError;


/**
 * Structure to hold map out status information of glass
 */
class MapOutStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  MapOutStatusInfo ();

    /**
     * Copy constructor
     */
    inline  MapOutStatusInfo (const MapOutStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  MapOutStatusInfo (uint32 glassId_, bool activeStatus_);

    /**
     * Destructor
     */
    inline  ~MapOutStatusInfo();

    /**
     * Assignment operator
     */
    inline MapOutStatusInfo& operator = (const MapOutStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapOutStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapOutStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapOutStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapOutStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "glassId"

    static const int kGlassId = 0;

    /**
     * Clears the field "glassId".
     *
     * The field will be set to its default value. The hasGlassId()
     * method will return false.
     */
    inline void clearGlassId();

    /**
     * Checks whether the field "glassId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlassId()). Otherwise it will return false.
     */
    inline bool hasGlassId () const;

    /**
     * Returns the value of the member "glassId".
     *
     * If the meaning of "glassId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "glassId"
     */
    inline uint32 getGlassId () const;

    /**
     * Sets the value of the member "glassId".
     *
     * If the meaning of "glassId" isn't clear, then there should be a description here.
     *
     * @param glassId The value which will be set
     */
    inline void setGlassId (uint32 glassId_);

    // API of field "activeStatus"

    static const int kActiveStatus = 1;

    /**
     * Clears the field "activeStatus".
     *
     * The field will be set to its default value. The hasActiveStatus()
     * method will return false.
     */
    inline void clearActiveStatus();

    /**
     * Checks whether the field "activeStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveStatus()). Otherwise it will return false.
     */
    inline bool hasActiveStatus () const;

    /**
     * Returns the value of the member "activeStatus".
     *
     * If the meaning of "activeStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activeStatus"
     */
    inline bool getActiveStatus () const;

    /**
     * Sets the value of the member "activeStatus".
     *
     * If the meaning of "activeStatus" isn't clear, then there should be a description here.
     *
     * @param activeStatus The value which will be set
     */
    inline void setActiveStatus (bool activeStatus_);

    static const MapOutStatusInfo &getDefaultInstance();

private:

    inline void set_has_glassId ();

    inline void clear_has_glassId ();

    inline void set_has_activeStatus ();

    inline void clear_has_activeStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _glassId;

    bool _activeStatus;

};

/**
 * Structure to hold map out status information of region
 */
class RegionMapOutStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  RegionMapOutStatusInfo ();

    /**
     * Copy constructor
     */
    inline  RegionMapOutStatusInfo (const RegionMapOutStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  RegionMapOutStatusInfo (uint32 regionId_, const ::std::vector< MapOutStatusInfo >& mapOutStatusInfo_);

    /**
     * Destructor
     */
    inline  ~RegionMapOutStatusInfo();

    /**
     * Assignment operator
     */
    inline RegionMapOutStatusInfo& operator = (const RegionMapOutStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegionMapOutStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegionMapOutStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegionMapOutStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegionMapOutStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "mapOutStatusInfo"

    static const int kMapOutStatusInfo = 1;

    /**
     * Clears the field "mapOutStatusInfo".
     *
     * The field will be set to its default value. The hasMapOutStatusInfo()
     * method will return false.
     */
    inline void clearMapOutStatusInfo();

    /**
     * Checks whether the field "mapOutStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapOutStatusInfo()). Otherwise it will return false.
     */
    inline bool hasMapOutStatusInfo () const;

    /**
     * Returns the value of the member "mapOutStatusInfo".
     *
     * If the meaning of "mapOutStatusInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mapOutStatusInfo"
     */
    inline const ::std::vector< MapOutStatusInfo >& getMapOutStatusInfo () const;

    /**
     * Retrieves the value of the field "mapOutStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mapOutStatusInfo".
     */
    inline ::std::vector< MapOutStatusInfo >& getMapOutStatusInfoMutable ();

    /**
     * Sets the value of the member "mapOutStatusInfo".
     *
     * If the meaning of "mapOutStatusInfo" isn't clear, then there should be a description here.
     *
     * @param mapOutStatusInfo The value which will be set
     */
    inline void setMapOutStatusInfo (const ::std::vector< MapOutStatusInfo >& mapOutStatusInfo_);

    static const RegionMapOutStatusInfo &getDefaultInstance();

private:

    static const ::std::vector< MapOutStatusInfo >& getMapOutStatusInfoList_DefaultInstance ();

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_mapOutStatusInfo ();

    inline void clear_has_mapOutStatusInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _regionId;

    ::std::vector< MapOutStatusInfo > _mapOutStatusInfo;

};

/**
 * Structure to hold source information of cabins
 */
class SourceInfoHolder {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoHolder ();

    /**
     * Copy constructor
     */
    inline  SourceInfoHolder (const SourceInfoHolder &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoHolder (int16 sourceId_, int16 sinkId_, uint8 sourceState_, uint32 subSourceId_, uint8 status_);

    /**
     * Destructor
     */
    inline  ~SourceInfoHolder();

    /**
     * Assignment operator
     */
    inline SourceInfoHolder& operator = (const SourceInfoHolder& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoHolder& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoHolder& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoHolder& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoHolder& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceId"

    static const int kSourceId = 0;

    /**
     * Clears the field "sourceId".
     *
     * The field will be set to its default value. The hasSourceId()
     * method will return false.
     */
    inline void clearSourceId();

    /**
     * Checks whether the field "sourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceId()). Otherwise it will return false.
     */
    inline bool hasSourceId () const;

    /**
     * Returns the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceId"
     */
    inline int16 getSourceId () const;

    /**
     * Sets the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @param sourceId The value which will be set
     */
    inline void setSourceId (int16 sourceId_);

    // API of field "sinkId"

    static const int kSinkId = 1;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline int16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (int16 sinkId_);

    // API of field "sourceState"

    static const int kSourceState = 2;

    /**
     * Clears the field "sourceState".
     *
     * The field will be set to its default value. The hasSourceState()
     * method will return false.
     */
    inline void clearSourceState();

    /**
     * Checks whether the field "sourceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceState()). Otherwise it will return false.
     */
    inline bool hasSourceState () const;

    /**
     * Returns the value of the member "sourceState".
     *
     * If the meaning of "sourceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceState"
     */
    inline uint8 getSourceState () const;

    /**
     * Sets the value of the member "sourceState".
     *
     * If the meaning of "sourceState" isn't clear, then there should be a description here.
     *
     * @param sourceState The value which will be set
     */
    inline void setSourceState (uint8 sourceState_);

    // API of field "subSourceId"

    static const int kSubSourceId = 3;

    /**
     * Clears the field "subSourceId".
     *
     * The field will be set to its default value. The hasSubSourceId()
     * method will return false.
     */
    inline void clearSubSourceId();

    /**
     * Checks whether the field "subSourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubSourceId()). Otherwise it will return false.
     */
    inline bool hasSubSourceId () const;

    /**
     * Returns the value of the member "subSourceId".
     *
     * If the meaning of "subSourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subSourceId"
     */
    inline uint32 getSubSourceId () const;

    /**
     * Sets the value of the member "subSourceId".
     *
     * If the meaning of "subSourceId" isn't clear, then there should be a description here.
     *
     * @param subSourceId The value which will be set
     */
    inline void setSubSourceId (uint32 subSourceId_);

    // API of field "status"

    static const int kStatus = 4;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const SourceInfoHolder &getDefaultInstance();

private:

    inline void set_has_sourceId ();

    inline void clear_has_sourceId ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    inline void set_has_sourceState ();

    inline void clear_has_sourceState ();

    inline void set_has_subSourceId ();

    inline void clear_has_subSourceId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (5 + 31) / 32];

    int16 _sourceId;

    int16 _sinkId;

    uint8 _sourceState;

    uint32 _subSourceId;

    uint8 _status;

};

/**
 * Structure to hold cabin source information of region
 */
class CabinSourceDisconnectionTriggerInfoHolder {
public:

    /**
     * Default constructor
     */
    inline  CabinSourceDisconnectionTriggerInfoHolder ();

    /**
     * Copy constructor
     */
    inline  CabinSourceDisconnectionTriggerInfoHolder (const CabinSourceDisconnectionTriggerInfoHolder &rhs);

    /**
     * All fields constructor
     */
    inline  CabinSourceDisconnectionTriggerInfoHolder (uint32 cabinId_, uint32 spmHMIState_, uint32 subErrorType_, const ::std::vector< SourceInfoHolder >& sourcesInfo_);

    /**
     * Destructor
     */
    inline  ~CabinSourceDisconnectionTriggerInfoHolder();

    /**
     * Assignment operator
     */
    inline CabinSourceDisconnectionTriggerInfoHolder& operator = (const CabinSourceDisconnectionTriggerInfoHolder& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinId"

    static const int kCabinId = 0;

    /**
     * Clears the field "cabinId".
     *
     * The field will be set to its default value. The hasCabinId()
     * method will return false.
     */
    inline void clearCabinId();

    /**
     * Checks whether the field "cabinId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinId()). Otherwise it will return false.
     */
    inline bool hasCabinId () const;

    /**
     * Returns the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinId"
     */
    inline uint32 getCabinId () const;

    /**
     * Sets the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @param cabinId The value which will be set
     */
    inline void setCabinId (uint32 cabinId_);

    // API of field "spmHMIState"

    static const int kSpmHMIState = 1;

    /**
     * Clears the field "spmHMIState".
     *
     * The field will be set to its default value. The hasSpmHMIState()
     * method will return false.
     */
    inline void clearSpmHMIState();

    /**
     * Checks whether the field "spmHMIState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpmHMIState()). Otherwise it will return false.
     */
    inline bool hasSpmHMIState () const;

    /**
     * Returns the value of the member "spmHMIState".
     *
     * If the meaning of "spmHMIState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "spmHMIState"
     */
    inline uint32 getSpmHMIState () const;

    /**
     * Sets the value of the member "spmHMIState".
     *
     * If the meaning of "spmHMIState" isn't clear, then there should be a description here.
     *
     * @param spmHMIState The value which will be set
     */
    inline void setSpmHMIState (uint32 spmHMIState_);

    // API of field "subErrorType"

    static const int kSubErrorType = 2;

    /**
     * Clears the field "subErrorType".
     *
     * The field will be set to its default value. The hasSubErrorType()
     * method will return false.
     */
    inline void clearSubErrorType();

    /**
     * Checks whether the field "subErrorType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubErrorType()). Otherwise it will return false.
     */
    inline bool hasSubErrorType () const;

    /**
     * Returns the value of the member "subErrorType".
     *
     * If the meaning of "subErrorType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subErrorType"
     */
    inline uint32 getSubErrorType () const;

    /**
     * Sets the value of the member "subErrorType".
     *
     * If the meaning of "subErrorType" isn't clear, then there should be a description here.
     *
     * @param subErrorType The value which will be set
     */
    inline void setSubErrorType (uint32 subErrorType_);

    // API of field "sourcesInfo"

    static const int kSourcesInfo = 3;

    /**
     * Clears the field "sourcesInfo".
     *
     * The field will be set to its default value. The hasSourcesInfo()
     * method will return false.
     */
    inline void clearSourcesInfo();

    /**
     * Checks whether the field "sourcesInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcesInfo()). Otherwise it will return false.
     */
    inline bool hasSourcesInfo () const;

    /**
     * Returns the value of the member "sourcesInfo".
     *
     * If the meaning of "sourcesInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourcesInfo"
     */
    inline const ::std::vector< SourceInfoHolder >& getSourcesInfo () const;

    /**
     * Retrieves the value of the field "sourcesInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourcesInfo".
     */
    inline ::std::vector< SourceInfoHolder >& getSourcesInfoMutable ();

    /**
     * Sets the value of the member "sourcesInfo".
     *
     * If the meaning of "sourcesInfo" isn't clear, then there should be a description here.
     *
     * @param sourcesInfo The value which will be set
     */
    inline void setSourcesInfo (const ::std::vector< SourceInfoHolder >& sourcesInfo_);

    static const CabinSourceDisconnectionTriggerInfoHolder &getDefaultInstance();

private:

    static const ::std::vector< SourceInfoHolder >& getSourceInfoHolderList_DefaultInstance ();

    inline void set_has_cabinId ();

    inline void clear_has_cabinId ();

    inline void set_has_spmHMIState ();

    inline void clear_has_spmHMIState ();

    inline void set_has_subErrorType ();

    inline void clear_has_subErrorType ();

    inline void set_has_sourcesInfo ();

    inline void clear_has_sourcesInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _cabinId;

    uint32 _spmHMIState;

    uint32 _subErrorType;

    ::std::vector< SourceInfoHolder > _sourcesInfo;

};

/**
 * Structure to hold cabin source restoration information
 */
class CabinSourceRestorationInfo {
public:

    /**
     * Default constructor
     */
    inline  CabinSourceRestorationInfo ();

    /**
     * Copy constructor
     */
    inline  CabinSourceRestorationInfo (const CabinSourceRestorationInfo &rhs);

    /**
     * All fields constructor
     */
    inline  CabinSourceRestorationInfo (uint32 cabinId_, uint8 status_, const ::std::vector< SourceInfoHolder >& lastActiveSourcesInfo_);

    /**
     * Destructor
     */
    inline  ~CabinSourceRestorationInfo();

    /**
     * Assignment operator
     */
    inline CabinSourceRestorationInfo& operator = (const CabinSourceRestorationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinSourceRestorationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinSourceRestorationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinSourceRestorationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinSourceRestorationInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinId"

    static const int kCabinId = 0;

    /**
     * Clears the field "cabinId".
     *
     * The field will be set to its default value. The hasCabinId()
     * method will return false.
     */
    inline void clearCabinId();

    /**
     * Checks whether the field "cabinId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinId()). Otherwise it will return false.
     */
    inline bool hasCabinId () const;

    /**
     * Returns the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinId"
     */
    inline uint32 getCabinId () const;

    /**
     * Sets the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @param cabinId The value which will be set
     */
    inline void setCabinId (uint32 cabinId_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "lastActiveSourcesInfo"

    static const int kLastActiveSourcesInfo = 2;

    /**
     * Clears the field "lastActiveSourcesInfo".
     *
     * The field will be set to its default value. The hasLastActiveSourcesInfo()
     * method will return false.
     */
    inline void clearLastActiveSourcesInfo();

    /**
     * Checks whether the field "lastActiveSourcesInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastActiveSourcesInfo()). Otherwise it will return false.
     */
    inline bool hasLastActiveSourcesInfo () const;

    /**
     * Returns the value of the member "lastActiveSourcesInfo".
     *
     * If the meaning of "lastActiveSourcesInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "lastActiveSourcesInfo"
     */
    inline const ::std::vector< SourceInfoHolder >& getLastActiveSourcesInfo () const;

    /**
     * Retrieves the value of the field "lastActiveSourcesInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "lastActiveSourcesInfo".
     */
    inline ::std::vector< SourceInfoHolder >& getLastActiveSourcesInfoMutable ();

    /**
     * Sets the value of the member "lastActiveSourcesInfo".
     *
     * If the meaning of "lastActiveSourcesInfo" isn't clear, then there should be a description here.
     *
     * @param lastActiveSourcesInfo The value which will be set
     */
    inline void setLastActiveSourcesInfo (const ::std::vector< SourceInfoHolder >& lastActiveSourcesInfo_);

    static const CabinSourceRestorationInfo &getDefaultInstance();

private:

    static const ::std::vector< SourceInfoHolder >& getSourceInfoHolderList_DefaultInstance ();

    inline void set_has_cabinId ();

    inline void clear_has_cabinId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_lastActiveSourcesInfo ();

    inline void clear_has_lastActiveSourcesInfo ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _cabinId;

    uint8 _status;

    ::std::vector< SourceInfoHolder > _lastActiveSourcesInfo;

};

/**
 * Structure to hold cabin system information
 */
class SystemInfo {
public:

    /**
     * Default constructor
     */
    inline  SystemInfo ();

    /**
     * Copy constructor
     */
    inline  SystemInfo (const SystemInfo &rhs);

    /**
     * All fields constructor
     */
    inline  SystemInfo (const ::std::vector< uint32 >& cabinsInfo_, uint64 entityId_, uint8 systemId_, uint8 systemPosition_, uint8 systemGroup_, uint8 systemStatus_, uint8 avdeccStatus_, uint8 nanoMsgStatus_, uint8 systemCategory_);

    /**
     * Destructor
     */
    inline  ~SystemInfo();

    /**
     * Assignment operator
     */
    inline SystemInfo& operator = (const SystemInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinsInfo"

    static const int kCabinsInfo = 0;

    /**
     * Clears the field "cabinsInfo".
     *
     * The field will be set to its default value. The hasCabinsInfo()
     * method will return false.
     */
    inline void clearCabinsInfo();

    /**
     * Checks whether the field "cabinsInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinsInfo()). Otherwise it will return false.
     */
    inline bool hasCabinsInfo () const;

    /**
     * Returns the value of the member "cabinsInfo".
     *
     * If the meaning of "cabinsInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinsInfo"
     */
    inline const ::std::vector< uint32 >& getCabinsInfo () const;

    /**
     * Retrieves the value of the field "cabinsInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinsInfo".
     */
    inline ::std::vector< uint32 >& getCabinsInfoMutable ();

    /**
     * Sets the value of the member "cabinsInfo".
     *
     * If the meaning of "cabinsInfo" isn't clear, then there should be a description here.
     *
     * @param cabinsInfo The value which will be set
     */
    inline void setCabinsInfo (const ::std::vector< uint32 >& cabinsInfo_);

    // API of field "entityId"

    static const int kEntityId = 1;

    /**
     * Clears the field "entityId".
     *
     * The field will be set to its default value. The hasEntityId()
     * method will return false.
     */
    inline void clearEntityId();

    /**
     * Checks whether the field "entityId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntityId()). Otherwise it will return false.
     */
    inline bool hasEntityId () const;

    /**
     * Returns the value of the member "entityId".
     *
     * If the meaning of "entityId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "entityId"
     */
    inline uint64 getEntityId () const;

    /**
     * Sets the value of the member "entityId".
     *
     * If the meaning of "entityId" isn't clear, then there should be a description here.
     *
     * @param entityId The value which will be set
     */
    inline void setEntityId (uint64 entityId_);

    // API of field "systemId"

    static const int kSystemId = 2;

    /**
     * Clears the field "systemId".
     *
     * The field will be set to its default value. The hasSystemId()
     * method will return false.
     */
    inline void clearSystemId();

    /**
     * Checks whether the field "systemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemId()). Otherwise it will return false.
     */
    inline bool hasSystemId () const;

    /**
     * Returns the value of the member "systemId".
     *
     * If the meaning of "systemId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "systemId"
     */
    inline uint8 getSystemId () const;

    /**
     * Sets the value of the member "systemId".
     *
     * If the meaning of "systemId" isn't clear, then there should be a description here.
     *
     * @param systemId The value which will be set
     */
    inline void setSystemId (uint8 systemId_);

    // API of field "systemPosition"

    static const int kSystemPosition = 3;

    /**
     * Clears the field "systemPosition".
     *
     * The field will be set to its default value. The hasSystemPosition()
     * method will return false.
     */
    inline void clearSystemPosition();

    /**
     * Checks whether the field "systemPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemPosition()). Otherwise it will return false.
     */
    inline bool hasSystemPosition () const;

    /**
     * Returns the value of the member "systemPosition".
     *
     * If the meaning of "systemPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "systemPosition"
     */
    inline uint8 getSystemPosition () const;

    /**
     * Sets the value of the member "systemPosition".
     *
     * If the meaning of "systemPosition" isn't clear, then there should be a description here.
     *
     * @param systemPosition The value which will be set
     */
    inline void setSystemPosition (uint8 systemPosition_);

    // API of field "systemGroup"

    static const int kSystemGroup = 4;

    /**
     * Clears the field "systemGroup".
     *
     * The field will be set to its default value. The hasSystemGroup()
     * method will return false.
     */
    inline void clearSystemGroup();

    /**
     * Checks whether the field "systemGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemGroup()). Otherwise it will return false.
     */
    inline bool hasSystemGroup () const;

    /**
     * Returns the value of the member "systemGroup".
     *
     * If the meaning of "systemGroup" isn't clear, then there should be a description here.
     *
     * @return The value of the field "systemGroup"
     */
    inline uint8 getSystemGroup () const;

    /**
     * Sets the value of the member "systemGroup".
     *
     * If the meaning of "systemGroup" isn't clear, then there should be a description here.
     *
     * @param systemGroup The value which will be set
     */
    inline void setSystemGroup (uint8 systemGroup_);

    // API of field "systemStatus"

    static const int kSystemStatus = 5;

    /**
     * Clears the field "systemStatus".
     *
     * The field will be set to its default value. The hasSystemStatus()
     * method will return false.
     */
    inline void clearSystemStatus();

    /**
     * Checks whether the field "systemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemStatus()). Otherwise it will return false.
     */
    inline bool hasSystemStatus () const;

    /**
     * Returns the value of the member "systemStatus".
     *
     * If the meaning of "systemStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "systemStatus"
     */
    inline uint8 getSystemStatus () const;

    /**
     * Sets the value of the member "systemStatus".
     *
     * If the meaning of "systemStatus" isn't clear, then there should be a description here.
     *
     * @param systemStatus The value which will be set
     */
    inline void setSystemStatus (uint8 systemStatus_);

    // API of field "avdeccStatus"

    static const int kAvdeccStatus = 6;

    /**
     * Clears the field "avdeccStatus".
     *
     * The field will be set to its default value. The hasAvdeccStatus()
     * method will return false.
     */
    inline void clearAvdeccStatus();

    /**
     * Checks whether the field "avdeccStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvdeccStatus()). Otherwise it will return false.
     */
    inline bool hasAvdeccStatus () const;

    /**
     * Returns the value of the member "avdeccStatus".
     *
     * If the meaning of "avdeccStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "avdeccStatus"
     */
    inline uint8 getAvdeccStatus () const;

    /**
     * Sets the value of the member "avdeccStatus".
     *
     * If the meaning of "avdeccStatus" isn't clear, then there should be a description here.
     *
     * @param avdeccStatus The value which will be set
     */
    inline void setAvdeccStatus (uint8 avdeccStatus_);

    // API of field "nanoMsgStatus"

    static const int kNanoMsgStatus = 7;

    /**
     * Clears the field "nanoMsgStatus".
     *
     * The field will be set to its default value. The hasNanoMsgStatus()
     * method will return false.
     */
    inline void clearNanoMsgStatus();

    /**
     * Checks whether the field "nanoMsgStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNanoMsgStatus()). Otherwise it will return false.
     */
    inline bool hasNanoMsgStatus () const;

    /**
     * Returns the value of the member "nanoMsgStatus".
     *
     * If the meaning of "nanoMsgStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "nanoMsgStatus"
     */
    inline uint8 getNanoMsgStatus () const;

    /**
     * Sets the value of the member "nanoMsgStatus".
     *
     * If the meaning of "nanoMsgStatus" isn't clear, then there should be a description here.
     *
     * @param nanoMsgStatus The value which will be set
     */
    inline void setNanoMsgStatus (uint8 nanoMsgStatus_);

    // API of field "systemCategory"

    static const int kSystemCategory = 8;

    /**
     * Clears the field "systemCategory".
     *
     * The field will be set to its default value. The hasSystemCategory()
     * method will return false.
     */
    inline void clearSystemCategory();

    /**
     * Checks whether the field "systemCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemCategory()). Otherwise it will return false.
     */
    inline bool hasSystemCategory () const;

    /**
     * Returns the value of the member "systemCategory".
     *
     * If the meaning of "systemCategory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "systemCategory"
     */
    inline uint8 getSystemCategory () const;

    /**
     * Sets the value of the member "systemCategory".
     *
     * If the meaning of "systemCategory" isn't clear, then there should be a description here.
     *
     * @param systemCategory The value which will be set
     */
    inline void setSystemCategory (uint8 systemCategory_);

    static const SystemInfo &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_cabinsInfo ();

    inline void clear_has_cabinsInfo ();

    inline void set_has_entityId ();

    inline void clear_has_entityId ();

    inline void set_has_systemId ();

    inline void clear_has_systemId ();

    inline void set_has_systemPosition ();

    inline void clear_has_systemPosition ();

    inline void set_has_systemGroup ();

    inline void clear_has_systemGroup ();

    inline void set_has_systemStatus ();

    inline void clear_has_systemStatus ();

    inline void set_has_avdeccStatus ();

    inline void clear_has_avdeccStatus ();

    inline void set_has_nanoMsgStatus ();

    inline void clear_has_nanoMsgStatus ();

    inline void set_has_systemCategory ();

    inline void clear_has_systemCategory ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::vector< uint32 > _cabinsInfo;

    uint64 _entityId;

    uint8 _systemId;

    uint8 _systemPosition;

    uint8 _systemGroup;

    uint8 _systemStatus;

    uint8 _avdeccStatus;

    uint8 _nanoMsgStatus;

    uint8 _systemCategory;

};

/**
 * Structure to hold SPI connection status information
 */
class SPIConnectionStatusInfoHolder {
public:

    /**
     * Default constructor
     */
    inline  SPIConnectionStatusInfoHolder ();

    /**
     * Copy constructor
     */
    inline  SPIConnectionStatusInfoHolder (const SPIConnectionStatusInfoHolder &rhs);

    /**
     * All fields constructor
     */
    inline  SPIConnectionStatusInfoHolder (uint8 status_, uint8 deviceType_, const ::std::string& deviceName_);

    /**
     * Destructor
     */
    inline  ~SPIConnectionStatusInfoHolder();

    /**
     * Assignment operator
     */
    inline SPIConnectionStatusInfoHolder& operator = (const SPIConnectionStatusInfoHolder& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SPIConnectionStatusInfoHolder& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SPIConnectionStatusInfoHolder& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SPIConnectionStatusInfoHolder& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SPIConnectionStatusInfoHolder& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "deviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "deviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "deviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "deviceType".
     *
     * If the meaning of "deviceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceType"
     */
    inline uint8 getDeviceType () const;

    /**
     * Sets the value of the member "deviceType".
     *
     * If the meaning of "deviceType" isn't clear, then there should be a description here.
     *
     * @param deviceType The value which will be set
     */
    inline void setDeviceType (uint8 deviceType_);

    // API of field "deviceName"

    static const int kDeviceName = 2;

    /**
     * Clears the field "deviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "deviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "deviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* deviceName_);

    /**
     * Sets the value of the member "deviceName".
     *
     * If the meaning of "deviceName" isn't clear, then there should be a description here.
     *
     * @param deviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    static const SPIConnectionStatusInfoHolder &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_deviceType ();

    inline void clear_has_deviceType ();

    inline void set_has_deviceName ();

    inline void clear_has_deviceName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _status;

    uint8 _deviceType;

    ::std::string _deviceName;

};

/**
 * If the meaning of "CabinSourceConnectionStatusInfo" isn't clear, then there should be a description here.
 */
class CabinSourceConnectionStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  CabinSourceConnectionStatusInfo ();

    /**
     * Copy constructor
     */
    inline  CabinSourceConnectionStatusInfo (const CabinSourceConnectionStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  CabinSourceConnectionStatusInfo (int16 sourceId_, bool status_, const ::std::string& userData1_, uint32 userData2_);

    /**
     * Destructor
     */
    inline  ~CabinSourceConnectionStatusInfo();

    /**
     * Assignment operator
     */
    inline CabinSourceConnectionStatusInfo& operator = (const CabinSourceConnectionStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinSourceConnectionStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinSourceConnectionStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinSourceConnectionStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinSourceConnectionStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceId"

    static const int kSourceId = 0;

    /**
     * Clears the field "sourceId".
     *
     * The field will be set to its default value. The hasSourceId()
     * method will return false.
     */
    inline void clearSourceId();

    /**
     * Checks whether the field "sourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceId()). Otherwise it will return false.
     */
    inline bool hasSourceId () const;

    /**
     * Returns the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceId"
     */
    inline int16 getSourceId () const;

    /**
     * Sets the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @param sourceId The value which will be set
     */
    inline void setSourceId (int16 sourceId_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    // API of field "userData1"

    static const int kUserData1 = 2;

    /**
     * Clears the field "userData1".
     *
     * The field will be set to its default value. The hasUserData1()
     * method will return false.
     */
    inline void clearUserData1();

    /**
     * Checks whether the field "userData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData1()). Otherwise it will return false.
     */
    inline bool hasUserData1 () const;

    /**
     * Returns the value of the member "userData1".
     *
     * If the meaning of "userData1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData1"
     */
    inline const ::std::string& getUserData1 () const;

    /**
     * Retrieves the value of the field "userData1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "userData1".
     */
    inline ::std::string& getUserData1Mutable ();

    /**
     * Sets the value of the member "userData1".
     *
     * If the meaning of "userData1" isn't clear, then there should be a description here.
     *
     * @param userData1 The value which will be set
     */
    inline void setUserData1 (const ::std::string& userData1_);

    /**
     * Sets the value of the member "userData1".
     *
     * If the meaning of "userData1" isn't clear, then there should be a description here.
     *
     * @param userData1 The value which will be set
     */
    inline void setUserData1 (const char* userData1_);

    /**
     * Sets the value of the member "userData1".
     *
     * If the meaning of "userData1" isn't clear, then there should be a description here.
     *
     * @param userData1 The value which will be set
     */
    inline void setUserData1 (const char* value, size_t size);

    // API of field "userData2"

    static const int kUserData2 = 3;

    /**
     * Clears the field "userData2".
     *
     * The field will be set to its default value. The hasUserData2()
     * method will return false.
     */
    inline void clearUserData2();

    /**
     * Checks whether the field "userData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData2()). Otherwise it will return false.
     */
    inline bool hasUserData2 () const;

    /**
     * Returns the value of the member "userData2".
     *
     * If the meaning of "userData2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData2"
     */
    inline uint32 getUserData2 () const;

    /**
     * Sets the value of the member "userData2".
     *
     * If the meaning of "userData2" isn't clear, then there should be a description here.
     *
     * @param userData2 The value which will be set
     */
    inline void setUserData2 (uint32 userData2_);

    static const CabinSourceConnectionStatusInfo &getDefaultInstance();

private:

    inline void set_has_sourceId ();

    inline void clear_has_sourceId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_userData1 ();

    inline void clear_has_userData1 ();

    inline void set_has_userData2 ();

    inline void clear_has_userData2 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int16 _sourceId;

    bool _status;

    ::std::string _userData1;

    uint32 _userData2;

};

/**
 * If the meaning of "CabinVideoMixInfo" isn't clear, then there should be a description here.
 */
class CabinVideoMixInfo {
public:

    /**
     * Default constructor
     */
    inline  CabinVideoMixInfo ();

    /**
     * Copy constructor
     */
    inline  CabinVideoMixInfo (const CabinVideoMixInfo &rhs);

    /**
     * All fields constructor
     */
    inline  CabinVideoMixInfo (uint32 cabinId_, uint8 reason_, uint8 videoMixIndex_);

    /**
     * Destructor
     */
    inline  ~CabinVideoMixInfo();

    /**
     * Assignment operator
     */
    inline CabinVideoMixInfo& operator = (const CabinVideoMixInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinVideoMixInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinVideoMixInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinVideoMixInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinVideoMixInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinId"

    static const int kCabinId = 0;

    /**
     * Clears the field "cabinId".
     *
     * The field will be set to its default value. The hasCabinId()
     * method will return false.
     */
    inline void clearCabinId();

    /**
     * Checks whether the field "cabinId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinId()). Otherwise it will return false.
     */
    inline bool hasCabinId () const;

    /**
     * Returns the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinId"
     */
    inline uint32 getCabinId () const;

    /**
     * Sets the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @param cabinId The value which will be set
     */
    inline void setCabinId (uint32 cabinId_);

    // API of field "reason"

    static const int kReason = 1;

    /**
     * Clears the field "reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reason"
     */
    inline uint8 getReason () const;

    /**
     * Sets the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @param reason The value which will be set
     */
    inline void setReason (uint8 reason_);

    // API of field "videoMixIndex"

    static const int kVideoMixIndex = 2;

    /**
     * Clears the field "videoMixIndex".
     *
     * The field will be set to its default value. The hasVideoMixIndex()
     * method will return false.
     */
    inline void clearVideoMixIndex();

    /**
     * Checks whether the field "videoMixIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoMixIndex()). Otherwise it will return false.
     */
    inline bool hasVideoMixIndex () const;

    /**
     * Returns the value of the member "videoMixIndex".
     *
     * If the meaning of "videoMixIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "videoMixIndex"
     */
    inline uint8 getVideoMixIndex () const;

    /**
     * Sets the value of the member "videoMixIndex".
     *
     * If the meaning of "videoMixIndex" isn't clear, then there should be a description here.
     *
     * @param videoMixIndex The value which will be set
     */
    inline void setVideoMixIndex (uint8 videoMixIndex_);

    static const CabinVideoMixInfo &getDefaultInstance();

private:

    inline void set_has_cabinId ();

    inline void clear_has_cabinId ();

    inline void set_has_reason ();

    inline void clear_has_reason ();

    inline void set_has_videoMixIndex ();

    inline void clear_has_videoMixIndex ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _cabinId;

    uint8 _reason;

    uint8 _videoMixIndex;

};

/**
 * Method to give RVC Signal status
 */
class GetRVCSignalStatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRVCSignalStatusResponse ();

    /**
     * Copy constructor
     */
    inline  GetRVCSignalStatusResponse (const GetRVCSignalStatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetRVCSignalStatusResponse (bool RVCSignalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~GetRVCSignalStatusResponse();

    /**
     * Assignment operator
     */
    inline GetRVCSignalStatusResponse& operator = (const GetRVCSignalStatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRVCSignalStatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRVCSignalStatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRVCSignalStatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRVCSignalStatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RVCSignalStatus"

    static const int kRVCSignalStatus = 0;

    /**
     * Clears the field "RVCSignalStatus".
     *
     * The field will be set to its default value. The hasRVCSignalStatus()
     * method will return false.
     */
    inline void clearRVCSignalStatus();

    /**
     * Checks whether the field "RVCSignalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVCSignalStatus()). Otherwise it will return false.
     */
    inline bool hasRVCSignalStatus () const;

    /**
     * Returns the value of the member "RVCSignalStatus".
     *
     * If the meaning of "RVCSignalStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RVCSignalStatus"
     */
    inline bool getRVCSignalStatus () const;

    /**
     * Sets the value of the member "RVCSignalStatus".
     *
     * If the meaning of "RVCSignalStatus" isn't clear, then there should be a description here.
     *
     * @param RVCSignalStatus The value which will be set
     */
    inline void setRVCSignalStatus (bool RVCSignalStatus_);

    static const GetRVCSignalStatusResponse &getDefaultInstance();

private:

    inline void set_has_RVCSignalStatus ();

    inline void clear_has_RVCSignalStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RVCSignalStatus;

};

/**
 * Method to give active screen/popup name
 */
class GetCurrentForegroundApplicationIdResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCurrentForegroundApplicationIdResponse ();

    /**
     * Copy constructor
     */
    inline  GetCurrentForegroundApplicationIdResponse (const GetCurrentForegroundApplicationIdResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetCurrentForegroundApplicationIdResponse (const ::std::string& currentForegroundApplicationId_);

    /**
     * Destructor
     */
    inline virtual  ~GetCurrentForegroundApplicationIdResponse();

    /**
     * Assignment operator
     */
    inline GetCurrentForegroundApplicationIdResponse& operator = (const GetCurrentForegroundApplicationIdResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCurrentForegroundApplicationIdResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCurrentForegroundApplicationIdResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCurrentForegroundApplicationIdResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCurrentForegroundApplicationIdResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "currentForegroundApplicationId"

    static const int kCurrentForegroundApplicationId = 0;

    /**
     * Clears the field "currentForegroundApplicationId".
     *
     * The field will be set to its default value. The hasCurrentForegroundApplicationId()
     * method will return false.
     */
    inline void clearCurrentForegroundApplicationId();

    /**
     * Checks whether the field "currentForegroundApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentForegroundApplicationId()). Otherwise it will return false.
     */
    inline bool hasCurrentForegroundApplicationId () const;

    /**
     * Returns the value of the member "currentForegroundApplicationId".
     *
     * If the meaning of "currentForegroundApplicationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentForegroundApplicationId"
     */
    inline const ::std::string& getCurrentForegroundApplicationId () const;

    /**
     * Retrieves the value of the field "currentForegroundApplicationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentForegroundApplicationId".
     */
    inline ::std::string& getCurrentForegroundApplicationIdMutable ();

    /**
     * Sets the value of the member "currentForegroundApplicationId".
     *
     * If the meaning of "currentForegroundApplicationId" isn't clear, then there should be a description here.
     *
     * @param currentForegroundApplicationId The value which will be set
     */
    inline void setCurrentForegroundApplicationId (const ::std::string& currentForegroundApplicationId_);

    /**
     * Sets the value of the member "currentForegroundApplicationId".
     *
     * If the meaning of "currentForegroundApplicationId" isn't clear, then there should be a description here.
     *
     * @param currentForegroundApplicationId The value which will be set
     */
    inline void setCurrentForegroundApplicationId (const char* currentForegroundApplicationId_);

    /**
     * Sets the value of the member "currentForegroundApplicationId".
     *
     * If the meaning of "currentForegroundApplicationId" isn't clear, then there should be a description here.
     *
     * @param currentForegroundApplicationId The value which will be set
     */
    inline void setCurrentForegroundApplicationId (const char* value, size_t size);

    static const GetCurrentForegroundApplicationIdResponse &getDefaultInstance();

private:

    inline void set_has_currentForegroundApplicationId ();

    inline void clear_has_currentForegroundApplicationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _currentForegroundApplicationId;

};

/**
 * Method to update the trigger of gadget audio source toggle
 */
class ToggleGadgetAudioSourceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ToggleGadgetAudioSourceRequest ();

    /**
     * Copy constructor
     */
    inline  ToggleGadgetAudioSourceRequest (const ToggleGadgetAudioSourceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ToggleGadgetAudioSourceRequest (uint32 regionId_, uint8 srcApplicationId_, uint8 destApplicationId_);

    /**
     * Destructor
     */
    inline virtual  ~ToggleGadgetAudioSourceRequest();

    /**
     * Assignment operator
     */
    inline ToggleGadgetAudioSourceRequest& operator = (const ToggleGadgetAudioSourceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ToggleGadgetAudioSourceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ToggleGadgetAudioSourceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ToggleGadgetAudioSourceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ToggleGadgetAudioSourceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "srcApplicationId"

    static const int kSrcApplicationId = 1;

    /**
     * Clears the field "srcApplicationId".
     *
     * The field will be set to its default value. The hasSrcApplicationId()
     * method will return false.
     */
    inline void clearSrcApplicationId();

    /**
     * Checks whether the field "srcApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcApplicationId()). Otherwise it will return false.
     */
    inline bool hasSrcApplicationId () const;

    /**
     * Returns the value of the member "srcApplicationId".
     *
     * If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "srcApplicationId"
     */
    inline uint8 getSrcApplicationId () const;

    /**
     * Sets the value of the member "srcApplicationId".
     *
     * If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @param srcApplicationId The value which will be set
     */
    inline void setSrcApplicationId (uint8 srcApplicationId_);

    // API of field "destApplicationId"

    static const int kDestApplicationId = 2;

    /**
     * Clears the field "destApplicationId".
     *
     * The field will be set to its default value. The hasDestApplicationId()
     * method will return false.
     */
    inline void clearDestApplicationId();

    /**
     * Checks whether the field "destApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestApplicationId()). Otherwise it will return false.
     */
    inline bool hasDestApplicationId () const;

    /**
     * Returns the value of the member "destApplicationId".
     *
     * If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destApplicationId"
     */
    inline uint8 getDestApplicationId () const;

    /**
     * Sets the value of the member "destApplicationId".
     *
     * If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     *
     * @param destApplicationId The value which will be set
     */
    inline void setDestApplicationId (uint8 destApplicationId_);

    static const ToggleGadgetAudioSourceRequest &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_srcApplicationId ();

    inline void clear_has_srcApplicationId ();

    inline void set_has_destApplicationId ();

    inline void clear_has_destApplicationId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _regionId;

    uint8 _srcApplicationId;

    uint8 _destApplicationId;

};

/**
 * Method to update the cabin source connection status
 */
class SetCabinSourceConnectionStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCabinSourceConnectionStatusRequest ();

    /**
     * Copy constructor
     */
    inline  SetCabinSourceConnectionStatusRequest (const SetCabinSourceConnectionStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetCabinSourceConnectionStatusRequest (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetCabinSourceConnectionStatusRequest();

    /**
     * Assignment operator
     */
    inline SetCabinSourceConnectionStatusRequest& operator = (const SetCabinSourceConnectionStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCabinSourceConnectionStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCabinSourceConnectionStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCabinSourceConnectionStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCabinSourceConnectionStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinSourcesConnectionStatusInfo"

    static const int kCabinSourcesConnectionStatusInfo = 0;

    /**
     * Clears the field "cabinSourcesConnectionStatusInfo".
     *
     * The field will be set to its default value. The hasCabinSourcesConnectionStatusInfo()
     * method will return false.
     */
    inline void clearCabinSourcesConnectionStatusInfo();

    /**
     * Checks whether the field "cabinSourcesConnectionStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinSourcesConnectionStatusInfo()). Otherwise it will return false.
     */
    inline bool hasCabinSourcesConnectionStatusInfo () const;

    /**
     * Returns the value of the member "cabinSourcesConnectionStatusInfo".
     *
     * If the meaning of "cabinSourcesConnectionStatusInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinSourcesConnectionStatusInfo"
     */
    inline const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatusInfo () const;

    /**
     * Retrieves the value of the field "cabinSourcesConnectionStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinSourcesConnectionStatusInfo".
     */
    inline ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatusInfoMutable ();

    /**
     * Sets the value of the member "cabinSourcesConnectionStatusInfo".
     *
     * If the meaning of "cabinSourcesConnectionStatusInfo" isn't clear, then there should be a description here.
     *
     * @param cabinSourcesConnectionStatusInfo The value which will be set
     */
    inline void setCabinSourcesConnectionStatusInfo (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo_);

    static const SetCabinSourceConnectionStatusRequest &getDefaultInstance();

private:

    static const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourceConnectionStatusInfoList_DefaultInstance ();

    inline void set_has_cabinSourcesConnectionStatusInfo ();

    inline void clear_has_cabinSourcesConnectionStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CabinSourceConnectionStatusInfo > _cabinSourcesConnectionStatusInfo;

};

/**
 * Method to remove source from cabin source connection array
 */
class RemoveCabinSourceConnectionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveCabinSourceConnectionRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveCabinSourceConnectionRequest (const RemoveCabinSourceConnectionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveCabinSourceConnectionRequest (const ::std::vector< uint32 >& sourcesIdInfo_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveCabinSourceConnectionRequest();

    /**
     * Assignment operator
     */
    inline RemoveCabinSourceConnectionRequest& operator = (const RemoveCabinSourceConnectionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveCabinSourceConnectionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveCabinSourceConnectionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveCabinSourceConnectionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveCabinSourceConnectionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourcesIdInfo"

    static const int kSourcesIdInfo = 0;

    /**
     * Clears the field "sourcesIdInfo".
     *
     * The field will be set to its default value. The hasSourcesIdInfo()
     * method will return false.
     */
    inline void clearSourcesIdInfo();

    /**
     * Checks whether the field "sourcesIdInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcesIdInfo()). Otherwise it will return false.
     */
    inline bool hasSourcesIdInfo () const;

    /**
     * Returns the value of the member "sourcesIdInfo".
     *
     * If the meaning of "sourcesIdInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourcesIdInfo"
     */
    inline const ::std::vector< uint32 >& getSourcesIdInfo () const;

    /**
     * Retrieves the value of the field "sourcesIdInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourcesIdInfo".
     */
    inline ::std::vector< uint32 >& getSourcesIdInfoMutable ();

    /**
     * Sets the value of the member "sourcesIdInfo".
     *
     * If the meaning of "sourcesIdInfo" isn't clear, then there should be a description here.
     *
     * @param sourcesIdInfo The value which will be set
     */
    inline void setSourcesIdInfo (const ::std::vector< uint32 >& sourcesIdInfo_);

    static const RemoveCabinSourceConnectionRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_sourcesIdInfo ();

    inline void clear_has_sourcesIdInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint32 > _sourcesIdInfo;

};

/**
 * Method to update the cabin video mix info
 */
class SetCabinVideoMixIndexRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCabinVideoMixIndexRequest ();

    /**
     * Copy constructor
     */
    inline  SetCabinVideoMixIndexRequest (const SetCabinVideoMixIndexRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetCabinVideoMixIndexRequest (const CabinVideoMixInfo& cabinVideoMixInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetCabinVideoMixIndexRequest();

    /**
     * Assignment operator
     */
    inline SetCabinVideoMixIndexRequest& operator = (const SetCabinVideoMixIndexRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCabinVideoMixIndexRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCabinVideoMixIndexRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCabinVideoMixIndexRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCabinVideoMixIndexRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinVideoMixInfo"

    static const int kCabinVideoMixInfo = 0;

    /**
     * Clears the field "cabinVideoMixInfo".
     *
     * The field will be set to its default value. The hasCabinVideoMixInfo()
     * method will return false.
     */
    inline void clearCabinVideoMixInfo();

    /**
     * Checks whether the field "cabinVideoMixInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinVideoMixInfo()). Otherwise it will return false.
     */
    inline bool hasCabinVideoMixInfo () const;

    /**
     * Returns the value of the member "cabinVideoMixInfo".
     *
     * If the meaning of "cabinVideoMixInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinVideoMixInfo"
     */
    inline const CabinVideoMixInfo& getCabinVideoMixInfo () const;

    /**
     * Retrieves the value of the field "cabinVideoMixInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinVideoMixInfo".
     */
    inline CabinVideoMixInfo& getCabinVideoMixInfoMutable ();

    /**
     * Sets the value of the member "cabinVideoMixInfo".
     *
     * If the meaning of "cabinVideoMixInfo" isn't clear, then there should be a description here.
     *
     * @param cabinVideoMixInfo The value which will be set
     */
    inline void setCabinVideoMixInfo (const CabinVideoMixInfo& cabinVideoMixInfo_);

    static const SetCabinVideoMixIndexRequest &getDefaultInstance();

private:

    inline void set_has_cabinVideoMixInfo ();

    inline void clear_has_cabinVideoMixInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    CabinVideoMixInfo _cabinVideoMixInfo;

};

/**
 * Property to state the currentVisibleScene
 */
class CurrentForegroundApplicationIdUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentForegroundApplicationIdUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentForegroundApplicationIdUpdate (const CurrentForegroundApplicationIdUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentForegroundApplicationIdUpdate (uint8 currentForegroundApplicationId_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentForegroundApplicationIdUpdate();

    /**
     * Assignment operator
     */
    inline CurrentForegroundApplicationIdUpdate& operator = (const CurrentForegroundApplicationIdUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentForegroundApplicationIdUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentForegroundApplicationIdUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentForegroundApplicationIdUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentForegroundApplicationIdUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "currentForegroundApplicationId"

    static const int kCurrentForegroundApplicationId = 0;

    /**
     * Clears the field "currentForegroundApplicationId".
     *
     * The field will be set to its default value. The hasCurrentForegroundApplicationId()
     * method will return false.
     */
    inline void clearCurrentForegroundApplicationId();

    /**
     * Checks whether the field "currentForegroundApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentForegroundApplicationId()). Otherwise it will return false.
     */
    inline bool hasCurrentForegroundApplicationId () const;

    /**
     * Returns the value of the member "currentForegroundApplicationId".
     *
     * Property to state the currentVisibleScene
     *
     * @return The value of the field "currentForegroundApplicationId"
     */
    inline uint8 getCurrentForegroundApplicationId () const;

    /**
     * Sets the value of the member "currentForegroundApplicationId".
     *
     * Property to state the currentVisibleScene
     *
     * @param currentForegroundApplicationId The value which will be set
     */
    inline void setCurrentForegroundApplicationId (uint8 currentForegroundApplicationId_);

    static const CurrentForegroundApplicationIdUpdate &getDefaultInstance();

private:

    inline void set_has_currentForegroundApplicationId ();

    inline void clear_has_currentForegroundApplicationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _currentForegroundApplicationId;

};

/**
 * Property to state the currentVisibleScene
 */
class CurrentForegroundApplicationIdRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentForegroundApplicationIdRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentForegroundApplicationIdRegister (const CurrentForegroundApplicationIdRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentForegroundApplicationIdRegister();

    /**
     * Assignment operator
     */
    inline CurrentForegroundApplicationIdRegister& operator = (const CurrentForegroundApplicationIdRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentForegroundApplicationIdRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentForegroundApplicationIdRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentForegroundApplicationIdRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentForegroundApplicationIdRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentForegroundApplicationIdRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the RVCSignal status false = RVC not active, true = RVC active
 */
class RVCSignalStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCSignalStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  RVCSignalStatusUpdate (const RVCSignalStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RVCSignalStatusUpdate (bool RVCSignalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RVCSignalStatusUpdate();

    /**
     * Assignment operator
     */
    inline RVCSignalStatusUpdate& operator = (const RVCSignalStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCSignalStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCSignalStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCSignalStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCSignalStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RVCSignalStatus"

    static const int kRVCSignalStatus = 0;

    /**
     * Clears the field "RVCSignalStatus".
     *
     * The field will be set to its default value. The hasRVCSignalStatus()
     * method will return false.
     */
    inline void clearRVCSignalStatus();

    /**
     * Checks whether the field "RVCSignalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVCSignalStatus()). Otherwise it will return false.
     */
    inline bool hasRVCSignalStatus () const;

    /**
     * Returns the value of the member "RVCSignalStatus".
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @return The value of the field "RVCSignalStatus"
     */
    inline bool getRVCSignalStatus () const;

    /**
     * Sets the value of the member "RVCSignalStatus".
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @param RVCSignalStatus The value which will be set
     */
    inline void setRVCSignalStatus (bool RVCSignalStatus_);

    static const RVCSignalStatusUpdate &getDefaultInstance();

private:

    inline void set_has_RVCSignalStatus ();

    inline void clear_has_RVCSignalStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RVCSignalStatus;

};

/**
 * Property to state the RVCSignal status false = RVC not active, true = RVC active
 */
class RVCSignalStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCSignalStatusRegister ();

    /**
     * Copy constructor
     */
    inline  RVCSignalStatusRegister (const RVCSignalStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RVCSignalStatusRegister();

    /**
     * Assignment operator
     */
    inline RVCSignalStatusRegister& operator = (const RVCSignalStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCSignalStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCSignalStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCSignalStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCSignalStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RVCSignalStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update map out status information of regions
 */
class RegionsMapOutStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegionsMapOutStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  RegionsMapOutStatusInfoUpdate (const RegionsMapOutStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RegionsMapOutStatusInfoUpdate (const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~RegionsMapOutStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline RegionsMapOutStatusInfoUpdate& operator = (const RegionsMapOutStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegionsMapOutStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegionsMapOutStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegionsMapOutStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegionsMapOutStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionsMapOutStatusInfo"

    static const int kRegionsMapOutStatusInfo = 0;

    /**
     * Clears the field "regionsMapOutStatusInfo".
     *
     * The field will be set to its default value. The hasRegionsMapOutStatusInfo()
     * method will return false.
     */
    inline void clearRegionsMapOutStatusInfo();

    /**
     * Checks whether the field "regionsMapOutStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionsMapOutStatusInfo()). Otherwise it will return false.
     */
    inline bool hasRegionsMapOutStatusInfo () const;

    /**
     * Returns the value of the member "regionsMapOutStatusInfo".
     *
     * Property to update map out status information of regions
     *
     * @return The value of the field "regionsMapOutStatusInfo"
     */
    inline const ::std::vector< RegionMapOutStatusInfo >& getRegionsMapOutStatusInfo () const;

    /**
     * Retrieves the value of the field "regionsMapOutStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regionsMapOutStatusInfo".
     */
    inline ::std::vector< RegionMapOutStatusInfo >& getRegionsMapOutStatusInfoMutable ();

    /**
     * Sets the value of the member "regionsMapOutStatusInfo".
     *
     * Property to update map out status information of regions
     *
     * @param regionsMapOutStatusInfo The value which will be set
     */
    inline void setRegionsMapOutStatusInfo (const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo_);

    static const RegionsMapOutStatusInfoUpdate &getDefaultInstance();

private:

    static const ::std::vector< RegionMapOutStatusInfo >& getRegionMapOutStatusInfoList_DefaultInstance ();

    inline void set_has_regionsMapOutStatusInfo ();

    inline void clear_has_regionsMapOutStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< RegionMapOutStatusInfo > _regionsMapOutStatusInfo;

};

/**
 * Property to update map out status information of regions
 */
class RegionsMapOutStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegionsMapOutStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  RegionsMapOutStatusInfoRegister (const RegionsMapOutStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RegionsMapOutStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline RegionsMapOutStatusInfoRegister& operator = (const RegionsMapOutStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegionsMapOutStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegionsMapOutStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegionsMapOutStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegionsMapOutStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RegionsMapOutStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to trigger cabin source restoration on subsystem error clearance
 */
class CabinsSourceRestorationInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsSourceRestorationInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  CabinsSourceRestorationInfoUpdate (const CabinsSourceRestorationInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CabinsSourceRestorationInfoUpdate (const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CabinsSourceRestorationInfoUpdate();

    /**
     * Assignment operator
     */
    inline CabinsSourceRestorationInfoUpdate& operator = (const CabinsSourceRestorationInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsSourceRestorationInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsSourceRestorationInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsSourceRestorationInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsSourceRestorationInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinsSourceRestorationInfo"

    static const int kCabinsSourceRestorationInfo = 0;

    /**
     * Clears the field "cabinsSourceRestorationInfo".
     *
     * The field will be set to its default value. The hasCabinsSourceRestorationInfo()
     * method will return false.
     */
    inline void clearCabinsSourceRestorationInfo();

    /**
     * Checks whether the field "cabinsSourceRestorationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinsSourceRestorationInfo()). Otherwise it will return false.
     */
    inline bool hasCabinsSourceRestorationInfo () const;

    /**
     * Returns the value of the member "cabinsSourceRestorationInfo".
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @return The value of the field "cabinsSourceRestorationInfo"
     */
    inline const ::std::vector< CabinSourceRestorationInfo >& getCabinsSourceRestorationInfo () const;

    /**
     * Retrieves the value of the field "cabinsSourceRestorationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinsSourceRestorationInfo".
     */
    inline ::std::vector< CabinSourceRestorationInfo >& getCabinsSourceRestorationInfoMutable ();

    /**
     * Sets the value of the member "cabinsSourceRestorationInfo".
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @param cabinsSourceRestorationInfo The value which will be set
     */
    inline void setCabinsSourceRestorationInfo (const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo_);

    static const CabinsSourceRestorationInfoUpdate &getDefaultInstance();

private:

    static const ::std::vector< CabinSourceRestorationInfo >& getCabinSourceRestorationInfoList_DefaultInstance ();

    inline void set_has_cabinsSourceRestorationInfo ();

    inline void clear_has_cabinsSourceRestorationInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CabinSourceRestorationInfo > _cabinsSourceRestorationInfo;

};

/**
 * Property to trigger cabin source restoration on subsystem error clearance
 */
class CabinsSourceRestorationInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsSourceRestorationInfoRegister ();

    /**
     * Copy constructor
     */
    inline  CabinsSourceRestorationInfoRegister (const CabinsSourceRestorationInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CabinsSourceRestorationInfoRegister();

    /**
     * Assignment operator
     */
    inline CabinsSourceRestorationInfoRegister& operator = (const CabinsSourceRestorationInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsSourceRestorationInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsSourceRestorationInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsSourceRestorationInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsSourceRestorationInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CabinsSourceRestorationInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update cabins systems information
 */
class CabinsSystemsInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsSystemsInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  CabinsSystemsInfoUpdate (const CabinsSystemsInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CabinsSystemsInfoUpdate (const ::std::vector< SystemInfo >& cabinsSystemsInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CabinsSystemsInfoUpdate();

    /**
     * Assignment operator
     */
    inline CabinsSystemsInfoUpdate& operator = (const CabinsSystemsInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsSystemsInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsSystemsInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsSystemsInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsSystemsInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinsSystemsInfo"

    static const int kCabinsSystemsInfo = 0;

    /**
     * Clears the field "cabinsSystemsInfo".
     *
     * The field will be set to its default value. The hasCabinsSystemsInfo()
     * method will return false.
     */
    inline void clearCabinsSystemsInfo();

    /**
     * Checks whether the field "cabinsSystemsInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinsSystemsInfo()). Otherwise it will return false.
     */
    inline bool hasCabinsSystemsInfo () const;

    /**
     * Returns the value of the member "cabinsSystemsInfo".
     *
     * Property to update cabins systems information
     *
     * @return The value of the field "cabinsSystemsInfo"
     */
    inline const ::std::vector< SystemInfo >& getCabinsSystemsInfo () const;

    /**
     * Retrieves the value of the field "cabinsSystemsInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinsSystemsInfo".
     */
    inline ::std::vector< SystemInfo >& getCabinsSystemsInfoMutable ();

    /**
     * Sets the value of the member "cabinsSystemsInfo".
     *
     * Property to update cabins systems information
     *
     * @param cabinsSystemsInfo The value which will be set
     */
    inline void setCabinsSystemsInfo (const ::std::vector< SystemInfo >& cabinsSystemsInfo_);

    static const CabinsSystemsInfoUpdate &getDefaultInstance();

private:

    static const ::std::vector< SystemInfo >& getSystemInfoList_DefaultInstance ();

    inline void set_has_cabinsSystemsInfo ();

    inline void clear_has_cabinsSystemsInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SystemInfo > _cabinsSystemsInfo;

};

/**
 * Property to update cabins systems information
 */
class CabinsSystemsInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsSystemsInfoRegister ();

    /**
     * Copy constructor
     */
    inline  CabinsSystemsInfoRegister (const CabinsSystemsInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CabinsSystemsInfoRegister();

    /**
     * Assignment operator
     */
    inline CabinsSystemsInfoRegister& operator = (const CabinsSystemsInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsSystemsInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsSystemsInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsSystemsInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsSystemsInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CabinsSystemsInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update language status information
 */
class LanguageStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  LanguageStatusInfoUpdate (const LanguageStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageStatusInfoUpdate (uint32 LanguageStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline LanguageStatusInfoUpdate& operator = (const LanguageStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageStatusInfo"

    static const int kLanguageStatusInfo = 0;

    /**
     * Clears the field "LanguageStatusInfo".
     *
     * The field will be set to its default value. The hasLanguageStatusInfo()
     * method will return false.
     */
    inline void clearLanguageStatusInfo();

    /**
     * Checks whether the field "LanguageStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageStatusInfo()). Otherwise it will return false.
     */
    inline bool hasLanguageStatusInfo () const;

    /**
     * Returns the value of the member "LanguageStatusInfo".
     *
     * Property to update language status information
     *
     * @return The value of the field "LanguageStatusInfo"
     */
    inline uint32 getLanguageStatusInfo () const;

    /**
     * Sets the value of the member "LanguageStatusInfo".
     *
     * Property to update language status information
     *
     * @param LanguageStatusInfo The value which will be set
     */
    inline void setLanguageStatusInfo (uint32 LanguageStatusInfo_);

    static const LanguageStatusInfoUpdate &getDefaultInstance();

private:

    inline void set_has_LanguageStatusInfo ();

    inline void clear_has_LanguageStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _LanguageStatusInfo;

};

/**
 * Property to update language status information
 */
class LanguageStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  LanguageStatusInfoRegister (const LanguageStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LanguageStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline LanguageStatusInfoRegister& operator = (const LanguageStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LanguageStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update SPI connection status information
 */
class SpiConnectionStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpiConnectionStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  SpiConnectionStatusInfoUpdate (const SpiConnectionStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpiConnectionStatusInfoUpdate (const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SpiConnectionStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline SpiConnectionStatusInfoUpdate& operator = (const SpiConnectionStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpiConnectionStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpiConnectionStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpiConnectionStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpiConnectionStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "spiConnectionStatusInfo"

    static const int kSpiConnectionStatusInfo = 0;

    /**
     * Clears the field "spiConnectionStatusInfo".
     *
     * The field will be set to its default value. The hasSpiConnectionStatusInfo()
     * method will return false.
     */
    inline void clearSpiConnectionStatusInfo();

    /**
     * Checks whether the field "spiConnectionStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpiConnectionStatusInfo()). Otherwise it will return false.
     */
    inline bool hasSpiConnectionStatusInfo () const;

    /**
     * Returns the value of the member "spiConnectionStatusInfo".
     *
     * Property to update SPI connection status information
     *
     * @return The value of the field "spiConnectionStatusInfo"
     */
    inline const SPIConnectionStatusInfoHolder& getSpiConnectionStatusInfo () const;

    /**
     * Retrieves the value of the field "spiConnectionStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "spiConnectionStatusInfo".
     */
    inline SPIConnectionStatusInfoHolder& getSpiConnectionStatusInfoMutable ();

    /**
     * Sets the value of the member "spiConnectionStatusInfo".
     *
     * Property to update SPI connection status information
     *
     * @param spiConnectionStatusInfo The value which will be set
     */
    inline void setSpiConnectionStatusInfo (const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo_);

    static const SpiConnectionStatusInfoUpdate &getDefaultInstance();

private:

    inline void set_has_spiConnectionStatusInfo ();

    inline void clear_has_spiConnectionStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SPIConnectionStatusInfoHolder _spiConnectionStatusInfo;

};

/**
 * Property to update SPI connection status information
 */
class SpiConnectionStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpiConnectionStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  SpiConnectionStatusInfoRegister (const SpiConnectionStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpiConnectionStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline SpiConnectionStatusInfoRegister& operator = (const SpiConnectionStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpiConnectionStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpiConnectionStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpiConnectionStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpiConnectionStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpiConnectionStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update the cabin sources connection status
 */
class CabinSourcesConnectionStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinSourcesConnectionStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  CabinSourcesConnectionStatusUpdate (const CabinSourcesConnectionStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CabinSourcesConnectionStatusUpdate (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~CabinSourcesConnectionStatusUpdate();

    /**
     * Assignment operator
     */
    inline CabinSourcesConnectionStatusUpdate& operator = (const CabinSourcesConnectionStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinSourcesConnectionStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinSourcesConnectionStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinSourcesConnectionStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinSourcesConnectionStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinSourcesConnectionStatus"

    static const int kCabinSourcesConnectionStatus = 0;

    /**
     * Clears the field "cabinSourcesConnectionStatus".
     *
     * The field will be set to its default value. The hasCabinSourcesConnectionStatus()
     * method will return false.
     */
    inline void clearCabinSourcesConnectionStatus();

    /**
     * Checks whether the field "cabinSourcesConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinSourcesConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasCabinSourcesConnectionStatus () const;

    /**
     * Returns the value of the member "cabinSourcesConnectionStatus".
     *
     * Property to update the cabin sources connection status
     *
     * @return The value of the field "cabinSourcesConnectionStatus"
     */
    inline const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatus () const;

    /**
     * Retrieves the value of the field "cabinSourcesConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinSourcesConnectionStatus".
     */
    inline ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatusMutable ();

    /**
     * Sets the value of the member "cabinSourcesConnectionStatus".
     *
     * Property to update the cabin sources connection status
     *
     * @param cabinSourcesConnectionStatus The value which will be set
     */
    inline void setCabinSourcesConnectionStatus (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus_);

    static const CabinSourcesConnectionStatusUpdate &getDefaultInstance();

private:

    static const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourceConnectionStatusInfoList_DefaultInstance ();

    inline void set_has_cabinSourcesConnectionStatus ();

    inline void clear_has_cabinSourcesConnectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CabinSourceConnectionStatusInfo > _cabinSourcesConnectionStatus;

};

/**
 * Property to update the cabin sources connection status
 */
class CabinSourcesConnectionStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinSourcesConnectionStatusRegister ();

    /**
     * Copy constructor
     */
    inline  CabinSourcesConnectionStatusRegister (const CabinSourcesConnectionStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CabinSourcesConnectionStatusRegister();

    /**
     * Assignment operator
     */
    inline CabinSourcesConnectionStatusRegister& operator = (const CabinSourcesConnectionStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinSourcesConnectionStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinSourcesConnectionStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinSourcesConnectionStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinSourcesConnectionStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CabinSourcesConnectionStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to update the cabin video mix info
 */
class CabinsVideoMixInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsVideoMixInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  CabinsVideoMixInfoUpdate (const CabinsVideoMixInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CabinsVideoMixInfoUpdate (const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CabinsVideoMixInfoUpdate();

    /**
     * Assignment operator
     */
    inline CabinsVideoMixInfoUpdate& operator = (const CabinsVideoMixInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsVideoMixInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsVideoMixInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsVideoMixInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsVideoMixInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinsVideoMixInfo"

    static const int kCabinsVideoMixInfo = 0;

    /**
     * Clears the field "cabinsVideoMixInfo".
     *
     * The field will be set to its default value. The hasCabinsVideoMixInfo()
     * method will return false.
     */
    inline void clearCabinsVideoMixInfo();

    /**
     * Checks whether the field "cabinsVideoMixInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinsVideoMixInfo()). Otherwise it will return false.
     */
    inline bool hasCabinsVideoMixInfo () const;

    /**
     * Returns the value of the member "cabinsVideoMixInfo".
     *
     * Property to update the cabin video mix info
     *
     * @return The value of the field "cabinsVideoMixInfo"
     */
    inline const ::std::vector< CabinVideoMixInfo >& getCabinsVideoMixInfo () const;

    /**
     * Retrieves the value of the field "cabinsVideoMixInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinsVideoMixInfo".
     */
    inline ::std::vector< CabinVideoMixInfo >& getCabinsVideoMixInfoMutable ();

    /**
     * Sets the value of the member "cabinsVideoMixInfo".
     *
     * Property to update the cabin video mix info
     *
     * @param cabinsVideoMixInfo The value which will be set
     */
    inline void setCabinsVideoMixInfo (const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo_);

    static const CabinsVideoMixInfoUpdate &getDefaultInstance();

private:

    static const ::std::vector< CabinVideoMixInfo >& getCabinVideoMixInfoList_DefaultInstance ();

    inline void set_has_cabinsVideoMixInfo ();

    inline void clear_has_cabinsVideoMixInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CabinVideoMixInfo > _cabinsVideoMixInfo;

};

/**
 * Property to update the cabin video mix info
 */
class CabinsVideoMixInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsVideoMixInfoRegister ();

    /**
     * Copy constructor
     */
    inline  CabinsVideoMixInfoRegister (const CabinsVideoMixInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CabinsVideoMixInfoRegister();

    /**
     * Assignment operator
     */
    inline CabinsVideoMixInfoRegister& operator = (const CabinsVideoMixInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsVideoMixInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsVideoMixInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsVideoMixInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsVideoMixInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CabinsVideoMixInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Signal to update the trigger of gadget audio source toggle
 */
class ToggleGadgetAudioSourceRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ToggleGadgetAudioSourceRequestSignal ();

    /**
     * Copy constructor
     */
    inline  ToggleGadgetAudioSourceRequestSignal (const ToggleGadgetAudioSourceRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ToggleGadgetAudioSourceRequestSignal (uint32 regionId_, uint8 srcApplicationId_, uint8 destApplicationId_);

    /**
     * Destructor
     */
    inline virtual  ~ToggleGadgetAudioSourceRequestSignal();

    /**
     * Assignment operator
     */
    inline ToggleGadgetAudioSourceRequestSignal& operator = (const ToggleGadgetAudioSourceRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ToggleGadgetAudioSourceRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ToggleGadgetAudioSourceRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ToggleGadgetAudioSourceRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ToggleGadgetAudioSourceRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "srcApplicationId"

    static const int kSrcApplicationId = 1;

    /**
     * Clears the field "srcApplicationId".
     *
     * The field will be set to its default value. The hasSrcApplicationId()
     * method will return false.
     */
    inline void clearSrcApplicationId();

    /**
     * Checks whether the field "srcApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcApplicationId()). Otherwise it will return false.
     */
    inline bool hasSrcApplicationId () const;

    /**
     * Returns the value of the member "srcApplicationId".
     *
     * If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "srcApplicationId"
     */
    inline uint8 getSrcApplicationId () const;

    /**
     * Sets the value of the member "srcApplicationId".
     *
     * If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @param srcApplicationId The value which will be set
     */
    inline void setSrcApplicationId (uint8 srcApplicationId_);

    // API of field "destApplicationId"

    static const int kDestApplicationId = 2;

    /**
     * Clears the field "destApplicationId".
     *
     * The field will be set to its default value. The hasDestApplicationId()
     * method will return false.
     */
    inline void clearDestApplicationId();

    /**
     * Checks whether the field "destApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestApplicationId()). Otherwise it will return false.
     */
    inline bool hasDestApplicationId () const;

    /**
     * Returns the value of the member "destApplicationId".
     *
     * If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destApplicationId"
     */
    inline uint8 getDestApplicationId () const;

    /**
     * Sets the value of the member "destApplicationId".
     *
     * If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     *
     * @param destApplicationId The value which will be set
     */
    inline void setDestApplicationId (uint8 destApplicationId_);

    static const ToggleGadgetAudioSourceRequestSignal &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_srcApplicationId ();

    inline void clear_has_srcApplicationId ();

    inline void set_has_destApplicationId ();

    inline void clear_has_destApplicationId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _regionId;

    uint8 _srcApplicationId;

    uint8 _destApplicationId;

};

/**
 * Signal to trigger cabin source disconnection on subsystem error
 */
class CabinsSourceDisconnectionTriggerSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinsSourceDisconnectionTriggerSignal ();

    /**
     * Copy constructor
     */
    inline  CabinsSourceDisconnectionTriggerSignal (const CabinsSourceDisconnectionTriggerSignal &rhs);

    /**
     * All fields constructor
     */
    inline  CabinsSourceDisconnectionTriggerSignal (const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CabinsSourceDisconnectionTriggerSignal();

    /**
     * Assignment operator
     */
    inline CabinsSourceDisconnectionTriggerSignal& operator = (const CabinsSourceDisconnectionTriggerSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinsSourceDisconnectionTriggerSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinsSourceDisconnectionTriggerSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinsSourceDisconnectionTriggerSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinsSourceDisconnectionTriggerSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinsSourceDisconnectionTriggerInfo"

    static const int kCabinsSourceDisconnectionTriggerInfo = 0;

    /**
     * Clears the field "cabinsSourceDisconnectionTriggerInfo".
     *
     * The field will be set to its default value. The hasCabinsSourceDisconnectionTriggerInfo()
     * method will return false.
     */
    inline void clearCabinsSourceDisconnectionTriggerInfo();

    /**
     * Checks whether the field "cabinsSourceDisconnectionTriggerInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinsSourceDisconnectionTriggerInfo()). Otherwise it will return false.
     */
    inline bool hasCabinsSourceDisconnectionTriggerInfo () const;

    /**
     * Returns the value of the member "cabinsSourceDisconnectionTriggerInfo".
     *
     * If the meaning of "cabinsSourceDisconnectionTriggerInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinsSourceDisconnectionTriggerInfo"
     */
    inline const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& getCabinsSourceDisconnectionTriggerInfo () const;

    /**
     * Retrieves the value of the field "cabinsSourceDisconnectionTriggerInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cabinsSourceDisconnectionTriggerInfo".
     */
    inline ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& getCabinsSourceDisconnectionTriggerInfoMutable ();

    /**
     * Sets the value of the member "cabinsSourceDisconnectionTriggerInfo".
     *
     * If the meaning of "cabinsSourceDisconnectionTriggerInfo" isn't clear, then there should be a description here.
     *
     * @param cabinsSourceDisconnectionTriggerInfo The value which will be set
     */
    inline void setCabinsSourceDisconnectionTriggerInfo (const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo_);

    static const CabinsSourceDisconnectionTriggerSignal &getDefaultInstance();

private:

    static const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& getCabinSourceDisconnectionTriggerInfoHolderList_DefaultInstance ();

    inline void set_has_cabinsSourceDisconnectionTriggerInfo ();

    inline void clear_has_cabinsSourceDisconnectionTriggerInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< CabinSourceDisconnectionTriggerInfoHolder > _cabinsSourceDisconnectionTriggerInfo;

};

/**
 * Signal to trigger AV source restoration
 */
class RestoreAVSourceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestoreAVSourceSignal ();

    /**
     * Copy constructor
     */
    inline  RestoreAVSourceSignal (const RestoreAVSourceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreAVSourceSignal (uint32 cabinId_, int16 sourceId_);

    /**
     * Destructor
     */
    inline virtual  ~RestoreAVSourceSignal();

    /**
     * Assignment operator
     */
    inline RestoreAVSourceSignal& operator = (const RestoreAVSourceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreAVSourceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreAVSourceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreAVSourceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreAVSourceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cabinId"

    static const int kCabinId = 0;

    /**
     * Clears the field "cabinId".
     *
     * The field will be set to its default value. The hasCabinId()
     * method will return false.
     */
    inline void clearCabinId();

    /**
     * Checks whether the field "cabinId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinId()). Otherwise it will return false.
     */
    inline bool hasCabinId () const;

    /**
     * Returns the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cabinId"
     */
    inline uint32 getCabinId () const;

    /**
     * Sets the value of the member "cabinId".
     *
     * If the meaning of "cabinId" isn't clear, then there should be a description here.
     *
     * @param cabinId The value which will be set
     */
    inline void setCabinId (uint32 cabinId_);

    // API of field "sourceId"

    static const int kSourceId = 1;

    /**
     * Clears the field "sourceId".
     *
     * The field will be set to its default value. The hasSourceId()
     * method will return false.
     */
    inline void clearSourceId();

    /**
     * Checks whether the field "sourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceId()). Otherwise it will return false.
     */
    inline bool hasSourceId () const;

    /**
     * Returns the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceId"
     */
    inline int16 getSourceId () const;

    /**
     * Sets the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @param sourceId The value which will be set
     */
    inline void setSourceId (int16 sourceId_);

    static const RestoreAVSourceSignal &getDefaultInstance();

private:

    inline void set_has_cabinId ();

    inline void clear_has_cabinId ();

    inline void set_has_sourceId ();

    inline void clear_has_sourceId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _cabinId;

    int16 _sourceId;

};

inline  MapOutStatusInfo::MapOutStatusInfo ()  :
    _glassId (0u),
    _activeStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapOutStatusInfo::MapOutStatusInfo (const MapOutStatusInfo &rhs)  :
    _glassId (0u),
    _activeStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapOutStatusInfo::MapOutStatusInfo (uint32 glassId_, bool activeStatus_)  :
    _glassId (glassId_),
    _activeStatus (activeStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapOutStatusInfo::~MapOutStatusInfo() {
}

inline MapOutStatusInfo& MapOutStatusInfo::operator = (const MapOutStatusInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGlassId()) {
            setGlassId(rhs.getGlassId());
        } else {
            clearGlassId();
        }
        if (rhs.hasActiveStatus()) {
            setActiveStatus(rhs.getActiveStatus());
        } else {
            clearActiveStatus();
        }
    }
    return *this;
}

inline bool MapOutStatusInfo::operator == (const MapOutStatusInfo& rhs) const {
    return (((!hasGlassId() && !rhs.hasGlassId()) || getGlassId() == rhs.getGlassId()) &&
        ((!hasActiveStatus() && !rhs.hasActiveStatus()) || getActiveStatus() == rhs.getActiveStatus()));
}

inline bool MapOutStatusInfo::operator != (const MapOutStatusInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool MapOutStatusInfo::operator < (const MapOutStatusInfo& rhs) const {
    if (hasGlassId() || rhs.hasGlassId()) {
        if (getGlassId() < rhs.getGlassId()) return true;
        if (getGlassId() > rhs.getGlassId()) return false;
    }
    if (hasActiveStatus() || rhs.hasActiveStatus()) {
        if (getActiveStatus() < rhs.getActiveStatus()) return true;
        if (getActiveStatus() > rhs.getActiveStatus()) return false;
    }
    return false;
}

inline bool MapOutStatusInfo::operator > (const MapOutStatusInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapOutStatusInfo::clear() {
    clearGlassId();
    clearActiveStatus();
}

inline void MapOutStatusInfo::clearGlassId() {
    if (hasGlassId()) {
         clear_has_glassId();
        _glassId = 0u;
     }
}

inline bool MapOutStatusInfo::hasGlassId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 MapOutStatusInfo::getGlassId () const {
    return _glassId;
}

inline void MapOutStatusInfo::setGlassId (uint32 glassId_) {
    set_has_glassId();
    this->_glassId = glassId_;
}

inline void MapOutStatusInfo::clearActiveStatus() {
    if (hasActiveStatus()) {
         clear_has_activeStatus();
        _activeStatus = false;
     }
}

inline bool MapOutStatusInfo::hasActiveStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool MapOutStatusInfo::getActiveStatus () const {
    return _activeStatus;
}

inline void MapOutStatusInfo::setActiveStatus (bool activeStatus_) {
    set_has_activeStatus();
    this->_activeStatus = activeStatus_;
}

inline void MapOutStatusInfo::set_has_glassId () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapOutStatusInfo::clear_has_glassId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MapOutStatusInfo::set_has_activeStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void MapOutStatusInfo::clear_has_activeStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegionMapOutStatusInfo::RegionMapOutStatusInfo ()  :
    _regionId (0u),
    _mapOutStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegionMapOutStatusInfo::RegionMapOutStatusInfo (const RegionMapOutStatusInfo &rhs)  :
    _regionId (0u),
    _mapOutStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegionMapOutStatusInfo::RegionMapOutStatusInfo (uint32 regionId_, const ::std::vector< MapOutStatusInfo >& mapOutStatusInfo_)  :
    _regionId (regionId_),
    _mapOutStatusInfo (mapOutStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegionMapOutStatusInfo::~RegionMapOutStatusInfo() {
}

inline RegionMapOutStatusInfo& RegionMapOutStatusInfo::operator = (const RegionMapOutStatusInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasMapOutStatusInfo()) {
            setMapOutStatusInfo(rhs.getMapOutStatusInfo());
        } else {
            clearMapOutStatusInfo();
        }
    }
    return *this;
}

inline bool RegionMapOutStatusInfo::operator == (const RegionMapOutStatusInfo& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasMapOutStatusInfo() && !rhs.hasMapOutStatusInfo()) || getMapOutStatusInfo() == rhs.getMapOutStatusInfo()));
}

inline bool RegionMapOutStatusInfo::operator != (const RegionMapOutStatusInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool RegionMapOutStatusInfo::operator < (const RegionMapOutStatusInfo& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasMapOutStatusInfo() || rhs.hasMapOutStatusInfo()) {
        if (getMapOutStatusInfo() < rhs.getMapOutStatusInfo()) return true;
        if (getMapOutStatusInfo() > rhs.getMapOutStatusInfo()) return false;
    }
    return false;
}

inline bool RegionMapOutStatusInfo::operator > (const RegionMapOutStatusInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegionMapOutStatusInfo::clear() {
    clearRegionId();
    clearMapOutStatusInfo();
}

inline void RegionMapOutStatusInfo::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool RegionMapOutStatusInfo::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RegionMapOutStatusInfo::getRegionId () const {
    return _regionId;
}

inline void RegionMapOutStatusInfo::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void RegionMapOutStatusInfo::clearMapOutStatusInfo() {
    if (hasMapOutStatusInfo()) {
         clear_has_mapOutStatusInfo();
        _mapOutStatusInfo.clear();
     }
}

inline bool RegionMapOutStatusInfo::hasMapOutStatusInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< MapOutStatusInfo >& RegionMapOutStatusInfo::getMapOutStatusInfo () const {
    return _mapOutStatusInfo;
}

inline ::std::vector< MapOutStatusInfo >& RegionMapOutStatusInfo::getMapOutStatusInfoMutable () {
    set_has_mapOutStatusInfo();
    return _mapOutStatusInfo;
}

inline void RegionMapOutStatusInfo::setMapOutStatusInfo (const ::std::vector< MapOutStatusInfo >& mapOutStatusInfo_) {
    set_has_mapOutStatusInfo();
    this->_mapOutStatusInfo = mapOutStatusInfo_;
}

inline void RegionMapOutStatusInfo::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegionMapOutStatusInfo::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegionMapOutStatusInfo::set_has_mapOutStatusInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegionMapOutStatusInfo::clear_has_mapOutStatusInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceInfoHolder::SourceInfoHolder ()  :
    _sourceId (0),
    _sinkId (0),
    _sourceState (0u),
    _subSourceId (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceInfoHolder::SourceInfoHolder (const SourceInfoHolder &rhs)  :
    _sourceId (0),
    _sinkId (0),
    _sourceState (0u),
    _subSourceId (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceInfoHolder::SourceInfoHolder (int16 sourceId_, int16 sinkId_, uint8 sourceState_, uint32 subSourceId_, uint8 status_)  :
    _sourceId (sourceId_),
    _sinkId (sinkId_),
    _sourceState (sourceState_),
    _subSourceId (subSourceId_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceInfoHolder::~SourceInfoHolder() {
}

inline SourceInfoHolder& SourceInfoHolder::operator = (const SourceInfoHolder& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSourceId()) {
            setSourceId(rhs.getSourceId());
        } else {
            clearSourceId();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
        if (rhs.hasSourceState()) {
            setSourceState(rhs.getSourceState());
        } else {
            clearSourceState();
        }
        if (rhs.hasSubSourceId()) {
            setSubSourceId(rhs.getSubSourceId());
        } else {
            clearSubSourceId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SourceInfoHolder::operator == (const SourceInfoHolder& rhs) const {
    return (((!hasSourceId() && !rhs.hasSourceId()) || getSourceId() == rhs.getSourceId()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()) &&
        ((!hasSourceState() && !rhs.hasSourceState()) || getSourceState() == rhs.getSourceState()) &&
        ((!hasSubSourceId() && !rhs.hasSubSourceId()) || getSubSourceId() == rhs.getSubSourceId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SourceInfoHolder::operator != (const SourceInfoHolder& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceInfoHolder::operator < (const SourceInfoHolder& rhs) const {
    if (hasSourceId() || rhs.hasSourceId()) {
        if (getSourceId() < rhs.getSourceId()) return true;
        if (getSourceId() > rhs.getSourceId()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    if (hasSourceState() || rhs.hasSourceState()) {
        if (getSourceState() < rhs.getSourceState()) return true;
        if (getSourceState() > rhs.getSourceState()) return false;
    }
    if (hasSubSourceId() || rhs.hasSubSourceId()) {
        if (getSubSourceId() < rhs.getSubSourceId()) return true;
        if (getSubSourceId() > rhs.getSubSourceId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool SourceInfoHolder::operator > (const SourceInfoHolder& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceInfoHolder::clear() {
    clearSourceId();
    clearSinkId();
    clearSourceState();
    clearSubSourceId();
    clearStatus();
}

inline void SourceInfoHolder::clearSourceId() {
    if (hasSourceId()) {
         clear_has_sourceId();
        _sourceId = 0;
     }
}

inline bool SourceInfoHolder::hasSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SourceInfoHolder::getSourceId () const {
    return _sourceId;
}

inline void SourceInfoHolder::setSourceId (int16 sourceId_) {
    set_has_sourceId();
    this->_sourceId = sourceId_;
}

inline void SourceInfoHolder::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0;
     }
}

inline bool SourceInfoHolder::hasSinkId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SourceInfoHolder::getSinkId () const {
    return _sinkId;
}

inline void SourceInfoHolder::setSinkId (int16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void SourceInfoHolder::clearSourceState() {
    if (hasSourceState()) {
         clear_has_sourceState();
        _sourceState = 0u;
     }
}

inline bool SourceInfoHolder::hasSourceState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 SourceInfoHolder::getSourceState () const {
    return _sourceState;
}

inline void SourceInfoHolder::setSourceState (uint8 sourceState_) {
    set_has_sourceState();
    this->_sourceState = sourceState_;
}

inline void SourceInfoHolder::clearSubSourceId() {
    if (hasSubSourceId()) {
         clear_has_subSourceId();
        _subSourceId = 0u;
     }
}

inline bool SourceInfoHolder::hasSubSourceId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 SourceInfoHolder::getSubSourceId () const {
    return _subSourceId;
}

inline void SourceInfoHolder::setSubSourceId (uint32 subSourceId_) {
    set_has_subSourceId();
    this->_subSourceId = subSourceId_;
}

inline void SourceInfoHolder::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool SourceInfoHolder::hasStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 SourceInfoHolder::getStatus () const {
    return _status;
}

inline void SourceInfoHolder::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void SourceInfoHolder::set_has_sourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceInfoHolder::clear_has_sourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceInfoHolder::set_has_sinkId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceInfoHolder::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SourceInfoHolder::set_has_sourceState () {
    _has_bits_[0] |= 1u << 2;
}

inline void SourceInfoHolder::clear_has_sourceState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SourceInfoHolder::set_has_subSourceId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SourceInfoHolder::clear_has_subSourceId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SourceInfoHolder::set_has_status () {
    _has_bits_[0] |= 1u << 4;
}

inline void SourceInfoHolder::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  CabinSourceDisconnectionTriggerInfoHolder::CabinSourceDisconnectionTriggerInfoHolder ()  :
    _cabinId (0u),
    _spmHMIState (0u),
    _subErrorType (0u),
    _sourcesInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinSourceDisconnectionTriggerInfoHolder::CabinSourceDisconnectionTriggerInfoHolder (const CabinSourceDisconnectionTriggerInfoHolder &rhs)  :
    _cabinId (0u),
    _spmHMIState (0u),
    _subErrorType (0u),
    _sourcesInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinSourceDisconnectionTriggerInfoHolder::CabinSourceDisconnectionTriggerInfoHolder (uint32 cabinId_, uint32 spmHMIState_, uint32 subErrorType_, const ::std::vector< SourceInfoHolder >& sourcesInfo_)  :
    _cabinId (cabinId_),
    _spmHMIState (spmHMIState_),
    _subErrorType (subErrorType_),
    _sourcesInfo (sourcesInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinSourceDisconnectionTriggerInfoHolder::~CabinSourceDisconnectionTriggerInfoHolder() {
}

inline CabinSourceDisconnectionTriggerInfoHolder& CabinSourceDisconnectionTriggerInfoHolder::operator = (const CabinSourceDisconnectionTriggerInfoHolder& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCabinId()) {
            setCabinId(rhs.getCabinId());
        } else {
            clearCabinId();
        }
        if (rhs.hasSpmHMIState()) {
            setSpmHMIState(rhs.getSpmHMIState());
        } else {
            clearSpmHMIState();
        }
        if (rhs.hasSubErrorType()) {
            setSubErrorType(rhs.getSubErrorType());
        } else {
            clearSubErrorType();
        }
        if (rhs.hasSourcesInfo()) {
            setSourcesInfo(rhs.getSourcesInfo());
        } else {
            clearSourcesInfo();
        }
    }
    return *this;
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::operator == (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const {
    return (((!hasCabinId() && !rhs.hasCabinId()) || getCabinId() == rhs.getCabinId()) &&
        ((!hasSpmHMIState() && !rhs.hasSpmHMIState()) || getSpmHMIState() == rhs.getSpmHMIState()) &&
        ((!hasSubErrorType() && !rhs.hasSubErrorType()) || getSubErrorType() == rhs.getSubErrorType()) &&
        ((!hasSourcesInfo() && !rhs.hasSourcesInfo()) || getSourcesInfo() == rhs.getSourcesInfo()));
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::operator != (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::operator < (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const {
    if (hasCabinId() || rhs.hasCabinId()) {
        if (getCabinId() < rhs.getCabinId()) return true;
        if (getCabinId() > rhs.getCabinId()) return false;
    }
    if (hasSpmHMIState() || rhs.hasSpmHMIState()) {
        if (getSpmHMIState() < rhs.getSpmHMIState()) return true;
        if (getSpmHMIState() > rhs.getSpmHMIState()) return false;
    }
    if (hasSubErrorType() || rhs.hasSubErrorType()) {
        if (getSubErrorType() < rhs.getSubErrorType()) return true;
        if (getSubErrorType() > rhs.getSubErrorType()) return false;
    }
    if (hasSourcesInfo() || rhs.hasSourcesInfo()) {
        if (getSourcesInfo() < rhs.getSourcesInfo()) return true;
        if (getSourcesInfo() > rhs.getSourcesInfo()) return false;
    }
    return false;
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::operator > (const CabinSourceDisconnectionTriggerInfoHolder& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clear() {
    clearCabinId();
    clearSpmHMIState();
    clearSubErrorType();
    clearSourcesInfo();
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clearCabinId() {
    if (hasCabinId()) {
         clear_has_cabinId();
        _cabinId = 0u;
     }
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::hasCabinId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CabinSourceDisconnectionTriggerInfoHolder::getCabinId () const {
    return _cabinId;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::setCabinId (uint32 cabinId_) {
    set_has_cabinId();
    this->_cabinId = cabinId_;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clearSpmHMIState() {
    if (hasSpmHMIState()) {
         clear_has_spmHMIState();
        _spmHMIState = 0u;
     }
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::hasSpmHMIState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 CabinSourceDisconnectionTriggerInfoHolder::getSpmHMIState () const {
    return _spmHMIState;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::setSpmHMIState (uint32 spmHMIState_) {
    set_has_spmHMIState();
    this->_spmHMIState = spmHMIState_;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clearSubErrorType() {
    if (hasSubErrorType()) {
         clear_has_subErrorType();
        _subErrorType = 0u;
     }
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::hasSubErrorType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 CabinSourceDisconnectionTriggerInfoHolder::getSubErrorType () const {
    return _subErrorType;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::setSubErrorType (uint32 subErrorType_) {
    set_has_subErrorType();
    this->_subErrorType = subErrorType_;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clearSourcesInfo() {
    if (hasSourcesInfo()) {
         clear_has_sourcesInfo();
        _sourcesInfo.clear();
     }
}

inline bool CabinSourceDisconnectionTriggerInfoHolder::hasSourcesInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< SourceInfoHolder >& CabinSourceDisconnectionTriggerInfoHolder::getSourcesInfo () const {
    return _sourcesInfo;
}

inline ::std::vector< SourceInfoHolder >& CabinSourceDisconnectionTriggerInfoHolder::getSourcesInfoMutable () {
    set_has_sourcesInfo();
    return _sourcesInfo;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::setSourcesInfo (const ::std::vector< SourceInfoHolder >& sourcesInfo_) {
    set_has_sourcesInfo();
    this->_sourcesInfo = sourcesInfo_;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::set_has_cabinId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clear_has_cabinId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CabinSourceDisconnectionTriggerInfoHolder::set_has_spmHMIState () {
    _has_bits_[0] |= 1u << 1;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clear_has_spmHMIState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CabinSourceDisconnectionTriggerInfoHolder::set_has_subErrorType () {
    _has_bits_[0] |= 1u << 2;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clear_has_subErrorType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CabinSourceDisconnectionTriggerInfoHolder::set_has_sourcesInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void CabinSourceDisconnectionTriggerInfoHolder::clear_has_sourcesInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CabinSourceRestorationInfo::CabinSourceRestorationInfo ()  :
    _cabinId (0u),
    _status (0u),
    _lastActiveSourcesInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinSourceRestorationInfo::CabinSourceRestorationInfo (const CabinSourceRestorationInfo &rhs)  :
    _cabinId (0u),
    _status (0u),
    _lastActiveSourcesInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinSourceRestorationInfo::CabinSourceRestorationInfo (uint32 cabinId_, uint8 status_, const ::std::vector< SourceInfoHolder >& lastActiveSourcesInfo_)  :
    _cabinId (cabinId_),
    _status (status_),
    _lastActiveSourcesInfo (lastActiveSourcesInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinSourceRestorationInfo::~CabinSourceRestorationInfo() {
}

inline CabinSourceRestorationInfo& CabinSourceRestorationInfo::operator = (const CabinSourceRestorationInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCabinId()) {
            setCabinId(rhs.getCabinId());
        } else {
            clearCabinId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasLastActiveSourcesInfo()) {
            setLastActiveSourcesInfo(rhs.getLastActiveSourcesInfo());
        } else {
            clearLastActiveSourcesInfo();
        }
    }
    return *this;
}

inline bool CabinSourceRestorationInfo::operator == (const CabinSourceRestorationInfo& rhs) const {
    return (((!hasCabinId() && !rhs.hasCabinId()) || getCabinId() == rhs.getCabinId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasLastActiveSourcesInfo() && !rhs.hasLastActiveSourcesInfo()) || getLastActiveSourcesInfo() == rhs.getLastActiveSourcesInfo()));
}

inline bool CabinSourceRestorationInfo::operator != (const CabinSourceRestorationInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinSourceRestorationInfo::operator < (const CabinSourceRestorationInfo& rhs) const {
    if (hasCabinId() || rhs.hasCabinId()) {
        if (getCabinId() < rhs.getCabinId()) return true;
        if (getCabinId() > rhs.getCabinId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasLastActiveSourcesInfo() || rhs.hasLastActiveSourcesInfo()) {
        if (getLastActiveSourcesInfo() < rhs.getLastActiveSourcesInfo()) return true;
        if (getLastActiveSourcesInfo() > rhs.getLastActiveSourcesInfo()) return false;
    }
    return false;
}

inline bool CabinSourceRestorationInfo::operator > (const CabinSourceRestorationInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinSourceRestorationInfo::clear() {
    clearCabinId();
    clearStatus();
    clearLastActiveSourcesInfo();
}

inline void CabinSourceRestorationInfo::clearCabinId() {
    if (hasCabinId()) {
         clear_has_cabinId();
        _cabinId = 0u;
     }
}

inline bool CabinSourceRestorationInfo::hasCabinId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CabinSourceRestorationInfo::getCabinId () const {
    return _cabinId;
}

inline void CabinSourceRestorationInfo::setCabinId (uint32 cabinId_) {
    set_has_cabinId();
    this->_cabinId = cabinId_;
}

inline void CabinSourceRestorationInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool CabinSourceRestorationInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 CabinSourceRestorationInfo::getStatus () const {
    return _status;
}

inline void CabinSourceRestorationInfo::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void CabinSourceRestorationInfo::clearLastActiveSourcesInfo() {
    if (hasLastActiveSourcesInfo()) {
         clear_has_lastActiveSourcesInfo();
        _lastActiveSourcesInfo.clear();
     }
}

inline bool CabinSourceRestorationInfo::hasLastActiveSourcesInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< SourceInfoHolder >& CabinSourceRestorationInfo::getLastActiveSourcesInfo () const {
    return _lastActiveSourcesInfo;
}

inline ::std::vector< SourceInfoHolder >& CabinSourceRestorationInfo::getLastActiveSourcesInfoMutable () {
    set_has_lastActiveSourcesInfo();
    return _lastActiveSourcesInfo;
}

inline void CabinSourceRestorationInfo::setLastActiveSourcesInfo (const ::std::vector< SourceInfoHolder >& lastActiveSourcesInfo_) {
    set_has_lastActiveSourcesInfo();
    this->_lastActiveSourcesInfo = lastActiveSourcesInfo_;
}

inline void CabinSourceRestorationInfo::set_has_cabinId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinSourceRestorationInfo::clear_has_cabinId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CabinSourceRestorationInfo::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void CabinSourceRestorationInfo::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CabinSourceRestorationInfo::set_has_lastActiveSourcesInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void CabinSourceRestorationInfo::clear_has_lastActiveSourcesInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SystemInfo::SystemInfo ()  :
    _cabinsInfo (),
    _entityId (0u),
    _systemId (0u),
    _systemPosition (0u),
    _systemGroup (0u),
    _systemStatus (0u),
    _avdeccStatus (0u),
    _nanoMsgStatus (0u),
    _systemCategory (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemInfo::SystemInfo (const SystemInfo &rhs)  :
    _cabinsInfo (),
    _entityId (0u),
    _systemId (0u),
    _systemPosition (0u),
    _systemGroup (0u),
    _systemStatus (0u),
    _avdeccStatus (0u),
    _nanoMsgStatus (0u),
    _systemCategory (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemInfo::SystemInfo (const ::std::vector< uint32 >& cabinsInfo_, uint64 entityId_, uint8 systemId_, uint8 systemPosition_, uint8 systemGroup_, uint8 systemStatus_, uint8 avdeccStatus_, uint8 nanoMsgStatus_, uint8 systemCategory_)  :
    _cabinsInfo (cabinsInfo_),
    _entityId (entityId_),
    _systemId (systemId_),
    _systemPosition (systemPosition_),
    _systemGroup (systemGroup_),
    _systemStatus (systemStatus_),
    _avdeccStatus (avdeccStatus_),
    _nanoMsgStatus (nanoMsgStatus_),
    _systemCategory (systemCategory_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemInfo::~SystemInfo() {
}

inline SystemInfo& SystemInfo::operator = (const SystemInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCabinsInfo()) {
            setCabinsInfo(rhs.getCabinsInfo());
        } else {
            clearCabinsInfo();
        }
        if (rhs.hasEntityId()) {
            setEntityId(rhs.getEntityId());
        } else {
            clearEntityId();
        }
        if (rhs.hasSystemId()) {
            setSystemId(rhs.getSystemId());
        } else {
            clearSystemId();
        }
        if (rhs.hasSystemPosition()) {
            setSystemPosition(rhs.getSystemPosition());
        } else {
            clearSystemPosition();
        }
        if (rhs.hasSystemGroup()) {
            setSystemGroup(rhs.getSystemGroup());
        } else {
            clearSystemGroup();
        }
        if (rhs.hasSystemStatus()) {
            setSystemStatus(rhs.getSystemStatus());
        } else {
            clearSystemStatus();
        }
        if (rhs.hasAvdeccStatus()) {
            setAvdeccStatus(rhs.getAvdeccStatus());
        } else {
            clearAvdeccStatus();
        }
        if (rhs.hasNanoMsgStatus()) {
            setNanoMsgStatus(rhs.getNanoMsgStatus());
        } else {
            clearNanoMsgStatus();
        }
        if (rhs.hasSystemCategory()) {
            setSystemCategory(rhs.getSystemCategory());
        } else {
            clearSystemCategory();
        }
    }
    return *this;
}

inline bool SystemInfo::operator == (const SystemInfo& rhs) const {
    return (((!hasCabinsInfo() && !rhs.hasCabinsInfo()) || getCabinsInfo() == rhs.getCabinsInfo()) &&
        ((!hasEntityId() && !rhs.hasEntityId()) || getEntityId() == rhs.getEntityId()) &&
        ((!hasSystemId() && !rhs.hasSystemId()) || getSystemId() == rhs.getSystemId()) &&
        ((!hasSystemPosition() && !rhs.hasSystemPosition()) || getSystemPosition() == rhs.getSystemPosition()) &&
        ((!hasSystemGroup() && !rhs.hasSystemGroup()) || getSystemGroup() == rhs.getSystemGroup()) &&
        ((!hasSystemStatus() && !rhs.hasSystemStatus()) || getSystemStatus() == rhs.getSystemStatus()) &&
        ((!hasAvdeccStatus() && !rhs.hasAvdeccStatus()) || getAvdeccStatus() == rhs.getAvdeccStatus()) &&
        ((!hasNanoMsgStatus() && !rhs.hasNanoMsgStatus()) || getNanoMsgStatus() == rhs.getNanoMsgStatus()) &&
        ((!hasSystemCategory() && !rhs.hasSystemCategory()) || getSystemCategory() == rhs.getSystemCategory()));
}

inline bool SystemInfo::operator != (const SystemInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemInfo::operator < (const SystemInfo& rhs) const {
    if (hasCabinsInfo() || rhs.hasCabinsInfo()) {
        if (getCabinsInfo() < rhs.getCabinsInfo()) return true;
        if (getCabinsInfo() > rhs.getCabinsInfo()) return false;
    }
    if (hasEntityId() || rhs.hasEntityId()) {
        if (getEntityId() < rhs.getEntityId()) return true;
        if (getEntityId() > rhs.getEntityId()) return false;
    }
    if (hasSystemId() || rhs.hasSystemId()) {
        if (getSystemId() < rhs.getSystemId()) return true;
        if (getSystemId() > rhs.getSystemId()) return false;
    }
    if (hasSystemPosition() || rhs.hasSystemPosition()) {
        if (getSystemPosition() < rhs.getSystemPosition()) return true;
        if (getSystemPosition() > rhs.getSystemPosition()) return false;
    }
    if (hasSystemGroup() || rhs.hasSystemGroup()) {
        if (getSystemGroup() < rhs.getSystemGroup()) return true;
        if (getSystemGroup() > rhs.getSystemGroup()) return false;
    }
    if (hasSystemStatus() || rhs.hasSystemStatus()) {
        if (getSystemStatus() < rhs.getSystemStatus()) return true;
        if (getSystemStatus() > rhs.getSystemStatus()) return false;
    }
    if (hasAvdeccStatus() || rhs.hasAvdeccStatus()) {
        if (getAvdeccStatus() < rhs.getAvdeccStatus()) return true;
        if (getAvdeccStatus() > rhs.getAvdeccStatus()) return false;
    }
    if (hasNanoMsgStatus() || rhs.hasNanoMsgStatus()) {
        if (getNanoMsgStatus() < rhs.getNanoMsgStatus()) return true;
        if (getNanoMsgStatus() > rhs.getNanoMsgStatus()) return false;
    }
    if (hasSystemCategory() || rhs.hasSystemCategory()) {
        if (getSystemCategory() < rhs.getSystemCategory()) return true;
        if (getSystemCategory() > rhs.getSystemCategory()) return false;
    }
    return false;
}

inline bool SystemInfo::operator > (const SystemInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemInfo::clear() {
    clearCabinsInfo();
    clearEntityId();
    clearSystemId();
    clearSystemPosition();
    clearSystemGroup();
    clearSystemStatus();
    clearAvdeccStatus();
    clearNanoMsgStatus();
    clearSystemCategory();
}

inline void SystemInfo::clearCabinsInfo() {
    if (hasCabinsInfo()) {
         clear_has_cabinsInfo();
        _cabinsInfo.clear();
     }
}

inline bool SystemInfo::hasCabinsInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint32 >& SystemInfo::getCabinsInfo () const {
    return _cabinsInfo;
}

inline ::std::vector< uint32 >& SystemInfo::getCabinsInfoMutable () {
    set_has_cabinsInfo();
    return _cabinsInfo;
}

inline void SystemInfo::setCabinsInfo (const ::std::vector< uint32 >& cabinsInfo_) {
    set_has_cabinsInfo();
    this->_cabinsInfo = cabinsInfo_;
}

inline void SystemInfo::clearEntityId() {
    if (hasEntityId()) {
         clear_has_entityId();
        _entityId = 0u;
     }
}

inline bool SystemInfo::hasEntityId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 SystemInfo::getEntityId () const {
    return _entityId;
}

inline void SystemInfo::setEntityId (uint64 entityId_) {
    set_has_entityId();
    this->_entityId = entityId_;
}

inline void SystemInfo::clearSystemId() {
    if (hasSystemId()) {
         clear_has_systemId();
        _systemId = 0u;
     }
}

inline bool SystemInfo::hasSystemId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 SystemInfo::getSystemId () const {
    return _systemId;
}

inline void SystemInfo::setSystemId (uint8 systemId_) {
    set_has_systemId();
    this->_systemId = systemId_;
}

inline void SystemInfo::clearSystemPosition() {
    if (hasSystemPosition()) {
         clear_has_systemPosition();
        _systemPosition = 0u;
     }
}

inline bool SystemInfo::hasSystemPosition () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 SystemInfo::getSystemPosition () const {
    return _systemPosition;
}

inline void SystemInfo::setSystemPosition (uint8 systemPosition_) {
    set_has_systemPosition();
    this->_systemPosition = systemPosition_;
}

inline void SystemInfo::clearSystemGroup() {
    if (hasSystemGroup()) {
         clear_has_systemGroup();
        _systemGroup = 0u;
     }
}

inline bool SystemInfo::hasSystemGroup () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 SystemInfo::getSystemGroup () const {
    return _systemGroup;
}

inline void SystemInfo::setSystemGroup (uint8 systemGroup_) {
    set_has_systemGroup();
    this->_systemGroup = systemGroup_;
}

inline void SystemInfo::clearSystemStatus() {
    if (hasSystemStatus()) {
         clear_has_systemStatus();
        _systemStatus = 0u;
     }
}

inline bool SystemInfo::hasSystemStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 SystemInfo::getSystemStatus () const {
    return _systemStatus;
}

inline void SystemInfo::setSystemStatus (uint8 systemStatus_) {
    set_has_systemStatus();
    this->_systemStatus = systemStatus_;
}

inline void SystemInfo::clearAvdeccStatus() {
    if (hasAvdeccStatus()) {
         clear_has_avdeccStatus();
        _avdeccStatus = 0u;
     }
}

inline bool SystemInfo::hasAvdeccStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 SystemInfo::getAvdeccStatus () const {
    return _avdeccStatus;
}

inline void SystemInfo::setAvdeccStatus (uint8 avdeccStatus_) {
    set_has_avdeccStatus();
    this->_avdeccStatus = avdeccStatus_;
}

inline void SystemInfo::clearNanoMsgStatus() {
    if (hasNanoMsgStatus()) {
         clear_has_nanoMsgStatus();
        _nanoMsgStatus = 0u;
     }
}

inline bool SystemInfo::hasNanoMsgStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 SystemInfo::getNanoMsgStatus () const {
    return _nanoMsgStatus;
}

inline void SystemInfo::setNanoMsgStatus (uint8 nanoMsgStatus_) {
    set_has_nanoMsgStatus();
    this->_nanoMsgStatus = nanoMsgStatus_;
}

inline void SystemInfo::clearSystemCategory() {
    if (hasSystemCategory()) {
         clear_has_systemCategory();
        _systemCategory = 0u;
     }
}

inline bool SystemInfo::hasSystemCategory () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 SystemInfo::getSystemCategory () const {
    return _systemCategory;
}

inline void SystemInfo::setSystemCategory (uint8 systemCategory_) {
    set_has_systemCategory();
    this->_systemCategory = systemCategory_;
}

inline void SystemInfo::set_has_cabinsInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemInfo::clear_has_cabinsInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SystemInfo::set_has_entityId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SystemInfo::clear_has_entityId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SystemInfo::set_has_systemId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SystemInfo::clear_has_systemId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SystemInfo::set_has_systemPosition () {
    _has_bits_[0] |= 1u << 3;
}

inline void SystemInfo::clear_has_systemPosition () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SystemInfo::set_has_systemGroup () {
    _has_bits_[0] |= 1u << 4;
}

inline void SystemInfo::clear_has_systemGroup () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SystemInfo::set_has_systemStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void SystemInfo::clear_has_systemStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void SystemInfo::set_has_avdeccStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void SystemInfo::clear_has_avdeccStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void SystemInfo::set_has_nanoMsgStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void SystemInfo::clear_has_nanoMsgStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void SystemInfo::set_has_systemCategory () {
    _has_bits_[0] |= 1u << 8;
}

inline void SystemInfo::clear_has_systemCategory () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  SPIConnectionStatusInfoHolder::SPIConnectionStatusInfoHolder ()  :
    _status (0u),
    _deviceType (0u),
    _deviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SPIConnectionStatusInfoHolder::SPIConnectionStatusInfoHolder (const SPIConnectionStatusInfoHolder &rhs)  :
    _status (0u),
    _deviceType (0u),
    _deviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SPIConnectionStatusInfoHolder::SPIConnectionStatusInfoHolder (uint8 status_, uint8 deviceType_, const ::std::string& deviceName_)  :
    _status (status_),
    _deviceType (deviceType_),
    _deviceName (deviceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SPIConnectionStatusInfoHolder::~SPIConnectionStatusInfoHolder() {
}

inline SPIConnectionStatusInfoHolder& SPIConnectionStatusInfoHolder::operator = (const SPIConnectionStatusInfoHolder& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
    }
    return *this;
}

inline bool SPIConnectionStatusInfoHolder::operator == (const SPIConnectionStatusInfoHolder& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()) &&
        ((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()));
}

inline bool SPIConnectionStatusInfoHolder::operator != (const SPIConnectionStatusInfoHolder& rhs) const {
    return ! (*this == rhs);
}

inline bool SPIConnectionStatusInfoHolder::operator < (const SPIConnectionStatusInfoHolder& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if (getDeviceType() < rhs.getDeviceType()) return true;
        if (getDeviceType() > rhs.getDeviceType()) return false;
    }
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    return false;
}

inline bool SPIConnectionStatusInfoHolder::operator > (const SPIConnectionStatusInfoHolder& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SPIConnectionStatusInfoHolder::clear() {
    clearStatus();
    clearDeviceType();
    clearDeviceName();
}

inline void SPIConnectionStatusInfoHolder::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool SPIConnectionStatusInfoHolder::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SPIConnectionStatusInfoHolder::getStatus () const {
    return _status;
}

inline void SPIConnectionStatusInfoHolder::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void SPIConnectionStatusInfoHolder::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_deviceType();
        _deviceType = 0u;
     }
}

inline bool SPIConnectionStatusInfoHolder::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SPIConnectionStatusInfoHolder::getDeviceType () const {
    return _deviceType;
}

inline void SPIConnectionStatusInfoHolder::setDeviceType (uint8 deviceType_) {
    set_has_deviceType();
    this->_deviceType = deviceType_;
}

inline void SPIConnectionStatusInfoHolder::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_deviceName();
        _deviceName.clear();
     }
}

inline bool SPIConnectionStatusInfoHolder::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SPIConnectionStatusInfoHolder::getDeviceName () const {
    return _deviceName;
}

inline ::std::string& SPIConnectionStatusInfoHolder::getDeviceNameMutable () {
    set_has_deviceName();
    return _deviceName;
}

inline void SPIConnectionStatusInfoHolder::setDeviceName (const ::std::string& deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName = deviceName_;
}

inline void SPIConnectionStatusInfoHolder::setDeviceName (const char* deviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (deviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(deviceName_);
}

inline void SPIConnectionStatusInfoHolder::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_deviceName();
    this->_deviceName.assign(value, size);
}

inline void SPIConnectionStatusInfoHolder::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SPIConnectionStatusInfoHolder::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SPIConnectionStatusInfoHolder::set_has_deviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void SPIConnectionStatusInfoHolder::clear_has_deviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SPIConnectionStatusInfoHolder::set_has_deviceName () {
    _has_bits_[0] |= 1u << 2;
}

inline void SPIConnectionStatusInfoHolder::clear_has_deviceName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CabinSourceConnectionStatusInfo::CabinSourceConnectionStatusInfo ()  :
    _sourceId (0),
    _status (false),
    _userData1 (),
    _userData2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinSourceConnectionStatusInfo::CabinSourceConnectionStatusInfo (const CabinSourceConnectionStatusInfo &rhs)  :
    _sourceId (0),
    _status (false),
    _userData1 (),
    _userData2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinSourceConnectionStatusInfo::CabinSourceConnectionStatusInfo (int16 sourceId_, bool status_, const ::std::string& userData1_, uint32 userData2_)  :
    _sourceId (sourceId_),
    _status (status_),
    _userData1 (userData1_),
    _userData2 (userData2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userData1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinSourceConnectionStatusInfo::~CabinSourceConnectionStatusInfo() {
}

inline CabinSourceConnectionStatusInfo& CabinSourceConnectionStatusInfo::operator = (const CabinSourceConnectionStatusInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSourceId()) {
            setSourceId(rhs.getSourceId());
        } else {
            clearSourceId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasUserData1()) {
            setUserData1(rhs.getUserData1());
        } else {
            clearUserData1();
        }
        if (rhs.hasUserData2()) {
            setUserData2(rhs.getUserData2());
        } else {
            clearUserData2();
        }
    }
    return *this;
}

inline bool CabinSourceConnectionStatusInfo::operator == (const CabinSourceConnectionStatusInfo& rhs) const {
    return (((!hasSourceId() && !rhs.hasSourceId()) || getSourceId() == rhs.getSourceId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasUserData1() && !rhs.hasUserData1()) || getUserData1() == rhs.getUserData1()) &&
        ((!hasUserData2() && !rhs.hasUserData2()) || getUserData2() == rhs.getUserData2()));
}

inline bool CabinSourceConnectionStatusInfo::operator != (const CabinSourceConnectionStatusInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinSourceConnectionStatusInfo::operator < (const CabinSourceConnectionStatusInfo& rhs) const {
    if (hasSourceId() || rhs.hasSourceId()) {
        if (getSourceId() < rhs.getSourceId()) return true;
        if (getSourceId() > rhs.getSourceId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasUserData1() || rhs.hasUserData1()) {
        if (getUserData1() < rhs.getUserData1()) return true;
        if (getUserData1() > rhs.getUserData1()) return false;
    }
    if (hasUserData2() || rhs.hasUserData2()) {
        if (getUserData2() < rhs.getUserData2()) return true;
        if (getUserData2() > rhs.getUserData2()) return false;
    }
    return false;
}

inline bool CabinSourceConnectionStatusInfo::operator > (const CabinSourceConnectionStatusInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinSourceConnectionStatusInfo::clear() {
    clearSourceId();
    clearStatus();
    clearUserData1();
    clearUserData2();
}

inline void CabinSourceConnectionStatusInfo::clearSourceId() {
    if (hasSourceId()) {
         clear_has_sourceId();
        _sourceId = 0;
     }
}

inline bool CabinSourceConnectionStatusInfo::hasSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 CabinSourceConnectionStatusInfo::getSourceId () const {
    return _sourceId;
}

inline void CabinSourceConnectionStatusInfo::setSourceId (int16 sourceId_) {
    set_has_sourceId();
    this->_sourceId = sourceId_;
}

inline void CabinSourceConnectionStatusInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool CabinSourceConnectionStatusInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool CabinSourceConnectionStatusInfo::getStatus () const {
    return _status;
}

inline void CabinSourceConnectionStatusInfo::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void CabinSourceConnectionStatusInfo::clearUserData1() {
    if (hasUserData1()) {
         clear_has_userData1();
        _userData1.clear();
     }
}

inline bool CabinSourceConnectionStatusInfo::hasUserData1 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& CabinSourceConnectionStatusInfo::getUserData1 () const {
    return _userData1;
}

inline ::std::string& CabinSourceConnectionStatusInfo::getUserData1Mutable () {
    set_has_userData1();
    return _userData1;
}

inline void CabinSourceConnectionStatusInfo::setUserData1 (const ::std::string& userData1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userData1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userData1();
    this->_userData1 = userData1_;
}

inline void CabinSourceConnectionStatusInfo::setUserData1 (const char* userData1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userData1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userData1();
    this->_userData1.assign(userData1_);
}

inline void CabinSourceConnectionStatusInfo::setUserData1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userData1();
    this->_userData1.assign(value, size);
}

inline void CabinSourceConnectionStatusInfo::clearUserData2() {
    if (hasUserData2()) {
         clear_has_userData2();
        _userData2 = 0u;
     }
}

inline bool CabinSourceConnectionStatusInfo::hasUserData2 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 CabinSourceConnectionStatusInfo::getUserData2 () const {
    return _userData2;
}

inline void CabinSourceConnectionStatusInfo::setUserData2 (uint32 userData2_) {
    set_has_userData2();
    this->_userData2 = userData2_;
}

inline void CabinSourceConnectionStatusInfo::set_has_sourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinSourceConnectionStatusInfo::clear_has_sourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CabinSourceConnectionStatusInfo::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void CabinSourceConnectionStatusInfo::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CabinSourceConnectionStatusInfo::set_has_userData1 () {
    _has_bits_[0] |= 1u << 2;
}

inline void CabinSourceConnectionStatusInfo::clear_has_userData1 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CabinSourceConnectionStatusInfo::set_has_userData2 () {
    _has_bits_[0] |= 1u << 3;
}

inline void CabinSourceConnectionStatusInfo::clear_has_userData2 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CabinVideoMixInfo::CabinVideoMixInfo ()  :
    _cabinId (0u),
    _reason (0u),
    _videoMixIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinVideoMixInfo::CabinVideoMixInfo (const CabinVideoMixInfo &rhs)  :
    _cabinId (0u),
    _reason (0u),
    _videoMixIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinVideoMixInfo::CabinVideoMixInfo (uint32 cabinId_, uint8 reason_, uint8 videoMixIndex_)  :
    _cabinId (cabinId_),
    _reason (reason_),
    _videoMixIndex (videoMixIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinVideoMixInfo::~CabinVideoMixInfo() {
}

inline CabinVideoMixInfo& CabinVideoMixInfo::operator = (const CabinVideoMixInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCabinId()) {
            setCabinId(rhs.getCabinId());
        } else {
            clearCabinId();
        }
        if (rhs.hasReason()) {
            setReason(rhs.getReason());
        } else {
            clearReason();
        }
        if (rhs.hasVideoMixIndex()) {
            setVideoMixIndex(rhs.getVideoMixIndex());
        } else {
            clearVideoMixIndex();
        }
    }
    return *this;
}

inline bool CabinVideoMixInfo::operator == (const CabinVideoMixInfo& rhs) const {
    return (((!hasCabinId() && !rhs.hasCabinId()) || getCabinId() == rhs.getCabinId()) &&
        ((!hasReason() && !rhs.hasReason()) || getReason() == rhs.getReason()) &&
        ((!hasVideoMixIndex() && !rhs.hasVideoMixIndex()) || getVideoMixIndex() == rhs.getVideoMixIndex()));
}

inline bool CabinVideoMixInfo::operator != (const CabinVideoMixInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinVideoMixInfo::operator < (const CabinVideoMixInfo& rhs) const {
    if (hasCabinId() || rhs.hasCabinId()) {
        if (getCabinId() < rhs.getCabinId()) return true;
        if (getCabinId() > rhs.getCabinId()) return false;
    }
    if (hasReason() || rhs.hasReason()) {
        if (getReason() < rhs.getReason()) return true;
        if (getReason() > rhs.getReason()) return false;
    }
    if (hasVideoMixIndex() || rhs.hasVideoMixIndex()) {
        if (getVideoMixIndex() < rhs.getVideoMixIndex()) return true;
        if (getVideoMixIndex() > rhs.getVideoMixIndex()) return false;
    }
    return false;
}

inline bool CabinVideoMixInfo::operator > (const CabinVideoMixInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinVideoMixInfo::clear() {
    clearCabinId();
    clearReason();
    clearVideoMixIndex();
}

inline void CabinVideoMixInfo::clearCabinId() {
    if (hasCabinId()) {
         clear_has_cabinId();
        _cabinId = 0u;
     }
}

inline bool CabinVideoMixInfo::hasCabinId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CabinVideoMixInfo::getCabinId () const {
    return _cabinId;
}

inline void CabinVideoMixInfo::setCabinId (uint32 cabinId_) {
    set_has_cabinId();
    this->_cabinId = cabinId_;
}

inline void CabinVideoMixInfo::clearReason() {
    if (hasReason()) {
         clear_has_reason();
        _reason = 0u;
     }
}

inline bool CabinVideoMixInfo::hasReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 CabinVideoMixInfo::getReason () const {
    return _reason;
}

inline void CabinVideoMixInfo::setReason (uint8 reason_) {
    set_has_reason();
    this->_reason = reason_;
}

inline void CabinVideoMixInfo::clearVideoMixIndex() {
    if (hasVideoMixIndex()) {
         clear_has_videoMixIndex();
        _videoMixIndex = 0u;
     }
}

inline bool CabinVideoMixInfo::hasVideoMixIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 CabinVideoMixInfo::getVideoMixIndex () const {
    return _videoMixIndex;
}

inline void CabinVideoMixInfo::setVideoMixIndex (uint8 videoMixIndex_) {
    set_has_videoMixIndex();
    this->_videoMixIndex = videoMixIndex_;
}

inline void CabinVideoMixInfo::set_has_cabinId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinVideoMixInfo::clear_has_cabinId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CabinVideoMixInfo::set_has_reason () {
    _has_bits_[0] |= 1u << 1;
}

inline void CabinVideoMixInfo::clear_has_reason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CabinVideoMixInfo::set_has_videoMixIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void CabinVideoMixInfo::clear_has_videoMixIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetRVCSignalStatusResponse::GetRVCSignalStatusResponse ()  :
    _RVCSignalStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRVCSignalStatusResponse::GetRVCSignalStatusResponse (const GetRVCSignalStatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _RVCSignalStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRVCSignalStatusResponse::GetRVCSignalStatusResponse (bool RVCSignalStatus_)  :
    _RVCSignalStatus (RVCSignalStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRVCSignalStatusResponse::~GetRVCSignalStatusResponse() {
}

inline GetRVCSignalStatusResponse& GetRVCSignalStatusResponse::operator = (const GetRVCSignalStatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRVCSignalStatus()) {
            setRVCSignalStatus(rhs.getRVCSignalStatus());
        } else {
            clearRVCSignalStatus();
        }
    }
    return *this;
}

inline bool GetRVCSignalStatusResponse::operator == (const GetRVCSignalStatusResponse& rhs) const {
    return (((!hasRVCSignalStatus() && !rhs.hasRVCSignalStatus()) || getRVCSignalStatus() == rhs.getRVCSignalStatus()));
}

inline bool GetRVCSignalStatusResponse::operator != (const GetRVCSignalStatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRVCSignalStatusResponse::operator < (const GetRVCSignalStatusResponse& rhs) const {
    if (hasRVCSignalStatus() || rhs.hasRVCSignalStatus()) {
        if (getRVCSignalStatus() < rhs.getRVCSignalStatus()) return true;
        if (getRVCSignalStatus() > rhs.getRVCSignalStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRVCSignalStatusResponse::clone() {
    return new GetRVCSignalStatusResponse(*this);
}

inline bool GetRVCSignalStatusResponse::operator > (const GetRVCSignalStatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRVCSignalStatusResponse::clear() {
    clearRVCSignalStatus();
}

inline void GetRVCSignalStatusResponse::clearRVCSignalStatus() {
    if (hasRVCSignalStatus()) {
         clear_has_RVCSignalStatus();
        _RVCSignalStatus = false;
     }
}

inline bool GetRVCSignalStatusResponse::hasRVCSignalStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GetRVCSignalStatusResponse::getRVCSignalStatus () const {
    return _RVCSignalStatus;
}

inline void GetRVCSignalStatusResponse::setRVCSignalStatus (bool RVCSignalStatus_) {
    set_has_RVCSignalStatus();
    this->_RVCSignalStatus = RVCSignalStatus_;
}

inline void GetRVCSignalStatusResponse::set_has_RVCSignalStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRVCSignalStatusResponse::clear_has_RVCSignalStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCurrentForegroundApplicationIdResponse::GetCurrentForegroundApplicationIdResponse ()  :
    _currentForegroundApplicationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCurrentForegroundApplicationIdResponse::GetCurrentForegroundApplicationIdResponse (const GetCurrentForegroundApplicationIdResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _currentForegroundApplicationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCurrentForegroundApplicationIdResponse::GetCurrentForegroundApplicationIdResponse (const ::std::string& currentForegroundApplicationId_)  :
    _currentForegroundApplicationId (currentForegroundApplicationId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (currentForegroundApplicationId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCurrentForegroundApplicationIdResponse::~GetCurrentForegroundApplicationIdResponse() {
}

inline GetCurrentForegroundApplicationIdResponse& GetCurrentForegroundApplicationIdResponse::operator = (const GetCurrentForegroundApplicationIdResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentForegroundApplicationId()) {
            setCurrentForegroundApplicationId(rhs.getCurrentForegroundApplicationId());
        } else {
            clearCurrentForegroundApplicationId();
        }
    }
    return *this;
}

inline bool GetCurrentForegroundApplicationIdResponse::operator == (const GetCurrentForegroundApplicationIdResponse& rhs) const {
    return (((!hasCurrentForegroundApplicationId() && !rhs.hasCurrentForegroundApplicationId()) || getCurrentForegroundApplicationId() == rhs.getCurrentForegroundApplicationId()));
}

inline bool GetCurrentForegroundApplicationIdResponse::operator != (const GetCurrentForegroundApplicationIdResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCurrentForegroundApplicationIdResponse::operator < (const GetCurrentForegroundApplicationIdResponse& rhs) const {
    if (hasCurrentForegroundApplicationId() || rhs.hasCurrentForegroundApplicationId()) {
        if (getCurrentForegroundApplicationId() < rhs.getCurrentForegroundApplicationId()) return true;
        if (getCurrentForegroundApplicationId() > rhs.getCurrentForegroundApplicationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCurrentForegroundApplicationIdResponse::clone() {
    return new GetCurrentForegroundApplicationIdResponse(*this);
}

inline bool GetCurrentForegroundApplicationIdResponse::operator > (const GetCurrentForegroundApplicationIdResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCurrentForegroundApplicationIdResponse::clear() {
    clearCurrentForegroundApplicationId();
}

inline void GetCurrentForegroundApplicationIdResponse::clearCurrentForegroundApplicationId() {
    if (hasCurrentForegroundApplicationId()) {
         clear_has_currentForegroundApplicationId();
        _currentForegroundApplicationId.clear();
     }
}

inline bool GetCurrentForegroundApplicationIdResponse::hasCurrentForegroundApplicationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetCurrentForegroundApplicationIdResponse::getCurrentForegroundApplicationId () const {
    return _currentForegroundApplicationId;
}

inline ::std::string& GetCurrentForegroundApplicationIdResponse::getCurrentForegroundApplicationIdMutable () {
    set_has_currentForegroundApplicationId();
    return _currentForegroundApplicationId;
}

inline void GetCurrentForegroundApplicationIdResponse::setCurrentForegroundApplicationId (const ::std::string& currentForegroundApplicationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (currentForegroundApplicationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_currentForegroundApplicationId();
    this->_currentForegroundApplicationId = currentForegroundApplicationId_;
}

inline void GetCurrentForegroundApplicationIdResponse::setCurrentForegroundApplicationId (const char* currentForegroundApplicationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (currentForegroundApplicationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_currentForegroundApplicationId();
    this->_currentForegroundApplicationId.assign(currentForegroundApplicationId_);
}

inline void GetCurrentForegroundApplicationIdResponse::setCurrentForegroundApplicationId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_currentForegroundApplicationId();
    this->_currentForegroundApplicationId.assign(value, size);
}

inline void GetCurrentForegroundApplicationIdResponse::set_has_currentForegroundApplicationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCurrentForegroundApplicationIdResponse::clear_has_currentForegroundApplicationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ToggleGadgetAudioSourceRequest::ToggleGadgetAudioSourceRequest ()  :
    _regionId (0u),
    _srcApplicationId (0u),
    _destApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ToggleGadgetAudioSourceRequest::ToggleGadgetAudioSourceRequest (const ToggleGadgetAudioSourceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _srcApplicationId (0u),
    _destApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ToggleGadgetAudioSourceRequest::ToggleGadgetAudioSourceRequest (uint32 regionId_, uint8 srcApplicationId_, uint8 destApplicationId_)  :
    _regionId (regionId_),
    _srcApplicationId (srcApplicationId_),
    _destApplicationId (destApplicationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ToggleGadgetAudioSourceRequest::~ToggleGadgetAudioSourceRequest() {
}

inline ToggleGadgetAudioSourceRequest& ToggleGadgetAudioSourceRequest::operator = (const ToggleGadgetAudioSourceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasSrcApplicationId()) {
            setSrcApplicationId(rhs.getSrcApplicationId());
        } else {
            clearSrcApplicationId();
        }
        if (rhs.hasDestApplicationId()) {
            setDestApplicationId(rhs.getDestApplicationId());
        } else {
            clearDestApplicationId();
        }
    }
    return *this;
}

inline bool ToggleGadgetAudioSourceRequest::operator == (const ToggleGadgetAudioSourceRequest& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasSrcApplicationId() && !rhs.hasSrcApplicationId()) || getSrcApplicationId() == rhs.getSrcApplicationId()) &&
        ((!hasDestApplicationId() && !rhs.hasDestApplicationId()) || getDestApplicationId() == rhs.getDestApplicationId()));
}

inline bool ToggleGadgetAudioSourceRequest::operator != (const ToggleGadgetAudioSourceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ToggleGadgetAudioSourceRequest::operator < (const ToggleGadgetAudioSourceRequest& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasSrcApplicationId() || rhs.hasSrcApplicationId()) {
        if (getSrcApplicationId() < rhs.getSrcApplicationId()) return true;
        if (getSrcApplicationId() > rhs.getSrcApplicationId()) return false;
    }
    if (hasDestApplicationId() || rhs.hasDestApplicationId()) {
        if (getDestApplicationId() < rhs.getDestApplicationId()) return true;
        if (getDestApplicationId() > rhs.getDestApplicationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ToggleGadgetAudioSourceRequest::clone() {
    return new ToggleGadgetAudioSourceRequest(*this);
}

inline bool ToggleGadgetAudioSourceRequest::operator > (const ToggleGadgetAudioSourceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ToggleGadgetAudioSourceRequest::clear() {
    clearRegionId();
    clearSrcApplicationId();
    clearDestApplicationId();
}

inline void ToggleGadgetAudioSourceRequest::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequest::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ToggleGadgetAudioSourceRequest::getRegionId () const {
    return _regionId;
}

inline void ToggleGadgetAudioSourceRequest::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void ToggleGadgetAudioSourceRequest::clearSrcApplicationId() {
    if (hasSrcApplicationId()) {
         clear_has_srcApplicationId();
        _srcApplicationId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequest::hasSrcApplicationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ToggleGadgetAudioSourceRequest::getSrcApplicationId () const {
    return _srcApplicationId;
}

inline void ToggleGadgetAudioSourceRequest::setSrcApplicationId (uint8 srcApplicationId_) {
    set_has_srcApplicationId();
    this->_srcApplicationId = srcApplicationId_;
}

inline void ToggleGadgetAudioSourceRequest::clearDestApplicationId() {
    if (hasDestApplicationId()) {
         clear_has_destApplicationId();
        _destApplicationId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequest::hasDestApplicationId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ToggleGadgetAudioSourceRequest::getDestApplicationId () const {
    return _destApplicationId;
}

inline void ToggleGadgetAudioSourceRequest::setDestApplicationId (uint8 destApplicationId_) {
    set_has_destApplicationId();
    this->_destApplicationId = destApplicationId_;
}

inline void ToggleGadgetAudioSourceRequest::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ToggleGadgetAudioSourceRequest::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ToggleGadgetAudioSourceRequest::set_has_srcApplicationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ToggleGadgetAudioSourceRequest::clear_has_srcApplicationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ToggleGadgetAudioSourceRequest::set_has_destApplicationId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ToggleGadgetAudioSourceRequest::clear_has_destApplicationId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetCabinSourceConnectionStatusRequest::SetCabinSourceConnectionStatusRequest ()  :
    _cabinSourcesConnectionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetCabinSourceConnectionStatusRequest::SetCabinSourceConnectionStatusRequest (const SetCabinSourceConnectionStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinSourcesConnectionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetCabinSourceConnectionStatusRequest::SetCabinSourceConnectionStatusRequest (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo_)  :
    _cabinSourcesConnectionStatusInfo (cabinSourcesConnectionStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetCabinSourceConnectionStatusRequest::~SetCabinSourceConnectionStatusRequest() {
}

inline SetCabinSourceConnectionStatusRequest& SetCabinSourceConnectionStatusRequest::operator = (const SetCabinSourceConnectionStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinSourcesConnectionStatusInfo()) {
            setCabinSourcesConnectionStatusInfo(rhs.getCabinSourcesConnectionStatusInfo());
        } else {
            clearCabinSourcesConnectionStatusInfo();
        }
    }
    return *this;
}

inline bool SetCabinSourceConnectionStatusRequest::operator == (const SetCabinSourceConnectionStatusRequest& rhs) const {
    return (((!hasCabinSourcesConnectionStatusInfo() && !rhs.hasCabinSourcesConnectionStatusInfo()) || getCabinSourcesConnectionStatusInfo() == rhs.getCabinSourcesConnectionStatusInfo()));
}

inline bool SetCabinSourceConnectionStatusRequest::operator != (const SetCabinSourceConnectionStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetCabinSourceConnectionStatusRequest::operator < (const SetCabinSourceConnectionStatusRequest& rhs) const {
    if (hasCabinSourcesConnectionStatusInfo() || rhs.hasCabinSourcesConnectionStatusInfo()) {
        if (getCabinSourcesConnectionStatusInfo() < rhs.getCabinSourcesConnectionStatusInfo()) return true;
        if (getCabinSourcesConnectionStatusInfo() > rhs.getCabinSourcesConnectionStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetCabinSourceConnectionStatusRequest::clone() {
    return new SetCabinSourceConnectionStatusRequest(*this);
}

inline bool SetCabinSourceConnectionStatusRequest::operator > (const SetCabinSourceConnectionStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetCabinSourceConnectionStatusRequest::clear() {
    clearCabinSourcesConnectionStatusInfo();
}

inline void SetCabinSourceConnectionStatusRequest::clearCabinSourcesConnectionStatusInfo() {
    if (hasCabinSourcesConnectionStatusInfo()) {
         clear_has_cabinSourcesConnectionStatusInfo();
        _cabinSourcesConnectionStatusInfo.clear();
     }
}

inline bool SetCabinSourceConnectionStatusRequest::hasCabinSourcesConnectionStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CabinSourceConnectionStatusInfo >& SetCabinSourceConnectionStatusRequest::getCabinSourcesConnectionStatusInfo () const {
    return _cabinSourcesConnectionStatusInfo;
}

inline ::std::vector< CabinSourceConnectionStatusInfo >& SetCabinSourceConnectionStatusRequest::getCabinSourcesConnectionStatusInfoMutable () {
    set_has_cabinSourcesConnectionStatusInfo();
    return _cabinSourcesConnectionStatusInfo;
}

inline void SetCabinSourceConnectionStatusRequest::setCabinSourcesConnectionStatusInfo (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo_) {
    set_has_cabinSourcesConnectionStatusInfo();
    this->_cabinSourcesConnectionStatusInfo = cabinSourcesConnectionStatusInfo_;
}

inline void SetCabinSourceConnectionStatusRequest::set_has_cabinSourcesConnectionStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetCabinSourceConnectionStatusRequest::clear_has_cabinSourcesConnectionStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveCabinSourceConnectionRequest::RemoveCabinSourceConnectionRequest ()  :
    _sourcesIdInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveCabinSourceConnectionRequest::RemoveCabinSourceConnectionRequest (const RemoveCabinSourceConnectionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourcesIdInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveCabinSourceConnectionRequest::RemoveCabinSourceConnectionRequest (const ::std::vector< uint32 >& sourcesIdInfo_)  :
    _sourcesIdInfo (sourcesIdInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveCabinSourceConnectionRequest::~RemoveCabinSourceConnectionRequest() {
}

inline RemoveCabinSourceConnectionRequest& RemoveCabinSourceConnectionRequest::operator = (const RemoveCabinSourceConnectionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourcesIdInfo()) {
            setSourcesIdInfo(rhs.getSourcesIdInfo());
        } else {
            clearSourcesIdInfo();
        }
    }
    return *this;
}

inline bool RemoveCabinSourceConnectionRequest::operator == (const RemoveCabinSourceConnectionRequest& rhs) const {
    return (((!hasSourcesIdInfo() && !rhs.hasSourcesIdInfo()) || getSourcesIdInfo() == rhs.getSourcesIdInfo()));
}

inline bool RemoveCabinSourceConnectionRequest::operator != (const RemoveCabinSourceConnectionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveCabinSourceConnectionRequest::operator < (const RemoveCabinSourceConnectionRequest& rhs) const {
    if (hasSourcesIdInfo() || rhs.hasSourcesIdInfo()) {
        if (getSourcesIdInfo() < rhs.getSourcesIdInfo()) return true;
        if (getSourcesIdInfo() > rhs.getSourcesIdInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveCabinSourceConnectionRequest::clone() {
    return new RemoveCabinSourceConnectionRequest(*this);
}

inline bool RemoveCabinSourceConnectionRequest::operator > (const RemoveCabinSourceConnectionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveCabinSourceConnectionRequest::clear() {
    clearSourcesIdInfo();
}

inline void RemoveCabinSourceConnectionRequest::clearSourcesIdInfo() {
    if (hasSourcesIdInfo()) {
         clear_has_sourcesIdInfo();
        _sourcesIdInfo.clear();
     }
}

inline bool RemoveCabinSourceConnectionRequest::hasSourcesIdInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint32 >& RemoveCabinSourceConnectionRequest::getSourcesIdInfo () const {
    return _sourcesIdInfo;
}

inline ::std::vector< uint32 >& RemoveCabinSourceConnectionRequest::getSourcesIdInfoMutable () {
    set_has_sourcesIdInfo();
    return _sourcesIdInfo;
}

inline void RemoveCabinSourceConnectionRequest::setSourcesIdInfo (const ::std::vector< uint32 >& sourcesIdInfo_) {
    set_has_sourcesIdInfo();
    this->_sourcesIdInfo = sourcesIdInfo_;
}

inline void RemoveCabinSourceConnectionRequest::set_has_sourcesIdInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveCabinSourceConnectionRequest::clear_has_sourcesIdInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetCabinVideoMixIndexRequest::SetCabinVideoMixIndexRequest ()  :
    _cabinVideoMixInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetCabinVideoMixIndexRequest::SetCabinVideoMixIndexRequest (const SetCabinVideoMixIndexRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinVideoMixInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetCabinVideoMixIndexRequest::SetCabinVideoMixIndexRequest (const CabinVideoMixInfo& cabinVideoMixInfo_)  :
    _cabinVideoMixInfo (cabinVideoMixInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetCabinVideoMixIndexRequest::~SetCabinVideoMixIndexRequest() {
}

inline SetCabinVideoMixIndexRequest& SetCabinVideoMixIndexRequest::operator = (const SetCabinVideoMixIndexRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinVideoMixInfo()) {
            setCabinVideoMixInfo(rhs.getCabinVideoMixInfo());
        } else {
            clearCabinVideoMixInfo();
        }
    }
    return *this;
}

inline bool SetCabinVideoMixIndexRequest::operator == (const SetCabinVideoMixIndexRequest& rhs) const {
    return (((!hasCabinVideoMixInfo() && !rhs.hasCabinVideoMixInfo()) || getCabinVideoMixInfo() == rhs.getCabinVideoMixInfo()));
}

inline bool SetCabinVideoMixIndexRequest::operator != (const SetCabinVideoMixIndexRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetCabinVideoMixIndexRequest::operator < (const SetCabinVideoMixIndexRequest& rhs) const {
    if (hasCabinVideoMixInfo() || rhs.hasCabinVideoMixInfo()) {
        if (getCabinVideoMixInfo() < rhs.getCabinVideoMixInfo()) return true;
        if (getCabinVideoMixInfo() > rhs.getCabinVideoMixInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetCabinVideoMixIndexRequest::clone() {
    return new SetCabinVideoMixIndexRequest(*this);
}

inline bool SetCabinVideoMixIndexRequest::operator > (const SetCabinVideoMixIndexRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetCabinVideoMixIndexRequest::clear() {
    clearCabinVideoMixInfo();
}

inline void SetCabinVideoMixIndexRequest::clearCabinVideoMixInfo() {
    if (hasCabinVideoMixInfo()) {
         clear_has_cabinVideoMixInfo();
        _cabinVideoMixInfo.clear();
     }
}

inline bool SetCabinVideoMixIndexRequest::hasCabinVideoMixInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const CabinVideoMixInfo& SetCabinVideoMixIndexRequest::getCabinVideoMixInfo () const {
    return _cabinVideoMixInfo;
}

inline CabinVideoMixInfo& SetCabinVideoMixIndexRequest::getCabinVideoMixInfoMutable () {
    set_has_cabinVideoMixInfo();
    return _cabinVideoMixInfo;
}

inline void SetCabinVideoMixIndexRequest::setCabinVideoMixInfo (const CabinVideoMixInfo& cabinVideoMixInfo_) {
    set_has_cabinVideoMixInfo();
    this->_cabinVideoMixInfo = cabinVideoMixInfo_;
}

inline void SetCabinVideoMixIndexRequest::set_has_cabinVideoMixInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetCabinVideoMixIndexRequest::clear_has_cabinVideoMixInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentForegroundApplicationIdUpdate::CurrentForegroundApplicationIdUpdate ()  :
    _currentForegroundApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentForegroundApplicationIdUpdate::CurrentForegroundApplicationIdUpdate (const CurrentForegroundApplicationIdUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _currentForegroundApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentForegroundApplicationIdUpdate::CurrentForegroundApplicationIdUpdate (uint8 currentForegroundApplicationId_)  :
    _currentForegroundApplicationId (currentForegroundApplicationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentForegroundApplicationIdUpdate::~CurrentForegroundApplicationIdUpdate() {
}

inline CurrentForegroundApplicationIdUpdate& CurrentForegroundApplicationIdUpdate::operator = (const CurrentForegroundApplicationIdUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentForegroundApplicationId()) {
            setCurrentForegroundApplicationId(rhs.getCurrentForegroundApplicationId());
        } else {
            clearCurrentForegroundApplicationId();
        }
    }
    return *this;
}

inline bool CurrentForegroundApplicationIdUpdate::operator == (const CurrentForegroundApplicationIdUpdate& rhs) const {
    return (((!hasCurrentForegroundApplicationId() && !rhs.hasCurrentForegroundApplicationId()) || getCurrentForegroundApplicationId() == rhs.getCurrentForegroundApplicationId()));
}

inline bool CurrentForegroundApplicationIdUpdate::operator != (const CurrentForegroundApplicationIdUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentForegroundApplicationIdUpdate::operator < (const CurrentForegroundApplicationIdUpdate& rhs) const {
    if (hasCurrentForegroundApplicationId() || rhs.hasCurrentForegroundApplicationId()) {
        if (getCurrentForegroundApplicationId() < rhs.getCurrentForegroundApplicationId()) return true;
        if (getCurrentForegroundApplicationId() > rhs.getCurrentForegroundApplicationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentForegroundApplicationIdUpdate::clone() {
    return new CurrentForegroundApplicationIdUpdate(*this);
}

inline bool CurrentForegroundApplicationIdUpdate::operator > (const CurrentForegroundApplicationIdUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentForegroundApplicationIdUpdate::clear() {
    clearCurrentForegroundApplicationId();
}

inline void CurrentForegroundApplicationIdUpdate::clearCurrentForegroundApplicationId() {
    if (hasCurrentForegroundApplicationId()) {
         clear_has_currentForegroundApplicationId();
        _currentForegroundApplicationId = 0u;
     }
}

inline bool CurrentForegroundApplicationIdUpdate::hasCurrentForegroundApplicationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CurrentForegroundApplicationIdUpdate::getCurrentForegroundApplicationId () const {
    return _currentForegroundApplicationId;
}

inline void CurrentForegroundApplicationIdUpdate::setCurrentForegroundApplicationId (uint8 currentForegroundApplicationId_) {
    set_has_currentForegroundApplicationId();
    this->_currentForegroundApplicationId = currentForegroundApplicationId_;
}

inline void CurrentForegroundApplicationIdUpdate::set_has_currentForegroundApplicationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentForegroundApplicationIdUpdate::clear_has_currentForegroundApplicationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentForegroundApplicationIdRegister::CurrentForegroundApplicationIdRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentForegroundApplicationIdRegister::CurrentForegroundApplicationIdRegister (const CurrentForegroundApplicationIdRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentForegroundApplicationIdRegister::~CurrentForegroundApplicationIdRegister() {
}

inline CurrentForegroundApplicationIdRegister& CurrentForegroundApplicationIdRegister::operator = (const CurrentForegroundApplicationIdRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CurrentForegroundApplicationIdRegister::operator == (const CurrentForegroundApplicationIdRegister& ) const {
    return true;
}

inline bool CurrentForegroundApplicationIdRegister::operator != (const CurrentForegroundApplicationIdRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentForegroundApplicationIdRegister::operator < (const CurrentForegroundApplicationIdRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CurrentForegroundApplicationIdRegister::clone() {
    return new CurrentForegroundApplicationIdRegister(*this);
}

inline bool CurrentForegroundApplicationIdRegister::operator > (const CurrentForegroundApplicationIdRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentForegroundApplicationIdRegister::clear() {
}

inline  RVCSignalStatusUpdate::RVCSignalStatusUpdate ()  :
    _RVCSignalStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCSignalStatusUpdate::RVCSignalStatusUpdate (const RVCSignalStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RVCSignalStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCSignalStatusUpdate::RVCSignalStatusUpdate (bool RVCSignalStatus_)  :
    _RVCSignalStatus (RVCSignalStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RVCSignalStatusUpdate::~RVCSignalStatusUpdate() {
}

inline RVCSignalStatusUpdate& RVCSignalStatusUpdate::operator = (const RVCSignalStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRVCSignalStatus()) {
            setRVCSignalStatus(rhs.getRVCSignalStatus());
        } else {
            clearRVCSignalStatus();
        }
    }
    return *this;
}

inline bool RVCSignalStatusUpdate::operator == (const RVCSignalStatusUpdate& rhs) const {
    return (((!hasRVCSignalStatus() && !rhs.hasRVCSignalStatus()) || getRVCSignalStatus() == rhs.getRVCSignalStatus()));
}

inline bool RVCSignalStatusUpdate::operator != (const RVCSignalStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCSignalStatusUpdate::operator < (const RVCSignalStatusUpdate& rhs) const {
    if (hasRVCSignalStatus() || rhs.hasRVCSignalStatus()) {
        if (getRVCSignalStatus() < rhs.getRVCSignalStatus()) return true;
        if (getRVCSignalStatus() > rhs.getRVCSignalStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RVCSignalStatusUpdate::clone() {
    return new RVCSignalStatusUpdate(*this);
}

inline bool RVCSignalStatusUpdate::operator > (const RVCSignalStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCSignalStatusUpdate::clear() {
    clearRVCSignalStatus();
}

inline void RVCSignalStatusUpdate::clearRVCSignalStatus() {
    if (hasRVCSignalStatus()) {
         clear_has_RVCSignalStatus();
        _RVCSignalStatus = false;
     }
}

inline bool RVCSignalStatusUpdate::hasRVCSignalStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RVCSignalStatusUpdate::getRVCSignalStatus () const {
    return _RVCSignalStatus;
}

inline void RVCSignalStatusUpdate::setRVCSignalStatus (bool RVCSignalStatus_) {
    set_has_RVCSignalStatus();
    this->_RVCSignalStatus = RVCSignalStatus_;
}

inline void RVCSignalStatusUpdate::set_has_RVCSignalStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RVCSignalStatusUpdate::clear_has_RVCSignalStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RVCSignalStatusRegister::RVCSignalStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCSignalStatusRegister::RVCSignalStatusRegister (const RVCSignalStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCSignalStatusRegister::~RVCSignalStatusRegister() {
}

inline RVCSignalStatusRegister& RVCSignalStatusRegister::operator = (const RVCSignalStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RVCSignalStatusRegister::operator == (const RVCSignalStatusRegister& ) const {
    return true;
}

inline bool RVCSignalStatusRegister::operator != (const RVCSignalStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCSignalStatusRegister::operator < (const RVCSignalStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RVCSignalStatusRegister::clone() {
    return new RVCSignalStatusRegister(*this);
}

inline bool RVCSignalStatusRegister::operator > (const RVCSignalStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCSignalStatusRegister::clear() {
}

inline  RegionsMapOutStatusInfoUpdate::RegionsMapOutStatusInfoUpdate ()  :
    _regionsMapOutStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegionsMapOutStatusInfoUpdate::RegionsMapOutStatusInfoUpdate (const RegionsMapOutStatusInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _regionsMapOutStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegionsMapOutStatusInfoUpdate::RegionsMapOutStatusInfoUpdate (const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo_)  :
    _regionsMapOutStatusInfo (regionsMapOutStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegionsMapOutStatusInfoUpdate::~RegionsMapOutStatusInfoUpdate() {
}

inline RegionsMapOutStatusInfoUpdate& RegionsMapOutStatusInfoUpdate::operator = (const RegionsMapOutStatusInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionsMapOutStatusInfo()) {
            setRegionsMapOutStatusInfo(rhs.getRegionsMapOutStatusInfo());
        } else {
            clearRegionsMapOutStatusInfo();
        }
    }
    return *this;
}

inline bool RegionsMapOutStatusInfoUpdate::operator == (const RegionsMapOutStatusInfoUpdate& rhs) const {
    return (((!hasRegionsMapOutStatusInfo() && !rhs.hasRegionsMapOutStatusInfo()) || getRegionsMapOutStatusInfo() == rhs.getRegionsMapOutStatusInfo()));
}

inline bool RegionsMapOutStatusInfoUpdate::operator != (const RegionsMapOutStatusInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RegionsMapOutStatusInfoUpdate::operator < (const RegionsMapOutStatusInfoUpdate& rhs) const {
    if (hasRegionsMapOutStatusInfo() || rhs.hasRegionsMapOutStatusInfo()) {
        if (getRegionsMapOutStatusInfo() < rhs.getRegionsMapOutStatusInfo()) return true;
        if (getRegionsMapOutStatusInfo() > rhs.getRegionsMapOutStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegionsMapOutStatusInfoUpdate::clone() {
    return new RegionsMapOutStatusInfoUpdate(*this);
}

inline bool RegionsMapOutStatusInfoUpdate::operator > (const RegionsMapOutStatusInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegionsMapOutStatusInfoUpdate::clear() {
    clearRegionsMapOutStatusInfo();
}

inline void RegionsMapOutStatusInfoUpdate::clearRegionsMapOutStatusInfo() {
    if (hasRegionsMapOutStatusInfo()) {
         clear_has_regionsMapOutStatusInfo();
        _regionsMapOutStatusInfo.clear();
     }
}

inline bool RegionsMapOutStatusInfoUpdate::hasRegionsMapOutStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< RegionMapOutStatusInfo >& RegionsMapOutStatusInfoUpdate::getRegionsMapOutStatusInfo () const {
    return _regionsMapOutStatusInfo;
}

inline ::std::vector< RegionMapOutStatusInfo >& RegionsMapOutStatusInfoUpdate::getRegionsMapOutStatusInfoMutable () {
    set_has_regionsMapOutStatusInfo();
    return _regionsMapOutStatusInfo;
}

inline void RegionsMapOutStatusInfoUpdate::setRegionsMapOutStatusInfo (const ::std::vector< RegionMapOutStatusInfo >& regionsMapOutStatusInfo_) {
    set_has_regionsMapOutStatusInfo();
    this->_regionsMapOutStatusInfo = regionsMapOutStatusInfo_;
}

inline void RegionsMapOutStatusInfoUpdate::set_has_regionsMapOutStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegionsMapOutStatusInfoUpdate::clear_has_regionsMapOutStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegionsMapOutStatusInfoRegister::RegionsMapOutStatusInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegionsMapOutStatusInfoRegister::RegionsMapOutStatusInfoRegister (const RegionsMapOutStatusInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegionsMapOutStatusInfoRegister::~RegionsMapOutStatusInfoRegister() {
}

inline RegionsMapOutStatusInfoRegister& RegionsMapOutStatusInfoRegister::operator = (const RegionsMapOutStatusInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RegionsMapOutStatusInfoRegister::operator == (const RegionsMapOutStatusInfoRegister& ) const {
    return true;
}

inline bool RegionsMapOutStatusInfoRegister::operator != (const RegionsMapOutStatusInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RegionsMapOutStatusInfoRegister::operator < (const RegionsMapOutStatusInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RegionsMapOutStatusInfoRegister::clone() {
    return new RegionsMapOutStatusInfoRegister(*this);
}

inline bool RegionsMapOutStatusInfoRegister::operator > (const RegionsMapOutStatusInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegionsMapOutStatusInfoRegister::clear() {
}

inline  CabinsSourceRestorationInfoUpdate::CabinsSourceRestorationInfoUpdate ()  :
    _cabinsSourceRestorationInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsSourceRestorationInfoUpdate::CabinsSourceRestorationInfoUpdate (const CabinsSourceRestorationInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinsSourceRestorationInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsSourceRestorationInfoUpdate::CabinsSourceRestorationInfoUpdate (const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo_)  :
    _cabinsSourceRestorationInfo (cabinsSourceRestorationInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinsSourceRestorationInfoUpdate::~CabinsSourceRestorationInfoUpdate() {
}

inline CabinsSourceRestorationInfoUpdate& CabinsSourceRestorationInfoUpdate::operator = (const CabinsSourceRestorationInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinsSourceRestorationInfo()) {
            setCabinsSourceRestorationInfo(rhs.getCabinsSourceRestorationInfo());
        } else {
            clearCabinsSourceRestorationInfo();
        }
    }
    return *this;
}

inline bool CabinsSourceRestorationInfoUpdate::operator == (const CabinsSourceRestorationInfoUpdate& rhs) const {
    return (((!hasCabinsSourceRestorationInfo() && !rhs.hasCabinsSourceRestorationInfo()) || getCabinsSourceRestorationInfo() == rhs.getCabinsSourceRestorationInfo()));
}

inline bool CabinsSourceRestorationInfoUpdate::operator != (const CabinsSourceRestorationInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsSourceRestorationInfoUpdate::operator < (const CabinsSourceRestorationInfoUpdate& rhs) const {
    if (hasCabinsSourceRestorationInfo() || rhs.hasCabinsSourceRestorationInfo()) {
        if (getCabinsSourceRestorationInfo() < rhs.getCabinsSourceRestorationInfo()) return true;
        if (getCabinsSourceRestorationInfo() > rhs.getCabinsSourceRestorationInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CabinsSourceRestorationInfoUpdate::clone() {
    return new CabinsSourceRestorationInfoUpdate(*this);
}

inline bool CabinsSourceRestorationInfoUpdate::operator > (const CabinsSourceRestorationInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsSourceRestorationInfoUpdate::clear() {
    clearCabinsSourceRestorationInfo();
}

inline void CabinsSourceRestorationInfoUpdate::clearCabinsSourceRestorationInfo() {
    if (hasCabinsSourceRestorationInfo()) {
         clear_has_cabinsSourceRestorationInfo();
        _cabinsSourceRestorationInfo.clear();
     }
}

inline bool CabinsSourceRestorationInfoUpdate::hasCabinsSourceRestorationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CabinSourceRestorationInfo >& CabinsSourceRestorationInfoUpdate::getCabinsSourceRestorationInfo () const {
    return _cabinsSourceRestorationInfo;
}

inline ::std::vector< CabinSourceRestorationInfo >& CabinsSourceRestorationInfoUpdate::getCabinsSourceRestorationInfoMutable () {
    set_has_cabinsSourceRestorationInfo();
    return _cabinsSourceRestorationInfo;
}

inline void CabinsSourceRestorationInfoUpdate::setCabinsSourceRestorationInfo (const ::std::vector< CabinSourceRestorationInfo >& cabinsSourceRestorationInfo_) {
    set_has_cabinsSourceRestorationInfo();
    this->_cabinsSourceRestorationInfo = cabinsSourceRestorationInfo_;
}

inline void CabinsSourceRestorationInfoUpdate::set_has_cabinsSourceRestorationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinsSourceRestorationInfoUpdate::clear_has_cabinsSourceRestorationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CabinsSourceRestorationInfoRegister::CabinsSourceRestorationInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsSourceRestorationInfoRegister::CabinsSourceRestorationInfoRegister (const CabinsSourceRestorationInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsSourceRestorationInfoRegister::~CabinsSourceRestorationInfoRegister() {
}

inline CabinsSourceRestorationInfoRegister& CabinsSourceRestorationInfoRegister::operator = (const CabinsSourceRestorationInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CabinsSourceRestorationInfoRegister::operator == (const CabinsSourceRestorationInfoRegister& ) const {
    return true;
}

inline bool CabinsSourceRestorationInfoRegister::operator != (const CabinsSourceRestorationInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsSourceRestorationInfoRegister::operator < (const CabinsSourceRestorationInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CabinsSourceRestorationInfoRegister::clone() {
    return new CabinsSourceRestorationInfoRegister(*this);
}

inline bool CabinsSourceRestorationInfoRegister::operator > (const CabinsSourceRestorationInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsSourceRestorationInfoRegister::clear() {
}

inline  CabinsSystemsInfoUpdate::CabinsSystemsInfoUpdate ()  :
    _cabinsSystemsInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsSystemsInfoUpdate::CabinsSystemsInfoUpdate (const CabinsSystemsInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinsSystemsInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsSystemsInfoUpdate::CabinsSystemsInfoUpdate (const ::std::vector< SystemInfo >& cabinsSystemsInfo_)  :
    _cabinsSystemsInfo (cabinsSystemsInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinsSystemsInfoUpdate::~CabinsSystemsInfoUpdate() {
}

inline CabinsSystemsInfoUpdate& CabinsSystemsInfoUpdate::operator = (const CabinsSystemsInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinsSystemsInfo()) {
            setCabinsSystemsInfo(rhs.getCabinsSystemsInfo());
        } else {
            clearCabinsSystemsInfo();
        }
    }
    return *this;
}

inline bool CabinsSystemsInfoUpdate::operator == (const CabinsSystemsInfoUpdate& rhs) const {
    return (((!hasCabinsSystemsInfo() && !rhs.hasCabinsSystemsInfo()) || getCabinsSystemsInfo() == rhs.getCabinsSystemsInfo()));
}

inline bool CabinsSystemsInfoUpdate::operator != (const CabinsSystemsInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsSystemsInfoUpdate::operator < (const CabinsSystemsInfoUpdate& rhs) const {
    if (hasCabinsSystemsInfo() || rhs.hasCabinsSystemsInfo()) {
        if (getCabinsSystemsInfo() < rhs.getCabinsSystemsInfo()) return true;
        if (getCabinsSystemsInfo() > rhs.getCabinsSystemsInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CabinsSystemsInfoUpdate::clone() {
    return new CabinsSystemsInfoUpdate(*this);
}

inline bool CabinsSystemsInfoUpdate::operator > (const CabinsSystemsInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsSystemsInfoUpdate::clear() {
    clearCabinsSystemsInfo();
}

inline void CabinsSystemsInfoUpdate::clearCabinsSystemsInfo() {
    if (hasCabinsSystemsInfo()) {
         clear_has_cabinsSystemsInfo();
        _cabinsSystemsInfo.clear();
     }
}

inline bool CabinsSystemsInfoUpdate::hasCabinsSystemsInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SystemInfo >& CabinsSystemsInfoUpdate::getCabinsSystemsInfo () const {
    return _cabinsSystemsInfo;
}

inline ::std::vector< SystemInfo >& CabinsSystemsInfoUpdate::getCabinsSystemsInfoMutable () {
    set_has_cabinsSystemsInfo();
    return _cabinsSystemsInfo;
}

inline void CabinsSystemsInfoUpdate::setCabinsSystemsInfo (const ::std::vector< SystemInfo >& cabinsSystemsInfo_) {
    set_has_cabinsSystemsInfo();
    this->_cabinsSystemsInfo = cabinsSystemsInfo_;
}

inline void CabinsSystemsInfoUpdate::set_has_cabinsSystemsInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinsSystemsInfoUpdate::clear_has_cabinsSystemsInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CabinsSystemsInfoRegister::CabinsSystemsInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsSystemsInfoRegister::CabinsSystemsInfoRegister (const CabinsSystemsInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsSystemsInfoRegister::~CabinsSystemsInfoRegister() {
}

inline CabinsSystemsInfoRegister& CabinsSystemsInfoRegister::operator = (const CabinsSystemsInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CabinsSystemsInfoRegister::operator == (const CabinsSystemsInfoRegister& ) const {
    return true;
}

inline bool CabinsSystemsInfoRegister::operator != (const CabinsSystemsInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsSystemsInfoRegister::operator < (const CabinsSystemsInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CabinsSystemsInfoRegister::clone() {
    return new CabinsSystemsInfoRegister(*this);
}

inline bool CabinsSystemsInfoRegister::operator > (const CabinsSystemsInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsSystemsInfoRegister::clear() {
}

inline  LanguageStatusInfoUpdate::LanguageStatusInfoUpdate ()  :
    _LanguageStatusInfo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LanguageStatusInfoUpdate::LanguageStatusInfoUpdate (const LanguageStatusInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _LanguageStatusInfo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LanguageStatusInfoUpdate::LanguageStatusInfoUpdate (uint32 LanguageStatusInfo_)  :
    _LanguageStatusInfo (LanguageStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LanguageStatusInfoUpdate::~LanguageStatusInfoUpdate() {
}

inline LanguageStatusInfoUpdate& LanguageStatusInfoUpdate::operator = (const LanguageStatusInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLanguageStatusInfo()) {
            setLanguageStatusInfo(rhs.getLanguageStatusInfo());
        } else {
            clearLanguageStatusInfo();
        }
    }
    return *this;
}

inline bool LanguageStatusInfoUpdate::operator == (const LanguageStatusInfoUpdate& rhs) const {
    return (((!hasLanguageStatusInfo() && !rhs.hasLanguageStatusInfo()) || getLanguageStatusInfo() == rhs.getLanguageStatusInfo()));
}

inline bool LanguageStatusInfoUpdate::operator != (const LanguageStatusInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool LanguageStatusInfoUpdate::operator < (const LanguageStatusInfoUpdate& rhs) const {
    if (hasLanguageStatusInfo() || rhs.hasLanguageStatusInfo()) {
        if (getLanguageStatusInfo() < rhs.getLanguageStatusInfo()) return true;
        if (getLanguageStatusInfo() > rhs.getLanguageStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LanguageStatusInfoUpdate::clone() {
    return new LanguageStatusInfoUpdate(*this);
}

inline bool LanguageStatusInfoUpdate::operator > (const LanguageStatusInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LanguageStatusInfoUpdate::clear() {
    clearLanguageStatusInfo();
}

inline void LanguageStatusInfoUpdate::clearLanguageStatusInfo() {
    if (hasLanguageStatusInfo()) {
         clear_has_LanguageStatusInfo();
        _LanguageStatusInfo = 0u;
     }
}

inline bool LanguageStatusInfoUpdate::hasLanguageStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 LanguageStatusInfoUpdate::getLanguageStatusInfo () const {
    return _LanguageStatusInfo;
}

inline void LanguageStatusInfoUpdate::setLanguageStatusInfo (uint32 LanguageStatusInfo_) {
    set_has_LanguageStatusInfo();
    this->_LanguageStatusInfo = LanguageStatusInfo_;
}

inline void LanguageStatusInfoUpdate::set_has_LanguageStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void LanguageStatusInfoUpdate::clear_has_LanguageStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LanguageStatusInfoRegister::LanguageStatusInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LanguageStatusInfoRegister::LanguageStatusInfoRegister (const LanguageStatusInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LanguageStatusInfoRegister::~LanguageStatusInfoRegister() {
}

inline LanguageStatusInfoRegister& LanguageStatusInfoRegister::operator = (const LanguageStatusInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool LanguageStatusInfoRegister::operator == (const LanguageStatusInfoRegister& ) const {
    return true;
}

inline bool LanguageStatusInfoRegister::operator != (const LanguageStatusInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool LanguageStatusInfoRegister::operator < (const LanguageStatusInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* LanguageStatusInfoRegister::clone() {
    return new LanguageStatusInfoRegister(*this);
}

inline bool LanguageStatusInfoRegister::operator > (const LanguageStatusInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LanguageStatusInfoRegister::clear() {
}

inline  SpiConnectionStatusInfoUpdate::SpiConnectionStatusInfoUpdate ()  :
    _spiConnectionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpiConnectionStatusInfoUpdate::SpiConnectionStatusInfoUpdate (const SpiConnectionStatusInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _spiConnectionStatusInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpiConnectionStatusInfoUpdate::SpiConnectionStatusInfoUpdate (const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo_)  :
    _spiConnectionStatusInfo (spiConnectionStatusInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpiConnectionStatusInfoUpdate::~SpiConnectionStatusInfoUpdate() {
}

inline SpiConnectionStatusInfoUpdate& SpiConnectionStatusInfoUpdate::operator = (const SpiConnectionStatusInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpiConnectionStatusInfo()) {
            setSpiConnectionStatusInfo(rhs.getSpiConnectionStatusInfo());
        } else {
            clearSpiConnectionStatusInfo();
        }
    }
    return *this;
}

inline bool SpiConnectionStatusInfoUpdate::operator == (const SpiConnectionStatusInfoUpdate& rhs) const {
    return (((!hasSpiConnectionStatusInfo() && !rhs.hasSpiConnectionStatusInfo()) || getSpiConnectionStatusInfo() == rhs.getSpiConnectionStatusInfo()));
}

inline bool SpiConnectionStatusInfoUpdate::operator != (const SpiConnectionStatusInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SpiConnectionStatusInfoUpdate::operator < (const SpiConnectionStatusInfoUpdate& rhs) const {
    if (hasSpiConnectionStatusInfo() || rhs.hasSpiConnectionStatusInfo()) {
        if (getSpiConnectionStatusInfo() < rhs.getSpiConnectionStatusInfo()) return true;
        if (getSpiConnectionStatusInfo() > rhs.getSpiConnectionStatusInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpiConnectionStatusInfoUpdate::clone() {
    return new SpiConnectionStatusInfoUpdate(*this);
}

inline bool SpiConnectionStatusInfoUpdate::operator > (const SpiConnectionStatusInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpiConnectionStatusInfoUpdate::clear() {
    clearSpiConnectionStatusInfo();
}

inline void SpiConnectionStatusInfoUpdate::clearSpiConnectionStatusInfo() {
    if (hasSpiConnectionStatusInfo()) {
         clear_has_spiConnectionStatusInfo();
        _spiConnectionStatusInfo.clear();
     }
}

inline bool SpiConnectionStatusInfoUpdate::hasSpiConnectionStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SPIConnectionStatusInfoHolder& SpiConnectionStatusInfoUpdate::getSpiConnectionStatusInfo () const {
    return _spiConnectionStatusInfo;
}

inline SPIConnectionStatusInfoHolder& SpiConnectionStatusInfoUpdate::getSpiConnectionStatusInfoMutable () {
    set_has_spiConnectionStatusInfo();
    return _spiConnectionStatusInfo;
}

inline void SpiConnectionStatusInfoUpdate::setSpiConnectionStatusInfo (const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo_) {
    set_has_spiConnectionStatusInfo();
    this->_spiConnectionStatusInfo = spiConnectionStatusInfo_;
}

inline void SpiConnectionStatusInfoUpdate::set_has_spiConnectionStatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpiConnectionStatusInfoUpdate::clear_has_spiConnectionStatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpiConnectionStatusInfoRegister::SpiConnectionStatusInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpiConnectionStatusInfoRegister::SpiConnectionStatusInfoRegister (const SpiConnectionStatusInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpiConnectionStatusInfoRegister::~SpiConnectionStatusInfoRegister() {
}

inline SpiConnectionStatusInfoRegister& SpiConnectionStatusInfoRegister::operator = (const SpiConnectionStatusInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SpiConnectionStatusInfoRegister::operator == (const SpiConnectionStatusInfoRegister& ) const {
    return true;
}

inline bool SpiConnectionStatusInfoRegister::operator != (const SpiConnectionStatusInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SpiConnectionStatusInfoRegister::operator < (const SpiConnectionStatusInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SpiConnectionStatusInfoRegister::clone() {
    return new SpiConnectionStatusInfoRegister(*this);
}

inline bool SpiConnectionStatusInfoRegister::operator > (const SpiConnectionStatusInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpiConnectionStatusInfoRegister::clear() {
}

inline  CabinSourcesConnectionStatusUpdate::CabinSourcesConnectionStatusUpdate ()  :
    _cabinSourcesConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinSourcesConnectionStatusUpdate::CabinSourcesConnectionStatusUpdate (const CabinSourcesConnectionStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinSourcesConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinSourcesConnectionStatusUpdate::CabinSourcesConnectionStatusUpdate (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus_)  :
    _cabinSourcesConnectionStatus (cabinSourcesConnectionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinSourcesConnectionStatusUpdate::~CabinSourcesConnectionStatusUpdate() {
}

inline CabinSourcesConnectionStatusUpdate& CabinSourcesConnectionStatusUpdate::operator = (const CabinSourcesConnectionStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinSourcesConnectionStatus()) {
            setCabinSourcesConnectionStatus(rhs.getCabinSourcesConnectionStatus());
        } else {
            clearCabinSourcesConnectionStatus();
        }
    }
    return *this;
}

inline bool CabinSourcesConnectionStatusUpdate::operator == (const CabinSourcesConnectionStatusUpdate& rhs) const {
    return (((!hasCabinSourcesConnectionStatus() && !rhs.hasCabinSourcesConnectionStatus()) || getCabinSourcesConnectionStatus() == rhs.getCabinSourcesConnectionStatus()));
}

inline bool CabinSourcesConnectionStatusUpdate::operator != (const CabinSourcesConnectionStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinSourcesConnectionStatusUpdate::operator < (const CabinSourcesConnectionStatusUpdate& rhs) const {
    if (hasCabinSourcesConnectionStatus() || rhs.hasCabinSourcesConnectionStatus()) {
        if (getCabinSourcesConnectionStatus() < rhs.getCabinSourcesConnectionStatus()) return true;
        if (getCabinSourcesConnectionStatus() > rhs.getCabinSourcesConnectionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CabinSourcesConnectionStatusUpdate::clone() {
    return new CabinSourcesConnectionStatusUpdate(*this);
}

inline bool CabinSourcesConnectionStatusUpdate::operator > (const CabinSourcesConnectionStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinSourcesConnectionStatusUpdate::clear() {
    clearCabinSourcesConnectionStatus();
}

inline void CabinSourcesConnectionStatusUpdate::clearCabinSourcesConnectionStatus() {
    if (hasCabinSourcesConnectionStatus()) {
         clear_has_cabinSourcesConnectionStatus();
        _cabinSourcesConnectionStatus.clear();
     }
}

inline bool CabinSourcesConnectionStatusUpdate::hasCabinSourcesConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CabinSourceConnectionStatusInfo >& CabinSourcesConnectionStatusUpdate::getCabinSourcesConnectionStatus () const {
    return _cabinSourcesConnectionStatus;
}

inline ::std::vector< CabinSourceConnectionStatusInfo >& CabinSourcesConnectionStatusUpdate::getCabinSourcesConnectionStatusMutable () {
    set_has_cabinSourcesConnectionStatus();
    return _cabinSourcesConnectionStatus;
}

inline void CabinSourcesConnectionStatusUpdate::setCabinSourcesConnectionStatus (const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatus_) {
    set_has_cabinSourcesConnectionStatus();
    this->_cabinSourcesConnectionStatus = cabinSourcesConnectionStatus_;
}

inline void CabinSourcesConnectionStatusUpdate::set_has_cabinSourcesConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinSourcesConnectionStatusUpdate::clear_has_cabinSourcesConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CabinSourcesConnectionStatusRegister::CabinSourcesConnectionStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinSourcesConnectionStatusRegister::CabinSourcesConnectionStatusRegister (const CabinSourcesConnectionStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinSourcesConnectionStatusRegister::~CabinSourcesConnectionStatusRegister() {
}

inline CabinSourcesConnectionStatusRegister& CabinSourcesConnectionStatusRegister::operator = (const CabinSourcesConnectionStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CabinSourcesConnectionStatusRegister::operator == (const CabinSourcesConnectionStatusRegister& ) const {
    return true;
}

inline bool CabinSourcesConnectionStatusRegister::operator != (const CabinSourcesConnectionStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinSourcesConnectionStatusRegister::operator < (const CabinSourcesConnectionStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CabinSourcesConnectionStatusRegister::clone() {
    return new CabinSourcesConnectionStatusRegister(*this);
}

inline bool CabinSourcesConnectionStatusRegister::operator > (const CabinSourcesConnectionStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinSourcesConnectionStatusRegister::clear() {
}

inline  CabinsVideoMixInfoUpdate::CabinsVideoMixInfoUpdate ()  :
    _cabinsVideoMixInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsVideoMixInfoUpdate::CabinsVideoMixInfoUpdate (const CabinsVideoMixInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinsVideoMixInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsVideoMixInfoUpdate::CabinsVideoMixInfoUpdate (const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo_)  :
    _cabinsVideoMixInfo (cabinsVideoMixInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinsVideoMixInfoUpdate::~CabinsVideoMixInfoUpdate() {
}

inline CabinsVideoMixInfoUpdate& CabinsVideoMixInfoUpdate::operator = (const CabinsVideoMixInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinsVideoMixInfo()) {
            setCabinsVideoMixInfo(rhs.getCabinsVideoMixInfo());
        } else {
            clearCabinsVideoMixInfo();
        }
    }
    return *this;
}

inline bool CabinsVideoMixInfoUpdate::operator == (const CabinsVideoMixInfoUpdate& rhs) const {
    return (((!hasCabinsVideoMixInfo() && !rhs.hasCabinsVideoMixInfo()) || getCabinsVideoMixInfo() == rhs.getCabinsVideoMixInfo()));
}

inline bool CabinsVideoMixInfoUpdate::operator != (const CabinsVideoMixInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsVideoMixInfoUpdate::operator < (const CabinsVideoMixInfoUpdate& rhs) const {
    if (hasCabinsVideoMixInfo() || rhs.hasCabinsVideoMixInfo()) {
        if (getCabinsVideoMixInfo() < rhs.getCabinsVideoMixInfo()) return true;
        if (getCabinsVideoMixInfo() > rhs.getCabinsVideoMixInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CabinsVideoMixInfoUpdate::clone() {
    return new CabinsVideoMixInfoUpdate(*this);
}

inline bool CabinsVideoMixInfoUpdate::operator > (const CabinsVideoMixInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsVideoMixInfoUpdate::clear() {
    clearCabinsVideoMixInfo();
}

inline void CabinsVideoMixInfoUpdate::clearCabinsVideoMixInfo() {
    if (hasCabinsVideoMixInfo()) {
         clear_has_cabinsVideoMixInfo();
        _cabinsVideoMixInfo.clear();
     }
}

inline bool CabinsVideoMixInfoUpdate::hasCabinsVideoMixInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CabinVideoMixInfo >& CabinsVideoMixInfoUpdate::getCabinsVideoMixInfo () const {
    return _cabinsVideoMixInfo;
}

inline ::std::vector< CabinVideoMixInfo >& CabinsVideoMixInfoUpdate::getCabinsVideoMixInfoMutable () {
    set_has_cabinsVideoMixInfo();
    return _cabinsVideoMixInfo;
}

inline void CabinsVideoMixInfoUpdate::setCabinsVideoMixInfo (const ::std::vector< CabinVideoMixInfo >& cabinsVideoMixInfo_) {
    set_has_cabinsVideoMixInfo();
    this->_cabinsVideoMixInfo = cabinsVideoMixInfo_;
}

inline void CabinsVideoMixInfoUpdate::set_has_cabinsVideoMixInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinsVideoMixInfoUpdate::clear_has_cabinsVideoMixInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CabinsVideoMixInfoRegister::CabinsVideoMixInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsVideoMixInfoRegister::CabinsVideoMixInfoRegister (const CabinsVideoMixInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsVideoMixInfoRegister::~CabinsVideoMixInfoRegister() {
}

inline CabinsVideoMixInfoRegister& CabinsVideoMixInfoRegister::operator = (const CabinsVideoMixInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CabinsVideoMixInfoRegister::operator == (const CabinsVideoMixInfoRegister& ) const {
    return true;
}

inline bool CabinsVideoMixInfoRegister::operator != (const CabinsVideoMixInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsVideoMixInfoRegister::operator < (const CabinsVideoMixInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CabinsVideoMixInfoRegister::clone() {
    return new CabinsVideoMixInfoRegister(*this);
}

inline bool CabinsVideoMixInfoRegister::operator > (const CabinsVideoMixInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsVideoMixInfoRegister::clear() {
}

inline  ToggleGadgetAudioSourceRequestSignal::ToggleGadgetAudioSourceRequestSignal ()  :
    _regionId (0u),
    _srcApplicationId (0u),
    _destApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ToggleGadgetAudioSourceRequestSignal::ToggleGadgetAudioSourceRequestSignal (const ToggleGadgetAudioSourceRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _srcApplicationId (0u),
    _destApplicationId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ToggleGadgetAudioSourceRequestSignal::ToggleGadgetAudioSourceRequestSignal (uint32 regionId_, uint8 srcApplicationId_, uint8 destApplicationId_)  :
    _regionId (regionId_),
    _srcApplicationId (srcApplicationId_),
    _destApplicationId (destApplicationId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ToggleGadgetAudioSourceRequestSignal::~ToggleGadgetAudioSourceRequestSignal() {
}

inline ToggleGadgetAudioSourceRequestSignal& ToggleGadgetAudioSourceRequestSignal::operator = (const ToggleGadgetAudioSourceRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasSrcApplicationId()) {
            setSrcApplicationId(rhs.getSrcApplicationId());
        } else {
            clearSrcApplicationId();
        }
        if (rhs.hasDestApplicationId()) {
            setDestApplicationId(rhs.getDestApplicationId());
        } else {
            clearDestApplicationId();
        }
    }
    return *this;
}

inline bool ToggleGadgetAudioSourceRequestSignal::operator == (const ToggleGadgetAudioSourceRequestSignal& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasSrcApplicationId() && !rhs.hasSrcApplicationId()) || getSrcApplicationId() == rhs.getSrcApplicationId()) &&
        ((!hasDestApplicationId() && !rhs.hasDestApplicationId()) || getDestApplicationId() == rhs.getDestApplicationId()));
}

inline bool ToggleGadgetAudioSourceRequestSignal::operator != (const ToggleGadgetAudioSourceRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ToggleGadgetAudioSourceRequestSignal::operator < (const ToggleGadgetAudioSourceRequestSignal& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasSrcApplicationId() || rhs.hasSrcApplicationId()) {
        if (getSrcApplicationId() < rhs.getSrcApplicationId()) return true;
        if (getSrcApplicationId() > rhs.getSrcApplicationId()) return false;
    }
    if (hasDestApplicationId() || rhs.hasDestApplicationId()) {
        if (getDestApplicationId() < rhs.getDestApplicationId()) return true;
        if (getDestApplicationId() > rhs.getDestApplicationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ToggleGadgetAudioSourceRequestSignal::clone() {
    return new ToggleGadgetAudioSourceRequestSignal(*this);
}

inline bool ToggleGadgetAudioSourceRequestSignal::operator > (const ToggleGadgetAudioSourceRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ToggleGadgetAudioSourceRequestSignal::clear() {
    clearRegionId();
    clearSrcApplicationId();
    clearDestApplicationId();
}

inline void ToggleGadgetAudioSourceRequestSignal::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequestSignal::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ToggleGadgetAudioSourceRequestSignal::getRegionId () const {
    return _regionId;
}

inline void ToggleGadgetAudioSourceRequestSignal::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void ToggleGadgetAudioSourceRequestSignal::clearSrcApplicationId() {
    if (hasSrcApplicationId()) {
         clear_has_srcApplicationId();
        _srcApplicationId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequestSignal::hasSrcApplicationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ToggleGadgetAudioSourceRequestSignal::getSrcApplicationId () const {
    return _srcApplicationId;
}

inline void ToggleGadgetAudioSourceRequestSignal::setSrcApplicationId (uint8 srcApplicationId_) {
    set_has_srcApplicationId();
    this->_srcApplicationId = srcApplicationId_;
}

inline void ToggleGadgetAudioSourceRequestSignal::clearDestApplicationId() {
    if (hasDestApplicationId()) {
         clear_has_destApplicationId();
        _destApplicationId = 0u;
     }
}

inline bool ToggleGadgetAudioSourceRequestSignal::hasDestApplicationId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ToggleGadgetAudioSourceRequestSignal::getDestApplicationId () const {
    return _destApplicationId;
}

inline void ToggleGadgetAudioSourceRequestSignal::setDestApplicationId (uint8 destApplicationId_) {
    set_has_destApplicationId();
    this->_destApplicationId = destApplicationId_;
}

inline void ToggleGadgetAudioSourceRequestSignal::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ToggleGadgetAudioSourceRequestSignal::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ToggleGadgetAudioSourceRequestSignal::set_has_srcApplicationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ToggleGadgetAudioSourceRequestSignal::clear_has_srcApplicationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ToggleGadgetAudioSourceRequestSignal::set_has_destApplicationId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ToggleGadgetAudioSourceRequestSignal::clear_has_destApplicationId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CabinsSourceDisconnectionTriggerSignal::CabinsSourceDisconnectionTriggerSignal ()  :
    _cabinsSourceDisconnectionTriggerInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CabinsSourceDisconnectionTriggerSignal::CabinsSourceDisconnectionTriggerSignal (const CabinsSourceDisconnectionTriggerSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinsSourceDisconnectionTriggerInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CabinsSourceDisconnectionTriggerSignal::CabinsSourceDisconnectionTriggerSignal (const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo_)  :
    _cabinsSourceDisconnectionTriggerInfo (cabinsSourceDisconnectionTriggerInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CabinsSourceDisconnectionTriggerSignal::~CabinsSourceDisconnectionTriggerSignal() {
}

inline CabinsSourceDisconnectionTriggerSignal& CabinsSourceDisconnectionTriggerSignal::operator = (const CabinsSourceDisconnectionTriggerSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinsSourceDisconnectionTriggerInfo()) {
            setCabinsSourceDisconnectionTriggerInfo(rhs.getCabinsSourceDisconnectionTriggerInfo());
        } else {
            clearCabinsSourceDisconnectionTriggerInfo();
        }
    }
    return *this;
}

inline bool CabinsSourceDisconnectionTriggerSignal::operator == (const CabinsSourceDisconnectionTriggerSignal& rhs) const {
    return (((!hasCabinsSourceDisconnectionTriggerInfo() && !rhs.hasCabinsSourceDisconnectionTriggerInfo()) || getCabinsSourceDisconnectionTriggerInfo() == rhs.getCabinsSourceDisconnectionTriggerInfo()));
}

inline bool CabinsSourceDisconnectionTriggerSignal::operator != (const CabinsSourceDisconnectionTriggerSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool CabinsSourceDisconnectionTriggerSignal::operator < (const CabinsSourceDisconnectionTriggerSignal& rhs) const {
    if (hasCabinsSourceDisconnectionTriggerInfo() || rhs.hasCabinsSourceDisconnectionTriggerInfo()) {
        if (getCabinsSourceDisconnectionTriggerInfo() < rhs.getCabinsSourceDisconnectionTriggerInfo()) return true;
        if (getCabinsSourceDisconnectionTriggerInfo() > rhs.getCabinsSourceDisconnectionTriggerInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CabinsSourceDisconnectionTriggerSignal::clone() {
    return new CabinsSourceDisconnectionTriggerSignal(*this);
}

inline bool CabinsSourceDisconnectionTriggerSignal::operator > (const CabinsSourceDisconnectionTriggerSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CabinsSourceDisconnectionTriggerSignal::clear() {
    clearCabinsSourceDisconnectionTriggerInfo();
}

inline void CabinsSourceDisconnectionTriggerSignal::clearCabinsSourceDisconnectionTriggerInfo() {
    if (hasCabinsSourceDisconnectionTriggerInfo()) {
         clear_has_cabinsSourceDisconnectionTriggerInfo();
        _cabinsSourceDisconnectionTriggerInfo.clear();
     }
}

inline bool CabinsSourceDisconnectionTriggerSignal::hasCabinsSourceDisconnectionTriggerInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& CabinsSourceDisconnectionTriggerSignal::getCabinsSourceDisconnectionTriggerInfo () const {
    return _cabinsSourceDisconnectionTriggerInfo;
}

inline ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& CabinsSourceDisconnectionTriggerSignal::getCabinsSourceDisconnectionTriggerInfoMutable () {
    set_has_cabinsSourceDisconnectionTriggerInfo();
    return _cabinsSourceDisconnectionTriggerInfo;
}

inline void CabinsSourceDisconnectionTriggerSignal::setCabinsSourceDisconnectionTriggerInfo (const ::std::vector< CabinSourceDisconnectionTriggerInfoHolder >& cabinsSourceDisconnectionTriggerInfo_) {
    set_has_cabinsSourceDisconnectionTriggerInfo();
    this->_cabinsSourceDisconnectionTriggerInfo = cabinsSourceDisconnectionTriggerInfo_;
}

inline void CabinsSourceDisconnectionTriggerSignal::set_has_cabinsSourceDisconnectionTriggerInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void CabinsSourceDisconnectionTriggerSignal::clear_has_cabinsSourceDisconnectionTriggerInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreAVSourceSignal::RestoreAVSourceSignal ()  :
    _cabinId (0u),
    _sourceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestoreAVSourceSignal::RestoreAVSourceSignal (const RestoreAVSourceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _cabinId (0u),
    _sourceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestoreAVSourceSignal::RestoreAVSourceSignal (uint32 cabinId_, int16 sourceId_)  :
    _cabinId (cabinId_),
    _sourceId (sourceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestoreAVSourceSignal::~RestoreAVSourceSignal() {
}

inline RestoreAVSourceSignal& RestoreAVSourceSignal::operator = (const RestoreAVSourceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCabinId()) {
            setCabinId(rhs.getCabinId());
        } else {
            clearCabinId();
        }
        if (rhs.hasSourceId()) {
            setSourceId(rhs.getSourceId());
        } else {
            clearSourceId();
        }
    }
    return *this;
}

inline bool RestoreAVSourceSignal::operator == (const RestoreAVSourceSignal& rhs) const {
    return (((!hasCabinId() && !rhs.hasCabinId()) || getCabinId() == rhs.getCabinId()) &&
        ((!hasSourceId() && !rhs.hasSourceId()) || getSourceId() == rhs.getSourceId()));
}

inline bool RestoreAVSourceSignal::operator != (const RestoreAVSourceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreAVSourceSignal::operator < (const RestoreAVSourceSignal& rhs) const {
    if (hasCabinId() || rhs.hasCabinId()) {
        if (getCabinId() < rhs.getCabinId()) return true;
        if (getCabinId() > rhs.getCabinId()) return false;
    }
    if (hasSourceId() || rhs.hasSourceId()) {
        if (getSourceId() < rhs.getSourceId()) return true;
        if (getSourceId() > rhs.getSourceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestoreAVSourceSignal::clone() {
    return new RestoreAVSourceSignal(*this);
}

inline bool RestoreAVSourceSignal::operator > (const RestoreAVSourceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestoreAVSourceSignal::clear() {
    clearCabinId();
    clearSourceId();
}

inline void RestoreAVSourceSignal::clearCabinId() {
    if (hasCabinId()) {
         clear_has_cabinId();
        _cabinId = 0u;
     }
}

inline bool RestoreAVSourceSignal::hasCabinId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RestoreAVSourceSignal::getCabinId () const {
    return _cabinId;
}

inline void RestoreAVSourceSignal::setCabinId (uint32 cabinId_) {
    set_has_cabinId();
    this->_cabinId = cabinId_;
}

inline void RestoreAVSourceSignal::clearSourceId() {
    if (hasSourceId()) {
         clear_has_sourceId();
        _sourceId = 0;
     }
}

inline bool RestoreAVSourceSignal::hasSourceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 RestoreAVSourceSignal::getSourceId () const {
    return _sourceId;
}

inline void RestoreAVSourceSignal::setSourceId (int16 sourceId_) {
    set_has_sourceId();
    this->_sourceId = sourceId_;
}

inline void RestoreAVSourceSignal::set_has_cabinId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestoreAVSourceSignal::clear_has_cabinId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RestoreAVSourceSignal::set_has_sourceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RestoreAVSourceSignal::clear_has_sourceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace HmiInfoService
} // namespace hmiinfoservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
