/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiData.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataDBus.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataJson.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataStub.h"

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmidataservice {
namespace HmiData {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/nissan/hmi/hmidataservice/bosch/cm/ai/nissan/hmi/hmidataservice/HmiData", HmiDataStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "DimmingMode", 1 },
    { 15, "SpeedLockStatus", 0 },
};

class HmiDataStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HmiDataStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HmiDataStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HmiDataStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.nissan.hmi.hmidataservice.HmiData"),
          _logger(logger) {}

    virtual ~HmiDataStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HmiDataStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HmiDataStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.nissan.hmi.hmidataservice.HmiData\">\n"
            "    <property access=\"readwrite\" name=\"SpeedLockStatus\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"DimmingMode\" type=\"y\"/>\n"
            "</interface>\n";
}

void HmiDataStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HmiDataStub*>(getStub()))->onGetAll (properties);
}

void HmiDataStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SpeedLockStatus");
            ::boost::shared_ptr< SpeedLockStatusSet > payload(new SpeedLockStatusSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<HmiDataStub*>(getStub())->onSpeedLockStatusSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DimmingMode");
            ::boost::shared_ptr< DimmingModeSet > payload(new DimmingModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<HmiDataStub*>(getStub())->onDimmingModeSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HmiDataStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SpeedLockStatus");
            ::boost::shared_ptr< SpeedLockStatusGet > payload(new SpeedLockStatusGet());
            payload->setAct(act);
            static_cast<HmiDataStub*>(getStub())->onSpeedLockStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DimmingMode");
            ::boost::shared_ptr< DimmingModeGet > payload(new DimmingModeGet());
            payload->setAct(act);
            static_cast<HmiDataStub*>(getStub())->onDimmingModeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HmiDataStub::HmiDataStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiDataStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiDataStub::HmiDataStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiDataStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiDataStub::~HmiDataStub() {
    delete _stubDelegate;
}

void HmiDataStub::sendSpeedLockStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpeedLockStatusUpdate payload(_SpeedLockStatusProperty);

        LOG_INFO ("-> send%s", "SpeedLockStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SpeedLockStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpeedLockStatusUpdate");
    }
}

void HmiDataStub::onSpeedLockStatusGet(const ::boost::shared_ptr< SpeedLockStatusGet >& speedLockStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeedLockStatusGet", speedLockStatus->getAct());
    sendSpeedLockStatusGetUpdate(_SpeedLockStatusProperty.getSpeedLockStatus(), speedLockStatus->getAct());
}

void HmiDataStub::sendSpeedLockStatusGetUpdate(bool speedLockStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpeedLockStatusGet payload(speedLockStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeedLockStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiDataStub::onSpeedLockStatusSet(const ::boost::shared_ptr< SpeedLockStatusSet >& speedLockStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeedLockStatusSet", speedLockStatus->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*speedLockStatus, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSpeedLockStatus (speedLockStatus->getSpeedLockStatus());
    sendSpeedLockStatusSetUpdate(speedLockStatus->getAct());
}

void HmiDataStub::sendSpeedLockStatusSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeedLockStatusSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void HmiDataStub::setSpeedLockStatus(bool speedLockStatus) {
    if(speedLockStatus!=_SpeedLockStatusProperty.getSpeedLockStatus()) {
        _SpeedLockStatusProperty.setSpeedLockStatus(speedLockStatus);
        sendSpeedLockStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool HmiDataStub::getSpeedLockStatus() const {
    return _SpeedLockStatusProperty.getSpeedLockStatus();
}

void HmiDataStub::sendDimmingModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DimmingModeUpdate payload(_DimmingModeProperty);

        LOG_INFO ("-> send%s", "DimmingModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DimmingMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DimmingModeUpdate");
    }
}

void HmiDataStub::onDimmingModeGet(const ::boost::shared_ptr< DimmingModeGet >& dimmingMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DimmingModeGet", dimmingMode->getAct());
    sendDimmingModeGetUpdate(_DimmingModeProperty.getDimmingMode(), dimmingMode->getAct());
}

void HmiDataStub::sendDimmingModeGetUpdate(uint8 dimmingMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DimmingModeGet payload(dimmingMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DimmingModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiDataStub::onDimmingModeSet(const ::boost::shared_ptr< DimmingModeSet >& dimmingMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DimmingModeSet", dimmingMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*dimmingMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDimmingMode (dimmingMode->getDimmingMode());
    sendDimmingModeSetUpdate(dimmingMode->getAct());
}

void HmiDataStub::sendDimmingModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DimmingModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void HmiDataStub::setDimmingMode(uint8 dimmingMode) {
    if(dimmingMode!=_DimmingModeProperty.getDimmingMode()) {
        _DimmingModeProperty.setDimmingMode(dimmingMode);
        sendDimmingModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 HmiDataStub::getDimmingMode() const {
    return _DimmingModeProperty.getDimmingMode();
}

void HmiDataStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SpeedLockStatus'
    {
        ::asf::dbus::DBusVariant variant;
        SpeedLockStatusGet payload(_SpeedLockStatusProperty.getSpeedLockStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SpeedLockStatus", variant));
    }

    //property 'DimmingMode'
    {
        ::asf::dbus::DBusVariant variant;
        DimmingModeGet payload(_DimmingModeProperty.getDimmingMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DimmingMode", variant));
    }
}

} // namespace HmiData
} // namespace hmidataservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch
