/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiData.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataDBus.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataJson.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmidataservice {
namespace HmiData {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/nissan/hmi/hmidataservice/bosch/cm/ai/nissan/hmi/hmidataservice/HmiData", HmiDataProxy);

class HmiDataProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HmiDataProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HmiDataProxy >& proxyShared = ::boost::static_pointer_cast< HmiDataProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SpeedLockStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedLockStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeedLockStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedLockStatusError> payload = ::boost::static_pointer_cast<SpeedLockStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SpeedLockStatusCallbackIF*) _callback)->onSpeedLockStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedLockStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeedLockStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedLockStatusUpdate> payload = ::boost::static_pointer_cast<SpeedLockStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SpeedLockStatusCallbackIF*) _callback)->onSpeedLockStatusUpdate(proxyShared, payload);
                        proxyShared->_speedLockStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DimmingMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DimmingModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DimmingMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DimmingModeError> payload = ::boost::static_pointer_cast<DimmingModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DimmingModeCallbackIF*) _callback)->onDimmingModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DimmingModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DimmingMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DimmingModeUpdate> payload = ::boost::static_pointer_cast<DimmingModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DimmingModeCallbackIF*) _callback)->onDimmingModeUpdate(proxyShared, payload);
                        proxyShared->_dimmingMode = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SpeedLockStatus: {
                ::boost::shared_ptr< SpeedLockStatusError > payload = ::boost::shared_ptr< SpeedLockStatusError >
                (new SpeedLockStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiData is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeedLockStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiDataProxy> proxyShared = ::boost::static_pointer_cast<HmiDataProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeedLockStatusCallbackIF*) _callback)->onSpeedLockStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DimmingMode: {
                ::boost::shared_ptr< DimmingModeError > payload = ::boost::shared_ptr< DimmingModeError >
                (new DimmingModeError(DBUS_ERROR_NO_SERVER, "The DBus service HmiData is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DimmingMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiDataProxy> proxyShared = ::boost::static_pointer_cast<HmiDataProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DimmingModeCallbackIF*) _callback)->onDimmingModeError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HmiDataProxyCallback::_logger (HmiDataProxy::_logger);

HmiDataProxy::HmiDataProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", serviceAvailable, _logger) {
}

HmiDataProxy::~HmiDataProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HmiDataProxy > HmiDataProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HmiDataProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HmiDataProxy > proxyNew(new HmiDataProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HmiDataProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HmiDataProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiDataProxy::clearAllProperties ()
{
    _speedLockStatus = ::asf::core::nullable< SpeedLockStatusUpdate >();
    _dimmingMode = ::asf::core::nullable< DimmingModeUpdate >();
}

void HmiDataProxy::sendDeregisterAll () const
{
    sendSpeedLockStatusDeregisterAll();
    sendDimmingModeDeregisterAll();
}

act_t HmiDataProxy::sendSpeedLockStatusRegister(SpeedLockStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SpeedLockStatus, "SpeedLockStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpeedLockStatus", &cb, act);
    return act;
}

bool HmiDataProxy::sendSpeedLockStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SpeedLockStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpeedLockStatus", act, static_cast<int>(rv));
    return rv;
}

act_t HmiDataProxy::sendSpeedLockStatusGet(SpeedLockStatusCallbackIF& cb) {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(ID_SpeedLockStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SpeedLockStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SpeedLockStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiDataProxy::sendSpeedLockStatusSet(bool speedLockStatus) {
    SpeedLockStatusSet parameter(speedLockStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SpeedLockStatus");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SpeedLockStatus", propertyContent);
}

act_t HmiDataProxy::sendSpeedLockStatusSet(SpeedLockStatusCallbackIF& cb, bool speedLockStatus) {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(ID_SpeedLockStatus, &cb);
    SpeedLockStatusSet parameter(speedLockStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SpeedLockStatus", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "SpeedLockStatus", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool HmiDataProxy::getSpeedLockStatus() const {
    return _speedLockStatus.get().getSpeedLockStatus();
}

bool HmiDataProxy::hasSpeedLockStatus() const {
    return _speedLockStatus.hasValue();
}

void HmiDataProxy::sendSpeedLockStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpeedLockStatus");
    _dbusProxyDelegate->deregisterSignalCallback("SpeedLockStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiDataProxy::sendDimmingModeRegister(DimmingModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DimmingMode, "DimmingMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DimmingMode", &cb, act);
    return act;
}

bool HmiDataProxy::sendDimmingModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DimmingMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DimmingMode", act, static_cast<int>(rv));
    return rv;
}

act_t HmiDataProxy::sendDimmingModeGet(DimmingModeCallbackIF& cb) {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(ID_DimmingMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DimmingMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DimmingMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiDataProxy::sendDimmingModeSet(uint8 dimmingMode) {
    DimmingModeSet parameter(dimmingMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DimmingMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DimmingMode", propertyContent);
}

act_t HmiDataProxy::sendDimmingModeSet(DimmingModeCallbackIF& cb, uint8 dimmingMode) {
    HmiDataProxyCallback* callback = new HmiDataProxyCallback(ID_DimmingMode, &cb);
    DimmingModeSet parameter(dimmingMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DimmingMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DimmingMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 HmiDataProxy::getDimmingMode() const {
    return _dimmingMode.get().getDimmingMode();
}

bool HmiDataProxy::hasDimmingMode() const {
    return _dimmingMode.hasValue();
}

void HmiDataProxy::sendDimmingModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DimmingMode");
    _dbusProxyDelegate->deregisterSignalCallback("DimmingMode", 0, _dbusDaemonProxy.get(), true);
}

} // namespace HmiData
} // namespace hmidataservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch
