/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "HealthcareMonInterface/HealthcareMonApplication.h"
#include "HealthcareMonInterface/HealthcareMonComponent.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "HealthcareMonApplication" isn't clear, then there should be a description here.
 */

namespace HealthcareMonInterface {

DEFINE_LOGGER_AND_LEVEL (_logger, "/HealthcareMonInterface/HealthcareMonApplication", Info);

/* static */ const char* HealthcareMonApplication::HealthcareMonthrd = "HealthcareMonthrd";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool HealthcareMonApplication_enabledASFSignalHandler = false;

void importHealthcareMonApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach HealthcareMonApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression1;
        {
            __expression1.setApplicationId(170);
        }
        ccaConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'T_HealthcareMonInterface'

    ::asf::core::ComponentContainerSharedPtr T_HealthcareMonInterface(new ::asf::core::ComponentContainer("T_HealthcareMonInterface", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T_HealthcareMonInterface);

        // Component 'HealthcareMonComponent HealthcareMonthrd'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::HealthcareMonInterface::HealthcareMonComponent > > healthcareMonthrdFactory(new ::asf::core::ComponentFactory< ::HealthcareMonInterface::HealthcareMonComponent >);
        ::asf::core::ComponentDescriptionSharedPtr healthcareMonthrdDescription(new ::asf::core::ComponentDescription(1, "HealthcareMonthrd", /* immediate = */ true, /* threadBridge = */ false, healthcareMonthrdFactory));
        T_HealthcareMonInterface->addComponentDescription(healthcareMonthrdDescription);

            // Port 'HealthcareMonServerPort'

            ::asf::core::ProvidedPort& HealthcareMonthrd_HealthcareMonServerPort = healthcareMonthrdDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.HealthcareMonService", "HealthcareMonServerPort", false, false));
            (void)HealthcareMonthrd_HealthcareMonServerPort; // prevent unused variable warning

            // Port 'NanoMsgLCMPort'

            ::asf::core::RequiredPort& HealthcareMonthrd_NanoMsgLCMPort = healthcareMonthrdDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgLCMInterface", "NanoMsgLCMPort"));
            (void)HealthcareMonthrd_NanoMsgLCMPort; // prevent unused variable warning

            // Port 'diaglogFiPort'

            ::asf::core::RequiredPort& HealthcareMonthrd_diaglogFiPort = healthcareMonthrdDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_DiagLog_FI", "diaglogFiPort"));
            (void)HealthcareMonthrd_diaglogFiPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (HealthcareMonthrd_HealthcareMonServerPort, ::std::string("/bosch/cm/ai/HealthcareMonService"));

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgLCMImport = dbusConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgLCMInterface"));
    NanoMsgLCMImport.setServiceName("bosch.cm.di.NanoMsgLCMInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (HealthcareMonthrd_NanoMsgLCMPort, NanoMsgLCMImport);

    // Expression

    ::asf::cca::CcaImportedPort& diaglogFiImport = ccaConnector_->importByName (256, 1, 4, 2);
    diaglogFiImport.setServiceName("Midw_DiagLog_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (HealthcareMonthrd_diaglogFiPort, diaglogFiImport);


    LOG_INFO_STATIC("Starting application 'HealthcareMonApplication' version 1.0.0");

    app->start();
}

int executeHealthcareMonApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("HealthcareMonInterface", "HealthcareMonApplication");
    } else {
        ::asf::core::Logger::setupLogging ("HealthcareMonInterface", "HealthcareMonApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", HealthcareMonApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("HealthcareMonInterface", "HealthcareMonApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create HealthcareMonApplication");

    app->enableExceptionHandler(true);

    importHealthcareMonApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace HealthcareMonInterface

int main(int argc, char* argv[]) {
    ::HealthcareMonInterface::HealthcareMonApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::HealthcareMonInterface::executeHealthcareMonApplication(argc, argv);
}

