#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_TESTIMAGES_H
#define BOSCH_CM_AI_HMI_TESTIMAGES_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/hmi/TestImagesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * service for test images
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace TestImages {

// method IDs
static const uint16 ID_ActivateTestImageProcessing = 0;
static const uint16 ID_ShowTestImage = 1;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class TestImageStatus;

class ActivateTestImageProcessingRequest;

class ShowTestImageRequest;

class ShowTestImageResponse;

// type definitions
/**
 * Enable/disable displaying of testimages
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActivateTestImageProcessingResponse;

/**
 * If the meaning of "ActivateTestImageProcessingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateTestImageProcessingError;

/**
 * If the meaning of "ShowTestImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowTestImageError;


/**
 * If the meaning of "TestImageStatus" isn't clear, then there should be a description here.
 */
class TestImageStatus {
public:

    /**
     * Default constructor
     */
    inline  TestImageStatus ();

    /**
     * Copy constructor
     */
    inline  TestImageStatus (const TestImageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TestImageStatus (tenErrorCode errorCode_);

    /**
     * Destructor
     */
    inline  ~TestImageStatus();

    /**
     * Assignment operator
     */
    inline TestImageStatus& operator = (const TestImageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TestImageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TestImageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TestImageStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TestImageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "errorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "errorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "errorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "errorCode".
     *
     * If the meaning of "errorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorCode"
     */
    inline tenErrorCode getErrorCode () const;

    /**
     * Sets the value of the member "errorCode".
     *
     * If the meaning of "errorCode" isn't clear, then there should be a description here.
     *
     * @param errorCode The value which will be set
     */
    inline void setErrorCode (tenErrorCode errorCode_);

    static const TestImageStatus &getDefaultInstance();

private:

    inline void set_has_errorCode ();

    inline void clear_has_errorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenErrorCode _errorCode;

};

/**
 * Enable/disable displaying of testimages
 */
class ActivateTestImageProcessingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateTestImageProcessingRequest ();

    /**
     * Copy constructor
     */
    inline  ActivateTestImageProcessingRequest (const ActivateTestImageProcessingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateTestImageProcessingRequest (bool activate_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateTestImageProcessingRequest();

    /**
     * Assignment operator
     */
    inline ActivateTestImageProcessingRequest& operator = (const ActivateTestImageProcessingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateTestImageProcessingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateTestImageProcessingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateTestImageProcessingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateTestImageProcessingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activate"

    static const int kActivate = 0;

    /**
     * Clears the field "activate".
     *
     * The field will be set to its default value. The hasActivate()
     * method will return false.
     */
    inline void clearActivate();

    /**
     * Checks whether the field "activate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivate()). Otherwise it will return false.
     */
    inline bool hasActivate () const;

    /**
     * Returns the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activate"
     */
    inline bool getActivate () const;

    /**
     * Sets the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param activate The value which will be set
     */
    inline void setActivate (bool activate_);

    static const ActivateTestImageProcessingRequest &getDefaultInstance();

private:

    inline void set_has_activate ();

    inline void clear_has_activate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _activate;

};

/**
 * Show a test image on a particular display
 */
class ShowTestImageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowTestImageRequest ();

    /**
     * Copy constructor
     */
    inline  ShowTestImageRequest (const ShowTestImageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowTestImageRequest (const ::std::string& imagePath_, uint32 displayId_);

    /**
     * Destructor
     */
    inline virtual  ~ShowTestImageRequest();

    /**
     * Assignment operator
     */
    inline ShowTestImageRequest& operator = (const ShowTestImageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowTestImageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowTestImageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowTestImageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowTestImageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "imagePath"

    static const int kImagePath = 0;

    /**
     * Clears the field "imagePath".
     *
     * The field will be set to its default value. The hasImagePath()
     * method will return false.
     */
    inline void clearImagePath();

    /**
     * Checks whether the field "imagePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImagePath()). Otherwise it will return false.
     */
    inline bool hasImagePath () const;

    /**
     * Returns the value of the member "imagePath".
     *
     * full qualified path to image file to display
     * 			                   supported formats are png and jpeg
     *
     * @return The value of the field "imagePath"
     */
    inline const ::std::string& getImagePath () const;

    /**
     * Retrieves the value of the field "imagePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "imagePath".
     */
    inline ::std::string& getImagePathMutable ();

    /**
     * Sets the value of the member "imagePath".
     *
     * full qualified path to image file to display
     * 			                   supported formats are png and jpeg
     *
     * @param imagePath The value which will be set
     */
    inline void setImagePath (const ::std::string& imagePath_);

    /**
     * Sets the value of the member "imagePath".
     *
     * full qualified path to image file to display
     * 			                   supported formats are png and jpeg
     *
     * @param imagePath The value which will be set
     */
    inline void setImagePath (const char* imagePath_);

    /**
     * Sets the value of the member "imagePath".
     *
     * full qualified path to image file to display
     * 			                   supported formats are png and jpeg
     *
     * @param imagePath The value which will be set
     */
    inline void setImagePath (const char* value, size_t size);

    // API of field "displayId"

    static const int kDisplayId = 1;

    /**
     * Clears the field "displayId".
     *
     * The field will be set to its default value. The hasDisplayId()
     * method will return false.
     */
    inline void clearDisplayId();

    /**
     * Checks whether the field "displayId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayId()). Otherwise it will return false.
     */
    inline bool hasDisplayId () const;

    /**
     * Returns the value of the member "displayId".
     *
     * display id where to show the test image
     * 			                   if displayId is 0 image will be shown on all displays
     * 			                   otherwise displayId will be used as index to access a
     * 			                   display in the array ov available displays
     *
     * @return The value of the field "displayId"
     */
    inline uint32 getDisplayId () const;

    /**
     * Sets the value of the member "displayId".
     *
     * display id where to show the test image
     * 			                   if displayId is 0 image will be shown on all displays
     * 			                   otherwise displayId will be used as index to access a
     * 			                   display in the array ov available displays
     *
     * @param displayId The value which will be set
     */
    inline void setDisplayId (uint32 displayId_);

    static const ShowTestImageRequest &getDefaultInstance();

private:

    inline void set_has_imagePath ();

    inline void clear_has_imagePath ();

    inline void set_has_displayId ();

    inline void clear_has_displayId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _imagePath;

    uint32 _displayId;

};

/**
 * Show a test image on a particular display
 */
class ShowTestImageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowTestImageResponse ();

    /**
     * Copy constructor
     */
    inline  ShowTestImageResponse (const ShowTestImageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ShowTestImageResponse (const TestImageStatus& status_);

    /**
     * Destructor
     */
    inline virtual  ~ShowTestImageResponse();

    /**
     * Assignment operator
     */
    inline ShowTestImageResponse& operator = (const ShowTestImageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowTestImageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowTestImageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowTestImageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowTestImageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline const TestImageStatus& getStatus () const;

    /**
     * Retrieves the value of the field "status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "status".
     */
    inline TestImageStatus& getStatusMutable ();

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (const TestImageStatus& status_);

    static const ShowTestImageResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TestImageStatus _status;

};

inline  TestImageStatus::TestImageStatus ()  :
    _errorCode (::bosch::cm::ai::hmi::TestImages::tenErrorCode__NO_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TestImageStatus::TestImageStatus (const TestImageStatus &rhs)  :
    _errorCode (::bosch::cm::ai::hmi::TestImages::tenErrorCode__NO_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TestImageStatus::TestImageStatus (tenErrorCode errorCode_)  :
    _errorCode (errorCode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorCode_IsValid(errorCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", errorCode_, "tenErrorCode", "errorCode", "TestImageStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TestImageStatus::~TestImageStatus() {
}

inline TestImageStatus& TestImageStatus::operator = (const TestImageStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool TestImageStatus::operator == (const TestImageStatus& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool TestImageStatus::operator != (const TestImageStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TestImageStatus::operator < (const TestImageStatus& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool TestImageStatus::operator > (const TestImageStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TestImageStatus::clear() {
    clearErrorCode();
}

inline void TestImageStatus::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_errorCode();
        _errorCode = ::bosch::cm::ai::hmi::TestImages::tenErrorCode__NO_ERROR;
     }
}

inline bool TestImageStatus::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenErrorCode TestImageStatus::getErrorCode () const {
    return _errorCode;
}

inline void TestImageStatus::setErrorCode (tenErrorCode errorCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenErrorCode_IsValid(errorCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", errorCode_, "tenErrorCode", "errorCode", "TestImageStatus");
    }
    set_has_errorCode();
    this->_errorCode = errorCode_;
}

inline void TestImageStatus::set_has_errorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void TestImageStatus::clear_has_errorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActivateTestImageProcessingRequest::ActivateTestImageProcessingRequest ()  :
    _activate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateTestImageProcessingRequest::ActivateTestImageProcessingRequest (const ActivateTestImageProcessingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _activate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateTestImageProcessingRequest::ActivateTestImageProcessingRequest (bool activate_)  :
    _activate (activate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateTestImageProcessingRequest::~ActivateTestImageProcessingRequest() {
}

inline ActivateTestImageProcessingRequest& ActivateTestImageProcessingRequest::operator = (const ActivateTestImageProcessingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActivate()) {
            setActivate(rhs.getActivate());
        } else {
            clearActivate();
        }
    }
    return *this;
}

inline bool ActivateTestImageProcessingRequest::operator == (const ActivateTestImageProcessingRequest& rhs) const {
    return (((!hasActivate() && !rhs.hasActivate()) || getActivate() == rhs.getActivate()));
}

inline bool ActivateTestImageProcessingRequest::operator != (const ActivateTestImageProcessingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateTestImageProcessingRequest::operator < (const ActivateTestImageProcessingRequest& rhs) const {
    if (hasActivate() || rhs.hasActivate()) {
        if (getActivate() < rhs.getActivate()) return true;
        if (getActivate() > rhs.getActivate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateTestImageProcessingRequest::clone() {
    return new ActivateTestImageProcessingRequest(*this);
}

inline bool ActivateTestImageProcessingRequest::operator > (const ActivateTestImageProcessingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateTestImageProcessingRequest::clear() {
    clearActivate();
}

inline void ActivateTestImageProcessingRequest::clearActivate() {
    if (hasActivate()) {
         clear_has_activate();
        _activate = false;
     }
}

inline bool ActivateTestImageProcessingRequest::hasActivate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ActivateTestImageProcessingRequest::getActivate () const {
    return _activate;
}

inline void ActivateTestImageProcessingRequest::setActivate (bool activate_) {
    set_has_activate();
    this->_activate = activate_;
}

inline void ActivateTestImageProcessingRequest::set_has_activate () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateTestImageProcessingRequest::clear_has_activate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ShowTestImageRequest::ShowTestImageRequest ()  :
    _imagePath (),
    _displayId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShowTestImageRequest::ShowTestImageRequest (const ShowTestImageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _imagePath (),
    _displayId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShowTestImageRequest::ShowTestImageRequest (const ::std::string& imagePath_, uint32 displayId_)  :
    _imagePath (imagePath_),
    _displayId (displayId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imagePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ShowTestImageRequest::~ShowTestImageRequest() {
}

inline ShowTestImageRequest& ShowTestImageRequest::operator = (const ShowTestImageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasImagePath()) {
            setImagePath(rhs.getImagePath());
        } else {
            clearImagePath();
        }
        if (rhs.hasDisplayId()) {
            setDisplayId(rhs.getDisplayId());
        } else {
            clearDisplayId();
        }
    }
    return *this;
}

inline bool ShowTestImageRequest::operator == (const ShowTestImageRequest& rhs) const {
    return (((!hasImagePath() && !rhs.hasImagePath()) || getImagePath() == rhs.getImagePath()) &&
        ((!hasDisplayId() && !rhs.hasDisplayId()) || getDisplayId() == rhs.getDisplayId()));
}

inline bool ShowTestImageRequest::operator != (const ShowTestImageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ShowTestImageRequest::operator < (const ShowTestImageRequest& rhs) const {
    if (hasImagePath() || rhs.hasImagePath()) {
        if (getImagePath() < rhs.getImagePath()) return true;
        if (getImagePath() > rhs.getImagePath()) return false;
    }
    if (hasDisplayId() || rhs.hasDisplayId()) {
        if (getDisplayId() < rhs.getDisplayId()) return true;
        if (getDisplayId() > rhs.getDisplayId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ShowTestImageRequest::clone() {
    return new ShowTestImageRequest(*this);
}

inline bool ShowTestImageRequest::operator > (const ShowTestImageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShowTestImageRequest::clear() {
    clearImagePath();
    clearDisplayId();
}

inline void ShowTestImageRequest::clearImagePath() {
    if (hasImagePath()) {
         clear_has_imagePath();
        _imagePath.clear();
     }
}

inline bool ShowTestImageRequest::hasImagePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ShowTestImageRequest::getImagePath () const {
    return _imagePath;
}

inline ::std::string& ShowTestImageRequest::getImagePathMutable () {
    set_has_imagePath();
    return _imagePath;
}

inline void ShowTestImageRequest::setImagePath (const ::std::string& imagePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imagePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imagePath();
    this->_imagePath = imagePath_;
}

inline void ShowTestImageRequest::setImagePath (const char* imagePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imagePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imagePath();
    this->_imagePath.assign(imagePath_);
}

inline void ShowTestImageRequest::setImagePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imagePath();
    this->_imagePath.assign(value, size);
}

inline void ShowTestImageRequest::clearDisplayId() {
    if (hasDisplayId()) {
         clear_has_displayId();
        _displayId = 0u;
     }
}

inline bool ShowTestImageRequest::hasDisplayId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ShowTestImageRequest::getDisplayId () const {
    return _displayId;
}

inline void ShowTestImageRequest::setDisplayId (uint32 displayId_) {
    set_has_displayId();
    this->_displayId = displayId_;
}

inline void ShowTestImageRequest::set_has_imagePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void ShowTestImageRequest::clear_has_imagePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ShowTestImageRequest::set_has_displayId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ShowTestImageRequest::clear_has_displayId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ShowTestImageResponse::ShowTestImageResponse ()  :
    _status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShowTestImageResponse::ShowTestImageResponse (const ShowTestImageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShowTestImageResponse::ShowTestImageResponse (const TestImageStatus& status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ShowTestImageResponse::~ShowTestImageResponse() {
}

inline ShowTestImageResponse& ShowTestImageResponse::operator = (const ShowTestImageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ShowTestImageResponse::operator == (const ShowTestImageResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ShowTestImageResponse::operator != (const ShowTestImageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ShowTestImageResponse::operator < (const ShowTestImageResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ShowTestImageResponse::clone() {
    return new ShowTestImageResponse(*this);
}

inline bool ShowTestImageResponse::operator > (const ShowTestImageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShowTestImageResponse::clear() {
    clearStatus();
}

inline void ShowTestImageResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status.clear();
     }
}

inline bool ShowTestImageResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TestImageStatus& ShowTestImageResponse::getStatus () const {
    return _status;
}

inline TestImageStatus& ShowTestImageResponse::getStatusMutable () {
    set_has_status();
    return _status;
}

inline void ShowTestImageResponse::setStatus (const TestImageStatus& status_) {
    set_has_status();
    this->_status = status_;
}

inline void ShowTestImageResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ShowTestImageResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace TestImages
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_TESTIMAGES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
