/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "hmibase/TestImageDaemon.h"
#include "hmibase/TestImageRenderer.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "TestImageDaemon" isn't clear, then there should be a description here.
 */

namespace hmibase {

DEFINE_LOGGER_AND_LEVEL (_logger, "/hmibase/TestImageDaemon", Info);

/* static */ const char* TestImageDaemon::renderer = "renderer";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool TestImageDaemon_enabledASFSignalHandler = false;

void importTestImageDaemon() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach TestImageDaemon, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'thHMIBaseTestImageDaemon'

    ::asf::core::ComponentContainerSharedPtr ThHMIBaseTestImageDaemon(new ::asf::core::ComponentContainer("thHMIBaseTestImageDaemon", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThHMIBaseTestImageDaemon);

        // Component 'TestImageRenderer renderer'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::hmibase::TestImageRenderer > > rendererFactory(new ::asf::core::ComponentFactory< ::hmibase::TestImageRenderer >);
        ::asf::core::ComponentDescriptionSharedPtr rendererDescription(new ::asf::core::ComponentDescription(1, "renderer", /* immediate = */ true, /* threadBridge = */ false, rendererFactory));
        ThHMIBaseTestImageDaemon->addComponentDescription(rendererDescription);

            // Port 'port'

            ::asf::core::ProvidedPort& renderer_port = rendererDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.TestImages", "port", false, false));
            (void)renderer_port; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& renderer_SBServicePort = rendererDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)renderer_SBServicePort; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (renderer_port, ::std::string("/bosch/cm/ai/hmi/TestImages"));

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (renderer_SBServicePort, sbServiceImport);


    LOG_INFO_STATIC("Starting application 'TestImageDaemon' version 1.0.0");

    app->start();
}

int executeTestImageDaemon(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("hmibase", "TestImageDaemon");
    } else {
        ::asf::core::Logger::setupLogging ("hmibase", "TestImageDaemon", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", TestImageDaemon_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("hmibase", "TestImageDaemon", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create TestImageDaemon");

    app->enableExceptionHandler(false);

    importTestImageDaemon();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace hmibase

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::hmibase::executeTestImageDaemon(argc, argv);
}

