#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDS_H
#define BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDS_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * service for common hmi trace commands
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

// method IDs
static const uint16 ID_UpdateClientStatus = 0;
static const uint16 ID_UpdateTraceQueryResult = 1;

// signal IDs
static const uint16 ID_TraceQuery = 2;
static const uint16 ID_SimTouch = 3;
static const uint16 ID_SimTouchByName = 4;
static const uint16 ID_SimTouchByText = 5;
static const uint16 ID_SimTouchByTextId = 6;
static const uint16 ID_SimTouchByIndex = 7;
static const uint16 ID_WidgetPropertyValueSetter = 8;
static const uint16 ID_SimRotateEncoder = 9;
static const uint16 ID_SimJoystick = 10;
static const uint16 ID_SimEnterKey = 11;
static const uint16 ID_SimFocusReq = 12;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TraceQueryData;

class SimTouchData;

class Rect;

class SurfaceInfo;

class SimTouchByNameData;

class SimTouchByTextData;

class SimTouchByTextIdData;

class SimTouchByIndexData;

class WidgetPropertyValueSetterData;

class SimRotateEncoderData;

class SimJoystickData;

class SimEnterKeyData;

class SimFocusReqData;

class UpdateClientStatusRequest;

class UpdateTraceQueryResultRequest;

class TraceQuerySignal;

class SimTouchSignal;

class SimTouchByNameSignal;

class SimTouchByTextSignal;

class SimTouchByTextIdSignal;

class SimTouchByIndexSignal;

class WidgetPropertyValueSetterSignal;

class SimRotateEncoderSignal;

class SimJoystickSignal;

class SimEnterKeySignal;

class SimFocusReqSignal;

// type definitions
/**
 * transport information about the hmi process to stub
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateClientStatusResponse;

/**
 * If the meaning of "UpdateClientStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateClientStatusError;

/**
 * forward status data to stub (for trace/testing purpose)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateTraceQueryResultResponse;

/**
 * If the meaning of "UpdateTraceQueryResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateTraceQueryResultError;

/**
 * If the meaning of "TraceQueryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TraceQueryError;

/**
 * If the meaning of "SimTouchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimTouchError;

/**
 * If the meaning of "SimTouchByNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimTouchByNameError;

/**
 * If the meaning of "SimTouchByTextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimTouchByTextError;

/**
 * If the meaning of "SimTouchByTextIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimTouchByTextIdError;

/**
 * If the meaning of "SimTouchByIndexError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimTouchByIndexError;

/**
 * If the meaning of "WidgetPropertyValueSetterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WidgetPropertyValueSetterError;

/**
 * If the meaning of "SimRotateEncoderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimRotateEncoderError;

/**
 * If the meaning of "SimJoystickError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimJoystickError;

/**
 * If the meaning of "SimEnterKeyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimEnterKeyError;

/**
 * If the meaning of "SimFocusReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SimFocusReqError;


/**
 * struct to transport common trace query information
 */
class TraceQueryData {
public:

    /**
     * Default constructor
     */
    inline  TraceQueryData ();

    /**
     * Copy constructor
     */
    inline  TraceQueryData (const TraceQueryData &rhs);

    /**
     * All fields constructor
     */
    inline  TraceQueryData (int32 pid_, traceQueryId queryId_, const ::std::vector< ::std::string >& queryInput_);

    /**
     * Destructor
     */
    inline  ~TraceQueryData();

    /**
     * Assignment operator
     */
    inline TraceQueryData& operator = (const TraceQueryData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceQueryData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceQueryData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceQueryData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceQueryData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "queryId"

    static const int kQueryId = 1;

    /**
     * Clears the field "queryId".
     *
     * The field will be set to its default value. The hasQueryId()
     * method will return false.
     */
    inline void clearQueryId();

    /**
     * Checks whether the field "queryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setQueryId()). Otherwise it will return false.
     */
    inline bool hasQueryId () const;

    /**
     * Returns the value of the member "queryId".
     *
     * If the meaning of "queryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "queryId"
     */
    inline traceQueryId getQueryId () const;

    /**
     * Sets the value of the member "queryId".
     *
     * If the meaning of "queryId" isn't clear, then there should be a description here.
     *
     * @param queryId The value which will be set
     */
    inline void setQueryId (traceQueryId queryId_);

    // API of field "queryInput"

    static const int kQueryInput = 2;

    /**
     * Clears the field "queryInput".
     *
     * The field will be set to its default value. The hasQueryInput()
     * method will return false.
     */
    inline void clearQueryInput();

    /**
     * Checks whether the field "queryInput" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setQueryInput()). Otherwise it will return false.
     */
    inline bool hasQueryInput () const;

    /**
     * Returns the value of the member "queryInput".
     *
     * If the meaning of "queryInput" isn't clear, then there should be a description here.
     *
     * @return The value of the field "queryInput"
     */
    inline const ::std::vector< ::std::string >& getQueryInput () const;

    /**
     * Retrieves the value of the field "queryInput" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "queryInput".
     */
    inline ::std::vector< ::std::string >& getQueryInputMutable ();

    /**
     * Sets the value of the member "queryInput".
     *
     * If the meaning of "queryInput" isn't clear, then there should be a description here.
     *
     * @param queryInput The value which will be set
     */
    inline void setQueryInput (const ::std::vector< ::std::string >& queryInput_);

    static const TraceQueryData &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_queryId ();

    inline void clear_has_queryId ();

    inline void set_has_queryInput ();

    inline void clear_has_queryInput ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    traceQueryId _queryId;

    ::std::vector< ::std::string > _queryInput;

};

/**
 * struct to transport touch simulation data
 */
class SimTouchData {
public:

    /**
     * Default constructor
     */
    inline  SimTouchData ();

    /**
     * Copy constructor
     */
    inline  SimTouchData (const SimTouchData &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchData (int32 pid_, int32 xPos_, int32 yPos_, int32 surfaceId_, int32 pointerId_, simulatedTouchStates status_);

    /**
     * Destructor
     */
    inline  ~SimTouchData();

    /**
     * Assignment operator
     */
    inline SimTouchData& operator = (const SimTouchData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "xPos"

    static const int kXPos = 1;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline int32 getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (int32 xPos_);

    // API of field "yPos"

    static const int kYPos = 2;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline int32 getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (int32 yPos_);

    // API of field "surfaceId"

    static const int kSurfaceId = 3;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline int32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (int32 surfaceId_);

    // API of field "pointerId"

    static const int kPointerId = 4;

    /**
     * Clears the field "pointerId".
     *
     * The field will be set to its default value. The hasPointerId()
     * method will return false.
     */
    inline void clearPointerId();

    /**
     * Checks whether the field "pointerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPointerId()). Otherwise it will return false.
     */
    inline bool hasPointerId () const;

    /**
     * Returns the value of the member "pointerId".
     *
     * If the meaning of "pointerId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pointerId"
     */
    inline int32 getPointerId () const;

    /**
     * Sets the value of the member "pointerId".
     *
     * If the meaning of "pointerId" isn't clear, then there should be a description here.
     *
     * @param pointerId The value which will be set
     */
    inline void setPointerId (int32 pointerId_);

    // API of field "status"

    static const int kStatus = 5;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline simulatedTouchStates getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (simulatedTouchStates status_);

    static const SimTouchData &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_pointerId ();

    inline void clear_has_pointerId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (6 + 31) / 32];

    int32 _pid;

    int32 _xPos;

    int32 _yPos;

    int32 _surfaceId;

    int32 _pointerId;

    simulatedTouchStates _status;

};

/**
 * If the meaning of "Rect" isn't clear, then there should be a description here.
 */
class Rect {
public:

    /**
     * Default constructor
     */
    inline  Rect ();

    /**
     * Copy constructor
     */
    inline  Rect (const Rect &rhs);

    /**
     * All fields constructor
     */
    inline  Rect (int32 xPos_, int32 yPos_, int32 width_, int32 height_);

    /**
     * Destructor
     */
    inline  ~Rect();

    /**
     * Assignment operator
     */
    inline Rect& operator = (const Rect& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Rect& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Rect& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Rect& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Rect& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "xPos"

    static const int kXPos = 0;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline int32 getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (int32 xPos_);

    // API of field "yPos"

    static const int kYPos = 1;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline int32 getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (int32 yPos_);

    // API of field "width"

    static const int kWidth = 2;

    /**
     * Clears the field "width".
     *
     * The field will be set to its default value. The hasWidth()
     * method will return false.
     */
    inline void clearWidth();

    /**
     * Checks whether the field "width" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidth()). Otherwise it will return false.
     */
    inline bool hasWidth () const;

    /**
     * Returns the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @return The value of the field "width"
     */
    inline int32 getWidth () const;

    /**
     * Sets the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @param width The value which will be set
     */
    inline void setWidth (int32 width_);

    // API of field "height"

    static const int kHeight = 3;

    /**
     * Clears the field "height".
     *
     * The field will be set to its default value. The hasHeight()
     * method will return false.
     */
    inline void clearHeight();

    /**
     * Checks whether the field "height" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeight()). Otherwise it will return false.
     */
    inline bool hasHeight () const;

    /**
     * Returns the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @return The value of the field "height"
     */
    inline int32 getHeight () const;

    /**
     * Sets the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @param height The value which will be set
     */
    inline void setHeight (int32 height_);

    static const Rect &getDefaultInstance();

private:

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    inline void set_has_width ();

    inline void clear_has_width ();

    inline void set_has_height ();

    inline void clear_has_height ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _xPos;

    int32 _yPos;

    int32 _width;

    int32 _height;

};

/**
 * If the meaning of "SurfaceInfo" isn't clear, then there should be a description here.
 */
class SurfaceInfo {
public:

    /**
     * Default constructor
     */
    inline  SurfaceInfo ();

    /**
     * Copy constructor
     */
    inline  SurfaceInfo (const SurfaceInfo &rhs);

    /**
     * All fields constructor
     */
    inline  SurfaceInfo (int32 surfaceId_, const Rect& rect_);

    /**
     * Destructor
     */
    inline  ~SurfaceInfo();

    /**
     * Assignment operator
     */
    inline SurfaceInfo& operator = (const SurfaceInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurfaceInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurfaceInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurfaceInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurfaceInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "surfaceId"

    static const int kSurfaceId = 0;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline int32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (int32 surfaceId_);

    // API of field "rect"

    static const int kRect = 1;

    /**
     * Clears the field "rect".
     *
     * The field will be set to its default value. The hasRect()
     * method will return false.
     */
    inline void clearRect();

    /**
     * Checks whether the field "rect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRect()). Otherwise it will return false.
     */
    inline bool hasRect () const;

    /**
     * Returns the value of the member "rect".
     *
     * If the meaning of "rect" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rect"
     */
    inline const Rect& getRect () const;

    /**
     * Retrieves the value of the field "rect" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rect".
     */
    inline Rect& getRectMutable ();

    /**
     * Sets the value of the member "rect".
     *
     * If the meaning of "rect" isn't clear, then there should be a description here.
     *
     * @param rect The value which will be set
     */
    inline void setRect (const Rect& rect_);

    static const SurfaceInfo &getDefaultInstance();

private:

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_rect ();

    inline void clear_has_rect ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _surfaceId;

    Rect _rect;

};

/**
 * struct to transport touch simulation data
 */
class SimTouchByNameData {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByNameData ();

    /**
     * Copy constructor
     */
    inline  SimTouchByNameData (const SimTouchByNameData &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByNameData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetName_, const ::std::string& viewName_);

    /**
     * Destructor
     */
    inline  ~SimTouchByNameData();

    /**
     * Assignment operator
     */
    inline SimTouchByNameData& operator = (const SimTouchByNameData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByNameData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByNameData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByNameData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByNameData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "touchableSurfaces"

    static const int kTouchableSurfaces = 1;

    /**
     * Clears the field "touchableSurfaces".
     *
     * The field will be set to its default value. The hasTouchableSurfaces()
     * method will return false.
     */
    inline void clearTouchableSurfaces();

    /**
     * Checks whether the field "touchableSurfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchableSurfaces()). Otherwise it will return false.
     */
    inline bool hasTouchableSurfaces () const;

    /**
     * Returns the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "touchableSurfaces"
     */
    inline const ::std::vector< SurfaceInfo >& getTouchableSurfaces () const;

    /**
     * Retrieves the value of the field "touchableSurfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "touchableSurfaces".
     */
    inline ::std::vector< SurfaceInfo >& getTouchableSurfacesMutable ();

    /**
     * Sets the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @param touchableSurfaces The value which will be set
     */
    inline void setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_);

    // API of field "widgetName"

    static const int kWidgetName = 2;

    /**
     * Clears the field "widgetName".
     *
     * The field will be set to its default value. The hasWidgetName()
     * method will return false.
     */
    inline void clearWidgetName();

    /**
     * Checks whether the field "widgetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidgetName()). Otherwise it will return false.
     */
    inline bool hasWidgetName () const;

    /**
     * Returns the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "widgetName"
     */
    inline const ::std::string& getWidgetName () const;

    /**
     * Retrieves the value of the field "widgetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "widgetName".
     */
    inline ::std::string& getWidgetNameMutable ();

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const ::std::string& widgetName_);

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const char* widgetName_);

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const char* value, size_t size);

    // API of field "viewName"

    static const int kViewName = 3;

    /**
     * Clears the field "viewName".
     *
     * The field will be set to its default value. The hasViewName()
     * method will return false.
     */
    inline void clearViewName();

    /**
     * Checks whether the field "viewName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setViewName()). Otherwise it will return false.
     */
    inline bool hasViewName () const;

    /**
     * Returns the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "viewName"
     */
    inline const ::std::string& getViewName () const;

    /**
     * Retrieves the value of the field "viewName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "viewName".
     */
    inline ::std::string& getViewNameMutable ();

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const ::std::string& viewName_);

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const char* viewName_);

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const char* value, size_t size);

    static const SimTouchByNameData &getDefaultInstance();

private:

    static const ::std::vector< SurfaceInfo >& getSurfaceInfoList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_touchableSurfaces ();

    inline void clear_has_touchableSurfaces ();

    inline void set_has_widgetName ();

    inline void clear_has_widgetName ();

    inline void set_has_viewName ();

    inline void clear_has_viewName ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _pid;

    ::std::vector< SurfaceInfo > _touchableSurfaces;

    ::std::string _widgetName;

    ::std::string _viewName;

};

/**
 * struct to transport touch simulation data
 */
class SimTouchByTextData {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByTextData ();

    /**
     * Copy constructor
     */
    inline  SimTouchByTextData (const SimTouchByTextData &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByTextData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetText_);

    /**
     * Destructor
     */
    inline  ~SimTouchByTextData();

    /**
     * Assignment operator
     */
    inline SimTouchByTextData& operator = (const SimTouchByTextData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByTextData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByTextData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByTextData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByTextData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "touchableSurfaces"

    static const int kTouchableSurfaces = 1;

    /**
     * Clears the field "touchableSurfaces".
     *
     * The field will be set to its default value. The hasTouchableSurfaces()
     * method will return false.
     */
    inline void clearTouchableSurfaces();

    /**
     * Checks whether the field "touchableSurfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchableSurfaces()). Otherwise it will return false.
     */
    inline bool hasTouchableSurfaces () const;

    /**
     * Returns the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "touchableSurfaces"
     */
    inline const ::std::vector< SurfaceInfo >& getTouchableSurfaces () const;

    /**
     * Retrieves the value of the field "touchableSurfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "touchableSurfaces".
     */
    inline ::std::vector< SurfaceInfo >& getTouchableSurfacesMutable ();

    /**
     * Sets the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @param touchableSurfaces The value which will be set
     */
    inline void setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_);

    // API of field "widgetText"

    static const int kWidgetText = 2;

    /**
     * Clears the field "widgetText".
     *
     * The field will be set to its default value. The hasWidgetText()
     * method will return false.
     */
    inline void clearWidgetText();

    /**
     * Checks whether the field "widgetText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidgetText()). Otherwise it will return false.
     */
    inline bool hasWidgetText () const;

    /**
     * Returns the value of the member "widgetText".
     *
     * If the meaning of "widgetText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "widgetText"
     */
    inline const ::std::string& getWidgetText () const;

    /**
     * Retrieves the value of the field "widgetText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "widgetText".
     */
    inline ::std::string& getWidgetTextMutable ();

    /**
     * Sets the value of the member "widgetText".
     *
     * If the meaning of "widgetText" isn't clear, then there should be a description here.
     *
     * @param widgetText The value which will be set
     */
    inline void setWidgetText (const ::std::string& widgetText_);

    /**
     * Sets the value of the member "widgetText".
     *
     * If the meaning of "widgetText" isn't clear, then there should be a description here.
     *
     * @param widgetText The value which will be set
     */
    inline void setWidgetText (const char* widgetText_);

    /**
     * Sets the value of the member "widgetText".
     *
     * If the meaning of "widgetText" isn't clear, then there should be a description here.
     *
     * @param widgetText The value which will be set
     */
    inline void setWidgetText (const char* value, size_t size);

    static const SimTouchByTextData &getDefaultInstance();

private:

    static const ::std::vector< SurfaceInfo >& getSurfaceInfoList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_touchableSurfaces ();

    inline void clear_has_touchableSurfaces ();

    inline void set_has_widgetText ();

    inline void clear_has_widgetText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    ::std::vector< SurfaceInfo > _touchableSurfaces;

    ::std::string _widgetText;

};

/**
 * struct to transport touch simulation data
 */
class SimTouchByTextIdData {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByTextIdData ();

    /**
     * Copy constructor
     */
    inline  SimTouchByTextIdData (const SimTouchByTextIdData &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByTextIdData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetTextId_);

    /**
     * Destructor
     */
    inline  ~SimTouchByTextIdData();

    /**
     * Assignment operator
     */
    inline SimTouchByTextIdData& operator = (const SimTouchByTextIdData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByTextIdData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByTextIdData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByTextIdData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByTextIdData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "touchableSurfaces"

    static const int kTouchableSurfaces = 1;

    /**
     * Clears the field "touchableSurfaces".
     *
     * The field will be set to its default value. The hasTouchableSurfaces()
     * method will return false.
     */
    inline void clearTouchableSurfaces();

    /**
     * Checks whether the field "touchableSurfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchableSurfaces()). Otherwise it will return false.
     */
    inline bool hasTouchableSurfaces () const;

    /**
     * Returns the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "touchableSurfaces"
     */
    inline const ::std::vector< SurfaceInfo >& getTouchableSurfaces () const;

    /**
     * Retrieves the value of the field "touchableSurfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "touchableSurfaces".
     */
    inline ::std::vector< SurfaceInfo >& getTouchableSurfacesMutable ();

    /**
     * Sets the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @param touchableSurfaces The value which will be set
     */
    inline void setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_);

    // API of field "widgetTextId"

    static const int kWidgetTextId = 2;

    /**
     * Clears the field "widgetTextId".
     *
     * The field will be set to its default value. The hasWidgetTextId()
     * method will return false.
     */
    inline void clearWidgetTextId();

    /**
     * Checks whether the field "widgetTextId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidgetTextId()). Otherwise it will return false.
     */
    inline bool hasWidgetTextId () const;

    /**
     * Returns the value of the member "widgetTextId".
     *
     * If the meaning of "widgetTextId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "widgetTextId"
     */
    inline const ::std::string& getWidgetTextId () const;

    /**
     * Retrieves the value of the field "widgetTextId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "widgetTextId".
     */
    inline ::std::string& getWidgetTextIdMutable ();

    /**
     * Sets the value of the member "widgetTextId".
     *
     * If the meaning of "widgetTextId" isn't clear, then there should be a description here.
     *
     * @param widgetTextId The value which will be set
     */
    inline void setWidgetTextId (const ::std::string& widgetTextId_);

    /**
     * Sets the value of the member "widgetTextId".
     *
     * If the meaning of "widgetTextId" isn't clear, then there should be a description here.
     *
     * @param widgetTextId The value which will be set
     */
    inline void setWidgetTextId (const char* widgetTextId_);

    /**
     * Sets the value of the member "widgetTextId".
     *
     * If the meaning of "widgetTextId" isn't clear, then there should be a description here.
     *
     * @param widgetTextId The value which will be set
     */
    inline void setWidgetTextId (const char* value, size_t size);

    static const SimTouchByTextIdData &getDefaultInstance();

private:

    static const ::std::vector< SurfaceInfo >& getSurfaceInfoList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_touchableSurfaces ();

    inline void clear_has_touchableSurfaces ();

    inline void set_has_widgetTextId ();

    inline void clear_has_widgetTextId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    ::std::vector< SurfaceInfo > _touchableSurfaces;

    ::std::string _widgetTextId;

};

/**
 * struct to transport touch simulation data of a ListItem
 * 			The ListID along with the index of the Button to be selected.
 */
class SimTouchByIndexData {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByIndexData ();

    /**
     * Copy constructor
     */
    inline  SimTouchByIndexData (const SimTouchByIndexData &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByIndexData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, int32 ListID_, int32 ButtonWidgetIndex_);

    /**
     * Destructor
     */
    inline  ~SimTouchByIndexData();

    /**
     * Assignment operator
     */
    inline SimTouchByIndexData& operator = (const SimTouchByIndexData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByIndexData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByIndexData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByIndexData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByIndexData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "touchableSurfaces"

    static const int kTouchableSurfaces = 1;

    /**
     * Clears the field "touchableSurfaces".
     *
     * The field will be set to its default value. The hasTouchableSurfaces()
     * method will return false.
     */
    inline void clearTouchableSurfaces();

    /**
     * Checks whether the field "touchableSurfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchableSurfaces()). Otherwise it will return false.
     */
    inline bool hasTouchableSurfaces () const;

    /**
     * Returns the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "touchableSurfaces"
     */
    inline const ::std::vector< SurfaceInfo >& getTouchableSurfaces () const;

    /**
     * Retrieves the value of the field "touchableSurfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "touchableSurfaces".
     */
    inline ::std::vector< SurfaceInfo >& getTouchableSurfacesMutable ();

    /**
     * Sets the value of the member "touchableSurfaces".
     *
     * If the meaning of "touchableSurfaces" isn't clear, then there should be a description here.
     *
     * @param touchableSurfaces The value which will be set
     */
    inline void setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_);

    // API of field "ListID"

    static const int kListID = 2;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * If the meaning of "ListID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListID"
     */
    inline int32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * If the meaning of "ListID" isn't clear, then there should be a description here.
     *
     * @param ListID The value which will be set
     */
    inline void setListID (int32 ListID_);

    // API of field "ButtonWidgetIndex"

    static const int kButtonWidgetIndex = 3;

    /**
     * Clears the field "ButtonWidgetIndex".
     *
     * The field will be set to its default value. The hasButtonWidgetIndex()
     * method will return false.
     */
    inline void clearButtonWidgetIndex();

    /**
     * Checks whether the field "ButtonWidgetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setButtonWidgetIndex()). Otherwise it will return false.
     */
    inline bool hasButtonWidgetIndex () const;

    /**
     * Returns the value of the member "ButtonWidgetIndex".
     *
     * If the meaning of "ButtonWidgetIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ButtonWidgetIndex"
     */
    inline int32 getButtonWidgetIndex () const;

    /**
     * Sets the value of the member "ButtonWidgetIndex".
     *
     * If the meaning of "ButtonWidgetIndex" isn't clear, then there should be a description here.
     *
     * @param ButtonWidgetIndex The value which will be set
     */
    inline void setButtonWidgetIndex (int32 ButtonWidgetIndex_);

    static const SimTouchByIndexData &getDefaultInstance();

private:

    static const ::std::vector< SurfaceInfo >& getSurfaceInfoList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_touchableSurfaces ();

    inline void clear_has_touchableSurfaces ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_ButtonWidgetIndex ();

    inline void clear_has_ButtonWidgetIndex ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _pid;

    ::std::vector< SurfaceInfo > _touchableSurfaces;

    int32 _ListID;

    int32 _ButtonWidgetIndex;

};

/**
 * struct to transport common widget property setter information
 */
class WidgetPropertyValueSetterData {
public:

    /**
     * Default constructor
     */
    inline  WidgetPropertyValueSetterData ();

    /**
     * Copy constructor
     */
    inline  WidgetPropertyValueSetterData (const WidgetPropertyValueSetterData &rhs);

    /**
     * All fields constructor
     */
    inline  WidgetPropertyValueSetterData (int32 pid_, const ::std::vector< ::std::string >& widgetNames_, const ::std::string& propertyName_, const ::std::string& propertyValue_);

    /**
     * Destructor
     */
    inline  ~WidgetPropertyValueSetterData();

    /**
     * Assignment operator
     */
    inline WidgetPropertyValueSetterData& operator = (const WidgetPropertyValueSetterData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WidgetPropertyValueSetterData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WidgetPropertyValueSetterData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WidgetPropertyValueSetterData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WidgetPropertyValueSetterData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "widgetNames"

    static const int kWidgetNames = 1;

    /**
     * Clears the field "widgetNames".
     *
     * The field will be set to its default value. The hasWidgetNames()
     * method will return false.
     */
    inline void clearWidgetNames();

    /**
     * Checks whether the field "widgetNames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidgetNames()). Otherwise it will return false.
     */
    inline bool hasWidgetNames () const;

    /**
     * Returns the value of the member "widgetNames".
     *
     * If the meaning of "widgetNames" isn't clear, then there should be a description here.
     *
     * @return The value of the field "widgetNames"
     */
    inline const ::std::vector< ::std::string >& getWidgetNames () const;

    /**
     * Retrieves the value of the field "widgetNames" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "widgetNames".
     */
    inline ::std::vector< ::std::string >& getWidgetNamesMutable ();

    /**
     * Sets the value of the member "widgetNames".
     *
     * If the meaning of "widgetNames" isn't clear, then there should be a description here.
     *
     * @param widgetNames The value which will be set
     */
    inline void setWidgetNames (const ::std::vector< ::std::string >& widgetNames_);

    // API of field "propertyName"

    static const int kPropertyName = 2;

    /**
     * Clears the field "propertyName".
     *
     * The field will be set to its default value. The hasPropertyName()
     * method will return false.
     */
    inline void clearPropertyName();

    /**
     * Checks whether the field "propertyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyName()). Otherwise it will return false.
     */
    inline bool hasPropertyName () const;

    /**
     * Returns the value of the member "propertyName".
     *
     * If the meaning of "propertyName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "propertyName"
     */
    inline const ::std::string& getPropertyName () const;

    /**
     * Retrieves the value of the field "propertyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "propertyName".
     */
    inline ::std::string& getPropertyNameMutable ();

    /**
     * Sets the value of the member "propertyName".
     *
     * If the meaning of "propertyName" isn't clear, then there should be a description here.
     *
     * @param propertyName The value which will be set
     */
    inline void setPropertyName (const ::std::string& propertyName_);

    /**
     * Sets the value of the member "propertyName".
     *
     * If the meaning of "propertyName" isn't clear, then there should be a description here.
     *
     * @param propertyName The value which will be set
     */
    inline void setPropertyName (const char* propertyName_);

    /**
     * Sets the value of the member "propertyName".
     *
     * If the meaning of "propertyName" isn't clear, then there should be a description here.
     *
     * @param propertyName The value which will be set
     */
    inline void setPropertyName (const char* value, size_t size);

    // API of field "propertyValue"

    static const int kPropertyValue = 3;

    /**
     * Clears the field "propertyValue".
     *
     * The field will be set to its default value. The hasPropertyValue()
     * method will return false.
     */
    inline void clearPropertyValue();

    /**
     * Checks whether the field "propertyValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPropertyValue()). Otherwise it will return false.
     */
    inline bool hasPropertyValue () const;

    /**
     * Returns the value of the member "propertyValue".
     *
     * If the meaning of "propertyValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "propertyValue"
     */
    inline const ::std::string& getPropertyValue () const;

    /**
     * Retrieves the value of the field "propertyValue" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "propertyValue".
     */
    inline ::std::string& getPropertyValueMutable ();

    /**
     * Sets the value of the member "propertyValue".
     *
     * If the meaning of "propertyValue" isn't clear, then there should be a description here.
     *
     * @param propertyValue The value which will be set
     */
    inline void setPropertyValue (const ::std::string& propertyValue_);

    /**
     * Sets the value of the member "propertyValue".
     *
     * If the meaning of "propertyValue" isn't clear, then there should be a description here.
     *
     * @param propertyValue The value which will be set
     */
    inline void setPropertyValue (const char* propertyValue_);

    /**
     * Sets the value of the member "propertyValue".
     *
     * If the meaning of "propertyValue" isn't clear, then there should be a description here.
     *
     * @param propertyValue The value which will be set
     */
    inline void setPropertyValue (const char* value, size_t size);

    static const WidgetPropertyValueSetterData &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_widgetNames ();

    inline void clear_has_widgetNames ();

    inline void set_has_propertyName ();

    inline void clear_has_propertyName ();

    inline void set_has_propertyValue ();

    inline void clear_has_propertyValue ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _pid;

    ::std::vector< ::std::string > _widgetNames;

    ::std::string _propertyName;

    ::std::string _propertyValue;

};

/**
 * struct to post Rotate Encorder message
 */
class SimRotateEncoderData {
public:

    /**
     * Default constructor
     */
    inline  SimRotateEncoderData ();

    /**
     * Copy constructor
     */
    inline  SimRotateEncoderData (const SimRotateEncoderData &rhs);

    /**
     * All fields constructor
     */
    inline  SimRotateEncoderData (int32 pid_, const ::std::string& encCode_, int32 encSteps_, uint32 userData_);

    /**
     * Destructor
     */
    inline  ~SimRotateEncoderData();

    /**
     * Assignment operator
     */
    inline SimRotateEncoderData& operator = (const SimRotateEncoderData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimRotateEncoderData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimRotateEncoderData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimRotateEncoderData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimRotateEncoderData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "encCode"

    static const int kEncCode = 1;

    /**
     * Clears the field "encCode".
     *
     * The field will be set to its default value. The hasEncCode()
     * method will return false.
     */
    inline void clearEncCode();

    /**
     * Checks whether the field "encCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncCode()). Otherwise it will return false.
     */
    inline bool hasEncCode () const;

    /**
     * Returns the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encCode"
     */
    inline const ::std::string& getEncCode () const;

    /**
     * Retrieves the value of the field "encCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "encCode".
     */
    inline ::std::string& getEncCodeMutable ();

    /**
     * Sets the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @param encCode The value which will be set
     */
    inline void setEncCode (const ::std::string& encCode_);

    /**
     * Sets the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @param encCode The value which will be set
     */
    inline void setEncCode (const char* encCode_);

    /**
     * Sets the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @param encCode The value which will be set
     */
    inline void setEncCode (const char* value, size_t size);

    // API of field "encSteps"

    static const int kEncSteps = 2;

    /**
     * Clears the field "encSteps".
     *
     * The field will be set to its default value. The hasEncSteps()
     * method will return false.
     */
    inline void clearEncSteps();

    /**
     * Checks whether the field "encSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncSteps()). Otherwise it will return false.
     */
    inline bool hasEncSteps () const;

    /**
     * Returns the value of the member "encSteps".
     *
     * If the meaning of "encSteps" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encSteps"
     */
    inline int32 getEncSteps () const;

    /**
     * Sets the value of the member "encSteps".
     *
     * If the meaning of "encSteps" isn't clear, then there should be a description here.
     *
     * @param encSteps The value which will be set
     */
    inline void setEncSteps (int32 encSteps_);

    // API of field "userData"

    static const int kUserData = 3;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const SimRotateEncoderData &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_encCode ();

    inline void clear_has_encCode ();

    inline void set_has_encSteps ();

    inline void clear_has_encSteps ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _pid;

    ::std::string _encCode;

    int32 _encSteps;

    uint32 _userData;

};

/**
 * struct to post Rotate Joystick message
 */
class SimJoystickData {
public:

    /**
     * Default constructor
     */
    inline  SimJoystickData ();

    /**
     * Copy constructor
     */
    inline  SimJoystickData (const SimJoystickData &rhs);

    /**
     * All fields constructor
     */
    inline  SimJoystickData (int32 pid_, uint32 direction_, const ::std::string& source_);

    /**
     * Destructor
     */
    inline  ~SimJoystickData();

    /**
     * Assignment operator
     */
    inline SimJoystickData& operator = (const SimJoystickData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimJoystickData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimJoystickData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimJoystickData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimJoystickData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "direction"

    static const int kDirection = 1;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * If the meaning of "direction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "direction"
     */
    inline uint32 getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * If the meaning of "direction" isn't clear, then there should be a description here.
     *
     * @param direction The value which will be set
     */
    inline void setDirection (uint32 direction_);

    // API of field "source"

    static const int kSource = 2;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline const ::std::string& getSource () const;

    /**
     * Retrieves the value of the field "source" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "source".
     */
    inline ::std::string& getSourceMutable ();

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const ::std::string& source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* value, size_t size);

    static const SimJoystickData &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    inline void set_has_source ();

    inline void clear_has_source ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    uint32 _direction;

    ::std::string _source;

};

/**
 * struct to post EnterKey message
 */
class SimEnterKeyData {
public:

    /**
     * Default constructor
     */
    inline  SimEnterKeyData ();

    /**
     * Copy constructor
     */
    inline  SimEnterKeyData (const SimEnterKeyData &rhs);

    /**
     * All fields constructor
     */
    inline  SimEnterKeyData (int32 pid_, uint32 keyState_, const ::std::string& source_);

    /**
     * Destructor
     */
    inline  ~SimEnterKeyData();

    /**
     * Assignment operator
     */
    inline SimEnterKeyData& operator = (const SimEnterKeyData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimEnterKeyData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimEnterKeyData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimEnterKeyData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimEnterKeyData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "keyState"

    static const int kKeyState = 1;

    /**
     * Clears the field "keyState".
     *
     * The field will be set to its default value. The hasKeyState()
     * method will return false.
     */
    inline void clearKeyState();

    /**
     * Checks whether the field "keyState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyState()). Otherwise it will return false.
     */
    inline bool hasKeyState () const;

    /**
     * Returns the value of the member "keyState".
     *
     * If the meaning of "keyState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyState"
     */
    inline uint32 getKeyState () const;

    /**
     * Sets the value of the member "keyState".
     *
     * If the meaning of "keyState" isn't clear, then there should be a description here.
     *
     * @param keyState The value which will be set
     */
    inline void setKeyState (uint32 keyState_);

    // API of field "source"

    static const int kSource = 2;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline const ::std::string& getSource () const;

    /**
     * Retrieves the value of the field "source" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "source".
     */
    inline ::std::string& getSourceMutable ();

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const ::std::string& source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* source_);

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (const char* value, size_t size);

    static const SimEnterKeyData &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_keyState ();

    inline void clear_has_keyState ();

    inline void set_has_source ();

    inline void clear_has_source ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    uint32 _keyState;

    ::std::string _source;

};

/**
 * struct to post FocusReq message
 */
class SimFocusReqData {
public:

    /**
     * Default constructor
     */
    inline  SimFocusReqData ();

    /**
     * Copy constructor
     */
    inline  SimFocusReqData (const SimFocusReqData &rhs);

    /**
     * All fields constructor
     */
    inline  SimFocusReqData (int32 pid_, uint32 action_, uint32 timeAction_, const ::std::string& viewName_, const ::std::string& widgetName_);

    /**
     * Destructor
     */
    inline  ~SimFocusReqData();

    /**
     * Assignment operator
     */
    inline SimFocusReqData& operator = (const SimFocusReqData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimFocusReqData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimFocusReqData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimFocusReqData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimFocusReqData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "action"

    static const int kAction = 1;

    /**
     * Clears the field "action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "action"
     */
    inline uint32 getAction () const;

    /**
     * Sets the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @param action The value which will be set
     */
    inline void setAction (uint32 action_);

    // API of field "timeAction"

    static const int kTimeAction = 2;

    /**
     * Clears the field "timeAction".
     *
     * The field will be set to its default value. The hasTimeAction()
     * method will return false.
     */
    inline void clearTimeAction();

    /**
     * Checks whether the field "timeAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeAction()). Otherwise it will return false.
     */
    inline bool hasTimeAction () const;

    /**
     * Returns the value of the member "timeAction".
     *
     * If the meaning of "timeAction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeAction"
     */
    inline uint32 getTimeAction () const;

    /**
     * Sets the value of the member "timeAction".
     *
     * If the meaning of "timeAction" isn't clear, then there should be a description here.
     *
     * @param timeAction The value which will be set
     */
    inline void setTimeAction (uint32 timeAction_);

    // API of field "viewName"

    static const int kViewName = 3;

    /**
     * Clears the field "viewName".
     *
     * The field will be set to its default value. The hasViewName()
     * method will return false.
     */
    inline void clearViewName();

    /**
     * Checks whether the field "viewName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setViewName()). Otherwise it will return false.
     */
    inline bool hasViewName () const;

    /**
     * Returns the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "viewName"
     */
    inline const ::std::string& getViewName () const;

    /**
     * Retrieves the value of the field "viewName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "viewName".
     */
    inline ::std::string& getViewNameMutable ();

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const ::std::string& viewName_);

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const char* viewName_);

    /**
     * Sets the value of the member "viewName".
     *
     * If the meaning of "viewName" isn't clear, then there should be a description here.
     *
     * @param viewName The value which will be set
     */
    inline void setViewName (const char* value, size_t size);

    // API of field "widgetName"

    static const int kWidgetName = 4;

    /**
     * Clears the field "widgetName".
     *
     * The field will be set to its default value. The hasWidgetName()
     * method will return false.
     */
    inline void clearWidgetName();

    /**
     * Checks whether the field "widgetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidgetName()). Otherwise it will return false.
     */
    inline bool hasWidgetName () const;

    /**
     * Returns the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "widgetName"
     */
    inline const ::std::string& getWidgetName () const;

    /**
     * Retrieves the value of the field "widgetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "widgetName".
     */
    inline ::std::string& getWidgetNameMutable ();

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const ::std::string& widgetName_);

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const char* widgetName_);

    /**
     * Sets the value of the member "widgetName".
     *
     * If the meaning of "widgetName" isn't clear, then there should be a description here.
     *
     * @param widgetName The value which will be set
     */
    inline void setWidgetName (const char* value, size_t size);

    static const SimFocusReqData &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_action ();

    inline void clear_has_action ();

    inline void set_has_timeAction ();

    inline void clear_has_timeAction ();

    inline void set_has_viewName ();

    inline void clear_has_viewName ();

    inline void set_has_widgetName ();

    inline void clear_has_widgetName ();

    uint32 _has_bits_[ (5 + 31) / 32];

    int32 _pid;

    uint32 _action;

    uint32 _timeAction;

    ::std::string _viewName;

    ::std::string _widgetName;

};

/**
 * transport information about the hmi process to stub
 */
class UpdateClientStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateClientStatusRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateClientStatusRequest (const UpdateClientStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateClientStatusRequest (uint32 pid_, const ::std::string& name_, const ::std::vector< uint32 >& surfaces_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateClientStatusRequest();

    /**
     * Assignment operator
     */
    inline UpdateClientStatusRequest& operator = (const UpdateClientStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateClientStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateClientStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateClientStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateClientStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline uint32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (uint32 pid_);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "surfaces"

    static const int kSurfaces = 2;

    /**
     * Clears the field "surfaces".
     *
     * The field will be set to its default value. The hasSurfaces()
     * method will return false.
     */
    inline void clearSurfaces();

    /**
     * Checks whether the field "surfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaces()). Otherwise it will return false.
     */
    inline bool hasSurfaces () const;

    /**
     * Returns the value of the member "surfaces".
     *
     * If the meaning of "surfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaces"
     */
    inline const ::std::vector< uint32 >& getSurfaces () const;

    /**
     * Retrieves the value of the field "surfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "surfaces".
     */
    inline ::std::vector< uint32 >& getSurfacesMutable ();

    /**
     * Sets the value of the member "surfaces".
     *
     * If the meaning of "surfaces" isn't clear, then there should be a description here.
     *
     * @param surfaces The value which will be set
     */
    inline void setSurfaces (const ::std::vector< uint32 >& surfaces_);

    static const UpdateClientStatusRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_surfaces ();

    inline void clear_has_surfaces ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pid;

    ::std::string _name;

    ::std::vector< uint32 > _surfaces;

};

/**
 * forward status data to stub (for trace/testing purpose)
 */
class UpdateTraceQueryResultRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateTraceQueryResultRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateTraceQueryResultRequest (const UpdateTraceQueryResultRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateTraceQueryResultRequest (const TraceQueryData& data_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateTraceQueryResultRequest();

    /**
     * Assignment operator
     */
    inline UpdateTraceQueryResultRequest& operator = (const UpdateTraceQueryResultRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateTraceQueryResultRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateTraceQueryResultRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateTraceQueryResultRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateTraceQueryResultRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const TraceQueryData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline TraceQueryData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const TraceQueryData& data_);

    static const UpdateTraceQueryResultRequest &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TraceQueryData _data;

};

/**
 * send out trace query to all registered clients
 */
class TraceQuerySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TraceQuerySignal ();

    /**
     * Copy constructor
     */
    inline  TraceQuerySignal (const TraceQuerySignal &rhs);

    /**
     * All fields constructor
     */
    inline  TraceQuerySignal (const TraceQueryData& data_);

    /**
     * Destructor
     */
    inline virtual  ~TraceQuerySignal();

    /**
     * Assignment operator
     */
    inline TraceQuerySignal& operator = (const TraceQuerySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceQuerySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceQuerySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceQuerySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceQuerySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const TraceQueryData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline TraceQueryData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const TraceQueryData& data_);

    static const TraceQuerySignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TraceQueryData _data;

};

/**
 * send out touch simulation commands to all registered clients
 */
class SimTouchSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimTouchSignal ();

    /**
     * Copy constructor
     */
    inline  SimTouchSignal (const SimTouchSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchSignal (const SimTouchData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimTouchSignal();

    /**
     * Assignment operator
     */
    inline SimTouchSignal& operator = (const SimTouchSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimTouchData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimTouchData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimTouchData& data_);

    static const SimTouchSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimTouchData _data;

};

/**
 * send out touch simulation commands to all registered clients
 */
class SimTouchByNameSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByNameSignal ();

    /**
     * Copy constructor
     */
    inline  SimTouchByNameSignal (const SimTouchByNameSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByNameSignal (const SimTouchByNameData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimTouchByNameSignal();

    /**
     * Assignment operator
     */
    inline SimTouchByNameSignal& operator = (const SimTouchByNameSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByNameSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByNameSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByNameSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByNameSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimTouchByNameData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimTouchByNameData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimTouchByNameData& data_);

    static const SimTouchByNameSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimTouchByNameData _data;

};

/**
 * send out touch simulation commands to all registered clients
 */
class SimTouchByTextSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByTextSignal ();

    /**
     * Copy constructor
     */
    inline  SimTouchByTextSignal (const SimTouchByTextSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByTextSignal (const SimTouchByTextData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimTouchByTextSignal();

    /**
     * Assignment operator
     */
    inline SimTouchByTextSignal& operator = (const SimTouchByTextSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByTextSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByTextSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByTextSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByTextSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimTouchByTextData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimTouchByTextData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimTouchByTextData& data_);

    static const SimTouchByTextSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimTouchByTextData _data;

};

/**
 * send out touch simulation commands to all registered clients
 */
class SimTouchByTextIdSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByTextIdSignal ();

    /**
     * Copy constructor
     */
    inline  SimTouchByTextIdSignal (const SimTouchByTextIdSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByTextIdSignal (const SimTouchByTextIdData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimTouchByTextIdSignal();

    /**
     * Assignment operator
     */
    inline SimTouchByTextIdSignal& operator = (const SimTouchByTextIdSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByTextIdSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByTextIdSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByTextIdSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByTextIdSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimTouchByTextIdData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimTouchByTextIdData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimTouchByTextIdData& data_);

    static const SimTouchByTextIdSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimTouchByTextIdData _data;

};

/**
 * send out touch simulation commands to all registered clients
 */
class SimTouchByIndexSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimTouchByIndexSignal ();

    /**
     * Copy constructor
     */
    inline  SimTouchByIndexSignal (const SimTouchByIndexSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimTouchByIndexSignal (const SimTouchByIndexData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimTouchByIndexSignal();

    /**
     * Assignment operator
     */
    inline SimTouchByIndexSignal& operator = (const SimTouchByIndexSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimTouchByIndexSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimTouchByIndexSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimTouchByIndexSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimTouchByIndexSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimTouchByIndexData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimTouchByIndexData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimTouchByIndexData& data_);

    static const SimTouchByIndexSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimTouchByIndexData _data;

};

/**
 * send out WidgetPropertyValueSetter commands to all registered clients
 */
class WidgetPropertyValueSetterSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WidgetPropertyValueSetterSignal ();

    /**
     * Copy constructor
     */
    inline  WidgetPropertyValueSetterSignal (const WidgetPropertyValueSetterSignal &rhs);

    /**
     * All fields constructor
     */
    inline  WidgetPropertyValueSetterSignal (const WidgetPropertyValueSetterData& data_);

    /**
     * Destructor
     */
    inline virtual  ~WidgetPropertyValueSetterSignal();

    /**
     * Assignment operator
     */
    inline WidgetPropertyValueSetterSignal& operator = (const WidgetPropertyValueSetterSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WidgetPropertyValueSetterSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WidgetPropertyValueSetterSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WidgetPropertyValueSetterSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WidgetPropertyValueSetterSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const WidgetPropertyValueSetterData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline WidgetPropertyValueSetterData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const WidgetPropertyValueSetterData& data_);

    static const WidgetPropertyValueSetterSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    WidgetPropertyValueSetterData _data;

};

/**
 * send out EncoderStatusChangedUpdMsg to all registered clients
 */
class SimRotateEncoderSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimRotateEncoderSignal ();

    /**
     * Copy constructor
     */
    inline  SimRotateEncoderSignal (const SimRotateEncoderSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimRotateEncoderSignal (const SimRotateEncoderData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimRotateEncoderSignal();

    /**
     * Assignment operator
     */
    inline SimRotateEncoderSignal& operator = (const SimRotateEncoderSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimRotateEncoderSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimRotateEncoderSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimRotateEncoderSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimRotateEncoderSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimRotateEncoderData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimRotateEncoderData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimRotateEncoderData& data_);

    static const SimRotateEncoderSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimRotateEncoderData _data;

};

/**
 * send out JoystickStatusChangedUpdMsg to all registered clients
 */
class SimJoystickSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimJoystickSignal ();

    /**
     * Copy constructor
     */
    inline  SimJoystickSignal (const SimJoystickSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimJoystickSignal (const SimJoystickData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimJoystickSignal();

    /**
     * Assignment operator
     */
    inline SimJoystickSignal& operator = (const SimJoystickSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimJoystickSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimJoystickSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimJoystickSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimJoystickSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimJoystickData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimJoystickData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimJoystickData& data_);

    static const SimJoystickSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimJoystickData _data;

};

/**
 * send out EnterKeyStatusChangedUpdMsg to all registered clients
 */
class SimEnterKeySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimEnterKeySignal ();

    /**
     * Copy constructor
     */
    inline  SimEnterKeySignal (const SimEnterKeySignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimEnterKeySignal (const SimEnterKeyData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimEnterKeySignal();

    /**
     * Assignment operator
     */
    inline SimEnterKeySignal& operator = (const SimEnterKeySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimEnterKeySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimEnterKeySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimEnterKeySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimEnterKeySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimEnterKeyData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimEnterKeyData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimEnterKeyData& data_);

    static const SimEnterKeySignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimEnterKeyData _data;

};

/**
 * send out FocusControlReqMsg to all registered clients
 */
class SimFocusReqSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimFocusReqSignal ();

    /**
     * Copy constructor
     */
    inline  SimFocusReqSignal (const SimFocusReqSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SimFocusReqSignal (const SimFocusReqData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SimFocusReqSignal();

    /**
     * Assignment operator
     */
    inline SimFocusReqSignal& operator = (const SimFocusReqSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimFocusReqSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimFocusReqSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimFocusReqSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimFocusReqSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const SimFocusReqData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline SimFocusReqData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const SimFocusReqData& data_);

    static const SimFocusReqSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SimFocusReqData _data;

};

inline  TraceQueryData::TraceQueryData ()  :
    _pid (0),
    _queryId (::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId__GET_CURRENT_MAIN_VIEW),
    _queryInput ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceQueryData::TraceQueryData (const TraceQueryData &rhs)  :
    _pid (0),
    _queryId (::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId__GET_CURRENT_MAIN_VIEW),
    _queryInput ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceQueryData::TraceQueryData (int32 pid_, traceQueryId queryId_, const ::std::vector< ::std::string >& queryInput_)  :
    _pid (pid_),
    _queryId (queryId_),
    _queryInput (queryInput_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(traceQueryId_IsValid(queryId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", queryId_, "traceQueryId", "queryId", "TraceQueryData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TraceQueryData::~TraceQueryData() {
}

inline TraceQueryData& TraceQueryData::operator = (const TraceQueryData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasQueryId()) {
            setQueryId(rhs.getQueryId());
        } else {
            clearQueryId();
        }
        if (rhs.hasQueryInput()) {
            setQueryInput(rhs.getQueryInput());
        } else {
            clearQueryInput();
        }
    }
    return *this;
}

inline bool TraceQueryData::operator == (const TraceQueryData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasQueryId() && !rhs.hasQueryId()) || getQueryId() == rhs.getQueryId()) &&
        ((!hasQueryInput() && !rhs.hasQueryInput()) || getQueryInput() == rhs.getQueryInput()));
}

inline bool TraceQueryData::operator != (const TraceQueryData& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceQueryData::operator < (const TraceQueryData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasQueryId() || rhs.hasQueryId()) {
        if ((uint32)getQueryId() < (uint32)rhs.getQueryId()) return true;
        if ((uint32)getQueryId() > (uint32)rhs.getQueryId()) return false;
    }
    if (hasQueryInput() || rhs.hasQueryInput()) {
        if (getQueryInput() < rhs.getQueryInput()) return true;
        if (getQueryInput() > rhs.getQueryInput()) return false;
    }
    return false;
}

inline bool TraceQueryData::operator > (const TraceQueryData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceQueryData::clear() {
    clearPid();
    clearQueryId();
    clearQueryInput();
}

inline void TraceQueryData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool TraceQueryData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 TraceQueryData::getPid () const {
    return _pid;
}

inline void TraceQueryData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void TraceQueryData::clearQueryId() {
    if (hasQueryId()) {
         clear_has_queryId();
        _queryId = ::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId__GET_CURRENT_MAIN_VIEW;
     }
}

inline bool TraceQueryData::hasQueryId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline traceQueryId TraceQueryData::getQueryId () const {
    return _queryId;
}

inline void TraceQueryData::setQueryId (traceQueryId queryId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(traceQueryId_IsValid(queryId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", queryId_, "traceQueryId", "queryId", "TraceQueryData");
    }
    set_has_queryId();
    this->_queryId = queryId_;
}

inline void TraceQueryData::clearQueryInput() {
    if (hasQueryInput()) {
         clear_has_queryInput();
        _queryInput.clear();
     }
}

inline bool TraceQueryData::hasQueryInput () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& TraceQueryData::getQueryInput () const {
    return _queryInput;
}

inline ::std::vector< ::std::string >& TraceQueryData::getQueryInputMutable () {
    set_has_queryInput();
    return _queryInput;
}

inline void TraceQueryData::setQueryInput (const ::std::vector< ::std::string >& queryInput_) {
    set_has_queryInput();
    this->_queryInput = queryInput_;
}

inline void TraceQueryData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void TraceQueryData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TraceQueryData::set_has_queryId () {
    _has_bits_[0] |= 1u << 1;
}

inline void TraceQueryData::clear_has_queryId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TraceQueryData::set_has_queryInput () {
    _has_bits_[0] |= 1u << 2;
}

inline void TraceQueryData::clear_has_queryInput () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimTouchData::SimTouchData ()  :
    _pid (0),
    _xPos (0),
    _yPos (0),
    _surfaceId (0),
    _pointerId (0),
    _status (::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates__DOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchData::SimTouchData (const SimTouchData &rhs)  :
    _pid (0),
    _xPos (0),
    _yPos (0),
    _surfaceId (0),
    _pointerId (0),
    _status (::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates__DOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchData::SimTouchData (int32 pid_, int32 xPos_, int32 yPos_, int32 surfaceId_, int32 pointerId_, simulatedTouchStates status_)  :
    _pid (pid_),
    _xPos (xPos_),
    _yPos (yPos_),
    _surfaceId (surfaceId_),
    _pointerId (pointerId_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(simulatedTouchStates_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "simulatedTouchStates", "status", "SimTouchData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchData::~SimTouchData() {
}

inline SimTouchData& SimTouchData::operator = (const SimTouchData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasXPos()) {
            setXPos(rhs.getXPos());
        } else {
            clearXPos();
        }
        if (rhs.hasYPos()) {
            setYPos(rhs.getYPos());
        } else {
            clearYPos();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasPointerId()) {
            setPointerId(rhs.getPointerId());
        } else {
            clearPointerId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SimTouchData::operator == (const SimTouchData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasXPos() && !rhs.hasXPos()) || getXPos() == rhs.getXPos()) &&
        ((!hasYPos() && !rhs.hasYPos()) || getYPos() == rhs.getYPos()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasPointerId() && !rhs.hasPointerId()) || getPointerId() == rhs.getPointerId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SimTouchData::operator != (const SimTouchData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchData::operator < (const SimTouchData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasXPos() || rhs.hasXPos()) {
        if (getXPos() < rhs.getXPos()) return true;
        if (getXPos() > rhs.getXPos()) return false;
    }
    if (hasYPos() || rhs.hasYPos()) {
        if (getYPos() < rhs.getYPos()) return true;
        if (getYPos() > rhs.getYPos()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasPointerId() || rhs.hasPointerId()) {
        if (getPointerId() < rhs.getPointerId()) return true;
        if (getPointerId() > rhs.getPointerId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool SimTouchData::operator > (const SimTouchData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchData::clear() {
    clearPid();
    clearXPos();
    clearYPos();
    clearSurfaceId();
    clearPointerId();
    clearStatus();
}

inline void SimTouchData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimTouchData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimTouchData::getPid () const {
    return _pid;
}

inline void SimTouchData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimTouchData::clearXPos() {
    if (hasXPos()) {
         clear_has_xPos();
        _xPos = 0;
     }
}

inline bool SimTouchData::hasXPos () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimTouchData::getXPos () const {
    return _xPos;
}

inline void SimTouchData::setXPos (int32 xPos_) {
    set_has_xPos();
    this->_xPos = xPos_;
}

inline void SimTouchData::clearYPos() {
    if (hasYPos()) {
         clear_has_yPos();
        _yPos = 0;
     }
}

inline bool SimTouchData::hasYPos () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimTouchData::getYPos () const {
    return _yPos;
}

inline void SimTouchData::setYPos (int32 yPos_) {
    set_has_yPos();
    this->_yPos = yPos_;
}

inline void SimTouchData::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0;
     }
}

inline bool SimTouchData::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 SimTouchData::getSurfaceId () const {
    return _surfaceId;
}

inline void SimTouchData::setSurfaceId (int32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void SimTouchData::clearPointerId() {
    if (hasPointerId()) {
         clear_has_pointerId();
        _pointerId = 0;
     }
}

inline bool SimTouchData::hasPointerId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 SimTouchData::getPointerId () const {
    return _pointerId;
}

inline void SimTouchData::setPointerId (int32 pointerId_) {
    set_has_pointerId();
    this->_pointerId = pointerId_;
}

inline void SimTouchData::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates__DOWN;
     }
}

inline bool SimTouchData::hasStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline simulatedTouchStates SimTouchData::getStatus () const {
    return _status;
}

inline void SimTouchData::setStatus (simulatedTouchStates status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(simulatedTouchStates_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "simulatedTouchStates", "status", "SimTouchData");
    }
    set_has_status();
    this->_status = status_;
}

inline void SimTouchData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimTouchData::set_has_xPos () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimTouchData::clear_has_xPos () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimTouchData::set_has_yPos () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimTouchData::clear_has_yPos () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimTouchData::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimTouchData::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SimTouchData::set_has_pointerId () {
    _has_bits_[0] |= 1u << 4;
}

inline void SimTouchData::clear_has_pointerId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SimTouchData::set_has_status () {
    _has_bits_[0] |= 1u << 5;
}

inline void SimTouchData::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  Rect::Rect ()  :
    _xPos (0),
    _yPos (0),
    _width (0),
    _height (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Rect::Rect (const Rect &rhs)  :
    _xPos (0),
    _yPos (0),
    _width (0),
    _height (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Rect::Rect (int32 xPos_, int32 yPos_, int32 width_, int32 height_)  :
    _xPos (xPos_),
    _yPos (yPos_),
    _width (width_),
    _height (height_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Rect::~Rect() {
}

inline Rect& Rect::operator = (const Rect& rhs) {
    if( this != &rhs ) {
        if (rhs.hasXPos()) {
            setXPos(rhs.getXPos());
        } else {
            clearXPos();
        }
        if (rhs.hasYPos()) {
            setYPos(rhs.getYPos());
        } else {
            clearYPos();
        }
        if (rhs.hasWidth()) {
            setWidth(rhs.getWidth());
        } else {
            clearWidth();
        }
        if (rhs.hasHeight()) {
            setHeight(rhs.getHeight());
        } else {
            clearHeight();
        }
    }
    return *this;
}

inline bool Rect::operator == (const Rect& rhs) const {
    return (((!hasXPos() && !rhs.hasXPos()) || getXPos() == rhs.getXPos()) &&
        ((!hasYPos() && !rhs.hasYPos()) || getYPos() == rhs.getYPos()) &&
        ((!hasWidth() && !rhs.hasWidth()) || getWidth() == rhs.getWidth()) &&
        ((!hasHeight() && !rhs.hasHeight()) || getHeight() == rhs.getHeight()));
}

inline bool Rect::operator != (const Rect& rhs) const {
    return ! (*this == rhs);
}

inline bool Rect::operator < (const Rect& rhs) const {
    if (hasXPos() || rhs.hasXPos()) {
        if (getXPos() < rhs.getXPos()) return true;
        if (getXPos() > rhs.getXPos()) return false;
    }
    if (hasYPos() || rhs.hasYPos()) {
        if (getYPos() < rhs.getYPos()) return true;
        if (getYPos() > rhs.getYPos()) return false;
    }
    if (hasWidth() || rhs.hasWidth()) {
        if (getWidth() < rhs.getWidth()) return true;
        if (getWidth() > rhs.getWidth()) return false;
    }
    if (hasHeight() || rhs.hasHeight()) {
        if (getHeight() < rhs.getHeight()) return true;
        if (getHeight() > rhs.getHeight()) return false;
    }
    return false;
}

inline bool Rect::operator > (const Rect& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Rect::clear() {
    clearXPos();
    clearYPos();
    clearWidth();
    clearHeight();
}

inline void Rect::clearXPos() {
    if (hasXPos()) {
         clear_has_xPos();
        _xPos = 0;
     }
}

inline bool Rect::hasXPos () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 Rect::getXPos () const {
    return _xPos;
}

inline void Rect::setXPos (int32 xPos_) {
    set_has_xPos();
    this->_xPos = xPos_;
}

inline void Rect::clearYPos() {
    if (hasYPos()) {
         clear_has_yPos();
        _yPos = 0;
     }
}

inline bool Rect::hasYPos () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 Rect::getYPos () const {
    return _yPos;
}

inline void Rect::setYPos (int32 yPos_) {
    set_has_yPos();
    this->_yPos = yPos_;
}

inline void Rect::clearWidth() {
    if (hasWidth()) {
         clear_has_width();
        _width = 0;
     }
}

inline bool Rect::hasWidth () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 Rect::getWidth () const {
    return _width;
}

inline void Rect::setWidth (int32 width_) {
    set_has_width();
    this->_width = width_;
}

inline void Rect::clearHeight() {
    if (hasHeight()) {
         clear_has_height();
        _height = 0;
     }
}

inline bool Rect::hasHeight () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 Rect::getHeight () const {
    return _height;
}

inline void Rect::setHeight (int32 height_) {
    set_has_height();
    this->_height = height_;
}

inline void Rect::set_has_xPos () {
    _has_bits_[0] |= 1u << 0;
}

inline void Rect::clear_has_xPos () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Rect::set_has_yPos () {
    _has_bits_[0] |= 1u << 1;
}

inline void Rect::clear_has_yPos () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Rect::set_has_width () {
    _has_bits_[0] |= 1u << 2;
}

inline void Rect::clear_has_width () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Rect::set_has_height () {
    _has_bits_[0] |= 1u << 3;
}

inline void Rect::clear_has_height () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SurfaceInfo::SurfaceInfo ()  :
    _surfaceId (0),
    _rect ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SurfaceInfo::SurfaceInfo (const SurfaceInfo &rhs)  :
    _surfaceId (0),
    _rect ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SurfaceInfo::SurfaceInfo (int32 surfaceId_, const Rect& rect_)  :
    _surfaceId (surfaceId_),
    _rect (rect_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SurfaceInfo::~SurfaceInfo() {
}

inline SurfaceInfo& SurfaceInfo::operator = (const SurfaceInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasRect()) {
            setRect(rhs.getRect());
        } else {
            clearRect();
        }
    }
    return *this;
}

inline bool SurfaceInfo::operator == (const SurfaceInfo& rhs) const {
    return (((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasRect() && !rhs.hasRect()) || getRect() == rhs.getRect()));
}

inline bool SurfaceInfo::operator != (const SurfaceInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool SurfaceInfo::operator < (const SurfaceInfo& rhs) const {
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasRect() || rhs.hasRect()) {
        if (getRect() < rhs.getRect()) return true;
        if (getRect() > rhs.getRect()) return false;
    }
    return false;
}

inline bool SurfaceInfo::operator > (const SurfaceInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SurfaceInfo::clear() {
    clearSurfaceId();
    clearRect();
}

inline void SurfaceInfo::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0;
     }
}

inline bool SurfaceInfo::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SurfaceInfo::getSurfaceId () const {
    return _surfaceId;
}

inline void SurfaceInfo::setSurfaceId (int32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void SurfaceInfo::clearRect() {
    if (hasRect()) {
         clear_has_rect();
        _rect.clear();
     }
}

inline bool SurfaceInfo::hasRect () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const Rect& SurfaceInfo::getRect () const {
    return _rect;
}

inline Rect& SurfaceInfo::getRectMutable () {
    set_has_rect();
    return _rect;
}

inline void SurfaceInfo::setRect (const Rect& rect_) {
    set_has_rect();
    this->_rect = rect_;
}

inline void SurfaceInfo::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SurfaceInfo::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SurfaceInfo::set_has_rect () {
    _has_bits_[0] |= 1u << 1;
}

inline void SurfaceInfo::clear_has_rect () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SimTouchByNameData::SimTouchByNameData ()  :
    _pid (0),
    _touchableSurfaces (),
    _widgetName (),
    _viewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByNameData::SimTouchByNameData (const SimTouchByNameData &rhs)  :
    _pid (0),
    _touchableSurfaces (),
    _widgetName (),
    _viewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByNameData::SimTouchByNameData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetName_, const ::std::string& viewName_)  :
    _pid (pid_),
    _touchableSurfaces (touchableSurfaces_),
    _widgetName (widgetName_),
    _viewName (viewName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByNameData::~SimTouchByNameData() {
}

inline SimTouchByNameData& SimTouchByNameData::operator = (const SimTouchByNameData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasTouchableSurfaces()) {
            setTouchableSurfaces(rhs.getTouchableSurfaces());
        } else {
            clearTouchableSurfaces();
        }
        if (rhs.hasWidgetName()) {
            setWidgetName(rhs.getWidgetName());
        } else {
            clearWidgetName();
        }
        if (rhs.hasViewName()) {
            setViewName(rhs.getViewName());
        } else {
            clearViewName();
        }
    }
    return *this;
}

inline bool SimTouchByNameData::operator == (const SimTouchByNameData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasTouchableSurfaces() && !rhs.hasTouchableSurfaces()) || getTouchableSurfaces() == rhs.getTouchableSurfaces()) &&
        ((!hasWidgetName() && !rhs.hasWidgetName()) || getWidgetName() == rhs.getWidgetName()) &&
        ((!hasViewName() && !rhs.hasViewName()) || getViewName() == rhs.getViewName()));
}

inline bool SimTouchByNameData::operator != (const SimTouchByNameData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByNameData::operator < (const SimTouchByNameData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasTouchableSurfaces() || rhs.hasTouchableSurfaces()) {
        if (getTouchableSurfaces() < rhs.getTouchableSurfaces()) return true;
        if (getTouchableSurfaces() > rhs.getTouchableSurfaces()) return false;
    }
    if (hasWidgetName() || rhs.hasWidgetName()) {
        if (getWidgetName() < rhs.getWidgetName()) return true;
        if (getWidgetName() > rhs.getWidgetName()) return false;
    }
    if (hasViewName() || rhs.hasViewName()) {
        if (getViewName() < rhs.getViewName()) return true;
        if (getViewName() > rhs.getViewName()) return false;
    }
    return false;
}

inline bool SimTouchByNameData::operator > (const SimTouchByNameData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByNameData::clear() {
    clearPid();
    clearTouchableSurfaces();
    clearWidgetName();
    clearViewName();
}

inline void SimTouchByNameData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimTouchByNameData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimTouchByNameData::getPid () const {
    return _pid;
}

inline void SimTouchByNameData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimTouchByNameData::clearTouchableSurfaces() {
    if (hasTouchableSurfaces()) {
         clear_has_touchableSurfaces();
        _touchableSurfaces.clear();
     }
}

inline bool SimTouchByNameData::hasTouchableSurfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SurfaceInfo >& SimTouchByNameData::getTouchableSurfaces () const {
    return _touchableSurfaces;
}

inline ::std::vector< SurfaceInfo >& SimTouchByNameData::getTouchableSurfacesMutable () {
    set_has_touchableSurfaces();
    return _touchableSurfaces;
}

inline void SimTouchByNameData::setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_) {
    set_has_touchableSurfaces();
    this->_touchableSurfaces = touchableSurfaces_;
}

inline void SimTouchByNameData::clearWidgetName() {
    if (hasWidgetName()) {
         clear_has_widgetName();
        _widgetName.clear();
     }
}

inline bool SimTouchByNameData::hasWidgetName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SimTouchByNameData::getWidgetName () const {
    return _widgetName;
}

inline ::std::string& SimTouchByNameData::getWidgetNameMutable () {
    set_has_widgetName();
    return _widgetName;
}

inline void SimTouchByNameData::setWidgetName (const ::std::string& widgetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName = widgetName_;
}

inline void SimTouchByNameData::setWidgetName (const char* widgetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName.assign(widgetName_);
}

inline void SimTouchByNameData::setWidgetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName.assign(value, size);
}

inline void SimTouchByNameData::clearViewName() {
    if (hasViewName()) {
         clear_has_viewName();
        _viewName.clear();
     }
}

inline bool SimTouchByNameData::hasViewName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SimTouchByNameData::getViewName () const {
    return _viewName;
}

inline ::std::string& SimTouchByNameData::getViewNameMutable () {
    set_has_viewName();
    return _viewName;
}

inline void SimTouchByNameData::setViewName (const ::std::string& viewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName = viewName_;
}

inline void SimTouchByNameData::setViewName (const char* viewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName.assign(viewName_);
}

inline void SimTouchByNameData::setViewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName.assign(value, size);
}

inline void SimTouchByNameData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByNameData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimTouchByNameData::set_has_touchableSurfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimTouchByNameData::clear_has_touchableSurfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimTouchByNameData::set_has_widgetName () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimTouchByNameData::clear_has_widgetName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimTouchByNameData::set_has_viewName () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimTouchByNameData::clear_has_viewName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SimTouchByTextData::SimTouchByTextData ()  :
    _pid (0),
    _touchableSurfaces (),
    _widgetText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByTextData::SimTouchByTextData (const SimTouchByTextData &rhs)  :
    _pid (0),
    _touchableSurfaces (),
    _widgetText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByTextData::SimTouchByTextData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetText_)  :
    _pid (pid_),
    _touchableSurfaces (touchableSurfaces_),
    _widgetText (widgetText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByTextData::~SimTouchByTextData() {
}

inline SimTouchByTextData& SimTouchByTextData::operator = (const SimTouchByTextData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasTouchableSurfaces()) {
            setTouchableSurfaces(rhs.getTouchableSurfaces());
        } else {
            clearTouchableSurfaces();
        }
        if (rhs.hasWidgetText()) {
            setWidgetText(rhs.getWidgetText());
        } else {
            clearWidgetText();
        }
    }
    return *this;
}

inline bool SimTouchByTextData::operator == (const SimTouchByTextData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasTouchableSurfaces() && !rhs.hasTouchableSurfaces()) || getTouchableSurfaces() == rhs.getTouchableSurfaces()) &&
        ((!hasWidgetText() && !rhs.hasWidgetText()) || getWidgetText() == rhs.getWidgetText()));
}

inline bool SimTouchByTextData::operator != (const SimTouchByTextData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByTextData::operator < (const SimTouchByTextData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasTouchableSurfaces() || rhs.hasTouchableSurfaces()) {
        if (getTouchableSurfaces() < rhs.getTouchableSurfaces()) return true;
        if (getTouchableSurfaces() > rhs.getTouchableSurfaces()) return false;
    }
    if (hasWidgetText() || rhs.hasWidgetText()) {
        if (getWidgetText() < rhs.getWidgetText()) return true;
        if (getWidgetText() > rhs.getWidgetText()) return false;
    }
    return false;
}

inline bool SimTouchByTextData::operator > (const SimTouchByTextData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByTextData::clear() {
    clearPid();
    clearTouchableSurfaces();
    clearWidgetText();
}

inline void SimTouchByTextData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimTouchByTextData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimTouchByTextData::getPid () const {
    return _pid;
}

inline void SimTouchByTextData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimTouchByTextData::clearTouchableSurfaces() {
    if (hasTouchableSurfaces()) {
         clear_has_touchableSurfaces();
        _touchableSurfaces.clear();
     }
}

inline bool SimTouchByTextData::hasTouchableSurfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SurfaceInfo >& SimTouchByTextData::getTouchableSurfaces () const {
    return _touchableSurfaces;
}

inline ::std::vector< SurfaceInfo >& SimTouchByTextData::getTouchableSurfacesMutable () {
    set_has_touchableSurfaces();
    return _touchableSurfaces;
}

inline void SimTouchByTextData::setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_) {
    set_has_touchableSurfaces();
    this->_touchableSurfaces = touchableSurfaces_;
}

inline void SimTouchByTextData::clearWidgetText() {
    if (hasWidgetText()) {
         clear_has_widgetText();
        _widgetText.clear();
     }
}

inline bool SimTouchByTextData::hasWidgetText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SimTouchByTextData::getWidgetText () const {
    return _widgetText;
}

inline ::std::string& SimTouchByTextData::getWidgetTextMutable () {
    set_has_widgetText();
    return _widgetText;
}

inline void SimTouchByTextData::setWidgetText (const ::std::string& widgetText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetText();
    this->_widgetText = widgetText_;
}

inline void SimTouchByTextData::setWidgetText (const char* widgetText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetText();
    this->_widgetText.assign(widgetText_);
}

inline void SimTouchByTextData::setWidgetText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetText();
    this->_widgetText.assign(value, size);
}

inline void SimTouchByTextData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByTextData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimTouchByTextData::set_has_touchableSurfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimTouchByTextData::clear_has_touchableSurfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimTouchByTextData::set_has_widgetText () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimTouchByTextData::clear_has_widgetText () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimTouchByTextIdData::SimTouchByTextIdData ()  :
    _pid (0),
    _touchableSurfaces (),
    _widgetTextId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByTextIdData::SimTouchByTextIdData (const SimTouchByTextIdData &rhs)  :
    _pid (0),
    _touchableSurfaces (),
    _widgetTextId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByTextIdData::SimTouchByTextIdData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, const ::std::string& widgetTextId_)  :
    _pid (pid_),
    _touchableSurfaces (touchableSurfaces_),
    _widgetTextId (widgetTextId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetTextId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByTextIdData::~SimTouchByTextIdData() {
}

inline SimTouchByTextIdData& SimTouchByTextIdData::operator = (const SimTouchByTextIdData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasTouchableSurfaces()) {
            setTouchableSurfaces(rhs.getTouchableSurfaces());
        } else {
            clearTouchableSurfaces();
        }
        if (rhs.hasWidgetTextId()) {
            setWidgetTextId(rhs.getWidgetTextId());
        } else {
            clearWidgetTextId();
        }
    }
    return *this;
}

inline bool SimTouchByTextIdData::operator == (const SimTouchByTextIdData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasTouchableSurfaces() && !rhs.hasTouchableSurfaces()) || getTouchableSurfaces() == rhs.getTouchableSurfaces()) &&
        ((!hasWidgetTextId() && !rhs.hasWidgetTextId()) || getWidgetTextId() == rhs.getWidgetTextId()));
}

inline bool SimTouchByTextIdData::operator != (const SimTouchByTextIdData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByTextIdData::operator < (const SimTouchByTextIdData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasTouchableSurfaces() || rhs.hasTouchableSurfaces()) {
        if (getTouchableSurfaces() < rhs.getTouchableSurfaces()) return true;
        if (getTouchableSurfaces() > rhs.getTouchableSurfaces()) return false;
    }
    if (hasWidgetTextId() || rhs.hasWidgetTextId()) {
        if (getWidgetTextId() < rhs.getWidgetTextId()) return true;
        if (getWidgetTextId() > rhs.getWidgetTextId()) return false;
    }
    return false;
}

inline bool SimTouchByTextIdData::operator > (const SimTouchByTextIdData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByTextIdData::clear() {
    clearPid();
    clearTouchableSurfaces();
    clearWidgetTextId();
}

inline void SimTouchByTextIdData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimTouchByTextIdData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimTouchByTextIdData::getPid () const {
    return _pid;
}

inline void SimTouchByTextIdData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimTouchByTextIdData::clearTouchableSurfaces() {
    if (hasTouchableSurfaces()) {
         clear_has_touchableSurfaces();
        _touchableSurfaces.clear();
     }
}

inline bool SimTouchByTextIdData::hasTouchableSurfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SurfaceInfo >& SimTouchByTextIdData::getTouchableSurfaces () const {
    return _touchableSurfaces;
}

inline ::std::vector< SurfaceInfo >& SimTouchByTextIdData::getTouchableSurfacesMutable () {
    set_has_touchableSurfaces();
    return _touchableSurfaces;
}

inline void SimTouchByTextIdData::setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_) {
    set_has_touchableSurfaces();
    this->_touchableSurfaces = touchableSurfaces_;
}

inline void SimTouchByTextIdData::clearWidgetTextId() {
    if (hasWidgetTextId()) {
         clear_has_widgetTextId();
        _widgetTextId.clear();
     }
}

inline bool SimTouchByTextIdData::hasWidgetTextId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SimTouchByTextIdData::getWidgetTextId () const {
    return _widgetTextId;
}

inline ::std::string& SimTouchByTextIdData::getWidgetTextIdMutable () {
    set_has_widgetTextId();
    return _widgetTextId;
}

inline void SimTouchByTextIdData::setWidgetTextId (const ::std::string& widgetTextId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetTextId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetTextId();
    this->_widgetTextId = widgetTextId_;
}

inline void SimTouchByTextIdData::setWidgetTextId (const char* widgetTextId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetTextId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetTextId();
    this->_widgetTextId.assign(widgetTextId_);
}

inline void SimTouchByTextIdData::setWidgetTextId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetTextId();
    this->_widgetTextId.assign(value, size);
}

inline void SimTouchByTextIdData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByTextIdData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimTouchByTextIdData::set_has_touchableSurfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimTouchByTextIdData::clear_has_touchableSurfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimTouchByTextIdData::set_has_widgetTextId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimTouchByTextIdData::clear_has_widgetTextId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimTouchByIndexData::SimTouchByIndexData ()  :
    _pid (0),
    _touchableSurfaces (),
    _ListID (0),
    _ButtonWidgetIndex (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByIndexData::SimTouchByIndexData (const SimTouchByIndexData &rhs)  :
    _pid (0),
    _touchableSurfaces (),
    _ListID (0),
    _ButtonWidgetIndex (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByIndexData::SimTouchByIndexData (int32 pid_, const ::std::vector< SurfaceInfo >& touchableSurfaces_, int32 ListID_, int32 ButtonWidgetIndex_)  :
    _pid (pid_),
    _touchableSurfaces (touchableSurfaces_),
    _ListID (ListID_),
    _ButtonWidgetIndex (ButtonWidgetIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByIndexData::~SimTouchByIndexData() {
}

inline SimTouchByIndexData& SimTouchByIndexData::operator = (const SimTouchByIndexData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasTouchableSurfaces()) {
            setTouchableSurfaces(rhs.getTouchableSurfaces());
        } else {
            clearTouchableSurfaces();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasButtonWidgetIndex()) {
            setButtonWidgetIndex(rhs.getButtonWidgetIndex());
        } else {
            clearButtonWidgetIndex();
        }
    }
    return *this;
}

inline bool SimTouchByIndexData::operator == (const SimTouchByIndexData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasTouchableSurfaces() && !rhs.hasTouchableSurfaces()) || getTouchableSurfaces() == rhs.getTouchableSurfaces()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasButtonWidgetIndex() && !rhs.hasButtonWidgetIndex()) || getButtonWidgetIndex() == rhs.getButtonWidgetIndex()));
}

inline bool SimTouchByIndexData::operator != (const SimTouchByIndexData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByIndexData::operator < (const SimTouchByIndexData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasTouchableSurfaces() || rhs.hasTouchableSurfaces()) {
        if (getTouchableSurfaces() < rhs.getTouchableSurfaces()) return true;
        if (getTouchableSurfaces() > rhs.getTouchableSurfaces()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasButtonWidgetIndex() || rhs.hasButtonWidgetIndex()) {
        if (getButtonWidgetIndex() < rhs.getButtonWidgetIndex()) return true;
        if (getButtonWidgetIndex() > rhs.getButtonWidgetIndex()) return false;
    }
    return false;
}

inline bool SimTouchByIndexData::operator > (const SimTouchByIndexData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByIndexData::clear() {
    clearPid();
    clearTouchableSurfaces();
    clearListID();
    clearButtonWidgetIndex();
}

inline void SimTouchByIndexData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimTouchByIndexData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimTouchByIndexData::getPid () const {
    return _pid;
}

inline void SimTouchByIndexData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimTouchByIndexData::clearTouchableSurfaces() {
    if (hasTouchableSurfaces()) {
         clear_has_touchableSurfaces();
        _touchableSurfaces.clear();
     }
}

inline bool SimTouchByIndexData::hasTouchableSurfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< SurfaceInfo >& SimTouchByIndexData::getTouchableSurfaces () const {
    return _touchableSurfaces;
}

inline ::std::vector< SurfaceInfo >& SimTouchByIndexData::getTouchableSurfacesMutable () {
    set_has_touchableSurfaces();
    return _touchableSurfaces;
}

inline void SimTouchByIndexData::setTouchableSurfaces (const ::std::vector< SurfaceInfo >& touchableSurfaces_) {
    set_has_touchableSurfaces();
    this->_touchableSurfaces = touchableSurfaces_;
}

inline void SimTouchByIndexData::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0;
     }
}

inline bool SimTouchByIndexData::hasListID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimTouchByIndexData::getListID () const {
    return _ListID;
}

inline void SimTouchByIndexData::setListID (int32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void SimTouchByIndexData::clearButtonWidgetIndex() {
    if (hasButtonWidgetIndex()) {
         clear_has_ButtonWidgetIndex();
        _ButtonWidgetIndex = 0;
     }
}

inline bool SimTouchByIndexData::hasButtonWidgetIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 SimTouchByIndexData::getButtonWidgetIndex () const {
    return _ButtonWidgetIndex;
}

inline void SimTouchByIndexData::setButtonWidgetIndex (int32 ButtonWidgetIndex_) {
    set_has_ButtonWidgetIndex();
    this->_ButtonWidgetIndex = ButtonWidgetIndex_;
}

inline void SimTouchByIndexData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByIndexData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimTouchByIndexData::set_has_touchableSurfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimTouchByIndexData::clear_has_touchableSurfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimTouchByIndexData::set_has_ListID () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimTouchByIndexData::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimTouchByIndexData::set_has_ButtonWidgetIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimTouchByIndexData::clear_has_ButtonWidgetIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  WidgetPropertyValueSetterData::WidgetPropertyValueSetterData ()  :
    _pid (0),
    _widgetNames (),
    _propertyName (),
    _propertyValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WidgetPropertyValueSetterData::WidgetPropertyValueSetterData (const WidgetPropertyValueSetterData &rhs)  :
    _pid (0),
    _widgetNames (),
    _propertyName (),
    _propertyValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WidgetPropertyValueSetterData::WidgetPropertyValueSetterData (int32 pid_, const ::std::vector< ::std::string >& widgetNames_, const ::std::string& propertyName_, const ::std::string& propertyValue_)  :
    _pid (pid_),
    _widgetNames (widgetNames_),
    _propertyName (propertyName_),
    _propertyValue (propertyValue_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyValue_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WidgetPropertyValueSetterData::~WidgetPropertyValueSetterData() {
}

inline WidgetPropertyValueSetterData& WidgetPropertyValueSetterData::operator = (const WidgetPropertyValueSetterData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasWidgetNames()) {
            setWidgetNames(rhs.getWidgetNames());
        } else {
            clearWidgetNames();
        }
        if (rhs.hasPropertyName()) {
            setPropertyName(rhs.getPropertyName());
        } else {
            clearPropertyName();
        }
        if (rhs.hasPropertyValue()) {
            setPropertyValue(rhs.getPropertyValue());
        } else {
            clearPropertyValue();
        }
    }
    return *this;
}

inline bool WidgetPropertyValueSetterData::operator == (const WidgetPropertyValueSetterData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasWidgetNames() && !rhs.hasWidgetNames()) || getWidgetNames() == rhs.getWidgetNames()) &&
        ((!hasPropertyName() && !rhs.hasPropertyName()) || getPropertyName() == rhs.getPropertyName()) &&
        ((!hasPropertyValue() && !rhs.hasPropertyValue()) || getPropertyValue() == rhs.getPropertyValue()));
}

inline bool WidgetPropertyValueSetterData::operator != (const WidgetPropertyValueSetterData& rhs) const {
    return ! (*this == rhs);
}

inline bool WidgetPropertyValueSetterData::operator < (const WidgetPropertyValueSetterData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasWidgetNames() || rhs.hasWidgetNames()) {
        if (getWidgetNames() < rhs.getWidgetNames()) return true;
        if (getWidgetNames() > rhs.getWidgetNames()) return false;
    }
    if (hasPropertyName() || rhs.hasPropertyName()) {
        if (getPropertyName() < rhs.getPropertyName()) return true;
        if (getPropertyName() > rhs.getPropertyName()) return false;
    }
    if (hasPropertyValue() || rhs.hasPropertyValue()) {
        if (getPropertyValue() < rhs.getPropertyValue()) return true;
        if (getPropertyValue() > rhs.getPropertyValue()) return false;
    }
    return false;
}

inline bool WidgetPropertyValueSetterData::operator > (const WidgetPropertyValueSetterData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WidgetPropertyValueSetterData::clear() {
    clearPid();
    clearWidgetNames();
    clearPropertyName();
    clearPropertyValue();
}

inline void WidgetPropertyValueSetterData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool WidgetPropertyValueSetterData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 WidgetPropertyValueSetterData::getPid () const {
    return _pid;
}

inline void WidgetPropertyValueSetterData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void WidgetPropertyValueSetterData::clearWidgetNames() {
    if (hasWidgetNames()) {
         clear_has_widgetNames();
        _widgetNames.clear();
     }
}

inline bool WidgetPropertyValueSetterData::hasWidgetNames () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& WidgetPropertyValueSetterData::getWidgetNames () const {
    return _widgetNames;
}

inline ::std::vector< ::std::string >& WidgetPropertyValueSetterData::getWidgetNamesMutable () {
    set_has_widgetNames();
    return _widgetNames;
}

inline void WidgetPropertyValueSetterData::setWidgetNames (const ::std::vector< ::std::string >& widgetNames_) {
    set_has_widgetNames();
    this->_widgetNames = widgetNames_;
}

inline void WidgetPropertyValueSetterData::clearPropertyName() {
    if (hasPropertyName()) {
         clear_has_propertyName();
        _propertyName.clear();
     }
}

inline bool WidgetPropertyValueSetterData::hasPropertyName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& WidgetPropertyValueSetterData::getPropertyName () const {
    return _propertyName;
}

inline ::std::string& WidgetPropertyValueSetterData::getPropertyNameMutable () {
    set_has_propertyName();
    return _propertyName;
}

inline void WidgetPropertyValueSetterData::setPropertyName (const ::std::string& propertyName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyName();
    this->_propertyName = propertyName_;
}

inline void WidgetPropertyValueSetterData::setPropertyName (const char* propertyName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyName();
    this->_propertyName.assign(propertyName_);
}

inline void WidgetPropertyValueSetterData::setPropertyName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyName();
    this->_propertyName.assign(value, size);
}

inline void WidgetPropertyValueSetterData::clearPropertyValue() {
    if (hasPropertyValue()) {
         clear_has_propertyValue();
        _propertyValue.clear();
     }
}

inline bool WidgetPropertyValueSetterData::hasPropertyValue () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& WidgetPropertyValueSetterData::getPropertyValue () const {
    return _propertyValue;
}

inline ::std::string& WidgetPropertyValueSetterData::getPropertyValueMutable () {
    set_has_propertyValue();
    return _propertyValue;
}

inline void WidgetPropertyValueSetterData::setPropertyValue (const ::std::string& propertyValue_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyValue_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyValue();
    this->_propertyValue = propertyValue_;
}

inline void WidgetPropertyValueSetterData::setPropertyValue (const char* propertyValue_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (propertyValue_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyValue();
    this->_propertyValue.assign(propertyValue_);
}

inline void WidgetPropertyValueSetterData::setPropertyValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_propertyValue();
    this->_propertyValue.assign(value, size);
}

inline void WidgetPropertyValueSetterData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void WidgetPropertyValueSetterData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void WidgetPropertyValueSetterData::set_has_widgetNames () {
    _has_bits_[0] |= 1u << 1;
}

inline void WidgetPropertyValueSetterData::clear_has_widgetNames () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void WidgetPropertyValueSetterData::set_has_propertyName () {
    _has_bits_[0] |= 1u << 2;
}

inline void WidgetPropertyValueSetterData::clear_has_propertyName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void WidgetPropertyValueSetterData::set_has_propertyValue () {
    _has_bits_[0] |= 1u << 3;
}

inline void WidgetPropertyValueSetterData::clear_has_propertyValue () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SimRotateEncoderData::SimRotateEncoderData ()  :
    _pid (0),
    _encCode (),
    _encSteps (0),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimRotateEncoderData::SimRotateEncoderData (const SimRotateEncoderData &rhs)  :
    _pid (0),
    _encCode (),
    _encSteps (0),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimRotateEncoderData::SimRotateEncoderData (int32 pid_, const ::std::string& encCode_, int32 encSteps_, uint32 userData_)  :
    _pid (pid_),
    _encCode (encCode_),
    _encSteps (encSteps_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimRotateEncoderData::~SimRotateEncoderData() {
}

inline SimRotateEncoderData& SimRotateEncoderData::operator = (const SimRotateEncoderData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasEncCode()) {
            setEncCode(rhs.getEncCode());
        } else {
            clearEncCode();
        }
        if (rhs.hasEncSteps()) {
            setEncSteps(rhs.getEncSteps());
        } else {
            clearEncSteps();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool SimRotateEncoderData::operator == (const SimRotateEncoderData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasEncCode() && !rhs.hasEncCode()) || getEncCode() == rhs.getEncCode()) &&
        ((!hasEncSteps() && !rhs.hasEncSteps()) || getEncSteps() == rhs.getEncSteps()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool SimRotateEncoderData::operator != (const SimRotateEncoderData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimRotateEncoderData::operator < (const SimRotateEncoderData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasEncCode() || rhs.hasEncCode()) {
        if (getEncCode() < rhs.getEncCode()) return true;
        if (getEncCode() > rhs.getEncCode()) return false;
    }
    if (hasEncSteps() || rhs.hasEncSteps()) {
        if (getEncSteps() < rhs.getEncSteps()) return true;
        if (getEncSteps() > rhs.getEncSteps()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline bool SimRotateEncoderData::operator > (const SimRotateEncoderData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimRotateEncoderData::clear() {
    clearPid();
    clearEncCode();
    clearEncSteps();
    clearUserData();
}

inline void SimRotateEncoderData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimRotateEncoderData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimRotateEncoderData::getPid () const {
    return _pid;
}

inline void SimRotateEncoderData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimRotateEncoderData::clearEncCode() {
    if (hasEncCode()) {
         clear_has_encCode();
        _encCode.clear();
     }
}

inline bool SimRotateEncoderData::hasEncCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SimRotateEncoderData::getEncCode () const {
    return _encCode;
}

inline ::std::string& SimRotateEncoderData::getEncCodeMutable () {
    set_has_encCode();
    return _encCode;
}

inline void SimRotateEncoderData::setEncCode (const ::std::string& encCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encCode();
    this->_encCode = encCode_;
}

inline void SimRotateEncoderData::setEncCode (const char* encCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encCode();
    this->_encCode.assign(encCode_);
}

inline void SimRotateEncoderData::setEncCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encCode();
    this->_encCode.assign(value, size);
}

inline void SimRotateEncoderData::clearEncSteps() {
    if (hasEncSteps()) {
         clear_has_encSteps();
        _encSteps = 0;
     }
}

inline bool SimRotateEncoderData::hasEncSteps () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimRotateEncoderData::getEncSteps () const {
    return _encSteps;
}

inline void SimRotateEncoderData::setEncSteps (int32 encSteps_) {
    set_has_encSteps();
    this->_encSteps = encSteps_;
}

inline void SimRotateEncoderData::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool SimRotateEncoderData::hasUserData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 SimRotateEncoderData::getUserData () const {
    return _userData;
}

inline void SimRotateEncoderData::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void SimRotateEncoderData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimRotateEncoderData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimRotateEncoderData::set_has_encCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimRotateEncoderData::clear_has_encCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimRotateEncoderData::set_has_encSteps () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimRotateEncoderData::clear_has_encSteps () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimRotateEncoderData::set_has_userData () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimRotateEncoderData::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SimJoystickData::SimJoystickData ()  :
    _pid (0),
    _direction (0u),
    _source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimJoystickData::SimJoystickData (const SimJoystickData &rhs)  :
    _pid (0),
    _direction (0u),
    _source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimJoystickData::SimJoystickData (int32 pid_, uint32 direction_, const ::std::string& source_)  :
    _pid (pid_),
    _direction (direction_),
    _source (source_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimJoystickData::~SimJoystickData() {
}

inline SimJoystickData& SimJoystickData::operator = (const SimJoystickData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool SimJoystickData::operator == (const SimJoystickData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool SimJoystickData::operator != (const SimJoystickData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimJoystickData::operator < (const SimJoystickData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if (getDirection() < rhs.getDirection()) return true;
        if (getDirection() > rhs.getDirection()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline bool SimJoystickData::operator > (const SimJoystickData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimJoystickData::clear() {
    clearPid();
    clearDirection();
    clearSource();
}

inline void SimJoystickData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimJoystickData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimJoystickData::getPid () const {
    return _pid;
}

inline void SimJoystickData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimJoystickData::clearDirection() {
    if (hasDirection()) {
         clear_has_direction();
        _direction = 0u;
     }
}

inline bool SimJoystickData::hasDirection () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SimJoystickData::getDirection () const {
    return _direction;
}

inline void SimJoystickData::setDirection (uint32 direction_) {
    set_has_direction();
    this->_direction = direction_;
}

inline void SimJoystickData::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source.clear();
     }
}

inline bool SimJoystickData::hasSource () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SimJoystickData::getSource () const {
    return _source;
}

inline ::std::string& SimJoystickData::getSourceMutable () {
    set_has_source();
    return _source;
}

inline void SimJoystickData::setSource (const ::std::string& source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source = source_;
}

inline void SimJoystickData::setSource (const char* source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(source_);
}

inline void SimJoystickData::setSource (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(value, size);
}

inline void SimJoystickData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimJoystickData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimJoystickData::set_has_direction () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimJoystickData::clear_has_direction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimJoystickData::set_has_source () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimJoystickData::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimEnterKeyData::SimEnterKeyData ()  :
    _pid (0),
    _keyState (0u),
    _source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimEnterKeyData::SimEnterKeyData (const SimEnterKeyData &rhs)  :
    _pid (0),
    _keyState (0u),
    _source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimEnterKeyData::SimEnterKeyData (int32 pid_, uint32 keyState_, const ::std::string& source_)  :
    _pid (pid_),
    _keyState (keyState_),
    _source (source_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimEnterKeyData::~SimEnterKeyData() {
}

inline SimEnterKeyData& SimEnterKeyData::operator = (const SimEnterKeyData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasKeyState()) {
            setKeyState(rhs.getKeyState());
        } else {
            clearKeyState();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool SimEnterKeyData::operator == (const SimEnterKeyData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasKeyState() && !rhs.hasKeyState()) || getKeyState() == rhs.getKeyState()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool SimEnterKeyData::operator != (const SimEnterKeyData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimEnterKeyData::operator < (const SimEnterKeyData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasKeyState() || rhs.hasKeyState()) {
        if (getKeyState() < rhs.getKeyState()) return true;
        if (getKeyState() > rhs.getKeyState()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline bool SimEnterKeyData::operator > (const SimEnterKeyData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimEnterKeyData::clear() {
    clearPid();
    clearKeyState();
    clearSource();
}

inline void SimEnterKeyData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimEnterKeyData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimEnterKeyData::getPid () const {
    return _pid;
}

inline void SimEnterKeyData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimEnterKeyData::clearKeyState() {
    if (hasKeyState()) {
         clear_has_keyState();
        _keyState = 0u;
     }
}

inline bool SimEnterKeyData::hasKeyState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SimEnterKeyData::getKeyState () const {
    return _keyState;
}

inline void SimEnterKeyData::setKeyState (uint32 keyState_) {
    set_has_keyState();
    this->_keyState = keyState_;
}

inline void SimEnterKeyData::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source.clear();
     }
}

inline bool SimEnterKeyData::hasSource () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SimEnterKeyData::getSource () const {
    return _source;
}

inline ::std::string& SimEnterKeyData::getSourceMutable () {
    set_has_source();
    return _source;
}

inline void SimEnterKeyData::setSource (const ::std::string& source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source = source_;
}

inline void SimEnterKeyData::setSource (const char* source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(source_);
}

inline void SimEnterKeyData::setSource (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_source();
    this->_source.assign(value, size);
}

inline void SimEnterKeyData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimEnterKeyData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimEnterKeyData::set_has_keyState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimEnterKeyData::clear_has_keyState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimEnterKeyData::set_has_source () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimEnterKeyData::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimFocusReqData::SimFocusReqData ()  :
    _pid (0),
    _action (0u),
    _timeAction (0u),
    _viewName (),
    _widgetName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimFocusReqData::SimFocusReqData (const SimFocusReqData &rhs)  :
    _pid (0),
    _action (0u),
    _timeAction (0u),
    _viewName (),
    _widgetName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimFocusReqData::SimFocusReqData (int32 pid_, uint32 action_, uint32 timeAction_, const ::std::string& viewName_, const ::std::string& widgetName_)  :
    _pid (pid_),
    _action (action_),
    _timeAction (timeAction_),
    _viewName (viewName_),
    _widgetName (widgetName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimFocusReqData::~SimFocusReqData() {
}

inline SimFocusReqData& SimFocusReqData::operator = (const SimFocusReqData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
        if (rhs.hasTimeAction()) {
            setTimeAction(rhs.getTimeAction());
        } else {
            clearTimeAction();
        }
        if (rhs.hasViewName()) {
            setViewName(rhs.getViewName());
        } else {
            clearViewName();
        }
        if (rhs.hasWidgetName()) {
            setWidgetName(rhs.getWidgetName());
        } else {
            clearWidgetName();
        }
    }
    return *this;
}

inline bool SimFocusReqData::operator == (const SimFocusReqData& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()) &&
        ((!hasTimeAction() && !rhs.hasTimeAction()) || getTimeAction() == rhs.getTimeAction()) &&
        ((!hasViewName() && !rhs.hasViewName()) || getViewName() == rhs.getViewName()) &&
        ((!hasWidgetName() && !rhs.hasWidgetName()) || getWidgetName() == rhs.getWidgetName()));
}

inline bool SimFocusReqData::operator != (const SimFocusReqData& rhs) const {
    return ! (*this == rhs);
}

inline bool SimFocusReqData::operator < (const SimFocusReqData& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if (getAction() < rhs.getAction()) return true;
        if (getAction() > rhs.getAction()) return false;
    }
    if (hasTimeAction() || rhs.hasTimeAction()) {
        if (getTimeAction() < rhs.getTimeAction()) return true;
        if (getTimeAction() > rhs.getTimeAction()) return false;
    }
    if (hasViewName() || rhs.hasViewName()) {
        if (getViewName() < rhs.getViewName()) return true;
        if (getViewName() > rhs.getViewName()) return false;
    }
    if (hasWidgetName() || rhs.hasWidgetName()) {
        if (getWidgetName() < rhs.getWidgetName()) return true;
        if (getWidgetName() > rhs.getWidgetName()) return false;
    }
    return false;
}

inline bool SimFocusReqData::operator > (const SimFocusReqData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimFocusReqData::clear() {
    clearPid();
    clearAction();
    clearTimeAction();
    clearViewName();
    clearWidgetName();
}

inline void SimFocusReqData::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool SimFocusReqData::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimFocusReqData::getPid () const {
    return _pid;
}

inline void SimFocusReqData::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void SimFocusReqData::clearAction() {
    if (hasAction()) {
         clear_has_action();
        _action = 0u;
     }
}

inline bool SimFocusReqData::hasAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SimFocusReqData::getAction () const {
    return _action;
}

inline void SimFocusReqData::setAction (uint32 action_) {
    set_has_action();
    this->_action = action_;
}

inline void SimFocusReqData::clearTimeAction() {
    if (hasTimeAction()) {
         clear_has_timeAction();
        _timeAction = 0u;
     }
}

inline bool SimFocusReqData::hasTimeAction () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SimFocusReqData::getTimeAction () const {
    return _timeAction;
}

inline void SimFocusReqData::setTimeAction (uint32 timeAction_) {
    set_has_timeAction();
    this->_timeAction = timeAction_;
}

inline void SimFocusReqData::clearViewName() {
    if (hasViewName()) {
         clear_has_viewName();
        _viewName.clear();
     }
}

inline bool SimFocusReqData::hasViewName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SimFocusReqData::getViewName () const {
    return _viewName;
}

inline ::std::string& SimFocusReqData::getViewNameMutable () {
    set_has_viewName();
    return _viewName;
}

inline void SimFocusReqData::setViewName (const ::std::string& viewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName = viewName_;
}

inline void SimFocusReqData::setViewName (const char* viewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (viewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName.assign(viewName_);
}

inline void SimFocusReqData::setViewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_viewName();
    this->_viewName.assign(value, size);
}

inline void SimFocusReqData::clearWidgetName() {
    if (hasWidgetName()) {
         clear_has_widgetName();
        _widgetName.clear();
     }
}

inline bool SimFocusReqData::hasWidgetName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& SimFocusReqData::getWidgetName () const {
    return _widgetName;
}

inline ::std::string& SimFocusReqData::getWidgetNameMutable () {
    set_has_widgetName();
    return _widgetName;
}

inline void SimFocusReqData::setWidgetName (const ::std::string& widgetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName = widgetName_;
}

inline void SimFocusReqData::setWidgetName (const char* widgetName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (widgetName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName.assign(widgetName_);
}

inline void SimFocusReqData::setWidgetName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_widgetName();
    this->_widgetName.assign(value, size);
}

inline void SimFocusReqData::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimFocusReqData::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimFocusReqData::set_has_action () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimFocusReqData::clear_has_action () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimFocusReqData::set_has_timeAction () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimFocusReqData::clear_has_timeAction () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimFocusReqData::set_has_viewName () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimFocusReqData::clear_has_viewName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SimFocusReqData::set_has_widgetName () {
    _has_bits_[0] |= 1u << 4;
}

inline void SimFocusReqData::clear_has_widgetName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest ()  :
    _pid (0u),
    _name (),
    _surfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest (const UpdateClientStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pid (0u),
    _name (),
    _surfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest (uint32 pid_, const ::std::string& name_, const ::std::vector< uint32 >& surfaces_)  :
    _pid (pid_),
    _name (name_),
    _surfaces (surfaces_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateClientStatusRequest::~UpdateClientStatusRequest() {
}

inline UpdateClientStatusRequest& UpdateClientStatusRequest::operator = (const UpdateClientStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasSurfaces()) {
            setSurfaces(rhs.getSurfaces());
        } else {
            clearSurfaces();
        }
    }
    return *this;
}

inline bool UpdateClientStatusRequest::operator == (const UpdateClientStatusRequest& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasSurfaces() && !rhs.hasSurfaces()) || getSurfaces() == rhs.getSurfaces()));
}

inline bool UpdateClientStatusRequest::operator != (const UpdateClientStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateClientStatusRequest::operator < (const UpdateClientStatusRequest& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasSurfaces() || rhs.hasSurfaces()) {
        if (getSurfaces() < rhs.getSurfaces()) return true;
        if (getSurfaces() > rhs.getSurfaces()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateClientStatusRequest::clone() {
    return new UpdateClientStatusRequest(*this);
}

inline bool UpdateClientStatusRequest::operator > (const UpdateClientStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateClientStatusRequest::clear() {
    clearPid();
    clearName();
    clearSurfaces();
}

inline void UpdateClientStatusRequest::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0u;
     }
}

inline bool UpdateClientStatusRequest::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 UpdateClientStatusRequest::getPid () const {
    return _pid;
}

inline void UpdateClientStatusRequest::setPid (uint32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void UpdateClientStatusRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool UpdateClientStatusRequest::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UpdateClientStatusRequest::getName () const {
    return _name;
}

inline ::std::string& UpdateClientStatusRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void UpdateClientStatusRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void UpdateClientStatusRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void UpdateClientStatusRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void UpdateClientStatusRequest::clearSurfaces() {
    if (hasSurfaces()) {
         clear_has_surfaces();
        _surfaces.clear();
     }
}

inline bool UpdateClientStatusRequest::hasSurfaces () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint32 >& UpdateClientStatusRequest::getSurfaces () const {
    return _surfaces;
}

inline ::std::vector< uint32 >& UpdateClientStatusRequest::getSurfacesMutable () {
    set_has_surfaces();
    return _surfaces;
}

inline void UpdateClientStatusRequest::setSurfaces (const ::std::vector< uint32 >& surfaces_) {
    set_has_surfaces();
    this->_surfaces = surfaces_;
}

inline void UpdateClientStatusRequest::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateClientStatusRequest::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateClientStatusRequest::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateClientStatusRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateClientStatusRequest::set_has_surfaces () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateClientStatusRequest::clear_has_surfaces () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  UpdateTraceQueryResultRequest::UpdateTraceQueryResultRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateTraceQueryResultRequest::UpdateTraceQueryResultRequest (const UpdateTraceQueryResultRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateTraceQueryResultRequest::UpdateTraceQueryResultRequest (const TraceQueryData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateTraceQueryResultRequest::~UpdateTraceQueryResultRequest() {
}

inline UpdateTraceQueryResultRequest& UpdateTraceQueryResultRequest::operator = (const UpdateTraceQueryResultRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool UpdateTraceQueryResultRequest::operator == (const UpdateTraceQueryResultRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool UpdateTraceQueryResultRequest::operator != (const UpdateTraceQueryResultRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateTraceQueryResultRequest::operator < (const UpdateTraceQueryResultRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateTraceQueryResultRequest::clone() {
    return new UpdateTraceQueryResultRequest(*this);
}

inline bool UpdateTraceQueryResultRequest::operator > (const UpdateTraceQueryResultRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateTraceQueryResultRequest::clear() {
    clearData();
}

inline void UpdateTraceQueryResultRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool UpdateTraceQueryResultRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TraceQueryData& UpdateTraceQueryResultRequest::getData () const {
    return _data;
}

inline TraceQueryData& UpdateTraceQueryResultRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void UpdateTraceQueryResultRequest::setData (const TraceQueryData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void UpdateTraceQueryResultRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateTraceQueryResultRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TraceQuerySignal::TraceQuerySignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceQuerySignal::TraceQuerySignal (const TraceQuerySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceQuerySignal::TraceQuerySignal (const TraceQueryData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TraceQuerySignal::~TraceQuerySignal() {
}

inline TraceQuerySignal& TraceQuerySignal::operator = (const TraceQuerySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool TraceQuerySignal::operator == (const TraceQuerySignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool TraceQuerySignal::operator != (const TraceQuerySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceQuerySignal::operator < (const TraceQuerySignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TraceQuerySignal::clone() {
    return new TraceQuerySignal(*this);
}

inline bool TraceQuerySignal::operator > (const TraceQuerySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceQuerySignal::clear() {
    clearData();
}

inline void TraceQuerySignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool TraceQuerySignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TraceQueryData& TraceQuerySignal::getData () const {
    return _data;
}

inline TraceQueryData& TraceQuerySignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void TraceQuerySignal::setData (const TraceQueryData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void TraceQuerySignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void TraceQuerySignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimTouchSignal::SimTouchSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchSignal::SimTouchSignal (const SimTouchSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchSignal::SimTouchSignal (const SimTouchData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchSignal::~SimTouchSignal() {
}

inline SimTouchSignal& SimTouchSignal::operator = (const SimTouchSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimTouchSignal::operator == (const SimTouchSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimTouchSignal::operator != (const SimTouchSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchSignal::operator < (const SimTouchSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimTouchSignal::clone() {
    return new SimTouchSignal(*this);
}

inline bool SimTouchSignal::operator > (const SimTouchSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchSignal::clear() {
    clearData();
}

inline void SimTouchSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimTouchSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimTouchData& SimTouchSignal::getData () const {
    return _data;
}

inline SimTouchData& SimTouchSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimTouchSignal::setData (const SimTouchData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimTouchSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimTouchByNameSignal::SimTouchByNameSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByNameSignal::SimTouchByNameSignal (const SimTouchByNameSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByNameSignal::SimTouchByNameSignal (const SimTouchByNameData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByNameSignal::~SimTouchByNameSignal() {
}

inline SimTouchByNameSignal& SimTouchByNameSignal::operator = (const SimTouchByNameSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimTouchByNameSignal::operator == (const SimTouchByNameSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimTouchByNameSignal::operator != (const SimTouchByNameSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByNameSignal::operator < (const SimTouchByNameSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimTouchByNameSignal::clone() {
    return new SimTouchByNameSignal(*this);
}

inline bool SimTouchByNameSignal::operator > (const SimTouchByNameSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByNameSignal::clear() {
    clearData();
}

inline void SimTouchByNameSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimTouchByNameSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimTouchByNameData& SimTouchByNameSignal::getData () const {
    return _data;
}

inline SimTouchByNameData& SimTouchByNameSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimTouchByNameSignal::setData (const SimTouchByNameData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimTouchByNameSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByNameSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimTouchByTextSignal::SimTouchByTextSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByTextSignal::SimTouchByTextSignal (const SimTouchByTextSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByTextSignal::SimTouchByTextSignal (const SimTouchByTextData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByTextSignal::~SimTouchByTextSignal() {
}

inline SimTouchByTextSignal& SimTouchByTextSignal::operator = (const SimTouchByTextSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimTouchByTextSignal::operator == (const SimTouchByTextSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimTouchByTextSignal::operator != (const SimTouchByTextSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByTextSignal::operator < (const SimTouchByTextSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimTouchByTextSignal::clone() {
    return new SimTouchByTextSignal(*this);
}

inline bool SimTouchByTextSignal::operator > (const SimTouchByTextSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByTextSignal::clear() {
    clearData();
}

inline void SimTouchByTextSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimTouchByTextSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimTouchByTextData& SimTouchByTextSignal::getData () const {
    return _data;
}

inline SimTouchByTextData& SimTouchByTextSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimTouchByTextSignal::setData (const SimTouchByTextData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimTouchByTextSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByTextSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimTouchByTextIdSignal::SimTouchByTextIdSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByTextIdSignal::SimTouchByTextIdSignal (const SimTouchByTextIdSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByTextIdSignal::SimTouchByTextIdSignal (const SimTouchByTextIdData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByTextIdSignal::~SimTouchByTextIdSignal() {
}

inline SimTouchByTextIdSignal& SimTouchByTextIdSignal::operator = (const SimTouchByTextIdSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimTouchByTextIdSignal::operator == (const SimTouchByTextIdSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimTouchByTextIdSignal::operator != (const SimTouchByTextIdSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByTextIdSignal::operator < (const SimTouchByTextIdSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimTouchByTextIdSignal::clone() {
    return new SimTouchByTextIdSignal(*this);
}

inline bool SimTouchByTextIdSignal::operator > (const SimTouchByTextIdSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByTextIdSignal::clear() {
    clearData();
}

inline void SimTouchByTextIdSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimTouchByTextIdSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimTouchByTextIdData& SimTouchByTextIdSignal::getData () const {
    return _data;
}

inline SimTouchByTextIdData& SimTouchByTextIdSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimTouchByTextIdSignal::setData (const SimTouchByTextIdData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimTouchByTextIdSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByTextIdSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimTouchByIndexSignal::SimTouchByIndexSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimTouchByIndexSignal::SimTouchByIndexSignal (const SimTouchByIndexSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimTouchByIndexSignal::SimTouchByIndexSignal (const SimTouchByIndexData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimTouchByIndexSignal::~SimTouchByIndexSignal() {
}

inline SimTouchByIndexSignal& SimTouchByIndexSignal::operator = (const SimTouchByIndexSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimTouchByIndexSignal::operator == (const SimTouchByIndexSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimTouchByIndexSignal::operator != (const SimTouchByIndexSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimTouchByIndexSignal::operator < (const SimTouchByIndexSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimTouchByIndexSignal::clone() {
    return new SimTouchByIndexSignal(*this);
}

inline bool SimTouchByIndexSignal::operator > (const SimTouchByIndexSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimTouchByIndexSignal::clear() {
    clearData();
}

inline void SimTouchByIndexSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimTouchByIndexSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimTouchByIndexData& SimTouchByIndexSignal::getData () const {
    return _data;
}

inline SimTouchByIndexData& SimTouchByIndexSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimTouchByIndexSignal::setData (const SimTouchByIndexData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimTouchByIndexSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimTouchByIndexSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WidgetPropertyValueSetterSignal::WidgetPropertyValueSetterSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WidgetPropertyValueSetterSignal::WidgetPropertyValueSetterSignal (const WidgetPropertyValueSetterSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WidgetPropertyValueSetterSignal::WidgetPropertyValueSetterSignal (const WidgetPropertyValueSetterData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WidgetPropertyValueSetterSignal::~WidgetPropertyValueSetterSignal() {
}

inline WidgetPropertyValueSetterSignal& WidgetPropertyValueSetterSignal::operator = (const WidgetPropertyValueSetterSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool WidgetPropertyValueSetterSignal::operator == (const WidgetPropertyValueSetterSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool WidgetPropertyValueSetterSignal::operator != (const WidgetPropertyValueSetterSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool WidgetPropertyValueSetterSignal::operator < (const WidgetPropertyValueSetterSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WidgetPropertyValueSetterSignal::clone() {
    return new WidgetPropertyValueSetterSignal(*this);
}

inline bool WidgetPropertyValueSetterSignal::operator > (const WidgetPropertyValueSetterSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WidgetPropertyValueSetterSignal::clear() {
    clearData();
}

inline void WidgetPropertyValueSetterSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool WidgetPropertyValueSetterSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const WidgetPropertyValueSetterData& WidgetPropertyValueSetterSignal::getData () const {
    return _data;
}

inline WidgetPropertyValueSetterData& WidgetPropertyValueSetterSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void WidgetPropertyValueSetterSignal::setData (const WidgetPropertyValueSetterData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void WidgetPropertyValueSetterSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void WidgetPropertyValueSetterSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimRotateEncoderSignal::SimRotateEncoderSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimRotateEncoderSignal::SimRotateEncoderSignal (const SimRotateEncoderSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimRotateEncoderSignal::SimRotateEncoderSignal (const SimRotateEncoderData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimRotateEncoderSignal::~SimRotateEncoderSignal() {
}

inline SimRotateEncoderSignal& SimRotateEncoderSignal::operator = (const SimRotateEncoderSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimRotateEncoderSignal::operator == (const SimRotateEncoderSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimRotateEncoderSignal::operator != (const SimRotateEncoderSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimRotateEncoderSignal::operator < (const SimRotateEncoderSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimRotateEncoderSignal::clone() {
    return new SimRotateEncoderSignal(*this);
}

inline bool SimRotateEncoderSignal::operator > (const SimRotateEncoderSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimRotateEncoderSignal::clear() {
    clearData();
}

inline void SimRotateEncoderSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimRotateEncoderSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimRotateEncoderData& SimRotateEncoderSignal::getData () const {
    return _data;
}

inline SimRotateEncoderData& SimRotateEncoderSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimRotateEncoderSignal::setData (const SimRotateEncoderData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimRotateEncoderSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimRotateEncoderSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimJoystickSignal::SimJoystickSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimJoystickSignal::SimJoystickSignal (const SimJoystickSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimJoystickSignal::SimJoystickSignal (const SimJoystickData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimJoystickSignal::~SimJoystickSignal() {
}

inline SimJoystickSignal& SimJoystickSignal::operator = (const SimJoystickSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimJoystickSignal::operator == (const SimJoystickSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimJoystickSignal::operator != (const SimJoystickSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimJoystickSignal::operator < (const SimJoystickSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimJoystickSignal::clone() {
    return new SimJoystickSignal(*this);
}

inline bool SimJoystickSignal::operator > (const SimJoystickSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimJoystickSignal::clear() {
    clearData();
}

inline void SimJoystickSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimJoystickSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimJoystickData& SimJoystickSignal::getData () const {
    return _data;
}

inline SimJoystickData& SimJoystickSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimJoystickSignal::setData (const SimJoystickData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimJoystickSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimJoystickSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimEnterKeySignal::SimEnterKeySignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimEnterKeySignal::SimEnterKeySignal (const SimEnterKeySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimEnterKeySignal::SimEnterKeySignal (const SimEnterKeyData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimEnterKeySignal::~SimEnterKeySignal() {
}

inline SimEnterKeySignal& SimEnterKeySignal::operator = (const SimEnterKeySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimEnterKeySignal::operator == (const SimEnterKeySignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimEnterKeySignal::operator != (const SimEnterKeySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimEnterKeySignal::operator < (const SimEnterKeySignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimEnterKeySignal::clone() {
    return new SimEnterKeySignal(*this);
}

inline bool SimEnterKeySignal::operator > (const SimEnterKeySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimEnterKeySignal::clear() {
    clearData();
}

inline void SimEnterKeySignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimEnterKeySignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimEnterKeyData& SimEnterKeySignal::getData () const {
    return _data;
}

inline SimEnterKeyData& SimEnterKeySignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimEnterKeySignal::setData (const SimEnterKeyData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimEnterKeySignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimEnterKeySignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimFocusReqSignal::SimFocusReqSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimFocusReqSignal::SimFocusReqSignal (const SimFocusReqSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimFocusReqSignal::SimFocusReqSignal (const SimFocusReqData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimFocusReqSignal::~SimFocusReqSignal() {
}

inline SimFocusReqSignal& SimFocusReqSignal::operator = (const SimFocusReqSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SimFocusReqSignal::operator == (const SimFocusReqSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SimFocusReqSignal::operator != (const SimFocusReqSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SimFocusReqSignal::operator < (const SimFocusReqSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimFocusReqSignal::clone() {
    return new SimFocusReqSignal(*this);
}

inline bool SimFocusReqSignal::operator > (const SimFocusReqSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimFocusReqSignal::clear() {
    clearData();
}

inline void SimFocusReqSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SimFocusReqSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SimFocusReqData& SimFocusReqSignal::getData () const {
    return _data;
}

inline SimFocusReqData& SimFocusReqSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SimFocusReqSignal::setData (const SimFocusReqData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SimFocusReqSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimFocusReqSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
