/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlDBus.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlJson.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/appctrl/bosch/cm/ai/hmi/appctrl/HMIAppCtrl", HMIAppCtrlStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "DisplayCmd", 5 },
    { 13, "KeyForwarding", 1 },
    { 14, "BeepForwarding", 3 },
    { 14, "FollowUpAction", 17 },
    { 15, "MultiDisplayCmd", 6 },
    { 17, "DisplayStatusEval", 7 },
    { 17, "EncoderForwarding", 2 },
    { 18, "UpdateClientStatus", 0 },
    { 22, "ResponseFollowUpAction", 18 },
    { 23, "SetApplicationMandatory", 4 },
    { 24, "SubSurfaceSwitchComplete", 16 },
    { 25, "ApplicationRenderedUpdate", 14 },
    { 25, "ApplicationSwitchComplete", 15 },
    { 25, "DrmBufferAllocationStatus", 19 },
    { 32, "RequestSlaveSurfaceRepositioning", 10 },
    { 33, "RequestExternalImageProviderTouch", 9 },
    { 33, "ResponseSlaveSurfaceRepositioning", 11 },
    { 38, "RequestExternalImageProviderActivation", 8 },
    { 40, "RequestDirectTextureConsumerPositionInfo", 12 },
    { 41, "ResponseDirectTextureConsumerPositionInfo", 13 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 7, "Clients", 1 },
    { 20, "ExternalImagesStatus", 0 },
};

class HMIAppCtrlStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HMIAppCtrlStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HMIAppCtrlStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HMIAppCtrlStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.appctrl.HMIAppCtrl"),
          _logger(logger) {}

    virtual ~HMIAppCtrlStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HMIAppCtrlStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 20, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'UpdateClientStatus'

            LOG_DEBUG_STUB("process method '%s'", "UpdateClientStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateClientStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateClientStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateClientStatusRequest > payload = ::boost::static_pointer_cast<UpdateClientStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onUpdateClientStatusRequest(payload);
            return;
        }
        case 1: {

            // method 'KeyForwarding'

            LOG_DEBUG_STUB("process method '%s'", "KeyForwarding");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyForwardingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "KeyForwarding", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< KeyForwardingRequest > payload = ::boost::static_pointer_cast<KeyForwardingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onKeyForwardingRequest(payload);
            return;
        }
        case 2: {

            // method 'EncoderForwarding'

            LOG_DEBUG_STUB("process method '%s'", "EncoderForwarding");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EncoderForwardingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EncoderForwarding", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EncoderForwardingRequest > payload = ::boost::static_pointer_cast<EncoderForwardingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onEncoderForwardingRequest(payload);
            return;
        }
        case 3: {

            // method 'BeepForwarding'

            LOG_DEBUG_STUB("process method '%s'", "BeepForwarding");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BeepForwardingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BeepForwarding", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BeepForwardingRequest > payload = ::boost::static_pointer_cast<BeepForwardingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onBeepForwardingRequest(payload);
            return;
        }
        case 4: {

            // method 'SetApplicationMandatory'

            LOG_DEBUG_STUB("process method '%s'", "SetApplicationMandatory");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetApplicationMandatoryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetApplicationMandatory", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetApplicationMandatoryRequest > payload = ::boost::static_pointer_cast<SetApplicationMandatoryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onSetApplicationMandatoryRequest(payload);
            return;
        }
        case 5: {

            // method 'DisplayCmd'

            LOG_DEBUG_STUB("process method '%s'", "DisplayCmd");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayCmdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisplayCmd", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisplayCmdRequest > payload = ::boost::static_pointer_cast<DisplayCmdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onDisplayCmdRequest(payload);
            return;
        }
        case 6: {

            // method 'MultiDisplayCmd'

            LOG_DEBUG_STUB("process method '%s'", "MultiDisplayCmd");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MultiDisplayCmdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MultiDisplayCmd", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MultiDisplayCmdRequest > payload = ::boost::static_pointer_cast<MultiDisplayCmdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onMultiDisplayCmdRequest(payload);
            return;
        }
        case 7: {

            // method 'DisplayStatusEval'

            LOG_DEBUG_STUB("process method '%s'", "DisplayStatusEval");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayStatusEvalRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisplayStatusEval", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisplayStatusEvalRequest > payload = ::boost::static_pointer_cast<DisplayStatusEvalRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onDisplayStatusEvalRequest(payload);
            return;
        }
        case 8: {

            // method 'RequestExternalImageProviderActivation'

            LOG_DEBUG_STUB("process method '%s'", "RequestExternalImageProviderActivation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestExternalImageProviderActivationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestExternalImageProviderActivation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestExternalImageProviderActivationRequest > payload = ::boost::static_pointer_cast<RequestExternalImageProviderActivationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onRequestExternalImageProviderActivationRequest(payload);
            return;
        }
        case 9: {

            // method 'RequestExternalImageProviderTouch'

            LOG_DEBUG_STUB("process method '%s'", "RequestExternalImageProviderTouch");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestExternalImageProviderTouchRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestExternalImageProviderTouch", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestExternalImageProviderTouchRequest > payload = ::boost::static_pointer_cast<RequestExternalImageProviderTouchRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onRequestExternalImageProviderTouchRequest(payload);
            return;
        }
        case 10: {

            // method 'RequestSlaveSurfaceRepositioning'

            LOG_DEBUG_STUB("process method '%s'", "RequestSlaveSurfaceRepositioning");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestSlaveSurfaceRepositioningRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestSlaveSurfaceRepositioning", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestSlaveSurfaceRepositioningRequest > payload = ::boost::static_pointer_cast<RequestSlaveSurfaceRepositioningRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onRequestSlaveSurfaceRepositioningRequest(payload);
            return;
        }
        case 11: {

            // method 'ResponseSlaveSurfaceRepositioning'

            LOG_DEBUG_STUB("process method '%s'", "ResponseSlaveSurfaceRepositioning");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResponseSlaveSurfaceRepositioningRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResponseSlaveSurfaceRepositioning", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResponseSlaveSurfaceRepositioningRequest > payload = ::boost::static_pointer_cast<ResponseSlaveSurfaceRepositioningRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onResponseSlaveSurfaceRepositioningRequest(payload);
            return;
        }
        case 12: {

            // method 'RequestDirectTextureConsumerPositionInfo'

            LOG_DEBUG_STUB("process method '%s'", "RequestDirectTextureConsumerPositionInfo");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDirectTextureConsumerPositionInfoRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestDirectTextureConsumerPositionInfo", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestDirectTextureConsumerPositionInfoRequest > payload = ::boost::static_pointer_cast<RequestDirectTextureConsumerPositionInfoRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onRequestDirectTextureConsumerPositionInfoRequest(payload);
            return;
        }
        case 13: {

            // method 'ResponseDirectTextureConsumerPositionInfo'

            LOG_DEBUG_STUB("process method '%s'", "ResponseDirectTextureConsumerPositionInfo");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResponseDirectTextureConsumerPositionInfoRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResponseDirectTextureConsumerPositionInfo", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResponseDirectTextureConsumerPositionInfoRequest > payload = ::boost::static_pointer_cast<ResponseDirectTextureConsumerPositionInfoRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onResponseDirectTextureConsumerPositionInfoRequest(payload);
            return;
        }
        case 14: {

            // method 'ApplicationRenderedUpdate'

            LOG_DEBUG_STUB("process method '%s'", "ApplicationRenderedUpdate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplicationRenderedUpdateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ApplicationRenderedUpdate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ApplicationRenderedUpdateRequest > payload = ::boost::static_pointer_cast<ApplicationRenderedUpdateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onApplicationRenderedUpdateRequest(payload);
            return;
        }
        case 15: {

            // method 'ApplicationSwitchComplete'

            LOG_DEBUG_STUB("process method '%s'", "ApplicationSwitchComplete");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplicationSwitchCompleteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ApplicationSwitchComplete", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ApplicationSwitchCompleteRequest > payload = ::boost::static_pointer_cast<ApplicationSwitchCompleteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onApplicationSwitchCompleteRequest(payload);
            return;
        }
        case 16: {

            // method 'SubSurfaceSwitchComplete'

            LOG_DEBUG_STUB("process method '%s'", "SubSurfaceSwitchComplete");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubSurfaceSwitchCompleteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SubSurfaceSwitchComplete", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SubSurfaceSwitchCompleteRequest > payload = ::boost::static_pointer_cast<SubSurfaceSwitchCompleteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onSubSurfaceSwitchCompleteRequest(payload);
            return;
        }
        case 17: {

            // method 'FollowUpAction'

            LOG_DEBUG_STUB("process method '%s'", "FollowUpAction");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FollowUpActionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FollowUpAction", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FollowUpActionRequest > payload = ::boost::static_pointer_cast<FollowUpActionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onFollowUpActionRequest(payload);
            return;
        }
        case 18: {

            // method 'ResponseFollowUpAction'

            LOG_DEBUG_STUB("process method '%s'", "ResponseFollowUpAction");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResponseFollowUpActionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResponseFollowUpAction", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResponseFollowUpActionRequest > payload = ::boost::static_pointer_cast<ResponseFollowUpActionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onResponseFollowUpActionRequest(payload);
            return;
        }
        case 19: {

            // method 'DrmBufferAllocationStatus'

            LOG_DEBUG_STUB("process method '%s'", "DrmBufferAllocationStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DrmBufferAllocationStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DrmBufferAllocationStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DrmBufferAllocationStatusRequest > payload = ::boost::static_pointer_cast<DrmBufferAllocationStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HMIAppCtrlStub*>(getStub())->onDrmBufferAllocationStatusRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HMIAppCtrlStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.appctrl.HMIAppCtrl\">\n"
            "    <property access=\"read\" name=\"ExternalImagesStatus\" type=\"a(uiu)\"/>\n"
            "    <property access=\"read\" name=\"Clients\" type=\"a(iu)\"/>\n"
            "    <method name=\"UpdateClientStatus\">\n"
            "      <doc>\n"
            "        <line>UpdateClientStatus = transport information about the hmi process to stub</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pid\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"state_\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>state_ (of type hmiAppState) = Description missing</line>\n"
            "          <line>enum[HMIAPP_UNINITIALIZED (null), HMIAPP_INITIALIZED (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"KeyForwarding\">\n"
            "      <doc>\n"
            "        <line>KeyForwarding = forward a received (and not consumed) key event to stub</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"keyRequest\" type=\"(uyuuuu)\">\n"
            "        <doc>\n"
            "          <line>keyRequest (of type keyInfo) = Description missing</line>\n"
            "          <line>keyInfo struct[keyCode, keyState, pidSender, pidReceiver, displayId, userData] = todo</line>\n"
            "          <line>0: keyInfo.keyCode ('u') = Description missing</line>\n"
            "          <line>1: keyInfo.keyState ('y') = Description missing</line>\n"
            "          <line>2: keyInfo.pidSender ('u') = Description missing</line>\n"
            "          <line>3: keyInfo.pidReceiver ('u') = Description missing</line>\n"
            "          <line>4: keyInfo.displayId ('u') = Description missing</line>\n"
            "          <line>5: keyInfo.userData ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EncoderForwarding\">\n"
            "      <doc>\n"
            "        <line>EncoderForwarding = forward a received (and not consumed) encoder event to stub</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"encoderRequest\" type=\"(iiuuuu)\">\n"
            "        <doc>\n"
            "          <line>encoderRequest (of type encoderInfo) = Description missing</line>\n"
            "          <line>encoderInfo struct[encCode, encValue, pidSender, pidReceiver, surfaceId, userData] = encoder information</line>\n"
            "          <line>0: encoderInfo.encCode ('i') = Description missing</line>\n"
            "          <line>1: encoderInfo.encValue ('i') = Description missing</line>\n"
            "          <line>2: encoderInfo.pidSender ('u') = Description missing</line>\n"
            "          <line>3: encoderInfo.pidReceiver ('u') = Description missing</line>\n"
            "          <line>4: encoderInfo.surfaceId ('u') = Description missing</line>\n"
            "          <line>5: encoderInfo.userData ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"BeepForwarding\">\n"
            "      <doc>\n"
            "        <line>BeepForwarding = forward a beep request to stub</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"beepType\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>beepType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetApplicationMandatory\">\n"
            "      <doc>\n"
            "        <line>SetApplicationMandatory = set the calling application as mandatory for synchronized hmi startup</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"value\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>value = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DisplayCmd\">\n"
            "      <doc>\n"
            "        <line>DisplayCmd = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"data\" type=\"(issiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type displayData) = Description missing</line>\n"
            "          <line>displayData struct[pidReceiver, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: displayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: displayData.senderName ('s') = Description missing</line>\n"
            "          <line>2: displayData.receiverName ('s') = Description missing</line>\n"
            "          <line>3: displayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>4: displayData.regionType ('i') = Description missing</line>\n"
            "          <line>5: displayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"MultiDisplayCmd\">\n"
            "      <arg direction=\"in\" name=\"data\" type=\"(iussiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type MultidisplayData) = Description missing</line>\n"
            "          <line>MultidisplayData struct[pidReceiver, displayid, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: MultidisplayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: MultidisplayData.displayid ('u') = Description missing</line>\n"
            "          <line>2: MultidisplayData.senderName ('s') = Description missing</line>\n"
            "          <line>3: MultidisplayData.receiverName ('s') = Description missing</line>\n"
            "          <line>4: MultidisplayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>5: MultidisplayData.regionType ('i') = Description missing</line>\n"
            "          <line>6: MultidisplayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DisplayStatusEval\">\n"
            "      <doc>\n"
            "        <line>DisplayStatusEval = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"data\" type=\"(iussiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type MultidisplayData) = Description missing</line>\n"
            "          <line>MultidisplayData struct[pidReceiver, displayid, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: MultidisplayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: MultidisplayData.displayid ('u') = Description missing</line>\n"
            "          <line>2: MultidisplayData.senderName ('s') = Description missing</line>\n"
            "          <line>3: MultidisplayData.receiverName ('s') = Description missing</line>\n"
            "          <line>4: MultidisplayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>5: MultidisplayData.regionType ('i') = Description missing</line>\n"
            "          <line>6: MultidisplayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestExternalImageProviderActivation\">\n"
            "      <doc>\n"
            "        <line>RequestExternalImageProviderActivation = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"targetState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>targetState (of type gadgetStatus) = Description missing</line>\n"
            "          <line>enum[ACTIVE (null), INACTIVE (null), HIDDEN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"instanceIds\" type=\"ai\">\n"
            "        <doc>\n"
            "          <line>instanceIds = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"consumerId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>consumerId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestExternalImageProviderTouch\">\n"
            "      <doc>\n"
            "        <line>RequestExternalImageProviderTouch = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"data\" type=\"(yiiu)\">\n"
            "        <doc>\n"
            "          <line>data (of type touchInfo) = Description missing</line>\n"
            "          <line>touchInfo struct[touchState, xPos, yPos, timeStamp] = todo</line>\n"
            "          <line>0: touchInfo.touchState ('y') = Description missing</line>\n"
            "          <line>1: touchInfo.xPos ('i') = Description missing</line>\n"
            "          <line>2: touchInfo.yPos ('i') = Description missing</line>\n"
            "          <line>3: touchInfo.timeStamp ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"instanceId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestSlaveSurfaceRepositioning\">\n"
            "      <doc>\n"
            "        <line>RequestSlaveSurfaceRepositioning = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"activate\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>activate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ResponseSlaveSurfaceRepositioning\">\n"
            "      <doc>\n"
            "        <line>ResponseSlaveSurfaceRepositioning = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"activate\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>activate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestDirectTextureConsumerPositionInfo\">\n"
            "      <doc>\n"
            "        <line>RequestDirectTextureConsumerPositionInfo = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"instanceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ResponseDirectTextureConsumerPositionInfo\">\n"
            "      <doc>\n"
            "        <line>ResponseDirectTextureConsumerPositionInfo = request stub to distribute</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"instanceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"xPos\" type=\"d\">\n"
            "        <doc>\n"
            "          <line>xPos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"yPos\" type=\"d\">\n"
            "        <doc>\n"
            "          <line>yPos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ApplicationRenderedUpdate\">\n"
            "      <doc>\n"
            "        <line>ApplicationRenderedUpdate = </line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"surfaceid\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ApplicationSwitchComplete\">\n"
            "      <doc>\n"
            "        <line>ApplicationSwitchComplete = </line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"surfaceid\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceState\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SubSurfaceSwitchComplete\">\n"
            "      <doc>\n"
            "        <line>SubSurfaceSwitchComplete = </line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"surfaceid\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceState\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"FollowUpAction\">\n"
            "      <doc>\n"
            "        <line>FollowUpAction = </line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"actionType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionType (of type followUpAction) = Description missing</line>\n"
            "          <line>enum[GADGET_PRESSED (null), GADGET_RELEASED (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ResponseFollowUpAction\">\n"
            "      <doc>\n"
            "        <line>ResponseFollowUpAction = </line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"actionType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionType (of type followUpAction) = Description missing</line>\n"
            "          <line>enum[GADGET_PRESSED (null), GADGET_RELEASED (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DrmBufferAllocationStatus\">\n"
            "      <doc>\n"
            "        <line>DrmBufferAllocationStatus = Report the status of dma buffer allocation</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pid\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>pid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type drmBufferAllocationStatus) = Description missing</line>\n"
            "          <line>enum[DRM_BUFFER_ALLOCATION_FAILED (null), DRM_BUFFER_ALLOCATION_SUCCESS (null), DRM_BUFFER_DEALLOCATION_FAILED (null), DRM_BUFFER_DEALLOCATION_SUCCESS (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"bufferSize\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>bufferSize = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"QueryClient\">\n"
            "      <doc>\n"
            "        <line>QueryClient = send out query to get info about all registered clients</line>\n"
            "      </doc>\n"
            "    </signal>\n"
            "    <signal name=\"subSurfaceSwitchUpdate\">\n"
            "      <doc>\n"
            "        <line>subSurfaceSwitchUpdate = broadcast sub surface switch complete msg to all apps</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"surfaceid\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceState\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>surfaceState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"keyInfoForwarding\">\n"
            "      <doc>\n"
            "        <line>keyInfoForwarding = broadcast key information to be processed by a particular client</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(uyuuuu)\">\n"
            "        <doc>\n"
            "          <line>data (of type keyInfo) = Description missing</line>\n"
            "          <line>keyInfo struct[keyCode, keyState, pidSender, pidReceiver, displayId, userData] = todo</line>\n"
            "          <line>0: keyInfo.keyCode ('u') = Description missing</line>\n"
            "          <line>1: keyInfo.keyState ('y') = Description missing</line>\n"
            "          <line>2: keyInfo.pidSender ('u') = Description missing</line>\n"
            "          <line>3: keyInfo.pidReceiver ('u') = Description missing</line>\n"
            "          <line>4: keyInfo.displayId ('u') = Description missing</line>\n"
            "          <line>5: keyInfo.userData ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"encoderInfoForwarding\">\n"
            "      <doc>\n"
            "        <line>encoderInfoForwarding = broadcast key information to be processed by a particular client</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iiuuuu)\">\n"
            "        <doc>\n"
            "          <line>data (of type encoderInfo) = Description missing</line>\n"
            "          <line>encoderInfo struct[encCode, encValue, pidSender, pidReceiver, surfaceId, userData] = encoder information</line>\n"
            "          <line>0: encoderInfo.encCode ('i') = Description missing</line>\n"
            "          <line>1: encoderInfo.encValue ('i') = Description missing</line>\n"
            "          <line>2: encoderInfo.pidSender ('u') = Description missing</line>\n"
            "          <line>3: encoderInfo.pidReceiver ('u') = Description missing</line>\n"
            "          <line>4: encoderInfo.surfaceId ('u') = Description missing</line>\n"
            "          <line>5: encoderInfo.userData ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SetDisplay\">\n"
            "      <doc>\n"
            "        <line>SetDisplay = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(issiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type displayData) = Description missing</line>\n"
            "          <line>displayData struct[pidReceiver, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: displayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: displayData.senderName ('s') = Description missing</line>\n"
            "          <line>2: displayData.receiverName ('s') = Description missing</line>\n"
            "          <line>3: displayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>4: displayData.regionType ('i') = Description missing</line>\n"
            "          <line>5: displayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SetMultiDisplay\">\n"
            "      <doc>\n"
            "        <line>SetMultiDisplay = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iussiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type MultidisplayData) = Description missing</line>\n"
            "          <line>MultidisplayData struct[pidReceiver, displayid, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: MultidisplayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: MultidisplayData.displayid ('u') = Description missing</line>\n"
            "          <line>2: MultidisplayData.senderName ('s') = Description missing</line>\n"
            "          <line>3: MultidisplayData.receiverName ('s') = Description missing</line>\n"
            "          <line>4: MultidisplayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>5: MultidisplayData.regionType ('i') = Description missing</line>\n"
            "          <line>6: MultidisplayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"evDisplayStatusEval\">\n"
            "      <doc>\n"
            "        <line>evDisplayStatusEval = use this to start display status evaluation (mainly used for statusline)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iussiin)\">\n"
            "        <doc>\n"
            "          <line>data (of type MultidisplayData) = Description missing</line>\n"
            "          <line>MultidisplayData struct[pidReceiver, displayid, senderName, receiverName, displayRegion, regionType, displayRegionStatus] = todo</line>\n"
            "          <line>0: MultidisplayData.pidReceiver ('i') = Description missing</line>\n"
            "          <line>1: MultidisplayData.displayid ('u') = Description missing</line>\n"
            "          <line>2: MultidisplayData.senderName ('s') = Description missing</line>\n"
            "          <line>3: MultidisplayData.receiverName ('s') = Description missing</line>\n"
            "          <line>4: MultidisplayData.displayRegion ('i') = Description missing</line>\n"
            "          <line>5: MultidisplayData.regionType ('i') = Description missing</line>\n"
            "          <line>6: MultidisplayData.displayRegionStatus ('n') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ActivateExternalImageProvider\">\n"
            "      <doc>\n"
            "        <line>ActivateExternalImageProvider = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"targetState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>targetState (of type gadgetStatus) = Description missing</line>\n"
            "          <line>enum[ACTIVE (null), INACTIVE (null), HIDDEN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"instanceIds\" type=\"ai\">\n"
            "        <doc>\n"
            "          <line>instanceIds = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"consumerId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>consumerId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ExternalImageProviderTouch\">\n"
            "      <doc>\n"
            "        <line>ExternalImageProviderTouch = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(yiiu)\">\n"
            "        <doc>\n"
            "          <line>data (of type touchInfo) = Description missing</line>\n"
            "          <line>touchInfo struct[touchState, xPos, yPos, timeStamp] = todo</line>\n"
            "          <line>0: touchInfo.touchState ('y') = Description missing</line>\n"
            "          <line>1: touchInfo.xPos ('i') = Description missing</line>\n"
            "          <line>2: touchInfo.yPos ('i') = Description missing</line>\n"
            "          <line>3: touchInfo.timeStamp ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"instanceId\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SlaveSurfaceRepositioning\">\n"
            "      <doc>\n"
            "        <line>SlaveSurfaceRepositioning = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"activate\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>activate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SlaveSurfaceRepositioningAck\">\n"
            "      <doc>\n"
            "        <line>SlaveSurfaceRepositioningAck = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"activate\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>activate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"DirectTextureConsumerPositionInfoRequest\">\n"
            "      <doc>\n"
            "        <line>DirectTextureConsumerPositionInfoRequest = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"instanceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"DirectTextureConsumerPositionInfoResponse\">\n"
            "      <doc>\n"
            "        <line>DirectTextureConsumerPositionInfoResponse = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"pidSender\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pidSender = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"instanceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>instanceId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"xPos\" type=\"d\">\n"
            "        <doc>\n"
            "          <line>xPos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"yPos\" type=\"d\">\n"
            "        <doc>\n"
            "          <line>yPos = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"DrmGarbageCollectionRequest\">\n"
            "      <doc>\n"
            "        <line>DrmGarbageCollectionRequest = Request all clients to clean up their dma buffer allocations</line>\n"
            "      </doc>\n"
            "    </signal>\n"
            "    <signal name=\"FollowUpActionRequest\">\n"
            "      <doc>\n"
            "        <line>FollowUpActionRequest = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"actionType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionType (of type followUpAction) = Description missing</line>\n"
            "          <line>enum[GADGET_PRESSED (null), GADGET_RELEASED (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"FollowUpActionResponse\">\n"
            "      <doc>\n"
            "        <line>FollowUpActionResponse = todo</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"actionType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionType (of type followUpAction) = Description missing</line>\n"
            "          <line>enum[GADGET_PRESSED (null), GADGET_RELEASED (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void HMIAppCtrlStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HMIAppCtrlStub*>(getStub()))->onGetAll (properties);
}

void HMIAppCtrlStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ExternalImagesStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Clients");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HMIAppCtrlStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ExternalImagesStatus");
            ::boost::shared_ptr< ExternalImagesStatusGet > payload(new ExternalImagesStatusGet());
            payload->setAct(act);
            static_cast<HMIAppCtrlStub*>(getStub())->onExternalImagesStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Clients");
            ::boost::shared_ptr< ClientsGet > payload(new ClientsGet());
            payload->setAct(act);
            static_cast<HMIAppCtrlStub*>(getStub())->onClientsGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HMIAppCtrlStub::HMIAppCtrlStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HMIAppCtrlStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HMIAppCtrlStub::HMIAppCtrlStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HMIAppCtrlStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HMIAppCtrlStub::~HMIAppCtrlStub() {
    delete _stubDelegate;
}

void HMIAppCtrlStub::sendQueryClientSignal() {
    if (_stubDelegate->isConnected()) {
        QueryClientSignal* payload = new QueryClientSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "QueryClient", QueryClientSignal, payload)
        LOG_INFO ("-> send%sSignal", "QueryClient");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "QueryClient");
    }
}

void HMIAppCtrlStub::sendSubSurfaceSwitchUpdateSignal(int32 surfaceid, int32 surfaceState) {
    if (_stubDelegate->isConnected()) {
        SubSurfaceSwitchUpdateSignal* payload = new SubSurfaceSwitchUpdateSignal(surfaceid, surfaceState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "subSurfaceSwitchUpdate", SubSurfaceSwitchUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "SubSurfaceSwitchUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SubSurfaceSwitchUpdate");
    }
}

void HMIAppCtrlStub::sendKeyInfoForwardingSignal(const keyInfo& data) {
    if (_stubDelegate->isConnected()) {
        KeyInfoForwardingSignal* payload = new KeyInfoForwardingSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "keyInfoForwarding", KeyInfoForwardingSignal, payload)
        LOG_INFO ("-> send%sSignal", "KeyInfoForwarding");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "KeyInfoForwarding");
    }
}

void HMIAppCtrlStub::sendEncoderInfoForwardingSignal(const encoderInfo& data) {
    if (_stubDelegate->isConnected()) {
        EncoderInfoForwardingSignal* payload = new EncoderInfoForwardingSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "encoderInfoForwarding", EncoderInfoForwardingSignal, payload)
        LOG_INFO ("-> send%sSignal", "EncoderInfoForwarding");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EncoderInfoForwarding");
    }
}

void HMIAppCtrlStub::sendSetDisplaySignal(const displayData& data) {
    if (_stubDelegate->isConnected()) {
        SetDisplaySignal* payload = new SetDisplaySignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SetDisplay", SetDisplaySignal, payload)
        LOG_INFO ("-> send%sSignal", "SetDisplay");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SetDisplay");
    }
}

void HMIAppCtrlStub::sendSetMultiDisplaySignal(const MultidisplayData& data) {
    if (_stubDelegate->isConnected()) {
        SetMultiDisplaySignal* payload = new SetMultiDisplaySignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SetMultiDisplay", SetMultiDisplaySignal, payload)
        LOG_INFO ("-> send%sSignal", "SetMultiDisplay");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SetMultiDisplay");
    }
}

void HMIAppCtrlStub::sendEvDisplayStatusEvalSignal(const MultidisplayData& data) {
    if (_stubDelegate->isConnected()) {
        EvDisplayStatusEvalSignal* payload = new EvDisplayStatusEvalSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "evDisplayStatusEval", EvDisplayStatusEvalSignal, payload)
        LOG_INFO ("-> send%sSignal", "EvDisplayStatusEval");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EvDisplayStatusEval");
    }
}

void HMIAppCtrlStub::sendActivateExternalImageProviderSignal(gadgetStatus targetState, const ::std::vector< int32 >& instanceIds, int32 consumerId) {
    if (_stubDelegate->isConnected()) {
        ActivateExternalImageProviderSignal* payload = new ActivateExternalImageProviderSignal(targetState, instanceIds, consumerId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ActivateExternalImageProvider", ActivateExternalImageProviderSignal, payload)
        LOG_INFO ("-> send%sSignal", "ActivateExternalImageProvider");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ActivateExternalImageProvider");
    }
}

void HMIAppCtrlStub::sendExternalImageProviderTouchSignal(uint32 pidSender, const touchInfo& data, int32 instanceId) {
    if (_stubDelegate->isConnected()) {
        ExternalImageProviderTouchSignal* payload = new ExternalImageProviderTouchSignal(pidSender, data, instanceId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ExternalImageProviderTouch", ExternalImageProviderTouchSignal, payload)
        LOG_INFO ("-> send%sSignal", "ExternalImageProviderTouch");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ExternalImageProviderTouch");
    }
}

void HMIAppCtrlStub::sendSlaveSurfaceRepositioningSignal(uint32 pidSender, bool activate, uint32 surfaceId) {
    if (_stubDelegate->isConnected()) {
        SlaveSurfaceRepositioningSignal* payload = new SlaveSurfaceRepositioningSignal(pidSender, activate, surfaceId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SlaveSurfaceRepositioning", SlaveSurfaceRepositioningSignal, payload)
        LOG_INFO ("-> send%sSignal", "SlaveSurfaceRepositioning");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SlaveSurfaceRepositioning");
    }
}

void HMIAppCtrlStub::sendSlaveSurfaceRepositioningAckSignal(uint32 pidSender, bool activate, uint32 surfaceId, bool status) {
    if (_stubDelegate->isConnected()) {
        SlaveSurfaceRepositioningAckSignal* payload = new SlaveSurfaceRepositioningAckSignal(pidSender, activate, surfaceId, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SlaveSurfaceRepositioningAck", SlaveSurfaceRepositioningAckSignal, payload)
        LOG_INFO ("-> send%sSignal", "SlaveSurfaceRepositioningAck");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SlaveSurfaceRepositioningAck");
    }
}

void HMIAppCtrlStub::sendDirectTextureConsumerPositionInfoRequestSignal(uint32 pidSender, uint32 instanceId) {
    if (_stubDelegate->isConnected()) {
        DirectTextureConsumerPositionInfoRequestSignal* payload = new DirectTextureConsumerPositionInfoRequestSignal(pidSender, instanceId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DirectTextureConsumerPositionInfoRequest", DirectTextureConsumerPositionInfoRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "DirectTextureConsumerPositionInfoRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DirectTextureConsumerPositionInfoRequest");
    }
}

void HMIAppCtrlStub::sendDirectTextureConsumerPositionInfoResponseSignal(uint32 pidSender, uint32 instanceId, float xPos, float yPos) {
    if (_stubDelegate->isConnected()) {
        DirectTextureConsumerPositionInfoResponseSignal* payload = new DirectTextureConsumerPositionInfoResponseSignal(pidSender, instanceId, xPos, yPos);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DirectTextureConsumerPositionInfoResponse", DirectTextureConsumerPositionInfoResponseSignal, payload)
        LOG_INFO ("-> send%sSignal", "DirectTextureConsumerPositionInfoResponse");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DirectTextureConsumerPositionInfoResponse");
    }
}

void HMIAppCtrlStub::sendDrmGarbageCollectionRequestSignal() {
    if (_stubDelegate->isConnected()) {
        DrmGarbageCollectionRequestSignal* payload = new DrmGarbageCollectionRequestSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DrmGarbageCollectionRequest", DrmGarbageCollectionRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "DrmGarbageCollectionRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DrmGarbageCollectionRequest");
    }
}

void HMIAppCtrlStub::sendFollowUpActionRequestSignal(followUpAction actionType, uint32 userData) {
    if (_stubDelegate->isConnected()) {
        FollowUpActionRequestSignal* payload = new FollowUpActionRequestSignal(actionType, userData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FollowUpActionRequest", FollowUpActionRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "FollowUpActionRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FollowUpActionRequest");
    }
}

void HMIAppCtrlStub::sendFollowUpActionResponseSignal(followUpAction actionType, uint32 userData) {
    if (_stubDelegate->isConnected()) {
        FollowUpActionResponseSignal* payload = new FollowUpActionResponseSignal(actionType, userData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FollowUpActionResponse", FollowUpActionResponseSignal, payload)
        LOG_INFO ("-> send%sSignal", "FollowUpActionResponse");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FollowUpActionResponse");
    }
}

void HMIAppCtrlStub::sendExternalImagesStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExternalImagesStatusUpdate payload(_ExternalImagesStatusProperty);

        LOG_INFO ("-> send%s", "ExternalImagesStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExternalImagesStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExternalImagesStatusUpdate");
    }
}

void HMIAppCtrlStub::onExternalImagesStatusGet(const ::boost::shared_ptr< ExternalImagesStatusGet >& externalImagesStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExternalImagesStatusGet", externalImagesStatus->getAct());
    sendExternalImagesStatusGetUpdate(_ExternalImagesStatusProperty.getExternalImagesStatus(), externalImagesStatus->getAct());
}

void HMIAppCtrlStub::sendExternalImagesStatusGetUpdate(const ::std::vector< ExternalImageData >& externalImagesStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExternalImagesStatusGet payload(externalImagesStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExternalImagesStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HMIAppCtrlStub::setExternalImagesStatus(const ::std::vector< ExternalImageData >& externalImagesStatus) {
    if(externalImagesStatus!=_ExternalImagesStatusProperty.getExternalImagesStatus()) {
        _ExternalImagesStatusProperty.setExternalImagesStatus(externalImagesStatus);
        sendExternalImagesStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ExternalImageData >& HMIAppCtrlStub::getExternalImagesStatus() const {
    return _ExternalImagesStatusProperty.getExternalImagesStatus();
}

::std::vector< ExternalImageData >& HMIAppCtrlStub::getExternalImagesStatusMutable() {
    return _ExternalImagesStatusProperty.getExternalImagesStatusMutable();
}

void HMIAppCtrlStub::sendClientsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ClientsUpdate payload(_ClientsProperty);

        LOG_INFO ("-> send%s", "ClientsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Clients", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ClientsUpdate");
    }
}

void HMIAppCtrlStub::onClientsGet(const ::boost::shared_ptr< ClientsGet >& clients) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ClientsGet", clients->getAct());
    sendClientsGetUpdate(_ClientsProperty.getClients(), clients->getAct());
}

void HMIAppCtrlStub::sendClientsGetUpdate(const ::std::vector< ApplicationState >& clients, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ClientsGet payload(clients);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ClientsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HMIAppCtrlStub::setClients(const ::std::vector< ApplicationState >& clients) {
    if(clients!=_ClientsProperty.getClients()) {
        _ClientsProperty.setClients(clients);
        sendClientsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ApplicationState >& HMIAppCtrlStub::getClients() const {
    return _ClientsProperty.getClients();
}

::std::vector< ApplicationState >& HMIAppCtrlStub::getClientsMutable() {
    return _ClientsProperty.getClientsMutable();
}





















void HMIAppCtrlStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'ExternalImagesStatus'
    {
        ::asf::dbus::DBusVariant variant;
        ExternalImagesStatusGet payload(_ExternalImagesStatusProperty.getExternalImagesStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExternalImagesStatus", variant));
    }

    //property 'Clients'
    {
        ::asf::dbus::DBusVariant variant;
        ClientsGet payload(_ClientsProperty.getClients());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Clients", variant));
    }
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
