/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLPROXY_H
#define BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

class HMIAppCtrlProxy;

class ActivateExternalImageProviderCallbackIF {
public:
    virtual ~ActivateExternalImageProviderCallbackIF() {}

    virtual void onActivateExternalImageProviderError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ActivateExternalImageProviderError >& error) = 0;

    virtual void onActivateExternalImageProviderSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ActivateExternalImageProviderSignal >& signal) = 0;
};

class ClientsCallbackIF {
public:
    virtual ~ClientsCallbackIF() {}

    virtual void onClientsError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ClientsError >& error) = 0;

    virtual void onClientsUpdate(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ClientsUpdate >& update) = 0;
};

class DirectTextureConsumerPositionInfoRequestCallbackIF {
public:
    virtual ~DirectTextureConsumerPositionInfoRequestCallbackIF() {}

    virtual void onDirectTextureConsumerPositionInfoRequestError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DirectTextureConsumerPositionInfoRequestError >& error) = 0;

    virtual void onDirectTextureConsumerPositionInfoRequestSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DirectTextureConsumerPositionInfoRequestSignal >& signal) = 0;
};

class DirectTextureConsumerPositionInfoResponseCallbackIF {
public:
    virtual ~DirectTextureConsumerPositionInfoResponseCallbackIF() {}

    virtual void onDirectTextureConsumerPositionInfoResponseError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DirectTextureConsumerPositionInfoResponseError >& error) = 0;

    virtual void onDirectTextureConsumerPositionInfoResponseSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DirectTextureConsumerPositionInfoResponseSignal >& signal) = 0;
};

class DrmGarbageCollectionRequestCallbackIF {
public:
    virtual ~DrmGarbageCollectionRequestCallbackIF() {}

    virtual void onDrmGarbageCollectionRequestError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DrmGarbageCollectionRequestError >& error) = 0;

    virtual void onDrmGarbageCollectionRequestSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< DrmGarbageCollectionRequestSignal >& signal) = 0;
};

class EncoderInfoForwardingCallbackIF {
public:
    virtual ~EncoderInfoForwardingCallbackIF() {}

    virtual void onEncoderInfoForwardingError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< EncoderInfoForwardingError >& error) = 0;

    virtual void onEncoderInfoForwardingSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< EncoderInfoForwardingSignal >& signal) = 0;
};

class EvDisplayStatusEvalCallbackIF {
public:
    virtual ~EvDisplayStatusEvalCallbackIF() {}

    virtual void onEvDisplayStatusEvalError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< EvDisplayStatusEvalError >& error) = 0;

    virtual void onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< EvDisplayStatusEvalSignal >& signal) = 0;
};

class ExternalImageProviderTouchCallbackIF {
public:
    virtual ~ExternalImageProviderTouchCallbackIF() {}

    virtual void onExternalImageProviderTouchError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ExternalImageProviderTouchError >& error) = 0;

    virtual void onExternalImageProviderTouchSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ExternalImageProviderTouchSignal >& signal) = 0;
};

class ExternalImagesStatusCallbackIF {
public:
    virtual ~ExternalImagesStatusCallbackIF() {}

    virtual void onExternalImagesStatusError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ExternalImagesStatusError >& error) = 0;

    virtual void onExternalImagesStatusUpdate(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< ExternalImagesStatusUpdate >& update) = 0;
};

class FollowUpActionRequestCallbackIF {
public:
    virtual ~FollowUpActionRequestCallbackIF() {}

    virtual void onFollowUpActionRequestError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< FollowUpActionRequestError >& error) = 0;

    virtual void onFollowUpActionRequestSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< FollowUpActionRequestSignal >& signal) = 0;
};

class FollowUpActionResponseCallbackIF {
public:
    virtual ~FollowUpActionResponseCallbackIF() {}

    virtual void onFollowUpActionResponseError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< FollowUpActionResponseError >& error) = 0;

    virtual void onFollowUpActionResponseSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< FollowUpActionResponseSignal >& signal) = 0;
};

class KeyInfoForwardingCallbackIF {
public:
    virtual ~KeyInfoForwardingCallbackIF() {}

    virtual void onKeyInfoForwardingError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< KeyInfoForwardingError >& error) = 0;

    virtual void onKeyInfoForwardingSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< KeyInfoForwardingSignal >& signal) = 0;
};

class QueryClientCallbackIF {
public:
    virtual ~QueryClientCallbackIF() {}

    virtual void onQueryClientError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< QueryClientError >& error) = 0;

    virtual void onQueryClientSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< QueryClientSignal >& signal) = 0;
};

class SetDisplayCallbackIF {
public:
    virtual ~SetDisplayCallbackIF() {}

    virtual void onSetDisplayError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SetDisplayError >& error) = 0;

    virtual void onSetDisplaySignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SetDisplaySignal >& signal) = 0;
};

class SetMultiDisplayCallbackIF {
public:
    virtual ~SetMultiDisplayCallbackIF() {}

    virtual void onSetMultiDisplayError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SetMultiDisplayError >& error) = 0;

    virtual void onSetMultiDisplaySignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SetMultiDisplaySignal >& signal) = 0;
};

class SlaveSurfaceRepositioningAckCallbackIF {
public:
    virtual ~SlaveSurfaceRepositioningAckCallbackIF() {}

    virtual void onSlaveSurfaceRepositioningAckError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SlaveSurfaceRepositioningAckError >& error) = 0;

    virtual void onSlaveSurfaceRepositioningAckSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SlaveSurfaceRepositioningAckSignal >& signal) = 0;
};

class SlaveSurfaceRepositioningCallbackIF {
public:
    virtual ~SlaveSurfaceRepositioningCallbackIF() {}

    virtual void onSlaveSurfaceRepositioningError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SlaveSurfaceRepositioningError >& error) = 0;

    virtual void onSlaveSurfaceRepositioningSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SlaveSurfaceRepositioningSignal >& signal) = 0;
};

class SubSurfaceSwitchUpdateCallbackIF {
public:
    virtual ~SubSurfaceSwitchUpdateCallbackIF() {}

    virtual void onSubSurfaceSwitchUpdateError(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SubSurfaceSwitchUpdateError >& error) = 0;

    virtual void onSubSurfaceSwitchUpdateSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< SubSurfaceSwitchUpdateSignal >& signal) = 0;
};


/**
 * HMIAppCtrlProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.ai.hmi.appctrl.HMIAppCtrl' (specified in file
 * HMIAppCtrl_.xml).
 *
 * service for common hmi application control functionality
 */
class HMIAppCtrlProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HMIAppCtrlProxy.
     */
    static ::boost::shared_ptr< HMIAppCtrlProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HMIAppCtrlProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HMIAppCtrlProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HMIAppCtrlProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HMIAppCtrlProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HMIAppCtrlProxy > proxyNew(new HMIAppCtrlProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~HMIAppCtrlProxy ();


    // Signal 'QueryClient'

    /**
     * Notify on the signal 'QueryClient'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'QueryClient'</b>:
     *
     * send out query to get info about all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendQueryClientRegister(QueryClientCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'QueryClient'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'QueryClient'</b>:
     *
     * send out query to get info about all registered clients
     *
     * @param act The act which was previously returned by the
     * sendQueryClientRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendQueryClientDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'QueryClient'.
     */
    void sendQueryClientDeregisterAll () const;

    // Signal 'subSurfaceSwitchUpdate'

    /**
     * Notify on the signal 'subSurfaceSwitchUpdate'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'subSurfaceSwitchUpdate'</b>:
     *
     * broadcast sub surface switch complete msg to all apps
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubSurfaceSwitchUpdateRegister(SubSurfaceSwitchUpdateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'subSurfaceSwitchUpdate'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'subSurfaceSwitchUpdate'</b>:
     *
     * broadcast sub surface switch complete msg to all apps
     *
     * @param act The act which was previously returned by the
     * sendSubSurfaceSwitchUpdateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSubSurfaceSwitchUpdateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'subSurfaceSwitchUpdate'.
     */
    void sendSubSurfaceSwitchUpdateDeregisterAll () const;

    // Signal 'keyInfoForwarding'

    /**
     * Notify on the signal 'keyInfoForwarding'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'keyInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyInfoForwardingRegister(KeyInfoForwardingCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'keyInfoForwarding'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'keyInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param act The act which was previously returned by the
     * sendKeyInfoForwardingRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKeyInfoForwardingDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'keyInfoForwarding'.
     */
    void sendKeyInfoForwardingDeregisterAll () const;

    // Signal 'encoderInfoForwarding'

    /**
     * Notify on the signal 'encoderInfoForwarding'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'encoderInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderInfoForwardingRegister(EncoderInfoForwardingCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'encoderInfoForwarding'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'encoderInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param act The act which was previously returned by the
     * sendEncoderInfoForwardingRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEncoderInfoForwardingDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'encoderInfoForwarding'.
     */
    void sendEncoderInfoForwardingDeregisterAll () const;

    // Signal 'SetDisplay'

    /**
     * Notify on the signal 'SetDisplay'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDisplayRegister(SetDisplayCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SetDisplay'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendSetDisplayRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSetDisplayDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SetDisplay'.
     */
    void sendSetDisplayDeregisterAll () const;

    // Signal 'SetMultiDisplay'

    /**
     * Notify on the signal 'SetMultiDisplay'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SetMultiDisplay'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMultiDisplayRegister(SetMultiDisplayCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SetMultiDisplay'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SetMultiDisplay'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendSetMultiDisplayRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSetMultiDisplayDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SetMultiDisplay'.
     */
    void sendSetMultiDisplayDeregisterAll () const;

    // Signal 'evDisplayStatusEval'

    /**
     * Notify on the signal 'evDisplayStatusEval'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'evDisplayStatusEval'</b>:
     *
     * use this to start display status evaluation (mainly used for statusline)
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEvDisplayStatusEvalRegister(EvDisplayStatusEvalCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'evDisplayStatusEval'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'evDisplayStatusEval'</b>:
     *
     * use this to start display status evaluation (mainly used for statusline)
     *
     * @param act The act which was previously returned by the
     * sendEvDisplayStatusEvalRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEvDisplayStatusEvalDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'evDisplayStatusEval'.
     */
    void sendEvDisplayStatusEvalDeregisterAll () const;

    // Signal 'ActivateExternalImageProvider'

    /**
     * Notify on the signal 'ActivateExternalImageProvider'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'ActivateExternalImageProvider'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateExternalImageProviderRegister(ActivateExternalImageProviderCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ActivateExternalImageProvider'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ActivateExternalImageProvider'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendActivateExternalImageProviderRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActivateExternalImageProviderDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'ActivateExternalImageProvider'.
     */
    void sendActivateExternalImageProviderDeregisterAll () const;

    // Signal 'ExternalImageProviderTouch'

    /**
     * Notify on the signal 'ExternalImageProviderTouch'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'ExternalImageProviderTouch'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExternalImageProviderTouchRegister(ExternalImageProviderTouchCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ExternalImageProviderTouch'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ExternalImageProviderTouch'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendExternalImageProviderTouchRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendExternalImageProviderTouchDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'ExternalImageProviderTouch'.
     */
    void sendExternalImageProviderTouchDeregisterAll () const;

    // Signal 'SlaveSurfaceRepositioning'

    /**
     * Notify on the signal 'SlaveSurfaceRepositioning'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioning'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSlaveSurfaceRepositioningRegister(SlaveSurfaceRepositioningCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SlaveSurfaceRepositioning'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioning'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendSlaveSurfaceRepositioningRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSlaveSurfaceRepositioningDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'SlaveSurfaceRepositioning'.
     */
    void sendSlaveSurfaceRepositioningDeregisterAll () const;

    // Signal 'SlaveSurfaceRepositioningAck'

    /**
     * Notify on the signal 'SlaveSurfaceRepositioningAck'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioningAck'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSlaveSurfaceRepositioningAckRegister(SlaveSurfaceRepositioningAckCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SlaveSurfaceRepositioningAck'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioningAck'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendSlaveSurfaceRepositioningAckRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSlaveSurfaceRepositioningAckDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'SlaveSurfaceRepositioningAck'.
     */
    void sendSlaveSurfaceRepositioningAckDeregisterAll () const;

    // Signal 'DirectTextureConsumerPositionInfoRequest'

    /**
     * Notify on the signal 'DirectTextureConsumerPositionInfoRequest'. This
     * method registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoRequest'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDirectTextureConsumerPositionInfoRequestRegister(DirectTextureConsumerPositionInfoRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal
     * 'DirectTextureConsumerPositionInfoRequest'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoRequest'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendDirectTextureConsumerPositionInfoRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDirectTextureConsumerPositionInfoRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'DirectTextureConsumerPositionInfoRequest'.
     */
    void sendDirectTextureConsumerPositionInfoRequestDeregisterAll () const;

    // Signal 'DirectTextureConsumerPositionInfoResponse'

    /**
     * Notify on the signal 'DirectTextureConsumerPositionInfoResponse'. This
     * method registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoResponse'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDirectTextureConsumerPositionInfoResponseRegister(DirectTextureConsumerPositionInfoResponseCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal
     * 'DirectTextureConsumerPositionInfoResponse'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoResponse'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendDirectTextureConsumerPositionInfoResponseRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDirectTextureConsumerPositionInfoResponseDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'DirectTextureConsumerPositionInfoResponse'.
     */
    void sendDirectTextureConsumerPositionInfoResponseDeregisterAll () const;

    // Signal 'DrmGarbageCollectionRequest'

    /**
     * Notify on the signal 'DrmGarbageCollectionRequest'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'DrmGarbageCollectionRequest'</b>:
     *
     * Request all clients to clean up their dma buffer allocations
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDrmGarbageCollectionRequestRegister(DrmGarbageCollectionRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DrmGarbageCollectionRequest'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DrmGarbageCollectionRequest'</b>:
     *
     * Request all clients to clean up their dma buffer allocations
     *
     * @param act The act which was previously returned by the
     * sendDrmGarbageCollectionRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDrmGarbageCollectionRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'DrmGarbageCollectionRequest'.
     */
    void sendDrmGarbageCollectionRequestDeregisterAll () const;

    // Signal 'FollowUpActionRequest'

    /**
     * Notify on the signal 'FollowUpActionRequest'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'FollowUpActionRequest'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFollowUpActionRequestRegister(FollowUpActionRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FollowUpActionRequest'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FollowUpActionRequest'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendFollowUpActionRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFollowUpActionRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FollowUpActionRequest'.
     */
    void sendFollowUpActionRequestDeregisterAll () const;

    // Signal 'FollowUpActionResponse'

    /**
     * Notify on the signal 'FollowUpActionResponse'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'FollowUpActionResponse'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFollowUpActionResponseRegister(FollowUpActionResponseCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FollowUpActionResponse'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FollowUpActionResponse'</b>:
     *
     * todo
     *
     * @param act The act which was previously returned by the
     * sendFollowUpActionResponseRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFollowUpActionResponseDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FollowUpActionResponse'.
     */
    void sendFollowUpActionResponseDeregisterAll () const;


    // Property 'ExternalImagesStatus'


    /**
     * Request the value of the property 'ExternalImagesStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExternalImagesStatusGet(ExternalImagesStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'ExternalImagesStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasExternalImagesStatus() returns true.
     *
     * @return the previously received value of the property 'ExternalImagesStatus'.
     */
    const ::std::vector< ExternalImageData >& getExternalImagesStatus() const;

    /**
     * Determines whether a status message for the property
     * 'ExternalImagesStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasExternalImagesStatus() const;

    // Property 'Clients'

    /**
     * Notify on the property 'Clients'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClientsRegister(ClientsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Clients'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     *
     * @param act The act which was previously returned by the
     * sendClientsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendClientsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Clients'.
     */
    void sendClientsDeregisterAll() const;

    /**
     * Request the value of the property 'Clients' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClientsGet(ClientsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Clients' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasClients()
     * returns true.
     *
     * @return the previously received value of the property 'Clients'.
     */
    const ::std::vector< ApplicationState >& getClients() const;

    /**
     * Determines whether a status message for the property 'Clients' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasClients() const;


    // Method 'UpdateClientStatus'

    /**
     * Call the method 'UpdateClientStatus'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'UpdateClientStatus'</b>:
     *
     * transport information about the hmi process to stub
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pid If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param state_ If the meaning of "state_" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateClientStatusRequest(uint32 pid, const ::std::string& name, hmiAppState state_) const;

    // Method 'KeyForwarding'

    /**
     * Call the method 'KeyForwarding'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'KeyForwarding'</b>:
     *
     * forward a received (and not consumed) key event to stub
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param keyRequest If the meaning of "keyRequest" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyForwardingRequest(const keyInfo& keyRequest) const;

    // Method 'EncoderForwarding'

    /**
     * Call the method 'EncoderForwarding'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'EncoderForwarding'</b>:
     *
     * forward a received (and not consumed) encoder event to stub
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param encoderRequest If the meaning of "encoderRequest" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderForwardingRequest(const encoderInfo& encoderRequest) const;

    // Method 'BeepForwarding'

    /**
     * Call the method 'BeepForwarding'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'BeepForwarding'</b>:
     *
     * forward a beep request to stub
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param beepType If the meaning of "beepType" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBeepForwardingRequest(int32 beepType) const;

    // Method 'SetApplicationMandatory'

    /**
     * Call the method 'SetApplicationMandatory'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'SetApplicationMandatory'</b>:
     *
     * set the calling application as mandatory for synchronized hmi startup
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetApplicationMandatoryRequest(const ::std::string& name, bool value) const;

    // Method 'DisplayCmd'

    /**
     * Call the method 'DisplayCmd'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'DisplayCmd'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisplayCmdRequest(const displayData& data) const;

    // Method 'MultiDisplayCmd'

    /**
     * Call the method 'MultiDisplayCmd'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'MultiDisplayCmd'</b>:
     *
     * If the meaning of "MultiDisplayCmd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMultiDisplayCmdRequest(const MultidisplayData& data) const;

    // Method 'DisplayStatusEval'

    /**
     * Call the method 'DisplayStatusEval'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DisplayStatusEval'</b>:
     *
     * todo
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisplayStatusEvalRequest(const MultidisplayData& data) const;

    // Method 'RequestExternalImageProviderActivation'

    /**
     * Call the method 'RequestExternalImageProviderActivation'. This method
     * sends a message to the D-Bus server.
     *
     * <b>Documentation of 'RequestExternalImageProviderActivation'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param targetState If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @param instanceIds If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @param consumerId If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestExternalImageProviderActivationRequest(gadgetStatus targetState, const ::std::vector< int32 >& instanceIds, int32 consumerId) const;

    // Method 'RequestExternalImageProviderTouch'

    /**
     * Call the method 'RequestExternalImageProviderTouch'. This method sends
     * a message to the D-Bus server.
     *
     * <b>Documentation of 'RequestExternalImageProviderTouch'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestExternalImageProviderTouchRequest(uint32 pidSender, const touchInfo& data, int32 instanceId) const;

    // Method 'RequestSlaveSurfaceRepositioning'

    /**
     * Call the method 'RequestSlaveSurfaceRepositioning'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RequestSlaveSurfaceRepositioning'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param activate If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param surfaceId If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSlaveSurfaceRepositioningRequest(uint32 pidSender, bool activate, uint32 surfaceId) const;

    // Method 'ResponseSlaveSurfaceRepositioning'

    /**
     * Call the method 'ResponseSlaveSurfaceRepositioning'. This method sends
     * a message to the D-Bus server.
     *
     * <b>Documentation of 'ResponseSlaveSurfaceRepositioning'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param activate If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param surfaceId If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResponseSlaveSurfaceRepositioningRequest(uint32 pidSender, bool activate, uint32 surfaceId, bool status) const;

    // Method 'RequestDirectTextureConsumerPositionInfo'

    /**
     * Call the method 'RequestDirectTextureConsumerPositionInfo'. This method
     * sends a message to the D-Bus server.
     *
     * <b>Documentation of 'RequestDirectTextureConsumerPositionInfo'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestDirectTextureConsumerPositionInfoRequest(uint32 pidSender, uint32 instanceId) const;

    // Method 'ResponseDirectTextureConsumerPositionInfo'

    /**
     * Call the method 'ResponseDirectTextureConsumerPositionInfo'. This
     * method sends a message to the D-Bus server.
     *
     * <b>Documentation of 'ResponseDirectTextureConsumerPositionInfo'</b>:
     *
     * request stub to distribute
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param xPos If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param yPos If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResponseDirectTextureConsumerPositionInfoRequest(uint32 pidSender, uint32 instanceId, float xPos, float yPos) const;

    // Method 'ApplicationRenderedUpdate'

    /**
     * Call the method 'ApplicationRenderedUpdate'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ApplicationRenderedUpdate'</b>:
     *
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param surfaceid If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendApplicationRenderedUpdateRequest(int32 surfaceid) const;

    // Method 'ApplicationSwitchComplete'

    /**
     * Call the method 'ApplicationSwitchComplete'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ApplicationSwitchComplete'</b>:
     *
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param surfaceid If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceState If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendApplicationSwitchCompleteRequest(int32 surfaceid, int32 surfaceState) const;

    // Method 'SubSurfaceSwitchComplete'

    /**
     * Call the method 'SubSurfaceSwitchComplete'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'SubSurfaceSwitchComplete'</b>:
     *
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param surfaceid If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceState If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubSurfaceSwitchCompleteRequest(int32 surfaceid, int32 surfaceState) const;

    // Method 'FollowUpAction'

    /**
     * Call the method 'FollowUpAction'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'FollowUpAction'</b>:
     *
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param actionType If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param userData If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFollowUpActionRequest(followUpAction actionType, uint32 userData) const;

    // Method 'ResponseFollowUpAction'

    /**
     * Call the method 'ResponseFollowUpAction'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'ResponseFollowUpAction'</b>:
     *
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param actionType If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param userData If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResponseFollowUpActionRequest(followUpAction actionType, uint32 userData) const;

    // Method 'DrmBufferAllocationStatus'

    /**
     * Call the method 'DrmBufferAllocationStatus'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'DrmBufferAllocationStatus'</b>:
     *
     * Report the status of dma buffer allocation
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pid If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param bufferSize If the meaning of "bufferSize" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDrmBufferAllocationStatusRequest(int32 pid, drmBufferAllocationStatus status, uint32 bufferSize) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HMIAppCtrlProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'ExternalImagesStatus'

    ::asf::core::nullable< ExternalImagesStatusUpdate > _externalImagesStatus;

    // Property 'Clients'

    ::asf::core::nullable< ClientsUpdate > _clients;

    DECLARE_CLASS_LOGGER();

    friend class HMIAppCtrlProxyCallback;
};

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLPROXY_H
