/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlJson.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "keyInfo"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKeyCode()) {
        yajl_gen_string(g, (const unsigned char*)  "keyCode" , 7);
        yajl_gen_integer(g, (long long)value.getKeyCode());
    }
    if (!isSparse || value.hasKeyState()) {
        yajl_gen_string(g, (const unsigned char*)  "keyState" , 8);
        yajl_gen_integer(g, (long long)value.getKeyState());
    }
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasPidReceiver()) {
        yajl_gen_string(g, (const unsigned char*)  "pidReceiver" , 11);
        yajl_gen_integer(g, (long long)value.getPidReceiver());
    }
    if (!isSparse || value.hasDisplayId()) {
        yajl_gen_string(g, (const unsigned char*)  "displayId" , 9);
        yajl_gen_integer(g, (long long)value.getDisplayId());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "touchInfo"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTouchState()) {
        yajl_gen_string(g, (const unsigned char*)  "touchState" , 10);
        yajl_gen_integer(g, (long long)value.getTouchState());
    }
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_integer(g, (long long)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_integer(g, (long long)value.getYPos());
    }
    if (!isSparse || value.hasTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "timeStamp" , 9);
        yajl_gen_integer(g, (long long)value.getTimeStamp());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "encoderInfo"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEncCode()) {
        yajl_gen_string(g, (const unsigned char*)  "encCode" , 7);
        yajl_gen_integer(g, (long long)value.getEncCode());
    }
    if (!isSparse || value.hasEncValue()) {
        yajl_gen_string(g, (const unsigned char*)  "encValue" , 8);
        yajl_gen_integer(g, (long long)value.getEncValue());
    }
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasPidReceiver()) {
        yajl_gen_string(g, (const unsigned char*)  "pidReceiver" , 11);
        yajl_gen_integer(g, (long long)value.getPidReceiver());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "displayData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidReceiver()) {
        yajl_gen_string(g, (const unsigned char*)  "pidReceiver" , 11);
        yajl_gen_integer(g, (long long)value.getPidReceiver());
    }
    if (!isSparse || value.hasSenderName()) {
        yajl_gen_string(g, (const unsigned char*)  "senderName" , 10);
        const char *s = value.getSenderName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasReceiverName()) {
        yajl_gen_string(g, (const unsigned char*)  "receiverName" , 12);
        const char *s = value.getReceiverName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDisplayRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "displayRegion" , 13);
        yajl_gen_integer(g, (long long)value.getDisplayRegion());
    }
    if (!isSparse || value.hasRegionType()) {
        yajl_gen_string(g, (const unsigned char*)  "regionType" , 10);
        yajl_gen_integer(g, (long long)value.getRegionType());
    }
    if (!isSparse || value.hasDisplayRegionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "displayRegionStatus" , 19);
        yajl_gen_integer(g, (long long)value.getDisplayRegionStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MultidisplayData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidReceiver()) {
        yajl_gen_string(g, (const unsigned char*)  "pidReceiver" , 11);
        yajl_gen_integer(g, (long long)value.getPidReceiver());
    }
    if (!isSparse || value.hasDisplayid()) {
        yajl_gen_string(g, (const unsigned char*)  "displayid" , 9);
        yajl_gen_integer(g, (long long)value.getDisplayid());
    }
    if (!isSparse || value.hasSenderName()) {
        yajl_gen_string(g, (const unsigned char*)  "senderName" , 10);
        const char *s = value.getSenderName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasReceiverName()) {
        yajl_gen_string(g, (const unsigned char*)  "receiverName" , 12);
        const char *s = value.getReceiverName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDisplayRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "displayRegion" , 13);
        yajl_gen_integer(g, (long long)value.getDisplayRegion());
    }
    if (!isSparse || value.hasRegionType()) {
        yajl_gen_string(g, (const unsigned char*)  "regionType" , 10);
        yajl_gen_integer(g, (long long)value.getRegionType());
    }
    if (!isSparse || value.hasDisplayRegionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "displayRegionStatus" , 19);
        yajl_gen_integer(g, (long long)value.getDisplayRegionStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExternalImageData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGadgetState()) {
        yajl_gen_string(g, (const unsigned char*)  "gadgetState" , 11);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus_Name(value.getGadgetState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGadgetState());
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    if (!isSparse || value.hasConsumerId()) {
        yajl_gen_string(g, (const unsigned char*)  "consumerId" , 10);
        yajl_gen_integer(g, (long long)value.getConsumerId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationState"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasAppState()) {
        yajl_gen_string(g, (const unsigned char*)  "appState" , 8);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState_Name(value.getAppState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateClientStatusRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasState_()) {
        yajl_gen_string(g, (const unsigned char*)  "state_" , 6);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState_Name(value.getState_());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getState_());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KeyForwardingRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKeyRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "keyRequest" , 10);
        serializeJson(value.getKeyRequest(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderForwardingRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEncoderRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "encoderRequest" , 14);
        serializeJson(value.getEncoderRequest(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BeepForwardingRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBeepType()) {
        yajl_gen_string(g, (const unsigned char*)  "beepType" , 8);
        yajl_gen_integer(g, (long long)value.getBeepType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetApplicationMandatoryRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        yajl_gen_bool(g, (bool)value.getValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayCmdRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MultiDisplayCmdRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayStatusEvalRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestExternalImageProviderActivationRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTargetState()) {
        yajl_gen_string(g, (const unsigned char*)  "targetState" , 11);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus_Name(value.getTargetState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTargetState());
    }
    if (!isSparse || value.hasInstanceIds()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceIds" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< int32 >& o1 = value.getInstanceIds();
        {
            ::std::vector< int32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasConsumerId()) {
        yajl_gen_string(g, (const unsigned char*)  "consumerId" , 10);
        yajl_gen_integer(g, (long long)value.getConsumerId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestExternalImageProviderTouchRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestSlaveSurfaceRepositioningRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasActivate()) {
        yajl_gen_string(g, (const unsigned char*)  "activate" , 8);
        yajl_gen_bool(g, (bool)value.getActivate());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResponseSlaveSurfaceRepositioningRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasActivate()) {
        yajl_gen_string(g, (const unsigned char*)  "activate" , 8);
        yajl_gen_bool(g, (bool)value.getActivate());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDirectTextureConsumerPositionInfoRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResponseDirectTextureConsumerPositionInfoRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_double(g, (double)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_double(g, (double)value.getYPos());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationRenderedUpdateRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSurfaceid()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceid" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationSwitchCompleteRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSurfaceid()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceid" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceid());
    }
    if (!isSparse || value.hasSurfaceState()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceState" , 12);
        yajl_gen_integer(g, (long long)value.getSurfaceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubSurfaceSwitchCompleteRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSurfaceid()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceid" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceid());
    }
    if (!isSparse || value.hasSurfaceState()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceState" , 12);
        yajl_gen_integer(g, (long long)value.getSurfaceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FollowUpActionRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActionType()) {
        yajl_gen_string(g, (const unsigned char*)  "actionType" , 10);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction_Name(value.getActionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getActionType());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResponseFollowUpActionRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActionType()) {
        yajl_gen_string(g, (const unsigned char*)  "actionType" , 10);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction_Name(value.getActionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getActionType());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DrmBufferAllocationStatusRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasBufferSize()) {
        yajl_gen_string(g, (const unsigned char*)  "bufferSize" , 10);
        yajl_gen_integer(g, (long long)value.getBufferSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExternalImagesStatusUpdate"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasExternalImagesStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ExternalImagesStatus" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData >& o3 = value.getExternalImagesStatus();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExternalImagesStatusRegister"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClientsUpdate"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClients()) {
        yajl_gen_string(g, (const unsigned char*)  "Clients" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState >& o5 = value.getClients();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClientsRegister"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubSurfaceSwitchUpdateSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSurfaceid()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceid" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceid());
    }
    if (!isSparse || value.hasSurfaceState()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceState" , 12);
        yajl_gen_integer(g, (long long)value.getSurfaceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KeyInfoForwardingSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderInfoForwardingSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDisplaySignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMultiDisplaySignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EvDisplayStatusEvalSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActivateExternalImageProviderSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTargetState()) {
        yajl_gen_string(g, (const unsigned char*)  "targetState" , 11);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus_Name(value.getTargetState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTargetState());
    }
    if (!isSparse || value.hasInstanceIds()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceIds" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< int32 >& o7 = value.getInstanceIds();
        {
            ::std::vector< int32 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasConsumerId()) {
        yajl_gen_string(g, (const unsigned char*)  "consumerId" , 10);
        yajl_gen_integer(g, (long long)value.getConsumerId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExternalImageProviderTouchSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SlaveSurfaceRepositioningSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasActivate()) {
        yajl_gen_string(g, (const unsigned char*)  "activate" , 8);
        yajl_gen_bool(g, (bool)value.getActivate());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SlaveSurfaceRepositioningAckSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasActivate()) {
        yajl_gen_string(g, (const unsigned char*)  "activate" , 8);
        yajl_gen_bool(g, (bool)value.getActivate());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DirectTextureConsumerPositionInfoRequestSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DirectTextureConsumerPositionInfoResponseSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPidSender()) {
        yajl_gen_string(g, (const unsigned char*)  "pidSender" , 9);
        yajl_gen_integer(g, (long long)value.getPidSender());
    }
    if (!isSparse || value.hasInstanceId()) {
        yajl_gen_string(g, (const unsigned char*)  "instanceId" , 10);
        yajl_gen_integer(g, (long long)value.getInstanceId());
    }
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_double(g, (double)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_double(g, (double)value.getYPos());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FollowUpActionRequestSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActionType()) {
        yajl_gen_string(g, (const unsigned char*)  "actionType" , 10);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction_Name(value.getActionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getActionType());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FollowUpActionResponseSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActionType()) {
        yajl_gen_string(g, (const unsigned char*)  "actionType" , 10);
        const char* s = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction_Name(value.getActionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getActionType());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

