#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRL_H
#define BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRL_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * service for common hmi application control functionality
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

// method IDs
static const uint16 ID_UpdateClientStatus = 0;
static const uint16 ID_KeyForwarding = 1;
static const uint16 ID_EncoderForwarding = 2;
static const uint16 ID_BeepForwarding = 3;
static const uint16 ID_SetApplicationMandatory = 4;
static const uint16 ID_DisplayCmd = 5;
static const uint16 ID_MultiDisplayCmd = 6;
static const uint16 ID_DisplayStatusEval = 7;
static const uint16 ID_RequestExternalImageProviderActivation = 8;
static const uint16 ID_RequestExternalImageProviderTouch = 9;
static const uint16 ID_RequestSlaveSurfaceRepositioning = 10;
static const uint16 ID_ResponseSlaveSurfaceRepositioning = 11;
static const uint16 ID_RequestDirectTextureConsumerPositionInfo = 12;
static const uint16 ID_ResponseDirectTextureConsumerPositionInfo = 13;
static const uint16 ID_ApplicationRenderedUpdate = 14;
static const uint16 ID_ApplicationSwitchComplete = 15;
static const uint16 ID_SubSurfaceSwitchComplete = 16;
static const uint16 ID_FollowUpAction = 17;
static const uint16 ID_ResponseFollowUpAction = 18;
static const uint16 ID_DrmBufferAllocationStatus = 19;

// signal IDs
static const uint16 ID_QueryClient = 20;
static const uint16 ID_subSurfaceSwitchUpdate = 21;
static const uint16 ID_keyInfoForwarding = 22;
static const uint16 ID_encoderInfoForwarding = 23;
static const uint16 ID_SetDisplay = 24;
static const uint16 ID_SetMultiDisplay = 25;
static const uint16 ID_evDisplayStatusEval = 26;
static const uint16 ID_ActivateExternalImageProvider = 27;
static const uint16 ID_ExternalImageProviderTouch = 28;
static const uint16 ID_SlaveSurfaceRepositioning = 29;
static const uint16 ID_SlaveSurfaceRepositioningAck = 30;
static const uint16 ID_DirectTextureConsumerPositionInfoRequest = 31;
static const uint16 ID_DirectTextureConsumerPositionInfoResponse = 32;
static const uint16 ID_DrmGarbageCollectionRequest = 33;
static const uint16 ID_FollowUpActionRequest = 34;
static const uint16 ID_FollowUpActionResponse = 35;

// property IDs
static const uint16 ID_ExternalImagesStatus = 36;
static const uint16 ID_Clients = 37;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class keyInfo;

class touchInfo;

class encoderInfo;

class displayData;

class MultidisplayData;

class ExternalImageData;

class ApplicationState;

class UpdateClientStatusRequest;

class KeyForwardingRequest;

class EncoderForwardingRequest;

class BeepForwardingRequest;

class SetApplicationMandatoryRequest;

class DisplayCmdRequest;

class MultiDisplayCmdRequest;

class DisplayStatusEvalRequest;

class RequestExternalImageProviderActivationRequest;

class RequestExternalImageProviderTouchRequest;

class RequestSlaveSurfaceRepositioningRequest;

class ResponseSlaveSurfaceRepositioningRequest;

class RequestDirectTextureConsumerPositionInfoRequest;

class ResponseDirectTextureConsumerPositionInfoRequest;

class ApplicationRenderedUpdateRequest;

class ApplicationSwitchCompleteRequest;

class SubSurfaceSwitchCompleteRequest;

class FollowUpActionRequest;

class ResponseFollowUpActionRequest;

class DrmBufferAllocationStatusRequest;

class ExternalImagesStatusUpdate;

class ExternalImagesStatusRegister;

class ClientsUpdate;

class ClientsRegister;

class SubSurfaceSwitchUpdateSignal;

class KeyInfoForwardingSignal;

class EncoderInfoForwardingSignal;

class SetDisplaySignal;

class SetMultiDisplaySignal;

class EvDisplayStatusEvalSignal;

class ActivateExternalImageProviderSignal;

class ExternalImageProviderTouchSignal;

class SlaveSurfaceRepositioningSignal;

class SlaveSurfaceRepositioningAckSignal;

class DirectTextureConsumerPositionInfoRequestSignal;

class DirectTextureConsumerPositionInfoResponseSignal;

class FollowUpActionRequestSignal;

class FollowUpActionResponseSignal;

// type definitions
/**
 * transport information about the hmi process to stub
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateClientStatusResponse;

/**
 * If the meaning of "UpdateClientStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateClientStatusError;

/**
 * forward a received (and not consumed) key event to stub
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage KeyForwardingResponse;

/**
 * If the meaning of "KeyForwardingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyForwardingError;

/**
 * forward a received (and not consumed) encoder event to stub
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EncoderForwardingResponse;

/**
 * If the meaning of "EncoderForwardingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EncoderForwardingError;

/**
 * forward a beep request to stub
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BeepForwardingResponse;

/**
 * If the meaning of "BeepForwardingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BeepForwardingError;

/**
 * set the calling application as mandatory for synchronized hmi startup
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetApplicationMandatoryResponse;

/**
 * If the meaning of "SetApplicationMandatoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetApplicationMandatoryError;

/**
 * todo
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisplayCmdResponse;

/**
 * If the meaning of "DisplayCmdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayCmdError;

/**
 * If the meaning of "MultiDisplayCmd" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage MultiDisplayCmdResponse;

/**
 * If the meaning of "MultiDisplayCmdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MultiDisplayCmdError;

/**
 * todo
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisplayStatusEvalResponse;

/**
 * If the meaning of "DisplayStatusEvalError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayStatusEvalError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestExternalImageProviderActivationResponse;

/**
 * If the meaning of "RequestExternalImageProviderActivationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestExternalImageProviderActivationError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestExternalImageProviderTouchResponse;

/**
 * If the meaning of "RequestExternalImageProviderTouchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestExternalImageProviderTouchError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestSlaveSurfaceRepositioningResponse;

/**
 * If the meaning of "RequestSlaveSurfaceRepositioningError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestSlaveSurfaceRepositioningError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResponseSlaveSurfaceRepositioningResponse;

/**
 * If the meaning of "ResponseSlaveSurfaceRepositioningError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResponseSlaveSurfaceRepositioningError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestDirectTextureConsumerPositionInfoResponse;

/**
 * If the meaning of "RequestDirectTextureConsumerPositionInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestDirectTextureConsumerPositionInfoError;

/**
 * request stub to distribute
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResponseDirectTextureConsumerPositionInfoResponse;

/**
 * If the meaning of "ResponseDirectTextureConsumerPositionInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResponseDirectTextureConsumerPositionInfoError;

typedef ::asf::dbus::DBusTypes::DefaultMessage ApplicationRenderedUpdateResponse;

/**
 * If the meaning of "ApplicationRenderedUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ApplicationRenderedUpdateError;

typedef ::asf::dbus::DBusTypes::DefaultMessage ApplicationSwitchCompleteResponse;

/**
 * If the meaning of "ApplicationSwitchCompleteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ApplicationSwitchCompleteError;

typedef ::asf::dbus::DBusTypes::DefaultMessage SubSurfaceSwitchCompleteResponse;

/**
 * If the meaning of "SubSurfaceSwitchCompleteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubSurfaceSwitchCompleteError;

typedef ::asf::dbus::DBusTypes::DefaultMessage FollowUpActionResponse;

/**
 * If the meaning of "FollowUpActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FollowUpActionError;

typedef ::asf::dbus::DBusTypes::DefaultMessage ResponseFollowUpActionResponse;

/**
 * If the meaning of "ResponseFollowUpActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResponseFollowUpActionError;

/**
 * Report the status of dma buffer allocation
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DrmBufferAllocationStatusResponse;

/**
 * If the meaning of "DrmBufferAllocationStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DrmBufferAllocationStatusError;

/**
 * Property to state the known/already requested external images.
 */
typedef ExternalImagesStatusUpdate ExternalImagesStatusSet;

/**
 * Property to state the known/already requested external images.
 */
typedef ExternalImagesStatusUpdate ExternalImagesStatusGet;

/**
 * If the meaning of "ExternalImagesStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ExternalImagesStatusError;

/**
 * Property to state the application status of registered clients.
 */
typedef ClientsUpdate ClientsSet;

/**
 * Property to state the application status of registered clients.
 */
typedef ClientsUpdate ClientsGet;

/**
 * If the meaning of "ClientsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClientsError;

/**
 * send out query to get info about all registered clients
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage QueryClientSignal;

/**
 * If the meaning of "QueryClientError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError QueryClientError;

/**
 * If the meaning of "SubSurfaceSwitchUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubSurfaceSwitchUpdateError;

/**
 * If the meaning of "KeyInfoForwardingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyInfoForwardingError;

/**
 * If the meaning of "EncoderInfoForwardingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EncoderInfoForwardingError;

/**
 * If the meaning of "SetDisplayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetDisplayError;

/**
 * If the meaning of "SetMultiDisplayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMultiDisplayError;

/**
 * If the meaning of "EvDisplayStatusEvalError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EvDisplayStatusEvalError;

/**
 * If the meaning of "ActivateExternalImageProviderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateExternalImageProviderError;

/**
 * If the meaning of "ExternalImageProviderTouchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ExternalImageProviderTouchError;

/**
 * If the meaning of "SlaveSurfaceRepositioningError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SlaveSurfaceRepositioningError;

/**
 * If the meaning of "SlaveSurfaceRepositioningAckError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SlaveSurfaceRepositioningAckError;

/**
 * If the meaning of "DirectTextureConsumerPositionInfoRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DirectTextureConsumerPositionInfoRequestError;

/**
 * If the meaning of "DirectTextureConsumerPositionInfoResponseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DirectTextureConsumerPositionInfoResponseError;

/**
 * Request all clients to clean up their dma buffer allocations
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DrmGarbageCollectionRequestSignal;

/**
 * If the meaning of "DrmGarbageCollectionRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DrmGarbageCollectionRequestError;

/**
 * If the meaning of "FollowUpActionRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FollowUpActionRequestError;

/**
 * If the meaning of "FollowUpActionResponseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FollowUpActionResponseError;


/**
 * todo
 */
class keyInfo {
public:

    /**
     * Default constructor
     */
    inline  keyInfo ();

    /**
     * Copy constructor
     */
    inline  keyInfo (const keyInfo &rhs);

    /**
     * All fields constructor
     */
    inline  keyInfo (uint32 keyCode_, uint8 keyState_, uint32 pidSender_, uint32 pidReceiver_, uint32 displayId_, uint32 userData_);

    /**
     * Destructor
     */
    inline  ~keyInfo();

    /**
     * Assignment operator
     */
    inline keyInfo& operator = (const keyInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const keyInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const keyInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const keyInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const keyInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyCode"

    static const int kKeyCode = 0;

    /**
     * Clears the field "keyCode".
     *
     * The field will be set to its default value. The hasKeyCode()
     * method will return false.
     */
    inline void clearKeyCode();

    /**
     * Checks whether the field "keyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCode()). Otherwise it will return false.
     */
    inline bool hasKeyCode () const;

    /**
     * Returns the value of the member "keyCode".
     *
     * If the meaning of "keyCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyCode"
     */
    inline uint32 getKeyCode () const;

    /**
     * Sets the value of the member "keyCode".
     *
     * If the meaning of "keyCode" isn't clear, then there should be a description here.
     *
     * @param keyCode The value which will be set
     */
    inline void setKeyCode (uint32 keyCode_);

    // API of field "keyState"

    static const int kKeyState = 1;

    /**
     * Clears the field "keyState".
     *
     * The field will be set to its default value. The hasKeyState()
     * method will return false.
     */
    inline void clearKeyState();

    /**
     * Checks whether the field "keyState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyState()). Otherwise it will return false.
     */
    inline bool hasKeyState () const;

    /**
     * Returns the value of the member "keyState".
     *
     * If the meaning of "keyState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyState"
     */
    inline uint8 getKeyState () const;

    /**
     * Sets the value of the member "keyState".
     *
     * If the meaning of "keyState" isn't clear, then there should be a description here.
     *
     * @param keyState The value which will be set
     */
    inline void setKeyState (uint8 keyState_);

    // API of field "pidSender"

    static const int kPidSender = 2;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "pidReceiver"

    static const int kPidReceiver = 3;

    /**
     * Clears the field "pidReceiver".
     *
     * The field will be set to its default value. The hasPidReceiver()
     * method will return false.
     */
    inline void clearPidReceiver();

    /**
     * Checks whether the field "pidReceiver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidReceiver()). Otherwise it will return false.
     */
    inline bool hasPidReceiver () const;

    /**
     * Returns the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidReceiver"
     */
    inline uint32 getPidReceiver () const;

    /**
     * Sets the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @param pidReceiver The value which will be set
     */
    inline void setPidReceiver (uint32 pidReceiver_);

    // API of field "displayId"

    static const int kDisplayId = 4;

    /**
     * Clears the field "displayId".
     *
     * The field will be set to its default value. The hasDisplayId()
     * method will return false.
     */
    inline void clearDisplayId();

    /**
     * Checks whether the field "displayId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayId()). Otherwise it will return false.
     */
    inline bool hasDisplayId () const;

    /**
     * Returns the value of the member "displayId".
     *
     * If the meaning of "displayId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayId"
     */
    inline uint32 getDisplayId () const;

    /**
     * Sets the value of the member "displayId".
     *
     * If the meaning of "displayId" isn't clear, then there should be a description here.
     *
     * @param displayId The value which will be set
     */
    inline void setDisplayId (uint32 displayId_);

    // API of field "userData"

    static const int kUserData = 5;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const keyInfo &getDefaultInstance();

private:

    inline void set_has_keyCode ();

    inline void clear_has_keyCode ();

    inline void set_has_keyState ();

    inline void clear_has_keyState ();

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_pidReceiver ();

    inline void clear_has_pidReceiver ();

    inline void set_has_displayId ();

    inline void clear_has_displayId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _keyCode;

    uint8 _keyState;

    uint32 _pidSender;

    uint32 _pidReceiver;

    uint32 _displayId;

    uint32 _userData;

};

/**
 * todo
 */
class touchInfo {
public:

    /**
     * Default constructor
     */
    inline  touchInfo ();

    /**
     * Copy constructor
     */
    inline  touchInfo (const touchInfo &rhs);

    /**
     * All fields constructor
     */
    inline  touchInfo (uint8 touchState_, int32 xPos_, int32 yPos_, uint32 timeStamp_);

    /**
     * Destructor
     */
    inline  ~touchInfo();

    /**
     * Assignment operator
     */
    inline touchInfo& operator = (const touchInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const touchInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const touchInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const touchInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const touchInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "touchState"

    static const int kTouchState = 0;

    /**
     * Clears the field "touchState".
     *
     * The field will be set to its default value. The hasTouchState()
     * method will return false.
     */
    inline void clearTouchState();

    /**
     * Checks whether the field "touchState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchState()). Otherwise it will return false.
     */
    inline bool hasTouchState () const;

    /**
     * Returns the value of the member "touchState".
     *
     * If the meaning of "touchState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "touchState"
     */
    inline uint8 getTouchState () const;

    /**
     * Sets the value of the member "touchState".
     *
     * If the meaning of "touchState" isn't clear, then there should be a description here.
     *
     * @param touchState The value which will be set
     */
    inline void setTouchState (uint8 touchState_);

    // API of field "xPos"

    static const int kXPos = 1;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline int32 getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (int32 xPos_);

    // API of field "yPos"

    static const int kYPos = 2;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline int32 getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (int32 yPos_);

    // API of field "timeStamp"

    static const int kTimeStamp = 3;

    /**
     * Clears the field "timeStamp".
     *
     * The field will be set to its default value. The hasTimeStamp()
     * method will return false.
     */
    inline void clearTimeStamp();

    /**
     * Checks whether the field "timeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeStamp()). Otherwise it will return false.
     */
    inline bool hasTimeStamp () const;

    /**
     * Returns the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeStamp"
     */
    inline uint32 getTimeStamp () const;

    /**
     * Sets the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @param timeStamp The value which will be set
     */
    inline void setTimeStamp (uint32 timeStamp_);

    static const touchInfo &getDefaultInstance();

private:

    inline void set_has_touchState ();

    inline void clear_has_touchState ();

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    inline void set_has_timeStamp ();

    inline void clear_has_timeStamp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _touchState;

    int32 _xPos;

    int32 _yPos;

    uint32 _timeStamp;

};

/**
 * encoder information
 */
class encoderInfo {
public:

    /**
     * Default constructor
     */
    inline  encoderInfo ();

    /**
     * Copy constructor
     */
    inline  encoderInfo (const encoderInfo &rhs);

    /**
     * All fields constructor
     */
    inline  encoderInfo (int32 encCode_, int32 encValue_, uint32 pidSender_, uint32 pidReceiver_, uint32 surfaceId_, uint32 userData_);

    /**
     * Destructor
     */
    inline  ~encoderInfo();

    /**
     * Assignment operator
     */
    inline encoderInfo& operator = (const encoderInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const encoderInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const encoderInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const encoderInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const encoderInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "encCode"

    static const int kEncCode = 0;

    /**
     * Clears the field "encCode".
     *
     * The field will be set to its default value. The hasEncCode()
     * method will return false.
     */
    inline void clearEncCode();

    /**
     * Checks whether the field "encCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncCode()). Otherwise it will return false.
     */
    inline bool hasEncCode () const;

    /**
     * Returns the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encCode"
     */
    inline int32 getEncCode () const;

    /**
     * Sets the value of the member "encCode".
     *
     * If the meaning of "encCode" isn't clear, then there should be a description here.
     *
     * @param encCode The value which will be set
     */
    inline void setEncCode (int32 encCode_);

    // API of field "encValue"

    static const int kEncValue = 1;

    /**
     * Clears the field "encValue".
     *
     * The field will be set to its default value. The hasEncValue()
     * method will return false.
     */
    inline void clearEncValue();

    /**
     * Checks whether the field "encValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncValue()). Otherwise it will return false.
     */
    inline bool hasEncValue () const;

    /**
     * Returns the value of the member "encValue".
     *
     * If the meaning of "encValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encValue"
     */
    inline int32 getEncValue () const;

    /**
     * Sets the value of the member "encValue".
     *
     * If the meaning of "encValue" isn't clear, then there should be a description here.
     *
     * @param encValue The value which will be set
     */
    inline void setEncValue (int32 encValue_);

    // API of field "pidSender"

    static const int kPidSender = 2;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "pidReceiver"

    static const int kPidReceiver = 3;

    /**
     * Clears the field "pidReceiver".
     *
     * The field will be set to its default value. The hasPidReceiver()
     * method will return false.
     */
    inline void clearPidReceiver();

    /**
     * Checks whether the field "pidReceiver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidReceiver()). Otherwise it will return false.
     */
    inline bool hasPidReceiver () const;

    /**
     * Returns the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidReceiver"
     */
    inline uint32 getPidReceiver () const;

    /**
     * Sets the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @param pidReceiver The value which will be set
     */
    inline void setPidReceiver (uint32 pidReceiver_);

    // API of field "surfaceId"

    static const int kSurfaceId = 4;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "userData"

    static const int kUserData = 5;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const encoderInfo &getDefaultInstance();

private:

    inline void set_has_encCode ();

    inline void clear_has_encCode ();

    inline void set_has_encValue ();

    inline void clear_has_encValue ();

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_pidReceiver ();

    inline void clear_has_pidReceiver ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (6 + 31) / 32];

    int32 _encCode;

    int32 _encValue;

    uint32 _pidSender;

    uint32 _pidReceiver;

    uint32 _surfaceId;

    uint32 _userData;

};

/**
 * todo
 */
class displayData {
public:

    /**
     * Default constructor
     */
    inline  displayData ();

    /**
     * Copy constructor
     */
    inline  displayData (const displayData &rhs);

    /**
     * All fields constructor
     */
    inline  displayData (int32 pidReceiver_, const ::std::string& senderName_, const ::std::string& receiverName_, int32 displayRegion_, int32 regionType_, int8 displayRegionStatus_);

    /**
     * Destructor
     */
    inline  ~displayData();

    /**
     * Assignment operator
     */
    inline displayData& operator = (const displayData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const displayData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const displayData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const displayData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const displayData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidReceiver"

    static const int kPidReceiver = 0;

    /**
     * Clears the field "pidReceiver".
     *
     * The field will be set to its default value. The hasPidReceiver()
     * method will return false.
     */
    inline void clearPidReceiver();

    /**
     * Checks whether the field "pidReceiver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidReceiver()). Otherwise it will return false.
     */
    inline bool hasPidReceiver () const;

    /**
     * Returns the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidReceiver"
     */
    inline int32 getPidReceiver () const;

    /**
     * Sets the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @param pidReceiver The value which will be set
     */
    inline void setPidReceiver (int32 pidReceiver_);

    // API of field "senderName"

    static const int kSenderName = 1;

    /**
     * Clears the field "senderName".
     *
     * The field will be set to its default value. The hasSenderName()
     * method will return false.
     */
    inline void clearSenderName();

    /**
     * Checks whether the field "senderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSenderName()). Otherwise it will return false.
     */
    inline bool hasSenderName () const;

    /**
     * Returns the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "senderName"
     */
    inline const ::std::string& getSenderName () const;

    /**
     * Retrieves the value of the field "senderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "senderName".
     */
    inline ::std::string& getSenderNameMutable ();

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const ::std::string& senderName_);

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const char* senderName_);

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const char* value, size_t size);

    // API of field "receiverName"

    static const int kReceiverName = 2;

    /**
     * Clears the field "receiverName".
     *
     * The field will be set to its default value. The hasReceiverName()
     * method will return false.
     */
    inline void clearReceiverName();

    /**
     * Checks whether the field "receiverName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceiverName()). Otherwise it will return false.
     */
    inline bool hasReceiverName () const;

    /**
     * Returns the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "receiverName"
     */
    inline const ::std::string& getReceiverName () const;

    /**
     * Retrieves the value of the field "receiverName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "receiverName".
     */
    inline ::std::string& getReceiverNameMutable ();

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const ::std::string& receiverName_);

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const char* receiverName_);

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const char* value, size_t size);

    // API of field "displayRegion"

    static const int kDisplayRegion = 3;

    /**
     * Clears the field "displayRegion".
     *
     * The field will be set to its default value. The hasDisplayRegion()
     * method will return false.
     */
    inline void clearDisplayRegion();

    /**
     * Checks whether the field "displayRegion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayRegion()). Otherwise it will return false.
     */
    inline bool hasDisplayRegion () const;

    /**
     * Returns the value of the member "displayRegion".
     *
     * If the meaning of "displayRegion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayRegion"
     */
    inline int32 getDisplayRegion () const;

    /**
     * Sets the value of the member "displayRegion".
     *
     * If the meaning of "displayRegion" isn't clear, then there should be a description here.
     *
     * @param displayRegion The value which will be set
     */
    inline void setDisplayRegion (int32 displayRegion_);

    // API of field "regionType"

    static const int kRegionType = 4;

    /**
     * Clears the field "regionType".
     *
     * The field will be set to its default value. The hasRegionType()
     * method will return false.
     */
    inline void clearRegionType();

    /**
     * Checks whether the field "regionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionType()). Otherwise it will return false.
     */
    inline bool hasRegionType () const;

    /**
     * Returns the value of the member "regionType".
     *
     * If the meaning of "regionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionType"
     */
    inline int32 getRegionType () const;

    /**
     * Sets the value of the member "regionType".
     *
     * If the meaning of "regionType" isn't clear, then there should be a description here.
     *
     * @param regionType The value which will be set
     */
    inline void setRegionType (int32 regionType_);

    // API of field "displayRegionStatus"

    static const int kDisplayRegionStatus = 5;

    /**
     * Clears the field "displayRegionStatus".
     *
     * The field will be set to its default value. The hasDisplayRegionStatus()
     * method will return false.
     */
    inline void clearDisplayRegionStatus();

    /**
     * Checks whether the field "displayRegionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayRegionStatus()). Otherwise it will return false.
     */
    inline bool hasDisplayRegionStatus () const;

    /**
     * Returns the value of the member "displayRegionStatus".
     *
     * If the meaning of "displayRegionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayRegionStatus"
     */
    inline int8 getDisplayRegionStatus () const;

    /**
     * Sets the value of the member "displayRegionStatus".
     *
     * If the meaning of "displayRegionStatus" isn't clear, then there should be a description here.
     *
     * @param displayRegionStatus The value which will be set
     */
    inline void setDisplayRegionStatus (int8 displayRegionStatus_);

    static const displayData &getDefaultInstance();

private:

    inline void set_has_pidReceiver ();

    inline void clear_has_pidReceiver ();

    inline void set_has_senderName ();

    inline void clear_has_senderName ();

    inline void set_has_receiverName ();

    inline void clear_has_receiverName ();

    inline void set_has_displayRegion ();

    inline void clear_has_displayRegion ();

    inline void set_has_regionType ();

    inline void clear_has_regionType ();

    inline void set_has_displayRegionStatus ();

    inline void clear_has_displayRegionStatus ();

    uint32 _has_bits_[ (6 + 31) / 32];

    int32 _pidReceiver;

    ::std::string _senderName;

    ::std::string _receiverName;

    int32 _displayRegion;

    int32 _regionType;

    int8 _displayRegionStatus;

};

/**
 * todo
 */
class MultidisplayData {
public:

    /**
     * Default constructor
     */
    inline  MultidisplayData ();

    /**
     * Copy constructor
     */
    inline  MultidisplayData (const MultidisplayData &rhs);

    /**
     * All fields constructor
     */
    inline  MultidisplayData (int32 pidReceiver_, uint32 displayid_, const ::std::string& senderName_, const ::std::string& receiverName_, int32 displayRegion_, int32 regionType_, int8 displayRegionStatus_);

    /**
     * Destructor
     */
    inline  ~MultidisplayData();

    /**
     * Assignment operator
     */
    inline MultidisplayData& operator = (const MultidisplayData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MultidisplayData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MultidisplayData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MultidisplayData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MultidisplayData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidReceiver"

    static const int kPidReceiver = 0;

    /**
     * Clears the field "pidReceiver".
     *
     * The field will be set to its default value. The hasPidReceiver()
     * method will return false.
     */
    inline void clearPidReceiver();

    /**
     * Checks whether the field "pidReceiver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidReceiver()). Otherwise it will return false.
     */
    inline bool hasPidReceiver () const;

    /**
     * Returns the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidReceiver"
     */
    inline int32 getPidReceiver () const;

    /**
     * Sets the value of the member "pidReceiver".
     *
     * If the meaning of "pidReceiver" isn't clear, then there should be a description here.
     *
     * @param pidReceiver The value which will be set
     */
    inline void setPidReceiver (int32 pidReceiver_);

    // API of field "displayid"

    static const int kDisplayid = 1;

    /**
     * Clears the field "displayid".
     *
     * The field will be set to its default value. The hasDisplayid()
     * method will return false.
     */
    inline void clearDisplayid();

    /**
     * Checks whether the field "displayid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayid()). Otherwise it will return false.
     */
    inline bool hasDisplayid () const;

    /**
     * Returns the value of the member "displayid".
     *
     * If the meaning of "displayid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayid"
     */
    inline uint32 getDisplayid () const;

    /**
     * Sets the value of the member "displayid".
     *
     * If the meaning of "displayid" isn't clear, then there should be a description here.
     *
     * @param displayid The value which will be set
     */
    inline void setDisplayid (uint32 displayid_);

    // API of field "senderName"

    static const int kSenderName = 2;

    /**
     * Clears the field "senderName".
     *
     * The field will be set to its default value. The hasSenderName()
     * method will return false.
     */
    inline void clearSenderName();

    /**
     * Checks whether the field "senderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSenderName()). Otherwise it will return false.
     */
    inline bool hasSenderName () const;

    /**
     * Returns the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "senderName"
     */
    inline const ::std::string& getSenderName () const;

    /**
     * Retrieves the value of the field "senderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "senderName".
     */
    inline ::std::string& getSenderNameMutable ();

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const ::std::string& senderName_);

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const char* senderName_);

    /**
     * Sets the value of the member "senderName".
     *
     * If the meaning of "senderName" isn't clear, then there should be a description here.
     *
     * @param senderName The value which will be set
     */
    inline void setSenderName (const char* value, size_t size);

    // API of field "receiverName"

    static const int kReceiverName = 3;

    /**
     * Clears the field "receiverName".
     *
     * The field will be set to its default value. The hasReceiverName()
     * method will return false.
     */
    inline void clearReceiverName();

    /**
     * Checks whether the field "receiverName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceiverName()). Otherwise it will return false.
     */
    inline bool hasReceiverName () const;

    /**
     * Returns the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "receiverName"
     */
    inline const ::std::string& getReceiverName () const;

    /**
     * Retrieves the value of the field "receiverName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "receiverName".
     */
    inline ::std::string& getReceiverNameMutable ();

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const ::std::string& receiverName_);

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const char* receiverName_);

    /**
     * Sets the value of the member "receiverName".
     *
     * If the meaning of "receiverName" isn't clear, then there should be a description here.
     *
     * @param receiverName The value which will be set
     */
    inline void setReceiverName (const char* value, size_t size);

    // API of field "displayRegion"

    static const int kDisplayRegion = 4;

    /**
     * Clears the field "displayRegion".
     *
     * The field will be set to its default value. The hasDisplayRegion()
     * method will return false.
     */
    inline void clearDisplayRegion();

    /**
     * Checks whether the field "displayRegion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayRegion()). Otherwise it will return false.
     */
    inline bool hasDisplayRegion () const;

    /**
     * Returns the value of the member "displayRegion".
     *
     * If the meaning of "displayRegion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayRegion"
     */
    inline int32 getDisplayRegion () const;

    /**
     * Sets the value of the member "displayRegion".
     *
     * If the meaning of "displayRegion" isn't clear, then there should be a description here.
     *
     * @param displayRegion The value which will be set
     */
    inline void setDisplayRegion (int32 displayRegion_);

    // API of field "regionType"

    static const int kRegionType = 5;

    /**
     * Clears the field "regionType".
     *
     * The field will be set to its default value. The hasRegionType()
     * method will return false.
     */
    inline void clearRegionType();

    /**
     * Checks whether the field "regionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionType()). Otherwise it will return false.
     */
    inline bool hasRegionType () const;

    /**
     * Returns the value of the member "regionType".
     *
     * If the meaning of "regionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionType"
     */
    inline int32 getRegionType () const;

    /**
     * Sets the value of the member "regionType".
     *
     * If the meaning of "regionType" isn't clear, then there should be a description here.
     *
     * @param regionType The value which will be set
     */
    inline void setRegionType (int32 regionType_);

    // API of field "displayRegionStatus"

    static const int kDisplayRegionStatus = 6;

    /**
     * Clears the field "displayRegionStatus".
     *
     * The field will be set to its default value. The hasDisplayRegionStatus()
     * method will return false.
     */
    inline void clearDisplayRegionStatus();

    /**
     * Checks whether the field "displayRegionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayRegionStatus()). Otherwise it will return false.
     */
    inline bool hasDisplayRegionStatus () const;

    /**
     * Returns the value of the member "displayRegionStatus".
     *
     * If the meaning of "displayRegionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayRegionStatus"
     */
    inline int8 getDisplayRegionStatus () const;

    /**
     * Sets the value of the member "displayRegionStatus".
     *
     * If the meaning of "displayRegionStatus" isn't clear, then there should be a description here.
     *
     * @param displayRegionStatus The value which will be set
     */
    inline void setDisplayRegionStatus (int8 displayRegionStatus_);

    static const MultidisplayData &getDefaultInstance();

private:

    inline void set_has_pidReceiver ();

    inline void clear_has_pidReceiver ();

    inline void set_has_displayid ();

    inline void clear_has_displayid ();

    inline void set_has_senderName ();

    inline void clear_has_senderName ();

    inline void set_has_receiverName ();

    inline void clear_has_receiverName ();

    inline void set_has_displayRegion ();

    inline void clear_has_displayRegion ();

    inline void set_has_regionType ();

    inline void clear_has_regionType ();

    inline void set_has_displayRegionStatus ();

    inline void clear_has_displayRegionStatus ();

    uint32 _has_bits_[ (7 + 31) / 32];

    int32 _pidReceiver;

    uint32 _displayid;

    ::std::string _senderName;

    ::std::string _receiverName;

    int32 _displayRegion;

    int32 _regionType;

    int8 _displayRegionStatus;

};

/**
 * If the meaning of "ExternalImageData" isn't clear, then there should be a description here.
 */
class ExternalImageData {
public:

    /**
     * Default constructor
     */
    inline  ExternalImageData ();

    /**
     * Copy constructor
     */
    inline  ExternalImageData (const ExternalImageData &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalImageData (gadgetStatus gadgetState_, int32 instanceId_, uint32 consumerId_);

    /**
     * Destructor
     */
    inline  ~ExternalImageData();

    /**
     * Assignment operator
     */
    inline ExternalImageData& operator = (const ExternalImageData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalImageData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalImageData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalImageData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalImageData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "gadgetState"

    static const int kGadgetState = 0;

    /**
     * Clears the field "gadgetState".
     *
     * The field will be set to its default value. The hasGadgetState()
     * method will return false.
     */
    inline void clearGadgetState();

    /**
     * Checks whether the field "gadgetState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGadgetState()). Otherwise it will return false.
     */
    inline bool hasGadgetState () const;

    /**
     * Returns the value of the member "gadgetState".
     *
     * If the meaning of "gadgetState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "gadgetState"
     */
    inline gadgetStatus getGadgetState () const;

    /**
     * Sets the value of the member "gadgetState".
     *
     * If the meaning of "gadgetState" isn't clear, then there should be a description here.
     *
     * @param gadgetState The value which will be set
     */
    inline void setGadgetState (gadgetStatus gadgetState_);

    // API of field "instanceId"

    static const int kInstanceId = 1;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline int32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (int32 instanceId_);

    // API of field "consumerId"

    static const int kConsumerId = 2;

    /**
     * Clears the field "consumerId".
     *
     * The field will be set to its default value. The hasConsumerId()
     * method will return false.
     */
    inline void clearConsumerId();

    /**
     * Checks whether the field "consumerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumerId()). Otherwise it will return false.
     */
    inline bool hasConsumerId () const;

    /**
     * Returns the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "consumerId"
     */
    inline uint32 getConsumerId () const;

    /**
     * Sets the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @param consumerId The value which will be set
     */
    inline void setConsumerId (uint32 consumerId_);

    static const ExternalImageData &getDefaultInstance();

private:

    inline void set_has_gadgetState ();

    inline void clear_has_gadgetState ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    inline void set_has_consumerId ();

    inline void clear_has_consumerId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    gadgetStatus _gadgetState;

    int32 _instanceId;

    uint32 _consumerId;

};

/**
 * If the meaning of "ApplicationState" isn't clear, then there should be a description here.
 */
class ApplicationState {
public:

    /**
     * Default constructor
     */
    inline  ApplicationState ();

    /**
     * Copy constructor
     */
    inline  ApplicationState (const ApplicationState &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationState (int32 pid_, EnumAppState appState_);

    /**
     * Destructor
     */
    inline  ~ApplicationState();

    /**
     * Assignment operator
     */
    inline ApplicationState& operator = (const ApplicationState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "appState"

    static const int kAppState = 1;

    /**
     * Clears the field "appState".
     *
     * The field will be set to its default value. The hasAppState()
     * method will return false.
     */
    inline void clearAppState();

    /**
     * Checks whether the field "appState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppState()). Otherwise it will return false.
     */
    inline bool hasAppState () const;

    /**
     * Returns the value of the member "appState".
     *
     * If the meaning of "appState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appState"
     */
    inline EnumAppState getAppState () const;

    /**
     * Sets the value of the member "appState".
     *
     * If the meaning of "appState" isn't clear, then there should be a description here.
     *
     * @param appState The value which will be set
     */
    inline void setAppState (EnumAppState appState_);

    static const ApplicationState &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_appState ();

    inline void clear_has_appState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _pid;

    EnumAppState _appState;

};

/**
 * transport information about the hmi process to stub
 */
class UpdateClientStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateClientStatusRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateClientStatusRequest (const UpdateClientStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateClientStatusRequest (uint32 pid_, const ::std::string& name_, hmiAppState state__);

    /**
     * Destructor
     */
    inline virtual  ~UpdateClientStatusRequest();

    /**
     * Assignment operator
     */
    inline UpdateClientStatusRequest& operator = (const UpdateClientStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateClientStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateClientStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateClientStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateClientStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline uint32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (uint32 pid_);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "state_"

    static const int kState_ = 2;

    /**
     * Clears the field "state_".
     *
     * The field will be set to its default value. The hasState_()
     * method will return false.
     */
    inline void clearState_();

    /**
     * Checks whether the field "state_" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState_()). Otherwise it will return false.
     */
    inline bool hasState_ () const;

    /**
     * Returns the value of the member "state_".
     *
     * If the meaning of "state_" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state_"
     */
    inline hmiAppState getState_ () const;

    /**
     * Sets the value of the member "state_".
     *
     * If the meaning of "state_" isn't clear, then there should be a description here.
     *
     * @param state_ The value which will be set
     */
    inline void setState_ (hmiAppState state__);

    static const UpdateClientStatusRequest &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_state_ ();

    inline void clear_has_state_ ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pid;

    ::std::string _name;

    hmiAppState _state_;

};

/**
 * forward a received (and not consumed) key event to stub
 */
class KeyForwardingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyForwardingRequest ();

    /**
     * Copy constructor
     */
    inline  KeyForwardingRequest (const KeyForwardingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  KeyForwardingRequest (const keyInfo& keyRequest_);

    /**
     * Destructor
     */
    inline virtual  ~KeyForwardingRequest();

    /**
     * Assignment operator
     */
    inline KeyForwardingRequest& operator = (const KeyForwardingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyForwardingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyForwardingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyForwardingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyForwardingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyRequest"

    static const int kKeyRequest = 0;

    /**
     * Clears the field "keyRequest".
     *
     * The field will be set to its default value. The hasKeyRequest()
     * method will return false.
     */
    inline void clearKeyRequest();

    /**
     * Checks whether the field "keyRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyRequest()). Otherwise it will return false.
     */
    inline bool hasKeyRequest () const;

    /**
     * Returns the value of the member "keyRequest".
     *
     * If the meaning of "keyRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyRequest"
     */
    inline const keyInfo& getKeyRequest () const;

    /**
     * Retrieves the value of the field "keyRequest" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "keyRequest".
     */
    inline keyInfo& getKeyRequestMutable ();

    /**
     * Sets the value of the member "keyRequest".
     *
     * If the meaning of "keyRequest" isn't clear, then there should be a description here.
     *
     * @param keyRequest The value which will be set
     */
    inline void setKeyRequest (const keyInfo& keyRequest_);

    static const KeyForwardingRequest &getDefaultInstance();

private:

    inline void set_has_keyRequest ();

    inline void clear_has_keyRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    keyInfo _keyRequest;

};

/**
 * forward a received (and not consumed) encoder event to stub
 */
class EncoderForwardingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EncoderForwardingRequest ();

    /**
     * Copy constructor
     */
    inline  EncoderForwardingRequest (const EncoderForwardingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderForwardingRequest (const encoderInfo& encoderRequest_);

    /**
     * Destructor
     */
    inline virtual  ~EncoderForwardingRequest();

    /**
     * Assignment operator
     */
    inline EncoderForwardingRequest& operator = (const EncoderForwardingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderForwardingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderForwardingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderForwardingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderForwardingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "encoderRequest"

    static const int kEncoderRequest = 0;

    /**
     * Clears the field "encoderRequest".
     *
     * The field will be set to its default value. The hasEncoderRequest()
     * method will return false.
     */
    inline void clearEncoderRequest();

    /**
     * Checks whether the field "encoderRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncoderRequest()). Otherwise it will return false.
     */
    inline bool hasEncoderRequest () const;

    /**
     * Returns the value of the member "encoderRequest".
     *
     * If the meaning of "encoderRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "encoderRequest"
     */
    inline const encoderInfo& getEncoderRequest () const;

    /**
     * Retrieves the value of the field "encoderRequest" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "encoderRequest".
     */
    inline encoderInfo& getEncoderRequestMutable ();

    /**
     * Sets the value of the member "encoderRequest".
     *
     * If the meaning of "encoderRequest" isn't clear, then there should be a description here.
     *
     * @param encoderRequest The value which will be set
     */
    inline void setEncoderRequest (const encoderInfo& encoderRequest_);

    static const EncoderForwardingRequest &getDefaultInstance();

private:

    inline void set_has_encoderRequest ();

    inline void clear_has_encoderRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    encoderInfo _encoderRequest;

};

/**
 * forward a beep request to stub
 */
class BeepForwardingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepForwardingRequest ();

    /**
     * Copy constructor
     */
    inline  BeepForwardingRequest (const BeepForwardingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BeepForwardingRequest (int32 beepType_);

    /**
     * Destructor
     */
    inline virtual  ~BeepForwardingRequest();

    /**
     * Assignment operator
     */
    inline BeepForwardingRequest& operator = (const BeepForwardingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepForwardingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepForwardingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepForwardingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepForwardingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "beepType"

    static const int kBeepType = 0;

    /**
     * Clears the field "beepType".
     *
     * The field will be set to its default value. The hasBeepType()
     * method will return false.
     */
    inline void clearBeepType();

    /**
     * Checks whether the field "beepType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepType()). Otherwise it will return false.
     */
    inline bool hasBeepType () const;

    /**
     * Returns the value of the member "beepType".
     *
     * If the meaning of "beepType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "beepType"
     */
    inline int32 getBeepType () const;

    /**
     * Sets the value of the member "beepType".
     *
     * If the meaning of "beepType" isn't clear, then there should be a description here.
     *
     * @param beepType The value which will be set
     */
    inline void setBeepType (int32 beepType_);

    static const BeepForwardingRequest &getDefaultInstance();

private:

    inline void set_has_beepType ();

    inline void clear_has_beepType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _beepType;

};

/**
 * set the calling application as mandatory for synchronized hmi startup
 */
class SetApplicationMandatoryRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetApplicationMandatoryRequest ();

    /**
     * Copy constructor
     */
    inline  SetApplicationMandatoryRequest (const SetApplicationMandatoryRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetApplicationMandatoryRequest (const ::std::string& name_, bool value_);

    /**
     * Destructor
     */
    inline virtual  ~SetApplicationMandatoryRequest();

    /**
     * Assignment operator
     */
    inline SetApplicationMandatoryRequest& operator = (const SetApplicationMandatoryRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetApplicationMandatoryRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetApplicationMandatoryRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetApplicationMandatoryRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetApplicationMandatoryRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline bool getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (bool value_);

    static const SetApplicationMandatoryRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    bool _value;

};

/**
 * todo
 */
class DisplayCmdRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayCmdRequest ();

    /**
     * Copy constructor
     */
    inline  DisplayCmdRequest (const DisplayCmdRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayCmdRequest (const displayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayCmdRequest();

    /**
     * Assignment operator
     */
    inline DisplayCmdRequest& operator = (const DisplayCmdRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayCmdRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayCmdRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayCmdRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayCmdRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const displayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline displayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const displayData& data_);

    static const DisplayCmdRequest &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    displayData _data;

};

/**
 * If the meaning of "MultiDisplayCmd" isn't clear, then there should be a description here.
 */
class MultiDisplayCmdRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MultiDisplayCmdRequest ();

    /**
     * Copy constructor
     */
    inline  MultiDisplayCmdRequest (const MultiDisplayCmdRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MultiDisplayCmdRequest (const MultidisplayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~MultiDisplayCmdRequest();

    /**
     * Assignment operator
     */
    inline MultiDisplayCmdRequest& operator = (const MultiDisplayCmdRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MultiDisplayCmdRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MultiDisplayCmdRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MultiDisplayCmdRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MultiDisplayCmdRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const MultidisplayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline MultidisplayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const MultidisplayData& data_);

    static const MultiDisplayCmdRequest &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MultidisplayData _data;

};

/**
 * todo
 */
class DisplayStatusEvalRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayStatusEvalRequest ();

    /**
     * Copy constructor
     */
    inline  DisplayStatusEvalRequest (const DisplayStatusEvalRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayStatusEvalRequest (const MultidisplayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayStatusEvalRequest();

    /**
     * Assignment operator
     */
    inline DisplayStatusEvalRequest& operator = (const DisplayStatusEvalRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayStatusEvalRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayStatusEvalRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayStatusEvalRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayStatusEvalRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const MultidisplayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline MultidisplayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const MultidisplayData& data_);

    static const DisplayStatusEvalRequest &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MultidisplayData _data;

};

/**
 * request stub to distribute
 */
class RequestExternalImageProviderActivationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestExternalImageProviderActivationRequest ();

    /**
     * Copy constructor
     */
    inline  RequestExternalImageProviderActivationRequest (const RequestExternalImageProviderActivationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestExternalImageProviderActivationRequest (gadgetStatus targetState_, const ::std::vector< int32 >& instanceIds_, int32 consumerId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestExternalImageProviderActivationRequest();

    /**
     * Assignment operator
     */
    inline RequestExternalImageProviderActivationRequest& operator = (const RequestExternalImageProviderActivationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestExternalImageProviderActivationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestExternalImageProviderActivationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestExternalImageProviderActivationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestExternalImageProviderActivationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "targetState"

    static const int kTargetState = 0;

    /**
     * Clears the field "targetState".
     *
     * The field will be set to its default value. The hasTargetState()
     * method will return false.
     */
    inline void clearTargetState();

    /**
     * Checks whether the field "targetState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetState()). Otherwise it will return false.
     */
    inline bool hasTargetState () const;

    /**
     * Returns the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetState"
     */
    inline gadgetStatus getTargetState () const;

    /**
     * Sets the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @param targetState The value which will be set
     */
    inline void setTargetState (gadgetStatus targetState_);

    // API of field "instanceIds"

    static const int kInstanceIds = 1;

    /**
     * Clears the field "instanceIds".
     *
     * The field will be set to its default value. The hasInstanceIds()
     * method will return false.
     */
    inline void clearInstanceIds();

    /**
     * Checks whether the field "instanceIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceIds()). Otherwise it will return false.
     */
    inline bool hasInstanceIds () const;

    /**
     * Returns the value of the member "instanceIds".
     *
     * If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceIds"
     */
    inline const ::std::vector< int32 >& getInstanceIds () const;

    /**
     * Retrieves the value of the field "instanceIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "instanceIds".
     */
    inline ::std::vector< int32 >& getInstanceIdsMutable ();

    /**
     * Sets the value of the member "instanceIds".
     *
     * If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @param instanceIds The value which will be set
     */
    inline void setInstanceIds (const ::std::vector< int32 >& instanceIds_);

    // API of field "consumerId"

    static const int kConsumerId = 2;

    /**
     * Clears the field "consumerId".
     *
     * The field will be set to its default value. The hasConsumerId()
     * method will return false.
     */
    inline void clearConsumerId();

    /**
     * Checks whether the field "consumerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumerId()). Otherwise it will return false.
     */
    inline bool hasConsumerId () const;

    /**
     * Returns the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "consumerId"
     */
    inline int32 getConsumerId () const;

    /**
     * Sets the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @param consumerId The value which will be set
     */
    inline void setConsumerId (int32 consumerId_);

    static const RequestExternalImageProviderActivationRequest &getDefaultInstance();

private:

    static const ::std::vector< int32 >& getInt32List_DefaultInstance ();

    inline void set_has_targetState ();

    inline void clear_has_targetState ();

    inline void set_has_instanceIds ();

    inline void clear_has_instanceIds ();

    inline void set_has_consumerId ();

    inline void clear_has_consumerId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    gadgetStatus _targetState;

    ::std::vector< int32 > _instanceIds;

    int32 _consumerId;

};

/**
 * request stub to distribute
 */
class RequestExternalImageProviderTouchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestExternalImageProviderTouchRequest ();

    /**
     * Copy constructor
     */
    inline  RequestExternalImageProviderTouchRequest (const RequestExternalImageProviderTouchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestExternalImageProviderTouchRequest (uint32 pidSender_, const touchInfo& data_, int32 instanceId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestExternalImageProviderTouchRequest();

    /**
     * Assignment operator
     */
    inline RequestExternalImageProviderTouchRequest& operator = (const RequestExternalImageProviderTouchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestExternalImageProviderTouchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestExternalImageProviderTouchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestExternalImageProviderTouchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestExternalImageProviderTouchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "data"

    static const int kData = 1;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const touchInfo& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline touchInfo& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const touchInfo& data_);

    // API of field "instanceId"

    static const int kInstanceId = 2;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline int32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (int32 instanceId_);

    static const RequestExternalImageProviderTouchRequest &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pidSender;

    touchInfo _data;

    int32 _instanceId;

};

/**
 * request stub to distribute
 */
class RequestSlaveSurfaceRepositioningRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSlaveSurfaceRepositioningRequest ();

    /**
     * Copy constructor
     */
    inline  RequestSlaveSurfaceRepositioningRequest (const RequestSlaveSurfaceRepositioningRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSlaveSurfaceRepositioningRequest (uint32 pidSender_, bool activate_, uint32 surfaceId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSlaveSurfaceRepositioningRequest();

    /**
     * Assignment operator
     */
    inline RequestSlaveSurfaceRepositioningRequest& operator = (const RequestSlaveSurfaceRepositioningRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "activate"

    static const int kActivate = 1;

    /**
     * Clears the field "activate".
     *
     * The field will be set to its default value. The hasActivate()
     * method will return false.
     */
    inline void clearActivate();

    /**
     * Checks whether the field "activate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivate()). Otherwise it will return false.
     */
    inline bool hasActivate () const;

    /**
     * Returns the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activate"
     */
    inline bool getActivate () const;

    /**
     * Sets the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param activate The value which will be set
     */
    inline void setActivate (bool activate_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    static const RequestSlaveSurfaceRepositioningRequest &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_activate ();

    inline void clear_has_activate ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pidSender;

    bool _activate;

    uint32 _surfaceId;

};

/**
 * request stub to distribute
 */
class ResponseSlaveSurfaceRepositioningRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResponseSlaveSurfaceRepositioningRequest ();

    /**
     * Copy constructor
     */
    inline  ResponseSlaveSurfaceRepositioningRequest (const ResponseSlaveSurfaceRepositioningRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ResponseSlaveSurfaceRepositioningRequest (uint32 pidSender_, bool activate_, uint32 surfaceId_, bool status_);

    /**
     * Destructor
     */
    inline virtual  ~ResponseSlaveSurfaceRepositioningRequest();

    /**
     * Assignment operator
     */
    inline ResponseSlaveSurfaceRepositioningRequest& operator = (const ResponseSlaveSurfaceRepositioningRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResponseSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResponseSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResponseSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResponseSlaveSurfaceRepositioningRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "activate"

    static const int kActivate = 1;

    /**
     * Clears the field "activate".
     *
     * The field will be set to its default value. The hasActivate()
     * method will return false.
     */
    inline void clearActivate();

    /**
     * Checks whether the field "activate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivate()). Otherwise it will return false.
     */
    inline bool hasActivate () const;

    /**
     * Returns the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activate"
     */
    inline bool getActivate () const;

    /**
     * Sets the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param activate The value which will be set
     */
    inline void setActivate (bool activate_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "status"

    static const int kStatus = 3;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const ResponseSlaveSurfaceRepositioningRequest &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_activate ();

    inline void clear_has_activate ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _pidSender;

    bool _activate;

    uint32 _surfaceId;

    bool _status;

};

/**
 * request stub to distribute
 */
class RequestDirectTextureConsumerPositionInfoRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDirectTextureConsumerPositionInfoRequest ();

    /**
     * Copy constructor
     */
    inline  RequestDirectTextureConsumerPositionInfoRequest (const RequestDirectTextureConsumerPositionInfoRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDirectTextureConsumerPositionInfoRequest (uint32 pidSender_, uint32 instanceId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDirectTextureConsumerPositionInfoRequest();

    /**
     * Assignment operator
     */
    inline RequestDirectTextureConsumerPositionInfoRequest& operator = (const RequestDirectTextureConsumerPositionInfoRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "instanceId"

    static const int kInstanceId = 1;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline uint32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (uint32 instanceId_);

    static const RequestDirectTextureConsumerPositionInfoRequest &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _pidSender;

    uint32 _instanceId;

};

/**
 * request stub to distribute
 */
class ResponseDirectTextureConsumerPositionInfoRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResponseDirectTextureConsumerPositionInfoRequest ();

    /**
     * Copy constructor
     */
    inline  ResponseDirectTextureConsumerPositionInfoRequest (const ResponseDirectTextureConsumerPositionInfoRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ResponseDirectTextureConsumerPositionInfoRequest (uint32 pidSender_, uint32 instanceId_, float xPos_, float yPos_);

    /**
     * Destructor
     */
    inline virtual  ~ResponseDirectTextureConsumerPositionInfoRequest();

    /**
     * Assignment operator
     */
    inline ResponseDirectTextureConsumerPositionInfoRequest& operator = (const ResponseDirectTextureConsumerPositionInfoRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "instanceId"

    static const int kInstanceId = 1;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline uint32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (uint32 instanceId_);

    // API of field "xPos"

    static const int kXPos = 2;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline float getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (float xPos_);

    // API of field "yPos"

    static const int kYPos = 3;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline float getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (float yPos_);

    static const ResponseDirectTextureConsumerPositionInfoRequest &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _pidSender;

    uint32 _instanceId;

    float _xPos;

    float _yPos;

};

class ApplicationRenderedUpdateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplicationRenderedUpdateRequest ();

    /**
     * Copy constructor
     */
    inline  ApplicationRenderedUpdateRequest (const ApplicationRenderedUpdateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationRenderedUpdateRequest (int32 surfaceid_);

    /**
     * Destructor
     */
    inline virtual  ~ApplicationRenderedUpdateRequest();

    /**
     * Assignment operator
     */
    inline ApplicationRenderedUpdateRequest& operator = (const ApplicationRenderedUpdateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationRenderedUpdateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationRenderedUpdateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationRenderedUpdateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationRenderedUpdateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "surfaceid"

    static const int kSurfaceid = 0;

    /**
     * Clears the field "surfaceid".
     *
     * The field will be set to its default value. The hasSurfaceid()
     * method will return false.
     */
    inline void clearSurfaceid();

    /**
     * Checks whether the field "surfaceid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceid()). Otherwise it will return false.
     */
    inline bool hasSurfaceid () const;

    /**
     * Returns the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceid"
     */
    inline int32 getSurfaceid () const;

    /**
     * Sets the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceid The value which will be set
     */
    inline void setSurfaceid (int32 surfaceid_);

    static const ApplicationRenderedUpdateRequest &getDefaultInstance();

private:

    inline void set_has_surfaceid ();

    inline void clear_has_surfaceid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _surfaceid;

};

class ApplicationSwitchCompleteRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplicationSwitchCompleteRequest ();

    /**
     * Copy constructor
     */
    inline  ApplicationSwitchCompleteRequest (const ApplicationSwitchCompleteRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationSwitchCompleteRequest (int32 surfaceid_, int32 surfaceState_);

    /**
     * Destructor
     */
    inline virtual  ~ApplicationSwitchCompleteRequest();

    /**
     * Assignment operator
     */
    inline ApplicationSwitchCompleteRequest& operator = (const ApplicationSwitchCompleteRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationSwitchCompleteRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationSwitchCompleteRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationSwitchCompleteRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationSwitchCompleteRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "surfaceid"

    static const int kSurfaceid = 0;

    /**
     * Clears the field "surfaceid".
     *
     * The field will be set to its default value. The hasSurfaceid()
     * method will return false.
     */
    inline void clearSurfaceid();

    /**
     * Checks whether the field "surfaceid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceid()). Otherwise it will return false.
     */
    inline bool hasSurfaceid () const;

    /**
     * Returns the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceid"
     */
    inline int32 getSurfaceid () const;

    /**
     * Sets the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceid The value which will be set
     */
    inline void setSurfaceid (int32 surfaceid_);

    // API of field "surfaceState"

    static const int kSurfaceState = 1;

    /**
     * Clears the field "surfaceState".
     *
     * The field will be set to its default value. The hasSurfaceState()
     * method will return false.
     */
    inline void clearSurfaceState();

    /**
     * Checks whether the field "surfaceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceState()). Otherwise it will return false.
     */
    inline bool hasSurfaceState () const;

    /**
     * Returns the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceState"
     */
    inline int32 getSurfaceState () const;

    /**
     * Sets the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @param surfaceState The value which will be set
     */
    inline void setSurfaceState (int32 surfaceState_);

    static const ApplicationSwitchCompleteRequest &getDefaultInstance();

private:

    inline void set_has_surfaceid ();

    inline void clear_has_surfaceid ();

    inline void set_has_surfaceState ();

    inline void clear_has_surfaceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _surfaceid;

    int32 _surfaceState;

};

class SubSurfaceSwitchCompleteRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubSurfaceSwitchCompleteRequest ();

    /**
     * Copy constructor
     */
    inline  SubSurfaceSwitchCompleteRequest (const SubSurfaceSwitchCompleteRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SubSurfaceSwitchCompleteRequest (int32 surfaceid_, int32 surfaceState_);

    /**
     * Destructor
     */
    inline virtual  ~SubSurfaceSwitchCompleteRequest();

    /**
     * Assignment operator
     */
    inline SubSurfaceSwitchCompleteRequest& operator = (const SubSurfaceSwitchCompleteRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubSurfaceSwitchCompleteRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubSurfaceSwitchCompleteRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubSurfaceSwitchCompleteRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubSurfaceSwitchCompleteRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "surfaceid"

    static const int kSurfaceid = 0;

    /**
     * Clears the field "surfaceid".
     *
     * The field will be set to its default value. The hasSurfaceid()
     * method will return false.
     */
    inline void clearSurfaceid();

    /**
     * Checks whether the field "surfaceid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceid()). Otherwise it will return false.
     */
    inline bool hasSurfaceid () const;

    /**
     * Returns the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceid"
     */
    inline int32 getSurfaceid () const;

    /**
     * Sets the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceid The value which will be set
     */
    inline void setSurfaceid (int32 surfaceid_);

    // API of field "surfaceState"

    static const int kSurfaceState = 1;

    /**
     * Clears the field "surfaceState".
     *
     * The field will be set to its default value. The hasSurfaceState()
     * method will return false.
     */
    inline void clearSurfaceState();

    /**
     * Checks whether the field "surfaceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceState()). Otherwise it will return false.
     */
    inline bool hasSurfaceState () const;

    /**
     * Returns the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceState"
     */
    inline int32 getSurfaceState () const;

    /**
     * Sets the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @param surfaceState The value which will be set
     */
    inline void setSurfaceState (int32 surfaceState_);

    static const SubSurfaceSwitchCompleteRequest &getDefaultInstance();

private:

    inline void set_has_surfaceid ();

    inline void clear_has_surfaceid ();

    inline void set_has_surfaceState ();

    inline void clear_has_surfaceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _surfaceid;

    int32 _surfaceState;

};

class FollowUpActionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FollowUpActionRequest ();

    /**
     * Copy constructor
     */
    inline  FollowUpActionRequest (const FollowUpActionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  FollowUpActionRequest (followUpAction actionType_, uint32 userData_);

    /**
     * Destructor
     */
    inline virtual  ~FollowUpActionRequest();

    /**
     * Assignment operator
     */
    inline FollowUpActionRequest& operator = (const FollowUpActionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FollowUpActionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FollowUpActionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FollowUpActionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FollowUpActionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "actionType"

    static const int kActionType = 0;

    /**
     * Clears the field "actionType".
     *
     * The field will be set to its default value. The hasActionType()
     * method will return false.
     */
    inline void clearActionType();

    /**
     * Checks whether the field "actionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionType()). Otherwise it will return false.
     */
    inline bool hasActionType () const;

    /**
     * Returns the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "actionType"
     */
    inline followUpAction getActionType () const;

    /**
     * Sets the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param actionType The value which will be set
     */
    inline void setActionType (followUpAction actionType_);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const FollowUpActionRequest &getDefaultInstance();

private:

    inline void set_has_actionType ();

    inline void clear_has_actionType ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    followUpAction _actionType;

    uint32 _userData;

};

class ResponseFollowUpActionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResponseFollowUpActionRequest ();

    /**
     * Copy constructor
     */
    inline  ResponseFollowUpActionRequest (const ResponseFollowUpActionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ResponseFollowUpActionRequest (followUpAction actionType_, uint32 userData_);

    /**
     * Destructor
     */
    inline virtual  ~ResponseFollowUpActionRequest();

    /**
     * Assignment operator
     */
    inline ResponseFollowUpActionRequest& operator = (const ResponseFollowUpActionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResponseFollowUpActionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResponseFollowUpActionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResponseFollowUpActionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResponseFollowUpActionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "actionType"

    static const int kActionType = 0;

    /**
     * Clears the field "actionType".
     *
     * The field will be set to its default value. The hasActionType()
     * method will return false.
     */
    inline void clearActionType();

    /**
     * Checks whether the field "actionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionType()). Otherwise it will return false.
     */
    inline bool hasActionType () const;

    /**
     * Returns the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "actionType"
     */
    inline followUpAction getActionType () const;

    /**
     * Sets the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param actionType The value which will be set
     */
    inline void setActionType (followUpAction actionType_);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const ResponseFollowUpActionRequest &getDefaultInstance();

private:

    inline void set_has_actionType ();

    inline void clear_has_actionType ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    followUpAction _actionType;

    uint32 _userData;

};

/**
 * Report the status of dma buffer allocation
 */
class DrmBufferAllocationStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DrmBufferAllocationStatusRequest ();

    /**
     * Copy constructor
     */
    inline  DrmBufferAllocationStatusRequest (const DrmBufferAllocationStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DrmBufferAllocationStatusRequest (int32 pid_, drmBufferAllocationStatus status_, uint32 bufferSize_);

    /**
     * Destructor
     */
    inline virtual  ~DrmBufferAllocationStatusRequest();

    /**
     * Assignment operator
     */
    inline DrmBufferAllocationStatusRequest& operator = (const DrmBufferAllocationStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DrmBufferAllocationStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DrmBufferAllocationStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DrmBufferAllocationStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DrmBufferAllocationStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pid"

    static const int kPid = 0;

    /**
     * Clears the field "pid".
     *
     * The field will be set to its default value. The hasPid()
     * method will return false.
     */
    inline void clearPid();

    /**
     * Checks whether the field "pid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPid()). Otherwise it will return false.
     */
    inline bool hasPid () const;

    /**
     * Returns the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pid"
     */
    inline int32 getPid () const;

    /**
     * Sets the value of the member "pid".
     *
     * If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param pid The value which will be set
     */
    inline void setPid (int32 pid_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline drmBufferAllocationStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (drmBufferAllocationStatus status_);

    // API of field "bufferSize"

    static const int kBufferSize = 2;

    /**
     * Clears the field "bufferSize".
     *
     * The field will be set to its default value. The hasBufferSize()
     * method will return false.
     */
    inline void clearBufferSize();

    /**
     * Checks whether the field "bufferSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferSize()). Otherwise it will return false.
     */
    inline bool hasBufferSize () const;

    /**
     * Returns the value of the member "bufferSize".
     *
     * If the meaning of "bufferSize" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bufferSize"
     */
    inline uint32 getBufferSize () const;

    /**
     * Sets the value of the member "bufferSize".
     *
     * If the meaning of "bufferSize" isn't clear, then there should be a description here.
     *
     * @param bufferSize The value which will be set
     */
    inline void setBufferSize (uint32 bufferSize_);

    static const DrmBufferAllocationStatusRequest &getDefaultInstance();

private:

    inline void set_has_pid ();

    inline void clear_has_pid ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_bufferSize ();

    inline void clear_has_bufferSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _pid;

    drmBufferAllocationStatus _status;

    uint32 _bufferSize;

};

/**
 * Property to state the known/already requested external images.
 */
class ExternalImagesStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExternalImagesStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  ExternalImagesStatusUpdate (const ExternalImagesStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalImagesStatusUpdate (const ::std::vector< ExternalImageData >& ExternalImagesStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ExternalImagesStatusUpdate();

    /**
     * Assignment operator
     */
    inline ExternalImagesStatusUpdate& operator = (const ExternalImagesStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalImagesStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalImagesStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalImagesStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalImagesStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ExternalImagesStatus"

    static const int kExternalImagesStatus = 0;

    /**
     * Clears the field "ExternalImagesStatus".
     *
     * The field will be set to its default value. The hasExternalImagesStatus()
     * method will return false.
     */
    inline void clearExternalImagesStatus();

    /**
     * Checks whether the field "ExternalImagesStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExternalImagesStatus()). Otherwise it will return false.
     */
    inline bool hasExternalImagesStatus () const;

    /**
     * Returns the value of the member "ExternalImagesStatus".
     *
     * Property to state the known/already requested external images.
     *
     * @return The value of the field "ExternalImagesStatus"
     */
    inline const ::std::vector< ExternalImageData >& getExternalImagesStatus () const;

    /**
     * Retrieves the value of the field "ExternalImagesStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ExternalImagesStatus".
     */
    inline ::std::vector< ExternalImageData >& getExternalImagesStatusMutable ();

    /**
     * Sets the value of the member "ExternalImagesStatus".
     *
     * Property to state the known/already requested external images.
     *
     * @param ExternalImagesStatus The value which will be set
     */
    inline void setExternalImagesStatus (const ::std::vector< ExternalImageData >& ExternalImagesStatus_);

    static const ExternalImagesStatusUpdate &getDefaultInstance();

private:

    static const ::std::vector< ExternalImageData >& getExternalImageDataList_DefaultInstance ();

    inline void set_has_ExternalImagesStatus ();

    inline void clear_has_ExternalImagesStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ExternalImageData > _ExternalImagesStatus;

};

/**
 * Property to state the known/already requested external images.
 */
class ExternalImagesStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExternalImagesStatusRegister ();

    /**
     * Copy constructor
     */
    inline  ExternalImagesStatusRegister (const ExternalImagesStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ExternalImagesStatusRegister();

    /**
     * Assignment operator
     */
    inline ExternalImagesStatusRegister& operator = (const ExternalImagesStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalImagesStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalImagesStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalImagesStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalImagesStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ExternalImagesStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the application status of registered clients.
 */
class ClientsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClientsUpdate ();

    /**
     * Copy constructor
     */
    inline  ClientsUpdate (const ClientsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ClientsUpdate (const ::std::vector< ApplicationState >& Clients_);

    /**
     * Destructor
     */
    inline virtual  ~ClientsUpdate();

    /**
     * Assignment operator
     */
    inline ClientsUpdate& operator = (const ClientsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClientsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClientsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClientsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClientsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Clients"

    static const int kClients = 0;

    /**
     * Clears the field "Clients".
     *
     * The field will be set to its default value. The hasClients()
     * method will return false.
     */
    inline void clearClients();

    /**
     * Checks whether the field "Clients" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClients()). Otherwise it will return false.
     */
    inline bool hasClients () const;

    /**
     * Returns the value of the member "Clients".
     *
     * Property to state the application status of registered clients.
     *
     * @return The value of the field "Clients"
     */
    inline const ::std::vector< ApplicationState >& getClients () const;

    /**
     * Retrieves the value of the field "Clients" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Clients".
     */
    inline ::std::vector< ApplicationState >& getClientsMutable ();

    /**
     * Sets the value of the member "Clients".
     *
     * Property to state the application status of registered clients.
     *
     * @param Clients The value which will be set
     */
    inline void setClients (const ::std::vector< ApplicationState >& Clients_);

    static const ClientsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ApplicationState >& getApplicationStateList_DefaultInstance ();

    inline void set_has_Clients ();

    inline void clear_has_Clients ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ApplicationState > _Clients;

};

/**
 * Property to state the application status of registered clients.
 */
class ClientsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClientsRegister ();

    /**
     * Copy constructor
     */
    inline  ClientsRegister (const ClientsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ClientsRegister();

    /**
     * Assignment operator
     */
    inline ClientsRegister& operator = (const ClientsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClientsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClientsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClientsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClientsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ClientsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * broadcast sub surface switch complete msg to all apps
 */
class SubSurfaceSwitchUpdateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubSurfaceSwitchUpdateSignal ();

    /**
     * Copy constructor
     */
    inline  SubSurfaceSwitchUpdateSignal (const SubSurfaceSwitchUpdateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SubSurfaceSwitchUpdateSignal (int32 surfaceid_, int32 surfaceState_);

    /**
     * Destructor
     */
    inline virtual  ~SubSurfaceSwitchUpdateSignal();

    /**
     * Assignment operator
     */
    inline SubSurfaceSwitchUpdateSignal& operator = (const SubSurfaceSwitchUpdateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubSurfaceSwitchUpdateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubSurfaceSwitchUpdateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubSurfaceSwitchUpdateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubSurfaceSwitchUpdateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "surfaceid"

    static const int kSurfaceid = 0;

    /**
     * Clears the field "surfaceid".
     *
     * The field will be set to its default value. The hasSurfaceid()
     * method will return false.
     */
    inline void clearSurfaceid();

    /**
     * Checks whether the field "surfaceid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceid()). Otherwise it will return false.
     */
    inline bool hasSurfaceid () const;

    /**
     * Returns the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceid"
     */
    inline int32 getSurfaceid () const;

    /**
     * Sets the value of the member "surfaceid".
     *
     * If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceid The value which will be set
     */
    inline void setSurfaceid (int32 surfaceid_);

    // API of field "surfaceState"

    static const int kSurfaceState = 1;

    /**
     * Clears the field "surfaceState".
     *
     * The field will be set to its default value. The hasSurfaceState()
     * method will return false.
     */
    inline void clearSurfaceState();

    /**
     * Checks whether the field "surfaceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceState()). Otherwise it will return false.
     */
    inline bool hasSurfaceState () const;

    /**
     * Returns the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceState"
     */
    inline int32 getSurfaceState () const;

    /**
     * Sets the value of the member "surfaceState".
     *
     * If the meaning of "surfaceState" isn't clear, then there should be a description here.
     *
     * @param surfaceState The value which will be set
     */
    inline void setSurfaceState (int32 surfaceState_);

    static const SubSurfaceSwitchUpdateSignal &getDefaultInstance();

private:

    inline void set_has_surfaceid ();

    inline void clear_has_surfaceid ();

    inline void set_has_surfaceState ();

    inline void clear_has_surfaceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _surfaceid;

    int32 _surfaceState;

};

/**
 * broadcast key information to be processed by a particular client
 */
class KeyInfoForwardingSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyInfoForwardingSignal ();

    /**
     * Copy constructor
     */
    inline  KeyInfoForwardingSignal (const KeyInfoForwardingSignal &rhs);

    /**
     * All fields constructor
     */
    inline  KeyInfoForwardingSignal (const keyInfo& data_);

    /**
     * Destructor
     */
    inline virtual  ~KeyInfoForwardingSignal();

    /**
     * Assignment operator
     */
    inline KeyInfoForwardingSignal& operator = (const KeyInfoForwardingSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyInfoForwardingSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyInfoForwardingSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyInfoForwardingSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyInfoForwardingSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const keyInfo& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline keyInfo& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const keyInfo& data_);

    static const KeyInfoForwardingSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    keyInfo _data;

};

/**
 * broadcast key information to be processed by a particular client
 */
class EncoderInfoForwardingSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EncoderInfoForwardingSignal ();

    /**
     * Copy constructor
     */
    inline  EncoderInfoForwardingSignal (const EncoderInfoForwardingSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderInfoForwardingSignal (const encoderInfo& data_);

    /**
     * Destructor
     */
    inline virtual  ~EncoderInfoForwardingSignal();

    /**
     * Assignment operator
     */
    inline EncoderInfoForwardingSignal& operator = (const EncoderInfoForwardingSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderInfoForwardingSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderInfoForwardingSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderInfoForwardingSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderInfoForwardingSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const encoderInfo& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline encoderInfo& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const encoderInfo& data_);

    static const EncoderInfoForwardingSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    encoderInfo _data;

};

/**
 * todo
 */
class SetDisplaySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDisplaySignal ();

    /**
     * Copy constructor
     */
    inline  SetDisplaySignal (const SetDisplaySignal &rhs);

    /**
     * All fields constructor
     */
    inline  SetDisplaySignal (const displayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SetDisplaySignal();

    /**
     * Assignment operator
     */
    inline SetDisplaySignal& operator = (const SetDisplaySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDisplaySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDisplaySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDisplaySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDisplaySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const displayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline displayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const displayData& data_);

    static const SetDisplaySignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    displayData _data;

};

/**
 * todo
 */
class SetMultiDisplaySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMultiDisplaySignal ();

    /**
     * Copy constructor
     */
    inline  SetMultiDisplaySignal (const SetMultiDisplaySignal &rhs);

    /**
     * All fields constructor
     */
    inline  SetMultiDisplaySignal (const MultidisplayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~SetMultiDisplaySignal();

    /**
     * Assignment operator
     */
    inline SetMultiDisplaySignal& operator = (const SetMultiDisplaySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMultiDisplaySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMultiDisplaySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMultiDisplaySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMultiDisplaySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const MultidisplayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline MultidisplayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const MultidisplayData& data_);

    static const SetMultiDisplaySignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MultidisplayData _data;

};

/**
 * use this to start display status evaluation (mainly used for statusline)
 */
class EvDisplayStatusEvalSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EvDisplayStatusEvalSignal ();

    /**
     * Copy constructor
     */
    inline  EvDisplayStatusEvalSignal (const EvDisplayStatusEvalSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EvDisplayStatusEvalSignal (const MultidisplayData& data_);

    /**
     * Destructor
     */
    inline virtual  ~EvDisplayStatusEvalSignal();

    /**
     * Assignment operator
     */
    inline EvDisplayStatusEvalSignal& operator = (const EvDisplayStatusEvalSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EvDisplayStatusEvalSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EvDisplayStatusEvalSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EvDisplayStatusEvalSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EvDisplayStatusEvalSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const MultidisplayData& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline MultidisplayData& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const MultidisplayData& data_);

    static const EvDisplayStatusEvalSignal &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MultidisplayData _data;

};

/**
 * todo
 */
class ActivateExternalImageProviderSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateExternalImageProviderSignal ();

    /**
     * Copy constructor
     */
    inline  ActivateExternalImageProviderSignal (const ActivateExternalImageProviderSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateExternalImageProviderSignal (gadgetStatus targetState_, const ::std::vector< int32 >& instanceIds_, int32 consumerId_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateExternalImageProviderSignal();

    /**
     * Assignment operator
     */
    inline ActivateExternalImageProviderSignal& operator = (const ActivateExternalImageProviderSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateExternalImageProviderSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateExternalImageProviderSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateExternalImageProviderSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateExternalImageProviderSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "targetState"

    static const int kTargetState = 0;

    /**
     * Clears the field "targetState".
     *
     * The field will be set to its default value. The hasTargetState()
     * method will return false.
     */
    inline void clearTargetState();

    /**
     * Checks whether the field "targetState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetState()). Otherwise it will return false.
     */
    inline bool hasTargetState () const;

    /**
     * Returns the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetState"
     */
    inline gadgetStatus getTargetState () const;

    /**
     * Sets the value of the member "targetState".
     *
     * If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @param targetState The value which will be set
     */
    inline void setTargetState (gadgetStatus targetState_);

    // API of field "instanceIds"

    static const int kInstanceIds = 1;

    /**
     * Clears the field "instanceIds".
     *
     * The field will be set to its default value. The hasInstanceIds()
     * method will return false.
     */
    inline void clearInstanceIds();

    /**
     * Checks whether the field "instanceIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceIds()). Otherwise it will return false.
     */
    inline bool hasInstanceIds () const;

    /**
     * Returns the value of the member "instanceIds".
     *
     * If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceIds"
     */
    inline const ::std::vector< int32 >& getInstanceIds () const;

    /**
     * Retrieves the value of the field "instanceIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "instanceIds".
     */
    inline ::std::vector< int32 >& getInstanceIdsMutable ();

    /**
     * Sets the value of the member "instanceIds".
     *
     * If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @param instanceIds The value which will be set
     */
    inline void setInstanceIds (const ::std::vector< int32 >& instanceIds_);

    // API of field "consumerId"

    static const int kConsumerId = 2;

    /**
     * Clears the field "consumerId".
     *
     * The field will be set to its default value. The hasConsumerId()
     * method will return false.
     */
    inline void clearConsumerId();

    /**
     * Checks whether the field "consumerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumerId()). Otherwise it will return false.
     */
    inline bool hasConsumerId () const;

    /**
     * Returns the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "consumerId"
     */
    inline int32 getConsumerId () const;

    /**
     * Sets the value of the member "consumerId".
     *
     * If the meaning of "consumerId" isn't clear, then there should be a description here.
     *
     * @param consumerId The value which will be set
     */
    inline void setConsumerId (int32 consumerId_);

    static const ActivateExternalImageProviderSignal &getDefaultInstance();

private:

    static const ::std::vector< int32 >& getInt32List_DefaultInstance ();

    inline void set_has_targetState ();

    inline void clear_has_targetState ();

    inline void set_has_instanceIds ();

    inline void clear_has_instanceIds ();

    inline void set_has_consumerId ();

    inline void clear_has_consumerId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    gadgetStatus _targetState;

    ::std::vector< int32 > _instanceIds;

    int32 _consumerId;

};

/**
 * todo
 */
class ExternalImageProviderTouchSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExternalImageProviderTouchSignal ();

    /**
     * Copy constructor
     */
    inline  ExternalImageProviderTouchSignal (const ExternalImageProviderTouchSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalImageProviderTouchSignal (uint32 pidSender_, const touchInfo& data_, int32 instanceId_);

    /**
     * Destructor
     */
    inline virtual  ~ExternalImageProviderTouchSignal();

    /**
     * Assignment operator
     */
    inline ExternalImageProviderTouchSignal& operator = (const ExternalImageProviderTouchSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalImageProviderTouchSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalImageProviderTouchSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalImageProviderTouchSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalImageProviderTouchSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "data"

    static const int kData = 1;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const touchInfo& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline touchInfo& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const touchInfo& data_);

    // API of field "instanceId"

    static const int kInstanceId = 2;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline int32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (int32 instanceId_);

    static const ExternalImageProviderTouchSignal &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pidSender;

    touchInfo _data;

    int32 _instanceId;

};

/**
 * todo
 */
class SlaveSurfaceRepositioningSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SlaveSurfaceRepositioningSignal ();

    /**
     * Copy constructor
     */
    inline  SlaveSurfaceRepositioningSignal (const SlaveSurfaceRepositioningSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SlaveSurfaceRepositioningSignal (uint32 pidSender_, bool activate_, uint32 surfaceId_);

    /**
     * Destructor
     */
    inline virtual  ~SlaveSurfaceRepositioningSignal();

    /**
     * Assignment operator
     */
    inline SlaveSurfaceRepositioningSignal& operator = (const SlaveSurfaceRepositioningSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SlaveSurfaceRepositioningSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SlaveSurfaceRepositioningSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SlaveSurfaceRepositioningSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SlaveSurfaceRepositioningSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "activate"

    static const int kActivate = 1;

    /**
     * Clears the field "activate".
     *
     * The field will be set to its default value. The hasActivate()
     * method will return false.
     */
    inline void clearActivate();

    /**
     * Checks whether the field "activate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivate()). Otherwise it will return false.
     */
    inline bool hasActivate () const;

    /**
     * Returns the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activate"
     */
    inline bool getActivate () const;

    /**
     * Sets the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param activate The value which will be set
     */
    inline void setActivate (bool activate_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    static const SlaveSurfaceRepositioningSignal &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_activate ();

    inline void clear_has_activate ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _pidSender;

    bool _activate;

    uint32 _surfaceId;

};

/**
 * todo
 */
class SlaveSurfaceRepositioningAckSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SlaveSurfaceRepositioningAckSignal ();

    /**
     * Copy constructor
     */
    inline  SlaveSurfaceRepositioningAckSignal (const SlaveSurfaceRepositioningAckSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SlaveSurfaceRepositioningAckSignal (uint32 pidSender_, bool activate_, uint32 surfaceId_, bool status_);

    /**
     * Destructor
     */
    inline virtual  ~SlaveSurfaceRepositioningAckSignal();

    /**
     * Assignment operator
     */
    inline SlaveSurfaceRepositioningAckSignal& operator = (const SlaveSurfaceRepositioningAckSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SlaveSurfaceRepositioningAckSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SlaveSurfaceRepositioningAckSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SlaveSurfaceRepositioningAckSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SlaveSurfaceRepositioningAckSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "activate"

    static const int kActivate = 1;

    /**
     * Clears the field "activate".
     *
     * The field will be set to its default value. The hasActivate()
     * method will return false.
     */
    inline void clearActivate();

    /**
     * Checks whether the field "activate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivate()). Otherwise it will return false.
     */
    inline bool hasActivate () const;

    /**
     * Returns the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activate"
     */
    inline bool getActivate () const;

    /**
     * Sets the value of the member "activate".
     *
     * If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param activate The value which will be set
     */
    inline void setActivate (bool activate_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "status"

    static const int kStatus = 3;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const SlaveSurfaceRepositioningAckSignal &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_activate ();

    inline void clear_has_activate ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _pidSender;

    bool _activate;

    uint32 _surfaceId;

    bool _status;

};

/**
 * todo
 */
class DirectTextureConsumerPositionInfoRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DirectTextureConsumerPositionInfoRequestSignal ();

    /**
     * Copy constructor
     */
    inline  DirectTextureConsumerPositionInfoRequestSignal (const DirectTextureConsumerPositionInfoRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DirectTextureConsumerPositionInfoRequestSignal (uint32 pidSender_, uint32 instanceId_);

    /**
     * Destructor
     */
    inline virtual  ~DirectTextureConsumerPositionInfoRequestSignal();

    /**
     * Assignment operator
     */
    inline DirectTextureConsumerPositionInfoRequestSignal& operator = (const DirectTextureConsumerPositionInfoRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "instanceId"

    static const int kInstanceId = 1;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline uint32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (uint32 instanceId_);

    static const DirectTextureConsumerPositionInfoRequestSignal &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _pidSender;

    uint32 _instanceId;

};

/**
 * todo
 */
class DirectTextureConsumerPositionInfoResponseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DirectTextureConsumerPositionInfoResponseSignal ();

    /**
     * Copy constructor
     */
    inline  DirectTextureConsumerPositionInfoResponseSignal (const DirectTextureConsumerPositionInfoResponseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DirectTextureConsumerPositionInfoResponseSignal (uint32 pidSender_, uint32 instanceId_, float xPos_, float yPos_);

    /**
     * Destructor
     */
    inline virtual  ~DirectTextureConsumerPositionInfoResponseSignal();

    /**
     * Assignment operator
     */
    inline DirectTextureConsumerPositionInfoResponseSignal& operator = (const DirectTextureConsumerPositionInfoResponseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pidSender"

    static const int kPidSender = 0;

    /**
     * Clears the field "pidSender".
     *
     * The field will be set to its default value. The hasPidSender()
     * method will return false.
     */
    inline void clearPidSender();

    /**
     * Checks whether the field "pidSender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPidSender()). Otherwise it will return false.
     */
    inline bool hasPidSender () const;

    /**
     * Returns the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pidSender"
     */
    inline uint32 getPidSender () const;

    /**
     * Sets the value of the member "pidSender".
     *
     * If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param pidSender The value which will be set
     */
    inline void setPidSender (uint32 pidSender_);

    // API of field "instanceId"

    static const int kInstanceId = 1;

    /**
     * Clears the field "instanceId".
     *
     * The field will be set to its default value. The hasInstanceId()
     * method will return false.
     */
    inline void clearInstanceId();

    /**
     * Checks whether the field "instanceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceId()). Otherwise it will return false.
     */
    inline bool hasInstanceId () const;

    /**
     * Returns the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instanceId"
     */
    inline uint32 getInstanceId () const;

    /**
     * Sets the value of the member "instanceId".
     *
     * If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param instanceId The value which will be set
     */
    inline void setInstanceId (uint32 instanceId_);

    // API of field "xPos"

    static const int kXPos = 2;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline float getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (float xPos_);

    // API of field "yPos"

    static const int kYPos = 3;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline float getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (float yPos_);

    static const DirectTextureConsumerPositionInfoResponseSignal &getDefaultInstance();

private:

    inline void set_has_pidSender ();

    inline void clear_has_pidSender ();

    inline void set_has_instanceId ();

    inline void clear_has_instanceId ();

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _pidSender;

    uint32 _instanceId;

    float _xPos;

    float _yPos;

};

/**
 * todo
 */
class FollowUpActionRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FollowUpActionRequestSignal ();

    /**
     * Copy constructor
     */
    inline  FollowUpActionRequestSignal (const FollowUpActionRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  FollowUpActionRequestSignal (followUpAction actionType_, uint32 userData_);

    /**
     * Destructor
     */
    inline virtual  ~FollowUpActionRequestSignal();

    /**
     * Assignment operator
     */
    inline FollowUpActionRequestSignal& operator = (const FollowUpActionRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FollowUpActionRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FollowUpActionRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FollowUpActionRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FollowUpActionRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "actionType"

    static const int kActionType = 0;

    /**
     * Clears the field "actionType".
     *
     * The field will be set to its default value. The hasActionType()
     * method will return false.
     */
    inline void clearActionType();

    /**
     * Checks whether the field "actionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionType()). Otherwise it will return false.
     */
    inline bool hasActionType () const;

    /**
     * Returns the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "actionType"
     */
    inline followUpAction getActionType () const;

    /**
     * Sets the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param actionType The value which will be set
     */
    inline void setActionType (followUpAction actionType_);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const FollowUpActionRequestSignal &getDefaultInstance();

private:

    inline void set_has_actionType ();

    inline void clear_has_actionType ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    followUpAction _actionType;

    uint32 _userData;

};

/**
 * todo
 */
class FollowUpActionResponseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FollowUpActionResponseSignal ();

    /**
     * Copy constructor
     */
    inline  FollowUpActionResponseSignal (const FollowUpActionResponseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  FollowUpActionResponseSignal (followUpAction actionType_, uint32 userData_);

    /**
     * Destructor
     */
    inline virtual  ~FollowUpActionResponseSignal();

    /**
     * Assignment operator
     */
    inline FollowUpActionResponseSignal& operator = (const FollowUpActionResponseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FollowUpActionResponseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FollowUpActionResponseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FollowUpActionResponseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FollowUpActionResponseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "actionType"

    static const int kActionType = 0;

    /**
     * Clears the field "actionType".
     *
     * The field will be set to its default value. The hasActionType()
     * method will return false.
     */
    inline void clearActionType();

    /**
     * Checks whether the field "actionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionType()). Otherwise it will return false.
     */
    inline bool hasActionType () const;

    /**
     * Returns the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "actionType"
     */
    inline followUpAction getActionType () const;

    /**
     * Sets the value of the member "actionType".
     *
     * If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param actionType The value which will be set
     */
    inline void setActionType (followUpAction actionType_);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * If the meaning of "userData" isn't clear, then there should be a description here.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const FollowUpActionResponseSignal &getDefaultInstance();

private:

    inline void set_has_actionType ();

    inline void clear_has_actionType ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    followUpAction _actionType;

    uint32 _userData;

};

inline  keyInfo::keyInfo ()  :
    _keyCode (0u),
    _keyState (0u),
    _pidSender (0u),
    _pidReceiver (0u),
    _displayId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  keyInfo::keyInfo (const keyInfo &rhs)  :
    _keyCode (0u),
    _keyState (0u),
    _pidSender (0u),
    _pidReceiver (0u),
    _displayId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  keyInfo::keyInfo (uint32 keyCode_, uint8 keyState_, uint32 pidSender_, uint32 pidReceiver_, uint32 displayId_, uint32 userData_)  :
    _keyCode (keyCode_),
    _keyState (keyState_),
    _pidSender (pidSender_),
    _pidReceiver (pidReceiver_),
    _displayId (displayId_),
    _userData (userData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  keyInfo::~keyInfo() {
}

inline keyInfo& keyInfo::operator = (const keyInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasKeyCode()) {
            setKeyCode(rhs.getKeyCode());
        } else {
            clearKeyCode();
        }
        if (rhs.hasKeyState()) {
            setKeyState(rhs.getKeyState());
        } else {
            clearKeyState();
        }
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasPidReceiver()) {
            setPidReceiver(rhs.getPidReceiver());
        } else {
            clearPidReceiver();
        }
        if (rhs.hasDisplayId()) {
            setDisplayId(rhs.getDisplayId());
        } else {
            clearDisplayId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool keyInfo::operator == (const keyInfo& rhs) const {
    return (((!hasKeyCode() && !rhs.hasKeyCode()) || getKeyCode() == rhs.getKeyCode()) &&
        ((!hasKeyState() && !rhs.hasKeyState()) || getKeyState() == rhs.getKeyState()) &&
        ((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasPidReceiver() && !rhs.hasPidReceiver()) || getPidReceiver() == rhs.getPidReceiver()) &&
        ((!hasDisplayId() && !rhs.hasDisplayId()) || getDisplayId() == rhs.getDisplayId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool keyInfo::operator != (const keyInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool keyInfo::operator < (const keyInfo& rhs) const {
    if (hasKeyCode() || rhs.hasKeyCode()) {
        if (getKeyCode() < rhs.getKeyCode()) return true;
        if (getKeyCode() > rhs.getKeyCode()) return false;
    }
    if (hasKeyState() || rhs.hasKeyState()) {
        if (getKeyState() < rhs.getKeyState()) return true;
        if (getKeyState() > rhs.getKeyState()) return false;
    }
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasPidReceiver() || rhs.hasPidReceiver()) {
        if (getPidReceiver() < rhs.getPidReceiver()) return true;
        if (getPidReceiver() > rhs.getPidReceiver()) return false;
    }
    if (hasDisplayId() || rhs.hasDisplayId()) {
        if (getDisplayId() < rhs.getDisplayId()) return true;
        if (getDisplayId() > rhs.getDisplayId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline bool keyInfo::operator > (const keyInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void keyInfo::clear() {
    clearKeyCode();
    clearKeyState();
    clearPidSender();
    clearPidReceiver();
    clearDisplayId();
    clearUserData();
}

inline void keyInfo::clearKeyCode() {
    if (hasKeyCode()) {
         clear_has_keyCode();
        _keyCode = 0u;
     }
}

inline bool keyInfo::hasKeyCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 keyInfo::getKeyCode () const {
    return _keyCode;
}

inline void keyInfo::setKeyCode (uint32 keyCode_) {
    set_has_keyCode();
    this->_keyCode = keyCode_;
}

inline void keyInfo::clearKeyState() {
    if (hasKeyState()) {
         clear_has_keyState();
        _keyState = 0u;
     }
}

inline bool keyInfo::hasKeyState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 keyInfo::getKeyState () const {
    return _keyState;
}

inline void keyInfo::setKeyState (uint8 keyState_) {
    set_has_keyState();
    this->_keyState = keyState_;
}

inline void keyInfo::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool keyInfo::hasPidSender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 keyInfo::getPidSender () const {
    return _pidSender;
}

inline void keyInfo::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void keyInfo::clearPidReceiver() {
    if (hasPidReceiver()) {
         clear_has_pidReceiver();
        _pidReceiver = 0u;
     }
}

inline bool keyInfo::hasPidReceiver () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 keyInfo::getPidReceiver () const {
    return _pidReceiver;
}

inline void keyInfo::setPidReceiver (uint32 pidReceiver_) {
    set_has_pidReceiver();
    this->_pidReceiver = pidReceiver_;
}

inline void keyInfo::clearDisplayId() {
    if (hasDisplayId()) {
         clear_has_displayId();
        _displayId = 0u;
     }
}

inline bool keyInfo::hasDisplayId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 keyInfo::getDisplayId () const {
    return _displayId;
}

inline void keyInfo::setDisplayId (uint32 displayId_) {
    set_has_displayId();
    this->_displayId = displayId_;
}

inline void keyInfo::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool keyInfo::hasUserData () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 keyInfo::getUserData () const {
    return _userData;
}

inline void keyInfo::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void keyInfo::set_has_keyCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void keyInfo::clear_has_keyCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void keyInfo::set_has_keyState () {
    _has_bits_[0] |= 1u << 1;
}

inline void keyInfo::clear_has_keyState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void keyInfo::set_has_pidSender () {
    _has_bits_[0] |= 1u << 2;
}

inline void keyInfo::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void keyInfo::set_has_pidReceiver () {
    _has_bits_[0] |= 1u << 3;
}

inline void keyInfo::clear_has_pidReceiver () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void keyInfo::set_has_displayId () {
    _has_bits_[0] |= 1u << 4;
}

inline void keyInfo::clear_has_displayId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void keyInfo::set_has_userData () {
    _has_bits_[0] |= 1u << 5;
}

inline void keyInfo::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  touchInfo::touchInfo ()  :
    _touchState (0u),
    _xPos (0),
    _yPos (0),
    _timeStamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  touchInfo::touchInfo (const touchInfo &rhs)  :
    _touchState (0u),
    _xPos (0),
    _yPos (0),
    _timeStamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  touchInfo::touchInfo (uint8 touchState_, int32 xPos_, int32 yPos_, uint32 timeStamp_)  :
    _touchState (touchState_),
    _xPos (xPos_),
    _yPos (yPos_),
    _timeStamp (timeStamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  touchInfo::~touchInfo() {
}

inline touchInfo& touchInfo::operator = (const touchInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTouchState()) {
            setTouchState(rhs.getTouchState());
        } else {
            clearTouchState();
        }
        if (rhs.hasXPos()) {
            setXPos(rhs.getXPos());
        } else {
            clearXPos();
        }
        if (rhs.hasYPos()) {
            setYPos(rhs.getYPos());
        } else {
            clearYPos();
        }
        if (rhs.hasTimeStamp()) {
            setTimeStamp(rhs.getTimeStamp());
        } else {
            clearTimeStamp();
        }
    }
    return *this;
}

inline bool touchInfo::operator == (const touchInfo& rhs) const {
    return (((!hasTouchState() && !rhs.hasTouchState()) || getTouchState() == rhs.getTouchState()) &&
        ((!hasXPos() && !rhs.hasXPos()) || getXPos() == rhs.getXPos()) &&
        ((!hasYPos() && !rhs.hasYPos()) || getYPos() == rhs.getYPos()) &&
        ((!hasTimeStamp() && !rhs.hasTimeStamp()) || getTimeStamp() == rhs.getTimeStamp()));
}

inline bool touchInfo::operator != (const touchInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool touchInfo::operator < (const touchInfo& rhs) const {
    if (hasTouchState() || rhs.hasTouchState()) {
        if (getTouchState() < rhs.getTouchState()) return true;
        if (getTouchState() > rhs.getTouchState()) return false;
    }
    if (hasXPos() || rhs.hasXPos()) {
        if (getXPos() < rhs.getXPos()) return true;
        if (getXPos() > rhs.getXPos()) return false;
    }
    if (hasYPos() || rhs.hasYPos()) {
        if (getYPos() < rhs.getYPos()) return true;
        if (getYPos() > rhs.getYPos()) return false;
    }
    if (hasTimeStamp() || rhs.hasTimeStamp()) {
        if (getTimeStamp() < rhs.getTimeStamp()) return true;
        if (getTimeStamp() > rhs.getTimeStamp()) return false;
    }
    return false;
}

inline bool touchInfo::operator > (const touchInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void touchInfo::clear() {
    clearTouchState();
    clearXPos();
    clearYPos();
    clearTimeStamp();
}

inline void touchInfo::clearTouchState() {
    if (hasTouchState()) {
         clear_has_touchState();
        _touchState = 0u;
     }
}

inline bool touchInfo::hasTouchState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 touchInfo::getTouchState () const {
    return _touchState;
}

inline void touchInfo::setTouchState (uint8 touchState_) {
    set_has_touchState();
    this->_touchState = touchState_;
}

inline void touchInfo::clearXPos() {
    if (hasXPos()) {
         clear_has_xPos();
        _xPos = 0;
     }
}

inline bool touchInfo::hasXPos () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 touchInfo::getXPos () const {
    return _xPos;
}

inline void touchInfo::setXPos (int32 xPos_) {
    set_has_xPos();
    this->_xPos = xPos_;
}

inline void touchInfo::clearYPos() {
    if (hasYPos()) {
         clear_has_yPos();
        _yPos = 0;
     }
}

inline bool touchInfo::hasYPos () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 touchInfo::getYPos () const {
    return _yPos;
}

inline void touchInfo::setYPos (int32 yPos_) {
    set_has_yPos();
    this->_yPos = yPos_;
}

inline void touchInfo::clearTimeStamp() {
    if (hasTimeStamp()) {
         clear_has_timeStamp();
        _timeStamp = 0u;
     }
}

inline bool touchInfo::hasTimeStamp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 touchInfo::getTimeStamp () const {
    return _timeStamp;
}

inline void touchInfo::setTimeStamp (uint32 timeStamp_) {
    set_has_timeStamp();
    this->_timeStamp = timeStamp_;
}

inline void touchInfo::set_has_touchState () {
    _has_bits_[0] |= 1u << 0;
}

inline void touchInfo::clear_has_touchState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void touchInfo::set_has_xPos () {
    _has_bits_[0] |= 1u << 1;
}

inline void touchInfo::clear_has_xPos () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void touchInfo::set_has_yPos () {
    _has_bits_[0] |= 1u << 2;
}

inline void touchInfo::clear_has_yPos () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void touchInfo::set_has_timeStamp () {
    _has_bits_[0] |= 1u << 3;
}

inline void touchInfo::clear_has_timeStamp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  encoderInfo::encoderInfo ()  :
    _encCode (0),
    _encValue (0),
    _pidSender (0u),
    _pidReceiver (0u),
    _surfaceId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  encoderInfo::encoderInfo (const encoderInfo &rhs)  :
    _encCode (0),
    _encValue (0),
    _pidSender (0u),
    _pidReceiver (0u),
    _surfaceId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  encoderInfo::encoderInfo (int32 encCode_, int32 encValue_, uint32 pidSender_, uint32 pidReceiver_, uint32 surfaceId_, uint32 userData_)  :
    _encCode (encCode_),
    _encValue (encValue_),
    _pidSender (pidSender_),
    _pidReceiver (pidReceiver_),
    _surfaceId (surfaceId_),
    _userData (userData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  encoderInfo::~encoderInfo() {
}

inline encoderInfo& encoderInfo::operator = (const encoderInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEncCode()) {
            setEncCode(rhs.getEncCode());
        } else {
            clearEncCode();
        }
        if (rhs.hasEncValue()) {
            setEncValue(rhs.getEncValue());
        } else {
            clearEncValue();
        }
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasPidReceiver()) {
            setPidReceiver(rhs.getPidReceiver());
        } else {
            clearPidReceiver();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool encoderInfo::operator == (const encoderInfo& rhs) const {
    return (((!hasEncCode() && !rhs.hasEncCode()) || getEncCode() == rhs.getEncCode()) &&
        ((!hasEncValue() && !rhs.hasEncValue()) || getEncValue() == rhs.getEncValue()) &&
        ((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasPidReceiver() && !rhs.hasPidReceiver()) || getPidReceiver() == rhs.getPidReceiver()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool encoderInfo::operator != (const encoderInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool encoderInfo::operator < (const encoderInfo& rhs) const {
    if (hasEncCode() || rhs.hasEncCode()) {
        if (getEncCode() < rhs.getEncCode()) return true;
        if (getEncCode() > rhs.getEncCode()) return false;
    }
    if (hasEncValue() || rhs.hasEncValue()) {
        if (getEncValue() < rhs.getEncValue()) return true;
        if (getEncValue() > rhs.getEncValue()) return false;
    }
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasPidReceiver() || rhs.hasPidReceiver()) {
        if (getPidReceiver() < rhs.getPidReceiver()) return true;
        if (getPidReceiver() > rhs.getPidReceiver()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline bool encoderInfo::operator > (const encoderInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void encoderInfo::clear() {
    clearEncCode();
    clearEncValue();
    clearPidSender();
    clearPidReceiver();
    clearSurfaceId();
    clearUserData();
}

inline void encoderInfo::clearEncCode() {
    if (hasEncCode()) {
         clear_has_encCode();
        _encCode = 0;
     }
}

inline bool encoderInfo::hasEncCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 encoderInfo::getEncCode () const {
    return _encCode;
}

inline void encoderInfo::setEncCode (int32 encCode_) {
    set_has_encCode();
    this->_encCode = encCode_;
}

inline void encoderInfo::clearEncValue() {
    if (hasEncValue()) {
         clear_has_encValue();
        _encValue = 0;
     }
}

inline bool encoderInfo::hasEncValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 encoderInfo::getEncValue () const {
    return _encValue;
}

inline void encoderInfo::setEncValue (int32 encValue_) {
    set_has_encValue();
    this->_encValue = encValue_;
}

inline void encoderInfo::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool encoderInfo::hasPidSender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 encoderInfo::getPidSender () const {
    return _pidSender;
}

inline void encoderInfo::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void encoderInfo::clearPidReceiver() {
    if (hasPidReceiver()) {
         clear_has_pidReceiver();
        _pidReceiver = 0u;
     }
}

inline bool encoderInfo::hasPidReceiver () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 encoderInfo::getPidReceiver () const {
    return _pidReceiver;
}

inline void encoderInfo::setPidReceiver (uint32 pidReceiver_) {
    set_has_pidReceiver();
    this->_pidReceiver = pidReceiver_;
}

inline void encoderInfo::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool encoderInfo::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 encoderInfo::getSurfaceId () const {
    return _surfaceId;
}

inline void encoderInfo::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void encoderInfo::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool encoderInfo::hasUserData () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 encoderInfo::getUserData () const {
    return _userData;
}

inline void encoderInfo::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void encoderInfo::set_has_encCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void encoderInfo::clear_has_encCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void encoderInfo::set_has_encValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void encoderInfo::clear_has_encValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void encoderInfo::set_has_pidSender () {
    _has_bits_[0] |= 1u << 2;
}

inline void encoderInfo::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void encoderInfo::set_has_pidReceiver () {
    _has_bits_[0] |= 1u << 3;
}

inline void encoderInfo::clear_has_pidReceiver () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void encoderInfo::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 4;
}

inline void encoderInfo::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void encoderInfo::set_has_userData () {
    _has_bits_[0] |= 1u << 5;
}

inline void encoderInfo::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  displayData::displayData ()  :
    _pidReceiver (0),
    _senderName (),
    _receiverName (),
    _displayRegion (0),
    _regionType (0),
    _displayRegionStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  displayData::displayData (const displayData &rhs)  :
    _pidReceiver (0),
    _senderName (),
    _receiverName (),
    _displayRegion (0),
    _regionType (0),
    _displayRegionStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  displayData::displayData (int32 pidReceiver_, const ::std::string& senderName_, const ::std::string& receiverName_, int32 displayRegion_, int32 regionType_, int8 displayRegionStatus_)  :
    _pidReceiver (pidReceiver_),
    _senderName (senderName_),
    _receiverName (receiverName_),
    _displayRegion (displayRegion_),
    _regionType (regionType_),
    _displayRegionStatus (displayRegionStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  displayData::~displayData() {
}

inline displayData& displayData::operator = (const displayData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPidReceiver()) {
            setPidReceiver(rhs.getPidReceiver());
        } else {
            clearPidReceiver();
        }
        if (rhs.hasSenderName()) {
            setSenderName(rhs.getSenderName());
        } else {
            clearSenderName();
        }
        if (rhs.hasReceiverName()) {
            setReceiverName(rhs.getReceiverName());
        } else {
            clearReceiverName();
        }
        if (rhs.hasDisplayRegion()) {
            setDisplayRegion(rhs.getDisplayRegion());
        } else {
            clearDisplayRegion();
        }
        if (rhs.hasRegionType()) {
            setRegionType(rhs.getRegionType());
        } else {
            clearRegionType();
        }
        if (rhs.hasDisplayRegionStatus()) {
            setDisplayRegionStatus(rhs.getDisplayRegionStatus());
        } else {
            clearDisplayRegionStatus();
        }
    }
    return *this;
}

inline bool displayData::operator == (const displayData& rhs) const {
    return (((!hasPidReceiver() && !rhs.hasPidReceiver()) || getPidReceiver() == rhs.getPidReceiver()) &&
        ((!hasSenderName() && !rhs.hasSenderName()) || getSenderName() == rhs.getSenderName()) &&
        ((!hasReceiverName() && !rhs.hasReceiverName()) || getReceiverName() == rhs.getReceiverName()) &&
        ((!hasDisplayRegion() && !rhs.hasDisplayRegion()) || getDisplayRegion() == rhs.getDisplayRegion()) &&
        ((!hasRegionType() && !rhs.hasRegionType()) || getRegionType() == rhs.getRegionType()) &&
        ((!hasDisplayRegionStatus() && !rhs.hasDisplayRegionStatus()) || getDisplayRegionStatus() == rhs.getDisplayRegionStatus()));
}

inline bool displayData::operator != (const displayData& rhs) const {
    return ! (*this == rhs);
}

inline bool displayData::operator < (const displayData& rhs) const {
    if (hasPidReceiver() || rhs.hasPidReceiver()) {
        if (getPidReceiver() < rhs.getPidReceiver()) return true;
        if (getPidReceiver() > rhs.getPidReceiver()) return false;
    }
    if (hasSenderName() || rhs.hasSenderName()) {
        if (getSenderName() < rhs.getSenderName()) return true;
        if (getSenderName() > rhs.getSenderName()) return false;
    }
    if (hasReceiverName() || rhs.hasReceiverName()) {
        if (getReceiverName() < rhs.getReceiverName()) return true;
        if (getReceiverName() > rhs.getReceiverName()) return false;
    }
    if (hasDisplayRegion() || rhs.hasDisplayRegion()) {
        if (getDisplayRegion() < rhs.getDisplayRegion()) return true;
        if (getDisplayRegion() > rhs.getDisplayRegion()) return false;
    }
    if (hasRegionType() || rhs.hasRegionType()) {
        if (getRegionType() < rhs.getRegionType()) return true;
        if (getRegionType() > rhs.getRegionType()) return false;
    }
    if (hasDisplayRegionStatus() || rhs.hasDisplayRegionStatus()) {
        if (getDisplayRegionStatus() < rhs.getDisplayRegionStatus()) return true;
        if (getDisplayRegionStatus() > rhs.getDisplayRegionStatus()) return false;
    }
    return false;
}

inline bool displayData::operator > (const displayData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void displayData::clear() {
    clearPidReceiver();
    clearSenderName();
    clearReceiverName();
    clearDisplayRegion();
    clearRegionType();
    clearDisplayRegionStatus();
}

inline void displayData::clearPidReceiver() {
    if (hasPidReceiver()) {
         clear_has_pidReceiver();
        _pidReceiver = 0;
     }
}

inline bool displayData::hasPidReceiver () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 displayData::getPidReceiver () const {
    return _pidReceiver;
}

inline void displayData::setPidReceiver (int32 pidReceiver_) {
    set_has_pidReceiver();
    this->_pidReceiver = pidReceiver_;
}

inline void displayData::clearSenderName() {
    if (hasSenderName()) {
         clear_has_senderName();
        _senderName.clear();
     }
}

inline bool displayData::hasSenderName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& displayData::getSenderName () const {
    return _senderName;
}

inline ::std::string& displayData::getSenderNameMutable () {
    set_has_senderName();
    return _senderName;
}

inline void displayData::setSenderName (const ::std::string& senderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName = senderName_;
}

inline void displayData::setSenderName (const char* senderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName.assign(senderName_);
}

inline void displayData::setSenderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName.assign(value, size);
}

inline void displayData::clearReceiverName() {
    if (hasReceiverName()) {
         clear_has_receiverName();
        _receiverName.clear();
     }
}

inline bool displayData::hasReceiverName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& displayData::getReceiverName () const {
    return _receiverName;
}

inline ::std::string& displayData::getReceiverNameMutable () {
    set_has_receiverName();
    return _receiverName;
}

inline void displayData::setReceiverName (const ::std::string& receiverName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName = receiverName_;
}

inline void displayData::setReceiverName (const char* receiverName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName.assign(receiverName_);
}

inline void displayData::setReceiverName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName.assign(value, size);
}

inline void displayData::clearDisplayRegion() {
    if (hasDisplayRegion()) {
         clear_has_displayRegion();
        _displayRegion = 0;
     }
}

inline bool displayData::hasDisplayRegion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 displayData::getDisplayRegion () const {
    return _displayRegion;
}

inline void displayData::setDisplayRegion (int32 displayRegion_) {
    set_has_displayRegion();
    this->_displayRegion = displayRegion_;
}

inline void displayData::clearRegionType() {
    if (hasRegionType()) {
         clear_has_regionType();
        _regionType = 0;
     }
}

inline bool displayData::hasRegionType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 displayData::getRegionType () const {
    return _regionType;
}

inline void displayData::setRegionType (int32 regionType_) {
    set_has_regionType();
    this->_regionType = regionType_;
}

inline void displayData::clearDisplayRegionStatus() {
    if (hasDisplayRegionStatus()) {
         clear_has_displayRegionStatus();
        _displayRegionStatus = 0;
     }
}

inline bool displayData::hasDisplayRegionStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline int8 displayData::getDisplayRegionStatus () const {
    return _displayRegionStatus;
}

inline void displayData::setDisplayRegionStatus (int8 displayRegionStatus_) {
    set_has_displayRegionStatus();
    this->_displayRegionStatus = displayRegionStatus_;
}

inline void displayData::set_has_pidReceiver () {
    _has_bits_[0] |= 1u << 0;
}

inline void displayData::clear_has_pidReceiver () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void displayData::set_has_senderName () {
    _has_bits_[0] |= 1u << 1;
}

inline void displayData::clear_has_senderName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void displayData::set_has_receiverName () {
    _has_bits_[0] |= 1u << 2;
}

inline void displayData::clear_has_receiverName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void displayData::set_has_displayRegion () {
    _has_bits_[0] |= 1u << 3;
}

inline void displayData::clear_has_displayRegion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void displayData::set_has_regionType () {
    _has_bits_[0] |= 1u << 4;
}

inline void displayData::clear_has_regionType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void displayData::set_has_displayRegionStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void displayData::clear_has_displayRegionStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  MultidisplayData::MultidisplayData ()  :
    _pidReceiver (0),
    _displayid (0u),
    _senderName (),
    _receiverName (),
    _displayRegion (0),
    _regionType (0),
    _displayRegionStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MultidisplayData::MultidisplayData (const MultidisplayData &rhs)  :
    _pidReceiver (0),
    _displayid (0u),
    _senderName (),
    _receiverName (),
    _displayRegion (0),
    _regionType (0),
    _displayRegionStatus (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MultidisplayData::MultidisplayData (int32 pidReceiver_, uint32 displayid_, const ::std::string& senderName_, const ::std::string& receiverName_, int32 displayRegion_, int32 regionType_, int8 displayRegionStatus_)  :
    _pidReceiver (pidReceiver_),
    _displayid (displayid_),
    _senderName (senderName_),
    _receiverName (receiverName_),
    _displayRegion (displayRegion_),
    _regionType (regionType_),
    _displayRegionStatus (displayRegionStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MultidisplayData::~MultidisplayData() {
}

inline MultidisplayData& MultidisplayData::operator = (const MultidisplayData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPidReceiver()) {
            setPidReceiver(rhs.getPidReceiver());
        } else {
            clearPidReceiver();
        }
        if (rhs.hasDisplayid()) {
            setDisplayid(rhs.getDisplayid());
        } else {
            clearDisplayid();
        }
        if (rhs.hasSenderName()) {
            setSenderName(rhs.getSenderName());
        } else {
            clearSenderName();
        }
        if (rhs.hasReceiverName()) {
            setReceiverName(rhs.getReceiverName());
        } else {
            clearReceiverName();
        }
        if (rhs.hasDisplayRegion()) {
            setDisplayRegion(rhs.getDisplayRegion());
        } else {
            clearDisplayRegion();
        }
        if (rhs.hasRegionType()) {
            setRegionType(rhs.getRegionType());
        } else {
            clearRegionType();
        }
        if (rhs.hasDisplayRegionStatus()) {
            setDisplayRegionStatus(rhs.getDisplayRegionStatus());
        } else {
            clearDisplayRegionStatus();
        }
    }
    return *this;
}

inline bool MultidisplayData::operator == (const MultidisplayData& rhs) const {
    return (((!hasPidReceiver() && !rhs.hasPidReceiver()) || getPidReceiver() == rhs.getPidReceiver()) &&
        ((!hasDisplayid() && !rhs.hasDisplayid()) || getDisplayid() == rhs.getDisplayid()) &&
        ((!hasSenderName() && !rhs.hasSenderName()) || getSenderName() == rhs.getSenderName()) &&
        ((!hasReceiverName() && !rhs.hasReceiverName()) || getReceiverName() == rhs.getReceiverName()) &&
        ((!hasDisplayRegion() && !rhs.hasDisplayRegion()) || getDisplayRegion() == rhs.getDisplayRegion()) &&
        ((!hasRegionType() && !rhs.hasRegionType()) || getRegionType() == rhs.getRegionType()) &&
        ((!hasDisplayRegionStatus() && !rhs.hasDisplayRegionStatus()) || getDisplayRegionStatus() == rhs.getDisplayRegionStatus()));
}

inline bool MultidisplayData::operator != (const MultidisplayData& rhs) const {
    return ! (*this == rhs);
}

inline bool MultidisplayData::operator < (const MultidisplayData& rhs) const {
    if (hasPidReceiver() || rhs.hasPidReceiver()) {
        if (getPidReceiver() < rhs.getPidReceiver()) return true;
        if (getPidReceiver() > rhs.getPidReceiver()) return false;
    }
    if (hasDisplayid() || rhs.hasDisplayid()) {
        if (getDisplayid() < rhs.getDisplayid()) return true;
        if (getDisplayid() > rhs.getDisplayid()) return false;
    }
    if (hasSenderName() || rhs.hasSenderName()) {
        if (getSenderName() < rhs.getSenderName()) return true;
        if (getSenderName() > rhs.getSenderName()) return false;
    }
    if (hasReceiverName() || rhs.hasReceiverName()) {
        if (getReceiverName() < rhs.getReceiverName()) return true;
        if (getReceiverName() > rhs.getReceiverName()) return false;
    }
    if (hasDisplayRegion() || rhs.hasDisplayRegion()) {
        if (getDisplayRegion() < rhs.getDisplayRegion()) return true;
        if (getDisplayRegion() > rhs.getDisplayRegion()) return false;
    }
    if (hasRegionType() || rhs.hasRegionType()) {
        if (getRegionType() < rhs.getRegionType()) return true;
        if (getRegionType() > rhs.getRegionType()) return false;
    }
    if (hasDisplayRegionStatus() || rhs.hasDisplayRegionStatus()) {
        if (getDisplayRegionStatus() < rhs.getDisplayRegionStatus()) return true;
        if (getDisplayRegionStatus() > rhs.getDisplayRegionStatus()) return false;
    }
    return false;
}

inline bool MultidisplayData::operator > (const MultidisplayData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MultidisplayData::clear() {
    clearPidReceiver();
    clearDisplayid();
    clearSenderName();
    clearReceiverName();
    clearDisplayRegion();
    clearRegionType();
    clearDisplayRegionStatus();
}

inline void MultidisplayData::clearPidReceiver() {
    if (hasPidReceiver()) {
         clear_has_pidReceiver();
        _pidReceiver = 0;
     }
}

inline bool MultidisplayData::hasPidReceiver () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 MultidisplayData::getPidReceiver () const {
    return _pidReceiver;
}

inline void MultidisplayData::setPidReceiver (int32 pidReceiver_) {
    set_has_pidReceiver();
    this->_pidReceiver = pidReceiver_;
}

inline void MultidisplayData::clearDisplayid() {
    if (hasDisplayid()) {
         clear_has_displayid();
        _displayid = 0u;
     }
}

inline bool MultidisplayData::hasDisplayid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 MultidisplayData::getDisplayid () const {
    return _displayid;
}

inline void MultidisplayData::setDisplayid (uint32 displayid_) {
    set_has_displayid();
    this->_displayid = displayid_;
}

inline void MultidisplayData::clearSenderName() {
    if (hasSenderName()) {
         clear_has_senderName();
        _senderName.clear();
     }
}

inline bool MultidisplayData::hasSenderName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& MultidisplayData::getSenderName () const {
    return _senderName;
}

inline ::std::string& MultidisplayData::getSenderNameMutable () {
    set_has_senderName();
    return _senderName;
}

inline void MultidisplayData::setSenderName (const ::std::string& senderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName = senderName_;
}

inline void MultidisplayData::setSenderName (const char* senderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (senderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName.assign(senderName_);
}

inline void MultidisplayData::setSenderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_senderName();
    this->_senderName.assign(value, size);
}

inline void MultidisplayData::clearReceiverName() {
    if (hasReceiverName()) {
         clear_has_receiverName();
        _receiverName.clear();
     }
}

inline bool MultidisplayData::hasReceiverName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& MultidisplayData::getReceiverName () const {
    return _receiverName;
}

inline ::std::string& MultidisplayData::getReceiverNameMutable () {
    set_has_receiverName();
    return _receiverName;
}

inline void MultidisplayData::setReceiverName (const ::std::string& receiverName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName = receiverName_;
}

inline void MultidisplayData::setReceiverName (const char* receiverName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (receiverName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName.assign(receiverName_);
}

inline void MultidisplayData::setReceiverName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_receiverName();
    this->_receiverName.assign(value, size);
}

inline void MultidisplayData::clearDisplayRegion() {
    if (hasDisplayRegion()) {
         clear_has_displayRegion();
        _displayRegion = 0;
     }
}

inline bool MultidisplayData::hasDisplayRegion () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 MultidisplayData::getDisplayRegion () const {
    return _displayRegion;
}

inline void MultidisplayData::setDisplayRegion (int32 displayRegion_) {
    set_has_displayRegion();
    this->_displayRegion = displayRegion_;
}

inline void MultidisplayData::clearRegionType() {
    if (hasRegionType()) {
         clear_has_regionType();
        _regionType = 0;
     }
}

inline bool MultidisplayData::hasRegionType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline int32 MultidisplayData::getRegionType () const {
    return _regionType;
}

inline void MultidisplayData::setRegionType (int32 regionType_) {
    set_has_regionType();
    this->_regionType = regionType_;
}

inline void MultidisplayData::clearDisplayRegionStatus() {
    if (hasDisplayRegionStatus()) {
         clear_has_displayRegionStatus();
        _displayRegionStatus = 0;
     }
}

inline bool MultidisplayData::hasDisplayRegionStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline int8 MultidisplayData::getDisplayRegionStatus () const {
    return _displayRegionStatus;
}

inline void MultidisplayData::setDisplayRegionStatus (int8 displayRegionStatus_) {
    set_has_displayRegionStatus();
    this->_displayRegionStatus = displayRegionStatus_;
}

inline void MultidisplayData::set_has_pidReceiver () {
    _has_bits_[0] |= 1u << 0;
}

inline void MultidisplayData::clear_has_pidReceiver () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MultidisplayData::set_has_displayid () {
    _has_bits_[0] |= 1u << 1;
}

inline void MultidisplayData::clear_has_displayid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MultidisplayData::set_has_senderName () {
    _has_bits_[0] |= 1u << 2;
}

inline void MultidisplayData::clear_has_senderName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void MultidisplayData::set_has_receiverName () {
    _has_bits_[0] |= 1u << 3;
}

inline void MultidisplayData::clear_has_receiverName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void MultidisplayData::set_has_displayRegion () {
    _has_bits_[0] |= 1u << 4;
}

inline void MultidisplayData::clear_has_displayRegion () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void MultidisplayData::set_has_regionType () {
    _has_bits_[0] |= 1u << 5;
}

inline void MultidisplayData::clear_has_regionType () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void MultidisplayData::set_has_displayRegionStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void MultidisplayData::clear_has_displayRegionStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  ExternalImageData::ExternalImageData ()  :
    _gadgetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceId (0),
    _consumerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExternalImageData::ExternalImageData (const ExternalImageData &rhs)  :
    _gadgetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceId (0),
    _consumerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExternalImageData::ExternalImageData (gadgetStatus gadgetState_, int32 instanceId_, uint32 consumerId_)  :
    _gadgetState (gadgetState_),
    _instanceId (instanceId_),
    _consumerId (consumerId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(gadgetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", gadgetState_, "gadgetStatus", "gadgetState", "ExternalImageData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExternalImageData::~ExternalImageData() {
}

inline ExternalImageData& ExternalImageData::operator = (const ExternalImageData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGadgetState()) {
            setGadgetState(rhs.getGadgetState());
        } else {
            clearGadgetState();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
        if (rhs.hasConsumerId()) {
            setConsumerId(rhs.getConsumerId());
        } else {
            clearConsumerId();
        }
    }
    return *this;
}

inline bool ExternalImageData::operator == (const ExternalImageData& rhs) const {
    return (((!hasGadgetState() && !rhs.hasGadgetState()) || getGadgetState() == rhs.getGadgetState()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()) &&
        ((!hasConsumerId() && !rhs.hasConsumerId()) || getConsumerId() == rhs.getConsumerId()));
}

inline bool ExternalImageData::operator != (const ExternalImageData& rhs) const {
    return ! (*this == rhs);
}

inline bool ExternalImageData::operator < (const ExternalImageData& rhs) const {
    if (hasGadgetState() || rhs.hasGadgetState()) {
        if ((uint32)getGadgetState() < (uint32)rhs.getGadgetState()) return true;
        if ((uint32)getGadgetState() > (uint32)rhs.getGadgetState()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    if (hasConsumerId() || rhs.hasConsumerId()) {
        if (getConsumerId() < rhs.getConsumerId()) return true;
        if (getConsumerId() > rhs.getConsumerId()) return false;
    }
    return false;
}

inline bool ExternalImageData::operator > (const ExternalImageData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExternalImageData::clear() {
    clearGadgetState();
    clearInstanceId();
    clearConsumerId();
}

inline void ExternalImageData::clearGadgetState() {
    if (hasGadgetState()) {
         clear_has_gadgetState();
        _gadgetState = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
     }
}

inline bool ExternalImageData::hasGadgetState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline gadgetStatus ExternalImageData::getGadgetState () const {
    return _gadgetState;
}

inline void ExternalImageData::setGadgetState (gadgetStatus gadgetState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(gadgetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", gadgetState_, "gadgetStatus", "gadgetState", "ExternalImageData");
    }
    set_has_gadgetState();
    this->_gadgetState = gadgetState_;
}

inline void ExternalImageData::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0;
     }
}

inline bool ExternalImageData::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 ExternalImageData::getInstanceId () const {
    return _instanceId;
}

inline void ExternalImageData::setInstanceId (int32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void ExternalImageData::clearConsumerId() {
    if (hasConsumerId()) {
         clear_has_consumerId();
        _consumerId = 0u;
     }
}

inline bool ExternalImageData::hasConsumerId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ExternalImageData::getConsumerId () const {
    return _consumerId;
}

inline void ExternalImageData::setConsumerId (uint32 consumerId_) {
    set_has_consumerId();
    this->_consumerId = consumerId_;
}

inline void ExternalImageData::set_has_gadgetState () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExternalImageData::clear_has_gadgetState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ExternalImageData::set_has_instanceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ExternalImageData::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ExternalImageData::set_has_consumerId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ExternalImageData::clear_has_consumerId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ApplicationState::ApplicationState ()  :
    _pid (0),
    _appState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState__APP_STATE_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ApplicationState::ApplicationState (const ApplicationState &rhs)  :
    _pid (0),
    _appState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState__APP_STATE_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ApplicationState::ApplicationState (int32 pid_, EnumAppState appState_)  :
    _pid (pid_),
    _appState (appState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnumAppState_IsValid(appState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", appState_, "EnumAppState", "appState", "ApplicationState");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ApplicationState::~ApplicationState() {
}

inline ApplicationState& ApplicationState::operator = (const ApplicationState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasAppState()) {
            setAppState(rhs.getAppState());
        } else {
            clearAppState();
        }
    }
    return *this;
}

inline bool ApplicationState::operator == (const ApplicationState& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasAppState() && !rhs.hasAppState()) || getAppState() == rhs.getAppState()));
}

inline bool ApplicationState::operator != (const ApplicationState& rhs) const {
    return ! (*this == rhs);
}

inline bool ApplicationState::operator < (const ApplicationState& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasAppState() || rhs.hasAppState()) {
        if ((uint32)getAppState() < (uint32)rhs.getAppState()) return true;
        if ((uint32)getAppState() > (uint32)rhs.getAppState()) return false;
    }
    return false;
}

inline bool ApplicationState::operator > (const ApplicationState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ApplicationState::clear() {
    clearPid();
    clearAppState();
}

inline void ApplicationState::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool ApplicationState::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 ApplicationState::getPid () const {
    return _pid;
}

inline void ApplicationState::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void ApplicationState::clearAppState() {
    if (hasAppState()) {
         clear_has_appState();
        _appState = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState__APP_STATE_UNKNOWN;
     }
}

inline bool ApplicationState::hasAppState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline EnumAppState ApplicationState::getAppState () const {
    return _appState;
}

inline void ApplicationState::setAppState (EnumAppState appState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnumAppState_IsValid(appState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", appState_, "EnumAppState", "appState", "ApplicationState");
    }
    set_has_appState();
    this->_appState = appState_;
}

inline void ApplicationState::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void ApplicationState::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ApplicationState::set_has_appState () {
    _has_bits_[0] |= 1u << 1;
}

inline void ApplicationState::clear_has_appState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest ()  :
    _pid (0u),
    _name (),
    _state_ (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState__HMIAPP_UNINITIALIZED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest (const UpdateClientStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pid (0u),
    _name (),
    _state_ (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState__HMIAPP_UNINITIALIZED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateClientStatusRequest::UpdateClientStatusRequest (uint32 pid_, const ::std::string& name_, hmiAppState state__)  :
    _pid (pid_),
    _name (name_),
    _state_ (state__)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hmiAppState_IsValid(state__), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", state__, "hmiAppState", "state_", "UpdateClientStatusRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateClientStatusRequest::~UpdateClientStatusRequest() {
}

inline UpdateClientStatusRequest& UpdateClientStatusRequest::operator = (const UpdateClientStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasState_()) {
            setState_(rhs.getState_());
        } else {
            clearState_();
        }
    }
    return *this;
}

inline bool UpdateClientStatusRequest::operator == (const UpdateClientStatusRequest& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasState_() && !rhs.hasState_()) || getState_() == rhs.getState_()));
}

inline bool UpdateClientStatusRequest::operator != (const UpdateClientStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateClientStatusRequest::operator < (const UpdateClientStatusRequest& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasState_() || rhs.hasState_()) {
        if ((uint32)getState_() < (uint32)rhs.getState_()) return true;
        if ((uint32)getState_() > (uint32)rhs.getState_()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateClientStatusRequest::clone() {
    return new UpdateClientStatusRequest(*this);
}

inline bool UpdateClientStatusRequest::operator > (const UpdateClientStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateClientStatusRequest::clear() {
    clearPid();
    clearName();
    clearState_();
}

inline void UpdateClientStatusRequest::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0u;
     }
}

inline bool UpdateClientStatusRequest::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 UpdateClientStatusRequest::getPid () const {
    return _pid;
}

inline void UpdateClientStatusRequest::setPid (uint32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void UpdateClientStatusRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool UpdateClientStatusRequest::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UpdateClientStatusRequest::getName () const {
    return _name;
}

inline ::std::string& UpdateClientStatusRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void UpdateClientStatusRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void UpdateClientStatusRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void UpdateClientStatusRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void UpdateClientStatusRequest::clearState_() {
    if (hasState_()) {
         clear_has_state_();
        _state_ = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState__HMIAPP_UNINITIALIZED;
     }
}

inline bool UpdateClientStatusRequest::hasState_ () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline hmiAppState UpdateClientStatusRequest::getState_ () const {
    return _state_;
}

inline void UpdateClientStatusRequest::setState_ (hmiAppState state__) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hmiAppState_IsValid(state__), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", state__, "hmiAppState", "state_", "UpdateClientStatusRequest");
    }
    set_has_state_();
    this->_state_ = state__;
}

inline void UpdateClientStatusRequest::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateClientStatusRequest::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateClientStatusRequest::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateClientStatusRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateClientStatusRequest::set_has_state_ () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateClientStatusRequest::clear_has_state_ () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  KeyForwardingRequest::KeyForwardingRequest ()  :
    _keyRequest ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyForwardingRequest::KeyForwardingRequest (const KeyForwardingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _keyRequest ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyForwardingRequest::KeyForwardingRequest (const keyInfo& keyRequest_)  :
    _keyRequest (keyRequest_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyForwardingRequest::~KeyForwardingRequest() {
}

inline KeyForwardingRequest& KeyForwardingRequest::operator = (const KeyForwardingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyRequest()) {
            setKeyRequest(rhs.getKeyRequest());
        } else {
            clearKeyRequest();
        }
    }
    return *this;
}

inline bool KeyForwardingRequest::operator == (const KeyForwardingRequest& rhs) const {
    return (((!hasKeyRequest() && !rhs.hasKeyRequest()) || getKeyRequest() == rhs.getKeyRequest()));
}

inline bool KeyForwardingRequest::operator != (const KeyForwardingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyForwardingRequest::operator < (const KeyForwardingRequest& rhs) const {
    if (hasKeyRequest() || rhs.hasKeyRequest()) {
        if (getKeyRequest() < rhs.getKeyRequest()) return true;
        if (getKeyRequest() > rhs.getKeyRequest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyForwardingRequest::clone() {
    return new KeyForwardingRequest(*this);
}

inline bool KeyForwardingRequest::operator > (const KeyForwardingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyForwardingRequest::clear() {
    clearKeyRequest();
}

inline void KeyForwardingRequest::clearKeyRequest() {
    if (hasKeyRequest()) {
         clear_has_keyRequest();
        _keyRequest.clear();
     }
}

inline bool KeyForwardingRequest::hasKeyRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const keyInfo& KeyForwardingRequest::getKeyRequest () const {
    return _keyRequest;
}

inline keyInfo& KeyForwardingRequest::getKeyRequestMutable () {
    set_has_keyRequest();
    return _keyRequest;
}

inline void KeyForwardingRequest::setKeyRequest (const keyInfo& keyRequest_) {
    set_has_keyRequest();
    this->_keyRequest = keyRequest_;
}

inline void KeyForwardingRequest::set_has_keyRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyForwardingRequest::clear_has_keyRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderForwardingRequest::EncoderForwardingRequest ()  :
    _encoderRequest ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderForwardingRequest::EncoderForwardingRequest (const EncoderForwardingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _encoderRequest ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderForwardingRequest::EncoderForwardingRequest (const encoderInfo& encoderRequest_)  :
    _encoderRequest (encoderRequest_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderForwardingRequest::~EncoderForwardingRequest() {
}

inline EncoderForwardingRequest& EncoderForwardingRequest::operator = (const EncoderForwardingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEncoderRequest()) {
            setEncoderRequest(rhs.getEncoderRequest());
        } else {
            clearEncoderRequest();
        }
    }
    return *this;
}

inline bool EncoderForwardingRequest::operator == (const EncoderForwardingRequest& rhs) const {
    return (((!hasEncoderRequest() && !rhs.hasEncoderRequest()) || getEncoderRequest() == rhs.getEncoderRequest()));
}

inline bool EncoderForwardingRequest::operator != (const EncoderForwardingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderForwardingRequest::operator < (const EncoderForwardingRequest& rhs) const {
    if (hasEncoderRequest() || rhs.hasEncoderRequest()) {
        if (getEncoderRequest() < rhs.getEncoderRequest()) return true;
        if (getEncoderRequest() > rhs.getEncoderRequest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EncoderForwardingRequest::clone() {
    return new EncoderForwardingRequest(*this);
}

inline bool EncoderForwardingRequest::operator > (const EncoderForwardingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderForwardingRequest::clear() {
    clearEncoderRequest();
}

inline void EncoderForwardingRequest::clearEncoderRequest() {
    if (hasEncoderRequest()) {
         clear_has_encoderRequest();
        _encoderRequest.clear();
     }
}

inline bool EncoderForwardingRequest::hasEncoderRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const encoderInfo& EncoderForwardingRequest::getEncoderRequest () const {
    return _encoderRequest;
}

inline encoderInfo& EncoderForwardingRequest::getEncoderRequestMutable () {
    set_has_encoderRequest();
    return _encoderRequest;
}

inline void EncoderForwardingRequest::setEncoderRequest (const encoderInfo& encoderRequest_) {
    set_has_encoderRequest();
    this->_encoderRequest = encoderRequest_;
}

inline void EncoderForwardingRequest::set_has_encoderRequest () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderForwardingRequest::clear_has_encoderRequest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BeepForwardingRequest::BeepForwardingRequest ()  :
    _beepType (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeepForwardingRequest::BeepForwardingRequest (const BeepForwardingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _beepType (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeepForwardingRequest::BeepForwardingRequest (int32 beepType_)  :
    _beepType (beepType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BeepForwardingRequest::~BeepForwardingRequest() {
}

inline BeepForwardingRequest& BeepForwardingRequest::operator = (const BeepForwardingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBeepType()) {
            setBeepType(rhs.getBeepType());
        } else {
            clearBeepType();
        }
    }
    return *this;
}

inline bool BeepForwardingRequest::operator == (const BeepForwardingRequest& rhs) const {
    return (((!hasBeepType() && !rhs.hasBeepType()) || getBeepType() == rhs.getBeepType()));
}

inline bool BeepForwardingRequest::operator != (const BeepForwardingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BeepForwardingRequest::operator < (const BeepForwardingRequest& rhs) const {
    if (hasBeepType() || rhs.hasBeepType()) {
        if (getBeepType() < rhs.getBeepType()) return true;
        if (getBeepType() > rhs.getBeepType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BeepForwardingRequest::clone() {
    return new BeepForwardingRequest(*this);
}

inline bool BeepForwardingRequest::operator > (const BeepForwardingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeepForwardingRequest::clear() {
    clearBeepType();
}

inline void BeepForwardingRequest::clearBeepType() {
    if (hasBeepType()) {
         clear_has_beepType();
        _beepType = 0;
     }
}

inline bool BeepForwardingRequest::hasBeepType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 BeepForwardingRequest::getBeepType () const {
    return _beepType;
}

inline void BeepForwardingRequest::setBeepType (int32 beepType_) {
    set_has_beepType();
    this->_beepType = beepType_;
}

inline void BeepForwardingRequest::set_has_beepType () {
    _has_bits_[0] |= 1u << 0;
}

inline void BeepForwardingRequest::clear_has_beepType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetApplicationMandatoryRequest::SetApplicationMandatoryRequest ()  :
    _name (),
    _value (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetApplicationMandatoryRequest::SetApplicationMandatoryRequest (const SetApplicationMandatoryRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetApplicationMandatoryRequest::SetApplicationMandatoryRequest (const ::std::string& name_, bool value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetApplicationMandatoryRequest::~SetApplicationMandatoryRequest() {
}

inline SetApplicationMandatoryRequest& SetApplicationMandatoryRequest::operator = (const SetApplicationMandatoryRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetApplicationMandatoryRequest::operator == (const SetApplicationMandatoryRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetApplicationMandatoryRequest::operator != (const SetApplicationMandatoryRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetApplicationMandatoryRequest::operator < (const SetApplicationMandatoryRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetApplicationMandatoryRequest::clone() {
    return new SetApplicationMandatoryRequest(*this);
}

inline bool SetApplicationMandatoryRequest::operator > (const SetApplicationMandatoryRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetApplicationMandatoryRequest::clear() {
    clearName();
    clearValue();
}

inline void SetApplicationMandatoryRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool SetApplicationMandatoryRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetApplicationMandatoryRequest::getName () const {
    return _name;
}

inline ::std::string& SetApplicationMandatoryRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void SetApplicationMandatoryRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void SetApplicationMandatoryRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void SetApplicationMandatoryRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void SetApplicationMandatoryRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = false;
     }
}

inline bool SetApplicationMandatoryRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetApplicationMandatoryRequest::getValue () const {
    return _value;
}

inline void SetApplicationMandatoryRequest::setValue (bool value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetApplicationMandatoryRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetApplicationMandatoryRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetApplicationMandatoryRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetApplicationMandatoryRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DisplayCmdRequest::DisplayCmdRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayCmdRequest::DisplayCmdRequest (const DisplayCmdRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayCmdRequest::DisplayCmdRequest (const displayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayCmdRequest::~DisplayCmdRequest() {
}

inline DisplayCmdRequest& DisplayCmdRequest::operator = (const DisplayCmdRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool DisplayCmdRequest::operator == (const DisplayCmdRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool DisplayCmdRequest::operator != (const DisplayCmdRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayCmdRequest::operator < (const DisplayCmdRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayCmdRequest::clone() {
    return new DisplayCmdRequest(*this);
}

inline bool DisplayCmdRequest::operator > (const DisplayCmdRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayCmdRequest::clear() {
    clearData();
}

inline void DisplayCmdRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool DisplayCmdRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const displayData& DisplayCmdRequest::getData () const {
    return _data;
}

inline displayData& DisplayCmdRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void DisplayCmdRequest::setData (const displayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void DisplayCmdRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayCmdRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MultiDisplayCmdRequest::MultiDisplayCmdRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MultiDisplayCmdRequest::MultiDisplayCmdRequest (const MultiDisplayCmdRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MultiDisplayCmdRequest::MultiDisplayCmdRequest (const MultidisplayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MultiDisplayCmdRequest::~MultiDisplayCmdRequest() {
}

inline MultiDisplayCmdRequest& MultiDisplayCmdRequest::operator = (const MultiDisplayCmdRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool MultiDisplayCmdRequest::operator == (const MultiDisplayCmdRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool MultiDisplayCmdRequest::operator != (const MultiDisplayCmdRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MultiDisplayCmdRequest::operator < (const MultiDisplayCmdRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MultiDisplayCmdRequest::clone() {
    return new MultiDisplayCmdRequest(*this);
}

inline bool MultiDisplayCmdRequest::operator > (const MultiDisplayCmdRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MultiDisplayCmdRequest::clear() {
    clearData();
}

inline void MultiDisplayCmdRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool MultiDisplayCmdRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const MultidisplayData& MultiDisplayCmdRequest::getData () const {
    return _data;
}

inline MultidisplayData& MultiDisplayCmdRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void MultiDisplayCmdRequest::setData (const MultidisplayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void MultiDisplayCmdRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void MultiDisplayCmdRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayStatusEvalRequest::DisplayStatusEvalRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayStatusEvalRequest::DisplayStatusEvalRequest (const DisplayStatusEvalRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayStatusEvalRequest::DisplayStatusEvalRequest (const MultidisplayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayStatusEvalRequest::~DisplayStatusEvalRequest() {
}

inline DisplayStatusEvalRequest& DisplayStatusEvalRequest::operator = (const DisplayStatusEvalRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool DisplayStatusEvalRequest::operator == (const DisplayStatusEvalRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool DisplayStatusEvalRequest::operator != (const DisplayStatusEvalRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayStatusEvalRequest::operator < (const DisplayStatusEvalRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayStatusEvalRequest::clone() {
    return new DisplayStatusEvalRequest(*this);
}

inline bool DisplayStatusEvalRequest::operator > (const DisplayStatusEvalRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayStatusEvalRequest::clear() {
    clearData();
}

inline void DisplayStatusEvalRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool DisplayStatusEvalRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const MultidisplayData& DisplayStatusEvalRequest::getData () const {
    return _data;
}

inline MultidisplayData& DisplayStatusEvalRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void DisplayStatusEvalRequest::setData (const MultidisplayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void DisplayStatusEvalRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayStatusEvalRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestExternalImageProviderActivationRequest::RequestExternalImageProviderActivationRequest ()  :
    _targetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceIds (),
    _consumerId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestExternalImageProviderActivationRequest::RequestExternalImageProviderActivationRequest (const RequestExternalImageProviderActivationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _targetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceIds (),
    _consumerId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestExternalImageProviderActivationRequest::RequestExternalImageProviderActivationRequest (gadgetStatus targetState_, const ::std::vector< int32 >& instanceIds_, int32 consumerId_)  :
    _targetState (targetState_),
    _instanceIds (instanceIds_),
    _consumerId (consumerId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(targetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetState_, "gadgetStatus", "targetState", "RequestExternalImageProviderActivationRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestExternalImageProviderActivationRequest::~RequestExternalImageProviderActivationRequest() {
}

inline RequestExternalImageProviderActivationRequest& RequestExternalImageProviderActivationRequest::operator = (const RequestExternalImageProviderActivationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetState()) {
            setTargetState(rhs.getTargetState());
        } else {
            clearTargetState();
        }
        if (rhs.hasInstanceIds()) {
            setInstanceIds(rhs.getInstanceIds());
        } else {
            clearInstanceIds();
        }
        if (rhs.hasConsumerId()) {
            setConsumerId(rhs.getConsumerId());
        } else {
            clearConsumerId();
        }
    }
    return *this;
}

inline bool RequestExternalImageProviderActivationRequest::operator == (const RequestExternalImageProviderActivationRequest& rhs) const {
    return (((!hasTargetState() && !rhs.hasTargetState()) || getTargetState() == rhs.getTargetState()) &&
        ((!hasInstanceIds() && !rhs.hasInstanceIds()) || getInstanceIds() == rhs.getInstanceIds()) &&
        ((!hasConsumerId() && !rhs.hasConsumerId()) || getConsumerId() == rhs.getConsumerId()));
}

inline bool RequestExternalImageProviderActivationRequest::operator != (const RequestExternalImageProviderActivationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestExternalImageProviderActivationRequest::operator < (const RequestExternalImageProviderActivationRequest& rhs) const {
    if (hasTargetState() || rhs.hasTargetState()) {
        if ((uint32)getTargetState() < (uint32)rhs.getTargetState()) return true;
        if ((uint32)getTargetState() > (uint32)rhs.getTargetState()) return false;
    }
    if (hasInstanceIds() || rhs.hasInstanceIds()) {
        if (getInstanceIds() < rhs.getInstanceIds()) return true;
        if (getInstanceIds() > rhs.getInstanceIds()) return false;
    }
    if (hasConsumerId() || rhs.hasConsumerId()) {
        if (getConsumerId() < rhs.getConsumerId()) return true;
        if (getConsumerId() > rhs.getConsumerId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestExternalImageProviderActivationRequest::clone() {
    return new RequestExternalImageProviderActivationRequest(*this);
}

inline bool RequestExternalImageProviderActivationRequest::operator > (const RequestExternalImageProviderActivationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestExternalImageProviderActivationRequest::clear() {
    clearTargetState();
    clearInstanceIds();
    clearConsumerId();
}

inline void RequestExternalImageProviderActivationRequest::clearTargetState() {
    if (hasTargetState()) {
         clear_has_targetState();
        _targetState = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
     }
}

inline bool RequestExternalImageProviderActivationRequest::hasTargetState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline gadgetStatus RequestExternalImageProviderActivationRequest::getTargetState () const {
    return _targetState;
}

inline void RequestExternalImageProviderActivationRequest::setTargetState (gadgetStatus targetState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(targetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetState_, "gadgetStatus", "targetState", "RequestExternalImageProviderActivationRequest");
    }
    set_has_targetState();
    this->_targetState = targetState_;
}

inline void RequestExternalImageProviderActivationRequest::clearInstanceIds() {
    if (hasInstanceIds()) {
         clear_has_instanceIds();
        _instanceIds.clear();
     }
}

inline bool RequestExternalImageProviderActivationRequest::hasInstanceIds () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< int32 >& RequestExternalImageProviderActivationRequest::getInstanceIds () const {
    return _instanceIds;
}

inline ::std::vector< int32 >& RequestExternalImageProviderActivationRequest::getInstanceIdsMutable () {
    set_has_instanceIds();
    return _instanceIds;
}

inline void RequestExternalImageProviderActivationRequest::setInstanceIds (const ::std::vector< int32 >& instanceIds_) {
    set_has_instanceIds();
    this->_instanceIds = instanceIds_;
}

inline void RequestExternalImageProviderActivationRequest::clearConsumerId() {
    if (hasConsumerId()) {
         clear_has_consumerId();
        _consumerId = 0;
     }
}

inline bool RequestExternalImageProviderActivationRequest::hasConsumerId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 RequestExternalImageProviderActivationRequest::getConsumerId () const {
    return _consumerId;
}

inline void RequestExternalImageProviderActivationRequest::setConsumerId (int32 consumerId_) {
    set_has_consumerId();
    this->_consumerId = consumerId_;
}

inline void RequestExternalImageProviderActivationRequest::set_has_targetState () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestExternalImageProviderActivationRequest::clear_has_targetState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestExternalImageProviderActivationRequest::set_has_instanceIds () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestExternalImageProviderActivationRequest::clear_has_instanceIds () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestExternalImageProviderActivationRequest::set_has_consumerId () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestExternalImageProviderActivationRequest::clear_has_consumerId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RequestExternalImageProviderTouchRequest::RequestExternalImageProviderTouchRequest ()  :
    _pidSender (0u),
    _data (),
    _instanceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestExternalImageProviderTouchRequest::RequestExternalImageProviderTouchRequest (const RequestExternalImageProviderTouchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _data (),
    _instanceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestExternalImageProviderTouchRequest::RequestExternalImageProviderTouchRequest (uint32 pidSender_, const touchInfo& data_, int32 instanceId_)  :
    _pidSender (pidSender_),
    _data (data_),
    _instanceId (instanceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestExternalImageProviderTouchRequest::~RequestExternalImageProviderTouchRequest() {
}

inline RequestExternalImageProviderTouchRequest& RequestExternalImageProviderTouchRequest::operator = (const RequestExternalImageProviderTouchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
    }
    return *this;
}

inline bool RequestExternalImageProviderTouchRequest::operator == (const RequestExternalImageProviderTouchRequest& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()));
}

inline bool RequestExternalImageProviderTouchRequest::operator != (const RequestExternalImageProviderTouchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestExternalImageProviderTouchRequest::operator < (const RequestExternalImageProviderTouchRequest& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestExternalImageProviderTouchRequest::clone() {
    return new RequestExternalImageProviderTouchRequest(*this);
}

inline bool RequestExternalImageProviderTouchRequest::operator > (const RequestExternalImageProviderTouchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestExternalImageProviderTouchRequest::clear() {
    clearPidSender();
    clearData();
    clearInstanceId();
}

inline void RequestExternalImageProviderTouchRequest::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool RequestExternalImageProviderTouchRequest::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestExternalImageProviderTouchRequest::getPidSender () const {
    return _pidSender;
}

inline void RequestExternalImageProviderTouchRequest::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void RequestExternalImageProviderTouchRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool RequestExternalImageProviderTouchRequest::hasData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const touchInfo& RequestExternalImageProviderTouchRequest::getData () const {
    return _data;
}

inline touchInfo& RequestExternalImageProviderTouchRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void RequestExternalImageProviderTouchRequest::setData (const touchInfo& data_) {
    set_has_data();
    this->_data = data_;
}

inline void RequestExternalImageProviderTouchRequest::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0;
     }
}

inline bool RequestExternalImageProviderTouchRequest::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 RequestExternalImageProviderTouchRequest::getInstanceId () const {
    return _instanceId;
}

inline void RequestExternalImageProviderTouchRequest::setInstanceId (int32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void RequestExternalImageProviderTouchRequest::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestExternalImageProviderTouchRequest::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestExternalImageProviderTouchRequest::set_has_data () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestExternalImageProviderTouchRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestExternalImageProviderTouchRequest::set_has_instanceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestExternalImageProviderTouchRequest::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RequestSlaveSurfaceRepositioningRequest::RequestSlaveSurfaceRepositioningRequest ()  :
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestSlaveSurfaceRepositioningRequest::RequestSlaveSurfaceRepositioningRequest (const RequestSlaveSurfaceRepositioningRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestSlaveSurfaceRepositioningRequest::RequestSlaveSurfaceRepositioningRequest (uint32 pidSender_, bool activate_, uint32 surfaceId_)  :
    _pidSender (pidSender_),
    _activate (activate_),
    _surfaceId (surfaceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestSlaveSurfaceRepositioningRequest::~RequestSlaveSurfaceRepositioningRequest() {
}

inline RequestSlaveSurfaceRepositioningRequest& RequestSlaveSurfaceRepositioningRequest::operator = (const RequestSlaveSurfaceRepositioningRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasActivate()) {
            setActivate(rhs.getActivate());
        } else {
            clearActivate();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
    }
    return *this;
}

inline bool RequestSlaveSurfaceRepositioningRequest::operator == (const RequestSlaveSurfaceRepositioningRequest& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasActivate() && !rhs.hasActivate()) || getActivate() == rhs.getActivate()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()));
}

inline bool RequestSlaveSurfaceRepositioningRequest::operator != (const RequestSlaveSurfaceRepositioningRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestSlaveSurfaceRepositioningRequest::operator < (const RequestSlaveSurfaceRepositioningRequest& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasActivate() || rhs.hasActivate()) {
        if (getActivate() < rhs.getActivate()) return true;
        if (getActivate() > rhs.getActivate()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestSlaveSurfaceRepositioningRequest::clone() {
    return new RequestSlaveSurfaceRepositioningRequest(*this);
}

inline bool RequestSlaveSurfaceRepositioningRequest::operator > (const RequestSlaveSurfaceRepositioningRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestSlaveSurfaceRepositioningRequest::clear() {
    clearPidSender();
    clearActivate();
    clearSurfaceId();
}

inline void RequestSlaveSurfaceRepositioningRequest::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool RequestSlaveSurfaceRepositioningRequest::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestSlaveSurfaceRepositioningRequest::getPidSender () const {
    return _pidSender;
}

inline void RequestSlaveSurfaceRepositioningRequest::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void RequestSlaveSurfaceRepositioningRequest::clearActivate() {
    if (hasActivate()) {
         clear_has_activate();
        _activate = false;
     }
}

inline bool RequestSlaveSurfaceRepositioningRequest::hasActivate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool RequestSlaveSurfaceRepositioningRequest::getActivate () const {
    return _activate;
}

inline void RequestSlaveSurfaceRepositioningRequest::setActivate (bool activate_) {
    set_has_activate();
    this->_activate = activate_;
}

inline void RequestSlaveSurfaceRepositioningRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool RequestSlaveSurfaceRepositioningRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RequestSlaveSurfaceRepositioningRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void RequestSlaveSurfaceRepositioningRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void RequestSlaveSurfaceRepositioningRequest::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestSlaveSurfaceRepositioningRequest::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestSlaveSurfaceRepositioningRequest::set_has_activate () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestSlaveSurfaceRepositioningRequest::clear_has_activate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestSlaveSurfaceRepositioningRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestSlaveSurfaceRepositioningRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ResponseSlaveSurfaceRepositioningRequest::ResponseSlaveSurfaceRepositioningRequest ()  :
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResponseSlaveSurfaceRepositioningRequest::ResponseSlaveSurfaceRepositioningRequest (const ResponseSlaveSurfaceRepositioningRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResponseSlaveSurfaceRepositioningRequest::ResponseSlaveSurfaceRepositioningRequest (uint32 pidSender_, bool activate_, uint32 surfaceId_, bool status_)  :
    _pidSender (pidSender_),
    _activate (activate_),
    _surfaceId (surfaceId_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResponseSlaveSurfaceRepositioningRequest::~ResponseSlaveSurfaceRepositioningRequest() {
}

inline ResponseSlaveSurfaceRepositioningRequest& ResponseSlaveSurfaceRepositioningRequest::operator = (const ResponseSlaveSurfaceRepositioningRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasActivate()) {
            setActivate(rhs.getActivate());
        } else {
            clearActivate();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ResponseSlaveSurfaceRepositioningRequest::operator == (const ResponseSlaveSurfaceRepositioningRequest& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasActivate() && !rhs.hasActivate()) || getActivate() == rhs.getActivate()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ResponseSlaveSurfaceRepositioningRequest::operator != (const ResponseSlaveSurfaceRepositioningRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ResponseSlaveSurfaceRepositioningRequest::operator < (const ResponseSlaveSurfaceRepositioningRequest& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasActivate() || rhs.hasActivate()) {
        if (getActivate() < rhs.getActivate()) return true;
        if (getActivate() > rhs.getActivate()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResponseSlaveSurfaceRepositioningRequest::clone() {
    return new ResponseSlaveSurfaceRepositioningRequest(*this);
}

inline bool ResponseSlaveSurfaceRepositioningRequest::operator > (const ResponseSlaveSurfaceRepositioningRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResponseSlaveSurfaceRepositioningRequest::clear() {
    clearPidSender();
    clearActivate();
    clearSurfaceId();
    clearStatus();
}

inline void ResponseSlaveSurfaceRepositioningRequest::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool ResponseSlaveSurfaceRepositioningRequest::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ResponseSlaveSurfaceRepositioningRequest::getPidSender () const {
    return _pidSender;
}

inline void ResponseSlaveSurfaceRepositioningRequest::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clearActivate() {
    if (hasActivate()) {
         clear_has_activate();
        _activate = false;
     }
}

inline bool ResponseSlaveSurfaceRepositioningRequest::hasActivate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool ResponseSlaveSurfaceRepositioningRequest::getActivate () const {
    return _activate;
}

inline void ResponseSlaveSurfaceRepositioningRequest::setActivate (bool activate_) {
    set_has_activate();
    this->_activate = activate_;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool ResponseSlaveSurfaceRepositioningRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ResponseSlaveSurfaceRepositioningRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void ResponseSlaveSurfaceRepositioningRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool ResponseSlaveSurfaceRepositioningRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool ResponseSlaveSurfaceRepositioningRequest::getStatus () const {
    return _status;
}

inline void ResponseSlaveSurfaceRepositioningRequest::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void ResponseSlaveSurfaceRepositioningRequest::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ResponseSlaveSurfaceRepositioningRequest::set_has_activate () {
    _has_bits_[0] |= 1u << 1;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clear_has_activate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ResponseSlaveSurfaceRepositioningRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ResponseSlaveSurfaceRepositioningRequest::set_has_status () {
    _has_bits_[0] |= 1u << 3;
}

inline void ResponseSlaveSurfaceRepositioningRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RequestDirectTextureConsumerPositionInfoRequest::RequestDirectTextureConsumerPositionInfoRequest ()  :
    _pidSender (0u),
    _instanceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestDirectTextureConsumerPositionInfoRequest::RequestDirectTextureConsumerPositionInfoRequest (const RequestDirectTextureConsumerPositionInfoRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _instanceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestDirectTextureConsumerPositionInfoRequest::RequestDirectTextureConsumerPositionInfoRequest (uint32 pidSender_, uint32 instanceId_)  :
    _pidSender (pidSender_),
    _instanceId (instanceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestDirectTextureConsumerPositionInfoRequest::~RequestDirectTextureConsumerPositionInfoRequest() {
}

inline RequestDirectTextureConsumerPositionInfoRequest& RequestDirectTextureConsumerPositionInfoRequest::operator = (const RequestDirectTextureConsumerPositionInfoRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
    }
    return *this;
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::operator == (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()));
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::operator != (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::operator < (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestDirectTextureConsumerPositionInfoRequest::clone() {
    return new RequestDirectTextureConsumerPositionInfoRequest(*this);
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::operator > (const RequestDirectTextureConsumerPositionInfoRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestDirectTextureConsumerPositionInfoRequest::clear() {
    clearPidSender();
    clearInstanceId();
}

inline void RequestDirectTextureConsumerPositionInfoRequest::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestDirectTextureConsumerPositionInfoRequest::getPidSender () const {
    return _pidSender;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0u;
     }
}

inline bool RequestDirectTextureConsumerPositionInfoRequest::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestDirectTextureConsumerPositionInfoRequest::getInstanceId () const {
    return _instanceId;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::setInstanceId (uint32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestDirectTextureConsumerPositionInfoRequest::set_has_instanceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestDirectTextureConsumerPositionInfoRequest::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ResponseDirectTextureConsumerPositionInfoRequest::ResponseDirectTextureConsumerPositionInfoRequest ()  :
    _pidSender (0u),
    _instanceId (0u),
    _xPos (0.0f),
    _yPos (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResponseDirectTextureConsumerPositionInfoRequest::ResponseDirectTextureConsumerPositionInfoRequest (const ResponseDirectTextureConsumerPositionInfoRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _instanceId (0u),
    _xPos (0.0f),
    _yPos (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResponseDirectTextureConsumerPositionInfoRequest::ResponseDirectTextureConsumerPositionInfoRequest (uint32 pidSender_, uint32 instanceId_, float xPos_, float yPos_)  :
    _pidSender (pidSender_),
    _instanceId (instanceId_),
    _xPos (xPos_),
    _yPos (yPos_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResponseDirectTextureConsumerPositionInfoRequest::~ResponseDirectTextureConsumerPositionInfoRequest() {
}

inline ResponseDirectTextureConsumerPositionInfoRequest& ResponseDirectTextureConsumerPositionInfoRequest::operator = (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
        if (rhs.hasXPos()) {
            setXPos(rhs.getXPos());
        } else {
            clearXPos();
        }
        if (rhs.hasYPos()) {
            setYPos(rhs.getYPos());
        } else {
            clearYPos();
        }
    }
    return *this;
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::operator == (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()) &&
        ((!hasXPos() && !rhs.hasXPos()) || getXPos() == rhs.getXPos()) &&
        ((!hasYPos() && !rhs.hasYPos()) || getYPos() == rhs.getYPos()));
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::operator != (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::operator < (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    if (hasXPos() || rhs.hasXPos()) {
        if (getXPos() < rhs.getXPos()) return true;
        if (getXPos() > rhs.getXPos()) return false;
    }
    if (hasYPos() || rhs.hasYPos()) {
        if (getYPos() < rhs.getYPos()) return true;
        if (getYPos() > rhs.getYPos()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResponseDirectTextureConsumerPositionInfoRequest::clone() {
    return new ResponseDirectTextureConsumerPositionInfoRequest(*this);
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::operator > (const ResponseDirectTextureConsumerPositionInfoRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clear() {
    clearPidSender();
    clearInstanceId();
    clearXPos();
    clearYPos();
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ResponseDirectTextureConsumerPositionInfoRequest::getPidSender () const {
    return _pidSender;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0u;
     }
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ResponseDirectTextureConsumerPositionInfoRequest::getInstanceId () const {
    return _instanceId;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::setInstanceId (uint32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clearXPos() {
    if (hasXPos()) {
         clear_has_xPos();
        _xPos = 0.0f;
     }
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::hasXPos () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float ResponseDirectTextureConsumerPositionInfoRequest::getXPos () const {
    return _xPos;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::setXPos (float xPos_) {
    set_has_xPos();
    this->_xPos = xPos_;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clearYPos() {
    if (hasYPos()) {
         clear_has_yPos();
        _yPos = 0.0f;
     }
}

inline bool ResponseDirectTextureConsumerPositionInfoRequest::hasYPos () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float ResponseDirectTextureConsumerPositionInfoRequest::getYPos () const {
    return _yPos;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::setYPos (float yPos_) {
    set_has_yPos();
    this->_yPos = yPos_;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::set_has_instanceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::set_has_xPos () {
    _has_bits_[0] |= 1u << 2;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clear_has_xPos () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::set_has_yPos () {
    _has_bits_[0] |= 1u << 3;
}

inline void ResponseDirectTextureConsumerPositionInfoRequest::clear_has_yPos () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ApplicationRenderedUpdateRequest::ApplicationRenderedUpdateRequest ()  :
    _surfaceid (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ApplicationRenderedUpdateRequest::ApplicationRenderedUpdateRequest (const ApplicationRenderedUpdateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _surfaceid (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ApplicationRenderedUpdateRequest::ApplicationRenderedUpdateRequest (int32 surfaceid_)  :
    _surfaceid (surfaceid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ApplicationRenderedUpdateRequest::~ApplicationRenderedUpdateRequest() {
}

inline ApplicationRenderedUpdateRequest& ApplicationRenderedUpdateRequest::operator = (const ApplicationRenderedUpdateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSurfaceid()) {
            setSurfaceid(rhs.getSurfaceid());
        } else {
            clearSurfaceid();
        }
    }
    return *this;
}

inline bool ApplicationRenderedUpdateRequest::operator == (const ApplicationRenderedUpdateRequest& rhs) const {
    return (((!hasSurfaceid() && !rhs.hasSurfaceid()) || getSurfaceid() == rhs.getSurfaceid()));
}

inline bool ApplicationRenderedUpdateRequest::operator != (const ApplicationRenderedUpdateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ApplicationRenderedUpdateRequest::operator < (const ApplicationRenderedUpdateRequest& rhs) const {
    if (hasSurfaceid() || rhs.hasSurfaceid()) {
        if (getSurfaceid() < rhs.getSurfaceid()) return true;
        if (getSurfaceid() > rhs.getSurfaceid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ApplicationRenderedUpdateRequest::clone() {
    return new ApplicationRenderedUpdateRequest(*this);
}

inline bool ApplicationRenderedUpdateRequest::operator > (const ApplicationRenderedUpdateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ApplicationRenderedUpdateRequest::clear() {
    clearSurfaceid();
}

inline void ApplicationRenderedUpdateRequest::clearSurfaceid() {
    if (hasSurfaceid()) {
         clear_has_surfaceid();
        _surfaceid = 0;
     }
}

inline bool ApplicationRenderedUpdateRequest::hasSurfaceid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 ApplicationRenderedUpdateRequest::getSurfaceid () const {
    return _surfaceid;
}

inline void ApplicationRenderedUpdateRequest::setSurfaceid (int32 surfaceid_) {
    set_has_surfaceid();
    this->_surfaceid = surfaceid_;
}

inline void ApplicationRenderedUpdateRequest::set_has_surfaceid () {
    _has_bits_[0] |= 1u << 0;
}

inline void ApplicationRenderedUpdateRequest::clear_has_surfaceid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ApplicationSwitchCompleteRequest::ApplicationSwitchCompleteRequest ()  :
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ApplicationSwitchCompleteRequest::ApplicationSwitchCompleteRequest (const ApplicationSwitchCompleteRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ApplicationSwitchCompleteRequest::ApplicationSwitchCompleteRequest (int32 surfaceid_, int32 surfaceState_)  :
    _surfaceid (surfaceid_),
    _surfaceState (surfaceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ApplicationSwitchCompleteRequest::~ApplicationSwitchCompleteRequest() {
}

inline ApplicationSwitchCompleteRequest& ApplicationSwitchCompleteRequest::operator = (const ApplicationSwitchCompleteRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSurfaceid()) {
            setSurfaceid(rhs.getSurfaceid());
        } else {
            clearSurfaceid();
        }
        if (rhs.hasSurfaceState()) {
            setSurfaceState(rhs.getSurfaceState());
        } else {
            clearSurfaceState();
        }
    }
    return *this;
}

inline bool ApplicationSwitchCompleteRequest::operator == (const ApplicationSwitchCompleteRequest& rhs) const {
    return (((!hasSurfaceid() && !rhs.hasSurfaceid()) || getSurfaceid() == rhs.getSurfaceid()) &&
        ((!hasSurfaceState() && !rhs.hasSurfaceState()) || getSurfaceState() == rhs.getSurfaceState()));
}

inline bool ApplicationSwitchCompleteRequest::operator != (const ApplicationSwitchCompleteRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ApplicationSwitchCompleteRequest::operator < (const ApplicationSwitchCompleteRequest& rhs) const {
    if (hasSurfaceid() || rhs.hasSurfaceid()) {
        if (getSurfaceid() < rhs.getSurfaceid()) return true;
        if (getSurfaceid() > rhs.getSurfaceid()) return false;
    }
    if (hasSurfaceState() || rhs.hasSurfaceState()) {
        if (getSurfaceState() < rhs.getSurfaceState()) return true;
        if (getSurfaceState() > rhs.getSurfaceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ApplicationSwitchCompleteRequest::clone() {
    return new ApplicationSwitchCompleteRequest(*this);
}

inline bool ApplicationSwitchCompleteRequest::operator > (const ApplicationSwitchCompleteRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ApplicationSwitchCompleteRequest::clear() {
    clearSurfaceid();
    clearSurfaceState();
}

inline void ApplicationSwitchCompleteRequest::clearSurfaceid() {
    if (hasSurfaceid()) {
         clear_has_surfaceid();
        _surfaceid = 0;
     }
}

inline bool ApplicationSwitchCompleteRequest::hasSurfaceid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 ApplicationSwitchCompleteRequest::getSurfaceid () const {
    return _surfaceid;
}

inline void ApplicationSwitchCompleteRequest::setSurfaceid (int32 surfaceid_) {
    set_has_surfaceid();
    this->_surfaceid = surfaceid_;
}

inline void ApplicationSwitchCompleteRequest::clearSurfaceState() {
    if (hasSurfaceState()) {
         clear_has_surfaceState();
        _surfaceState = 0;
     }
}

inline bool ApplicationSwitchCompleteRequest::hasSurfaceState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 ApplicationSwitchCompleteRequest::getSurfaceState () const {
    return _surfaceState;
}

inline void ApplicationSwitchCompleteRequest::setSurfaceState (int32 surfaceState_) {
    set_has_surfaceState();
    this->_surfaceState = surfaceState_;
}

inline void ApplicationSwitchCompleteRequest::set_has_surfaceid () {
    _has_bits_[0] |= 1u << 0;
}

inline void ApplicationSwitchCompleteRequest::clear_has_surfaceid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ApplicationSwitchCompleteRequest::set_has_surfaceState () {
    _has_bits_[0] |= 1u << 1;
}

inline void ApplicationSwitchCompleteRequest::clear_has_surfaceState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SubSurfaceSwitchCompleteRequest::SubSurfaceSwitchCompleteRequest ()  :
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubSurfaceSwitchCompleteRequest::SubSurfaceSwitchCompleteRequest (const SubSurfaceSwitchCompleteRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubSurfaceSwitchCompleteRequest::SubSurfaceSwitchCompleteRequest (int32 surfaceid_, int32 surfaceState_)  :
    _surfaceid (surfaceid_),
    _surfaceState (surfaceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubSurfaceSwitchCompleteRequest::~SubSurfaceSwitchCompleteRequest() {
}

inline SubSurfaceSwitchCompleteRequest& SubSurfaceSwitchCompleteRequest::operator = (const SubSurfaceSwitchCompleteRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSurfaceid()) {
            setSurfaceid(rhs.getSurfaceid());
        } else {
            clearSurfaceid();
        }
        if (rhs.hasSurfaceState()) {
            setSurfaceState(rhs.getSurfaceState());
        } else {
            clearSurfaceState();
        }
    }
    return *this;
}

inline bool SubSurfaceSwitchCompleteRequest::operator == (const SubSurfaceSwitchCompleteRequest& rhs) const {
    return (((!hasSurfaceid() && !rhs.hasSurfaceid()) || getSurfaceid() == rhs.getSurfaceid()) &&
        ((!hasSurfaceState() && !rhs.hasSurfaceState()) || getSurfaceState() == rhs.getSurfaceState()));
}

inline bool SubSurfaceSwitchCompleteRequest::operator != (const SubSurfaceSwitchCompleteRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SubSurfaceSwitchCompleteRequest::operator < (const SubSurfaceSwitchCompleteRequest& rhs) const {
    if (hasSurfaceid() || rhs.hasSurfaceid()) {
        if (getSurfaceid() < rhs.getSurfaceid()) return true;
        if (getSurfaceid() > rhs.getSurfaceid()) return false;
    }
    if (hasSurfaceState() || rhs.hasSurfaceState()) {
        if (getSurfaceState() < rhs.getSurfaceState()) return true;
        if (getSurfaceState() > rhs.getSurfaceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubSurfaceSwitchCompleteRequest::clone() {
    return new SubSurfaceSwitchCompleteRequest(*this);
}

inline bool SubSurfaceSwitchCompleteRequest::operator > (const SubSurfaceSwitchCompleteRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubSurfaceSwitchCompleteRequest::clear() {
    clearSurfaceid();
    clearSurfaceState();
}

inline void SubSurfaceSwitchCompleteRequest::clearSurfaceid() {
    if (hasSurfaceid()) {
         clear_has_surfaceid();
        _surfaceid = 0;
     }
}

inline bool SubSurfaceSwitchCompleteRequest::hasSurfaceid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SubSurfaceSwitchCompleteRequest::getSurfaceid () const {
    return _surfaceid;
}

inline void SubSurfaceSwitchCompleteRequest::setSurfaceid (int32 surfaceid_) {
    set_has_surfaceid();
    this->_surfaceid = surfaceid_;
}

inline void SubSurfaceSwitchCompleteRequest::clearSurfaceState() {
    if (hasSurfaceState()) {
         clear_has_surfaceState();
        _surfaceState = 0;
     }
}

inline bool SubSurfaceSwitchCompleteRequest::hasSurfaceState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SubSurfaceSwitchCompleteRequest::getSurfaceState () const {
    return _surfaceState;
}

inline void SubSurfaceSwitchCompleteRequest::setSurfaceState (int32 surfaceState_) {
    set_has_surfaceState();
    this->_surfaceState = surfaceState_;
}

inline void SubSurfaceSwitchCompleteRequest::set_has_surfaceid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubSurfaceSwitchCompleteRequest::clear_has_surfaceid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SubSurfaceSwitchCompleteRequest::set_has_surfaceState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SubSurfaceSwitchCompleteRequest::clear_has_surfaceState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FollowUpActionRequest::FollowUpActionRequest ()  :
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FollowUpActionRequest::FollowUpActionRequest (const FollowUpActionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FollowUpActionRequest::FollowUpActionRequest (followUpAction actionType_, uint32 userData_)  :
    _actionType (actionType_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FollowUpActionRequest::~FollowUpActionRequest() {
}

inline FollowUpActionRequest& FollowUpActionRequest::operator = (const FollowUpActionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActionType()) {
            setActionType(rhs.getActionType());
        } else {
            clearActionType();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool FollowUpActionRequest::operator == (const FollowUpActionRequest& rhs) const {
    return (((!hasActionType() && !rhs.hasActionType()) || getActionType() == rhs.getActionType()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool FollowUpActionRequest::operator != (const FollowUpActionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool FollowUpActionRequest::operator < (const FollowUpActionRequest& rhs) const {
    if (hasActionType() || rhs.hasActionType()) {
        if ((uint32)getActionType() < (uint32)rhs.getActionType()) return true;
        if ((uint32)getActionType() > (uint32)rhs.getActionType()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FollowUpActionRequest::clone() {
    return new FollowUpActionRequest(*this);
}

inline bool FollowUpActionRequest::operator > (const FollowUpActionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FollowUpActionRequest::clear() {
    clearActionType();
    clearUserData();
}

inline void FollowUpActionRequest::clearActionType() {
    if (hasActionType()) {
         clear_has_actionType();
        _actionType = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
     }
}

inline bool FollowUpActionRequest::hasActionType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline followUpAction FollowUpActionRequest::getActionType () const {
    return _actionType;
}

inline void FollowUpActionRequest::setActionType (followUpAction actionType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionRequest");
    }
    set_has_actionType();
    this->_actionType = actionType_;
}

inline void FollowUpActionRequest::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool FollowUpActionRequest::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FollowUpActionRequest::getUserData () const {
    return _userData;
}

inline void FollowUpActionRequest::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void FollowUpActionRequest::set_has_actionType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FollowUpActionRequest::clear_has_actionType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FollowUpActionRequest::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void FollowUpActionRequest::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ResponseFollowUpActionRequest::ResponseFollowUpActionRequest ()  :
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResponseFollowUpActionRequest::ResponseFollowUpActionRequest (const ResponseFollowUpActionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResponseFollowUpActionRequest::ResponseFollowUpActionRequest (followUpAction actionType_, uint32 userData_)  :
    _actionType (actionType_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "ResponseFollowUpActionRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResponseFollowUpActionRequest::~ResponseFollowUpActionRequest() {
}

inline ResponseFollowUpActionRequest& ResponseFollowUpActionRequest::operator = (const ResponseFollowUpActionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActionType()) {
            setActionType(rhs.getActionType());
        } else {
            clearActionType();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool ResponseFollowUpActionRequest::operator == (const ResponseFollowUpActionRequest& rhs) const {
    return (((!hasActionType() && !rhs.hasActionType()) || getActionType() == rhs.getActionType()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool ResponseFollowUpActionRequest::operator != (const ResponseFollowUpActionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ResponseFollowUpActionRequest::operator < (const ResponseFollowUpActionRequest& rhs) const {
    if (hasActionType() || rhs.hasActionType()) {
        if ((uint32)getActionType() < (uint32)rhs.getActionType()) return true;
        if ((uint32)getActionType() > (uint32)rhs.getActionType()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResponseFollowUpActionRequest::clone() {
    return new ResponseFollowUpActionRequest(*this);
}

inline bool ResponseFollowUpActionRequest::operator > (const ResponseFollowUpActionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResponseFollowUpActionRequest::clear() {
    clearActionType();
    clearUserData();
}

inline void ResponseFollowUpActionRequest::clearActionType() {
    if (hasActionType()) {
         clear_has_actionType();
        _actionType = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
     }
}

inline bool ResponseFollowUpActionRequest::hasActionType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline followUpAction ResponseFollowUpActionRequest::getActionType () const {
    return _actionType;
}

inline void ResponseFollowUpActionRequest::setActionType (followUpAction actionType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "ResponseFollowUpActionRequest");
    }
    set_has_actionType();
    this->_actionType = actionType_;
}

inline void ResponseFollowUpActionRequest::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool ResponseFollowUpActionRequest::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ResponseFollowUpActionRequest::getUserData () const {
    return _userData;
}

inline void ResponseFollowUpActionRequest::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void ResponseFollowUpActionRequest::set_has_actionType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResponseFollowUpActionRequest::clear_has_actionType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ResponseFollowUpActionRequest::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ResponseFollowUpActionRequest::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DrmBufferAllocationStatusRequest::DrmBufferAllocationStatusRequest ()  :
    _pid (0),
    _status (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus__DRM_BUFFER_ALLOCATION_FAILED),
    _bufferSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DrmBufferAllocationStatusRequest::DrmBufferAllocationStatusRequest (const DrmBufferAllocationStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pid (0),
    _status (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus__DRM_BUFFER_ALLOCATION_FAILED),
    _bufferSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DrmBufferAllocationStatusRequest::DrmBufferAllocationStatusRequest (int32 pid_, drmBufferAllocationStatus status_, uint32 bufferSize_)  :
    _pid (pid_),
    _status (status_),
    _bufferSize (bufferSize_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(drmBufferAllocationStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "drmBufferAllocationStatus", "status", "DrmBufferAllocationStatusRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DrmBufferAllocationStatusRequest::~DrmBufferAllocationStatusRequest() {
}

inline DrmBufferAllocationStatusRequest& DrmBufferAllocationStatusRequest::operator = (const DrmBufferAllocationStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPid()) {
            setPid(rhs.getPid());
        } else {
            clearPid();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasBufferSize()) {
            setBufferSize(rhs.getBufferSize());
        } else {
            clearBufferSize();
        }
    }
    return *this;
}

inline bool DrmBufferAllocationStatusRequest::operator == (const DrmBufferAllocationStatusRequest& rhs) const {
    return (((!hasPid() && !rhs.hasPid()) || getPid() == rhs.getPid()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasBufferSize() && !rhs.hasBufferSize()) || getBufferSize() == rhs.getBufferSize()));
}

inline bool DrmBufferAllocationStatusRequest::operator != (const DrmBufferAllocationStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DrmBufferAllocationStatusRequest::operator < (const DrmBufferAllocationStatusRequest& rhs) const {
    if (hasPid() || rhs.hasPid()) {
        if (getPid() < rhs.getPid()) return true;
        if (getPid() > rhs.getPid()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasBufferSize() || rhs.hasBufferSize()) {
        if (getBufferSize() < rhs.getBufferSize()) return true;
        if (getBufferSize() > rhs.getBufferSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DrmBufferAllocationStatusRequest::clone() {
    return new DrmBufferAllocationStatusRequest(*this);
}

inline bool DrmBufferAllocationStatusRequest::operator > (const DrmBufferAllocationStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DrmBufferAllocationStatusRequest::clear() {
    clearPid();
    clearStatus();
    clearBufferSize();
}

inline void DrmBufferAllocationStatusRequest::clearPid() {
    if (hasPid()) {
         clear_has_pid();
        _pid = 0;
     }
}

inline bool DrmBufferAllocationStatusRequest::hasPid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 DrmBufferAllocationStatusRequest::getPid () const {
    return _pid;
}

inline void DrmBufferAllocationStatusRequest::setPid (int32 pid_) {
    set_has_pid();
    this->_pid = pid_;
}

inline void DrmBufferAllocationStatusRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus__DRM_BUFFER_ALLOCATION_FAILED;
     }
}

inline bool DrmBufferAllocationStatusRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline drmBufferAllocationStatus DrmBufferAllocationStatusRequest::getStatus () const {
    return _status;
}

inline void DrmBufferAllocationStatusRequest::setStatus (drmBufferAllocationStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(drmBufferAllocationStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "drmBufferAllocationStatus", "status", "DrmBufferAllocationStatusRequest");
    }
    set_has_status();
    this->_status = status_;
}

inline void DrmBufferAllocationStatusRequest::clearBufferSize() {
    if (hasBufferSize()) {
         clear_has_bufferSize();
        _bufferSize = 0u;
     }
}

inline bool DrmBufferAllocationStatusRequest::hasBufferSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DrmBufferAllocationStatusRequest::getBufferSize () const {
    return _bufferSize;
}

inline void DrmBufferAllocationStatusRequest::setBufferSize (uint32 bufferSize_) {
    set_has_bufferSize();
    this->_bufferSize = bufferSize_;
}

inline void DrmBufferAllocationStatusRequest::set_has_pid () {
    _has_bits_[0] |= 1u << 0;
}

inline void DrmBufferAllocationStatusRequest::clear_has_pid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DrmBufferAllocationStatusRequest::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void DrmBufferAllocationStatusRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DrmBufferAllocationStatusRequest::set_has_bufferSize () {
    _has_bits_[0] |= 1u << 2;
}

inline void DrmBufferAllocationStatusRequest::clear_has_bufferSize () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ExternalImagesStatusUpdate::ExternalImagesStatusUpdate ()  :
    _ExternalImagesStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExternalImagesStatusUpdate::ExternalImagesStatusUpdate (const ExternalImagesStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ExternalImagesStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExternalImagesStatusUpdate::ExternalImagesStatusUpdate (const ::std::vector< ExternalImageData >& ExternalImagesStatus_)  :
    _ExternalImagesStatus (ExternalImagesStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExternalImagesStatusUpdate::~ExternalImagesStatusUpdate() {
}

inline ExternalImagesStatusUpdate& ExternalImagesStatusUpdate::operator = (const ExternalImagesStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasExternalImagesStatus()) {
            setExternalImagesStatus(rhs.getExternalImagesStatus());
        } else {
            clearExternalImagesStatus();
        }
    }
    return *this;
}

inline bool ExternalImagesStatusUpdate::operator == (const ExternalImagesStatusUpdate& rhs) const {
    return (((!hasExternalImagesStatus() && !rhs.hasExternalImagesStatus()) || getExternalImagesStatus() == rhs.getExternalImagesStatus()));
}

inline bool ExternalImagesStatusUpdate::operator != (const ExternalImagesStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ExternalImagesStatusUpdate::operator < (const ExternalImagesStatusUpdate& rhs) const {
    if (hasExternalImagesStatus() || rhs.hasExternalImagesStatus()) {
        if (getExternalImagesStatus() < rhs.getExternalImagesStatus()) return true;
        if (getExternalImagesStatus() > rhs.getExternalImagesStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExternalImagesStatusUpdate::clone() {
    return new ExternalImagesStatusUpdate(*this);
}

inline bool ExternalImagesStatusUpdate::operator > (const ExternalImagesStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExternalImagesStatusUpdate::clear() {
    clearExternalImagesStatus();
}

inline void ExternalImagesStatusUpdate::clearExternalImagesStatus() {
    if (hasExternalImagesStatus()) {
         clear_has_ExternalImagesStatus();
        _ExternalImagesStatus.clear();
     }
}

inline bool ExternalImagesStatusUpdate::hasExternalImagesStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ExternalImageData >& ExternalImagesStatusUpdate::getExternalImagesStatus () const {
    return _ExternalImagesStatus;
}

inline ::std::vector< ExternalImageData >& ExternalImagesStatusUpdate::getExternalImagesStatusMutable () {
    set_has_ExternalImagesStatus();
    return _ExternalImagesStatus;
}

inline void ExternalImagesStatusUpdate::setExternalImagesStatus (const ::std::vector< ExternalImageData >& ExternalImagesStatus_) {
    set_has_ExternalImagesStatus();
    this->_ExternalImagesStatus = ExternalImagesStatus_;
}

inline void ExternalImagesStatusUpdate::set_has_ExternalImagesStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExternalImagesStatusUpdate::clear_has_ExternalImagesStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ExternalImagesStatusRegister::ExternalImagesStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExternalImagesStatusRegister::ExternalImagesStatusRegister (const ExternalImagesStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExternalImagesStatusRegister::~ExternalImagesStatusRegister() {
}

inline ExternalImagesStatusRegister& ExternalImagesStatusRegister::operator = (const ExternalImagesStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ExternalImagesStatusRegister::operator == (const ExternalImagesStatusRegister& ) const {
    return true;
}

inline bool ExternalImagesStatusRegister::operator != (const ExternalImagesStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ExternalImagesStatusRegister::operator < (const ExternalImagesStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ExternalImagesStatusRegister::clone() {
    return new ExternalImagesStatusRegister(*this);
}

inline bool ExternalImagesStatusRegister::operator > (const ExternalImagesStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExternalImagesStatusRegister::clear() {
}

inline  ClientsUpdate::ClientsUpdate ()  :
    _Clients ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClientsUpdate::ClientsUpdate (const ClientsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Clients ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClientsUpdate::ClientsUpdate (const ::std::vector< ApplicationState >& Clients_)  :
    _Clients (Clients_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClientsUpdate::~ClientsUpdate() {
}

inline ClientsUpdate& ClientsUpdate::operator = (const ClientsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClients()) {
            setClients(rhs.getClients());
        } else {
            clearClients();
        }
    }
    return *this;
}

inline bool ClientsUpdate::operator == (const ClientsUpdate& rhs) const {
    return (((!hasClients() && !rhs.hasClients()) || getClients() == rhs.getClients()));
}

inline bool ClientsUpdate::operator != (const ClientsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ClientsUpdate::operator < (const ClientsUpdate& rhs) const {
    if (hasClients() || rhs.hasClients()) {
        if (getClients() < rhs.getClients()) return true;
        if (getClients() > rhs.getClients()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClientsUpdate::clone() {
    return new ClientsUpdate(*this);
}

inline bool ClientsUpdate::operator > (const ClientsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClientsUpdate::clear() {
    clearClients();
}

inline void ClientsUpdate::clearClients() {
    if (hasClients()) {
         clear_has_Clients();
        _Clients.clear();
     }
}

inline bool ClientsUpdate::hasClients () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ApplicationState >& ClientsUpdate::getClients () const {
    return _Clients;
}

inline ::std::vector< ApplicationState >& ClientsUpdate::getClientsMutable () {
    set_has_Clients();
    return _Clients;
}

inline void ClientsUpdate::setClients (const ::std::vector< ApplicationState >& Clients_) {
    set_has_Clients();
    this->_Clients = Clients_;
}

inline void ClientsUpdate::set_has_Clients () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClientsUpdate::clear_has_Clients () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClientsRegister::ClientsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClientsRegister::ClientsRegister (const ClientsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClientsRegister::~ClientsRegister() {
}

inline ClientsRegister& ClientsRegister::operator = (const ClientsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ClientsRegister::operator == (const ClientsRegister& ) const {
    return true;
}

inline bool ClientsRegister::operator != (const ClientsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ClientsRegister::operator < (const ClientsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ClientsRegister::clone() {
    return new ClientsRegister(*this);
}

inline bool ClientsRegister::operator > (const ClientsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClientsRegister::clear() {
}

inline  SubSurfaceSwitchUpdateSignal::SubSurfaceSwitchUpdateSignal ()  :
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubSurfaceSwitchUpdateSignal::SubSurfaceSwitchUpdateSignal (const SubSurfaceSwitchUpdateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _surfaceid (0),
    _surfaceState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubSurfaceSwitchUpdateSignal::SubSurfaceSwitchUpdateSignal (int32 surfaceid_, int32 surfaceState_)  :
    _surfaceid (surfaceid_),
    _surfaceState (surfaceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubSurfaceSwitchUpdateSignal::~SubSurfaceSwitchUpdateSignal() {
}

inline SubSurfaceSwitchUpdateSignal& SubSurfaceSwitchUpdateSignal::operator = (const SubSurfaceSwitchUpdateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSurfaceid()) {
            setSurfaceid(rhs.getSurfaceid());
        } else {
            clearSurfaceid();
        }
        if (rhs.hasSurfaceState()) {
            setSurfaceState(rhs.getSurfaceState());
        } else {
            clearSurfaceState();
        }
    }
    return *this;
}

inline bool SubSurfaceSwitchUpdateSignal::operator == (const SubSurfaceSwitchUpdateSignal& rhs) const {
    return (((!hasSurfaceid() && !rhs.hasSurfaceid()) || getSurfaceid() == rhs.getSurfaceid()) &&
        ((!hasSurfaceState() && !rhs.hasSurfaceState()) || getSurfaceState() == rhs.getSurfaceState()));
}

inline bool SubSurfaceSwitchUpdateSignal::operator != (const SubSurfaceSwitchUpdateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SubSurfaceSwitchUpdateSignal::operator < (const SubSurfaceSwitchUpdateSignal& rhs) const {
    if (hasSurfaceid() || rhs.hasSurfaceid()) {
        if (getSurfaceid() < rhs.getSurfaceid()) return true;
        if (getSurfaceid() > rhs.getSurfaceid()) return false;
    }
    if (hasSurfaceState() || rhs.hasSurfaceState()) {
        if (getSurfaceState() < rhs.getSurfaceState()) return true;
        if (getSurfaceState() > rhs.getSurfaceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubSurfaceSwitchUpdateSignal::clone() {
    return new SubSurfaceSwitchUpdateSignal(*this);
}

inline bool SubSurfaceSwitchUpdateSignal::operator > (const SubSurfaceSwitchUpdateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubSurfaceSwitchUpdateSignal::clear() {
    clearSurfaceid();
    clearSurfaceState();
}

inline void SubSurfaceSwitchUpdateSignal::clearSurfaceid() {
    if (hasSurfaceid()) {
         clear_has_surfaceid();
        _surfaceid = 0;
     }
}

inline bool SubSurfaceSwitchUpdateSignal::hasSurfaceid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SubSurfaceSwitchUpdateSignal::getSurfaceid () const {
    return _surfaceid;
}

inline void SubSurfaceSwitchUpdateSignal::setSurfaceid (int32 surfaceid_) {
    set_has_surfaceid();
    this->_surfaceid = surfaceid_;
}

inline void SubSurfaceSwitchUpdateSignal::clearSurfaceState() {
    if (hasSurfaceState()) {
         clear_has_surfaceState();
        _surfaceState = 0;
     }
}

inline bool SubSurfaceSwitchUpdateSignal::hasSurfaceState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SubSurfaceSwitchUpdateSignal::getSurfaceState () const {
    return _surfaceState;
}

inline void SubSurfaceSwitchUpdateSignal::setSurfaceState (int32 surfaceState_) {
    set_has_surfaceState();
    this->_surfaceState = surfaceState_;
}

inline void SubSurfaceSwitchUpdateSignal::set_has_surfaceid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubSurfaceSwitchUpdateSignal::clear_has_surfaceid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SubSurfaceSwitchUpdateSignal::set_has_surfaceState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SubSurfaceSwitchUpdateSignal::clear_has_surfaceState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  KeyInfoForwardingSignal::KeyInfoForwardingSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyInfoForwardingSignal::KeyInfoForwardingSignal (const KeyInfoForwardingSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyInfoForwardingSignal::KeyInfoForwardingSignal (const keyInfo& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyInfoForwardingSignal::~KeyInfoForwardingSignal() {
}

inline KeyInfoForwardingSignal& KeyInfoForwardingSignal::operator = (const KeyInfoForwardingSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool KeyInfoForwardingSignal::operator == (const KeyInfoForwardingSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool KeyInfoForwardingSignal::operator != (const KeyInfoForwardingSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyInfoForwardingSignal::operator < (const KeyInfoForwardingSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyInfoForwardingSignal::clone() {
    return new KeyInfoForwardingSignal(*this);
}

inline bool KeyInfoForwardingSignal::operator > (const KeyInfoForwardingSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyInfoForwardingSignal::clear() {
    clearData();
}

inline void KeyInfoForwardingSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool KeyInfoForwardingSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const keyInfo& KeyInfoForwardingSignal::getData () const {
    return _data;
}

inline keyInfo& KeyInfoForwardingSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void KeyInfoForwardingSignal::setData (const keyInfo& data_) {
    set_has_data();
    this->_data = data_;
}

inline void KeyInfoForwardingSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyInfoForwardingSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderInfoForwardingSignal::EncoderInfoForwardingSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderInfoForwardingSignal::EncoderInfoForwardingSignal (const EncoderInfoForwardingSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderInfoForwardingSignal::EncoderInfoForwardingSignal (const encoderInfo& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderInfoForwardingSignal::~EncoderInfoForwardingSignal() {
}

inline EncoderInfoForwardingSignal& EncoderInfoForwardingSignal::operator = (const EncoderInfoForwardingSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool EncoderInfoForwardingSignal::operator == (const EncoderInfoForwardingSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool EncoderInfoForwardingSignal::operator != (const EncoderInfoForwardingSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderInfoForwardingSignal::operator < (const EncoderInfoForwardingSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EncoderInfoForwardingSignal::clone() {
    return new EncoderInfoForwardingSignal(*this);
}

inline bool EncoderInfoForwardingSignal::operator > (const EncoderInfoForwardingSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderInfoForwardingSignal::clear() {
    clearData();
}

inline void EncoderInfoForwardingSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool EncoderInfoForwardingSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const encoderInfo& EncoderInfoForwardingSignal::getData () const {
    return _data;
}

inline encoderInfo& EncoderInfoForwardingSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void EncoderInfoForwardingSignal::setData (const encoderInfo& data_) {
    set_has_data();
    this->_data = data_;
}

inline void EncoderInfoForwardingSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderInfoForwardingSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDisplaySignal::SetDisplaySignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDisplaySignal::SetDisplaySignal (const SetDisplaySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDisplaySignal::SetDisplaySignal (const displayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDisplaySignal::~SetDisplaySignal() {
}

inline SetDisplaySignal& SetDisplaySignal::operator = (const SetDisplaySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SetDisplaySignal::operator == (const SetDisplaySignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SetDisplaySignal::operator != (const SetDisplaySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDisplaySignal::operator < (const SetDisplaySignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDisplaySignal::clone() {
    return new SetDisplaySignal(*this);
}

inline bool SetDisplaySignal::operator > (const SetDisplaySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDisplaySignal::clear() {
    clearData();
}

inline void SetDisplaySignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SetDisplaySignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const displayData& SetDisplaySignal::getData () const {
    return _data;
}

inline displayData& SetDisplaySignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SetDisplaySignal::setData (const displayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SetDisplaySignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDisplaySignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetMultiDisplaySignal::SetMultiDisplaySignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMultiDisplaySignal::SetMultiDisplaySignal (const SetMultiDisplaySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMultiDisplaySignal::SetMultiDisplaySignal (const MultidisplayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMultiDisplaySignal::~SetMultiDisplaySignal() {
}

inline SetMultiDisplaySignal& SetMultiDisplaySignal::operator = (const SetMultiDisplaySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SetMultiDisplaySignal::operator == (const SetMultiDisplaySignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SetMultiDisplaySignal::operator != (const SetMultiDisplaySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMultiDisplaySignal::operator < (const SetMultiDisplaySignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMultiDisplaySignal::clone() {
    return new SetMultiDisplaySignal(*this);
}

inline bool SetMultiDisplaySignal::operator > (const SetMultiDisplaySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMultiDisplaySignal::clear() {
    clearData();
}

inline void SetMultiDisplaySignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SetMultiDisplaySignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const MultidisplayData& SetMultiDisplaySignal::getData () const {
    return _data;
}

inline MultidisplayData& SetMultiDisplaySignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SetMultiDisplaySignal::setData (const MultidisplayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SetMultiDisplaySignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMultiDisplaySignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EvDisplayStatusEvalSignal::EvDisplayStatusEvalSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EvDisplayStatusEvalSignal::EvDisplayStatusEvalSignal (const EvDisplayStatusEvalSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EvDisplayStatusEvalSignal::EvDisplayStatusEvalSignal (const MultidisplayData& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EvDisplayStatusEvalSignal::~EvDisplayStatusEvalSignal() {
}

inline EvDisplayStatusEvalSignal& EvDisplayStatusEvalSignal::operator = (const EvDisplayStatusEvalSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool EvDisplayStatusEvalSignal::operator == (const EvDisplayStatusEvalSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool EvDisplayStatusEvalSignal::operator != (const EvDisplayStatusEvalSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EvDisplayStatusEvalSignal::operator < (const EvDisplayStatusEvalSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EvDisplayStatusEvalSignal::clone() {
    return new EvDisplayStatusEvalSignal(*this);
}

inline bool EvDisplayStatusEvalSignal::operator > (const EvDisplayStatusEvalSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EvDisplayStatusEvalSignal::clear() {
    clearData();
}

inline void EvDisplayStatusEvalSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool EvDisplayStatusEvalSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const MultidisplayData& EvDisplayStatusEvalSignal::getData () const {
    return _data;
}

inline MultidisplayData& EvDisplayStatusEvalSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void EvDisplayStatusEvalSignal::setData (const MultidisplayData& data_) {
    set_has_data();
    this->_data = data_;
}

inline void EvDisplayStatusEvalSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void EvDisplayStatusEvalSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActivateExternalImageProviderSignal::ActivateExternalImageProviderSignal ()  :
    _targetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceIds (),
    _consumerId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateExternalImageProviderSignal::ActivateExternalImageProviderSignal (const ActivateExternalImageProviderSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _targetState (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE),
    _instanceIds (),
    _consumerId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateExternalImageProviderSignal::ActivateExternalImageProviderSignal (gadgetStatus targetState_, const ::std::vector< int32 >& instanceIds_, int32 consumerId_)  :
    _targetState (targetState_),
    _instanceIds (instanceIds_),
    _consumerId (consumerId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(targetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetState_, "gadgetStatus", "targetState", "ActivateExternalImageProviderSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateExternalImageProviderSignal::~ActivateExternalImageProviderSignal() {
}

inline ActivateExternalImageProviderSignal& ActivateExternalImageProviderSignal::operator = (const ActivateExternalImageProviderSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetState()) {
            setTargetState(rhs.getTargetState());
        } else {
            clearTargetState();
        }
        if (rhs.hasInstanceIds()) {
            setInstanceIds(rhs.getInstanceIds());
        } else {
            clearInstanceIds();
        }
        if (rhs.hasConsumerId()) {
            setConsumerId(rhs.getConsumerId());
        } else {
            clearConsumerId();
        }
    }
    return *this;
}

inline bool ActivateExternalImageProviderSignal::operator == (const ActivateExternalImageProviderSignal& rhs) const {
    return (((!hasTargetState() && !rhs.hasTargetState()) || getTargetState() == rhs.getTargetState()) &&
        ((!hasInstanceIds() && !rhs.hasInstanceIds()) || getInstanceIds() == rhs.getInstanceIds()) &&
        ((!hasConsumerId() && !rhs.hasConsumerId()) || getConsumerId() == rhs.getConsumerId()));
}

inline bool ActivateExternalImageProviderSignal::operator != (const ActivateExternalImageProviderSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateExternalImageProviderSignal::operator < (const ActivateExternalImageProviderSignal& rhs) const {
    if (hasTargetState() || rhs.hasTargetState()) {
        if ((uint32)getTargetState() < (uint32)rhs.getTargetState()) return true;
        if ((uint32)getTargetState() > (uint32)rhs.getTargetState()) return false;
    }
    if (hasInstanceIds() || rhs.hasInstanceIds()) {
        if (getInstanceIds() < rhs.getInstanceIds()) return true;
        if (getInstanceIds() > rhs.getInstanceIds()) return false;
    }
    if (hasConsumerId() || rhs.hasConsumerId()) {
        if (getConsumerId() < rhs.getConsumerId()) return true;
        if (getConsumerId() > rhs.getConsumerId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateExternalImageProviderSignal::clone() {
    return new ActivateExternalImageProviderSignal(*this);
}

inline bool ActivateExternalImageProviderSignal::operator > (const ActivateExternalImageProviderSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateExternalImageProviderSignal::clear() {
    clearTargetState();
    clearInstanceIds();
    clearConsumerId();
}

inline void ActivateExternalImageProviderSignal::clearTargetState() {
    if (hasTargetState()) {
         clear_has_targetState();
        _targetState = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
     }
}

inline bool ActivateExternalImageProviderSignal::hasTargetState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline gadgetStatus ActivateExternalImageProviderSignal::getTargetState () const {
    return _targetState;
}

inline void ActivateExternalImageProviderSignal::setTargetState (gadgetStatus targetState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(gadgetStatus_IsValid(targetState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetState_, "gadgetStatus", "targetState", "ActivateExternalImageProviderSignal");
    }
    set_has_targetState();
    this->_targetState = targetState_;
}

inline void ActivateExternalImageProviderSignal::clearInstanceIds() {
    if (hasInstanceIds()) {
         clear_has_instanceIds();
        _instanceIds.clear();
     }
}

inline bool ActivateExternalImageProviderSignal::hasInstanceIds () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< int32 >& ActivateExternalImageProviderSignal::getInstanceIds () const {
    return _instanceIds;
}

inline ::std::vector< int32 >& ActivateExternalImageProviderSignal::getInstanceIdsMutable () {
    set_has_instanceIds();
    return _instanceIds;
}

inline void ActivateExternalImageProviderSignal::setInstanceIds (const ::std::vector< int32 >& instanceIds_) {
    set_has_instanceIds();
    this->_instanceIds = instanceIds_;
}

inline void ActivateExternalImageProviderSignal::clearConsumerId() {
    if (hasConsumerId()) {
         clear_has_consumerId();
        _consumerId = 0;
     }
}

inline bool ActivateExternalImageProviderSignal::hasConsumerId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 ActivateExternalImageProviderSignal::getConsumerId () const {
    return _consumerId;
}

inline void ActivateExternalImageProviderSignal::setConsumerId (int32 consumerId_) {
    set_has_consumerId();
    this->_consumerId = consumerId_;
}

inline void ActivateExternalImageProviderSignal::set_has_targetState () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateExternalImageProviderSignal::clear_has_targetState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActivateExternalImageProviderSignal::set_has_instanceIds () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActivateExternalImageProviderSignal::clear_has_instanceIds () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ActivateExternalImageProviderSignal::set_has_consumerId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ActivateExternalImageProviderSignal::clear_has_consumerId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ExternalImageProviderTouchSignal::ExternalImageProviderTouchSignal ()  :
    _pidSender (0u),
    _data (),
    _instanceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExternalImageProviderTouchSignal::ExternalImageProviderTouchSignal (const ExternalImageProviderTouchSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _data (),
    _instanceId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExternalImageProviderTouchSignal::ExternalImageProviderTouchSignal (uint32 pidSender_, const touchInfo& data_, int32 instanceId_)  :
    _pidSender (pidSender_),
    _data (data_),
    _instanceId (instanceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExternalImageProviderTouchSignal::~ExternalImageProviderTouchSignal() {
}

inline ExternalImageProviderTouchSignal& ExternalImageProviderTouchSignal::operator = (const ExternalImageProviderTouchSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
    }
    return *this;
}

inline bool ExternalImageProviderTouchSignal::operator == (const ExternalImageProviderTouchSignal& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()));
}

inline bool ExternalImageProviderTouchSignal::operator != (const ExternalImageProviderTouchSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ExternalImageProviderTouchSignal::operator < (const ExternalImageProviderTouchSignal& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExternalImageProviderTouchSignal::clone() {
    return new ExternalImageProviderTouchSignal(*this);
}

inline bool ExternalImageProviderTouchSignal::operator > (const ExternalImageProviderTouchSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExternalImageProviderTouchSignal::clear() {
    clearPidSender();
    clearData();
    clearInstanceId();
}

inline void ExternalImageProviderTouchSignal::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool ExternalImageProviderTouchSignal::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ExternalImageProviderTouchSignal::getPidSender () const {
    return _pidSender;
}

inline void ExternalImageProviderTouchSignal::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void ExternalImageProviderTouchSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool ExternalImageProviderTouchSignal::hasData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const touchInfo& ExternalImageProviderTouchSignal::getData () const {
    return _data;
}

inline touchInfo& ExternalImageProviderTouchSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void ExternalImageProviderTouchSignal::setData (const touchInfo& data_) {
    set_has_data();
    this->_data = data_;
}

inline void ExternalImageProviderTouchSignal::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0;
     }
}

inline bool ExternalImageProviderTouchSignal::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 ExternalImageProviderTouchSignal::getInstanceId () const {
    return _instanceId;
}

inline void ExternalImageProviderTouchSignal::setInstanceId (int32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void ExternalImageProviderTouchSignal::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExternalImageProviderTouchSignal::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ExternalImageProviderTouchSignal::set_has_data () {
    _has_bits_[0] |= 1u << 1;
}

inline void ExternalImageProviderTouchSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ExternalImageProviderTouchSignal::set_has_instanceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ExternalImageProviderTouchSignal::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SlaveSurfaceRepositioningSignal::SlaveSurfaceRepositioningSignal ()  :
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SlaveSurfaceRepositioningSignal::SlaveSurfaceRepositioningSignal (const SlaveSurfaceRepositioningSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SlaveSurfaceRepositioningSignal::SlaveSurfaceRepositioningSignal (uint32 pidSender_, bool activate_, uint32 surfaceId_)  :
    _pidSender (pidSender_),
    _activate (activate_),
    _surfaceId (surfaceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SlaveSurfaceRepositioningSignal::~SlaveSurfaceRepositioningSignal() {
}

inline SlaveSurfaceRepositioningSignal& SlaveSurfaceRepositioningSignal::operator = (const SlaveSurfaceRepositioningSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasActivate()) {
            setActivate(rhs.getActivate());
        } else {
            clearActivate();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
    }
    return *this;
}

inline bool SlaveSurfaceRepositioningSignal::operator == (const SlaveSurfaceRepositioningSignal& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasActivate() && !rhs.hasActivate()) || getActivate() == rhs.getActivate()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()));
}

inline bool SlaveSurfaceRepositioningSignal::operator != (const SlaveSurfaceRepositioningSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SlaveSurfaceRepositioningSignal::operator < (const SlaveSurfaceRepositioningSignal& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasActivate() || rhs.hasActivate()) {
        if (getActivate() < rhs.getActivate()) return true;
        if (getActivate() > rhs.getActivate()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SlaveSurfaceRepositioningSignal::clone() {
    return new SlaveSurfaceRepositioningSignal(*this);
}

inline bool SlaveSurfaceRepositioningSignal::operator > (const SlaveSurfaceRepositioningSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SlaveSurfaceRepositioningSignal::clear() {
    clearPidSender();
    clearActivate();
    clearSurfaceId();
}

inline void SlaveSurfaceRepositioningSignal::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool SlaveSurfaceRepositioningSignal::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SlaveSurfaceRepositioningSignal::getPidSender () const {
    return _pidSender;
}

inline void SlaveSurfaceRepositioningSignal::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void SlaveSurfaceRepositioningSignal::clearActivate() {
    if (hasActivate()) {
         clear_has_activate();
        _activate = false;
     }
}

inline bool SlaveSurfaceRepositioningSignal::hasActivate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SlaveSurfaceRepositioningSignal::getActivate () const {
    return _activate;
}

inline void SlaveSurfaceRepositioningSignal::setActivate (bool activate_) {
    set_has_activate();
    this->_activate = activate_;
}

inline void SlaveSurfaceRepositioningSignal::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool SlaveSurfaceRepositioningSignal::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SlaveSurfaceRepositioningSignal::getSurfaceId () const {
    return _surfaceId;
}

inline void SlaveSurfaceRepositioningSignal::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void SlaveSurfaceRepositioningSignal::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void SlaveSurfaceRepositioningSignal::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SlaveSurfaceRepositioningSignal::set_has_activate () {
    _has_bits_[0] |= 1u << 1;
}

inline void SlaveSurfaceRepositioningSignal::clear_has_activate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SlaveSurfaceRepositioningSignal::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SlaveSurfaceRepositioningSignal::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SlaveSurfaceRepositioningAckSignal::SlaveSurfaceRepositioningAckSignal ()  :
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SlaveSurfaceRepositioningAckSignal::SlaveSurfaceRepositioningAckSignal (const SlaveSurfaceRepositioningAckSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _activate (false),
    _surfaceId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SlaveSurfaceRepositioningAckSignal::SlaveSurfaceRepositioningAckSignal (uint32 pidSender_, bool activate_, uint32 surfaceId_, bool status_)  :
    _pidSender (pidSender_),
    _activate (activate_),
    _surfaceId (surfaceId_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SlaveSurfaceRepositioningAckSignal::~SlaveSurfaceRepositioningAckSignal() {
}

inline SlaveSurfaceRepositioningAckSignal& SlaveSurfaceRepositioningAckSignal::operator = (const SlaveSurfaceRepositioningAckSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasActivate()) {
            setActivate(rhs.getActivate());
        } else {
            clearActivate();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SlaveSurfaceRepositioningAckSignal::operator == (const SlaveSurfaceRepositioningAckSignal& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasActivate() && !rhs.hasActivate()) || getActivate() == rhs.getActivate()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SlaveSurfaceRepositioningAckSignal::operator != (const SlaveSurfaceRepositioningAckSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SlaveSurfaceRepositioningAckSignal::operator < (const SlaveSurfaceRepositioningAckSignal& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasActivate() || rhs.hasActivate()) {
        if (getActivate() < rhs.getActivate()) return true;
        if (getActivate() > rhs.getActivate()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SlaveSurfaceRepositioningAckSignal::clone() {
    return new SlaveSurfaceRepositioningAckSignal(*this);
}

inline bool SlaveSurfaceRepositioningAckSignal::operator > (const SlaveSurfaceRepositioningAckSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SlaveSurfaceRepositioningAckSignal::clear() {
    clearPidSender();
    clearActivate();
    clearSurfaceId();
    clearStatus();
}

inline void SlaveSurfaceRepositioningAckSignal::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool SlaveSurfaceRepositioningAckSignal::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SlaveSurfaceRepositioningAckSignal::getPidSender () const {
    return _pidSender;
}

inline void SlaveSurfaceRepositioningAckSignal::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void SlaveSurfaceRepositioningAckSignal::clearActivate() {
    if (hasActivate()) {
         clear_has_activate();
        _activate = false;
     }
}

inline bool SlaveSurfaceRepositioningAckSignal::hasActivate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SlaveSurfaceRepositioningAckSignal::getActivate () const {
    return _activate;
}

inline void SlaveSurfaceRepositioningAckSignal::setActivate (bool activate_) {
    set_has_activate();
    this->_activate = activate_;
}

inline void SlaveSurfaceRepositioningAckSignal::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool SlaveSurfaceRepositioningAckSignal::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SlaveSurfaceRepositioningAckSignal::getSurfaceId () const {
    return _surfaceId;
}

inline void SlaveSurfaceRepositioningAckSignal::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void SlaveSurfaceRepositioningAckSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool SlaveSurfaceRepositioningAckSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool SlaveSurfaceRepositioningAckSignal::getStatus () const {
    return _status;
}

inline void SlaveSurfaceRepositioningAckSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void SlaveSurfaceRepositioningAckSignal::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void SlaveSurfaceRepositioningAckSignal::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SlaveSurfaceRepositioningAckSignal::set_has_activate () {
    _has_bits_[0] |= 1u << 1;
}

inline void SlaveSurfaceRepositioningAckSignal::clear_has_activate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SlaveSurfaceRepositioningAckSignal::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SlaveSurfaceRepositioningAckSignal::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SlaveSurfaceRepositioningAckSignal::set_has_status () {
    _has_bits_[0] |= 1u << 3;
}

inline void SlaveSurfaceRepositioningAckSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DirectTextureConsumerPositionInfoRequestSignal::DirectTextureConsumerPositionInfoRequestSignal ()  :
    _pidSender (0u),
    _instanceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DirectTextureConsumerPositionInfoRequestSignal::DirectTextureConsumerPositionInfoRequestSignal (const DirectTextureConsumerPositionInfoRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _instanceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DirectTextureConsumerPositionInfoRequestSignal::DirectTextureConsumerPositionInfoRequestSignal (uint32 pidSender_, uint32 instanceId_)  :
    _pidSender (pidSender_),
    _instanceId (instanceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DirectTextureConsumerPositionInfoRequestSignal::~DirectTextureConsumerPositionInfoRequestSignal() {
}

inline DirectTextureConsumerPositionInfoRequestSignal& DirectTextureConsumerPositionInfoRequestSignal::operator = (const DirectTextureConsumerPositionInfoRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
    }
    return *this;
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::operator == (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()));
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::operator != (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::operator < (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DirectTextureConsumerPositionInfoRequestSignal::clone() {
    return new DirectTextureConsumerPositionInfoRequestSignal(*this);
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::operator > (const DirectTextureConsumerPositionInfoRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DirectTextureConsumerPositionInfoRequestSignal::clear() {
    clearPidSender();
    clearInstanceId();
}

inline void DirectTextureConsumerPositionInfoRequestSignal::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DirectTextureConsumerPositionInfoRequestSignal::getPidSender () const {
    return _pidSender;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0u;
     }
}

inline bool DirectTextureConsumerPositionInfoRequestSignal::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DirectTextureConsumerPositionInfoRequestSignal::getInstanceId () const {
    return _instanceId;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::setInstanceId (uint32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DirectTextureConsumerPositionInfoRequestSignal::set_has_instanceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void DirectTextureConsumerPositionInfoRequestSignal::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DirectTextureConsumerPositionInfoResponseSignal::DirectTextureConsumerPositionInfoResponseSignal ()  :
    _pidSender (0u),
    _instanceId (0u),
    _xPos (0.0f),
    _yPos (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DirectTextureConsumerPositionInfoResponseSignal::DirectTextureConsumerPositionInfoResponseSignal (const DirectTextureConsumerPositionInfoResponseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _pidSender (0u),
    _instanceId (0u),
    _xPos (0.0f),
    _yPos (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DirectTextureConsumerPositionInfoResponseSignal::DirectTextureConsumerPositionInfoResponseSignal (uint32 pidSender_, uint32 instanceId_, float xPos_, float yPos_)  :
    _pidSender (pidSender_),
    _instanceId (instanceId_),
    _xPos (xPos_),
    _yPos (yPos_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DirectTextureConsumerPositionInfoResponseSignal::~DirectTextureConsumerPositionInfoResponseSignal() {
}

inline DirectTextureConsumerPositionInfoResponseSignal& DirectTextureConsumerPositionInfoResponseSignal::operator = (const DirectTextureConsumerPositionInfoResponseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPidSender()) {
            setPidSender(rhs.getPidSender());
        } else {
            clearPidSender();
        }
        if (rhs.hasInstanceId()) {
            setInstanceId(rhs.getInstanceId());
        } else {
            clearInstanceId();
        }
        if (rhs.hasXPos()) {
            setXPos(rhs.getXPos());
        } else {
            clearXPos();
        }
        if (rhs.hasYPos()) {
            setYPos(rhs.getYPos());
        } else {
            clearYPos();
        }
    }
    return *this;
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::operator == (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const {
    return (((!hasPidSender() && !rhs.hasPidSender()) || getPidSender() == rhs.getPidSender()) &&
        ((!hasInstanceId() && !rhs.hasInstanceId()) || getInstanceId() == rhs.getInstanceId()) &&
        ((!hasXPos() && !rhs.hasXPos()) || getXPos() == rhs.getXPos()) &&
        ((!hasYPos() && !rhs.hasYPos()) || getYPos() == rhs.getYPos()));
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::operator != (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::operator < (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const {
    if (hasPidSender() || rhs.hasPidSender()) {
        if (getPidSender() < rhs.getPidSender()) return true;
        if (getPidSender() > rhs.getPidSender()) return false;
    }
    if (hasInstanceId() || rhs.hasInstanceId()) {
        if (getInstanceId() < rhs.getInstanceId()) return true;
        if (getInstanceId() > rhs.getInstanceId()) return false;
    }
    if (hasXPos() || rhs.hasXPos()) {
        if (getXPos() < rhs.getXPos()) return true;
        if (getXPos() > rhs.getXPos()) return false;
    }
    if (hasYPos() || rhs.hasYPos()) {
        if (getYPos() < rhs.getYPos()) return true;
        if (getYPos() > rhs.getYPos()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DirectTextureConsumerPositionInfoResponseSignal::clone() {
    return new DirectTextureConsumerPositionInfoResponseSignal(*this);
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::operator > (const DirectTextureConsumerPositionInfoResponseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clear() {
    clearPidSender();
    clearInstanceId();
    clearXPos();
    clearYPos();
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clearPidSender() {
    if (hasPidSender()) {
         clear_has_pidSender();
        _pidSender = 0u;
     }
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::hasPidSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DirectTextureConsumerPositionInfoResponseSignal::getPidSender () const {
    return _pidSender;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::setPidSender (uint32 pidSender_) {
    set_has_pidSender();
    this->_pidSender = pidSender_;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clearInstanceId() {
    if (hasInstanceId()) {
         clear_has_instanceId();
        _instanceId = 0u;
     }
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::hasInstanceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DirectTextureConsumerPositionInfoResponseSignal::getInstanceId () const {
    return _instanceId;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::setInstanceId (uint32 instanceId_) {
    set_has_instanceId();
    this->_instanceId = instanceId_;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clearXPos() {
    if (hasXPos()) {
         clear_has_xPos();
        _xPos = 0.0f;
     }
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::hasXPos () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float DirectTextureConsumerPositionInfoResponseSignal::getXPos () const {
    return _xPos;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::setXPos (float xPos_) {
    set_has_xPos();
    this->_xPos = xPos_;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clearYPos() {
    if (hasYPos()) {
         clear_has_yPos();
        _yPos = 0.0f;
     }
}

inline bool DirectTextureConsumerPositionInfoResponseSignal::hasYPos () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float DirectTextureConsumerPositionInfoResponseSignal::getYPos () const {
    return _yPos;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::setYPos (float yPos_) {
    set_has_yPos();
    this->_yPos = yPos_;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::set_has_pidSender () {
    _has_bits_[0] |= 1u << 0;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clear_has_pidSender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DirectTextureConsumerPositionInfoResponseSignal::set_has_instanceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clear_has_instanceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DirectTextureConsumerPositionInfoResponseSignal::set_has_xPos () {
    _has_bits_[0] |= 1u << 2;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clear_has_xPos () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DirectTextureConsumerPositionInfoResponseSignal::set_has_yPos () {
    _has_bits_[0] |= 1u << 3;
}

inline void DirectTextureConsumerPositionInfoResponseSignal::clear_has_yPos () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  FollowUpActionRequestSignal::FollowUpActionRequestSignal ()  :
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FollowUpActionRequestSignal::FollowUpActionRequestSignal (const FollowUpActionRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FollowUpActionRequestSignal::FollowUpActionRequestSignal (followUpAction actionType_, uint32 userData_)  :
    _actionType (actionType_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionRequestSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FollowUpActionRequestSignal::~FollowUpActionRequestSignal() {
}

inline FollowUpActionRequestSignal& FollowUpActionRequestSignal::operator = (const FollowUpActionRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActionType()) {
            setActionType(rhs.getActionType());
        } else {
            clearActionType();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool FollowUpActionRequestSignal::operator == (const FollowUpActionRequestSignal& rhs) const {
    return (((!hasActionType() && !rhs.hasActionType()) || getActionType() == rhs.getActionType()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool FollowUpActionRequestSignal::operator != (const FollowUpActionRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool FollowUpActionRequestSignal::operator < (const FollowUpActionRequestSignal& rhs) const {
    if (hasActionType() || rhs.hasActionType()) {
        if ((uint32)getActionType() < (uint32)rhs.getActionType()) return true;
        if ((uint32)getActionType() > (uint32)rhs.getActionType()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FollowUpActionRequestSignal::clone() {
    return new FollowUpActionRequestSignal(*this);
}

inline bool FollowUpActionRequestSignal::operator > (const FollowUpActionRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FollowUpActionRequestSignal::clear() {
    clearActionType();
    clearUserData();
}

inline void FollowUpActionRequestSignal::clearActionType() {
    if (hasActionType()) {
         clear_has_actionType();
        _actionType = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
     }
}

inline bool FollowUpActionRequestSignal::hasActionType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline followUpAction FollowUpActionRequestSignal::getActionType () const {
    return _actionType;
}

inline void FollowUpActionRequestSignal::setActionType (followUpAction actionType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionRequestSignal");
    }
    set_has_actionType();
    this->_actionType = actionType_;
}

inline void FollowUpActionRequestSignal::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool FollowUpActionRequestSignal::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FollowUpActionRequestSignal::getUserData () const {
    return _userData;
}

inline void FollowUpActionRequestSignal::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void FollowUpActionRequestSignal::set_has_actionType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FollowUpActionRequestSignal::clear_has_actionType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FollowUpActionRequestSignal::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void FollowUpActionRequestSignal::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FollowUpActionResponseSignal::FollowUpActionResponseSignal ()  :
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FollowUpActionResponseSignal::FollowUpActionResponseSignal (const FollowUpActionResponseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _actionType (::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FollowUpActionResponseSignal::FollowUpActionResponseSignal (followUpAction actionType_, uint32 userData_)  :
    _actionType (actionType_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionResponseSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FollowUpActionResponseSignal::~FollowUpActionResponseSignal() {
}

inline FollowUpActionResponseSignal& FollowUpActionResponseSignal::operator = (const FollowUpActionResponseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActionType()) {
            setActionType(rhs.getActionType());
        } else {
            clearActionType();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool FollowUpActionResponseSignal::operator == (const FollowUpActionResponseSignal& rhs) const {
    return (((!hasActionType() && !rhs.hasActionType()) || getActionType() == rhs.getActionType()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool FollowUpActionResponseSignal::operator != (const FollowUpActionResponseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool FollowUpActionResponseSignal::operator < (const FollowUpActionResponseSignal& rhs) const {
    if (hasActionType() || rhs.hasActionType()) {
        if ((uint32)getActionType() < (uint32)rhs.getActionType()) return true;
        if ((uint32)getActionType() > (uint32)rhs.getActionType()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FollowUpActionResponseSignal::clone() {
    return new FollowUpActionResponseSignal(*this);
}

inline bool FollowUpActionResponseSignal::operator > (const FollowUpActionResponseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FollowUpActionResponseSignal::clear() {
    clearActionType();
    clearUserData();
}

inline void FollowUpActionResponseSignal::clearActionType() {
    if (hasActionType()) {
         clear_has_actionType();
        _actionType = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
     }
}

inline bool FollowUpActionResponseSignal::hasActionType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline followUpAction FollowUpActionResponseSignal::getActionType () const {
    return _actionType;
}

inline void FollowUpActionResponseSignal::setActionType (followUpAction actionType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(followUpAction_IsValid(actionType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", actionType_, "followUpAction", "actionType", "FollowUpActionResponseSignal");
    }
    set_has_actionType();
    this->_actionType = actionType_;
}

inline void FollowUpActionResponseSignal::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool FollowUpActionResponseSignal::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FollowUpActionResponseSignal::getUserData () const {
    return _userData;
}

inline void FollowUpActionResponseSignal::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void FollowUpActionResponseSignal::set_has_actionType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FollowUpActionResponseSignal::clear_has_actionType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FollowUpActionResponseSignal::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void FollowUpActionResponseSignal::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRL_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
